// ui/base/accelerators/mojom/accelerator.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_SHARED_H_
#define UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared.h"




#include "ui/base/accelerators/mojom/accelerator.mojom-data-view.h"




namespace std {

template <>
struct hash<::ui::mojom::AcceleratorKeyState>
    : public mojo::internal::EnumHashImpl<::ui::mojom::AcceleratorKeyState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::AcceleratorKeyState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ui::mojom::AcceleratorKeyState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ui::mojom::AcceleratorKeyState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::AcceleratorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::AcceleratorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::Accelerator_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->key_code = Traits::key_code(input);

    
    mojo::internal::Serialize<::ui::mojom::AcceleratorKeyState>(
      Traits::key_state(input),
      &fragment->key_state);

    fragment->modifiers = Traits::modifiers(input);

    decltype(Traits::time_stamp(input)) in_time_stamp = Traits::time_stamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_stamp)::BaseType> time_stamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_time_stamp,
      time_stamp_fragment);

    fragment->time_stamp.Set(
        time_stamp_fragment.is_null() ? nullptr : time_stamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->time_stamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_stamp in Accelerator struct");
  }

  static bool Deserialize(::ui::mojom::internal::Accelerator_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::AcceleratorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {

inline void AcceleratorDataView::GetTimeStampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->time_stamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::ui::mojom::AcceleratorKeyState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ui::mojom::AcceleratorKeyState value);
};

} // namespace perfetto

#endif  // UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_SHARED_H_