// ui/accessibility/mojom/ax_tree_update.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_data.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_checks.mojom-shared.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXTreeUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXTreeUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->has_tree_data = Traits::has_tree_data(input);

      decltype(Traits::tree_data(input)) in_tree_data = Traits::tree_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tree_data)::BaseType> tree_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ax::mojom::AXTreeDataDataView, send_validation>(
        in_tree_data,
        tree_data_fragment);

      fragment->tree_data.Set(
          tree_data_fragment.is_null() ? nullptr : tree_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tree_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tree_data in AXTreeUpdate struct");

      fragment->node_id_to_clear = Traits::node_id_to_clear(input);

      fragment->root_id = Traits::root_id(input);

      decltype(Traits::nodes(input)) in_nodes = Traits::nodes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nodes)::BaseType>
          nodes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& nodes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXNodeDataDataView>, send_validation>(
        in_nodes,
        nodes_fragment,
        &nodes_validate_params);

      fragment->nodes.Set(
          nodes_fragment.is_null() ? nullptr : nodes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->nodes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nodes in AXTreeUpdate struct");

      
      mojo::internal::Serialize<::ax::mojom::EventFrom>(
        Traits::event_from(input),
        &fragment->event_from);

      
      mojo::internal::Serialize<::ax::mojom::Action>(
        Traits::event_from_action(input),
        &fragment->event_from_action);

      decltype(Traits::event_intents(input)) in_event_intents = Traits::event_intents(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_intents)::BaseType>
          event_intents_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& event_intents_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>, send_validation>(
        in_event_intents,
        event_intents_fragment,
        &event_intents_validate_params);

      fragment->event_intents.Set(
          event_intents_fragment.is_null() ? nullptr : event_intents_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_intents.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_intents in AXTreeUpdate struct");

      decltype(Traits::tree_checks(input)) in_tree_checks = Traits::tree_checks(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tree_checks)::BaseType> tree_checks_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ax::mojom::AXTreeChecksDataView, send_validation>(
        in_tree_checks,
        tree_checks_fragment);

      fragment->tree_checks.Set(
          tree_checks_fragment.is_null() ? nullptr : tree_checks_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_SEND_VALIDATION_H_