// ui/accessibility/mojom/ax_tree_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_id.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_id.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_tree_id_mojom_traits.h"




namespace ax::mojom {





class  AXTreeID {
 public:
  using DataView = AXTreeIDDataView;
  using Data_ = internal::AXTreeID_Data;
  using Tag = Data_::AXTreeID_Tag;

  template <typename... Args>
  static AXTreeIDPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |unknown|.
  static AXTreeIDPtr NewUnknown(
      uint8_t value);
  // Construct an instance holding |token|.
  static AXTreeIDPtr NewToken(
      const ::base::UnguessableToken& value);

  template <typename U>
  static AXTreeIDPtr From(const U& u) {
    return mojo::TypeConverter<AXTreeIDPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXTreeID>::Convert(*this);
  }
  ~AXTreeID();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AXTreeID(const AXTreeID& other) = delete;
  AXTreeID& operator=(const AXTreeID& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AXTreeIDPtr>
  AXTreeIDPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AXTreeID>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AXTreeID>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_unknown() const { return tag_ == Tag::kUnknown; }
  uint8_t get_unknown() const {
    CHECK(tag_ == Tag::kUnknown);
    return data_.unknown;
  }
  void set_unknown(uint8_t unknown);

  bool is_token() const { return tag_ == Tag::kToken; }
  const ::base::UnguessableToken& get_token() const {
    CHECK(tag_ == Tag::kToken);
    return data_.token;
  }
  ::base::UnguessableToken& get_token() {
    CHECK(tag_ == Tag::kToken);
    return data_.token;
  }
  void set_token(const ::base::UnguessableToken& token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXTreeID::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AXTreeID::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
        uint8_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
        const ::base::UnguessableToken& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint8_t unknown;
    ::base::UnguessableToken token;
  };

  AXTreeID(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
      uint8_t value);
  AXTreeID(
      std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
      const ::base::UnguessableToken& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
AXTreeIDPtr AXTreeID::Clone() const {
  switch (tag_) {
    case Tag::kUnknown:
      return NewUnknown(
          mojo::Clone(data_.unknown));
    case Tag::kToken:
      return NewToken(
          mojo::Clone(data_.token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AXTreeID>::value>::type*>
bool AXTreeID::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kUnknown:
      return mojo::Equals(data_.unknown, other.data_.unknown);
    case Tag::kToken:
      return mojo::Equals(data_.token, other.data_.token);
  }

  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  UnionTraits<::ax::mojom::AXTreeID::DataView,
                                        ::ax::mojom::AXTreeIDPtr> {
  static bool IsNull(const ::ax::mojom::AXTreeIDPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::AXTreeIDPtr* output) { output->reset(); }

  static ::ax::mojom::AXTreeID::Tag GetTag(const ::ax::mojom::AXTreeIDPtr& input) {
    return input->which();
  }

  static  uint8_t unknown(const ::ax::mojom::AXTreeIDPtr& input) {
    return input->get_unknown();
  }

  static const ::base::UnguessableToken& token(const ::ax::mojom::AXTreeIDPtr& input) {
    return input->get_token();
  }

  static bool Read(::ax::mojom::AXTreeID::DataView input, ::ax::mojom::AXTreeIDPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_H_