// ui/accessibility/mojom/ax_tree_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_data.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_data.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_data.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_tree_data_mojom_traits.h"




namespace ax::mojom {








class  AXTreeData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXTreeData, T>::value>;
  using DataView = AXTreeDataDataView;
  using Data_ = internal::AXTreeData_Data;

  template <typename... Args>
  static AXTreeDataPtr New(Args&&... args) {
    return AXTreeDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXTreeDataPtr From(const U& u) {
    return mojo::TypeConverter<AXTreeDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXTreeData>::Convert(*this);
  }


  AXTreeData();

  AXTreeData(
      const ::ui::AXTreeID& tree_id,
      const ::ui::AXTreeID& parent_tree_id,
      const ::ui::AXTreeID& focused_tree_id,
      const std::string& doctype,
      bool loaded,
      float loading_progress,
      const std::string& mimetype,
      const std::string& title,
      const std::string& url,
      int32_t focus_id,
      bool sel_is_backward,
      int32_t sel_anchor_object_id,
      int32_t sel_anchor_offset,
      ::ax::mojom::TextAffinity sel_anchor_affinity,
      int32_t sel_focus_object_id,
      int32_t sel_focus_offset,
      ::ax::mojom::TextAffinity sel_focus_affinity,
      int32_t root_scroller_id,
      std::optional<std::vector<std::string>> metadata);


  ~AXTreeData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXTreeDataPtr>
  AXTreeDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXTreeData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXTreeData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXTreeData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXTreeData_UnserializedMessageContext<
            UserType, AXTreeData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXTreeData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXTreeData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXTreeData_UnserializedMessageContext<
            UserType, AXTreeData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXTreeData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::AXTreeID tree_id;
  
  ::ui::AXTreeID parent_tree_id;
  
  ::ui::AXTreeID focused_tree_id;
  
  std::string doctype;
  
  bool loaded;
  
  float loading_progress;
  
  std::string mimetype;
  
  std::string title;
  
  std::string url;
  
  int32_t focus_id;
  
  bool sel_is_backward;
  
  int32_t sel_anchor_object_id;
  
  int32_t sel_anchor_offset;
  
  ::ax::mojom::TextAffinity sel_anchor_affinity;
  
  int32_t sel_focus_object_id;
  
  int32_t sel_focus_offset;
  
  ::ax::mojom::TextAffinity sel_focus_affinity;
  
  int32_t root_scroller_id;
  
  std::optional<std::vector<std::string>> metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXTreeData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXTreeDataPtr AXTreeData::Clone() const {
  return New(
      mojo::Clone(tree_id),
      mojo::Clone(parent_tree_id),
      mojo::Clone(focused_tree_id),
      mojo::Clone(doctype),
      mojo::Clone(loaded),
      mojo::Clone(loading_progress),
      mojo::Clone(mimetype),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(focus_id),
      mojo::Clone(sel_is_backward),
      mojo::Clone(sel_anchor_object_id),
      mojo::Clone(sel_anchor_offset),
      mojo::Clone(sel_anchor_affinity),
      mojo::Clone(sel_focus_object_id),
      mojo::Clone(sel_focus_offset),
      mojo::Clone(sel_focus_affinity),
      mojo::Clone(root_scroller_id),
      mojo::Clone(metadata)
  );
}

template <typename T, AXTreeData::EnableIfSame<T>*>
bool AXTreeData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tree_id, other_struct.tree_id))
    return false;
  if (!mojo::Equals(this->parent_tree_id, other_struct.parent_tree_id))
    return false;
  if (!mojo::Equals(this->focused_tree_id, other_struct.focused_tree_id))
    return false;
  if (!mojo::Equals(this->doctype, other_struct.doctype))
    return false;
  if (!mojo::Equals(this->loaded, other_struct.loaded))
    return false;
  if (!mojo::Equals(this->loading_progress, other_struct.loading_progress))
    return false;
  if (!mojo::Equals(this->mimetype, other_struct.mimetype))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->focus_id, other_struct.focus_id))
    return false;
  if (!mojo::Equals(this->sel_is_backward, other_struct.sel_is_backward))
    return false;
  if (!mojo::Equals(this->sel_anchor_object_id, other_struct.sel_anchor_object_id))
    return false;
  if (!mojo::Equals(this->sel_anchor_offset, other_struct.sel_anchor_offset))
    return false;
  if (!mojo::Equals(this->sel_anchor_affinity, other_struct.sel_anchor_affinity))
    return false;
  if (!mojo::Equals(this->sel_focus_object_id, other_struct.sel_focus_object_id))
    return false;
  if (!mojo::Equals(this->sel_focus_offset, other_struct.sel_focus_offset))
    return false;
  if (!mojo::Equals(this->sel_focus_affinity, other_struct.sel_focus_affinity))
    return false;
  if (!mojo::Equals(this->root_scroller_id, other_struct.root_scroller_id))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  return true;
}

template <typename T, AXTreeData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tree_id < rhs.tree_id)
    return true;
  if (rhs.tree_id < lhs.tree_id)
    return false;
  if (lhs.parent_tree_id < rhs.parent_tree_id)
    return true;
  if (rhs.parent_tree_id < lhs.parent_tree_id)
    return false;
  if (lhs.focused_tree_id < rhs.focused_tree_id)
    return true;
  if (rhs.focused_tree_id < lhs.focused_tree_id)
    return false;
  if (lhs.doctype < rhs.doctype)
    return true;
  if (rhs.doctype < lhs.doctype)
    return false;
  if (lhs.loaded < rhs.loaded)
    return true;
  if (rhs.loaded < lhs.loaded)
    return false;
  if (lhs.loading_progress < rhs.loading_progress)
    return true;
  if (rhs.loading_progress < lhs.loading_progress)
    return false;
  if (lhs.mimetype < rhs.mimetype)
    return true;
  if (rhs.mimetype < lhs.mimetype)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.focus_id < rhs.focus_id)
    return true;
  if (rhs.focus_id < lhs.focus_id)
    return false;
  if (lhs.sel_is_backward < rhs.sel_is_backward)
    return true;
  if (rhs.sel_is_backward < lhs.sel_is_backward)
    return false;
  if (lhs.sel_anchor_object_id < rhs.sel_anchor_object_id)
    return true;
  if (rhs.sel_anchor_object_id < lhs.sel_anchor_object_id)
    return false;
  if (lhs.sel_anchor_offset < rhs.sel_anchor_offset)
    return true;
  if (rhs.sel_anchor_offset < lhs.sel_anchor_offset)
    return false;
  if (lhs.sel_anchor_affinity < rhs.sel_anchor_affinity)
    return true;
  if (rhs.sel_anchor_affinity < lhs.sel_anchor_affinity)
    return false;
  if (lhs.sel_focus_object_id < rhs.sel_focus_object_id)
    return true;
  if (rhs.sel_focus_object_id < lhs.sel_focus_object_id)
    return false;
  if (lhs.sel_focus_offset < rhs.sel_focus_offset)
    return true;
  if (rhs.sel_focus_offset < lhs.sel_focus_offset)
    return false;
  if (lhs.sel_focus_affinity < rhs.sel_focus_affinity)
    return true;
  if (rhs.sel_focus_affinity < lhs.sel_focus_affinity)
    return false;
  if (lhs.root_scroller_id < rhs.root_scroller_id)
    return true;
  if (rhs.root_scroller_id < lhs.root_scroller_id)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::AXTreeData::DataView,
                                         ::ax::mojom::AXTreeDataPtr> {
  static bool IsNull(const ::ax::mojom::AXTreeDataPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::AXTreeDataPtr* output) { output->reset(); }

  static const decltype(::ax::mojom::AXTreeData::tree_id)& tree_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->tree_id;
  }

  static const decltype(::ax::mojom::AXTreeData::parent_tree_id)& parent_tree_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->parent_tree_id;
  }

  static const decltype(::ax::mojom::AXTreeData::focused_tree_id)& focused_tree_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->focused_tree_id;
  }

  static const decltype(::ax::mojom::AXTreeData::doctype)& doctype(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->doctype;
  }

  static decltype(::ax::mojom::AXTreeData::loaded) loaded(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->loaded;
  }

  static decltype(::ax::mojom::AXTreeData::loading_progress) loading_progress(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->loading_progress;
  }

  static const decltype(::ax::mojom::AXTreeData::mimetype)& mimetype(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->mimetype;
  }

  static const decltype(::ax::mojom::AXTreeData::title)& title(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->title;
  }

  static const decltype(::ax::mojom::AXTreeData::url)& url(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->url;
  }

  static decltype(::ax::mojom::AXTreeData::focus_id) focus_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->focus_id;
  }

  static decltype(::ax::mojom::AXTreeData::sel_is_backward) sel_is_backward(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_is_backward;
  }

  static decltype(::ax::mojom::AXTreeData::sel_anchor_object_id) sel_anchor_object_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_anchor_object_id;
  }

  static decltype(::ax::mojom::AXTreeData::sel_anchor_offset) sel_anchor_offset(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_anchor_offset;
  }

  static decltype(::ax::mojom::AXTreeData::sel_anchor_affinity) sel_anchor_affinity(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_anchor_affinity;
  }

  static decltype(::ax::mojom::AXTreeData::sel_focus_object_id) sel_focus_object_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_focus_object_id;
  }

  static decltype(::ax::mojom::AXTreeData::sel_focus_offset) sel_focus_offset(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_focus_offset;
  }

  static decltype(::ax::mojom::AXTreeData::sel_focus_affinity) sel_focus_affinity(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->sel_focus_affinity;
  }

  static decltype(::ax::mojom::AXTreeData::root_scroller_id) root_scroller_id(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->root_scroller_id;
  }

  static const decltype(::ax::mojom::AXTreeData::metadata)& metadata(
      const ::ax::mojom::AXTreeDataPtr& input) {
    return input->metadata;
  }

  static bool Read(::ax::mojom::AXTreeData::DataView input, ::ax::mojom::AXTreeDataPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_H_