// ui/accessibility/mojom/ax_tree_data.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_tree_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"

#include "ui/accessibility/mojom/ax_tree_data.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXTreeDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXTreeDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXTreeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tree_id(input)) in_tree_id = Traits::tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->tree_id)>
          tree_id_fragment(fragment.message());
      tree_id_fragment.Claim(&fragment->tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_tree_id,
        tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tree_id in AXTreeData struct");

      decltype(Traits::parent_tree_id(input)) in_parent_tree_id = Traits::parent_tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->parent_tree_id)>
          parent_tree_id_fragment(fragment.message());
      parent_tree_id_fragment.Claim(&fragment->parent_tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_parent_tree_id,
        parent_tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parent_tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parent_tree_id in AXTreeData struct");

      decltype(Traits::focused_tree_id(input)) in_focused_tree_id = Traits::focused_tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->focused_tree_id)>
          focused_tree_id_fragment(fragment.message());
      focused_tree_id_fragment.Claim(&fragment->focused_tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_focused_tree_id,
        focused_tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->focused_tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null focused_tree_id in AXTreeData struct");

      decltype(Traits::doctype(input)) in_doctype = Traits::doctype(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->doctype)::BaseType> doctype_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_doctype,
        doctype_fragment);

      fragment->doctype.Set(
          doctype_fragment.is_null() ? nullptr : doctype_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->doctype.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null doctype in AXTreeData struct");

      fragment->loaded = Traits::loaded(input);

      fragment->loading_progress = Traits::loading_progress(input);

      decltype(Traits::mimetype(input)) in_mimetype = Traits::mimetype(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mimetype)::BaseType> mimetype_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mimetype,
        mimetype_fragment);

      fragment->mimetype.Set(
          mimetype_fragment.is_null() ? nullptr : mimetype_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mimetype.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mimetype in AXTreeData struct");

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in AXTreeData struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in AXTreeData struct");

      fragment->focus_id = Traits::focus_id(input);

      fragment->sel_is_backward = Traits::sel_is_backward(input);

      fragment->sel_anchor_object_id = Traits::sel_anchor_object_id(input);

      fragment->sel_anchor_offset = Traits::sel_anchor_offset(input);

      
      mojo::internal::Serialize<::ax::mojom::TextAffinity>(
        Traits::sel_anchor_affinity(input),
        &fragment->sel_anchor_affinity);

      fragment->sel_focus_object_id = Traits::sel_focus_object_id(input);

      fragment->sel_focus_offset = Traits::sel_focus_offset(input);

      
      mojo::internal::Serialize<::ax::mojom::TextAffinity>(
        Traits::sel_focus_affinity(input),
        &fragment->sel_focus_affinity);

      fragment->root_scroller_id = Traits::root_scroller_id(input);

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType>
          metadata_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& metadata_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_metadata,
        metadata_fragment,
        &metadata_validate_params);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SEND_VALIDATION_H_