// ui/accessibility/mojom/ax_tree_checks.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_CHECKS_MOJOM_BLINK_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_CHECKS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_checks.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_checks.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_checks.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ax::mojom::blink {





class  AXTreeChecks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXTreeChecks, T>::value>;
  using DataView = AXTreeChecksDataView;
  using Data_ = internal::AXTreeChecks_Data;

  template <typename... Args>
  static AXTreeChecksPtr New(Args&&... args) {
    return AXTreeChecksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXTreeChecksPtr From(const U& u) {
    return mojo::TypeConverter<AXTreeChecksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXTreeChecks>::Convert(*this);
  }


  AXTreeChecks();

  explicit AXTreeChecks(
      uint64_t node_count);


  ~AXTreeChecks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXTreeChecksPtr>
  AXTreeChecksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXTreeChecks::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXTreeChecks::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXTreeChecks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXTreeChecks_UnserializedMessageContext<
            UserType, AXTreeChecks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXTreeChecks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXTreeChecks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXTreeChecks_UnserializedMessageContext<
            UserType, AXTreeChecks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXTreeChecks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t node_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXTreeChecks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
AXTreeChecksPtr AXTreeChecks::Clone() const {
  return New(
      mojo::Clone(node_count)
  );
}

template <typename T, AXTreeChecks::EnableIfSame<T>*>
bool AXTreeChecks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_count, other_struct.node_count))
    return false;
  return true;
}

template <typename T, AXTreeChecks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_count < rhs.node_count)
    return true;
  if (rhs.node_count < lhs.node_count)
    return false;
  return false;
}


}  // ax::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::blink::AXTreeChecks::DataView,
                                         ::ax::mojom::blink::AXTreeChecksPtr> {
  static bool IsNull(const ::ax::mojom::blink::AXTreeChecksPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXTreeChecksPtr* output) { output->reset(); }

  static decltype(::ax::mojom::blink::AXTreeChecks::node_count) node_count(
      const ::ax::mojom::blink::AXTreeChecksPtr& input) {
    return input->node_count;
  }

  static bool Read(::ax::mojom::blink::AXTreeChecks::DataView input, ::ax::mojom::blink::AXTreeChecksPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_CHECKS_MOJOM_BLINK_H_