// ui/accessibility/mojom/ax_event_intent.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_event_intent.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_enums$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/ax_enums.mojom', '../ax_enums.mojom.js');
  }



  function EventIntent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventIntent.prototype.initDefaults_ = function() {
    this.command = 0;
    this.inputEventType = 0;
    this.textBoundary = 0;
    this.moveDirection = 0;
  };
  EventIntent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventIntent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventIntent.command
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ax_enums$.Command);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventIntent.inputEventType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ax_enums$.InputEventType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventIntent.textBoundary
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ax_enums$.TextBoundary);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventIntent.moveDirection
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ax_enums$.MoveDirection);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventIntent.encodedSize = codec.kStructHeaderSize + 16;

  EventIntent.decode = function(decoder) {
    var packed;
    var val = new EventIntent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.command =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Command));
    val.inputEventType =
        decoder.decodeStruct(new codec.Enum(ax_enums$.InputEventType));
    val.textBoundary =
        decoder.decodeStruct(new codec.Enum(ax_enums$.TextBoundary));
    val.moveDirection =
        decoder.decodeStruct(new codec.Enum(ax_enums$.MoveDirection));
    return val;
  };

  EventIntent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventIntent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.command);
    encoder.encodeStruct(codec.Int32, val.inputEventType);
    encoder.encodeStruct(codec.Int32, val.textBoundary);
    encoder.encodeStruct(codec.Int32, val.moveDirection);
  };
  exports.EventIntent = EventIntent;
})();