// ui/accessibility/mojom/ax_action_data.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_action_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "ui/accessibility/mojom/ax_action_data.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXActionDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXActionDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXActionData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ax::mojom::Action>(
        Traits::action(input),
        &fragment->action);

      decltype(Traits::target_tree_id(input)) in_target_tree_id = Traits::target_tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->target_tree_id)>
          target_tree_id_fragment(fragment.message());
      target_tree_id_fragment.Claim(&fragment->target_tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_target_tree_id,
        target_tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->target_tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_tree_id in AXActionData struct");

      decltype(Traits::source_extension_id(input)) in_source_extension_id = Traits::source_extension_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_extension_id)::BaseType> source_extension_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_source_extension_id,
        source_extension_id_fragment);

      fragment->source_extension_id.Set(
          source_extension_id_fragment.is_null() ? nullptr : source_extension_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_extension_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_extension_id in AXActionData struct");

      fragment->target_node_id = Traits::target_node_id(input);

      fragment->request_id = Traits::request_id(input);

      fragment->flags = Traits::flags(input);

      fragment->anchor_node_id = Traits::anchor_node_id(input);

      fragment->anchor_offset = Traits::anchor_offset(input);

      fragment->focus_node_id = Traits::focus_node_id(input);

      fragment->focus_offset = Traits::focus_offset(input);

      fragment->custom_action_id = Traits::custom_action_id(input);

      decltype(Traits::target_rect(input)) in_target_rect = Traits::target_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->target_rect)::BaseType> target_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_target_rect,
        target_rect_fragment);

      fragment->target_rect.Set(
          target_rect_fragment.is_null() ? nullptr : target_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->target_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_rect in AXActionData struct");

      decltype(Traits::target_point(input)) in_target_point = Traits::target_point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->target_point)::BaseType> target_point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_target_point,
        target_point_fragment);

      fragment->target_point.Set(
          target_point_fragment.is_null() ? nullptr : target_point_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->target_point.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_point in AXActionData struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AXActionData struct");

      
      mojo::internal::Serialize<::ax::mojom::Event>(
        Traits::hit_test_event_to_fire(input),
        &fragment->hit_test_event_to_fire);

      
      mojo::internal::Serialize<::ax::mojom::ScrollAlignment>(
        Traits::horizontal_scroll_alignment(input),
        &fragment->horizontal_scroll_alignment);

      
      mojo::internal::Serialize<::ax::mojom::ScrollAlignment>(
        Traits::vertical_scroll_alignment(input),
        &fragment->vertical_scroll_alignment);

      
      mojo::internal::Serialize<::ax::mojom::ScrollBehavior>(
        Traits::scroll_behavior(input),
        &fragment->scroll_behavior);

      decltype(Traits::child_tree_id(input)) in_child_tree_id = Traits::child_tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->child_tree_id)>
          child_tree_id_fragment(fragment.message());
      child_tree_id_fragment.Claim(&fragment->child_tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_child_tree_id,
        child_tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->child_tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null child_tree_id in AXActionData struct");

      
      mojo::internal::Serialize<::ax::mojom::Role>(
        Traits::target_role(input),
        &fragment->target_role);
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SEND_VALIDATION_H_