// ui/accessibility/ax_enums.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/ax_enums.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');


  var Event = {};
  Event.kNone = 0;
  Event.kActiveDescendantChanged = 1;
  Event.kAlert = 2;
  Event.kAriaAttributeChangedDeprecated = 3;
  Event.kAutocorrectionOccured = 4;
  Event.kBlur = 5;
  Event.kCheckedStateChanged = 6;
  Event.kChildrenChanged = 7;
  Event.kClicked = 8;
  Event.kControlsChanged = 9;
  Event.kDocumentSelectionChanged = 10;
  Event.kDocumentTitleChanged = 11;
  Event.kEndOfTest = 12;
  Event.kExpandedChanged = 13;
  Event.kFocus = 14;
  Event.kFocusAfterMenuClose = 15;
  Event.kFocusContext = 16;
  Event.kHide = 17;
  Event.kHitTestResult = 18;
  Event.kHover = 19;
  Event.kImageFrameUpdated = 20;
  Event.kLayoutComplete = 21;
  Event.kLiveRegionCreated = 22;
  Event.kLiveRegionChanged = 23;
  Event.kLoadComplete = 24;
  Event.kLoadStart = 25;
  Event.kLocationChanged = 26;
  Event.kMediaStartedPlaying = 27;
  Event.kMediaStoppedPlaying = 28;
  Event.kMenuEnd = 29;
  Event.kMenuListValueChangedDeprecated = 30;
  Event.kMenuPopupEnd = 31;
  Event.kMenuPopupStart = 32;
  Event.kMenuStart = 33;
  Event.kMouseCanceled = 34;
  Event.kMouseDragged = 35;
  Event.kMouseMoved = 36;
  Event.kMousePressed = 37;
  Event.kMouseReleased = 38;
  Event.kRowCollapsed = 39;
  Event.kRowCountChanged = 40;
  Event.kRowExpanded = 41;
  Event.kScrollPositionChanged = 42;
  Event.kScrolledToAnchor = 43;
  Event.kSelectedChildrenChanged = 44;
  Event.kSelection = 45;
  Event.kSelectionAdd = 46;
  Event.kSelectionRemove = 47;
  Event.kShow = 48;
  Event.kStateChanged = 49;
  Event.kTextChanged = 50;
  Event.kTextSelectionChanged = 51;
  Event.kTooltipClosed = 52;
  Event.kTooltipOpened = 53;
  Event.kTreeChanged = 54;
  Event.kValueChanged = 55;
  Event.kWindowActivated = 56;
  Event.kWindowDeactivated = 57;
  Event.kWindowVisibilityChanged = 58;
  Event.MIN_VALUE = 0;
  Event.MAX_VALUE = 58;
  Event.DEFAULT_VALUE = 0;

  Event.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
      return true;
    }
    return false;
  };

  Event.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  Event.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Role = {};
  Role.kUnknown = 181;
  Role.kAbbr = 1;
  Role.kAlert = 2;
  Role.kAlertDialog = 3;
  Role.kApplication = 4;
  Role.kArticle = 5;
  Role.kAudio = 6;
  Role.kBanner = 7;
  Role.kBlockquote = 8;
  Role.kButton = 9;
  Role.kCanvas = 10;
  Role.kCaption = 11;
  Role.kCaret = 12;
  Role.kCell = 13;
  Role.kCheckBox = 14;
  Role.kClient = 15;
  Role.kCode = 16;
  Role.kColorWell = 17;
  Role.kColumn = 18;
  Role.kColumnHeader = 19;
  Role.kComboBoxGrouping = 20;
  Role.kComboBoxMenuButton = 21;
  Role.kComboBoxSelect = 209;
  Role.kComplementary = 22;
  Role.kComment = 23;
  Role.kContentDeletion = 24;
  Role.kContentInsertion = 25;
  Role.kContentInfo = 26;
  Role.kDate = 27;
  Role.kDateTime = 28;
  Role.kDefinition = 29;
  Role.kDescriptionList = 30;
  Role.kDescriptionListDetailDeprecated = 31;
  Role.kDescriptionListTermDeprecated = 32;
  Role.kDesktop = 33;
  Role.kDetails = 34;
  Role.kDialog = 35;
  Role.kDirectoryDeprecated = 36;
  Role.kDisclosureTriangle = 37;
  Role.kDisclosureTriangleGrouped = 210;
  Role.kDocAbstract = 38;
  Role.kDocAcknowledgments = 39;
  Role.kDocAfterword = 40;
  Role.kDocAppendix = 41;
  Role.kDocBackLink = 42;
  Role.kDocBiblioEntry = 43;
  Role.kDocBibliography = 44;
  Role.kDocBiblioRef = 45;
  Role.kDocChapter = 46;
  Role.kDocColophon = 47;
  Role.kDocConclusion = 48;
  Role.kDocCover = 49;
  Role.kDocCredit = 50;
  Role.kDocCredits = 51;
  Role.kDocDedication = 52;
  Role.kDocEndnote = 53;
  Role.kDocEndnotes = 54;
  Role.kDocEpigraph = 55;
  Role.kDocEpilogue = 56;
  Role.kDocErrata = 57;
  Role.kDocExample = 58;
  Role.kDocFootnote = 59;
  Role.kDocForeword = 60;
  Role.kDocGlossary = 61;
  Role.kDocGlossRef = 62;
  Role.kDocIndex = 63;
  Role.kDocIntroduction = 64;
  Role.kDocNoteRef = 65;
  Role.kDocNotice = 66;
  Role.kDocPageBreak = 67;
  Role.kDocPageFooter = 68;
  Role.kDocPageHeader = 69;
  Role.kDocPageList = 70;
  Role.kDocPart = 71;
  Role.kDocPreface = 72;
  Role.kDocPrologue = 73;
  Role.kDocPullquote = 74;
  Role.kDocQna = 75;
  Role.kDocSubtitle = 76;
  Role.kDocTip = 77;
  Role.kDocToc = 78;
  Role.kDocument = 79;
  Role.kEmbeddedObject = 80;
  Role.kEmphasis = 81;
  Role.kFeed = 82;
  Role.kFigcaption = 83;
  Role.kFigure = 84;
  Role.kFooter = 85;
  Role.kSectionFooter = 86;
  Role.kForm = 87;
  Role.kGenericContainer = 88;
  Role.kGraphicsDocument = 89;
  Role.kGraphicsObject = 90;
  Role.kGraphicsSymbol = 91;
  Role.kGrid = 92;
  Role.kGridCell = 212;
  Role.kGroup = 93;
  Role.kHeader = 94;
  Role.kSectionHeader = 95;
  Role.kHeading = 96;
  Role.kIframe = 97;
  Role.kIframePresentational = 98;
  Role.kImage = 99;
  Role.kImeCandidate = 100;
  Role.kInlineTextBox = 101;
  Role.kInputTime = 102;
  Role.kKeyboard = 103;
  Role.kLabelText = 104;
  Role.kLayoutTable = 105;
  Role.kLayoutTableCell = 106;
  Role.kLayoutTableRow = 107;
  Role.kLegend = 108;
  Role.kLineBreak = 109;
  Role.kLink = 110;
  Role.kList = 111;
  Role.kListBox = 112;
  Role.kListBoxOption = 113;
  Role.kListGrid = 114;
  Role.kListItem = 115;
  Role.kListMarker = 116;
  Role.kLog = 117;
  Role.kMain = 118;
  Role.kMark = 119;
  Role.kMarquee = 120;
  Role.kMath = 121;
  Role.kMathMLFraction = 188;
  Role.kMathMLIdentifier = 189;
  Role.kMathMLMath = 187;
  Role.kMathMLMultiscripts = 190;
  Role.kMathMLNoneScript = 191;
  Role.kMathMLNumber = 192;
  Role.kMathMLOperator = 193;
  Role.kMathMLOver = 194;
  Role.kMathMLPrescriptDelimiter = 195;
  Role.kMathMLRoot = 196;
  Role.kMathMLRow = 197;
  Role.kMathMLSquareRoot = 198;
  Role.kMathMLStringLiteral = 199;
  Role.kMathMLSub = 200;
  Role.kMathMLSubSup = 201;
  Role.kMathMLSup = 202;
  Role.kMathMLTable = 203;
  Role.kMathMLTableCell = 204;
  Role.kMathMLTableRow = 205;
  Role.kMathMLText = 206;
  Role.kMathMLUnder = 207;
  Role.kMathMLUnderOver = 208;
  Role.kMenu = 122;
  Role.kMenuBar = 123;
  Role.kMenuItem = 124;
  Role.kMenuItemCheckBox = 125;
  Role.kMenuItemRadio = 126;
  Role.kMenuItemSeparator = 213;
  Role.kMenuListOption = 127;
  Role.kMenuListPopup = 128;
  Role.kMeter = 129;
  Role.kNavigation = 130;
  Role.kNone = 0;
  Role.kNote = 131;
  Role.kPane = 132;
  Role.kParagraph = 133;
  Role.kPdfActionableHighlight = 134;
  Role.kPdfRoot = 135;
  Role.kPluginObject = 136;
  Role.kPopUpButton = 137;
  Role.kPortalDeprecated = 138;
  Role.kPreDeprecated = 139;
  Role.kProgressIndicator = 140;
  Role.kRadioButton = 141;
  Role.kRadioGroup = 142;
  Role.kRegion = 143;
  Role.kRootWebArea = 144;
  Role.kRow = 145;
  Role.kRowGroup = 146;
  Role.kRowHeader = 147;
  Role.kRuby = 148;
  Role.kRubyAnnotation = 149;
  Role.kScrollBar = 150;
  Role.kScrollView = 151;
  Role.kSearch = 152;
  Role.kSearchBox = 153;
  Role.kSection = 154;
  Role.kSectionWithoutName = 211;
  Role.kSlider = 155;
  Role.kSpinButton = 156;
  Role.kSplitter = 157;
  Role.kStaticText = 158;
  Role.kStatus = 159;
  Role.kStrong = 160;
  Role.kSubscript = 185;
  Role.kSuggestion = 161;
  Role.kSuperscript = 186;
  Role.kSvgRoot = 162;
  Role.kSwitch = 163;
  Role.kTab = 164;
  Role.kTabList = 165;
  Role.kTabPanel = 166;
  Role.kTable = 167;
  Role.kTableHeaderContainer = 168;
  Role.kTerm = 169;
  Role.kTextField = 170;
  Role.kTextFieldWithComboBox = 171;
  Role.kTime = 172;
  Role.kTimer = 173;
  Role.kTitleBar = 174;
  Role.kToggleButton = 175;
  Role.kToolbar = 176;
  Role.kTooltip = 177;
  Role.kTree = 178;
  Role.kTreeGrid = 179;
  Role.kTreeItem = 180;
  Role.kVideo = 182;
  Role.kWebView = 183;
  Role.kWindow = 184;
  Role.MIN_VALUE = 0;
  Role.MAX_VALUE = 213;
  Role.DEFAULT_VALUE = 181;

  Role.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
    case 89:
    case 90:
    case 91:
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
    case 112:
    case 113:
    case 114:
    case 115:
    case 116:
    case 117:
    case 118:
    case 119:
    case 120:
    case 121:
    case 122:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 129:
    case 130:
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:
    case 137:
    case 138:
    case 139:
    case 140:
    case 141:
    case 142:
    case 143:
    case 144:
    case 145:
    case 146:
    case 147:
    case 148:
    case 149:
    case 150:
    case 151:
    case 152:
    case 153:
    case 154:
    case 155:
    case 156:
    case 157:
    case 158:
    case 159:
    case 160:
    case 161:
    case 162:
    case 163:
    case 164:
    case 165:
    case 166:
    case 167:
    case 168:
    case 169:
    case 170:
    case 171:
    case 172:
    case 173:
    case 174:
    case 175:
    case 176:
    case 177:
    case 178:
    case 179:
    case 180:
    case 181:
    case 182:
    case 183:
    case 184:
    case 185:
    case 186:
    case 187:
    case 188:
    case 189:
    case 190:
    case 191:
    case 192:
    case 193:
    case 194:
    case 195:
    case 196:
    case 197:
    case 198:
    case 199:
    case 200:
    case 201:
    case 202:
    case 203:
    case 204:
    case 205:
    case 206:
    case 207:
    case 208:
    case 209:
    case 210:
    case 211:
    case 212:
    case 213:
      return true;
    }
    return false;
  };

  Role.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  Role.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var State = {};
  State.kNone = 0;
  State.kAutofillAvailable = 1;
  State.kCollapsed = 2;
  State.kDefault = 3;
  State.kEditable = 4;
  State.kExpanded = 5;
  State.kFocusable = 6;
  State.kHorizontal = 7;
  State.kHovered = 8;
  State.kIgnored = 9;
  State.kInvisible = 10;
  State.kLinked = 11;
  State.kMultiline = 12;
  State.kMultiselectable = 13;
  State.kProtected = 14;
  State.kRequired = 15;
  State.kRichlyEditable = 16;
  State.kVertical = 17;
  State.kVisited = 18;
  State.kHasActions = 19;
  State.kHasInterestFor = 20;
  State.MIN_VALUE = 0;
  State.MAX_VALUE = 20;
  State.DEFAULT_VALUE = 0;

  State.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
      return true;
    }
    return false;
  };

  State.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  State.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Action = {};
  Action.kNone = 0;
  Action.kAnnotatePageImages = 1;
  Action.kBlur = 2;
  Action.kClearAccessibilityFocus = 3;
  Action.kCollapse = 4;
  Action.kCustomAction = 5;
  Action.kDecrement = 6;
  Action.kDoDefault = 7;
  Action.kExpand = 8;
  Action.kFocus = 9;
  Action.kGetImageData = 10;
  Action.kGetTextLocation = 11;
  Action.kHideTooltip = 12;
  Action.kHitTest = 13;
  Action.kIncrement = 14;
  Action.kInternalInvalidateTree = 15;
  Action.kLoadInlineTextBoxes = 16;
  Action.kLongClick = 38;
  Action.kReplaceSelectedText = 17;
  Action.kRequestLayoutBasedAction = 41;
  Action.kResumeMedia = 34;
  Action.kScrollBackward = 18;
  Action.kScrollDown = 19;
  Action.kScrollForward = 20;
  Action.kScrollLeft = 21;
  Action.kScrollRight = 22;
  Action.kScrollUp = 23;
  Action.kScrollToMakeVisible = 24;
  Action.kScrollToPoint = 25;
  Action.kScrollToPositionAtRowColumn = 39;
  Action.kSetAccessibilityFocus = 26;
  Action.kSetScrollOffset = 27;
  Action.kSetSelection = 28;
  Action.kSetSequentialFocusNavigationStartingPoint = 29;
  Action.kSetValue = 30;
  Action.kShowContextMenu = 31;
  Action.kSignalEndOfTest = 32;
  Action.kShowTooltip = 33;
  Action.kStitchChildTree = 40;
  Action.kStartDuckingMedia = 35;
  Action.kStopDuckingMedia = 36;
  Action.kSuspendMedia = 37;
  Action.MIN_VALUE = 0;
  Action.MAX_VALUE = 41;
  Action.DEFAULT_VALUE = 0;

  Action.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
      return true;
    }
    return false;
  };

  Action.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  Action.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ActionFlags = {};
  ActionFlags.kNone = 0;
  ActionFlags.kRequestImages = 1;
  ActionFlags.kRequestInlineTextBoxes = 2;
  ActionFlags.MIN_VALUE = 0;
  ActionFlags.MAX_VALUE = 2;

  ActionFlags.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ActionFlags.toKnownEnumValue = function(value) {
    return value;
  };

  ActionFlags.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ScrollAlignment = {};
  ScrollAlignment.kNone = 0;
  ScrollAlignment.kScrollAlignmentCenter = 1;
  ScrollAlignment.kScrollAlignmentTop = 2;
  ScrollAlignment.kScrollAlignmentBottom = 3;
  ScrollAlignment.kScrollAlignmentLeft = 4;
  ScrollAlignment.kScrollAlignmentRight = 5;
  ScrollAlignment.kScrollAlignmentClosestEdge = 6;
  ScrollAlignment.MIN_VALUE = 0;
  ScrollAlignment.MAX_VALUE = 6;
  ScrollAlignment.DEFAULT_VALUE = 0;

  ScrollAlignment.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  ScrollAlignment.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ScrollAlignment.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ScrollBehavior = {};
  ScrollBehavior.kNone = 0;
  ScrollBehavior.kDoNotScrollIfVisible = 1;
  ScrollBehavior.kScrollIfVisible = 2;
  ScrollBehavior.MIN_VALUE = 0;
  ScrollBehavior.MAX_VALUE = 2;
  ScrollBehavior.DEFAULT_VALUE = 0;

  ScrollBehavior.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ScrollBehavior.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ScrollBehavior.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DefaultActionVerb = {};
  DefaultActionVerb.kNone = 0;
  DefaultActionVerb.kActivate = 1;
  DefaultActionVerb.kCheck = 2;
  DefaultActionVerb.kClick = 3;
  DefaultActionVerb.kClickAncestor = 4;
  DefaultActionVerb.kClickInHitTest = 5;
  DefaultActionVerb.kClickNotInHitTest = 6;
  DefaultActionVerb.kJump = 7;
  DefaultActionVerb.kOpen = 8;
  DefaultActionVerb.kPress = 9;
  DefaultActionVerb.kSelect = 10;
  DefaultActionVerb.kUncheck = 11;
  DefaultActionVerb.MIN_VALUE = 0;
  DefaultActionVerb.MAX_VALUE = 11;

  DefaultActionVerb.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  DefaultActionVerb.toKnownEnumValue = function(value) {
    return value;
  };

  DefaultActionVerb.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Mutation = {};
  Mutation.kNone = 0;
  Mutation.kNodeCreated = 1;
  Mutation.kSubtreeCreated = 2;
  Mutation.kNodeChanged = 3;
  Mutation.kNodeRemoved = 4;
  Mutation.kTextChanged = 5;
  Mutation.kSubtreeUpdateEnd = 6;
  Mutation.MIN_VALUE = 0;
  Mutation.MAX_VALUE = 6;

  Mutation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  Mutation.toKnownEnumValue = function(value) {
    return value;
  };

  Mutation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var StringAttribute = {};
  StringAttribute.kNone = 0;
  StringAttribute.kAccessKey = 1;
  StringAttribute.kAppId = 2;
  StringAttribute.kAriaInvalidValueDeprecated = 3;
  StringAttribute.kAutoComplete = 4;
  StringAttribute.kAriaBrailleLabel = 33;
  StringAttribute.kAriaBrailleRoleDescription = 34;
  StringAttribute.kAriaCellColumnIndexText = 39;
  StringAttribute.kAriaCellRowIndexText = 40;
  StringAttribute.kAriaNotificationAnnouncementDeprecated = 36;
  StringAttribute.kAriaNotificationIdDeprecated = 37;
  StringAttribute.kCheckedStateDescription = 5;
  StringAttribute.kChildTreeId = 6;
  StringAttribute.kChildTreeNodeAppId = 7;
  StringAttribute.kClassName = 8;
  StringAttribute.kContainerLiveRelevant = 9;
  StringAttribute.kContainerLiveStatus = 10;
  StringAttribute.kDateTime = 41;
  StringAttribute.kDescription = 11;
  StringAttribute.kDisplay = 12;
  StringAttribute.kDoDefaultLabel = 31;
  StringAttribute.kFontFamily = 13;
  StringAttribute.kHtmlId = 38;
  StringAttribute.kHtmlTag = 14;
  StringAttribute.kHtmlInputName = 42;
  StringAttribute.kImageAnnotation = 15;
  StringAttribute.kImageDataUrl = 16;
  StringAttribute.kInputType = 18;
  StringAttribute.kKeyShortcuts = 19;
  StringAttribute.kLanguage = 20;
  StringAttribute.kLinkTarget = 35;
  StringAttribute.kLongClickLabel = 32;
  StringAttribute.kLiveRelevant = 22;
  StringAttribute.kLiveStatus = 23;
  StringAttribute.kMathContent = 17;
  StringAttribute.kName = 21;
  StringAttribute.kPlaceholder = 24;
  StringAttribute.kRole = 25;
  StringAttribute.kRoleDescription = 26;
  StringAttribute.kTooltip = 27;
  StringAttribute.kUrl = 28;
  StringAttribute.kValue = 29;
  StringAttribute.kVirtualContent = 30;
  StringAttribute.MIN_VALUE = 0;
  StringAttribute.MAX_VALUE = 42;
  StringAttribute.DEFAULT_VALUE = 0;

  StringAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
      return true;
    }
    return false;
  };

  StringAttribute.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  StringAttribute.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IntAttribute = {};
  IntAttribute.kNone = 0;
  IntAttribute.kDefaultActionVerb = 1;
  IntAttribute.kScrollX = 2;
  IntAttribute.kScrollXMin = 3;
  IntAttribute.kScrollXMax = 4;
  IntAttribute.kScrollY = 5;
  IntAttribute.kScrollYMin = 6;
  IntAttribute.kScrollYMax = 7;
  IntAttribute.kTextSelStart = 8;
  IntAttribute.kTextSelEnd = 9;
  IntAttribute.kAriaColumnCount = 10;
  IntAttribute.kAriaCellColumnIndex = 11;
  IntAttribute.kAriaCellColumnSpan = 12;
  IntAttribute.kAriaRowCount = 13;
  IntAttribute.kAriaCellRowIndex = 14;
  IntAttribute.kAriaCellRowSpan = 15;
  IntAttribute.kTableRowCount = 16;
  IntAttribute.kTableColumnCount = 17;
  IntAttribute.kTableHeaderId = 18;
  IntAttribute.kTableRowIndex = 19;
  IntAttribute.kTableRowHeaderId = 20;
  IntAttribute.kTableColumnIndex = 21;
  IntAttribute.kTableColumnHeaderId = 22;
  IntAttribute.kTableCellColumnIndex = 23;
  IntAttribute.kTableCellColumnSpan = 24;
  IntAttribute.kTableCellRowIndex = 25;
  IntAttribute.kTableCellRowSpan = 26;
  IntAttribute.kSortDirection = 27;
  IntAttribute.kHierarchicalLevel = 28;
  IntAttribute.kNameFrom = 29;
  IntAttribute.kDescriptionFrom = 30;
  IntAttribute.kActivedescendantId = 31;
  IntAttribute.kErrormessageIdDeprecated = 32;
  IntAttribute.kInPageLinkTargetId = 33;
  IntAttribute.kMemberOfId = 34;
  IntAttribute.kNextOnLineId = 35;
  IntAttribute.kPopupForId = 36;
  IntAttribute.kPreviousOnLineId = 37;
  IntAttribute.kRestriction = 38;
  IntAttribute.kSetSize = 39;
  IntAttribute.kPosInSet = 40;
  IntAttribute.kColorValue = 41;
  IntAttribute.kAriaCurrentState = 42;
  IntAttribute.kBackgroundColor = 43;
  IntAttribute.kColor = 44;
  IntAttribute.kHasPopup = 45;
  IntAttribute.kImageAnnotationStatus = 46;
  IntAttribute.kInvalidState = 47;
  IntAttribute.kCheckedState = 48;
  IntAttribute.kListStyle = 49;
  IntAttribute.kTextAlign = 50;
  IntAttribute.kTextDirection = 51;
  IntAttribute.kTextPosition = 52;
  IntAttribute.kTextStyle = 53;
  IntAttribute.kTextOverlineStyle = 54;
  IntAttribute.kTextStrikethroughStyle = 55;
  IntAttribute.kTextUnderlineStyle = 56;
  IntAttribute.kPreviousFocusId = 57;
  IntAttribute.kNextFocusId = 58;
  IntAttribute.kDropeffectDeprecated = 59;
  IntAttribute.kDOMNodeIdDeprecated = 60;
  IntAttribute.kIsPopup = 61;
  IntAttribute.kNextWindowFocusId = 62;
  IntAttribute.kPreviousWindowFocusId = 63;
  IntAttribute.kAriaNotificationInterruptDeprecated = 64;
  IntAttribute.kAriaNotificationPriorityDeprecated = 65;
  IntAttribute.kDetailsFrom = 66;
  IntAttribute.kMaxLength = 67;
  IntAttribute.kPaintOrder = 68;
  IntAttribute.MIN_VALUE = 0;
  IntAttribute.MAX_VALUE = 68;
  IntAttribute.DEFAULT_VALUE = 0;

  IntAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
      return true;
    }
    return false;
  };

  IntAttribute.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  IntAttribute.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FloatAttribute = {};
  FloatAttribute.kNone = 0;
  FloatAttribute.kValueForRange = 1;
  FloatAttribute.kMinValueForRange = 2;
  FloatAttribute.kMaxValueForRange = 3;
  FloatAttribute.kStepValueForRange = 4;
  FloatAttribute.kFontSize = 5;
  FloatAttribute.kFontWeight = 6;
  FloatAttribute.kTextIndent = 7;
  FloatAttribute.kChildTreeScale = 8;
  FloatAttribute.MIN_VALUE = 0;
  FloatAttribute.MAX_VALUE = 8;
  FloatAttribute.DEFAULT_VALUE = 0;

  FloatAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  FloatAttribute.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  FloatAttribute.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BoolAttribute = {};
  BoolAttribute.kNone = 0;
  BoolAttribute.kBusy = 1;
  BoolAttribute.kNonAtomicTextFieldRoot = 2;
  BoolAttribute.kContainerLiveAtomic = 3;
  BoolAttribute.kContainerLiveBusy = 4;
  BoolAttribute.kLiveAtomic = 5;
  BoolAttribute.kModal = 6;
  BoolAttribute.kUpdateLocationOnly = 7;
  BoolAttribute.kCanvasHasFallback = 8;
  BoolAttribute.kScrollable = 9;
  BoolAttribute.kClickable = 10;
  BoolAttribute.kClipsChildren = 11;
  BoolAttribute.kNotUserSelectableStyle = 12;
  BoolAttribute.kSelected = 13;
  BoolAttribute.kSelectedFromFocus = 14;
  BoolAttribute.kSupportsTextLocation = 15;
  BoolAttribute.kGrabbedDeprecated = 16;
  BoolAttribute.kIsLineBreakingObject = 17;
  BoolAttribute.kIsPageBreakingObject = 18;
  BoolAttribute.kHasAriaAttribute = 19;
  BoolAttribute.kTouchPassthroughDeprecated = 20;
  BoolAttribute.kLongClickable = 21;
  BoolAttribute.kHasHiddenOffscreenNodes = 22;
  BoolAttribute.MIN_VALUE = 0;
  BoolAttribute.MAX_VALUE = 22;
  BoolAttribute.DEFAULT_VALUE = 0;

  BoolAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
      return true;
    }
    return false;
  };

  BoolAttribute.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  BoolAttribute.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IntListAttribute = {};
  IntListAttribute.kNone = 0;
  IntListAttribute.kIndirectChildIds = 1;
  IntListAttribute.kControlsIds = 2;
  IntListAttribute.kDetailsIds = 3;
  IntListAttribute.kDescribedbyIds = 4;
  IntListAttribute.kErrormessageIds = 26;
  IntListAttribute.kFlowtoIds = 5;
  IntListAttribute.kLabelledbyIds = 6;
  IntListAttribute.kRadioGroupIds = 7;
  IntListAttribute.kActionsIds = 29;
  IntListAttribute.kMarkerTypes = 8;
  IntListAttribute.kMarkerStarts = 9;
  IntListAttribute.kMarkerEnds = 10;
  IntListAttribute.kHighlightTypes = 20;
  IntListAttribute.kCaretBounds = 16;
  IntListAttribute.kCharacterOffsets = 11;
  IntListAttribute.kLineStarts = 12;
  IntListAttribute.kLineEnds = 17;
  IntListAttribute.kSentenceStarts = 18;
  IntListAttribute.kSentenceEnds = 19;
  IntListAttribute.kWordStarts = 13;
  IntListAttribute.kWordEnds = 14;
  IntListAttribute.kCustomActionIds = 15;
  IntListAttribute.kTextOperationStartAnchorIds = 21;
  IntListAttribute.kTextOperationStartOffsets = 22;
  IntListAttribute.kTextOperationEndAnchorIds = 23;
  IntListAttribute.kTextOperationEndOffsets = 24;
  IntListAttribute.kTextOperations = 25;
  IntListAttribute.kAriaNotificationInterruptProperties = 27;
  IntListAttribute.kAriaNotificationPriorityProperties = 28;
  IntListAttribute.MIN_VALUE = 0;
  IntListAttribute.MAX_VALUE = 29;
  IntListAttribute.DEFAULT_VALUE = 0;

  IntListAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
      return true;
    }
    return false;
  };

  IntListAttribute.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  IntListAttribute.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var StringListAttribute = {};
  StringListAttribute.kNone = 0;
  StringListAttribute.kAriaNotificationAnnouncements = 2;
  StringListAttribute.kAriaNotificationTypes = 3;
  StringListAttribute.kCustomActionDescriptions = 1;
  StringListAttribute.MIN_VALUE = 0;
  StringListAttribute.MAX_VALUE = 3;
  StringListAttribute.DEFAULT_VALUE = 0;

  StringListAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  StringListAttribute.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  StringListAttribute.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ListStyle = {};
  ListStyle.kNone = 0;
  ListStyle.kCircle = 1;
  ListStyle.kDisc = 2;
  ListStyle.kImage = 3;
  ListStyle.kNumeric = 4;
  ListStyle.kSquare = 5;
  ListStyle.kOther = 6;
  ListStyle.MIN_VALUE = 0;
  ListStyle.MAX_VALUE = 6;

  ListStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  ListStyle.toKnownEnumValue = function(value) {
    return value;
  };

  ListStyle.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MarkerType = {};
  MarkerType.kNone = 0;
  MarkerType.kSpelling = 1;
  MarkerType.kGrammar = 2;
  MarkerType.kTextMatch = 4;
  MarkerType.kActiveSuggestion = 16;
  MarkerType.kSuggestion = 32;
  MarkerType.kHighlight = 64;
  MarkerType.MIN_VALUE = 0;
  MarkerType.MAX_VALUE = 64;

  MarkerType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 4:
    case 16:
    case 32:
    case 64:
      return true;
    }
    return false;
  };

  MarkerType.toKnownEnumValue = function(value) {
    return value;
  };

  MarkerType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HighlightType = {};
  HighlightType.kNone = 0;
  HighlightType.kHighlight = 1;
  HighlightType.kSpellingError = 2;
  HighlightType.kGrammarError = 3;
  HighlightType.MIN_VALUE = 0;
  HighlightType.MAX_VALUE = 3;

  HighlightType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  HighlightType.toKnownEnumValue = function(value) {
    return value;
  };

  HighlightType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MoveDirection = {};
  MoveDirection.kNone = 0;
  MoveDirection.kBackward = 1;
  MoveDirection.kForward = 2;
  MoveDirection.MIN_VALUE = 0;
  MoveDirection.MAX_VALUE = 2;
  MoveDirection.DEFAULT_VALUE = 0;

  MoveDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  MoveDirection.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  MoveDirection.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Command = {};
  Command.kNone = 0;
  Command.kClearSelection = 1;
  Command.kDelete = 2;
  Command.kDictate = 3;
  Command.kExtendSelection = 4;
  Command.kFormat = 5;
  Command.kHistory = 6;
  Command.kInsert = 7;
  Command.kMarker = 8;
  Command.kMoveSelection = 9;
  Command.kSetSelection = 10;
  Command.MIN_VALUE = 0;
  Command.MAX_VALUE = 10;
  Command.DEFAULT_VALUE = 0;

  Command.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  Command.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  Command.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var InputEventType = {};
  InputEventType.kNone = 0;
  InputEventType.kInsertText = 1;
  InputEventType.kInsertLineBreak = 2;
  InputEventType.kInsertParagraph = 3;
  InputEventType.kInsertOrderedList = 4;
  InputEventType.kInsertUnorderedList = 5;
  InputEventType.kInsertHorizontalRule = 6;
  InputEventType.kInsertFromPaste = 7;
  InputEventType.kInsertFromDrop = 8;
  InputEventType.kInsertFromYank = 9;
  InputEventType.kInsertTranspose = 10;
  InputEventType.kInsertReplacementText = 11;
  InputEventType.kInsertCompositionText = 12;
  InputEventType.kInsertLink = 39;
  InputEventType.kDeleteWordBackward = 13;
  InputEventType.kDeleteWordForward = 14;
  InputEventType.kDeleteSoftLineBackward = 15;
  InputEventType.kDeleteSoftLineForward = 16;
  InputEventType.kDeleteHardLineBackward = 17;
  InputEventType.kDeleteHardLineForward = 18;
  InputEventType.kDeleteContentBackward = 19;
  InputEventType.kDeleteContentForward = 20;
  InputEventType.kDeleteByCut = 21;
  InputEventType.kDeleteByDrag = 22;
  InputEventType.kHistoryUndo = 23;
  InputEventType.kHistoryRedo = 24;
  InputEventType.kFormatBold = 25;
  InputEventType.kFormatItalic = 26;
  InputEventType.kFormatUnderline = 27;
  InputEventType.kFormatStrikeThrough = 28;
  InputEventType.kFormatSuperscript = 29;
  InputEventType.kFormatSubscript = 30;
  InputEventType.kFormatJustifyCenter = 31;
  InputEventType.kFormatJustifyFull = 32;
  InputEventType.kFormatJustifyRight = 33;
  InputEventType.kFormatJustifyLeft = 34;
  InputEventType.kFormatIndent = 35;
  InputEventType.kFormatOutdent = 36;
  InputEventType.kFormatRemove = 37;
  InputEventType.kFormatSetBlockTextDirection = 38;
  InputEventType.MIN_VALUE = 0;
  InputEventType.MAX_VALUE = 39;
  InputEventType.DEFAULT_VALUE = 0;

  InputEventType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
      return true;
    }
    return false;
  };

  InputEventType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  InputEventType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextBoundary = {};
  TextBoundary.kNone = 0;
  TextBoundary.kCharacter = 1;
  TextBoundary.kFormatEnd = 2;
  TextBoundary.kFormatStart = 21;
  TextBoundary.kFormatStartOrEnd = 22;
  TextBoundary.kLineEnd = 3;
  TextBoundary.kLineStart = 4;
  TextBoundary.kLineStartOrEnd = 5;
  TextBoundary.kObject = 6;
  TextBoundary.kPageEnd = 7;
  TextBoundary.kPageStart = 8;
  TextBoundary.kPageStartOrEnd = 9;
  TextBoundary.kParagraphEnd = 10;
  TextBoundary.kParagraphStart = 11;
  TextBoundary.kParagraphStartSkippingEmptyParagraphs = 20;
  TextBoundary.kParagraphStartOrEnd = 12;
  TextBoundary.kSentenceEnd = 13;
  TextBoundary.kSentenceStart = 14;
  TextBoundary.kSentenceStartOrEnd = 15;
  TextBoundary.kWebPage = 16;
  TextBoundary.kWordEnd = 17;
  TextBoundary.kWordStart = 18;
  TextBoundary.kWordStartOrEnd = 19;
  TextBoundary.MIN_VALUE = 0;
  TextBoundary.MAX_VALUE = 22;
  TextBoundary.DEFAULT_VALUE = 0;

  TextBoundary.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
      return true;
    }
    return false;
  };

  TextBoundary.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  TextBoundary.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextAlign = {};
  TextAlign.kNone = 0;
  TextAlign.kLeft = 1;
  TextAlign.kRight = 2;
  TextAlign.kCenter = 3;
  TextAlign.kJustify = 4;
  TextAlign.MIN_VALUE = 0;
  TextAlign.MAX_VALUE = 4;

  TextAlign.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  TextAlign.toKnownEnumValue = function(value) {
    return value;
  };

  TextAlign.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WritingDirection = {};
  WritingDirection.kNone = 0;
  WritingDirection.kLtr = 1;
  WritingDirection.kRtl = 2;
  WritingDirection.kTtb = 3;
  WritingDirection.kBtt = 4;
  WritingDirection.MIN_VALUE = 0;
  WritingDirection.MAX_VALUE = 4;

  WritingDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  WritingDirection.toKnownEnumValue = function(value) {
    return value;
  };

  WritingDirection.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextPosition = {};
  TextPosition.kNone = 0;
  TextPosition.kSubscript = 1;
  TextPosition.kSuperscript = 2;
  TextPosition.MIN_VALUE = 0;
  TextPosition.MAX_VALUE = 2;

  TextPosition.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  TextPosition.toKnownEnumValue = function(value) {
    return value;
  };

  TextPosition.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextStyle = {};
  TextStyle.kNone = 0;
  TextStyle.kBold = 1;
  TextStyle.kItalic = 2;
  TextStyle.kUnderline = 3;
  TextStyle.kLineThrough = 4;
  TextStyle.kOverline = 5;
  TextStyle.MIN_VALUE = 0;
  TextStyle.MAX_VALUE = 5;

  TextStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  TextStyle.toKnownEnumValue = function(value) {
    return value;
  };

  TextStyle.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextDecorationStyle = {};
  TextDecorationStyle.kNone = 0;
  TextDecorationStyle.kDotted = 1;
  TextDecorationStyle.kDashed = 2;
  TextDecorationStyle.kSolid = 3;
  TextDecorationStyle.kDouble = 4;
  TextDecorationStyle.kWavy = 5;
  TextDecorationStyle.MIN_VALUE = 0;
  TextDecorationStyle.MAX_VALUE = 5;

  TextDecorationStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  TextDecorationStyle.toKnownEnumValue = function(value) {
    return value;
  };

  TextDecorationStyle.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AriaCurrentState = {};
  AriaCurrentState.kNone = 0;
  AriaCurrentState.kFalse = 1;
  AriaCurrentState.kTrue = 2;
  AriaCurrentState.kPage = 3;
  AriaCurrentState.kStep = 4;
  AriaCurrentState.kLocation = 5;
  AriaCurrentState.kDate = 6;
  AriaCurrentState.kTime = 7;
  AriaCurrentState.MIN_VALUE = 0;
  AriaCurrentState.MAX_VALUE = 7;

  AriaCurrentState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  AriaCurrentState.toKnownEnumValue = function(value) {
    return value;
  };

  AriaCurrentState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HasPopup = {};
  HasPopup.kFalse = 0;
  HasPopup.kTrue = 1;
  HasPopup.kMenu = 2;
  HasPopup.kListbox = 3;
  HasPopup.kTree = 4;
  HasPopup.kGrid = 5;
  HasPopup.kDialog = 6;
  HasPopup.kNone = 0;
  HasPopup.MIN_VALUE = 0;
  HasPopup.MAX_VALUE = 6;

  HasPopup.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  HasPopup.toKnownEnumValue = function(value) {
    return value;
  };

  HasPopup.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IsPopup = {};
  IsPopup.kNone = 0;
  IsPopup.kManual = 1;
  IsPopup.kAuto = 2;
  IsPopup.kHint = 3;
  IsPopup.MIN_VALUE = 0;
  IsPopup.MAX_VALUE = 3;

  IsPopup.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  IsPopup.toKnownEnumValue = function(value) {
    return value;
  };

  IsPopup.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var InvalidState = {};
  InvalidState.kNone = 0;
  InvalidState.kFalse = 1;
  InvalidState.kTrue = 2;
  InvalidState.MIN_VALUE = 0;
  InvalidState.MAX_VALUE = 2;

  InvalidState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  InvalidState.toKnownEnumValue = function(value) {
    return value;
  };

  InvalidState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Restriction = {};
  Restriction.kNone = 0;
  Restriction.kReadOnly = 1;
  Restriction.kDisabled = 2;
  Restriction.MIN_VALUE = 0;
  Restriction.MAX_VALUE = 2;

  Restriction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  Restriction.toKnownEnumValue = function(value) {
    return value;
  };

  Restriction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CheckedState = {};
  CheckedState.kNone = 0;
  CheckedState.kFalse = 1;
  CheckedState.kTrue = 2;
  CheckedState.kMixed = 3;
  CheckedState.MIN_VALUE = 0;
  CheckedState.MAX_VALUE = 3;

  CheckedState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  CheckedState.toKnownEnumValue = function(value) {
    return value;
  };

  CheckedState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SortDirection = {};
  SortDirection.kNone = 0;
  SortDirection.kUnsorted = 1;
  SortDirection.kAscending = 2;
  SortDirection.kDescending = 3;
  SortDirection.kOther = 4;
  SortDirection.MIN_VALUE = 0;
  SortDirection.MAX_VALUE = 4;

  SortDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  SortDirection.toKnownEnumValue = function(value) {
    return value;
  };

  SortDirection.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var NameFrom = {};
  NameFrom.kNone = 0;
  NameFrom.kAttribute = 1;
  NameFrom.kAttributeExplicitlyEmpty = 2;
  NameFrom.kCaption = 3;
  NameFrom.kContents = 4;
  NameFrom.kCssAltText = 5;
  NameFrom.kPlaceholder = 6;
  NameFrom.kRelatedElement = 7;
  NameFrom.kProhibited = 8;
  NameFrom.kProhibitedAndRedundant = 9;
  NameFrom.kTitle = 10;
  NameFrom.kValue = 11;
  NameFrom.kPopoverTarget = 12;
  NameFrom.kInterestFor = 13;
  NameFrom.MIN_VALUE = 0;
  NameFrom.MAX_VALUE = 13;

  NameFrom.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
      return true;
    }
    return false;
  };

  NameFrom.toKnownEnumValue = function(value) {
    return value;
  };

  NameFrom.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DescriptionFrom = {};
  DescriptionFrom.kNone = 0;
  DescriptionFrom.kAriaDescription = 1;
  DescriptionFrom.kAttributeExplicitlyEmpty = 2;
  DescriptionFrom.kButtonLabel = 3;
  DescriptionFrom.kRelatedElement = 4;
  DescriptionFrom.kRubyAnnotation = 5;
  DescriptionFrom.kProhibitedNameRepair = 6;
  DescriptionFrom.kSummary = 7;
  DescriptionFrom.kSvgDescElement = 8;
  DescriptionFrom.kTableCaption = 9;
  DescriptionFrom.kTitle = 10;
  DescriptionFrom.kPopoverTarget = 11;
  DescriptionFrom.kInterestFor = 12;
  DescriptionFrom.MIN_VALUE = 0;
  DescriptionFrom.MAX_VALUE = 12;

  DescriptionFrom.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
      return true;
    }
    return false;
  };

  DescriptionFrom.toKnownEnumValue = function(value) {
    return value;
  };

  DescriptionFrom.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DetailsFrom = {};
  DetailsFrom.kAriaDetails = 0;
  DetailsFrom.kCssAnchor = 1;
  DetailsFrom.kPopoverTarget = 2;
  DetailsFrom.kInterestFor = 3;
  DetailsFrom.kCommandfor = 4;
  DetailsFrom.kCssScrollMarkerPseudoElement = 5;
  DetailsFrom.MIN_VALUE = 0;
  DetailsFrom.MAX_VALUE = 5;

  DetailsFrom.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  DetailsFrom.toKnownEnumValue = function(value) {
    return value;
  };

  DetailsFrom.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EventFrom = {};
  EventFrom.kNone = 0;
  EventFrom.kUser = 1;
  EventFrom.kPage = 2;
  EventFrom.kAction = 3;
  EventFrom.MIN_VALUE = 0;
  EventFrom.MAX_VALUE = 3;
  EventFrom.DEFAULT_VALUE = 0;

  EventFrom.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  EventFrom.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  EventFrom.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Gesture = {};
  Gesture.kNone = 0;
  Gesture.kClick = 1;
  Gesture.kSwipeLeft1 = 2;
  Gesture.kSwipeUp1 = 3;
  Gesture.kSwipeRight1 = 4;
  Gesture.kSwipeDown1 = 5;
  Gesture.kSwipeLeft2 = 6;
  Gesture.kSwipeUp2 = 7;
  Gesture.kSwipeRight2 = 8;
  Gesture.kSwipeDown2 = 9;
  Gesture.kSwipeLeft3 = 10;
  Gesture.kSwipeUp3 = 11;
  Gesture.kSwipeRight3 = 12;
  Gesture.kSwipeDown3 = 13;
  Gesture.kSwipeLeft4 = 14;
  Gesture.kSwipeUp4 = 15;
  Gesture.kSwipeRight4 = 16;
  Gesture.kSwipeDown4 = 17;
  Gesture.kTap2 = 18;
  Gesture.kTap3 = 19;
  Gesture.kTap4 = 20;
  Gesture.kTouchExplore = 21;
  Gesture.MIN_VALUE = 0;
  Gesture.MAX_VALUE = 21;

  Gesture.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
      return true;
    }
    return false;
  };

  Gesture.toKnownEnumValue = function(value) {
    return value;
  };

  Gesture.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextAffinity = {};
  TextAffinity.kNone = 0;
  TextAffinity.kDownstream = 1;
  TextAffinity.kUpstream = 2;
  TextAffinity.MIN_VALUE = 0;
  TextAffinity.MAX_VALUE = 2;
  TextAffinity.DEFAULT_VALUE = 0;

  TextAffinity.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  TextAffinity.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  TextAffinity.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TreeOrder = {};
  TreeOrder.kNone = 0;
  TreeOrder.kUndefined = 1;
  TreeOrder.kBefore = 2;
  TreeOrder.kEqual = 3;
  TreeOrder.kAfter = 4;
  TreeOrder.MIN_VALUE = 0;
  TreeOrder.MAX_VALUE = 4;

  TreeOrder.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  TreeOrder.toKnownEnumValue = function(value) {
    return value;
  };

  TreeOrder.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AXTreeIDType = {};
  AXTreeIDType.kUnknown = 0;
  AXTreeIDType.kToken = 1;
  AXTreeIDType.MIN_VALUE = 0;
  AXTreeIDType.MAX_VALUE = 1;

  AXTreeIDType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AXTreeIDType.toKnownEnumValue = function(value) {
    return value;
  };

  AXTreeIDType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ImageAnnotationStatus = {};
  ImageAnnotationStatus.kNone = 0;
  ImageAnnotationStatus.kWillNotAnnotateDueToScheme = 1;
  ImageAnnotationStatus.kIneligibleForAnnotation = 2;
  ImageAnnotationStatus.kEligibleForAnnotation = 3;
  ImageAnnotationStatus.kSilentlyEligibleForAnnotation = 4;
  ImageAnnotationStatus.kAnnotationPending = 5;
  ImageAnnotationStatus.kAnnotationSucceeded = 6;
  ImageAnnotationStatus.kAnnotationEmpty = 7;
  ImageAnnotationStatus.kAnnotationAdult = 8;
  ImageAnnotationStatus.kAnnotationProcessFailed = 9;
  ImageAnnotationStatus.MIN_VALUE = 0;
  ImageAnnotationStatus.MAX_VALUE = 9;

  ImageAnnotationStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  ImageAnnotationStatus.toKnownEnumValue = function(value) {
    return value;
  };

  ImageAnnotationStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AriaNotificationInterrupt = {};
  AriaNotificationInterrupt.kNone = 0;
  AriaNotificationInterrupt.kAll = 1;
  AriaNotificationInterrupt.kPending = 2;
  AriaNotificationInterrupt.MIN_VALUE = 0;
  AriaNotificationInterrupt.MAX_VALUE = 2;

  AriaNotificationInterrupt.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AriaNotificationInterrupt.toKnownEnumValue = function(value) {
    return value;
  };

  AriaNotificationInterrupt.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AriaNotificationPriority = {};
  AriaNotificationPriority.kNormal = 0;
  AriaNotificationPriority.kHigh = 1;
  AriaNotificationPriority.MIN_VALUE = 0;
  AriaNotificationPriority.MAX_VALUE = 1;

  AriaNotificationPriority.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AriaNotificationPriority.toKnownEnumValue = function(value) {
    return value;
  };

  AriaNotificationPriority.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  exports.Event = Event;
  exports.Role = Role;
  exports.State = State;
  exports.Action = Action;
  exports.ActionFlags = ActionFlags;
  exports.ScrollAlignment = ScrollAlignment;
  exports.ScrollBehavior = ScrollBehavior;
  exports.DefaultActionVerb = DefaultActionVerb;
  exports.Mutation = Mutation;
  exports.StringAttribute = StringAttribute;
  exports.IntAttribute = IntAttribute;
  exports.FloatAttribute = FloatAttribute;
  exports.BoolAttribute = BoolAttribute;
  exports.IntListAttribute = IntListAttribute;
  exports.StringListAttribute = StringListAttribute;
  exports.ListStyle = ListStyle;
  exports.MarkerType = MarkerType;
  exports.HighlightType = HighlightType;
  exports.MoveDirection = MoveDirection;
  exports.Command = Command;
  exports.InputEventType = InputEventType;
  exports.TextBoundary = TextBoundary;
  exports.TextAlign = TextAlign;
  exports.WritingDirection = WritingDirection;
  exports.TextPosition = TextPosition;
  exports.TextStyle = TextStyle;
  exports.TextDecorationStyle = TextDecorationStyle;
  exports.AriaCurrentState = AriaCurrentState;
  exports.HasPopup = HasPopup;
  exports.IsPopup = IsPopup;
  exports.InvalidState = InvalidState;
  exports.Restriction = Restriction;
  exports.CheckedState = CheckedState;
  exports.SortDirection = SortDirection;
  exports.NameFrom = NameFrom;
  exports.DescriptionFrom = DescriptionFrom;
  exports.DetailsFrom = DetailsFrom;
  exports.EventFrom = EventFrom;
  exports.Gesture = Gesture;
  exports.TextAffinity = TextAffinity;
  exports.TreeOrder = TreeOrder;
  exports.AXTreeIDType = AXTreeIDType;
  exports.ImageAnnotationStatus = ImageAnnotationStatus;
  exports.AriaNotificationInterrupt = AriaNotificationInterrupt;
  exports.AriaNotificationPriority = AriaNotificationPriority;
})();