// ui/accessibility/ax_enums.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/accessibility/ax_enums.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/ax_enums.mojom-params-data.h"
namespace ax {
namespace mojom {

NOINLINE static const char* EventToStringHelper(Event value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Event::kNone:
      return "kNone";
    case Event::kActiveDescendantChanged:
      return "kActiveDescendantChanged";
    case Event::kAlert:
      return "kAlert";
    case Event::kAriaAttributeChangedDeprecated:
      return "kAriaAttributeChangedDeprecated";
    case Event::kAutocorrectionOccured:
      return "kAutocorrectionOccured";
    case Event::kBlur:
      return "kBlur";
    case Event::kCheckedStateChanged:
      return "kCheckedStateChanged";
    case Event::kChildrenChanged:
      return "kChildrenChanged";
    case Event::kClicked:
      return "kClicked";
    case Event::kControlsChanged:
      return "kControlsChanged";
    case Event::kDocumentSelectionChanged:
      return "kDocumentSelectionChanged";
    case Event::kDocumentTitleChanged:
      return "kDocumentTitleChanged";
    case Event::kEndOfTest:
      return "kEndOfTest";
    case Event::kExpandedChanged:
      return "kExpandedChanged";
    case Event::kFocus:
      return "kFocus";
    case Event::kFocusAfterMenuClose:
      return "kFocusAfterMenuClose";
    case Event::kFocusContext:
      return "kFocusContext";
    case Event::kHide:
      return "kHide";
    case Event::kHitTestResult:
      return "kHitTestResult";
    case Event::kHover:
      return "kHover";
    case Event::kImageFrameUpdated:
      return "kImageFrameUpdated";
    case Event::kLayoutComplete:
      return "kLayoutComplete";
    case Event::kLiveRegionCreated:
      return "kLiveRegionCreated";
    case Event::kLiveRegionChanged:
      return "kLiveRegionChanged";
    case Event::kLoadComplete:
      return "kLoadComplete";
    case Event::kLoadStart:
      return "kLoadStart";
    case Event::kLocationChanged:
      return "kLocationChanged";
    case Event::kMediaStartedPlaying:
      return "kMediaStartedPlaying";
    case Event::kMediaStoppedPlaying:
      return "kMediaStoppedPlaying";
    case Event::kMenuEnd:
      return "kMenuEnd";
    case Event::kMenuListValueChangedDeprecated:
      return "kMenuListValueChangedDeprecated";
    case Event::kMenuPopupEnd:
      return "kMenuPopupEnd";
    case Event::kMenuPopupStart:
      return "kMenuPopupStart";
    case Event::kMenuStart:
      return "kMenuStart";
    case Event::kMouseCanceled:
      return "kMouseCanceled";
    case Event::kMouseDragged:
      return "kMouseDragged";
    case Event::kMouseMoved:
      return "kMouseMoved";
    case Event::kMousePressed:
      return "kMousePressed";
    case Event::kMouseReleased:
      return "kMouseReleased";
    case Event::kRowCollapsed:
      return "kRowCollapsed";
    case Event::kRowCountChanged:
      return "kRowCountChanged";
    case Event::kRowExpanded:
      return "kRowExpanded";
    case Event::kScrollPositionChanged:
      return "kScrollPositionChanged";
    case Event::kScrolledToAnchor:
      return "kScrolledToAnchor";
    case Event::kSelectedChildrenChanged:
      return "kSelectedChildrenChanged";
    case Event::kSelection:
      return "kSelection";
    case Event::kSelectionAdd:
      return "kSelectionAdd";
    case Event::kSelectionRemove:
      return "kSelectionRemove";
    case Event::kShow:
      return "kShow";
    case Event::kStateChanged:
      return "kStateChanged";
    case Event::kTextChanged:
      return "kTextChanged";
    case Event::kTextSelectionChanged:
      return "kTextSelectionChanged";
    case Event::kTooltipClosed:
      return "kTooltipClosed";
    case Event::kTooltipOpened:
      return "kTooltipOpened";
    case Event::kTreeChanged:
      return "kTreeChanged";
    case Event::kValueChanged:
      return "kValueChanged";
    case Event::kWindowActivated:
      return "kWindowActivated";
    case Event::kWindowDeactivated:
      return "kWindowDeactivated";
    case Event::kWindowVisibilityChanged:
      return "kWindowVisibilityChanged";
    default:
      return nullptr;
  }
}

std::string EventToString(Event value) {
  const char *str = EventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Event value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Event value) {
  return os << EventToString(value);
}

NOINLINE static const char* RoleToStringHelper(Role value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Role::kNone:
      return "kNone";
    case Role::kAbbr:
      return "kAbbr";
    case Role::kAlert:
      return "kAlert";
    case Role::kAlertDialog:
      return "kAlertDialog";
    case Role::kApplication:
      return "kApplication";
    case Role::kArticle:
      return "kArticle";
    case Role::kAudio:
      return "kAudio";
    case Role::kBanner:
      return "kBanner";
    case Role::kBlockquote:
      return "kBlockquote";
    case Role::kButton:
      return "kButton";
    case Role::kCanvas:
      return "kCanvas";
    case Role::kCaption:
      return "kCaption";
    case Role::kCaret:
      return "kCaret";
    case Role::kCell:
      return "kCell";
    case Role::kCheckBox:
      return "kCheckBox";
    case Role::kClient:
      return "kClient";
    case Role::kCode:
      return "kCode";
    case Role::kColorWell:
      return "kColorWell";
    case Role::kColumn:
      return "kColumn";
    case Role::kColumnHeader:
      return "kColumnHeader";
    case Role::kComboBoxGrouping:
      return "kComboBoxGrouping";
    case Role::kComboBoxMenuButton:
      return "kComboBoxMenuButton";
    case Role::kComplementary:
      return "kComplementary";
    case Role::kComment:
      return "kComment";
    case Role::kContentDeletion:
      return "kContentDeletion";
    case Role::kContentInsertion:
      return "kContentInsertion";
    case Role::kContentInfo:
      return "kContentInfo";
    case Role::kDate:
      return "kDate";
    case Role::kDateTime:
      return "kDateTime";
    case Role::kDefinition:
      return "kDefinition";
    case Role::kDescriptionList:
      return "kDescriptionList";
    case Role::kDescriptionListDetailDeprecated:
      return "kDescriptionListDetailDeprecated";
    case Role::kDescriptionListTermDeprecated:
      return "kDescriptionListTermDeprecated";
    case Role::kDesktop:
      return "kDesktop";
    case Role::kDetails:
      return "kDetails";
    case Role::kDialog:
      return "kDialog";
    case Role::kDirectoryDeprecated:
      return "kDirectoryDeprecated";
    case Role::kDisclosureTriangle:
      return "kDisclosureTriangle";
    case Role::kDocAbstract:
      return "kDocAbstract";
    case Role::kDocAcknowledgments:
      return "kDocAcknowledgments";
    case Role::kDocAfterword:
      return "kDocAfterword";
    case Role::kDocAppendix:
      return "kDocAppendix";
    case Role::kDocBackLink:
      return "kDocBackLink";
    case Role::kDocBiblioEntry:
      return "kDocBiblioEntry";
    case Role::kDocBibliography:
      return "kDocBibliography";
    case Role::kDocBiblioRef:
      return "kDocBiblioRef";
    case Role::kDocChapter:
      return "kDocChapter";
    case Role::kDocColophon:
      return "kDocColophon";
    case Role::kDocConclusion:
      return "kDocConclusion";
    case Role::kDocCover:
      return "kDocCover";
    case Role::kDocCredit:
      return "kDocCredit";
    case Role::kDocCredits:
      return "kDocCredits";
    case Role::kDocDedication:
      return "kDocDedication";
    case Role::kDocEndnote:
      return "kDocEndnote";
    case Role::kDocEndnotes:
      return "kDocEndnotes";
    case Role::kDocEpigraph:
      return "kDocEpigraph";
    case Role::kDocEpilogue:
      return "kDocEpilogue";
    case Role::kDocErrata:
      return "kDocErrata";
    case Role::kDocExample:
      return "kDocExample";
    case Role::kDocFootnote:
      return "kDocFootnote";
    case Role::kDocForeword:
      return "kDocForeword";
    case Role::kDocGlossary:
      return "kDocGlossary";
    case Role::kDocGlossRef:
      return "kDocGlossRef";
    case Role::kDocIndex:
      return "kDocIndex";
    case Role::kDocIntroduction:
      return "kDocIntroduction";
    case Role::kDocNoteRef:
      return "kDocNoteRef";
    case Role::kDocNotice:
      return "kDocNotice";
    case Role::kDocPageBreak:
      return "kDocPageBreak";
    case Role::kDocPageFooter:
      return "kDocPageFooter";
    case Role::kDocPageHeader:
      return "kDocPageHeader";
    case Role::kDocPageList:
      return "kDocPageList";
    case Role::kDocPart:
      return "kDocPart";
    case Role::kDocPreface:
      return "kDocPreface";
    case Role::kDocPrologue:
      return "kDocPrologue";
    case Role::kDocPullquote:
      return "kDocPullquote";
    case Role::kDocQna:
      return "kDocQna";
    case Role::kDocSubtitle:
      return "kDocSubtitle";
    case Role::kDocTip:
      return "kDocTip";
    case Role::kDocToc:
      return "kDocToc";
    case Role::kDocument:
      return "kDocument";
    case Role::kEmbeddedObject:
      return "kEmbeddedObject";
    case Role::kEmphasis:
      return "kEmphasis";
    case Role::kFeed:
      return "kFeed";
    case Role::kFigcaption:
      return "kFigcaption";
    case Role::kFigure:
      return "kFigure";
    case Role::kFooter:
      return "kFooter";
    case Role::kSectionFooter:
      return "kSectionFooter";
    case Role::kForm:
      return "kForm";
    case Role::kGenericContainer:
      return "kGenericContainer";
    case Role::kGraphicsDocument:
      return "kGraphicsDocument";
    case Role::kGraphicsObject:
      return "kGraphicsObject";
    case Role::kGraphicsSymbol:
      return "kGraphicsSymbol";
    case Role::kGrid:
      return "kGrid";
    case Role::kGroup:
      return "kGroup";
    case Role::kHeader:
      return "kHeader";
    case Role::kSectionHeader:
      return "kSectionHeader";
    case Role::kHeading:
      return "kHeading";
    case Role::kIframe:
      return "kIframe";
    case Role::kIframePresentational:
      return "kIframePresentational";
    case Role::kImage:
      return "kImage";
    case Role::kImeCandidate:
      return "kImeCandidate";
    case Role::kInlineTextBox:
      return "kInlineTextBox";
    case Role::kInputTime:
      return "kInputTime";
    case Role::kKeyboard:
      return "kKeyboard";
    case Role::kLabelText:
      return "kLabelText";
    case Role::kLayoutTable:
      return "kLayoutTable";
    case Role::kLayoutTableCell:
      return "kLayoutTableCell";
    case Role::kLayoutTableRow:
      return "kLayoutTableRow";
    case Role::kLegend:
      return "kLegend";
    case Role::kLineBreak:
      return "kLineBreak";
    case Role::kLink:
      return "kLink";
    case Role::kList:
      return "kList";
    case Role::kListBox:
      return "kListBox";
    case Role::kListBoxOption:
      return "kListBoxOption";
    case Role::kListGrid:
      return "kListGrid";
    case Role::kListItem:
      return "kListItem";
    case Role::kListMarker:
      return "kListMarker";
    case Role::kLog:
      return "kLog";
    case Role::kMain:
      return "kMain";
    case Role::kMark:
      return "kMark";
    case Role::kMarquee:
      return "kMarquee";
    case Role::kMath:
      return "kMath";
    case Role::kMenu:
      return "kMenu";
    case Role::kMenuBar:
      return "kMenuBar";
    case Role::kMenuItem:
      return "kMenuItem";
    case Role::kMenuItemCheckBox:
      return "kMenuItemCheckBox";
    case Role::kMenuItemRadio:
      return "kMenuItemRadio";
    case Role::kMenuListOption:
      return "kMenuListOption";
    case Role::kMenuListPopup:
      return "kMenuListPopup";
    case Role::kMeter:
      return "kMeter";
    case Role::kNavigation:
      return "kNavigation";
    case Role::kNote:
      return "kNote";
    case Role::kPane:
      return "kPane";
    case Role::kParagraph:
      return "kParagraph";
    case Role::kPdfActionableHighlight:
      return "kPdfActionableHighlight";
    case Role::kPdfRoot:
      return "kPdfRoot";
    case Role::kPluginObject:
      return "kPluginObject";
    case Role::kPopUpButton:
      return "kPopUpButton";
    case Role::kPortalDeprecated:
      return "kPortalDeprecated";
    case Role::kPreDeprecated:
      return "kPreDeprecated";
    case Role::kProgressIndicator:
      return "kProgressIndicator";
    case Role::kRadioButton:
      return "kRadioButton";
    case Role::kRadioGroup:
      return "kRadioGroup";
    case Role::kRegion:
      return "kRegion";
    case Role::kRootWebArea:
      return "kRootWebArea";
    case Role::kRow:
      return "kRow";
    case Role::kRowGroup:
      return "kRowGroup";
    case Role::kRowHeader:
      return "kRowHeader";
    case Role::kRuby:
      return "kRuby";
    case Role::kRubyAnnotation:
      return "kRubyAnnotation";
    case Role::kScrollBar:
      return "kScrollBar";
    case Role::kScrollView:
      return "kScrollView";
    case Role::kSearch:
      return "kSearch";
    case Role::kSearchBox:
      return "kSearchBox";
    case Role::kSection:
      return "kSection";
    case Role::kSlider:
      return "kSlider";
    case Role::kSpinButton:
      return "kSpinButton";
    case Role::kSplitter:
      return "kSplitter";
    case Role::kStaticText:
      return "kStaticText";
    case Role::kStatus:
      return "kStatus";
    case Role::kStrong:
      return "kStrong";
    case Role::kSuggestion:
      return "kSuggestion";
    case Role::kSvgRoot:
      return "kSvgRoot";
    case Role::kSwitch:
      return "kSwitch";
    case Role::kTab:
      return "kTab";
    case Role::kTabList:
      return "kTabList";
    case Role::kTabPanel:
      return "kTabPanel";
    case Role::kTable:
      return "kTable";
    case Role::kTableHeaderContainer:
      return "kTableHeaderContainer";
    case Role::kTerm:
      return "kTerm";
    case Role::kTextField:
      return "kTextField";
    case Role::kTextFieldWithComboBox:
      return "kTextFieldWithComboBox";
    case Role::kTime:
      return "kTime";
    case Role::kTimer:
      return "kTimer";
    case Role::kTitleBar:
      return "kTitleBar";
    case Role::kToggleButton:
      return "kToggleButton";
    case Role::kToolbar:
      return "kToolbar";
    case Role::kTooltip:
      return "kTooltip";
    case Role::kTree:
      return "kTree";
    case Role::kTreeGrid:
      return "kTreeGrid";
    case Role::kTreeItem:
      return "kTreeItem";
    case Role::kUnknown:
      return "kUnknown";
    case Role::kVideo:
      return "kVideo";
    case Role::kWebView:
      return "kWebView";
    case Role::kWindow:
      return "kWindow";
    case Role::kSubscript:
      return "kSubscript";
    case Role::kSuperscript:
      return "kSuperscript";
    case Role::kMathMLMath:
      return "kMathMLMath";
    case Role::kMathMLFraction:
      return "kMathMLFraction";
    case Role::kMathMLIdentifier:
      return "kMathMLIdentifier";
    case Role::kMathMLMultiscripts:
      return "kMathMLMultiscripts";
    case Role::kMathMLNoneScript:
      return "kMathMLNoneScript";
    case Role::kMathMLNumber:
      return "kMathMLNumber";
    case Role::kMathMLOperator:
      return "kMathMLOperator";
    case Role::kMathMLOver:
      return "kMathMLOver";
    case Role::kMathMLPrescriptDelimiter:
      return "kMathMLPrescriptDelimiter";
    case Role::kMathMLRoot:
      return "kMathMLRoot";
    case Role::kMathMLRow:
      return "kMathMLRow";
    case Role::kMathMLSquareRoot:
      return "kMathMLSquareRoot";
    case Role::kMathMLStringLiteral:
      return "kMathMLStringLiteral";
    case Role::kMathMLSub:
      return "kMathMLSub";
    case Role::kMathMLSubSup:
      return "kMathMLSubSup";
    case Role::kMathMLSup:
      return "kMathMLSup";
    case Role::kMathMLTable:
      return "kMathMLTable";
    case Role::kMathMLTableCell:
      return "kMathMLTableCell";
    case Role::kMathMLTableRow:
      return "kMathMLTableRow";
    case Role::kMathMLText:
      return "kMathMLText";
    case Role::kMathMLUnder:
      return "kMathMLUnder";
    case Role::kMathMLUnderOver:
      return "kMathMLUnderOver";
    case Role::kComboBoxSelect:
      return "kComboBoxSelect";
    case Role::kDisclosureTriangleGrouped:
      return "kDisclosureTriangleGrouped";
    case Role::kSectionWithoutName:
      return "kSectionWithoutName";
    case Role::kGridCell:
      return "kGridCell";
    case Role::kMenuItemSeparator:
      return "kMenuItemSeparator";
    default:
      return nullptr;
  }
}

std::string RoleToString(Role value) {
  const char *str = RoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Role value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Role value) {
  return os << RoleToString(value);
}

NOINLINE static const char* StateToStringHelper(State value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case State::kNone:
      return "kNone";
    case State::kAutofillAvailable:
      return "kAutofillAvailable";
    case State::kCollapsed:
      return "kCollapsed";
    case State::kDefault:
      return "kDefault";
    case State::kEditable:
      return "kEditable";
    case State::kExpanded:
      return "kExpanded";
    case State::kFocusable:
      return "kFocusable";
    case State::kHorizontal:
      return "kHorizontal";
    case State::kHovered:
      return "kHovered";
    case State::kIgnored:
      return "kIgnored";
    case State::kInvisible:
      return "kInvisible";
    case State::kLinked:
      return "kLinked";
    case State::kMultiline:
      return "kMultiline";
    case State::kMultiselectable:
      return "kMultiselectable";
    case State::kProtected:
      return "kProtected";
    case State::kRequired:
      return "kRequired";
    case State::kRichlyEditable:
      return "kRichlyEditable";
    case State::kVertical:
      return "kVertical";
    case State::kVisited:
      return "kVisited";
    case State::kHasActions:
      return "kHasActions";
    case State::kHasInterestFor:
      return "kHasInterestFor";
    default:
      return nullptr;
  }
}

std::string StateToString(State value) {
  const char *str = StateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown State value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, State value) {
  return os << StateToString(value);
}

NOINLINE static const char* ActionToStringHelper(Action value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Action::kNone:
      return "kNone";
    case Action::kAnnotatePageImages:
      return "kAnnotatePageImages";
    case Action::kBlur:
      return "kBlur";
    case Action::kClearAccessibilityFocus:
      return "kClearAccessibilityFocus";
    case Action::kCollapse:
      return "kCollapse";
    case Action::kCustomAction:
      return "kCustomAction";
    case Action::kDecrement:
      return "kDecrement";
    case Action::kDoDefault:
      return "kDoDefault";
    case Action::kExpand:
      return "kExpand";
    case Action::kFocus:
      return "kFocus";
    case Action::kGetImageData:
      return "kGetImageData";
    case Action::kGetTextLocation:
      return "kGetTextLocation";
    case Action::kHideTooltip:
      return "kHideTooltip";
    case Action::kHitTest:
      return "kHitTest";
    case Action::kIncrement:
      return "kIncrement";
    case Action::kInternalInvalidateTree:
      return "kInternalInvalidateTree";
    case Action::kLoadInlineTextBoxes:
      return "kLoadInlineTextBoxes";
    case Action::kReplaceSelectedText:
      return "kReplaceSelectedText";
    case Action::kScrollBackward:
      return "kScrollBackward";
    case Action::kScrollDown:
      return "kScrollDown";
    case Action::kScrollForward:
      return "kScrollForward";
    case Action::kScrollLeft:
      return "kScrollLeft";
    case Action::kScrollRight:
      return "kScrollRight";
    case Action::kScrollUp:
      return "kScrollUp";
    case Action::kScrollToMakeVisible:
      return "kScrollToMakeVisible";
    case Action::kScrollToPoint:
      return "kScrollToPoint";
    case Action::kSetAccessibilityFocus:
      return "kSetAccessibilityFocus";
    case Action::kSetScrollOffset:
      return "kSetScrollOffset";
    case Action::kSetSelection:
      return "kSetSelection";
    case Action::kSetSequentialFocusNavigationStartingPoint:
      return "kSetSequentialFocusNavigationStartingPoint";
    case Action::kSetValue:
      return "kSetValue";
    case Action::kShowContextMenu:
      return "kShowContextMenu";
    case Action::kSignalEndOfTest:
      return "kSignalEndOfTest";
    case Action::kShowTooltip:
      return "kShowTooltip";
    case Action::kResumeMedia:
      return "kResumeMedia";
    case Action::kStartDuckingMedia:
      return "kStartDuckingMedia";
    case Action::kStopDuckingMedia:
      return "kStopDuckingMedia";
    case Action::kSuspendMedia:
      return "kSuspendMedia";
    case Action::kLongClick:
      return "kLongClick";
    case Action::kScrollToPositionAtRowColumn:
      return "kScrollToPositionAtRowColumn";
    case Action::kStitchChildTree:
      return "kStitchChildTree";
    case Action::kRequestLayoutBasedAction:
      return "kRequestLayoutBasedAction";
    default:
      return nullptr;
  }
}

std::string ActionToString(Action value) {
  const char *str = ActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Action value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Action value) {
  return os << ActionToString(value);
}

NOINLINE static const char* ActionFlagsToStringHelper(ActionFlags value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActionFlags::kNone:
      return "kNone";
    case ActionFlags::kRequestImages:
      return "kRequestImages";
    case ActionFlags::kRequestInlineTextBoxes:
      return "kRequestInlineTextBoxes";
    default:
      return nullptr;
  }
}

std::string ActionFlagsToString(ActionFlags value) {
  const char *str = ActionFlagsToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActionFlags value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActionFlags value) {
  return os << ActionFlagsToString(value);
}

NOINLINE static const char* ScrollAlignmentToStringHelper(ScrollAlignment value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollAlignment::kNone:
      return "kNone";
    case ScrollAlignment::kScrollAlignmentCenter:
      return "kScrollAlignmentCenter";
    case ScrollAlignment::kScrollAlignmentTop:
      return "kScrollAlignmentTop";
    case ScrollAlignment::kScrollAlignmentBottom:
      return "kScrollAlignmentBottom";
    case ScrollAlignment::kScrollAlignmentLeft:
      return "kScrollAlignmentLeft";
    case ScrollAlignment::kScrollAlignmentRight:
      return "kScrollAlignmentRight";
    case ScrollAlignment::kScrollAlignmentClosestEdge:
      return "kScrollAlignmentClosestEdge";
    default:
      return nullptr;
  }
}

std::string ScrollAlignmentToString(ScrollAlignment value) {
  const char *str = ScrollAlignmentToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollAlignment value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollAlignment value) {
  return os << ScrollAlignmentToString(value);
}

NOINLINE static const char* ScrollBehaviorToStringHelper(ScrollBehavior value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollBehavior::kNone:
      return "kNone";
    case ScrollBehavior::kDoNotScrollIfVisible:
      return "kDoNotScrollIfVisible";
    case ScrollBehavior::kScrollIfVisible:
      return "kScrollIfVisible";
    default:
      return nullptr;
  }
}

std::string ScrollBehaviorToString(ScrollBehavior value) {
  const char *str = ScrollBehaviorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollBehavior value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollBehavior value) {
  return os << ScrollBehaviorToString(value);
}

NOINLINE static const char* DefaultActionVerbToStringHelper(DefaultActionVerb value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DefaultActionVerb::kNone:
      return "kNone";
    case DefaultActionVerb::kActivate:
      return "kActivate";
    case DefaultActionVerb::kCheck:
      return "kCheck";
    case DefaultActionVerb::kClick:
      return "kClick";
    case DefaultActionVerb::kClickAncestor:
      return "kClickAncestor";
    case DefaultActionVerb::kClickInHitTest:
      return "kClickInHitTest";
    case DefaultActionVerb::kClickNotInHitTest:
      return "kClickNotInHitTest";
    case DefaultActionVerb::kJump:
      return "kJump";
    case DefaultActionVerb::kOpen:
      return "kOpen";
    case DefaultActionVerb::kPress:
      return "kPress";
    case DefaultActionVerb::kSelect:
      return "kSelect";
    case DefaultActionVerb::kUncheck:
      return "kUncheck";
    default:
      return nullptr;
  }
}

std::string DefaultActionVerbToString(DefaultActionVerb value) {
  const char *str = DefaultActionVerbToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DefaultActionVerb value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DefaultActionVerb value) {
  return os << DefaultActionVerbToString(value);
}

NOINLINE static const char* MutationToStringHelper(Mutation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Mutation::kNone:
      return "kNone";
    case Mutation::kNodeCreated:
      return "kNodeCreated";
    case Mutation::kSubtreeCreated:
      return "kSubtreeCreated";
    case Mutation::kNodeChanged:
      return "kNodeChanged";
    case Mutation::kNodeRemoved:
      return "kNodeRemoved";
    case Mutation::kTextChanged:
      return "kTextChanged";
    case Mutation::kSubtreeUpdateEnd:
      return "kSubtreeUpdateEnd";
    default:
      return nullptr;
  }
}

std::string MutationToString(Mutation value) {
  const char *str = MutationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Mutation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Mutation value) {
  return os << MutationToString(value);
}

NOINLINE static const char* StringAttributeToStringHelper(StringAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StringAttribute::kNone:
      return "kNone";
    case StringAttribute::kAccessKey:
      return "kAccessKey";
    case StringAttribute::kAppId:
      return "kAppId";
    case StringAttribute::kAriaInvalidValueDeprecated:
      return "kAriaInvalidValueDeprecated";
    case StringAttribute::kAutoComplete:
      return "kAutoComplete";
    case StringAttribute::kCheckedStateDescription:
      return "kCheckedStateDescription";
    case StringAttribute::kChildTreeId:
      return "kChildTreeId";
    case StringAttribute::kChildTreeNodeAppId:
      return "kChildTreeNodeAppId";
    case StringAttribute::kClassName:
      return "kClassName";
    case StringAttribute::kContainerLiveRelevant:
      return "kContainerLiveRelevant";
    case StringAttribute::kContainerLiveStatus:
      return "kContainerLiveStatus";
    case StringAttribute::kDescription:
      return "kDescription";
    case StringAttribute::kDisplay:
      return "kDisplay";
    case StringAttribute::kFontFamily:
      return "kFontFamily";
    case StringAttribute::kHtmlTag:
      return "kHtmlTag";
    case StringAttribute::kImageAnnotation:
      return "kImageAnnotation";
    case StringAttribute::kImageDataUrl:
      return "kImageDataUrl";
    case StringAttribute::kMathContent:
      return "kMathContent";
    case StringAttribute::kInputType:
      return "kInputType";
    case StringAttribute::kKeyShortcuts:
      return "kKeyShortcuts";
    case StringAttribute::kLanguage:
      return "kLanguage";
    case StringAttribute::kName:
      return "kName";
    case StringAttribute::kLiveRelevant:
      return "kLiveRelevant";
    case StringAttribute::kLiveStatus:
      return "kLiveStatus";
    case StringAttribute::kPlaceholder:
      return "kPlaceholder";
    case StringAttribute::kRole:
      return "kRole";
    case StringAttribute::kRoleDescription:
      return "kRoleDescription";
    case StringAttribute::kTooltip:
      return "kTooltip";
    case StringAttribute::kUrl:
      return "kUrl";
    case StringAttribute::kValue:
      return "kValue";
    case StringAttribute::kVirtualContent:
      return "kVirtualContent";
    case StringAttribute::kDoDefaultLabel:
      return "kDoDefaultLabel";
    case StringAttribute::kLongClickLabel:
      return "kLongClickLabel";
    case StringAttribute::kAriaBrailleLabel:
      return "kAriaBrailleLabel";
    case StringAttribute::kAriaBrailleRoleDescription:
      return "kAriaBrailleRoleDescription";
    case StringAttribute::kLinkTarget:
      return "kLinkTarget";
    case StringAttribute::kAriaNotificationAnnouncementDeprecated:
      return "kAriaNotificationAnnouncementDeprecated";
    case StringAttribute::kAriaNotificationIdDeprecated:
      return "kAriaNotificationIdDeprecated";
    case StringAttribute::kHtmlId:
      return "kHtmlId";
    case StringAttribute::kAriaCellColumnIndexText:
      return "kAriaCellColumnIndexText";
    case StringAttribute::kAriaCellRowIndexText:
      return "kAriaCellRowIndexText";
    case StringAttribute::kDateTime:
      return "kDateTime";
    case StringAttribute::kHtmlInputName:
      return "kHtmlInputName";
    default:
      return nullptr;
  }
}

std::string StringAttributeToString(StringAttribute value) {
  const char *str = StringAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StringAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StringAttribute value) {
  return os << StringAttributeToString(value);
}

NOINLINE static const char* IntAttributeToStringHelper(IntAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IntAttribute::kNone:
      return "kNone";
    case IntAttribute::kDefaultActionVerb:
      return "kDefaultActionVerb";
    case IntAttribute::kScrollX:
      return "kScrollX";
    case IntAttribute::kScrollXMin:
      return "kScrollXMin";
    case IntAttribute::kScrollXMax:
      return "kScrollXMax";
    case IntAttribute::kScrollY:
      return "kScrollY";
    case IntAttribute::kScrollYMin:
      return "kScrollYMin";
    case IntAttribute::kScrollYMax:
      return "kScrollYMax";
    case IntAttribute::kTextSelStart:
      return "kTextSelStart";
    case IntAttribute::kTextSelEnd:
      return "kTextSelEnd";
    case IntAttribute::kAriaColumnCount:
      return "kAriaColumnCount";
    case IntAttribute::kAriaCellColumnIndex:
      return "kAriaCellColumnIndex";
    case IntAttribute::kAriaCellColumnSpan:
      return "kAriaCellColumnSpan";
    case IntAttribute::kAriaRowCount:
      return "kAriaRowCount";
    case IntAttribute::kAriaCellRowIndex:
      return "kAriaCellRowIndex";
    case IntAttribute::kAriaCellRowSpan:
      return "kAriaCellRowSpan";
    case IntAttribute::kTableRowCount:
      return "kTableRowCount";
    case IntAttribute::kTableColumnCount:
      return "kTableColumnCount";
    case IntAttribute::kTableHeaderId:
      return "kTableHeaderId";
    case IntAttribute::kTableRowIndex:
      return "kTableRowIndex";
    case IntAttribute::kTableRowHeaderId:
      return "kTableRowHeaderId";
    case IntAttribute::kTableColumnIndex:
      return "kTableColumnIndex";
    case IntAttribute::kTableColumnHeaderId:
      return "kTableColumnHeaderId";
    case IntAttribute::kTableCellColumnIndex:
      return "kTableCellColumnIndex";
    case IntAttribute::kTableCellColumnSpan:
      return "kTableCellColumnSpan";
    case IntAttribute::kTableCellRowIndex:
      return "kTableCellRowIndex";
    case IntAttribute::kTableCellRowSpan:
      return "kTableCellRowSpan";
    case IntAttribute::kSortDirection:
      return "kSortDirection";
    case IntAttribute::kHierarchicalLevel:
      return "kHierarchicalLevel";
    case IntAttribute::kNameFrom:
      return "kNameFrom";
    case IntAttribute::kDescriptionFrom:
      return "kDescriptionFrom";
    case IntAttribute::kActivedescendantId:
      return "kActivedescendantId";
    case IntAttribute::kErrormessageIdDeprecated:
      return "kErrormessageIdDeprecated";
    case IntAttribute::kInPageLinkTargetId:
      return "kInPageLinkTargetId";
    case IntAttribute::kMemberOfId:
      return "kMemberOfId";
    case IntAttribute::kNextOnLineId:
      return "kNextOnLineId";
    case IntAttribute::kPopupForId:
      return "kPopupForId";
    case IntAttribute::kPreviousOnLineId:
      return "kPreviousOnLineId";
    case IntAttribute::kRestriction:
      return "kRestriction";
    case IntAttribute::kSetSize:
      return "kSetSize";
    case IntAttribute::kPosInSet:
      return "kPosInSet";
    case IntAttribute::kColorValue:
      return "kColorValue";
    case IntAttribute::kAriaCurrentState:
      return "kAriaCurrentState";
    case IntAttribute::kBackgroundColor:
      return "kBackgroundColor";
    case IntAttribute::kColor:
      return "kColor";
    case IntAttribute::kHasPopup:
      return "kHasPopup";
    case IntAttribute::kImageAnnotationStatus:
      return "kImageAnnotationStatus";
    case IntAttribute::kInvalidState:
      return "kInvalidState";
    case IntAttribute::kCheckedState:
      return "kCheckedState";
    case IntAttribute::kListStyle:
      return "kListStyle";
    case IntAttribute::kTextAlign:
      return "kTextAlign";
    case IntAttribute::kTextDirection:
      return "kTextDirection";
    case IntAttribute::kTextPosition:
      return "kTextPosition";
    case IntAttribute::kTextStyle:
      return "kTextStyle";
    case IntAttribute::kTextOverlineStyle:
      return "kTextOverlineStyle";
    case IntAttribute::kTextStrikethroughStyle:
      return "kTextStrikethroughStyle";
    case IntAttribute::kTextUnderlineStyle:
      return "kTextUnderlineStyle";
    case IntAttribute::kPreviousFocusId:
      return "kPreviousFocusId";
    case IntAttribute::kNextFocusId:
      return "kNextFocusId";
    case IntAttribute::kDropeffectDeprecated:
      return "kDropeffectDeprecated";
    case IntAttribute::kDOMNodeIdDeprecated:
      return "kDOMNodeIdDeprecated";
    case IntAttribute::kIsPopup:
      return "kIsPopup";
    case IntAttribute::kNextWindowFocusId:
      return "kNextWindowFocusId";
    case IntAttribute::kPreviousWindowFocusId:
      return "kPreviousWindowFocusId";
    case IntAttribute::kAriaNotificationInterruptDeprecated:
      return "kAriaNotificationInterruptDeprecated";
    case IntAttribute::kAriaNotificationPriorityDeprecated:
      return "kAriaNotificationPriorityDeprecated";
    case IntAttribute::kDetailsFrom:
      return "kDetailsFrom";
    case IntAttribute::kMaxLength:
      return "kMaxLength";
    case IntAttribute::kPaintOrder:
      return "kPaintOrder";
    default:
      return nullptr;
  }
}

std::string IntAttributeToString(IntAttribute value) {
  const char *str = IntAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IntAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IntAttribute value) {
  return os << IntAttributeToString(value);
}

NOINLINE static const char* FloatAttributeToStringHelper(FloatAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FloatAttribute::kNone:
      return "kNone";
    case FloatAttribute::kValueForRange:
      return "kValueForRange";
    case FloatAttribute::kMinValueForRange:
      return "kMinValueForRange";
    case FloatAttribute::kMaxValueForRange:
      return "kMaxValueForRange";
    case FloatAttribute::kStepValueForRange:
      return "kStepValueForRange";
    case FloatAttribute::kFontSize:
      return "kFontSize";
    case FloatAttribute::kFontWeight:
      return "kFontWeight";
    case FloatAttribute::kTextIndent:
      return "kTextIndent";
    case FloatAttribute::kChildTreeScale:
      return "kChildTreeScale";
    default:
      return nullptr;
  }
}

std::string FloatAttributeToString(FloatAttribute value) {
  const char *str = FloatAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FloatAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FloatAttribute value) {
  return os << FloatAttributeToString(value);
}

NOINLINE static const char* BoolAttributeToStringHelper(BoolAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BoolAttribute::kNone:
      return "kNone";
    case BoolAttribute::kBusy:
      return "kBusy";
    case BoolAttribute::kNonAtomicTextFieldRoot:
      return "kNonAtomicTextFieldRoot";
    case BoolAttribute::kContainerLiveAtomic:
      return "kContainerLiveAtomic";
    case BoolAttribute::kContainerLiveBusy:
      return "kContainerLiveBusy";
    case BoolAttribute::kLiveAtomic:
      return "kLiveAtomic";
    case BoolAttribute::kModal:
      return "kModal";
    case BoolAttribute::kUpdateLocationOnly:
      return "kUpdateLocationOnly";
    case BoolAttribute::kCanvasHasFallback:
      return "kCanvasHasFallback";
    case BoolAttribute::kScrollable:
      return "kScrollable";
    case BoolAttribute::kClickable:
      return "kClickable";
    case BoolAttribute::kClipsChildren:
      return "kClipsChildren";
    case BoolAttribute::kNotUserSelectableStyle:
      return "kNotUserSelectableStyle";
    case BoolAttribute::kSelected:
      return "kSelected";
    case BoolAttribute::kSelectedFromFocus:
      return "kSelectedFromFocus";
    case BoolAttribute::kSupportsTextLocation:
      return "kSupportsTextLocation";
    case BoolAttribute::kGrabbedDeprecated:
      return "kGrabbedDeprecated";
    case BoolAttribute::kIsLineBreakingObject:
      return "kIsLineBreakingObject";
    case BoolAttribute::kIsPageBreakingObject:
      return "kIsPageBreakingObject";
    case BoolAttribute::kHasAriaAttribute:
      return "kHasAriaAttribute";
    case BoolAttribute::kTouchPassthroughDeprecated:
      return "kTouchPassthroughDeprecated";
    case BoolAttribute::kLongClickable:
      return "kLongClickable";
    case BoolAttribute::kHasHiddenOffscreenNodes:
      return "kHasHiddenOffscreenNodes";
    default:
      return nullptr;
  }
}

std::string BoolAttributeToString(BoolAttribute value) {
  const char *str = BoolAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BoolAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BoolAttribute value) {
  return os << BoolAttributeToString(value);
}

NOINLINE static const char* IntListAttributeToStringHelper(IntListAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IntListAttribute::kNone:
      return "kNone";
    case IntListAttribute::kIndirectChildIds:
      return "kIndirectChildIds";
    case IntListAttribute::kControlsIds:
      return "kControlsIds";
    case IntListAttribute::kDetailsIds:
      return "kDetailsIds";
    case IntListAttribute::kDescribedbyIds:
      return "kDescribedbyIds";
    case IntListAttribute::kFlowtoIds:
      return "kFlowtoIds";
    case IntListAttribute::kLabelledbyIds:
      return "kLabelledbyIds";
    case IntListAttribute::kRadioGroupIds:
      return "kRadioGroupIds";
    case IntListAttribute::kMarkerTypes:
      return "kMarkerTypes";
    case IntListAttribute::kMarkerStarts:
      return "kMarkerStarts";
    case IntListAttribute::kMarkerEnds:
      return "kMarkerEnds";
    case IntListAttribute::kCharacterOffsets:
      return "kCharacterOffsets";
    case IntListAttribute::kLineStarts:
      return "kLineStarts";
    case IntListAttribute::kWordStarts:
      return "kWordStarts";
    case IntListAttribute::kWordEnds:
      return "kWordEnds";
    case IntListAttribute::kCustomActionIds:
      return "kCustomActionIds";
    case IntListAttribute::kCaretBounds:
      return "kCaretBounds";
    case IntListAttribute::kLineEnds:
      return "kLineEnds";
    case IntListAttribute::kSentenceStarts:
      return "kSentenceStarts";
    case IntListAttribute::kSentenceEnds:
      return "kSentenceEnds";
    case IntListAttribute::kHighlightTypes:
      return "kHighlightTypes";
    case IntListAttribute::kTextOperationStartAnchorIds:
      return "kTextOperationStartAnchorIds";
    case IntListAttribute::kTextOperationStartOffsets:
      return "kTextOperationStartOffsets";
    case IntListAttribute::kTextOperationEndAnchorIds:
      return "kTextOperationEndAnchorIds";
    case IntListAttribute::kTextOperationEndOffsets:
      return "kTextOperationEndOffsets";
    case IntListAttribute::kTextOperations:
      return "kTextOperations";
    case IntListAttribute::kErrormessageIds:
      return "kErrormessageIds";
    case IntListAttribute::kAriaNotificationInterruptProperties:
      return "kAriaNotificationInterruptProperties";
    case IntListAttribute::kAriaNotificationPriorityProperties:
      return "kAriaNotificationPriorityProperties";
    case IntListAttribute::kActionsIds:
      return "kActionsIds";
    default:
      return nullptr;
  }
}

std::string IntListAttributeToString(IntListAttribute value) {
  const char *str = IntListAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IntListAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IntListAttribute value) {
  return os << IntListAttributeToString(value);
}

NOINLINE static const char* StringListAttributeToStringHelper(StringListAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StringListAttribute::kNone:
      return "kNone";
    case StringListAttribute::kCustomActionDescriptions:
      return "kCustomActionDescriptions";
    case StringListAttribute::kAriaNotificationAnnouncements:
      return "kAriaNotificationAnnouncements";
    case StringListAttribute::kAriaNotificationTypes:
      return "kAriaNotificationTypes";
    default:
      return nullptr;
  }
}

std::string StringListAttributeToString(StringListAttribute value) {
  const char *str = StringListAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StringListAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StringListAttribute value) {
  return os << StringListAttributeToString(value);
}

NOINLINE static const char* ListStyleToStringHelper(ListStyle value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ListStyle::kNone:
      return "kNone";
    case ListStyle::kCircle:
      return "kCircle";
    case ListStyle::kDisc:
      return "kDisc";
    case ListStyle::kImage:
      return "kImage";
    case ListStyle::kNumeric:
      return "kNumeric";
    case ListStyle::kSquare:
      return "kSquare";
    case ListStyle::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string ListStyleToString(ListStyle value) {
  const char *str = ListStyleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ListStyle value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ListStyle value) {
  return os << ListStyleToString(value);
}

NOINLINE static const char* MarkerTypeToStringHelper(MarkerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MarkerType::kNone:
      return "kNone";
    case MarkerType::kSpelling:
      return "kSpelling";
    case MarkerType::kGrammar:
      return "kGrammar";
    case MarkerType::kTextMatch:
      return "kTextMatch";
    case MarkerType::kActiveSuggestion:
      return "kActiveSuggestion";
    case MarkerType::kSuggestion:
      return "kSuggestion";
    case MarkerType::kHighlight:
      return "kHighlight";
    default:
      return nullptr;
  }
}

std::string MarkerTypeToString(MarkerType value) {
  const char *str = MarkerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MarkerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MarkerType value) {
  return os << MarkerTypeToString(value);
}

NOINLINE static const char* HighlightTypeToStringHelper(HighlightType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HighlightType::kNone:
      return "kNone";
    case HighlightType::kHighlight:
      return "kHighlight";
    case HighlightType::kSpellingError:
      return "kSpellingError";
    case HighlightType::kGrammarError:
      return "kGrammarError";
    default:
      return nullptr;
  }
}

std::string HighlightTypeToString(HighlightType value) {
  const char *str = HighlightTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HighlightType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HighlightType value) {
  return os << HighlightTypeToString(value);
}

NOINLINE static const char* MoveDirectionToStringHelper(MoveDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MoveDirection::kNone:
      return "kNone";
    case MoveDirection::kBackward:
      return "kBackward";
    case MoveDirection::kForward:
      return "kForward";
    default:
      return nullptr;
  }
}

std::string MoveDirectionToString(MoveDirection value) {
  const char *str = MoveDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MoveDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MoveDirection value) {
  return os << MoveDirectionToString(value);
}

NOINLINE static const char* CommandToStringHelper(Command value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Command::kNone:
      return "kNone";
    case Command::kClearSelection:
      return "kClearSelection";
    case Command::kDelete:
      return "kDelete";
    case Command::kDictate:
      return "kDictate";
    case Command::kExtendSelection:
      return "kExtendSelection";
    case Command::kFormat:
      return "kFormat";
    case Command::kHistory:
      return "kHistory";
    case Command::kInsert:
      return "kInsert";
    case Command::kMarker:
      return "kMarker";
    case Command::kMoveSelection:
      return "kMoveSelection";
    case Command::kSetSelection:
      return "kSetSelection";
    default:
      return nullptr;
  }
}

std::string CommandToString(Command value) {
  const char *str = CommandToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Command value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Command value) {
  return os << CommandToString(value);
}

NOINLINE static const char* InputEventTypeToStringHelper(InputEventType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputEventType::kNone:
      return "kNone";
    case InputEventType::kInsertText:
      return "kInsertText";
    case InputEventType::kInsertLineBreak:
      return "kInsertLineBreak";
    case InputEventType::kInsertParagraph:
      return "kInsertParagraph";
    case InputEventType::kInsertOrderedList:
      return "kInsertOrderedList";
    case InputEventType::kInsertUnorderedList:
      return "kInsertUnorderedList";
    case InputEventType::kInsertHorizontalRule:
      return "kInsertHorizontalRule";
    case InputEventType::kInsertFromPaste:
      return "kInsertFromPaste";
    case InputEventType::kInsertFromDrop:
      return "kInsertFromDrop";
    case InputEventType::kInsertFromYank:
      return "kInsertFromYank";
    case InputEventType::kInsertTranspose:
      return "kInsertTranspose";
    case InputEventType::kInsertReplacementText:
      return "kInsertReplacementText";
    case InputEventType::kInsertCompositionText:
      return "kInsertCompositionText";
    case InputEventType::kDeleteWordBackward:
      return "kDeleteWordBackward";
    case InputEventType::kDeleteWordForward:
      return "kDeleteWordForward";
    case InputEventType::kDeleteSoftLineBackward:
      return "kDeleteSoftLineBackward";
    case InputEventType::kDeleteSoftLineForward:
      return "kDeleteSoftLineForward";
    case InputEventType::kDeleteHardLineBackward:
      return "kDeleteHardLineBackward";
    case InputEventType::kDeleteHardLineForward:
      return "kDeleteHardLineForward";
    case InputEventType::kDeleteContentBackward:
      return "kDeleteContentBackward";
    case InputEventType::kDeleteContentForward:
      return "kDeleteContentForward";
    case InputEventType::kDeleteByCut:
      return "kDeleteByCut";
    case InputEventType::kDeleteByDrag:
      return "kDeleteByDrag";
    case InputEventType::kHistoryUndo:
      return "kHistoryUndo";
    case InputEventType::kHistoryRedo:
      return "kHistoryRedo";
    case InputEventType::kFormatBold:
      return "kFormatBold";
    case InputEventType::kFormatItalic:
      return "kFormatItalic";
    case InputEventType::kFormatUnderline:
      return "kFormatUnderline";
    case InputEventType::kFormatStrikeThrough:
      return "kFormatStrikeThrough";
    case InputEventType::kFormatSuperscript:
      return "kFormatSuperscript";
    case InputEventType::kFormatSubscript:
      return "kFormatSubscript";
    case InputEventType::kFormatJustifyCenter:
      return "kFormatJustifyCenter";
    case InputEventType::kFormatJustifyFull:
      return "kFormatJustifyFull";
    case InputEventType::kFormatJustifyRight:
      return "kFormatJustifyRight";
    case InputEventType::kFormatJustifyLeft:
      return "kFormatJustifyLeft";
    case InputEventType::kFormatIndent:
      return "kFormatIndent";
    case InputEventType::kFormatOutdent:
      return "kFormatOutdent";
    case InputEventType::kFormatRemove:
      return "kFormatRemove";
    case InputEventType::kFormatSetBlockTextDirection:
      return "kFormatSetBlockTextDirection";
    case InputEventType::kInsertLink:
      return "kInsertLink";
    default:
      return nullptr;
  }
}

std::string InputEventTypeToString(InputEventType value) {
  const char *str = InputEventTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputEventType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputEventType value) {
  return os << InputEventTypeToString(value);
}

NOINLINE static const char* TextBoundaryToStringHelper(TextBoundary value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextBoundary::kNone:
      return "kNone";
    case TextBoundary::kCharacter:
      return "kCharacter";
    case TextBoundary::kFormatEnd:
      return "kFormatEnd";
    case TextBoundary::kLineEnd:
      return "kLineEnd";
    case TextBoundary::kLineStart:
      return "kLineStart";
    case TextBoundary::kLineStartOrEnd:
      return "kLineStartOrEnd";
    case TextBoundary::kObject:
      return "kObject";
    case TextBoundary::kPageEnd:
      return "kPageEnd";
    case TextBoundary::kPageStart:
      return "kPageStart";
    case TextBoundary::kPageStartOrEnd:
      return "kPageStartOrEnd";
    case TextBoundary::kParagraphEnd:
      return "kParagraphEnd";
    case TextBoundary::kParagraphStart:
      return "kParagraphStart";
    case TextBoundary::kParagraphStartOrEnd:
      return "kParagraphStartOrEnd";
    case TextBoundary::kSentenceEnd:
      return "kSentenceEnd";
    case TextBoundary::kSentenceStart:
      return "kSentenceStart";
    case TextBoundary::kSentenceStartOrEnd:
      return "kSentenceStartOrEnd";
    case TextBoundary::kWebPage:
      return "kWebPage";
    case TextBoundary::kWordEnd:
      return "kWordEnd";
    case TextBoundary::kWordStart:
      return "kWordStart";
    case TextBoundary::kWordStartOrEnd:
      return "kWordStartOrEnd";
    case TextBoundary::kParagraphStartSkippingEmptyParagraphs:
      return "kParagraphStartSkippingEmptyParagraphs";
    case TextBoundary::kFormatStart:
      return "kFormatStart";
    case TextBoundary::kFormatStartOrEnd:
      return "kFormatStartOrEnd";
    default:
      return nullptr;
  }
}

std::string TextBoundaryToString(TextBoundary value) {
  const char *str = TextBoundaryToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextBoundary value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextBoundary value) {
  return os << TextBoundaryToString(value);
}

NOINLINE static const char* TextAlignToStringHelper(TextAlign value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextAlign::kNone:
      return "kNone";
    case TextAlign::kLeft:
      return "kLeft";
    case TextAlign::kRight:
      return "kRight";
    case TextAlign::kCenter:
      return "kCenter";
    case TextAlign::kJustify:
      return "kJustify";
    default:
      return nullptr;
  }
}

std::string TextAlignToString(TextAlign value) {
  const char *str = TextAlignToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextAlign value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextAlign value) {
  return os << TextAlignToString(value);
}

NOINLINE static const char* WritingDirectionToStringHelper(WritingDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WritingDirection::kNone:
      return "kNone";
    case WritingDirection::kLtr:
      return "kLtr";
    case WritingDirection::kRtl:
      return "kRtl";
    case WritingDirection::kTtb:
      return "kTtb";
    case WritingDirection::kBtt:
      return "kBtt";
    default:
      return nullptr;
  }
}

std::string WritingDirectionToString(WritingDirection value) {
  const char *str = WritingDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WritingDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WritingDirection value) {
  return os << WritingDirectionToString(value);
}

NOINLINE static const char* TextPositionToStringHelper(TextPosition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextPosition::kNone:
      return "kNone";
    case TextPosition::kSubscript:
      return "kSubscript";
    case TextPosition::kSuperscript:
      return "kSuperscript";
    default:
      return nullptr;
  }
}

std::string TextPositionToString(TextPosition value) {
  const char *str = TextPositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextPosition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextPosition value) {
  return os << TextPositionToString(value);
}

NOINLINE static const char* TextStyleToStringHelper(TextStyle value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextStyle::kNone:
      return "kNone";
    case TextStyle::kBold:
      return "kBold";
    case TextStyle::kItalic:
      return "kItalic";
    case TextStyle::kUnderline:
      return "kUnderline";
    case TextStyle::kLineThrough:
      return "kLineThrough";
    case TextStyle::kOverline:
      return "kOverline";
    default:
      return nullptr;
  }
}

std::string TextStyleToString(TextStyle value) {
  const char *str = TextStyleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextStyle value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextStyle value) {
  return os << TextStyleToString(value);
}

NOINLINE static const char* TextDecorationStyleToStringHelper(TextDecorationStyle value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextDecorationStyle::kNone:
      return "kNone";
    case TextDecorationStyle::kDotted:
      return "kDotted";
    case TextDecorationStyle::kDashed:
      return "kDashed";
    case TextDecorationStyle::kSolid:
      return "kSolid";
    case TextDecorationStyle::kDouble:
      return "kDouble";
    case TextDecorationStyle::kWavy:
      return "kWavy";
    default:
      return nullptr;
  }
}

std::string TextDecorationStyleToString(TextDecorationStyle value) {
  const char *str = TextDecorationStyleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextDecorationStyle value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextDecorationStyle value) {
  return os << TextDecorationStyleToString(value);
}

NOINLINE static const char* AriaCurrentStateToStringHelper(AriaCurrentState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AriaCurrentState::kNone:
      return "kNone";
    case AriaCurrentState::kFalse:
      return "kFalse";
    case AriaCurrentState::kTrue:
      return "kTrue";
    case AriaCurrentState::kPage:
      return "kPage";
    case AriaCurrentState::kStep:
      return "kStep";
    case AriaCurrentState::kLocation:
      return "kLocation";
    case AriaCurrentState::kDate:
      return "kDate";
    case AriaCurrentState::kTime:
      return "kTime";
    default:
      return nullptr;
  }
}

std::string AriaCurrentStateToString(AriaCurrentState value) {
  const char *str = AriaCurrentStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AriaCurrentState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AriaCurrentState value) {
  return os << AriaCurrentStateToString(value);
}

NOINLINE static const char* HasPopupToStringHelper(HasPopup value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HasPopup::kFalse:
      return "{kFalse, kNone}";
    case HasPopup::kTrue:
      return "kTrue";
    case HasPopup::kMenu:
      return "kMenu";
    case HasPopup::kListbox:
      return "kListbox";
    case HasPopup::kTree:
      return "kTree";
    case HasPopup::kGrid:
      return "kGrid";
    case HasPopup::kDialog:
      return "kDialog";
    default:
      return nullptr;
  }
}

std::string HasPopupToString(HasPopup value) {
  const char *str = HasPopupToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HasPopup value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HasPopup value) {
  return os << HasPopupToString(value);
}

NOINLINE static const char* IsPopupToStringHelper(IsPopup value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IsPopup::kNone:
      return "kNone";
    case IsPopup::kManual:
      return "kManual";
    case IsPopup::kAuto:
      return "kAuto";
    case IsPopup::kHint:
      return "kHint";
    default:
      return nullptr;
  }
}

std::string IsPopupToString(IsPopup value) {
  const char *str = IsPopupToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IsPopup value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IsPopup value) {
  return os << IsPopupToString(value);
}

NOINLINE static const char* InvalidStateToStringHelper(InvalidState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InvalidState::kNone:
      return "kNone";
    case InvalidState::kFalse:
      return "kFalse";
    case InvalidState::kTrue:
      return "kTrue";
    default:
      return nullptr;
  }
}

std::string InvalidStateToString(InvalidState value) {
  const char *str = InvalidStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InvalidState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InvalidState value) {
  return os << InvalidStateToString(value);
}

NOINLINE static const char* RestrictionToStringHelper(Restriction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Restriction::kNone:
      return "kNone";
    case Restriction::kReadOnly:
      return "kReadOnly";
    case Restriction::kDisabled:
      return "kDisabled";
    default:
      return nullptr;
  }
}

std::string RestrictionToString(Restriction value) {
  const char *str = RestrictionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Restriction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Restriction value) {
  return os << RestrictionToString(value);
}

NOINLINE static const char* CheckedStateToStringHelper(CheckedState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CheckedState::kNone:
      return "kNone";
    case CheckedState::kFalse:
      return "kFalse";
    case CheckedState::kTrue:
      return "kTrue";
    case CheckedState::kMixed:
      return "kMixed";
    default:
      return nullptr;
  }
}

std::string CheckedStateToString(CheckedState value) {
  const char *str = CheckedStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CheckedState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CheckedState value) {
  return os << CheckedStateToString(value);
}

NOINLINE static const char* SortDirectionToStringHelper(SortDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SortDirection::kNone:
      return "kNone";
    case SortDirection::kUnsorted:
      return "kUnsorted";
    case SortDirection::kAscending:
      return "kAscending";
    case SortDirection::kDescending:
      return "kDescending";
    case SortDirection::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string SortDirectionToString(SortDirection value) {
  const char *str = SortDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SortDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SortDirection value) {
  return os << SortDirectionToString(value);
}

NOINLINE static const char* NameFromToStringHelper(NameFrom value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NameFrom::kNone:
      return "kNone";
    case NameFrom::kAttribute:
      return "kAttribute";
    case NameFrom::kAttributeExplicitlyEmpty:
      return "kAttributeExplicitlyEmpty";
    case NameFrom::kCaption:
      return "kCaption";
    case NameFrom::kContents:
      return "kContents";
    case NameFrom::kCssAltText:
      return "kCssAltText";
    case NameFrom::kPlaceholder:
      return "kPlaceholder";
    case NameFrom::kRelatedElement:
      return "kRelatedElement";
    case NameFrom::kProhibited:
      return "kProhibited";
    case NameFrom::kProhibitedAndRedundant:
      return "kProhibitedAndRedundant";
    case NameFrom::kTitle:
      return "kTitle";
    case NameFrom::kValue:
      return "kValue";
    case NameFrom::kPopoverTarget:
      return "kPopoverTarget";
    case NameFrom::kInterestFor:
      return "kInterestFor";
    default:
      return nullptr;
  }
}

std::string NameFromToString(NameFrom value) {
  const char *str = NameFromToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NameFrom value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NameFrom value) {
  return os << NameFromToString(value);
}

NOINLINE static const char* DescriptionFromToStringHelper(DescriptionFrom value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DescriptionFrom::kNone:
      return "kNone";
    case DescriptionFrom::kAriaDescription:
      return "kAriaDescription";
    case DescriptionFrom::kAttributeExplicitlyEmpty:
      return "kAttributeExplicitlyEmpty";
    case DescriptionFrom::kButtonLabel:
      return "kButtonLabel";
    case DescriptionFrom::kRelatedElement:
      return "kRelatedElement";
    case DescriptionFrom::kRubyAnnotation:
      return "kRubyAnnotation";
    case DescriptionFrom::kProhibitedNameRepair:
      return "kProhibitedNameRepair";
    case DescriptionFrom::kSummary:
      return "kSummary";
    case DescriptionFrom::kSvgDescElement:
      return "kSvgDescElement";
    case DescriptionFrom::kTableCaption:
      return "kTableCaption";
    case DescriptionFrom::kTitle:
      return "kTitle";
    case DescriptionFrom::kPopoverTarget:
      return "kPopoverTarget";
    case DescriptionFrom::kInterestFor:
      return "kInterestFor";
    default:
      return nullptr;
  }
}

std::string DescriptionFromToString(DescriptionFrom value) {
  const char *str = DescriptionFromToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DescriptionFrom value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DescriptionFrom value) {
  return os << DescriptionFromToString(value);
}

NOINLINE static const char* DetailsFromToStringHelper(DetailsFrom value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DetailsFrom::kAriaDetails:
      return "kAriaDetails";
    case DetailsFrom::kCssAnchor:
      return "kCssAnchor";
    case DetailsFrom::kPopoverTarget:
      return "kPopoverTarget";
    case DetailsFrom::kInterestFor:
      return "kInterestFor";
    case DetailsFrom::kCommandfor:
      return "kCommandfor";
    case DetailsFrom::kCssScrollMarkerPseudoElement:
      return "kCssScrollMarkerPseudoElement";
    default:
      return nullptr;
  }
}

std::string DetailsFromToString(DetailsFrom value) {
  const char *str = DetailsFromToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DetailsFrom value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DetailsFrom value) {
  return os << DetailsFromToString(value);
}

NOINLINE static const char* EventFromToStringHelper(EventFrom value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EventFrom::kNone:
      return "kNone";
    case EventFrom::kUser:
      return "kUser";
    case EventFrom::kPage:
      return "kPage";
    case EventFrom::kAction:
      return "kAction";
    default:
      return nullptr;
  }
}

std::string EventFromToString(EventFrom value) {
  const char *str = EventFromToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EventFrom value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EventFrom value) {
  return os << EventFromToString(value);
}

NOINLINE static const char* GestureToStringHelper(Gesture value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Gesture::kNone:
      return "kNone";
    case Gesture::kClick:
      return "kClick";
    case Gesture::kSwipeLeft1:
      return "kSwipeLeft1";
    case Gesture::kSwipeUp1:
      return "kSwipeUp1";
    case Gesture::kSwipeRight1:
      return "kSwipeRight1";
    case Gesture::kSwipeDown1:
      return "kSwipeDown1";
    case Gesture::kSwipeLeft2:
      return "kSwipeLeft2";
    case Gesture::kSwipeUp2:
      return "kSwipeUp2";
    case Gesture::kSwipeRight2:
      return "kSwipeRight2";
    case Gesture::kSwipeDown2:
      return "kSwipeDown2";
    case Gesture::kSwipeLeft3:
      return "kSwipeLeft3";
    case Gesture::kSwipeUp3:
      return "kSwipeUp3";
    case Gesture::kSwipeRight3:
      return "kSwipeRight3";
    case Gesture::kSwipeDown3:
      return "kSwipeDown3";
    case Gesture::kSwipeLeft4:
      return "kSwipeLeft4";
    case Gesture::kSwipeUp4:
      return "kSwipeUp4";
    case Gesture::kSwipeRight4:
      return "kSwipeRight4";
    case Gesture::kSwipeDown4:
      return "kSwipeDown4";
    case Gesture::kTap2:
      return "kTap2";
    case Gesture::kTap3:
      return "kTap3";
    case Gesture::kTap4:
      return "kTap4";
    case Gesture::kTouchExplore:
      return "kTouchExplore";
    default:
      return nullptr;
  }
}

std::string GestureToString(Gesture value) {
  const char *str = GestureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Gesture value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Gesture value) {
  return os << GestureToString(value);
}

NOINLINE static const char* TextAffinityToStringHelper(TextAffinity value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TextAffinity::kNone:
      return "kNone";
    case TextAffinity::kDownstream:
      return "kDownstream";
    case TextAffinity::kUpstream:
      return "kUpstream";
    default:
      return nullptr;
  }
}

std::string TextAffinityToString(TextAffinity value) {
  const char *str = TextAffinityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TextAffinity value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TextAffinity value) {
  return os << TextAffinityToString(value);
}

NOINLINE static const char* TreeOrderToStringHelper(TreeOrder value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TreeOrder::kNone:
      return "kNone";
    case TreeOrder::kUndefined:
      return "kUndefined";
    case TreeOrder::kBefore:
      return "kBefore";
    case TreeOrder::kEqual:
      return "kEqual";
    case TreeOrder::kAfter:
      return "kAfter";
    default:
      return nullptr;
  }
}

std::string TreeOrderToString(TreeOrder value) {
  const char *str = TreeOrderToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TreeOrder value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TreeOrder value) {
  return os << TreeOrderToString(value);
}

NOINLINE static const char* AXTreeIDTypeToStringHelper(AXTreeIDType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AXTreeIDType::kUnknown:
      return "kUnknown";
    case AXTreeIDType::kToken:
      return "kToken";
    default:
      return nullptr;
  }
}

std::string AXTreeIDTypeToString(AXTreeIDType value) {
  const char *str = AXTreeIDTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AXTreeIDType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AXTreeIDType value) {
  return os << AXTreeIDTypeToString(value);
}

NOINLINE static const char* ImageAnnotationStatusToStringHelper(ImageAnnotationStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageAnnotationStatus::kNone:
      return "kNone";
    case ImageAnnotationStatus::kWillNotAnnotateDueToScheme:
      return "kWillNotAnnotateDueToScheme";
    case ImageAnnotationStatus::kIneligibleForAnnotation:
      return "kIneligibleForAnnotation";
    case ImageAnnotationStatus::kEligibleForAnnotation:
      return "kEligibleForAnnotation";
    case ImageAnnotationStatus::kSilentlyEligibleForAnnotation:
      return "kSilentlyEligibleForAnnotation";
    case ImageAnnotationStatus::kAnnotationPending:
      return "kAnnotationPending";
    case ImageAnnotationStatus::kAnnotationSucceeded:
      return "kAnnotationSucceeded";
    case ImageAnnotationStatus::kAnnotationEmpty:
      return "kAnnotationEmpty";
    case ImageAnnotationStatus::kAnnotationAdult:
      return "kAnnotationAdult";
    case ImageAnnotationStatus::kAnnotationProcessFailed:
      return "kAnnotationProcessFailed";
    default:
      return nullptr;
  }
}

std::string ImageAnnotationStatusToString(ImageAnnotationStatus value) {
  const char *str = ImageAnnotationStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageAnnotationStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageAnnotationStatus value) {
  return os << ImageAnnotationStatusToString(value);
}

NOINLINE static const char* AriaNotificationInterruptToStringHelper(AriaNotificationInterrupt value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AriaNotificationInterrupt::kNone:
      return "kNone";
    case AriaNotificationInterrupt::kAll:
      return "kAll";
    case AriaNotificationInterrupt::kPending:
      return "kPending";
    default:
      return nullptr;
  }
}

std::string AriaNotificationInterruptToString(AriaNotificationInterrupt value) {
  const char *str = AriaNotificationInterruptToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AriaNotificationInterrupt value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AriaNotificationInterrupt value) {
  return os << AriaNotificationInterruptToString(value);
}

NOINLINE static const char* AriaNotificationPriorityToStringHelper(AriaNotificationPriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AriaNotificationPriority::kNormal:
      return "kNormal";
    case AriaNotificationPriority::kHigh:
      return "kHigh";
    default:
      return nullptr;
  }
}

std::string AriaNotificationPriorityToString(AriaNotificationPriority value) {
  const char *str = AriaNotificationPriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AriaNotificationPriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AriaNotificationPriority value) {
  return os << AriaNotificationPriorityToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ax

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Event>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Event value) {
  return std::move(context).WriteString(::ax::mojom::EventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Role>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Role value) {
  return std::move(context).WriteString(::ax::mojom::RoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::State>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::State value) {
  return std::move(context).WriteString(::ax::mojom::StateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Action>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Action value) {
  return std::move(context).WriteString(::ax::mojom::ActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ActionFlags>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::ActionFlags value) {
  return std::move(context).WriteString(::ax::mojom::ActionFlagsToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ScrollAlignment>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::ScrollAlignment value) {
  return std::move(context).WriteString(::ax::mojom::ScrollAlignmentToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ScrollBehavior>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::ScrollBehavior value) {
  return std::move(context).WriteString(::ax::mojom::ScrollBehaviorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::DefaultActionVerb>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::DefaultActionVerb value) {
  return std::move(context).WriteString(::ax::mojom::DefaultActionVerbToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Mutation>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Mutation value) {
  return std::move(context).WriteString(::ax::mojom::MutationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::StringAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::StringAttribute value) {
  return std::move(context).WriteString(::ax::mojom::StringAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::IntAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::IntAttribute value) {
  return std::move(context).WriteString(::ax::mojom::IntAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::FloatAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::FloatAttribute value) {
  return std::move(context).WriteString(::ax::mojom::FloatAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::BoolAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::BoolAttribute value) {
  return std::move(context).WriteString(::ax::mojom::BoolAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::IntListAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::IntListAttribute value) {
  return std::move(context).WriteString(::ax::mojom::IntListAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::StringListAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::StringListAttribute value) {
  return std::move(context).WriteString(::ax::mojom::StringListAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ListStyle>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::ListStyle value) {
  return std::move(context).WriteString(::ax::mojom::ListStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::MarkerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::MarkerType value) {
  return std::move(context).WriteString(::ax::mojom::MarkerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::HighlightType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::HighlightType value) {
  return std::move(context).WriteString(::ax::mojom::HighlightTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::MoveDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::MoveDirection value) {
  return std::move(context).WriteString(::ax::mojom::MoveDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Command>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Command value) {
  return std::move(context).WriteString(::ax::mojom::CommandToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::InputEventType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::InputEventType value) {
  return std::move(context).WriteString(::ax::mojom::InputEventTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextBoundary>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TextBoundary value) {
  return std::move(context).WriteString(::ax::mojom::TextBoundaryToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextAlign>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TextAlign value) {
  return std::move(context).WriteString(::ax::mojom::TextAlignToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::WritingDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::WritingDirection value) {
  return std::move(context).WriteString(::ax::mojom::WritingDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextPosition>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TextPosition value) {
  return std::move(context).WriteString(::ax::mojom::TextPositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextStyle>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TextStyle value) {
  return std::move(context).WriteString(::ax::mojom::TextStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextDecorationStyle>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TextDecorationStyle value) {
  return std::move(context).WriteString(::ax::mojom::TextDecorationStyleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::AriaCurrentState>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::AriaCurrentState value) {
  return std::move(context).WriteString(::ax::mojom::AriaCurrentStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::HasPopup>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::HasPopup value) {
  return std::move(context).WriteString(::ax::mojom::HasPopupToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::IsPopup>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::IsPopup value) {
  return std::move(context).WriteString(::ax::mojom::IsPopupToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::InvalidState>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::InvalidState value) {
  return std::move(context).WriteString(::ax::mojom::InvalidStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Restriction>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Restriction value) {
  return std::move(context).WriteString(::ax::mojom::RestrictionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::CheckedState>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::CheckedState value) {
  return std::move(context).WriteString(::ax::mojom::CheckedStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::SortDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::SortDirection value) {
  return std::move(context).WriteString(::ax::mojom::SortDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::NameFrom>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::NameFrom value) {
  return std::move(context).WriteString(::ax::mojom::NameFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::DescriptionFrom>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::DescriptionFrom value) {
  return std::move(context).WriteString(::ax::mojom::DescriptionFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::DetailsFrom>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::DetailsFrom value) {
  return std::move(context).WriteString(::ax::mojom::DetailsFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::EventFrom>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::EventFrom value) {
  return std::move(context).WriteString(::ax::mojom::EventFromToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::Gesture>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::Gesture value) {
  return std::move(context).WriteString(::ax::mojom::GestureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TextAffinity>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TextAffinity value) {
  return std::move(context).WriteString(::ax::mojom::TextAffinityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::TreeOrder>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::TreeOrder value) {
  return std::move(context).WriteString(::ax::mojom::TreeOrderToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::AXTreeIDType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::AXTreeIDType value) {
  return std::move(context).WriteString(::ax::mojom::AXTreeIDTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::ImageAnnotationStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::ImageAnnotationStatus value) {
  return std::move(context).WriteString(::ax::mojom::ImageAnnotationStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::AriaNotificationInterrupt>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::AriaNotificationInterrupt value) {
  return std::move(context).WriteString(::ax::mojom::AriaNotificationInterruptToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ax::mojom::AriaNotificationPriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::ax::mojom::AriaNotificationPriority value) {
  return std::move(context).WriteString(::ax::mojom::AriaNotificationPriorityToString(value));
}

} // namespace perfetto