#include "perfetto/protozero/gen_field_helpers.h"
#include "perfetto/protozero/message.h"
#include "perfetto/protozero/packed_repeated_fields.h"
#include "perfetto/protozero/proto_decoder.h"
#include "perfetto/protozero/scattered_heap_buffer.h"
// DO NOT EDIT. Autogenerated by Perfetto cppgen_plugin
#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
#include "protos/perfetto/config/gpu/gpu_renderstages_config.gen.h"

namespace perfetto {
namespace protos {
namespace gen {

GpuRenderStagesConfig::GpuRenderStagesConfig() = default;
GpuRenderStagesConfig::~GpuRenderStagesConfig() = default;
GpuRenderStagesConfig::GpuRenderStagesConfig(const GpuRenderStagesConfig&) = default;
GpuRenderStagesConfig& GpuRenderStagesConfig::operator=(const GpuRenderStagesConfig&) = default;
GpuRenderStagesConfig::GpuRenderStagesConfig(GpuRenderStagesConfig&&) noexcept = default;
GpuRenderStagesConfig& GpuRenderStagesConfig::operator=(GpuRenderStagesConfig&&) = default;

bool GpuRenderStagesConfig::operator==(const GpuRenderStagesConfig& other) const {
  return ::protozero::internal::gen_helpers::EqualsField(unknown_fields_, other.unknown_fields_)
   && ::protozero::internal::gen_helpers::EqualsField(full_loadstore_, other.full_loadstore_)
   && ::protozero::internal::gen_helpers::EqualsField(low_overhead_, other.low_overhead_)
   && ::protozero::internal::gen_helpers::EqualsField(trace_metrics_, other.trace_metrics_);
}

bool GpuRenderStagesConfig::ParseFromArray(const void* raw, size_t size) {
  trace_metrics_.clear();
  unknown_fields_.clear();
  bool packed_error = false;

  ::protozero::ProtoDecoder dec(raw, size);
  for (auto field = dec.ReadField(); field.valid(); field = dec.ReadField()) {
    if (field.id() < _has_field_.size()) {
      _has_field_.set(field.id());
    }
    switch (field.id()) {
      case 1 /* full_loadstore */:
        field.get(&full_loadstore_);
        break;
      case 2 /* low_overhead */:
        field.get(&low_overhead_);
        break;
      case 3 /* trace_metrics */:
        trace_metrics_.emplace_back();
        ::protozero::internal::gen_helpers::DeserializeString(field, &trace_metrics_.back());
        break;
      default:
        field.SerializeAndAppendTo(&unknown_fields_);
        break;
    }
  }
  return !packed_error && !dec.bytes_left();
}

std::string GpuRenderStagesConfig::SerializeAsString() const {
  ::protozero::internal::gen_helpers::MessageSerializer msg;
  Serialize(msg.get());
  return msg.SerializeAsString();
}

std::vector<uint8_t> GpuRenderStagesConfig::SerializeAsArray() const {
  ::protozero::internal::gen_helpers::MessageSerializer msg;
  Serialize(msg.get());
  return msg.SerializeAsArray();
}

void GpuRenderStagesConfig::Serialize(::protozero::Message* msg) const {
  // Field 1: full_loadstore
  if (_has_field_[1]) {
    ::protozero::internal::gen_helpers::SerializeTinyVarInt(1, full_loadstore_, msg);
  }

  // Field 2: low_overhead
  if (_has_field_[2]) {
    ::protozero::internal::gen_helpers::SerializeTinyVarInt(2, low_overhead_, msg);
  }

  // Field 3: trace_metrics
  for (auto& it : trace_metrics_) {
    ::protozero::internal::gen_helpers::SerializeString(3, it, msg);
  }

  protozero::internal::gen_helpers::SerializeUnknownFields(unknown_fields_, msg);
}

}  // namespace perfetto
}  // namespace protos
}  // namespace gen
#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic pop
#endif
