#include "perfetto/protozero/gen_field_helpers.h"
#include "perfetto/protozero/message.h"
#include "perfetto/protozero/packed_repeated_fields.h"
#include "perfetto/protozero/proto_decoder.h"
#include "perfetto/protozero/scattered_heap_buffer.h"
// DO NOT EDIT. Autogenerated by Perfetto cppgen_plugin
#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
#include "protos/perfetto/common/system_info.gen.h"

namespace perfetto {
namespace protos {
namespace gen {

SystemInfo::SystemInfo() = default;
SystemInfo::~SystemInfo() = default;
SystemInfo::SystemInfo(const SystemInfo&) = default;
SystemInfo& SystemInfo::operator=(const SystemInfo&) = default;
SystemInfo::SystemInfo(SystemInfo&&) noexcept = default;
SystemInfo& SystemInfo::operator=(SystemInfo&&) = default;

bool SystemInfo::operator==(const SystemInfo& other) const {
  return ::protozero::internal::gen_helpers::EqualsField(unknown_fields_, other.unknown_fields_)
   && ::protozero::internal::gen_helpers::EqualsField(utsname_, other.utsname_)
   && ::protozero::internal::gen_helpers::EqualsField(android_build_fingerprint_, other.android_build_fingerprint_)
   && ::protozero::internal::gen_helpers::EqualsField(android_device_manufacturer_, other.android_device_manufacturer_)
   && ::protozero::internal::gen_helpers::EqualsField(android_soc_model_, other.android_soc_model_)
   && ::protozero::internal::gen_helpers::EqualsField(android_guest_soc_model_, other.android_guest_soc_model_)
   && ::protozero::internal::gen_helpers::EqualsField(android_hardware_revision_, other.android_hardware_revision_)
   && ::protozero::internal::gen_helpers::EqualsField(android_storage_model_, other.android_storage_model_)
   && ::protozero::internal::gen_helpers::EqualsField(android_ram_model_, other.android_ram_model_)
   && ::protozero::internal::gen_helpers::EqualsField(android_serial_console_, other.android_serial_console_)
   && ::protozero::internal::gen_helpers::EqualsField(tracing_service_version_, other.tracing_service_version_)
   && ::protozero::internal::gen_helpers::EqualsField(android_sdk_version_, other.android_sdk_version_)
   && ::protozero::internal::gen_helpers::EqualsField(page_size_, other.page_size_)
   && ::protozero::internal::gen_helpers::EqualsField(num_cpus_, other.num_cpus_)
   && ::protozero::internal::gen_helpers::EqualsField(timezone_off_mins_, other.timezone_off_mins_)
   && ::protozero::internal::gen_helpers::EqualsField(hz_, other.hz_);
}

bool SystemInfo::ParseFromArray(const void* raw, size_t size) {
  unknown_fields_.clear();
  bool packed_error = false;

  ::protozero::ProtoDecoder dec(raw, size);
  for (auto field = dec.ReadField(); field.valid(); field = dec.ReadField()) {
    if (field.id() < _has_field_.size()) {
      _has_field_.set(field.id());
    }
    switch (field.id()) {
      case 1 /* utsname */:
        (*utsname_).ParseFromArray(field.data(), field.size());
        break;
      case 2 /* android_build_fingerprint */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_build_fingerprint_);
        break;
      case 14 /* android_device_manufacturer */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_device_manufacturer_);
        break;
      case 9 /* android_soc_model */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_soc_model_);
        break;
      case 13 /* android_guest_soc_model */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_guest_soc_model_);
        break;
      case 10 /* android_hardware_revision */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_hardware_revision_);
        break;
      case 11 /* android_storage_model */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_storage_model_);
        break;
      case 12 /* android_ram_model */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_ram_model_);
        break;
      case 15 /* android_serial_console */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &android_serial_console_);
        break;
      case 4 /* tracing_service_version */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &tracing_service_version_);
        break;
      case 5 /* android_sdk_version */:
        field.get(&android_sdk_version_);
        break;
      case 6 /* page_size */:
        field.get(&page_size_);
        break;
      case 8 /* num_cpus */:
        field.get(&num_cpus_);
        break;
      case 7 /* timezone_off_mins */:
        field.get(&timezone_off_mins_);
        break;
      case 3 /* hz */:
        field.get(&hz_);
        break;
      default:
        field.SerializeAndAppendTo(&unknown_fields_);
        break;
    }
  }
  return !packed_error && !dec.bytes_left();
}

std::string SystemInfo::SerializeAsString() const {
  ::protozero::internal::gen_helpers::MessageSerializer msg;
  Serialize(msg.get());
  return msg.SerializeAsString();
}

std::vector<uint8_t> SystemInfo::SerializeAsArray() const {
  ::protozero::internal::gen_helpers::MessageSerializer msg;
  Serialize(msg.get());
  return msg.SerializeAsArray();
}

void SystemInfo::Serialize(::protozero::Message* msg) const {
  // Field 1: utsname
  if (_has_field_[1]) {
    (*utsname_).Serialize(msg->BeginNestedMessage<::protozero::Message>(1));
  }

  // Field 2: android_build_fingerprint
  if (_has_field_[2]) {
    ::protozero::internal::gen_helpers::SerializeString(2, android_build_fingerprint_, msg);
  }

  // Field 14: android_device_manufacturer
  if (_has_field_[14]) {
    ::protozero::internal::gen_helpers::SerializeString(14, android_device_manufacturer_, msg);
  }

  // Field 9: android_soc_model
  if (_has_field_[9]) {
    ::protozero::internal::gen_helpers::SerializeString(9, android_soc_model_, msg);
  }

  // Field 13: android_guest_soc_model
  if (_has_field_[13]) {
    ::protozero::internal::gen_helpers::SerializeString(13, android_guest_soc_model_, msg);
  }

  // Field 10: android_hardware_revision
  if (_has_field_[10]) {
    ::protozero::internal::gen_helpers::SerializeString(10, android_hardware_revision_, msg);
  }

  // Field 11: android_storage_model
  if (_has_field_[11]) {
    ::protozero::internal::gen_helpers::SerializeString(11, android_storage_model_, msg);
  }

  // Field 12: android_ram_model
  if (_has_field_[12]) {
    ::protozero::internal::gen_helpers::SerializeString(12, android_ram_model_, msg);
  }

  // Field 15: android_serial_console
  if (_has_field_[15]) {
    ::protozero::internal::gen_helpers::SerializeString(15, android_serial_console_, msg);
  }

  // Field 4: tracing_service_version
  if (_has_field_[4]) {
    ::protozero::internal::gen_helpers::SerializeString(4, tracing_service_version_, msg);
  }

  // Field 5: android_sdk_version
  if (_has_field_[5]) {
    ::protozero::internal::gen_helpers::SerializeVarInt(5, android_sdk_version_, msg);
  }

  // Field 6: page_size
  if (_has_field_[6]) {
    ::protozero::internal::gen_helpers::SerializeVarInt(6, page_size_, msg);
  }

  // Field 8: num_cpus
  if (_has_field_[8]) {
    ::protozero::internal::gen_helpers::SerializeVarInt(8, num_cpus_, msg);
  }

  // Field 7: timezone_off_mins
  if (_has_field_[7]) {
    ::protozero::internal::gen_helpers::SerializeVarInt(7, timezone_off_mins_, msg);
  }

  // Field 3: hz
  if (_has_field_[3]) {
    ::protozero::internal::gen_helpers::SerializeVarInt(3, hz_, msg);
  }

  protozero::internal::gen_helpers::SerializeUnknownFields(unknown_fields_, msg);
}


Utsname::Utsname() = default;
Utsname::~Utsname() = default;
Utsname::Utsname(const Utsname&) = default;
Utsname& Utsname::operator=(const Utsname&) = default;
Utsname::Utsname(Utsname&&) noexcept = default;
Utsname& Utsname::operator=(Utsname&&) = default;

bool Utsname::operator==(const Utsname& other) const {
  return ::protozero::internal::gen_helpers::EqualsField(unknown_fields_, other.unknown_fields_)
   && ::protozero::internal::gen_helpers::EqualsField(sysname_, other.sysname_)
   && ::protozero::internal::gen_helpers::EqualsField(version_, other.version_)
   && ::protozero::internal::gen_helpers::EqualsField(release_, other.release_)
   && ::protozero::internal::gen_helpers::EqualsField(machine_, other.machine_);
}

bool Utsname::ParseFromArray(const void* raw, size_t size) {
  unknown_fields_.clear();
  bool packed_error = false;

  ::protozero::ProtoDecoder dec(raw, size);
  for (auto field = dec.ReadField(); field.valid(); field = dec.ReadField()) {
    if (field.id() < _has_field_.size()) {
      _has_field_.set(field.id());
    }
    switch (field.id()) {
      case 1 /* sysname */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &sysname_);
        break;
      case 2 /* version */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &version_);
        break;
      case 3 /* release */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &release_);
        break;
      case 4 /* machine */:
        ::protozero::internal::gen_helpers::DeserializeString(field, &machine_);
        break;
      default:
        field.SerializeAndAppendTo(&unknown_fields_);
        break;
    }
  }
  return !packed_error && !dec.bytes_left();
}

std::string Utsname::SerializeAsString() const {
  ::protozero::internal::gen_helpers::MessageSerializer msg;
  Serialize(msg.get());
  return msg.SerializeAsString();
}

std::vector<uint8_t> Utsname::SerializeAsArray() const {
  ::protozero::internal::gen_helpers::MessageSerializer msg;
  Serialize(msg.get());
  return msg.SerializeAsArray();
}

void Utsname::Serialize(::protozero::Message* msg) const {
  // Field 1: sysname
  if (_has_field_[1]) {
    ::protozero::internal::gen_helpers::SerializeString(1, sysname_, msg);
  }

  // Field 2: version
  if (_has_field_[2]) {
    ::protozero::internal::gen_helpers::SerializeString(2, version_, msg);
  }

  // Field 3: release
  if (_has_field_[3]) {
    ::protozero::internal::gen_helpers::SerializeString(3, release_, msg);
  }

  // Field 4: machine
  if (_has_field_[4]) {
    ::protozero::internal::gen_helpers::SerializeString(4, machine_, msg);
  }

  protozero::internal::gen_helpers::SerializeUnknownFields(unknown_fields_, msg);
}

}  // namespace perfetto
}  // namespace protos
}  // namespace gen
#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic pop
#endif
