/**
 * Lighthouse v13.0.1 (Oct 22 2025)
 *
 * Automated auditing, performance metrics, and best practices for the web.
 *
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   Copyright 2025 Google LLC
 * @license  Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
"use strict";(()=>{var EG=Object.create;var El=Object.defineProperty;var TG=Object.getOwnPropertyDescriptor;var xG=Object.getOwnPropertyNames;var SG=Object.getPrototypeOf,CG=Object.prototype.hasOwnProperty;var i=(e,t)=>El(e,"name",{value:t,configurable:!0});var g=(e,t)=>()=>(e&&(t=e(e=0)),t);var ve=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),x=(e,t)=>{for(var n in t)El(e,n,{get:t[n],enumerable:!0})},AI=(e,t,n,r)=>{if(t&&typeof t=="object"||typeof t=="function")for(let a of xG(t))!CG.call(e,a)&&a!==n&&El(e,a,{get:()=>t[a],enumerable:!(r=TG(t,a))||r.enumerable});return e};var Tn=(e,t,n)=>(n=e!=null?EG(SG(e)):{},AI(t||!e||!e.__esModule?El(n,"default",{value:e,enumerable:!0}):n,e)),kG=e=>AI(El({},"__esModule",{value:!0}),e);function NI(){throw new Error("setTimeout has not been defined")}function MI(){throw new Error("clearTimeout has not been defined")}function OI(e){if(io===setTimeout)return setTimeout(e,0);if((io===NI||!io)&&setTimeout)return io=setTimeout,setTimeout(e,0);try{return io(e,0)}catch{try{return io.call(null,e,0)}catch{return io.call(this,e,0)}}}function RG(e){if(so===clearTimeout)return clearTimeout(e);if((so===MI||!so)&&clearTimeout)return so=clearTimeout,clearTimeout(e);try{return so(e)}catch{try{return so.call(null,e)}catch{return so.call(this,e)}}}function _G(){!Ts||!gi||(Ts=!1,gi.length?wa=gi.concat(wa):ip=-1,wa.length&&PI())}function PI(){if(!Ts){var e=OI(_G);Ts=!0;for(var t=wa.length;t;){for(gi=wa,wa=[];++ip<t;)gi&&gi[ip].run();ip=-1,t=wa.length}gi=null,Ts=!1,RG(e)}}function xn(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];wa.push(new LI(e,t)),wa.length===1&&!Ts&&OI(PI)}function LI(e,t){this.fun=e,this.array=t}function yi(){}
function WG(e){throw new Error("process.binding is not supported")}function VG(){return"/"}function $G(e){throw new Error("process.chdir is not supported")}function YG(){return 0}function XG(e){var t=KG.call(Es)*.001,n=Math.floor(t),r=Math.floor(t%1*1e9);return e&&(n=n-e[0],r=r-e[1],r<0&&(n--,r+=1e9)),[n,r]}function ZG(){var e=new Date,t=e-JG;return t/1e3}var io,so,wa,Ts,gi,ip,IG,DG,AG,NG,MG,OG,PG,LG,FG,UG,BG,jG,HG,qG,zG,GG,Es,KG,JG,Sn,co=g(()=>{d();i(NI,"defaultSetTimout");i(MI,"defaultClearTimeout");io=NI,so=MI;typeof globalThis.setTimeout=="function"&&(io=setTimeout);typeof globalThis.clearTimeout=="function"&&(so=clearTimeout);i(OI,"runTimeout");i(RG,"runClearTimeout");wa=[],Ts=!1,ip=-1;i(_G,"cleanUpNextTick");i(PI,"drainQueue");i(xn,"nextTick");i(LI,"Item");LI.prototype.run=function(){this.fun.apply(null,this.array)};IG="browser",DG="browser",AG=!0,NG={},MG=[],OG="",PG={},LG={},FG={};i(yi,"noop");UG=yi,BG=yi,jG=yi,HG=yi,qG=yi,zG=yi,GG=yi;i(WG,"binding");i(VG,"cwd");i($G,"chdir");i(
YG,"umask");Es=globalThis.performance||{},KG=Es.now||Es.mozNow||Es.msNow||Es.oNow||Es.webkitNow||function(){return new Date().getTime()};i(XG,"hrtime");JG=new Date;i(ZG,"uptime");Sn={nextTick:xn,title:IG,browser:AG,env:NG,argv:MG,version:OG,versions:PG,on:UG,addListener:BG,once:jG,off:HG,removeListener:qG,removeAllListeners:zG,emit:GG,binding:WG,cwd:VG,chdir:$G,umask:YG,hrtime:XG,platform:DG,release:LG,config:FG,uptime:ZG}});var d=g(()=>{"use strict";co();globalThis.process=Sn});function jI(){M1=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",t=0,n=e.length;t<n;++t)Yr[t]=e[t],pr[e.charCodeAt(t)]=t;pr[45]=62,pr[95]=63}function eW(e){M1||jI();var t,n,r,a,o,s,c=e.length;if(c%4>0)throw new Error("Invalid string. Length must be a multiple of 4");o=e[c-2]==="="?2:e[c-1]==="="?1:0,s=new QG(c*3/4-o),r=o>0?c-4:c;var l=0;for(t=0,n=0;t<r;t+=4,n+=3)a=pr[e.charCodeAt(t)]<<18|pr[e.charCodeAt(t+1)]<<12|pr[e.charCodeAt(t+2)]<<6|pr[e.charCodeAt(t+3)],s[l++]=a>>16&255,s[l++]=a>>8&255,s[l++]=a&255;return o===2?(a=pr[e.charCodeAt(t)]<<2|pr[e.charCodeAt(t+1)]>>4,s[l++]=a&255):o===1&&(a=pr[e.charCodeAt(t)]<<10|pr[e.charCodeAt(t+1)]<<4|pr[e.charCodeAt(t+2)]>>2,s[l++]=a>>8&255,s[l++]=a&255),s}function tW(e){return Yr[e>>18&63]+Yr[e>>12&63]+Yr[e>>6&63]+Yr[e&63]}function nW(e,t,n){for(var r,a=[],o=t;o<n;o+=3)r=(e[o]<<16)+(e[o+1]<<8)+e[o+2],a.push(tW(r));return a.join("")}function FI(e){M1||jI();for(var t,n=e.length,r=n%3,a="",o=[],s=16383,c=0,l=n-r;c<l;c+=
s)o.push(nW(e,c,c+s>l?l:c+s));return r===1?(t=e[n-1],a+=Yr[t>>2],a+=Yr[t<<4&63],a+="=="):r===2&&(t=(e[n-2]<<8)+e[n-1],a+=Yr[t>>10],a+=Yr[t>>4&63],a+=Yr[t<<2&63],a+="="),o.push(a),o.join("")}function lp(e,t,n,r,a){var o,s,c=a*8-r-1,l=(1<<c)-1,u=l>>1,m=-7,p=n?a-1:0,f=n?-1:1,h=e[t+p];for(p+=f,o=h&(1<<-m)-1,h>>=-m,m+=c;m>0;o=o*256+e[t+p],p+=f,m-=8);for(s=o&(1<<-m)-1,o>>=-m,m+=r;m>0;s=s*256+e[t+p],p+=f,m-=8);if(o===0)o=1-u;else{if(o===l)return s?NaN:(h?-1:1)*(1/0);s=s+Math.pow(2,r),o=o-u}return(h?-1:1)*s*Math.pow(2,o-r)}function HI(e,t,n,r,a,o){var s,c,l,u=o*8-a-1,m=(1<<u)-1,p=m>>1,f=a===23?Math.pow(2,-24)-Math.pow(2,-77):0,h=r?0:o-1,y=r?1:-1,b=t<0||t===0&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(c=isNaN(t)?1:0,s=m):(s=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-s))<1&&(s--,l*=2),s+p>=1?t+=f/l:t+=f*Math.pow(2,1-p),t*l>=2&&(s++,l/=2),s+p>=m?(c=0,s=m):s+p>=1?(c=(t*l-1)*Math.pow(2,a),s=s+p):(c=t*Math.pow(2,p-1)*Math.pow(2,a),s=0));a>=8;e[n+h]=c&255,h+=y,c/=256,a-=8);for(s=s<<a|c,u+=
a;u>0;e[n+h]=s&255,h+=y,s/=256,u-=8);e[n+h-y]|=b*128}function sp(){return H.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function Ea(e,t){if(sp()<t)throw new RangeError("Invalid typed array length");return H.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=H.prototype):(e===null&&(e=new H(t)),e.length=t),e}function H(e,t,n){if(!H.TYPED_ARRAY_SUPPORT&&!(this instanceof H))return new H(e,t,n);if(typeof e=="number"){if(typeof t=="string")throw new Error("If encoding is specified then the first argument must be a string");return O1(this,e)}return zI(this,e,t,n)}function zI(e,t,n,r){if(typeof t=="number")throw new TypeError('"value" argument must not be a number');return typeof ArrayBuffer<"u"&&t instanceof ArrayBuffer?sW(e,t,n,r):typeof t=="string"?iW(e,t,n):cW(e,t)}function GI(e){if(typeof e!="number")throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function oW(e,t,n,r){return GI(t),t<=0?Ea(e,t):n!==void 0?typeof r==
"string"?Ea(e,t).fill(n,r):Ea(e,t).fill(n):Ea(e,t)}function O1(e,t){if(GI(t),e=Ea(e,t<0?0:P1(t)|0),!H.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function iW(e,t,n){if((typeof n!="string"||n==="")&&(n="utf8"),!H.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=WI(t,n)|0;e=Ea(e,r);var a=e.write(t,n);return a!==r&&(e=e.slice(0,a)),e}function N1(e,t){var n=t.length<0?0:P1(t.length)|0;e=Ea(e,n);for(var r=0;r<n;r+=1)e[r]=t[r]&255;return e}function sW(e,t,n,r){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return n===void 0&&r===void 0?t=new Uint8Array(t):r===void 0?t=new Uint8Array(t,n):t=new Uint8Array(t,n,r),H.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=H.prototype):e=N1(e,t),e}function cW(e,t){if(Kr(t)){var n=P1(t.length)|0;return e=Ea(e,n),e.length===0||t.copy(e,0,0,n),e}if(t){if(typeof ArrayBuffer<"u"&&t.buffer instanceof ArrayBuffer||
"length"in t)return typeof t.length!="number"||RW(t.length)?Ea(e,0):N1(e,t);if(t.type==="Buffer"&&qI(t.data))return N1(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function P1(e){if(e>=sp())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+sp().toString(16)+" bytes");return e|0}function Kr(e){return!!(e!=null&&e._isBuffer)}function WI(e,t){if(Kr(e))return e.length;if(typeof ArrayBuffer<"u"&&typeof ArrayBuffer.isView=="function"&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;typeof e!="string"&&(e=""+e);var n=e.length;if(n===0)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return cp(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return n*2;case"hex":return n>>>1;case"base64":return ZI(e).length;default:if(r)return cp(e).length;t=(""+t).toLowerCase(),r=!0}}function lW(e,t,n){var r=!1;
if((t===void 0||t<0)&&(t=0),t>this.length||((n===void 0||n>this.length)&&(n=this.length),n<=0)||(n>>>=0,t>>>=0,n<=t))return"";for(e||(e="utf8");;)switch(e){case"hex":return bW(this,t,n);case"utf8":case"utf-8":return YI(this,t,n);case"ascii":return yW(this,t,n);case"latin1":case"binary":return vW(this,t,n);case"base64":return hW(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return wW(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function vi(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function VI(e,t,n,r,a){if(e.length===0)return-1;if(typeof n=="string"?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=a?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(a)return-1;n=e.length-1}else if(n<0)if(a)n=0;else return-1;if(typeof t=="string"&&(t=H.from(t,r)),Kr(t))return t.length===0?-1:UI(e,t,n,r,a);if(typeof t=="number")return t=t&255,H.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf=="function"?
a?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):UI(e,[t],n,r,a);throw new TypeError("val must be string, number or Buffer")}function UI(e,t,n,r,a){var o=1,s=e.length,c=t.length;if(r!==void 0&&(r=String(r).toLowerCase(),r==="ucs2"||r==="ucs-2"||r==="utf16le"||r==="utf-16le")){if(e.length<2||t.length<2)return-1;o=2,s/=2,c/=2,n/=2}function l(h,y){return o===1?h[y]:h.readUInt16BE(y*o)}i(l,"read");var u;if(a){var m=-1;for(u=n;u<s;u++)if(l(e,u)===l(t,m===-1?0:u-m)){if(m===-1&&(m=u),u-m+1===c)return m*o}else m!==-1&&(u-=u-m),m=-1}else for(n+c>s&&(n=s-c),u=n;u>=0;u--){for(var p=!0,f=0;f<c;f++)if(l(e,u+f)!==l(t,f)){p=!1;break}if(p)return u}return-1}function uW(e,t,n,r){n=Number(n)||0;var a=e.length-n;r?(r=Number(r),r>a&&(r=a)):r=a;var o=t.length;if(o%2!==0)throw new TypeError("Invalid hex string");r>o/2&&(r=o/2);for(var s=0;s<r;++s){var c=parseInt(t.substr(s*2,2),16);if(isNaN(c))return s;e[n+s]=c}return s}function dW(e,t,n,r){return mp(cp(t,e.length-n),e,
n,r)}function $I(e,t,n,r){return mp(CW(t),e,n,r)}function mW(e,t,n,r){return $I(e,t,n,r)}function pW(e,t,n,r){return mp(ZI(t),e,n,r)}function fW(e,t,n,r){return mp(kW(t,e.length-n),e,n,r)}function hW(e,t,n){return t===0&&n===e.length?FI(e):FI(e.slice(t,n))}function YI(e,t,n){n=Math.min(e.length,n);for(var r=[],a=t;a<n;){var o=e[a],s=null,c=o>239?4:o>223?3:o>191?2:1;if(a+c<=n){var l,u,m,p;switch(c){case 1:o<128&&(s=o);break;case 2:l=e[a+1],(l&192)===128&&(p=(o&31)<<6|l&63,p>127&&(s=p));break;case 3:l=e[a+1],u=e[a+2],(l&192)===128&&(u&192)===128&&(p=(o&15)<<12|(l&63)<<6|u&63,p>2047&&(p<55296||p>57343)&&(s=p));break;case 4:l=e[a+1],u=e[a+2],m=e[a+3],(l&192)===128&&(u&192)===128&&(m&192)===128&&(p=(o&15)<<18|(l&63)<<12|(u&63)<<6|m&63,p>65535&&p<1114112&&(s=p))}}s===null?(s=65533,c=1):s>65535&&(s-=65536,r.push(s>>>10&1023|55296),s=56320|s&1023),r.push(s),a+=c}return gW(r)}function gW(e){var t=e.length;if(t<=BI)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.
apply(String,e.slice(r,r+=BI));return n}function yW(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]&127);return r}function vW(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]);return r}function bW(e,t,n){var r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);for(var a="",o=t;o<n;++o)a+=SW(e[o]);return a}function wW(e,t,n){for(var r=e.slice(t,n),a="",o=0;o<r.length;o+=2)a+=String.fromCharCode(r[o]+r[o+1]*256);return a}function on(e,t,n){if(e%1!==0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function Vn(e,t,n,r,a,o){if(!Kr(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>a||t<o)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function up(e,t,n,r){t<0&&(t=65535+t+1);for(var a=0,o=Math.min(e.length-n,2);a<o;++a)e[n+a]=(t&255<<8*(r?a:1-a))>>>(r?a:1-a)*
8}function dp(e,t,n,r){t<0&&(t=4294967295+t+1);for(var a=0,o=Math.min(e.length-n,4);a<o;++a)e[n+a]=t>>>(r?a:3-a)*8&255}function KI(e,t,n,r,a,o){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function XI(e,t,n,r,a){return a||KI(e,t,n,4),HI(e,t,n,r,23,4),n+4}function JI(e,t,n,r,a){return a||KI(e,t,n,8),HI(e,t,n,r,52,8),n+8}function TW(e){if(e=xW(e).replace(EW,""),e.length<2)return"";for(;e.length%4!==0;)e=e+"=";return e}function xW(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function SW(e){return e<16?"0"+e.toString(16):e.toString(16)}function cp(e,t){t=t||1/0;for(var n,r=e.length,a=null,o=[],s=0;s<r;++s){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!a){if(n>56319){(t-=3)>-1&&o.push(239,191,189);continue}else if(s+1===r){(t-=3)>-1&&o.push(239,191,189);continue}a=n;continue}if(n<56320){(t-=3)>-1&&o.push(239,191,189),a=n;continue}n=(a-55296<<10|n-56320)+65536}else a&&(t-=3)>-1&&o.push(239,191,189);if(a=null,n<128){if((t-=1)<
0)break;o.push(n)}else if(n<2048){if((t-=2)<0)break;o.push(n>>6|192,n&63|128)}else if(n<65536){if((t-=3)<0)break;o.push(n>>12|224,n>>6&63|128,n&63|128)}else if(n<1114112){if((t-=4)<0)break;o.push(n>>18|240,n>>12&63|128,n>>6&63|128,n&63|128)}else throw new Error("Invalid code point")}return o}function CW(e){for(var t=[],n=0;n<e.length;++n)t.push(e.charCodeAt(n)&255);return t}function kW(e,t){for(var n,r,a,o=[],s=0;s<e.length&&!((t-=2)<0);++s)n=e.charCodeAt(s),r=n>>8,a=n%256,o.push(a),o.push(r);return o}function ZI(e){return eW(TW(e))}function mp(e,t,n,r){for(var a=0;a<r&&!(a+n>=t.length||a>=e.length);++a)t[a+n]=e[a];return a}function RW(e){return e!==e}function _W(e){return e!=null&&(!!e._isBuffer||QI(e)||IW(e))}function QI(e){return!!e.constructor&&typeof e.constructor.isBuffer=="function"&&e.constructor.isBuffer(e)}function IW(e){return typeof e.readFloatLE=="function"&&typeof e.slice=="function"&&QI(e.slice(0,0))}var Yr,pr,QG,M1,rW,qI,aW,Ive,BI,EW,Tl=g(()=>{d();Yr=[],pr=[],QG=typeof Uint8Array<
"u"?Uint8Array:Array,M1=!1;i(jI,"init");i(eW,"toByteArray");i(tW,"tripletToBase64");i(nW,"encodeChunk");i(FI,"fromByteArray");i(lp,"read");i(HI,"write");rW={}.toString,qI=Array.isArray||function(e){return rW.call(e)=="[object Array]"};aW=50;H.TYPED_ARRAY_SUPPORT=globalThis.TYPED_ARRAY_SUPPORT!==void 0?globalThis.TYPED_ARRAY_SUPPORT:!0;Ive=sp();i(sp,"kMaxLength");i(Ea,"createBuffer");i(H,"Buffer");H.poolSize=8192;H._augment=function(e){return e.__proto__=H.prototype,e};i(zI,"from");H.from=function(e,t,n){return zI(null,e,t,n)};H.TYPED_ARRAY_SUPPORT&&(H.prototype.__proto__=Uint8Array.prototype,H.__proto__=Uint8Array,typeof Symbol<"u"&&Symbol.species&&H[Symbol.species]);i(GI,"assertSize");i(oW,"alloc");H.alloc=function(e,t,n){return oW(null,e,t,n)};i(O1,"allocUnsafe");H.allocUnsafe=function(e){return O1(null,e)};H.allocUnsafeSlow=function(e){return O1(null,e)};i(iW,"fromString");i(N1,"fromArrayLike");i(sW,"fromArrayBuffer");i(cW,"fromObject");i(P1,"checked");H.isBuffer=_W;i(Kr,"internalIs\
Buffer");H.compare=i(function(t,n){if(!Kr(t)||!Kr(n))throw new TypeError("Arguments must be Buffers");if(t===n)return 0;for(var r=t.length,a=n.length,o=0,s=Math.min(r,a);o<s;++o)if(t[o]!==n[o]){r=t[o],a=n[o];break}return r<a?-1:a<r?1:0},"compare");H.isEncoding=i(function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},"isEncoding");H.concat=i(function(t,n){if(!qI(t))throw new TypeError('"list" argument must be an Array of Buffers');if(t.length===0)return H.alloc(0);var r;if(n===void 0)for(n=0,r=0;r<t.length;++r)n+=t[r].length;var a=H.allocUnsafe(n),o=0;for(r=0;r<t.length;++r){var s=t[r];if(!Kr(s))throw new TypeError('"list" argument must be an Array of Buffers');s.copy(a,o),o+=s.length}return a},"concat");i(WI,"byteLength");H.byteLength=WI;i(lW,"slowToString");H.prototype._isBuffer=!0;i(vi,"swap");H.prototype.swap16=i(function(){var t=this.
length;if(t%2!==0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var n=0;n<t;n+=2)vi(this,n,n+1);return this},"swap16");H.prototype.swap32=i(function(){var t=this.length;if(t%4!==0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var n=0;n<t;n+=4)vi(this,n,n+3),vi(this,n+1,n+2);return this},"swap32");H.prototype.swap64=i(function(){var t=this.length;if(t%8!==0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var n=0;n<t;n+=8)vi(this,n,n+7),vi(this,n+1,n+6),vi(this,n+2,n+5),vi(this,n+3,n+4);return this},"swap64");H.prototype.toString=i(function(){var t=this.length|0;return t===0?"":arguments.length===0?YI(this,0,t):lW.apply(this,arguments)},"toString");H.prototype.equals=i(function(t){if(!Kr(t))throw new TypeError("Argument must be a Buffer");return this===t?!0:H.compare(this,t)===0},"equals");H.prototype.inspect=i(function(){var t="",n=aW;return this.length>0&&(t=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>
n&&(t+=" ... ")),"<Buffer "+t+">"},"inspect");H.prototype.compare=i(function(t,n,r,a,o){if(!Kr(t))throw new TypeError("Argument must be a Buffer");if(n===void 0&&(n=0),r===void 0&&(r=t?t.length:0),a===void 0&&(a=0),o===void 0&&(o=this.length),n<0||r>t.length||a<0||o>this.length)throw new RangeError("out of range index");if(a>=o&&n>=r)return 0;if(a>=o)return-1;if(n>=r)return 1;if(n>>>=0,r>>>=0,a>>>=0,o>>>=0,this===t)return 0;for(var s=o-a,c=r-n,l=Math.min(s,c),u=this.slice(a,o),m=t.slice(n,r),p=0;p<l;++p)if(u[p]!==m[p]){s=u[p],c=m[p];break}return s<c?-1:c<s?1:0},"compare");i(VI,"bidirectionalIndexOf");i(UI,"arrayIndexOf");H.prototype.includes=i(function(t,n,r){return this.indexOf(t,n,r)!==-1},"includes");H.prototype.indexOf=i(function(t,n,r){return VI(this,t,n,r,!0)},"indexOf");H.prototype.lastIndexOf=i(function(t,n,r){return VI(this,t,n,r,!1)},"lastIndexOf");i(uW,"hexWrite");i(dW,"utf8Write");i($I,"asciiWrite");i(mW,"latin1Write");i(pW,"base64Write");i(fW,"ucs2Write");H.prototype.write=
i(function(t,n,r,a){if(n===void 0)a="utf8",r=this.length,n=0;else if(r===void 0&&typeof n=="string")a=n,r=this.length,n=0;else if(isFinite(n))n=n|0,isFinite(r)?(r=r|0,a===void 0&&(a="utf8")):(a=r,r=void 0);else throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");var o=this.length-n;if((r===void 0||r>o)&&(r=o),t.length>0&&(r<0||n<0)||n>this.length)throw new RangeError("Attempt to write outside buffer bounds");a||(a="utf8");for(var s=!1;;)switch(a){case"hex":return uW(this,t,n,r);case"utf8":case"utf-8":return dW(this,t,n,r);case"ascii":return $I(this,t,n,r);case"latin1":case"binary":return mW(this,t,n,r);case"base64":return pW(this,t,n,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return fW(this,t,n,r);default:if(s)throw new TypeError("Unknown encoding: "+a);a=(""+a).toLowerCase(),s=!0}},"write");H.prototype.toJSON=i(function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},"toJSON");i(hW,"base64Slice");i(YI,"utf8\
Slice");BI=4096;i(gW,"decodeCodePointsArray");i(yW,"asciiSlice");i(vW,"latin1Slice");i(bW,"hexSlice");i(wW,"utf16leSlice");H.prototype.slice=i(function(t,n){var r=this.length;t=~~t,n=n===void 0?r:~~n,t<0?(t+=r,t<0&&(t=0)):t>r&&(t=r),n<0?(n+=r,n<0&&(n=0)):n>r&&(n=r),n<t&&(n=t);var a;if(H.TYPED_ARRAY_SUPPORT)a=this.subarray(t,n),a.__proto__=H.prototype;else{var o=n-t;a=new H(o,void 0);for(var s=0;s<o;++s)a[s]=this[s+t]}return a},"slice");i(on,"checkOffset");H.prototype.readUIntLE=i(function(t,n,r){t=t|0,n=n|0,r||on(t,n,this.length);for(var a=this[t],o=1,s=0;++s<n&&(o*=256);)a+=this[t+s]*o;return a},"readUIntLE");H.prototype.readUIntBE=i(function(t,n,r){t=t|0,n=n|0,r||on(t,n,this.length);for(var a=this[t+--n],o=1;n>0&&(o*=256);)a+=this[t+--n]*o;return a},"readUIntBE");H.prototype.readUInt8=i(function(t,n){return n||on(t,1,this.length),this[t]},"readUInt8");H.prototype.readUInt16LE=i(function(t,n){return n||on(t,2,this.length),this[t]|this[t+1]<<8},"readUInt16LE");H.prototype.readUInt16BE=
i(function(t,n){return n||on(t,2,this.length),this[t]<<8|this[t+1]},"readUInt16BE");H.prototype.readUInt32LE=i(function(t,n){return n||on(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+this[t+3]*16777216},"readUInt32LE");H.prototype.readUInt32BE=i(function(t,n){return n||on(t,4,this.length),this[t]*16777216+(this[t+1]<<16|this[t+2]<<8|this[t+3])},"readUInt32BE");H.prototype.readIntLE=i(function(t,n,r){t=t|0,n=n|0,r||on(t,n,this.length);for(var a=this[t],o=1,s=0;++s<n&&(o*=256);)a+=this[t+s]*o;return o*=128,a>=o&&(a-=Math.pow(2,8*n)),a},"readIntLE");H.prototype.readIntBE=i(function(t,n,r){t=t|0,n=n|0,r||on(t,n,this.length);for(var a=n,o=1,s=this[t+--a];a>0&&(o*=256);)s+=this[t+--a]*o;return o*=128,s>=o&&(s-=Math.pow(2,8*n)),s},"readIntBE");H.prototype.readInt8=i(function(t,n){return n||on(t,1,this.length),this[t]&128?(255-this[t]+1)*-1:this[t]},"readInt8");H.prototype.readInt16LE=i(function(t,n){n||on(t,2,this.length);var r=this[t]|this[t+1]<<8;return r&32768?r|4294901760:r},"rea\
dInt16LE");H.prototype.readInt16BE=i(function(t,n){n||on(t,2,this.length);var r=this[t+1]|this[t]<<8;return r&32768?r|4294901760:r},"readInt16BE");H.prototype.readInt32LE=i(function(t,n){return n||on(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},"readInt32LE");H.prototype.readInt32BE=i(function(t,n){return n||on(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},"readInt32BE");H.prototype.readFloatLE=i(function(t,n){return n||on(t,4,this.length),lp(this,t,!0,23,4)},"readFloatLE");H.prototype.readFloatBE=i(function(t,n){return n||on(t,4,this.length),lp(this,t,!1,23,4)},"readFloatBE");H.prototype.readDoubleLE=i(function(t,n){return n||on(t,8,this.length),lp(this,t,!0,52,8)},"readDoubleLE");H.prototype.readDoubleBE=i(function(t,n){return n||on(t,8,this.length),lp(this,t,!1,52,8)},"readDoubleBE");i(Vn,"checkInt");H.prototype.writeUIntLE=i(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var o=Math.pow(2,8*r)-1;Vn(this,t,n,r,o,0)}var s=1,c=0;for(this[n]=t&255;++c<
r&&(s*=256);)this[n+c]=t/s&255;return n+r},"writeUIntLE");H.prototype.writeUIntBE=i(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var o=Math.pow(2,8*r)-1;Vn(this,t,n,r,o,0)}var s=r-1,c=1;for(this[n+s]=t&255;--s>=0&&(c*=256);)this[n+s]=t/c&255;return n+r},"writeUIntBE");H.prototype.writeUInt8=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,1,255,0),H.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),this[n]=t&255,n+1},"writeUInt8");i(up,"objectWriteUInt16");H.prototype.writeUInt16LE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,2,65535,0),H.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):up(this,t,n,!0),n+2},"writeUInt16LE");H.prototype.writeUInt16BE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,2,65535,0),H.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):up(this,t,n,!1),n+2},"writeUInt16BE");i(dp,"objectWriteUInt32");H.prototype.writeUInt32LE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,4,4294967295,0),H.TYPED_ARRAY_SUPPORT?(this[n+3]=t>>>24,this[n+2]=t>>>16,this[n+1]=t>>>8,
this[n]=t&255):dp(this,t,n,!0),n+4},"writeUInt32LE");H.prototype.writeUInt32BE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,4,4294967295,0),H.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):dp(this,t,n,!1),n+4},"writeUInt32BE");H.prototype.writeIntLE=i(function(t,n,r,a){if(t=+t,n=n|0,!a){var o=Math.pow(2,8*r-1);Vn(this,t,n,r,o-1,-o)}var s=0,c=1,l=0;for(this[n]=t&255;++s<r&&(c*=256);)t<0&&l===0&&this[n+s-1]!==0&&(l=1),this[n+s]=(t/c>>0)-l&255;return n+r},"writeIntLE");H.prototype.writeIntBE=i(function(t,n,r,a){if(t=+t,n=n|0,!a){var o=Math.pow(2,8*r-1);Vn(this,t,n,r,o-1,-o)}var s=r-1,c=1,l=0;for(this[n+s]=t&255;--s>=0&&(c*=256);)t<0&&l===0&&this[n+s+1]!==0&&(l=1),this[n+s]=(t/c>>0)-l&255;return n+r},"writeIntBE");H.prototype.writeInt8=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,1,127,-128),H.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),t<0&&(t=255+t+1),this[n]=t&255,n+1},"writeInt8");H.prototype.writeInt16LE=i(function(t,n,r){return t=+t,n=n|0,
r||Vn(this,t,n,2,32767,-32768),H.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):up(this,t,n,!0),n+2},"writeInt16LE");H.prototype.writeInt16BE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,2,32767,-32768),H.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):up(this,t,n,!1),n+2},"writeInt16BE");H.prototype.writeInt32LE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,4,2147483647,-2147483648),H.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8,this[n+2]=t>>>16,this[n+3]=t>>>24):dp(this,t,n,!0),n+4},"writeInt32LE");H.prototype.writeInt32BE=i(function(t,n,r){return t=+t,n=n|0,r||Vn(this,t,n,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),H.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):dp(this,t,n,!1),n+4},"writeInt32BE");i(KI,"checkIEEE754");i(XI,"writeFloat");H.prototype.writeFloatLE=i(function(t,n,r){return XI(this,t,n,!0,r)},"writeFloatLE");H.prototype.writeFloatBE=i(function(t,n,r){return XI(this,t,n,!1,r)},"writeFloatBE");i(JI,"w\
riteDouble");H.prototype.writeDoubleLE=i(function(t,n,r){return JI(this,t,n,!0,r)},"writeDoubleLE");H.prototype.writeDoubleBE=i(function(t,n,r){return JI(this,t,n,!1,r)},"writeDoubleBE");H.prototype.copy=i(function(t,n,r,a){if(r||(r=0),!a&&a!==0&&(a=this.length),n>=t.length&&(n=t.length),n||(n=0),a>0&&a<r&&(a=r),a===r||t.length===0||this.length===0)return 0;if(n<0)throw new RangeError("targetStart out of bounds");if(r<0||r>=this.length)throw new RangeError("sourceStart out of bounds");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),t.length-n<a-r&&(a=t.length-n+r);var o=a-r,s;if(this===t&&r<n&&n<a)for(s=o-1;s>=0;--s)t[s+n]=this[s+r];else if(o<1e3||!H.TYPED_ARRAY_SUPPORT)for(s=0;s<o;++s)t[s+n]=this[s+r];else Uint8Array.prototype.set.call(t,this.subarray(r,r+o),n);return o},"copy");H.prototype.fill=i(function(t,n,r,a){if(typeof t=="string"){if(typeof n=="string"?(a=n,n=0,r=this.length):typeof r=="string"&&(a=r,r=this.length),t.length===1){var o=t.charCodeAt(
0);o<256&&(t=o)}if(a!==void 0&&typeof a!="string")throw new TypeError("encoding must be a string");if(typeof a=="string"&&!H.isEncoding(a))throw new TypeError("Unknown encoding: "+a)}else typeof t=="number"&&(t=t&255);if(n<0||this.length<n||this.length<r)throw new RangeError("Out of range index");if(r<=n)return this;n=n>>>0,r=r===void 0?this.length:r>>>0,t||(t=0);var s;if(typeof t=="number")for(s=n;s<r;++s)this[s]=t;else{var c=Kr(t)?t:cp(new H(t,a).toString()),l=c.length;for(s=0;s<r-n;++s)this[s+n]=c[s%l]}return this},"fill");EW=/[^+\/0-9A-Za-z-_]/g;i(TW,"base64clean");i(xW,"stringtrim");i(SW,"toHex");i(cp,"utf8ToBytes");i(CW,"asciiToBytes");i(kW,"utf16leToBytes");i(ZI,"base64ToBytes");i(mp,"blitBuffer");i(RW,"isnan");i(_W,"isBuffer");i(QI,"isFastBuffer");i(IW,"isSlowBuffer")});function lo(){}function Ye(){Ye.init.call(this)}function eD(e){return e._maxListeners===void 0?Ye.defaultMaxListeners:e._maxListeners}function DW(e,t,n){if(t)e.call(n);else for(var r=e.length,a=xl(e,r),o=0;o<r;++o)a[o].call(n)}function AW(e,t,n,r){if(t)e.call(n,r);else for(var a=e.length,o=xl(e,a),s=0;s<a;++s)o[s].call(n,r)}function NW(e,t,n,r,a){if(t)e.call(n,r,a);else for(var o=e.length,s=xl(e,o),c=0;c<o;++c)s[c].call(n,r,a)}function MW(e,t,n,r,a,o){if(t)e.call(n,r,a,o);else for(var s=e.length,c=xl(e,s),l=0;l<s;++l)c[l].call(n,r,a,o)}function OW(e,t,n,r){if(t)e.apply(n,r);else for(var a=e.length,o=xl(e,a),s=0;s<a;++s)o[s].apply(n,r)}function tD(e,t,n,r){var a,o,s;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(o=e._events,o?(o.newListener&&(e.emit("newListener",t,n.listener?n.listener:n),o=e._events),s=o[t]):(o=e._events=new lo,e._eventsCount=0),!s)s=o[t]=n,++e._eventsCount;else if(typeof s=="function"?s=o[t]=r?[n,s]:[s,n]:r?s.unshift(n):s.push(
n),!s.warned&&(a=eD(e),a&&a>0&&s.length>a)){s.warned=!0;var c=new Error("Possible EventEmitter memory leak detected. "+s.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");c.name="MaxListenersExceededWarning",c.emitter=e,c.type=t,c.count=s.length,PW(c)}return e}function PW(e){typeof console.warn=="function"?console.warn(e):console.log(e)}function nD(e,t,n){var r=!1;function a(){e.removeListener(t,a),r||(r=!0,n.apply(e,arguments))}return i(a,"g"),a.listener=n,a}function rD(e){var t=this._events;if(t){var n=t[e];if(typeof n=="function")return 1;if(n)return n.length}return 0}function LW(e,t){for(var n=t,r=n+1,a=e.length;r<a;n+=1,r+=1)e[n]=e[r];e.pop()}function xl(e,t){for(var n=new Array(t);t--;)n[t]=e[t];return n}function FW(e){for(var t=new Array(e.length),n=0;n<t.length;++n)t[n]=e[n].listener||e[n];return t}var L1,fr,Ta=g(()=>{"use strict";d();i(lo,"EventHandlers");lo.prototype=Object.create(null);i(Ye,"EventEmitter");fr=Ye;Ye.EventEmitter=Ye;Ye.usingDomains=
!1;Ye.prototype.domain=void 0;Ye.prototype._events=void 0;Ye.prototype._maxListeners=void 0;Ye.defaultMaxListeners=10;Ye.init=function(){this.domain=null,Ye.usingDomains&&L1.active&&!(this instanceof L1.Domain)&&(this.domain=L1.active),(!this._events||this._events===Object.getPrototypeOf(this)._events)&&(this._events=new lo,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0};Ye.prototype.setMaxListeners=i(function(t){if(typeof t!="number"||t<0||isNaN(t))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=t,this},"setMaxListeners");i(eD,"$getMaxListeners");Ye.prototype.getMaxListeners=i(function(){return eD(this)},"getMaxListeners");i(DW,"emitNone");i(AW,"emitOne");i(NW,"emitTwo");i(MW,"emitThree");i(OW,"emitMany");Ye.prototype.emit=i(function(t){var n,r,a,o,s,c,l,u=!1,m=t==="error";if(c=this._events,c)m=m&&c.error==null;else if(!m)return!1;if(l=this.domain,m){if(n=arguments[1],l)n||(n=new Error('Uncaught, unspecified "error" event')),
n.domainEmitter=this,n.domain=l,n.domainThrown=!1,l.emit("error",n);else{if(n instanceof Error)throw n;var p=new Error('Uncaught, unspecified "error" event. ('+n+")");throw p.context=n,p}return!1}if(r=c[t],!r)return!1;var f=typeof r=="function";switch(a=arguments.length,a){case 1:DW(r,f,this);break;case 2:AW(r,f,this,arguments[1]);break;case 3:NW(r,f,this,arguments[1],arguments[2]);break;case 4:MW(r,f,this,arguments[1],arguments[2],arguments[3]);break;default:for(o=new Array(a-1),s=1;s<a;s++)o[s-1]=arguments[s];OW(r,f,this,o)}return u&&l.exit(),!0},"emit");i(tD,"_addListener");i(PW,"emitWarning");Ye.prototype.addListener=i(function(t,n){return tD(this,t,n,!1)},"addListener");Ye.prototype.on=Ye.prototype.addListener;Ye.prototype.prependListener=i(function(t,n){return tD(this,t,n,!0)},"prependListener");i(nD,"_onceWrap");Ye.prototype.once=i(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.on(t,nD(this,t,n)),this},"once");Ye.prototype.
prependOnceListener=i(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.prependListener(t,nD(this,t,n)),this},"prependOnceListener");Ye.prototype.removeListener=i(function(t,n){var r,a,o,s,c;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(a=this._events,!a)return this;if(r=a[t],!r)return this;if(r===n||r.listener&&r.listener===n)--this._eventsCount===0?this._events=new lo:(delete a[t],a.removeListener&&this.emit("removeListener",t,r.listener||n));else if(typeof r!="function"){for(o=-1,s=r.length;s-- >0;)if(r[s]===n||r[s].listener&&r[s].listener===n){c=r[s].listener,o=s;break}if(o<0)return this;if(r.length===1){if(r[0]=void 0,--this._eventsCount===0)return this._events=new lo,this;delete a[t]}else LW(r,o);a.removeListener&&this.emit("removeListener",t,c||n)}return this},"removeListener");Ye.prototype.off=function(e,t){return this.removeListener(e,t)};Ye.prototype.removeAllListeners=i(function(t){
var n,r;if(r=this._events,!r)return this;if(!r.removeListener)return arguments.length===0?(this._events=new lo,this._eventsCount=0):r[t]&&(--this._eventsCount===0?this._events=new lo:delete r[t]),this;if(arguments.length===0){for(var a=Object.keys(r),o=0,s;o<a.length;++o)s=a[o],s!=="removeListener"&&this.removeAllListeners(s);return this.removeAllListeners("removeListener"),this._events=new lo,this._eventsCount=0,this}if(n=r[t],typeof n=="function")this.removeListener(t,n);else if(n)do this.removeListener(t,n[n.length-1]);while(n[0]);return this},"removeAllListeners");Ye.prototype.listeners=i(function(t){var n,r,a=this._events;return a?(n=a[t],n?typeof n=="function"?r=[n.listener||n]:r=FW(n):r=[]):r=[],r},"listeners");Ye.listenerCount=function(e,t){return typeof e.listenerCount=="function"?e.listenerCount(t):rD.call(e,t)};Ye.prototype.listenerCount=rD;i(rD,"listenerCount");Ye.prototype.eventNames=i(function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]},"eventNames");i(
LW,"spliceOne");i(xl,"arrayClone");i(FW,"unwrapListeners")});var oD=ve((Lve,aD)=>{d();var xs=1e3,Ss=xs*60,Cs=Ss*60,bi=Cs*24,UW=bi*7,BW=bi*365.25;aD.exports=function(e,t){t=t||{};var n=typeof e;if(n==="string"&&e.length>0)return jW(e);if(n==="number"&&isFinite(e))return t.long?qW(e):HW(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))};function jW(e){if(e=String(e),!(e.length>100)){var t=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(t){var n=parseFloat(t[1]),r=(t[2]||"ms").toLowerCase();switch(r){case"years":case"year":case"yrs":case"yr":case"y":return n*BW;case"weeks":case"week":case"w":return n*UW;case"days":case"day":case"d":return n*bi;case"hours":case"hour":case"hrs":case"hr":case"h":return n*Cs;case"minutes":case"minute":case"mins":case"min":case"m":return n*Ss;case"seconds":case"second":case"secs":case"sec":case"s":return n*xs;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return n;default:
return}}}}i(jW,"parse");function HW(e){var t=Math.abs(e);return t>=bi?Math.round(e/bi)+"d":t>=Cs?Math.round(e/Cs)+"h":t>=Ss?Math.round(e/Ss)+"m":t>=xs?Math.round(e/xs)+"s":e+"ms"}i(HW,"fmtShort");function qW(e){var t=Math.abs(e);return t>=bi?pp(e,t,bi,"day"):t>=Cs?pp(e,t,Cs,"hour"):t>=Ss?pp(e,t,Ss,"minute"):t>=xs?pp(e,t,xs,"second"):e+" ms"}i(qW,"fmtLong");function pp(e,t,n,r){var a=t>=n*1.5;return Math.round(e/n)+" "+r+(a?"s":"")}i(pp,"plural")});var sD=ve((Bve,iD)=>{d();function zW(e){n.debug=n,n.default=n,n.coerce=l,n.disable=o,n.enable=a,n.enabled=s,n.humanize=oD(),n.destroy=u,Object.keys(e).forEach(m=>{n[m]=e[m]}),n.names=[],n.skips=[],n.formatters={};function t(m){let p=0;for(let f=0;f<m.length;f++)p=(p<<5)-p+m.charCodeAt(f),p|=0;return n.colors[Math.abs(p)%n.colors.length]}i(t,"selectColor"),n.selectColor=t;function n(m){let p,f=null,h,y;function b(...w){if(!b.enabled)return;let C=b,k=Number(new Date),R=k-(p||k);C.diff=R,C.prev=p,C.curr=k,p=k,w[0]=n.coerce(w[0]),typeof w[0]!="string"&&w.unshift("%O");let S=0;w[0]=w[0].replace(/%([a-zA-Z%])/g,(q,F)=>{if(q==="%%")return"%";S++;let G=n.formatters[F];if(typeof G=="function"){let K=w[S];q=G.call(C,K),w.splice(S,1),S--}return q}),n.formatArgs.call(C,w),(C.log||n.log).apply(C,w)}return i(b,"debug"),b.namespace=m,b.useColors=n.useColors(),b.color=n.selectColor(m),b.extend=r,b.destroy=n.destroy,Object.defineProperty(b,"enabled",{enumerable:!0,configurable:!1,get:i(()=>f!==null?f:(h!==
n.namespaces&&(h=n.namespaces,y=n.enabled(m)),y),"get"),set:i(w=>{f=w},"set")}),typeof n.init=="function"&&n.init(b),b}i(n,"createDebug");function r(m,p){let f=n(this.namespace+(typeof p>"u"?":":p)+m);return f.log=this.log,f}i(r,"extend");function a(m){n.save(m),n.namespaces=m,n.names=[],n.skips=[];let p,f=(typeof m=="string"?m:"").split(/[\s,]+/),h=f.length;for(p=0;p<h;p++)f[p]&&(m=f[p].replace(/\*/g,".*?"),m[0]==="-"?n.skips.push(new RegExp("^"+m.slice(1)+"$")):n.names.push(new RegExp("^"+m+"$")))}i(a,"enable");function o(){let m=[...n.names.map(c),...n.skips.map(c).map(p=>"-"+p)].join(",");return n.enable(""),m}i(o,"disable");function s(m){if(m[m.length-1]==="*")return!0;let p,f;for(p=0,f=n.skips.length;p<f;p++)if(n.skips[p].test(m))return!1;for(p=0,f=n.names.length;p<f;p++)if(n.names[p].test(m))return!0;return!1}i(s,"enabled");function c(m){return m.toString().substring(2,m.toString().length-2).replace(/\.\*\?$/,"*")}i(c,"toNamespace");function l(m){return m instanceof Error?m.stack||
m.message:m}i(l,"coerce");function u(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")}return i(u,"destroy"),n.enable(n.load()),n}i(zW,"setup");iD.exports=zW});var cD=ve((ar,fp)=>{d();ar.formatArgs=WW;ar.save=VW;ar.load=$W;ar.useColors=GW;ar.storage=YW();ar.destroy=(()=>{let e=!1;return()=>{e||(e=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})();ar.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#\
FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"];function GW(){return typeof window<"u"&&window.process&&(window.process.type==="renderer"||window.process.__nwjs)?!0:typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)?!1:typeof document<"u"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window<"u"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}i(GW,"useColors");function WW(e){if(e[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+e[0]+(this.useColors?"%c ":" ")+"+"+fp.exports.humanize(this.diff),!this.useColors)return;let t="color: "+this.color;e.splice(
1,0,t,"color: inherit");let n=0,r=0;e[0].replace(/%[a-zA-Z%]/g,a=>{a!=="%%"&&(n++,a==="%c"&&(r=n))}),e.splice(r,0,t)}i(WW,"formatArgs");ar.log=console.debug||console.log||(()=>{});function VW(e){try{e?ar.storage.setItem("debug",e):ar.storage.removeItem("debug")}catch{}}i(VW,"save");function $W(){let e;try{e=ar.storage.getItem("debug")}catch{}return!e&&typeof process<"u"&&"env"in process&&(e=process.env.DEBUG),e}i($W,"load");function YW(){try{return localStorage}catch{}}i(YW,"localstorage");fp.exports=sD()(ar);var{formatters:KW}=fp.exports;KW.j=function(e){try{return JSON.stringify(e)}catch(t){return"[UnexpectedJSONParseError]: "+t.message}}});function hp(e){if(!e)throw new Error("name must be non-empty")}function XW(e,t){for(var n=0,r=e.length,a;n<r;)a=n+r>>>1,e[a].startTime<t.startTime?n=a+1:r=a;e.splice(n,0,t)}var fn,lD,vp,bp,Sl,wp,gp,yp,uD=g(()=>{d();fn=typeof performance<"u"&&performance,lD=fn&&fn.now?function(){return fn.now()}:function(){return Date.now()};i(hp,"throwIfEmpty");i(XW,"insertSorted");fn&&fn.mark&&fn.measure&&fn.getEntriesByName&&fn.getEntriesByType&&fn.clearMarks&&fn.clearMeasures?(vp=i(function(e){hp(e),fn.mark("start "+e)},"mark"),bp=i(function(e){hp(e),fn.mark("end "+e);var t=fn.measure(e,"start "+e,"end "+e);if(t)return t;var n=fn.getEntriesByName(e);return n[n.length-1]},"stop"),Sl=i(function(){return fn.getEntriesByType("measure")},"getEntries"),wp=i(function(){fn.clearMarks(),fn.clearMeasures()},"clear")):(gp={},yp=[],vp=i(function(e){hp(e);var t=lD();gp["$"+e]=t},"mark"),bp=i(function(e){hp(e);var t=lD(),n=gp["$"+e];if(!n)throw new Error("no known mark: "+e);var r={startTime:n,name:e,duration:t-n,
entryType:"measure"};return XW(yp,r),r},"stop"),Sl=i(function(){return yp},"getEntries"),wp=i(function(){gp={},yp=[]},"clear"))});var mo,uo,ks,Rs,F1,dD,ZW,mD,_s,M,Ve=g(()=>{d();co();Ta();mo=Tn(cD());uD();uo=Sn.platform==="win32",ks=Sn.browser,Rs={red:ks?"crimson":1,yellow:ks?"gold":3,cyan:ks?"darkturquoise":6,green:ks?"forestgreen":2,blue:ks?"steelblue":4,magenta:ks?"palevioletred":5};mo.default.colors=[Rs.cyan,Rs.green,Rs.blue,Rs.magenta];F1=class extends Ye{static{i(this,"Emitter")}constructor(t){super(t)}issueStatus(t,n){(t==="status"||t==="statusEnd")&&this.emit(t,[t,...n])}issueWarning(t,n){this.emit("warning",[t,...n])}},dD={},ZW=25,_s=class e{static{i(this,"Log")}static _logToStdErr(t,n){e.loggerfn(t)(...n)}static loggerfn(t){t=`LH:${t}`;let n=dD[t];return n||(n=(0,mo.default)(t),dD[t]=n,t.endsWith("error")?n.color=Rs.red:t.endsWith("warn")&&(n.color=Rs.yellow)),n}static setLevel(t){switch(mD=t,t){case"silent":mo.default.enable("-LH:*");break;case"verbose":mo.default.enable("LH:*");break;case"warn":mo.default.enable("-LH:*, LH:*:warn, LH:*:error");break;case"error":mo.default.enable("-LH:*, LH:*:error");break;default:
mo.default.enable("LH:*, -LH:*:verbose")}}static formatProtocol(t,n,r){let a=!Sn||Sn.browser?1/0:Sn.stdout.columns,o=n.method||"?????",s=a-o.length-t.length-ZW,c=n.params&&o!=="IO.read"?JSON.stringify(n.params).substr(0,s):"";e._logToStdErr(`${t}:${r||""}`,[o,c])}static isVerbose(){return mD==="verbose"}static time({msg:t,id:n,args:r=[]},a="log"){vp(n),e[a]("status",t,...r)}static timeEnd({msg:t,id:n,args:r=[]},a="verbose"){e[a]("statusEnd",t,...r),bp(n)}static log(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(t,n)}static warn(t,...n){return e.events.issueWarning(t,n),e._logToStdErr(`${t}:warn`,n)}static error(t,...n){return e._logToStdErr(`${t}:error`,n)}static verbose(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(`${t}:verbose`,n)}static greenify(t){return`${e.green}${t}${e.reset}`}static redify(t){return`${e.red}${t}${e.reset}`}static get green(){return"\x1B[32m"}static get red(){return"\x1B[31m"}static get yellow(){return"\x1B[33m"}static get purple(){return"\x1B[9\
5m"}static get reset(){return"\x1B[0m"}static get bold(){return"\x1B[1m"}static get dim(){return"\x1B[2m"}static get tick(){return uo?"√":"✓"}static get cross(){return uo?"×":"✘"}static get whiteSmallSquare(){return uo?"·":"▫"}static get heavyHorizontal(){return uo?"─":"━"}static get heavyVertical(){return uo?"│ ":"┃ "}static get heavyUpAndRight(){return uo?"└":"┗"}static get heavyVerticalAndRight(){return uo?"├":"┣"}static get heavyDownAndHorizontal(){return uo?"┬":"┳"}static get doubleLightHorizontal(){return"──"}};_s.events=new F1;_s.takeTimeEntries=()=>{let e=Sl();return wp(),e};_s.getTimeEntries=()=>Sl();M=_s});var Cn=g(()=>{"use strict";d();});var U1,fe,bt=g(()=>{"use strict";d();Cn();U1=class{static{i(this,"BaseGatherer")}meta={supportedModes:[]};startInstrumentation(t){}startSensitiveInstrumentation(t){}stopSensitiveInstrumentation(t){}stopInstrumentation(t){}getArtifact(t){}},fe=U1});var QW,eV,tV,nV,rV,aV,Ln,po=g(()=>{"use strict";d();Ve();QW=/^(chrome|https?):/,eV=16,tV="RunTask",nV="ThreadControllerImpl::RunTask",rV="ThreadControllerImpl::DoWork",aV="TaskQueueManager::ProcessTaskFromWorkQueue",Ln=class e{static{i(this,"TraceProcessor")}static get TIMESPAN_MARKER_ID(){return"__lighthouseTimespanStart__"}static createNoNavstartError(){return new Error("No navigationStart event found")}static createNoResourceSendRequestError(){return new Error("No ResourceSendRequest event found")}static createNoTracingStartedError(){return new Error("No tracingStartedInBrowser event found")}static createNoFirstContentfulPaintError(){return new Error("No FirstContentfulPaint event found")}static createNoLighthouseMarkerError(){return new Error("No Lighthouse timespan marker event found")}static _isNavigationStartOfInterest(t){return t.name!=="navigationStart"?!1:t.args.data?.documentLoaderURL===void 0?!0:t.args.data?.documentLoaderURL?QW.test(t.args.data.documentLoaderURL):!1}static _sortTimestampEventGroup(t,n,r,a){
let o=i(p=>n[p],"lookupArrayIndexByTsIndex"),s=i(p=>a[o(p)],"lookupEventByTsIndex"),c=[],l=[],u=[];for(let p of t){let f=o(p),h=s(p);h.ph==="E"?c.push(f):h.ph==="X"||h.ph==="B"?l.push(f):u.push(f)}let m=new Map;for(let p of l){let f=a[p];if(f.ph==="X")m.set(p,f.dur);else{let h=Number.MAX_SAFE_INTEGER,y=0,b=r+t.length;for(let w=b;w<n.length;w++){let C=s(w);if(C.name===f.name&&C.pid===f.pid&&C.tid===f.tid)if(C.ph==="E"&&y===0){h=C.ts-f.ts;break}else C.ph==="E"?y--:C.ph==="B"&&y++}m.set(p,h)}}return l.sort((p,f)=>(m.get(f)||0)-(m.get(p)||0)||p-f),u.sort((p,f)=>p-f),[...c,...l,...u]}static filteredTraceSort(t,n){let r=[];for(let o=0;o<t.length;o++)n(t[o])&&r.push(o);r.sort((o,s)=>t[o].ts-t[s].ts);for(let o=0;o<r.length-1;o++){let s=t[r[o]].ts,c=[o];for(let u=o+1;u<r.length&&t[r[u]].ts===s;u++)c.push(u);if(c.length===1)continue;let l=e._sortTimestampEventGroup(c,r,o,t);r.splice(o,l.length,...l),o+=c.length-1}let a=[];for(let o=0;o<r.length;o++)a.push(t[r[o]]);return a}static assertHasToplevelEvents(t){
if(!t.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static _riskPercentiles(t,n,r,a=0){let o=0;for(let f=0;f<t.length;f++)o+=t[f];o-=a;let s=n-o,c=0,l=s,u=[],m=-1,p=t.length+1;a>0&&p--;for(let f of r){let h=f*n;for(;l<h&&m<t.length-1;)s+=c,p-=c<0?-1:1,a>0&&a<t[m+1]?(c=-a,a=0):(m++,c=t[m]),l=s+Math.abs(c)*p;u.push({percentile:f,time:Math.max(0,(h-s)/p)+eV})}return u}static getRiskToResponsiveness(t,n,r,a=[.5,.75,.9,.99,1]){let o=r-n;a.sort((c,l)=>c-l);let s=this.getMainThreadTopLevelEventDurations(t,n,r);return this._riskPercentiles(s.durations,o,a,s.clippedLength)}static getMainThreadTopLevelEventDurations(t,n=0,r=1/0){let a=[],o=0;for(let s of t){if(s.end<n||s.start>r)continue;let c=s.duration,l=s.start;l<n&&(l=n,c=s.end-n),s.end>r&&(o=c-(r-l)),a.push(c)}return a.sort((s,c)=>s-c),{durations:a,clippedLength:o}}static getMainThreadTopLevelEvents(t,n=0,r=1/0){let a=[],o;for(let s of t.mainThreadEvents){if(!this.isScheduleableTask(s)||!s.dur)continue;
let c=(s.ts-t.timeOriginEvt.ts)/1e3,l=(s.ts+s.dur-t.timeOriginEvt.ts)/1e3;c>r||l<n||(o&&c<o.end&&(o.end=c-.001),o={start:c,end:l,duration:s.dur/1e3},a.push(o))}return a}static findMainFrameIds(t){let n=t.find(s=>s.name==="TracingStartedInBrowser");if(n?.args.data?.frames){let s=n.args.data.frames.find(u=>!u.parent),c=s?.frame,l=s?.processId;if(l&&c)return{startingPid:l,frameId:c}}let r=t.find(s=>s.name==="TracingStartedInPage");if(r?.args?.data){let s=r.args.data.page;if(s)return{startingPid:r.pid,frameId:s}}let a=t.find(s=>this._isNavigationStartOfInterest(s)&&s.args.data?.isLoadingMainFrame),o=t.find(s=>s.name==="ResourceSendRequest");if(a?.args?.data&&o&&o.pid===a.pid&&o.tid===a.tid){let s=a.args.frame;if(s)return{startingPid:a.pid,frameId:s}}throw this.createNoTracingStartedError()}static findMainFramePidTids(t,n){let r=n.filter(s=>(s.name==="FrameCommittedInBrowser"||s.name==="ProcessReadyInBrowser")&&s.args?.data?.frame===t.frameId&&s?.args?.data?.processId),a=r.length?r.map(s=>s?.
args?.data?.processId):[t.startingPid],o=new Map;for(let s of new Set(a)){let c=n.filter(m=>m.cat==="__metadata"&&m.pid===s&&m.ph==="M"&&m.name==="thread_name"),l=c.find(m=>m.args.name==="CrRendererMain");l||(l=c.find(m=>m.args.name==="CrBrowserMain"));let u=l?.tid;if(!u)throw new Error("Unable to determine tid for renderer process");o.set(s,u)}return o}static isScheduleableTask(t){return t.name===tV||t.name===nV||t.name===rV||t.name===aV}static isLCPEvent(t){return t.name!=="largestContentfulPaint::Invalidate"&&t.name!=="largestContentfulPaint::Candidate"?!1:!!t.args?.frame}static isLCPCandidateEvent(t){return!!(t.name==="largestContentfulPaint::Candidate"&&t.args?.frame&&t.args.data&&t.args.data.size!==void 0)}static getFrameId(t){return t.args?.data?.frame||t.args.data?.frameID||t.args.frame}static computeValidLCPAllFrames(t,n){let r=t.filter(this.isLCPEvent).reverse(),a=new Map;for(let s of r){if(s.ts<=n.ts)break;let c=s.args.frame;a.has(c)||a.set(c,s)}let o;for(let s of a.values())
this.isLCPCandidateEvent(s)&&(!o||s.args.data.size>o.args.data.size)&&(o=s);return{lcp:o,invalidated:!!(!o&&a.size)}}static resolveRootFrames(t){let n=new Map;for(let a of t)a.parent&&n.set(a.id,a.parent);let r=new Map;for(let a of t){let o=a.id;for(;n.has(o);)o=n.get(o);if(o===void 0)throw new Error("Unexpected undefined frameId");r.set(a.id,o)}return r}static processTrace(t,n){let{timeOriginDeterminationMethod:r="auto"}=n||{},a=this.filteredTraceSort(t.traceEvents,S=>S.cat.includes("blink.user_timing")||S.cat.includes("loading")||S.cat.includes("devtools.timeline")||S.cat==="__metadata"),o=this.findMainFrameIds(a),s=this.findMainFramePidTids(o,a),c=e.filteredTraceSort(t.traceEvents,S=>s.has(S.pid)),l=new Map,u=a.find(S=>S.name==="TracingStartedInBrowser")?.args?.data?.frames;if(u)for(let S of u)l.set(S.frame,{id:S.frame,url:S.url,parent:S.parent});a.filter(S=>!!(S.name==="FrameCommittedInBrowser"&&S.args.data?.frame&&S.args.data.url!==void 0)).forEach(S=>{l.set(S.args.data.frame,{id:S.
args.data.frame,url:S.args.data.url,parent:S.args.data.parent})});let m=[...l.values()],p=this.resolveRootFrames(m),f=[...p.entries()].filter(([,S])=>S===o.frameId).map(([S])=>S);function h(S){return e.getFrameId(S)===o.frameId}i(h,"associatedToMainFrame");function y(S){let _=e.getFrameId(S);return _?f.includes(_):!1}i(y,"associatedToAllFrames");let b=a.filter(S=>h(S)),w=[];p.has(o.frameId)?w=a.filter(S=>y(S)):(M.warn("TraceProcessor","frameTreeEvents may be incomplete, make sure the trace has frame events"),p.set(o.frameId,o.frameId),w=b);let C=this.computeTimeOrigin({keyEvents:a,frameEvents:b,mainFrameInfo:o},r),k=c.filter(S=>S.tid===s.get(S.pid)),R=this.computeTraceEnd(t.traceEvents,C);return{frames:m,mainThreadEvents:k,frameEvents:b,frameTreeEvents:w,processEvents:c,mainFrameInfo:o,timeOriginEvt:C,timings:{timeOrigin:0,traceEnd:R.timing},timestamps:{timeOrigin:C.ts,traceEnd:R.timestamp},_keyEvents:a,_rendererPidToTid:s}}static processNavigation(t){let{frameEvents:n,frameTreeEvents:r,
timeOriginEvt:a,timings:o,timestamps:s}=t,c=this.computeNavigationTimingsForFrame(n,{timeOriginEvt:a}),l=r.find(f=>f.name==="firstContentfulPaint"&&f.ts>a.ts);if(!l)throw this.createNoFirstContentfulPaintError();let u=this.computeValidLCPAllFrames(r,a).lcp,m=i(f=>(f-a.ts)/1e3,"getTiming"),p=i(f=>f===void 0?void 0:m(f),"maybeGetTiming");return{timings:{timeOrigin:o.timeOrigin,firstPaint:c.timings.firstPaint,firstContentfulPaint:c.timings.firstContentfulPaint,firstContentfulPaintAllFrames:m(l.ts),largestContentfulPaint:c.timings.largestContentfulPaint,largestContentfulPaintAllFrames:p(u?.ts),load:c.timings.load,domContentLoaded:c.timings.domContentLoaded,traceEnd:o.traceEnd},timestamps:{timeOrigin:s.timeOrigin,firstPaint:c.timestamps.firstPaint,firstContentfulPaint:c.timestamps.firstContentfulPaint,firstContentfulPaintAllFrames:l.ts,largestContentfulPaint:c.timestamps.largestContentfulPaint,largestContentfulPaintAllFrames:u?.ts,load:c.timestamps.load,domContentLoaded:c.timestamps.domContentLoaded,
traceEnd:s.traceEnd},firstPaintEvt:c.firstPaintEvt,firstContentfulPaintEvt:c.firstContentfulPaintEvt,firstContentfulPaintAllFramesEvt:l,largestContentfulPaintEvt:c.largestContentfulPaintEvt,largestContentfulPaintAllFramesEvt:u,loadEvt:c.loadEvt,domContentLoadedEvt:c.domContentLoadedEvt,lcpInvalidated:c.lcpInvalidated}}static computeTraceEnd(t,n){let r=-1/0;for(let a of t)r=Math.max(a.ts+(a.dur||0),r);return{timestamp:r,timing:(r-n.ts)/1e3}}static computeTimeOrigin(t,n){let r=i(()=>t.frameEvents.filter(this._isNavigationStartOfInterest).pop(),"lastNavigationStart"),a=i(()=>t.keyEvents.find(s=>s.name==="clock_sync"&&s.args.sync_id===e.TIMESPAN_MARKER_ID),"lighthouseMarker");switch(n){case"firstResourceSendRequest":{let o=t.keyEvents.find(s=>s.name!=="ResourceSendRequest"?!1:(s.args.data||{}).frame===t.mainFrameInfo.frameId);if(!o)throw this.createNoResourceSendRequestError();return o}case"lastNavigationStart":{let o=r();if(!o)throw this.createNoNavstartError();return o}case"lighthouseMar\
ker":{let o=a();if(!o)throw this.createNoLighthouseMarkerError();return o}case"auto":{let o=a()||r();if(!o)throw this.createNoNavstartError();return o}}}static computeNavigationTimingsForFrame(t,n){let{timeOriginEvt:r}=n,a=t.find(y=>y.name==="firstPaint"&&y.ts>r.ts),o=t.find(y=>y.name==="firstContentfulPaint"&&y.ts>r.ts);if(!o)throw this.createNoFirstContentfulPaintError();let s=this.computeValidLCPAllFrames(t,r),c=t.find(y=>y.name==="loadEventEnd"&&y.ts>r.ts),l=t.find(y=>y.name==="domContentLoadedEventEnd"&&y.ts>r.ts),u=i(y=>y?.ts,"getTimestamp"),m={timeOrigin:r.ts,firstPaint:u(a),firstContentfulPaint:o.ts,largestContentfulPaint:u(s.lcp),load:u(c),domContentLoaded:u(l)},p=i(y=>(y-r.ts)/1e3,"getTiming"),f=i(y=>y===void 0?void 0:p(y),"maybeGetTiming");return{timings:{timeOrigin:0,firstPaint:f(m.firstPaint),firstContentfulPaint:p(m.firstContentfulPaint),largestContentfulPaint:f(m.largestContentfulPaint),load:f(m.load),domContentLoaded:f(m.domContentLoaded)},timestamps:m,timeOriginEvt:r,firstPaintEvt:a,
firstContentfulPaintEvt:o,largestContentfulPaintEvt:s.lcp,loadEvt:c,domContentLoadedEvt:l,lcpInvalidated:s.invalidated}}}});var pD={};x(pD,{default:()=>wi});var B1,wi,Cl=g(()=>{"use strict";d();bt();po();B1=class e extends fe{static{i(this,"Trace")}_trace={traceEvents:[]};static getDefaultTraceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack","disabled-by-default-devtools.timeline.frame","latencyInfo","disabled-by-default-devtools.target-rundown","disabled-by-default-devtools.v8-source-rundown-sources","disabled-by-default-devtools.v8-source-rundown"]}static async endTraceAndCollectEvents(t){let n=[],r=i(function(a){n.push(...a.value)},"dataListener");return t.on("Tracing.dataCollected",r),new Promise((a,o)=>{t.once("Tracing.tracingComplete",s=>{t.off("Tracing.dataCollected",r),a({traceEvents:n})}),t.sendCommand("Tracing.end").catch(o)})}static symbol=Symbol("Trace");meta={symbol:e.symbol,supportedModes:[
"timespan","navigation"]};async startSensitiveInstrumentation({driver:t,gatherMode:n,settings:r}){let a=e.getDefaultTraceCategories().concat(r.additionalTraceCategories||[]);await t.defaultSession.sendCommand("Page.enable"),await t.defaultSession.sendCommand("Tracing.start",{categories:a.join(","),options:"sampling-frequency=10000"}),n==="timespan"&&await t.defaultSession.sendCommand("Tracing.recordClockSyncMarker",{syncId:Ln.TIMESPAN_MARKER_ID})}async stopSensitiveInstrumentation({driver:t}){this._trace=await e.endTraceAndCollectEvents(t.defaultSession)}getDebugData(){return this._trace}getArtifact(){return this._trace}},wi=B1});var fD={};x(fD,{default:()=>hr});var hr,fo=g(()=>{d();hr={}});function hD(e,t){for(var n=0,r=e.length-1;r>=0;r--){var a=e[r];a==="."?e.splice(r,1):a===".."?(e.splice(r,1),n++):n&&(e.splice(r,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}function j1(){for(var e="",t=!1,n=arguments.length-1;n>=-1&&!t;n--){var r=n>=0?arguments[n]:"/";if(typeof r!="string")throw new TypeError("Arguments to path.resolve must be strings");if(!r)continue;e=r+"/"+e,t=r.charAt(0)==="/"}return e=hD(q1(e.split("/"),function(a){return!!a}),!t).join("/"),(t?"/":"")+e||"."}function gD(e){var t=yD(e),n=pV(e,-1)==="/";return e=hD(q1(e.split("/"),function(r){return!!r}),!t).join("/"),!e&&!t&&(e="."),e&&n&&(e+="/"),(t?"/":"")+e}function yD(e){return e.charAt(0)==="/"}function iV(){var e=Array.prototype.slice.call(arguments,0);return gD(q1(e,function(t,n){if(typeof t!="string")throw new TypeError("Arguments to path.join must be strings");return t}).join("/"))}function sV(e,t){e=j1(e).substr(1),t=j1(t).substr(1);function n(u){for(var m=0;m<u.length&&u[m]==="";m++);for(var p=u.length-
1;p>=0&&u[p]==="";p--);return m>p?[]:u.slice(m,p-m+1)}i(n,"trim");for(var r=n(e.split("/")),a=n(t.split("/")),o=Math.min(r.length,a.length),s=o,c=0;c<o;c++)if(r[c]!==a[c]){s=c;break}for(var l=[],c=s;c<r.length;c++)l.push("..");return l=l.concat(a.slice(s)),l.join("/")}function uV(e){var t=H1(e),n=t[0],r=t[1];return!n&&!r?".":(r&&(r=r.substr(0,r.length-1)),n+r)}function dV(e,t){var n=H1(e)[2];return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n}function mV(e){return H1(e)[3]}function q1(e,t){if(e.filter)return e.filter(t);for(var n=[],r=0;r<e.length;r++)t(e[r],r,e)&&n.push(e[r]);return n}var oV,H1,cV,lV,At,pV,ho=g(()=>{d();i(hD,"normalizeArray");oV=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,H1=i(function(e){return oV.exec(e).slice(1)},"splitPath");i(j1,"resolve");i(gD,"normalize");i(yD,"isAbsolute");i(iV,"join");i(sV,"relative");cV="/",lV=":";i(uV,"dirname");i(dV,"basename");i(mV,"extname");At={extname:mV,basename:dV,dirname:uV,sep:cV,delimiter:lV,
relative:sV,join:iV,isAbsolute:yD,normalize:gD,resolve:j1};i(q1,"filter");pV="ab".substr(-1)==="b"?function(e,t,n){return e.substr(t,n)}:function(e,t,n){return t<0&&(t=e.length+t),e.substr(t,n)}});var fV,Ep,z1=g(()=>{d();fV=typeof globalThis=="object"&&globalThis&&globalThis.Object===Object&&globalThis,Ep=fV});var hV,gV,sn,Xr=g(()=>{d();z1();hV=typeof self=="object"&&self&&self.Object===Object&&self,gV=Ep||hV||Function("return this")(),sn=gV});var yV,xa,Tp=g(()=>{d();Xr();yV=sn.Symbol,xa=yV});function wV(e){var t=vV.call(e,kl),n=e[kl];try{e[kl]=void 0;var r=!0}catch{}var a=bV.call(e);return r&&(t?e[kl]=n:delete e[kl]),a}var vD,vV,bV,kl,bD,wD=g(()=>{d();Tp();vD=Object.prototype,vV=vD.hasOwnProperty,bV=vD.toString,kl=xa?xa.toStringTag:void 0;i(wV,"getRawTag");bD=wV});function xV(e){return TV.call(e)}var EV,TV,ED,TD=g(()=>{d();EV=Object.prototype,TV=EV.toString;i(xV,"objectToString");ED=xV});function kV(e){return e==null?e===void 0?CV:SV:xD&&xD in Object(e)?bD(e):ED(e)}var SV,CV,xD,Sa,Rl=g(()=>{d();Tp();wD();TD();SV="[object Null]",CV="[object Undefined]",xD=xa?xa.toStringTag:void 0;i(kV,"baseGetTag");Sa=kV});function RV(e){return e!=null&&typeof e=="object"}var Ca,_l=g(()=>{d();i(RV,"isObjectLike");Ca=RV});var _V,Ei,xp=g(()=>{d();_V=Array.isArray,Ei=_V});function IV(e){var t=typeof e;return e!=null&&(t=="object"||t=="function")}var Sp,G1=g(()=>{d();i(IV,"isObject");Sp=IV});function OV(e){if(!Sp(e))return!1;var t=Sa(e);return t==AV||t==NV||t==DV||t==MV}var DV,AV,NV,MV,Cp,W1=g(()=>{d();Rl();G1();DV="[object AsyncFunction]",AV="[object Function]",NV="[object GeneratorFunction]",MV="[object Proxy]";i(OV,"isFunction");Cp=OV});var PV,kp,SD=g(()=>{d();Xr();PV=sn["__core-js_shared__"],kp=PV});function LV(e){return!!CD&&CD in e}var CD,kD,RD=g(()=>{d();SD();CD=(function(){var e=/[^.]+$/.exec(kp&&kp.keys&&kp.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""})();i(LV,"isMasked");kD=LV});function BV(e){if(e!=null){try{return UV.call(e)}catch{}try{return e+""}catch{}}return""}var FV,UV,ka,V1=g(()=>{d();FV=Function.prototype,UV=FV.toString;i(BV,"toSource");ka=BV});function $V(e){if(!Sp(e)||kD(e))return!1;var t=Cp(e)?VV:HV;return t.test(ka(e))}var jV,HV,qV,zV,GV,WV,VV,_D,ID=g(()=>{d();W1();RD();G1();V1();jV=/[\\^$.*+?()[\]{}|]/g,HV=/^\[object .+?Constructor\]$/,qV=Function.prototype,zV=Object.prototype,GV=qV.toString,WV=zV.hasOwnProperty,VV=RegExp("^"+GV.call(WV).replace(jV,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");i($V,"baseIsNative");_D=$V});function YV(e,t){return e?.[t]}var DD,AD=g(()=>{d();i(YV,"getValue");DD=YV});function KV(e,t){var n=DD(e,t);return _D(n)?n:void 0}var gr,Ti=g(()=>{d();ID();AD();i(KV,"getNative");gr=KV});var XV,Rp,ND=g(()=>{d();Ti();Xr();XV=gr(sn,"WeakMap"),Rp=XV});function QV(e,t){var n=typeof e;return t=t??JV,!!t&&(n=="number"||n!="symbol"&&ZV.test(e))&&e>-1&&e%1==0&&e<t}var JV,ZV,MD,OD=g(()=>{d();JV=9007199254740991,ZV=/^(?:0|[1-9]\d*)$/;i(QV,"isIndex");MD=QV});function e$(e,t){return e===t||e!==e&&t!==t}var _p,$1=g(()=>{d();i(e$,"eq");_p=e$});function n$(e){return typeof e=="number"&&e>-1&&e%1==0&&e<=t$}var t$,Ip,Y1=g(()=>{d();t$=9007199254740991;i(n$,"isLength");Ip=n$});function r$(e){return e!=null&&Ip(e.length)&&!Cp(e)}var PD,LD=g(()=>{d();W1();Y1();i(r$,"isArrayLike");PD=r$});function o$(e){var t=e&&e.constructor,n=typeof t=="function"&&t.prototype||a$;return e===n}var a$,FD,UD=g(()=>{d();a$=Object.prototype;i(o$,"isPrototype");FD=o$});function i$(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}var BD,jD=g(()=>{d();i(i$,"baseTimes");BD=i$});function c$(e){return Ca(e)&&Sa(e)==s$}var s$,K1,HD=g(()=>{d();Rl();_l();s$="[object Arguments]";i(c$,"baseIsArguments");K1=c$});var qD,l$,u$,d$,zD,GD=g(()=>{d();HD();_l();qD=Object.prototype,l$=qD.hasOwnProperty,u$=qD.propertyIsEnumerable,d$=K1((function(){return arguments})())?K1:function(e){return Ca(e)&&l$.call(e,"callee")&&!u$.call(e,"callee")},zD=d$});function m$(){return!1}var WD,VD=g(()=>{d();i(m$,"stubFalse");WD=m$});var KD,$D,p$,YD,f$,h$,Il,X1=g(()=>{d();Xr();VD();KD=typeof exports=="object"&&exports&&!exports.nodeType&&exports,$D=KD&&typeof module=="object"&&module&&!module.nodeType&&module,p$=$D&&$D.exports===KD,YD=p$?sn.Buffer:void 0,f$=YD?YD.isBuffer:void 0,h$=f$||WD,Il=h$});function j$(e){return Ca(e)&&Ip(e.length)&&!!_t[Sa(e)]}var g$,y$,v$,b$,w$,E$,T$,x$,S$,C$,k$,R$,_$,I$,D$,A$,N$,M$,O$,P$,L$,F$,U$,B$,_t,XD,JD=g(()=>{d();Rl();Y1();_l();g$="[object Arguments]",y$="[object Array]",v$="[object Boolean]",b$="[object Date]",w$="[object Error]",E$="[object Function]",T$="[object Map]",x$="[object Number]",S$="[object Object]",C$="[object RegExp]",k$="[object Set]",R$="[object String]",_$="[object WeakMap]",I$="[object ArrayBuffer]",D$="[object DataView]",A$="[object Float32Array]",N$="[object Float64Array]",M$="[object Int8Array]",O$="[object Int16Array]",P$="[object Int32Array]",L$="[object Uint8Array]",F$="[object Uint8ClampedArray]",U$="[object Uint16Array]",B$="[object Uint32Array]",_t={};_t[A$]=_t[N$]=_t[M$]=_t[O$]=_t[P$]=_t[L$]=_t[F$]=_t[U$]=_t[B$]=!0;_t[g$]=_t[y$]=_t[I$]=_t[v$]=_t[D$]=_t[b$]=_t[w$]=_t[E$]=_t[T$]=_t[x$]=_t[S$]=_t[C$]=_t[k$]=_t[R$]=_t[_$]=!1;i(j$,"baseIsTypedArray");XD=j$});function H$(e){return function(t){return e(t)}}var ZD,QD=g(()=>{d();i(H$,"baseUnary");ZD=H$});var eA,Dl,q$,J1,z$,Z1,tA=g(()=>{d();z1();eA=typeof exports=="object"&&exports&&!exports.nodeType&&exports,Dl=eA&&typeof module=="object"&&module&&!module.nodeType&&module,q$=Dl&&Dl.exports===eA,J1=q$&&Ep.process,z$=(function(){try{var e=Dl&&Dl.require&&Dl.require("util").types;return e||J1&&J1.binding&&J1.binding("util")}catch{}})(),Z1=z$});var nA,G$,Dp,Q1=g(()=>{d();JD();QD();tA();nA=Z1&&Z1.isTypedArray,G$=nA?ZD(nA):XD,Dp=G$});function $$(e,t){var n=Ei(e),r=!n&&zD(e),a=!n&&!r&&Il(e),o=!n&&!r&&!a&&Dp(e),s=n||r||a||o,c=s?BD(e.length,String):[],l=c.length;for(var u in e)(t||V$.call(e,u))&&!(s&&(u=="length"||a&&(u=="offset"||u=="parent")||o&&(u=="buffer"||u=="byteLength"||u=="byteOffset")||MD(u,l)))&&c.push(u);return c}var W$,V$,rA,aA=g(()=>{d();jD();GD();xp();X1();OD();Q1();W$=Object.prototype,V$=W$.hasOwnProperty;i($$,"arrayLikeKeys");rA=$$});function Y$(e,t){return function(n){return e(t(n))}}var oA,iA=g(()=>{d();i(Y$,"overArg");oA=Y$});var K$,sA,cA=g(()=>{d();iA();K$=oA(Object.keys,Object),sA=K$});function Z$(e){if(!FD(e))return sA(e);var t=[];for(var n in Object(e))J$.call(e,n)&&n!="constructor"&&t.push(n);return t}var X$,J$,lA,uA=g(()=>{d();UD();cA();X$=Object.prototype,J$=X$.hasOwnProperty;i(Z$,"baseKeys");lA=Z$});function Q$(e){return PD(e)?rA(e):lA(e)}var dA,mA=g(()=>{d();aA();uA();LD();i(Q$,"keys");dA=Q$});var eY,Ra,Al=g(()=>{d();Ti();eY=gr(Object,"create"),Ra=eY});function tY(){this.__data__=Ra?Ra(null):{},this.size=0}var pA,fA=g(()=>{d();Al();i(tY,"hashClear");pA=tY});function nY(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}var hA,gA=g(()=>{d();i(nY,"hashDelete");hA=nY});function iY(e){var t=this.__data__;if(Ra){var n=t[e];return n===rY?void 0:n}return oY.call(t,e)?t[e]:void 0}var rY,aY,oY,yA,vA=g(()=>{d();Al();rY="__lodash_hash_undefined__",aY=Object.prototype,oY=aY.hasOwnProperty;i(iY,"hashGet");yA=iY});function lY(e){var t=this.__data__;return Ra?t[e]!==void 0:cY.call(t,e)}var sY,cY,bA,wA=g(()=>{d();Al();sY=Object.prototype,cY=sY.hasOwnProperty;i(lY,"hashHas");bA=lY});function dY(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=Ra&&t===void 0?uY:t,this}var uY,EA,TA=g(()=>{d();Al();uY="__lodash_hash_undefined__";i(dY,"hashSet");EA=dY});function Is(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}var ey,xA=g(()=>{d();fA();gA();vA();wA();TA();i(Is,"Hash");Is.prototype.clear=pA;Is.prototype.delete=hA;Is.prototype.get=yA;Is.prototype.has=bA;Is.prototype.set=EA;ey=Is});function mY(){this.__data__=[],this.size=0}var SA,CA=g(()=>{d();i(mY,"listCacheClear");SA=mY});function pY(e,t){for(var n=e.length;n--;)if(_p(e[n][0],t))return n;return-1}var go,Nl=g(()=>{d();$1();i(pY,"assocIndexOf");go=pY});function gY(e){var t=this.__data__,n=go(t,e);if(n<0)return!1;var r=t.length-1;return n==r?t.pop():hY.call(t,n,1),--this.size,!0}var fY,hY,kA,RA=g(()=>{d();Nl();fY=Array.prototype,hY=fY.splice;i(gY,"listCacheDelete");kA=gY});function yY(e){var t=this.__data__,n=go(t,e);return n<0?void 0:t[n][1]}var _A,IA=g(()=>{d();Nl();i(yY,"listCacheGet");_A=yY});function vY(e){return go(this.__data__,e)>-1}var DA,AA=g(()=>{d();Nl();i(vY,"listCacheHas");DA=vY});function bY(e,t){var n=this.__data__,r=go(n,e);return r<0?(++this.size,n.push([e,t])):n[r][1]=t,this}var NA,MA=g(()=>{d();Nl();i(bY,"listCacheSet");NA=bY});function Ds(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}var yo,Ml=g(()=>{d();CA();RA();IA();AA();MA();i(Ds,"ListCache");Ds.prototype.clear=SA;Ds.prototype.delete=kA;Ds.prototype.get=_A;Ds.prototype.has=DA;Ds.prototype.set=NA;yo=Ds});var wY,vo,Ap=g(()=>{d();Ti();Xr();wY=gr(sn,"Map"),vo=wY});function EY(){this.size=0,this.__data__={hash:new ey,map:new(vo||yo),string:new ey}}var OA,PA=g(()=>{d();xA();Ml();Ap();i(EY,"mapCacheClear");OA=EY});function TY(e){var t=typeof e;return t=="string"||t=="number"||t=="symbol"||t=="boolean"?e!=="__proto__":e===null}var LA,FA=g(()=>{d();i(TY,"isKeyable");LA=TY});function xY(e,t){var n=e.__data__;return LA(t)?n[typeof t=="string"?"string":"hash"]:n.map}var bo,Ol=g(()=>{d();FA();i(xY,"getMapData");bo=xY});function SY(e){var t=bo(this,e).delete(e);return this.size-=t?1:0,t}var UA,BA=g(()=>{d();Ol();i(SY,"mapCacheDelete");UA=SY});function CY(e){return bo(this,e).get(e)}var jA,HA=g(()=>{d();Ol();i(CY,"mapCacheGet");jA=CY});function kY(e){return bo(this,e).has(e)}var qA,zA=g(()=>{d();Ol();i(kY,"mapCacheHas");qA=kY});function RY(e,t){var n=bo(this,e),r=n.size;return n.set(e,t),this.size+=n.size==r?0:1,this}var GA,WA=g(()=>{d();Ol();i(RY,"mapCacheSet");GA=RY});function As(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}var Np,ty=g(()=>{d();PA();BA();HA();zA();WA();i(As,"MapCache");As.prototype.clear=OA;As.prototype.delete=UA;As.prototype.get=jA;As.prototype.has=qA;As.prototype.set=GA;Np=As});function _Y(e,t){for(var n=-1,r=t.length,a=e.length;++n<r;)e[a+n]=t[n];return e}var VA,$A=g(()=>{d();i(_Y,"arrayPush");VA=_Y});function IY(){this.__data__=new yo,this.size=0}var YA,KA=g(()=>{d();Ml();i(IY,"stackClear");YA=IY});function DY(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n}var XA,JA=g(()=>{d();i(DY,"stackDelete");XA=DY});function AY(e){return this.__data__.get(e)}var ZA,QA=g(()=>{d();i(AY,"stackGet");ZA=AY});function NY(e){return this.__data__.has(e)}var eN,tN=g(()=>{d();i(NY,"stackHas");eN=NY});function OY(e,t){var n=this.__data__;if(n instanceof yo){var r=n.__data__;if(!vo||r.length<MY-1)return r.push([e,t]),this.size=++n.size,this;n=this.__data__=new Np(r)}return n.set(e,t),this.size=n.size,this}var MY,nN,rN=g(()=>{d();Ml();Ap();ty();MY=200;i(OY,"stackSet");nN=OY});function Ns(e){var t=this.__data__=new yo(e);this.size=t.size}var Mp,aN=g(()=>{d();Ml();KA();JA();QA();tN();rN();i(Ns,"Stack");Ns.prototype.clear=YA;Ns.prototype.delete=XA;Ns.prototype.get=ZA;Ns.prototype.has=eN;Ns.prototype.set=nN;Mp=Ns});function PY(e,t){for(var n=-1,r=e==null?0:e.length,a=0,o=[];++n<r;){var s=e[n];t(s,n,e)&&(o[a++]=s)}return o}var oN,iN=g(()=>{d();i(PY,"arrayFilter");oN=PY});function LY(){return[]}var sN,cN=g(()=>{d();i(LY,"stubArray");sN=LY});var FY,UY,lN,BY,uN,dN=g(()=>{d();iN();cN();FY=Object.prototype,UY=FY.propertyIsEnumerable,lN=Object.getOwnPropertySymbols,BY=lN?function(e){return e==null?[]:(e=Object(e),oN(lN(e),function(t){return UY.call(e,t)}))}:sN,uN=BY});function jY(e,t,n){var r=t(e);return Ei(e)?r:VA(r,n(e))}var mN,pN=g(()=>{d();$A();xp();i(jY,"baseGetAllKeys");mN=jY});function HY(e){return mN(e,dA,uN)}var ny,fN=g(()=>{d();pN();dN();mA();i(HY,"getAllKeys");ny=HY});var qY,Op,hN=g(()=>{d();Ti();Xr();qY=gr(sn,"DataView"),Op=qY});var zY,Pp,gN=g(()=>{d();Ti();Xr();zY=gr(sn,"Promise"),Pp=zY});var GY,Lp,yN=g(()=>{d();Ti();Xr();GY=gr(sn,"Set"),Lp=GY});var vN,WY,bN,wN,EN,TN,VY,$Y,YY,KY,XY,xi,ry,xN=g(()=>{d();hN();Ap();gN();yN();ND();Rl();V1();vN="[object Map]",WY="[object Object]",bN="[object Promise]",wN="[object Set]",EN="[object WeakMap]",TN="[object DataView]",VY=ka(Op),$Y=ka(vo),YY=ka(Pp),KY=ka(Lp),XY=ka(Rp),xi=Sa;(Op&&xi(new Op(new ArrayBuffer(1)))!=TN||vo&&xi(new vo)!=vN||Pp&&xi(Pp.resolve())!=bN||Lp&&xi(new Lp)!=wN||Rp&&xi(new Rp)!=EN)&&(xi=i(function(e){var t=Sa(e),n=t==WY?e.constructor:void 0,r=n?ka(n):"";if(r)switch(r){case VY:return TN;case $Y:return vN;case YY:return bN;case KY:return wN;case XY:return EN}return t},"getTag"));ry=xi});var JY,ay,SN=g(()=>{d();Xr();JY=sn.Uint8Array,ay=JY});function QY(e){return this.__data__.set(e,ZY),this}var ZY,CN,kN=g(()=>{d();ZY="__lodash_hash_undefined__";i(QY,"setCacheAdd");CN=QY});function eK(e){return this.__data__.has(e)}var RN,_N=g(()=>{d();i(eK,"setCacheHas");RN=eK});function Fp(e){var t=-1,n=e==null?0:e.length;for(this.__data__=new Np;++t<n;)this.add(e[t])}var IN,DN=g(()=>{d();ty();kN();_N();i(Fp,"SetCache");Fp.prototype.add=Fp.prototype.push=CN;Fp.prototype.has=RN;IN=Fp});function tK(e,t){for(var n=-1,r=e==null?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}var AN,NN=g(()=>{d();i(tK,"arraySome");AN=tK});function nK(e,t){return e.has(t)}var MN,ON=g(()=>{d();i(nK,"cacheHas");MN=nK});function oK(e,t,n,r,a,o){var s=n&rK,c=e.length,l=t.length;if(c!=l&&!(s&&l>c))return!1;var u=o.get(e),m=o.get(t);if(u&&m)return u==t&&m==e;var p=-1,f=!0,h=n&aK?new IN:void 0;for(o.set(e,t),o.set(t,e);++p<c;){var y=e[p],b=t[p];if(r)var w=s?r(b,y,p,t,e,o):r(y,b,p,e,t,o);if(w!==void 0){if(w)continue;f=!1;break}if(h){if(!AN(t,function(C,k){if(!MN(h,k)&&(y===C||a(y,C,n,r,o)))return h.push(k)})){f=!1;break}}else if(!(y===b||a(y,b,n,r,o))){f=!1;break}}return o.delete(e),o.delete(t),f}var rK,aK,Up,oy=g(()=>{d();DN();NN();ON();rK=1,aK=2;i(oK,"equalArrays");Up=oK});function iK(e){var t=-1,n=Array(e.size);return e.forEach(function(r,a){n[++t]=[a,r]}),n}var PN,LN=g(()=>{d();i(iK,"mapToArray");PN=iK});function sK(e){var t=-1,n=Array(e.size);return e.forEach(function(r){n[++t]=r}),n}var FN,UN=g(()=>{d();i(sK,"setToArray");FN=sK});function EK(e,t,n,r,a,o,s){switch(n){case wK:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case bK:return!(e.byteLength!=t.byteLength||!o(new ay(e),new ay(t)));case uK:case dK:case fK:return _p(+e,+t);case mK:return e.name==t.name&&e.message==t.message;case hK:case yK:return e==t+"";case pK:var c=PN;case gK:var l=r&cK;if(c||(c=FN),e.size!=t.size&&!l)return!1;var u=s.get(e);if(u)return u==t;r|=lK,s.set(e,t);var m=Up(c(e),c(t),r,a,o,s);return s.delete(e),m;case vK:if(iy)return iy.call(e)==iy.call(t)}return!1}var cK,lK,uK,dK,mK,pK,fK,hK,gK,yK,vK,bK,wK,BN,iy,jN,HN=g(()=>{d();Tp();SN();$1();oy();LN();UN();cK=1,lK=2,uK="[object Boolean]",dK="[object Date]",mK="[object Error]",pK="[object Map]",fK="[object Number]",hK="[object RegExp]",gK="[object Set]",yK="[object String]",vK="[object Symbol]",bK="[object ArrayBuffer]",wK="[object DataView]",BN=xa?xa.prototype:void 0,iy=BN?BN.valueOf:void 0;i(EK,"equalByTag");jN=EK});function CK(e,t,n,r,a,o){var s=n&TK,c=ny(e),l=c.length,u=ny(t),m=u.length;if(l!=m&&!s)return!1;for(var p=l;p--;){var f=c[p];if(!(s?f in t:SK.call(t,f)))return!1}var h=o.get(e),y=o.get(t);if(h&&y)return h==t&&y==e;var b=!0;o.set(e,t),o.set(t,e);for(var w=s;++p<l;){f=c[p];var C=e[f],k=t[f];if(r)var R=s?r(k,C,f,t,e,o):r(C,k,f,e,t,o);if(!(R===void 0?C===k||a(C,k,n,r,o):R)){b=!1;break}w||(w=f=="constructor")}if(b&&!w){var S=e.constructor,_=t.constructor;S!=_&&"constructor"in e&&"constructor"in t&&!(typeof S=="function"&&S instanceof S&&typeof _=="function"&&_ instanceof _)&&(b=!1)}return o.delete(e),o.delete(t),b}var TK,xK,SK,qN,zN=g(()=>{d();fN();TK=1,xK=Object.prototype,SK=xK.hasOwnProperty;i(CK,"equalObjects");qN=CK});function _K(e,t,n,r,a,o){var s=Ei(e),c=Ei(t),l=s?WN:ry(e),u=c?WN:ry(t);l=l==GN?Bp:l,u=u==GN?Bp:u;var m=l==Bp,p=u==Bp,f=l==u;if(f&&Il(e)){if(!Il(t))return!1;s=!0,m=!1}if(f&&!m)return o||(o=new Mp),s||Dp(e)?Up(e,t,n,r,a,o):jN(e,t,l,n,r,a,o);if(!(n&kK)){var h=m&&VN.call(e,"__wrapped__"),y=p&&VN.call(t,"__wrapped__");if(h||y){var b=h?e.value():e,w=y?t.value():t;return o||(o=new Mp),a(b,w,n,r,o)}}return f?(o||(o=new Mp),qN(e,t,n,r,a,o)):!1}var kK,GN,WN,Bp,RK,VN,$N,YN=g(()=>{d();aN();oy();HN();zN();xN();xp();X1();Q1();kK=1,GN="[object Arguments]",WN="[object Array]",Bp="[object Object]",RK=Object.prototype,VN=RK.hasOwnProperty;i(_K,"baseIsEqualDeep");$N=_K});function KN(e,t,n,r,a){return e===t?!0:e==null||t==null||!Ca(e)&&!Ca(t)?e!==e&&t!==t:$N(e,t,n,r,KN,a)}var XN,JN=g(()=>{d();YN();_l();i(KN,"baseIsEqual");XN=KN});function IK(e,t){return XN(e,t)}var Jr,ZN=g(()=>{d();JN();i(IK,"isEqual");Jr=IK});var Pl=g(()=>{d();ZN();});var Ms,jp=g(()=>{"use strict";d();co();Ms=!!Sn.env.CI||Sn.env.NODE_ENV==="test"});function MK(e){let t=Math.sign(e);e=Math.abs(e);let n=.254829592,r=-.284496736,a=1.421413741,o=-1.453152027,s=1.061405429,l=1/(1+.3275911*e),u=l*(n+l*(r+l*(a+l*(o+l*s))));return t*(1-u*Math.exp(-e*e))}function QN({median:e,p10:t},n){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;let r=.9061938024368232,a=Math.max(Number.MIN_VALUE,n/e),o=Math.log(a),s=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(s),l=o*r/c,u=(1-MK(l))/2,m;return n<=t?m=Math.max(.9,Math.min(1,u)):n<=e?m=Math.max(AK,Math.min(DK,u)):m=Math.max(0,Math.min(NK,u)),m}var DK,AK,NK,eM=g(()=>{"use strict";d();DK=.8999999999999999,AK=.5,NK=.49999999999999994;i(MK,"erf");i(QN,"getLogNormalScore")});var _a,PK,tM,LK,FK,ot,Zr=g(()=>{"use strict";d();eM();_a="…",PK=" ",tM=.9,LK={PASS:{label:"pass",minScore:tM},AVERAGE:{label:"average",minScore:.5},FAIL:{label:"fail"},ERROR:{label:"error"}},FK=["com","co","gov","edu","ac","org","go","gob","or","net","in","ne","nic","gouv","web","spb","blog","jus","kiev","mil","wi","qc","ca","bel","on"],ot=class e{static{i(this,"Util")}static get RATINGS(){return LK}static get PASS_THRESHOLD(){return tM}static get MS_DISPLAY_VALUE(){return`%10d${PK}ms`}static getFinalDisplayedUrl(t){if(t.finalDisplayedUrl)return t.finalDisplayedUrl;if(t.finalUrl)return t.finalUrl;throw new Error("Could not determine final displayed URL")}static getMainDocumentUrl(t){return t.mainDocumentUrl||t.finalUrl}static getFullPageScreenshot(t){return t.fullPageScreenshot?t.fullPageScreenshot:t.audits["full-page-screenshot"]?.details}static getEntityFromUrl(t,n){return n&&n.find(a=>a.origins.find(o=>t.startsWith(o)))||e.getPseudoRootDomain(t)}static splitMarkdownCodeSpans(t){let n=[],
r=t.split(/`(.*?)`/g);for(let a=0;a<r.length;a++){let o=r[a];if(!o)continue;let s=a%2!==0;n.push({isCode:s,text:o})}return n}static splitMarkdownLink(t){let n=[],r=t.split(/\[([^\]]+?)\]\((https?:\/\/.*?)\)/g);for(;r.length;){let[a,o,s]=r.splice(0,3);a&&n.push({isLink:!1,text:a}),o&&s&&n.push({isLink:!0,text:o,linkHref:s})}return n}static truncate(t,n,r="…"){if(t.length<=n)return t;let o=new Intl.Segmenter(void 0,{granularity:"grapheme"}).segment(t)[Symbol.iterator](),s=0;for(let c=0;c<=n-r.length;c++){let l=o.next();if(l.done)return t;s=l.value.index}for(let c=0;c<r.length;c++)if(o.next().done)return t;return t.slice(0,s)+r}static getURLDisplayName(t,n){n=n||{numPathParts:void 0,preserveQuery:void 0,preserveHost:void 0};let r=n.numPathParts!==void 0?n.numPathParts:2,a=n.preserveQuery!==void 0?n.preserveQuery:!0,o=n.preserveHost||!1,s;if(t.protocol==="about:"||t.protocol==="data:")s=t.href;else{s=t.pathname;let l=s.split("/").filter(u=>u.length);r&&l.length>r&&(s=_a+l.slice(-1*r).join(
"/")),o&&(s=`${t.host}/${s.replace(/^\//,"")}`),a&&(s=`${s}${t.search}`)}let c=64;if(t.protocol!=="data:"&&(s=s.slice(0,200),s=s.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${_a}`),s=s.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${_a}`),s=s.replace(/(\d{3})\d{6,}/g,`$1${_a}`),s=s.replace(/\u2026+/g,_a),s.length>c&&s.includes("?")&&(s=s.replace(/\?([^=]*)(=)?.*/,`?$1$2${_a}`),s.length>c&&(s=s.replace(/\?.*/,`?${_a}`)))),s.length>c){let l=s.lastIndexOf(".");l>=0?s=s.slice(0,c-1-(s.length-l))+`${_a}${s.slice(l)}`:s=s.slice(0,c-1)+_a}return s}static getChromeExtensionOrigin(t){let n=new URL(t);return n.protocol+"//"+n.host}static parseURL(t){let n=new URL(t);return{file:e.getURLDisplayName(n),hostname:n.hostname,origin:n.protocol==="chrome-extension:"?e.getChromeExtensionOrigin(t):n.origin}}static createOrReturnURL(t){return t instanceof URL?t:new URL(t)}static getPseudoTld(t){let n=t.split(".").slice(-2);return FK.includes(n[0])?`.${n.join(".")}`:
`.${n[n.length-1]}`}static getPseudoRootDomain(t){let n=e.createOrReturnURL(t).hostname,a=e.getPseudoTld(n).split(".");return n.split(".").slice(-a.length).join(".")}static filterRelevantLines(t,n,r){if(n.length===0)return t.slice(0,r*2+1);let a=3,o=new Set;return n=n.sort((s,c)=>(s.lineNumber||0)-(c.lineNumber||0)),n.forEach(({lineNumber:s})=>{let c=s-r,l=s+r;for(;c<1;)c++,l++;o.has(c-a-1)&&(c-=a);for(let u=c;u<=l;u++){let m=u;o.add(m)}}),t.filter(s=>o.has(s.lineNumber))}static computeLogNormalScore(t,n){let r=QN(t,n);return r>.9&&(r+=.05*(r-.9)),Math.floor(r*100)/100}}});var UK,BK,E,$=g(()=>{"use strict";d();Cn();jp();Zr();UK={FCP:50,LCP:50,INP:50,TBT:50,CLS:.001},BK=i(e=>Math.round(e*100)/100,"clampTo2Decimals"),E=class e{static{i(this,"Audit")}static get SCORING_MODES(){return{NUMERIC:"numeric",METRIC_SAVINGS:"metricSavings",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(t,n){throw new Error("audit() method must be overridden")}static computeLogNormalScore(t,n){return ot.computeLogNormalScore(t,n)}static assertHeadingKeysExist(t,n){if(n.length&&Ms)for(let r of t){if(r.key===null)continue;let a=r.key;if(!n.some(o=>a in o))throw new Error(`"${r.key}" is missing from items`)}}static makeChecklistDetails(t){return{type:"checklist",items:t}}static makeTableDetails(t,n,r={}){let{wastedBytes:a,wastedMs:o,sortedBy:s,skipSumming:c,isEntityGrouped:l}=r,u=a||o?{wastedBytes:a,wastedMs:o}:
void 0;return n.length===0?{type:"table",headings:t,items:[],summary:u}:(e.assertHeadingKeysExist(t,n),{type:"table",headings:t,items:n,summary:u,sortedBy:s,skipSumming:c,isEntityGrouped:l})}static makeListDetails(t){return{type:"list",items:t}}static makeListDetailSectionItem(t,n,r){return{type:"list-section",title:n,description:r,value:t}}static makeSnippetDetails({content:t,title:n,lineMessages:r,generalMessages:a,node:o,maxLineLength:s=200,maxLinesAroundMessage:c=20}){let l=e._makeSnippetLinesArray(t,s);return{type:"snippet",lines:ot.filterRelevantLines(l,r,c),title:n,lineMessages:r,generalMessages:a,lineCount:l.length,node:o}}static _makeSnippetLinesArray(t,n){return t.split(`
`).map((r,a)=>{let o=a+1,s={content:ot.truncate(r,n),lineNumber:o};return r.length>n&&(s.truncated=!0),s})}static makeOpportunityDetails(t,n,r){e.assertHeadingKeysExist(t,n);let{overallSavingsMs:a,overallSavingsBytes:o,sortedBy:s,skipSumming:c,isEntityGrouped:l}=r;return{type:"opportunity",headings:n.length===0?[]:t,items:n,overallSavingsMs:a,overallSavingsBytes:o,sortedBy:s,skipSumming:c,isEntityGrouped:l}}static makeNodeItem(t){return{type:"node",lhId:t.lhId,path:t.devtoolsNodePath,selector:t.selector,boundingRect:t.boundingRect,snippet:t.snippet,nodeLabel:t.nodeLabel}}static _findOriginalLocation(t,n,r){let a=t?.map.findEntry(n,r);if(a)return{file:a.sourceURL||"",line:a.sourceLineNumber||0,column:a.sourceColumnNumber||0}}static makeSourceLocation(t,n,r,a){return{type:"source-location",url:t,urlProvider:"network",line:n,column:r,original:a&&this._findOriginalLocation(a,n,r)}}static makeSourceLocationFromConsoleMessage(t,n){if(!t.url)return;let r=t.lineNumber||0,a=t.columnNumber||0;return this.
makeSourceLocation(t.url,r,a,n)}static _normalizeAuditScore(t,n,r){if(n===e.SCORING_MODES.INFORMATIVE)return 1;if(n!==e.SCORING_MODES.BINARY&&n!==e.SCORING_MODES.NUMERIC&&n!==e.SCORING_MODES.METRIC_SAVINGS)return null;if(t===null||!Number.isFinite(t))throw new Error(`Invalid score for ${r}: ${t}`);if(t>1)throw new Error(`Audit score for ${r} is > 1`);if(t<0)throw new Error(`Audit score for ${r} is < 0`);return t=BK(t),t}static _quantizeMetricSavings(t){if(!t)return;let n={...t};for(let r of Object.keys(t)){let a=t[r];if(a===void 0)continue;a=Math.max(a,0);let o=UK[r];o!==void 0&&(a=Math.round(a/o)*o),n[r]=a}return n}static generateErrorAuditResult(t,n,r){return e.generateAuditResult(t,{score:null,errorMessage:n,errorStack:r})}static generateAuditResult(t,n){if(n.score===void 0)throw new Error("generateAuditResult requires a score");let r=t.meta.scoreDisplayMode||e.SCORING_MODES.BINARY,a=n.score;n.errorMessage!==void 0?r=e.SCORING_MODES.ERROR:n.notApplicable?r=e.SCORING_MODES.NOT_APPLICABLE:
n.scoreDisplayMode&&(r=n.scoreDisplayMode);let o=e._quantizeMetricSavings(n.metricSavings),s=Object.values(o||{}).some(u=>u);r===e.SCORING_MODES.METRIC_SAVINGS&&(a&&a>=ot.PASS_THRESHOLD?a=1:s?a=0:a=.5),a=e._normalizeAuditScore(a,r,t.meta.id);let c=t.meta.title;t.meta.failureTitle&&a!==null&&a<ot.PASS_THRESHOLD&&(c=t.meta.failureTitle);let l="numericUnit"in n?n:void 0;return{id:t.meta.id,title:c,description:t.meta.description,score:a,scoreDisplayMode:r,numericValue:l?.numericValue,numericUnit:l?.numericUnit,displayValue:n.displayValue,explanation:n.explanation,errorMessage:n.errorMessage,errorStack:n.errorStack,warnings:n.warnings,scoringOptions:n.scoringOptions,metricSavings:o,details:n.details,guidanceLevel:t.meta.guidanceLevel}}static makeMetricComputationDataInput(t,n){let r=t.Trace,a=t.DevtoolsLog,o=t.GatherContext,{URL:s,HostDPR:c,SourceMaps:l}=t;return{trace:r,devtoolsLog:a,gatherContext:o,settings:n.settings,URL:s,SourceMaps:l,HostDPR:c,simulator:null}}}});var jK,Hp,nM=g(()=>{"use strict";d();$();jK=i(e=>Math.round(e*100)/100,"clampTo2Decimals"),Hp=class e{static{i(this,"ReportScoring")}static arithmeticMean(t){if(t=t.filter(r=>r.weight>0),t.some(r=>r.score===null))return null;let n=t.reduce((r,a)=>{let o=a.score,s=a.weight;return{weight:r.weight+s,sum:r.sum+o*s}},{weight:0,sum:0});return jK(n.sum/n.weight||0)}static scoreAllCategories(t,n){let r={};for(let[a,o]of Object.entries(t)){let s=o.auditRefs.map(u=>{let m={...u},p=n[m.id];return(p.scoreDisplayMode===E.SCORING_MODES.NOT_APPLICABLE||p.scoreDisplayMode===E.SCORING_MODES.INFORMATIVE||p.scoreDisplayMode===E.SCORING_MODES.MANUAL)&&(m.weight=0),m}),c=s.map(u=>({score:n[u.id].score,weight:u.weight})),l=e.arithmeticMean(c);r[a]={...o,auditRefs:s,id:a,score:l}}return r}}});function Ll(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");sy(e,t);function n(){this.constructor=e}i(n,"__"),e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}function rM(e,t){var n={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(n[r]=e[r]);if(e!=null&&typeof Object.getOwnPropertySymbols=="function")for(var a=0,r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(n[r[a]]=e[r[a]]);return n}function qp(e,t,n){if(n||arguments.length===2)for(var r=0,a=t.length,o;r<a;r++)(o||!(r in t))&&(o||(o=Array.prototype.slice.call(t,0,r)),o[r]=t[r]);return e.concat(o||Array.prototype.slice.call(t))}var sy,Ur,cy=g(()=>{d();sy=i(function(e,t){return sy=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,r){n.__proto__=r}||function(n,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(n[a]=
r[a])},sy(e,t)},"extendStatics");i(Ll,"__extends");Ur=i(function(){return Ur=Object.assign||i(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),Ur.apply(this,arguments)},"__assign");i(rM,"__rest");i(qp,"__spreadArray")});var Os,ly=g(()=>{d();Os=i(function(){return Os=Object.assign||i(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),Os.apply(this,arguments)},"__assign")});var Ke,uy=g(()=>{d();(function(e){e[e.EXPECT_ARGUMENT_CLOSING_BRACE=1]="EXPECT_ARGUMENT_CLOSING_BRACE",e[e.EMPTY_ARGUMENT=2]="EMPTY_ARGUMENT",e[e.MALFORMED_ARGUMENT=3]="MALFORMED_ARGUMENT",e[e.EXPECT_ARGUMENT_TYPE=4]="EXPECT_ARGUMENT_TYPE",e[e.INVALID_ARGUMENT_TYPE=5]="INVALID_ARGUMENT_TYPE",e[e.EXPECT_ARGUMENT_STYLE=6]="EXPECT_ARGUMENT_STYLE",e[e.INVALID_NUMBER_SKELETON=7]="INVALID_NUMBER_SKELETON",e[e.INVALID_DATE_TIME_SKELETON=8]="INVALID_DATE_TIME_SKELETON",e[e.EXPECT_NUMBER_SKELETON=9]="EXPECT_NUMBER_SKELETON",e[e.EXPECT_DATE_TIME_SKELETON=10]="EXPECT_DATE_TIME_SKELETON",e[e.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE=11]="UNCLOSED_QUOTE_IN_ARGUMENT_STYLE",e[e.EXPECT_SELECT_ARGUMENT_OPTIONS=12]="EXPECT_SELECT_ARGUMENT_OPTIONS",e[e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE=13]="EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE=14]="INVALID_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR=15]="EXPECT_SELECT_ARGUMENT_SELECTOR",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR=
16]="EXPECT_PLURAL_ARGUMENT_SELECTOR",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT=17]="EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT=18]="EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT",e[e.INVALID_PLURAL_ARGUMENT_SELECTOR=19]="INVALID_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_PLURAL_ARGUMENT_SELECTOR=20]="DUPLICATE_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_SELECT_ARGUMENT_SELECTOR=21]="DUPLICATE_SELECT_ARGUMENT_SELECTOR",e[e.MISSING_OTHER_CLAUSE=22]="MISSING_OTHER_CLAUSE",e[e.INVALID_TAG=23]="INVALID_TAG",e[e.INVALID_TAG_NAME=25]="INVALID_TAG_NAME",e[e.UNMATCHED_CLOSING_TAG=26]="UNMATCHED_CLOSING_TAG",e[e.UNCLOSED_TAG=27]="UNCLOSED_TAG"})(Ke||(Ke={}))});function dy(e){return e.type===It.literal}function aM(e){return e.type===It.argument}function zp(e){return e.type===It.number}function Gp(e){return e.type===It.date}function Wp(e){return e.type===It.time}function Vp(e){return e.type===It.select}function $p(e){return e.type===It.plural}function oM(e){return e.type===It.pound}function Yp(e){return e.type===It.tag}function Kp(e){return!!(e&&typeof e=="object"&&e.type===Si.number)}function Fl(e){return!!(e&&typeof e=="object"&&e.type===Si.dateTime)}var It,Si,Xp=g(()=>{d();(function(e){e[e.literal=0]="literal",e[e.argument=1]="argument",e[e.number=2]="number",e[e.date=3]="date",e[e.time=4]="time",e[e.select=5]="select",e[e.plural=6]="plural",e[e.pound=7]="pound",e[e.tag=8]="tag"})(It||(It={}));(function(e){e[e.number=0]="number",e[e.dateTime=1]="dateTime"})(Si||(Si={}));i(dy,"isLiteralElement");i(aM,"isArgumentElement");i(zp,"isNumberElement");i(Gp,"isDateElement");i(Wp,"isTimeElement");i(Vp,"isSelectElement");i($p,"isPluralElement");i(oM,"\
isPoundElement");i(Yp,"isTagElement");i(Kp,"isNumberSkeleton");i(Fl,"isDateTimeSkeleton")});var my,iM=g(()=>{d();my=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/});function sM(e){var t={};return e.replace(HK,function(n){var r=n.length;switch(n[0]){case"G":t.era=r===4?"long":r===5?"narrow":"short";break;case"y":t.year=r===2?"2-digit":"numeric";break;case"Y":case"u":case"U":case"r":throw new RangeError("`Y/u/U/r` (year) patterns are not supported, use `y` instead");case"q":case"Q":throw new RangeError("`q/Q` (quarter) patterns are not supported");case"M":case"L":t.month=["numeric","2-digit","short","long","narrow"][r-1];break;case"w":case"W":throw new RangeError("`w/W` (week) patterns are not supported");case"d":t.day=["numeric","2-digit"][r-1];break;case"D":case"F":case"g":throw new RangeError("`D/F/g` (day) patterns are not supported, use `d` instead");case"E":t.weekday=r===4?"short":r===5?"narrow":"short";break;case"e":if(r<4)throw new RangeError("`e..eee` (weekday) patterns are not supported");t.weekday=["short","long","narrow","short"][r-4];break;case"c":if(r<4)throw new RangeError("`c..ccc` (weekday) patterns are not supported");t.weekday=["s\
hort","long","narrow","short"][r-4];break;case"a":t.hour12=!0;break;case"b":case"B":throw new RangeError("`b/B` (period) patterns are not supported, use `a` instead");case"h":t.hourCycle="h12",t.hour=["numeric","2-digit"][r-1];break;case"H":t.hourCycle="h23",t.hour=["numeric","2-digit"][r-1];break;case"K":t.hourCycle="h11",t.hour=["numeric","2-digit"][r-1];break;case"k":t.hourCycle="h24",t.hour=["numeric","2-digit"][r-1];break;case"j":case"J":case"C":throw new RangeError("`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead");case"m":t.minute=["numeric","2-digit"][r-1];break;case"s":t.second=["numeric","2-digit"][r-1];break;case"S":case"A":throw new RangeError("`S/A` (second) patterns are not supported, use `s` instead");case"z":t.timeZoneName=r<4?"short":"long";break;case"Z":case"O":case"v":case"V":case"X":case"x":throw new RangeError("`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead")}return""}),t}var HK,cM=g(()=>{d();HK=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
i(sM,"parseDateTimeSkeleton")});var Lt,lM=g(()=>{d();Lt=i(function(){return Lt=Object.assign||i(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),Lt.apply(this,arguments)},"__assign")});var uM,dM=g(()=>{d();uM=/[\t-\r \x85\u200E\u200F\u2028\u2029]/i});function hM(e){if(e.length===0)throw new Error("Number skeleton cannot be empty");for(var t=e.split(uM).filter(function(f){return f.length>0}),n=[],r=0,a=t;r<a.length;r++){var o=a[r],s=o.split("/");if(s.length===0)throw new Error("Invalid number skeleton");for(var c=s[0],l=s.slice(1),u=0,m=l;u<m.length;u++){var p=m[u];if(p.length===0)throw new Error("Invalid number skeleton")}n.push({stem:c,options:l})}return n}function qK(e){return e.replace(/^(.*?)-/,"")}function pM(e){var t={};return e[e.length-1]==="r"?t.roundingPriority="morePrecision":e[e.length-1]==="s"&&(t.roundingPriority="lessPrecision"),e.replace(gM,function(n,r,a){return typeof a!="string"?(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length):a==="+"?t.minimumSignificantDigits=r.length:r[0]==="#"?t.maximumSignificantDigits=r.length:(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length+(typeof a=="string"?a.length:0)),""}),t}function vM(e){switch(e){case"sign-auto":return{signDisplay:"a\
uto"};case"sign-accounting":case"()":return{currencySign:"accounting"};case"sign-always":case"+!":return{signDisplay:"always"};case"sign-accounting-always":case"()!":return{signDisplay:"always",currencySign:"accounting"};case"sign-except-zero":case"+?":return{signDisplay:"exceptZero"};case"sign-accounting-except-zero":case"()?":return{signDisplay:"exceptZero",currencySign:"accounting"};case"sign-never":case"+_":return{signDisplay:"never"}}}function GK(e){var t;if(e[0]==="E"&&e[1]==="E"?(t={notation:"engineering"},e=e.slice(2)):e[0]==="E"&&(t={notation:"scientific"},e=e.slice(1)),t){var n=e.slice(0,2);if(n==="+!"?(t.signDisplay="always",e=e.slice(2)):n==="+?"&&(t.signDisplay="exceptZero",e=e.slice(2)),!yM.test(e))throw new Error("Malformed concise eng/scientific notation");t.minimumIntegerDigits=e.length}return t}function fM(e){var t={},n=vM(e);return n||t}function bM(e){for(var t={},n=0,r=e;n<r.length;n++){var a=r[n];switch(a.stem){case"percent":case"%":t.style="percent";continue;case"\
%x100":t.style="percent",t.scale=100;continue;case"currency":t.style="currency",t.currency=a.options[0];continue;case"group-off":case",_":t.useGrouping=!1;continue;case"precision-integer":case".":t.maximumFractionDigits=0;continue;case"measure-unit":case"unit":t.style="unit",t.unit=qK(a.options[0]);continue;case"compact-short":case"K":t.notation="compact",t.compactDisplay="short";continue;case"compact-long":case"KK":t.notation="compact",t.compactDisplay="long";continue;case"scientific":t=Lt(Lt(Lt({},t),{notation:"scientific"}),a.options.reduce(function(l,u){return Lt(Lt({},l),fM(u))},{}));continue;case"engineering":t=Lt(Lt(Lt({},t),{notation:"engineering"}),a.options.reduce(function(l,u){return Lt(Lt({},l),fM(u))},{}));continue;case"notation-simple":t.notation="standard";continue;case"unit-width-narrow":t.currencyDisplay="narrowSymbol",t.unitDisplay="narrow";continue;case"unit-width-short":t.currencyDisplay="code",t.unitDisplay="short";continue;case"unit-width-full-name":t.currencyDisplay=
"name",t.unitDisplay="long";continue;case"unit-width-iso-code":t.currencyDisplay="symbol";continue;case"scale":t.scale=parseFloat(a.options[0]);continue;case"integer-width":if(a.options.length>1)throw new RangeError("integer-width stems only accept a single optional option");a.options[0].replace(zK,function(l,u,m,p,f,h){if(u)t.minimumIntegerDigits=m.length;else{if(p&&f)throw new Error("We currently do not support maximum integer digits");if(h)throw new Error("We currently do not support exact integer digits")}return""});continue}if(yM.test(a.stem)){t.minimumIntegerDigits=a.stem.length;continue}if(mM.test(a.stem)){if(a.options.length>1)throw new RangeError("Fraction-precision stems only accept a single optional option");a.stem.replace(mM,function(l,u,m,p,f,h){return m==="*"?t.minimumFractionDigits=u.length:p&&p[0]==="#"?t.maximumFractionDigits=p.length:f&&h?(t.minimumFractionDigits=f.length,t.maximumFractionDigits=f.length+h.length):(t.minimumFractionDigits=u.length,t.maximumFractionDigits=
u.length),""});var o=a.options[0];o==="w"?t=Lt(Lt({},t),{trailingZeroDisplay:"stripIfInteger"}):o&&(t=Lt(Lt({},t),pM(o)));continue}if(gM.test(a.stem)){t=Lt(Lt({},t),pM(a.stem));continue}var s=vM(a.stem);s&&(t=Lt(Lt({},t),s));var c=GK(a.stem);c&&(t=Lt(Lt({},t),c))}return t}var mM,gM,zK,yM,wM=g(()=>{d();lM();dM();i(hM,"parseNumberSkeletonFromString");i(qK,"icuUnitToEcma");mM=/^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g,gM=/^(@+)?(\+|#+)?[rs]?$/g,zK=/(\*)(0+)|(#+)(0+)|(0+)/g,yM=/^(0+)$/;i(pM,"parseSignificantPrecision");i(vM,"parseSign");i(GK,"parseConciseScientificAndEngineeringStem");i(fM,"parseNotationOptions");i(bM,"parseNumberSkeleton")});var EM=g(()=>{d();cM();wM()});var Ul,TM=g(()=>{d();Ul={"001":["H","h"],AC:["H","h","hb","hB"],AD:["H","hB"],AE:["h","hB","hb","H"],AF:["H","hb","hB","h"],AG:["h","hb","H","hB"],AI:["H","h","hb","hB"],AL:["h","H","hB"],AM:["H","hB"],AO:["H","hB"],AR:["H","h","hB","hb"],AS:["h","H"],AT:["H","hB"],AU:["h","hb","H","hB"],AW:["H","hB"],AX:["H"],AZ:["H","hB","h"],BA:["H","hB","h"],BB:["h","hb","H","hB"],BD:["h","hB","H"],BE:["H","hB"],BF:["H","hB"],BG:["H","hB","h"],BH:["h","hB","hb","H"],BJ:["H","hB"],BL:["H","hB"],BM:["h","hb","H","hB"],BN:["hb","hB","h","H"],BO:["H","hB","h","hb"],BQ:["H"],BR:["H","hB"],BS:["h","hb","H","hB"],BT:["h","H"],BW:["H","h","hb","hB"],BZ:["H","h","hb","hB"],CA:["h","hb","H","hB"],CC:["H","h","hb","hB"],CD:["hB","H"],CF:["H","h","hB"],CG:["H","hB"],CH:["H","hB","h"],CI:["H","hB"],CK:["H","h","hb","hB"],CL:["H","h","hB","hb"],CM:["H","h","hB"],CN:["H","hB","hb","h"],CO:["h","H","hB","hb"],CP:["H"],CR:["H","h","hB","hb"],CU:["H","h","hB","hb"],CV:["H","hB"],CX:["H","h","hb","hB"],CY:["h","H","h\
b","hB"],CZ:["H"],DE:["H","hB"],DG:["H","h","hb","hB"],DJ:["h","H"],DK:["H"],DM:["h","hb","H","hB"],DO:["h","H","hB","hb"],DZ:["h","hB","hb","H"],EA:["H","h","hB","hb"],EC:["H","hB","h","hb"],EE:["H","hB"],EG:["h","hB","hb","H"],EH:["h","hB","hb","H"],ER:["h","H"],ES:["H","hB","h","hb"],ET:["hB","hb","h","H"],FI:["H"],FJ:["h","hb","H","hB"],FK:["H","h","hb","hB"],FM:["h","hb","H","hB"],FR:["H","hB"],GA:["H","hB"],GB:["H","h","hb","hB"],GD:["h","hb","H","hB"],GE:["H","hB","h"],GF:["H","hB"],GG:["H","h","hb","hB"],GH:["h","H"],GI:["H","h","hb","hB"],GM:["h","hb","H","hB"],GN:["H","hB"],GP:["H","hB"],GQ:["H","hB","h","hb"],GR:["h","H","hb","hB"],GT:["H","h","hB","hb"],GU:["h","hb","H","hB"],GW:["H","hB"],GY:["h","hb","H","hB"],HK:["h","hB","hb","H"],HN:["H","h","hB","hb"],HR:["H","hB"],IC:["H","h","hB","hb"],ID:["H"],IE:["H","h","hb","hB"],IL:["H","hB"],IM:["H","h","hb","hB"],IN:["h","H"],IO:["H","h","hb","hB"],IQ:["h","hB","hb","H"],IR:["hB","H"],IS:["H"],IT:["H","hB"],JE:["H","h","hb","\
hB"],JM:["h","hb","H","hB"],JO:["h","hB","hb","H"],JP:["H","h","K"],KE:["hB","hb","H","h"],KG:["H","h","hB","hb"],KH:["hB","h","H","hb"],KI:["h","hb","H","hB"],KM:["H","h","hB","hb"],KN:["h","hb","H","hB"],KP:["h","H","hB","hb"],KR:["h","H","hB","hb"],KW:["h","hB","hb","H"],KY:["h","hb","H","hB"],KZ:["H","hB"],LA:["H","hb","hB","h"],LB:["h","hB","hb","H"],LC:["h","hb","H","hB"],LI:["H","hB","h"],LK:["H","h","hB","hb"],LR:["h","hb","H","hB"],LS:["h","H"],LT:["H","h","hb","hB"],LU:["H","h","hB"],LV:["H","hB","hb","h"],LY:["h","hB","hb","H"],MA:["H","h","hB","hb"],MC:["H","hB"],MD:["H","hB"],ME:["H","hB","h"],MF:["H","hB"],MH:["h","hb","H","hB"],MK:["H","h","hb","hB"],ML:["H"],MM:["hB","hb","H","h"],MN:["H","h","hb","hB"],MO:["h","hB","hb","H"],MP:["h","hb","H","hB"],MQ:["H","hB"],MR:["h","hB","hb","H"],MS:["H","h","hb","hB"],MW:["h","hb","H","hB"],MX:["H","h","hB","hb"],MY:["hb","hB","h","H"],MZ:["H","hB"],NA:["h","H","hB","hb"],NC:["H","hB"],NE:["H"],NF:["H","h","hb","hB"],NG:["H","h","\
hb","hB"],NI:["H","h","hB","hb"],NL:["H","hB"],NP:["H","h","hB"],NR:["H","h","hb","hB"],NU:["H","h","hb","hB"],NZ:["h","hb","H","hB"],OM:["h","hB","hb","H"],PA:["h","H","hB","hb"],PE:["H","hB","h","hb"],PF:["H","h","hB"],PG:["h","H"],PH:["h","hB","hb","H"],PK:["h","hB","H"],PM:["H","hB"],PN:["H","h","hb","hB"],PR:["h","H","hB","hb"],PS:["h","hB","hb","H"],PT:["H","hB"],PW:["h","H"],PY:["H","h","hB","hb"],QA:["h","hB","hb","H"],RE:["H","hB"],RO:["H","hB"],RS:["H","hB","h"],RU:["H"],SA:["h","hB","hb","H"],SB:["h","hb","H","hB"],SC:["H","h","hB"],SD:["h","hB","hb","H"],SE:["H"],SG:["h","hb","H","hB"],SH:["H","h","hb","hB"],SI:["H","hB"],SJ:["H"],SK:["H"],SL:["h","hb","H","hB"],SM:["H","h","hB"],SN:["H","h","hB"],SO:["h","H"],SR:["H","hB"],SS:["h","hb","H","hB"],ST:["H","hB"],SV:["H","h","hB","hb"],SX:["H","h","hb","hB"],SY:["h","hB","hb","H"],SZ:["h","hb","H","hB"],TA:["H","h","hb","hB"],TC:["h","hb","H","hB"],TD:["h","H","hB"],TF:["H","h","hB"],TG:["H","hB"],TL:["H","hB","hb","h"],TN:["h",
"hB","hb","H"],TO:["h","H"],TR:["H","hB"],TT:["h","hb","H","hB"],TW:["hB","hb","h","H"],TZ:["hB","hb","H","h"],UA:["H","hB","h"],UG:["hB","hb","H","h"],UM:["h","hb","H","hB"],US:["h","hb","H","hB"],UY:["H","h","hB","hb"],UZ:["H","hB","h"],VA:["H","h","hB"],VC:["h","hb","H","hB"],VE:["h","H","hB","hb"],VG:["h","hb","H","hB"],VI:["h","hb","H","hB"],VU:["h","H"],WF:["H","hB"],WS:["h","H"],XK:["H","hB","h"],YE:["h","hB","hb","H"],YT:["H","hB"],ZA:["H","h","hb","hB"],ZM:["h","hb","H","hB"],"af-ZA":["H","h","hB","hb"],"ar-001":["h","hB","hb","H"],"ca-ES":["H","h","hB"],"en-001":["h","hb","H","hB"],"es-BO":["H","h","hB","hb"],"es-BR":["H","h","hB","hb"],"es-EC":["H","h","hB","hb"],"es-ES":["H","h","hB","hb"],"es-GQ":["H","h","hB","hb"],"es-PE":["H","h","hB","hb"],"fr-CA":["H","h","hB"],"gl-ES":["H","h","hB"],"gu-IN":["hB","hb","h","H"],"hi-IN":["hB","h","H"],"it-CH":["H","h","hB"],"it-IT":["H","h","hB"],"kn-IN":["hB","h","H"],"ml-IN":["hB","h","H"],"mr-IN":["hB","hb","h","H"],"pa-IN":["hB","h\
b","h","H"],"ta-IN":["hB","h","hb","H"],"te-IN":["hB","h","H"],"zu-ZA":["H","hB","hb","h"]}});function xM(e,t){for(var n="",r=0;r<e.length;r++){var a=e.charAt(r);if(a==="j"){for(var o=0;r+1<e.length&&e.charAt(r+1)===a;)o++,r++;var s=1+(o&1),c=o<2?1:3+(o>>1),l="a",u=WK(t);for((u=="H"||u=="k")&&(c=0);c-- >0;)n+=l;for(;s-- >0;)n=u+n}else a==="J"?n+="H":n+=a}return n}function WK(e){var t=e.hourCycle;if(t===void 0&&e.hourCycles&&e.hourCycles.length&&(t=e.hourCycles[0]),t)switch(t){case"h24":return"k";case"h23":return"H";case"h12":return"h";case"h11":return"K";default:throw new Error("Invalid hourCycle")}var n=e.language,r;n!=="root"&&(r=e.maximize().region);var a=Ul[r||""]||Ul[n||""]||Ul["".concat(n,"-001")]||Ul["001"];return a[0]}var SM=g(()=>{d();TM();i(xM,"getBestPattern");i(WK,"getDefaultHourSymbolFromLocale")});function tt(e,t){return{start:e,end:t}}function IM(e,t){return new RegExp(e,t)}function vy(e){return e>=97&&e<=122||e>=65&&e<=90}function aX(e){return vy(e)||e===47}function oX(e){return e===45||e===46||e>=48&&e<=57||e===95||e>=97&&e<=122||e>=65&&e<=90||e==183||e>=192&&e<=214||e>=216&&e<=246||e>=248&&e<=893||e>=895&&e<=8191||e>=8204&&e<=8205||e>=8255&&e<=8256||e>=8304&&e<=8591||e>=11264&&e<=12271||e>=12289&&e<=55295||e>=63744&&e<=64975||e>=65008&&e<=65533||e>=65536&&e<=983039}function AM(e){return e>=9&&e<=13||e===32||e===133||e>=8206&&e<=8207||e===8232||e===8233}function iX(e){return e>=33&&e<=35||e===36||e>=37&&e<=39||e===40||e===41||e===42||e===43||e===44||e===45||e>=46&&e<=47||e>=58&&e<=59||e>=60&&e<=62||e>=63&&e<=64||e===91||e===92||e===93||e===94||e===96||e===123||e===124||e===125||e===126||e===161||e>=162&&e<=165||e===166||e===167||e===169||e===171||e===172||e===174||e===176||e===177||e===182||e===187||e===191||e===215||e===247||e>=8208&&e<=8213||e>=8214&&e<=8215||e===8216||e===
8217||e===8218||e>=8219&&e<=8220||e===8221||e===8222||e===8223||e>=8224&&e<=8231||e>=8240&&e<=8248||e===8249||e===8250||e>=8251&&e<=8254||e>=8257&&e<=8259||e===8260||e===8261||e===8262||e>=8263&&e<=8273||e===8274||e===8275||e>=8277&&e<=8286||e>=8592&&e<=8596||e>=8597&&e<=8601||e>=8602&&e<=8603||e>=8604&&e<=8607||e===8608||e>=8609&&e<=8610||e===8611||e>=8612&&e<=8613||e===8614||e>=8615&&e<=8621||e===8622||e>=8623&&e<=8653||e>=8654&&e<=8655||e>=8656&&e<=8657||e===8658||e===8659||e===8660||e>=8661&&e<=8691||e>=8692&&e<=8959||e>=8960&&e<=8967||e===8968||e===8969||e===8970||e===8971||e>=8972&&e<=8991||e>=8992&&e<=8993||e>=8994&&e<=9e3||e===9001||e===9002||e>=9003&&e<=9083||e===9084||e>=9085&&e<=9114||e>=9115&&e<=9139||e>=9140&&e<=9179||e>=9180&&e<=9185||e>=9186&&e<=9254||e>=9255&&e<=9279||e>=9280&&e<=9290||e>=9291&&e<=9311||e>=9472&&e<=9654||e===9655||e>=9656&&e<=9664||e===9665||e>=9666&&e<=9719||e>=9720&&e<=9727||e>=9728&&e<=9838||e===9839||e>=9840&&e<=10087||e===10088||e===10089||e===10090||
e===10091||e===10092||e===10093||e===10094||e===10095||e===10096||e===10097||e===10098||e===10099||e===10100||e===10101||e>=10132&&e<=10175||e>=10176&&e<=10180||e===10181||e===10182||e>=10183&&e<=10213||e===10214||e===10215||e===10216||e===10217||e===10218||e===10219||e===10220||e===10221||e===10222||e===10223||e>=10224&&e<=10239||e>=10240&&e<=10495||e>=10496&&e<=10626||e===10627||e===10628||e===10629||e===10630||e===10631||e===10632||e===10633||e===10634||e===10635||e===10636||e===10637||e===10638||e===10639||e===10640||e===10641||e===10642||e===10643||e===10644||e===10645||e===10646||e===10647||e===10648||e>=10649&&e<=10711||e===10712||e===10713||e===10714||e===10715||e>=10716&&e<=10747||e===10748||e===10749||e>=10750&&e<=11007||e>=11008&&e<=11055||e>=11056&&e<=11076||e>=11077&&e<=11078||e>=11079&&e<=11084||e>=11085&&e<=11123||e>=11124&&e<=11125||e>=11126&&e<=11157||e===11158||e>=11159&&e<=11263||e>=11776&&e<=11777||e===11778||e===11779||e===11780||e===11781||e>=11782&&e<=11784||e===
11785||e===11786||e===11787||e===11788||e===11789||e>=11790&&e<=11798||e===11799||e>=11800&&e<=11801||e===11802||e===11803||e===11804||e===11805||e>=11806&&e<=11807||e===11808||e===11809||e===11810||e===11811||e===11812||e===11813||e===11814||e===11815||e===11816||e===11817||e>=11818&&e<=11822||e===11823||e>=11824&&e<=11833||e>=11834&&e<=11835||e>=11836&&e<=11839||e===11840||e===11841||e===11842||e>=11843&&e<=11855||e>=11856&&e<=11857||e===11858||e>=11859&&e<=11903||e>=12289&&e<=12291||e===12296||e===12297||e===12298||e===12299||e===12300||e===12301||e===12302||e===12303||e===12304||e===12305||e>=12306&&e<=12307||e===12308||e===12309||e===12310||e===12311||e===12312||e===12313||e===12314||e===12315||e===12316||e===12317||e>=12318&&e<=12319||e===12320||e===12336||e===64830||e===64831||e>=65093&&e<=65094}var py,VK,$K,YK,KK,XK,JK,ZK,QK,eX,tX,hy,CM,kM,gy,RM,_M,nX,rX,yy,fy,DM,NM=g(()=>{d();ly();uy();Xp();iM();EM();SM();VK=new RegExp("^".concat(my.source,"*")),$K=new RegExp("".concat(my.source,
"*$"));i(tt,"createLocation");YK=!!String.prototype.startsWith&&"_a".startsWith("a",1),KK=!!String.fromCodePoint,XK=!!Object.fromEntries,JK=!!String.prototype.codePointAt,ZK=!!String.prototype.trimStart,QK=!!String.prototype.trimEnd,eX=!!Number.isSafeInteger,tX=eX?Number.isSafeInteger:function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e&&Math.abs(e)<=9007199254740991},hy=!0;try{CM=IM("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),hy=((py=CM.exec("a"))===null||py===void 0?void 0:py[0])==="a"}catch{hy=!1}kM=i(YK?function(t,n,r){return t.startsWith(n,r)}:function(t,n,r){return t.slice(r,r+n.length)===n},"startsWith"),gy=KK?String.fromCodePoint:i(function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];for(var r="",a=t.length,o=0,s;a>o;){if(s=t[o++],s>1114111)throw RangeError(s+" is not a valid code point");r+=s<65536?String.fromCharCode(s):String.fromCharCode(((s-=65536)>>10)+55296,s%1024+56320)}return r},"fromCodePoint"),RM=XK?Object.fromEntries:i(function(t){
for(var n={},r=0,a=t;r<a.length;r++){var o=a[r],s=o[0],c=o[1];n[s]=c}return n},"fromEntries"),_M=i(JK?function(t,n){return t.codePointAt(n)}:function(t,n){var r=t.length;if(!(n<0||n>=r)){var a=t.charCodeAt(n),o;return a<55296||a>56319||n+1===r||(o=t.charCodeAt(n+1))<56320||o>57343?a:(a-55296<<10)+(o-56320)+65536}},"codePointAt"),nX=i(ZK?function(t){return t.trimStart()}:function(t){return t.replace(VK,"")},"trimStart"),rX=i(QK?function(t){return t.trimEnd()}:function(t){return t.replace($K,"")},"trimEnd");i(IM,"RE");hy?(fy=IM("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),yy=i(function(t,n){var r;fy.lastIndex=n;var a=fy.exec(t);return(r=a[1])!==null&&r!==void 0?r:""},"matchIdentifierAtIndex")):yy=i(function(t,n){for(var r=[];;){var a=_M(t,n);if(a===void 0||AM(a)||iX(a))break;r.push(a),n+=a>=65536?2:1}return gy.apply(void 0,r)},"matchIdentifierAtIndex");DM=(function(){function e(t,n){n===void 0&&(n={}),this.message=t,this.position={offset:0,line:1,column:1},this.ignoreTag=!!n.ignoreTag,
this.locale=n.locale,this.requiresOtherClause=!!n.requiresOtherClause,this.shouldParseSkeletons=!!n.shouldParseSkeletons}return i(e,"Parser"),e.prototype.parse=function(){if(this.offset()!==0)throw Error("parser can only be used once");return this.parseMessage(0,"",!1)},e.prototype.parseMessage=function(t,n,r){for(var a=[];!this.isEOF();){var o=this.char();if(o===123){var s=this.parseArgument(t,r);if(s.err)return s;a.push(s.val)}else{if(o===125&&t>0)break;if(o===35&&(n==="plural"||n==="selectordinal")){var c=this.clonePosition();this.bump(),a.push({type:It.pound,location:tt(c,this.clonePosition())})}else if(o===60&&!this.ignoreTag&&this.peek()===47){if(r)break;return this.error(Ke.UNMATCHED_CLOSING_TAG,tt(this.clonePosition(),this.clonePosition()))}else if(o===60&&!this.ignoreTag&&vy(this.peek()||0)){var s=this.parseTag(t,n);if(s.err)return s;a.push(s.val)}else{var s=this.parseLiteral(t,n);if(s.err)return s;a.push(s.val)}}}return{val:a,err:null}},e.prototype.parseTag=function(t,n){var r=this.
clonePosition();this.bump();var a=this.parseTagName();if(this.bumpSpace(),this.bumpIf("/>"))return{val:{type:It.literal,value:"<".concat(a,"/>"),location:tt(r,this.clonePosition())},err:null};if(this.bumpIf(">")){var o=this.parseMessage(t+1,n,!0);if(o.err)return o;var s=o.val,c=this.clonePosition();if(this.bumpIf("</")){if(this.isEOF()||!vy(this.char()))return this.error(Ke.INVALID_TAG,tt(c,this.clonePosition()));var l=this.clonePosition(),u=this.parseTagName();return a!==u?this.error(Ke.UNMATCHED_CLOSING_TAG,tt(l,this.clonePosition())):(this.bumpSpace(),this.bumpIf(">")?{val:{type:It.tag,value:a,children:s,location:tt(r,this.clonePosition())},err:null}:this.error(Ke.INVALID_TAG,tt(c,this.clonePosition())))}else return this.error(Ke.UNCLOSED_TAG,tt(r,this.clonePosition()))}else return this.error(Ke.INVALID_TAG,tt(r,this.clonePosition()))},e.prototype.parseTagName=function(){var t=this.offset();for(this.bump();!this.isEOF()&&oX(this.char());)this.bump();return this.message.slice(t,this.
offset())},e.prototype.parseLiteral=function(t,n){for(var r=this.clonePosition(),a="";;){var o=this.tryParseQuote(n);if(o){a+=o;continue}var s=this.tryParseUnquoted(t,n);if(s){a+=s;continue}var c=this.tryParseLeftAngleBracket();if(c){a+=c;continue}break}var l=tt(r,this.clonePosition());return{val:{type:It.literal,value:a,location:l},err:null}},e.prototype.tryParseLeftAngleBracket=function(){return!this.isEOF()&&this.char()===60&&(this.ignoreTag||!aX(this.peek()||0))?(this.bump(),"<"):null},e.prototype.tryParseQuote=function(t){if(this.isEOF()||this.char()!==39)return null;switch(this.peek()){case 39:return this.bump(),this.bump(),"'";case 123:case 60:case 62:case 125:break;case 35:if(t==="plural"||t==="selectordinal")break;return null;default:return null}this.bump();var n=[this.char()];for(this.bump();!this.isEOF();){var r=this.char();if(r===39)if(this.peek()===39)n.push(39),this.bump();else{this.bump();break}else n.push(r);this.bump()}return gy.apply(void 0,n)},e.prototype.tryParseUnquoted=
function(t,n){if(this.isEOF())return null;var r=this.char();return r===60||r===123||r===35&&(n==="plural"||n==="selectordinal")||r===125&&t>0?null:(this.bump(),gy(r))},e.prototype.parseArgument=function(t,n){var r=this.clonePosition();if(this.bump(),this.bumpSpace(),this.isEOF())return this.error(Ke.EXPECT_ARGUMENT_CLOSING_BRACE,tt(r,this.clonePosition()));if(this.char()===125)return this.bump(),this.error(Ke.EMPTY_ARGUMENT,tt(r,this.clonePosition()));var a=this.parseIdentifierIfPossible().value;if(!a)return this.error(Ke.MALFORMED_ARGUMENT,tt(r,this.clonePosition()));if(this.bumpSpace(),this.isEOF())return this.error(Ke.EXPECT_ARGUMENT_CLOSING_BRACE,tt(r,this.clonePosition()));switch(this.char()){case 125:return this.bump(),{val:{type:It.argument,value:a,location:tt(r,this.clonePosition())},err:null};case 44:return this.bump(),this.bumpSpace(),this.isEOF()?this.error(Ke.EXPECT_ARGUMENT_CLOSING_BRACE,tt(r,this.clonePosition())):this.parseArgumentOptions(t,n,a,r);default:return this.error(
Ke.MALFORMED_ARGUMENT,tt(r,this.clonePosition()))}},e.prototype.parseIdentifierIfPossible=function(){var t=this.clonePosition(),n=this.offset(),r=yy(this.message,n),a=n+r.length;this.bumpTo(a);var o=this.clonePosition(),s=tt(t,o);return{value:r,location:s}},e.prototype.parseArgumentOptions=function(t,n,r,a){var o,s=this.clonePosition(),c=this.parseIdentifierIfPossible().value,l=this.clonePosition();switch(c){case"":return this.error(Ke.EXPECT_ARGUMENT_TYPE,tt(s,l));case"number":case"date":case"time":{this.bumpSpace();var u=null;if(this.bumpIf(",")){this.bumpSpace();var m=this.clonePosition(),p=this.parseSimpleArgStyleIfPossible();if(p.err)return p;var f=rX(p.val);if(f.length===0)return this.error(Ke.EXPECT_ARGUMENT_STYLE,tt(this.clonePosition(),this.clonePosition()));var h=tt(m,this.clonePosition());u={style:f,styleLocation:h}}var y=this.tryParseArgumentClose(a);if(y.err)return y;var b=tt(a,this.clonePosition());if(u&&kM(u?.style,"::",0)){var w=nX(u.style.slice(2));if(c==="number"){var p=this.
parseNumberSkeletonFromString(w,u.styleLocation);return p.err?p:{val:{type:It.number,value:r,location:b,style:p.val},err:null}}else{if(w.length===0)return this.error(Ke.EXPECT_DATE_TIME_SKELETON,b);var C=w;this.locale&&(C=xM(w,this.locale));var f={type:Si.dateTime,pattern:C,location:u.styleLocation,parsedOptions:this.shouldParseSkeletons?sM(C):{}},k=c==="date"?It.date:It.time;return{val:{type:k,value:r,location:b,style:f},err:null}}}return{val:{type:c==="number"?It.number:c==="date"?It.date:It.time,value:r,location:b,style:(o=u?.style)!==null&&o!==void 0?o:null},err:null}}case"plural":case"selectordinal":case"select":{var R=this.clonePosition();if(this.bumpSpace(),!this.bumpIf(","))return this.error(Ke.EXPECT_SELECT_ARGUMENT_OPTIONS,tt(R,Os({},R)));this.bumpSpace();var S=this.parseIdentifierIfPossible(),_=0;if(c!=="select"&&S.value==="offset"){if(!this.bumpIf(":"))return this.error(Ke.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,tt(this.clonePosition(),this.clonePosition()));this.bumpSpace();var p=this.
tryParseDecimalInteger(Ke.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Ke.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);if(p.err)return p;this.bumpSpace(),S=this.parseIdentifierIfPossible(),_=p.val}var q=this.tryParsePluralOrSelectOptions(t,c,n,S);if(q.err)return q;var y=this.tryParseArgumentClose(a);if(y.err)return y;var F=tt(a,this.clonePosition());return c==="select"?{val:{type:It.select,value:r,options:RM(q.val),location:F},err:null}:{val:{type:It.plural,value:r,options:RM(q.val),offset:_,pluralType:c==="plural"?"cardinal":"ordinal",location:F},err:null}}default:return this.error(Ke.INVALID_ARGUMENT_TYPE,tt(s,l))}},e.prototype.tryParseArgumentClose=function(t){return this.isEOF()||this.char()!==125?this.error(Ke.EXPECT_ARGUMENT_CLOSING_BRACE,tt(t,this.clonePosition())):(this.bump(),{val:!0,err:null})},e.prototype.parseSimpleArgStyleIfPossible=function(){for(var t=0,n=this.clonePosition();!this.isEOF();){var r=this.char();switch(r){case 39:{this.bump();var a=this.clonePosition();if(!this.bumpUntil("\
'"))return this.error(Ke.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE,tt(a,this.clonePosition()));this.bump();break}case 123:{t+=1,this.bump();break}case 125:{if(t>0)t-=1;else return{val:this.message.slice(n.offset,this.offset()),err:null};break}default:this.bump();break}}return{val:this.message.slice(n.offset,this.offset()),err:null}},e.prototype.parseNumberSkeletonFromString=function(t,n){var r=[];try{r=hM(t)}catch{return this.error(Ke.INVALID_NUMBER_SKELETON,n)}return{val:{type:Si.number,tokens:r,location:n,parsedOptions:this.shouldParseSkeletons?bM(r):{}},err:null}},e.prototype.tryParsePluralOrSelectOptions=function(t,n,r,a){for(var o,s=!1,c=[],l=new Set,u=a.value,m=a.location;;){if(u.length===0){var p=this.clonePosition();if(n!=="select"&&this.bumpIf("=")){var f=this.tryParseDecimalInteger(Ke.EXPECT_PLURAL_ARGUMENT_SELECTOR,Ke.INVALID_PLURAL_ARGUMENT_SELECTOR);if(f.err)return f;m=tt(p,this.clonePosition()),u=this.message.slice(p.offset,this.offset())}else break}if(l.has(u))return this.error(n===
"select"?Ke.DUPLICATE_SELECT_ARGUMENT_SELECTOR:Ke.DUPLICATE_PLURAL_ARGUMENT_SELECTOR,m);u==="other"&&(s=!0),this.bumpSpace();var h=this.clonePosition();if(!this.bumpIf("{"))return this.error(n==="select"?Ke.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT:Ke.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT,tt(this.clonePosition(),this.clonePosition()));var y=this.parseMessage(t+1,n,r);if(y.err)return y;var b=this.tryParseArgumentClose(h);if(b.err)return b;c.push([u,{value:y.val,location:tt(h,this.clonePosition())}]),l.add(u),this.bumpSpace(),o=this.parseIdentifierIfPossible(),u=o.value,m=o.location}return c.length===0?this.error(n==="select"?Ke.EXPECT_SELECT_ARGUMENT_SELECTOR:Ke.EXPECT_PLURAL_ARGUMENT_SELECTOR,tt(this.clonePosition(),this.clonePosition())):this.requiresOtherClause&&!s?this.error(Ke.MISSING_OTHER_CLAUSE,tt(this.clonePosition(),this.clonePosition())):{val:c,err:null}},e.prototype.tryParseDecimalInteger=function(t,n){var r=1,a=this.clonePosition();this.bumpIf("+")||this.bumpIf("-")&&(r=-1);
for(var o=!1,s=0;!this.isEOF();){var c=this.char();if(c>=48&&c<=57)o=!0,s=s*10+(c-48),this.bump();else break}var l=tt(a,this.clonePosition());return o?(s*=r,tX(s)?{val:s,err:null}:this.error(n,l)):this.error(t,l)},e.prototype.offset=function(){return this.position.offset},e.prototype.isEOF=function(){return this.offset()===this.message.length},e.prototype.clonePosition=function(){return{offset:this.position.offset,line:this.position.line,column:this.position.column}},e.prototype.char=function(){var t=this.position.offset;if(t>=this.message.length)throw Error("out of bound");var n=_M(this.message,t);if(n===void 0)throw Error("Offset ".concat(t," is at invalid UTF-16 code unit boundary"));return n},e.prototype.error=function(t,n){return{val:null,err:{kind:t,message:this.message,location:n}}},e.prototype.bump=function(){if(!this.isEOF()){var t=this.char();t===10?(this.position.line+=1,this.position.column=1,this.position.offset+=1):(this.position.column+=1,this.position.offset+=t<65536?1:
2)}},e.prototype.bumpIf=function(t){if(kM(this.message,t,this.offset())){for(var n=0;n<t.length;n++)this.bump();return!0}return!1},e.prototype.bumpUntil=function(t){var n=this.offset(),r=this.message.indexOf(t,n);return r>=0?(this.bumpTo(r),!0):(this.bumpTo(this.message.length),!1)},e.prototype.bumpTo=function(t){if(this.offset()>t)throw Error("targetOffset ".concat(t," must be greater than or equal to the current offset ").concat(this.offset()));for(t=Math.min(t,this.message.length);;){var n=this.offset();if(n===t)break;if(n>t)throw Error("targetOffset ".concat(t," is at invalid UTF-16 code unit boundary"));if(this.bump(),this.isEOF())break}},e.prototype.bumpSpace=function(){for(;!this.isEOF()&&AM(this.char());)this.bump()},e.prototype.peek=function(){if(this.isEOF())return null;var t=this.char(),n=this.offset(),r=this.message.charCodeAt(n+(t>=65536?2:1));return r??null},e})();i(vy,"_isAlpha");i(aX,"_isAlphaOrSlash");i(oX,"_isPotentialElementNameChar");i(AM,"_isWhiteSpace");i(iX,"_isP\
atternSyntax")});function by(e){e.forEach(function(t){if(delete t.location,Vp(t)||$p(t))for(var n in t.options)delete t.options[n].location,by(t.options[n].value);else zp(t)&&Kp(t.style)||(Gp(t)||Wp(t))&&Fl(t.style)?delete t.style.location:Yp(t)&&by(t.children)})}function MM(e,t){t===void 0&&(t={}),t=Os({shouldParseSkeletons:!0,requiresOtherClause:!0},t);var n=new DM(e,t).parse();if(n.err){var r=SyntaxError(Ke[n.err.kind]);throw r.location=n.err.location,r.originalMessage=n.err.message,r}return t?.captureLocation||by(n.val),n.val}var wy=g(()=>{d();ly();uy();NM();Xp();Xp();i(by,"pruneLocation");i(MM,"parse")});function Jp(e,t){var n=t&&t.cache?t.cache:mX,r=t&&t.serializer?t.serializer:dX,a=t&&t.strategy?t.strategy:cX;return a(e,{cache:n,serializer:r})}function sX(e){return e==null||typeof e=="number"||typeof e=="boolean"}function OM(e,t,n,r){var a=sX(r)?r:n(r),o=t.get(a);return typeof o>"u"&&(o=e.call(this,r),t.set(a,o)),o}function PM(e,t,n){var r=Array.prototype.slice.call(arguments,3),a=n(r),o=t.get(a);return typeof o>"u"&&(o=e.apply(this,r),t.set(a,o)),o}function Ey(e,t,n,r,a){return n.bind(t,e,r,a)}function cX(e,t){var n=e.length===1?OM:PM;return Ey(e,this,n,t.cache.create(),t.serializer)}function lX(e,t){return Ey(e,this,PM,t.cache.create(),t.serializer)}function uX(e,t){return Ey(e,this,OM,t.cache.create(),t.serializer)}function Ty(){this.cache=Object.create(null)}var dX,mX,Zp,LM=g(()=>{d();i(Jp,"memoize");i(sX,"isPrimitive");i(OM,"monadic");i(PM,"variadic");i(Ey,"assemble");i(cX,"strategyDefault");i(lX,"strategyVariadic");i(uX,"strategyMonadic");dX=i(function(){return JSON.stringify(arguments)},
"serializerDefault");i(Ty,"ObjectWithoutPrototypeCache");Ty.prototype.get=function(e){return this.cache[e]};Ty.prototype.set=function(e,t){this.cache[e]=t};mX={create:i(function(){return new Ty},"create")},Zp={variadic:lX,monadic:uX}});var Ci,Bl,xy,FM,UM,Sy=g(()=>{d();cy();(function(e){e.MISSING_VALUE="MISSING_VALUE",e.INVALID_VALUE="INVALID_VALUE",e.MISSING_INTL_API="MISSING_INTL_API"})(Ci||(Ci={}));Bl=(function(e){Ll(t,e);function t(n,r,a){var o=e.call(this,n)||this;return o.code=r,o.originalMessage=a,o}return i(t,"FormatError"),t.prototype.toString=function(){return"[formatjs Error: ".concat(this.code,"] ").concat(this.message)},t})(Error),xy=(function(e){Ll(t,e);function t(n,r,a,o){return e.call(this,'Invalid values for "'.concat(n,'": "').concat(r,'". Options are "').concat(Object.keys(a).join('", "'),'"'),Ci.INVALID_VALUE,o)||this}return i(t,"InvalidValueError"),t})(Bl),FM=(function(e){Ll(t,e);function t(n,r,a){return e.call(this,'Value for "'.concat(n,'" must be of type ').concat(r),Ci.INVALID_VALUE,a)||this}return i(t,"InvalidValueTypeError"),t})(Bl),UM=(function(e){Ll(t,e);function t(n,r){return e.call(this,'The intl string context variable "'.concat(n,'" was not provided to the string "').concat(r,'"'),Ci.MISSING_VALUE,
r)||this}return i(t,"MissingValueError"),t})(Bl)});function pX(e){return e.length<2?e:e.reduce(function(t,n){var r=t[t.length-1];return!r||r.type!==kn.literal||n.type!==kn.literal?t.push(n):r.value+=n.value,t},[])}function fX(e){return typeof e=="function"}function jl(e,t,n,r,a,o,s){if(e.length===1&&dy(e[0]))return[{type:kn.literal,value:e[0].value}];for(var c=[],l=0,u=e;l<u.length;l++){var m=u[l];if(dy(m)){c.push({type:kn.literal,value:m.value});continue}if(oM(m)){typeof o=="number"&&c.push({type:kn.literal,value:n.getNumberFormat(t).format(o)});continue}var p=m.value;if(!(a&&p in a))throw new UM(p,s);var f=a[p];if(aM(m)){(!f||typeof f=="string"||typeof f=="number")&&(f=typeof f=="string"||typeof f=="number"?String(f):""),c.push({type:typeof f=="string"?kn.literal:kn.object,value:f});continue}if(Gp(m)){var h=typeof m.style=="string"?r.date[m.style]:Fl(m.style)?m.style.parsedOptions:void 0;c.push({type:kn.literal,value:n.getDateTimeFormat(t,h).format(f)});continue}if(Wp(m)){var h=typeof m.style=="string"?r.time[m.style]:Fl(m.style)?m.style.
parsedOptions:r.time.medium;c.push({type:kn.literal,value:n.getDateTimeFormat(t,h).format(f)});continue}if(zp(m)){var h=typeof m.style=="string"?r.number[m.style]:Kp(m.style)?m.style.parsedOptions:void 0;h&&h.scale&&(f=f*(h.scale||1)),c.push({type:kn.literal,value:n.getNumberFormat(t,h).format(f)});continue}if(Yp(m)){var y=m.children,b=m.value,w=a[b];if(!fX(w))throw new FM(b,"function",s);var C=jl(y,t,n,r,a,o),k=w(C.map(function(_){return _.value}));Array.isArray(k)||(k=[k]),c.push.apply(c,k.map(function(_){return{type:typeof _=="string"?kn.literal:kn.object,value:_}}))}if(Vp(m)){var R=m.options[f]||m.options.other;if(!R)throw new xy(m.value,f,Object.keys(m.options),s);c.push.apply(c,jl(R.value,t,n,r,a));continue}if($p(m)){var R=m.options["=".concat(f)];if(!R){if(!Intl.PluralRules)throw new Bl(`Intl.PluralRules is not available in this environment.
Try polyfilling it using "@formatjs/intl-pluralrules"
`,Ci.MISSING_INTL_API,s);var S=n.getPluralRules(t,{type:m.pluralType}).select(f-(m.offset||0));R=m.options[S]||m.options.other}if(!R)throw new xy(m.value,f,Object.keys(m.options),s);c.push.apply(c,jl(R.value,t,n,r,a,f-(m.offset||0)));continue}}return pX(c)}var kn,Cy=g(()=>{d();wy();Sy();(function(e){e[e.literal=0]="literal",e[e.object=1]="object"})(kn||(kn={}));i(pX,"mergeLiteral");i(fX,"isFormatXMLElementFn");i(jl,"formatToParts")});function hX(e,t){return t?Ur(Ur(Ur({},e||{}),t||{}),Object.keys(e).reduce(function(n,r){return n[r]=Ur(Ur({},e[r]),t[r]||{}),n},{})):e}function gX(e,t){return t?Object.keys(e).reduce(function(n,r){return n[r]=hX(e[r],t[r]),n},Ur({},e)):e}function ky(e){return{create:i(function(){return{get:i(function(t){return e[t]},"get"),set:i(function(t,n){e[t]=n},"set")}},"create")}}function yX(e){return e===void 0&&(e={number:{},dateTime:{},pluralRules:{}}),{getNumberFormat:Jp(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.NumberFormat).bind.apply(t,qp([void 0],n,!1)))},{cache:ky(e.number),strategy:Zp.variadic}),getDateTimeFormat:Jp(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.DateTimeFormat).bind.apply(t,qp([void 0],n,!1)))},{cache:ky(e.dateTime),strategy:Zp.variadic}),getPluralRules:Jp(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.PluralRules).bind.apply(t,qp([void 0],
n,!1)))},{cache:ky(e.pluralRules),strategy:Zp.variadic})}}var BM,Ry=g(()=>{d();cy();wy();LM();Cy();i(hX,"mergeConfig");i(gX,"mergeConfigs");i(ky,"createFastMemoizeCache");i(yX,"createDefaultFormatters");BM=(function(){function e(t,n,r,a){n===void 0&&(n=e.defaultLocale);var o=this;if(this.formatterCache={number:{},dateTime:{},pluralRules:{}},this.format=function(u){var m=o.formatToParts(u);if(m.length===1)return m[0].value;var p=m.reduce(function(f,h){return!f.length||h.type!==kn.literal||typeof f[f.length-1]!="string"?f.push(h.value):f[f.length-1]+=h.value,f},[]);return p.length<=1?p[0]||"":p},this.formatToParts=function(u){return jl(o.ast,o.locales,o.formatters,o.formats,u,void 0,o.message)},this.resolvedOptions=function(){var u;return{locale:((u=o.resolvedLocale)===null||u===void 0?void 0:u.toString())||Intl.NumberFormat.supportedLocalesOf(o.locales)[0]}},this.getAst=function(){return o.ast},this.locales=n,this.resolvedLocale=e.resolveLocale(n),typeof t=="string"){if(this.message=t,!e.
__parse)throw new TypeError("IntlMessageFormat.__parse must be set to process `message` of type `string`");var s=a||{},c=s.formatters,l=rM(s,["formatters"]);this.ast=e.__parse(t,Ur(Ur({},l),{locale:this.resolvedLocale}))}else this.ast=t;if(!Array.isArray(this.ast))throw new TypeError("A message must be provided as a String or AST.");this.formats=gX(e.formats,r),this.formatters=a&&a.formatters||yX(this.formatterCache)}return i(e,"IntlMessageFormat"),Object.defineProperty(e,"defaultLocale",{get:i(function(){return e.memoizedDefaultLocale||(e.memoizedDefaultLocale=new Intl.NumberFormat().resolvedOptions().locale),e.memoizedDefaultLocale},"get"),enumerable:!1,configurable:!0}),e.memoizedDefaultLocale=null,e.resolveLocale=function(t){if(!(typeof Intl.Locale>"u")){var n=Intl.NumberFormat.supportedLocalesOf(t);return n.length>0?new Intl.Locale(n[0]):new Intl.Locale(typeof t=="string"?t:t[0])}},e.__parse=MM,e.formats={number:{integer:{maximumFractionDigits:0},currency:{style:"currency"},percent:{
style:"percent"}},date:{short:{month:"numeric",day:"numeric",year:"2-digit"},medium:{month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}},e})()});var _y,jM=g(()=>{d();Ry();Cy();Ry();Sy();_y=BM});var ki,Ps=g(()=>{d();ki=i(()=>({resolve(){throw new Error("createRequire.resolve is not supported in bundled Lighthouse")}}),"createRequire")});var vX,bX,Ri,Hl=g(()=>{d();vX=globalThis.URL,bX=i(e=>e,"fileURLToPath"),Ri={URL:vX,fileURLToPath:bX}});function HM(e){return Ri.fileURLToPath(e.url)}var _i=g(()=>{"use strict";d();Ps();Hl();ho();i(HM,"getModulePath")});function Iy(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function qM(e){return typeof e=="object"&&e!==null}var zM=g(()=>{"use strict";d();i(Iy,"isObjectOfUnknownValues");i(qM,"isObjectOrArrayOfUnknownValues")});var GM,WM=g(()=>{d();GM={}});function $M(e,t=new Map){for(let n of e)if(!(n.type===Qp.literal||n.type===Qp.pound)&&(t.set(n.value,n),n.type===Qp.plural))for(let r of Object.values(n.options))$M(r.value,t);return t}function TX(e,t={},n){let r=$M(e.getAst()),a={};for(let[o,s]of r){if(!(o in t))throw new Error(`ICU Message "${n}" contains a value reference ("${o}") that wasn't provided`);let c=t[o];if(s.type!==Qp.number){a[o]=c;continue}if(typeof c!="number")throw new Error(`ICU Message "${n}" contains a numeric reference ("${o}") but provided value was not a number`);s.style==="milliseconds"?a[o]=Math.round(c/10)*10:s.style==="seconds"&&o==="timeInMs"?a[o]=Math.round(c/100)/10:s.style==="bytes"?a[o]=c/1024:a[o]=c}for(let o of Object.keys(t))if(!(o in a)){if(o==="errorCode"){a.errorCode=t.errorCode;continue}throw new Error(`Provided value "${o}" does not match any placeholder in ICU message "${n}"`)}return a}function xX(e){return e.replace(/'/g,"''").replace(/\\{/g,"'{").replace(/\\}/g,"'}")}function Ay(e,t,n){e=xX(e);
let r=n==="en-XA"||n==="en-XL"?"de-DE":n,a=_y.IntlMessageFormat||_y,o=new a(e,r,EX,{ignoreTag:!0}),s=TX(o,t,e),c=o.format(s);if(typeof c!="string")throw new Error("unexpected formatted result");return c}function SX(e,t){let r=KM(t)[e.i18nId];return r?Ay(r.message,e.values,t):e.formattedDefault}function YM(e){let t=KM(e),n=Object.keys(t).filter(a=>a.startsWith("report/renderer/report-utils.js")),r={};for(let a of n){let{filename:o,key:s}=kX(a);if(!o.endsWith("report-utils.js"))throw new Error(`Unexpected message: ${a}`);r[s]=t[a].message}return r}function Fs(e){if(!Iy(e))return!1;let{i18nId:t,values:n,formattedDefault:r}=e;if(typeof t!="string"||typeof r!="string")return!1;if(n!==void 0){if(!Iy(n))return!1;for(let a of Object.values(n))if(typeof a!="string"&&typeof a!="number")return!1}return VM.test(t)}function Ii(e,t){if(Fs(e))return SX(e,t);if(typeof e=="string")return e;throw new Error("Attempted to format invalid icuMessage type")}function CX(e){let t="";for(let n of e)if(/^[a-z]+$/i.
test(n))t.length&&(t+="."),t+=n;else{if(/]|"|'|\s/.test(n))throw new Error(`Cannot handle "${n}" in i18n`);t+=`[${n}]`}return t}function Ny(e,t){function n(a,o,s=[]){if(qM(a))for(let[c,l]of Object.entries(a)){let u=s.concat([c]);if(Fs(l)){let m=Ii(l,t),p=o[l.i18nId]||[],f=CX(u);p.push(l.values?{values:l.values,path:f}:f),a[c]=m,o[l.i18nId]=p}else n(l,o,u)}}i(n,"replaceInObject");let r={};return n(e,r),r}function KM(e){let t=Dy[e];if(!t){if(e===Ls)return{};throw new Error(`Unsupported locale '${e}'`)}return t}function XM(){return wX}function JM(){return[...new Set([...Object.keys(Dy),Ls])].sort()}function ZM(e,t){Dy[e]=t}function kX(e){if(!VM.test(e))throw Error(`"${e}" does not appear to be a valid ICU message id`);let[t,n]=e.split(" | ");return{filename:t,key:n}}var Qp,Dy,Ls,wX,VM,EX,Ia=g(()=>{"use strict";d();fo();jM();_i();zM();WM();Qp={literal:0,argument:1,number:2,date:3,time:4,select:5,plural:6,pound:7,tag:8},Dy=GM,Ls="en-US",wX=["ar-XB.json","ar.json","bg.json","ca.json","cs.jso\
n","da.json","de.json","el.json","en-GB.json","en-US.ctc.json","en-US.json","en-XA.json","en-XL.ctc.json","en-XL.json","es-419.json","es.json","fi.json","fil.json","fr.json","he.json","hi.json","hr.json","hu.json","id.json","it.json","ja.json","ko.json","lt.json","lv.json","nl.json","no.json","pl.json","pt-PT.json","pt.json","ro.json","ru.json","sk.json","sl.json","sr-Latn.json","sr.json","sv.json","ta.json","te.json","th.json","tr.json","uk.json","vi.json","zh-HK.json","zh-TW.json","zh.json"].filter(e=>e.endsWith(".json")&&!e.endsWith(".ctc.json")).map(e=>e.replace(".json","")).sort(),VM=/ | [^\s]+$/,EX={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};i($M,"collectAllCustomElementsFromICU");i(TX,"_preformatValues");i(xX,"escapeIcuMessage");i(Ay,"formatMessage");i(SX,"_localizeIcuMessage");i(YM,"getRendererFormattedStrings");i(Fs,"isIcuMes\
sage");i(Ii,"getFormatted");i(CX,"_formatPathAsString");i(Ny,"replaceIcuMessages");i(KM,"_getLocaleMessages");i(XM,"getCanonicalLocales");i(JM,"getAvailableLocales");i(ZM,"registerLocaleData");i(kX,"getIcuMessageIdParts")});var eO=ve((F2e,QM)=>{d();var RX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><path fill="%230379c4" fill-rule="evenodd" d="m171.887 116.28-53.696 89.36h-9.728l9.617-58.227-30.2.047a4.852 4.852 0 0 1-4.855-4.855c0-1.152 1.07-3.102 1.07-3.102l53.52-89.254 9.9.043-9.86 58.317 30.413-.043a4.852 4.852 0 0 1 4.855 4.855c0 1.088-.427 2.044-1.033 2.854l.004.004zM128 0C57.306 0 0 57.3 0 128s57.306 128 128 128 128-57.306 128-128S198.7 0 128 0z"/></svg>',_X={"modern-image-formats":"Consider displaying all [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) components in WebP formats while specifying an appropriate fallback for other browsers. [Learn more](https://amp.dev/documentation/components/amp-img/#example:-specifying-a-fallback-image).","offscreen-images":"Ensure that you are using [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) for images to automatically lazy-load. [Learn more](https://amp.dev/\
documentation/guides-and-tutorials/develop/media_iframes_3p/?format=websites#images).","render-blocking-resources":"Use tools such as [AMP Optimizer](https://github.com/ampproject/amp-toolbox/tree/master/packages/optimizer) to [server-side render AMP layouts](https://amp.dev/documentation/guides-and-tutorials/optimize-and-measure/server-side-rendering/).","unminified-css":"Refer to the [AMP documentation](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/style_pages/) to ensure all styles are supported.","efficient-animated-content":"For animated content, use [`amp-anim`](https://amp.dev/documentation/components/amp-anim/) to minimize CPU usage when the content is offscreen.","uses-responsive-images":"The [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) component supports the [`srcset`](https://web.dev/use-srcset-to-automatically-choose-the-right-image/) attribute to specify which image assets to use based on the screen size. [Lea\
rn more](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/art_direction/)."};QM.exports={id:"amp",title:"AMP",icon:RX,UIStrings:_X}});var nO=ve((B2e,tO)=>{d();var IX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250"><path fill="%23dd0031" d="M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"/><path fill="%23c3002f" d="M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"/><path fill="%23fff" d="M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z"/></svg>',DX={"total-byte-weight":"Apply [route-level code splitting](https://web.dev/route-level-code-splitting-in-angular/) to minimize the size of your JavaScript bundles. Also, consider precaching assets with the [Angular service worker](https://web.dev/precaching-with-the-angular-service-worker/).","unminified-warning":"If you are using Angular CLI, ensure that builds are generated in production mode. [Learn more](https://angular.io/guide/deployment#enable-runtime-production-mode).","unused-javascript":"If you are using Angular CLI, include source maps in your production build to inspect your \
bundles. [Learn more](https://angular.io/guide/deployment#inspect-the-bundles).","uses-responsive-images":"Consider using the `BreakpointObserver` utility in the Component Dev Kit (CDK) to manage image breakpoints. [Learn more](https://material.angular.io/cdk/layout/overview).","uses-rel-preload":"Preload routes ahead of time to speed up navigation. [Learn more](https://web.dev/route-preloading-in-angular/).","dom-size":"Consider virtual scrolling with the Component Dev Kit (CDK) if very large lists are being rendered. [Learn more](https://web.dev/virtualize-lists-with-angular-cdk/)."};tO.exports={id:"angular",title:"Angular",icon:IX,UIStrings:DX}});var aO=ve((H2e,rO)=>{d();var AX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 186.525 243.713"><path fill="%23009cde" d="M131.64 51.91C114.491 34.769 98.13 18.429 93.26 0c-4.87 18.429-21.234 34.769-38.38 51.91C29.16 77.613 0 106.743 0 150.434a93.263 93.263 0 1 0 186.525 0c0-43.688-29.158-72.821-54.885-98.524m-92 120.256c-5.719-.194-26.824-36.571 12.329-75.303l25.909 28.3a2.215 2.215 0 0 1-.173 3.306c-6.183 6.34-32.534 32.765-35.81 41.902-.675 1.886-1.663 1.815-2.256 1.795m53.624 47.943a32.075 32.075 0 0 1-32.076-32.075 33.423 33.423 0 0 1 7.995-21.187c5.784-7.072 24.077-26.963 24.077-26.963s18.012 20.183 24.033 26.896a31.368 31.368 0 0 1 8.046 21.254 32.076 32.076 0 0 1-32.075 32.075m61.392-52.015c-.691 1.512-2.26 4.036-4.376 4.113-3.773.138-4.176-1.796-6.965-5.923-6.122-9.06-59.551-64.9-69.545-75.699-8.79-9.498-1.238-16.195 2.266-19.704 4.395-4.403 17.224-17.225 17.224-17.225s38.255 36.296 54.19 61.096 10.444 46.26 7.206 53.342"/></svg>',NX={"unused-css-rule\
s":"Consider removing unused CSS rules and only attach the needed `Drupal` libraries to the relevant page or component in a page. See the [`Drupal` documentation](https://www.drupal.org/docs/develop/theming-drupal/adding-assets-css-js-to-a-drupal-theme-via-librariesyml#define) for details. To identify attached libraries that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the stylesheet when CSS aggregation is disabled in your `Drupal` site. Look out for themes/modules that have many stylesheets in the list which have a lot of red in code coverage. A theme/module should only attach a stylesheet library if it is actually used on the page.","modern-image-formats":"Consider configuring [WebP image formats with a Convert image style](https://www.drupal.org/docs/core-modules-and-themes/core-modules/image-module/working-with-images#styles) on your site\
.","offscreen-images":"Consider configuring lazy load images in `Drupal`. The field formatters for images support `lazy` or `eager`.","total-byte-weight":"Consider using [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) to reduce the size of images loaded on your page. If you are using `Views` to show multiple content items on a page, consider implementing pagination to limit the number of content items shown on a given page.","render-blocking-resources":"Consider using [a module](https://www.drupal.org/project/critical_css) to inline critical CSS and JavaScript, and use the defer attribute for non-critical CSS or JavaScript.","unminified-css":'Ensure you have enabled "Aggregate CSS files" in the "Administration » Configuration » Development" page.',"unminified-javascript":'Ensure you have enabled "Aggregate JavaScript files" in the "Administration » Configuration » Development" page.',"efficient-animated-content":"Consider uploading your `GIF\
` to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider removing unused JavaScript assets and only attach the needed `Drupal` libraries to the relevant page or component in a page. See the [Drupal documentation](https://www.drupal.org/docs/develop/theming-drupal/adding-assets-css-js-to-a-drupal-theme-via-librariesyml#define) for details. To identify attached libraries that are adding extraneous JavaScript, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the script when JavaScript aggregation is disabled in your `Drupal` site. Look out for themes/modules that have many scripts in the list which have a lot of red in code coverage. A theme/module should only attach a script library if it is actually used on the page.","uses-long-cache-ttl":'Set the "Browser and proxy cache maximum age" in the "Administration » Configuration » Dev\
elopment" page. Read about [`Drupal` cache and optimizing for performance](https://www.drupal.org/docs/8/api/cache-api/cache-api).',"uses-optimized-images":"Consider using [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=image&solrsort=iss_project_release_usage+desc&op=Search) that automatically optimizes and reduces the size of images uploaded through the site while retaining quality. Also, ensure you are using the native [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) provided from `Drupal` for all images rendered on the site.","uses-text-compression":"Text-based resources should be served with compression (gzip, deflate or brotli) to minimize total network bytes. Consider using a CDN that natively supports this, or configure the web server to perform this operation. [Learn more](https://developers.google.com/web/tools/l\
ighthouse/audits/text-compression).","uses-responsive-images":"Ensure that you are using the native [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) provided from `Drupal`. Use the Responsive Image Styles when rendering image fields through view modes, views, or images uploaded through the WYSIWYG editor.","prioritize-lcp-image":"If the LCP element is dynamically added to the page, you should optimize the image in order to improve LCP. [Learn more](https://www.smashingmagazine.com/2023/08/methods-improving-drupal-largest-contentful-paint-core-web-vital/).","server-response-time":"Offload traffic with one or more `Drupal` caching modules such as `Internal Page Cache`, `Internal Dynamic Page Cache`, and `BigPipe`. Couple these with a CDN to further improve response time. Your hosting servers should make use of PHP OPcache. Consider using memory-caching such as Redis or Memcached to reduce database query times. Lastly use performant themes, modules,\
 and faster servers to lower server response time.",redirects:"Redirects introduce additional delays before the page can be loaded. If the [Redirect](https://www.drupal.org/project/redirect) module is installed, review if unnecessary redirects can be removed. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/redirects).","uses-rel-preconnect":"`Preconnect` or `dns-prefetch` resource hints can be added by installing and configuring [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=Preconnect&solrsort=score+desc&op=Search) that provides facilities for user agent resource hints."};rO.exports={id:"drupal",title:"Drupal",icon:AX,UIStrings:NX}});var iO=ve((z2e,oO)=>{d();var MX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82 82"><path fill="%235FA624" fill-rule="evenodd" d="M81.37 48.117C85.301 25.821 70.413 4.56 48.117.63 25.821-3.3 4.56 11.586.63 33.883-3.3 56.178 11.586 77.44 33.883 81.37 56.18 85.301 77.44 70.412 81.37 48.117Zm-8.935-14.17c2.77 12.357-1.942 25.721-12.96 33.436-14.57 10.203-34.656 6.662-44.859-7.909a32.434 32.434 0 0 1-2.869-4.98l28.7-20.097a6.53 6.53 0 1 0-3.744-5.347L9.564 48.054c-2.768-12.359 1.943-25.724 12.96-33.439 14.572-10.203 34.656-6.662 44.86 7.91a32.349 32.349 0 0 1 2.868 4.98L41.554 47.6a6.53 6.53 0 1 0 3.746 5.35l27.136-19.003Z"/></svg>',OX={"unused-css-rules":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Remove Unused CSS` to help with this issue. It will identify the CSS classes that are actually used on each page of your site, and remove any others to keep the file size small.","modern-image-formats":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap\
) and enable `Next-Gen Formats` to convert images to WebP.","offscreen-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Lazy Load Images` to defer loading off-screen images until they are needed.","render-blocking-resources":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Script Delay` to defer non-critical JS.","unminified-css":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Minify CSS` to automatically minify your CSS to reduce network payload sizes.","unminified-javascript":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Minify Javascript` to automatically minify your JS to reduce network payload sizes.","uses-long-cache-ttl":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Efficient Static Cache Policy` to set recommended values in the caching header for static assests.","uses-optimized-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Next-Gen Formats` to convert images to WebP.","uses-\
responsive-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Resize Images` to resize images to a device appropriate size, reducing network payload sizes.","server-response-time":"Use [Ezoic Cloud Caching](https://pubdash.ezoic.com/leap/caching) to cache your content across our world wide network, improving time to first byte.","uses-rel-preconnect":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Pre-Connect Origins` to automatically add `preconnect` resource hints to establish early connections to important third-party origins.","uses-rel-preload":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Preload Fonts` and `Preload Background Images` to add `preload` links to prioritize fetching resources that are currently requested later in page load.","font-display":"Use [Ezoic Leap](https://pubdash.ezoic.com/leap) and enable `Optimize Fonts` to automatically leverage the `font-display` CSS feature to ensure text is user-visible while webfonts \
are loading."};oO.exports={id:"ezoic",title:"Ezoic",icon:MX,UIStrings:OX}});var cO=ve((W2e,sO)=>{d();var PX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="%23639"/><path fill="%23fff" d="M6.2 21.8C4.1 19.7 3 16.9 3 14.2L13.9 25c-2.8-.1-5.6-1.1-7.7-3.2zm10.2 2.9L3.3 11.6C4.4 6.7 8.8 3 14 3c3.7 0 6.9 1.8 8.9 4.5l-1.5 1.3C19.7 6.5 17 5 14 5c-3.9 0-7.2 2.5-8.5 6L17 22.5c2.9-1 5.1-3.5 5.8-6.5H18v-2h7c0 5.2-3.7 9.6-8.6 10.7z"/></svg>',LX={"unused-css-rules":"Use the `PurgeCSS` `Gatsby` plugin to remove unused rules from stylesheets. [Learn more](https://purgecss.com/plugins/gatsby.html).","modern-image-formats":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically optimize image format. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","offscreen-images":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plu\
gin-image).","render-blocking-resources":"Use the `Gatsby Script API` to defer loading of non-critical third-party scripts. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-script/).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://www.gatsbyjs.com/plugins/gatsby-plugin-webpack-bundle-analyser-v2/)","uses-long-cache-ttl":"Configure caching for immutable assets. [Learn more](https://www.gatsbyjs.com/docs/how-to/previews-deploys-hosting/caching/).","uses-optimized-images":"Use the `gatsby-plugin-image` component instead of `<img>` to adjust image quality. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","uses-responsive-images":"Use the `gatsby-plugin-image` component to set appropriate `sizes`. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","prioritize-lcp-image":"Use the `gatsby-plugin-image` component a\
nd set the `loading` prop to `eager`. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-plugin-image#shared-props)."};sO.exports={id:"gatsby",title:"Gatsby",icon:PX,UIStrings:LX}});var uO=ve(($2e,lO)=>{"use strict";d();var FX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 258"><path fill="%23F9AE41" d="M255.7 35.6a33.7 33.7 0 0 0-67-4.8l-.4-.2c-27.6-12.4-50.8 9.6-50.8 9.6l-61.4 61.7 24.3 23.4 49.4-48.6c23-23 35.6-7.4 35.6-7.4 17.4 14.6.6 32 .6 32l24.9 24c20.3-22 21.5-41.1 15.3-56.3a33.7 33.7 0 0 0 29.5-33.4"/><path fill="%23EE4035" d="m226.5 190.5.2-.3c12.4-27.6-9.6-50.8-9.6-50.8L155.4 78l-23.3 24.3 48.5 49.4c23 23 7.5 35.6 7.5 35.6-14.7 17.4-32 .6-32 .6l-24 24.9c21.9 20.3 41 21.5 56.2 15.3a33.7 33.7 0 1 0 38.2-37.6"/><path fill="%234F91CD" d="m156 133-49.5 48.6c-23 23-35.6 7.4-35.6 7.4-17.4-14.6-.6-32-.6-32l-24.9-24c-20.3 22-21.4 41.1-15.3 56.3a33.7 33.7 0 1 0 37.6 38.2l.3.2c27.6 12.4 50.8-9.6 50.8-9.6l61.4-61.7-24.3-23.4"/><path fill="%237AC043" d="M75.7 106.6c-23-23-7.4-35.6-7.4-35.6 14.6-17.4 32-.6 32-.6l24-24.9c-22-20.3-41-21.5-56.3-15.3a33.7 33.7 0 1 0-38.2 37.6l-.2.3C17.2 95.7 39.2 119 39.2 119l6\
1.7 61.4 23.4-24.3-48.6-49.4"/></svg>',UX={"unused-css-rules":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused CSS in your page. To identify extensions that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using a [plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=webp) or service that will automatically convert your uploaded images to the optimal formats.","offscreen-images":"Install a [lazy-load Joomla plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=lazy%20loading) that provid\
es the ability to defer any offscreen images, or switch to a template that provides that functionality. Starting with Joomla 4.0, all new images will [automatically](https://github.com/joomla/joomla-cms/pull/30748) get the `loading` attribute from the core.","total-byte-weight":"Consider showing excerpts in your article categories (e.g. via the read more link), reducing the number of articles shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of Joomla plugins that can help you [inline critical assets](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) or [defer less important resources](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance). Beware that optimizations provided by these plugins may break features of your templates or plugins, so you will need to test these thoroughly.","unminified-css":"A number of [Joomla extens\
ions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your css styles. There are also templates that provide this functionality.","unminified-javascript":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your scripts. There are also templates that provide this functionality.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the ex\
tension responsible from the URL of the script. Look out for extensions that have many scripts in the list which have a lot of red in code coverage. An extension should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in Joomla](https://docs.joomla.org/Cache).","uses-optimized-images":"Consider using an [image optimization plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression by enabling Gzip Page Compression in Joomla (System > Global configuration > Server).","uses-responsive-images":"Consider using a [responsive images plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=responsive%20images) to use responsive images in your content.","server-response-time":"Templates, extensions, and server specifications all contribute to server response time. Consider finding\
 a more optimized template, carefully selecting an optimization extension, and/or upgrading your server."};lO.exports={id:"joomla",title:"Joomla",icon:FX,UIStrings:UX}});var mO=ve((K2e,dO)=>{d();var BX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="%23f26322" viewBox="0 0 1000 1000"><path d="M916.9 267.4v465.3l-111.3 67.4V331.4l-1.5-.9-303.9-189-304.6 189.2-1.2.8V799L83.1 732.6V267.4l.7-.4L500.3 10l416 257 .6.4zM560.7 468.5v383.3L500.3 890l-61-38.2V306.7l-136 84.3v476.6l197 122.5 196.4-122.5V391l-136-84.3v161.8z"/></svg>',jX={"modern-image-formats":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=webp) for a variety of third-party extensions to leverage newer image formats.","offscreen-images":"Consider modifying your product and catalog templates to make use of the web platform's [lazy loading](https://web.dev/native-lazy-loading) feature.","disable-bundling":"Disable Magento's built-in [JavaScript bundling and minification](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html), and consider using [baler](https://github.com/magento/baler/) instead.","\
unminified-css":`Enable the "Minify CSS Files" option in your store's Developer settings. [Learn more](https://devdocs.magento.com/guides/v2.3/performance-best-practices/configuration.html?itm_source=devdocs&itm_medium=search_page&itm_campaign=federated_search&itm_term=minify%20css%20files).`,"unminified-javascript":"Use [Terser](https://www.npmjs.com/package/terser) to minify all JavaScript assets from static content deployment, and disable the built-in minification feature.","unused-javascript":"Disable Magento's built-in [JavaScript bundling](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html).","uses-optimized-images":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=optimize%20image) for a variety of third party extensions to optimize images.","server-response-time":"Use Magento's [Varnish integration](https://devdocs.magento.com/guides/v2.3/config-guide/varnish/config-varnish.html).","uses-rel-pre\
connect":"Preconnect or dns-prefetch resource hints can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","uses-rel-preload":"`<link rel=preload>` tags can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","critical-request-chains":"If you are not bundling your JavaScript assets, consider using [baler](https://github.com/magento/baler).","font-display":"Specify `@font-display` when [defining custom fonts](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/css-topics/using-fonts.html)."};dO.exports={id:"magento",title:"Magento",icon:BX,UIStrings:jX}});var fO=ve((J2e,pO)=>{d();var HX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 207 124"><path fill="%23000" d="M48.942 32.632h38.96v3.082h-35.39v23.193H85.79v3.082H52.513v25.464h35.794v3.081H48.942V32.632Zm42.45 0h4.139l18.343 25.464 18.749-25.464L158.124.287l-41.896 60.485 21.59 29.762h-4.302l-19.642-27.086L94.15 90.534h-4.22l21.751-29.762-20.29-28.14Zm47.967 3.082v-3.082h44.397v3.082h-20.453v54.82h-3.571v-54.82h-20.373ZM.203 32.632h4.464l61.557 91.671-25.439-33.769L3.936 37.011l-.162 53.523H.203zm183.194 53.891c.738 0 1.276-.563 1.276-1.29 0-.727-.538-1.29-1.276-1.29-.73 0-1.277.563-1.277 1.29 0 .727.547 1.29 1.277 1.29Zm3.509-3.393c0 2.146 1.555 3.549 3.822 3.549 2.414 0 3.874-1.446 3.874-3.956v-8.837h-1.946v8.828c0 1.394-.704 2.138-1.946 2.138-1.112 0-1.867-.692-1.893-1.722h-1.911Zm10.24-.113c.14 2.233 2.007 3.662 4.787 3.662 2.97 0 4.83-1.498 4.83-3.887 0-1.878-1.06-2.917-3.632-3.514l-1.38-.338c-1.634-.38-2.294-.891-2.294-1.783 0-1.125 1.025-1.86 2.563-1.\
86 1.459 0 2.466.718 2.649 1.869h1.893c-.113-2.103-1.971-3.583-4.516-3.583-2.737 0-4.56 1.48-4.56 3.704 0 1.835 1.033 2.926 3.3 3.454l1.616.39c1.659.389 2.388.96 2.388 1.912 0 1.108-1.146 1.913-2.71 1.913-1.676 0-2.84-.753-3.005-1.939h-1.928Z"/></svg>',qX={"unused-css-rules":"Consider setting up `PurgeCSS` in `Next.js` configuration to remove unused rules from stylesheets. [Learn more](https://purgecss.com/guides/next.html).","modern-image-formats":"Use the `next/image` component instead of `<img>` to automatically optimize image format. [Learn more](https://nextjs.org/docs/app/getting-started/images).","offscreen-images":"Use the `next/image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://nextjs.org/docs/app/getting-started/images).","render-blocking-resources":"Use the `next/script` component to defer loading of non-critical third-party scripts. [Learn more](https://nextjs.org/docs/app/guides/scripts).","unused-javascript":"Use `Webpack Bundle An\
alyzer` to detect unused JavaScript code. [Learn more](https://github.com/vercel/next.js/tree/canary/packages/next-bundle-analyzer)","uses-long-cache-ttl":"Configure caching for immutable assets and `Server-side Rendered` (SSR) pages. [Learn more](https://nextjs.org/docs/13/pages/building-your-application/deploying/production-checklist#caching).","uses-optimized-images":"Use the `next/image` component instead of `<img>` to adjust image quality. [Learn more](https://nextjs.org/docs/app/getting-started/images).","uses-text-compression":"Enable compression on your Next.js server. [Learn more](https://nextjs.org/docs/api-reference/next.config.js/compression).","uses-responsive-images":"Use the `next/image` component to set the appropriate `sizes`. [Learn more](https://nextjs.org/docs/api-reference/next/image#sizes).","user-timings":"Consider using `Next.js Analytics` to measure your app's real-world performance. [Learn more](https://nextjs.org/docs/pages/guides/analytics).","prioritize-lcp\
-image":'Use the `next/image` component and set "priority" to true to preload LCP image. [Learn more](https://nextjs.org/docs/api-reference/next/image#priority).',"unsized-images":"Use the `next/image` component to make sure images are always sized appropriately. [Learn more](https://nextjs.org/docs/api-reference/next/image#width)."};pO.exports={id:"next.js",title:"Next.js",icon:HX,UIStrings:qX}});var gO=ve((Q2e,hO)=>{d();var zX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="142" height="54"><g fill="none" fill-rule="evenodd"><g fill="%231B004E"><path d="M19.486 53.24h-3.891L4.682 39.247v13.936H0V32.946h5.444l9.475 12.398V32.946h4.567zM21.346 32.94h4.647v3.57h-4.647v-3.57Zm0 5.477h4.647V53.18h-4.647V38.417ZM40.569 53.183H36c-3.408 0-4.991-1.625-4.991-4.697v-6.22h-3.777V38.42h3.777v-5.474h4.598v5.474h4.958v3.846h-4.958v4.588c0 1.597.477 2.252 2.197 2.252h2.764v4.077ZM46.688 53.183h-4.57V38.42h4.57v2.308c.31-.686 1.351-2.336 4.425-2.336h3.13v4.56h-4.004c-2.593 0-3.55.967-3.55 3.019v7.212ZM70.612 45.802c0 4.56-3.409 7.75-8.01 7.75s-8.006-3.19-8.006-7.75c0-4.56 3.408-7.755 8.006-7.755 4.598 0 8.01 3.195 8.01 7.755Zm-4.599 0c0-2.14-1.35-3.733-3.408-3.733-2.057 0-3.44 1.594-3.44 3.733 0 2.139 1.41 3.733 3.44 3.733 2.03 0 3.408-1.598 3.408-3.733ZM72.47 32.946h11.7c4.543 0 7.192 2.28 7.192 6.526 0 4.247-2.649 6.577-7.191 6.577h-6.935v7.125h-4.765V32.946Zm4.766 4.218v\
4.676h6.485c1.832 0 2.736-.883 2.736-2.34 0-1.565-.904-2.336-2.736-2.336h-6.485ZM102.662 51.016c-.254.485-1.636 2.48-4.71 2.48-3.665 0-6.627-2.906-6.627-7.694 0-4.789 2.962-7.667 6.656-7.667 2.962 0 4.372 1.851 4.626 2.336v-2.05h4.567v14.762h-4.512v-2.167Zm-3.327-8.932c-2.03 0-3.384 1.594-3.384 3.733 0 2.14 1.354 3.733 3.384 3.733s3.327-1.597 3.327-3.733-1.298-3.733-3.327-3.733ZM119.184 43.578a2.98 2.98 0 0 0-2.749-1.494c-1.918 0-3.13 1.594-3.13 3.733 0 2.14 1.24 3.758 3.158 3.758 1.807 0 2.625-1.168 2.764-1.51h4.4c-.143 2.052-2.116 5.5-7.275 5.5-4.286 0-7.641-3.078-7.641-7.75 0-4.673 3.328-7.755 7.585-7.755 5.159 0 7.105 3.392 7.33 5.53l-4.442-.012ZM129.712 46.6v6.577h-4.567V32.194h4.567v11.998l5.838-5.784h5.751l-6.994 6.811 7.362 7.952h-5.921z"/></g><g fill="%2325F5CE"><path d="M49.159 4.65c12.832 0 23.235 10.41 23.235 23.251h4.648C77.042 12.491 64.558 0 49.159 0c-15.4 0-27.883 12.492-27.883 27.901h4.647c0-12.841 10.403-23.25 23.236-23.25Z"/><path d="M44.852 25.793a3.632 3.632 0 0 1 \
2.6-5.097L63.8 16.951 50.426 27.09a3.626 3.626 0 0 1-5.574-1.296Z"/></g></g></svg>',GX={"unused-css-rules":"Enable [`Reduce Unused CSS`](https://support.nitropack.io/hc/en-us/articles/360020418457-Reduce-Unused-CSS) to remove CSS rules that are not applicable to this page.","modern-image-formats":"Use [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/16547237162513) to automatically convert your images to WebP.","offscreen-images":"Defer offscreen images by enabling [`Automatic Image Lazy Loading`](https://support.nitropack.io/hc/en-us/articles/12457493524369-NitroPack-Lazy-Loading-Feature-for-Images).","render-blocking-resources":"Enable [`Remove render-blocking resources`](https://support.nitropack.io/hc/en-us/articles/13820893500049-How-to-Deal-with-Render-Blocking-Resources-in-NitroPack) in NitroPack for faster initial load times.","unminified-css":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your \
Caching settings to reduce the size of your CSS, HTML, and JavaScript files for faster load times.","unminified-javascript":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your Caching settings to reduce the size of your JS, HTML, and CSS files for faster load times.","unused-javascript":"Configure [`Delayed Scripts`](https://support.nitropack.io/hc/en-us/articles/1500002600942-Delayed-Scripts) in NitroPack to delay loading of scripts until they are needed.","uses-long-cache-ttl":"Go to the [`Improve Server Response Time`](https://support.nitropack.io/hc/en-us/articles/1500002321821-Improve-Server-Response-Time) feature in the `Caching` menu and adjust your page cache expiration time to improve loading times and user experience.","uses-optimized-images":"Automatically compress, optimize, and convert your images into WebP by enabling the [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/14177271695121-How-\
to-serve-images-in-next-gen-formats-using-NitroPack) setting.","uses-responsive-images":"Enable [`Adaptive Image Sizing`](https://support.nitropack.io/hc/en-us/articles/10123833029905-How-to-Enable-Adaptive-Image-Sizing-For-Your-Site) to preemptively optimize your images and make them match the dimensions of the containers they’re displayed in across all devices.","dom-size":"Contact your account manager to enable [`HTML Lazy Load`](https://support.nitropack.io/hc/en-us/articles/17144942904337). Configuring it will prioritize and optimize your page rendering performance.","font-display":"Use the [`Override Font Rendering Behavior`](https://support.nitropack.io/hc/en-us/articles/16547358865041) option in NitroPack to set a desired value for the CSS font-display rule."};hO.exports={id:"nitropack",title:"NitroPack",icon:zX,UIStrings:GX}});var vO=ve((tRe,yO)=>{d();var WX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 512 512"><path fill="%2300DC82" d="M281.44 397.667h156.88c5.006 0 9.798-1.759 14.133-4.244.336-2.481 8.805-5.596 11.307-9.894 2.502-4.297 4.242-9.173 4.24-14.134-.002-4.962-1.734-9.836-4.24-14.131l-106-182.321c-2.502-4.297-5.559-7.413-9.893-9.894-4.335-2.48-10.542-4.24-15.547-4.24-5.005 0-9.799 1.76-14.133 4.24-4.335 2.481-7.392 5.597-9.894 9.894l-26.853 46.64-53.707-90.457c-2.504-4.296-5.557-8.823-9.893-11.303-4.336-2.481-9.127-2.827-14.133-2.827-5.006 0-9.798.346-14.134 2.827-4.335 2.48-8.802 7.007-11.306 11.303L46.827 355.268c-2.506 4.295-2.8259.169-2.827 14.131-.002 4.961.325 9.836 2.827 14.134 2.502 4.297 6.97 7.413 11.306 9.894 4.336 2.481 9.127 4.24 14.134 4.24H171.2c39.201 0 67.734-17.585 87.627-50.88L306.88 263.4l25.44-43.813 77.733 132.853H306.88l-25.44 45.227ZM169.787 352.44h-69.254l103.174-178.08L256 263.4l-34.639 60.384c-13.21 21.603-28.272 28.656-51.574 28.\
656Z"/></svg>',VX={"modern-image-formats":'Use the `nuxt/image` component and set `format="webp"`. [Learn more](https://image.nuxt.com/usage/nuxt-img#format).',"offscreen-images":'Use the `nuxt/image` component and set `loading="lazy"` for offscreen images. [Learn more](https://image.nuxt.com/usage/nuxt-img#loading).',"uses-optimized-images":"Use the `nuxt/image` component and set the appropriate `quality`. [Learn more](https://image.nuxt.com/usage/nuxt-img#quality).","uses-responsive-images":"Use the `nuxt/image` component and set the appropriate `sizes`. [Learn more](https://image.nuxt.com/usage/nuxt-img#sizes).","prioritize-lcp-image":"Use the `nuxt/image` component and specify `preload` for LCP image. [Learn more](https://image.nuxt.com/usage/nuxt-img#preload).","unsized-images":"Use the `nuxt/image` component and specify explicit `width` and `height`. [Learn more](https://image.nuxt.com/usage/nuxt-img#width-height)."};yO.exports={id:"nuxt",title:"Nuxt",icon:WX,UIStrings:VX}});var wO=ve((rRe,bO)=>{d();var $X='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 310 310"><path fill="none" d="M-1-1h802v602H-1z"/><path fill="%23de6c26" d="M135 6.9c-14.2 4.4-34.9 21.8-49.9 42C55.8 88.5 39.6 135.8 41.4 177c.8 20.2 4.9 35.5 14.4 54.5 13.6 27.4 40.8 55.1 65.5 66.9 14.1 6.7 13.4 6.9 14.1-2.8.3-4.4 1-32.4 1.6-62.1 2.7-137.3 4.4-176 8.2-191.3.6-2.3 1.4-4.2 1.9-4.2 1.2 0 3.6 9.1 4.9 18.3.5 4.3 1 17.7 1 29.8 0 12 .3 21.9.7 21.9.3 0 5.7-5 11.9-11 6.9-6.8 12-11 13.3-11 1.8 0 1.9.3 1 2.7-1.2 3.1-7.9 13.2-19.1 28.5L153 128l.1 31.2c.1 17.2.4 37.4.8 44.9l.6 13.7 11-12.6c14-16 35.1-37.1 39.5-39.6l3.3-1.9-.6 3.2c-2 9.8-9.5 20.7-37.4 54.3L154 240.8v31.1c0 18.3.4 31.1.9 31.1 2.8 0 19.3-6.4 26.8-10.5 13.8-7.3 23.8-15 38.3-29.5 15.7-15.7 24.4-27.4 33.4-45.2 20.5-40 21-80.3 1.6-119-17.8-35.6-54.6-72.1-87.8-86.9-11.7-5.3-24.6-7.3-32.2-5z"/></svg>',YX={"unused-css-rules":"Consider reviewing the [plugins](https://octobercms.com/plugins) loading unused CSS on the webs\
ite. To identify plugins that add unnecessary CSS, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the stylesheet URL. Look for plugins with many stylesheets with lots of red in code coverage. A plugin should only add a stylesheet if it is actually used on the web page.","modern-image-formats":"Consider using a [plugin](https://octobercms.com/plugins?search=image) or service that will automatically convert the uploaded images to the optimal formats. [WebP lossless images](https://developers.google.com/speed/webp) are 26% smaller in size compared to PNGs and 25-34% smaller than comparable JPEG images at the equivalent SSIM quality index. Another next-gen image format to consider is [AVIF](https://jakearchibald.com/2020/avif-has-landed/).","offscreen-images":"Consider installing an [image lazy loading plugin](https://octobercms.com/plugins?search=lazy) that provides the a\
bility to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://octobercms.com/plugins?search=Accelerated+Mobile+Pages).","total-byte-weight":"Consider showing excerpts in the post lists (e.g. using a `show more` button), reducing the number of posts shown on a given web page, breaking long posts into multiple web pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are many plugins that help [inline critical assets](https://octobercms.com/plugins?search=css). These plugins may break other plugins, so you should test thoroughly.","unminified-css":"There are many [plugins](https://octobercms.com/plugins?search=css) that can speed up a website by concatenating, minifying and compressing the styles. Using a build process to do this minification up-front can speed up development.","unminified-javascript":"There are many [plugins](https://octobercms.com/plugins?search=javascript) that ca\
n speed up a website by concatenating, minifying and compressing the scripts. Using a build process to do this minification up-front can speed up development.","efficient-animated-content":"[Replace animated GIFs with video](https://web.dev/replace-gifs-with-videos/) for faster web page loads and consider using modern file formats such as [WebM](https://web.dev/replace-gifs-with-videos/#create-webm-videos) or [AV1](https://developers.google.com/web/updates/2018/09/chrome-70-media-updates#av1-decoder) to improve compression efficiency by greater than 30% over the current state-of-the-art video codec, VP9.","unused-javascript":"Consider reviewing the [plugins](https://octobercms.com/plugins?search=javascript) that load unused JavaScript in the web page. To identify plugins that add unnecessary JavaScript, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the URL of the scri\
pt. Look for plugins with many scripts with lots of red in code coverage. A plugin should only add a script if it is actually used on the web page.","uses-long-cache-ttl":"Read about [preventing unnecessary network requests with the HTTP Cache](https://web.dev/http-cache/#caching-checklist). There are many [plugins](https://octobercms.com/plugins?search=Caching) that can be used to speed up caching.","uses-optimized-images":"Consider using an [image optimization plugin](https://octobercms.com/plugins?search=image) to compresses images while retaining the quality.","uses-text-compression":"Enable text compression in the web server configuration.","uses-responsive-images":"Upload images directly in the media manager to ensure the required image sizes are available. Consider using the [resize filter](https://octobercms.com/docs/markup/filter-resize) or an [image resizing plugin](https://octobercms.com/plugins?search=image) to ensure the optimal image sizes are used.","server-response-time":"\
Themes, plugins and server specifications all contribute to the server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin and/or upgrade the server. October CMS also allows developers to use [`Queues`](https://octobercms.com/docs/services/queues) to defer the processing of a time consuming task, such as sending an e-mail. This drastically speeds up web requests."};bO.exports={id:"octobercms",title:"October CMS",icon:$X,UIStrings:YX}});var TO=ve((oRe,EO)=>{d();var KX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3"><g fill="%2361DAFB"><path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-\
8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27\
.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/><circle cx="420.9" cy="296.5" r="45.7"/><path d="M520.5 78.1z"/></g></svg>',XX={"unminified-css":"If your build system minifies CSS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unminif\
ied-javascript":"If your build system minifies JS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unused-javascript":"If you are not server-side rendering, [split your JavaScript bundles](https://web.dev/code-splitting-suspense/) with `React.lazy()`. Otherwise, code-split using a third-party library such as [loadable-components](https://loadable-components.com/).","server-response-time":"If you are server-side rendering any React components, consider using `renderToPipeableStream()` or `renderToStaticNodeStream()` to allow the client to receive and hydrate different parts of the markup instead of all at once. [Learn more](https://reactjs.org/docs/react-dom-server.html#renderToPipeableStream).",redirects:"If you are using React Router, minimize usage of the `<Redirect>` component for [rout\
e navigations](https://reacttraining.com/react-router/web/api/Redirect).","user-timings":"Use the React DevTools Profiler, which makes use of the Profiler API, to measure the rendering performance of your components. [Learn more.](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)","dom-size":'Consider using a "windowing" library like `react-window` to minimize the number of DOM nodes created if you are rendering many repeated elements on the page. [Learn more](https://web.dev/virtualize-long-lists-react-window/). Also, minimize unnecessary re-renders using [`shouldComponentUpdate`](https://reactjs.org/docs/optimizing-performance.html#shouldcomponentupdate-in-action), [`PureComponent`](https://reactjs.org/docs/react-api.html#reactpurecomponent), or [`React.memo`](https://reactjs.org/docs/react-api.html#reactmemo) and [skip effects](https://reactjs.org/docs/hooks-effect.html#tip-optimizing-performance-by-skipping-effects) only until certain dependencies have change\
d if you are using the `Effect` hook to improve runtime performance.'};EO.exports={id:"react",title:"React",icon:KX,UIStrings:XX}});var SO=ve((sRe,xO)=>{d();var JX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 28"><path fill-rule="evenodd" d="M0 .032s2.796-.356 4.66 1.31C5.81 2.37 6.145 4.008 6.145 4.008L9.952 18.96l3.165-12.239c.309-1.301.864-2.909 1.743-3.997 1.121-1.385 3.398-1.472 3.641-1.472.242 0 2.519.087 3.639 1.472.88 1.088 1.435 2.696 1.744 3.997l3.165 12.239 3.806-14.953s.336-1.638 1.486-2.666C34.205-.324 37 .032 37 .032l-7.289 27.945s-2.404.176-3.607-.446c-1.58-.816-2.332-1.447-3.289-5.249l-.099-.395c-.349-1.399-.883-3.59-1.424-5.813l-.162-.667-.162-.664c-.779-3.198-1.497-6.143-1.612-6.517-.108-.351-.236-1.187-.855-1.187-.607 0-.746.837-.857 1.187-.13.412-.99 3.955-1.856 7.514l-.162.667c-.512 2.107-1.01 4.151-1.341 5.48l-.1.395c-.956 3.802-1.708 4.433-3.288 5.249-1.204.622-3.608.446-3.608.446zM43.998 5v.995L44 5.994v16.628c-.014 3.413-.373 4.17-1.933 4.956-1.213.61-3.067.379-3.067.379V9.332c0-.935.315-1.548 1.477-2.098.693-.329 1.34-.58 2.012-.953C43.54 5.703 43.998 5 43.99\
8 5zM46 .125s3.877-.673 5.797 1.107c1.228 1.14 2.602 3.19 2.602 3.19l3.38 4.965c.164.258.378.54.72.54.343 0 .558-.282.722-.54l3.38-4.965s1.374-2.05 2.602-3.19C67.123-.548 71 .125 71 .125l-9.186 13.923 9.161 13.881-.032.004c-.38.045-4.036.423-5.855-1.266-1.229-1.138-2.487-2.992-2.487-2.992l-3.38-4.964c-.164-.26-.379-.54-.721-.54-.343 0-.557.28-.721.54l-3.38 4.964s-1.19 1.854-2.418 2.992c-1.92 1.783-5.957 1.262-5.957 1.262l9.161-13.88zM43.96 0H44c0 1.91-.186 3.042-1.387 3.923-.384.28-1.048.71-1.826.992C39.719 5.304 39 6 39 6c0-3.476.53-4.734 1.95-5.48.865-.452 2.272-.514 2.82-.52z"></path></svg>',ZX={"modern-image-formats":"Upload images using `Wix Media Manager` to ensure they are automatically served as WebP. Find [more ways to optimize](https://support.wix.com/en/article/site-performance-optimizing-your-media) your site's media.","render-blocking-resources":"When [adding third-party code](https://support.wix.com/en/article/site-performance-using-third-party-code-on-your-site) in the `\
Custom Code` tab of your site's dashboard, make sure it's deferred or loaded at the end of the code body. Where possible, use Wix’s [integrations](https://support.wix.com/en/article/about-marketing-integrations) to embed marketing tools on your site. ","efficient-animated-content":"Place videos inside `VideoBoxes`, customize them using `Video Masks` or add `Transparent Videos`. [Learn more](https://support.wix.com/en/article/wix-video-about-wix-video).","unused-javascript":"Review any third-party code you've added to your site in the `Custom Code` tab of your site's dashboard and only keep the services that are necessary to your site. [Find out more](https://support.wix.com/en/article/site-performance-removing-unused-javascript).","server-response-time":"Wix utilizes CDNs and caching to serve responses as fast as possible for most visitors. Consider [manually enabling caching](https://support.wix.com/en/article/site-performance-caching-pages-to-optimize-loading-speed) for your site, \
especially if using `Velo`."};xO.exports={id:"wix",title:"Wix",icon:JX,UIStrings:ZX}});var kO=ve((lRe,CO)=>{d();var QX='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.5 122.5"><g fill="%232f3439"><path d="M8.7 61.3c0 20.8 12.1 38.7 29.6 47.3l-25-68.7c-3 6.5-4.6 13.7-4.6 21.4zm88-2.7c0-6.5-2.3-11-4.3-14.5-2.7-4.3-5.2-8-5.2-12.3 0-4.8 3.7-9.3 8.9-9.3h.7a52.4 52.4 0 0 0-79.4 9.9h3.3c5.5 0 14-.6 14-.6 2.9-.2 3.2 4 .4 4.3 0 0-2.9.4-6 .5l19.1 57L59.7 59l-8.2-22.5c-2.8-.1-5.5-.5-5.5-.5-2.8-.1-2.5-4.5.3-4.3 0 0 8.7.7 13.9.7 5.5 0 14-.7 14-.7 2.8-.2 3.2 4 .3 4.3 0 0-2.8.4-6 .5l19 56.5 5.2-17.5c2.3-7.3 4-12.5 4-17z"/><path d="m62.2 65.9-15.8 45.8a52.6 52.6 0 0 0 32.3-.9l-.4-.7zM107.4 36a49.6 49.6 0 0 1-3.6 24.2l-16.1 46.5A52.5 52.5 0 0 0 107.4 36z"/><path d="M61.3 0a61.3 61.3 0 1 0 .1 122.7A61.3 61.3 0 0 0 61.3 0zm0 119.7a58.5 58.5 0 1 1 .1-117 58.5 58.5 0 0 1-.1 117z"/></g></svg>',eJ={"unused-css-rules":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused CSS in your page. To identify plugi\
ns that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using the [Performance Lab](https://wordpress.org/plugins/performance-lab/) plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.","offscreen-images":"Install a [lazy-load WordPress plugin](https://wordpress.org/plugins/search/lazy+load/) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://wordpress.org/plugins/amp/).","total-byte-weight":"Consider showing excerpts in your post lists (e.g. via the more tag), reducing the number\
 of posts shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of WordPress plugins that can help you [inline critical assets](https://wordpress.org/plugins/search/critical+css/) or [defer less important resources](https://wordpress.org/plugins/search/defer+css+javascript/). Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.","unminified-css":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+css/) can speed up your site by concatenating, minifying, and compressing your styles. You may also want to use a build process to do this minification up-front if possible.","unminified-javascript":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+javascript/) can speed up your site by concatenating, minifying, and compressing your scripts. You may a\
lso want to use a build process to do this minification up front if possible.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the script. Look out for plugins that have many scripts in the list which have a lot of red in code coverage. A plugin should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in WordPress](https://wordpress.org/support/article/optimization/#browser-caching).","uses-optimized-images":"Consider using an [image optimization WordPress plugin](https://wordpre\
ss.org/plugins/search/optimize+images/) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression in your web server configuration.","uses-responsive-images":"Upload images directly through the [media library](https://wordpress.org/support/article/media-library-screen/) to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using `Full Size` images unless the dimensions are adequate for their usage. [Learn More](https://wordpress.org/support/article/inserting-images-into-posts-and-pages/).","server-response-time":"Choose a lightweight theme (ideally a block theme) and implement full-page caching or a static site solution. Disable unnecessary plugins to minimize server overhead. Consider upgrading your hosting to managed or dedicated service."};CO.exports={id:"wordpress",
title:"WordPress",icon:QX,UIStrings:eJ}});var _O=ve((dRe,RO)=>{d();var tJ='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294 524"><defs><linearGradient id="a" x1="36.742%" x2="37.116%" y1="100.518%" y2="-.001%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="b" x1="28.046%" x2="28.421%" y1="100.518%" y2="-.003%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="c" x1="38.215%" x2="38.589%" y1="100.518%" y2="0%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><path fill="url(%23a)" d="M218.617 270.615c-9.752 0-18.896-5.689-23.366-14.63l-7.72-17.27h-76.6l-7.722 17.27c-4.47 8.941-13.613 14.63-23.366 14.63H75.78l32.712 249.306\
c1.625 4.671 4.673 4.671 6.502 0l32.51-79.648 28.242 79.442c1.625 4.676 4.673 4.676 6.501 0L220.04 270.82l-1.423-.204Z" transform="translate(-1.58 -.2)"/><path fill="url(%23b)" d="M184.47 231.784h-70.3l-10.77 24.179c-3.657 7.314-10.768 12.597-18.489 14.02L109.7 423.791c1.625 2.844 4.673 2.844 6.501 0l31.697-48.155 29.055 47.951c1.829 2.845 4.673 2.845 6.502 0l28.039-154.012c-6.908-2.032-13.004-6.908-16.255-13.613l-10.768-24.18Z" transform="translate(-1.58 -.2)"/><path fill="url(%23c)" d="m195.259 255.988-46.123-103.014-45.92 103.014c-1.625 3.048-3.656 5.69-6.095 7.925l19.1 102.2c1.015 1.423 3.657 1.83 5.485 0l25.601-33.931 25.602 33.728c1.625 2.032 4.47 1.626 5.485 0l21.131-103.42c-1.625-2.032-3.047-4.064-4.266-6.502Z" transform="translate(-1.58 -.2)"/><path fill="%23F56F46" d="M.439 12.559c-1.422-4.877 1.422-8.33 6.299-8.33H47.17c2.845 0 5.486 2.437 6.299 4.876l29.665 116.83h1.422l53.437-121.3c1.016-2.032 3.048-3.86 5.892-3.86h6.299c3.047 0 5.08 1.625 5.892 3.86l53.437 121.3h1.423L240\
.6 9.105c.61-2.439 3.454-4.877 6.299-4.877h40.433c4.877 0 7.518 3.454 6.299 8.33l-65.221 231.63c-.61 2.845-3.454 4.876-6.298 4.876h-5.487c-2.438 0-4.876-1.625-5.892-3.86l-63.19-141.009h-1.015L83.744 245.203c-1.016 2.032-3.454 3.86-5.892 3.86h-5.486c-2.845 0-5.486-2.031-6.299-4.876L.44 12.559Z"/></g></svg>',nJ={"unused-css-rules":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket' to fix this issue. It reduces page size by removing all CSS and stylesheets that are not used while keeping only the used CSS for each page.","modern-image-formats":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' to convert your images to WebP.","unused-javascript":"Enable [Delay JavaScript execution](https://docs.wp-rocket.me/article/1349-delay-javascript-execution) in 'WP Rocket' to fix this problem. It will improve the loading of your page by delaying the execution of scripts until user interaction. If your site has iframes, you can use WP Ro\
cket's [LazyLoad for iframes and videos](https://docs.wp-rocket.me/article/1674-lazyload-for-iframes-and-videos) and [Replace YouTube iframe with preview image](https://docs.wp-rocket.me/article/1488-replace-youtube-iframe-with-preview-image) as well.","render-blocking-resources":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) and [Load JavaScript deferred](https://docs.wp-rocket.me/article/1265-load-javascript-deferred) in 'WP Rocket' to address this recommendation. These features will respectively optimize the CSS and JavaScript files so that they don't block the rendering of your page.","unminified-css":"Enable [Minify CSS files](https://docs.wp-rocket.me/article/1350-css-minify-combine) in 'WP Rocket' to fix this issue. Any spaces and comments in your site's CSS files will be removed to make the file size smaller and faster to download.","unminified-javascript":"Enable [Minify JavaScript files](https://docs.wp-rocket.me/article/1351-javascript-\
minify-combine) in 'WP Rocket' to fix this issue. Empty spaces and comments will be removed from JavaScript files to make their size smaller and faster to download.","uses-optimized-images":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' and run Bulk Optimization to compress your images.","uses-rel-preconnect":`Use [Prefetch DNS Requests](https://docs.wp-rocket.me/article/1302-prefetch-dns-requests) in 'WP Rocket' to add "dns-prefetch" and speed up the connection with external domains. Also, 'WP Rocket' automatically adds "preconnect" to [Google Fonts domain](https://docs.wp-rocket.me/article/1312-optimize-google-fonts) and any CNAME(S) added via the [Enable CDN](https://docs.wp-rocket.me/article/42-using-wp-rocket-with-a-cdn) feature.`,"uses-rel-preload":"To fix this issue for fonts, enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket'. Your site's critical fonts will be preloaded with priority.","offscreen-images":"Enabl\
e [LazyLoad](https://docs.wp-rocket.me/article/1141-lazyload-for-images) in WP Rocket to fix this recommendation. This feature delays the loading of the images until the visitor scrolls down the page and actually needs to see them."};RO.exports={id:"wp-rocket",title:"WP Rocket",icon:tJ,UIStrings:nJ}});var DO=ve((pRe,IO)=>{d();var rJ=[eO(),nO(),aO(),iO(),cO(),uO(),mO(),fO(),gO(),vO(),wO(),TO(),SO(),kO(),_O()];IO.exports=rJ});var NO=ve((hRe,AO)=>{d();AO.exports=i(function(t,n){if(typeof t=="string"&&n[t])return t;for(var r=[].concat(t||[]),a=0,o=r.length;a<o;++a)for(var s=r[a].split("-");s.length;){var c=s.join("-");if(n[c])return c;s.pop()}},"lookupClosestLocale")});var ef,aJ,MO,tf=g(()=>{"use strict";d();fo();ho();_i();ef=At.dirname(""),aJ=JSON.parse(`{
  "name": "lighthouse",
  "type": "module",
  "version": "13.0.1",
  "description": "Automated auditing, performance metrics, and best practices for the web.",
  "main": "./core/index.js",
  "bin": {
    "lighthouse": "./cli/index.js",
    "chrome-debug": "./core/scripts/manual-chrome-launcher.js",
    "smokehouse": "./cli/test/smokehouse/frontends/smokehouse-bin.js"
  },
  "engines": {
    "node": ">=22.19"
  },
  "scripts": {
    "prepack": "yarn build-report --standalone --flow --esm && yarn build-types",
    "postpack": "yarn clean-types",
    "build-all": "yarn build-report && yarn build-cdt-strings && yarn build-devtools && concurrently 'yarn build-extension' 'yarn build-lr' 'yarn build-viewer' 'yarn build-treemap' 'yarn build-smokehouse-bundle' 'yarn build-legacy-javascript' && yarn build-pack",
    "build-cdt-lib": "node ./build/build-cdt-lib.js",
    "build-cdt-strings": "node ./build/build-cdt-strings.js",
    "build-extension": "yarn build-extension-chrome && yarn build-extension-firefox",
    "build-extension-chrome": "node ./build/build-extension.js chrome",
    "build-extension-firefox": "node ./build/build-extension.js firefox",
    "build-devtools": "yarn reset-link && node ./build/build-bundle.js clients/devtools/devtools-entry.js dist/lighthouse-dt-bundle.js && node ./build/build-dt-report-resources.js",
    "build-legacy-javascript": "node ./build/build-legacy-javascript.js",
    "build-smokehouse-bundle": "node ./build/build-smokehouse-bundle.js",
    "build-lr": "yarn reset-link && node --max-old-space-size=4096 ./build/build-lightrider-bundles.js",
    "build-pack": "bash build/build-pack.sh",
    "build-report": "node build/build-report-components.js && node build/build-report.js",
    "build-sample-reports": "yarn build-report && node build/build-sample-reports.js",
    "build-treemap": "node ./build/build-treemap.js",
    "build-viewer": "node ./build/build-viewer.js",
    "build-types": "yarn type-check && rsync -a .tmp/tsbuildinfo/ ./ --include='*.d.ts' --include='*.d.cts' --exclude='*.map' --exclude='*.tsbuildinfo'",
    "reset-link": "(yarn unlink || true) && yarn link && yarn link lighthouse",
    "c8": "bash core/scripts/c8.sh",
    "clean": "rm -r dist proto/scripts/*.json proto/scripts/*_pb2.* proto/scripts/*_pb.* proto/scripts/__pycache__ proto/scripts/*.pyc *.report.html *.report.dom.html *.report.json *.devtoolslog.json *.trace.json shared/localization/locales/*.ctc.json || true",
    "clean-types": "git clean -xfq '*.d.ts' '*.d.cts' -e 'node_modules/' -e 'dist/' -e '.tmp/' -e '**/types/'",
    "lint": "[ \\"$CI\\" = true ] && eslint --quiet -f codeframe . || eslint .",
    "smoke": "node -r source-map-support/register cli/test/smokehouse/frontends/smokehouse-bin.js",
    "debug": "node --inspect-brk ./cli/index.js",
    "start": "yarn build-report --standalone && node ./cli/index.js",
    "mocha": "node core/test/scripts/run-mocha-tests.js",
    "test": "yarn diff:sample-json && yarn lint --quiet && yarn unit && yarn type-check",
    "test-bundle": "yarn smoke --runner bundle",
    "test-clients": "yarn mocha --testMatch clients/**/*-test.js && yarn mocha --testMatch clients/**/*-test-pptr.js",
    "test-viewer": "yarn unit-viewer && yarn mocha --testMatch viewer/**/*-test-pptr.js --timeout 35000",
    "test-treemap": "yarn unit-treemap && yarn mocha --testMatch treemap/**/*-test-pptr.js --timeout 35000",
    "test-lantern": "bash core/scripts/test-lantern.sh",
    "test-legacy-javascript": "bash core/scripts/test-legacy-javascript.sh",
    "test-docs": "yarn --cwd docs/recipes/ test",
    "test-proto": "yarn compile-proto && yarn build-proto-roundtrip",
    "unit-core": "yarn mocha core",
    "unit-cli": "yarn mocha --testMatch cli/**/*-test.js",
    "unit-lantern-trace": "INTERNAL_LANTERN_USE_TRACE=1 yarn mocha core/test/computed/metrics core/test/audits",
    "unit-report": "yarn mocha --testMatch report/**/*-test.js",
    "unit-treemap": "yarn mocha --testMatch treemap/**/*-test.js",
    "unit-viewer": "yarn mocha --testMatch viewer/**/*-test.js",
    "unit-flow": "bash flow-report/test/run-flow-report-tests.sh",
    "unit": "yarn unit-flow && yarn mocha && yarn unit-lantern-trace",
    "unit:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit",
    "unit-lantern-trace:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit-lantern-trace",
    "core-unit": "yarn unit-core",
    "cli-unit": "yarn unit-cli",
    "viewer-unit": "yarn unit-viewer",
    "watch": "yarn unit-core --watch",
    "unit:cicoverage": "yarn c8 --all yarn unit:ci && yarn c8 --all yarn unit-lantern-trace:ci",
    "coverage": "yarn unit:cicoverage && c8 report --reporter html",
    "coverage:smoke": "yarn c8 yarn smoke -j=1 && c8 report --reporter html",
    "devtools": "bash core/scripts/roll-to-devtools.sh",
    "chrome": "node core/scripts/manual-chrome-launcher.js",
    "fast": "node ./cli/index.js --preset=desktop --throttlingMethod=provided",
    "deploy-treemap": "yarn build-treemap --deploy",
    "deploy-viewer": "yarn build-viewer --deploy",
    "vercel-build": "yarn build-sample-reports && yarn build-viewer && yarn build-treemap",
    "dogfood-lhci": "./core/scripts/dogfood-lhci.sh",
    "timing-trace": "node core/scripts/generate-timing-trace.js",
    "changelog": "conventional-changelog --config ./build/changelog-generator/index.cjs --infile changelog.md --same-file",
    "type-check": "tsc --build ./tsconfig-all.json",
    "i18n:checks": "./core/scripts/i18n/assert-strings-collected.sh",
    "i18n:collect-strings": "node core/scripts/i18n/collect-strings.js",
    "update:lantern-baseline": "node core/scripts/lantern/update-baseline-lantern-values.js",
    "update:sample-artifacts": "node core/scripts/update-report-fixtures.js",
    "update:sample-json": "yarn i18n:collect-strings && node ./cli -A=./core/test/results/artifacts --config-path=./core/test/results/sample-config.js --output=json --output-path=./core/test/results/sample_v2.json && node core/scripts/cleanup-LHR-for-diff.js ./core/test/results/sample_v2.json --only-remove-timing && node ./core/scripts/update-flow-fixtures.js",
    "update:flow-sample-json": "yarn i18n:collect-strings && node ./core/scripts/update-flow-fixtures.js",
    "test-devtools": "bash core/test/devtools-tests/test-locally.sh",
    "open-devtools": "bash core/scripts/open-devtools.sh",
    "run-devtools": "node core/scripts/pptr-run-devtools.js",
    "diff:sample-json": "yarn i18n:checks && bash core/scripts/assert-golden-lhr-unchanged.sh",
    "diff:flow-sample-json": "yarn i18n:collect-strings && bash core/scripts/assert-baseline-flow-result-unchanged.sh",
    "computeBenchmarkIndex": "./core/scripts/benchmark.js",
    "save-latest-run": "./core/scripts/save-latest-run.sh",
    "compile-proto": "protoc --python_out=./ ./proto/lighthouse-result.proto && mv ./proto/*_pb2.py ./proto/scripts || (echo \\"❌ Install protobuf = 3.20.x to compile the proto file.\\" && false)",
    "build-proto-roundtrip": "mkdir -p .tmp && python3 proto/scripts/json_roundtrip_via_proto.py",
    "static-server": "node cli/test/fixtures/static-server.js",
    "serve-dist": "cd dist && python3 -m http.server 7878",
    "serve-gh-pages": "cd dist/gh-pages && python3 -m http.server 7333",
    "serve-treemap": "yarn serve-gh-pages",
    "serve-viewer": "yarn serve-gh-pages",
    "flow-report": "yarn build-report --flow && node ./core/scripts/build-test-flow-report.js",
    "generate-insight-audits": "node core/scripts/generate-insight-audits.js"
  },
  "devDependencies": {
    "@build-tracker/cli": "^1.0.0-beta.15",
    "@esbuild-kit/esm-loader": "^2.6.5",
    "@esbuild-plugins/node-modules-polyfill": "^0.1.4",
    "@eslint/compat": "^1.3.0",
    "@eslint/eslintrc": "^3.3.1",
    "@eslint/js": "^9.28.0",
    "@formatjs/icu-messageformat-parser": "^2.6.2",
    "@jest/fake-timers": "^29.7.0",
    "@testing-library/preact": "^3.1.1",
    "@testing-library/preact-hooks": "^1.1.0",
    "@types/archiver": "^2.1.2",
    "@types/chrome": "^0.0.154",
    "@types/configstore": "^6.0.2",
    "@types/cpy": "^5.1.0",
    "@types/debug": "^4.1.7",
    "@types/eslint": "^9.6.1",
    "@types/estree": "^0.0.50",
    "@types/gh-pages": "^2.0.0",
    "@types/google.analytics": "0.0.39",
    "@types/gtag.js": "0.0.20",
    "@types/jpeg-js": "^0.3.7",
    "@types/jsdom": "^16.2.13",
    "@types/lodash-es": "^4.17.12",
    "@types/mocha": "^9.0.0",
    "@types/node": "*",
    "@types/pako": "^1.0.1",
    "@types/resize-observer-browser": "^0.1.1",
    "@types/resolve": "^1.20.2",
    "@types/semver": "^5.5.0",
    "@types/ws": "^7.0.0",
    "@types/yargs": "^17.0.8",
    "@types/yargs-parser": "^20.2.1",
    "@typescript-eslint/eslint-plugin": "^8.34.0",
    "@typescript-eslint/parser": "^8.34.0",
    "acorn": "^8.5.0",
    "angular": "^1.7.4",
    "archiver": "^7.0.1",
    "builtin-modules": "^3.3.0",
    "c8": "^7.11.3",
    "chalk": "^2.4.1",
    "chrome-devtools-frontend": "1.0.1526630",
    "colors": "^1.4.0",
    "concurrently": "^9.2.1",
    "conventional-changelog-cli": "^2.1.1",
    "core-js-compat": "^3.44.0",
    "cpy": "^8.1.2",
    "csv-validator": "^0.0.3",
    "esbuild": "0.25.9",
    "eslint": "^9.28.0",
    "eslint-config-google": "^0.14.0",
    "eslint-formatter-codeframe": "^7.32.1",
    "eslint-plugin-import": "^2.25.3",
    "eslint-plugin-local-rules": "1.1.0",
    "expect": "^28.1.0",
    "firebase": "^9.0.2",
    "gh-pages": "^2.0.1",
    "glob": "^7.1.3",
    "globals": "^15.14.0",
    "idb-keyval": "2.2.0",
    "jest-mock": "^29.7.0",
    "jest-snapshot": "^29.7.0",
    "jsdom": "^12.2.0",
    "lighthouse-plugin-soft-navigation": "^1.1.0",
    "magic-string": "^0.25.7",
    "mime-types": "^2.1.30",
    "mocha": "^10.0.0",
    "pako": "^2.1.0",
    "preact": "^10.7.2",
    "pretty-json-stringify": "^0.0.2",
    "puppeteer": "^24.23.0",
    "resolve": "^1.22.10",
    "rollup-plugin-polyfill-node": "^0.12.0",
    "source-map-support": "^0.5.21",
    "terser": "^5.18.2",
    "testdouble": "^3.20.2",
    "typed-query-selector": "^2.12.0",
    "typescript": "5.8.2",
    "wait-for-expect": "^3.0.2",
    "webtreemap-cdt": "^3.2.1"
  },
  "dependencies": {
    "@paulirish/trace_engine": "0.0.61",
    "@sentry/node": "^9.28.1",
    "axe-core": "^4.11.0",
    "chrome-launcher": "^1.2.1",
    "configstore": "^7.0.0",
    "csp_evaluator": "1.1.5",
    "devtools-protocol": "0.0.1527314",
    "enquirer": "^2.3.6",
    "http-link-header": "^1.1.1",
    "intl-messageformat": "^10.5.3",
    "jpeg-js": "^0.4.4",
    "js-library-detector": "^6.7.0",
    "lighthouse-logger": "^2.0.2",
    "lighthouse-stack-packs": "1.12.3",
    "lodash-es": "^4.17.21",
    "lookup-closest-locale": "6.2.0",
    "open": "^8.4.0",
    "puppeteer-core": "^24.23.0",
    "robots-parser": "^3.0.1",
    "speedline-core": "^1.4.3",
    "third-party-web": "^0.27.0",
    "tldts-icann": "^7.0.17",
    "ws": "^7.0.0",
    "yargs": "^17.3.1",
    "yargs-parser": "^21.0.0"
  },
  "resolutions": {
    "puppeteer/**/devtools-protocol": "0.0.1527314",
    "puppeteer-core/**/devtools-protocol": "0.0.1527314"
  },
  "repository": "GoogleChrome/lighthouse",
  "keywords": [
    "google",
    "chrome",
    "devtools"
  ],
  "author": "Google LLC",
  "license": "Apache-2.0",
  "bugs": {
    "url": "https://github.com/GoogleChrome/lighthouse/issues"
  },
  "homepage": "https://github.com/GoogleChrome/lighthouse#readme",
  "packageManager": "yarn@1.22.22+sha512.a6b2f7906b721bba3d67d4aff083df04dad64c399707841b7acf00f6b133b7ac24255f2652fa22ae3534329dc6180534e98d17432037ff6fd140556e2bb3137e"
}
`),MO=aJ.version});function nf(e,t){if(typeof Intl!="object")throw new Error("Lighthouse must be run in Node with `Intl` support. See https://nodejs.org/api/intl.html for help");let n=Intl.getCanonicalLocales(e),r=Intl.NumberFormat.supportedLocalesOf(n),a=t||JM(),o=Object.fromEntries(a.map(c=>[c,{}])),s=(0,OO.default)(r,o);return s||(Intl.NumberFormat.supportedLocalesOf("es").length===0&&M.warn("i18n","Requested locale not available in this version of node. The `full-icu` npm module can provide additional locales. For help, see https://github.com/GoogleChrome/lighthouse/blob/main/readme.md#how-do-i-get-localized-lighthouse-results-via-the-cli"),M.warn("i18n",`locale(s) '${e}' not available. Falling back to default '${Ls}'`)),s||Ls}function T(e,t={}){e.startsWith("file://")&&(e=Ri.fileURLToPath(e)),At.isAbsolute(e)&&(e=At.relative(ef,e));let n={...D,...t};return i((a,o)=>{let s=Object.keys(n).find(m=>n[m]===a);if(!s)throw new Error(`Could not locate: ${a}`);return{i18nId:`${(s in t?e:At.relative(ef,HM({url:"\
core/lib/i18n/i18n.js"}))).replace(/\\/g,"/")} | ${s}`,values:o,formattedDefault:Ay(a,o,Ls)}},"getIcuMessageFn")}function Qr(e){return typeof e=="string"||Fs(e)}var OO,D,A=g(()=>{"use strict";d();ho();Hl();OO=Tn(NO(),1);Ve();Ia();tf();Ia();_i();D={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Est savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Est savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Est Savings",columnWastedMs:"Est Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnElement:"Element",columnStartTime:"\
Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",total:"Total",totalResourceType:"Total",documentResourceType:"Document",scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift",interactionToNextPaint:"Interaction to Next Paint",itemSeverityLow:"Low",itemSeverityMedium:"Medium",itemSeverityHigh:"High"};i(nf,"lookupLocale");i(T,"createIcuMessageFn");i(Qr,"isStringOrIcuM\
essage")});function LO(e){if(!e)return[];let t=[];for(let n of e){let r=Oy.find(l=>l.requiredStacks.includes(`${n.detector}:${n.id}`));if(!r)continue;let a=PO.default.find(l=>l.id===r.packId);if(!a){M.warn("StackPacks",`'${r.packId}' stack pack was matched but is not found in stack-packs lib`);continue}let o=T(`node_modules/lighthouse-stack-packs/packs/${a.id}.js`,a.UIStrings),s={},c=a.UIStrings;for(let l in c)c[l]&&(s[l]=o(c[l]));t.push({id:a.id,title:a.title,iconDataURL:a.icon,descriptions:s})}return t.sort((n,r)=>{let a=Oy.findIndex(s=>s.packId===n.id),o=Oy.findIndex(s=>s.packId===r.id);return a-o})}var PO,Oy,FO=g(()=>{"use strict";d();Ve();PO=Tn(DO(),1);A();Oy=[{packId:"gatsby",requiredStacks:["js:gatsby"]},{packId:"wordpress",requiredStacks:["js:wordpress"]},{packId:"wix",requiredStacks:["js:wix"]},{packId:"wp-rocket",requiredStacks:["js:wp-rocket"]},{packId:"ezoic",requiredStacks:["js:ezoic"]},{packId:"drupal",requiredStacks:["js:drupal"]},{packId:"nitropack",requiredStacks:["js:nitropack"]},
{packId:"amp",requiredStacks:["js:amp"]},{packId:"magento",requiredStacks:["js:magento"]},{packId:"octobercms",requiredStacks:["js:octobercms"]},{packId:"joomla",requiredStacks:["js:joomla"]},{packId:"next.js",requiredStacks:["js:next"]},{packId:"nuxt",requiredStacks:["js:nuxt"]},{packId:"angular",requiredStacks:["js:angular"]},{packId:"react",requiredStacks:["js:react"]}];i(LO,"getStackPacks")});var Py,Ht,UO=g(()=>{d();typeof Object.create=="function"?Py=i(function(t,n){t.super_=n,t.prototype=Object.create(n.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})},"inherits"):Py=i(function(t,n){t.super_=n;var r=i(function(){},"TempCtor");r.prototype=n.prototype,t.prototype=new r,t.prototype.constructor=t},"inherits");Ht=Py});function cJ(e){if(!Gy(e)){for(var t=[],n=0;n<arguments.length;n++)t.push(Eo(arguments[n]));return t.join(" ")}for(var n=1,r=arguments,a=r.length,o=String(e).replace(sJ,function(c){if(c==="%%")return"%";if(n>=a)return c;switch(c){case"%s":return String(r[n++]);case"%d":return Number(r[n++]);case"%j":try{return JSON.stringify(r[n++])}catch{return"[Circular]"}default:return c}}),s=r[n];n<a;s=r[++n])zy(s)||!ql(s)?o+=" "+s:o+=" "+Eo(s);return o}function qy(e,t){if(wo(globalThis.process))return function(){return qy(e,t).apply(this,arguments)};if(Sn.noDeprecation===!0)return e;var n=!1;function r(){if(!n){if(Sn.throwDeprecation)throw new Error(t);Sn.traceDeprecation?console.trace(t):console.error(t),n=!0}return e.apply(this,arguments)}return i(r,"deprecated"),r}function jO(e){if(wo(Ly)&&(Ly=Sn.env.NODE_DEBUG||""),e=e.toUpperCase(),!rf[e])if(new RegExp("\\b"+e+"\\b","i").test(Ly)){var t=0;rf[e]=function(){var n=cJ.apply(null,arguments);console.error("%s %d: %s",e,t,n)}}else rf[e]=function(){};
return rf[e]}function Eo(e,t){var n={seen:[],stylize:uJ};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),HO(t)?n.showHidden=t:t&&yJ(n,t),wo(n.showHidden)&&(n.showHidden=!1),wo(n.depth)&&(n.depth=2),wo(n.colors)&&(n.colors=!1),wo(n.customInspect)&&(n.customInspect=!0),n.colors&&(n.stylize=lJ),af(n,e,n.depth)}function lJ(e,t){var n=Eo.styles[t];return n?"\x1B["+Eo.colors[n][0]+"m"+e+"\x1B["+Eo.colors[n][1]+"m":e}function uJ(e,t){return e}function dJ(e){var t={};return e.forEach(function(n,r){t[n]=!0}),t}function af(e,t,n){if(e.customInspect&&t&&jy(t.inspect)&&t.inspect!==Eo&&!(t.constructor&&t.constructor.prototype===t)){var r=t.inspect(n,e);return Gy(r)||(r=af(e,r,n)),r}var a=mJ(e,t);if(a)return a;var o=Object.keys(t),s=dJ(o);if(e.showHidden&&(o=Object.getOwnPropertyNames(t)),By(t)&&(o.indexOf("message")>=0||o.indexOf("description")>=0))return Fy(t);if(o.length===0){if(jy(t)){var c=t.name?": "+t.name:"";return e.stylize("[Function"+c+"]","\
special")}if(Uy(t))return e.stylize(RegExp.prototype.toString.call(t),"regexp");if(BO(t))return e.stylize(Date.prototype.toString.call(t),"date");if(By(t))return Fy(t)}var l="",u=!1,m=["{","}"];if(hJ(t)&&(u=!0,m=["[","]"]),jy(t)){var p=t.name?": "+t.name:"";l=" [Function"+p+"]"}if(Uy(t)&&(l=" "+RegExp.prototype.toString.call(t)),BO(t)&&(l=" "+Date.prototype.toUTCString.call(t)),By(t)&&(l=" "+Fy(t)),o.length===0&&(!u||t.length==0))return m[0]+l+m[1];if(n<0)return Uy(t)?e.stylize(RegExp.prototype.toString.call(t),"regexp"):e.stylize("[Object]","special");e.seen.push(t);var f;return u?f=pJ(e,t,n,s,o):f=o.map(function(h){return Hy(e,t,n,s,h,u)}),e.seen.pop(),fJ(f,l,m)}function mJ(e,t){if(wo(t))return e.stylize("undefined","undefined");if(Gy(t)){var n="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(n,"string")}if(gJ(t))return e.stylize(""+t,"number");if(HO(t))return e.stylize(""+t,"boolean");if(zy(t))return e.stylize("null","null")}function Fy(e){
return"["+Error.prototype.toString.call(e)+"]"}function pJ(e,t,n,r,a){for(var o=[],s=0,c=t.length;s<c;++s)qO(t,String(s))?o.push(Hy(e,t,n,r,String(s),!0)):o.push("");return a.forEach(function(l){l.match(/^\d+$/)||o.push(Hy(e,t,n,r,l,!0))}),o}function Hy(e,t,n,r,a,o){var s,c,l;if(l=Object.getOwnPropertyDescriptor(t,a)||{value:t[a]},l.get?l.set?c=e.stylize("[Getter/Setter]","special"):c=e.stylize("[Getter]","special"):l.set&&(c=e.stylize("[Setter]","special")),qO(r,a)||(s="["+a+"]"),c||(e.seen.indexOf(l.value)<0?(zy(n)?c=af(e,l.value,null):c=af(e,l.value,n-1),c.indexOf(`
`)>-1&&(o?c=c.split(`
`).map(function(u){return"  "+u}).join(`
`).substr(2):c=`
`+c.split(`
`).map(function(u){return"   "+u}).join(`
`))):c=e.stylize("[Circular]","special")),wo(s)){if(o&&a.match(/^\d+$/))return c;s=JSON.stringify(""+a),s.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(s=s.substr(1,s.length-2),s=e.stylize(s,"name")):(s=s.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),s=e.stylize(s,"string"))}return s+": "+c}function fJ(e,t,n){var r=0,a=e.reduce(function(o,s){return r++,s.indexOf(`
`)>=0&&r++,o+s.replace(/\u001b\[\d\d?m/g,"").length+1},0);return a>60?n[0]+(t===""?"":t+`
 `)+" "+e.join(`,
  `)+" "+n[1]:n[0]+t+" "+e.join(", ")+" "+n[1]}function hJ(e){return Array.isArray(e)}function HO(e){return typeof e=="boolean"}function zy(e){return e===null}function gJ(e){return typeof e=="number"}function Gy(e){return typeof e=="string"}function wo(e){return e===void 0}function Uy(e){return ql(e)&&Wy(e)==="[object RegExp]"}function ql(e){return typeof e=="object"&&e!==null}function BO(e){return ql(e)&&Wy(e)==="[object Date]"}function By(e){return ql(e)&&(Wy(e)==="[object Error]"||e instanceof Error)}function jy(e){return typeof e=="function"}function Wy(e){return Object.prototype.toString.call(e)}function yJ(e,t){if(!t||!ql(t))return e;for(var n=Object.keys(t),r=n.length;r--;)e[n[r]]=t[n[r]];return e}function qO(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function vJ(e){if(typeof e!="function")throw new TypeError('The "original" argument must be of type Function');if(Di&&e[Di]){var t=e[Di];if(typeof t!="function")throw new TypeError('The "util.promisify.custom" argument m\
ust be of type Function');return Object.defineProperty(t,Di,{value:t,enumerable:!1,writable:!1,configurable:!0}),t}function t(){for(var n,r,a=new Promise(function(c,l){n=c,r=l}),o=[],s=0;s<arguments.length;s++)o.push(arguments[s]);o.push(function(c,l){c?r(c):n(l)});try{e.apply(this,o)}catch(c){r(c)}return a}return i(t,"fn"),Object.setPrototypeOf(t,Object.getPrototypeOf(e)),Di&&Object.defineProperty(t,Di,{value:t,enumerable:!1,writable:!1,configurable:!0}),Object.defineProperties(t,iJ(e))}var iJ,sJ,rf,Ly,Di,To=g(()=>{d();co();UO();iJ=Object.getOwnPropertyDescriptors||i(function(t){for(var n=Object.keys(t),r={},a=0;a<n.length;a++)r[n[a]]=Object.getOwnPropertyDescriptor(t,n[a]);return r},"getOwnPropertyDescriptors"),sJ=/%[sdj%]/g;i(cJ,"format");i(qy,"deprecate");rf={};i(jO,"debuglog");i(Eo,"inspect");Eo.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[33,39]};
Eo.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"};i(lJ,"stylizeWithColor");i(uJ,"stylizeNoColor");i(dJ,"arrayToHash");i(af,"formatValue");i(mJ,"formatPrimitive");i(Fy,"formatError");i(pJ,"formatArray");i(Hy,"formatProperty");i(fJ,"reduceToSingleString");i(hJ,"isArray");i(HO,"isBoolean");i(zy,"isNull");i(gJ,"isNumber");i(Gy,"isString");i(wo,"isUndefined");i(Uy,"isRegExp");i(ql,"isObject");i(BO,"isDate");i(By,"isError");i(jy,"isFunction");i(Wy,"objectToString");i(yJ,"_extend");i(qO,"hasOwnProperty");Di=typeof Symbol<"u"?Symbol("util.promisify.custom"):void 0;i(vJ,"promisify");vJ.custom=Di});function Ai(){this.head=null,this.tail=null,this.length=0}var zO,GO=g(()=>{d();Tl();zO=Ai;i(Ai,"BufferList");Ai.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length};Ai.prototype.unshift=function(e){var t={data:e,next:this.head};this.length===0&&(this.tail=t),this.head=t,++this.length};Ai.prototype.shift=function(){if(this.length!==0){var e=this.head.data;return this.length===1?this.head=this.tail=null:this.head=this.head.next,--this.length,e}};Ai.prototype.clear=function(){this.head=this.tail=null,this.length=0};Ai.prototype.join=function(e){if(this.length===0)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n};Ai.prototype.concat=function(e){if(this.length===0)return H.alloc(0);if(this.length===1)return this.head.data;for(var t=H.allocUnsafe(e>>>0),n=this.head,r=0;n;)n.data.copy(t,r),r+=n.data.length,n=n.next;return t}});function wJ(e){if(e&&!bJ(e))throw new Error("Unknown encoding: "+e)}function Us(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),wJ(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=TJ;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=xJ;break;default:this.write=EJ;return}this.charBuffer=new H(6),this.charReceived=0,this.charLength=0}function EJ(e){return e.toString(this.encoding)}function TJ(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function xJ(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}var bJ,WO=g(()=>{d();Tl();bJ=H.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};i(wJ,"assertEncoding");i(Us,"StringDecoder");Us.prototype.write=function(e){for(var t="";this.charLength;){
var n=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,n),this.charReceived+=n,this.charReceived<this.charLength)return"";e=e.slice(n,e.length),t=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var a=t.charCodeAt(t.length-1);if(a>=55296&&a<=56319){this.charLength+=this.surrogateSize,t="";continue}if(this.charReceived=this.charLength=0,e.length===0)return t;break}this.detectIncompleteChar(e);var r=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,r),r-=this.charReceived),t+=e.toString(this.encoding,0,r);var r=t.length-1,a=t.charCodeAt(r);if(a>=55296&&a<=56319){var o=this.surrogateSize;return this.charLength+=o,this.charReceived+=o,this.charBuffer.copy(this.charBuffer,o,0,o),e.copy(this.charBuffer,0,0,o),t.substring(0,r)}return t};Us.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var n=e[e.length-t];if(t==1&&n>>5==6){this.
charLength=2;break}if(t<=2&&n>>4==14){this.charLength=3;break}if(t<=3&&n>>3==30){this.charLength=4;break}}this.charReceived=t};Us.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var n=this.charReceived,r=this.charBuffer,a=this.encoding;t+=r.slice(0,n).toString(a)}return t};i(EJ,"passThroughWrite");i(TJ,"utf16DetectIncompleteChar");i(xJ,"base64DetectIncompleteChar")});function SJ(e,t,n){if(typeof e.prependListener=="function")return e.prependListener(t,n);!e._events||!e._events[t]?e.on(t,n):Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]}function CJ(e,t){return e.listeners(t).length}function KO(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof Rn&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.buffer=new zO,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new Us(e.encoding),this.encoding=e.encoding)}function Nt(e){if(!(this instanceof Nt))return new Nt(
e);this._readableState=new KO(e,this),this.readable=!0,e&&typeof e.read=="function"&&(this._read=e.read),fr.call(this)}function XO(e,t,n,r,a){var o=_J(t,n);if(o)e.emit("error",o);else if(n===null)t.reading=!1,IJ(e,t);else if(t.objectMode||n&&n.length>0)if(t.ended&&!a){var s=new Error("stream.push() after EOF");e.emit("error",s)}else if(t.endEmitted&&a){var c=new Error("stream.unshift() after end event");e.emit("error",c)}else{var l;t.decoder&&!a&&!r&&(n=t.decoder.write(n),l=!t.objectMode&&n.length===0),a||(t.reading=!1),l||(t.flowing&&t.length===0&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,a?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&of(e))),DJ(e,t)}else a||(t.reading=!1);return kJ(t)}function kJ(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||e.length===0)}function RJ(e){return e>=VO?e=VO:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function $O(e,t){return e<=0||t.length===0&&t.ended?0:t.objectMode?1:e!==e?t.flowing&&t.
length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=RJ(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function _J(e,t){var n=null;return!Buffer.isBuffer(t)&&typeof t!="string"&&t!==null&&t!==void 0&&!e.objectMode&&(n=new TypeError("Invalid non-string/buffer chunk")),n}function IJ(e,t){if(!t.ended){if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,of(e)}}function of(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(yt("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?xn(YO,e):YO(e))}function YO(e){yt("emit readable"),e.emit("readable"),$y(e)}function DJ(e,t){t.readingMore||(t.readingMore=!0,xn(AJ,e,t))}function AJ(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(yt("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}function NJ(e){return function(){var t=e._readableState;yt("pipeOnDrain",t.awaitDrain),t.awaitDrain&&
t.awaitDrain--,t.awaitDrain===0&&e.listeners("data").length&&(t.flowing=!0,$y(e))}}function MJ(e){yt("readable nexttick read 0"),e.read(0)}function OJ(e,t){t.resumeScheduled||(t.resumeScheduled=!0,xn(PJ,e,t))}function PJ(e,t){t.reading||(yt("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),$y(e),t.flowing&&!t.reading&&e.read(0)}function $y(e){var t=e._readableState;for(yt("flow",t.flowing);t.flowing&&e.read()!==null;);}function JO(e,t){if(t.length===0)return null;var n;return t.objectMode?n=t.buffer.shift():!e||e>=t.length?(t.decoder?n=t.buffer.join(""):t.buffer.length===1?n=t.buffer.head.data:n=t.buffer.concat(t.length),t.buffer.clear()):n=LJ(e,t.buffer,t.decoder),n}function LJ(e,t,n){var r;return e<t.head.data.length?(r=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):e===t.head.data.length?r=t.shift():r=n?FJ(e,t):UJ(e,t),r}function FJ(e,t){var n=t.head,r=1,a=n.data;for(e-=a.length;n=n.next;){var o=n.data,s=e>o.length?o.length:e;if(s===o.length?
a+=o:a+=o.slice(0,e),e-=s,e===0){s===o.length?(++r,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=o.slice(s));break}++r}return t.length-=r,a}function UJ(e,t){var n=Buffer.allocUnsafe(e),r=t.head,a=1;for(r.data.copy(n),e-=r.data.length;r=r.next;){var o=r.data,s=e>o.length?o.length:e;if(o.copy(n,n.length-e,0,s),e-=s,e===0){s===o.length?(++a,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=o.slice(s));break}++a}return t.length-=a,n}function Vy(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,xn(BJ,t,e))}function BJ(e,t){!e.endEmitted&&e.length===0&&(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function jJ(e,t){for(var n=0,r=e.length;n<r;n++)t(e[n],n)}function ZO(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}var yt,VO,Yy=g(()=>{"use strict";d();Ta();To();GO();WO();zl();co();Nt.ReadableState=KO;yt=jO("stream");Ht(Nt,fr);i(SJ,"prependListener");i(CJ,"listenerCount");i(KO,"Re\
adableState");i(Nt,"Readable");Nt.prototype.push=function(e,t){var n=this._readableState;return!n.objectMode&&typeof e=="string"&&(t=t||n.defaultEncoding,t!==n.encoding&&(e=Buffer.from(e,t),t="")),XO(this,n,e,t,!1)};Nt.prototype.unshift=function(e){var t=this._readableState;return XO(this,t,e,"",!0)};Nt.prototype.isPaused=function(){return this._readableState.flowing===!1};i(XO,"readableAddChunk");i(kJ,"needMoreData");Nt.prototype.setEncoding=function(e){return this._readableState.decoder=new Us(e),this._readableState.encoding=e,this};VO=8388608;i(RJ,"computeNewHighWaterMark");i($O,"howMuchToRead");Nt.prototype.read=function(e){yt("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(e!==0&&(t.emittedReadable=!1),e===0&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return yt("read: emitReadable",t.length,t.ended),t.length===0&&t.ended?Vy(this):of(this),null;if(e=$O(e,t),e===0&&t.ended)return t.length===0&&Vy(this),null;var r=t.needReadable;yt("need readable",r),(t.length===
0||t.length-e<t.highWaterMark)&&(r=!0,yt("length less than watermark",r)),t.ended||t.reading?(r=!1,yt("reading or ended",r)):r&&(yt("do read"),t.reading=!0,t.sync=!0,t.length===0&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=$O(n,t)));var a;return e>0?a=JO(e,t):a=null,a===null?(t.needReadable=!0,e=0):t.length-=e,t.length===0&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&Vy(this)),a!==null&&this.emit("data",a),a};i(_J,"chunkInvalid");i(IJ,"onEofChunk");i(of,"emitReadable");i(YO,"emitReadable_");i(DJ,"maybeReadMore");i(AJ,"maybeReadMore_");Nt.prototype._read=function(e){this.emit("error",new Error("not implemented"))};Nt.prototype.pipe=function(e,t){var n=this,r=this._readableState;switch(r.pipesCount){case 0:r.pipes=e;break;case 1:r.pipes=[r.pipes,e];break;default:r.pipes.push(e);break}r.pipesCount+=1,yt("pipe count=%d opts=%j",r.pipesCount,t);var a=!t||t.end!==!1,o=a?c:m;r.endEmitted?xn(o):n.once("end",o),e.on("unpipe",s);function s(C){yt("onunpipe"),C===n&&
m()}i(s,"onunpipe");function c(){yt("onend"),e.end()}i(c,"onend");var l=NJ(n);e.on("drain",l);var u=!1;function m(){yt("cleanup"),e.removeListener("close",y),e.removeListener("finish",b),e.removeListener("drain",l),e.removeListener("error",h),e.removeListener("unpipe",s),n.removeListener("end",c),n.removeListener("end",m),n.removeListener("data",f),u=!0,r.awaitDrain&&(!e._writableState||e._writableState.needDrain)&&l()}i(m,"cleanup");var p=!1;n.on("data",f);function f(C){yt("ondata"),p=!1;var k=e.write(C);k===!1&&!p&&((r.pipesCount===1&&r.pipes===e||r.pipesCount>1&&ZO(r.pipes,e)!==-1)&&!u&&(yt("false write response, pause",n._readableState.awaitDrain),n._readableState.awaitDrain++,p=!0),n.pause())}i(f,"ondata");function h(C){yt("onerror",C),w(),e.removeListener("error",h),CJ(e,"error")===0&&e.emit("error",C)}i(h,"onerror"),SJ(e,"error",h);function y(){e.removeListener("finish",b),w()}i(y,"onclose"),e.once("close",y);function b(){yt("onfinish"),e.removeListener("close",y),w()}i(b,"onfin\
ish"),e.once("finish",b);function w(){yt("unpipe"),n.unpipe(e)}return i(w,"unpipe"),e.emit("pipe",n),r.flowing||(yt("pipe resume"),n.resume()),e};i(NJ,"pipeOnDrain");Nt.prototype.unpipe=function(e){var t=this._readableState;if(t.pipesCount===0)return this;if(t.pipesCount===1)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var n=t.pipes,r=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var a=0;a<r;a++)n[a].emit("unpipe",this);return this}var o=ZO(t.pipes,e);return o===-1?this:(t.pipes.splice(o,1),t.pipesCount-=1,t.pipesCount===1&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)};Nt.prototype.on=function(e,t){var n=fr.prototype.on.call(this,e,t);if(e==="data")this._readableState.flowing!==!1&&this.resume();else if(e==="readable"){var r=this._readableState;!r.endEmitted&&!r.readableListening&&(r.readableListening=r.needReadable=!0,r.emittedReadable=!1,r.reading?r.length&&of(this,r):xn(MJ,this))}return n};Nt.
prototype.addListener=Nt.prototype.on;i(MJ,"nReadingNextTick");Nt.prototype.resume=function(){var e=this._readableState;return e.flowing||(yt("resume"),e.flowing=!0,OJ(this,e)),this};i(OJ,"resume");i(PJ,"resume_");Nt.prototype.pause=function(){return yt("call pause flowing=%j",this._readableState.flowing),this._readableState.flowing!==!1&&(yt("pause"),this._readableState.flowing=!1,this.emit("pause")),this};i($y,"flow");Nt.prototype.wrap=function(e){var t=this._readableState,n=!1,r=this;e.on("end",function(){if(yt("wrapped end"),t.decoder&&!t.ended){var s=t.decoder.end();s&&s.length&&r.push(s)}r.push(null)}),e.on("data",function(s){if(yt("wrapped data"),t.decoder&&(s=t.decoder.write(s)),!(t.objectMode&&s==null)&&!(!t.objectMode&&(!s||!s.length))){var c=r.push(s);c||(n=!0,e.pause())}});for(var a in e)this[a]===void 0&&typeof e[a]=="function"&&(this[a]=(function(s){return function(){return e[s].apply(e,arguments)}})(a));var o=["error","close","destroy","pause","resume"];return jJ(o,function(s){
e.on(s,r.emit.bind(r,s))}),r._read=function(s){yt("wrapped _read",s),n&&(n=!1,e.resume())},r};Nt._fromList=JO;i(JO,"fromList");i(LJ,"fromListPartial");i(FJ,"copyFromBufferString");i(UJ,"copyFromBuffer");i(Vy,"endReadable");i(BJ,"endReadableNT");i(jJ,"forEach");i(ZO,"indexOf")});function HJ(){}function qJ(e,t,n){this.chunk=e,this.encoding=t,this.callback=n,this.next=null}function Xy(e,t){Object.defineProperty(this,"buffer",{get:qy(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof Rn&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var a=e.decodeStrings===!1;this.decodeStrings=!a,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(o){KJ(t,o)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new aP(this)}function cn(e){
if(!(this instanceof cn)&&!(this instanceof Rn))return new cn(e);this._writableState=new Xy(e,this),this.writable=!0,e&&(typeof e.write=="function"&&(this._write=e.write),typeof e.writev=="function"&&(this._writev=e.writev)),Ye.call(this)}function zJ(e,t){var n=new Error("write after end");e.emit("error",n),xn(t,n)}function GJ(e,t,n,r){var a=!0,o=!1;return n===null?o=new TypeError("May not write null values to stream"):!H.isBuffer(n)&&typeof n!="string"&&n!==void 0&&!t.objectMode&&(o=new TypeError("Invalid non-string/buffer chunk")),o&&(e.emit("error",o),xn(r,o),a=!1),a}function WJ(e,t,n){return!e.objectMode&&e.decodeStrings!==!1&&typeof t=="string"&&(t=H.from(t,n)),t}function VJ(e,t,n,r,a){n=WJ(t,n,r),H.isBuffer(n)&&(r="buffer");var o=t.objectMode?1:n.length;t.length+=o;var s=t.length<t.highWaterMark;if(s||(t.needDrain=!0),t.writing||t.corked){var c=t.lastBufferedRequest;t.lastBufferedRequest=new qJ(n,r,a),c?c.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,t.bufferedRequestCount+=
1}else Ky(e,t,!1,o,n,r,a);return s}function Ky(e,t,n,r,a,o,s){t.writelen=r,t.writecb=s,t.writing=!0,t.sync=!0,n?e._writev(a,t.onwrite):e._write(a,o,t.onwrite),t.sync=!1}function $J(e,t,n,r,a){--t.pendingcb,n?xn(a,r):a(r),e._writableState.errorEmitted=!0,e.emit("error",r)}function YJ(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function KJ(e,t){var n=e._writableState,r=n.sync,a=n.writecb;if(YJ(n),t)$J(e,n,r,t,a);else{var o=nP(n);!o&&!n.corked&&!n.bufferProcessing&&n.bufferedRequest&&tP(e,n),r?xn(QO,e,n,o,a):QO(e,n,o,a)}}function QO(e,t,n,r){n||XJ(e,t),t.pendingcb--,r(),rP(e,t)}function XJ(e,t){t.length===0&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function tP(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var r=t.bufferedRequestCount,a=new Array(r),o=t.corkedRequestsFree;o.entry=n;for(var s=0;n;)a[s]=n,n=n.next,s+=1;Ky(e,t,!0,t.length,a,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=o.next,o.next=null):
t.corkedRequestsFree=new aP(t)}else{for(;n;){var c=n.chunk,l=n.encoding,u=n.callback,m=t.objectMode?1:c.length;if(Ky(e,t,!1,m,c,l,u),n=n.next,t.writing)break}n===null&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function nP(e){return e.ending&&e.length===0&&e.bufferedRequest===null&&!e.finished&&!e.writing}function eP(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function rP(e,t){var n=nP(t);return n&&(t.pendingcb===0?(eP(e,t),t.finished=!0,e.emit("finish")):eP(e,t)),n}function JJ(e,t,n){t.ending=!0,rP(e,t),n&&(t.finished?xn(n):e.once("finish",n)),t.ended=!0,e.writable=!1}function aP(e){var t=this;this.next=null,this.entry=null,this.finish=function(n){var r=t.entry;for(t.entry=null;r;){var a=r.callback;e.pendingcb--,a(n),r=r.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}var Jy=g(()=>{d();To();Tl();Ta();zl();co();cn.WritableState=Xy;Ht(cn,Ye);i(HJ,"nop");i(qJ,"WriteReq");i(Xy,"WritableState");
Xy.prototype.getBuffer=i(function(){for(var t=this.bufferedRequest,n=[];t;)n.push(t),t=t.next;return n},"writableStateGetBuffer");i(cn,"Writable");cn.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))};i(zJ,"writeAfterEnd");i(GJ,"validChunk");cn.prototype.write=function(e,t,n){var r=this._writableState,a=!1;return typeof t=="function"&&(n=t,t=null),H.isBuffer(e)?t="buffer":t||(t=r.defaultEncoding),typeof n!="function"&&(n=HJ),r.ended?zJ(this,n):GJ(this,r,e,n)&&(r.pendingcb++,a=VJ(this,r,e,t,n)),a};cn.prototype.cork=function(){var e=this._writableState;e.corked++};cn.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,!e.writing&&!e.corked&&!e.finished&&!e.bufferProcessing&&e.bufferedRequest&&tP(this,e))};cn.prototype.setDefaultEncoding=i(function(t){if(typeof t=="string"&&(t=t.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((t+"").toLowerCase())>-1))throw new TypeError(
"Unknown encoding: "+t);return this._writableState.defaultEncoding=t,this},"setDefaultEncoding");i(WJ,"decodeChunk");i(VJ,"writeOrBuffer");i(Ky,"doWrite");i($J,"onwriteError");i(YJ,"onwriteStateUpdate");i(KJ,"onwrite");i(QO,"afterWrite");i(XJ,"onwriteDrain");i(tP,"clearBuffer");cn.prototype._write=function(e,t,n){n(new Error("not implemented"))};cn.prototype._writev=null;cn.prototype.end=function(e,t,n){var r=this._writableState;typeof e=="function"?(n=e,e=null,t=null):typeof t=="function"&&(n=t,t=null),e!=null&&this.write(e,t),r.corked&&(r.corked=1,this.uncork()),!r.ending&&!r.finished&&JJ(this,r,n)};i(nP,"needFinish");i(eP,"prefinish");i(rP,"finishMaybe");i(JJ,"endWritable");i(aP,"CorkedRequest")});function Rn(e){if(!(this instanceof Rn))return new Rn(e);Nt.call(this,e),cn.call(this,e),e&&e.readable===!1&&(this.readable=!1),e&&e.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,e&&e.allowHalfOpen===!1&&(this.allowHalfOpen=!1),this.once("end",ZJ)}function ZJ(){this.allowHalfOpen||this._writableState.ended||xn(QJ,this)}function QJ(e){e.end()}var oP,cf,sf,zl=g(()=>{d();To();co();Yy();Jy();Ht(Rn,Nt);oP=Object.keys(cn.prototype);for(sf=0;sf<oP.length;sf++)cf=oP[sf],Rn.prototype[cf]||(Rn.prototype[cf]=cn.prototype[cf]);i(Rn,"Duplex");i(ZJ,"onend");i(QJ,"onEndNT")});function eZ(e){this.afterTransform=function(t,n){return tZ(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function tZ(e,t,n){var r=e._transformState;r.transforming=!1;var a=r.writecb;if(!a)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,n!=null&&e.push(n),a(t);var o=e._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&e._read(o.highWaterMark)}function Fn(e){if(!(this instanceof Fn))return new Fn(e);Rn.call(this,e),this._transformState=new eZ(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&(typeof e.transform=="function"&&(this._transform=e.transform),typeof e.flush=="function"&&(this._flush=e.flush)),this.once("prefinish",function(){typeof this._flush=="function"?this._flush(function(n){iP(t,n)}):iP(t)})}function iP(e,t){if(t)return e.emit("error",t);var n=e._writableState,r=e._transformState;if(n.length)throw new Error(
"Calling transform done when ws.length != 0");if(r.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}var Zy=g(()=>{d();zl();To();Ht(Fn,Rn);i(eZ,"TransformState");i(tZ,"afterTransform");i(Fn,"Transform");Fn.prototype.push=function(e,t){return this._transformState.needTransform=!1,Rn.prototype.push.call(this,e,t)};Fn.prototype._transform=function(e,t,n){throw new Error("Not implemented")};Fn.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var a=this._readableState;(r.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}};Fn.prototype._read=function(e){var t=this._transformState;t.writechunk!==null&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0};i(iP,"done")});function Bs(e){if(!(this instanceof Bs))return new Bs(e);Fn.call(this,e)}var sP=g(()=>{d();Zy();To();Ht(Bs,Fn);i(Bs,"PassThrough");Bs.prototype._transform=function(e,t,n){n(null,e)}});function ea(){fr.call(this)}var Qy,ev=g(()=>{d();Ta();To();zl();Yy();Jy();Zy();sP();Ht(ea,fr);ea.Readable=Nt;ea.Writable=cn;ea.Duplex=Rn;ea.Transform=Fn;ea.PassThrough=Bs;ea.Stream=ea;Qy=ea;i(ea,"Stream");ea.prototype.pipe=function(e,t){var n=this;function r(m){e.writable&&e.write(m)===!1&&n.pause&&n.pause()}i(r,"ondata"),n.on("data",r);function a(){n.readable&&n.resume&&n.resume()}i(a,"ondrain"),e.on("drain",a),!e._isStdio&&(!t||t.end!==!1)&&(n.on("end",s),n.on("close",c));var o=!1;function s(){o||(o=!0,e.end())}i(s,"onend");function c(){o||(o=!0,typeof e.destroy=="function"&&e.destroy())}i(c,"onclose");function l(m){if(u(),fr.listenerCount(this,"error")===0)throw m}i(l,"onerror"),n.on("error",l),e.on("error",l);function u(){n.removeListener("data",r),e.removeListener("drain",a),n.removeListener("end",s),n.removeListener("close",c),n.removeListener("error",l),e.removeListener("error",l),n.removeListener("end",u),n.removeListener("close",u),e.removeListener("close",u)}return i(u,"clean\
up"),n.on("end",u),n.on("close",u),e.on("close",u),e.emit("pipe",n),e}});var lf,tv=g(()=>{d();lf={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}});function nZ(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}var cP,lP=g(()=>{d();i(nZ,"ZStream");cP=nZ});function js(e,t,n,r,a){if(t.subarray&&e.subarray){e.set(t.subarray(n,n+r),a);return}for(var o=0;o<r;o++)e[a+o]=t[n+o]}var nv,Da,rv=g(()=>{"use strict";d();i(js,"arraySet");nv=Uint8Array,Da=Uint16Array});function qs(e){for(var t=e.length;--t>=0;)e[t]=0}function ov(e,t,n,r,a){this.static_tree=e,this.extra_bits=t,this.extra_base=n,this.elems=r,this.max_length=a,this.has_stree=e&&e.length}function iv(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function kP(e){return e<256?Vl[e]:Vl[256+(e>>>7)]}function Yl(e,t){e.pending_buf[e.pending++]=t&255,e.pending_buf[e.pending++]=t>>>8&255}function $n(e,t,n){e.bi_valid>av-n?(e.bi_buf|=t<<e.bi_valid&65535,Yl(e,e.bi_buf),e.bi_buf=t>>av-e.bi_valid,e.bi_valid+=n-av):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=n)}function ta(e,t,n){$n(e,n[t*2],n[t*2+1])}function RP(e,t){var n=0;do n|=e&1,e>>>=1,n<<=1;while(--t>0);return n>>>1}function mZ(e){e.bi_valid===16?(Yl(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):e.bi_valid>=8&&(e.pending_buf[e.pending++]=e.bi_buf&255,e.bi_buf>>=8,e.bi_valid-=8)}function pZ(e,t){var n=t.dyn_tree,r=t.max_code,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,s=t.stat_desc.extra_bits,c=t.stat_desc.extra_base,l=t.stat_desc.max_length,
u,m,p,f,h,y,b=0;for(f=0;f<=Ni;f++)e.bl_count[f]=0;for(n[e.heap[e.heap_max]*2+1]=0,u=e.heap_max+1;u<vP;u++)m=e.heap[u],f=n[n[m*2+1]*2+1]+1,f>l&&(f=l,b++),n[m*2+1]=f,!(m>r)&&(e.bl_count[f]++,h=0,m>=c&&(h=s[m-c]),y=n[m*2],e.opt_len+=y*(f+h),o&&(e.static_len+=y*(a[m*2+1]+h)));if(b!==0){do{for(f=l-1;e.bl_count[f]===0;)f--;e.bl_count[f]--,e.bl_count[f+1]+=2,e.bl_count[l]--,b-=2}while(b>0);for(f=l;f!==0;f--)for(m=e.bl_count[f];m!==0;)p=e.heap[--u],!(p>r)&&(n[p*2+1]!==f&&(e.opt_len+=(f-n[p*2+1])*n[p*2],n[p*2+1]=f),m--)}}function _P(e,t,n){var r=new Array(Ni+1),a=0,o,s;for(o=1;o<=Ni;o++)r[o]=a=a+n[o-1]<<1;for(s=0;s<=t;s++){var c=e[s*2+1];c!==0&&(e[s*2]=RP(r[c]++,c))}}function fZ(){var e,t,n,r,a,o=new Array(Ni+1);for(n=0,r=0;r<uv-1;r++)for(pv[r]=n,e=0;e<1<<cv[r];e++)$l[n++]=r;for($l[n-1]=r,a=0,r=0;r<16;r++)for(df[r]=a,e=0;e<1<<uf[r];e++)Vl[a++]=r;for(a>>=7;r<Hs;r++)for(df[r]=a<<7,e=0;e<1<<uf[r]-7;e++)Vl[256+a++]=r;for(t=0;t<=Ni;t++)o[t]=0;for(e=0;e<=143;)Aa[e*2+1]=8,e++,o[8]++;for(;e<=255;)Aa[e*
2+1]=9,e++,o[9]++;for(;e<=279;)Aa[e*2+1]=7,e++,o[7]++;for(;e<=287;)Aa[e*2+1]=8,e++,o[8]++;for(_P(Aa,Wl+1,o),e=0;e<Hs;e++)Gl[e*2+1]=5,Gl[e*2]=RP(e,5);xP=new ov(Aa,cv,Kl+1,Wl,Ni),SP=new ov(Gl,uf,0,Hs,Ni),CP=new ov(new Array(0),uZ,0,dv,lZ)}function IP(e){var t;for(t=0;t<Wl;t++)e.dyn_ltree[t*2]=0;for(t=0;t<Hs;t++)e.dyn_dtree[t*2]=0;for(t=0;t<dv;t++)e.bl_tree[t*2]=0;e.dyn_ltree[mv*2]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function DP(e){e.bi_valid>8?Yl(e,e.bi_buf):e.bi_valid>0&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function hZ(e,t,n,r){DP(e),r&&(Yl(e,n),Yl(e,~n)),js(e.pending_buf,e.window,t,n,e.pending),e.pending+=n}function mP(e,t,n,r){var a=t*2,o=n*2;return e[a]<e[o]||e[a]===e[o]&&r[t]<=r[n]}function sv(e,t,n){for(var r=e.heap[n],a=n<<1;a<=e.heap_len&&(a<e.heap_len&&mP(t,e.heap[a+1],e.heap[a],e.depth)&&a++,!mP(t,r,e.heap[a],e.depth));)e.heap[n]=e.heap[a],n=a,a<<=1;e.heap[n]=r}function pP(e,t,n){var r,a,o=0,s,c;if(e.last_lit!==0)do r=e.pending_buf[e.d_buf+
o*2]<<8|e.pending_buf[e.d_buf+o*2+1],a=e.pending_buf[e.l_buf+o],o++,r===0?ta(e,a,t):(s=$l[a],ta(e,s+Kl+1,t),c=cv[s],c!==0&&(a-=pv[s],$n(e,a,c)),r--,s=kP(r),ta(e,s,n),c=uf[s],c!==0&&(r-=df[s],$n(e,r,c)));while(o<e.last_lit);ta(e,mv,t)}function lv(e,t){var n=t.dyn_tree,r=t.stat_desc.static_tree,a=t.stat_desc.has_stree,o=t.stat_desc.elems,s,c,l=-1,u;for(e.heap_len=0,e.heap_max=vP,s=0;s<o;s++)n[s*2]!==0?(e.heap[++e.heap_len]=l=s,e.depth[s]=0):n[s*2+1]=0;for(;e.heap_len<2;)u=e.heap[++e.heap_len]=l<2?++l:0,n[u*2]=1,e.depth[u]=0,e.opt_len--,a&&(e.static_len-=r[u*2+1]);for(t.max_code=l,s=e.heap_len>>1;s>=1;s--)sv(e,n,s);u=o;do s=e.heap[1],e.heap[1]=e.heap[e.heap_len--],sv(e,n,1),c=e.heap[1],e.heap[--e.heap_max]=s,e.heap[--e.heap_max]=c,n[u*2]=n[s*2]+n[c*2],e.depth[u]=(e.depth[s]>=e.depth[c]?e.depth[s]:e.depth[c])+1,n[s*2+1]=n[c*2+1]=u,e.heap[1]=u++,sv(e,n,1);while(e.heap_len>=2);e.heap[--e.heap_max]=e.heap[1],pZ(e,t),_P(n,l,e.bl_count)}function fP(e,t,n){var r,a=-1,o,s=t[1],c=0,l=7,u=4;for(s===
0&&(l=138,u=3),t[(n+1)*2+1]=65535,r=0;r<=n;r++)o=s,s=t[(r+1)*2+1],!(++c<l&&o===s)&&(c<u?e.bl_tree[o*2]+=c:o!==0?(o!==a&&e.bl_tree[o*2]++,e.bl_tree[bP*2]++):c<=10?e.bl_tree[wP*2]++:e.bl_tree[EP*2]++,c=0,a=o,s===0?(l=138,u=3):o===s?(l=6,u=3):(l=7,u=4))}function hP(e,t,n){var r,a=-1,o,s=t[1],c=0,l=7,u=4;for(s===0&&(l=138,u=3),r=0;r<=n;r++)if(o=s,s=t[(r+1)*2+1],!(++c<l&&o===s)){if(c<u)do ta(e,o,e.bl_tree);while(--c!==0);else o!==0?(o!==a&&(ta(e,o,e.bl_tree),c--),ta(e,bP,e.bl_tree),$n(e,c-3,2)):c<=10?(ta(e,wP,e.bl_tree),$n(e,c-3,3)):(ta(e,EP,e.bl_tree),$n(e,c-11,7));c=0,a=o,s===0?(l=138,u=3):o===s?(l=6,u=3):(l=7,u=4)}}function gZ(e){var t;for(fP(e,e.dyn_ltree,e.l_desc.max_code),fP(e,e.dyn_dtree,e.d_desc.max_code),lv(e,e.bl_desc),t=dv-1;t>=3&&e.bl_tree[TP[t]*2+1]===0;t--);return e.opt_len+=3*(t+1)+5+5+4,t}function yZ(e,t,n,r){var a;for($n(e,t-257,5),$n(e,n-1,5),$n(e,r-4,4),a=0;a<r;a++)$n(e,e.bl_tree[TP[a]*2+1],3);hP(e,e.dyn_ltree,t-1),hP(e,e.dyn_dtree,n-1)}function vZ(e){var t=4093624447,n;for(n=
0;n<=31;n++,t>>>=1)if(t&1&&e.dyn_ltree[n*2]!==0)return uP;if(e.dyn_ltree[18]!==0||e.dyn_ltree[20]!==0||e.dyn_ltree[26]!==0)return dP;for(n=32;n<Kl;n++)if(e.dyn_ltree[n*2]!==0)return dP;return uP}function AP(e){gP||(fZ(),gP=!0),e.l_desc=new iv(e.dyn_ltree,xP),e.d_desc=new iv(e.dyn_dtree,SP),e.bl_desc=new iv(e.bl_tree,CP),e.bi_buf=0,e.bi_valid=0,IP(e)}function fv(e,t,n,r){$n(e,(oZ<<1)+(r?1:0),3),hZ(e,t,n,!0)}function NP(e){$n(e,yP<<1,3),ta(e,mv,Aa),mZ(e)}function MP(e,t,n,r){var a,o,s=0;e.level>0?(e.strm.data_type===aZ&&(e.strm.data_type=vZ(e)),lv(e,e.l_desc),lv(e,e.d_desc),s=gZ(e),a=e.opt_len+3+7>>>3,o=e.static_len+3+7>>>3,o<=a&&(a=o)):a=o=n+5,n+4<=a&&t!==-1?fv(e,t,n,r):e.strategy===rZ||o===a?($n(e,(yP<<1)+(r?1:0),3),pP(e,Aa,Gl)):($n(e,(iZ<<1)+(r?1:0),3),yZ(e,e.l_desc.max_code+1,e.d_desc.max_code+1,s+1),pP(e,e.dyn_ltree,e.dyn_dtree)),IP(e),r&&DP(e)}function Na(e,t,n){return e.pending_buf[e.d_buf+e.last_lit*2]=t>>>8&255,e.pending_buf[e.d_buf+e.last_lit*2+1]=t&255,e.pending_buf[e.l_buf+e.
last_lit]=n&255,e.last_lit++,t===0?e.dyn_ltree[n*2]++:(e.matches++,t--,e.dyn_ltree[($l[n]+Kl+1)*2]++,e.dyn_dtree[kP(t)*2]++),e.last_lit===e.lit_bufsize-1}var rZ,uP,dP,aZ,oZ,yP,iZ,sZ,cZ,uv,Kl,Wl,Hs,dv,vP,Ni,av,lZ,mv,bP,wP,EP,cv,uf,uZ,TP,dZ,Aa,Gl,Vl,$l,pv,df,xP,SP,CP,gP,OP=g(()=>{"use strict";d();rv();rZ=4,uP=0,dP=1,aZ=2;i(qs,"zero");oZ=0,yP=1,iZ=2,sZ=3,cZ=258,uv=29,Kl=256,Wl=Kl+1+uv,Hs=30,dv=19,vP=2*Wl+1,Ni=15,av=16,lZ=7,mv=256,bP=16,wP=17,EP=18,cv=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],uf=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],uZ=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],TP=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],dZ=512,Aa=new Array((Wl+2)*2);qs(Aa);Gl=new Array(Hs*2);qs(Gl);Vl=new Array(dZ);qs(Vl);$l=new Array(cZ-sZ+1);qs($l);pv=new Array(uv);qs(pv);df=new Array(Hs);qs(df);i(ov,"StaticTreeDesc");i(iv,"TreeDesc");i(kP,"d_code");i(Yl,"put_short");i($n,"send_bits");i(ta,"send_code");i(RP,"bi_reverse");i(mZ,"bi_flush");i(pZ,"gen_b\
itlen");i(_P,"gen_codes");i(fZ,"tr_static_init");i(IP,"init_block");i(DP,"bi_windup");i(hZ,"copy_block");i(mP,"smaller");i(sv,"pqdownheap");i(pP,"compress_block");i(lv,"build_tree");i(fP,"scan_tree");i(hP,"send_tree");i(gZ,"build_bl_tree");i(yZ,"send_all_trees");i(vZ,"detect_data_type");gP=!1;i(AP,"_tr_init");i(fv,"_tr_stored_block");i(NP,"_tr_align");i(MP,"_tr_flush_block");i(Na,"_tr_tally")});function bZ(e,t,n,r){for(var a=e&65535|0,o=e>>>16&65535|0,s=0;n!==0;){s=n>2e3?2e3:n,n-=s;do a=a+t[r++]|0,o=o+a|0;while(--s);a%=65521,o%=65521}return a|o<<16|0}var PP,LP=g(()=>{d();i(bZ,"adler32");PP=bZ});function wZ(){for(var e,t=[],n=0;n<256;n++){e=n;for(var r=0;r<8;r++)e=e&1?3988292384^e>>>1:e>>>1;t[n]=e}return t}function TZ(e,t,n,r){var a=EZ,o=r+n;e^=-1;for(var s=r;s<o;s++)e=e>>>8^a[(e^t[s])&255];return e^-1}var EZ,Ma,FP=g(()=>{d();i(wZ,"makeTable");EZ=wZ();i(TZ,"crc32");Ma=TZ});function ko(e,t){return e.msg=lf[t],t}function jP(e){return(e<<1)-(e>4?9:0)}function Mi(e){for(var t=e.length;--t>=0;)e[t]=0}function xo(e){var t=e.state,n=t.pending;n>e.avail_out&&(n=e.avail_out),n!==0&&(js(e.output,t.pending_buf,t.pending_out,n,e.next_out),e.next_out+=n,t.pending_out+=n,e.total_out+=n,e.avail_out-=n,t.pending-=n,t.pending===0&&(t.pending_out=0))}function hn(e,t){MP(e,e.block_start>=0?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,xo(e.strm)}function st(e,t){e.pending_buf[e.pending++]=t}function Xl(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=t&255}function jZ(e,t,n,r){var a=e.avail_in;return a>r&&(a=r),a===0?0:(e.avail_in-=a,js(t,e.input,e.next_in,a,n),e.state.wrap===1?e.adler=PP(e.adler,t,a,n):e.state.wrap===2&&(e.adler=Ma(e.adler,t,a,n)),e.next_in+=a,e.total_in+=a,a)}function HP(e,t){var n=e.max_chain_length,r=e.strstart,a,o,s=e.prev_length,c=e.nice_match,l=e.strstart>e.w_size-Br?e.strstart-(e.w_size-Br):0,u=e.window,m=e.
w_mask,p=e.prev,f=e.strstart+Co,h=u[r+s-1],y=u[r+s];e.prev_length>=e.good_match&&(n>>=2),c>e.lookahead&&(c=e.lookahead);do if(a=t,!(u[a+s]!==y||u[a+s-1]!==h||u[a]!==u[r]||u[++a]!==u[r+1])){r+=2,a++;do;while(u[++r]===u[++a]&&u[++r]===u[++a]&&u[++r]===u[++a]&&u[++r]===u[++a]&&u[++r]===u[++a]&&u[++r]===u[++a]&&u[++r]===u[++a]&&u[++r]===u[++a]&&r<f);if(o=Co-(f-r),r=f-Co,o>s){if(e.match_start=t,s=o,o>=c)break;h=u[r+s-1],y=u[r+s]}}while((t=p[t&m])>l&&--n!==0);return s<=e.lookahead?s:e.lookahead}function Ql(e){var t=e.w_size,n,r,a,o,s;do{if(o=e.window_size-e.lookahead-e.strstart,e.strstart>=t+(t-Br)){js(e.window,e.window,t,t,0),e.match_start-=t,e.strstart-=t,e.block_start-=t,r=e.hash_size,n=r;do a=e.head[--n],e.head[n]=a>=t?a-t:0;while(--r);r=t,n=r;do a=e.prev[--n],e.prev[n]=a>=t?a-t:0;while(--r);o+=t}if(e.strm.avail_in===0)break;if(r=jZ(e.strm,e.window,e.strstart+e.lookahead,o),e.lookahead+=r,e.lookahead+e.insert>=ft)for(s=e.strstart-e.insert,e.ins_h=e.window[s],e.ins_h=(e.ins_h<<e.hash_shift^
e.window[s+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[s+ft-1])&e.hash_mask,e.prev[s&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=s,s++,e.insert--,!(e.lookahead+e.insert<ft)););}while(e.lookahead<Br&&e.strm.avail_in!==0)}function HZ(e,t){var n=65535;for(n>e.pending_buf_size-5&&(n=e.pending_buf_size-5);;){if(e.lookahead<=1){if(Ql(e),e.lookahead===0&&t===Li)return en;if(e.lookahead===0)break}e.strstart+=e.lookahead,e.lookahead=0;var r=e.block_start+n;if((e.strstart===0||e.strstart>=r)&&(e.lookahead=e.strstart-r,e.strstart=r,hn(e,!1),e.strm.avail_out===0)||e.strstart-e.block_start>=e.w_size-Br&&(hn(e,!1),e.strm.avail_out===0))return en}return e.insert=0,t===Ro?(hn(e,!0),e.strm.avail_out===0?Pi:Ws):(e.strstart>e.block_start&&(hn(e,!1),e.strm.avail_out===0),en)}function gv(e,t){for(var n,r;;){if(e.lookahead<Br){if(Ql(e),e.lookahead<Br&&t===Li)return en;if(e.lookahead===0)break}if(n=0,e.lookahead>=ft&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+ft-1])&e.hash_mask,
n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),n!==0&&e.strstart-n<=e.w_size-Br&&(e.match_length=HP(e,n)),e.match_length>=ft)if(r=Na(e,e.strstart-e.match_start,e.match_length-ft),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=ft){e.match_length--;do e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+ft-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart;while(--e.match_length!==0);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else r=Na(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(r&&(hn(e,!1),e.strm.avail_out===0))return en}return e.insert=e.strstart<ft-1?e.strstart:ft-1,t===Ro?(hn(e,!0),e.strm.avail_out===0?Pi:Ws):e.last_lit&&(hn(e,!1),e.strm.avail_out===0)?en:Zl}function zs(e,t){for(var n,r,a;;){if(e.lookahead<Br){if(Ql(e),e.lookahead<Br&&t===Li)return en;if(e.
lookahead===0)break}if(n=0,e.lookahead>=ft&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+ft-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=ft-1,n!==0&&e.prev_length<e.max_lazy_match&&e.strstart-n<=e.w_size-Br&&(e.match_length=HP(e,n),e.match_length<=5&&(e.strategy===RZ||e.match_length===ft&&e.strstart-e.match_start>4096)&&(e.match_length=ft-1)),e.prev_length>=ft&&e.match_length<=e.prev_length){a=e.strstart+e.lookahead-ft,r=Na(e,e.strstart-1-e.prev_match,e.prev_length-ft),e.lookahead-=e.prev_length-1,e.prev_length-=2;do++e.strstart<=a&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+ft-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart);while(--e.prev_length!==0);if(e.match_available=0,e.match_length=ft-1,e.strstart++,r&&(hn(e,!1),e.strm.avail_out===0))return en}else if(e.match_available){if(r=Na(e,0,e.window[e.strstart-1]),r&&
hn(e,!1),e.strstart++,e.lookahead--,e.strm.avail_out===0)return en}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(r=Na(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<ft-1?e.strstart:ft-1,t===Ro?(hn(e,!0),e.strm.avail_out===0?Pi:Ws):e.last_lit&&(hn(e,!1),e.strm.avail_out===0)?en:Zl}function qZ(e,t){for(var n,r,a,o,s=e.window;;){if(e.lookahead<=Co){if(Ql(e),e.lookahead<=Co&&t===Li)return en;if(e.lookahead===0)break}if(e.match_length=0,e.lookahead>=ft&&e.strstart>0&&(a=e.strstart-1,r=s[a],r===s[++a]&&r===s[++a]&&r===s[++a])){o=e.strstart+Co;do;while(r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&a<o);e.match_length=Co-(o-a),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=ft?(n=Na(e,1,e.match_length-ft),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(n=Na(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),n&&(hn(e,!1),e.strm.avail_out===
0))return en}return e.insert=0,t===Ro?(hn(e,!0),e.strm.avail_out===0?Pi:Ws):e.last_lit&&(hn(e,!1),e.strm.avail_out===0)?en:Zl}function zZ(e,t){for(var n;;){if(e.lookahead===0&&(Ql(e),e.lookahead===0)){if(t===Li)return en;break}if(e.match_length=0,n=Na(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,n&&(hn(e,!1),e.strm.avail_out===0))return en}return e.insert=0,t===Ro?(hn(e,!0),e.strm.avail_out===0?Pi:Ws):e.last_lit&&(hn(e,!1),e.strm.avail_out===0)?en:Zl}function na(e,t,n,r,a){this.good_length=e,this.max_lazy=t,this.nice_length=n,this.max_chain=r,this.func=a}function GZ(e){e.window_size=2*e.w_size,Mi(e.head),e.max_lazy_match=Gs[e.level].max_lazy,e.good_match=Gs[e.level].good_length,e.nice_match=Gs[e.level].nice_length,e.max_chain_length=Gs[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=ft-1,e.match_available=0,e.ins_h=0}function WZ(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.
pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=bv,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new Da(LZ*2),this.dyn_dtree=new Da((2*OZ+1)*2),this.bl_tree=new Da((2*PZ+1)*2),Mi(this.dyn_ltree),Mi(this.dyn_dtree),Mi(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new Da(FZ+1),this.heap=new Da(2*yv+1),Mi(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new Da(2*yv+1),Mi(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=
0,this.bi_buf=0,this.bi_valid=0}function VZ(e){var t;return!e||!e.state?ko(e,_o):(e.total_in=e.total_out=0,e.data_type=DZ,t=e.state,t.pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?wv:Oi,e.adler=t.wrap===2?0:1,t.last_flush=Li,AP(t),So)}function Ev(e){var t=VZ(e);return t===So&&GZ(e.state),t}function qP(e,t,n,r,a,o){if(!e)return _o;var s=1;if(t===kZ&&(t=6),r<0?(s=0,r=-r):r>15&&(s=2,r-=16),a<1||a>AZ||n!==bv||r<8||r>15||t<0||t>9||o<0||o>IZ)return ko(e,_o);r===8&&(r=9);var c=new WZ;return e.state=c,c.strm=e,c.wrap=s,c.gzhead=null,c.w_bits=r,c.w_size=1<<c.w_bits,c.w_mask=c.w_size-1,c.hash_bits=a+7,c.hash_size=1<<c.hash_bits,c.hash_mask=c.hash_size-1,c.hash_shift=~~((c.hash_bits+ft-1)/ft),c.window=new nv(c.w_size*2),c.head=new Da(c.hash_size),c.prev=new Da(c.w_size),c.lit_bufsize=1<<a+6,c.pending_buf_size=c.lit_bufsize*4,c.pending_buf=new nv(c.pending_buf_size),c.d_buf=1*c.lit_bufsize,c.l_buf=3*c.lit_bufsize,c.level=t,c.strategy=o,c.method=n,Ev(e)}function zP(e,t){var n,
r,a,o;if(!e||!e.state||t>UP||t<0)return e?ko(e,_o):_o;if(r=e.state,!e.output||!e.input&&e.avail_in!==0||r.status===Jl&&t!==Ro)return ko(e,e.avail_out===0?hv:_o);if(r.strm=e,n=r.last_flush,r.last_flush=t,r.status===wv)if(r.wrap===2)e.adler=0,st(r,31),st(r,139),st(r,8),r.gzhead?(st(r,(r.gzhead.text?1:0)+(r.gzhead.hcrc?2:0)+(r.gzhead.extra?4:0)+(r.gzhead.name?8:0)+(r.gzhead.comment?16:0)),st(r,r.gzhead.time&255),st(r,r.gzhead.time>>8&255),st(r,r.gzhead.time>>16&255),st(r,r.gzhead.time>>24&255),st(r,r.level===9?2:r.strategy>=mf||r.level<2?4:0),st(r,r.gzhead.os&255),r.gzhead.extra&&r.gzhead.extra.length&&(st(r,r.gzhead.extra.length&255),st(r,r.gzhead.extra.length>>8&255)),r.gzhead.hcrc&&(e.adler=Ma(e.adler,r.pending_buf,r.pending,0)),r.gzindex=0,r.status=vv):(st(r,0),st(r,0),st(r,0),st(r,0),st(r,0),st(r,r.level===9?2:r.strategy>=mf||r.level<2?4:0),st(r,BZ),r.status=Oi);else{var s=bv+(r.w_bits-8<<4)<<8,c=-1;r.strategy>=mf||r.level<2?c=0:r.level<6?c=1:r.level===6?c=2:c=3,s|=c<<6,r.strstart!==
0&&(s|=UZ),s+=31-s%31,r.status=Oi,Xl(r,s),r.strstart!==0&&(Xl(r,e.adler>>>16),Xl(r,e.adler&65535)),e.adler=1}if(r.status===vv)if(r.gzhead.extra){for(a=r.pending;r.gzindex<(r.gzhead.extra.length&65535)&&!(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=Ma(e.adler,r.pending_buf,r.pending-a,a)),xo(e),a=r.pending,r.pending===r.pending_buf_size));)st(r,r.gzhead.extra[r.gzindex]&255),r.gzindex++;r.gzhead.hcrc&&r.pending>a&&(e.adler=Ma(e.adler,r.pending_buf,r.pending-a,a)),r.gzindex===r.gzhead.extra.length&&(r.gzindex=0,r.status=pf)}else r.status=pf;if(r.status===pf)if(r.gzhead.name){a=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=Ma(e.adler,r.pending_buf,r.pending-a,a)),xo(e),a=r.pending,r.pending===r.pending_buf_size)){o=1;break}r.gzindex<r.gzhead.name.length?o=r.gzhead.name.charCodeAt(r.gzindex++)&255:o=0,st(r,o)}while(o!==0);r.gzhead.hcrc&&r.pending>a&&(e.adler=Ma(e.adler,r.pending_buf,r.pending-a,a)),o===0&&(r.gzindex=0,r.status=
ff)}else r.status=ff;if(r.status===ff)if(r.gzhead.comment){a=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=Ma(e.adler,r.pending_buf,r.pending-a,a)),xo(e),a=r.pending,r.pending===r.pending_buf_size)){o=1;break}r.gzindex<r.gzhead.comment.length?o=r.gzhead.comment.charCodeAt(r.gzindex++)&255:o=0,st(r,o)}while(o!==0);r.gzhead.hcrc&&r.pending>a&&(e.adler=Ma(e.adler,r.pending_buf,r.pending-a,a)),o===0&&(r.status=hf)}else r.status=hf;if(r.status===hf&&(r.gzhead.hcrc?(r.pending+2>r.pending_buf_size&&xo(e),r.pending+2<=r.pending_buf_size&&(st(r,e.adler&255),st(r,e.adler>>8&255),e.adler=0,r.status=Oi)):r.status=Oi),r.pending!==0){if(xo(e),e.avail_out===0)return r.last_flush=-1,So}else if(e.avail_in===0&&jP(t)<=jP(n)&&t!==Ro)return ko(e,hv);if(r.status===Jl&&e.avail_in!==0)return ko(e,hv);if(e.avail_in!==0||r.lookahead!==0||t!==Li&&r.status!==Jl){var l=r.strategy===mf?zZ(r,t):r.strategy===_Z?qZ(r,t):Gs[r.level].func(r,t);if((l===Pi||l===Ws)&&(r.status=Jl),l===
en||l===Pi)return e.avail_out===0&&(r.last_flush=-1),So;if(l===Zl&&(t===xZ?NP(r):t!==UP&&(fv(r,0,0,!1),t===SZ&&(Mi(r.head),r.lookahead===0&&(r.strstart=0,r.block_start=0,r.insert=0))),xo(e),e.avail_out===0))return r.last_flush=-1,So}return t!==Ro?So:r.wrap<=0?BP:(r.wrap===2?(st(r,e.adler&255),st(r,e.adler>>8&255),st(r,e.adler>>16&255),st(r,e.adler>>24&255),st(r,e.total_in&255),st(r,e.total_in>>8&255),st(r,e.total_in>>16&255),st(r,e.total_in>>24&255)):(Xl(r,e.adler>>>16),Xl(r,e.adler&65535)),xo(e),r.wrap>0&&(r.wrap=-r.wrap),r.pending!==0?So:BP)}function GP(e){var t;return!e||!e.state?_o:(t=e.state.status,t!==wv&&t!==vv&&t!==pf&&t!==ff&&t!==hf&&t!==Oi&&t!==Jl?ko(e,_o):(e.state=null,t===Oi?ko(e,CZ):So))}var Li,xZ,SZ,Ro,UP,So,BP,_o,CZ,hv,kZ,RZ,mf,_Z,IZ,DZ,bv,AZ,NZ,MZ,yv,OZ,PZ,LZ,FZ,ft,Co,Br,UZ,wv,vv,pf,ff,hf,Oi,Jl,en,Zl,Pi,Ws,BZ,Gs,WP=g(()=>{d();rv();OP();LP();FP();tv();Li=0,xZ=1,SZ=3,Ro=4,UP=5,So=0,BP=1,_o=-2,CZ=-3,hv=-5,kZ=-1,RZ=1,mf=2,_Z=3,IZ=4,DZ=2,bv=8,AZ=9,NZ=29,MZ=256,yv=MZ+1+NZ,OZ=
30,PZ=19,LZ=2*yv+1,FZ=15,ft=3,Co=258,Br=Co+ft+1,UZ=32,wv=42,vv=69,pf=73,ff=91,hf=103,Oi=113,Jl=666,en=1,Zl=2,Pi=3,Ws=4,BZ=3;i(ko,"err");i(jP,"rank");i(Mi,"zero");i(xo,"flush_pending");i(hn,"flush_block_only");i(st,"put_byte");i(Xl,"putShortMSB");i(jZ,"read_buf");i(HP,"longest_match");i(Ql,"fill_window");i(HZ,"deflate_stored");i(gv,"deflate_fast");i(zs,"deflate_slow");i(qZ,"deflate_rle");i(zZ,"deflate_huff");i(na,"Config");Gs=[new na(0,0,0,0,HZ),new na(4,4,8,4,gv),new na(4,5,16,8,gv),new na(4,6,32,32,gv),new na(4,4,16,16,zs),new na(8,16,32,32,zs),new na(8,16,128,128,zs),new na(8,32,128,256,zs),new na(32,128,258,1024,zs),new na(32,258,258,4096,zs)];i(GZ,"lm_init");i(WZ,"DeflateState");i(VZ,"deflateResetKeep");i(Ev,"deflateReset");i(qP,"deflateInit2");i(zP,"deflate");i(GP,"deflateEnd")});var VP=g(()=>{d()});var wf={};x(wf,{DEFLATE:()=>$s,DEFLATERAW:()=>Vs,GUNZIP:()=>yf,GZIP:()=>eu,INFLATE:()=>vf,INFLATERAW:()=>tu,NONE:()=>Tv,UNZIP:()=>nu,Z_BEST_COMPRESSION:()=>tQ,Z_BEST_SPEED:()=>eQ,Z_BINARY:()=>cQ,Z_BLOCK:()=>ZP,Z_BUF_ERROR:()=>ZZ,Z_DATA_ERROR:()=>JZ,Z_DEFAULT_COMPRESSION:()=>nQ,Z_DEFAULT_STRATEGY:()=>sQ,Z_DEFLATED:()=>eL,Z_ERRNO:()=>KZ,Z_FILTERED:()=>rQ,Z_FINISH:()=>JP,Z_FIXED:()=>iQ,Z_FULL_FLUSH:()=>XP,Z_HUFFMAN_ONLY:()=>aQ,Z_NEED_DICT:()=>YZ,Z_NO_COMPRESSION:()=>QZ,Z_NO_FLUSH:()=>$P,Z_OK:()=>bf,Z_PARTIAL_FLUSH:()=>YP,Z_RLE:()=>oQ,Z_STREAM_END:()=>QP,Z_STREAM_ERROR:()=>XZ,Z_SYNC_FLUSH:()=>KP,Z_TEXT:()=>lQ,Z_TREES:()=>$Z,Z_UNKNOWN:()=>uQ,Zlib:()=>ra});function ra(e){if(e<$s||e>nu)throw new TypeError("Bad argument");this.mode=e,this.init_done=!1,this.write_in_progress=!1,this.pending_close=!1,this.windowBits=0,this.level=0,this.memLevel=0,this.strategy=0,this.dictionary=null}function dQ(e,t){for(var n=0;n<e.length;n++)this[t+n]=e[n]}var Tv,$s,vf,eu,yf,Vs,tu,nu,$P,YP,KP,XP,JP,ZP,$Z,bf,QP,
YZ,KZ,XZ,JZ,ZZ,QZ,eQ,tQ,nQ,rQ,aQ,oQ,iQ,sQ,cQ,lQ,uQ,eL,gf,tL=g(()=>{d();tv();lP();WP();VP();Tv=0,$s=1,vf=2,eu=3,yf=4,Vs=5,tu=6,nu=7,$P=0,YP=1,KP=2,XP=3,JP=4,ZP=5,$Z=6,bf=0,QP=1,YZ=2,KZ=-1,XZ=-2,JZ=-3,ZZ=-5,QZ=0,eQ=1,tQ=9,nQ=-1,rQ=1,aQ=2,oQ=3,iQ=4,sQ=0,cQ=0,lQ=1,uQ=2,eL=8;i(ra,"Zlib");ra.prototype.init=function(e,t,n,r,a){this.windowBits=e,this.level=t,this.memLevel=n,this.strategy=r,(this.mode===eu||this.mode===yf)&&(this.windowBits+=16),this.mode===nu&&(this.windowBits+=32),(this.mode===Vs||this.mode===tu)&&(this.windowBits=-this.windowBits),this.strm=new cP;var o;switch(this.mode){case $s:case eu:case Vs:o=qP(this.strm,this.level,eL,this.windowBits,this.memLevel,this.strategy);break;case vf:case yf:case tu:case nu:o=(this.strm,this.windowBits,void 0);break;default:throw new Error("Unknown mode "+this.mode)}if(o!==bf){this._error(o);return}this.write_in_progress=!1,this.init_done=!0};ra.prototype.params=function(){throw new Error("deflateParams Not supported")};ra.prototype._writeCheck=
function(){if(!this.init_done)throw new Error("write before init");if(this.mode===Tv)throw new Error("already finalized");if(this.write_in_progress)throw new Error("write already in progress");if(this.pending_close)throw new Error("close is pending")};ra.prototype.write=function(e,t,n,r,a,o,s){this._writeCheck(),this.write_in_progress=!0;var c=this;return process.nextTick(function(){c.write_in_progress=!1;var l=c._write(e,t,n,r,a,o,s);c.callback(l[0],l[1]),c.pending_close&&c.close()}),this};i(dQ,"bufferSet");ra.prototype.writeSync=function(e,t,n,r,a,o,s){return this._writeCheck(),this._write(e,t,n,r,a,o,s)};ra.prototype._write=function(e,t,n,r,a,o,s){if(this.write_in_progress=!0,e!==$P&&e!==YP&&e!==KP&&e!==XP&&e!==JP&&e!==ZP)throw new Error("Invalid flush value");t==null&&(t=new Buffer(0),r=0,n=0),a._set?a.set=a._set:a.set=dQ;var c=this.strm;c.avail_in=r,c.input=t,c.next_in=n,c.avail_out=s,c.output=a,c.next_out=o;var l;switch(this.mode){case $s:case eu:case Vs:l=zP(c,e);break;case nu:case vf:case yf:case tu:
l=void 0;break;default:throw new Error("Unknown mode "+this.mode)}return l!==QP&&l!==bf&&this._error(l),this.write_in_progress=!1,[c.avail_in,c.avail_out]};ra.prototype.close=function(){if(this.write_in_progress){this.pending_close=!0;return}this.pending_close=!1,this.mode===$s||this.mode===eu||this.mode===Vs?GP(this.strm):(this.strm,void 0),this.mode=Tv};ra.prototype.reset=function(){switch(this.mode){case $s:case Vs:gf=Ev(this.strm);break;case vf:case tu:gf=(this.strm,void 0);break}gf!==bf&&this._error(gf)};ra.prototype._error=function(e){this.onerror(lf[e]+": "+this.strm.msg,e),this.write_in_progress=!1,this.pending_close&&this.close()}});function mQ(e,t){if(!e)throw new Error(t)}function nL(e){return new Ef(e)}function rL(e,t){return pQ(new Tf(t),e)}function pQ(e,t){if(typeof t=="string"&&(t=new Buffer(t)),!Buffer.isBuffer(t))throw new TypeError("Not a string or buffer");var n=ee.Z_FINISH;return e._processChunk(t,n)}function Sv(e){if(!(this instanceof Sv))return new Sv(e);qt.call(this,e,ee.DEFLATE)}function Cv(e){if(!(this instanceof Cv))return new Cv(e);qt.call(this,e,ee.INFLATE)}function Ef(e){if(!(this instanceof Ef))return new Ef(e);qt.call(this,e,ee.GZIP)}function Tf(e){if(!(this instanceof Tf))return new Tf(e);qt.call(this,e,ee.GUNZIP)}function kv(e){if(!(this instanceof kv))return new kv(e);qt.call(this,e,ee.DEFLATERAW)}function Rv(e){if(!(this instanceof Rv))return new Rv(e);qt.call(this,e,ee.INFLATERAW)}function _v(e){if(!(this instanceof _v))return new _v(e);qt.call(this,e,ee.UNZIP)}function qt(e,t){if(this._opts=e=e||{},this._chunkSize=e.chunkSize||ee.Z_DEFAULT_CHUNK,Fn.call(this,e),e.flush&&e.flush!==ee.Z_NO_FLUSH&&
e.flush!==ee.Z_PARTIAL_FLUSH&&e.flush!==ee.Z_SYNC_FLUSH&&e.flush!==ee.Z_FULL_FLUSH&&e.flush!==ee.Z_FINISH&&e.flush!==ee.Z_BLOCK)throw new Error("Invalid flush flag: "+e.flush);if(this._flushFlag=e.flush||ee.Z_NO_FLUSH,e.chunkSize&&(e.chunkSize<ee.Z_MIN_CHUNK||e.chunkSize>ee.Z_MAX_CHUNK))throw new Error("Invalid chunk size: "+e.chunkSize);if(e.windowBits&&(e.windowBits<ee.Z_MIN_WINDOWBITS||e.windowBits>ee.Z_MAX_WINDOWBITS))throw new Error("Invalid windowBits: "+e.windowBits);if(e.level&&(e.level<ee.Z_MIN_LEVEL||e.level>ee.Z_MAX_LEVEL))throw new Error("Invalid compression level: "+e.level);if(e.memLevel&&(e.memLevel<ee.Z_MIN_MEMLEVEL||e.memLevel>ee.Z_MAX_MEMLEVEL))throw new Error("Invalid memLevel: "+e.memLevel);if(e.strategy&&e.strategy!=ee.Z_FILTERED&&e.strategy!=ee.Z_HUFFMAN_ONLY&&e.strategy!=ee.Z_RLE&&e.strategy!=ee.Z_FIXED&&e.strategy!=ee.Z_DEFAULT_STRATEGY)throw new Error("Invalid strategy: "+e.strategy);if(e.dictionary&&!Buffer.isBuffer(e.dictionary))throw new Error("Invalid dicti\
onary: it should be a Buffer instance");this._binding=new ee.Zlib(t);var n=this;this._hadError=!1,this._binding.onerror=function(o,s){n._binding=null,n._hadError=!0;var c=new Error(o);c.errno=s,c.code=ee.codes[s],n.emit("error",c)};var r=ee.Z_DEFAULT_COMPRESSION;typeof e.level=="number"&&(r=e.level);var a=ee.Z_DEFAULT_STRATEGY;typeof e.strategy=="number"&&(a=e.strategy),this._binding.init(e.windowBits||ee.Z_DEFAULT_WINDOWBITS,r,e.memLevel||ee.Z_DEFAULT_MEMLEVEL,a,e.dictionary),this._buffer=new Buffer(this._chunkSize),this._offset=0,this._closed=!1,this._level=r,this._strategy=a,this.once("end",this.close)}var ee,xv,aL=g(()=>{d();ev();tL();To();i(mQ,"assert");ee={};Object.keys(wf).forEach(function(e){ee[e]=wf[e]});ee.Z_MIN_WINDOWBITS=8;ee.Z_MAX_WINDOWBITS=15;ee.Z_DEFAULT_WINDOWBITS=15;ee.Z_MIN_CHUNK=64;ee.Z_MAX_CHUNK=1/0;ee.Z_DEFAULT_CHUNK=16*1024;ee.Z_MIN_MEMLEVEL=1;ee.Z_MAX_MEMLEVEL=9;ee.Z_DEFAULT_MEMLEVEL=8;ee.Z_MIN_LEVEL=-1;ee.Z_MAX_LEVEL=9;ee.Z_DEFAULT_LEVEL=ee.Z_DEFAULT_COMPRESSION;
xv={Z_OK:ee.Z_OK,Z_STREAM_END:ee.Z_STREAM_END,Z_NEED_DICT:ee.Z_NEED_DICT,Z_ERRNO:ee.Z_ERRNO,Z_STREAM_ERROR:ee.Z_STREAM_ERROR,Z_DATA_ERROR:ee.Z_DATA_ERROR,Z_MEM_ERROR:ee.Z_MEM_ERROR,Z_BUF_ERROR:ee.Z_BUF_ERROR,Z_VERSION_ERROR:ee.Z_VERSION_ERROR};Object.keys(xv).forEach(function(e){xv[xv[e]]=e});i(nL,"createGzip");i(rL,"gunzipSync");i(pQ,"zlibBufferSync");i(Sv,"Deflate");i(Cv,"Inflate");i(Ef,"Gzip");i(Tf,"Gunzip");i(kv,"DeflateRaw");i(Rv,"InflateRaw");i(_v,"Unzip");i(qt,"Zlib");Ht(qt,Fn);qt.prototype.params=function(e,t,n){if(e<ee.Z_MIN_LEVEL||e>ee.Z_MAX_LEVEL)throw new RangeError("Invalid compression level: "+e);if(t!=ee.Z_FILTERED&&t!=ee.Z_HUFFMAN_ONLY&&t!=ee.Z_RLE&&t!=ee.Z_FIXED&&t!=ee.Z_DEFAULT_STRATEGY)throw new TypeError("Invalid strategy: "+t);if(this._level!==e||this._strategy!==t){var r=this;this.flush(ee.Z_SYNC_FLUSH,function(){r._binding.params(e,t),r._hadError||(r._level=e,r._strategy=t,n&&n())})}else process.nextTick(n)};qt.prototype.reset=function(){return this._binding.reset()};
qt.prototype._flush=function(e){this._transform(new Buffer(0),"",e)};qt.prototype.flush=function(e,t){var n=this._writableState;if((typeof e=="function"||e===void 0&&!t)&&(t=e,e=ee.Z_FULL_FLUSH),n.ended)t&&process.nextTick(t);else if(n.ending)t&&this.once("end",t);else if(n.needDrain){var r=this;this.once("drain",function(){r.flush(t)})}else this._flushFlag=e,this.write(new Buffer(0),"",t)};qt.prototype.close=function(e){if(e&&process.nextTick(e),!this._closed){this._closed=!0,this._binding.close();var t=this;process.nextTick(function(){t.emit("close")})}};qt.prototype._transform=function(e,t,n){var r,a=this._writableState,o=a.ending||a.ended,s=o&&(!e||a.length===e.length);if(!e===null&&!Buffer.isBuffer(e))return n(new Error("invalid input"));s?r=ee.Z_FINISH:(r=this._flushFlag,e.length>=a.length&&(this._flushFlag=this._opts.flush||ee.Z_NO_FLUSH)),this._processChunk(e,r,n)};qt.prototype._processChunk=function(e,t,n){var r=e&&e.length,a=this._chunkSize-this._offset,o=0,s=this,c=typeof n==
"function";if(!c){var l=[],u=0,m;this.on("error",function(b){m=b});do var p=this._binding.writeSync(t,e,o,r,this._buffer,this._offset,a);while(!this._hadError&&y(p[0],p[1]));if(this._hadError)throw m;var f=Buffer.concat(l,u);return this.close(),f}var h=this._binding.write(t,e,o,r,this._buffer,this._offset,a);h.buffer=e,h.callback=y;function y(b,w){if(!s._hadError){var C=a-w;if(mQ(C>=0,"have should not go down"),C>0){var k=s._buffer.slice(s._offset,s._offset+C);s._offset+=C,c?s.push(k):(l.push(k),u+=k.length)}if((w===0||s._offset>=s._chunkSize)&&(a=s._chunkSize,s._offset=0,s._buffer=new Buffer(s._chunkSize)),w===0){if(o+=r-b,r=b,!c)return!0;var R=s._binding.write(t,e,o,r,s._buffer,s._offset,s._chunkSize);R.callback=y,R.buffer=e;return}if(!c)return!1;n()}}i(y,"callback")};Ht(Sv,qt);Ht(Cv,qt);Ht(Ef,qt);Ht(Tf,qt);Ht(kv,qt);Ht(Rv,qt);Ht(_v,qt)});var Z,Iv=g(()=>{d();Z=class extends Error{static{i(this,"LanternError")}}});var xf,oL,fQ,hQ,Oa,iL=g(()=>{d();Iv();xf=class{static{i(this,"UrlUtils")}static rewriteChromeInternalUrl(t){return t?.startsWith("chrome://")?(t.endsWith("/")&&(t=t.replace(/\/$/,"")),t.replace(/^chrome:\/\/chrome\//,"chrome://")):t}static equalWithExcludedFragments(t,n){[t,n]=[t,n].map(this.rewriteChromeInternalUrl);try{let r=new URL(t);r.hash="";let a=new URL(n);return a.hash="",r.href===a.href}catch{return!1}}},oL=14*1024,fQ=.4,hQ={Document:.9,XHR:.9,Fetch:.9},Oa=class e{static{i(this,"NetworkAnalyzer")}static get summary(){return"__SUMMARY__"}static groupByOrigin(t){let n=new Map;return t.forEach(r=>{let a=r.parsedURL.securityOrigin,o=n.get(a)||[];o.push(r),n.set(a,o)}),n}static getSummary(t){t.sort((r,a)=>r-a);let n;if(t.length===0)n=t[0];else if(t.length%2===0){let r=t[Math.floor((t.length-1)/2)],a=t[Math.floor((t.length-1)/2)+1];n=(r+a)/2}else n=t[Math.floor((t.length-1)/2)];return{min:t[0],max:t[t.length-1],avg:t.reduce((r,a)=>r+a,0)/t.length,median:n}}static summarize(t){let n=new Map,
r=[];for(let[a,o]of t)n.set(a,e.getSummary(o)),r.push(...o);return n.set(e.summary,e.getSummary(r)),n}static estimateValueByOrigin(t,n){let r=e.estimateIfConnectionWasReused(t),a=e.groupByOrigin(t),o=new Map;for(let[s,c]of a.entries()){let l=[];for(let u of c){let m=u.timing;if(!m)continue;let p=n({request:u,timing:m,connectionReused:r.get(u.requestId)});typeof p<"u"&&(l=l.concat(p))}l.length&&o.set(s,l)}return o}static estimateRTTViaConnectionTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r)return;let{connectStart:o,sslStart:s,sslEnd:c,connectEnd:l}=n;if(l>=0&&o>=0&&a.protocol.startsWith("h3"))return l-o;if(s>=0&&c>=0&&s!==o)return[l-s,s-o];if(o>=0&&l>=0)return l-o}static estimateRTTViaDownloadTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r||a.transferSize<=oL||!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0)return;let s=a.networkEndTime-a.networkRequestTime-n.receiveHeadersEnd,c=Math.log2(a.transferSize/oL);if(!(c>5))return s/c}static estimateRTTViaSendStartTiming(t){
let{timing:n,connectionReused:r,request:a}=t;if(r||!Number.isFinite(n.sendStart)||n.sendStart<0)return;let o=1;return a.protocol.startsWith("h3")||(o+=1),a.parsedURL.scheme==="https"&&(o+=1),n.sendStart/o}static estimateRTTViaHeadersEndTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0||!a.resourceType)return;let o=hQ[a.resourceType]||fQ,s=n.receiveHeadersEnd*o,c=1;return r||(c+=1,a.protocol.startsWith("h3")||(c+=1),a.parsedURL.scheme==="https"&&(c+=1)),Math.max((n.receiveHeadersEnd-s)/c,3)}static estimateResponseTimeByOrigin(t,n){return e.estimateValueByOrigin(t,({request:r,timing:a})=>{if(r.serverResponseTime!==void 0)return r.serverResponseTime;if(!Number.isFinite(a.receiveHeadersEnd)||a.receiveHeadersEnd<0||!Number.isFinite(a.sendEnd)||a.sendEnd<0)return;let o=a.receiveHeadersEnd-a.sendEnd,s=r.parsedURL.securityOrigin,c=n.get(s)||n.get(e.summary)||0;return Math.max(o-c,0)})}static canTrustConnectionInformation(t){let n=new Map;
for(let r of t){let a=n.get(r.connectionId)||!r.connectionReused;n.set(r.connectionId,a)}return n.size<=1?!1:Array.from(n.values()).every(r=>r)}static estimateIfConnectionWasReused(t,n){let{forceCoarseEstimates:r=!1}=n||{};if(!r&&e.canTrustConnectionInformation(t))return new Map(t.map(s=>[s.requestId,!!s.connectionReused]));let a=new Map,o=e.groupByOrigin(t);for(let s of o.values()){let c=s.map(u=>u.networkEndTime).reduce((u,m)=>Math.min(u,m),1/0);for(let u of s)a.set(u.requestId,u.networkRequestTime>=c||u.protocol==="h2");let l=s.reduce((u,m)=>u.networkRequestTime>m.networkRequestTime?m:u);a.set(l.requestId,!1)}return a}static estimateRTTByOrigin(t,n){let{forceCoarseEstimates:r=!1,coarseEstimateMultiplier:a=.3,useDownloadEstimates:o=!0,useSendStartEstimates:s=!0,useHeadersEndEstimates:c=!0}=n||{},l=e.estimateIfConnectionWasReused(t),u=e.groupByOrigin(t),m=new Map;for(let[p,f]of u.entries()){let y=function(b,w=1){for(let C of f){let k=C.timing;if(!k||!C.transferSize)continue;let R=b({request:C,
timing:k,connectionReused:l.get(C.requestId)});R!==void 0&&(Array.isArray(R)?h.push(...R.map(S=>S*w)):h.push(R*w))}};i(y,"collectEstimates");let h=[];r||y(this.estimateRTTViaConnectionTiming),h.length||(o&&y(this.estimateRTTViaDownloadTiming,a),s&&y(this.estimateRTTViaSendStartTiming,a),c&&y(this.estimateRTTViaHeadersEndTiming,a)),h.length&&m.set(p,h)}if(!m.size)throw new Z("No timing information available");return e.summarize(m)}static estimateServerResponseTimeByOrigin(t,n){let r=n?.rttByOrigin;if(!r){r=new Map;let o=e.estimateRTTByOrigin(t,n);for(let[s,c]of o.entries())r.set(s,c.min)}let a=e.estimateResponseTimeByOrigin(t,r);return e.summarize(a)}static estimateThroughput(t){let n=0,r=t.reduce((c,l)=>(l.parsedURL?.scheme==="data"||l.failed||!l.finished||l.statusCode>300||!l.transferSize||(n+=l.transferSize,c.push({time:l.responseHeadersEndTime/1e3,isStart:!0}),c.push({time:l.networkEndTime/1e3,isStart:!1})),c),[]).sort((c,l)=>c.time-l.time);if(!r.length)return null;let a=0,o=0,s=0;return r.
forEach(c=>{c.isStart?(a===0&&(o=c.time),a++):(a--,a===0&&(s+=c.time-o))}),n*8/s}static computeRTTAndServerResponseTime(t){let n=new Map;for(let[c,l]of e.estimateRTTByOrigin(t).entries())n.set(c,l.min);let r=Math.min(...Array.from(n.values())),a=e.estimateServerResponseTimeByOrigin(t,{rttByOrigin:n}),o=new Map,s=new Map;for(let[c,l]of a.entries()){let u=n.get(c)||r;o.set(c,u-r),s.set(c,l.median)}return{rtt:r,additionalRttByOrigin:o,serverResponseTimeByOrigin:s}}static analyze(t){let n=e.estimateThroughput(t);return n===null?null:{throughput:n,...e.computeRTTAndServerResponseTime(t)}}static findResourceForUrl(t,n){return t.find(r=>n.startsWith(r.url)&&xf.equalWithExcludedFragments(r.url,n))}static findLastDocumentForUrl(t,n){let r=t.filter(a=>a.resourceType==="Document"&&!a.failed&&n.startsWith(a.url)&&xf.equalWithExcludedFragments(a.url,n));return r[r.length-1]}static resolveRedirects(t){for(;t.redirectDestination;)t=t.redirectDestination;return t}}});var ct={};x(ct,{LanternError:()=>Z,NetworkAnalyzer:()=>Oa});var or=g(()=>{d();Iv();iL()});var et,Sf=g(()=>{d();or();et=class e{static{i(this,"BaseNode")}static types={NETWORK:"network",CPU:"cpu"};_id;_isMainDocument;dependents;dependencies;constructor(t){this._id=t,this._isMainDocument=!1,this.dependents=[],this.dependencies=[]}get id(){return this._id}get type(){throw new Z("Unimplemented")}get startTime(){throw new Z("Unimplemented")}get endTime(){throw new Z("Unimplemented")}setIsMainDocument(t){this._isMainDocument=t}isMainDocument(){return this._isMainDocument}getDependents(){return this.dependents.slice()}getNumberOfDependents(){return this.dependents.length}getDependencies(){return this.dependencies.slice()}getNumberOfDependencies(){return this.dependencies.length}getRootNode(){let t=this;for(;t.dependencies.length;)t=t.dependencies[0];return t}addDependent(t){t.addDependency(this)}addDependency(t){if(t===this)throw new Z("Cannot add dependency on itself");this.dependencies.includes(t)||(t.dependents.push(this),this.dependencies.push(t))}removeDependent(t){t.removeDependency(
this)}removeDependency(t){if(!this.dependencies.includes(t))return;let n=t.dependents.indexOf(this);t.dependents.splice(n,1),this.dependencies.splice(this.dependencies.indexOf(t),1)}removeAllDependencies(){for(let t of this.dependencies.slice())this.removeDependency(t)}isDependentOn(t){let n=!1;return this.traverse(r=>{n||(n=r===t)},r=>n?[]:r.getDependencies()),n}cloneWithoutRelationships(){let t=new e(this.id);return t.setIsMainDocument(this._isMainDocument),t}cloneWithRelationships(t){let n=this.getRootNode(),r=new Map;n.traverse(o=>{if(!r.has(o.id)){if(t===void 0){r.set(o.id,o.cloneWithoutRelationships());return}t(o)&&o.traverse(s=>r.set(s.id,s.cloneWithoutRelationships()),s=>s.dependencies.filter(c=>!r.has(c.id)))}}),n.traverse(o=>{let s=r.get(o.id);if(s)for(let c of o.dependencies){let l=r.get(c.id);if(!l)throw new Z("Dependency somehow not cloned");s.addDependency(l)}});let a=r.get(this.id);if(!a)throw new Z("Cloned graph missing node");return a}traverse(t,n){for(let{node:r,traversalPath:a}of this.
traverseGenerator(n))t(r,a)}*traverseGenerator(t){t||(t=i(a=>a.getDependents(),"getNextNodes"));let n=[[this]],r=new Set([this.id]);for(;n.length;){let a=n.shift(),o=a[0];yield{node:o,traversalPath:a};for(let s of t(o))r.has(s.id)||(r.add(s.id),n.push([s,...a]))}}static findCycle(t,n="both"){if(n==="both")return e.findCycle(t,"dependents")||e.findCycle(t,"dependencies");let r=new Set,a=[],o=[t],s=new Map([[t,0]]);for(;o.length;){let c=o.pop();if(a.includes(c))return a;if(r.has(c))continue;for(;a.length>s.get(c);)a.pop();r.add(c),a.push(c);let l=n==="dependents"?c.dependents:c.dependencies;for(let u of l)o.includes(u)||(o.push(u),s.set(u,a.length))}return null}canDependOn(t){return t.startTime<=this.startTime}}});var ru,Dv=g(()=>{d();Sf();ru=class e extends et{static{i(this,"CPUNode")}_event;_childEvents;correctedEndTs;constructor(t,n=[],r){let a=`${t.tid}.${t.ts}`;super(a),this._event=t,this._childEvents=n,this.correctedEndTs=r}get type(){return et.types.CPU}get startTime(){return this._event.ts}get endTime(){return this.correctedEndTs?this.correctedEndTs:this._event.ts+this._event.dur}get duration(){return this.endTime-this.startTime}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some(t=>t.name==="Layout")}getEvaluateScriptURLs(){let t=new Set;for(let n of this._childEvents)n.name==="EvaluateScript"&&n.args.data?.url&&t.add(n.args.data.url);return t}cloneWithoutRelationships(){return new e(this._event,this._childEvents,this.correctedEndTs)}}});function sL(e){let t=e.includes(":")?e.slice(0,e.indexOf(":")):e;return gQ.includes(t)}var gQ,Fi,Av=g(()=>{d();Sf();gQ=["blob","data","intent","file","filesystem","chrome-extension"];i(sL,"isNonNetworkProtocol");Fi=class e extends et{static{i(this,"NetworkNode")}_request;constructor(t){super(t.requestId),this._request=t}get type(){return et.types.NETWORK}get startTime(){return this._request.rendererStartTime*1e3}get endTime(){return this._request.networkEndTime*1e3}get rawRequest(){return this._request.rawRequest}get request(){return this._request}get initiatorType(){return this._request.initiator.type}get fromDiskCache(){return!!this._request.fromDiskCache}get isNonNetworkProtocol(){return sL(this.request.protocol)||sL(this.request.parsedURL.scheme)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){let t=this._request.priority,n=this._request.resourceType==="Script",r=this._request.resourceType==="Document";return t==="VeryHigh"||t===
"High"&&n||t==="High"&&r}cloneWithoutRelationships(){let t=new e(this._request);return t.setIsMainDocument(this._isMainDocument),t}}});var yQ,vQ,bQ,wQ,EQ,TQ,Nv,cL=g(()=>{d();or();Dv();Av();yQ="RunTask",vQ="ThreadControllerImpl::RunTask",bQ="ThreadControllerImpl::DoWork",wQ="TaskQueueManager::ProcessTaskFromWorkQueue",EQ=10,TQ=/^video/,Nv=class e{static{i(this,"PageDependencyGraph")}static getNetworkInitiators(t){if(!t.initiator)return[];if(t.initiator.url)return[t.initiator.url];if(t.initiator.type==="script"){let n=new Set,r=t.initiator.stack;for(;r;){let a=r.callFrames||[];for(let o of a)o.url&&n.add(o.url);r=r.parent}return Array.from(n)}return[]}static getNetworkNodeOutput(t){let n=[],r=new Map,a=new Map,o=new Map;return t.forEach(s=>{if(TQ.test(s.mimeType)||s.fromWorker)return;for(;r.has(s.requestId);)s.requestId+=":duplicate";let c=new Fi(s);n.push(c);let l=a.get(s.url)||[];if(l.push(c),r.set(s.requestId,c),a.set(s.url,l),s.frameId&&s.resourceType==="Document"&&s.documentURL===s.url){let u=o.has(s.frameId)?null:c;o.set(s.frameId,u)}}),{nodes:n,idToNodeMap:r,urlToNodeMap:a,frameIdToNodeMap:o}}static isScheduleableTask(t){
return t.name===yQ||t.name===vQ||t.name===bQ||t.name===wQ}static assertHasToplevelEvents(t){if(!t.some(this.isScheduleableTask))throw new Z("Could not find any top level events")}static getCPUNodes(t){let n=[],r=0;for(e.assertHasToplevelEvents(t);r<t.length;){let a=t[r];if(r++,!e.isScheduleableTask(a)||!a.dur)continue;let o,s=[];for(let c=a.ts+a.dur;r<t.length&&t[r].ts<c;r++){let l=t[r];if(e.isScheduleableTask(l)&&l.dur){o=l.ts-1;break}s.push(l)}n.push(new ru(a,s,o))}return n}static linkNetworkNodes(t,n){n.nodes.forEach(r=>{let a=r.request.initiatorRequest||t.request,o=n.idToNodeMap.get(a.requestId)||t,s=!o.isDependentOn(r)&&r.canDependOn(o),c=e.getNetworkInitiators(r.request);if(c.length?c.forEach(u=>{let m=n.urlToNodeMap.get(u)||[];m.length===1&&m[0].startTime<=r.startTime&&!m[0].isDependentOn(r)?r.addDependency(m[0]):s&&o.addDependent(r)}):s&&o.addDependent(r),r!==t&&r.getDependencies().length===0&&r.canDependOn(t)&&r.addDependency(t),!r.request.redirects)return;let l=[...r.request.
redirects,r.request];for(let u=1;u<l.length;u++){let m=n.idToNodeMap.get(l[u-1].requestId),p=n.idToNodeMap.get(l[u].requestId);p&&m&&p.addDependency(m)}})}static linkCPUNodes(t,n,r){let a=new Set(["XHR","Fetch","Script"]);function o(h,y){let b=n.idToNodeMap.get(y);if(!b||b.startTime<=h.startTime)return;let{request:w}=b,C=w.resourceType||w.redirectDestination?.resourceType;a.has(C)&&h.addDependent(b)}i(o,"addDependentNetworkRequest");function s(h,y){if(!y)return;let b=n.frameIdToNodeMap.get(y);b&&(b.startTime>=h.startTime||h.addDependency(b))}i(s,"addDependencyOnFrame");function c(h,y){if(!y)return;let b=-100*1e3,w=n.urlToNodeMap.get(y)||[],C=null,k=1/0;for(let R of w){if(h.startTime<=R.startTime)return;let S=h.startTime-R.endTime;S>=b&&S<k&&(C=R,k=S)}C&&h.addDependency(C)}i(c,"addDependencyOnUrl");let l=new Map;for(let h of r){for(let y of h.childEvents){if(!y.args.data)continue;let b=y.args.data.url,w=(y.args.data.stackTrace||[]).map(C=>C.url).filter(Boolean);switch(y.name){case"Timer\
Install":l.set(y.args.data.timerId,h),w.forEach(C=>c(h,C));break;case"TimerFire":{let C=l.get(y.args.data.timerId);if(!C||C.endTime>h.startTime)break;C.addDependent(h);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":s(h,y.args.data.frame),w.forEach(C=>c(h,C));break;case"EvaluateScript":s(h,y.args.data.frame),c(h,b),w.forEach(C=>c(h,C));break;case"XHRReadyStateChange":if(y.args.data.readyState!==4)break;c(h,b),w.forEach(C=>c(h,C));break;case"FunctionCall":case"v8.compile":s(h,y.args.data.frame),c(h,b);break;case"ParseAuthorStyleSheet":s(h,y.args.data.frame),c(h,y.args.data.styleSheetUrl);break;case"ResourceSendRequest":s(h,y.args.data.frame),o(h,y.args.data.requestId),w.forEach(C=>c(h,C));break}}h.getNumberOfDependencies()===0&&h.canDependOn(t)&&h.addDependency(t)}let u=EQ*1e3,m=!1,p=!1,f=!1;for(let h of r){let y=!1;!m&&h.childEvents.some(b=>b.name==="Layout")&&(y=m=!0),!p&&h.childEvents.some(b=>b.name==="Paint")&&(y=p=!0),!f&&h.childEvents.some(b=>b.name==="ParseHTML")&&(y=
f=!0),!(y||h.duration>=u)&&(h.getNumberOfDependencies()===1||h.getNumberOfDependents()<=1)&&e.pruneNode(h)}}static pruneNode(t){let n=t.getDependencies(),r=t.getDependents();for(let a of n){t.removeDependency(a);for(let o of r)a.addDependent(o)}for(let a of r)t.removeDependent(a)}static debugNormalizeRequests(t){for(let a of t)a.rendererStartTime=Math.round(a.rendererStartTime*1e3)/1e3,a.networkRequestTime=Math.round(a.networkRequestTime*1e3)/1e3,a.responseHeadersEndTime=Math.round(a.responseHeadersEndTime*1e3)/1e3,a.networkEndTime=Math.round(a.networkEndTime*1e3)/1e3;for(let a of t)delete a.rawRequest,a.initiatorRequest&&(a.initiatorRequest={id:a.initiatorRequest.requestId}),a.redirectDestination&&(a.redirectDestination={id:a.redirectDestination.requestId}),a.redirectSource&&(a.redirectSource={id:a.redirectSource.requestId}),a.redirects&&(a.redirects=a.redirects.map(o=>o.requestId));let r=t.map(a=>({requestId:a.requestId,connectionId:a.connectionId,connectionReused:a.connectionReused,
url:a.url,protocol:a.protocol,parsedURL:a.parsedURL,documentURL:a.documentURL,rendererStartTime:a.rendererStartTime,networkRequestTime:a.networkRequestTime,responseHeadersEndTime:a.responseHeadersEndTime,networkEndTime:a.networkEndTime,transferSize:a.transferSize,resourceSize:a.resourceSize,fromDiskCache:a.fromDiskCache,fromMemoryCache:a.fromMemoryCache,finished:a.finished,statusCode:a.statusCode,redirectSource:a.redirectSource,redirectDestination:a.redirectDestination,redirects:a.redirects,failed:a.failed,initiator:a.initiator,timing:a.timing?{requestTime:a.timing.requestTime,proxyStart:a.timing.proxyStart,proxyEnd:a.timing.proxyEnd,dnsStart:a.timing.dnsStart,dnsEnd:a.timing.dnsEnd,connectStart:a.timing.connectStart,connectEnd:a.timing.connectEnd,sslStart:a.timing.sslStart,sslEnd:a.timing.sslEnd,workerStart:a.timing.workerStart,workerReady:a.timing.workerReady,workerFetchStart:a.timing.workerFetchStart,workerRespondWithSettled:a.timing.workerRespondWithSettled,sendStart:a.timing.sendStart,
sendEnd:a.timing.sendEnd,pushStart:a.timing.pushStart,pushEnd:a.timing.pushEnd,receiveHeadersStart:a.timing.receiveHeadersStart,receiveHeadersEnd:a.timing.receiveHeadersEnd}:a.timing,resourceType:a.resourceType,mimeType:a.mimeType,priority:a.priority,initiatorRequest:a.initiatorRequest,frameId:a.frameId,fromWorker:a.fromWorker,isLinkPreload:a.isLinkPreload,serverResponseTime:a.serverResponseTime})).filter(a=>!a.fromWorker);console.log(r)}static createGraph(t,n,r){let a=e.getNetworkNodeOutput(n),o=e.getCPUNodes(t),{requestedUrl:s,mainDocumentUrl:c}=r;if(!s)throw new Z("requestedUrl is required to get the root request");if(!c)throw new Z("mainDocumentUrl is required to get the main resource");let l=Oa.findResourceForUrl(n,s);if(!l)throw new Z("rootRequest not found");let u=a.idToNodeMap.get(l.requestId);if(!u)throw new Z("rootNode not found");let m=Oa.findLastDocumentForUrl(n,c);if(!m)throw new Z("mainDocumentRequest not found");let p=a.idToNodeMap.get(m.requestId);if(!p)throw new Z("mai\
nDocumentNode not found");if(e.linkNetworkNodes(u,a),e.linkCPUNodes(u,a,o),p.setIsMainDocument(!0),Fi.findCycle(u))throw new Z("Invalid dependency graph created, cycle detected");return u}static printGraph(t,n=80){function r(p,f,h=" "){return p+h.repeat(Math.max(f-p.length,0))}i(r,"padRight");let a=[];t.traverse(p=>a.push(p)),a.sort((p,f)=>p.startTime-f.startTime);let o=new Map;t.traverse(p=>{let f=65+o.size,h;f>90?h=`Z${f-90}`:h=String.fromCharCode(f),o.set(p,h)});let s=a[0].startTime,u=(a.reduce((p,f)=>Math.max(p,f.endTime),0)-s)/n;a.forEach(p=>{let f=Math.round((p.startTime-s)/u),h=Math.ceil((p.endTime-p.startTime)/u),y=r("",f)+r("",h,"="),b=p.request?p.request.url:p.type;console.log(r(y,n),`| ${b.slice(0,50)}`)}),console.log(),a.forEach(p=>{let f=p.request?p.request.url:p.type;console.log(o.get(p),f.slice(0,n-5));for(let h of p.dependents){let y=h.request?h.request.url:h.type;console.log("  ->",o.get(h),y.slice(0,n-10))}console.log()});let m=Fi.findCycle(t);if(console.log("Cycle?",
m?"yes":"no"),m){let p=[...m];p.push(p[0]),console.log(p.map(f=>o.get(f)).join(" -> "))}}}});var gn={};x(gn,{BaseNode:()=>et,CPUNode:()=>ru,NetworkNode:()=>Fi,PageDependencyGraph:()=>Nv});var aa=g(()=>{d();Sf();Dv();Av();cL()});var _n,Io=g(()=>{d();or();aa();_n=class{static{i(this,"Metric")}static getScriptUrls(t,n){let r=new Set;return t.traverse(a=>{a.type===et.types.NETWORK&&a.request.resourceType==="Script"&&n?.(a)&&r.add(a.request.url)}),r}static get coefficients(){throw new Z("coefficients unimplemented!")}static getScaledCoefficients(t){return this.coefficients}static getOptimisticGraph(t,n){throw new Z("Optimistic graph unimplemented!")}static getPessimisticGraph(t,n){throw new Z("Pessmistic graph unimplemented!")}static getEstimateFromSimulation(t,n){return t}static compute(t,n){let{simulator:r,graph:a,processedNavigation:o}=t,s=this.name.replace("Lantern",""),c=this.getOptimisticGraph(a,o),l=this.getPessimisticGraph(a,o),u={label:`optimistic${s}`},m=r.simulate(c,u);u={label:`pessimistic${s}`};let p=r.simulate(l,u),f=this.getEstimateFromSimulation(m,{...n,optimistic:!0}),h=this.getEstimateFromSimulation(p,{...n,optimistic:!1}),y=this.getScaledCoefficients(r.rtt),b=y.intercept>0?Math.min(1,f.timeInMs/
1e3):1;return{timing:y.intercept*b+y.optimistic*f.timeInMs+y.pessimistic*h.timeInMs,optimisticEstimate:f,pessimisticEstimate:h,optimisticGraph:c,pessimisticGraph:l}}}});var Ys,Mv=g(()=>{d();aa();Io();Ys=class extends _n{static{i(this,"FirstContentfulPaint")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getRenderBlockingNodeData(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=new Map,s=[];t.traverse(h=>{if(h.type===et.types.CPU){h.startTime<=n&&s.push(h);let y=h.getEvaluateScriptURLs();for(let b of y){let w=o.get(b)||h;o.set(b,h.startTime<w.startTime?h:w)}}}),s.sort((h,y)=>h.startTime-y.startTime);let c=_n.getScriptUrls(t,h=>h.endTime<=n&&r(h)),l=new Set,u=new Set;for(let h of c){let y=o.get(h);if(y){if(s.includes(y)){u.add(y.id);continue}l.add(h)}}let m=s.find(h=>h.didPerformLayout());m&&u.add(m.id);let p=s.find(h=>h.childEvents.some(y=>y.name==="Paint"));p&&u.add(p.id);let f=s.find(h=>h.childEvents.some(y=>y.name==="ParseHTML"));return f&&u.add(f.id),a&&s.filter(a).forEach(h=>u.add(h.id)),{definitelyNotRenderBlockingScriptUrls:l,renderBlockingCpuNodeIds:u}}static getFirstPaintBasedGraph(t,{
cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=this.getRenderBlockingNodeData(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}),{definitelyNotRenderBlockingScriptUrls:s,renderBlockingCpuNodeIds:c}=o;return t.cloneWithRelationships(l=>{if(l.type===et.types.NETWORK){if((l.endTime>n||l.startTime>n)&&!l.isMainDocument())return!1;let m=l.request.url;return s.has(m)?!1:r(l)}return c.has(l.id)})}static getOptimisticGraph(t,n){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:n.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:i(r=>r.hasRenderBlockingPriority()&&r.initiatorType!=="script","treatNodeAsRenderBlocking")})}static getPessimisticGraph(t,n){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:n.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:i(r=>r.hasRenderBlockingPriority(),"treatNodeAsRenderBlocking")})}}});var xQ,Ov,lL=g(()=>{d();or();aa();Io();xQ=20,Ov=class e extends _n{static{i(this,"Interactive")}static get coefficients(){return{intercept:0,optimistic:.45,pessimistic:.55}}static getOptimisticGraph(t){let n=xQ*1e3;return t.cloneWithRelationships(r=>{if(r.type===et.types.CPU)return r.duration>n;let a=r.request.resourceType==="Image",o=r.request.resourceType==="Script";return!a&&(o||r.request.priority==="High"||r.request.priority==="VeryHigh")})}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.lcpResult)throw new Z("missing lcpResult");let r=e.getLastLongTaskEndTime(t.nodeTimings),a=n.optimistic?n.lcpResult.optimisticEstimate.timeInMs:n.lcpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(a,r),nodeTimings:t.nodeTimings}}static compute(t,n){let r=n?.lcpResult;if(!r)throw new Z("LCP is required to calculate the Interactive metric");let a=super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}static getLastLongTaskEndTime(t,n=50){return Array.
from(t.entries()).filter(([r,a])=>r.type!==et.types.CPU?!1:a.duration>n).map(([r,a])=>a.endTime).reduce((r,a)=>Math.max(r||0,a||0),0)}}});var Pv,uL=g(()=>{d();or();Mv();Io();Pv=class e extends _n{static{i(this,"LargestContentfulPaint")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static isNotLowPriorityImageNode(t){if(t.type!=="network")return!0;let n=t.request.resourceType==="Image",r=t.request.priority==="Low"||t.request.priority==="VeryLow";return!n||!r}static getOptimisticGraph(t,n){let r=n.timestamps.largestContentfulPaint;if(!r)throw new Z("NO_LCP");return Ys.getFirstPaintBasedGraph(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:e.isNotLowPriorityImageNode})}static getPessimisticGraph(t,n){let r=n.timestamps.largestContentfulPaint;if(!r)throw new Z("NO_LCP");return Ys.getFirstPaintBasedGraph(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:i(a=>!0,"treatNodeAsRenderBlocking"),additionalCpuNodesToTreatAsRenderBlocking:i(a=>a.didPerformLayout(),"additionalCpuNodesToTreatAsRenderBlocking")})}static getEstimateFromSimulation(t){let n=Array.from(t.nodeTimings.entries()).filter(r=>e.isNotLowPriorityImageNode(
r[0])).map(r=>r[1].endTime);return{timeInMs:Math.max(...n),nodeTimings:t.nodeTimings}}static compute(t,n){let r=n?.fcpResult;if(!r)throw new Z("FCP is required to calculate the LCP metric");let a=super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}}});var Lv,dL=g(()=>{d();or();aa();Io();Lv=class e extends _n{static{i(this,"MaxPotentialFID")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new Z("missing fcpResult");let r=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=e.getTimingsAfterFCP(t.nodeTimings,r);return{timeInMs:Math.max(...a.map(o=>o.duration),16),nodeTimings:t.nodeTimings}}static compute(t,n){if(!n?.fcpResult)throw new Z("FCP is required to calculate the Max Potential FID metric");return super.compute(t,n)}static getTimingsAfterFCP(t,n){return Array.from(t.entries()).filter(([r,a])=>r.type===et.types.CPU&&a.endTime>n).map(([r,a])=>a)}}});var SQ,Fv,mL=g(()=>{d();or();aa();Io();SQ=150,Fv=class e extends _n{static{i(this,"SpeedIndex")}static get coefficients(){return{intercept:0,optimistic:1.4,pessimistic:.4}}static getScaledCoefficients(t){let n=this.coefficients,r=SQ-30,a=Math.max((t-30)/r,0);return{intercept:n.intercept*a,optimistic:.5+(n.optimistic-.5)*a,pessimistic:.5+(n.pessimistic-.5)*a}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new Z("missing fcpResult");if(n.observedSpeedIndex===void 0)throw new Z("missing observedSpeedIndex");let r=n.fcpResult.pessimisticEstimate.timeInMs;return{timeInMs:n.optimistic?n.observedSpeedIndex:e.computeLayoutBasedSpeedIndex(t.nodeTimings,r),nodeTimings:t.nodeTimings}}static compute(t,n){let r=n?.fcpResult;if(!r)throw new Z("FCP is required to calculate the SpeedIndex metric");let a=super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}static computeLayoutBasedSpeedIndex(t,n){let r=[];
for(let[s,c]of t.entries())if(s.type===et.types.CPU&&s.childEvents.some(l=>l.name==="Layout")){let l=Math.max(Math.log2(c.endTime-c.startTime),0);r.push({time:c.endTime,weight:l})}let a=r.map(s=>s.weight*Math.max(s.time,n)).reduce((s,c)=>s+c,0),o=r.map(s=>s.weight).reduce((s,c)=>s+c,0);return o?a/o:n}}});var jv={};x(jv,{BLOCKING_TIME_THRESHOLD:()=>Uv,calculateSumOfBlockingTime:()=>Bv,calculateTbtImpactForEvent:()=>pL});function pL(e,t,n,r){let a=50;if(r&&(a*=e.duration/r.duration),e.duration<a||e.end<t||e.start>n)return 0;let o=Math.max(e.start,t),c=Math.min(e.end,n)-o;return c<a?0:c-a}function Bv(e,t,n){if(n<=t)return 0;let r=0;for(let a of e)r+=pL(a,t,n);return r}var Uv,Hv=g(()=>{d();Uv=50;i(pL,"calculateTbtImpactForEvent");i(Bv,"calculateSumOfBlockingTime")});var qv,fL=g(()=>{d();or();aa();Io();Hv();qv=class e extends _n{static{i(this,"TotalBlockingTime")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new Z("missing fcpResult");if(!n.interactiveResult)throw new Z("missing interactiveResult");let r=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=n.optimistic?n.interactiveResult.optimisticEstimate.timeInMs:n.interactiveResult.pessimisticEstimate.timeInMs,o=50,s=e.getTopLevelEvents(t.nodeTimings,o);return{timeInMs:Bv(s,r,a),nodeTimings:t.nodeTimings}}static compute(t,n){if(!n?.fcpResult)throw new Z("FCP is required to calculate the TBT metric");if(!n?.fcpResult)throw new Z("Interactive is required to calculate the TBT metric");return super.compute(t,n)}static getTopLevelEvents(t,n){let r=[];for(let[a,o]of t.entries())a.type===et.types.
CPU&&(o.duration<n||r.push({start:o.startTime,end:o.endTime,duration:o.duration}));return r}}});var Ft={};x(Ft,{FirstContentfulPaint:()=>Ys,Interactive:()=>Ov,LargestContentfulPaint:()=>Pv,MaxPotentialFID:()=>Lv,Metric:()=>_n,SpeedIndex:()=>Fv,TBTUtils:()=>jv,TotalBlockingTime:()=>qv});var hL=g(()=>{d();Mv();lL();uL();dL();Io();mL();fL();Hv()});var Ui,Cf=g(()=>{d();Ui=class e{static{i(this,"TCPConnection")}warmed;ssl;h2;rtt;throughput;serverLatency;_congestionWindow;h2OverflowBytesDownloaded;constructor(t,n,r=0,a=!0,o=!1){this.warmed=!1,this.ssl=a,this.h2=o,this.rtt=t,this.throughput=n,this.serverLatency=r,this._congestionWindow=10,this.h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(t,n){let s=1e3/t*1460*8;return Math.floor(n/s)}computeMaximumCongestionWindowInSegments(){let t=this.throughput/8,n=this.rtt/1e3,r=t*n;return Math.floor(r/1460)}setThroughput(t){this.throughput=t}setCongestionWindow(t){this._congestionWindow=t}setWarmed(t){this.warmed=t}isH2(){return this.h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(t){this.h2&&(this.h2OverflowBytesDownloaded=t)}clone(){return Object.assign(new e(this.rtt,this.throughput),this)}simulateDownloadUntil(t,n){let{timeAlreadyElapsed:r=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:o=0}=n||{};this.warmed&&this.h2&&(t-=this.h2OverflowBytesDownloaded);
let s=this.rtt,c=s/2,l=this.computeMaximumCongestionWindowInSegments(),u=c;this.warmed||(u=o+c+c+c+(this.ssl?s:0));let m=Math.ceil(u/s),p=u+this.serverLatency+c;this.warmed&&this.h2&&(p=0);let f=Math.max(p-r,0),h=a-f,y=Math.min(this._congestionWindow,l),b=0;f>0?b=y*1460:m=0;let w=0,C=t-b;for(;C>0&&w<=h;){m++,w+=s,y=Math.max(Math.min(l,y*2),1);let q=y*1460;b+=q,C-=q}let k=f+w,R=this.h2?Math.max(b-t,0):0,S=Math.max(Math.min(b,t),0),_;return this.warmed?this.h2?_={timeToFirstByte:p}:_={connectionTime:u,timeToFirstByte:p}:_={dnsResolutionTime:o,connectionTime:u-o,sslTime:this.ssl?s:void 0,timeToFirstByte:p},{roundTrips:m,timeElapsed:k,bytesDownloaded:S,extraBytesDownloaded:R,congestionWindow:y,connectionTiming:_}}}});var CQ,kQ,RQ,au,zv=g(()=>{d();or();Cf();CQ=30,kQ=["https","wss"],RQ=6,au=class{static{i(this,"ConnectionPool")}options;records;connectionsByOrigin;connectionsByRequest;_connectionsInUse;connectionReusedByRequestId;constructor(t,n){this.options=n,this.records=t,this.connectionsByOrigin=new Map,this.connectionsByRequest=new Map,this._connectionsInUse=new Set,this.connectionReusedByRequestId=Oa.estimateIfConnectionWasReused(t,{forceCoarseEstimates:!0}),this.initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}initializeConnections(){let t=this.connectionReusedByRequestId,n=this.options.additionalRttByOrigin,r=this.options.serverResponseTimeByOrigin,a=Oa.groupByOrigin(this.records);for(let[o,s]of a.entries()){let c=[],l=n.get(o)||0,u=r.get(o)||CQ;for(let p of s){if(t.get(p.requestId))continue;let f=kQ.includes(p.parsedURL.scheme),h=p.protocol==="h2",y=new Ui(this.options.rtt+l,this.options.throughput,u,f,h);c.push(y)}if(!c.length)throw new Z(`Could not find \
a connection for origin: ${o}`);let m=c[0].isH2()?1:RQ;for(;c.length<m;)c.push(c[0].clone());this.connectionsByOrigin.set(o,c)}}findAvailableConnectionWithLargestCongestionWindow(t){let n=null;for(let r=0;r<t.length;r++){let a=t[r];if(this._connectionsInUse.has(a))continue;let o=n?.congestionWindow||-1/0;a.congestionWindow>o&&(n=a)}return n}acquire(t){if(this.connectionsByRequest.has(t))throw new Z("Record already has a connection");let n=t.parsedURL.securityOrigin,r=this.connectionsByOrigin.get(n)||[],a=this.findAvailableConnectionWithLargestCongestionWindow(r);return a?(this._connectionsInUse.add(a),this.connectionsByRequest.set(t,a),a):null}acquireActiveConnectionFromRequest(t){let n=this.connectionsByRequest.get(t);if(!n)throw new Z("Could not find an active connection for request");return n}release(t){let n=this.connectionsByRequest.get(t);this.connectionsByRequest.delete(t),n&&this._connectionsInUse.delete(n)}}});var _Q,ou,Gv=g(()=>{d();_Q={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:3.75,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:.9,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},ou={throttling:_Q}});var Ks,Wv=g(()=>{d();Ks=class e{static{i(this,"DNSCache")}static rttMultiplier=2;rtt;resolvedDomainNames;constructor({rtt:t}){this.rtt=t,this.resolvedDomainNames=new Map}getTimeUntilResolution(t,n){let{requestedAt:r=0,shouldUpdateCache:a=!1}=n||{},o=t.parsedURL.host,s=this.resolvedDomainNames.get(o),c=this.rtt*e.rttMultiplier;if(s){let u=Math.max(s.resolvedAt-r,0);c=Math.min(u,c)}let l=r+c;return a&&this.updateCacheResolvedAtIfNeeded(t,l),c}updateCacheResolvedAtIfNeeded(t,n){let r=t.parsedURL.host,a=this.resolvedDomainNames.get(r)||{resolvedAt:n};a.resolvedAt=Math.min(a.resolvedAt,n),this.resolvedDomainNames.set(r,a)}setResolvedAt(t,n){this.resolvedDomainNames.set(t,{resolvedAt:n})}}});var Xs,Vv=g(()=>{d();or();aa();Xs=class{static{i(this,"SimulatorTimingMap")}nodeTimings;constructor(){this.nodeTimings=new Map}getNodes(){return Array.from(this.nodeTimings.keys())}setReadyToStart(t,n){this.nodeTimings.set(t,n)}setInProgress(t,n){let r={...this.getQueued(t),startTime:n.startTime,timeElapsed:0};this.nodeTimings.set(t,t.type===et.types.NETWORK?{...r,timeElapsedOvershoot:0,bytesDownloaded:0}:r)}setCompleted(t,n){let r={...this.getInProgress(t),endTime:n.endTime,connectionTiming:n.connectionTiming};this.nodeTimings.set(t,r)}setCpu(t,n){let r={...this.getCpuStarted(t),timeElapsed:n.timeElapsed};this.nodeTimings.set(t,r)}setCpuEstimated(t,n){let r={...this.getCpuStarted(t),estimatedTimeElapsed:n.estimatedTimeElapsed};this.nodeTimings.set(t,r)}setNetwork(t,n){let r={...this.getNetworkStarted(t),timeElapsed:n.timeElapsed,timeElapsedOvershoot:n.timeElapsedOvershoot,bytesDownloaded:n.bytesDownloaded};this.nodeTimings.set(t,r)}setNetworkEstimated(t,n){let r={...this.getNetworkStarted(
t),estimatedTimeElapsed:n.estimatedTimeElapsed};this.nodeTimings.set(t,r)}getQueued(t){let n=this.nodeTimings.get(t);if(!n)throw new Z(`Node ${t.id} not yet queued`);return n}getCpuStarted(t){let n=this.nodeTimings.get(t);if(!n)throw new Z(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Z(`Node ${t.id} not yet started`);if("bytesDownloaded"in n)throw new Z(`Node ${t.id} timing not valid`);return n}getNetworkStarted(t){let n=this.nodeTimings.get(t);if(!n)throw new Z(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Z(`Node ${t.id} not yet started`);if(!("bytesDownloaded"in n))throw new Z(`Node ${t.id} timing not valid`);return n}getInProgress(t){let n=this.nodeTimings.get(t);if(!n)throw new Z(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new Z(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new Z(`Node ${t.id} not yet in progress`);return n}getCompleted(t){let n=this.nodeTimings.get(t);if(!n)throw new Z(`Node ${t.id} not ye\
t queued`);if(!("startTime"in n))throw new Z(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new Z(`Node ${t.id} not yet in progress`);if(!("endTime"in n))throw new Z(`Node ${t.id} not yet completed`);return n}}});var $v,IQ,DQ,AQ,yr,NQ,gL,Yv,yL=g(()=>{d();or();aa();zv();Gv();Wv();Vv();Cf();$v=ou.throttling.mobileSlow4G,IQ=10,DQ=.5,AQ=1e4,yr={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},NQ={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},gL=new Map,Yv=class e{static{i(this,"Simulator")}static createSimulator(t){let{throttlingMethod:n,throttling:r,precomputedLanternData:a,networkAnalysis:o}=t,s={additionalRttByOrigin:o.additionalRttByOrigin,serverResponseTimeByOrigin:o.serverResponseTimeByOrigin,observedThroughput:o.throughput};switch(a&&(s.additionalRttByOrigin=new Map(Object.entries(a.additionalRttByOrigin)),s.serverResponseTimeByOrigin=new Map(Object.entries(a.serverResponseTimeByOrigin))),n){case"provided":s.rtt=o.rtt,s.throughput=o.throughput,s.cpuSlowdownMultiplier=1,s.layoutTaskMultiplier=1;break;case"devtools":r&&(s.rtt=r.requestLatencyMs/ou.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,s.throughput=r.downloadThroughputKbps*1024/ou.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),
s.cpuSlowdownMultiplier=1,s.layoutTaskMultiplier=1;break;case"simulate":r&&(s.rtt=r.rttMs,s.throughput=r.throughputKbps*1024,s.cpuSlowdownMultiplier=r.cpuSlowdownMultiplier);break;default:break}return new e(s)}options;_rtt;throughput;maximumConcurrentRequests;cpuSlowdownMultiplier;layoutTaskMultiplier;cachedNodeListByStartPosition;nodeTimings;numberInProgressByType;nodes;dns;connectionPool;constructor(t){if(this.options=Object.assign({rtt:$v.rttMs,throughput:$v.throughputKbps*1024,maximumConcurrentRequests:IQ,cpuSlowdownMultiplier:$v.cpuSlowdownMultiplier,layoutTaskMultiplier:DQ,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},t),this._rtt=this.options.rtt,this.throughput=this.options.throughput,this.maximumConcurrentRequests=Math.max(Math.min(Ui.maximumSaturatedConnections(this._rtt,this.throughput),this.options.maximumConcurrentRequests),1),this.cpuSlowdownMultiplier=this.options.cpuSlowdownMultiplier,this.layoutTaskMultiplier=this.cpuSlowdownMultiplier*this.options.
layoutTaskMultiplier,this.cachedNodeListByStartPosition=[],this.nodeTimings=new Xs,this.numberInProgressByType=new Map,this.nodes={},this.dns=new Ks({rtt:this._rtt}),this.connectionPool=null,!Number.isFinite(this._rtt))throw new Z(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this.throughput))throw new Z(`Invalid throughput ${this.throughput}`)}get rtt(){return this._rtt}initializeConnectionPool(t){let n=[];t.getRootNode().traverse(r=>{r.type===et.types.NETWORK&&n.push(r.request)}),this.connectionPool=new au(n,this.options)}initializeAuxiliaryData(){this.nodeTimings=new Xs,this.numberInProgressByType=new Map,this.nodes={},this.cachedNodeListByStartPosition=[];for(let t of Object.values(yr))this.nodes[t]=new Set}numberInProgress(t){return this.numberInProgressByType.get(t)||0}markNodeAsReadyToStart(t,n){let r=e.computeNodeStartPosition(t),a=this.cachedNodeListByStartPosition.findIndex(s=>e.computeNodeStartPosition(s)>r),o=a===-1?this.cachedNodeListByStartPosition.length:a;this.cachedNodeListByStartPosition.
splice(o,0,t),this.nodes[yr.ReadyToStart].add(t),this.nodes[yr.NotReadyToStart].delete(t),this.nodeTimings.setReadyToStart(t,{queuedTime:n})}markNodeAsInProgress(t,n){let r=this.cachedNodeListByStartPosition.indexOf(t);this.cachedNodeListByStartPosition.splice(r,1),this.nodes[yr.InProgress].add(t),this.nodes[yr.ReadyToStart].delete(t),this.numberInProgressByType.set(t.type,this.numberInProgress(t.type)+1),this.nodeTimings.setInProgress(t,{startTime:n})}markNodeAsComplete(t,n,r){this.nodes[yr.Complete].add(t),this.nodes[yr.InProgress].delete(t),this.numberInProgressByType.set(t.type,this.numberInProgress(t.type)-1),this.nodeTimings.setCompleted(t,{endTime:n,connectionTiming:r});for(let a of t.getDependents())a.getDependencies().some(s=>!this.nodes[yr.Complete].has(s))||this.markNodeAsReadyToStart(a,n)}acquireConnection(t){return this.connectionPool.acquire(t)}getNodesSortedByStartPosition(){return Array.from(this.cachedNodeListByStartPosition)}startNodeIfPossible(t,n){if(t.type===et.types.
CPU){this.numberInProgress(t.type)===0&&this.markNodeAsInProgress(t,n);return}if(t.type!==et.types.NETWORK)throw new Z("Unsupported");!t.isConnectionless&&(this.numberInProgress(t.type)>=this.maximumConcurrentRequests||!this.acquireConnection(t.request))||this.markNodeAsInProgress(t,n)}updateNetworkCapacity(){let t=this.numberInProgress(et.types.NETWORK);if(t!==0)for(let n of this.connectionPool.connectionsInUse())n.setThroughput(this.throughput/t)}estimateTimeRemaining(t){if(t.type===et.types.CPU)return this.estimateCPUTimeRemaining(t);if(t.type===et.types.NETWORK)return this.estimateNetworkTimeRemaining(t);throw new Z("Unsupported")}estimateCPUTimeRemaining(t){let n=this.nodeTimings.getCpuStarted(t),r=t.didPerformLayout()?this.layoutTaskMultiplier:this.cpuSlowdownMultiplier,o=Math.min(Math.round(t.duration/1e3*r),AQ)-n.timeElapsed;return this.nodeTimings.setCpuEstimated(t,{estimatedTimeElapsed:o}),o}estimateNetworkTimeRemaining(t){let n=t.request,r=this.nodeTimings.getNetworkStarted(
t),a=0;if(t.fromDiskCache)a=8+20*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else if(t.isNonNetworkProtocol)a=2+10*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else{let s=this.connectionPool.acquireActiveConnectionFromRequest(n),c=this.dns.getTimeUntilResolution(n,{requestedAt:r.startTime,shouldUpdateCache:!0}),l=r.timeElapsed;a=s.simulateDownloadUntil(n.transferSize-r.bytesDownloaded,{timeAlreadyElapsed:l,dnsResolutionTime:c,maximumTimeToElapse:1/0}).timeElapsed}let o=a+r.timeElapsedOvershoot;return this.nodeTimings.setNetworkEstimated(t,{estimatedTimeElapsed:o}),o}findNextNodeCompletionTime(){let t=1/0;for(let n of this.nodes[yr.InProgress])t=Math.min(t,this.estimateTimeRemaining(n));return t}updateProgressMadeInTimePeriod(t,n,r){let a=this.nodeTimings.getInProgress(t),o=a.estimatedTimeElapsed===n;if(t.type===et.types.CPU||t.isConnectionless){o?this.markNodeAsComplete(t,r):a.timeElapsed+=n;return}if(t.type!==et.types.NETWORK)throw new Z("Unsupported");if(!("bytesDownloaded"in a))throw new Z(
"Invalid timing data");let s=t.request,c=this.connectionPool.acquireActiveConnectionFromRequest(s),l=this.dns.getTimeUntilResolution(s,{requestedAt:a.startTime,shouldUpdateCache:!0}),u=c.simulateDownloadUntil(s.transferSize-a.bytesDownloaded,{dnsResolutionTime:l,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:n-a.timeElapsedOvershoot});c.setCongestionWindow(u.congestionWindow),c.setH2OverflowBytesDownloaded(u.extraBytesDownloaded),o?(c.setWarmed(!0),this.connectionPool.release(s),this.markNodeAsComplete(t,r,u.connectionTiming)):(a.timeElapsed+=u.timeElapsed,a.timeElapsedOvershoot+=u.timeElapsed-n,a.bytesDownloaded+=u.bytesDownloaded)}computeFinalNodeTimings(){let t=this.nodeTimings.getNodes().map(r=>[r,this.nodeTimings.getCompleted(r)]);t.sort((r,a)=>r[1].startTime-a[1].startTime);let n=t.map(([r,a])=>[r,{startTime:a.startTime,endTime:a.endTime,duration:a.endTime-a.startTime}]);return{nodeTimings:new Map(n),completeNodeTimings:new Map(t)}}getOptions(){return this.options}simulate(t,n){
if(et.findCycle(t))throw new Z("Cannot simulate graph with cycle");n=Object.assign({label:void 0},n),this.dns=new Ks({rtt:this._rtt}),this.initializeConnectionPool(t),this.initializeAuxiliaryData();let r=this.nodes[yr.NotReadyToStart],a=this.nodes[yr.ReadyToStart],o=this.nodes[yr.InProgress],s=t.getRootNode();s.traverse(p=>r.add(p));let c=0,l=0;for(this.markNodeAsReadyToStart(s,c);a.size||o.size;){for(let f of this.getNodesSortedByStartPosition())this.startNodeIfPossible(f,c);if(!o.size)throw new Z("Failed to start a node");this.updateNetworkCapacity();let p=this.findNextNodeCompletionTime();if(c+=p,!Number.isFinite(p)||l>1e5)throw new Z("Simulation failed, depth exceeded");l++;for(let f of o)this.updateProgressMadeInTimePeriod(f,p,c)}let{nodeTimings:u,completeNodeTimings:m}=this.computeFinalNodeTimings();return gL.set(n.label||"unlabeled",m),{timeInMs:c,nodeTimings:u}}computeWastedMsFromWastedBytes(t){let{throughput:n,observedThroughput:r}=this.options,a=n===0?r:n;if(a===0)return 0;let s=t*
8/a*1e3;return Math.round(s/10)*10}static get allNodeTimings(){return gL}static computeNodeStartPosition(t){return t.type==="cpu"?t.startTime:t.startTime+(NQ[t.request.priority]*1e3*1e3||0)}}});var Pa={};x(Pa,{ConnectionPool:()=>au,Constants:()=>ou,DNSCache:()=>Ks,Simulator:()=>Yv,SimulatorTimingMap:()=>Xs,TCPConnection:()=>Ui});var vL=g(()=>{d();zv();Gv();Wv();Vv();yL();Cf()});var MQ,bL=g(()=>{d();MQ={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch",FedCM:"FedCM"}});var iu={};x(iu,{NetworkRequestTypes:()=>MQ});var wL=g(()=>{d();bL()});var su=g(()=>{d();or();aa();hL();vL();wL()});var kL=ve((DAe,CL)=>{d();var EL=/:\/\/(\S*?)(:\d+)?(\/|$)/,TL=/([a-z0-9.-]+\.[a-z0-9]+|localhost)/i,OQ=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,PQ=/[^.]+\.([^.]+|(gov|com|co|ne)\.\w{2})$/i;function xL(e){return typeof e!="string"||e.length>1e4||e.startsWith("data:")?null:EL.test(e)?e.match(EL)[1]:TL.test(e)?e.match(TL)[0]:null}i(xL,"getDomainFromOriginOrURL");function Xv(e){let t=xL(e);if(!t)return null;if(OQ.test(t))return t;let n=t.match(PQ);return n&&n[0]||t}i(Xv,"getRootDomain");function LQ(e,t){return e.length<=t.length?e:e.split(".").slice(1).join(".")}i(LQ,"sliceSubdomainFromDomain");function SL(e,t,n,r){let a=xL(r),o=Xv(a);if(!(!a||!o)){if(e.has(a))return e.get(a);for(let s=a;s.length>o.length;s=LQ(s,o))if(t.has(s))return t.get(s);if(n.has(o))return n.get(o)}}i(SL,"getEntityInDataset");function FQ(e,t,n,r){let a=SL(e,t,n,r),o=a&&a.products;if(o&&typeof r=="string"){for(let s of o)for(let c of s.urlPatterns)if(c instanceof RegExp&&c.test(r)||typeof c=="string"&&r.includes(c))return s}}
i(FQ,"getProductInDataset");function UQ(e){return e.map(t=>{let n={company:t.name,categories:[t.category],...t},r=(t.products||[]).map(a=>({company:n.company,category:n.category,categories:[n.category],facades:[],...a,urlPatterns:(a.urlPatterns||[]).map(o=>o.startsWith("REGEXP:")?new RegExp(o.slice(7)):o)}));return n.products=r,n})}i(UQ,"cloneEntities");function BQ(e){let t=UQ(e),n=new Map,r=new Map,a=new Map;for(let c of t){c.totalExecutionTime=Number(c.totalExecutionTime)||0,c.totalOccurrences=Number(c.totalOccurrences)||0,c.averageExecutionTime=c.totalExecutionTime/c.totalOccurrences;for(let l of c.domains){if(n.has(l)){let m=n.get(l);throw new Error(`Duplicate domain ${l} (${c.name} and ${m.name})`)}n.set(l,c);let u=Xv(l);if(l.startsWith("*.")){let m=l.slice(2);m===u?r.set(u,c):a.set(m,c)}}}for(let[c,l]of r.entries())l||r.delete(c);let o=SL.bind(null,n,a,r),s=FQ.bind(null,n,a,r);return{getEntity:o,getProduct:s,getRootDomain:Xv,entities:t}}i(BQ,"createAPIFromDataset");CL.exports={createAPIFromDataset:BQ}});var RL=ve((MAe,jQ)=>{jQ.exports=[{name:"Google/Doubleclick Ads",company:"Google",homepage:"https://marketingplatform.google.com/about/enterprise/",category:"ad",domains:["adservice.google.com","adservice.google.com.au","adservice.google.com.sg","adservice.google.com.br","adservice.google.com.ua","adservice.google.co.uk","adservice.google.co.jp","adservice.google.co.in","adservice.google.co.kr","adservice.google.co.id","adservice.google.co.nz","adservice.google.ie","adservice.google.se","adservice.google.de","adservice.google.ca","adservice.google.be","adservice.google.es","adservice.google.ch","adservice.google.fr","adservice.google.nl","*.googleadservices.com","*.googlesyndication.com","*.googletagservices.com","*.2mdn.net","*.doubleclick.net"],examples:["pagead2.googlesyndication.com","tpc.googlesyndication.com","ade.googlesyndication.com","googleads.g.doubleclick.net","googleads4.g.doubleclick.net","securepubads.g.doubleclick.net","pubads.g.doubleclick.net","static.doubleclick.net",
"cm.g.doubleclick.net","bid.g.doubleclick.net","s0.2mdn.net","stats.g.doubleclick.net","survey.g.doubleclick.net","fls.doubleclick.net","ad.doubleclick.net","www.googleadservices.com","https://www.googletagservices.com/tag/js/gpt.js"],totalExecutionTime:3224311743,totalOccurrences:1232210},{name:"Facebook",homepage:"https://www.facebook.com",category:"social",domains:["*.facebook.com","*.atlassbx.com","*.fbsbx.com","fbcdn-photos-e-a.akamaihd.net","*.facebook.net","*.fbcdn.net"],examples:["www.facebook.com","connect.facebook.net","staticxx.facebook.com","static.xx.fbcdn.net","m.facebook.com","an.facebook.com","platform-lookaside.fbsbx.com"],products:[{name:"Facebook Messenger Customer Chat",urlPatterns:["REGEXP:connect\\.facebook\\.net\\/.*\\/sdk\\/xfbml\\.customerchat\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],totalExecutionTime:1097107210,totalOccurrences:3157799},{name:"Instagram",homepage:"https://www.instagram.com",
category:"social",domains:["*.cdninstagram.com","*.instagram.com"],examples:["scontent.cdninstagram.com"],totalExecutionTime:31988464,totalOccurrences:20376},{name:"Google CDN",company:"Google",homepage:"https://developers.google.com/speed/libraries/",category:"cdn",domains:["ajax.googleapis.com","commondatastorage.googleapis.com","www.gstatic.com","ssl.gstatic.com"],totalExecutionTime:4805631169,totalOccurrences:3192326},{name:"Google Maps",company:"Google",homepage:"https://www.google.com/maps",category:"utility",domains:["maps.google.com","maps-api-ssl.google.com","maps.googleapis.com","mts.googleapis.com","mt.googleapis.com","mt0.googleapis.com","mt1.googleapis.com","mt2.googleapis.com","mt3.googleapis.com","khm0.googleapis.com","khm1.googleapis.com","khms.googleapis.com","khms1.googleapis.com","khms2.googleapis.com","maps.gstatic.com"],totalExecutionTime:904392768,totalOccurrences:1195850},{name:"Other Google APIs/SDKs",company:"Google",homepage:"https://developers.google.com/apis\
-explorer/#p/",category:"utility",domains:["accounts.google.com","apis.google.com","calendar.google.com","clients2.google.com","cse.google.com","news.google.com","pay.google.com","payments.google.com","play.google.com","smartlock.google.com","www.google.com","www.google.de","www.google.co.jp","www.google.com.au","www.google.co.uk","www.google.ie","www.google.com.sg","www.google.co.in","www.google.com.br","www.google.ca","www.google.co.kr","www.google.co.nz","www.google.co.id","www.google.fr","www.google.be","www.google.com.ua","www.google.nl","www.google.ru","www.google.se","www.googleapis.com","imasdk.googleapis.com","storage.googleapis.com","translate.googleapis.com","translate.google.com","translate-pa.googleapis.com","lh3.googleusercontent.com","jnn-pa.googleapis.com","csi.gstatic.com"],totalExecutionTime:1158368443,totalOccurrences:2638940},{name:"Firebase",homepage:"https://developers.google.com/apis-explorer/#p/",category:"utility",domains:["firebasestorage.googleapis.com","fire\
store.googleapis.com","firebaseinstallations.googleapis.com","firebase.googleapis.com","firebaseremoteconfig.googleapis.com"],totalExecutionTime:201194,totalOccurrences:493},{name:"Google Analytics",company:"Google",homepage:"https://marketingplatform.google.com/about/analytics/",category:"analytics",domains:["*.google-analytics.com","*.urchin.com","analytics.google.com"],examples:["www.google-analytics.com","ssl.google-analytics.com","analytics.google.com/g/collect"],totalExecutionTime:495649535,totalOccurrences:4231882},{name:"Google Optimize",company:"Google",homepage:"https://marketingplatform.google.com/about/optimize/",category:"analytics",domains:["www.googleoptimize.com"],examples:["https://www.googleoptimize.com/optimize.js?id="],totalExecutionTime:9330261,totalOccurrences:38797},{name:"Google AMP",company:"Google",homepage:"https://github.com/google/amp-client-id-library",category:"analytics",domains:["ampcid.google.com"]},{name:"Google Tag Manager",company:"Google",homepage:"\
https://marketingplatform.google.com/about/tag-manager/",category:"tag-manager",domains:["*.googletagmanager.com"],examples:["www.googletagmanager.com"],totalExecutionTime:6770912735,totalOccurrences:8124119},{name:"Google Fonts",company:"Google",homepage:"https://fonts.google.com/",category:"cdn",domains:["fonts.googleapis.com","fonts.gstatic.com"],totalExecutionTime:53081,totalOccurrences:220864},{name:"Adobe TypeKit",company:"Adobe",homepage:"https://fonts.adobe.com/",category:"cdn",domains:["*.typekit.com","*.typekit.net"],examples:["use.typekit.net","p.typekit.net"],totalExecutionTime:78981507,totalOccurrences:119621},{name:"YouTube",homepage:"https://youtube.com",category:"video",domains:["*.youtube.com","*.ggpht.com","*.youtube-nocookie.com","*.ytimg.com"],examples:["www.youtube.com","s.ytimg.com","yt3.ggpht.com","img.youtube.com","fcmatch.youtube.com"],products:[{name:"YouTube Embedded Player",urlPatterns:["youtube.com/embed/"],facades:[{name:"Lite YouTube",repo:"https://github\
.com/paulirish/lite-youtube-embed"},{name:"Ngx Lite Video",repo:"https://github.com/karim-mamdouh/ngx-lite-video"}]}],totalExecutionTime:6277579675,totalOccurrences:977311},{name:"Twitter",homepage:"https://twitter.com",category:"social",domains:["*.vine.co","*.twimg.com","*.twitpic.com","platform.twitter.com","syndication.twitter.com"],examples:["cdn.syndication.twimg.com","abs.twimg.com","pbs.twimg.com"],totalExecutionTime:804233203,totalOccurrences:319957},{name:"AddThis",homepage:"https://www.addthis.com/",category:"social",domains:["*.addthis.com","*.addthiscdn.com","*.addthisedge.com"],examples:["s7.addthis.com","r.dlx.addthis.com","su.addthis.com","x.dlx.addthis.com"],totalExecutionTime:23,totalOccurrences:42},{name:"AddToAny",homepage:"https://www.addtoany.com/",category:"social",domains:["*.addtoany.com"],examples:["static.addtoany.com"],totalExecutionTime:10606113,totalOccurrences:66065},{name:"Akamai",homepage:"https://www.akamai.com/",category:"cdn",domains:["23.62.3.183","\
*.akamaitechnologies.com","*.akamaitechnologies.fr","*.akamai.net","*.akamaiedge.net","*.akamaihd.net","*.akamaized.net","*.edgefcs.net","*.edgekey.net","edgesuite.net","*.srip.net"],totalExecutionTime:4795669,totalOccurrences:9820},{name:"Blogger",homepage:"https://www.blogger.com/",category:"hosting",domains:["*.blogblog.com","*.blogger.com","*.blogspot.com","images-blogger-opensocial.googleusercontent.com"],examples:["1.bp.blogspot.com","www.blogger.com"],totalExecutionTime:58390438,totalOccurrences:213326},{name:"Gravatar",homepage:"https://en.gravatar.com/",category:"social",domains:["*.gravatar.com"],examples:["secure.gravatar.com","www.gravatar.com"],totalExecutionTime:9235,totalOccurrences:43},{name:"Yandex Metrica",company:"Yandex",homepage:"https://metrica.yandex.com/about?",category:"analytics",domains:["mc.yandex.ru","mc.yandex.com","d31j93rd8oukbv.cloudfront.net"],totalExecutionTime:1438544698,totalOccurrences:602136},{name:"Hotjar",homepage:"https://www.hotjar.com/",category:"\
analytics",domains:["*.hotjar.com","*.hotjar.io"],examples:["script.hotjar.com","static.hotjar.com","in.hotjar.com","vc.hotjar.io","vars.hotjar.com"],totalExecutionTime:241418055,totalOccurrences:333356},{name:"Baidu Analytics",homepage:"https://tongji.baidu.com/web/welcome/login",category:"analytics",domains:["hm.baidu.com","hmcdn.baidu.com"],examples:["hm.baidu.com","hmcdn.baidu.com"],totalExecutionTime:7739347,totalOccurrences:32612},{name:"Insider",homepage:"",category:"analytics",domains:["*.useinsider.com"],examples:["hit.api.useinsider.com"],totalExecutionTime:2214966,totalOccurrences:1861},{name:"Adobe Experience Cloud",company:"Adobe",homepage:"",category:"analytics",domains:["*.2o7.net","du8783wkf05yr.cloudfront.net","*.hitbox.com","*.imageg.net","*.nedstat.com","*.omtrdc.net"],examples:["audiag.112.2o7.net","du8783wkf05yr.cloudfront.net/NS_mbox.js"],totalExecutionTime:2369,totalOccurrences:38},{name:"Adobe Tag Manager",company:"Adobe",homepage:"https://www.adobe.com/experien\
ce-platform/",category:"tag-manager",domains:["*.adobedtm.com","*.demdex.net","*.everesttech.net","sstats.adobe.com","hbrt.adobe.com"],examples:["assets.adobedtm.com","sync-tm.everesttech.net","cm.everesttech.net"],totalExecutionTime:34937564,totalOccurrences:200160},{name:"jQuery CDN",homepage:"https://code.jquery.com/",category:"cdn",domains:["*.jquery.com"],examples:["code.jquery.com"],totalExecutionTime:302334055,totalOccurrences:724477},{name:"Cloudflare CDN",homepage:"https://cdnjs.com/",category:"cdn",domains:["cdnjs.cloudflare.com","amp.cloudflare.com"],totalExecutionTime:337711119,totalOccurrences:666628},{name:"Cloudflare",homepage:"https://www.cloudflare.com/website-optimization/",category:"utility",domains:["ajax.cloudflare.com","*.nel.cloudflare.com","static.cloudflareinsights.com"],totalExecutionTime:58723052,totalOccurrences:467719},{name:"WordPress",company:"Automattic",homepage:"https://wp.com/",category:"hosting",domains:["*.wordpress.com","s0.wp.com","s2.wp.com","*.w\
.org","c0.wp.com","s1.wp.com","i0.wp.com","i1.wp.com","i2.wp.com","widgets.wp.com"],examples:["s.w.org"],totalExecutionTime:220910650,totalOccurrences:308694},{name:"WordPress Site Stats",company:"Automattic",homepage:"https://wp.com/",category:"analytics",domains:["pixel.wp.com","stats.wp.com"],totalExecutionTime:8573549,totalOccurrences:128931},{name:"Hatena Blog",homepage:"https://hatenablog.com/",category:"hosting",domains:["*.st-hatena.com","*.hatena.ne.jp"],examples:["cdn.blog.st-hatena.com","cdn.pool.st-hatena.com","cdn7.www.st-hatena.com","s.hatena.ne.jp","b.st-hatena.com"],totalExecutionTime:106337940,totalOccurrences:43183},{name:"Shopify",homepage:"https://www.shopify.com/",category:"hosting",domains:["*.shopify.com","*.shopifyapps.com","*.shopifycdn.com","*.shopifysvc.com"],examples:["cdn.shopify.com","productreviews.shopifycdn.com","monorail-edge.shopifysvc.com"],totalExecutionTime:287428893,totalOccurrences:338668},{name:"Dealer",homepage:"https://www.dealer.com/",category:"\
hosting",domains:["*.dealer.com"],examples:["static.dealer.com"],totalExecutionTime:871324,totalOccurrences:2620},{name:"PIXNET",homepage:"https://www.pixnet.net/",category:"social",domains:["*.pixfs.net","*.pixnet.net"],examples:["front.pixfs.net","falcon-asset.pixfs.net","pixgame-asset.pixfs.net"],totalExecutionTime:18541448,totalOccurrences:13718},{name:"Moat",homepage:"https://moat.com/",category:"ad",domains:["*.moatads.com","*.moatpixel.com"],examples:["z.moatads.com","px.moatads.com","geo.moatads.com","sejs.moatads.com","mb.moatads.com","v4.moatads.com"]},{name:"33 Across",homepage:"https://33across.com/",category:"ad",domains:["*.33across.com"],examples:["sic.33across.com","cdn-sic.33across.com"],totalExecutionTime:10002146,totalOccurrences:192648},{name:"OpenX",homepage:"https://www.openx.com/",category:"ad",domains:["*.deliverimp.com","*.openxadexchange.com","*.servedbyopenx.com","*.jump-time.net","*.openx.net","*.openxcdn.net"],examples:["uk-ads.openx.net","us-ads.openx.net",
"33across-d.openx.net","rtb.openx.net","us-u.openx.net","eu-u.openx.net","u.openx.net"],totalExecutionTime:6274934,totalOccurrences:76561},{name:"Amazon Ads",homepage:"https://ad.amazon.com/",category:"ad",domains:["*.amazon-adsystem.com"],examples:["s.amazon-adsystem.com","c.amazon-adsystem.com","aax.amazon-adsystem.com","z-na.amazon-adsystem.com","fls-na.amazon-adsystem.com","aax-us-east.amazon-adsystem.com","ir-na.amazon-adsystem.com"],totalExecutionTime:98703856,totalOccurrences:240331},{name:"Rubicon Project",homepage:"https://rubiconproject.com/",category:"ad",domains:["*.rubiconproject.com","*.chango.com","*.fimserve.com"],examples:["pixel.rubiconproject.com","fastlane.rubiconproject.com","secure-assets.rubiconproject.com","eus.rubiconproject.com","pixel-us-east.rubiconproject.com","token.rubiconproject.com","ads.rubiconproject.com"],totalExecutionTime:287111007,totalOccurrences:270271},{name:"The Trade Desk",homepage:"https://www.thetradedesk.com/",category:"ad",domains:["*.ads\
rvr.org","d1eoo1tco6rr5e.cloudfront.net"],examples:["js.adsrvr.org","match.adsrvr.org","insight.adsrvr.org","usw-lax.adsrvr.org","data.adsrvr.org","snap.adsrvr.org"],totalExecutionTime:2197325,totalOccurrences:25346},{name:"Bidswitch",homepage:"https://www.bidswitch.com/",category:"ad",domains:["*.bidswitch.net"],examples:["x.bidswitch.net"],totalExecutionTime:25660,totalOccurrences:68217},{name:"LiveRamp IdentityLink",homepage:"https://liveramp.com/discover-identitylink/",category:"analytics",domains:["*.circulate.com","*.rlcdn.com"],examples:["idsync.rlcdn.com","id.rlcdn.com","api.rlcdn.com","cdn.rlcdn.com"],totalExecutionTime:141414,totalOccurrences:1461},{name:"Drawbridge",homepage:"https://www.drawbridge.com/",category:"ad",domains:["*.adsymptotic.com"]},{name:"AOL / Oath / Verizon Media",homepage:"https://www.oath.com/",category:"ad",domains:["*.advertising.com","*.aol.com","*.aolcdn.com","*.blogsmithmedia.com","*.oath.com","*.aol.net","*.tacoda.net","*.aol.co.uk"],examples:["pix\
el.advertising.com","dtm.advertising.com","tag.sp.advertising.com","service.sp.advertising.com","adtech.advertising.com","adaptv.advertising.com","mighty.aol.net","consent.cmp.oath.com"],totalExecutionTime:165968,totalOccurrences:278},{name:"Xaxis",homepage:"https://www.xaxis.com/",category:"ad",domains:["*.247realmedia.com","*.mookie1.com","*.gmads.net"],examples:["t.mookie1.com","odr.mookie1.com"],totalExecutionTime:28343,totalOccurrences:209},{name:"Freshdesk",company:"Freshworks",homepage:"https://freshdesk.com/",category:"customer-success",domains:["d36mpcpuzc4ztk.cloudfront.net"],totalExecutionTime:64296,totalOccurrences:225},{name:"Help Scout",homepage:"https://www.helpscout.net/",category:"customer-success",domains:["djtflbt20bdde.cloudfront.net","*.helpscout.net"],examples:["beacon-v2.helpscout.net"],products:[{name:"Help Scout Beacon",urlPatterns:["beacon-v2.helpscout.net"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],
totalExecutionTime:2186050,totalOccurrences:4906},{name:"Alexa",homepage:"https://www.alexa.com/",category:"analytics",domains:["*.alexametrics.com","d31qbv1cthcecs.cloudfront.net"],examples:["certify.alexametrics.com"]},{name:"OneSignal",homepage:"https://onesignal.com/",category:"utility",domains:["*.onesignal.com"],examples:["cdn.onesignal.com","https://onesignal.com/api/v1/sync/"],totalExecutionTime:17761218,totalOccurrences:68282},{name:"Lucky Orange",homepage:"https://www.luckyorange.com/",category:"analytics",domains:["*.luckyorange.com","d10lpsik1i8c69.cloudfront.net","*.luckyorange.net"],totalExecutionTime:12779009,totalOccurrences:16442},{name:"Crazy Egg",homepage:"https://www.crazyegg.com/",category:"analytics",domains:["*.cetrk.com","*.crazyegg.com","dnn506yrbagrg.cloudfront.net"],totalExecutionTime:27593244,totalOccurrences:43822},{name:"Hello Bar",homepage:"https://www.hellobar.com/",category:"marketing",domains:["*.hellobar.com"],totalExecutionTime:1533955,totalOccurrences:4502},
{name:"Yandex Ads",company:"Yandex",homepage:"https://yandex.com/adv/",category:"ad",domains:["an.yandex.ru"],totalExecutionTime:5171537,totalOccurrences:8488},{name:"Salesforce",homepage:"https://www.salesforce.com/products/marketing-cloud/",category:"analytics",domains:["*.krxd.net"],examples:["cdn.krxd.net","beacon.krxd.net","consumer.krxd.net","usermatch.krxd.net"]},{name:"Salesforce Commerce Cloud",homepage:"https://www.salesforce.com/products/commerce-cloud/overview/",category:"hosting",domains:["*.cquotient.com","*.demandware.net","demandware.edgesuite.net"],totalExecutionTime:2045309,totalOccurrences:4127},{name:"Optimizely",homepage:"https://www.optimizely.com/",category:"analytics",domains:["*.optimizely.com"],examples:["cdn.optimizely.com","cdn-pci.optimizely.com","logx.optimizely.com","cdn3.optimizely.com"],totalExecutionTime:12599739,totalOccurrences:15998},{name:"LiveChat",homepage:"https://www.livechat.com/",category:"customer-success",domains:["*.livechatinc.com","*.liv\
echat.com","*.livechat-static.com"],examples:["cdn.livechatinc.com","secure.livechatinc.com"],totalExecutionTime:49171416,totalOccurrences:39034},{name:"VK",homepage:"https://vk.com/",category:"social",domains:["*.vk.com"],totalExecutionTime:91334176,totalOccurrences:22377},{name:"Tumblr",homepage:"https://tumblr.com/",category:"social",domains:["*.tumblr.com"],examples:["assets.tumblr.com","static.tumblr.com"],totalExecutionTime:45570825,totalOccurrences:18114},{name:"Wistia",homepage:"https://wistia.com/",category:"video",domains:["*.wistia.com","embedwistia-a.akamaihd.net","*.wistia.net"],examples:["fast.wistia.com","fast.wistia.net","distillery.wistia.com","pipedream.wistia.com"],totalExecutionTime:115722112,totalOccurrences:27059},{name:"Brightcove",homepage:"https://www.brightcove.com/en/",category:"video",domains:["*.brightcove.com","*.brightcove.net","*.zencdn.net"],examples:["vjs.zencdn.net","players.brightcove.net"],totalExecutionTime:15099708,totalOccurrences:13745},{name:"J\
SDelivr CDN",homepage:"https://www.jsdelivr.com/",category:"cdn",domains:["*.jsdelivr.net"],examples:["cdn.jsdelivr.net"],totalExecutionTime:260364458,totalOccurrences:399959},{name:"Sumo",homepage:"https://sumo.com/",category:"marketing",domains:["*.sumo.com","*.sumome.com","sumo.b-cdn.net"],examples:["sumo.b-cdn.net","load.sumo.com","load.sumome.com"],totalExecutionTime:16489977,totalOccurrences:10901},{name:"Vimeo",homepage:"https://vimeo.com/",category:"video",domains:["*.vimeo.com","*.vimeocdn.com"],examples:["f.vimeocdn.com","player.vimeo.com","i.vimeocdn.com"],products:[{name:"Vimeo Embedded Player",urlPatterns:["player.vimeo.com/video/"],facades:[{name:"Lite Vimeo",repo:"https://github.com/slightlyoff/lite-vimeo"},{name:"Lite Vimeo Embed",repo:"https://github.com/luwes/lite-vimeo-embed"},{name:"Ngx Lite Video",repo:"https://github.com/karim-mamdouh/ngx-lite-video"}]}],totalExecutionTime:263943622,totalOccurrences:120397},{name:"Disqus",homepage:"https://disqus.com/",category:"s\
ocial",domains:["*.disqus.com","*.disquscdn.com"],examples:["c.disquscdn.com"],totalExecutionTime:3697272,totalOccurrences:1775},{name:"Yandex APIs",company:"Yandex",homepage:"https://yandex.ru/",category:"utility",domains:["api-maps.yandex.ru","money.yandex.ru"],totalExecutionTime:40765111,totalOccurrences:51601},{name:"Yandex CDN",company:"Yandex",homepage:"https://yandex.ru/",category:"cdn",domains:["*.yandex.st","*.yastatic.net"],examples:["https://yastatic.net/share2/share.js","https://yastatic.net/jquery/2.1.4/jquery.min.js"]},{name:"Integral Ad Science",homepage:"https://integralads.com/uk/",category:"ad",domains:["*.adsafeprotected.com","*.iasds01.com"],examples:["pixel.adsafeprotected.com","static.adsafeprotected.com","fw.adsafeprotected.com","cdn.adsafeprotected.com","dt.adsafeprotected.com"],totalExecutionTime:88554254,totalOccurrences:21660},{name:"Tealium",homepage:"https://tealium.com/",category:"tag-manager",domains:["*.aniview.com","*.delvenetworks.com","*.limelight.com",
"*.tiqcdn.com","*.llnwd.net","*.tealiumiq.com"],examples:["tags.tiqcdn.com","tealium.hs.llnwd.net","link.videoplatform.limelight.com","datacloud.tealiumiq.com"],totalExecutionTime:20176561,totalOccurrences:75434},{name:"Pubmatic",homepage:"https://pubmatic.com/",category:"ad",domains:["*.pubmatic.com"],examples:["image6.pubmatic.com","ads.pubmatic.com","image2.pubmatic.com","simage2.pubmatic.com","image4.pubmatic.com","simage4.pubmatic.com","image5.pubmatic.com","hbopenbid.pubmatic.com"],totalExecutionTime:417694368,totalOccurrences:279418},{name:"Olark",homepage:"https://www.olark.com/",category:"customer-success",domains:["*.olark.com"],examples:["static.olark.com"],totalExecutionTime:9840846,totalOccurrences:6534},{name:"Tawk.to",homepage:"https://www.tawk.to/",category:"customer-success",domains:["*.tawk.to"],examples:["embed.tawk.to"],totalExecutionTime:43074965,totalOccurrences:111088},{name:"OptinMonster",homepage:"https://optinmonster.com/",category:"marketing",domains:["*.opmn\
str.com","*.optmnstr.com","*.optmstr.com"],examples:["a.optmstr.com","api.opmnstr.com","a.optmnstr.com"],totalExecutionTime:1035991,totalOccurrences:2346},{name:"ZenDesk",homepage:"https://zendesk.com/",category:"customer-success",domains:["*.zdassets.com","*.zendesk.com","*.zopim.com"],examples:["assets.zendesk.com","static.zdassets.com","v2.zopim.com"],totalExecutionTime:106701440,totalOccurrences:72537},{name:"Pusher",homepage:"https://pusher.com/",category:"utility",domains:["*.pusher.com","*.pusherapp.com"],examples:["stats.pusher.com"],totalExecutionTime:152727,totalOccurrences:1698},{name:"Drift",homepage:"https://www.drift.com/",category:"marketing",domains:["*.drift.com","*.driftt.com"],examples:["js.driftt.com","api.drift.com"],products:[{name:"Drift Live Chat",urlPatterns:["REGEXP:js\\.driftt\\.com\\/include\\/.*\\/.*\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],totalExecutionTime:30179596,totalOccurrences:5515},
{name:"Sentry",homepage:"https://sentry.io/",category:"utility",domains:["*.getsentry.com","*.ravenjs.com","*.sentry-cdn.com","*.sentry.io"],examples:["cdn.ravenjs.com","browser.sentry-cdn.com"],totalExecutionTime:47937360,totalOccurrences:85598},{name:"Amazon Web Services",homepage:"https://aws.amazon.com/s3/",category:"other",domains:["*.amazon.com","*.amazonaws.com","*.amazonwebapps.com","*.amazonwebservices.com","*.elasticbeanstalk.com","*.images-amazon.com","*.amazon.co.uk"],examples:["s3.amazonaws.com","us-east-1.amazonaws.com","api-cdn.amazon.com","ecx.images-amazon.com","ws.amazon.co.uk"],totalExecutionTime:51892201,totalOccurrences:119152},{name:"Amazon Pay",homepage:"https://pay.amazon.com",category:"utility",domains:["payments.amazon.com","*.payments-amazon.com"],totalExecutionTime:1234650,totalOccurrences:6833},{name:"Media.net",homepage:"https://www.media.net/",category:"ad",domains:["*.media.net","*.mnet-ad.net"],examples:["contextual.media.net","cdnwest-xch.media.net","h\
bx.media.net","cs.media.net","hblg.media.net"],totalExecutionTime:24973689,totalOccurrences:97679},{name:"Yahoo!",homepage:"https://www.yahoo.com/",category:"ad",domains:["*.bluelithium.com","*.hostingprod.com","*.lexity.com","*.yahoo.com","*.yahooapis.com","*.yimg.com","*.zenfs.com","*.yahoo.net"],examples:["ads.yahoo.com","analytics.yahoo.com","geo.yahoo.com","udc.yahoo.com","ganon.yahoo.com","ads.yap.yahoo.com"],totalExecutionTime:2617276,totalOccurrences:24800},{name:"Adroll",homepage:"https://www.adroll.com/",category:"ad",domains:["*.adroll.com"],examples:["d.adroll.com","s.adroll.com"],totalExecutionTime:11884188,totalOccurrences:30782},{name:"Twitch",homepage:"https://twitch.tv/",category:"video",domains:["*.twitch.tv"],examples:["player.twitch.tv"],totalExecutionTime:18452667,totalOccurrences:1255},{name:"Taboola",homepage:"https://www.taboola.com/",category:"ad",domains:["*.taboola.com","*.taboolasyndication.com"],examples:["cdn.taboola.com","trc.taboola.com","vidstat.taboola\
.com","images.taboola.com"],totalExecutionTime:32631891,totalOccurrences:49191},{name:"Sizmek",homepage:"https://www.sizmek.com/",category:"ad",domains:["*.serving-sys.com","*.peer39.net"],examples:["secure-ds.serving-sys.com","ds.serving-sys.com","bs.serving-sys.com"],totalExecutionTime:6679849,totalOccurrences:4307},{name:"Scorecard Research",homepage:"https://www.scorecardresearch.com/",category:"ad",domains:["*.scorecardresearch.com"],examples:["sb.scorecardresearch.com","sa.scorecardresearch.com","b.scorecardresearch.com"],totalExecutionTime:4399371,totalOccurrences:54577},{name:"Criteo",homepage:"https://www.criteo.com/",category:"ad",domains:["*.criteo.com","*.emailretargeting.com","*.criteo.net"],examples:["static.criteo.net","bidder.criteo.com","dis.criteo.com","gum.criteo.com","sslwidget.criteo.com","dis.us.criteo.com"],totalExecutionTime:25625451,totalOccurrences:213880},{name:"Segment",homepage:"https://segment.com/",category:"analytics",domains:["*.segment.com","*.segment.\
io"],examples:["cdn.segment.com","api.segment.io"],totalExecutionTime:11055141,totalOccurrences:27036},{name:"ShareThis",homepage:"https://www.sharethis.com/",category:"social",domains:["*.sharethis.com"],examples:["w.sharethis.com","ws.sharethis.com","t.sharethis.com"],totalExecutionTime:30807804,totalOccurrences:88829},{name:"Distil Networks",homepage:"https://www.distilnetworks.com/",category:"utility",domains:["*.areyouahuman.com"],examples:["n-cdn.areyouahuman.com"]},{name:"Connexity",homepage:"https://connexity.com/",category:"analytics",domains:["*.connexity.net"]},{name:"Popads",homepage:"https://www.popads.net/",category:"ad",domains:["*.popads.net"],examples:["serve.popads.net","c1.popads.net"],totalExecutionTime:756593,totalOccurrences:427},{name:"CreateJS CDN",homepage:"https://code.createjs.com/",category:"cdn",domains:["*.createjs.com"],examples:["code.createjs.com"],totalExecutionTime:13654049,totalOccurrences:3880},{name:"Squarespace",homepage:"https://www.squarespace.c\
om/",category:"hosting",domains:["*.squarespace.com"],examples:["static.squarespace.com","static1.squarespace.com"],totalExecutionTime:1106480464,totalOccurrences:243154},{name:"Media Math",homepage:"https://www.mediamath.com/",category:"ad",domains:["*.mathads.com","*.mathtag.com"],examples:["mathid.mathtag.com","sync.mathtag.com","pixel.mathtag.com"],totalExecutionTime:20783,totalOccurrences:305},{name:"Mixpanel",homepage:"https://mixpanel.com/",category:"analytics",domains:["*.mixpanel.com","*.mxpnl.com"],examples:["cdn.mxpnl.com"],totalExecutionTime:3250547,totalOccurrences:18817},{name:"FontAwesome CDN",homepage:"https://fontawesome.com/",category:"cdn",domains:["*.fontawesome.com"],examples:["use.fontawesome.com"],totalExecutionTime:73007333,totalOccurrences:291586},{name:"Hubspot",homepage:"https://hubspot.com/",category:"marketing",domains:["*.hs-scripts.com","*.hubspot.com","*.leadin.com","*.hs-analytics.net","*.hscollectedforms.net","*.hscta.net","*.hsforms.net","*.hsleadflow\
s.net","*.hsstatic.net","*.hubspot.net","*.hsforms.com","*.hs-banner.com","*.hs-embed-reporting.com","*.hs-growth-metrics.com","*.hs-data.com","*.hsadspixel.net","*.hubapi.com"],examples:["forms.hubspot.com","js.hsforms.net","js.hs-analytics.net","js.leadin.com"],totalExecutionTime:92224372,totalOccurrences:154415},{name:"Mailchimp",homepage:"https://mailchimp.com/",category:"marketing",domains:["*.chimpstatic.com","*.list-manage.com","*.mailchimp.com"],examples:["downloads.mailchimp.com"],totalExecutionTime:21592375,totalOccurrences:45506},{name:"MGID",homepage:"https://www.mgid.com/",category:"ad",domains:["*.mgid.com","*.dt07.net"],examples:["servicer.mgid.com"],totalExecutionTime:22074076,totalOccurrences:10437},{name:"Stripe",homepage:"https://stripe.com",category:"utility",domains:["*.stripe.com","*.stripecdn.com","*.stripe.network"],examples:["m.stripe.network","js.stripe.com"],totalExecutionTime:166354648,totalOccurrences:136440},{name:"PayPal",homepage:"https://paypal.com",category:"\
utility",domains:["*.paypal.com","*.paypalobjects.com"],examples:["www.paypalobjects.com"],totalExecutionTime:64408205,totalOccurrences:62800},{name:"Market GID",homepage:"https://www.marketgid.com/",category:"ad",domains:["*.marketgid.com"],examples:["jsc.marketgid.com"]},{name:"Pinterest",homepage:"https://pinterest.com/",category:"social",domains:["*.pinimg.com","*.pinterest.com"],examples:["assets.pinterest.com","ct.pinterest.com","log.pinterest.com"],totalExecutionTime:17602311,totalOccurrences:131448},{name:"New Relic",homepage:"https://newrelic.com/",category:"utility",domains:["*.newrelic.com","*.nr-data.net"],examples:["js-agent.newrelic.com","bam.nr-data.net"],totalExecutionTime:64592740,totalOccurrences:227672},{name:"AppDynamics",homepage:"https://www.appdynamics.com/",category:"utility",domains:["*.appdynamics.com","*.eum-appdynamics.com","d3tjaysgumg9lf.cloudfront.net"],examples:["cdn.appdynamics.com"],totalExecutionTime:2509158,totalOccurrences:2920},{name:"Parking Crew",
homepage:"https://parkingcrew.net/",category:"other",domains:["d1lxhc4jvstzrp.cloudfront.net","*.parkingcrew.net"],totalExecutionTime:9,totalOccurrences:1},{name:"WordAds",company:"Automattic",homepage:"https://wordads.co/",category:"ad",domains:["*.pubmine.com"],examples:["s.pubmine.com"],totalExecutionTime:74286347,totalOccurrences:100449},{name:"AppNexus",homepage:"https://www.appnexus.com/",category:"ad",domains:["*.adnxs.com","*.ctasnet.com","*.adrdgt.com"],examples:["acdn.adnxs.com","secure.adnxs.com","ib.adnxs.com","sharethrough.adnxs.com","cdn.adnxs.com","vcdn.adnxs.com"],totalExecutionTime:5948505,totalOccurrences:234133},{name:"Histats",homepage:"https://www.histats.com/",category:"analytics",domains:["*.histats.com"],examples:["s10.histats.com"],totalExecutionTime:5601,totalOccurrences:92},{name:"DoubleVerify",homepage:"https://www.doubleverify.com/",category:"ad",domains:["*.doubleverify.com","*.dvtps.com","*.iqfp1.com"],examples:["cdn.doubleverify.com","cdn3.doubleverify.c\
om","tps.doubleverify.com","tps712.doubleverify.com","tps714.doubleverify.com","tps706.doubleverify.com","tps700.doubleverify.com","tps707.doubleverify.com","rtb2.doubleverify.com","rtb0.doubleverify.com","rtbcdn.doubleverify.com","tps11020.doubleverify.com","tm.iqfp1.com"],totalExecutionTime:46891028,totalOccurrences:19453},{name:"Mediavine",homepage:"https://www.mediavine.com/",category:"ad",domains:["*.mediavine.com"],examples:["scripts.mediavine.com","video.mediavine.com"],totalExecutionTime:59009373,totalOccurrences:12963},{name:"Wix",homepage:"https://www.wix.com/",category:"hosting",domains:["*.parastorage.com","*.wix.com","*.wixstatic.com","*.wixapps.net"],examples:["static.parastorage.com","static.wixstatic.com","www.wix.com","instagram.codev.wixapps.net"],totalExecutionTime:2112268981,totalOccurrences:458273},{name:"Webflow",homepage:"https://webflow.com/",category:"hosting",domains:["*.uploads-ssl.webflow.com","*.assets-global.website-files.com","*.assets.website-files.com"],
examples:["uploads-ssl.webflow.com","assets-global.website-files.com","assets.website-files.com"]},{name:"Weebly",homepage:"https://www.weebly.com/",category:"hosting",domains:["*.editmysite.com"],totalExecutionTime:413019e3,totalOccurrences:67864},{name:"LinkedIn",homepage:"https://www.linkedin.com/",category:"social",domains:["*.bizographics.com","platform.linkedin.com","*.slideshare.com","*.slidesharecdn.com","*.oribi.io"],totalExecutionTime:5776577,totalOccurrences:16507},{name:"LinkedIn Ads",category:"ad",domains:["*.licdn.com","*.ads.linkedin.com","ads.linkedin.com","www.linkedin.com"],examples:["snap.licdn.com"],totalExecutionTime:22805542,totalOccurrences:199088},{name:"Vox Media",homepage:"https://www.voxmedia.com/",category:"content",domains:["*.vox-cdn.com","*.voxmedia.com"],examples:["cdn.vox-cdn.com"],totalExecutionTime:910366,totalOccurrences:320},{name:"Hotmart",homepage:"https://www.hotmart.com/",category:"content",domains:["*.hotmart.com"],examples:["launchermodule.hot\
mart.com"],totalExecutionTime:15363016,totalOccurrences:4554},{name:"SoundCloud",homepage:"https://www.soundcloud.com/",category:"content",domains:["*.sndcdn.com","*.soundcloud.com","*.stratus.sc"],examples:["widget.sndcdn.com"],totalExecutionTime:15888610,totalOccurrences:5859},{name:"Spotify",homepage:"https://www.spotify.com/",category:"content",domains:["*.scdn.co","*.spotify.com"],examples:["open.spotify.com","open.scdn.co","i.scdn.co"],totalExecutionTime:99924,totalOccurrences:10992},{name:"AMP",homepage:"https://amp.dev/",category:"content",domains:["*.ampproject.org"],examples:["cdn.ampproject.org"],totalExecutionTime:79590738,totalOccurrences:66265},{name:"Beeketing",homepage:"https://beeketing.com/",category:"marketing",domains:["*.beeketing.com"],examples:["sdk-cdn.beeketing.com","sdk.beeketing.com"],totalExecutionTime:2163106,totalOccurrences:1971},{name:"Albacross",homepage:"https://albacross.com/",category:"marketing",domains:["*.albacross.com"],examples:["serve.albacross\
.com"],totalExecutionTime:100459,totalOccurrences:1503},{name:"TrafficJunky",homepage:"https://www.trafficjunky.com/",category:"ad",domains:["*.contentabc.com","*.trafficjunky.net"],examples:["ads2.contentabc.com","hw-cdn.contentabc.com","media.trafficjunky.net","ads.trafficjunky.net","hw-cdn.trafficjunky.net"],totalExecutionTime:2936,totalOccurrences:62},{name:"Bootstrap CDN",homepage:"https://www.bootstrapcdn.com/",category:"cdn",domains:["*.bootstrapcdn.com"],examples:["maxcdn.bootstrapcdn.com","stackpath.bootstrapcdn.com"],totalExecutionTime:2075388,totalOccurrences:38731},{name:"Shareaholic",homepage:"https://www.shareaholic.com/",category:"social",domains:["*.shareaholic.com","dsms0mj1bbhn4.cloudfront.net"],totalExecutionTime:122180,totalOccurrences:1429},{name:"Snowplow",homepage:"https://snowplowanalytics.com/",category:"analytics",domains:["d32hwlnfiv2gyn.cloudfront.net"],totalExecutionTime:7099041,totalOccurrences:58566},{name:"RD Station",homepage:"https://www.rdstation.com/\
en/",category:"marketing",domains:["d335luupugsy2.cloudfront.net"],totalExecutionTime:7693701,totalOccurrences:21846},{name:"Jivochat",homepage:"https://www.jivochat.com/",category:"customer-success",domains:["*.jivosite.com"],examples:["cdn-ca.jivosite.com","code.jivosite.com"],totalExecutionTime:36663932,totalOccurrences:57540},{name:"Listrak",homepage:"https://www.listrak.com/",category:"marketing",domains:["*.listrak.com","*.listrakbi.com"],examples:["cdn.listrakbi.com","s1.listrakbi.com"],totalExecutionTime:458776,totalOccurrences:1045},{name:"Ontame",homepage:"https://www.ontame.io",category:"analytics",domains:["*.ontame.io"],examples:["cdn.ontame.io","collector.ontame.io"],totalExecutionTime:23620,totalOccurrences:101},{name:"Ipify",homepage:"https://www.ipify.org",category:"utility",domains:["*.ipify.org"],examples:["api.ipify.org","geo.ipify.org"],totalExecutionTime:365905,totalOccurrences:2753},{name:"Ensighten",homepage:"https://www.ensighten.com/",category:"tag-manager",domains:[
"*.ensighten.com"],examples:["nexus.ensighten.com"],totalExecutionTime:1774287,totalOccurrences:3199},{name:"EpiServer",homepage:"https://www.episerver.com",category:"content",domains:["*.episerver.net"],examples:["dl.episerver.net"],totalExecutionTime:9010,totalOccurrences:80},{name:"mPulse",homepage:"https://developer.akamai.com/akamai-mpulse",category:"analytics",domains:["*.akstat.io","*.go-mpulse.net","*.mpulse.net","*.mpstat.us"],examples:["c.go-mpulse.net","0211c83c.akstat.io"],totalExecutionTime:3089821,totalOccurrences:30624},{name:"Pingdom RUM",homepage:"https://www.pingdom.com/product/performance-monitoring/",category:"analytics",domains:["*.pingdom.net"],examples:["rum-static.pingdom.net","rum-collector-2.pingdom.net"],totalExecutionTime:106679,totalOccurrences:1825},{name:"SpeedCurve RUM",company:"SpeedCurve",homepage:"https://www.speedcurve.com/features/performance-monitoring/",category:"analytics",domains:["*.speedcurve.com"],examples:["cdn.speedcurve.com","lux.speedcurv\
e.com"],totalExecutionTime:323903,totalOccurrences:5358},{name:"Radar",company:"Cedexis",homepage:"https://www.cedexis.com/radar/",category:"analytics",domains:["*.cedexis-test.com","*.cedexis.com","*.cmdolb.com","cedexis.leasewebcdn.com","*.cedexis-radar.net","*.cedexis.net","cedexis-test01.insnw.net","cedexisakamaitest.azureedge.net","cedexispub.cdnetworks.net","cs600.wac.alphacdn.net","cs600.wpc.edgecastdns.net","global2.cmdolb.com","img-cedexis.mncdn.com","a-cedexis.msedge.net","zn3vgszfh.fastestcdn.net"],examples:["radar.cedexis.com","rpt.cedexis.com","2-01-49cd-0002.cdx.cedexis.net","bench.cedexis-test.com"],totalExecutionTime:290925,totalOccurrences:1133},{name:"Byside",homepage:"https://byside.com",category:"analytics",domains:["*.byside.com"],examples:["byce2.byside.com","wce2.byside.com"],totalExecutionTime:45270,totalOccurrences:87},{name:"VWO",homepage:"https://vwo.com",category:"analytics",domains:["*.vwo.com","*.visualwebsiteoptimizer.com","d5phz18u4wuww.cloudfront.net","\
*.wingify.com"],examples:["dev.visualwebsiteoptimizer.com"],totalExecutionTime:6485310,totalOccurrences:7903},{name:"Bing Ads",homepage:"https://bingads.microsoft.com",category:"ad",domains:["*.bing.com","*.microsoft.com","*.msn.com","*.s-msft.com","*.s-msn.com","*.msads.net","*.msecnd.net"],examples:["bat.bing.com","c.bing.com","bat.r.msn.com","ajax.microsoft.com"],totalExecutionTime:14227177,totalOccurrences:117720},{name:"GoSquared",homepage:"https://www.gosquared.com",category:"analytics",domains:["*.gosquared.com","d1l6p2sc9645hc.cloudfront.net"],examples:["data.gosquared.com","data2.gosquared.com"],totalExecutionTime:56152,totalOccurrences:613},{name:"Usabilla",homepage:"https://usabilla.com",category:"analytics",domains:["*.usabilla.com","d6tizftlrpuof.cloudfront.net"],examples:["w.usabilla.com"],totalExecutionTime:240166,totalOccurrences:1354},{name:"Fastly Insights",homepage:"https://insights.fastlylabs.com",category:"analytics",domains:["*.fastly-insights.com"],examples:["www\
.fastly-insights.com"],totalExecutionTime:541189,totalOccurrences:4449},{name:"Visual IQ",homepage:"https://www.visualiq.com",category:"analytics",domains:["*.myvisualiq.net"],examples:["t.myvisualiq.net"]},{name:"Snapchat",homepage:"https://www.snapchat.com",category:"analytics",domains:["*.snapchat.com","*.sc-static.net"],examples:["tr.snapchat.com"],totalExecutionTime:177890,totalOccurrences:1978},{name:"Atlas Solutions",homepage:"https://atlassolutions.com",category:"analytics",domains:["*.atdmt.com"],examples:["ad.atdmt.com","cx.atdmt.com"]},{name:"Quantcast",homepage:"https://www.quantcast.com",category:"analytics",domains:["*.brtstats.com","*.quantcount.com","*.quantserve.com","*.semantictec.com","*.ntv.io"],examples:["pixel.quantserve.com","secure.quantserve.com","cms.quantserve.com","rules.quantcount.com"],totalExecutionTime:12419392,totalOccurrences:77646},{name:"Spiceworks",homepage:"https://www.spiceworks.com",category:"analytics",domains:["*.spiceworks.com"],examples:["px.\
spiceworks.com"]},{name:"Marketo",homepage:"https://www.marketo.com",category:"analytics",domains:["*.marketo.com","*.mktoresp.com","*.marketo.net"],examples:["munchkin.marketo.net"],totalExecutionTime:724464,totalOccurrences:1798},{name:"Intercom",homepage:"https://www.intercom.com",category:"customer-success",domains:["*.intercomcdn.com","*.intercom.io"],examples:["js.intercomcdn.com","api-iam.intercom.io","widget.intercom.io","nexus-websocket-a.intercom.io"],products:[{name:"Intercom Widget",urlPatterns:["widget.intercom.io","js.intercomcdn.com/shim.latest.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"},{name:"Intercom Facade",repo:"https://github.com/danielbachhuber/intercom-facade/"}]}],totalExecutionTime:44601345,totalOccurrences:35197},{name:"Unpkg",homepage:"https://unpkg.com",category:"cdn",domains:["*.unpkg.com","*.npmcdn.com"],totalExecutionTime:74666,totalOccurrences:227},{name:"ReadSpeaker",homepage:"https://www.rea\
dspeaker.com",category:"other",domains:["*.readspeaker.com"],examples:["sf1-eu.readspeaker.com"],totalExecutionTime:727525,totalOccurrences:6265},{name:"Browsealoud",homepage:"https://www.texthelp.com/en-gb/products/browsealoud/",category:"other",domains:["*.browsealoud.com","*.texthelp.com"],examples:["www.browsealoud.com"],totalExecutionTime:665425,totalOccurrences:1951},{name:"15gifts",category:"customer-success",domains:["*.15gifts.com","*.primefuse.com"],examples:["www.primefuse.com"]},{name:"1xRUN",category:"utility",domains:["*.1xrun.com"]},{name:"2AdPro Media Solutions",category:"ad",domains:["*.2adpro.com"]},{name:"301 Digital Media",category:"content",domains:["*.301ads.com","*.301network.com"]},{name:"360 picnic platform",company:"MediaV",category:"ad",domains:["*.mediav.com"],totalExecutionTime:4893,totalOccurrences:78},{name:"365 Media Group",category:"content",domains:["*.365dm.com"]},{name:"365 Tech Services",category:"hosting",domains:["*.365webservices.co.uk"]},{name:"\
3D Issue",category:"utility",domains:["*.3dissue.com","*.pressjack.com"],totalExecutionTime:53823,totalOccurrences:30},{name:"47Line Technologies",category:"other",domains:["*.pejs.net"]},{name:"4finance",category:"utility",domains:["*.4finance.com"]},{name:"5miles",category:"content",domains:["*.5milesapp.com"]},{name:"77Tool",company:"77Agency",category:"analytics",domains:["*.77tracking.com"]},{name:"9xb",category:"ad",domains:["*.9xb.com"]},{name:"@UK",category:"hosting",domains:["*.uk-plc.net"]},{name:"A Perfect Pocket",category:"hosting",domains:["*.aperfectpocketdata.com"]},{name:"A-FIS PTE",category:"analytics",domains:["*.websta.me"]},{name:"AB Tasty",homepage:"https://www.abtasty.com/",category:"analytics",domains:["*.abtasty.com","d1447tq2m68ekg.cloudfront.net"],examples:["try.abtasty.com"],totalExecutionTime:1720461,totalOccurrences:3363},{name:"ABA RESEARCH",category:"analytics",domains:["*.abaresearch.uk","qmodal.azurewebsites.net"]},{name:"ADMIZED",category:"ad",domains:[
"*.admized.com"]},{name:"ADNOLOGIES",category:"ad",domains:["*.heias.com"]},{name:"ADventori",category:"ad",domains:["*.adventori.com"],totalExecutionTime:5790,totalOccurrences:21},{name:"AI Media Group",category:"ad",domains:["*.aimediagroup.com"]},{name:"AIR.TV",category:"ad",domains:["*.air.tv"]},{name:"AKQA",category:"ad",domains:["*.srtk.net"]},{name:"AOL ad",company:"AOL",category:"ad",domains:["*.atwola.com"]},{name:"AOL On",company:"AOL",category:"content",domains:["*.5min.com"]},{name:"AOL Sponsored Listiings",company:"AOL",category:"ad",domains:["*.adsonar.com"]},{name:"APSIS Lead",company:"APSIS International AB",category:"ad",domains:["*.prospecteye.com"]},{name:"APSIS Profile Cloud",company:"APSIS",category:"analytics",domains:["*.innomdc.com"]},{name:"APSIS Forms",company:"APSIS",category:"other",domains:["*.apsisforms.com"],examples:["forms.apsisforms.com"]},{name:"ARENA",company:"Altitude",category:"ad",domains:["*.altitude-arena.com"],totalExecutionTime:1,totalOccurrences:1},
{name:"ARM",category:"analytics",domains:["*.tag4arm.com"],totalExecutionTime:5847,totalOccurrences:83},{name:"ASAPP",category:"other",domains:["*.asapp.com"],totalExecutionTime:37052,totalOccurrences:31},{name:"ASP",category:"hosting",domains:["*.goshowoff.com"]},{name:"AT Internet",category:"analytics",domains:["*.ati-host.net"]},{name:"ATTRAQT",category:"utility",domains:["*.attraqt.com","*.locayta.com"]},{name:"AVANSER",category:"analytics",domains:["*.avanser.com.au"]},{name:"AVG",company:"AVG Technologies",category:"utility",domains:["*.avg.com"],examples:["omni.avg.com"]},{name:"AWeber",category:"ad",domains:["*.aweber.com"],totalExecutionTime:40945,totalOccurrences:280},{name:"AXS",category:"content",domains:["*.axs.com"],totalExecutionTime:49218,totalOccurrences:8},{name:"Accentuate",company:"Accentuate Digital",category:"utility",homepage:"https://www.accentuate.io/",domains:["*.accentuate.io"],examples:["cdn.accentuate.io","original.accentuate.io"],totalExecutionTime:1772,totalOccurrences:17},
{name:"Accenture",category:"analytics",domains:["*.tmvtp.com"]},{name:"Accord Holdings",category:"ad",domains:["*.agcdn.com"]},{name:"Accordant Media",category:"ad",domains:["*.a3cloud.net"],examples:["segment.a3cloud.net"]},{name:"Account Kit",category:"other",domains:["*.accountkit.com"]},{name:"Accuen Media (Omnicom Media Group)",category:"content",domains:["*.p-td.com"]},{name:"Accuweather",category:"content",domains:["*.accuweather.com"],totalExecutionTime:291762,totalOccurrences:1477},{name:"Acquisio",category:"ad",domains:["*.acq.io"],totalExecutionTime:1692,totalOccurrences:32},{name:"Act-On Software",category:"marketing",domains:["*.actonsoftware.com"],totalExecutionTime:98,totalOccurrences:2},{name:"ActBlue",category:"other",domains:["*.actblue.com"],totalExecutionTime:62800,totalOccurrences:73},{name:"Active Agent",category:"ad",domains:["*.active-agent.com"]},{name:"ActiveCampaign",category:"ad",domains:["*.trackcmp.net","app-us1.com","*.app-us1.com"],examples:["trackcmp.ne\
t","prism.app-us1.com","diffuser-cdn.app-us1.com"],totalExecutionTime:1605217,totalOccurrences:19100},{name:"AcuityAds",category:"ad",domains:["*.acuityplatform.com"],totalExecutionTime:2492,totalOccurrences:693},{name:"Acxiom",category:"ad",domains:["*.acxiom-online.com","*.acxiomapac.com","*.delivery.net"]},{name:"Ad4Screen",category:"ad",domains:["*.a4.tl"]},{name:"Ad6Media",category:"ad",domains:["*.ad6media.fr"],totalExecutionTime:821770,totalOccurrences:654},{name:"AdCurve",category:"ad",domains:["*.shop2market.com"]},{name:"AdEasy",category:"ad",domains:["*.adeasy.ru"]},{name:"AdExtent",category:"ad",domains:["*.adextent.com"]},{name:"AdForge Edge",company:"AdForge",category:"ad",domains:["*.adforgeinc.com"]},{name:"AdGear",company:"Samsung Electronics",category:"ad",domains:["*.adgear.com","*.adgrx.com"],totalExecutionTime:19948,totalOccurrences:42920},{name:"AdInMedia",category:"ad",domains:["*.fastapi.net"]},{name:"AdJug",category:"ad",domains:["*.adjug.com"],examples:["track\
ing.adjug.com","uk.view.adjug.com"]},{name:"AdMatic",category:"ad",domains:["*.admatic.com.tr"],totalExecutionTime:1274496,totalOccurrences:467},{name:"AdMedia",category:"ad",domains:["*.admedia.com"],examples:["pixel.admedia.com"],totalExecutionTime:2027,totalOccurrences:7},{name:"AdRecover",category:"ad",domains:["*.adrecover.com"],totalExecutionTime:5117,totalOccurrences:46},{name:"AdRiver",category:"ad",domains:["*.adriver.ru"],totalExecutionTime:1374767,totalOccurrences:4740},{name:"AdSniper",category:"ad",domains:["*.adsniper.ru","*.sniperlog.ru"],totalExecutionTime:2366,totalOccurrences:22},{name:"AdSpeed",category:"ad",domains:["*.adspeed.net"],totalExecutionTime:4642,totalOccurrences:16},{name:"AdSpruce",category:"ad",domains:["*.adspruce.com"]},{name:"AdSupply",category:"ad",domains:["*.doublepimp.com"],totalExecutionTime:1436,totalOccurrences:13},{name:"AdTheorent",category:"ad",domains:["*.adentifi.com"],totalExecutionTime:108,totalOccurrences:1},{name:"AdThink AudienceInsi\
ghts",company:"AdThink Media",category:"analytics",domains:["*.audienceinsights.net"]},{name:"AdTrue",company:"FPT AdTrue",category:"ad",domains:["*.adtrue.com"]},{name:"AdYapper",category:"ad",domains:["*.adyapper.com"]},{name:"Adacado",category:"ad",domains:["*.adacado.com"],totalExecutionTime:1777,totalOccurrences:18},{name:"Adap.tv",category:"ad",domains:["*.adap.tv"]},{name:"Adapt Services",category:"hosting",domains:["*.adcmps.com"]},{name:"Adaptive Web",category:"hosting",domains:["*.adaptive.co.uk"]},{name:"Adara Media",category:"ad",domains:["*.yieldoptimizer.com"],totalExecutionTime:1324,totalOccurrences:23},{name:"Adblade",category:"ad",domains:["*.adblade.com"],totalExecutionTime:704,totalOccurrences:7},{name:"Adbrain",category:"ad",domains:["*.adbrn.com"]},{name:"AddEvent",category:"utility",domains:["*.addevent.com"],examples:["www.addevent.com"],totalExecutionTime:73230,totalOccurrences:203},{name:"AddShoppers",category:"social",domains:["*.addshoppers.com","d3rr3d0n31t4\
8m.cloudfront.net","*.shop.pe"],totalExecutionTime:31574,totalOccurrences:451},{name:"AddThisEvent",category:"hosting",domains:["*.addthisevent.com"]},{name:"Addoox MetaNetwork",company:"Addoox",category:"ad",domains:["*.metanetwork.net"]},{name:"Addvantage Media",category:"ad",domains:["*.addvantagemedia.com","*.simplytechnology.net"]},{name:"AD EBis",category:"analytics",homepage:"https://www.ebis.ne.jp/",domains:["*.ebis.ne.jp"],examples:["taj1.ebis.ne.jp"],totalExecutionTime:55086,totalOccurrences:608},{name:"Adecs",category:"customer-success",domains:["*.adecs.co.uk"],examples:["www.adecs.co.uk"]},{name:"Adelphic",category:"ad",domains:["*.ipredictive.com"],totalExecutionTime:8196,totalOccurrences:112},{name:"Adestra",category:"ad",domains:["*.adestra.com","*.msgfocus.com"]},{name:"Adform",category:"ad",domains:["*.adform.net","*.adformdsp.net"],totalExecutionTime:1798751,totalOccurrences:140125},{name:"Adkontekst",category:"ad",domains:["*.adkontekst.pl"]},{name:"Adlead",category:"\
ad",domains:["*.webelapp.com"]},{name:"Adledge",category:"utility",domains:["*.adledge.com"]},{name:"Adloox",category:"ad",domains:["*.adlooxtracking.com"],totalExecutionTime:103507,totalOccurrences:112},{name:"Adlux",category:"ad",domains:["*.adlux.com"]},{name:"Admedo",category:"ad",domains:["*.a8723.com","*.adizio.com","*.admedo.com"],examples:["pool.a8723.com"],totalExecutionTime:9586,totalOccurrences:695},{name:"Admeta",company:"Wideorbit",category:"ad",domains:["*.atemda.com"]},{name:"Admetrics",company:"Next Tuesday",category:"analytics",domains:["*.nt.vc"],examples:["metrics.nt.vc"]},{name:"Admiral",category:"ad",domains:["*.unknowntray.com"]},{name:"Admitad",category:"ad",domains:["*.lenmit.com"],totalExecutionTime:2335,totalOccurrences:31},{name:"Admixer for Publishers",company:"Admixer",category:"ad",domains:["*.admixer.net"],totalExecutionTime:1542643,totalOccurrences:878},{name:"Adnium",category:"ad",domains:["*.adnium.com"]},{name:"Adnostic",company:"Dennis Publishing",category:"\
ad",domains:["*.adnostic.co.uk"]},{name:"Adobe Marketing Cloud",company:"Adobe Systems",category:"ad",domains:["*.adobetag.com"]},{name:"Adobe Scene7",company:"Adobe Systems",category:"content",domains:["wwwimages.adobe.com","*.scene7.com","*.everestads.net","*.everestjs.net"],totalExecutionTime:808424,totalOccurrences:702},{name:"Adobe Systems",category:"content",domains:["adobe.com","www.adobe.com"],totalExecutionTime:38836,totalOccurrences:179},{name:"Adobe Business Catalyst",homepage:"https://www.businesscatalyst.com/",category:"hosting",domains:["*.businesscatalyst.com"]},{name:"Adocean",company:"Gemius",category:"ad",domains:["*.adocean.pl"],totalExecutionTime:1658274,totalOccurrences:2151},{name:"Adometry",company:"Google",category:"ad",domains:["*.dmtry.com"]},{name:"Adomik",category:"analytics",domains:["*.adomik.com"]},{name:"Adotmob",category:"ad",domains:["*.adotmob.com"]},{name:"Adrian Quevedo",category:"hosting",domains:["*.adrianquevedo.com"]},{name:"Adroit Digital Solut\
ions",category:"ad",domains:["*.imiclk.com","*.abmr.net"]},{name:"AdsNative",category:"ad",domains:["*.adsnative.com"]},{name:"AdsWizz",category:"ad",domains:["*.adswizz.com"],totalExecutionTime:479514,totalOccurrences:1901},{name:"Adscale",category:"ad",domains:["*.adscale.de"],totalExecutionTime:106237,totalOccurrences:960},{name:"Adschoom",company:"JSWeb Production",category:"ad",domains:["*.adschoom.com"],totalExecutionTime:491,totalOccurrences:2},{name:"Adscience",category:"ad",domains:["*.adscience.nl"]},{name:"Adsiduous",category:"ad",domains:["*.adsiduous.com"]},{name:"Adsty",category:"ad",domains:["*.adx1.com"],totalExecutionTime:698,totalOccurrences:5},{name:"Adtech (AOL)",category:"ad",domains:["*.adtechus.com"],totalExecutionTime:176,totalOccurrences:2},{name:"Adtegrity",category:"ad",domains:["*.adtpix.com"],totalExecutionTime:1735,totalOccurrences:20},{name:"Adthink",company:"Adthink Media",category:"ad",domains:["*.adxcore.com","*.dcoengine.com"],examples:["d.adxcore.com"]},
{name:"AdultWebmasterEmpire.Com",category:"ad",domains:["*.awempire.com"],totalExecutionTime:65091,totalOccurrences:38},{name:"Adunity",category:"ad",domains:["*.adunity.com"]},{name:"Advance Magazine Group",category:"content",domains:["*.condenastdigital.com","*.condenet.com","*.condenast.co.uk"],totalExecutionTime:2531,totalOccurrences:8},{name:"Adverline Board",company:"Adverline",category:"ad",domains:["*.adverline.com","*.adnext.fr"]},{name:"AdvertServe",category:"ad",domains:["*.advertserve.com"],totalExecutionTime:112685,totalOccurrences:437},{name:"Advolution",category:"utility",domains:["*.advolution.de"]},{name:"Adwise",category:"ad",domains:["*.adwise.bg"],totalExecutionTime:144,totalOccurrences:2},{name:"Adyen",category:"utility",domains:["*.adyen.com"],totalExecutionTime:6335144,totalOccurrences:2363},{name:"Adyoulike",category:"ad",domains:["*.adyoulike.com","*.omnitagjs.com","*.adyoulike.net"],totalExecutionTime:147862,totalOccurrences:53190},{name:"Adzerk",category:"ad",
domains:["*.adzerk.net"],totalExecutionTime:35184,totalOccurrences:117},{name:"Adzip",company:"Adbox Digital",category:"ad",domains:["*.adzip.co"]},{name:"AerServ",category:"ad",domains:["*.aerserv.com"]},{name:"Affectv",category:"ad",domains:["*.affectv.com","*.affec.tv"],totalExecutionTime:1187,totalOccurrences:12},{name:"Affiliate Window",company:"Digital Window",category:"ad",domains:["*.dwin1.com"],totalExecutionTime:561168,totalOccurrences:5414},{name:"Affiliatly",category:"ad",domains:["*.affiliatly.com"],examples:["www.affiliatly.com"],totalExecutionTime:32020,totalOccurrences:132},{name:"Affino",category:"ad",domains:["affino.com"]},{name:"Affirm",category:"utility",domains:["*.affirm.com"],totalExecutionTime:3997184,totalOccurrences:6665},{name:"Afterpay",company:"Block",category:"utility",homepage:"https://www.afterpay.com/",domains:["*.afterpay.com"],examples:["static-us.afterpay.com"],totalExecutionTime:1270109,totalOccurrences:8269},{name:"Agenda Media",category:"ad",domains:[
"*.agendamedia.co.uk"]},{name:"Aggregate Knowledge",company:"Neustar",category:"ad",domains:["*.agkn.com"],totalExecutionTime:14828,totalOccurrences:344},{name:"AgilOne",category:"marketing",domains:["*.agilone.com"],totalExecutionTime:4190,totalOccurrences:53},{name:"Agility",category:"hosting",domains:["*.agilitycms.com"],totalExecutionTime:3079,totalOccurrences:4},{name:"Ahalogy",category:"social",domains:["*.ahalogy.com"]},{name:"Aheadworks",category:"utility",domains:["*.aheadworks.com"]},{name:"AirPR",category:"analytics",domains:["*.airpr.com"],totalExecutionTime:416,totalOccurrences:5},{name:"Aira",category:"ad",domains:["*.aira.net"],examples:["www.aira.net"]},{name:"Airport Parking and Hotels",category:"content",domains:["*.aph.com"],totalExecutionTime:277,totalOccurrences:3},{name:"Akanoo",category:"analytics",domains:["*.akanoo.com"]},{name:"Alchemy",company:"AndBeyond.Media",category:"ad",domains:["*.andbeyond.media"],totalExecutionTime:456340,totalOccurrences:164},{name:"\
AlephD",company:"AOL",category:"ad",domains:["*.alephd.com"]},{name:"AliveChat",company:"AYU Technology Solutions",category:"customer-success",domains:["*.websitealive.com","*.websitealive7.com"]},{name:"All Access",category:"other",domains:["*.allaccess.com.ph"]},{name:"Alliance for Audited Media",category:"ad",domains:["*.aamsitecertifier.com"]},{name:"Allyde",category:"marketing",domains:["*.mautic.com"]},{name:"AlphaSSL",category:"utility",domains:["*.alphassl.com"],totalExecutionTime:1146,totalOccurrences:10},{name:"Altitude",category:"ad",domains:["*.altitudeplatform.com"]},{name:"Altocloud",category:"analytics",domains:["*.altocloud.com"]},{name:"Amadeus",category:"content",domains:["*.e-travel.com"]},{name:"Amazon CloudFront",company:"Amazon",category:"utility",domains:["cloudfront.net"]},{name:"Ambassador",category:"ad",domains:["*.getambassador.com"],totalExecutionTime:21042,totalOccurrences:89},{name:"Ambient",company:"Ericcson",category:"other",domains:["*.adnetwork.vn","*.\
ambientplatform.vn"]},{name:"Amelia Communication",category:"hosting",domains:["*.sara.media"]},{name:"Amobee",category:"marketing",domains:["*.amgdgt.com","*.kontera.com"]},{name:"Amplience",category:"marketing",domains:["*.10cms.com","*.amplience.com","*.amplience.net","*.bigcontent.io","*.adis.ws"],totalExecutionTime:4093,totalOccurrences:17},{name:"Amplitude Mobile Analytics",company:"Amplitude",category:"analytics",domains:["*.amplitude.com","d24n15hnbwhuhn.cloudfront.net"],totalExecutionTime:8703641,totalOccurrences:46524},{name:"Anametrix",company:"Ensighten",category:"analytics",domains:["*.anametrix.com"]},{name:"Ancora Platform",company:"Ancora Media Solutions",category:"ad",domains:["*.ancoraplatform.com"]},{name:"Anedot",category:"other",domains:["*.anedot.com"],totalExecutionTime:84655,totalOccurrences:21},{name:"AnimateJS",category:"utility",domains:["*.animatedjs.com"]},{name:"AnswerDash",category:"customer-success",domains:["*.answerdash.com"],examples:["p1.answerdash.c\
om"]},{name:"Answers",category:"analytics",domains:["*.answcdn.com","*.answers.com","*.dsply.com"]},{name:"Apester",category:"analytics",domains:["*.apester.com","*.qmerce.com"],totalExecutionTime:25294,totalOccurrences:166},{name:"Apligraf SmartWeb",company:"Apligraf",category:"utility",domains:["*.apligraf.com.br"]},{name:"Appier",category:"ad",domains:["*.appier.net"],totalExecutionTime:124524,totalOccurrences:826},{name:"Appsolute",category:"utility",homepage:"https://appsolute.us/",domains:["dropahint.love"],examples:["dropahint.love"],totalExecutionTime:16362,totalOccurrences:144},{name:"Apptus eSales",company:"Apptus",category:"analytics",domains:["*.apptus.com"]},{name:"Arbor",company:"LiveRamp",category:"other",domains:["*.pippio.com"]},{name:"Ardent Creative",category:"hosting",domains:["*.ardentcreative.co.uk"]},{name:"Arnold Clark Automobiles",category:"content",domains:["*.arnoldclark.com"]},{name:"Atom Content Marketing",category:"content",domains:["*.atomvault.net"],examples:[
"danu.atomvault.net"]},{name:"Atom Data",category:"other",domains:["*.atomdata.io"]},{name:"Attribution",category:"ad",domains:["*.attributionapp.com"],totalExecutionTime:44124,totalOccurrences:124},{name:"Audience 360",company:"Datapoint Media",category:"ad",domains:["*.dpmsrv.com"],totalExecutionTime:578723,totalOccurrences:371},{name:"Audience Science",category:"ad",domains:["*.revsci.net"]},{name:"AudienceSearch",company:"Intimate Merger",category:"ad",domains:["*.im-apps.net"],totalExecutionTime:9114981,totalOccurrences:46726},{name:"Auditorius",category:"ad",domains:["*.audtd.com"]},{name:"Augur",category:"analytics",domains:["*.augur.io"]},{name:"Auto Link Maker",company:"Apple",category:"ad",domains:["*.apple.com"],examples:["autolinkmaker.itunes.apple.com"],totalExecutionTime:657122,totalOccurrences:2479},{name:"Autopilot",category:"ad",domains:["*.autopilothq.com"],totalExecutionTime:15490,totalOccurrences:74},{name:"Avail",company:"RichRelevance",category:"ad",domains:["*.av\
ail.net"]},{name:"AvantLink",category:"ad",domains:["*.avmws.com"],totalExecutionTime:417,totalOccurrences:8},{name:"Avco Systems",category:"utility",domains:["*.avcosystems.com"]},{name:"Avid Media",category:"customer-success",domains:["*.adspdbl.com","*.metadsp.co.uk"],totalExecutionTime:58,totalOccurrences:1},{name:"Avocet Systems",category:"ad",domains:["*.avocet.io","ads.avct.cloud"]},{name:"Avora",category:"analytics",domains:["*.truedash.com"],examples:["truetag.truedash.com"]},{name:"Azure Traffic Manager",company:"Microsoft",category:"other",domains:["*.gateway.net","*.trafficmanager.net"],examples:["analytics.gateway.net"],totalExecutionTime:51660,totalOccurrences:148},{name:"Azure Web Services",company:"Microsoft",category:"cdn",domains:["*.azurewebsites.net","*.azureedge.net","*.msedge.net","*.windows.net"],totalExecutionTime:35665078,totalOccurrences:51378},{name:"BAM",category:"analytics",domains:["*.bam-x.com"]},{name:"Baifendian Technology",category:"marketing",domains:[
"*.baifendian.com"]},{name:"Bankrate",category:"utility",domains:["*.bankrate.com"]},{name:"BannerFlow",company:"Nordic Factory Solutions",category:"ad",domains:["*.bannerflow.com"],totalExecutionTime:50455,totalOccurrences:42},{name:"Barclaycard SmartPay",company:"Barclaycard",category:"utility",domains:["*.barclaycardsmartpay.com"]},{name:"Barilliance",category:"analytics",domains:["*.barilliance.net","dn3y71tq7jf07.cloudfront.net"],totalExecutionTime:7250,totalOccurrences:26},{name:"Barnebys",category:"other",domains:["*.barnebys.com"],totalExecutionTime:59682,totalOccurrences:57},{name:"Basis",company:"Basis Technologies",category:"ad",homepage:"https://basis.net/",domains:["*.basis.net"],examples:["cdn01.basis.net"],totalExecutionTime:215661,totalOccurrences:2623},{name:"Batch Media",category:"ad",domains:["*.t4ft.de"]},{name:"Bauer Consumer Media",category:"content",domains:["*.bauercdn.com","*.greatmagazines.co.uk"],examples:["www.greatmagazines.co.uk"]},{name:"Baynote",category:"\
analytics",domains:["*.baynote.net"]},{name:"Bazaarvoice",category:"analytics",domains:["*.bazaarvoice.com","*.feedmagnet.com"],totalExecutionTime:1664795,totalOccurrences:3375},{name:"Beachfront Media",category:"ad",domains:["*.bfmio.com"],totalExecutionTime:7782,totalOccurrences:771},{name:"BeamPulse",category:"analytics",domains:["*.beampulse.com"]},{name:"Beeswax",category:"ad",domains:["*.bidr.io"],totalExecutionTime:5298,totalOccurrences:12735},{name:"Beetailer",category:"social",domains:["*.beetailer.com"],examples:["www.beetailer.com"]},{name:"Best Of Media S.A.",category:"content",domains:["*.servebom.com"],totalExecutionTime:29,totalOccurrences:67},{name:"Bet365",category:"ad",domains:["*.bet365affiliates.com"]},{name:"Betfair",category:"other",domains:["*.cdnbf.net"]},{name:"Betgenius",company:"Genius Sports",category:"content",domains:["*.connextra.com"],totalExecutionTime:84739,totalOccurrences:287},{name:"Better Banners",category:"ad",domains:["*.betterbannerscloud.com"]},
{name:"Better Business Bureau",category:"analytics",domains:["*.bbb.org"],totalExecutionTime:10819,totalOccurrences:78},{name:"Between Digital",category:"ad",domains:["*.betweendigital.com"],totalExecutionTime:88306,totalOccurrences:787},{name:"BidTheatre",category:"ad",domains:["*.bidtheatre.com"],totalExecutionTime:23106,totalOccurrences:252},{name:"Bidtellect",category:"ad",domains:["*.bttrack.com"],totalExecutionTime:2834,totalOccurrences:19},{name:"Bigcommerce",category:"marketing",domains:["*.bigcommerce.com"],totalExecutionTime:45747978,totalOccurrences:19595},{name:"BitGravity",company:"Tata Communications",category:"content",domains:["*.bitgravity.com"]},{name:"Bitly",category:"utility",domains:["*.bitly.com","*.lemde.fr","*.bit.ly"],totalExecutionTime:2977,totalOccurrences:8},{name:"Bizible",category:"ad",domains:["*.bizible.com","*.bizibly.com"],totalExecutionTime:435247,totalOccurrences:1186},{name:"Bizrate",category:"analytics",domains:["*.bizrate.com"],totalExecutionTime:11197,
totalOccurrences:57},{name:"BlastCasta",category:"social",domains:["*.poweringnews.com"],examples:["www.poweringnews.com"]},{name:"Blindado",category:"utility",domains:["*.siteblindado.com"],totalExecutionTime:41,totalOccurrences:1},{name:"Blis",category:"ad",domains:["*.blismedia.com"]},{name:"Blogg.se",category:"hosting",domains:["*.cdnme.se","*.publishme.se"]},{name:"BloomReach",category:"ad",domains:["*.brcdn.com","*.brsrvr.com","*.brsvr.com"],totalExecutionTime:2695,totalOccurrences:47},{name:"Bloomberg",category:"content",domains:["*.gotraffic.net"]},{name:"Shop Logic",company:"BloomReach",category:"marketing",domains:["*.goshoplogic.com"]},{name:"Blue State Digital",category:"ad",domains:["*.bsd.net"]},{name:"Blue Triangle Technologies",category:"analytics",domains:["*.btttag.com"],totalExecutionTime:102966,totalOccurrences:182},{name:"BlueCava",category:"ad",domains:["*.bluecava.com"],totalExecutionTime:466075,totalOccurrences:5165},{name:"BlueKai",company:"Oracle",category:"ad",
domains:["*.bkrtx.com","*.bluekai.com"],totalExecutionTime:4,totalOccurrences:6},{name:"Bluecore",category:"analytics",domains:["*.bluecore.com"],examples:["www.bluecore.com"],totalExecutionTime:83612,totalOccurrences:225},{name:"Bluegg",category:"hosting",domains:["d1va5oqn59yrvt.cloudfront.net"]},{name:"Bold Commerce",category:"utility",domains:["*.shappify-cdn.com","*.shappify.com","*.boldapps.net"],totalExecutionTime:5072681,totalOccurrences:9886},{name:"BoldChat",company:"LogMeIn",category:"customer-success",domains:["*.boldchat.com"]},{name:"Bombora",category:"ad",domains:["*.mlno6.com"]},{name:"Bonnier",category:"content",domains:["*.bonniercorp.com"]},{name:"Bookatable",category:"content",domains:["*.bookatable.com","*.livebookings.com"]},{name:"Booking.com",category:"content",domains:["*.bstatic.com"],totalExecutionTime:1652677,totalOccurrences:2448},{name:"Boomtrain",category:"ad",domains:["*.boomtrain.com","*.boomtrain.net"],totalExecutionTime:360072,totalOccurrences:2169},{
name:"BoostSuite",category:"ad",domains:["*.poweredbyeden.com"]},{name:"Boostable",category:"ad",domains:["*.boostable.com"]},{name:"Bootstrap Chinese network",category:"cdn",domains:["*.bootcss.com"],totalExecutionTime:427117,totalOccurrences:881},{name:"Booxscale",category:"ad",domains:["*.booxscale.com"]},{name:"Borderfree",company:"pitney bowes",category:"utility",domains:["*.borderfree.com","*.fiftyone.com"]},{name:"BowNow",category:"analytics",homepage:"https://bow-now.jp/",domains:["*.bownow.jp"],examples:["contents.bownow.jp"],totalExecutionTime:1298132,totalOccurrences:2410},{name:"Box",category:"hosting",domains:["*.box.com"],totalExecutionTime:15191,totalOccurrences:223},{name:"Boxever",category:"analytics",domains:["*.boxever.com"]},{name:"Braintree Payments",company:"Paypal",category:"utility",domains:["*.braintreegateway.com"],totalExecutionTime:171291,totalOccurrences:1141},{name:"Branch Metrics",category:"ad",domains:["*.branch.io","*.app.link"],totalExecutionTime:441792,
totalOccurrences:8288},{name:"Brand Finance",category:"other",domains:["*.brandirectory.com"]},{name:"Brand View",category:"analytics",domains:["*.brandview.com"]},{name:"Brandscreen",category:"ad",domains:["*.rtbidder.net"],examples:["match.rtbidder.net"]},{name:"BridgeTrack",company:"Sapient",category:"ad",domains:["*.bridgetrack.com"]},{name:"BrightRoll",company:"Yahoo!",category:"ad",domains:["*.btrll.com"]},{name:"BrightTag / Signal",company:"Signal",homepage:"https://www.signal.co",category:"tag-manager",domains:["*.btstatic.com","*.thebrighttag.com"]},{name:"Brightcove ZenCoder",company:"Brightcove",category:"other",domains:["*.zencoder.net"]},{name:"Bronto Software",category:"marketing",domains:["*.bm23.com","*.bronto.com","*.brontops.com"]},{name:"Browser-Update.org",category:"other",domains:["*.browser-update.org"]},{name:"Buffer",category:"social",domains:["*.bufferapp.com"],totalExecutionTime:535,totalOccurrences:7},{name:"Bugsnag",category:"utility",domains:["*.bugsnag.com",
"d2wy8f7a9ursnm.cloudfront.net"],examples:["notify.bugsnag.com"],totalExecutionTime:6197502,totalOccurrences:15069},{name:"Burst Media",category:"ad",domains:["*.burstnet.com","*.1rx.io"],examples:["usermatch.burstnet.com"],totalExecutionTime:1618,totalOccurrences:52},{name:"Burt",category:"analytics",domains:["*.richmetrics.com","*.burt.io"]},{name:"Business Message",category:"ad",domains:["*.message-business.com"],totalExecutionTime:7310,totalOccurrences:21},{name:"Business Week",company:"Bloomberg",category:"social",domains:["*.bwbx.io"],totalExecutionTime:67737,totalOccurrences:9},{name:"Buto",company:"Big Button",category:"ad",domains:["*.buto.tv"]},{name:"Button",category:"ad",domains:["*.btncdn.com"]},{name:"BuySellAds",category:"ad",domains:["*.buysellads.com","*.buysellads.net"],totalExecutionTime:179225,totalOccurrences:170},{name:"BuySight (AOL)",category:"ad",domains:["*.pulsemgr.com"]},{name:"Buyapowa",category:"ad",domains:["*.co-buying.com"],totalExecutionTime:3038,totalOccurrences:37},
{name:"BuzzFeed",category:"social",domains:["*.buzzfed.com","*.buzzfeed.com"],totalExecutionTime:14608,totalOccurrences:2},{name:"C1X",category:"ad",domains:["*.c1exchange.com"]},{name:"C3 Metrics",category:"analytics",domains:["*.c3tag.com"],totalExecutionTime:18122,totalOccurrences:153},{name:"CANDDi",company:"Campaign and Digital Intelligence",category:"ad",domains:["*.canddi.com"],totalExecutionTime:84756,totalOccurrences:150},{name:"CCM benchmark Group",category:"social",domains:["*.ccm2.net"]},{name:"CD Networks",category:"utility",domains:["*.gccdn.net"]},{name:"CDN Planet",category:"analytics",domains:["*.cdnplanet.com"]},{name:"InAuth",category:"utility",homepage:"https://www.inauth.com/",domains:["*.cdn-net.com"],examples:["uk.cdn-net.com"],totalExecutionTime:306346,totalOccurrences:298},{name:"CJ Affiliate",company:"Conversant",category:"ad",domains:["*.cj.com","*.dpbolvw.net"],totalExecutionTime:7725,totalOccurrences:17},{name:"CJ Affiliate by Conversant",company:"Conversan\
t",category:"ad",domains:["*.ftjcfx.com"],totalExecutionTime:8,totalOccurrences:4},{name:"CNBC",category:"content",domains:["*.cnbc.com"],totalExecutionTime:11468,totalOccurrences:12},{name:"CNET Content Solutions",company:"CBS Interactive",category:"content",domains:["*.cnetcontent.com"],examples:["cdn.cnetcontent.com","ws.cnetcontent.com"]},{name:"CPEx",category:"content",domains:["*.cpex.cz"],totalExecutionTime:763356,totalOccurrences:1104},{name:"CPXi",category:"ad",domains:["*.cpxinteractive.com"]},{name:"CUBED Attribution",company:"CUBED",category:"ad",domains:["*.withcubed.com"],examples:["data.withcubed.com"]},{name:"Cachefly",category:"utility",domains:["*.cachefly.net"],totalExecutionTime:128046,totalOccurrences:258},{name:"Calendly",category:"other",domains:["*.calendly.com"],totalExecutionTime:8622733,totalOccurrences:4604},{name:"CallRail",category:"analytics",domains:["*.callrail.com"],totalExecutionTime:8080185,totalOccurrences:29537},{name:"CallTrackingMetrics",category:"\
analytics",domains:["*.tctm.co"],totalExecutionTime:1981698,totalOccurrences:7503},{name:"Canned Banners",category:"ad",domains:["*.cannedbanners.com"]},{name:"Canopy Labs",category:"analytics",domains:["*.canopylabs.com"]},{name:"Capita",category:"utility",domains:["*.crcom.co.uk"],examples:["emmsrep.crcom.co.uk"]},{name:"Captify Media",category:"ad",domains:["*.cpx.to"],totalExecutionTime:1519,totalOccurrences:31},{name:"Captiify",category:"ad",domains:["*.captifymedia.com"]},{name:"Captivate Ai",category:"ad",domains:["*.captivate.ai"]},{name:"Captora",category:"marketing",domains:["*.captora.com"]},{name:"Carcloud",category:"other",domains:["*.carcloud.co.uk"]},{name:"Cardlytics",category:"ad",domains:["*.cardlytics.com"]},{name:"Cardosa Enterprises",category:"analytics",domains:["*.y-track.com"],totalExecutionTime:778,totalOccurrences:17},{name:"Caspian Media",category:"ad",domains:["*.caspianmedia.com"]},{name:"Cast",category:"utility",domains:["*.cast.rocks"]},{name:"Catch",category:"\
other",domains:["*.getcatch.com"],examples:["app.getcatch.com","assets.getcatch.com","js.getcatch.com"],totalExecutionTime:18282,totalOccurrences:40},{name:"Cavisson",category:"analytics",domains:["*.cavisson.com"]},{name:"Cedato",category:"ad",domains:["*.algovid.com","*.vdoserv.com"]},{name:"Celebrus Technologies",category:"analytics",domains:["*.celebrus.com"]},{name:"Celtra",category:"ad",domains:["*.celtra.com"],totalExecutionTime:369517,totalOccurrences:427},{name:"Centro",category:"ad",domains:["*.brand-server.com"]},{name:"Ceros",category:"other",domains:["ceros.com","view.ceros.com"],totalExecutionTime:64139,totalOccurrences:149},{name:"Ceros Analytics",company:"Ceros",category:"analytics",domains:["api.ceros.com"]},{name:"Certona",category:"analytics",domains:["*.certona.net"],totalExecutionTime:376,totalOccurrences:4},{name:"Certum",category:"utility",domains:["*.ocsp-certum.com","*.certum.pl"],totalExecutionTime:8544,totalOccurrences:3},{name:"Cgrdirect",category:"other",domains:[
"*.cgrdirect.co.uk"]},{name:"Channel 5 Media",category:"ad",domains:["*.five.tv"]},{name:"Channel.me",category:"customer-success",domains:["*.channel.me"]},{name:"ChannelAdvisor",category:"ad",domains:["*.channeladvisor.com","*.searchmarketing.com"],totalExecutionTime:3385,totalOccurrences:25},{name:"ChannelApe",company:"ChannelApe",category:"other",homepage:"https://www.channelape.com/",domains:["*.channelape.com"],examples:["callbacks.channelape.com"]},{name:"Chargeads Oscar",company:"Chargeads",category:"ad",domains:["*.chargeads.com"]},{name:"Charities Aid Foundation",category:"utility",domains:["*.cafonline.org"],totalExecutionTime:4368,totalOccurrences:7},{name:"Chartbeat",category:"analytics",domains:["*.chartbeat.com","*.chartbeat.net"],totalExecutionTime:1270560,totalOccurrences:6246},{name:"Cheapflights Media",company:"Momondo",category:"content",domains:["*.momondo.net"]},{name:"CheckM8",category:"ad",domains:["*.checkm8.com"]},{name:"CheckRate",company:"FreeStart",category:"\
utility",domains:["*.checkrate.co.uk"]},{name:"Checkfront",category:"other",domains:["*.checkfront.com","dcg3jth5savst.cloudfront.net"],totalExecutionTime:279282,totalOccurrences:152},{name:"CheetahMail",company:"Experian",category:"ad",domains:["*.chtah.com"]},{name:"Chitika",category:"ad",domains:["*.chitika.net"]},{name:"ChoiceStream",category:"ad",domains:["*.choicestream.com"]},{name:"Cint",category:"social",domains:["*.cint.com"],totalExecutionTime:111659,totalOccurrences:33},{name:"Civic",category:"hosting",domains:["*.civiccomputing.com"],totalExecutionTime:2815742,totalOccurrences:7253},{name:"ClearRise",category:"customer-success",domains:["*.clearrise.com"]},{name:"Clearstream",category:"ad",domains:["*.clrstm.com"]},{name:"Clerk.io ApS",category:"analytics",domains:["*.clerk.io"],totalExecutionTime:1196778,totalOccurrences:1915},{name:"CleverDATA",category:"ad",domains:["*.1dmp.io"]},{name:"CleverTap",category:"analytics",domains:["d2r1yp2w7bby2u.cloudfront.net"],totalExecutionTime:163519,
totalOccurrences:1321},{name:"Click Density",category:"analytics",domains:["*.clickdensity.com"]},{name:"Click4Assistance",category:"customer-success",domains:["*.click4assistance.co.uk"],totalExecutionTime:22710,totalOccurrences:178},{name:"ClickDesk",category:"customer-success",domains:["*.clickdesk.com","d1gwclp1pmzk26.cloudfront.net"],totalExecutionTime:74975,totalOccurrences:595},{name:"ClickDimensions",category:"ad",domains:["*.clickdimensions.com"],totalExecutionTime:125295,totalOccurrences:262},{name:"Clickadu (Winner Solutions)",category:"ad",domains:["*.clickadu.com"],totalExecutionTime:10740,totalOccurrences:4},{name:"Clickagy Audience Lab",company:"Clickagy",category:"ad",domains:["*.clickagy.com"],examples:["aorta.clickagy.com"],totalExecutionTime:44558,totalOccurrences:667},{name:"Clickio",category:"ad",domains:[]},{name:"Clicktale",category:"analytics",domains:["*.cdngc.net","*.clicktale.net"],examples:["clicktalecdn.sslcs.cdngc.net"],totalExecutionTime:288716,totalOccurrences:256},
{name:"Clicktripz",category:"content",domains:["*.clicktripz.com"],examples:["static.clicktripz.com","www.clicktripz.com"],totalExecutionTime:502041,totalOccurrences:354},{name:"Clik.com Websites",category:"content",domains:["*.clikpic.com"]},{name:"Cloud Technologies",category:"ad",domains:["*.behavioralengine.com","*.behavioralmailing.com"]},{name:"Cloud-A",category:"other",domains:["*.bulkstorage.ca"]},{name:"Cloud.typography",company:"Hoefler &amp; Co",category:"cdn",domains:["*.typography.com"],totalExecutionTime:3308,totalOccurrences:364},{name:"CloudSponge",category:"ad",domains:["*.cloudsponge.com"]},{name:"CloudVPS",category:"other",domains:["*.adoftheyear.com","*.objectstore.eu"]},{name:"Cloudinary",category:"content",domains:["*.cloudinary.com"],totalExecutionTime:1188126,totalOccurrences:2129},{name:"Cloudqp",company:"Cloudwp",category:"other",domains:["*.cloudwp.io"]},{name:"Cludo",category:"utility",domains:["*.cludo.com"],totalExecutionTime:25376,totalOccurrences:249},{name:"\
Cognesia",category:"marketing",domains:["*.intelli-direct.com"]},{name:"CogoCast",company:"Cogo Labs",category:"ad",domains:["*.cogocast.net"]},{name:"Colbenson",category:"utility",domains:["*.colbenson.com"]},{name:"Collective",category:"ad",domains:["*.collective-media.net"]},{name:"Com Laude",category:"other",domains:["*.gdimg.net"]},{name:"Comm100",category:"customer-success",domains:["*.comm100.com"],totalExecutionTime:469389,totalOccurrences:1045},{name:"CommerceHub",category:"marketing",domains:["*.mercent.com"]},{name:"Commission Factory",category:"ad",domains:["*.cfjump.com"],totalExecutionTime:961,totalOccurrences:12},{name:"Communicator",category:"ad",domains:["*.communicatorcorp.com","*.communicatoremail.com"]},{name:"Comodo",category:"utility",domains:["*.comodo.com","*.trust-provider.com","*.trustlogo.com","*.usertrust.com","*.comodo.net"],examples:["ocsp.trust-provider.com"],totalExecutionTime:41752,totalOccurrences:34},{name:"Comodo Certificate Authority",company:"Comod\
o",category:"utility",domains:["crt.comodoca.com","*.comodoca4.com","ocsp.comodoca.com","ocsp.usertrust.com","crt.usertrust.com"],examples:["ocsp.comodoca4.com"]},{name:"Compete",company:"Millwood Brown Digital",category:"analytics",domains:["*.c-col.com","*.compete.com"]},{name:"Compuware",category:"analytics",domains:["*.axf8.net"]},{name:"Conductrics",category:"analytics",domains:["*.conductrics.com"],examples:["cdn-v3.conductrics.com"],totalExecutionTime:12705,totalOccurrences:61},{name:"Confirmit",category:"analytics",domains:["*.confirmit.com"],totalExecutionTime:32100,totalOccurrences:195},{name:"Connatix",category:"ad",domains:["*.connatix.com"],totalExecutionTime:6751327,totalOccurrences:1195},{name:"Connect Events",category:"hosting",domains:["*.connectevents.com.au"]},{name:"Constant Contact",category:"ad",domains:["*.ctctcdn.com"],totalExecutionTime:604932,totalOccurrences:17528},{name:"Constructor.io",category:"utility",domains:["*.cnstrc.com"]},{name:"Contabo",category:"h\
osting",domains:["185.2.100.179"]},{name:"Content Media Corporation",category:"content",domains:["*.contentmedia.eu"]},{name:"ContentSquare",category:"analytics",domains:["d1m6l9dfulcyw7.cloudfront.net","*.content-square.net","*.contentsquare.net"],totalExecutionTime:3626830,totalOccurrences:2948},{name:"ContextWeb",category:"ad",domains:["*.contextweb.com"],totalExecutionTime:32437,totalOccurrences:1909},{name:"Continental Exchange Solutions",category:"utility",domains:["*.hifx.com"]},{name:"Converge-Digital",category:"ad",domains:["*.converge-digital.com"],examples:["ads.converge-digital.com"]},{name:"Conversant",category:"analytics",domains:["*.dotomi.com","*.dtmpub.com","*.emjcd.com","mediaplex.com","*.tqlkg.com","*.fastclick.net"],examples:["www.tqlkg.com"],totalExecutionTime:6531550,totalOccurrences:54802},{name:"Conversant Ad Server",company:"Conversant",category:"ad",domains:["adfarm.mediaplex.com","*.mediaplex.com"]},{name:"Conversant Tag Manager",company:"Conversant",category:"\
tag-manager",domains:["*.mplxtms.com"],totalExecutionTime:14146,totalOccurrences:58},{name:"Conversio",category:"ad",domains:["*.conversio.com"]},{name:"Conversion Labs",category:"ad",domains:["*.net.pl"],examples:["conversionlabs.net.pl"],totalExecutionTime:3243395,totalOccurrences:1898},{name:"Conversion Logic",category:"ad",domains:["*.conversionlogic.net"]},{name:"Convert Insights",category:"analytics",domains:["*.convertexperiments.com"],totalExecutionTime:2575826,totalOccurrences:4385},{name:"ConvertMedia",category:"ad",domains:["*.admailtiser.com","*.basebanner.com","*.cmbestsrv.com","*.vidfuture.com","*.zorosrv.com"],examples:["www.cmbestsrv.com"]},{name:"Convertro",category:"ad",domains:["*.convertro.com"]},{name:"Conviva",category:"content",domains:["*.conviva.com"],totalExecutionTime:2955,totalOccurrences:2},{name:"Cookie Reports",category:"utility",domains:["*.cookiereports.com"],totalExecutionTime:280810,totalOccurrences:671},{name:"Cookie-Script.com",category:"utility",domains:[
"*.cookie-script.com"],totalExecutionTime:15051619,totalOccurrences:58095},{name:"CookieQ",company:"Baycloud Systems",category:"utility",domains:["*.cookieq.com"]},{name:"CoolaData",category:"analytics",domains:["*.cooladata.com"],totalExecutionTime:1165,totalOccurrences:15},{name:"CopperEgg",category:"analytics",domains:["*.copperegg.com","d2vig74li2resi.cloudfront.net"]},{name:"Council ad Network",category:"ad",domains:["*.counciladvertising.net"],totalExecutionTime:18621,totalOccurrences:94},{name:"Covert Pics",category:"content",domains:["*.covet.pics"],totalExecutionTime:4496,totalOccurrences:55},{name:"Cox Digital Solutions",category:"ad",domains:["*.afy11.net"]},{name:"Creafi Online Media",category:"ad",domains:["*.creafi-online-media.com"]},{name:"Creators",category:"content",domains:["*.creators.co"]},{name:"Crimson Hexagon Analytics",company:"Crimson Hexagon",category:"analytics",domains:["*.hexagon-analytics.com"]},{name:"Crimtan",category:"ad",domains:["*.ctnsnet.com"],totalExecutionTime:59150,
totalOccurrences:74818},{name:"Cross Pixel Media",category:"ad",domains:["*.crsspxl.com"],totalExecutionTime:493,totalOccurrences:8},{name:"Crosswise",category:"ad",domains:["*.univide.com"],examples:["p.univide.com"]},{name:"Crowd Control",company:"Lotame",category:"ad",domains:["*.crwdcntrl.net"],totalExecutionTime:16298725,totalOccurrences:101196},{name:"Crowd Ignite",category:"ad",domains:["*.crowdignite.com"]},{name:"CrowdTwist",category:"ad",domains:["*.crowdtwist.com"]},{name:"Crowdskout",category:"ad",domains:["*.crowdskout.com"]},{name:"Crowdynews",category:"social",domains:["*.breakingburner.com"]},{name:"Curalate",category:"marketing",domains:["*.curalate.com","d116tqlcqfmz3v.cloudfront.net"],totalExecutionTime:628884,totalOccurrences:683},{name:"Customer Acquisition Cloud",company:"[24]7",category:"ad",domains:["*.campanja.com"]},{name:"Customer.io",category:"ad",domains:["*.customer.io"],totalExecutionTime:210609,totalOccurrences:1268},{name:"Custora",category:"analytics",
domains:["*.custora.com"]},{name:"Cxense",category:"ad",domains:["*.cxense.com","*.cxpublic.com","*.emediate.dk","*.emediate.eu"],totalExecutionTime:2218364,totalOccurrences:3708},{name:"CyberKnight",company:"Namogoo",category:"utility",domains:["*.namogoo.com"]},{name:"CyberSource (Visa)",category:"utility",domains:["*.authorize.net"],totalExecutionTime:339030,totalOccurrences:2682},{name:"Cybernet Quest",category:"analytics",domains:["*.cqcounter.com"]},{name:"D.A. Consortium",category:"ad",domains:["*.eff1.net"]},{name:"D4t4 Solutions",category:"analytics",domains:["*.u5e.com"]},{name:"DCSL Software",category:"hosting",domains:["*.dcslsoftware.com"]},{name:"DMG Media",category:"content",domains:["*.mol.im","*.and.co.uk","*.anm.co.uk","*.dailymail.co.uk"],totalExecutionTime:37855,totalOccurrences:15},{name:"DTSCOUT",category:"ad",domains:["*.dtscout.com"],totalExecutionTime:645362,totalOccurrences:8311},{name:"Dailykarma",category:"utility",homepage:"https://www.dailykarma.com/",domains:[
"*.dailykarma.io"],examples:["assets.dailykarma.io"],totalExecutionTime:122378,totalOccurrences:477},{name:"Dailymotion",category:"content",domains:["*.dailymotion.com","*.dmxleo.com","*.dm.gg","*.pxlad.io","*.dmcdn.net","*.sublimevideo.net"],examples:["ad.pxlad.io","www.dailymotion.com"],totalExecutionTime:56076026,totalOccurrences:5142},{name:"Dash Hudson",company:"Dash Hudson",category:"content",domains:["*.dashhudson.com"],examples:["cdn.dashhudson.com"],totalExecutionTime:154963,totalOccurrences:91},{name:"Datacamp",category:"utility",domains:["*.cdn77.org"],totalExecutionTime:3303608,totalOccurrences:1181},{name:"Datalicious",category:"tag-manager",domains:["*.supert.ag","*.optimahub.com"]},{name:"Datalogix",category:"ad",domains:["*.nexac.com"]},{name:"Datawrapper",category:"utility",domains:["*.datawrapper.de","*.dwcdn.net"],examples:["www.datawrapper.de"],totalExecutionTime:951486,totalOccurrences:249},{name:"Dataxu",category:"marketing",domains:["*.w55c.net"],totalExecutionTime:10,
totalOccurrences:5},{name:"DatoCMS",homepage:"https://www.datocms.com/",category:"content",domains:["*.datocms-assets.com"],examples:["www.datocms-assets.com"]},{name:"Datonics",category:"ad",domains:["*.pro-market.net"],examples:["pbid.pro-market.net"],totalExecutionTime:16955,totalOccurrences:254},{name:"Dealtime",category:"content",domains:["*.dealtime.com"]},{name:"Debenhams Geo Location",company:"Debenhams",category:"utility",domains:["176.74.183.134"]},{name:"Decibel Insight",category:"analytics",domains:["*.decibelinsight.net"],totalExecutionTime:995190,totalOccurrences:691},{name:"Deep Forest Media",company:"Rakuten",category:"ad",domains:["*.dpclk.com"]},{name:"DeepIntent",category:"ad",domains:["*.deepintent.com"],totalExecutionTime:3875,totalOccurrences:206},{name:"Delicious Media",category:"social",domains:["*.delicious.com"]},{name:"Delineo",category:"ad",domains:["*.delineo.com"],examples:["www.delineo.com"]},{name:"Delta Projects AB",category:"ad",domains:["*.de17a.com"],
totalExecutionTime:90548,totalOccurrences:382},{name:"Demand Media",category:"content",domains:["*.dmtracker.com"]},{name:"DemandBase",category:"marketing",domains:["*.demandbase.com"],totalExecutionTime:393206,totalOccurrences:2552},{name:"DemandJump",category:"analytics",domains:["*.demandjump.com"]},{name:"Dennis Publishing",category:"content",domains:["*.alphr.com"]},{name:"Devatics",category:"analytics",domains:["*.devatics.com","*.devatics.io"]},{name:"Developer Media",category:"ad",domains:["*.developermedia.com"],totalExecutionTime:4416,totalOccurrences:17},{name:"DialogTech",category:"ad",domains:["*.dialogtech.com"]},{name:"DialogTech SourceTrak",company:"DialogTech",category:"ad",domains:["d31y97ze264gaa.cloudfront.net"]},{name:"DigiCert",category:"utility",domains:["*.digicert.com"],examples:["ocsp.digicert.com"],totalExecutionTime:26560,totalOccurrences:83},{name:"Digioh",category:"ad",domains:["*.lightboxcdn.com"],totalExecutionTime:1347082,totalOccurrences:1303},{name:"D\
igital Look",category:"content",domains:["*.digitallook.com"]},{name:"Digital Media Exchange",company:"NDN",category:"content",domains:["*.newsinc.com"]},{name:"Digital Millennium Copyright Act Services",category:"utility",domains:["*.dmca.com"],totalExecutionTime:8820,totalOccurrences:70},{name:"Digital Ocean",category:"other",domains:["95.85.62.56"]},{name:"Digital Remedy",category:"ad",domains:["*.consumedmedia.com"]},{name:"Digital Window",category:"ad",domains:["*.awin1.com","*.zenaps.com"],totalExecutionTime:195,totalOccurrences:4},{name:"DigitalScirocco",category:"analytics",domains:["*.digitalscirocco.net"]},{name:"Digitial Point",category:"utility",domains:["*.dpstatic.com"]},{name:"Diligent (Adnetik)",category:"ad",domains:["*.wtp101.com"]},{name:"Directed Edge",category:"social",domains:["*.directededge.com"],examples:["shopify.directededge.com"],totalExecutionTime:8371,totalOccurrences:81},{name:"Distribute Travel",category:"ad",domains:["*.dtrck.net"]},{name:"District M",category:"\
ad",domains:["*.districtm.io"]},{name:"DistroScale",category:"ad",domains:["*.jsrdn.com"],totalExecutionTime:186009,totalOccurrences:198},{name:"Divido",category:"utility",domains:["*.divido.com"]},{name:"Dow Jones",category:"content",domains:["*.dowjones.com","*.dowjoneson.com"]},{name:"Drifty Co",category:"utility",domains:["*.onicframework.com"]},{name:"Drip",company:"The Numa Group",category:"ad",domains:["*.getdrip.com"],totalExecutionTime:120918,totalOccurrences:1350},{name:"Dropbox",category:"utility",domains:["*.dropboxusercontent.com"],totalExecutionTime:142552,totalOccurrences:145},{name:"Dyn Real User Monitoring",company:"Dyn",category:"analytics",domains:["*.jisusaiche.biz","*.dynapis.com","*.jisusaiche.com","*.dynapis.info"],examples:["beacon.rum.dynapis.com"]},{name:"DynAdmic",category:"ad",domains:["*.dyntrk.com"]},{name:"Dynamic Converter",category:"utility",domains:["*.dynamicconverter.com"],totalExecutionTime:58723,totalOccurrences:96},{name:"Dynamic Dummy Image Gener\
ator",company:"Open Source",category:"utility",domains:["*.dummyimage.com"]},{name:"Dynamic Logic",category:"ad",domains:["*.dl-rms.com","*.questionmarket.com"]},{name:"Dynamic Yield",category:"customer-success",domains:["*.dynamicyield.com"],totalExecutionTime:3580074,totalOccurrences:1843},{name:"Dynatrace",category:"analytics",domains:["*.ruxit.com","js-cdn.dynatrace.com"],totalExecutionTime:4106731,totalOccurrences:3221},{name:"ec-concier",homepage:"https://ec-concier.com/",category:"marketing",domains:["*.ec-concier.com"],examples:["s.ec-concier.com","gsync.ec-concier.com"]},{name:"ECT News Network",category:"content",domains:["*.ectnews.com"]},{name:"ELITechGroup",category:"analytics",domains:["*.elitechnology.com"]},{name:"EMAP",category:"content",domains:["*.emap.com"]},{name:"EMedia Solutions",category:"ad",domains:["*.e-shots.eu"],examples:["www.e-shots.eu"]},{name:"EQ works",category:"ad",domains:["*.eqads.com"]},{name:"ESV Digital",category:"analytics",domains:["*.esearchvi\
sion.com"]},{name:"Ebiquity",category:"analytics",domains:["*.ebiquitymedia.com"]},{name:"Eco Rebates",category:"ad",domains:["*.ecorebates.com"]},{name:"Ecwid",category:"hosting",domains:["*.ecwid.com","*.shopsettings.com","d3fi9i0jj23cau.cloudfront.net","d3j0zfs7paavns.cloudfront.net"],totalExecutionTime:3757012,totalOccurrences:4362},{name:"Edge Web Fonts",company:"Adobe Systems",category:"cdn",domains:["*.edgefonts.net"],examples:["use.edgefonts.net"]},{name:"Edition Digital",category:"ad",domains:["*.editiondigital.com"]},{name:"Edot Web Technologies",category:"hosting",domains:["*.edot.co.za"]},{name:"Effective Measure",category:"ad",domains:["*.effectivemeasure.net"],totalExecutionTime:17,totalOccurrences:1},{name:"Effiliation sa",category:"ad",domains:["*.effiliation.com"],totalExecutionTime:108,totalOccurrences:3},{name:"Ekm Systems",category:"analytics",domains:["*.ekmsecure.com","*.ekmpinpoint.co.uk"],examples:["globalstats.ekmsecure.com"],totalExecutionTime:67875,totalOccurrences:789},
{name:"Elastera",category:"hosting",domains:["*.elastera.net"]},{name:"Elastic Ad",category:"ad",domains:["*.elasticad.net"],totalExecutionTime:30225,totalOccurrences:137},{name:"Elastic Load Balancing",company:"Amazon Web Services",category:"hosting",domains:["*.105app.com"],examples:["rhpury.105app.com","rhxtd.105app.com"]},{name:"Elecard StreamEye",company:"Elecard",category:"other",domains:["*.streameye.net"]},{name:"Elevate",company:"Elevate Technology Solutions",category:"utility",domains:["*.elevaate.technology"]},{name:"Elicit",category:"utility",domains:["*.elicitapp.com"]},{name:"Elogia",category:"ad",domains:["*.elogia.net"]},{name:"Email Attitude",company:"1000mercis",category:"ad",domains:["*.email-attitude.com"]},{name:"EmailCenter",category:"ad",domains:["*.emailcenteruk.com"]},{name:"Embedly",category:"content",domains:["*.embedly.com","*.embed.ly"],totalExecutionTime:5014487,totalOccurrences:10836},{name:"EmpathyBroker Site Search",company:"EmpathyBroker",category:"uti\
lity",domains:["*.empathybroker.com"]},{name:"Enfusen",category:"analytics",domains:["*.enfusen.com"]},{name:"Engadget",company:"Engadget (AOL)",category:"content",domains:["*.gdgt.com"],examples:["media.gdgt.com"]},{name:"Engagio",category:"marketing",domains:["*.engagio.com"]},{name:"Ensighten Manage",company:"Ensighten",category:"tag-manager",domains:["*.levexis.com"]},{name:"EntityLink",category:"other",domains:["*.entitytag.co.uk"]},{name:"Entrust Datacard",category:"utility",domains:["*.entrust.com","*.entrust.net"],examples:["ocsp.entrust.com","ocsp.entrust.net"],totalExecutionTime:14041,totalOccurrences:3},{name:"Equiniti",category:"utility",domains:["*.equiniti.com"]},{name:"Errorception",category:"utility",domains:["*.errorception.com"]},{name:"Esri ArcGIS",company:"Esri",category:"utility",domains:["*.arcgis.com","*.arcgisonline.com"],totalExecutionTime:21967746,totalOccurrences:3432},{name:"Ethnio",category:"analytics",domains:["*.ethn.io"]},{name:"Eulerian Technologies",category:"\
ad",domains:["*.eolcdn.com"]},{name:"Euroland",category:"utility",domains:["*.euroland.com"],totalExecutionTime:1,totalOccurrences:3},{name:"European Interactive Digital ad Alli",category:"utility",domains:["*.edaa.eu"]},{name:"Eventbrite",category:"hosting",domains:["*.evbuc.com","*.eventbrite.co.uk"],totalExecutionTime:4667,totalOccurrences:33},{name:"Everflow",category:"analytics",domains:["*.tp88trk.com"],examples:["www.tp88trk.com"],totalExecutionTime:110842,totalOccurrences:185},{name:"Evergage",category:"analytics",domains:["*.evergage.com","*.evgnet.com"],examples:["cdn.evgnet.com"],totalExecutionTime:1095634,totalOccurrences:2491},{name:"Everquote",category:"content",domains:["*.evq1.com"]},{name:"Everyday Health",category:"ad",domains:["*.agoramedia.com"]},{name:"Evidon",category:"analytics",domains:["*.evidon.com"],totalExecutionTime:1260409,totalOccurrences:2482},{name:"Evolve Media",category:"content",domains:["*.evolvemediallc.com"]},{name:"Exactag",category:"ad",domains:[
"*.exactag.com"],totalExecutionTime:662,totalOccurrences:6},{name:"ExoClick",category:"ad",domains:["*.exoclick.com"],totalExecutionTime:69348,totalOccurrences:568},{name:"Expedia",category:"content",domains:["*.travel-assets.com","*.trvl-media.com","*.trvl-px.com","*.uciservice.com"],examples:["www.trvl-px.com","www.uciservice.com"],totalExecutionTime:15443,totalOccurrences:15},{name:"Expedia Australia",company:"Expedia",category:"content",domains:["*.expedia.com.au"],examples:["www.expedia.com.au"]},{name:"Expedia Canada",company:"Expedia",category:"content",domains:["*.expedia.ca"],examples:["www.expedia.ca"]},{name:"Expedia France",company:"Expedia",category:"content",domains:["*.expedia.fr"],examples:["www.expedia.fr"]},{name:"Expedia Germany",company:"Expedia",category:"content",domains:["*.expedia.de"],examples:["www.expedia.de"]},{name:"Expedia Italy",company:"Expedia",category:"content",domains:["*.expedia.it"],examples:["www.expedia.it"]},{name:"Expedia Japan",company:"Expedi\
a",category:"content",domains:["*.expedia.co.jp"],examples:["www.expedia.co.jp"]},{name:"Expedia USA",company:"Expedia",category:"content",domains:["*.expedia.com"],examples:["www.expedia.com"],totalExecutionTime:40062,totalOccurrences:19},{name:"Expedia United Kingdom",company:"Expedia",category:"content",domains:["*.expedia.co.uk"],examples:["www.expedia.co.uk"]},{name:"Experian",category:"utility",domains:["*.audienceiq.com","*.experian.com","*.experianmarketingservices.digital"]},{name:"Experian Cross-Channel Marketing Platform",company:"Experian",category:"marketing",domains:["*.eccmp.com","*.ccmp.eu"],totalExecutionTime:1268,totalOccurrences:24},{name:"Exponea",category:"analytics",domains:["*.exponea.com"],totalExecutionTime:154832,totalOccurrences:1303},{name:"Exponential Interactive",category:"ad",domains:["*.exponential.com"],totalExecutionTime:5179,totalOccurrences:120},{name:"Extensis WebInk",category:"cdn",domains:["*.webink.com"]},{name:"Extole",category:"ad",domains:["*.\
extole.com","*.extole.io"],examples:["origin.extole.io"],totalExecutionTime:21067,totalOccurrences:44},{name:"Ey-Seren",category:"analytics",domains:["*.webabacus.com"]},{name:"EyeView",category:"ad",domains:["*.eyeviewads.com"]},{name:"Eyeota",category:"ad",domains:["*.eyeota.net"],totalExecutionTime:152570,totalOccurrences:1827},{name:"Ezakus Pretargeting",company:"Ezakus",category:"ad",domains:["*.ezakus.net"]},{name:"Ezoic",category:"analytics",domains:["*.ezoic.net"],totalExecutionTime:93024,totalOccurrences:173},{name:"FLXone",company:"Teradata",category:"ad",domains:["*.pangolin.blue","*.flx1.com","d2hlpp31teaww3.cloudfront.net","*.flxpxl.com"],totalExecutionTime:25037,totalOccurrences:67},{name:"Fairfax Media",category:"content",domains:["ads.fairfax.com.au","resources.fairfax.com.au"]},{name:"Fairfax Media Analtics",company:"Fairfax Media",category:"analytics",domains:["analytics.fairfax.com.au"]},{name:"Falk Technologies",category:"ad",domains:["*.angsrvr.com"]},{name:"Fanpla\
yr",category:"analytics",domains:["*.fanplayr.com","d38nbbai6u794i.cloudfront.net"],totalExecutionTime:69669,totalOccurrences:154},{name:"Fast Thinking",company:"NE Marketing",category:"marketing",domains:["*.fast-thinking.co.uk"]},{name:"Fastest Forward",category:"analytics",domains:["*.gaug.es"],totalExecutionTime:13583,totalOccurrences:261},{name:"Fastly",category:"utility",domains:["*.fastly.net"],totalExecutionTime:21362072,totalOccurrences:9582},{name:"Feedbackify",company:"InsideMetrics",category:"analytics",domains:["*.feedbackify.com"],totalExecutionTime:42808,totalOccurrences:173},{name:"Feefo.com",company:"Feefo",category:"analytics",domains:["*.feefo.com"],totalExecutionTime:1362284,totalOccurrences:2025},{name:"Fidelity Media",category:"ad",domains:["*.fidelity-media.com"],examples:["x.fidelity-media.com"]},{name:"Filestack",category:"content",domains:["*.filepicker.io"],examples:["api.filepicker.io","dialog.filepicker.io","www.filepicker.io"],totalExecutionTime:27297,totalOccurrences:200},
{name:"Finsbury Media",category:"ad",domains:["*.finsburymedia.com"],totalExecutionTime:3470,totalOccurrences:12},{name:"Firepush",category:"utility",domains:["*.firepush.io"]},{name:"FirstImpression",category:"ad",domains:["*.firstimpression.io"],totalExecutionTime:141056,totalOccurrences:107},{name:"Fit Analytics",category:"other",domains:["*.fitanalytics.com"],examples:["integrations.fitanalytics.com","widget.fitanalytics.com","metrics.fitanalytics.com"]},{name:"Fits Me",category:"analytics",domains:["*.fits.me"]},{name:"Fivetran",category:"analytics",domains:["*.fivetran.com"],totalExecutionTime:2922,totalOccurrences:3},{name:"FlexShopper",category:"utility",domains:["*.flexshopper.com"]},{name:"Flickr",category:"content",domains:["*.flickr.com","*.staticflickr.com"],totalExecutionTime:262262,totalOccurrences:524},{name:"Flipboard",category:"social",domains:["*.flipboard.com"],totalExecutionTime:50049,totalOccurrences:41},{name:"Flipdesk",category:"customer-success",homepage:"https\
://flipdesk.jp/",domains:["*.flipdesk.jp"],examples:["api.flipdesk.jp"],totalExecutionTime:322297,totalOccurrences:411},{name:"Flipp",category:"analytics",domains:["*.wishabi.com","d2e0sxz09bo7k2.cloudfront.net","*.wishabi.net"]},{name:"Flite",category:"ad",domains:["*.flite.com"]},{name:"Flixmedia",category:"analytics",domains:["*.flix360.com","*.flixcar.com","*.flixfacts.com","*.flixsyndication.net","*.flixfacts.co.uk"],totalExecutionTime:32827,totalOccurrences:19},{name:"Flockler",category:"ad",domains:["*.flockler.com"],totalExecutionTime:504051,totalOccurrences:1297},{name:"Flowplayer",category:"content",domains:["*.flowplayer.org"],totalExecutionTime:218859,totalOccurrences:862},{name:"Flowzymes Ky",category:"cdn",domains:["*.jquerytools.org"]},{name:"Fomo",category:"ad",domains:["*.notifyapp.io"]},{name:"Fonecall",category:"analytics",domains:["*.web-call-analytics.com"]},{name:"Fontdeck",category:"cdn",domains:["*.fontdeck.com"]},{name:"Foodity Technologies",category:"ad",domains:[
"*.foodity.com"]},{name:"Force24",category:"ad",domains:["*.force24.co.uk"],totalExecutionTime:10225,totalOccurrences:112},{name:"ForeSee",company:"Answers",category:"analytics",domains:["*.4seeresults.com","*.answerscloud.com","*.foresee.com","*.foreseeresults.com"],totalExecutionTime:179704,totalOccurrences:266},{name:"Forensiq",category:"utility",domains:["*.fqtag.com"],totalExecutionTime:21937,totalOccurrences:171},{name:"Fort Awesome",category:"cdn",domains:["*.fortawesome.com"],totalExecutionTime:652365,totalOccurrences:3635},{name:"Forter",category:"utility",domains:["*.forter.com"],totalExecutionTime:6578955,totalOccurrences:6930},{name:"Forward Internet Group",category:"hosting",domains:["*.f3d.io"]},{name:"Forward3D",category:"ad",domains:["*.forward3d.com"]},{name:"Fospha",category:"analytics",domains:["*.fospha.com"],examples:["router.fospha.com"]},{name:"Foursixty",category:"customer-success",domains:["*.foursixty.com"]},{name:"FoxyCart",category:"utility",domains:["*.foxy\
cart.com"],totalExecutionTime:361777,totalOccurrences:669},{name:"Fraudlogix",category:"utility",domains:["*.yabidos.com"],totalExecutionTime:47637,totalOccurrences:357},{name:"FreakOut",category:"ad",domains:["*.fout.jp"],totalExecutionTime:114328,totalOccurrences:2036},{name:"Freespee",category:"customer-success",domains:["*.freespee.com"],examples:["analytics.freespee.com"],totalExecutionTime:67626,totalOccurrences:484},{name:"Freetobook",category:"content",domains:["*.freetobook.com"],examples:["www.freetobook.com"],totalExecutionTime:297146,totalOccurrences:649},{name:"Fresh 8 Gaming",category:"ad",domains:["*.fresh8.co"],totalExecutionTime:319849,totalOccurrences:76},{name:"Fresh Relevance",category:"analytics",domains:["*.freshrelevance.com","*.cloudfront.ne","d1y9qtn9cuc3xw.cloudfront.net","d81mfvml8p5ml.cloudfront.net","dkpklk99llpj0.cloudfront.net"],examples:["d1y9qtn9cuc3xw.cloudfront.ne"],totalExecutionTime:91181,totalOccurrences:300},{name:"Friendbuy",category:"ad",domains:[
"*.friendbuy.com","djnf6e5yyirys.cloudfront.net"],totalExecutionTime:17783,totalOccurrences:150},{name:"Frienefit",category:"ad",domains:["*.frienefit.com"]},{name:"FuelX",category:"ad",domains:["*.fuelx.com"]},{name:"Full Circle Studies",category:"analytics",domains:["*.securestudies.com"]},{name:"FullStory",category:"analytics",domains:["*.fullstory.com"],examples:["rs.fullstory.com"],totalExecutionTime:11575233,totalOccurrences:14687},{name:"Fyber",category:"ad",domains:["*.fyber.com"]},{name:"G-Forces Web Management",category:"hosting",domains:["*.gforcesinternal.co.uk"]},{name:"G4 Native",company:"Gravity4",category:"ad",domains:["*.triggit.com"]},{name:"GET ME IN!  (TicketMaster)",category:"content",domains:["*.getmein.com"]},{name:"GIPHY",category:"content",domains:["*.giphy.com"],totalExecutionTime:4831,totalOccurrences:6},{name:"GainCloud",company:"GainCloud Systems",category:"other",domains:["*.egaincloud.net"]},{name:"Gath Adams",category:"content",domains:["*.iwantthatfligh\
t.com.au"]},{name:"Gecko Tribe",category:"social",domains:["*.geckotribe.com"]},{name:"Gemius",category:"ad",domains:["*.gemius.pl"],totalExecutionTime:2964756,totalOccurrences:15596},{name:"Genesis Media",category:"ad",domains:["*.bzgint.com","*.genesismedia.com","*.genesismediaus.com"]},{name:"Genie Ventures",category:"ad",domains:["*.genieventures.co.uk"]},{name:"Geniee",category:"ad",domains:["*.href.asia","*.genieessp.jp","*.genieesspv.jp","*.gssprt.jp"],examples:["cs.gssprt.jp"],totalExecutionTime:16956055,totalOccurrences:16354},{name:"Geniuslink",category:"analytics",domains:["*.geni.us"],totalExecutionTime:897,totalOccurrences:3},{name:"GeoRiot",category:"other",domains:["*.georiot.com"]},{name:"GeoTrust",category:"utility",domains:["*.geotrust.com"],totalExecutionTime:3300,totalOccurrences:2},{name:"Geoplugin",category:"utility",domains:["*.geoplugin.com","*.geoplugin.net"],totalExecutionTime:119,totalOccurrences:3},{name:"Georeferencer",company:"Klokan Technologies",category:"\
utility",domains:["*.georeferencer.com"]},{name:"GetIntent RTBSuite",company:"GetIntent",category:"ad",domains:["*.adhigh.net"],totalExecutionTime:2768,totalOccurrences:356},{name:"GetResponse",category:"ad",domains:["*.getresponse.com"],totalExecutionTime:209076,totalOccurrences:1019},{name:"GetSiteControl",company:"GetWebCraft",category:"utility",domains:["*.getsitecontrol.com"],totalExecutionTime:1739288,totalOccurrences:3146},{name:"GetSocial",category:"social",domains:["*.getsocial.io"],totalExecutionTime:1204,totalOccurrences:11},{name:"Getty Images",category:"content",domains:["*.gettyimages.com","*.gettyimages.co.uk"],examples:["www.gettyimages.com"],totalExecutionTime:17939,totalOccurrences:65},{name:"Gfycat",company:"Gycat",category:"utility",domains:["*.gfycat.com"]},{name:"Ghostery Enterprise",company:"Ghostery",category:"marketing",domains:["*.betrad.com"],totalExecutionTime:1129,totalOccurrences:26},{name:"Giant Media",category:"ad",domains:["*.videostat.com"]},{name:"Gig\
ya",category:"analytics",domains:["*.gigya.com"],totalExecutionTime:2692493,totalOccurrences:1995},{name:"GitHub",category:"utility",domains:["*.github.com","*.githubusercontent.com","*.github.io","*.rawgit.com"],examples:["raw.githubusercontent.com","cdn.rawgit.com"],totalExecutionTime:7126491,totalOccurrences:14675},{name:"Gladly",company:"Gladly",homepage:"https://www.gladly.com/",category:"customer-success",domains:["*.gladly.com"],examples:["cdn.gladly.com"],totalExecutionTime:240417,totalOccurrences:381},{name:"Glassdoor",category:"content",domains:["*.glassdoor.com"],totalExecutionTime:68877,totalOccurrences:19},{name:"Gleam",category:"marketing",domains:["*.gleam.io"],totalExecutionTime:43249,totalOccurrences:221},{name:"Global Digital Markets",category:"ad",domains:["*.gdmdigital.com"]},{name:"Global-e",category:"hosting",domains:["*.global-e.com"],totalExecutionTime:706185,totalOccurrences:1314},{name:"GlobalSign",category:"utility",domains:["*.globalsign.com","*.globalsign.n\
et"],totalExecutionTime:11228,totalOccurrences:48},{name:"GlobalWebIndex",category:"analytics",domains:["*.globalwebindex.net"]},{name:"Globase International",category:"ad",domains:["*.globase.com"]},{name:"GoDataFeed",category:"other",domains:["*.godatafeed.com"]},{name:"Google APIs",company:"Google",category:"utility",domains:["googleapis.com"]},{name:"Google Ad Block Detection",company:"Google",category:"ad",domains:["*.0emn.com","*.0fmm.com"]},{name:"Google Analytics Experiments",company:"Google",category:"analytics",domains:["*.gexperiments1.com"]},{name:"Google DoubleClick Ad Exchange",company:"Google",category:"ad",domains:["*.admeld.com"]},{name:"Google IPV6 Metrics",company:"Google",category:"analytics",domains:["*.ipv6test.net"]},{name:"Google Plus",company:"Google",category:"social",domains:["plus.google.com"],totalExecutionTime:49945,totalOccurrences:442},{name:"Google Trusted Stores",company:"Google",category:"utility",domains:["*.googlecommerce.com"],totalExecutionTime:218,
totalOccurrences:5},{name:"Google Video",company:"Google",category:"content",domains:["*.googlevideo.com"],totalExecutionTime:4,totalOccurrences:3},{name:"Google reCAPTCHA",company:"Google",category:"utility",domains:["*.recaptcha.net"],examples:["api.recaptcha.net"],totalExecutionTime:8694396,totalOccurrences:25662},{name:"GovMetric",company:"ROL Solutions",category:"analytics",domains:["*.govmetric.com"],totalExecutionTime:233,totalOccurrences:6},{name:"Granify",category:"analytics",domains:["*.granify.com"],totalExecutionTime:19211,totalOccurrences:24},{name:"Grapeshot",category:"ad",domains:["*.gscontxt.net","*.grapeshot.co.uk"],totalExecutionTime:4945,totalOccurrences:4},{name:"Gravity (AOL)",category:"analytics",domains:["*.grvcdn.com"]},{name:"Groovy Gecko",category:"content",domains:["*.ggwebcast.com","*.groovygecko.net"]},{name:"GroupM",category:"ad",domains:["*.qservz.com"]},{name:"Guardian Media",category:"ad",domains:["*.theguardian.com","*.guardian.co.uk"],examples:["oas.t\
heguardian.com"]},{name:"GumGum",category:"ad",domains:["*.gumgum.com"],totalExecutionTime:3440651,totalOccurrences:167535},{name:"Gumtree",category:"content",domains:["*.gumtree.com"]},{name:"H264 Codec",company:"Cisco",category:"other",domains:["*.openh264.org"]},{name:"HERE",category:"analytics",domains:["*.medio.com"]},{name:"HP Optimost",company:"Hewlett-Packard Development Company",category:"marketing",domains:["*.hp.com","d2uncb19xzxhzx.cloudfront.net"],examples:["by.marketinghub.hp.com","marketinghub.hp.com"],totalExecutionTime:420577,totalOccurrences:100},{name:"Has Offers",company:"TUNE",category:"ad",domains:["*.go2cloud.org"],totalExecutionTime:0,totalOccurrences:3},{name:"Hawk Search",category:"utility",domains:["*.hawksearch.com"],totalExecutionTime:15097,totalOccurrences:132},{name:"Haymarket Media Group",category:"content",domains:["*.brandrepublic.com","*.hbpl.co.uk"]},{name:"Heap",category:"analytics",domains:["*.heapanalytics.com"],totalExecutionTime:5187800,totalOccurrences:12078},
{name:"Hearst Communications",category:"content",domains:["*.h-cdn.co","*.hearstdigital.com","*.hearstlabs.com","*.hearst.io","*.cdnds.net"]},{name:"Heatmap",category:"analytics",domains:["*.heatmap.it"],totalExecutionTime:7337,totalOccurrences:141},{name:"Heroku",category:"other",domains:["*.herokuapp.com"],totalExecutionTime:12602535,totalOccurrences:14119},{name:"Hexton",category:"utility",domains:["*.hextom.com"],totalExecutionTime:10806589,totalOccurrences:24738},{name:"Hibernia Networks",category:"utility",domains:["*.hiberniacdn.com"]},{name:"High Impact Media",category:"ad",domains:["*.reactx.com"]},{name:"Highcharts",category:"utility",domains:["*.highcharts.com"],totalExecutionTime:746540,totalOccurrences:3181},{name:"Highwinds",category:"utility",domains:["*.hwcdn.net"]},{name:"HitsLink",category:"analytics",domains:["*.hitslink.com"],totalExecutionTime:1452,totalOccurrences:29},{name:"Hola Networks",category:"other",domains:["*.h-cdn.com"],totalExecutionTime:83024,totalOccurrences:42},
{name:"Hootsuite",category:"analytics",domains:["*.hootsuite.com"]},{name:"HotUKDeals",category:"analytics",domains:["*.hotukdeals.com"]},{name:"HotWords",company:"Media Response Group",category:"ad",domains:["*.hotwords.com.br"]},{name:"HotelsCombined",category:"content",domains:["*.datahc.com"],totalExecutionTime:81,totalOccurrences:2},{name:"Hoverr",category:"ad",domains:["*.hoverr.media"]},{name:"Hull.js",category:"utility",domains:["*.hull.io","*.hullapp.io"]},{name:"Hupso Website Analyzer",company:"Hupso",category:"analytics",domains:["*.hupso.com"],totalExecutionTime:20892,totalOccurrences:248},{name:"I-Behavior",company:"WPP",category:"ad",domains:["*.ib-ibi.com"],totalExecutionTime:23,totalOccurrences:35},{name:"i-mobile",company:"i-mobile",category:"ad",domains:["*.i-mobile.co.jp"],examples:["ssp-sync.i-mobile.co.jp"],totalExecutionTime:3701005,totalOccurrences:16595},{name:"IBM Digital Analytics",company:"IBM",category:"analytics",domains:["*.cmcore.com","coremetrics.com","d\
ata.coremetrics.com","data.de.coremetrics.com","libs.de.coremetrics.com","tmscdn.de.coremetrics.com","iocdn.coremetrics.com","libs.coremetrics.com","tmscdn.coremetrics.com","*.s81c.com","*.unica.com","*.coremetrics.eu"],examples:["data.coremetrics.eu"],totalExecutionTime:126790,totalOccurrences:169},{name:"IBM Digital Data Exchange",company:"IBM",category:"tag-manager",domains:["tagmanager.coremetrics.com"]},{name:"IBM Tealeaf",company:"IBM",category:"analytics",domains:["*.ibmcloud.com"],examples:["uscollector.tealeaf.ibmcloud.com"]},{name:"IBM Acoustic Campaign",company:"IBM",category:"analytics",domains:["www.sc.pages01.net","www.sc.pages02.net","www.sc.pages03.net","www.sc.pages04.net","www.sc.pages05.net","www.sc.pages06.net","www.sc.pages07.net","www.sc.pages08.net","www.sc.pages09.net","www.sc.pagesA.net"],examples:["https://www.sc.pages01.net/lp/static/js/iMAWebCookie.js"],totalExecutionTime:51361,totalOccurrences:417},{name:"ICF Technology",category:"content",domains:["*.camad\
s.net"]},{name:"IFDNRG",category:"hosting",domains:["*.ifdnrg.com"]},{name:"IMRG",category:"analytics",domains:["*.peermap.com","*.imrg.org"],examples:["benchmarking.imrg.org"]},{name:"IPONWEB",category:"ad",domains:["*.company-target.com","*.liadm.com","*.iponweb.net","*.p161.net"],examples:["pool.udsp.iponweb.net"],totalExecutionTime:8924906,totalOccurrences:39154},{name:"IQ Mobile",category:"utility",domains:["*.iqm.cc"]},{name:"IS Group",category:"hosting",domains:["*.creative-serving.com"],totalExecutionTime:2127,totalOccurrences:29},{name:"IT Dienstleistungen Tim Prinzkosky",category:"utility",domains:["*.flaticons.net"]},{name:"IXI Digital",company:"Equifax",category:"ad",domains:["*.ixiaa.com"]},{name:"IcoMoon",category:"cdn",domains:["d19ayerf5ehaab.cloudfront.net","d1azc1qln24ryf.cloudfront.net"],totalExecutionTime:54286,totalOccurrences:180},{name:"IdenTrust",category:"utility",domains:["*.identrust.com"],totalExecutionTime:2334,totalOccurrences:1},{name:"Ido",category:"cust\
omer-success",domains:["*.idio.co"],totalExecutionTime:2222,totalOccurrences:12},{name:"Ignition One",category:"marketing",domains:["*.searchignite.com"]},{name:"ImageShack",category:"content",domains:["*.yfrog.com"]},{name:"Imagen Studio",category:"utility",domains:["*.telephonesky.com"]},{name:"Imagini Holdings",category:"ad",domains:["*.vdna-assets.com"]},{name:"Img Safe",category:"content",domains:["*.imgsafe.org"]},{name:"Imgur",category:"utility",domains:["*.imgur.com"],totalExecutionTime:3538,totalOccurrences:30},{name:"Impact Radius",category:"ad",domains:["*.impactradius-event.com","*.impactradius-go.com","*.7eer.net","d3cxv97fi8q177.cloudfront.net","*.evyy.net","*.ojrq.net","utt.impactcdn.com","*.sjv.io"],examples:["a.impactradius-go.com","microsoft-uk.evyy.net"],totalExecutionTime:612310,totalOccurrences:4274},{name:"Improve Digital",category:"ad",domains:["*.360yield.com"],totalExecutionTime:28784,totalOccurrences:732},{name:"Improvely",category:"analytics",domains:["*.iljm\
p.com"],totalExecutionTime:129,totalOccurrences:3},{name:"InMobi",category:"ad",domains:["*.inmobi.com"],totalExecutionTime:24607375,totalOccurrences:126087},{name:"InSkin Media",category:"ad",domains:["*.inskinad.com","*.inskinmedia.com"]},{name:"Inbenta",category:"customer-success",domains:["*.inbenta.com"],totalExecutionTime:3923,totalOccurrences:7},{name:"Incisive Media",category:"content",domains:["*.incisivemedia.com"]},{name:"Indeed",category:"content",domains:["*.indeed.com"],totalExecutionTime:81347,totalOccurrences:55},{name:"Index Exchange",company:"WPP",category:"ad",domains:["*.casalemedia.com","*.indexww.com"],totalExecutionTime:892351,totalOccurrences:32324},{name:"Indoona",category:"other",domains:["*.indoona.com"]},{name:"Infectious Media",category:"ad",domains:["*.impdesk.com","*.impressiondesk.com","*.inmz.net"]},{name:"Inference Mobile",category:"ad",domains:["*.inferencemobile.com"]},{name:"Infinity Tracking",category:"analytics",domains:["*.infinity-tracking.net"],
totalExecutionTime:24308,totalOccurrences:250},{name:"Infoline",category:"analytics",domains:["*.ioam.de"],totalExecutionTime:8983,totalOccurrences:95},{name:"Infolinks",category:"ad",domains:["*.infolinks.com"],totalExecutionTime:7995389,totalOccurrences:5950},{name:"Infopark",category:"hosting",domains:["*.scrvt.com"]},{name:"Infusionsoft",category:"ad",domains:["*.infusionsoft.com"],totalExecutionTime:345182,totalOccurrences:723},{name:"Ink",category:"ad",domains:["*.inktad.com"]},{name:"Inktel Contact Center Solutions",company:"Inktel",category:"customer-success",domains:["*.inktel.com"]},{name:"Inneractive",category:"ad",domains:["*.inner-active.mobi"]},{name:"Innovid",category:"ad",homepage:"https://www.innovid.com/",domains:["*.innovid.com"],examples:["ag.innovid.com","rtr.innovid.com"],totalExecutionTime:115267,totalOccurrences:1363},{name:"Insight Express",category:"analytics",domains:["*.insightexpressai.com"],totalExecutionTime:1,totalOccurrences:2},{name:"Insipio",category:"\
other",domains:["*.insipio.com"]},{name:"Inspectlet",category:"analytics",domains:["*.inspectlet.com"],totalExecutionTime:7622183,totalOccurrences:5346},{name:"Instansive",category:"utility",domains:["*.instansive.com"]},{name:"Instart",homepage:"https://www.instart.com/",category:"utility",domains:["*.insnw.net"]},{name:"Instembedder",category:"content",domains:["*.instaembedder.com"]},{name:"Instinctive",category:"ad",domains:["*.instinctiveads.com"]},{name:"Intelligent Reach",category:"ad",domains:["*.ist-track.com"]},{name:"Intent HQ",category:"analytics",domains:["*.intenthq.com"]},{name:"Intent IQ",category:"ad",domains:["*.intentiq.com"],totalExecutionTime:48447,totalOccurrences:1146},{name:"Intercept Interactive",category:"ad",domains:["*.undertone.com"],totalExecutionTime:2293921,totalOccurrences:21012},{name:"Interest Graph",company:"AOL",category:"ad",domains:["*.gravity.com"]},{name:"Internet Brands",category:"content",domains:["*.ibpxl.com"]},{name:"Interpublic Group",category:"\
ad",domains:["*.mbww.com"]},{name:"Interstate",category:"analytics",domains:["*.interstateanalytics.com"]},{name:"Interview",category:"analytics",domains:["*.efm.me"]},{name:"Intilery",category:"customer-success",domains:["*.intilery-analytics.com"]},{name:"Investis",category:"utility",domains:["*.investis.com"],totalExecutionTime:244162,totalOccurrences:282},{name:"Investis Flife",category:"hosting",domains:["*.quartalflife.com"]},{name:"Invodo",category:"ad",domains:["*.invodo.com"],examples:["e.invodo.com"]},{name:"iSite",category:"analytics",domains:["*.isitetv.com"],examples:["static.isitetv.com","events.isitetv.com"]},{name:"Issue",category:"content",domains:["*.issue.by"]},{name:"J.D. Williams & Co",category:"content",domains:["*.drct2u.com"]},{name:"Janrain",category:"analytics",domains:["*.janrain.com","*.janrainbackplane.com","*.rpxnow.com","d3hmp0045zy3cs.cloudfront.net"],totalExecutionTime:4006,totalOccurrences:21},{name:"Jellyfish",category:"ad",domains:["*.jellyfish.net"]},
{name:"JetStream",category:"content",domains:["*.xlcdn.com"]},{name:"JingDong",category:"content",domains:["*.3.com","*.jd.com"],totalExecutionTime:119043,totalOccurrences:84},{name:"Jivox",category:"ad",domains:["*.jivox.com"],totalExecutionTime:31166,totalOccurrences:65},{name:"Jobvite",category:"content",domains:["*.jobvite.com"],totalExecutionTime:6667,totalOccurrences:4},{name:"Johnston Press",category:"content",domains:["*.johnstonpress.co.uk","*.jpress.co.uk"]},{name:"Join the Dots (Research)",category:"social",domains:["*.jtdiscuss.com"]},{name:"JotForm",category:"utility",domains:["*.jotformpro.com"]},{name:"JuicyAds",category:"ad",domains:["*.juicyads.com"],totalExecutionTime:543292,totalOccurrences:2092},{name:"JustPremium",category:"ad",domains:["*.net.net"],examples:["d2nvliyzbo36lk.cloudfrontd2nvliyzbo36lk.cloudfront.net.net"]},{name:"JustPremium Ads",company:"JustPremium",category:"ad",domains:["*.justpremium.com"],totalExecutionTime:1061,totalOccurrences:35},{name:"Just\
Uno",category:"ad",domains:["*.justuno.com","d2j3qa5nc37287.cloudfront.net"],totalExecutionTime:773949,totalOccurrences:1448},{name:"KINX (Korea Internet Neutral eXchange)",category:"other",domains:["*.kinxcdn.com"],totalExecutionTime:1433,totalOccurrences:4},{name:"KISSmetrics",category:"analytics",domains:["*.kissmetrics.com","doug1izaerwt3.cloudfront.net","dsyszv14g9ymi.cloudfront.net"],totalExecutionTime:3896,totalOccurrences:46},{name:"Kaizen Platform",category:"analytics",domains:["*.kaizenplatform.net"],examples:["cdn.kaizenplatform.net","log-v4.kaizenplatform.net"],totalExecutionTime:85284,totalOccurrences:183},{name:"Kakao",category:"social",domains:["*.daum.net","*.daumcdn.net"],totalExecutionTime:38351047,totalOccurrences:62730},{name:"Kaltura Video Platform",company:"Kaltura",category:"content",domains:["*.kaltura.com"],examples:["cdnsecakmi.kaltura.com"],totalExecutionTime:2164237,totalOccurrences:1017},{name:"Kameleoon",homepage:"https://www.kameleoon.com/",category:"anal\
ytics",domains:["*.kameleoon.com","*.kameleoon.eu","*.kameleoon.io"],examples:["data.kameleoon.io","kdm3fpv6il.kameleoon.eu"],totalExecutionTime:2217218,totalOccurrences:2337},{name:"Kampyle",category:"analytics",domains:["*.kampyle.com"],totalExecutionTime:413304,totalOccurrences:702},{name:"Kantar",category:"analytics",domains:["*.sesamestats.com"]},{name:"Kargo",category:"marketing",domains:["*.kargo.com"],totalExecutionTime:48285,totalOccurrences:1135},{name:"KARTE",company:"Plaid",homepage:"https://karte.io/",category:"marketing",domains:["*.karte.io"],examples:["static.karte.io","t.karte.io"],totalExecutionTime:1712123,totalOccurrences:1729},{name:"Kauli",category:"ad",domains:["*.kau.li"]},{name:"Keen",company:"Keen",homepage:"https://keen.io/",category:"analytics",domains:["*.keen.io","d26b395fwzu5fz.cloudfront.net"],totalExecutionTime:24210,totalOccurrences:416},{name:"Kelkoo",category:"hosting",domains:["*.kelkoo.com"]},{name:"Kenshoo",category:"marketing",domains:["*.xg4ken.\
com"],totalExecutionTime:710,totalOccurrences:18},{name:"Key CDN",category:"utility",domains:["*.kxcdn.com"],totalExecutionTime:4814875,totalOccurrences:10025},{name:"Keynote",company:"Dynatrace",category:"analytics",domains:["*.keynote.com"]},{name:"Keywee",category:"ad",domains:["*.keywee.co"],totalExecutionTime:44984,totalOccurrences:259},{name:"Kiosked",category:"ad",domains:["*.kiosked.com"],totalExecutionTime:343355,totalOccurrences:173},{name:"Klarna",category:"utility",domains:["*.klarna.com"],totalExecutionTime:1374032,totalOccurrences:10759},{name:"Klaviyo",category:"ad",domains:["*.klaviyo.com"],totalExecutionTime:113130218,totalOccurrences:161289},{name:"Klevu Search",company:"Klevu",category:"utility",domains:["*.klevu.com"],totalExecutionTime:1124647,totalOccurrences:1463},{name:"Klick2Contact",category:"customer-success",domains:["*.klick2contact.com"]},{name:"Knight Lab",company:"Northwestern University",category:"utility",domains:["*.knightlab.com"],totalExecutionTime:350550,
totalOccurrences:448},{name:"Kodajo",category:"other",domains:["*.kodajo.com"]},{name:"Komoona",category:"ad",domains:["*.komoona.com"]},{name:"Korrelate",company:"JD Power",category:"analytics",domains:["*.korrelate.net"]},{name:"LKQD",category:"ad",domains:["*.lkqd.net"]},{name:"Layer0",category:"cdn",domains:["*.layer0.co"],examples:["rum.layer0.co"]},{name:"Layershift",category:"hosting",domains:["109.109.138.174"]},{name:"Lead Forensics",category:"ad",domains:["*.200summit.com","*.baw5tracker.com","*.business-path-55.com","*.bux1le001.com","*.central-core-7.com","*.direct-azr-78.com","*.explore-123.com","*.forensics1000.com","*.gldsta-02-or.com","*.green-bloc9.com","*.lansrv040.com","*.lead-123.com","*.leadforensics.com","*.mavic852.com","*.mon-com-net.com","*.peak-ip-54.com","*.snta0034.com","*.svr-prc-01.com","*.syntace-094.com","*.tghbn12.com","*.trail-web.com","*.web-01-gbl.com","*.web-cntr-07.com","*.trackdiscovery.net"],examples:["www.baw5tracker.com","www.lansrv040.com","ww\
w.mon-com-net.com","www.peak-ip-54.com","www.tghbn12.com","www.web-01-gbl.com"],totalExecutionTime:45938,totalOccurrences:307},{name:"Lead Intelligence",company:"Magnetise Solutions",category:"ad",domains:["*.leadintelligence.co.uk"]},{name:"LeadLander",category:"analytics",domains:["*.formalyzer.com","*.trackalyzer.com"]},{name:"Leaflet",category:"utility",domains:["*.leafletjs.com"],totalExecutionTime:3668,totalOccurrences:69},{name:"LeasdBoxer",company:"LeadBoxer",category:"ad",domains:["*.leadboxer.com"],totalExecutionTime:15328,totalOccurrences:118},{name:"LeaseWeb",homepage:"https://www.leaseweb.com/",category:"cdn",domains:["*.lswcdn.net","*.leasewebcdn.com"]},{name:"Leboncoin",category:"content",domains:["*.leboncoin.fr"]},{name:"Lengow",category:"hosting",domains:["*.lengow.com"]},{name:"Lessbuttons",category:"social",domains:["*.lessbuttons.com"]},{name:"Letter Press",category:"ad",domains:["*.getletterpress.com"]},{name:"Level 3 Communications",category:"utility",domains:["f\
ootprint.net"]},{name:"Level3",category:"other",domains:["secure.footprint.net"]},{name:"Lifestreet Media",category:"social",domains:["*.lfstmedia.com"]},{name:"LiftSuggest",category:"analytics",domains:["d2blwevgjs7yom.cloudfront.net"]},{name:"Ligatus",category:"ad",domains:["*.ligadx.com"]},{name:"LightStep",category:"analytics",domains:["*.lightstep.com"]},{name:"LightWidget",category:"utility",domains:["*.lightwidget.com"],totalExecutionTime:1825559,totalOccurrences:9383},{name:"Likelihood",company:"LIkeihood",category:"hosting",domains:["*.likelihood.com"],examples:["client.likelihood.com"]},{name:"LikeShop",company:"Dash Hudson",category:"content",domains:["likeshop.me"],examples:["likeshop.me"]},{name:"LINE Corporation",category:"ad",domains:["*.line-scdn.net","*.line.me"],examples:["d.line-scdn.net","tr.line.me"],totalExecutionTime:3858282,totalOccurrences:26881},{name:"Linkcious",category:"analytics",domains:["*.linkcious.com"]},{name:"Linking Mobile",category:"ad",domains:["*\
.linkingmobile.com"]},{name:"LittleData",category:"analytics",homepage:"https://www.littledata.io/",domains:["*.littledata.io"],examples:["transactions.littledata.io"],totalExecutionTime:832,totalOccurrences:1},{name:"LiveBurst",category:"ad",domains:["*.liveburst.com"]},{name:"LiveClicker",category:"ad",domains:["*.liveclicker.net"]},{name:"LiveHelpNow",category:"customer-success",domains:["*.livehelpnow.net"],totalExecutionTime:284671,totalOccurrences:819},{name:"LiveInternet",category:"analytics",domains:["*.yadro.ru"]},{name:"LiveJournal",category:"social",domains:["*.livejournal.com","*.livejournal.net"],totalExecutionTime:63532309,totalOccurrences:9109},{name:"LivePerson",category:"customer-success",homepage:"https://www.liveperson.com/",domains:["*.liveperson.com","*.look.io","*.liveperson.net","*.lpsnmedia.net"],totalExecutionTime:1930619,totalOccurrences:2544},{name:"LiveRail",company:"Facebook",category:"ad",domains:["*.liverail.com","*.lrcdn.net"],examples:["scontent.lrcdn.n\
et"]},{name:"LiveTex",category:"customer-success",domains:["*.livetex.ru"],totalExecutionTime:476954,totalOccurrences:1911},{name:"Livefyre",category:"content",domains:["*.fyre.co","*.livefyre.com"]},{name:"Living Map Company",category:"utility",domains:["*.livingmap.com"]},{name:"Local World",category:"content",domains:["*.thelocalpeople.co.uk"]},{name:"LockerDome",category:"analytics",domains:["*.lockerdome.com"],totalExecutionTime:244,totalOccurrences:3},{name:"Logentries",company:"Rapid",category:"utility",domains:["*.logentries.com"],examples:["js.logentries.com"]},{name:"Logicalis",category:"analytics",domains:["*.trovus.co.uk"]},{name:"LoginRadius",company:"LoginRadius",homepage:"https://www.loginradius.com/",category:"ad",domains:["*.loginradius.com","*.lrcontent.com"],examples:["config.lrcontent.com"],totalExecutionTime:15746,totalOccurrences:131},{name:"LongTail Ad Solutions",category:"ad",domains:["*.jwpcdn.com","*.jwplatform.com","*.jwplayer.com","*.jwpltx.com","*.jwpsrv.co\
m","*.longtailvideo.com"],totalExecutionTime:4531393,totalOccurrences:5572},{name:"Loop Commerce",category:"other",domains:["*.loopassets.net"]},{name:"Loop11",category:"analytics",domains:["*.loop11.com"],totalExecutionTime:22278,totalOccurrences:28},{name:"LoopMe",category:"ad",domains:["*.loopme.biz","*.loopme.com","*.vntsm.com","*.loopme.me"],totalExecutionTime:2112781,totalOccurrences:11752},{name:"Looper",category:"content",domains:["*.looper.com"]},{name:"Loyalty Point",category:"ad",domains:["*.loyaltypoint.pl"]},{name:"LoyaltyLion",category:"ad",domains:["*.loyaltylion.com","*.loyaltylion.net","dg1f2pfrgjxdq.cloudfront.net"],totalExecutionTime:2971522,totalOccurrences:4114},{name:"Luma Tag",category:"analytics",domains:["*.lumatag.co.uk"]},{name:"Lumesse",category:"content",domains:["*.recruitmentplatform.com"]},{name:"Luminate",category:"ad",domains:["*.luminate.com"]},{name:"Lynchpin Analytics",category:"analytics",domains:["*.lypn.net"]},{name:"Lyris",category:"ad",domains:[
"*.clicktracks.com"]},{name:"Lytics",category:"ad",domains:["*.lytics.io"],totalExecutionTime:272463,totalOccurrences:857},{name:"MEC WebTrack",company:"MEC",category:"ad",domains:["*.e-webtrack.net"]},{name:"MECLABS Institute",category:"analytics",domains:["*.meclabs.com","*.meclabsdata.com"]},{name:"MLveda",category:"utility",domains:["*.mlveda.com"],examples:["www.mlveda.com"],totalExecutionTime:109345,totalOccurrences:229},{name:"Macromill",company:"Macromill",category:"analytics",homepage:"https://group.macromill.com/",domains:["*.macromill.com"],examples:["img.macromill.com/js/us000131vfg/4000000570-56/lognos.js"],totalExecutionTime:5731,totalOccurrences:9},{name:"Macropod BugHerd",company:"Macropod",category:"utility",domains:["*.bugherd.com"],examples:["www.bugherd.com"],totalExecutionTime:512091,totalOccurrences:3523},{name:"Madison Logic",category:"marketing",domains:["*.ml314.com"],totalExecutionTime:101,totalOccurrences:3},{name:"Madmetrics",company:"Keyade",category:"analy\
tics",domains:["*.keyade.com"]},{name:"Magnetic",category:"ad",domains:["*.domdex.com","d3ezl4ajpp2zy8.cloudfront.net"]},{name:"Magnetic Platform",company:"Magnetic",category:"ad",domains:["*.magnetic.is"]},{name:"MailMunch",category:"ad",domains:["*.mailmunch.co"],totalExecutionTime:1414543,totalOccurrences:19969},{name:"MailPlus",category:"ad",domains:["*.mailplus.nl"],totalExecutionTime:83524,totalOccurrences:304},{name:"Mapbox",category:"utility",domains:["*.mapbox.com"],totalExecutionTime:13815633,totalOccurrences:19555},{name:"Maptive",category:"utility",domains:["*.maptive.com"]},{name:"Marcaria.com",category:"other",domains:["*.gooo.al"]},{name:"Marchex",category:"analytics",domains:["*.voicestar.com","*.marchex.io"],totalExecutionTime:1378181,totalOccurrences:7390},{name:"Mark and Mini",category:"ad",domains:["*.markandmini.com"],examples:["www.markandmini.com"]},{name:"Marker",category:"utility",domains:["*.marker.io"],examples:["edge.marker.io"],totalExecutionTime:2331726,totalOccurrences:1722},
{name:"Marketing Dashboards",company:"GroupM",category:"analytics",domains:["*.m-decision.com"]},{name:"Marketizator",category:"analytics",domains:["*.marketizator.com"]},{name:"Marketplace Web Service",company:"Amazon",category:"other",domains:["*.ssl-images-amazon.com"],totalExecutionTime:234709,totalOccurrences:451},{name:"Mashable",category:"social",domains:["*.mshcdn.com"]},{name:"MatchWork",category:"utility",domains:["*.matchwork.com"]},{name:"MathJax",category:"utility",domains:["*.mathjax.org"],totalExecutionTime:84751,totalOccurrences:743},{name:"Mather Economics",category:"analytics",domains:["*.matheranalytics.com"],totalExecutionTime:262501,totalOccurrences:507},{name:"MaxCDN Enterprise",company:"MaxCDN",category:"utility",domains:["*.netdna-cdn.com","*.netdna-ssl.com"]},{name:"MaxMind",category:"utility",domains:["*.maxmind.com"],totalExecutionTime:855332,totalOccurrences:831},{name:"MaxPoint Interactive",category:"ad",domains:["*.mxptint.net"],totalExecutionTime:20140,totalOccurrences:23834},
{name:"Maxsi",category:"analytics",domains:["*.evisitanalyst.com"]},{name:"Maxymiser",category:"analytics",domains:["*.maxymiser.net, maxymiser.hs.llnwd.net"]},{name:"McAffee",category:"utility",domains:["*.mcafeesecure.com","*.scanalert.com"]},{name:"Measured",category:"analytics",domains:["*.measured.com"],examples:["tag.measured.com"],homepage:"https://www.measured.com/"},{name:"Media IQ",category:"analytics",domains:["*.mediaiqdigital.com"]},{name:"Media Management Technologies",category:"ad",domains:["*.speedshiftmedia.com"],totalExecutionTime:27147,totalOccurrences:161},{name:"Media Temple",category:"hosting",domains:["*.goodlayers2.com"]},{name:"Mediabong",category:"ad",domains:["*.mediabong.net"]},{name:"Mediahawk",category:"analytics",domains:["*.mediahawk.co.uk"],totalExecutionTime:51393,totalOccurrences:239},{name:"Mediahub",category:"ad",domains:["*.hubverifyandoptimize.com","*.projectwatchtower.com"]},{name:"Mediasyndicator",category:"ad",domains:["*.creativesyndicator.com"]},
{name:"Medium",category:"content",domains:["*.medium.com"],totalExecutionTime:216923262,totalOccurrences:17027},{name:"Meetrics",category:"ad",domains:["*.de.com","*.meetrics.net","*.mxcdn.net"],examples:["research.de.com"],totalExecutionTime:102809,totalOccurrences:63},{name:"Mega",company:"Mega Information Technology",category:"other",domains:["*.mgcdn.com"]},{name:"Melt",category:"ad",domains:["*.meltdsp.com","*.mesp.com"]},{name:"Meltwater Group",category:"customer-success",domains:["*.meltwaternews.com"]},{name:"Meme",category:"ad",domains:["*.viewwonder.com"]},{name:"MentAd",category:"ad",domains:["*.mentad.com"]},{name:"Mention Me",category:"ad",domains:["*.mention-me.com"],examples:["tag.mention-me.com"],totalExecutionTime:15233,totalOccurrences:44},{name:"Merchant Equipment Store",category:"utility",domains:["*.merchantequip.com"],totalExecutionTime:268,totalOccurrences:1},{name:"Merchenta",category:"customer-success",domains:["*.merchenta.com"]},{name:"Merkle Digital Data Exc\
hange",company:"Merkle",category:"ad",domains:["*.brilig.com"]},{name:"Merkle Paid Search",company:"Merkle",category:"ad",domains:["*.rkdms.com"],totalExecutionTime:69291,totalOccurrences:407},{name:"Met Office",category:"content",domains:["*.metoffice.gov.uk"],totalExecutionTime:15029,totalOccurrences:19},{name:"Meta Broadcast",category:"social",domains:["*.metabroadcast.com"],examples:["voila.metabroadcast.com"]},{name:"Michael Associates",category:"ad",domains:["*.checktestsite.com"],examples:["www.checktestsite.com"]},{name:"Michelin",category:"content",domains:["*.viamichelin.com"],totalExecutionTime:8087,totalOccurrences:7},{name:"Microad",category:"ad",domains:["*.microad.jp"],totalExecutionTime:14626755,totalOccurrences:23909},{name:"Microsoft Certificate Services",company:"Microsoft",category:"utility",domains:["*.msocsp.com"]},{name:"Microsoft Hosted Libs",company:"Microsoft",category:"cdn",domains:["*.aspnetcdn.com"],examples:["ajax.aspnetcdn.com"],totalExecutionTime:4562478,
totalOccurrences:20042},{name:"Microsoft XBox Live",company:"Microsoft",category:"marketing",domains:["*.xboxlive.com"]},{name:"Mightypop",category:"ad",domains:["*.mightypop.ca"]},{name:"Mika Tuupola",category:"utility",domains:["*.appelsiini.net"]},{name:"Millennial Media",category:"ad",domains:["*.jumptap.com"]},{name:"Mirror Image Internet",category:"utility",domains:["*.miisolutions.net"]},{name:"Mobify",category:"utility",domains:["*.mobify.com","*.mobify.net"]},{name:"Mobile Nations",category:"social",domains:["*.mobilenations.com"]},{name:"Mobivate",category:"ad",domains:["*.mobivatebulksms.com"]},{name:"Momondo",category:"content",domains:["*.momondo.dk"]},{name:"Momondo Group",category:"content",domains:["*.momondogrouo.com","*.momondogroup.com"]},{name:"Monarch Ads",category:"ad",domains:["*.monarchads.com"]},{name:"Monetate",category:"analytics",domains:["*.monetate.net"],totalExecutionTime:260345,totalOccurrences:599},{name:"MonetizeMore",category:"ad",domains:["*.m2.ai"],
totalExecutionTime:8896,totalOccurrences:47},{name:"Monitor",company:"Econda",category:"analytics",domains:["*.econda-monitor.de"],examples:["www.econda-monitor.de"]},{name:"Monkey Frog Media",category:"content",domains:["*.monkeyfrogmedia.com"]},{name:"Monotype",category:"cdn",domains:["*.fonts.com","*.fonts.net"],totalExecutionTime:729465,totalOccurrences:3185},{name:"Moore-Wilson",category:"ad",domains:["*.mwdev.co.uk"]},{name:"Moovweb",category:"utility",domains:["*.moovweb.net"]},{name:"Mopinion",category:"analytics",domains:["*.mopinion.com"],totalExecutionTime:171681,totalOccurrences:177},{name:"MotionPoint",category:"other",domains:["*.convertlanguage.com"],totalExecutionTime:1843,totalOccurrences:35},{name:"Mouse3K",category:"analytics",domains:["*.mouse3k.com"]},{name:"MouseStats",category:"analytics",domains:["*.mousestats.com"]},{name:"Mouseflow",homepage:"https://mouseflow.com/",category:"analytics",domains:["*.mouseflow.com"],totalExecutionTime:331345,totalOccurrences:6786},
{name:"Movable Ink",category:"analytics",domains:["*.micpn.com"],totalExecutionTime:439979,totalOccurrences:4949},{name:"MovingIMAGE24",category:"content",domains:["*.edge-cdn.net"]},{name:"Moxielinks",category:"ad",domains:["*.moxielinks.com"]},{name:"Moz Recommended Companies",company:"Moz",category:"analytics",domains:["d2eeipcrcdle6.cloudfront.net"]},{name:"Mozilla",category:"utility",domains:["*.mozilla.org"],examples:["aus5.mozilla.org"],totalExecutionTime:21085,totalOccurrences:32},{name:"Multiview",category:"content",domains:["*.multiview.com","*.track-mv.com"],totalExecutionTime:8831,totalOccurrences:58},{name:"Mux",category:"analytics",domains:["*.litix.io"],totalExecutionTime:91580,totalOccurrences:249},{name:"MyAds",company:"MyBuys",category:"analytics",domains:["*.veruta.com"]},{name:"MyBuys",category:"analytics",domains:["*.mybuys.com"]},{name:"MyFonts",category:"cdn",domains:["*.myfonts.net"],totalExecutionTime:78,totalOccurrences:4},{name:"MyRegistry",category:"other",domains:[
"*.myregistry.com"],totalExecutionTime:164086,totalOccurrences:621},{name:"MySpace",company:"Specific Media",category:"social",domains:["*.myspace.com"]},{name:"Mynewsdesk",category:"utility",domains:["*.mynewsdesk.com"],totalExecutionTime:564,totalOccurrences:31},{name:"NAVIS",category:"content",domains:["*.navistechnologies.info"]},{name:"NCC Group Real User Monitoring",company:"NCC Group",category:"analytics",domains:["*.nccgroup-webperf.com"],examples:["beacon-rumlive.rum.nccgroup-webperf.com","config-rumlive.rum.nccgroup-webperf.com","script-rumlive.rum.nccgroup-webperf.com"]},{name:"NEORY Marketing Cloud",company:"NEORY",category:"marketing",domains:["*.ad-srv.net"],totalExecutionTime:10976,totalOccurrences:240},{name:"Nanigans",category:"ad",domains:["*.nanigans.com"]},{name:"Nano Interactive",category:"ad",domains:["*.audiencemanager.de"],totalExecutionTime:780,totalOccurrences:10},{name:"Nanorep",company:"Nanorep Technologies",category:"customer-success",domains:["*.nanorep.co\
m"]},{name:"Narrative",category:"ad",domains:["*.narrative.io"],totalExecutionTime:1228,totalOccurrences:2},{name:"Native Ads",category:"ad",domains:["*.nativeads.com"]},{name:"Nativo",category:"ad",domains:["*.postrelease.com"],totalExecutionTime:28260,totalOccurrences:35852},{name:"Navegg",category:"ad",domains:["*.navdmp.com"],totalExecutionTime:51915,totalOccurrences:805},{name:"NaviStone",category:"ad",domains:["*.murdoog.com"]},{name:"Naytev",category:"analytics",domains:["*.naytev.com"]},{name:"Needle",category:"analytics",domains:["*.needle.com"]},{name:"Neiman Marcus",category:"content",domains:["*.ctscdn.com"]},{name:"Nend",category:"ad",domains:["*.nend.net"]},{name:"Neodata",category:"ad",domains:["*.neodatagroup.com"],totalExecutionTime:12827,totalOccurrences:86},{name:"Net Applications",category:"analytics",domains:["*.hitsprocessor.com"]},{name:"Net Reviews",category:"analytics",domains:["*.avis-verifies.com"],examples:["www.avis-verifies.com"],totalExecutionTime:1143140,
totalOccurrences:2442},{name:"NetAffiliation",company:"Kwanco",category:"ad",domains:["*.metaffiliation.com"],totalExecutionTime:18519,totalOccurrences:127},{name:"NetDirector",company:"G-Forces Web Management",category:"other",domains:["*.netdirector.co.uk"],totalExecutionTime:3931,totalOccurrences:1},{name:"NetFlix",category:"content",domains:["*.nflxext.com","*.nflximg.net"],totalExecutionTime:4364,totalOccurrences:5},{name:"Nielsen NetRatings SiteCensus",company:"The Nielsen Company",homepage:"http://www.nielsen-online.com/intlpage.html",category:"analytics",domains:["*.imrworldwide.com"],totalExecutionTime:6840006,totalOccurrences:19525},{name:"NetSeer",category:"ad",domains:["*.netseer.com","*.ns-cdn.com"]},{name:"NetShelter",company:"Ziff Davis Tech",category:"ad",domains:["*.netshelter.net"]},{name:"Netmining",company:"Ignition One",category:"ad",domains:["*.netmng.com"],totalExecutionTime:7746,totalOccurrences:92},{name:"Netop",category:"customer-success",domains:["*.netop.com"]},
{name:"Network Solutions",category:"utility",domains:["*.netsolssl.com","*.networksolutions.com"],examples:["ocsp.netsolssl.com"],totalExecutionTime:2415,totalOccurrences:2},{name:"Neustar AdAdvisor",company:"Neustar",category:"ad",domains:["*.adadvisor.net"]},{name:"New Approach Media",category:"ad",domains:["*.newapproachmedia.co.uk"]},{name:"NewShareCounts",category:"social",domains:["*.newsharecounts.com"]},{name:"News",category:"social",domains:["*.news.com.au","*.newsanalytics.com.au","*.newsapi.com.au","*.newscdn.com.au","*.newsdata.com.au","*.newsdiscover.com.au","*.news-static.com"],totalExecutionTime:69261,totalOccurrences:46},{name:"Newsquest",category:"content",domains:["*.newsquestdigital.co.uk"]},{name:"Newzulu",category:"content",domains:["*.filemobile.com","*.projects.fm"]},{name:"Nexcess.Net",category:"hosting",domains:["*.nexcesscdn.net"]},{name:"Nexstar Media Group",category:"ad",domains:["*.yashi.com"]},{name:"NextPerf",company:"Rakuten Marketing",category:"ad",domains:[
"*.nxtck.com"]},{name:"Nine.com.au",company:"Nine Digital",category:"content",domains:["*.9msn.com.au"]},{name:"NitroSell",category:"hosting",domains:["*.nitrosell.com"]},{name:"Nochex",category:"utility",domains:["*.nochex.com"]},{name:"Northern &amp; Shell Media Group",category:"content",domains:["*.northernandshell.co.uk"]},{name:"Nosto",category:"analytics",domains:["*.nosto.com"],totalExecutionTime:703736,totalOccurrences:1189},{name:"Now Interact",category:"analytics",domains:["*.nowinteract.com"]},{name:"Numberly",company:"1000mercis",category:"ad",domains:["*.mmtro.com","*.nzaza.com"],totalExecutionTime:1827,totalOccurrences:19},{name:"NyaConcepts",category:"analytics",domains:["*.xclusive.ly"]},{name:"O2",category:"other",domains:["*.o2.co.uk"],examples:["servedby.o2.co.uk"]},{name:"GoDaddy",homepage:"https://www.godaddy.com/",category:"utility",domains:["*.godaddy.com","*.wsimg.com"],examples:["ocsp.godaddy.com","seal.godaddy.com"],totalExecutionTime:94698135,totalOccurrences:110342},
{name:"ObjectPlanet",category:"analytics",domains:["*.easypolls.net"],totalExecutionTime:28470,totalOccurrences:70},{name:"OhMyAd",category:"ad",domains:["*.ohmyad.co"],examples:["pr.ohmyad.co"]},{name:"Okas Concepts",category:"utility",domains:["*.okasconcepts.com"],totalExecutionTime:1483515,totalOccurrences:661},{name:"Okta",category:"analytics",domains:["*.okta.com"],totalExecutionTime:1464920,totalOccurrences:3542},{name:"Olapic",category:"content",domains:["*.photorank.me"],totalExecutionTime:115,totalOccurrences:2},{name:"Ometria",category:"analytics",domains:["*.ometria.com"],totalExecutionTime:16630,totalOccurrences:204},{name:"Omniconvert",category:"analytics",domains:["*.omniconvert.com","d2tgfbvjf3q6hn.cloudfront.net","d3vbj265bmdenw.cloudfront.net"],totalExecutionTime:85855,totalOccurrences:381},{name:"Omniroot",company:"Verizon",category:"utility",domains:["*.omniroot.com"],examples:["ocsp.omniroot.com","vassg142.ocsp.omniroot.com"]},{name:"OnAudience",company:"Cloud Tech\
nologies",category:"ad",domains:["*.onaudience.com"]},{name:"OnScroll",category:"ad",domains:["*.onscroll.com"]},{name:"OnState",category:"ad",domains:["*.onstate.co.uk"]},{name:"OnYourMap",category:"utility",domains:["*.onyourmap.com"]},{name:"One by AOL",company:"AOL",category:"ad",domains:["*.adtechjp.com","*.adtech.de"],totalExecutionTime:1140,totalOccurrences:17},{name:"One by AOL:Mobile",company:"AOL",category:"ad",domains:["*.nexage.com"],examples:["ads.nexage.com","hb.nexage.com"]},{name:"OneAll",category:"analytics",domains:["*.oneall.com"],totalExecutionTime:104501,totalOccurrences:623},{name:"OneSoon",category:"analytics",domains:["*.adalyser.com"],totalExecutionTime:33037,totalOccurrences:437},{name:"OneTag",category:"ad",domains:["*.onetag-sys.com"]},{name:"Onet",category:"ad",domains:["*.onet.pl"],totalExecutionTime:531334,totalOccurrences:760},{name:"Online Rewards",company:"Mastercard",category:"ad",domains:["*.loyaltygateway.com"]},{name:"Online republic",category:"con\
tent",domains:["*.imallcdn.net"],totalExecutionTime:67122,totalOccurrences:58},{name:"Ooyala",category:"ad",domains:["*.ooyala.com"]},{name:"OpenTable",company:"Priceline Group",category:"content",domains:["*.opentable.com","*.opentable.co.uk","*.toptable.co.uk"],examples:["www.toptable.co.uk"],totalExecutionTime:412090,totalOccurrences:4314},{name:"OpenX Ad Exchange",company:"OpenX Technologies",category:"ad",domains:["*.liftdna.com"]},{name:"Opinion Stage",category:"analytics",domains:["*.opinionstage.com"],examples:["www.opinionstage.com"],totalExecutionTime:113206,totalOccurrences:145},{name:"OpinionBar",category:"analytics",domains:["*.opinionbar.com"]},{name:"Opta",company:"Perform Group",category:"content",domains:["*.opta.net"],totalExecutionTime:302785,totalOccurrences:272},{name:"OptiMonk",category:"ad",domains:["*.optimonk.com"],totalExecutionTime:10318415,totalOccurrences:10615},{name:"Optilead",category:"analytics",domains:["*.dyn-img.com","*.leadcall.co.uk","*.optilead.co\
.uk"]},{name:"Optimatic",category:"ad",domains:["*.optimatic.com"],examples:["synch.optimatic.com"]},{name:"Optimise Media Group",category:"utility",domains:["*.omguk.com"],totalExecutionTime:6691,totalOccurrences:41},{name:"Optimost",company:"OpenText",category:"ad",domains:["*.optimost.com"]},{name:"Optimove",company:"Mobius Solutions",category:"analytics",domains:["*.optimove.net"],totalExecutionTime:22679,totalOccurrences:293},{name:"Optorb",category:"ad",domains:["*.optorb.com"]},{name:"Oracle",category:"marketing",domains:["*.custhelp.com","*.eloqua.com","*.en25.com","*.estara.com","*.instantservice.com"],totalExecutionTime:684920,totalOccurrences:569},{name:"Oracle Recommendations On Demand",company:"Oracle",category:"analytics",domains:["*.atgsvcs.com"],totalExecutionTime:8696,totalOccurrences:96},{name:"Oracle Responsys",company:"Oracle",category:"marketing",domains:["*.adrsp.net","*.responsys.net"]},{name:"Order Security-VOID",company:"Order Security",category:"analytics",domains:[
"*.order-security.com"]},{name:"Oriel",category:"ad",domains:["*.oriel.io"]},{name:"Outbrain",homepage:"https://www.outbrain.com/",category:"ad",domains:["*.outbrain.com","*.outbrainimg.com","*.visualrevenue.com"],totalExecutionTime:3373858,totalOccurrences:13287},{name:"OverStream",company:"Coull",category:"ad",domains:["*.coull.com"],examples:["ex1.coull.com"]},{name:"Overdrive",category:"content",domains:["*.contentreserve.com"]},{name:"Overstock",category:"utility",domains:["*.ostkcdn.com"]},{name:"OwnerIQ",category:"ad",domains:["*.owneriq.net"],totalExecutionTime:305561,totalOccurrences:2173},{name:"OzCart",category:"utility",domains:["*.ozcart.com.au"]},{name:"Ozone Media",category:"ad",domains:["*.adadyn.com"]},{name:"Loqate",company:"Loqate",category:"other",domains:["*.pcapredict.com","*.postcodeanywhere.co.uk"],totalExecutionTime:136866,totalOccurrences:777},{name:"PEER 1 Hosting",category:"hosting",domains:["*.peer1.com"]},{name:"PERFORM",category:"content",domains:["*.perf\
ormgroup.com"]},{name:"PICnet",category:"hosting",domains:["*.nonprofitsoapbox.com"]},{name:"Pacnet",company:"Telstra",category:"other",domains:["*.cdndelivery.net"],examples:["682968324.r.cdndelivery.net"]},{name:"Pagefair",category:"ad",domains:["*.pagefair.com","*.pagefair.net"]},{name:"Pagely",category:"other",domains:["*.optnmstr.com"],totalExecutionTime:99314,totalOccurrences:487},{name:"Pagesuite",category:"ad",domains:["*.pagesuite-professional.co.uk"],totalExecutionTime:12,totalOccurrences:1},{name:"Pardot",category:"marketing",domains:["*.pardot.com"],totalExecutionTime:73880,totalOccurrences:550},{name:"Parse.ly",category:"analytics",domains:["*.parsely.com","d1z2jf7jlzjs58.cloudfront.net"],totalExecutionTime:1122662,totalOccurrences:5204},{name:"Pay per Click",company:"Eysys",category:"ad",domains:["*.eysys.com"],examples:["pla27.eysys.com"]},{name:"PayPal Ads",category:"ad",domains:["*.where.com"]},{name:"Peaks & Pies",category:"analytics",domains:["*.bunchbox.co"]},{name:"\
PebblePost",category:"ad",domains:["*.pbbl.co"],totalExecutionTime:147945,totalOccurrences:725},{name:"Peerius",category:"analytics",domains:["*.peerius.com"]},{name:"Peermap",company:"IMRG",category:"analytics",domains:["peermapcontent.affino.com"]},{name:"Penske Media",category:"content",domains:["*.pmc.com"]},{name:"Penton",category:"utility",domains:["*.pisces-penton.com"]},{name:"Pepper",category:"ad",domains:["*.peppercorp.com"]},{name:"Perfect Audience",company:"Marin Software",category:"ad",domains:["*.prfct.co","*.marinsm.com","*.perfectaudience.com"],totalExecutionTime:405,totalOccurrences:7},{name:"Perfect Market",category:"ad",domains:["*.perfectmarket.com"]},{name:"Perfect Privacy",category:"other",domains:["*.suitesmart.com"]},{name:"Perform Group",category:"content",domains:["*.performfeeds.com","*.premiumtv.co.uk"]},{name:"Performio",category:"ad",domains:["*.performax.cz"],examples:["ut.performax.cz"],totalExecutionTime:117591,totalOccurrences:337},{name:"PerimeterX Bo\
t Defender",company:"PerimeterX",category:"utility",domains:["*.perimeterx.net","*.pxi.pub"],totalExecutionTime:172605,totalOccurrences:68},{name:"Periscope",category:"content",domains:["*.periscope.tv"]},{name:"Permutive",category:"ad",domains:["*.permutive.com","d3alqb8vzo7fun.cloudfront.net"],totalExecutionTime:1406714,totalOccurrences:1124},{name:"Petametrics",category:"analytics",domains:["*.petametrics.com"]},{name:"PhotoBucket",category:"content",domains:["*.photobucket.com"],totalExecutionTime:2383529,totalOccurrences:338},{name:"Picreel",category:"analytics",domains:["*.pcrl.co","*.picreel.com"],totalExecutionTime:45437,totalOccurrences:300},{name:"Pictela (AOL)",category:"analytics",domains:["*.pictela.net"]},{name:"PistonHeads",category:"social",domains:["*.pistonheads.com"]},{name:"Piwik",category:"analytics",domains:["*.drtvtracker.com","*.piwikpro.com","*.raac33.net"],totalExecutionTime:2813,totalOccurrences:32},{name:"Pixalate",category:"utility",domains:["*.adrta.com"],
totalExecutionTime:4187,totalOccurrences:13},{name:"Pixlee",category:"social",domains:["*.pixlee.com"],totalExecutionTime:137281,totalOccurrences:341},{name:"Placed",category:"analytics",domains:["*.placed.com"],totalExecutionTime:691,totalOccurrences:1},{name:"Planning-inc",category:"analytics",domains:["*.planning-inc.co.uk"]},{name:"PlayAd Media Group",category:"ad",domains:["*.youplay.se"]},{name:"Playbuzz",category:"hosting",domains:["*.playbuzz.com"],totalExecutionTime:58184,totalOccurrences:89},{name:"Pleenq",category:"ad",domains:["*.pleenq.com"]},{name:"Plentific",category:"content",domains:["*.plentific.com"]},{name:"PluginDetect",category:"other",domains:["dtlilztwypawv.cloudfront.net"]},{name:"Po.st",company:"RadiumOne",category:"utility",domains:["*.po.st"],totalExecutionTime:178,totalOccurrences:3},{name:"Pointpin",category:"utility",domains:["*.pointp.in"]},{name:"Pointroll (Garnett)",category:"ad",domains:["*.pointroll.com"]},{name:"Polar",homepage:"https://polar.me/",category:"\
ad",domains:["*.polarmobile.ca","*.mediaeverywhere.com","*.mediavoice.com","*.plrsrvcs.com","*.polarcdn-engine.com","*.polarcdn-meraxes.com","*.polarcdn-pentos.com","*.polarcdn-static.com","*.polarcdn-terrax.com","*.polarcdn.com","*.polarmobile.com","*.poweredbypolar.com","*.mediaconductor.me","*.polaracademy.me"],totalExecutionTime:66280,totalOccurrences:223},{name:"PollDaddy (Automattic)",category:"ad",domains:["static.polldaddy.com","*.poll.fm"],totalExecutionTime:4752,totalOccurrences:37},{name:"Polldaddy",company:"Automattic",category:"analytics",domains:["polldaddy.com","*.polldaddy.com"],totalExecutionTime:294207,totalOccurrences:2715},{name:"Polyfill service",company:"Polyfill.io",category:"other",domains:["*.polyfill.io"]},{name:"MegaPopAds",category:"ad",domains:["*.megapopads.com"]},{name:"Populis",category:"ad",domains:["*.populisengage.com"]},{name:"Postimage.org",category:"content",domains:["*.postimg.org"]},{name:"PowerFront",category:"hosting",domains:["*.inside-graph.c\
om"],totalExecutionTime:220331,totalOccurrences:370},{name:"PowerReviews",category:"analytics",domains:["*.powerreviews.com"],totalExecutionTime:1208993,totalOccurrences:1324},{name:"Powerlinks.com",category:"ad",domains:["*.powerlinks.com"]},{name:"Press+",category:"ad",domains:["*.pipol.com","*.ppjol.com","*.ppjol.net"]},{name:"PressArea",category:"utility",domains:["*.pressarea.com"],examples:["www.pressarea.com"]},{name:"Pretio Interactive",category:"ad",domains:["*.pretio.in"]},{name:"Prezi",category:"utility",domains:["*.prezi.com"],totalExecutionTime:72394,totalOccurrences:79},{name:"PriceGrabber",category:"content",domains:["*.pgcdn.com","*.pricegrabber.com"]},{name:"PriceRunner",category:"content",domains:["*.pricerunner.com"],totalExecutionTime:200,totalOccurrences:6},{name:"PrintFriendly",category:"utility",domains:["*.printfriendly.com"],totalExecutionTime:39464,totalOccurrences:381},{name:"Privy",category:"ad",domains:["*.privy.com","*.privymktg.com"],totalExecutionTime:14992809,
totalOccurrences:18961},{name:"Proclivity Media",category:"analytics",domains:["*.pswec.com"]},{name:"Profitshare",category:"ad",domains:["*.profitshare.ro"],totalExecutionTime:60087,totalOccurrences:194},{name:"Programattik",category:"ad",domains:["*.programattik.com"],totalExecutionTime:95,totalOccurrences:9},{name:"Proper Media",category:"content",domains:["*.proper.io"],totalExecutionTime:253672,totalOccurrences:109},{name:"Property Week",category:"content",domains:["*.propertyweek.com"],examples:["www.propertyweek.com"]},{name:"Provide Support",category:"customer-success",domains:["*.providesupport.com"],totalExecutionTime:79281,totalOccurrences:989},{name:"Proweb Uk",category:"hosting",domains:["*.proweb.net"]},{name:"Proximic (ComScore)",category:"ad",domains:["*.proximic.com"]},{name:"Psyma",category:"ad",domains:["*.psyma.com"],totalExecutionTime:2496,totalOccurrences:5},{name:"PubFactory",company:"Safari Books Online",category:"content",domains:["*.pubfactory.com"]},{name:"Pu\
bNation",category:"ad",domains:["*.pubnation.com"],totalExecutionTime:625439,totalOccurrences:132},{name:"Publicidad.net",category:"ad",domains:["*.publicidad.tv"]},{name:"PublishThis",company:"Ultra Unlimited",category:"ad",domains:["*.publishthis.com"]},{name:"Pulse Insights",category:"analytics",domains:["*.pulseinsights.com"],totalExecutionTime:5757,totalOccurrences:53},{name:"Pulsepoint",category:"marketing",domains:["*.displaymarketplace.com"]},{name:"Purch",category:"ad",domains:["*.bestofmedia.com","*.purch.com"],examples:["ramp.purch.com"]},{name:"Pure Chat",category:"customer-success",domains:["*.purechat.com"],totalExecutionTime:1129392,totalOccurrences:3105},{name:"PushCrew",category:"ad",domains:["*.pushcrew.com"],totalExecutionTime:170011,totalOccurrences:823},{name:"Q1Media",category:"ad",domains:["*.q1media.com","*.q1mediahydraplatform.com"]},{name:"Qbase Software Development",category:"hosting",domains:["*.smartwebportal.co.uk"]},{name:"Qeryz",category:"analytics",domains:[
"*.qeryz.com"]},{name:"Qode Interactive",category:"hosting",domains:["*.qodeinteractive.com"],totalExecutionTime:2503828,totalOccurrences:147},{name:"Qrius",category:"social",domains:["*.qrius.me"]},{name:"Qualaroo",category:"analytics",domains:["*.qualaroo.com"],totalExecutionTime:54960,totalOccurrences:347},{name:"Qualtrics",category:"analytics",domains:["*.qualtrics.com"],totalExecutionTime:4907219,totalOccurrences:7134},{name:"Qubit",company:"Qubit",category:"analytics",domains:["*.qubit.com","*.qutics.com","d3c3cq33003psk.cloudfront.net","*.goqubit.com","*.qubitproducts.com"],totalExecutionTime:50060,totalOccurrences:43},{name:"Qubit Deliver",company:"Qubit",category:"analytics",domains:["d1m54pdnjzjnhe.cloudfront.net","d22rutvoghj3db.cloudfront.net","dd6zx4ibq538k.cloudfront.net"]},{name:"QuestionPro",category:"analytics",domains:["*.questionpro.com"],totalExecutionTime:60868,totalOccurrences:152},{name:"Queue-it",category:"other",domains:["*.queue-it.net"],totalExecutionTime:60031,
totalOccurrences:143},{name:"QuinStreet",category:"ad",domains:["*.Quinstreet.com","*.b2btechleadform.com","*.qnsr.com","*.qsstats.com"],examples:["www.qsstats.com"]},{name:"QuoVadis",category:"utility",domains:["*.quovadisglobal.com"]},{name:"Qzzr",category:"analytics",domains:["*.movementventures.com","*.qzzr.com"],examples:["www.qzzr.com"]},{name:"RapidAPI",category:"utility",domains:["*.rapidapi.com"],examples:["telize-v1.p.rapidapi.com"],totalExecutionTime:4218,totalOccurrences:2},{name:"RCS Media Group",category:"ad",domains:["*.rcsadv.it"]},{name:"REVIVVE",category:"ad",domains:["*.revivve.com"]},{name:"RSSinclude",category:"social",domains:["*.rssinclude.com"]},{name:"RTB House AdPilot",company:"RTB House",category:"ad",domains:["*.erne.co","*.creativecdn.com"],totalExecutionTime:1677125,totalOccurrences:13287},{name:"RTB Media",category:"ad",domains:["*.rtb-media.me"]},{name:"RUN",category:"ad",domains:["*.runadtag.com","*.rundsp.com"]},{name:"Rackspace",category:"hosting",domains:[
"*.rackcdn.com","*.rackspacecloud.com","*.raxcdn.com","*.websitetestlink.com"],totalExecutionTime:3573460,totalOccurrences:2624},{name:"RadiumOne",category:"ad",domains:["*.gwallet.com","*.r1-cdn.net"]},{name:"Rakuten DC Storm",company:"Rakuten",category:"analytics",domains:["*.dc-storm.com","*.h4k5.com","*.stormiq.com"]},{name:"Rakuten LinkShare",company:"Rakuten",category:"ad",domains:["*.linksynergy.com"],totalExecutionTime:23285,totalOccurrences:151},{name:"Rakuten Marketing",company:"Rakuten",category:"ad",domains:["*.rakuten-static.com","*.rmtag.com","tag.rmp.rakuten.com"],totalExecutionTime:462276,totalOccurrences:3399},{name:"Rakuten MediaForge",company:"Rakuten",category:"ad",domains:["*.mediaforge.com"],totalExecutionTime:1650,totalOccurrences:20},{name:"Rambler",company:"Rambler & Co",category:"utility",domains:["*.rambler.ru"],totalExecutionTime:54521084,totalOccurrences:15831},{name:"Ranker",category:"content",domains:["*.ranker.com","*.rnkr-static.com"]},{name:"Ravelin",category:"\
utility",domains:["*.ravelin.com"]},{name:"Raygun",category:"utility",domains:["*.raygun.io","*.rapidzebra.io"],totalExecutionTime:245714,totalOccurrences:2539},{name:"ReCollect",category:"utility",domains:["*.recollect.net"],totalExecutionTime:229879,totalOccurrences:135},{name:"ReSRC",category:"utility",domains:["*.resrc.it"]},{name:"ReTargeter",category:"ad",domains:["*.retargeter.com"]},{name:"Reach Group",category:"ad",domains:["*.redintelligence.net"],totalExecutionTime:1449,totalOccurrences:199},{name:"ReachDynamics",category:"ad",domains:["*.rdcdn.com"]},{name:"ReachForce",category:"ad",domains:["*.reachforce.com"]},{name:"ReachLocal",category:"ad",domains:["*.rtrk.co.nz"],examples:["rtsys.rtrk.co.nz"]},{name:"ReachMee",category:"content",domains:["*.reachmee.com"],totalExecutionTime:133135,totalOccurrences:40},{name:"Reactful",category:"analytics",domains:["*.reactful.com"],totalExecutionTime:12497,totalOccurrences:42},{name:"Realtime",company:"internet business technologies",
category:"utility",domains:["*.realtime.co"]},{name:"Realtime Media (Brian Communications)",category:"ad",domains:["*.rtm.com"]},{name:"Realtime Targeting",category:"ad",domains:["*.idtargeting.com"]},{name:"Realytics",category:"analytics",domains:["dcniko1cv0rz.cloudfront.net","*.realytics.net"],totalExecutionTime:38343,totalOccurrences:276},{name:"RebelMouse",category:"ad",domains:["*.rebelmouse.com","*.rbl.ms"],examples:["www.rebelmouse.com"],totalExecutionTime:3876,totalOccurrences:22},{name:"Receiptful",category:"utility",domains:["*.receiptful.com"],totalExecutionTime:58254,totalOccurrences:361},{name:"Recite Me",category:"other",domains:["*.reciteme.com"],totalExecutionTime:22320,totalOccurrences:142},{name:"RecoBell",category:"analytics",domains:["*.recobell.io"]},{name:"Recommend",category:"analytics",domains:["*.recommend.pro"]},{name:"Red Eye International",category:"ad",domains:["*.pajmc.com"]},{name:"Redfish Group",category:"ad",domains:["*.wmps.com"]},{name:"Reevoo",category:"\
analytics",domains:["*.reevoo.com"],totalExecutionTime:87323,totalOccurrences:133},{name:"Refersion",category:"ad",domains:["*.refersion.com"],totalExecutionTime:564360,totalOccurrences:2170},{name:"Refined Ads",category:"ad",domains:["*.refinedads.com"]},{name:"Reflektion",category:"analytics",domains:["*.reflektion.com","d26opx5dl8t69i.cloudfront.net"]},{name:"Reflow",company:"Scenestealer",category:"ad",domains:["*.reflow.tv"]},{name:"Reklama",category:"ad",domains:["*.o2.pl","*.wp.pl"],examples:["dot.wp.pl","px.o2.pl","px.wp.pl"],totalExecutionTime:846563,totalOccurrences:1054},{name:"Relevad ReleStar",company:"Relevad",category:"ad",domains:["*.relestar.com"]},{name:"Remarketing Pixel",company:"Adsterra Network",category:"ad",domains:["*.datadbs.com","*.remarketingpixel.com"]},{name:"Remintrex",company:"SmartUp Venture",category:"ad",domains:["*.remintrex.com"]},{name:"Republer",category:"ad",domains:["*.republer.com"],examples:["sync.republer.com"]},{name:"Research Now",category:"\
analytics",domains:["*.researchgnow.com","*.researchnow.com"],examples:["tag.researchgnow.com"]},{name:"Research Online",company:"Skills Development Scotland",category:"content",domains:["*.researchonline.org.uk"],examples:["www.researchonline.org.uk"]},{name:"Resonance Insights",category:"analytics",domains:["*.res-x.com"],totalExecutionTime:2277,totalOccurrences:20},{name:"Resonate Networks",category:"analytics",domains:["*.reson8.com"],totalExecutionTime:1739,totalOccurrences:1},{name:"Response Team",category:"ad",domains:["*.i-transactads.com"]},{name:"ResponseTap",category:"analytics",domains:["*.adinsight.com","*.responsetap.com"],totalExecutionTime:84074,totalOccurrences:274},{name:"ResponsiveVoice",category:"other",domains:["*.responsivevoice.org"],totalExecutionTime:851397,totalOccurrences:6863},{name:"Retention Science",category:"ad",domains:["*.retentionscience.com","d1stxfv94hrhia.cloudfront.net"],totalExecutionTime:17276,totalOccurrences:209},{name:"Revcontent",category:"c\
ontent",domains:["*.revcontent.com"],totalExecutionTime:1153469,totalOccurrences:1251},{name:"Revee",category:"ad",domains:["*.revee.com"]},{name:"Revenue Conduit",category:"utility",domains:["*.revenueconduit.com"]},{name:"RevenueMantra",category:"ad",domains:["*.revenuemantra.com"]},{name:"Reviews.co.uk",category:"analytics",domains:["*.reviews.co.uk"],totalExecutionTime:425151,totalOccurrences:1883},{name:"Reviews.io",category:"analytics",domains:["*.reviews.io"],totalExecutionTime:1713955,totalOccurrences:4516},{name:"Revolver Maps",category:"analytics",domains:["*.revolvermaps.com"],totalExecutionTime:2132297,totalOccurrences:2305},{name:"Revv",category:"utility",domains:["*.revv.co"],totalExecutionTime:26667,totalOccurrences:11},{name:"RichRelevance",category:"analytics",domains:["*.richrelevance.com"],totalExecutionTime:3496,totalOccurrences:19},{name:"RightNow Service Cloud",company:"Oracle",category:"customer-success",domains:["*.rightnowtech.com","*.rnengage.com"],totalExecutionTime:8970,
totalOccurrences:122},{name:"Rightster",category:"ad",domains:["*.ads-creativesyndicator.com"]},{name:"Riskified",category:"utility",domains:["*.riskified.com"],totalExecutionTime:373865,totalOccurrences:1643},{name:"Rockerbox",category:"analytics",homepage:"https://www.rockerbox.com/",domains:["getrockerbox.com"],examples:["getrockerbox.com"],totalExecutionTime:19742,totalOccurrences:162},{name:"Rocket Fuel",category:"ad",domains:["*.rfihub.com","*.ru4.com","*.rfihub.net","*.ad1x.com"],totalExecutionTime:356189,totalOccurrences:3247},{name:"Rollbar",category:"utility",domains:["*.rollbar.com","d37gvrvc0wt4s1.cloudfront.net"],examples:["api.rollbar.com"],totalExecutionTime:190180,totalOccurrences:2349},{name:"RomanCart",category:"utility",domains:["*.romancart.com"],totalExecutionTime:510,totalOccurrences:5},{name:"Rondavu",category:"ad",domains:["*.rondavu.com"]},{name:"Roomkey",category:"content",domains:["*.roomkey.com"],examples:["www.roomkey.com"]},{name:"Roost",category:"utility",
domains:["*.goroost.com"]},{name:"Roxot",category:"ad",domains:["*.rxthdr.com"]},{name:"Roxr Software",category:"analytics",domains:["*.getclicky.com"],totalExecutionTime:851573,totalOccurrences:12877},{name:"Rtoaster",company:"Brainpad",homepage:"https://www.brainpad.co.jp/rtoaster/",category:"marketing",domains:["*.rtoaster.jp"],examples:["rt.rtoaster.jp"],totalExecutionTime:15065,totalOccurrences:91},{name:"Rubikloud.com",category:"analytics",domains:["*.rubikloud.com"]},{name:"Ruler Analytics",company:"Ruler",category:"analytics",domains:["*.nyltx.com","*.ruleranalytics.com"],examples:["www.ruleranalytics.com"],totalExecutionTime:41074,totalOccurrences:436},{name:"Runner",company:"Rambler & Co",category:"content",domains:["*.begun.ru"],totalExecutionTime:26,totalOccurrences:1},{name:"S4M",category:"ad",domains:["*.sam4m.com"]},{name:"SAP Hybris Marketing Convert",company:"SAP",category:"ad",domains:["*.seewhy.com"]},{name:"SAS Institute",category:"ad",domains:["*.aimatch.com","*.sa\
s.com"],totalExecutionTime:59419,totalOccurrences:29},{name:"SATORI",homepage:"https://satori.marketing/",category:"marketing",domains:["satori.segs.jp"],examples:["satori.segs.jp/s.js"],totalExecutionTime:62202,totalOccurrences:816},{name:"SC ShopMania Net SRL",category:"content",domains:["*.shopmania.com"]},{name:"SDL Media Manager",company:"SDL",category:"other",domains:["*.sdlmedia.com"]},{name:"SFR",category:"other",domains:["*.sfr.fr"],examples:["elr.sfr.fr"],totalExecutionTime:22751,totalOccurrences:22},{name:"SLI Systems",category:"utility",domains:["*.resultslist.com","*.resultspage.com","*.sli-spark.com"],totalExecutionTime:2909,totalOccurrences:33},{name:"SMARTASSISTANT",company:"Smart Information Systems",category:"customer-success",domains:["*.smartassistant.com"]},{name:"SMARTSTREAM.TV",category:"ad",domains:["*.smartstream.tv"]},{name:"SPX",company:"Smaato",category:"ad",domains:["*.smaato.net"],totalExecutionTime:519,totalOccurrences:13},{name:"Sabio",category:"customer\
-success",domains:["*.sabio.co.uk"],examples:["www.sabio.co.uk"]},{name:"Sailthru",category:"analytics",domains:["*.sail-horizon.com","*.sail-personalize.com","*.sail-track.com"],totalExecutionTime:59245,totalOccurrences:678},{name:"Sailthru Sightlines",company:"Sailthru",category:"marketing",domains:["*.sailthru.com"],totalExecutionTime:6772,totalOccurrences:18},{name:"Sajari Pty",category:"utility",domains:["*.sajari.com"],totalExecutionTime:70019,totalOccurrences:197},{name:"SaleCycle",category:"ad",domains:["*.salecycle.com","d16fk4ms6rqz1v.cloudfront.net","d22j4fzzszoii2.cloudfront.net","d30ke5tqu2tkyx.cloudfront.net","dn1i8v75r669j.cloudfront.net"],totalExecutionTime:146399,totalOccurrences:641},{name:"Salesforce Live Agent",company:"Salesforce.com",category:"customer-success",domains:["*.salesforceliveagent.com"],totalExecutionTime:100033,totalOccurrences:675},{name:"Salesforce.com",category:"ad",domains:["*.force.com","*.salesforce.com"],examples:["secure.force.com"],totalExecutionTime:1614051,
totalOccurrences:4970},{name:"Samba TV",company:"Samba",category:"content",domains:["*.samba.tv"],totalExecutionTime:1690,totalOccurrences:7},{name:"Samplicio.us",category:"analytics",domains:["*.samplicio.us"],totalExecutionTime:1727,totalOccurrences:5},{name:"Say Media",category:"ad",domains:["*.saymedia.com"]},{name:"Scenario",category:"analytics",domains:["*.getscenario.com"]},{name:"Schuh (image shard)",company:"Schuh",category:"other",domains:["d2ob0iztsaxy5v.cloudfront.net"]},{name:"Science Rockstars",category:"analytics",domains:["*.persuasionapi.com"]},{name:"ScientiaMobile",category:"analytics",domains:["*.wurflcloud.com","*.wurfl.io"],totalExecutionTime:627,totalOccurrences:3},{name:"Scoota",category:"ad",domains:["*.rockabox.co","*.scoota.co","d31i2625d5nv27.cloudfront.net","dyjnzf8evxrp2.cloudfront.net"]},{name:"ScribbleLive",category:"ad",domains:["*.scribblelive.com"]},{name:"SearchForce",category:"ad",domains:["*.searchforce.net"],totalExecutionTime:118,totalOccurrences:3},
{name:"SearchSpring",category:"utility",domains:["*.searchspring.net"],totalExecutionTime:1175588,totalOccurrences:309},{name:"Searchanise",category:"analytics",domains:["*.searchanise.com"],examples:["www.searchanise.com"],totalExecutionTime:63519,totalOccurrences:420},{name:"Sears Holdings",category:"content",domains:["*.shld.net"]},{name:"Secomapp",category:"utility",domains:["*.secomapp.com"],totalExecutionTime:2151952,totalOccurrences:2137},{name:"SecuredVisit",company:"4Cite Marketing",category:"ad",domains:["*.securedvisit.com"],totalExecutionTime:41054,totalOccurrences:369},{name:"SecurityMetrics",category:"utility",domains:["*.securitymetrics.com"],totalExecutionTime:8413,totalOccurrences:2},{name:"Segmento",category:"ad",domains:["*.rutarget.ru"],totalExecutionTime:17111,totalOccurrences:226},{name:"Segmint",category:"analytics",domains:["*.segmint.net"],totalExecutionTime:14122,totalOccurrences:109},{name:"Sekindo",category:"content",domains:["*.sekindo.com"],totalExecutionTime:376,
totalOccurrences:4},{name:"Seldon",category:"analytics",domains:["*.rummblelabs.com"]},{name:"SelectMedia International",category:"content",domains:["*.selectmedia.asia"],totalExecutionTime:186574,totalOccurrences:68},{name:"Selligent",category:"ad",domains:["*.emsecure.net","*.slgnt.eu","targetemsecure.blob.core.windows.net"],totalExecutionTime:163886,totalOccurrences:506},{name:"Sellpoints",category:"analytics",domains:["*.sellpoints.com"]},{name:"Semantics3",category:"analytics",domains:["*.hits.io"]},{name:"Semasio",category:"analytics",domains:["*.semasio.net"]},{name:"Semcasting Site Visitor Attribution",company:"Semcasting",category:"ad",domains:["*.smartzonessva.com"]},{name:"Sentifi",category:"social",domains:["*.sentifi.com"]},{name:"ServMetric",category:"analytics",domains:["*.servmetric.com"]},{name:"ServiceSource International",category:"marketing",domains:["*.scoutanalytics.net"],examples:["scout.scoutanalytics.net"]},{name:"ServiceTick",category:"analytics",domains:["*.s\
ervicetick.com"]},{name:"Servo",company:"Xervo",category:"hosting",domains:["*.onmodulus.net"]},{name:"SessionCam",company:"ServiceTick",category:"analytics",domains:["*.sessioncam.com","d2oh4tlt9mrke9.cloudfront.net"]},{name:"Seznam",category:"utility",domains:["*.imedia.cz"],totalExecutionTime:1323711,totalOccurrences:6863},{name:"Sharethrough",category:"ad",domains:["*.sharethrough.com"],totalExecutionTime:46730,totalOccurrences:833},{name:"SharpSpring",category:"marketing",domains:["*.sharpspring.com","*.marketingautomation.services"],totalExecutionTime:632191,totalOccurrences:2080},{name:"ShopRunner",category:"content",domains:["*.shoprunner.com","*.s-9.us"],totalExecutionTime:35573,totalOccurrences:32},{name:"ShopStorm",category:"utility",domains:["*.shopstorm.com"]},{name:"Shopatron",category:"hosting",domains:["*.shopatron.com"]},{name:"Shopgate",category:"utility",domains:["*.shopgate.com"],totalExecutionTime:15293,totalOccurrences:25},{name:"ShopiMind",company:"ShopIMind",category:"\
ad",domains:["*.shopimind.com"]},{name:"Shopkeeper Tools",category:"utility",domains:["*.shopkeepertools.com"],totalExecutionTime:500,totalOccurrences:6},{name:"Sidecar",category:"other",domains:["*.getsidecar.com","d3v27wwd40f0xu.cloudfront.net"]},{name:"Sidereel",category:"analytics",domains:["*.sidereel.com"]},{name:"Sift Science",category:"utility",domains:["*.siftscience.com"],totalExecutionTime:90167,totalOccurrences:355},{name:"Signal",category:"tag-manager",domains:["*.sitetagger.co.uk"]},{name:"Signyfyd",category:"utility",domains:["*.signifyd.com"],totalExecutionTime:4752892,totalOccurrences:2608},{name:"Silktide",category:"hosting",domains:["*.silktide.com"],totalExecutionTime:132707,totalOccurrences:390},{name:"Silverpop",company:"IBM",category:"ad",domains:["*.mkt912.com","*.mkt922.com","*.mkt932.com","*.mkt941.com","*.mkt51.net","*.mkt61.net","*.pages01.net","*.pages02.net","*.pages03.net","*.pages04.net","*.pages05.net"],totalExecutionTime:4144,totalOccurrences:58},{name:"\
Simplaex",category:"marketing",domains:["*.simplaex.net"]},{name:"SimpleReach",category:"analytics",domains:["*.simplereach.com","d8rk54i4mohrb.cloudfront.net"]},{name:"Simplestream",category:"content",domains:["*.simplestream.com"],examples:["player.simplestream.com"]},{name:"Simpli.fi",category:"ad",domains:["*.simpli.fi"],totalExecutionTime:974218,totalOccurrences:16378},{name:"Simplicity Marketing",category:"ad",domains:["*.flashtalking.com"],totalExecutionTime:579126,totalOccurrences:2927},{name:"SinnerSchrader Deutschland",category:"ad",domains:["*.s2Betrieb.de"]},{name:"Sirv",category:"other",domains:["*.sirv.com"],totalExecutionTime:604262,totalOccurrences:1034},{name:"Site Meter",category:"analytics",domains:["*.sitemeter.com"]},{name:"Site24x7 Real User Monitoring",company:"Site24x7",category:"analytics",domains:["*.site24x7rum.com"],totalExecutionTime:124283,totalOccurrences:1007},{name:"SiteGainer",category:"analytics",domains:["*.sitegainer.com","d191y0yd6d0jy4.cloudfront.\
net"]},{name:"SiteScout",company:"Centro",category:"ad",domains:["*.pixel.ad","*.sitescout.com"],totalExecutionTime:256082,totalOccurrences:3401},{name:"Siteimprove",category:"utility",domains:["*.siteimprove.com","*.siteimproveanalytics.com"],totalExecutionTime:28494,totalOccurrences:361},{name:"Six Degrees Group",category:"hosting",domains:["*.fstech.co.uk"]},{name:"Skimbit",category:"ad",domains:["*.redirectingat.com","*.skimresources.com","*.skimresources.net"],totalExecutionTime:32940093,totalOccurrences:86270},{name:"Skimlinks",category:"ad",domains:["*.skimlinks.com"]},{name:"SkyGlue Technology",category:"analytics",domains:["*.skyglue.com"],totalExecutionTime:2567,totalOccurrences:24},{name:"SkyScanner",category:"content",domains:["*.skyscanner.net"],examples:["api.skyscanner.net"],totalExecutionTime:98147,totalOccurrences:370},{name:"Skybet",company:"Bonne Terre t/a Sky Vegas (Sky)",category:"other",domains:["*.skybet.com"]},{name:"Skype",category:"other",domains:["*.skype.com"],
totalExecutionTime:121901,totalOccurrences:625},{name:"Slate Group",category:"content",domains:["*.cdnslate.com"]},{name:"SlimCut Media Outstream",company:"SlimCut Media",category:"ad",domains:["*.freeskreen.com"]},{name:"Smart Insight Tracking",company:"Emarsys",category:"analytics",domains:["*.scarabresearch.com"],totalExecutionTime:361811,totalOccurrences:1779},{name:"Smart AdServer",category:"ad",domains:["*.01net.com","*.sascdn.com","*.sasqos.com","*.smartadserver.com"],examples:["securite.01net.com"],totalExecutionTime:22356737,totalOccurrences:107812},{name:"SmartFocus",category:"analytics",domains:["*.emv2.com","*.emv3.com","*.predictiveintent.com","*.smartfocus.com","*.themessagecloud.com"]},{name:"Smarter Click",category:"ad",domains:["*.smct.co","*.smarterclick.co.uk"],totalExecutionTime:761,totalOccurrences:11},{name:"SmarterHQ",category:"analytics",domains:["*.smarterhq.io","d1n00d49gkbray.cloudfront.net","*.smarterremarketer.net"],totalExecutionTime:2636,totalOccurrences:28},
{name:"Smarttools",category:"customer-success",domains:["*.smartertrack.com"]},{name:"Smartzer",category:"ad",domains:["*.smartzer.com"]},{name:"Snack Media",category:"content",domains:["*.snack-media.com"],totalExecutionTime:575613,totalOccurrences:423},{name:"Snacktools",category:"ad",domains:["*.bannersnack.com"],totalExecutionTime:162327,totalOccurrences:303},{name:"SnapEngage",category:"customer-success",domains:["*.snapengage.com"],totalExecutionTime:147012,totalOccurrences:1038},{name:"SnapWidget",category:"content",domains:["*.snapwidget.com"]},{name:"Soasta",category:"analytics",domains:["*.lognormal.net"]},{name:"SociableLabs",category:"ad",domains:["*.sociablelabs.net","*.sociablelabs.com"]},{name:"Social Annex",category:"customer-success",domains:["*.socialannex.com"]},{name:"SocialShopWave",category:"social",domains:["*.socialshopwave.com"],totalExecutionTime:4962079,totalOccurrences:3720},{name:"Socialphotos",category:"social",domains:["*.slpht.com"],totalExecutionTime:12590,
totalOccurrences:120},{name:"Sociomantic Labs",company:"DunnHumby",category:"ad",domains:["*.sociomantic.com"]},{name:"SodaHead",category:"analytics",domains:["*.sodahead.com"],examples:["pollware-cdn.sodahead.com"]},{name:"Softwebzone",category:"hosting",domains:["*.softwebzone.com"],examples:["www.softwebzone.com"]},{name:"Sojern",category:"marketing",domains:["*.sojern.com"],totalExecutionTime:2086952,totalOccurrences:4422},{name:"Sokrati",category:"marketing",domains:["*.sokrati.com"]},{name:"Sonobi",category:"ad",domains:["*.sonobi.com"],totalExecutionTime:4682222,totalOccurrences:81682},{name:"Sooqr Search",company:"Sooqr",category:"utility",domains:["*.sooqr.com"],totalExecutionTime:176199,totalOccurrences:396},{name:"Sophus3",category:"analytics",domains:["*.s3ae.com","*.sophus3.com"],totalExecutionTime:5605,totalOccurrences:11},{name:"Sorenson Media",category:"content",domains:["*.sorensonmedia.com"]},{name:"Sortable",category:"ad",domains:["*.deployads.com"]},{name:"Sotic",category:"\
hosting",domains:["*.sotic.net","*.soticservers.net"]},{name:"Soundest",category:"ad",domains:["*.soundestlink.com","*.soundest.net"],totalExecutionTime:835,totalOccurrences:102},{name:"Sourcepoint",category:"ad",domains:["*.decenthat.com","*.fallingfalcon.com","*.summerhamster.com","d2lv4zbk7v5f93.cloudfront.net","d3qxwzhswv93jk.cloudfront.net"],examples:["www.decenthat.com","www.fallingfalcon.com","www.summerhamster.com"]},{name:"SourceKnowledge",homepage:"https://www.sourceknowledge.com",category:"ad",domains:["*.provenpixel.com"],totalExecutionTime:505,totalOccurrences:8},{name:"SpaceNet",category:"hosting",domains:["*.nmm.de"]},{name:"Sparkflow",company:"Intercept Interactive",category:"ad",domains:["*.sparkflow.net"]},{name:"Specific Media",category:"ad",domains:["*.specificmedia.com","*.adviva.net","*.specificclick.net"]},{name:"Spicy",company:"Data-Centric Alliance",category:"ad",domains:["*.sspicy.ru"]},{name:"Spoke",category:"customer-success",domains:["*.121d8.com"]},{name:"\
Spongecell",category:"ad",domains:["*.spongecell.com"]},{name:"Spot.IM",category:"social",domains:["*.spot.im","*.spotim.market"],totalExecutionTime:192547,totalOccurrences:342},{name:"SpotXchange",category:"ad",domains:["*.spotxcdn.com","*.spotxchange.com","*.spotx.tv"]},{name:"SpringServer",category:"ad",domains:["*.springserve.com"],totalExecutionTime:1192823,totalOccurrences:1432},{name:"Spylight",category:"other",domains:["*.spylight.com"]},{name:"SreamAMG",company:"StreamAMG",category:"other",domains:["*.streamamg.com"],totalExecutionTime:85506,totalOccurrences:62},{name:"StackAdapt",category:"ad",domains:["*.stackadapt.com"],totalExecutionTime:1338506,totalOccurrences:14912},{name:"StackExchange",category:"social",domains:["*.sstatic.net"],totalExecutionTime:187262,totalOccurrences:217},{name:"Stackla PTY",category:"social",domains:["*.stackla.com"],totalExecutionTime:271026,totalOccurrences:175},{name:"Stailamedia",category:"ad",domains:["*.stailamedia.com"]},{name:"Stamped.io",
category:"analytics",domains:["*.stamped.io"],totalExecutionTime:1665115,totalOccurrences:12460},{name:"Starfield Services Root Certificate Authority",company:"Starfield Technologies",category:"utility",domains:["*.starfieldtech.com","ss2.us","*.ss2.us"],examples:["ocsp.starfieldtech.com"],totalExecutionTime:18156,totalOccurrences:39},{name:"Starfield Technologies",category:"utility",domains:["*.websiteprotection.com"],examples:["seals.websiteprotection.com"]},{name:"StatCounter",category:"analytics",domains:["*.statcounter.com"],totalExecutionTime:5427381,totalOccurrences:50769},{name:"Statful",category:"analytics",domains:["*.statful.com"]},{name:"Steelhouse",category:"ad",domains:["*.steelhousemedia.com"],totalExecutionTime:66172,totalOccurrences:452},{name:"Steepto",category:"ad",domains:["*.steepto.com"],totalExecutionTime:170,totalOccurrences:1},{name:"StellaService",category:"analytics",domains:["*.stellaservice.com"]},{name:"StickyADS.tv",category:"ad",domains:["*.stickyadstv.c\
om"],totalExecutionTime:2198555,totalOccurrences:1462},{name:"STINGRAY",company:"FlexOne",category:"ad",domains:["*.impact-ad.jp"],examples:["y.one.impact-ad.jp"],totalExecutionTime:1261721,totalOccurrences:9742},{name:"Storify",company:"Adobe Systems",category:"social",domains:["*.storify.com"]},{name:"Storm Tag Manager",company:"Rakuten",category:"tag-manager",domains:["*.stormcontainertag.com"]},{name:"Storygize",category:"ad",domains:["*.storygize.net"],examples:["www.storygize.net"],totalExecutionTime:60468,totalOccurrences:154},{name:"Strands",category:"utility",domains:["*.strands.com"]},{name:"StreamRail",category:"ad",domains:["*.streamrail.com","*.streamrail.net"]},{name:"StrikeAd",category:"ad",domains:["*.strikead.com"]},{name:"Struq",company:"Quantcast",category:"ad",domains:["*.struq.com"]},{name:"StrÃ¶er Digital Media",category:"ad",domains:["*.stroeerdigitalmedia.de"]},{name:"StumbleUpon",category:"content",domains:["*.stumble-upon.com","*.stumbleupon.com"],totalExecutionTime:18653,
totalOccurrences:17},{name:"Sub2 Technologies",category:"analytics",domains:["*.sub2tech.com"],totalExecutionTime:6667,totalOccurrences:31},{name:"SublimeSkinz",category:"ad",domains:["*.ayads.co"],totalExecutionTime:339456,totalOccurrences:772},{name:"Sumo Logic",category:"utility",domains:["*.sumologic.com"],totalExecutionTime:19322,totalOccurrences:9},{name:"Sunday Times Driving",category:"content",domains:["*.driving.co.uk"]},{name:"SundaySky",category:"ad",domains:["*.sundaysky.com","dds6m601du5ji.cloudfront.net"],totalExecutionTime:7435,totalOccurrences:10},{name:"Sunrise Integration",category:"utility",domains:["*.sunriseintegration.com"]},{name:"Supertool Network Technology",category:"analytics",domains:["*.miaozhen.com"],totalExecutionTime:6166,totalOccurrences:49},{name:"Survata",category:"analytics",domains:["*.survata.com"]},{name:"SurveyGizmo",category:"analytics",domains:["*.surveygizmo.eu"],examples:["www.surveygizmo.eu"]},{name:"SurveyMonkey",category:"analytics",domains:[
"*.surveymonkey.com"],totalExecutionTime:28632,totalOccurrences:250},{name:"Survicate",category:"analytics",domains:["*.survicate.com"],totalExecutionTime:933283,totalOccurrences:3008},{name:"Sweet Tooth",category:"ad",domains:["*.sweettooth.io"],totalExecutionTime:2673,totalOccurrences:41},{name:"Swiftype",category:"utility",domains:["*.swiftype.com","*.swiftypecdn.com"],totalExecutionTime:383638,totalOccurrences:982},{name:"Switch Concepts",category:"ad",domains:["*.switchadhub.com"]},{name:"SwitchAds",company:"Switch Concepts",category:"ad",domains:["*.switchads.com"]},{name:"Swogo",category:"analytics",domains:["*.xsellapp.com"]},{name:"Swoop",category:"ad",domains:["*.swoop.com"],totalExecutionTime:13511,totalOccurrences:75},{name:"Symantec",category:"utility",domains:["*.norton.com","*.symantec.com","*.symcb.com","*.symcd.com"],examples:["extended-validation-ssl.websecurity.symantec.com"],totalExecutionTime:184600,totalOccurrences:363},{name:"Syncapse",category:"social",domains:[
"*.clickable.net"]},{name:"Synergetic",category:"ad",domains:["*.synergetic.ag"]},{name:"Synthetix",category:"customer-success",domains:["*.syn-finity.com","*.synthetix-ec1.com","*.synthetix.com"],examples:["www.synthetix-ec1.com"],totalExecutionTime:6284,totalOccurrences:27},{name:"Syte",category:"other",domains:["*.syteapi.com"],examples:["cdn.syteapi.com"],totalExecutionTime:109749,totalOccurrences:106},{name:"TINT",category:"content",domains:["*.71n7.com","d33w9bm0n1egwm.cloudfront.net","d36hc0p18k1aoc.cloudfront.net","d3l7tj34e9fc43.cloudfront.net"],examples:["www.71n7.com"]},{name:"TNS (Kantar Group)",category:"analytics",domains:["*.tns-counter.ru"]},{name:"TRUSTe",category:"utility",domains:["*.truste.com"],totalExecutionTime:123425,totalOccurrences:613},{name:"TV Genius",company:"Ericcson Media Services",category:"content",domains:["*.tvgenius.net"]},{name:"TVSquared",category:"ad",domains:["*.tvsquared.com"],totalExecutionTime:548667,totalOccurrences:4082},{name:"TVTY",category:"\
ad",domains:["*.distribeo.com","*.ogigl.com"]},{name:"Tactics bvba",category:"hosting",domains:["*.influid.co"]},{name:"Tag Inspector",company:"InfoTrust",category:"analytics",domains:["d22xmn10vbouk4.cloudfront.net"],totalExecutionTime:51386,totalOccurrences:171},{name:"TagCommander",category:"tag-manager",domains:["*.commander1.com","*.tagcommander.com"],totalExecutionTime:448164,totalOccurrences:1509},{name:"Tagboard",category:"social",domains:["*.tagboard.com"],totalExecutionTime:106499,totalOccurrences:49},{name:"Taggstar",company:"Taggstar UK",category:"ad",domains:["*.taggstar.com"],totalExecutionTime:16168,totalOccurrences:68},{name:"Tail Target",company:"Tail",category:"ad",domains:["*.tailtarget.com"],totalExecutionTime:176612,totalOccurrences:873},{name:"Tailored",category:"other",domains:["d24qm7bu56swjs.cloudfront.net","dw3vahmen1rfy.cloudfront.net","*.tailored.to"]},{name:"Taleo Enterprise Cloud Service",company:"Oracle",category:"content",domains:["*.taleo.net"],totalExecutionTime:4178,
totalOccurrences:68},{name:"Talkable",category:"ad",domains:["*.talkable.com","d2jjzw81hqbuqv.cloudfront.net"],examples:["www.talkable.com"],totalExecutionTime:154019,totalOccurrences:601},{name:"TapSense",category:"ad",domains:["*.tapsense.com"]},{name:"Tapad",category:"ad",domains:["*.tapad.com"],totalExecutionTime:976,totalOccurrences:54},{name:"Teads",category:"ad",domains:["*.teads.tv"],totalExecutionTime:2295585,totalOccurrences:7565},{name:"Team Internet Tonic",company:"Team Internet",category:"ad",domains:["*.dntrax.com"]},{name:"TechTarget",category:"content",domains:["*.techtarget.com","*.ttgtmedia.com"],totalExecutionTime:11857,totalOccurrences:24},{name:"Technorati",company:"Synacor",category:"ad",domains:["*.technoratimedia.com"],totalExecutionTime:5382653,totalOccurrences:27186},{name:"Teedhaze",category:"content",domains:["*.fuel451.com"]},{name:"Tell Apart",category:"analytics",domains:["*.tellapart.com","*.tellaparts.com"]},{name:"Tencent",category:"content",domains:["\
*.qq.com","*.ywxi.net"],totalExecutionTime:2265040,totalOccurrences:8726},{name:"Thanx Media",category:"utility",domains:["*.hawksearch.info"]},{name:"Thawte",category:"utility",domains:["*.thawte.com"],examples:["ocsp.thawte.com","seal.thawte.com"],totalExecutionTime:307,totalOccurrences:1},{name:"Thesis",category:"analytics",homepage:"https://www.thesistesting.com/",domains:["*.ttsep.com"],examples:["thix.ttsep.com"]},{name:"The AA",category:"ad",domains:["*.adstheaa.com"]},{name:"The ADEX",category:"ad",domains:["*.theadex.com"],totalExecutionTime:13554,totalOccurrences:129},{name:"The Best Day",category:"social",domains:["*.thebestday.com"]},{name:"The Filter",company:"Exabre",category:"analytics",domains:["*.thefilter.com"]},{name:"The Guardian",category:"analytics",domains:["*.ophan.co.uk"]},{name:"The Hut Group",category:"content",domains:["*.thcdn.com"],totalExecutionTime:497181,totalOccurrences:281},{name:"The Numa Group",category:"other",domains:["*.hittail.com"]},{name:"The \
Publisher Desk",category:"ad",domains:["*.206ads.com","*.publisherdesk.com"]},{name:"The Sydney Morning Herald",company:"Fairfax Media",category:"content",domains:["*.smh.com.au"]},{name:"The Wall Street Jounal",category:"content",domains:["*.wsj.net"],totalExecutionTime:3036,totalOccurrences:5},{name:"The Wall Street Journal",category:"content",domains:["*.marketwatch.com"]},{name:"TheFind",category:"content",domains:["*.thefind.com"]},{name:"Thinglink",category:"utility",domains:["*.thinglink.com"],totalExecutionTime:2987,totalOccurrences:53},{name:"Thirdpresence",category:"ad",domains:["*.thirdpresence.com"]},{name:"ThreatMetrix",category:"utility",domains:["*.online-metrix.net"],totalExecutionTime:1901757,totalOccurrences:3530},{name:"Throtle",homepage:"https://throtle.io/",category:"analytics",domains:["*.thrtle.com","*.v12group.com"]},{name:"TicketMaster",category:"content",domains:["*.t-x.io","*.tmcs.net"]},{name:"TikTok",company:"ByteDance Ltd",homepage:"https://www.tiktok.com/\
en/",category:"social",domains:["*.tiktok.com","*.ipstatp.com"],examples:["analytics.tiktok.com","https://s0.ipstatp.com/ad/business/track-log.js"],totalExecutionTime:111182189,totalOccurrences:256224},{name:"Tidio Live Chat",company:"Tidio",homepage:"https://www.tidiochat.com/en/",category:"customer-success",domains:["*.tidiochat.com"],totalExecutionTime:26584634,totalOccurrences:24598},{name:"Tiledesk Live Chat",company:"Tiledesk SRL",homepage:"https://www.tiledesk.com/",category:"customer-success",domains:["*.tiledesk.com"],examples:["widget.tiledesk.com"],totalExecutionTime:253744,totalOccurrences:103},{name:"Time",category:"content",domains:["*.timeinc.net"]},{name:"Time2Perf",category:"ad",domains:["*.time2perf.com"]},{name:"TinyURL",category:"utility",domains:["*.tinyurl.com"]},{name:"Tivo",category:"analytics",domains:["*.rovicorp.com"]},{name:"Tom&Co",category:"hosting",domains:["*.tomandco.uk"]},{name:"Toms Native Ads",company:"Purch",category:"ad",domains:["*.natoms.com"]},{
name:"ToneMedia",category:"ad",domains:["*.clickfuse.com"]},{name:"Tonic",company:"Team Internet",category:"ad",domains:["*.dntx.com"]},{name:"Touch Commerce",category:"customer-success",domains:["*.inq.com","*.touchcommerce.com"],totalExecutionTime:12673,totalOccurrences:74},{name:"ToutApp",category:"ad",domains:["*.toutapp.com"]},{name:"TraceView",company:"Solarwinds",category:"analytics",domains:["*.tracelytics.com","d2gfdmu30u15x7.cloudfront.net"]},{name:"TrackJS",category:"analytics",domains:["*.trackjs.com","d2zah9y47r7bi2.cloudfront.net"],examples:["usage.trackjs.com"],totalExecutionTime:2112335,totalOccurrences:2268},{name:"Tradedoubler",category:"ad",domains:["*.pvnsolutions.com","*.tradedoubler.com"],totalExecutionTime:31870,totalOccurrences:165},{name:"Tradelab",category:"ad",domains:["*.tradelab.fr"],totalExecutionTime:5013,totalOccurrences:44},{name:"TrafficFactory",category:"ad",domains:["*.trafficfactory.biz"]},{name:"TrafficHunt",category:"ad",domains:["*.traffichunt.co\
m"]},{name:"TrafficStars",category:"ad",domains:["*.trafficstars.com","*.tsyndicate.com"],totalExecutionTime:3435101,totalOccurrences:7430},{name:"Transifex",category:"utility",domains:["*.transifex.com"],totalExecutionTime:193259,totalOccurrences:546},{name:"Travelex",category:"utility",domains:["*.travelex.net","*.travelex.co.uk"],examples:["api.travelex.net","travelmoney.travelex.co.uk"]},{name:"Travelocity Canada",company:"Travelocity",category:"content",domains:["*.travelocity.ca"],examples:["www.travelocity.ca"]},{name:"Travelocity USA",company:"Travelocity",category:"content",domains:["*.travelocity.com"],examples:["www.travelocity.com"]},{name:"Travelzoo",category:"content",domains:["*.travelzoo.com"]},{name:"Treasure Data",category:"analytics",domains:["*.treasuredata.com"],totalExecutionTime:1404314,totalOccurrences:14403},{name:"Tremor Video",category:"ad",domains:["*.tremorhub.com","*.videohub.tv"]},{name:"Trialfire",category:"analytics",domains:["*.trialfire.com"],totalExecutionTime:44579,
totalOccurrences:198},{name:"Tribal Fusion",company:"Exponential Interactive",category:"ad",domains:["*.tribalfusion.com"],totalExecutionTime:96569,totalOccurrences:158016},{name:"Triblio",category:"marketing",domains:["*.tribl.io"]},{name:"Triggered Messaging",company:"Fresh Relevance",category:"ad",domains:["*.triggeredmessaging.com"]},{name:"Trinity Mirror",category:"content",domains:["*.mirror.co.uk"],totalExecutionTime:13841,totalOccurrences:41},{name:"Trinity Mirror Digital Media",category:"social",domains:["*.tm-aws.com","*.icnetwork.co.uk"]},{name:"TripAdvisor",category:"content",domains:["*.jscache.com","*.tacdn.com","*.tamgrt.com","*.tripadvisor.com","*.viator.com","*.tripadvisor.co.uk"],examples:["www.jscache.com","www.tamgrt.com"],totalExecutionTime:749303,totalOccurrences:2354},{name:"TripleLift",category:"ad",domains:["*.3lift.com"],totalExecutionTime:8396,totalOccurrences:4812},{name:"Tru Optik",category:"ad",domains:["*.truoptik.com"]},{name:"TruConversion",category:"an\
alytics",domains:["*.truconversion.com"],totalExecutionTime:487670,totalOccurrences:1008},{name:"Trueffect",category:"marketing",domains:["*.adlegend.com"]},{name:"Truefit",category:"analytics",domains:["*.truefitcorp.com"],examples:["cdn.truefitcorp.com","fitrec.truefitcorp.com","sch-cdn.truefitcorp.com"],totalExecutionTime:4647,totalOccurrences:20},{name:"Trust Guard",category:"utility",domains:["*.trust-guard.com"],totalExecutionTime:3346,totalOccurrences:35},{name:"Trust Pilot",category:"analytics",domains:["*.trustpilot.com"],totalExecutionTime:14795265,totalOccurrences:54942},{name:"Amazon Trust Services",company:"Amazon",category:"utility",domains:["*.amazontrust.com","o.ss2.us"],examples:["ocsp.rootca1.amazontrust.com"],totalExecutionTime:107,totalOccurrences:1},{name:"Google Trust Services",company:"Google",category:"utility",domains:["*.pki.goog"],examples:["ocsp.pki.goog"],totalExecutionTime:18,totalOccurrences:1},{name:"Let's Encrypt",homepage:"https://letsencrypt.org/",category:"\
utility",domains:["*.letsencrypt.org"],examples:["ocsp.int-x3.letsencrypt.org"],totalExecutionTime:76,totalOccurrences:3},{name:"TrustX",category:"ad",domains:["*.trustx.org"]},{name:"Trusted Shops",category:"utility",domains:["*.trustedshops.com"],totalExecutionTime:7373870,totalOccurrences:17267},{name:"Trustev",company:"TransUnion",category:"utility",domains:["*.trustev.com"],totalExecutionTime:3272,totalOccurrences:22},{name:"Trustwave",category:"utility",domains:["*.trustwave.com"],totalExecutionTime:4600,totalOccurrences:7},{name:"Tryzens TradeState",company:"Tryzens",category:"analytics",domains:["*.tryzens-analytics.com"],totalExecutionTime:969,totalOccurrences:9},{name:"TubeMogul",category:"ad",domains:["*.tubemogul.com"],totalExecutionTime:24151,totalOccurrences:51},{name:"Turn",category:"ad",domains:["*.turn.com"],totalExecutionTime:4802,totalOccurrences:72},{name:"Tutorialize",category:"customer-success",domains:["*.tutorialize.me"]},{name:"Twenga",category:"content",domains:[
"*.twenga.fr","*.c4tw.net","*.twenga.co.uk"],examples:["tracker.twenga.co.uk"]},{name:"Twitframe",company:"Superblock",category:"utility",domains:["*.twitframe.com"]},{name:"Twitter Online Conversion Tracking",company:"Twitter",category:"ad",domains:["*.ads-twitter.com","analytics.twitter.com"],examples:["static.ads-twitter.com"],totalExecutionTime:6170585,totalOccurrences:73452},{name:"Twitter Short URL",company:"Twitter",category:"social",domains:["*.t.co"]},{name:"Twyn Group",category:"ad",domains:["*.twyn.com"]},{name:"Tynt",company:"33 Across",category:"ad",domains:["*.tynt.com"],totalExecutionTime:41643525,totalOccurrences:212415},{name:"Typepad",category:"hosting",domains:["*.typepad.com"],totalExecutionTime:834082,totalOccurrences:813},{name:"TyrbooBytes",category:"utility",domains:["*.turbobytes.net"]},{name:"UPS i-parcel",company:"UPS",category:"other",domains:["*.i-parcel.com"]},{name:"US Media Consulting",category:"ad",domains:["*.mediade.sk"]},{name:"Ubertags",category:"ta\
g-manager",domains:["*.ubertags.com"]},{name:"Umbel",category:"analytics",domains:["*.umbel.com"]},{name:"Unanimis",company:"Switch",category:"ad",domains:["*.unanimis.co.uk"]},{name:"Unbounce",category:"ad",domains:["*.ubembed.com","*.unbounce.com","d2xxq4ijfwetlm.cloudfront.net","d9hhrg4mnvzow.cloudfront.net"],totalExecutionTime:2902422,totalOccurrences:8808},{name:"Underdog Media",category:"ad",domains:["*.underdog.media","*.udmserve.net"],totalExecutionTime:524141,totalOccurrences:289},{name:"Understand Digital",category:"ad",domains:["*.redirecting2.net"]},{name:"Undertone",company:"Perion",category:"ad",domains:["*.legolas-media.com"],examples:["rt.legolas-media.com"]},{name:"Unidays",category:"ad",domains:["*.myunidays.com","*.unidays.world"]},{name:"Uniqodo",category:"ad",domains:["*.uniqodo.com"]},{name:"Unite",category:"ad",domains:["*.uadx.com"]},{name:"United Card Services",category:"utility",domains:["*.ucs.su"]},{name:"United Internet",category:"hosting",domains:["*.uicdn\
.com"],totalExecutionTime:14225,totalOccurrences:75},{name:"United Internet Media",category:"ad",domains:["*.ui-portal.de"],totalExecutionTime:20307,totalOccurrences:59},{name:"United Internet Media AG",category:"hosting",domains:["*.tifbs.net","*.uicdn.net","*.uimserv.net"],totalExecutionTime:1737,totalOccurrences:48},{name:"Unknown",category:"other",domains:[]},{name:"Unruly Media",category:"ad",domains:["*.unrulymedia.com"],totalExecutionTime:679,totalOccurrences:1789},{name:"UpBuild",category:"ad",domains:["*.upbuild.io"],examples:["www.upbuild.io"]},{name:"UpSellit",category:"analytics",domains:["*.upsellit.com"],examples:["www.upsellit.com"],totalExecutionTime:289920,totalOccurrences:1013},{name:"Upland Software",category:"hosting",domains:["*.clickability.com"]},{name:"Airship",category:"marketing",domains:["*.urbanairship.com","*.aswpsdkus.com"],totalExecutionTime:4666,totalOccurrences:37},{name:"UsabilityTools",category:"analytics",domains:["*.usabilitytools.com"]},{name:"Usab\
lenet.net",category:"utility",domains:["*.usablenet.net"]},{name:"Use It Better",category:"analytics",domains:["*.useitbetter.com"]},{name:"User Replay",category:"analytics",domains:["*.userreplay.net"]},{name:"UserReport",category:"analytics",domains:["*.userreport.com"],totalExecutionTime:133479,totalOccurrences:476},{name:"Userneeds",category:"analytics",domains:["*.userneeds.dk"]},{name:"Userzoom",category:"analytics",domains:["*.userzoom.com"],totalExecutionTime:5093,totalOccurrences:4},{name:"V12 Retail Finance",category:"utility",domains:["*.v12finance.com"]},{name:"Vacaciones eDreams",category:"content",domains:["*.odistatic.net"]},{name:"Varick Media Management",category:"ad",domains:["*.vmmpxl.com"]},{name:"Vdopia Chocolate",company:"Vdopia",category:"ad",domains:["*.vdopia.com"]},{name:"Ve",company:"Ve",homepage:"https://www.ve.com/",category:"marketing",domains:["*.veinteractive.com","*.ve.com"]},{name:"Ve Interactive",company:"Ve",category:"ad",domains:["*.vepxl1.net","*.a\
dgenie.co.uk"]},{name:"Vee24",category:"customer-success",domains:["*.vee24.com"],totalExecutionTime:20941,totalOccurrences:38},{name:"Veeseo",category:"content",domains:["*.veeseo.com"]},{name:"Venatus Media",category:"marketing",domains:["*.alcvid.com","*.venatusmedia.com"]},{name:"Veoxa",category:"ad",domains:["*.veoxa.com"]},{name:"Vergic AB",category:"customer-success",domains:["*.psplugin.com"],totalExecutionTime:48232,totalOccurrences:71},{name:"Vergic Engage Platform",company:"Vergic",category:"customer-success",domains:["*.vergic.com"],totalExecutionTime:41524,totalOccurrences:57},{name:"Verisign (Symantec)",category:"utility",domains:["*.verisign.com"]},{name:"Verizon",category:"utility",domains:["*.public-trust.com"],examples:["www.public-trust.com"]},{name:"Verizon Digital Media CDN",homepage:"https://www.verizondigitalmedia.com/",category:"cdn",domains:["*.edgecastcdn.net","*.edgecastdns.net"],totalExecutionTime:98698,totalOccurrences:108},{name:"Verizon Uplynk",company:"V\
erizon",category:"content",domains:["*.uplynk.com"],totalExecutionTime:572,totalOccurrences:4},{name:"Vero",company:"Semblance",category:"ad",domains:["*.getvero.com","d3qxef4rp70elm.cloudfront.net"],totalExecutionTime:613,totalOccurrences:10},{name:"VertaMedia",category:"ad",domains:["*.vertamedia.com"]},{name:"Vertical Mass",category:"ad",domains:["*.vmweb.net"]},{name:"Vestorly",category:"ad",domains:["*.oodalab.com"]},{name:"Vextras",category:"other",domains:["*.vextras.com"],totalExecutionTime:4484,totalOccurrences:42},{name:"Viacom",category:"content",domains:["*.mtvnservices.com"],totalExecutionTime:15501,totalOccurrences:44},{name:"Vibrant Media",category:"ad",domains:["*.intellitxt.com","*.picadmedia.com"]},{name:"VidPulse",category:"analytics",domains:["*.vidpulse.com"]},{name:"Video Media Groep",category:"ad",domains:["*.vmg.host","*.inpagevideo.nl"]},{name:"VideoHub",company:"Tremor Video",category:"ad",domains:["*.scanscout.com"],examples:["dt.scanscout.com"]},{name:"Video\
logy",category:"ad",domains:["*.tidaltv.com"]},{name:"Vidible",category:"ad",domains:["*.vidible.tv"]},{name:"VigLink",category:"ad",domains:["*.viglink.com"],totalExecutionTime:3670311,totalOccurrences:6219},{name:"Vindico",company:"Viant",category:"ad",domains:["*.vindicosuite.com"]},{name:"Viocorp International",category:"content",domains:["*.vioapi.com"]},{name:"ViralNinjas",category:"ad",domains:["*.viralninjas.com"]},{name:"Virool",category:"ad",domains:["*.virool.com"]},{name:"Virtual Earth",company:"Microsoft",category:"utility",domains:["*.virtualearth.net"],totalExecutionTime:54315,totalOccurrences:312},{name:"Visely",company:"Visely",category:"other",homepage:"https://visely.io/",domains:["*.visely.io"]},{name:"VisScore",category:"analytics",domains:["*.visscore.com","d2hkbi3gan6yg6.cloudfront.net"]},{name:"Visible Measures",category:"ad",domains:["*.visiblemeasures.com"],totalExecutionTime:11,totalOccurrences:13},{name:"Visual Studio",company:"Microsoft",category:"utility",
domains:["*.visualstudio.com"],totalExecutionTime:3464,totalOccurrences:3},{name:"VisualDNA",category:"ad",domains:["*.visualdna.com"]},{name:"VisualVisitor",category:"ad",domains:["*.id-visitors.com"],examples:["frontend.id-visitors.com"],totalExecutionTime:871,totalOccurrences:14},{name:"Vivocha S.p.A",category:"customer-success",domains:["*.vivocha.com"],totalExecutionTime:65471,totalOccurrences:38},{name:"Vizu (Nielsen)",category:"analytics",domains:["*.vizu.com"]},{name:"Vizury",category:"ad",domains:["*.vizury.com"],totalExecutionTime:1296,totalOccurrences:20},{name:"VoiceFive",category:"analytics",domains:["*.voicefive.com"]},{name:"Volvelle",company:"Optomaton",category:"ad",domains:["*.volvelle.tech"]},{name:"VouchedFor",category:"analytics",domains:["*.vouchedfor.co.uk"],totalExecutionTime:30557,totalOccurrences:18},{name:"WARPCACHE",category:"utility",domains:["*.warpcache.net"]},{name:"WISHLIST",company:"Shopapps",category:"social",domains:["*.shopapps.in"]},{name:"WP Engin\
e",category:"hosting",domains:["*.wpengine.com"],totalExecutionTime:651034,totalOccurrences:341},{name:"WalkMe",category:"customer-success",domains:["*.walkme.com"],totalExecutionTime:636459,totalOccurrences:495},{name:"Watching That",category:"other",domains:["*.watchingthat.com"]},{name:"Wayfair",category:"analytics",domains:["*.wayfair.com"],examples:["t.wayfair.com"]},{name:"Web CEO",category:"other",domains:["*.websiteceo.com"],examples:["www.websiteceo.com"]},{name:"Web Dissector",company:"Beijing Gridsum Technologies",category:"analytics",domains:["*.gridsumdissector.com","*.webdissector.com"],examples:["www.webdissector.com"]},{name:"Web Forensics",category:"analytics",domains:["*.webforensics.co.uk"]},{name:"Web Security and Performance",company:"NCC Group",category:"utility",domains:["*.nccgroup.trust"]},{name:"WebEngage",category:"customer-success",domains:["*.webengage.co","*.webengage.com","d23nd6ymopvz52.cloudfront.net","d3701cc9l7v9a6.cloudfront.net"],totalExecutionTime:789975,
totalOccurrences:2283},{name:"WebInsight",company:"dotMailer",category:"analytics",domains:["*.trackedlink.net","*.trackedweb.net"],totalExecutionTime:21241,totalOccurrences:277},{name:"WebPageOne Solutions",category:"other",domains:["*.webpageone.com"]},{name:"WebSpectator",category:"ad",domains:["*.webspectator.com"]},{name:"WebTuna",company:"Application Performance",category:"analytics",domains:["*.webtuna.com"]},{name:"WebVideoCore",company:"StreamingVideoProvider",category:"content",domains:["*.webvideocore.net"],totalExecutionTime:74152,totalOccurrences:38},{name:"WebWombat",category:"utility",domains:["*.ic.com.au"]},{name:"Webcollage",category:"customer-success",domains:["*.webcollage.net"]},{name:"Webcore",category:"ad",domains:["*.onefeed.co.uk"]},{name:"Webkul",company:"Webkul Software",category:"utility",domains:["*.webkul.com"],totalExecutionTime:172788,totalOccurrences:490},{name:"Webmarked",category:"utility",domains:["*.webmarked.net"],totalExecutionTime:72467,totalOccurrences:1077},
{name:"Weborama",category:"ad",domains:["*.weborama.com","*.weborama.fr"],totalExecutionTime:45883,totalOccurrences:372},{name:"WebpageFX",category:"ad",domains:["*.leadmanagerfx.com"],totalExecutionTime:241118,totalOccurrences:946},{name:"Webphone",company:"IP WEB SERVICES",category:"customer-success",domains:["*.webphone.net"],totalExecutionTime:4605,totalOccurrences:20},{name:"Webselect selectcommerce",company:"Webselect Internet",category:"hosting",domains:["*.webselect.net"]},{name:"Webthinking",category:"hosting",domains:["*.webthinking.co.uk"]},{name:"Webtrekk",category:"analytics",domains:["*.wbtrk.net","*.webtrekk-asia.net","*.webtrekk.net","*.wt-eu02.net","*.wt-safetag.com"],totalExecutionTime:85572,totalOccurrences:428},{name:"Webtrends",category:"analytics",domains:["*.webtrends.com","*.webtrendslive.com","d1q62gfb8siqnm.cloudfront.net"],totalExecutionTime:1437,totalOccurrences:6},{name:"Webtype",category:"cdn",domains:["*.webtype.com"],totalExecutionTime:0,totalOccurrences:1},
{name:"White Ops",category:"utility",domains:["*.acexedge.com","*.tagsrvcs.com"]},{name:"Whitespace",category:"ad",domains:["*.whitespacers.com"]},{name:"WhosOn Live Chat Software",category:"customer-success",domains:["*.whoson.com"],totalExecutionTime:20753,totalOccurrences:112},{name:"Wibbitz",category:"other",domains:["*.wibbitz.com"]},{name:"Wide Area Communications",category:"hosting",domains:["*.widearea.co.uk"]},{name:"WideOrbit",category:"marketing",domains:["*.admaym.com"]},{name:"William Reed",category:"content",domains:["*.wrbm.com"],totalExecutionTime:50,totalOccurrences:1},{name:"WillyFogg.com",category:"content",domains:["*.willyfogg.com"]},{name:"Windows",company:"Microsoft",category:"utility",domains:["*.windowsupdate.com"],examples:["ctldl.windowsupdate.com"]},{name:"WisePops",category:"utility",domains:["*.wisepops.com"],totalExecutionTime:2631328,totalOccurrences:1950},{name:"Wishlist King",company:"Appmate",category:"other",homepage:"https://appmate.io/",domains:["*\
.appmate.io"],examples:["api.appmate.io"],totalExecutionTime:130543,totalOccurrences:235},{name:"Wishpond Technologies",category:"marketing",domains:["*.wishpond.com","*.wishpond.net"],totalExecutionTime:771888,totalOccurrences:1691},{name:"WizRocket Technologies",category:"analytics",domains:["*.wzrkt.com"],totalExecutionTime:138,totalOccurrences:2},{name:"Woopra",category:"analytics",domains:["*.woopra.com"],totalExecutionTime:120767,totalOccurrences:1366},{name:"Woosmap",category:"utility",domains:["*.woosmap.com"],totalExecutionTime:58710,totalOccurrences:139},{name:"WorkCast",category:"hosting",domains:["*.workcast.net"]},{name:"World News Media",category:"content",domains:["*.wnmedia.co.uk"]},{name:"Worldpay",category:"utility",domains:["*.worldpay.com"],totalExecutionTime:25852,totalOccurrences:18},{name:"Wow Analytics",category:"analytics",domains:["*.wowanalytics.co.uk"],totalExecutionTime:11162,totalOccurrences:73},{name:"Wowcher",category:"ad",domains:["*.wowcher.co.uk"]},{name:"\
Wufoo",category:"utility",domains:["*.wufoo.com"],totalExecutionTime:381206,totalOccurrences:1507},{name:"Wunderkind",category:"marketing",homepage:"https://www.wunderkind.co/",domains:["*.bounceexchange.com","*.bouncex.net","*.wknd.ai","*.cdnbasket.net","*.cdnwidget.com"],examples:["events.bouncex.net","tag.wknd.ai","data.cdnbasket.net","pix.cdnwidget.com"],totalExecutionTime:2016506,totalOccurrences:1278},{name:"Wyng",category:"ad",domains:["*.offerpop.com"]},{name:"XMLSHOP",category:"hosting",domains:["*.xmlshop.biz"]},{name:"XiTi",company:"AT Internet",category:"analytics",domains:["*.xiti.com","*.aticdn.net"],homepage:"https://www.atinternet.com/en/",examples:["tag.aticdn.net/123456789/smarttag.js"],totalExecutionTime:918257,totalOccurrences:8483},{name:"YUDU",category:"content",domains:["*.yudu.com"]},{name:"Yahoo! Ad Exchange",company:"Yahoo!",category:"ad",domains:["*.yieldmanager.com","*.browsiprod.com"],examples:["yield-manager.browsiprod.com"],totalExecutionTime:12720569,totalOccurrences:4994},
{name:"Yahoo! JAPAN Ads",company:"Yahoo! JAPAN",category:"ad",homepage:"https://marketing.yahoo.co.jp/service/yahooads/",domains:["yads.c.yimg.jp","s.yimg.jp","b92.yahoo.co.jp"],examples:["yads.c.yimg.jp/js/yads-async.js","s.yimg.jp/images/listing/tool/yads/ydn/creative/video/ytop_video_timeline_sp.min.js","b92.yahoo.co.jp/js/s_retargeting.js"],totalExecutionTime:6236624,totalOccurrences:37464},{name:"Yahoo! Tag Manager",company:"Yahoo! JAPAN",category:"tag-manager",homepage:"https://marketing.yahoo.co.jp/service/tagmanager/",domains:["*.yjtag.jp"],examples:["s.yjtag.jp/tag.js"]},{name:"Yahoo! Small Business",company:"Yahoo!",category:"hosting",domains:["*.aabacosmallbusiness.com"]},{name:"Yellow Robot",category:"ad",domains:["*.backinstock.org"],totalExecutionTime:15268,totalOccurrences:508},{name:"YieldPartners",category:"ad",domains:["*.yieldpartners.com"]},{name:"Yieldbot",category:"ad",domains:["*.yldbt.com"]},{name:"Yieldify",category:"ad",domains:["*.yieldify.com","*.yieldifylab\
s.com","d33wq5gej88ld6.cloudfront.net","dwmvwp56lzq5t.cloudfront.net"],examples:["geo.yieldifylabs.com"],totalExecutionTime:513761,totalOccurrences:168},{name:"Yieldlab",category:"ad",domains:["*.yieldlab.net"],totalExecutionTime:54,totalOccurrences:8},{name:"Yieldmo",category:"ad",domains:["*.yieldmo.com"],totalExecutionTime:51128,totalOccurrences:2375},{name:"Yieldr",category:"ad",domains:["*.254a.com"]},{name:"Yo",category:"utility",domains:["*.yopify.com"]},{name:"YoYo",category:"utility",domains:["*.goadservices.com"]},{name:"Yotpo",homepage:"https://www.yotpo.com/",category:"marketing",domains:["*.yotpo.com","*.swellrewards.com"],totalExecutionTime:16919447,totalOccurrences:26094},{name:"Yottaa",category:"hosting",domains:["*.yottaa.com","*.yottaa.net"],totalExecutionTime:798791,totalOccurrences:753},{name:"YourAmigo",category:"utility",domains:["*.youramigo.com"]},{name:"YuMe",category:"ad",domains:["*.yume.com","*.yumenetworks.com"],examples:["cks.yumenetworks.com"]},{name:"Yum\
mley",category:"other",domains:["*.yummly.com"],totalExecutionTime:14163,totalOccurrences:6},{name:"ZEDO",category:"ad",domains:["*.zedo.com"]},{name:"Zafu",category:"analytics",domains:["*.zafu.com"]},{name:"Zaius",category:"ad",domains:["*.zaius.com"]},{name:"Zamplus ad",category:"ad",domains:["*.zampda.net"]},{name:"Zanox",category:"ad",domains:["*.zanox.com","*.zanox.ws"]},{name:"Zapper",category:"utility",domains:["*.zapper.com"]},{name:"Zarget",category:"analytics",domains:["*.zarget.com"]},{name:"Zemanta",category:"ad",domains:["*.zemanta.com"],totalExecutionTime:2735,totalOccurrences:28},{name:"Zen Internet",category:"other",domains:["*.zyen.com"]},{name:"Zenovia Digital Exchange",category:"ad",domains:["*.rhythmxchange.com","*.zenoviaexchange.com"]},{name:"ZergNet",category:"content",domains:["*.zergnet.com"],totalExecutionTime:186,totalOccurrences:4},{name:"Zerogrey",category:"hosting",domains:["*.zerogrey.com"]},{name:"Ziff Davis Tech",category:"ad",domains:["*.adziff.com","\
*.zdbb.net"],totalExecutionTime:30706,totalOccurrences:93},{name:"Zmags",category:"marketing",domains:["*.zmags.com"],totalExecutionTime:262514,totalOccurrences:119},{name:"Zolando",category:"content",domains:["*.ztat.net"],totalExecutionTime:229623,totalOccurrences:48},{name:"Zoover",category:"analytics",domains:["*.zoover.nl","*.zoover.co.uk"],totalExecutionTime:9173,totalOccurrences:2},{name:"Zopim",category:"customer-success",domains:["*.zopim.io"]},{name:"[24]7",category:"customer-success",domains:["*.247-inc.net","*.247inc.net","d1af033869koo7.cloudfront.net"],totalExecutionTime:24965,totalOccurrences:20},{name:"adKernel",category:"ad",domains:["*.adkernel.com"],totalExecutionTime:19140,totalOccurrences:9621},{name:"adMarketplace",company:"AMPexchange",category:"ad",domains:["*.ampxchange.com","*.admarketplace.net"]},{name:"addtocalendar",category:"utility",domains:["*.addtocalendar.com"]},{name:"adnanny",category:"ad",domains:["*.adserver01.de"],totalExecutionTime:2,totalOccurrences:6},
{name:"affilinet",category:"ad",domains:["*.reussissonsensemble.fr","*.successfultogether.co.uk"]},{name:"audioBoom",category:"social",domains:["*.audioboom.com","*.audioboo.fm"],totalExecutionTime:136729,totalOccurrences:57},{name:"bPay by Barclaycard",company:"Barclays Bank",category:"utility",domains:["*.bpay.co.uk"]},{name:"bRealTime",category:"ad",domains:["*.brealtime.com"],totalExecutionTime:4479,totalOccurrences:76},{name:"bd4travel",category:"analytics",domains:["*.bd4travel.com"]},{name:"bizinformation-VOID",company:"bizinformation",category:"analytics",domains:["*.bizinformation.org"]},{name:"carrot",category:"social",domains:["*.sharebutton.co"]},{name:"cloudIQ",category:"analytics",domains:["*.cloud-iq.com"]},{name:"comScore",category:"analytics",domains:["*.adxpose.com","*.comscore.com","*.sitestat.com","*.zqtk.net"],totalExecutionTime:4938,totalOccurrences:3},{name:"content.ad",category:"ad",domains:["*.content.ad"]},{name:"d3 Media",company:"d3 Technologies",category:"o\
ther",domains:["*.d3sv.net"]},{name:"dexiMEDIA",category:"ad",domains:["*.deximedia.com"]},{name:"dianomi",category:"ad",domains:["*.dianomi.com","*.dianomioffers.co.uk"],totalExecutionTime:52461,totalOccurrences:86},{name:"donReach",category:"social",domains:["*.donreach.com"]},{name:"dotMailer",category:"ad",domains:["*.dmtrk.com","*.dotmailer.com","*.emlfiles.com"]},{name:"dotMailer Surveys",company:"dotMailer",category:"analytics",domains:["*.dotmailer-surveys.com"]},{name:"dstillery",category:"ad",domains:["*.dstillery.com","*.media6degrees.com"],totalExecutionTime:1160,totalOccurrences:12},{name:"eBay",category:"ad",domains:["*.ebay.com","*.ebayimg.com","*.fetchback.com"],totalExecutionTime:600826,totalOccurrences:1026},{name:"eBay Enterprise",category:"hosting",domains:["*.csdata1.com","*.gsipartners.com"]},{name:"eBuzzing",company:"Teads Managed Services",category:"ad",domains:["*.ebz.io"]},{name:"eDigital Research",category:"customer-success",domains:["*.edigitalresearch.com",
"*.edigitalsurvey.com","*.edrcdn.com","*.ecustomeropinions.com"]},{name:"eGain",category:"analytics",domains:["*.analytics-egain.com","*.egain.com"],totalExecutionTime:8418,totalOccurrences:74},{name:"eHost",category:"hosting",domains:["*.ehosts.net"]},{name:"eKomi",category:"analytics",domains:["*.ekomi.com","*.ekomi.de"],totalExecutionTime:51192,totalOccurrences:17},{name:"eWAY",company:"Web Active Pty",category:"utility",domains:["*.eway.com.au"],examples:["www.eway.com.au"],totalExecutionTime:11094,totalOccurrences:1},{name:"eXTReMe digital",category:"analytics",domains:["*.extreme-dm.com"],totalExecutionTime:3491,totalOccurrences:78},{name:"eXelate",category:"ad",domains:["*.exelator.com"],totalExecutionTime:17905,totalOccurrences:246},{name:"ecommercefeed.net",category:"marketing",domains:["*.ecommercefeed.net"]},{name:"engage:BDR",category:"ad",domains:["*.bnmla.com","*.ebdr3.com"]},{name:"epago",category:"ad",domains:["*.adaos-ads.net"]},{name:"epoq internet services",category:"\
analytics",domains:["*.epoq.de"],totalExecutionTime:84260,totalOccurrences:122},{name:"etouches",category:"hosting",domains:["*.etouches.com"],examples:["www.etouches.com"]},{name:"etracker",category:"analytics",domains:["*.etracker.com","*.etracker.de"],examples:["www.etracker.com"],totalExecutionTime:2076262,totalOccurrences:5626},{name:"everestads.com",category:"content",domains:["*.verestads.net"]},{name:"exebid.DCA",company:"Data-Centric Alliance",category:"ad",domains:["*.exe.bid"]},{name:"eyeReturn Marketing",category:"marketing",domains:["*.eyereturn.com"]},{name:"feedoptimise",category:"hosting",domains:["*.feedoptimise.com","d1w78njrm56n7g.cloudfront.net"],totalExecutionTime:126,totalOccurrences:2},{name:"fifty-five",category:"ad",domains:["*.55labs.com"]},{name:"fluct",category:"ad",domains:["*.adingo.jp"],totalExecutionTime:5114249,totalOccurrences:12890},{name:"freegeoip.net",company:"(community-funded)",category:"utility",domains:["*.freegeoip.net"]},{name:"freewheel.tv",
category:"content",domains:["*.fwmrm.net"],totalExecutionTime:3847,totalOccurrences:42},{name:"gnatta",category:"customer-success",domains:["*.gnatta.com"]},{name:"home.pl",category:"hosting",domains:["*.nscontext.eu"]},{name:"hyfn",category:"ad",domains:["*.hyfn.com"]},{name:"iAdvize SAS",category:"customer-success",domains:["*.iadvize.com"],totalExecutionTime:286995,totalOccurrences:844},{name:"iBillboard",category:"ad",domains:["*.ibillboard.com"],totalExecutionTime:303,totalOccurrences:2},{name:"iCrossing",category:"ad",domains:["*.ic-live.com"]},{name:"iFactory",company:"RDW Group",category:"hosting",domains:["*.ifactory.com"]},{name:"iGoDigital",category:"analytics",domains:["*.igodigital.com"],totalExecutionTime:1800,totalOccurrences:21},{name:"iJento",company:"Fopsha",category:"ad",domains:["*.ijento.com"]},{name:"iPage",category:"hosting",domains:["*.ipage.com"],examples:["www.ipage.com"],totalExecutionTime:490,totalOccurrences:6},{name:"iPerceptions",category:"customer-succes\
s",domains:["*.iperceptions.com"],totalExecutionTime:626044,totalOccurrences:4662},{name:"iTunes",company:"Apple",category:"content",domains:["*.mzstatic.com"]},{name:"imgix",company:"Zebrafish Labs",category:"utility",domains:["*.imgix.net"],totalExecutionTime:40073,totalOccurrences:98},{name:"infogr.am",category:"utility",domains:["*.infogr.am","*.jifo.co"],totalExecutionTime:2008949,totalOccurrences:233},{name:"iotec",category:"analytics",domains:["*.dsp.io"]},{name:"iovation",category:"utility",domains:["*.iesnare.com"],totalExecutionTime:270232,totalOccurrences:2159},{name:"ipinfo.io",category:"utility",domains:["*.ipinfo.io"]},{name:"issuu",category:"content",domains:["*.issuu.com","*.isu.pub"],totalExecutionTime:5607951,totalOccurrences:2714},{name:"iubenda",category:"utility",domains:["*.iubenda.com"],examples:["www.iubenda.com"],totalExecutionTime:69911073,totalOccurrences:97074},{name:"j2 Cloud Services",category:"ad",domains:["*.campaigner.com"],totalExecutionTime:12708,totalOccurrences:28},
{name:"jsonip.com",category:"analytics",domains:["*.jsonip.com"]},{name:"linkpulse",category:"analytics",domains:["*.lp4.io"]},{name:"loGo_net",category:"analytics",domains:["*.logo-net.co.uk"]},{name:"mainADV",category:"ad",domains:["*.httptrack.com","*.solocpm.com"]},{name:"mbr targeting",category:"ad",domains:["*.m6r.eu"],totalExecutionTime:17,totalOccurrences:1},{name:"media.ventive",category:"ad",domains:["*.contentspread.net"]},{name:"metrigo",category:"ad",domains:["*.metrigo.com"]},{name:"minicabit.com",category:"content",domains:["*.minicabit.com"]},{name:"mobiManage",category:"hosting",domains:["*.mobimanage.com"]},{name:"moving-pictures",category:"other",domains:["*.moving-pictures.biz","*.v6-moving-pictures.com","*.vtstat.com","*.moving-pictures.de"]},{name:"my6sense",category:"ad",domains:["*.mynativeplatform.com"]},{name:"myThings",category:"ad",domains:["*.mythings.com","*.mythingsmedia.net"]},{name:"mymovies",category:"content",domains:["*.mymovies.net"]},{name:"nRelate\
-VOID",company:"nRelate",category:"content",domains:["*.nrelate.com"]},{name:"nToklo",category:"analytics",domains:["*.ntoklo.com"]},{name:"neXeps",category:"ad",domains:["*.nexeps.com"]},{name:"ninemsn Pty.",category:"utility",domains:["*.ninemsn.com.au"]},{name:"nugg.ad",category:"ad",domains:["*.nuggad.net"]},{name:"numero interactive",company:"numero",category:"ad",domains:["*.numerointeractive.com"]},{name:"optMD",company:"Optimax Media Delivery",category:"ad",domains:["*.optmd.com"]},{name:"otracking.com",category:"analytics",domains:["*.otracking.com"]},{name:"paysafecard",company:"Paysafe Group",category:"utility",domains:["*.paysafecard.com"]},{name:"piano",category:"ad",domains:["*.npttech.com","*.tinypass.com"],examples:["www.npttech.com"],totalExecutionTime:1016108,totalOccurrences:1146},{name:"piclike",category:"ad",domains:["*.piclike.us"]},{name:"placehold.it",category:"utility",domains:["*.placehold.it"]},{name:"plista",category:"ad",domains:["*.plista.com"]},{name:"pre\
bid.org",category:"utility",domains:["*.prebid.org"],totalExecutionTime:462,totalOccurrences:1},{name:"reEmbed",category:"other",domains:["*.reembed.com"]},{name:"reddit",category:"social",domains:["*.reddit.com","*.redditstatic.com"],examples:["www.redditstatic.com"],totalExecutionTime:4113522,totalOccurrences:18483},{name:"rewardStyle.com",category:"ad",domains:["*.rewardstyle.com"],totalExecutionTime:280999,totalOccurrences:1491},{name:"rss2json",category:"utility",domains:["*.rss2json.com"],totalExecutionTime:1380,totalOccurrences:18},{name:"sage Pay",company:"Sage Pay Europe",category:"utility",domains:["*.sagepay.com"],totalExecutionTime:4481,totalOccurrences:40},{name:"section.io",category:"utility",domains:["*.squixa.net"],examples:["beacon.squixa.net","s.squixa.net"]},{name:"smartclip",category:"ad",domains:["*.smartclip.net"],totalExecutionTime:41051,totalOccurrences:21},{name:"sovrn",category:"ad",domains:["*.lijit.com"],totalExecutionTime:2389059,totalOccurrences:27306},{name:"\
stackpile.io",company:"StackPile",category:"tag-manager",domains:["*.stackpile.io"]},{name:"template-help.com",category:"hosting",domains:["*.template-help.com"],totalExecutionTime:16016,totalOccurrences:13},{name:"test",company:"test only",category:"other",domains:["*.testtesttest.com"]},{name:"trueAnthem",category:"social",domains:["*.tru.am"]},{name:"tweetmeme-VOID",company:"tweetmeme",category:"analytics",domains:["*.tweetmeme.com"]},{name:"uLogin",category:"other",domains:["*.ulogin.ru"]},{name:"uLogix",category:"ad",domains:["*.ulogix.ru"]},{name:"ucfunnel ucX",company:"ucfunnel",category:"ad",domains:["*.aralego.com"],totalExecutionTime:1469345,totalOccurrences:7945},{name:"up-value",category:"ad",domains:["*.up-value.de"]},{name:"wywy",category:"ad",domains:["*.wywy.com","*.wywyuserservice.com"]},{name:"CDK Dealer Management",company:"CDK Global",homepage:"https://www.cdkglobal.com/us",category:"hosting",domains:["*.assets-cdk.com"],examples:["media-cf.assets-cdk.com"],totalExecutionTime:1052,
totalOccurrences:4},{name:"fam",company:"Fing Co Ltd.",homepage:"http://admin.fam-ad.com/report/",category:"ad",domains:["*.fam-ad.com"],examples:["img.fam-ad.com"],totalExecutionTime:1816,totalOccurrences:10},{name:"zypmedia",category:"ad",domains:["*.extend.tv"]},{name:"codigo",homepage:"https://www.codigo.se",category:"analytics",domains:["*.codigo.se"],examples:["analytics.codigo.se"],totalExecutionTime:469,totalOccurrences:10},{name:"Playground",homepage:"https://playground.xyz",category:"ad",domains:["*.playground.xyz"],examples:["ads.playground.xyz"],totalExecutionTime:2767,totalOccurrences:26},{name:"RAM",homepage:"https://www2.rampanel.com/",category:"analytics",domains:["*.rampanel.com"],examples:["inviso.rampanel.com"],totalExecutionTime:15413,totalOccurrences:1},{name:"Adition",homepage:"https://www.adition.com",category:"ad",domains:["*.adition.com"],examples:["dsp.adfarm1.adition.com"],totalExecutionTime:74399,totalOccurrences:491},{name:"Widespace",homepage:"https://www.\
widespace.com",category:"ad",domains:["*.widespace.com"],examples:["sync.widespace.com"]},{name:"Colpirio",homepage:"https://www.widespace.com",category:"analytics",domains:["*.colpirio.com"],examples:["proxy-tracker.colpirio.com"]},{name:"Brandmetrics",homepage:"https://www.brandmetrics.com",category:"analytics",domains:["*.brandmetrics.com"],examples:["collector.brandmetrics.com","cdn.brandmetrics.com"],totalExecutionTime:3689914,totalOccurrences:30850},{name:"EasyAd",homepage:"https://web.easy-ads.com/",category:"ad",domains:["*.easy-ads.com"],examples:["ads.easy-ads.com"]},{name:"Glimr",homepage:"https://glimr.io/",category:"analytics",domains:["*.glimr.io"],examples:["pixel.glimr.io"]},{name:"Webtreck",homepage:"https://www.webtrekk.com/en/home/",category:"analytics",domains:["*.wcfbc.net"],examples:["fbc.wcfbc.net"]},{name:"DigiTrust",homepage:"http://www.digitru.st/",category:"analytics",domains:["*.digitru.st"],examples:["cdn.digitru.st"]},{name:"Kantar Sifo",homepage:"https://\
www.kantarsifo.se",category:"analytics",domains:["*.research-int.se"],examples:["trafficgateway.research-int.se"],totalExecutionTime:375,totalOccurrences:1},{name:"Concert",homepage:"https://concert.io/",category:"ad",domains:["*.concert.io"],examples:["cdn.concert.io"],totalExecutionTime:317481,totalOccurrences:336},{name:"Emerse",homepage:"https://www.emerse.com/",category:"ad",domains:["*.emerse.com"],examples:["tracking.emerse.com"],totalExecutionTime:2872,totalOccurrences:13},{name:"Iterate",homepage:"https://iteratehq.com/",category:"analytics",domains:["*.iteratehq.com"],totalExecutionTime:8751,totalOccurrences:72},{name:"Cookiebot",homepage:"https://www.cookiebot.com/",category:"utility",domains:["*.cookiebot.com"],examples:["consent.cookiebot.com"],totalExecutionTime:64865019,totalOccurrences:187732},{name:"Netlify",homepage:"https://www.netlify.com/",category:"utility",domains:["*.netlify.com","*.netlifyusercontent.com"],examples:["cloud.netlifyusercontent.com"],totalExecutionTime:299527,
totalOccurrences:1323},{name:"Scroll",homepage:"https://scroll.com/",category:"utility",domains:["*.scroll.com"],examples:["static.scroll.com","connect.scroll.com"]},{name:"Consumable",homepage:"https://consumable.com/",category:"ad",domains:["*.serverbid.com"],totalExecutionTime:15203,totalOccurrences:266},{name:"DMD Marketing",homepage:"https://www.dmdconnects.com/",category:"ad",domains:["*.medtargetsystem.com"],totalExecutionTime:257224,totalOccurrences:846},{name:"Catchpoint",homepage:"https://www.catchpoint.com/",category:"analytics",domains:["*.3gl.net","*.3genlabs.net"],totalExecutionTime:14822,totalOccurrences:160},{name:"Terminus",homepage:"https://terminus.com/",category:"ad",domains:["*.terminus.services"],totalExecutionTime:28077,totalOccurrences:207},{name:"Acceptable Ads",homepage:"https://acceptableads.com/",category:"ad",domains:["*.aaxads.com","*.aaxdetect.com"],totalExecutionTime:2200,totalOccurrences:34},{name:"ClearBrain",homepage:"https://www.clearbrain.com/",category:"\
analytics",domains:["*.clearbrain.com"],examples:["api.clearbrain.com"]},{name:"Optanon",homepage:"https://www.cookielaw.org/",category:"consent-provider",domains:["*.onetrust.com","*.cookielaw.org"],examples:["cdn.cookielaw.org","geolocation.onetrust.com"],totalExecutionTime:55293468,totalOccurrences:113700},{name:"TrustArc",homepage:"https://www.trustarc.com/",category:"utility",domains:["*.trustarc.com"],examples:["choices.trustarc.com","consent.trustarc.com"],totalExecutionTime:2429376,totalOccurrences:5941},{name:"iSpot.tv",homepage:"https://www.ispot.tv/",category:"ad",domains:["*.ispot.tv"],examples:["pt.ispot.tv"],totalExecutionTime:2947,totalOccurrences:10},{name:"RevJet",homepage:"https://www.revjet.com/",category:"ad",domains:["*.revjet.com"],examples:["pix.revjet.com","ads.revjet.com"],totalExecutionTime:54608,totalOccurrences:36},{name:"atlasRTX",homepage:"https://www.atlasrtx.com/",category:"customer-success",domains:["*.atlasrtx.com"],examples:["app.atlasrtx.com","cdn.at\
lasrtx.com","dev.atlasrtx.com"],totalExecutionTime:52386,totalOccurrences:46},{name:"ContactAtOnce",homepage:"https://www.contactatonce.com/",category:"customer-success",domains:["*.contactatonce.com"],examples:["tag.contactatonce.com","agentpresence.contactatonce.com"]},{name:"Algolia",homepage:"https://www.algolia.com/",category:"utility",domains:["*.algolianet.com","*.algolia.net","*.algolia.io"],totalExecutionTime:5603,totalOccurrences:20},{name:"EMX Digital",homepage:"https://emxdigital.com",category:"ad",domains:["*.emxdgt.com"],totalExecutionTime:9160,totalOccurrences:166},{name:"Moxie",homepage:"https://www.gomoxie.com/",category:"utility",domains:["*.gomoxie.solutions"],totalExecutionTime:24183,totalOccurrences:28},{name:"Scripps Network Digital",homepage:"https://www.scrippsnetworksdigital.com/",category:"ad",domains:["*.snidigital.com"]},{name:"TurnTo",homepage:"https://www.turntonetworks.com/",category:"utility",domains:["*.turnto.com"],totalExecutionTime:4666,totalOccurrences:32},
{name:"Quantum Metric",homepage:"https://www.quantummetric.com/",category:"analytics",domains:["*.quantummetric.com"],totalExecutionTime:1699724,totalOccurrences:1140},{name:"Carbon Ads",homepage:"https://www.carbonads.net/",category:"ad",domains:["*.carbonads.net","*.carbonads.com"],totalExecutionTime:12059,totalOccurrences:224},{name:"Ably",homepage:"https://www.ably.io/",category:"utility",domains:["*.ably.io"],totalExecutionTime:17031,totalOccurrences:125},{name:"Sectigo",homepage:"https://sectigo.com/",category:"utility",domains:["*.sectigo.com"],totalExecutionTime:4576,totalOccurrences:3},{name:"Specless",homepage:"https://gospecless.com/",category:"ad",domains:["*.specless.tech"]},{name:"Loggly",homepage:"https://www.loggly.com/",category:"analytics",domains:["*.loggly.com","d9jmv9u00p0mv.cloudfront.net"],examples:["logs-01.loggly.com"],totalExecutionTime:943,totalOccurrences:5},{name:"Intent Media",homepage:"https://intent.com/",category:"ad",domains:["*.intentmedia.net"]},{name:"\
Supership",homepage:"https://supership.jp/",category:"ad",domains:["*.socdm.com"],totalExecutionTime:10809246,totalOccurrences:17934},{name:"F@N Communications",homepage:"https://www.fancs.com/",category:"ad",domains:["*.ladsp.com"],examples:["px.ladsp.com"],totalExecutionTime:258835,totalOccurrences:1768},{name:"Vidyard",homepage:"https://www.vidyard.com/",category:"utility",domains:["*.vidyard.com"],totalExecutionTime:1165600,totalOccurrences:1097},{name:"RapidSSL",homepage:"https://www.rapidssl.com/",category:"utility",domains:["*.rapidssl.com"],totalExecutionTime:845,totalOccurrences:2},{name:"Coherent Path",homepage:"https://coherentpath.com/",category:"utility",domains:["*.coherentpath.com"]},{name:"Attentive",homepage:"https://attentivemobile.com/",category:"ad",domains:["*.attn.tv","*.attentivemobile.com"],totalExecutionTime:5554871,totalOccurrences:9099},{name:"emetriq",homepage:"https://www.emetriq.com/",category:"ad",domains:["*.emetriq.de","*.xplosion.de"],totalExecutionTime:1917,
totalOccurrences:24},{name:"Bonzai",homepage:"https://www.bonzai.co/",category:"ad",domains:["*.bonzai.co"]},{name:"Freshchat",homepage:"https://www.freshworks.com/live-chat-software/",category:"customer-success",domains:["*.freshchat.com","*.freshworksapi.com"],products:[{name:"Freshdesk Messaging",urlPatterns:["wchat.freshchat.com"],facades:[{name:"Freshdesk Messaging (formerly Freshchat) Facade",repo:"https://github.com/coliff/freshdesk-messaging-facade/"}]}],totalExecutionTime:23350324,totalOccurrences:7081},{name:"Contentful",homepage:"https://www.contentful.com/",category:"utility",domains:["*.contentful.com"],examples:["cdn.contentful.com"],totalExecutionTime:4826,totalOccurrences:2},{name:"PureCars",homepage:"https://www.purecars.com/",category:"marketing",domains:["*.purecars.com"],examples:["cdn.purecars.com"],totalExecutionTime:969442,totalOccurrences:1292},{name:"Tray Commerce",homepage:"https://www.tray.com.br/",category:"marketing",domains:["*.tcdn.com.br"],examples:["ima\
ges.tcdn.com.br"],totalExecutionTime:68362173,totalOccurrences:14071},{name:"AdScore",homepage:"https://www.adscore.com/",category:"ad",domains:["*.adsco.re"],examples:["c.adsco.re"],totalExecutionTime:2812771,totalOccurrences:4394},{name:"WebsiteBuilder.com",homepage:"https://www.websitebuilder.com",category:"hosting",domains:["*.mywebsitebuilder.com"],totalExecutionTime:19568135,totalOccurrences:4688},{name:"mParticle",homepage:"https://www.mparticle.com/",category:"utility",domains:["*.mparticle.com"],examples:["jssdks.mparticle.com","identity.mparticle.com"],totalExecutionTime:403503,totalOccurrences:1029},{name:"Ada",homepage:"https://www.ada.support/",category:"customer-success",domains:["*.ada.support"],examples:["static.ada.support"],totalExecutionTime:695777,totalOccurrences:985},{name:"Quora Ads",homepage:"https://www.quora.com/business/",category:"ad",domains:["*.quora.com"],examples:["q.quora.com"],totalExecutionTime:1338719,totalOccurrences:10614},{name:"Auth0",homepage:"h\
ttps://auth0.com/",category:"utility",domains:["*.auth0.com"],examples:["cdn.auth0.com"],totalExecutionTime:245638,totalOccurrences:816},{name:"Bridgewell DSP",homepage:"https://www.bridgewell.com/",category:"ad",domains:["*.scupio.com"],examples:["img.scupio.com"],totalExecutionTime:63728,totalOccurrences:354},{name:"Wicked Reports",homepage:"https://www.wickedreports.com/",category:"marketing",domains:["*.wickedreports.com"],examples:["widget.wickedreports.com"],totalExecutionTime:148754,totalOccurrences:483},{name:"Jaywing",homepage:"https://jaywing.com/",category:"marketing",domains:["*.jaywing.com"],examples:["amazon.almanac.jaywing.com"]},{name:"Holimetrix",homepage:"https://u360.d-bi.fr/",category:"marketing",domains:["*.d-bi.fr"],examples:["u360.d-bi.fr"]},{name:"iZooto",homepage:"https://www.izooto.com",category:"marketing",domains:["*.izooto.com"],examples:["cdn.izooto.com"],totalExecutionTime:1111125,totalOccurrences:2022},{name:"Ordergroove",homepage:"https://www.ordergroov\
e.com/",category:"marketing",domains:["*.ordergroove.com"],examples:["static.ordergroove.com"],totalExecutionTime:99990,totalOccurrences:274},{name:"PageSense",homepage:"https://www.zoho.com/pagesense/",category:"analytics",domains:["*.pagesense.io"],examples:["cdn.pagesense.io"],totalExecutionTime:1996537,totalOccurrences:6219},{name:"Vizzit",homepage:"https://www.vizzit.se",category:"analytics",domains:["*.vizzit.se"],examples:["www.vizzit.se","tag.vizzit.se"],totalExecutionTime:739,totalOccurrences:7},{name:"Click Guardian",homepage:"https://www.clickguardian.co.uk/",category:"ad",domains:["*.clickguardian.app","*.clickguardian.co.uk"],examples:["v2.clickguardian.app","protection.clickguardian.co.uk"],totalExecutionTime:202620,totalOccurrences:1101},{name:"Smartsupp",company:"Smartsupp.com",homepage:"https://www.smartsupp.com",category:"customer-success",domains:["*.smartsuppchat.com","*.smartsupp.com","smartsupp-widget-161959.c.cdn77.org","*.smartsuppcdn.com"],examples:["widget-v1.\
smartsuppcdn.com"],totalExecutionTime:9998165,totalOccurrences:21505},{name:"Smartlook",company:"Smartsupp.com",homepage:"https://www.smartlook.com/",category:"analytics",domains:["*.smartlook.com"],totalExecutionTime:1386251,totalOccurrences:16221},{name:"Luigis Box",company:"Luigis Box",homepage:"https://www.luigisbox.com/",category:"utility",domains:["*.luigisbox.com"],totalExecutionTime:2975273,totalOccurrences:2356},{name:"Targito",company:"VIVmail.cz",homepage:"https://www.targito.com",category:"marketing",domains:["*.targito.com"],totalExecutionTime:3145,totalOccurrences:29},{name:"Foxentry",company:"AVANTRO",homepage:"https://foxentry.cz/",category:"utility",domains:["*.foxentry.cz"],totalExecutionTime:758854,totalOccurrences:2313},{name:"Pendo",homepage:"https://www.pendo.io",category:"analytics",domains:["*.pendo.io"],examples:["app.pendo.io"],totalExecutionTime:4935190,totalOccurrences:12203},{name:"Braze",homepage:"https://www.braze.com",category:"analytics",domains:["*.app\
boycdn.com"],examples:["js.appboycdn.com"],totalExecutionTime:399216,totalOccurrences:2014},{name:"Usersnap",homepage:"https://usersnap.com",category:"customer-success",domains:["*.usersnap.com"],examples:["api.usersnap.com","cdn.usersnap.com"],totalExecutionTime:334324,totalOccurrences:437},{name:"Rewardful",homepage:"https://www.getrewardful.com",category:"analytics",domains:["*.wdfl.co"],examples:["r.wdfl.co"],totalExecutionTime:9094,totalOccurrences:161},{name:"Launch Darkly",homepage:"https://launchdarkly.com",category:"utility",domains:["*.launchdarkly.com"],examples:["app.launchdarkly.com","events.launchdarkly.com"],totalExecutionTime:10547,totalOccurrences:6},{name:"Statuspage",company:"Atlassian",homepage:"https://www.statuspage.io",category:"utility",domains:["*.statuspage.io"],examples:["1k6wzpspjf99.statuspage.io"],totalExecutionTime:43124,totalOccurrences:1212},{name:"HyperInzerce",homepage:"https://hyperinzerce.cz",category:"ad",domains:["*.hyperinzerce.cz"],examples:["mo\
torky.hyperinzerce.cz"],totalExecutionTime:1035,totalOccurrences:39},{name:"POWr",homepage:"https://www.powr.io",category:"utility",domains:["*.powr.io"],examples:["www.powr.io"],totalExecutionTime:191534674,totalOccurrences:39716},{name:"Coral",company:"Coral",homepage:"https://coralproject.net",category:"content",domains:["*.coral.coralproject.net"],examples:["company.coral.coralproject.net"],totalExecutionTime:61135,totalOccurrences:250},{name:"Bolt",homepage:"https://www.bolt.com/",category:"utility",domains:["*.bolt.com"],examples:["connect.bolt.com"],totalExecutionTime:513689,totalOccurrences:217},{name:"Judge.me",homepage:"https://judge.me/",category:"marketing",domains:["*.judge.me"],examples:["cdn.judge.me"],totalExecutionTime:31886982,totalOccurrences:27483},{name:"Tilda",homepage:"https://tilda.cc/",category:"hosting",domains:["*.tildacdn.com"],examples:["stat.tildacdn.com","static.tildacdn.com","upwidget.tildacdn.com"],totalExecutionTime:94734169,totalOccurrences:70321},{name:"\
SalesLoft",homepage:"https://salesloft.com/",category:"marketing",domains:["*.salesloft.com"],examples:["scout-cdn.salesloft.com"],totalExecutionTime:42987,totalOccurrences:705},{name:"Accessibe Accessibility Overlay",company:"Accessibe",homepage:"https://accessibe.com/",category:"utility",domains:["*.accessibe.com","*.acsbapp.com","*.acsbap.com"],examples:["accessibe.com","acsbapp.com"],totalExecutionTime:285765,totalOccurrences:808},{name:"Builder",homepage:"https://www.builder.io/",category:"hosting",domains:["*.builder.io"],examples:["cdn.builder.io"],totalExecutionTime:412358,totalOccurrences:261},{name:"Pepperjam",homepage:"https://www.pepperjam.com/",category:"marketing",domains:["*.pepperjam.com","*.affiliatetechnology.com"],examples:["container.pepperjam.com"],totalExecutionTime:2308,totalOccurrences:35},{name:"Reach",homepage:"https://withreach.com/",category:"utility",domains:["*.gointerpay.net"],examples:["checkout.gointerpay.net"]},{name:"Chameleon",homepage:"https://www.t\
rychameleon.com/",category:"marketing",domains:["*.trychameleon.com"],examples:["fast.trychameleon.com"],totalExecutionTime:24218,totalOccurrences:8},{name:"Matomo",company:"InnoCraft",homepage:"https://matomo.org/",category:"analytics",domains:["*.matomo.cloud"],totalExecutionTime:3115176,totalOccurrences:14345},{name:"Segmanta",homepage:"https://segmanta.com/",category:"marketing",domains:["*.segmanta.com"],examples:["clientName.segmanta.com"]},{name:"Podsights",homepage:"https://podsights.com/",category:"marketing",domains:["*.pdst.fm","us-central1-adaptive-growth.cloudfunctions.net"],examples:["cdn.pdst.fm","sink.pdst.fm"],totalExecutionTime:71990,totalOccurrences:1140},{name:"Chatwoot",homepage:"https://www.chatwoot.com/",category:"customer-success",domains:["*.chatwoot.com"],examples:["cdn.chatwoot.com","app.chatwoot.com"],totalExecutionTime:31973,totalOccurrences:444},{name:"Crisp",homepage:"https://crisp.chat/",category:"customer-success",domains:["*.crisp.chat"],examples:["cli\
ent.crisp.chat","client.relay.crisp.chat"],totalExecutionTime:33757,totalOccurrences:1052},{name:"Admiral CMP",homepage:"https://www.getadmiral.com",category:"consent-provider",domains:["admiral.mgr.consensu.org","*.admiral.mgr.consensu.org"]},{name:"Adnuntius CMP",homepage:"https://adnuntius.com",category:"consent-provider",domains:["adnuntiusconsent.mgr.consensu.org","*.adnuntiusconsent.mgr.consensu.org"]},{name:"Clickio CMP",homepage:"https://clickio.com",category:"consent-provider",domains:["clickio.mgr.consensu.org","*.clickio.mgr.consensu.org"]},{name:"AppConsent CMP",homepage:"https://appconsent.io/en",category:"consent-provider",domains:["appconsent.mgr.consensu.org","*.appconsent.mgr.consensu.org"]},{name:"DMG Media CMP",homepage:"https://www.dmgmedia.co.uk",category:"consent-provider",domains:["dmgmedia.mgr.consensu.org","*.dmgmedia.mgr.consensu.org"]},{name:"Axel Springer CMP",homepage:"https://www.axelspringer.com",category:"consent-provider",domains:["axelspringer.mgr.cons\
ensu.org","*.axelspringer.mgr.consensu.org"]},{name:"Bedrock CMP",homepage:"https://www.bedrockstreaming.com",category:"consent-provider",domains:["bedrock.mgr.consensu.org","*.bedrock.mgr.consensu.org"]},{name:"BMIND CMP",homepage:"https://www.bmind.es",category:"consent-provider",domains:["bmind.mgr.consensu.org","*.bmind.mgr.consensu.org"]},{name:"Borlabs CMP",homepage:"https://borlabs.io",category:"consent-provider",domains:["borlabs.mgr.consensu.org","*.borlabs.mgr.consensu.org"]},{name:"Civic CMP",homepage:"https://www.civicuk.com",category:"consent-provider",domains:["cookiecontrol.mgr.consensu.org","*.cookiecontrol.mgr.consensu.org"]},{name:"Commanders Act CMP",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["commandersact.mgr.consensu.org","*.commandersact.mgr.consensu.org"]},{name:"Complianz CMP",homepage:"https://complianz.io/",category:"consent-provider",domains:["complianz.mgr.consensu.org","*.complianz.mgr.consensu.org"]},{name:"Consent Desk \
CMP",homepage:"https://www.consentdesk.com/",category:"consent-provider",domains:["consentdesk.mgr.consensu.org","*.consentdesk.mgr.consensu.org"]},{name:"Consent Manager CMP",homepage:"https://consentmanager.net",category:"consent-provider",domains:["consentmanager.mgr.consensu.org","*.consentmanager.mgr.consensu.org"]},{name:"Conversant CMP",homepage:"https://www.conversantmedia.eu/",category:"consent-provider",domains:["conversant.mgr.consensu.org","*.conversant.mgr.consensu.org"]},{name:"Cookie Information CMP",homepage:"https://www.cookieinformation.com/",category:"consent-provider",domains:["cookieinformation.mgr.consensu.org","*.cookieinformation.mgr.consensu.org"]},{name:"Cookiebot CMP",homepage:"https://www.cookiebot.com",category:"consent-provider",domains:["cookiebot.mgr.consensu.org","*.cookiebot.mgr.consensu.org"]},{name:"Truendo CMP",homepage:"https://truendo.com/",category:"consent-provider",domains:["truendo.mgr.consensu.org","*.truendo.mgr.consensu.org"]},{name:"Dentsu\
 CMP",homepage:"https://www.dentsuaegisnetwork.de/",category:"consent-provider",domains:["dan.mgr.consensu.org","*.dan.mgr.consensu.org"]},{name:"Didomi CMP",homepage:"https://www.didomi.io/en/",category:"consent-provider",domains:["didomi.mgr.consensu.org","*.didomi.mgr.consensu.org"]},{name:"Ensighten CMP",homepage:"https://www.ensighten.com/",category:"consent-provider",domains:["ensighten.mgr.consensu.org","*.ensighten.mgr.consensu.org"]},{name:"Evidon CMP",homepage:"https://evidon.com",category:"consent-provider",domains:["evidon.mgr.consensu.org","*.evidon.mgr.consensu.org"]},{name:"Ezoic CMP",homepage:"https://www.ezoic.com/",category:"consent-provider",domains:["ezoic.mgr.consensu.org","*.ezoic.mgr.consensu.org"]},{name:"Gemius CMP",homepage:"https://www.gemius.com",category:"consent-provider",domains:["gemius.mgr.consensu.org","*.gemius.mgr.consensu.org"]},{name:"NitroPay CMP",homepage:"https://nitropay.com/",category:"consent-provider",domains:["nitropay.mgr.consensu.org","*.\
nitropay.mgr.consensu.org"]},{name:"Google FundingChoices",homepage:"https://fundingchoices.google.com/start/",category:"consent-provider",domains:["fundingchoices.mgr.consensu.org","*.fundingchoices.mgr.consensu.org","fundingchoicesmessages.google.com","*.fundingchoicesmessages.google.com"],totalExecutionTime:257806056,totalOccurrences:400016},{name:"Gravito CMP",homepage:"https://www.gravito.net/",category:"consent-provider",domains:["gravito.mgr.consensu.org","*.gravito.mgr.consensu.org"]},{name:"ID Ward CMP",homepage:"https://id-ward.com/enterprise",category:"consent-provider",domains:["idward.mgr.consensu.org","*.idward.mgr.consensu.org"]},{name:"iubenda CMP",homepage:"https://www.iubenda.com",category:"consent-provider",domains:["iubenda.mgr.consensu.org","*.iubenda.mgr.consensu.org"]},{name:"Jump CMP",homepage:"https://jumpgroup.it/",category:"consent-provider",domains:["avacy.mgr.consensu.org","*.avacy.mgr.consensu.org"]},{name:"LiveRamp CMP",homepage:"https://liveramp.com/",category:"\
consent-provider",domains:["faktor.mgr.consensu.org","*.faktor.mgr.consensu.org"]},{name:"Madvertise CMP",homepage:"https://madvertise.com/en/",category:"consent-provider",domains:["madvertise.mgr.consensu.org","*.madvertise.mgr.consensu.org"]},{name:"Mairdumont Netletic CMP",homepage:"https://www.mairdumont-netletix.com/",category:"consent-provider",domains:["mdnxmp.mgr.consensu.org","*.mdnxmp.mgr.consensu.org"]},{name:"Marfeel CMP",homepage:"https://www.marfeel.com/",category:"consent-provider",domains:["marfeel.mgr.consensu.org","*.marfeel.mgr.consensu.org"]},{name:"Mediavine CMP",homepage:"https://www.mediavine.com/",category:"consent-provider",domains:["mediavine.mgr.consensu.org","*.mediavine.mgr.consensu.org"]},{name:"ConsentServe CMP",homepage:"https://www.consentserve.com/",category:"consent-provider",domains:["consentserve.mgr.consensu.org","*.consentserve.mgr.consensu.org"]},{name:"Next14 CMP",homepage:"https://www.next14.com/",category:"consent-provider",domains:["next14.mg\
r.consensu.org","*.next14.mgr.consensu.org"]},{name:"AdRoll CMP",homepage:"https://www.adroll.com/",category:"consent-provider",domains:["adroll.mgr.consensu.org","*.adroll.mgr.consensu.org"]},{name:"Ogury CMP",homepage:"https://www.ogury.com/",category:"consent-provider",domains:["ogury.mgr.consensu.org","*.ogury.mgr.consensu.org"]},{name:"OneTag CMP",homepage:"https://onetag.net",category:"consent-provider",domains:["onetag.mgr.consensu.org","*.onetag.mgr.consensu.org"]},{name:"OneTrust CMP",homepage:"https://onetrust.com",category:"consent-provider",domains:["onetrust.mgr.consensu.org","*.onetrust.mgr.consensu.org"]},{name:"optAd360 CMP",homepage:"https://www.optad360.com/",category:"consent-provider",domains:["optad360.mgr.consensu.org","*.optad360.mgr.consensu.org"]},{name:"Osano CMP",homepage:"https://www.osano.com",category:"consent-provider",domains:["osano.mgr.consensu.org","*.osano.mgr.consensu.org"]},{name:"Playwire CMP",homepage:"https://www.playwire.com",category:"consent-\
provider",domains:["playwire.mgr.consensu.org","*.playwire.mgr.consensu.org"]},{name:"Pulselive CMP",homepage:"https://www.pulselive.com",category:"consent-provider",domains:["pulselive.mgr.consensu.org","*.pulselive.mgr.consensu.org"]},{name:"Quantcast Choice",homepage:"https://quantcast.com",category:"consent-provider",domains:["quantcast.mgr.consensu.org","*.quantcast.mgr.consensu.org"]},{name:"RCS Pubblicita CMP",homepage:"http://www.rcspubblicita.it/site/home.html",category:"consent-provider",domains:["rcsmediagroup.mgr.consensu.org","*.rcsmediagroup.mgr.consensu.org"]},{name:"Rich Audience CMP",homepage:"https://richaudience.com",category:"consent-provider",domains:["richaudience.mgr.consensu.org","*.richaudience.mgr.consensu.org"]},{name:"Ringier Axel Springer CMP",homepage:"https://www.ringieraxelspringer.pl/en/home/",category:"consent-provider",domains:["rasp.mgr.consensu.org","*.rasp.mgr.consensu.org"]},{name:"Secure Privacy CMP",homepage:"https://secureprivacy.ai/",category:"\
consent-provider",domains:["secureprivacy.mgr.consensu.org","*.secureprivacy.mgr.consensu.org"]},{name:"Securiti CMP",homepage:"https://securiti.ai/",category:"consent-provider",domains:["securiti.mgr.consensu.org","*.securiti.mgr.consensu.org"]},{name:"Seznam.cz CMP",homepage:"https://www.seznam.cz/",category:"consent-provider",domains:["seznam.mgr.consensu.org","*.seznam.mgr.consensu.org"]},{name:"ShareThis CMP",homepage:"https://sharethis.com",category:"consent-provider",domains:["sharethis.mgr.consensu.org","*.sharethis.mgr.consensu.org"]},{name:"ShinyStat CMP",homepage:"https://www.shinystat.com",category:"consent-provider",domains:["shinystat.mgr.consensu.org","*.shinystat.mgr.consensu.org"]},{name:"Sibbo CMP",homepage:"https://sibboventures.com/en/",category:"consent-provider",domains:["sibboventures.mgr.consensu.org","*.sibboventures.mgr.consensu.org"]},{name:"Singlespot CMP",homepage:"https://www.singlespot.com/en",category:"consent-provider",domains:["singlespot.mgr.consensu.\
org","*.singlespot.mgr.consensu.org"]},{name:"Sirdata CMP",homepage:"https://www.sirdata.com",category:"consent-provider",domains:["sddan.mgr.consensu.org","*.sddan.mgr.consensu.org"]},{name:"Snigel CMP",homepage:"https://snigel.com",category:"consent-provider",domains:["snigelweb.mgr.consensu.org","*.snigelweb.mgr.consensu.org"]},{name:"Sourcepoint CMP",homepage:"https://sourcepoint.com",category:"consent-provider",domains:["sourcepoint.mgr.consensu.org","*.sourcepoint.mgr.consensu.org"]},{name:"Pubtech CMP",homepage:"https://www.pubtech.ai/",category:"consent-provider",domains:["pubtech.mgr.consensu.org","*.pubtech.mgr.consensu.org"]},{name:"AdMetrics Pro CMP",homepage:"https://admetricspro.com",category:"consent-provider",domains:["cmp.mgr.consensu.org","*.cmp.mgr.consensu.org"]},{name:"Traffective CMP",homepage:"https://traffective.com",category:"consent-provider",domains:["traffective.mgr.consensu.org","*.traffective.mgr.consensu.org"]},{name:"UniConsent CMP",homepage:"https://www\
.uniconsent.com",category:"consent-provider",domains:["uniconsent.mgr.consensu.org","*.uniconsent.mgr.consensu.org","cmp.uniconsent.com","*.uniconsent.com"],totalExecutionTime:829870,totalOccurrences:1336},{name:"TrustArc CMP",homepage:"https://trustarc.com/",category:"consent-provider",domains:["trustarc.mgr.consensu.org","*.trustarc.mgr.consensu.org"]},{name:"Usercentrics CMP",homepage:"https://usercentrics.com",category:"consent-provider",domains:["usercentrics.mgr.consensu.org","*.usercentrics.mgr.consensu.org","*.usercentrics.eu","*.services.usercentrics.eu"],totalExecutionTime:53008518,totalOccurrences:49602},{name:"WebAds CMP",homepage:"https://www.webads.nl/",category:"consent-provider",domains:["webads.mgr.consensu.org","*.webads.mgr.consensu.org"]},{name:"Trustcommander",company:"Commandersact",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["*.trustcommander.net"],examples:["cdn.trustcommander.net","privacy.trustcommander.net"],totalExecutionTime:324770,
totalOccurrences:1713},{name:"Hubvisor",homepage:"https://www.hubvisor.io",category:"ad",domains:["*.hubvisor.io"],examples:["cdn.hubvisor.io","stream.hubvisor.io"],totalExecutionTime:404737,totalOccurrences:492},{name:"Castle",homepage:"https://castle.io",category:"utility",domains:["*.castle.io","d2t77mnxyo7adj.cloudfront.net"],examples:["t.castle.io"]},{name:"Wigzo",homepage:"https://www.wigzo.com/",category:"marketing",domains:["*.wigzo.com","*.wigzopush.com"],examples:["app.wigzo.com","tracker.wigzopush.com"],totalExecutionTime:215280,totalOccurrences:762},{name:"Convertful",homepage:"https://convertful.com/",category:"marketing",domains:["*.convertful.com"],examples:["app.convertful.com"],totalExecutionTime:215317,totalOccurrences:1534},{name:"OpenLink",company:"MediaWallah",homepage:"https://www.mediawallah.com/",category:"ad",domains:["*.mediawallahscript.com"],examples:["partner.mediawallahscript.com"]},{name:"TPMN",company:"TPMN",homepage:"http://tpmn.io/",category:"ad",domains:[
"*.tpmn.co.kr"],examples:["ad.tpmn.co.kr"],totalExecutionTime:354,totalOccurrences:10},{name:"HERO",company:"Klarna",homepage:"https://www.usehero.com/",category:"customer-success",domains:["*.usehero.com"],examples:["api.usehero.com","cdn.usehero.com"],totalExecutionTime:32092,totalOccurrences:42},{name:"Zync",company:"Zeta Global",homepage:"https://zetaglobal.com/",category:"marketing",domains:["*.rezync.com"],examples:["live.rezync.com"],totalExecutionTime:25978,totalOccurrences:246},{name:"AdFuel Video",company:"AdFuel",homepage:"https://goadfuel.com/",category:"ad",domains:["*.videoplayerhub.com"],examples:["customer.videoplayerhub.com"],totalExecutionTime:82951,totalOccurrences:1407},{name:"Prefix Box AI Search",company:"Prefix Box",homepage:"https://www.prefixbox.com/",category:"utility",domains:["*.prefixbox.com"],examples:["cdn.prefixbox.com"],totalExecutionTime:51608,totalOccurrences:58},{name:"SpeedSize Service Worker",company:"SpeedSize",homepage:"https://speedsize.com/",category:"\
utility",domains:["di6367dava8ow.cloudfront.net","d2d22nphq0yz8t.cloudfront.net"],examples:["di6367dava8ow.cloudfront.net"]},{name:"Vonage Video API",company:"Vonage",homepage:"https://www.vonage.com/communications-apis/video/",category:"video",domains:["*.opentok.com"],examples:["static.opentok.com"],totalExecutionTime:220760,totalOccurrences:304},{name:"Checkout.com",company:"Checkout.com",homepage:"https://www.checkout.com",category:"utility",domains:["*.checkout.com"],examples:["cdn.checkout.com"],totalExecutionTime:184372,totalOccurrences:1367},{name:"Noibu",company:"Noibu",homepage:"https://www.noibu.com",category:"utility",domains:["*.noibu.com"],examples:["input.noibu.com"],totalExecutionTime:1453903,totalOccurrences:613},{name:"Clarity",company:"Microsoft",homepage:"https://clarity.microsoft.com/",category:"utility",domains:["*.clarity.ms"],examples:["c.clarity.ms"],totalExecutionTime:208824616,totalOccurrences:456309},{name:"goinstore",company:"Emplifi",homepage:"https://goin\
store.com/",category:"customer-success",domains:["*.goinstore.com"],examples:["gis.goinstore.com"]},{name:"SegmentStream",company:"SegmentStream",homepage:"https://segmentstream.com/",category:"marketing",domains:["*.segmentstream.com"],examples:["track.segmentstream.com"],totalExecutionTime:8628,totalOccurrences:13},{name:"Amazon Associates",company:"Amazon",homepage:"https://affiliate-program.amazon.co.uk/",category:"marketing",domains:["*.associates-amazon.com"],examples:["assoc-na.associates-amazon.com"],totalExecutionTime:50,totalOccurrences:1},{name:"DotMetrics",company:"Ipsos",homepage:"https://www.dotmetrics.net/",category:"analytics",domains:["*.dotmetrics.net"],examples:["uk-script.dotmetrics.net"],totalExecutionTime:159255,totalOccurrences:817},{name:"Truffle Bid",company:"Truffle",homepage:"https://truffle.bid/",category:"ad",domains:["*.truffle.bid"],examples:["matching.truffle.bid"],totalExecutionTime:24026,totalOccurrences:39},{name:"Hybrid",company:"Hybrid",homepage:"ht\
tps://hybrid.ai/",category:"ad",domains:["*.hybrid.ai"],examples:["dm-eu.hybrid.ai"],totalExecutionTime:219740,totalOccurrences:2326},{name:"AdMan Media",company:"AdMan",homepage:"https://admanmedia.com/",category:"video",domains:["*.admanmedia.com"],examples:["cs.admanmedia.com"],totalExecutionTime:1924,totalOccurrences:202},{name:"ID5 Identity Cloud",company:"ID5",homepage:"https://id5.io/",category:"ad",domains:["id5-sync.com","*.id5-sync.com"],examples:["id5-sync.com"],totalExecutionTime:26134069,totalOccurrences:119336},{name:"Audience Rate",company:"Audience Rate Limited",homepage:"https://www.audiencerate.com/",category:"ad",domains:["*.audrte.com"],examples:["a.audrte.com"]},{name:"Seedtag",company:"Seedtag Advertising",homepage:"https://www.seedtag.com/",category:"ad",domains:["*.seedtag.com"],examples:["s.seedtag.com"],totalExecutionTime:3342567,totalOccurrences:1503},{name:"IVI",company:"IVI Technologies",homepage:"http://ivitechnologies.com/",category:"ad",domains:["*.ivitr\
ack.com"],examples:["matching.ivitrack.com"],totalExecutionTime:3746,totalOccurrences:34},{name:"Sportradar",company:"Sportradar",homepage:"https://www.sportradar.com/",category:"ad",domains:["*.sportradarserving.com"],examples:["a.sportradarserving.com"],totalExecutionTime:520,totalOccurrences:11},{name:"ZEOTAP",company:"ZEOTAP",homepage:"https://zeotap.com/",category:"ad",domains:["*.zeotap.com"],examples:["spl.zeotap.com"],totalExecutionTime:14368,totalOccurrences:96},{name:"Web Content Assessor",company:"TMT Digital",homepage:"https://mediatrust.com/",category:"ad",domains:["*.webcontentassessor.com"],examples:["scripts.webcontentassessor.com"],totalExecutionTime:314249,totalOccurrences:633},{name:"Genie",company:"Media Force",homepage:"https://hellogenie.com/",category:"ad",domains:["*.mfadsrvr.com"],examples:["rtb.mfadsrvr.com"],totalExecutionTime:37,totalOccurrences:2},{name:"mediarithmics",company:"mediarithmics",homepage:"https://www.mediarithmics.com/",category:"ad",domains:[
"*.mediarithmics.com"],examples:["cookie-matching.mediarithmics.com"],totalExecutionTime:25799,totalOccurrences:144},{name:"Ozone Project",company:"The Ozone Project",homepage:"https://www.ozoneproject.com/",category:"ad",domains:["*.the-ozone-project.com"],examples:["elb.the-ozone-project.com"],totalExecutionTime:152768,totalOccurrences:910},{name:"FiftyAurora",company:"Fifty",homepage:"https://fifty.io/",category:"ad",domains:["*.fiftyt.com"],examples:["visitor.fiftyt.com"]},{name:"smadex",company:"entravision",homepage:"https://smadex.com/",category:"ad",domains:["*.smadex.com"],examples:["cm.smadex.com"],totalExecutionTime:5,totalOccurrences:1},{name:"AWX",company:"Trinity Mirror",category:"ad",domains:["*.tm-awx.com"],examples:["felix.data.tm-awx.com"],totalExecutionTime:68744,totalOccurrences:54},{name:"XPO",company:"Knorex",category:"ad",homepage:"https://www.knorex.com/",domains:["*.brand-display.com"],examples:["dmp.brand-display.com"],totalExecutionTime:388629,totalOccurrences:477},
{name:"Viafoura",company:"Viafoura",category:"ad",homepage:"https://viafoura.com/",domains:["*.viafoura.co","*.viafoura.net"],examples:["api.viafoura.co","cdn.viafoura.net"],totalExecutionTime:307404,totalOccurrences:446},{name:"Adnami",company:"Adnami",category:"ad",homepage:"https://www.adnami.io/",domains:["*.adnami.io"],examples:["macro.adnami.io"],totalExecutionTime:272668,totalOccurrences:1639},{name:"LiveRamp Privacy Manager",company:"LiveRamp",category:"ad",homepage:"https://liveramp.com/privacy-legal-compliance/",domains:["*.privacymanager.io"],examples:["geo.privacymanager.io"],totalExecutionTime:6546055,totalOccurrences:22295},{name:"Onfocus",company:"Onfocus SAS",category:"ad",domains:["*.4dex.io"],examples:["script.4dex.io"],totalExecutionTime:4240761,totalOccurrences:8836},{name:"viewTag",company:"Advanced Store",category:"ad",domains:["*.ad4m.at"],examples:["ad4m.at","as.ad4m.at"],totalExecutionTime:458,totalOccurrences:21},{name:"MRP Prelytics",company:"Market Resource \
Partners",category:"ad",homepage:"https://www.mrpfd.com/",domains:["*.mrpdata.net"],examples:["j.mrpdata.net"]},{name:"iPROM",company:"iPROM",category:"ad",homepage:"https://iprom.eu/",domains:["*.iprom.net"],examples:["core.iprom.net"],totalExecutionTime:114801,totalOccurrences:72099},{name:"Plausible",company:"Plausible",homepage:"https://plausible.io/",category:"analytics",domains:["*.plausible.io"]},{name:"Micro Analytics",company:"Micro Analytics",homepage:"https://microanalytics.io/",category:"analytics",domains:["padmin.microanalytics.io","www.microanalytics.io","dev.microanalytics.io","status.microanalytics.io"]},{name:"Scale8",company:"Scale8",homepage:"https://scale8.com/",category:"analytics",domains:["www.scale8.com","api-dev.scale8.com","cdn.scale8.com","ui.scale8.com"]},{name:"Cabin",company:"Cabin",homepage:"https://withcabin.com/",category:"analytics",domains:["*.withcabin.com"],totalExecutionTime:3843,totalOccurrences:100},{name:"Appcues",company:"Appcues",homepage:"ht\
tps://www.appcues.com/",category:"analytics",domains:["*.appcues.com"],totalExecutionTime:2154145,totalOccurrences:2831},{name:"Fathom Analytics",company:"Fathom",homepage:"https://usefathom.com/",category:"analytics",domains:["*.usefathom.com"],totalExecutionTime:145389,totalOccurrences:1141},{name:"Clearbit",company:"Clearbit",homepage:"https://clearbit.com/",category:"analytics",domains:["*.clearbitjs.com","*.clearbitscripts.com","*.clearbit.com"],totalExecutionTime:967253,totalOccurrences:4171},{name:"G2",company:"G2",homepage:"https://www.g2.com/",category:"utility",domains:["*.g2.com","*.g2crowd.com"],totalExecutionTime:195752,totalOccurrences:406},{name:"Navu",company:"Navu",homepage:"https://navu.co/",category:"ad",domains:["*.navu.co"]},{name:"InZynk",company:"InZynk",homepage:"https://inzynk.com/",category:"ad",domains:["*.inzynk.com","*.inzynk.io"],totalExecutionTime:541,totalOccurrences:8},{name:"Integrate",company:"Integrate",homepage:"https://www.integrate.com/",category:"\
ad",domains:["*.integrate.com","*.listenloop.com"],totalExecutionTime:14260,totalOccurrences:39},{name:"Ad Lightning",company:"Boltive",homepage:"https://www.adlightning.com/",category:"ad",domains:["*.adlightning.com"],totalExecutionTime:6879067,totalOccurrences:3795},{name:"GeoEdge",company:"GeoEdge",homepage:"https://www.geoedge.com/",category:"ad",domains:["*.geoedge.com","*.geoedge.be"],totalExecutionTime:1039615,totalOccurrences:1796},{name:"Doofinder",company:"Doofinder",homepage:"https://www.doofinder.com/",category:"utility",domains:["cdn.doofinder.com"],totalExecutionTime:1750777,totalOccurrences:12550},{name:"Revlifter",company:"Revlifter",homepage:"https://www.revlifter.com/",category:"utility",domains:["assets.revlifter.com"]},{name:"Didomi",company:"Didomi",homepage:"https://www.didomi.io/",category:"consent-provider",domains:["sdk.privacy-center.org","api.privacy-center.org"],totalExecutionTime:85132161,totalOccurrences:84206},{name:"Pubperf Analytics",company:"Pubperf",
homepage:"https://www.pubperf.com/",category:"analytics",domains:["*.pubperf.com"],totalExecutionTime:51392,totalOccurrences:400}]});var IL=ve((OAe,_L)=>{d();var{createAPIFromDataset:HQ}=kL(),qQ=RL();_L.exports=HQ(qQ)});var Js,Jv=g(()=>{d();Js=Tn(IL(),1)});var oa={};x(oa,{configToCacheKey:()=>GQ,defaults:()=>zQ});function GQ(e){return JSON.stringify(e)}var zQ,AL=g(()=>{d();zQ=i(()=>({includeRuntimeCallStats:!1,showAllEvents:!1,debugMode:!1,maxInvalidationEventsPerEvent:20,enableAnimationsFrameHandler:!1}),"defaults");i(GQ,"configToCacheKey")});var Yn={};x(Yn,{extensionPalette:()=>WQ,isConsoleTimestampPayloadTrackEntry:()=>OL,isExtensionEntryObj:()=>ML,isExtensionPayloadMarker:()=>NL,isSyntheticExtensionEntry:()=>$Q,isValidExtensionPayload:()=>VQ});function NL(e){return e.dataType==="marker"}function ML(e){let t="track"in e&&!!e.track;return(e.dataType==="track-entry"||e.dataType===void 0)&&t}function OL(e){return e.url!==void 0&&e.description!==void 0}function VQ(e){return NL(e)||ML(e)||OL(e)}function $Q(e){return e.cat==="devtools.extension"}var WQ,PL=g(()=>{d();WQ=["primary","primary-light","primary-dark","secondary","secondary-light","secondary-dark","tertiary","tertiary-light","tertiary-dark","error","warning"];i(NL,"isExtensionPayloadMarker");i(ML,"isExtensionEntryObj");i(OL,"isConsoleTimestampPayloadTrackEntry");i(VQ,"isValidExtensionPayload");i($Q,"isSyntheticExtensionEntry")});var ji={};x(ji,{DataOrigin:()=>Zv,EntriesLinkState:()=>Qv,EventKeyType:()=>Bi,isEntriesLinkAnnotation:()=>XQ,isEntryLabelAnnotation:()=>KQ,isTimeRangeAnnotation:()=>YQ,traceEventKeyToValues:()=>JQ});function YQ(e){return e.type==="TIME_RANGE"}function KQ(e){return e.type==="ENTRY_LABEL"}function XQ(e){return e.type==="ENTRIES_LINK"}function JQ(e){let t=e.split("-"),n=t[0];switch(n){case Bi.PROFILE_CALL:if(t.length!==5||!t.every((r,a)=>a===0||typeof r=="number"||!isNaN(parseInt(r,10))))throw new Error(`Invalid ProfileCallKey: ${e}`);return{type:t[0],processID:parseInt(t[1],10),threadID:parseInt(t[2],10),sampleIndex:parseInt(t[3],10),protocol:parseInt(t[4],10)};case Bi.RAW_EVENT:if(t.length!==2||!(typeof t[1]=="number"||!isNaN(parseInt(t[1],10))))throw new Error(`Invalid RawEvent Key: ${e}`);return{type:t[0],rawIndex:parseInt(t[1],10)};case Bi.SYNTHETIC_EVENT:if(t.length!==2||!(typeof t[1]=="number"||!isNaN(parseInt(t[1],10))))throw new Error(`Invalid SyntheticEvent Key: ${e}`);return{type:t[0],
rawIndex:parseInt(t[1],10)};case Bi.LEGACY_TIMELINE_FRAME:{if(t.length!==2||Number.isNaN(parseInt(t[1],10)))throw new Error(`Invalid LegacyTimelineFrame Key: ${e}`);return{type:n,rawIndex:parseInt(t[1],10)}}default:throw new Error(`Unknown trace event key: ${e}`)}}var Zv,Qv,Bi,LL=g(()=>{d();(function(e){e.CPU_PROFILE="CPUProfile",e.TRACE_EVENTS="TraceEvents"})(Zv||(Zv={}));(function(e){e.CREATION_NOT_STARTED="creation_not_started",e.PENDING_TO_EVENT="pending_to_event",e.CONNECTED="connected"})(Qv||(Qv={}));(function(e){e.RAW_EVENT="r",e.SYNTHETIC_EVENT="s",e.PROFILE_CALL="p",e.LEGACY_TIMELINE_FRAME="l"})(Bi||(Bi={}));i(YQ,"isTimeRangeAnnotation");i(KQ,"isEntryLabelAnnotation");i(XQ,"isEntriesLinkAnnotation");i(JQ,"traceEventKeyToValues")});var FL=g(()=>{d()});var I={};x(I,{Micro:()=>ZQ,Milli:()=>QQ,Seconds:()=>eee});function ZQ(e){return e}function QQ(e){return e}function eee(e){return e}var UL=g(()=>{d();i(ZQ,"Micro");i(QQ,"Milli");i(eee,"Seconds")});var v={};x(v,{AuctionWorkletType:()=>tb,CallFrameID:()=>Xee,Categories:()=>Ene,InvalidationEventType:()=>ab,LayoutInvalidationReason:()=>nb,MarkerName:()=>lee,NO_NAVIGATION:()=>ib,Name:()=>W,Phase:()=>ge,ProcessID:()=>Zee,ProfileID:()=>Kee,SampleIndex:()=>Jee,Scope:()=>eb,SelectorTimingsKey:()=>zt,StyleRecalcInvalidationReason:()=>rb,ThreadID:()=>Qee,WorkerId:()=>ete,eventIsPageLoadEvent:()=>mee,isAbortPostTaskCallback:()=>yne,isActivateLayerTree:()=>Uee,isAnimation:()=>hte,isAnimationFrameAsyncEnd:()=>See,isAnimationFrameAsyncStart:()=>xee,isAnimationFramePresentation:()=>Cee,isAnyScriptSourceEvent:()=>Rne,isAuctionWorkletDoneWithProcess:()=>oee,isAuctionWorkletRunningInProcess:()=>aee,isBegin:()=>tte,isBeginCommitCompositorFrame:()=>fee,isBeginFrame:()=>Dee,isBeginMainThreadFrame:()=>Mee,isBeginRemoteFontLoad:()=>Hte,isCommit:()=>Pee,isCommitLoad:()=>fte,isComplete:()=>GL,isCompositeLayers:()=>Fee,isConsoleRunTask:()=>o3,isConsoleTime:()=>Wte,isConsoleTimeStamp:()=>Vte,isDOMStats:()=>lte,
isDebuggerAsyncTaskRun:()=>Yee,isDebuggerAsyncTaskScheduled:()=>$ee,isDecodeImage:()=>qee,isDecodeLazyPixelRef:()=>Hee,isDidCommitSameDocumentNavigation:()=>Lte,isDispatch:()=>rte,isDisplayListItemListSnapshot:()=>rne,isDomLoading:()=>jte,isDrawFrame:()=>Iee,isDrawLazyPixelRef:()=>jee,isDroppedFrame:()=>Aee,isEnd:()=>nte,isEventTiming:()=>sb,isEventTimingEnd:()=>wte,isEventTimingStart:()=>Ete,isFireAnimationFrame:()=>one,isFireIdleCallback:()=>ote,isFirstContentfulPaint:()=>$L,isFirstPaint:()=>XL,isFlowPhase:()=>tee,isFlowPhaseEvent:()=>bne,isFrameCommittedInBrowser:()=>pte,isFunctionCall:()=>fne,isGPUTask:()=>Tte,isHandlePostMessage:()=>ste,isInstant:()=>WL,isInteractiveTime:()=>ZL,isInvalidateLayout:()=>Vee,isInvalidationTracking:()=>Bee,isJSInvocationEvent:()=>vne,isLargestContentfulPaintCandidate:()=>YL,isLargestImagePaintCandidate:()=>vte,isLargestTextPaintCandidate:()=>bte,isLayerTreeHostImplSnapshot:()=>ane,isLayout:()=>Wee,isLayoutImageUnsized:()=>bee,isLayoutInvalidationTracking:()=>VL,
isLayoutShift:()=>yte,isLegacyScreenshot:()=>iee,isLegacySyntheticScreenshot:()=>see,isLegacyTimelineFrame:()=>Tne,isLinkPreconnect:()=>gee,isMainFrameViewport:()=>Fte,isMarkDOMContent:()=>JL,isMarkLoad:()=>KL,isMarkerEvent:()=>uee,isNavigationStart:()=>e3,isNeedsBeginFrameChanged:()=>Oee,isNestableAsyncPhase:()=>BL,isNetworkTrackEntry:()=>Ote,isPaint:()=>Zte,isPaintImage:()=>Qte,isPairableAsyncBegin:()=>wee,isPairableAsyncEnd:()=>Eee,isPairableAsyncInstant:()=>Tee,isParseAuthorStyleSheetEvent:()=>wne,isParseHTML:()=>Yte,isParseMetaViewport:()=>hee,isPerformanceMark:()=>Gte,isPerformanceMeasure:()=>t3,isPerformanceMeasureBegin:()=>zte,isPhaseAsync:()=>ob,isPipelineReporter:()=>kee,isPrePaint:()=>Pte,isProcessName:()=>dte,isProfile:()=>xte,isProfileCall:()=>Jte,isProfileChunk:()=>Cte,isRasterTask:()=>Lee,isRecalcStyle:()=>Gee,isReceivedDataEvent:()=>Mte,isRemoteFontLoaded:()=>qte,isRenderFrameImplCreateChildFrame:()=>vee,isRendererEvent:()=>ate,isRequestIdleCallback:()=>cne,isRequestMainThreadFrame:()=>Nee,
isResourceChangePriority:()=>kte,isResourceFinish:()=>Dte,isResourceMarkAsCached:()=>Ite,isResourceReceiveResponse:()=>_te,isResourceReceivedData:()=>Nte,isResourceSendRequest:()=>Rte,isResourceWillSendRequest:()=>Ate,isRunPostTaskCallback:()=>gne,isRunTask:()=>ree,isRundownScript:()=>Sne,isRundownScriptCompiled:()=>xne,isRundownScriptSource:()=>Cne,isRundownScriptSourceLarge:()=>kne,isSchedulePostMessage:()=>ite,isSchedulePostTaskCallback:()=>hne,isScheduleStyleInvalidationTracking:()=>HL,isScheduleStyleRecalculation:()=>yee,isScreenshot:()=>cee,isScrollLayer:()=>ene,isSelectorStats:()=>zee,isSetLayerId:()=>tne,isStyleInvalidatorInvalidationTracking:()=>zL,isStyleRecalcInvalidationTracking:()=>qL,isSyntheticAnimation:()=>gte,isSyntheticBased:()=>Ree,isSyntheticConsoleTiming:()=>Bte,isSyntheticCpuProfile:()=>Ste,isSyntheticInteraction:()=>_ee,isSyntheticLayoutShift:()=>Kte,isSyntheticLayoutShiftCluster:()=>Xte,isSyntheticNetworkRequest:()=>QL,isSyntheticUserTiming:()=>Ute,isSyntheticWebSocketConnection:()=>cb,
isThreadName:()=>ute,isTimerFire:()=>sne,isTimerInstall:()=>ine,isTracingSessionIdForWorker:()=>pee,isTracingStartedInBrowser:()=>mte,isUpdateCounters:()=>cte,isUpdateLayer:()=>nne,isUserTiming:()=>lb,isUserTimingMeasure:()=>$te,isV8Compile:()=>pne,isWebSocketCreate:()=>n3,isWebSocketDestroy:()=>dne,isWebSocketEvent:()=>mne,isWebSocketInfo:()=>r3,isWebSocketReceiveHandshakeResponse:()=>une,isWebSocketSendHandshakeRequest:()=>lne,isWebSocketTraceEvent:()=>ub,isWebSocketTransfer:()=>a3,objectIsCallFrame:()=>nee});function BL(e){return e===ge.ASYNC_NESTABLE_START||e===ge.ASYNC_NESTABLE_END||e===ge.ASYNC_NESTABLE_INSTANT}function ob(e){return BL(e)||e===ge.ASYNC_BEGIN||e===ge.ASYNC_STEP_INTO||e===ge.ASYNC_END||e===ge.ASYNC_STEP_PAST}function tee(e){return e===ge.FLOW_START||e===ge.FLOW_STEP||e===ge.FLOW_END}function nee(e){return"functionName"in e&&typeof e.functionName=="string"&&"scriptId"in e&&(typeof e.scriptId=="string"||typeof e.scriptId=="number")&&"columnNumber"in e&&typeof e.columnNumber==
"number"&&"lineNumber"in e&&typeof e.lineNumber=="number"&&"url"in e&&typeof e.url=="string"}function ree(e){return e.name===W.RUN_TASK&&e.ph===ge.COMPLETE}function aee(e){return e.name==="AuctionWorkletRunningInProcess"}function oee(e){return e.name==="AuctionWorkletDoneWithProcess"}function iee(e){return e.name===W.SCREENSHOT&&"id"in e}function see(e){return e.name===W.SCREENSHOT&&"dataUri"in(e.args??{})}function cee(e){return e.name===W.SCREENSHOT&&"source_id"in(e.args??{})}function uee(e){return e.ph===ge.INSTANT||e.ph===ge.MARK?jL.some(t=>t(e)):!1}function mee(e){return e.ph===ge.INSTANT||e.ph===ge.MARK?dee.some(t=>t(e)):!1}function pee(e){return e.name==="TracingSessionIdForWorker"}function HL(e){return e.name===W.SCHEDULE_STYLE_INVALIDATION_TRACKING}function qL(e){return e.name===W.STYLE_RECALC_INVALIDATION_TRACKING}function zL(e){return e.name===W.STYLE_INVALIDATOR_INVALIDATION_TRACKING}function fee(e){return e.name===W.BEGIN_COMMIT_COMPOSITOR_FRAME}function hee(e){return e.name===
W.PARSE_META_VIEWPORT}function gee(e){return e.name===W.LINK_PRECONNECT}function yee(e){return e.name===W.SCHEDULE_STYLE_RECALCULATION}function vee(e){return e.name===W.RENDER_FRAME_IMPL_CREATE_CHILD_FRAME}function bee(e){return e.name===W.LAYOUT_IMAGE_UNSIZED}function wee(e){return e.ph===ge.ASYNC_NESTABLE_START}function Eee(e){return e.ph===ge.ASYNC_NESTABLE_END}function Tee(e){return e.ph===ge.ASYNC_NESTABLE_INSTANT}function xee(e){return e.name===W.ANIMATION_FRAME&&e.ph===ge.ASYNC_NESTABLE_START}function See(e){return e.name===W.ANIMATION_FRAME&&e.ph===ge.ASYNC_NESTABLE_END}function Cee(e){return e.name===W.ANIMATION_FRAME_PRESENTATION}function kee(e){return e.name===W.PIPELINE_REPORTER}function Ree(e){return"rawSourceEvent"in e}function _ee(e){return!!("interactionId"in e&&e.args?.data&&"beginEvent"in e.args.data&&"endEvent"in e.args.data)}function Iee(e){return e.name===W.DRAW_FRAME&&e.ph===ge.INSTANT}function Dee(e){return!!(e.name===W.BEGIN_FRAME&&e.args&&"frameSeqId"in e.args)}
function Aee(e){return!!(e.name===W.DROPPED_FRAME&&e.args&&"frameSeqId"in e.args)}function Nee(e){return e.name===W.REQUEST_MAIN_THREAD_FRAME}function Mee(e){return e.name===W.BEGIN_MAIN_THREAD_FRAME}function Oee(e){return e.name===W.NEEDS_BEGIN_FRAME_CHANGED}function Pee(e){return!!(e.name===W.COMMIT&&e.args&&"frameSeqId"in e.args)}function Lee(e){return e.name===W.RASTER_TASK}function Fee(e){return e.name===W.COMPOSITE_LAYERS}function Uee(e){return e.name===W.ACTIVATE_LAYER_TREE}function Bee(e){return HL(e)||qL(e)||zL(e)||VL(e)}function jee(e){return e.name===W.DRAW_LAZY_PIXEL_REF}function Hee(e){return e.name===W.DECODE_LAZY_PIXEL_REF}function qee(e){return e.name===W.DECODE_IMAGE}function zee(e){return e.name===W.SELECTOR_STATS}function Gee(e){return e.name===W.RECALC_STYLE}function Wee(e){return e.name===W.LAYOUT&&!!(e.args&&"beginData"in e.args)}function Vee(e){return e.name===W.INVALIDATE_LAYOUT}function $ee(e){return e.name===W.DEBUGGER_ASYNC_TASK_SCHEDULED}function Yee(e){return e.
name===W.DEBUGGER_ASYNC_TASK_RUN}function Kee(e){return e}function Xee(e){return e}function Jee(e){return e}function Zee(e){return e}function Qee(e){return e}function ete(e){return e}function GL(e){return e.ph===ge.COMPLETE}function tte(e){return e.ph===ge.BEGIN}function nte(e){return e.ph===ge.END}function rte(e){return e.name==="EventDispatch"&&e.ph===ge.COMPLETE}function WL(e){return e.ph===ge.INSTANT}function ate(e){return WL(e)||GL(e)}function ote(e){return e.name==="FireIdleCallback"&&e.ph===ge.COMPLETE}function ite(e){return e.name===W.SCHEDULE_POST_MESSAGE}function ste(e){return e.name===W.HANDLE_POST_MESSAGE&&e.ph===ge.COMPLETE}function cte(e){return e.name==="UpdateCounters"}function lte(e){return e.name==="DOMStats"}function ute(e){return e.name===W.THREAD_NAME}function dte(e){return e.name==="process_name"}function mte(e){return e.name===W.TRACING_STARTED_IN_BROWSER}function pte(e){return e.name==="FrameCommittedInBrowser"}function fte(e){return e.name==="CommitLoad"}function hte(e){
return e.name==="Animation"&&e.cat.includes("devtools.timeline")}function gte(e){if(e.name!=="Animation"||!e.cat.includes("devtools.timeline"))return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function yte(e){return e.name===W.LAYOUT_SHIFT}function VL(e){return e.name===W.LAYOUT_INVALIDATION_TRACKING}function $L(e){return e.name==="firstContentfulPaint"}function YL(e){return e.name===W.MARK_LCP_CANDIDATE}function vte(e){return e.name==="LargestImagePaint::Candidate"}function bte(e){return e.name==="LargestTextPaint::Candidate"}function KL(e){return e.name==="MarkLoad"}function XL(e){return e.name==="firstPaint"}function JL(e){return e.name==="MarkDOMContent"}function ZL(e){return e.name==="InteractiveTime"}function sb(e){return e.name===W.EVENT_TIMING}function wte(e){return sb(e)&&e.ph===ge.ASYNC_NESTABLE_END}function Ete(e){return sb(e)&&e.ph===ge.ASYNC_NESTABLE_START}function Tte(e){return e.name==="GPUTask"}function xte(e){return e.name===W.PROFILE}function Ste(e){
return e.name===W.CPU_PROFILE&&e.ph===ge.COMPLETE}function Cte(e){return e.name===W.PROFILE_CHUNK}function kte(e){return e.name==="ResourceChangePriority"}function Rte(e){return e.name==="ResourceSendRequest"}function _te(e){return e.name==="ResourceReceiveResponse"}function Ite(e){return e.name==="ResourceMarkAsCached"}function Dte(e){return e.name==="ResourceFinish"}function Ate(e){return e.name==="ResourceWillSendRequest"}function Nte(e){return e.name==="ResourceReceivedData"}function Mte(e){return e.name==="ResourceReceivedData"||e.name==="ResourceFinish"||e.name==="ResourceReceiveResponse"}function QL(e){return e.name===W.SYNTHETIC_NETWORK_REQUEST}function cb(e){return e.name==="SyntheticWebSocketConnection"}function Ote(e){return QL(e)||cb(e)||ub(e)}function Pte(e){return e.name==="PrePaint"}function e3(e){return e.name==="navigationStart"&&e.args?.data?.documentLoaderURL!==""}function Lte(e){return e.name==="RenderFrameHostImpl::DidCommitSameDocumentNavigation"&&e.ph===ge.COMPLETE}
function Fte(e){return e.name==="PaintTimingVisualizer::Viewport"}function Ute(e){if(e.cat!=="blink.user_timing")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function Bte(e){if(e.cat!=="blink.console")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function lb(e){return e.cat==="blink.user_timing"}function jte(e){return e.name===W.DOM_LOADING}function Hte(e){return e.name===W.BEGIN_REMOTE_FONT_LOAD}function qte(e){return e.name===W.REMOTE_FONT_LOADED}function t3(e){return lb(e)&&ob(e.ph)}function zte(e){return t3(e)&&e.ph===ge.ASYNC_NESTABLE_START}function Gte(e){return lb(e)&&(e.ph===ge.MARK||e.ph===ge.INSTANT)}function Wte(e){return e.cat==="blink.console"&&ob(e.ph)}function Vte(e){return e.ph===ge.INSTANT&&e.name===W.TIME_STAMP}function $te(e){return e.name===W.USER_TIMING_MEASURE}function Yte(e){return e.name==="ParseHTML"}function Kte(e){return e.name===W.SYNTHETIC_LAYOUT_SHIFT}function Xte(e){return e.name===W.SYNTHETIC_LAYOUT_SHIFT_CLUSTER}
function Jte(e){return"callFrame"in e}function Zte(e){return e.name===W.PAINT}function Qte(e){return e.name===W.PAINT_IMAGE&&e.ph===ge.COMPLETE}function ene(e){return e.name===W.SCROLL_LAYER&&e.ph===ge.COMPLETE}function tne(e){return e.name===W.SET_LAYER_TREE_ID}function nne(e){return e.name===W.UPDATE_LAYER}function rne(e){return e.name===W.DISPLAY_ITEM_LIST_SNAPSHOT}function ane(e){return e.name===W.LAYER_TREE_HOST_IMPL_SNAPSHOT}function one(e){return e.name===W.FIRE_ANIMATION_FRAME&&e.ph===ge.COMPLETE}function ine(e){return e.name===W.TIMER_INSTALL}function sne(e){return e.name===W.TIMER_FIRE&&e.ph===ge.COMPLETE}function cne(e){return e.name===W.REQUEST_IDLE_CALLBACK}function n3(e){return e.name===W.WEB_SOCKET_CREATE}function r3(e){return e.name===W.WEB_SOCKET_SEND_HANDSHAKE_REQUEST||e.name===W.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST||e.name===W.WEB_SOCKET_DESTROY}function a3(e){return e.name===W.WEB_SOCKET_SEND||e.name===W.WEB_SOCKET_RECEIVE}function lne(e){return e.name===W.WEB_SOCKET_SEND_HANDSHAKE_REQUEST}
function une(e){return e.name===W.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST}function dne(e){return e.name===W.WEB_SOCKET_DESTROY}function ub(e){return n3(e)||r3(e)||a3(e)}function mne(e){return ub(e)||cb(e)}function pne(e){return e.name===W.COMPILE&&e.ph===ge.COMPLETE}function fne(e){return e.name===W.FUNCTION_CALL&&e.ph===ge.COMPLETE}function hne(e){return e.name===W.SCHEDULE_POST_TASK_CALLBACK}function gne(e){return e.name===W.RUN_POST_TASK_CALLBACK&&e.ph===ge.COMPLETE}function yne(e){return e.name===W.ABORT_POST_TASK_CALLBACK&&e.ph===ge.COMPLETE}function vne(e){switch(e.name){case W.RUN_MICROTASKS:case W.FUNCTION_CALL:case W.EVALUATE_SCRIPT:case W.EVALUATE_MODULE:case W.EVENT_DISPATCH:case W.V8_EXECUTE:case W.V8_CONSOLE_RUN_TASK:return!0}return!!(e.name.startsWith("v8")||e.name.startsWith("V8")||o3(e))}function o3(e){return e.name===W.V8_CONSOLE_RUN_TASK}function bne(e){return e.ph===ge.FLOW_START||e.ph===ge.FLOW_STEP||e.ph===ge.FLOW_END}function wne(e){return e.name===W.PARSE_AUTHOR_STYLE_SHEET&&
e.ph===ge.COMPLETE}function Tne(e){return"idle"in e&&typeof e.idle=="boolean"}function xne(e){return e.cat==="disabled-by-default-devtools.target-rundown"}function Sne(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown"&&e.name==="ScriptCatchup"}function Cne(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"&&e.name==="ScriptCatchup"}function kne(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"&&e.name==="LargeScriptCatchup"}function Rne(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"}var ge,eb,tb,jL,lee,dee,ib,nb,rb,ab,zt,W,Ene,kf=g(()=>{d();(function(e){e.BEGIN="B",e.END="E",e.COMPLETE="X",e.INSTANT="I",e.COUNTER="C",e.ASYNC_NESTABLE_START="b",e.ASYNC_NESTABLE_INSTANT="n",e.ASYNC_NESTABLE_END="e",e.ASYNC_STEP_INTO="T",e.ASYNC_BEGIN="S",e.ASYNC_END="F",e.ASYNC_STEP_PAST="p",e.FLOW_START="s",e.FLOW_STEP="t",e.FLOW_END="f",e.SAMPLE="P",e.OBJECT_CREATED="N",e.OBJECT_SNAPSHOT="O",e.OBJECT_DESTROYED=
"D",e.METADATA="M",e.MEMORY_DUMP_GLOBAL="V",e.MEMORY_DUMP_PROCESS="v",e.MARK="R",e.CLOCK_SYNC="c"})(ge||(ge={}));i(BL,"isNestableAsyncPhase");i(ob,"isPhaseAsync");i(tee,"isFlowPhase");(function(e){e.THREAD="t",e.PROCESS="p",e.GLOBAL="g"})(eb||(eb={}));i(nee,"objectIsCallFrame");i(ree,"isRunTask");(function(e){e.BIDDER="bidder",e.SELLER="seller",e.UNKNOWN="unknown"})(tb||(tb={}));i(aee,"isAuctionWorkletRunningInProcess");i(oee,"isAuctionWorkletDoneWithProcess");i(iee,"isLegacyScreenshot");i(see,"isLegacySyntheticScreenshot");i(cee,"isScreenshot");jL=[JL,KL,XL,$L,YL,e3],lee=["MarkDOMContent","MarkLoad","firstPaint","firstContentfulPaint","largestContentfulPaint::Candidate"];i(uee,"isMarkerEvent");dee=[...jL,ZL];i(mee,"eventIsPageLoadEvent");i(pee,"isTracingSessionIdForWorker");ib="NO_NAVIGATION";(function(e){e.SIZE_CHANGED="Size changed",e.ATTRIBUTE="Attribute",e.ADDED_TO_LAYOUT="Added to layout",e.SCROLLBAR_CHANGED="Scrollbar changed",e.REMOVED_FROM_LAYOUT="Removed from layout",e.STYLE_CHANGED=
"Style changed",e.FONTS_CHANGED="Fonts changed",e.UNKNOWN="Unknown"})(nb||(nb={}));i(HL,"isScheduleStyleInvalidationTracking");(function(e){e.ANIMATION="Animation",e.RELATED_STYLE_RULE="Related style rule"})(rb||(rb={}));i(qL,"isStyleRecalcInvalidationTracking");i(zL,"isStyleInvalidatorInvalidationTracking");i(fee,"isBeginCommitCompositorFrame");i(hee,"isParseMetaViewport");i(gee,"isLinkPreconnect");i(yee,"isScheduleStyleRecalculation");i(vee,"isRenderFrameImplCreateChildFrame");i(bee,"isLayoutImageUnsized");i(wee,"isPairableAsyncBegin");i(Eee,"isPairableAsyncEnd");i(Tee,"isPairableAsyncInstant");i(xee,"isAnimationFrameAsyncStart");i(See,"isAnimationFrameAsyncEnd");i(Cee,"isAnimationFramePresentation");i(kee,"isPipelineReporter");i(Ree,"isSyntheticBased");i(_ee,"isSyntheticInteraction");i(Iee,"isDrawFrame");i(Dee,"isBeginFrame");i(Aee,"isDroppedFrame");i(Nee,"isRequestMainThreadFrame");i(Mee,"isBeginMainThreadFrame");i(Oee,"isNeedsBeginFrameChanged");i(Pee,"isCommit");i(Lee,"isRasterTa\
sk");i(Fee,"isCompositeLayers");i(Uee,"isActivateLayerTree");i(Bee,"isInvalidationTracking");i(jee,"isDrawLazyPixelRef");i(Hee,"isDecodeLazyPixelRef");i(qee,"isDecodeImage");(function(e){e.StyleInvalidatorInvalidationTracking="StyleInvalidatorInvalidationTracking",e.StyleRecalcInvalidationTracking="StyleRecalcInvalidationTracking"})(ab||(ab={}));(function(e){e.Elapsed="elapsed (us)",e.RejectPercentage="reject_percentage",e.FastRejectCount="fast_reject_count",e.MatchAttempts="match_attempts",e.MatchCount="match_count",e.Selector="selector",e.StyleSheetId="style_sheet_id",e.InvalidationCount="invalidation_count"})(zt||(zt={}));i(zee,"isSelectorStats");i(Gee,"isRecalcStyle");i(Wee,"isLayout");i(Vee,"isInvalidateLayout");i($ee,"isDebuggerAsyncTaskScheduled");i(Yee,"isDebuggerAsyncTaskRun");i(Kee,"ProfileID");i(Xee,"CallFrameID");i(Jee,"SampleIndex");i(Zee,"ProcessID");i(Qee,"ThreadID");i(ete,"WorkerId");i(GL,"isComplete");i(tte,"isBegin");i(nte,"isEnd");i(rte,"isDispatch");i(WL,"isInstant");
i(ate,"isRendererEvent");i(ote,"isFireIdleCallback");i(ite,"isSchedulePostMessage");i(ste,"isHandlePostMessage");i(cte,"isUpdateCounters");i(lte,"isDOMStats");i(ute,"isThreadName");i(dte,"isProcessName");i(mte,"isTracingStartedInBrowser");i(pte,"isFrameCommittedInBrowser");i(fte,"isCommitLoad");i(hte,"isAnimation");i(gte,"isSyntheticAnimation");i(yte,"isLayoutShift");i(VL,"isLayoutInvalidationTracking");i($L,"isFirstContentfulPaint");i(YL,"isLargestContentfulPaintCandidate");i(vte,"isLargestImagePaintCandidate");i(bte,"isLargestTextPaintCandidate");i(KL,"isMarkLoad");i(XL,"isFirstPaint");i(JL,"isMarkDOMContent");i(ZL,"isInteractiveTime");i(sb,"isEventTiming");i(wte,"isEventTimingEnd");i(Ete,"isEventTimingStart");i(Tte,"isGPUTask");i(xte,"isProfile");i(Ste,"isSyntheticCpuProfile");i(Cte,"isProfileChunk");i(kte,"isResourceChangePriority");i(Rte,"isResourceSendRequest");i(_te,"isResourceReceiveResponse");i(Ite,"isResourceMarkAsCached");i(Dte,"isResourceFinish");i(Ate,"isResourceWillSendRe\
quest");i(Nte,"isResourceReceivedData");i(Mte,"isReceivedDataEvent");i(QL,"isSyntheticNetworkRequest");i(cb,"isSyntheticWebSocketConnection");i(Ote,"isNetworkTrackEntry");i(Pte,"isPrePaint");i(e3,"isNavigationStart");i(Lte,"isDidCommitSameDocumentNavigation");i(Fte,"isMainFrameViewport");i(Ute,"isSyntheticUserTiming");i(Bte,"isSyntheticConsoleTiming");i(lb,"isUserTiming");i(jte,"isDomLoading");i(Hte,"isBeginRemoteFontLoad");i(qte,"isRemoteFontLoaded");i(t3,"isPerformanceMeasure");i(zte,"isPerformanceMeasureBegin");i(Gte,"isPerformanceMark");i(Wte,"isConsoleTime");i(Vte,"isConsoleTimeStamp");i($te,"isUserTimingMeasure");i(Yte,"isParseHTML");i(Kte,"isSyntheticLayoutShift");i(Xte,"isSyntheticLayoutShiftCluster");i(Jte,"isProfileCall");i(Zte,"isPaint");i(Qte,"isPaintImage");i(ene,"isScrollLayer");i(tne,"isSetLayerId");i(nne,"isUpdateLayer");i(rne,"isDisplayListItemListSnapshot");i(ane,"isLayerTreeHostImplSnapshot");i(one,"isFireAnimationFrame");i(ine,"isTimerInstall");i(sne,"isTimerFire");
i(cne,"isRequestIdleCallback");i(n3,"isWebSocketCreate");i(r3,"isWebSocketInfo");i(a3,"isWebSocketTransfer");i(lne,"isWebSocketSendHandshakeRequest");i(une,"isWebSocketReceiveHandshakeResponse");i(dne,"isWebSocketDestroy");i(ub,"isWebSocketTraceEvent");i(mne,"isWebSocketEvent");i(pne,"isV8Compile");i(fne,"isFunctionCall");i(hne,"isSchedulePostTaskCallback");i(gne,"isRunPostTaskCallback");i(yne,"isAbortPostTaskCallback");i(vne,"isJSInvocationEvent");i(o3,"isConsoleRunTask");i(bne,"isFlowPhaseEvent");i(wne,"isParseAuthorStyleSheetEvent");(function(e){e.THREAD_NAME="thread_name",e.PROGRAM="Program",e.RUN_TASK="RunTask",e.ASYNC_TASK="AsyncTask",e.RUN_MICROTASKS="RunMicrotasks",e.XHR_LOAD="XHRLoad",e.XHR_READY_STATE_CHANGED="XHRReadyStateChange",e.PARSE_HTML="ParseHTML",e.PARSE_CSS="ParseAuthorStyleSheet",e.COMPILE_CODE="V8.CompileCode",e.COMPILE_MODULE="V8.CompileModule",e.COMPILE="v8.compile",e.COMPILE_SCRIPT="V8.CompileScript",e.OPTIMIZE="V8.OptimizeCode",e.WASM_STREAM_FROM_RESPONSE_CALLBACK=
"v8.wasm.streamFromResponseCallback",e.WASM_COMPILED_MODULE="v8.wasm.compiledModule",e.WASM_CACHED_MODULE="v8.wasm.cachedModule",e.WASM_MODULE_CACHE_HIT="v8.wasm.moduleCacheHit",e.WASM_MODULE_CACHE_INVALID="v8.wasm.moduleCacheInvalid",e.PROFILE_CALL="ProfileCall",e.EVALUATE_SCRIPT="EvaluateScript",e.FUNCTION_CALL="FunctionCall",e.EVENT_DISPATCH="EventDispatch",e.EVALUATE_MODULE="v8.evaluateModule",e.REQUEST_MAIN_THREAD_FRAME="RequestMainThreadFrame",e.REQUEST_ANIMATION_FRAME="RequestAnimationFrame",e.CANCEL_ANIMATION_FRAME="CancelAnimationFrame",e.FIRE_ANIMATION_FRAME="FireAnimationFrame",e.REQUEST_IDLE_CALLBACK="RequestIdleCallback",e.CANCEL_IDLE_CALLBACK="CancelIdleCallback",e.FIRE_IDLE_CALLBACK="FireIdleCallback",e.TIMER_INSTALL="TimerInstall",e.TIMER_REMOVE="TimerRemove",e.TIMER_FIRE="TimerFire",e.WEB_SOCKET_CREATE="WebSocketCreate",e.WEB_SOCKET_SEND_HANDSHAKE="WebSocketSendHandshakeRequest",e.WEB_SOCKET_RECEIVE_HANDSHAKE="WebSocketReceiveHandshakeResponse",e.WEB_SOCKET_DESTROY="We\
bSocketDestroy",e.WEB_SOCKET_SEND="WebSocketSend",e.WEB_SOCKET_RECEIVE="WebSocketReceive",e.CRYPTO_DO_ENCRYPT="DoEncrypt",e.CRYPTO_DO_ENCRYPT_REPLY="DoEncryptReply",e.CRYPTO_DO_DECRYPT="DoDecrypt",e.CRYPTO_DO_DECRYPT_REPLY="DoDecryptReply",e.CRYPTO_DO_DIGEST="DoDigest",e.CRYPTO_DO_DIGEST_REPLY="DoDigestReply",e.CRYPTO_DO_SIGN="DoSign",e.CRYPTO_DO_SIGN_REPLY="DoSignReply",e.CRYPTO_DO_VERIFY="DoVerify",e.CRYPTO_DO_VERIFY_REPLY="DoVerifyReply",e.V8_EXECUTE="V8.Execute",e.V8_CONSOLE_RUN_TASK="V8Console::runTask",e.SCHEDULE_POST_TASK_CALLBACK="SchedulePostTaskCallback",e.RUN_POST_TASK_CALLBACK="RunPostTaskCallback",e.ABORT_POST_TASK_CALLBACK="AbortPostTaskCallback",e.DEBUGGER_ASYNC_TASK_RUN="v8::Debugger::AsyncTaskRun",e.DEBUGGER_ASYNC_TASK_SCHEDULED="v8::Debugger::AsyncTaskScheduled",e.GC="GCEvent",e.DOMGC="BlinkGC.AtomicPhase",e.MAJOR_GC="MajorGC",e.MINOR_GC="MinorGC",e.GC_COLLECT_GARBARGE="BlinkGC.AtomicPhase",e.CPPGC_SWEEP="CppGC.IncrementalSweep",e.SCHEDULE_STYLE_RECALCULATION="Schedul\
eStyleRecalculation",e.LAYOUT="Layout",e.RECALC_STYLE="UpdateLayoutTree",e.INVALIDATE_LAYOUT="InvalidateLayout",e.LAYOUT_INVALIDATION_TRACKING="LayoutInvalidationTracking",e.COMPUTE_INTERSECTION="ComputeIntersections",e.HIT_TEST="HitTest",e.PRE_PAINT="PrePaint",e.LAYERIZE="Layerize",e.LAYOUT_SHIFT="LayoutShift",e.SYNTHETIC_LAYOUT_SHIFT="SyntheticLayoutShift",e.SYNTHETIC_LAYOUT_SHIFT_CLUSTER="SyntheticLayoutShiftCluster",e.UPDATE_LAYER_TREE="UpdateLayerTree",e.SCHEDULE_STYLE_INVALIDATION_TRACKING="ScheduleStyleInvalidationTracking",e.STYLE_RECALC_INVALIDATION_TRACKING="StyleRecalcInvalidationTracking",e.STYLE_INVALIDATOR_INVALIDATION_TRACKING="StyleInvalidatorInvalidationTracking",e.SELECTOR_STATS="SelectorStats",e.BEGIN_COMMIT_COMPOSITOR_FRAME="BeginCommitCompositorFrame",e.PARSE_META_VIEWPORT="ParseMetaViewport",e.SCROLL_LAYER="ScrollLayer",e.UPDATE_LAYER="UpdateLayer",e.PAINT_SETUP="PaintSetup",e.PAINT="Paint",e.PAINT_IMAGE="PaintImage",e.COMMIT="Commit",e.COMPOSITE_LAYERS="Composite\
Layers",e.RASTER_TASK="RasterTask",e.IMAGE_DECODE_TASK="ImageDecodeTask",e.IMAGE_UPLOAD_TASK="ImageUploadTask",e.DECODE_IMAGE="Decode Image",e.DRAW_LAZY_PIXEL_REF="Draw LazyPixelRef",e.DECODE_LAZY_PIXEL_REF="Decode LazyPixelRef",e.GPU_TASK="GPUTask",e.RASTERIZE="Rasterize",e.EVENT_TIMING="EventTiming",e.OPTIMIZE_CODE="V8.OptimizeCode",e.CACHE_SCRIPT="v8.produceCache",e.CACHE_MODULE="v8.produceModuleCache",e.V8_SAMPLE="V8Sample",e.JIT_CODE_ADDED="JitCodeAdded",e.JIT_CODE_MOVED="JitCodeMoved",e.STREAMING_COMPILE_SCRIPT="v8.parseOnBackground",e.STREAMING_COMPILE_SCRIPT_WAITING="v8.parseOnBackgroundWaiting",e.STREAMING_COMPILE_SCRIPT_PARSING="v8.parseOnBackgroundParsing",e.BACKGROUND_DESERIALIZE="v8.deserializeOnBackground",e.FINALIZE_DESERIALIZATION="V8.FinalizeDeserialization",e.COMMIT_LOAD="CommitLoad",e.MARK_LOAD="MarkLoad",e.MARK_DOM_CONTENT="MarkDOMContent",e.MARK_FIRST_PAINT="firstPaint",e.MARK_FCP="firstContentfulPaint",e.MARK_LCP_CANDIDATE="largestContentfulPaint::Candidate",e.MARK_LCP_INVALIDATE=
"largestContentfulPaint::Invalidate",e.NAVIGATION_START="navigationStart",e.CONSOLE_TIME="ConsoleTime",e.USER_TIMING="UserTiming",e.INTERACTIVE_TIME="InteractiveTime",e.TIME_STAMP="TimeStamp",e.BEGIN_FRAME="BeginFrame",e.NEEDS_BEGIN_FRAME_CHANGED="NeedsBeginFrameChanged",e.BEGIN_MAIN_THREAD_FRAME="BeginMainThreadFrame",e.ACTIVATE_LAYER_TREE="ActivateLayerTree",e.DRAW_FRAME="DrawFrame",e.DROPPED_FRAME="DroppedFrame",e.FRAME_STARTED_LOADING="FrameStartedLoading",e.PIPELINE_REPORTER="PipelineReporter",e.SCREENSHOT="Screenshot",e.RESOURCE_WILL_SEND_REQUEST="ResourceWillSendRequest",e.RESOURCE_SEND_REQUEST="ResourceSendRequest",e.RESOURCE_RECEIVE_RESPONSE="ResourceReceiveResponse",e.RESOURCE_RECEIVE_DATA="ResourceReceivedData",e.RESOURCE_FINISH="ResourceFinish",e.RESOURCE_MARK_AS_CACHED="ResourceMarkAsCached",e.WEB_SOCKET_SEND_HANDSHAKE_REQUEST="WebSocketSendHandshakeRequest",e.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST="WebSocketReceiveHandshakeResponse",e.CPU_PROFILE="CpuProfile",e.PROFILE="Pro\
file",e.START_PROFILING="CpuProfiler::StartProfiling",e.PROFILE_CHUNK="ProfileChunk",e.UPDATE_COUNTERS="UpdateCounters",e.JS_SAMPLE="JSSample",e.ANIMATION="Animation",e.PARSE_AUTHOR_STYLE_SHEET="ParseAuthorStyleSheet",e.EMBEDDER_CALLBACK="EmbedderCallback",e.SET_LAYER_TREE_ID="SetLayerTreeId",e.TRACING_STARTED_IN_PAGE="TracingStartedInPage",e.TRACING_STARTED_IN_BROWSER="TracingStartedInBrowser",e.TRACING_SESSION_ID_FOR_WORKER="TracingSessionIdForWorker",e.LAZY_PIXEL_REF="LazyPixelRef",e.LAYER_TREE_HOST_IMPL_SNAPSHOT="cc::LayerTreeHostImpl",e.PICTURE_SNAPSHOT="cc::Picture",e.DISPLAY_ITEM_LIST_SNAPSHOT="cc::DisplayItemList",e.INPUT_LATENCY_MOUSE_MOVE="InputLatency::MouseMove",e.INPUT_LATENCY_MOUSE_WHEEL="InputLatency::MouseWheel",e.IMPL_SIDE_FLING="InputHandlerProxy::HandleGestureFling::started",e.SCHEDULE_POST_MESSAGE="SchedulePostMessage",e.HANDLE_POST_MESSAGE="HandlePostMessage",e.RENDER_FRAME_IMPL_CREATE_CHILD_FRAME="RenderFrameImpl::createChildFrame",e.LAYOUT_IMAGE_UNSIZED="LayoutIm\
ageUnsized",e.DOM_LOADING="domLoading",e.BEGIN_REMOTE_FONT_LOAD="BeginRemoteFontLoad",e.REMOTE_FONT_LOADED="RemoteFontLoaded",e.ANIMATION_FRAME="AnimationFrame",e.ANIMATION_FRAME_PRESENTATION="AnimationFrame::Presentation",e.SYNTHETIC_NETWORK_REQUEST="SyntheticNetworkRequest",e.USER_TIMING_MEASURE="UserTiming::Measure",e.LINK_PRECONNECT="LinkPreconnect"})(W||(W={}));Ene={Console:"blink.console",UserTiming:"blink.user_timing",Loading:"loading"};i(Tne,"isLegacyTimelineFrame");i(xne,"isRundownScriptCompiled");i(Sne,"isRundownScript");i(Cne,"isRundownScriptSource");i(kne,"isRundownScriptSourceLarge");i(Rne,"isAnyScriptSourceEvent")});var ie=g(()=>{d();AL();PL();LL();FL();UL();kf()});var vr={};x(vr,{addEventToEntityMapping:()=>mb,addNetworkRequestToEntityMapping:()=>pb,getEntityForEvent:()=>db,getEntityForUrl:()=>i3,getNonResolvedURL:()=>Rf,makeUpEntity:()=>s3});function db(e,t){let n=Rf(e);if(n)return i3(n,t)}function i3(e,t){let n=t.entityByUrlCache.get(e);if(n)return n;let r=Js.default.getEntity(e)??s3(t.createdEntityCache,e);return r&&t.entityByUrlCache.set(e,r),r}function Rf(e,t){if(v.isProfileCall(e))return e.callFrame.url;if(v.isSyntheticNetworkRequest(e))return e.args.data.url;if(v.isParseAuthorStyleSheetEvent(e)&&e.args)return e.args.data.stylesheetUrl;if(e.args?.data?.stackTrace&&e.args.data.stackTrace.length>0)return e.args.data.stackTrace[0].url;if(v.isParseHTML(e))return e.args.beginData.url;if(t){if(v.isDecodeImage(e)){let r=t.ImagePainting.paintImageForEvent.get(e);return r?Rf(r,t):null}if(v.isDrawLazyPixelRef(e)&&e.args?.LazyPixelRef){let r=t.ImagePainting.paintImageByDrawLazyPixelRef.get(e.args.LazyPixelRef);return r?Rf(r,t):null}}if(e.args?.data?.
url)return e.args.data.url;let n=e.args?.data?.requestId;if(t&&n){let r=t.NetworkRequests.byId.get(n)?.args.data.url;if(r)return r}return null}function s3(e,t){if(t.startsWith("chrome-extension:"))return Ine(e,t);if(!t.startsWith("http"))return;let n=Js.default.getRootDomain(t);if(!n)return;if(e.has(n))return e.get(n);let r={name:n,company:n,category:"",categories:[],domains:[n],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0,isUnrecognized:!0};return e.set(n,r),r}function _ne(e){return e.protocol+"//"+e.host}function Ine(e,t,n){let r=new URL(t),a=_ne(r),o=new URL(a).host,s=n||o,c=e.get(a);if(c)return c;let l={name:s,company:s,category:"Chrome Extension",homepage:"https://chromewebstore.google.com/detail/"+o,categories:[],domains:[a],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0};return e.set(a,l),l}function mb(e,t){if(t.entityByEvent.has(e))return;let n=db(e,t);if(!n)return;let r=t.eventsByEntity.get(n);r?r.push(e):t.eventsByEntity.set(n,[e]),t.entityByEvent.
set(e,n)}function pb(e,t,n){let r=db(e,t);if(!r)return;let a=[e,...Object.values(n).flat()],o=t.eventsByEntity.get(r);o?o.push(...a):t.eventsByEntity.set(r,a);for(let s of a)t.entityByEvent.set(s,r)}var _f=g(()=>{d();Jv();ie();i(db,"getEntityForEvent");i(i3,"getEntityForUrl");i(Rf,"getNonResolvedURL");i(s3,"makeUpEntity");i(_ne,"getChromeExtensionOrigin");i(Ine,"makeUpChromeExtensionEntity");i(mb,"addEventToEntityMapping");i(pb,"addNetworkRequestToEntityMapping")});var Wt={};x(Wt,{DEFAULT_COMPARATOR:()=>Lne,arrayDoesNotContainNullOrUndefined:()=>jne,binaryIndexOf:()=>Mne,intersectOrdered:()=>One,lowerBound:()=>l3,mergeOrdered:()=>Pne,nearestIndexFromBeginning:()=>Une,nearestIndexFromEnd:()=>Bne,removeElement:()=>Dne,sortRange:()=>Nne,upperBound:()=>Fne});function fb(e,t,n){let r=e[t];e[t]=e[n],e[n]=r}function Ane(e,t,n,r,a){let o=e[a];fb(e,r,a);let s=n;for(let c=n;c<r;++c)t(e[c],o)<0&&(fb(e,s,c),++s);return fb(e,r,s),s}function hb(e,t,n,r,a,o){if(r<=n)return;let s=Math.floor(Math.random()*(r-n))+n,c=Ane(e,t,n,r,s);a<c&&hb(e,t,n,c-1,a,o),c<o&&hb(e,t,c+1,r,a,o)}function Nne(e,t,n,r,a,o){return n===0&&r===e.length-1&&a===0&&o>=r?e.sort(t):hb(e,t,n,r,a,o),e}function c3(e,t,n,r){let a=[],o=0,s=0;for(;o<e.length&&s<t.length;){let c=n(e[o],t[s]);(r||!c)&&a.push(c<=0?e[o]:t[s]),c<=0&&o++,c>=0&&s++}if(r){for(;o<e.length;)a.push(e[o++]);for(;s<t.length;)a.push(t[s++])}return a}function l3(e,t,n,r,a){let o=r||0,s=a!==void 0?a:e.length;for(;o<s;){let c=o+s>>
1;n(t,e[c])>0?o=c+1:s=c}return s}function Fne(e,t,n,r,a){let o=r||0,s=a!==void 0?a:e.length;for(;o<s;){let c=o+s>>1;n(t,e[c])>=0?o=c+1:s=c}return s}function u3(e,t,n){let r=n==="END";if(e.length===0)return null;let a=0,o=e.length-1,s=0,c=!1,l=!1,u=0;do u=a+(o-a)/2,s=r?Math.ceil(u):Math.floor(u),c=t(e[s]),l=c===r,l?a=Math.min(o,s+(a===s?1:0)):o=Math.max(a,s+(o===s?-1:0));while(o!==a);return t(e[a])?a:null}function Une(e,t){return u3(e,t,"BEGINNING")}function Bne(e,t){return u3(e,t,"END")}function jne(e){return!e.includes(null)&&!e.includes(void 0)}var Dne,Mne,One,Pne,Lne,d3=g(()=>{d();Dne=i((e,t,n)=>{let r=e.indexOf(t);if(r===-1)return!1;if(n)return e.splice(r,1),!0;for(let a=r+1,o=e.length;a<o;++a)e[a]!==t&&(e[r++]=e[a]);return e.length=r,!0},"removeElement");i(fb,"swap");i(Ane,"partition");i(hb,"quickSortRange");i(Nne,"sortRange");Mne=i((e,t,n)=>{let r=l3(e,t,n);return r<e.length&&n(t,e[r])===0?r:-1},"binaryIndexOf");i(c3,"mergeOrIntersect");One=i((e,t,n)=>c3(e,t,n,!1),"intersectOrder\
ed"),Pne=i((e,t,n)=>c3(e,t,n,!0),"mergeOrdered"),Lne=i((e,t)=>e<t?-1:e>t?1:0,"DEFAULT_COMPARATOR");i(l3,"lowerBound");i(Fne,"upperBound");i(u3,"nearestIndex");i(Une,"nearestIndexFromBeginning");i(Bne,"nearestIndexFromEnd");i(jne,"arrayDoesNotContainNullOrUndefined")});var m3=g(()=>{d()});var p3=g(()=>{d()});var f3=g(()=>{d()});var h3=g(()=>{d()});var g3=g(()=>{d()});var y3=g(()=>{d()});var me={};x(me,{Multimap:()=>If,getWithDefault:()=>Vne,inverse:()=>Wne});function Vne(e,t,n){let r=e.get(t);return r==null&&(r=n(t),e.set(t,r)),r}var Wne,If,v3=g(()=>{d();Wne=i(function(e){let t=new If;for(let[n,r]of e.entries())t.set(r,n);return t},"inverse"),If=class{static{i(this,"Multimap")}map=new Map;set(t,n){let r=this.map.get(t);r||(r=new Set,this.map.set(t,r)),r.add(n)}get(t){return this.map.get(t)||new Set}has(t){return this.map.has(t)}hasValue(t,n){let r=this.map.get(t);return r?r.has(n):!1}get size(){return this.map.size}delete(t,n){let r=this.get(t);if(!r)return!1;let a=r.delete(n);return r.size||this.map.delete(t),a}deleteAll(t){this.map.delete(t)}keysArray(){return[...this.map.keys()]}keys(){return this.map.keys()}valuesArray(){let t=[];for(let n of this.map.values())t.push(...n.values());return t}clear(){this.map.clear()}};i(Vne,"getWithDefault")});var b3=g(()=>{d()});var ia={};x(ia,{aspectRatio:()=>Qne,clamp:()=>Yne,floor:()=>Jne,greatestCommonDivisor:()=>w3,mod:()=>Kne,toFixedIfFloating:()=>Xne,withThousandsSeparator:()=>ere});var Yne,Kne,Xne,Jne,w3,Zne,Qne,ere,E3=g(()=>{d();Yne=i((e,t,n)=>{let r=e;return e<t?r=t:e>n&&(r=n),r},"clamp"),Kne=i((e,t)=>(e%t+t)%t,"mod"),Xne=i(e=>{if(!e||Number.isNaN(Number(e)))return e;let t=Number(e);return t%1?t.toFixed(3):String(t)},"toFixedIfFloating"),Jne=i((e,t=0)=>{if(t>0&&t<1)return t=1/t,Math.floor(e/t)*t;let n=Math.pow(10,t);return Math.floor(e*n)/n},"floor"),w3=i((e,t)=>{for(e=Math.round(e),t=Math.round(t);t!==0;){let n=t;t=e%t,e=n}return e},"greatestCommonDivisor"),Zne=new Map([["8∶5","16∶10"]]),Qne=i((e,t)=>{let n=w3(e,t);n!==0&&(e/=n,t/=n);let r=`${e}∶${t}`;return Zne.get(r)||r},"aspectRatio"),ere=i(function(e){let t=String(e),n=/(\d+)(\d{3})/;for(;t.match(n);)t=t.replace(n,"$1 $2");return t},"withThousandsSeparator")});var T3=g(()=>{d()});var x3=g(()=>{d()});var S3=g(()=>{d()});var Df={};x(Df,{assertNever:()=>Zs,assertNotNullOrUndefined:()=>C3,assertUnhandled:()=>k3});function C3(e,t){if(e==null)throw new Error(`Expected given value to not be null/undefined but it was: ${e}${t?`
${t}`:""}`)}function Zs(e,t){throw new Error(t)}function k3(e){return e}var gb=g(()=>{d();i(C3,"assertNotNullOrUndefined");i(Zs,"assertNever");i(k3,"assertUnhandled")});var R3=g(()=>{d()});var _3=g(()=>{d()});var wt=g(()=>{d();d3();m3();p3();f3();h3();g3();y3();v3();b3();E3();T3();x3();S3();gb();R3();_3();gb()});var Ut={};x(Ut,{SyntheticEventsManager:()=>cu});var Af,cu,yb=g(()=>{d();Af=null,cu=class e{static{i(this,"SyntheticEventsManager")}#e=[];#t=[];static activate(t){Af=t}static createAndActivate(t){let n=new e(t);return e.activate(n),n}static getActiveManager(){if(!Af)throw new Error("Attempted to get a SyntheticEventsManager without initializing");return Af}static reset(){Af=null}static registerSyntheticEvent(t){try{return e.getActiveManager().#o(t)}catch{return t}}constructor(t){this.#t=t}#o(t){let n=this.#t.indexOf(t.rawSourceEvent);if(n<0)throw new Error("Attempted to register a synthetic event paired to an unknown raw event.");let r=t;return this.#e[n]=r,r}syntheticEventForRawEventIndex(t){let n=this.#e.at(t);if(!n)throw new Error(`Attempted to get a synthetic event from an unknown raw event index: ${t}`);return n}getSyntheticTraces(){return this.#e}getRawTraceEvents(){return this.#t}}});var j={};x(j,{boundsIncludeTimeRange:()=>hre,combineTraceWindowsMicro:()=>bb,eventIsInBounds:()=>wb,eventTimingsMicroSeconds:()=>uu,eventTimingsMilliSeconds:()=>ure,expandWindowByPercentOrToOneMillisecond:()=>lre,microToMilli:()=>Hi,microToSeconds:()=>sre,milliToMicro:()=>Do,secondsToMicro:()=>ire,secondsToMilli:()=>I3,timeStampForEventAdjustedByClosestNavigation:()=>cre,timestampIsInBounds:()=>gre,traceWindowFromEvent:()=>lu,traceWindowFromMicroSeconds:()=>vb,traceWindowFromMilliSeconds:()=>pre,traceWindowFromOverlay:()=>fre,traceWindowMicroSecondsToMilliSeconds:()=>mre,traceWindowMilliSeconds:()=>dre,windowFitsInsideBounds:()=>yre,windowsEqual:()=>vre});function cre(e,t,n,r){let a=e.ts-t.min;if(e.args?.data?.navigationId){let o=n.get(e.args.data.navigationId);o&&(a=e.ts-o.ts)}else if(e.args?.data?.frame){let o=Eb(e,e.args.data.frame,r);o&&(a=e.ts-o.ts)}return I.Micro(a)}function lre(e,t,n){let r=e.min-e.range*(n/100)/2,a=e.max+e.range*(n/100)/2;if(a-r<1e3){let s=(e.min+e.max)/2;r=s-500,
a=s+500}return r=Math.max(r,t.min),a=Math.min(a,t.max),{min:I.Micro(r),max:I.Micro(a),range:I.Micro(a-r)}}function uu(e){return{startTime:e.ts,endTime:e.ts+(e.dur??0),duration:e.dur||0}}function ure(e){return{startTime:e.ts/1e3,endTime:(e.ts+(e.dur??0))/1e3,duration:(e.dur||0)/1e3}}function dre(e){return{min:Hi(e.min),max:Hi(e.max),range:Hi(e.range)}}function mre(e){return{min:Hi(e.min),max:Hi(e.max),range:Hi(e.range)}}function pre(e,t){return{min:Do(e),max:Do(t),range:I.Micro(Do(t)-Do(e))}}function vb(e,t){return{min:e,max:t,range:t-e}}function lu(e){return{min:e.ts,max:e.ts+(e.dur??0),range:e.dur??0}}function fre(e){switch(e.type){case"ENTRY_LABEL":case"ENTRY_OUTLINE":case"ENTRY_SELECTED":return lu(e.entry);case"TIMESPAN_BREAKDOWN":{let t=e.sections.map(n=>n.bounds);return e.entry&&t.push(lu(e.entry)),bb(t)}case"CANDY_STRIPED_TIME_RANGE":case"TIME_RANGE":return structuredClone(e.bounds);case"ENTRIES_LINK":{let t=lu(e.entryFrom);if(!e.entryTo)return t;let n=lu(e.entryTo);return bb([t,
n])}case"TIMESTAMP_MARKER":return vb(e.timestamp,e.timestamp);case"TIMINGS_MARKER":return vb(e.adjustedTimestamp,e.adjustedTimestamp);case"BOTTOM_INFO_BAR":return null;default:Df.assertNever(e,`Unexpected overlay ${e}`)}}function bb(e){if(!e.length)return null;let t=structuredClone(e[0]);for(let n of e.slice(1))t.min=Math.min(t.min,n.min),t.max=Math.max(t.max,n.max);return t.range=t.max-t.min,t}function hre(e){let{min:t,max:n}=e.bounds,{min:r,max:a}=e.timeRange;return t<=a&&n>=r}function wb(e,t){let n=e.ts;return n<=t.max&&t.min<n+(e.dur??0)}function gre(e,t){return t>=e.min&&t<=e.max}function yre(e){return e.window.min>=e.bounds.min&&e.window.max<=e.bounds.max}function vre(e,t){return e.min===t.min&&e.max===t.max}var Do,I3,ire,Hi,sre,du=g(()=>{d();wt();ie();mu();Do=i(e=>I.Micro(e*1e3),"milliToMicro"),I3=i(e=>I.Milli(e*1e3),"secondsToMilli"),ire=i(e=>Do(I3(e)),"secondsToMicro"),Hi=i(e=>I.Milli(e/1e3),"microToMilli"),sre=i(e=>I.Seconds(e/1e3/1e3),"microToSeconds");i(cre,"timeStampForEve\
ntAdjustedByClosestNavigation");i(lre,"expandWindowByPercentOrToOneMillisecond");i(uu,"eventTimingsMicroSeconds");i(ure,"eventTimingsMilliSeconds");i(dre,"traceWindowMilliSeconds");i(mre,"traceWindowMicroSecondsToMilliSeconds");i(pre,"traceWindowFromMilliSeconds");i(vb,"traceWindowFromMicroSeconds");i(lu,"traceWindowFromEvent");i(fre,"traceWindowFromOverlay");i(bb,"combineTraceWindowsMicro");i(hre,"boundsIncludeTimeRange");i(wb,"eventIsInBounds");i(gre,"timestampIsInBounds");i(yre,"windowFitsInsideBounds");i(vre,"windowsEqual")});var re={};x(re,{VISIBLE_TRACE_EVENT_TYPES:()=>Hre,activeURLForFrameAtTime:()=>Tre,addEventToProcessThread:()=>wre,compareBeginAndEnd:()=>D3,createMatchedSortedSyntheticEvents:()=>Cre,eventContainsTimestamp:()=>jre,eventHasCategory:()=>Ure,eventTimeComparator:()=>xb,extractId:()=>A3,extractOriginFromTrace:()=>bre,extractSampleTraceId:()=>Mf,findNextEventAfterTimestamp:()=>Ore,findPreviousEventBeforeTimestamp:()=>Pre,findRecalcStyleEvents:()=>Mre,forEachEvent:()=>Lre,frameIDForEvent:()=>Dre,getNavigationForTraceEvent:()=>Eb,getStackTraceTopCallFrameInEventPayload:()=>_re,getSyntheticId:()=>Nf,getZeroIndexedLineAndColumnForEvent:()=>kre,getZeroIndexedStackTraceInEventPayload:()=>Rre,isExtensionUrl:()=>Nre,isMatchingCallFrame:()=>Bre,isTopLevelEvent:()=>N3,makeProfileCall:()=>fu,makeZeroBasedCallFrame:()=>pu,mergeEventsInOrder:()=>Sb,parseDevtoolsDetails:()=>Ere,sortTraceEventsInPlace:()=>qi,stackTraceInEvent:()=>Tb});function Tb(e){if(e.args?.data?.stackTrace)return e.args.data.stackTrace;
if(e.args?.stackTrace)return e.args.stackTrace;if(v.isRecalcStyle(e))return e.args.beginData?.stackTrace||null;if(v.isLayout(e))return e.args.beginData.stackTrace??null;if(v.isFunctionCall(e)){let t=e.args.data;if(!t)return null;let{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}=t;return r===void 0||s===void 0||n===void 0||o===void 0||a===void 0?null:[{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}]}if(v.isProfileCall(e)){let t=e.callFrame;if(!t)return null;let{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}=t;return r===void 0||s===void 0||n===void 0||o===void 0||a===void 0?null:[{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}]}return null}function bre(e){let t=new URL(e);return t?t.host.startsWith("www.")?t.host.slice(4):t.host:null}function wre(e,t){let{tid:n,pid:r}=e,a=t.get(r);a||(a=new Map);let o=a.get(n);o||(o=[]),o.push(e),a.set(e.tid,o),t.set(e.pid,a)}function D3(e,t,n,r){return e<t?-1:e>t?1:n>r?-1:n<r?1:0}function xb(e,t){
let n=e.ts,r=t.ts,a=e.dur??0,o=t.dur??0,s=n+a,c=r+o,l=D3(n,r,s,c);return l||(v.isProfileCall(e)&&!v.isProfileCall(t)?-1:v.isProfileCall(t)&&!v.isProfileCall(e)?1:0)}function qi(e){e.sort(xb)}function Sb(e,t){let n=[],r=0,a=0;for(;r<e.length&&a<t.length;){let o=e[r],s=t[a],c=xb(o,s);c<=0&&(n.push(o),r++),c===1&&(n.push(s),a++)}for(;r<e.length;)n.push(e[r++]);for(;a<t.length;)n.push(t[a++]);return n}function Ere(e,t){try{let n=JSON.parse(e);return!(t in n)||!Yn.isValidExtensionPayload(n[t])?null:n[t]}catch{return null}}function Eb(e,t,n){let r=n.get(t);if(!r||t==="")return null;let a=Wt.nearestIndexFromEnd(r,o=>o.ts<=e.ts);return a===null?null:r[a]}function A3(e){return e.id??e.id2?.global??e.id2?.local}function Tre(e,t,n){let r=n.get(e);if(!r)return null;for(let a of r.values())for(let o of a)if(!(o.window.min>t||o.window.max<t))return o.frame.url;return null}function fu(e,t,n,r,a,o){return{cat:"",name:"ProfileCall",nodeId:e.id,args:{},ph:v.Phase.COMPLETE,pid:a,tid:o,ts:r,dur:I.Micro(0),
callFrame:e.callFrame,sampleIndex:n,profileId:t}}function xre(e){qi(e);let t=[],n=new Map,r=new Map;for(let a of e){let o=Nf(a);if(o!==void 0){if(v.isPairableAsyncBegin(a)){let s=n.get(o)??[];s.push(a),n.set(o,s)}else if(v.isPairableAsyncInstant(a)){let s=r.get(o)??[];s.push(a),r.set(o,s)}else if(v.isPairableAsyncEnd(a)){let c=(n.get(o)??[]).pop();if(!c)continue;let l=r.get(o)??[],u=[];for(;l.length>0&&l[0].ts>=c.ts;){let p=l.pop();p&&u.push(p)}let m={begin:c,end:a,instant:u,syntheticId:o};t.push(m)}}}for(let[a,o]of n){let s=o.pop();if(!s)continue;let c=r.get(a);c?.length&&t.push({syntheticId:a,begin:s,end:null,instant:c})}return t}function Nf(e){let t=A3(e);return t&&`${e.cat}:${t}:${e.name}`}function Sre(e){let t=[];for(let n of e){let l=function(p){let f=p.instantEvents?p.instantEvents.some(y=>r===Nf(y)):!1,h=p.endEvent?r===Nf(p.endEvent):!1;return!!r&&(f||h)};i(l,"eventsArePairable");let r=n.syntheticId,a=n.begin,o=n.end,s=n.instant;if(!a||!(o||s))continue;let c={beginEvent:a,endEvent:o,
instantEvents:s};if(!l(c))continue;let u=o||a,m=cu.registerSyntheticEvent({rawSourceEvent:c.beginEvent,cat:u.cat,ph:u.ph,pid:u.pid,tid:u.tid,id:r,name:a.name,dur:I.Micro(u.ts-a.ts),ts:a.ts,args:{data:c}});m.dur<0||t.push(m)}return qi(t),t}function Cre(e){let t=xre(e);return Sre(t)}function kre(e){let t=Ire(e),{lineNumber:n,columnNumber:r}=t;switch(e.name){case v.Name.FUNCTION_CALL:case v.Name.EVALUATE_SCRIPT:case v.Name.COMPILE:case v.Name.CACHE_SCRIPT:return{lineNumber:typeof n=="number"?n-1:void 0,columnNumber:typeof r=="number"?r-1:void 0};case v.Name.PROFILE_CALL:{let a=e.callFrame;return{lineNumber:typeof n=="number"?a.lineNumber-1:void 0,columnNumber:typeof r=="number"?a.columnNumber-1:void 0}}default:return t}}function Rre(e){let t=Tb(e);if(!t)return null;switch(e.name){case v.Name.SCHEDULE_STYLE_RECALCULATION:case v.Name.INVALIDATE_LAYOUT:case v.Name.FUNCTION_CALL:case v.Name.LAYOUT:case v.Name.RECALC_STYLE:return t.map(pu);default:return v.isUserTiming(e)||Yn.isSyntheticExtensionEntry(
e)?t.map(pu):t}}function _re(e){let t=Tb(e);if(!t||t.length===0)return null;switch(e.name){case v.Name.SCHEDULE_STYLE_RECALCULATION:case v.Name.INVALIDATE_LAYOUT:case v.Name.FUNCTION_CALL:case v.Name.LAYOUT:case v.Name.RECALC_STYLE:return pu(t[0]);default:return v.isUserTiming(e)||Yn.isSyntheticExtensionEntry(e)?pu(t[0]):t[0]}}function pu(e){let t={...e};return t.lineNumber=e.lineNumber&&e.lineNumber-1,t.columnNumber=e.columnNumber&&e.columnNumber-1,t}function Ire(e){if(!e.args?.data)return{lineNumber:void 0,columnNumber:void 0};let t,n;return"lineNumber"in e.args.data&&typeof e.args.data.lineNumber=="number"&&(t=e.args.data.lineNumber),"columnNumber"in e.args.data&&typeof e.args.data.columnNumber=="number"&&(n=e.args.data.columnNumber),{lineNumber:t,columnNumber:n}}function Dre(e){return e.args&&"beginData"in e.args&&typeof e.args.beginData=="object"&&e.args.beginData!==null&&"frame"in e.args.beginData&&typeof e.args.beginData.frame=="string"?e.args.beginData.frame:e.args?.data?.frame?
e.args.data.frame:null}function N3(e){return e.cat.includes(Are)&&e.name===v.Name.RUN_TASK}function Nre(e){return e.startsWith("extensions:")||e.startsWith("chrome-extension:")}function M3(e,t){let n=Wt.upperBound(e,t,(r,a)=>r-a.ts)-1;for(;n>0&&!N3(e[n]);)n--;return Math.max(n,0)}function Mre(e,t,n){let r=[],a=M3(e,t);for(let o=a;o<e.length;o++){let s=e[o];v.isRecalcStyle(s)&&(s.ts>=(n||1/0)||r.push(s))}return r}function Ore(e,t){let n=Wt.nearestIndexFromBeginning(e,r=>t<r.ts);return n===null?null:e[n]}function Pre(e,t){let n=Wt.nearestIndexFromEnd(e,r=>r.ts<t);return n===null?null:e[n]}function Lre(e,t){let n=t.startTime??I.Micro(0),r=t.endTime||I.Micro(1/0),a=t.ignoreAsyncEvents!==!1,o=[],s=M3(e,n);for(let c=s;c<e.length;c++){let l=e[c],u=uu(l);if(u.endTime<n)continue;if(u.startTime>r)break;if(a&&v.isPhaseAsync(l.ph)||v.isFlowPhase(l.ph))continue;let p=o.at(-1),f=p?uu(p).endTime:null;for(;p&&f&&f<=u.startTime;)o.pop(),t.onEndEvent(p),p=o.at(-1),f=p?uu(p).endTime:null;t.eventFilter&&!t.
eventFilter(l)||(u.duration?(t.onStartEvent(l),o.push(l)):t.onInstantEvent&&t.onInstantEvent(l))}for(;o.length;){let c=o.pop();c&&t.onEndEvent(c)}}function Ure(e,t){let n=Fre.get(e.cat);return n||(n=new Set(e.cat.split(",")||[])),n.has(t)}function Bre(e,t){return e.columnNumber===t.columnNumber&&e.lineNumber===t.lineNumber&&String(e.scriptId)===t.scriptId&&e.url===t.url&&e.functionName===t.functionName}function jre(e,t){return e.ts<=t&&e.ts+(e.dur||0)>=t}function Mf(e){return e.args?"beginData"in e.args?e.args.beginData.sampleTraceId??null:e.args?.sampleTraceId??e.args?.data?.sampleTraceId??null:null}var Are,Fre,Hre,mu=g(()=>{d();wt();ie();yb();du();i(Tb,"stackTraceInEvent");i(bre,"extractOriginFromTrace");i(wre,"addEventToProcessThread");i(D3,"compareBeginAndEnd");i(xb,"eventTimeComparator");i(qi,"sortTraceEventsInPlace");i(Sb,"mergeEventsInOrder");i(Ere,"parseDevtoolsDetails");i(Eb,"getNavigationForTraceEvent");i(A3,"extractId");i(Tre,"activeURLForFrameAtTime");i(fu,"makeProfileCall");
i(xre,"matchEvents");i(Nf,"getSyntheticId");i(Sre,"createSortedSyntheticEvents");i(Cre,"createMatchedSortedSyntheticEvents");i(kre,"getZeroIndexedLineAndColumnForEvent");i(Rre,"getZeroIndexedStackTraceInEventPayload");i(_re,"getStackTraceTopCallFrameInEventPayload");i(pu,"makeZeroBasedCallFrame");i(Ire,"getRawLineAndColumnNumbersForEvent");i(Dre,"frameIDForEvent");Are="disabled-by-default-devtools.timeline";i(N3,"isTopLevelEvent");i(Nre,"isExtensionUrl");i(M3,"topLevelEventIndexEndingAfter");i(Mre,"findRecalcStyleEvents");i(Ore,"findNextEventAfterTimestamp");i(Pre,"findPreviousEventBeforeTimestamp");i(Lre,"forEachEvent");Fre=new Map;i(Ure,"eventHasCategory");i(Bre,"isMatchingCallFrame");i(jre,"eventContainsTimestamp");i(Mf,"extractSampleTraceId");Hre=new Set([v.Name.ABORT_POST_TASK_CALLBACK,v.Name.ANIMATION,v.Name.ASYNC_TASK,v.Name.BACKGROUND_DESERIALIZE,v.Name.CACHE_MODULE,v.Name.CACHE_SCRIPT,v.Name.CANCEL_ANIMATION_FRAME,v.Name.CANCEL_IDLE_CALLBACK,v.Name.COMMIT,v.Name.COMPILE_CODE,v.
Name.COMPILE_MODULE,v.Name.COMPILE,v.Name.COMPOSITE_LAYERS,v.Name.COMPUTE_INTERSECTION,v.Name.CONSOLE_TIME,v.Name.CPPGC_SWEEP,v.Name.CRYPTO_DO_DECRYPT_REPLY,v.Name.CRYPTO_DO_DECRYPT,v.Name.CRYPTO_DO_DIGEST_REPLY,v.Name.CRYPTO_DO_DIGEST,v.Name.CRYPTO_DO_ENCRYPT_REPLY,v.Name.CRYPTO_DO_ENCRYPT,v.Name.CRYPTO_DO_SIGN_REPLY,v.Name.CRYPTO_DO_SIGN,v.Name.CRYPTO_DO_VERIFY_REPLY,v.Name.CRYPTO_DO_VERIFY,v.Name.DECODE_IMAGE,v.Name.EMBEDDER_CALLBACK,v.Name.EVALUATE_MODULE,v.Name.EVALUATE_SCRIPT,v.Name.EVENT_DISPATCH,v.Name.EVENT_TIMING,v.Name.FINALIZE_DESERIALIZATION,v.Name.FIRE_ANIMATION_FRAME,v.Name.FIRE_IDLE_CALLBACK,v.Name.FUNCTION_CALL,v.Name.GC_COLLECT_GARBARGE,v.Name.GC,v.Name.GPU_TASK,v.Name.HANDLE_POST_MESSAGE,v.Name.HIT_TEST,v.Name.JS_SAMPLE,v.Name.LAYERIZE,v.Name.LAYOUT,v.Name.MAJOR_GC,v.Name.MINOR_GC,v.Name.OPTIMIZE_CODE,v.Name.PAINT_SETUP,v.Name.PAINT,v.Name.PARSE_AUTHOR_STYLE_SHEET,v.Name.PARSE_HTML,v.Name.PRE_PAINT,v.Name.PROFILE_CALL,v.Name.PROGRAM,v.Name.RASTER_TASK,v.Name.REQUEST_ANIMATION_FRAME,
v.Name.REQUEST_IDLE_CALLBACK,v.Name.RESOURCE_FINISH,v.Name.RESOURCE_RECEIVE_DATA,v.Name.RESOURCE_RECEIVE_RESPONSE,v.Name.RESOURCE_SEND_REQUEST,v.Name.RESOURCE_WILL_SEND_REQUEST,v.Name.RUN_MICROTASKS,v.Name.RUN_POST_TASK_CALLBACK,v.Name.RUN_TASK,v.Name.SCHEDULE_POST_MESSAGE,v.Name.SCHEDULE_POST_TASK_CALLBACK,v.Name.SCHEDULE_STYLE_RECALCULATION,v.Name.SCROLL_LAYER,v.Name.START_PROFILING,v.Name.STREAMING_COMPILE_SCRIPT_PARSING,v.Name.STREAMING_COMPILE_SCRIPT_WAITING,v.Name.STREAMING_COMPILE_SCRIPT,v.Name.SYNTHETIC_LAYOUT_SHIFT_CLUSTER,v.Name.SYNTHETIC_LAYOUT_SHIFT,v.Name.TIME_STAMP,v.Name.TIMER_FIRE,v.Name.TIMER_INSTALL,v.Name.TIMER_REMOVE,v.Name.UPDATE_LAYER_TREE,v.Name.RECALC_STYLE,v.Name.USER_TIMING,v.Name.V8_CONSOLE_RUN_TASK,v.Name.WASM_CACHED_MODULE,v.Name.WASM_COMPILED_MODULE,v.Name.WASM_MODULE_CACHE_HIT,v.Name.WASM_MODULE_CACHE_INVALID,v.Name.WASM_STREAM_FROM_RESPONSE_CALLBACK,v.Name.WEB_SOCKET_CREATE,v.Name.WEB_SOCKET_DESTROY,v.Name.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST,v.Name.WEB_SOCKET_RECEIVE,
v.Name.WEB_SOCKET_SEND_HANDSHAKE_REQUEST,v.Name.WEB_SOCKET_SEND,v.Name.XHR_LOAD,v.Name.XHR_READY_STATE_CHANGED])});var La={};x(La,{canBuildTreesFromEvents:()=>_b,makeEmptyTraceEntryNode:()=>L3,makeEmptyTraceEntryTree:()=>P3,makeTraceEntryNodeId:()=>O3,treify:()=>kb,walkEntireTree:()=>zre,walkTreeFromEntry:()=>qre});function kb(e,t){let n=new Map,r=[];Cb=-1;let a=P3();for(let o=0;o<e.length;o++){let s=e[o];if(t&&!t.filter.has(s.name))continue;let c=s.dur||0,l=O3(),u=L3(s,l);if(r.length===0){a.roots.add(u),u.selfTime=I.Micro(c),r.push(u),a.maxDepth=Math.max(a.maxDepth,r.length),n.set(s,u);continue}let m=r.at(-1);if(m===void 0)throw new Error("Impossible: no parent node found in the stack");let p=m.entry,f=s.ts,h=p.ts,y=p.dur||0,b=f+c,w=h+y;if(f<h)throw new Error("Impossible: current event starts before the parent event");if(f>=w){r.pop(),o--,Cb--;continue}b>w||(u.depth=r.length,u.parent=m,m.children.push(u),u.selfTime=I.Micro(c),m.selfTime!==void 0&&(m.selfTime=I.Micro(m.selfTime-(s.dur||0))),r.push(u),a.maxDepth=Math.max(a.maxDepth,r.length),n.set(s,u))}return{tree:a,entryToNode:n}}function qre(e,t,n,r){
let a=e.get(t);a&&Rb(e,a,n,r)}function zre(e,t,n,r,a,o){for(let s of t.roots)Rb(e,s,n,r,a,o)}function Rb(e,t,n,r,a,o){if(!(a&&!Gre(t,a))&&!(typeof o<"u"&&I.Micro(t.entry.ts+I.Micro(t.entry.dur??0))<o)){n(t.entry);for(let s of t.children)Rb(e,s,n,r,a,o);r(t.entry)}}function Gre(e,t){return wb(e.entry,t)}function _b(e){let t=[];for(let n of e){let r=n.ts,a=n.ts+(n.dur??0),o=t.at(-1);if(o===void 0){t.push(n);continue}let s=o.ts+(o.dur??0);for(;t.length&&r>=s&&(t.pop(),o=t.at(-1),o!==void 0);)s=o.ts+(o.dur??0);if(t.length&&a>s)return!1;t.push(n)}return!0}var Cb,O3,P3,L3,Ib=g(()=>{d();ie();du();Cb=0,O3=i(()=>++Cb,"makeTraceEntryNodeId"),P3=i(()=>({roots:new Set,maxDepth:0}),"makeEmptyTraceEntryTree"),L3=i((e,t)=>({entry:e,id:t,parent:null,children:[],depth:0}),"makeEmptyTraceEntryNode");i(kb,"treify");i(qre,"walkTreeFromEntry");i(zre,"walkEntireTree");i(Rb,"walkTreeByNode");i(Gre,"treeNodeIsInWindow");i(_b,"canBuildTreesFromEvents")});var hu={};x(hu,{buildTrackDataFromExtensionEntries:()=>Wre});function Wre(e,t,n){let r=new Map;for(let a of e){let o=a.devtoolsObj.trackGroup||`track-name-${a.devtoolsObj.track}`,s=me.getWithDefault(r,o,()=>({name:a.devtoolsObj.trackGroup||a.devtoolsObj.track,isTrackGroup:!!a.devtoolsObj.trackGroup,entriesByTrack:{[a.devtoolsObj.track]:[]}}));s.entriesByTrack[a.devtoolsObj.track]||(s.entriesByTrack[a.devtoolsObj.track]=[]),s.entriesByTrack[a.devtoolsObj.track].push(a)}for(let a of r.values()){for(let o of Object.values(a.entriesByTrack))if(qi(o),_b(o))for(let[s,c]of kb(o).entryToNode)n.set(s,c);t.push(a)}return{extensionTrackData:t,entryToNode:n}}var F3=g(()=>{d();wt();mu();Ib();i(Wre,"buildTrackDataFromExtensionEntries")});var In={};x(In,{CACHEABLE_STATUS_CODES:()=>Xre,NON_NETWORK_SCHEMES:()=>Zre,STATIC_RESOURCE_TYPES:()=>Jre,isSyntheticNetworkRequestEventRenderBlocking:()=>$re,isSyntheticNetworkRequestHighPriority:()=>Kre,isSyntheticNetworkRequestLocalhost:()=>tae,parseCacheControl:()=>Qre});function $re(e){return!Vre.has(e.args.data.renderBlocking)}function Kre(e){return Yre.has(e.args.data.priority)}function Qre(e){if(!e)return null;let t=e.split(",").map(r=>r.trim()),n={};for(let r of t){let[a,o]=r.split("=").map(s=>s.trim());switch(a){case"max-age":{let s=parseInt(o,10);isNaN(s)||(n["max-age"]=s);break}case"no-cache":n["no-cache"]=!0;break;case"no-store":n["no-store"]=!0;break;case"must-revalidate":n["must-revalidate"]=!0;break;case"private":n.private=!0;break;default:break}}return n}function tae(e){try{let t=new URL(e.args.data.url).hostname;return eae.includes(t)||t.endsWith(".localhost")}catch{return!1}}var Vre,Yre,Xre,Jre,Zre,eae,U3=g(()=>{d();Vre=new Set(["non_blocking","dynamically_injected_no\
n_blocking","potentially_blocking"]);i($re,"isSyntheticNetworkRequestEventRenderBlocking");Yre=new Set(["VeryHigh","High","Medium"]);i(Kre,"isSyntheticNetworkRequestHighPriority");Xre=new Set([200,203,206]),Jre=new Set(["Font","Image","Media","Script","Stylesheet"]),Zre=["blob","data","intent","file","filesystem","chrome-extension"];i(Qre,"parseCacheControl");eae=["localhost","127.0.0.1"];i(tae,"isSyntheticNetworkRequestLocalhost")});var gu={};x(gu,{SamplesIntegrator:()=>Ua});var Fa,Ua,Db=g(()=>{d();ie();du();mu();Ua=class{static{i(this,"SamplesIntegrator")}#e=[];#t=[];#o;#n;#a=[];#c=!1;#r;#i=new Map;#l;#s;jsSampleEvents=[];constructor(t,n,r,a,o){this.#r=t,this.#n=a,this.#o=r,this.#l=o||oa.defaults(),this.#s=n}buildProfileCalls(t){let n=Sb(t,this.callsFromProfileSamples()),r=[];for(let a=0;a<n.length;a++){let o=n[a];if(o.ph===v.Phase.INSTANT&&!Mf(o))continue;if(r.length===0){if(v.isProfileCall(o)){this.#p(o);continue}r.push(o),this.#u(o);continue}let s=r.at(-1);if(s===void 0)continue;let c=o.ts,l=s.ts,u=s.dur||0,m=l+u;if(c>=m){this.#d(s),r.pop(),a--;continue}if(v.isProfileCall(o)){this.#p(o,s);continue}this.#u(o),r.push(o)}for(;r.length;){let a=r.pop();a&&this.#d(a)}return qi(this.jsSampleEvents),this.#e}#u(t){(t.name===v.Name.RUN_MICROTASKS||t.name===v.Name.RUN_TASK)&&(this.#a=[],this.#g(0,t.ts),this.#c=!1),this.#c&&(this.#g(this.#a.pop()||0,t.ts),this.#c=!1),this.#h(t),this.#a.push(this.#t.length)}#p(t,n){if(n&&v.
isJSInvocationEvent(n)||this.#c)this.#h(t);else if(v.isProfileCall(t)&&this.#t.length===0){this.#c=!0;let r=this.#t.length;this.#h(t),this.#a.push(r)}}#d(t){let n=I.Micro(t.ts+(t.dur??0));this.#g(this.#a.pop()||0,n)}callsFromProfileSamples(){let t=this.#r.samples,n=this.#r.timestamps;if(!t)return[];let r=[],a;for(let o=0;o<t.length;o++){let s=this.#r.nodeByIndex(o),c=Do(I.Milli(n[o]));if(!s)continue;let l=fu(s,this.#s,o,c,this.#o,this.#n);if(r.push(l),this.#l.debugMode){let u=this.#r.traceIds?.[o];this.jsSampleEvents.push(this.#y(l,c,u))}if(s.id===this.#r.gcNode?.id&&a){this.#i.set(l,a);continue}a=s}return r}#m(t,n){let r=this.#r.nodeById(t.nodeId),a=r?.id===this.#r.gcNode?.id;if(a&&(r=this.#i.get(t)||null),!r)return[];let o=new Array(r.depth+1+Number(a)),s=o.length-1;for(a&&(o[s--]=t);r;)o[s--]=fu(r,t.profileId,t.sampleIndex,n??t.ts,this.#o,this.#n),r=r.parent;return o}#f(t,n){let r=this.#r.traceIds?.[t],a=r&&this.#r.nodeById(r),o=a&&fu(a,this.#s,-1,n,this.#o,this.#n);return o?(this.#l.
debugMode&&this.jsSampleEvents.push(this.#y(o,n,t)),this.#m(o)):null}#h(t){let n=this.#t;v.isProfileCall(t)&&(n=this.#m(t));let r=Mf(t),a=r&&this.#f(r,t.ts);a&&(n=a),Fa.filterStackFrames(n,this.#l);let o=t.ts+(t.dur||0),s=Math.min(n.length,this.#t.length),c;for(c=this.#a.at(-1)||0;c<s;++c){let l=n[c].callFrame,u=this.#t[c].callFrame;if(!Fa.framesAreEqual(l,u))break;this.#t[c].dur=I.Micro(Math.max(this.#t[c].dur||0,o-this.#t[c].ts))}for(this.#g(c,t.ts);c<n.length;++c){let l=n[c];l.nodeId===this.#r.programNode?.id||l.nodeId===this.#r.root?.id||l.nodeId===this.#r.idleNode?.id||l.nodeId===this.#r.gcNode?.id||(this.#t.push(l),this.#e.push(l))}}#g(t,n){if(this.#a.length){let r=this.#a.at(-1);r&&t<r&&(console.error(`Child stack is shallower (${t}) than the parent stack (${r}) at ${n}`),t=r)}this.#t.length<t&&(console.error(`Trying to truncate higher than the current stack size at ${n}`),t=this.#t.length);for(let r=0;r<this.#t.length;++r)this.#t[r].dur=I.Micro(Math.max(n-this.#t[r].ts,0));this.#t.
length=t}#y(t,n,r){return{name:v.Name.JS_SAMPLE,cat:"devtools.timeline",args:{data:{traceId:r,stackTrace:this.#m(t).map(o=>o.callFrame)}},ph:v.Phase.INSTANT,ts:n,dur:I.Micro(0),pid:this.#o,tid:this.#n}}static framesAreEqual(t,n){return t.scriptId===n.scriptId&&t.functionName===n.functionName&&t.lineNumber===n.lineNumber}static showNativeName(t,n){return n&&!!Fa.nativeGroup(t)}static nativeGroup(t){return t.startsWith("Parse")?Fa.NativeGroups.PARSE:t.startsWith("Compile")||t.startsWith("Recompile")?Fa.NativeGroups.COMPILE:null}static isNativeRuntimeFrame(t){return t.url==="native V8Runtime"}static filterStackFrames(t,n){if(n.showAllEvents)return;let a=null,o=0;for(let s=0;s<t.length;++s){let c=t[s].callFrame,l=Fa.isNativeRuntimeFrame(c);if(l&&!Fa.showNativeName(c.functionName,n.includeRuntimeCallStats))continue;let u=l?Fa.nativeGroup(c.functionName):null;a&&a===u||(a=u,t[o++]=t[s])}t.length=o}static createFakeTraceFromCpuProfile(t,n){return t?{traceEvents:[{cat:"disabled-by-default-devt\
ools.timeline",name:v.Name.CPU_PROFILE,ph:v.Phase.COMPLETE,pid:v.ProcessID(1),tid:n,ts:I.Micro(t.startTime),dur:I.Micro(t.endTime-t.startTime),args:{data:{cpuProfile:t}},id:"0x1"}],metadata:{dataOrigin:ji.DataOrigin.CPU_PROFILE}}:{traceEvents:[],metadata:{}}}static extractCpuProfileFromFakeTrace(t){let r=t.find(a=>v.isSyntheticCpuProfile(a))?.args.data.cpuProfile;if(!r)throw new Error("Missing cpuProfile data");return r}};Fa=Ua;(function(e){let t;(function(n){n.COMPILE="Compile",n.PARSE="Parse"})(t=e.NativeGroups||(e.NativeGroups={}))})(Ua||(Ua={}))});var Ee={};x(Ee,{Extensions:()=>hu,Network:()=>In,SamplesIntegrator:()=>gu,SyntheticEvents:()=>Ut,Timing:()=>j,Trace:()=>re,TreeHelpers:()=>La});var Se=g(()=>{d();F3();U3();Db();yb();du();mu();Ib()});var Pb={};x(Pb,{data:()=>iae,deps:()=>sae,finalize:()=>oae,handleEvent:()=>aae,handleUserConfig:()=>rae,reset:()=>nae});function B3(e){return`${e.pid}-${e.tid}`}function nae(){Of=new Map,Pf=new Map,Nb=[],Mb=new Map,Ab=new Map,Ob=!1}function rae(e){Ob=e.enableAnimationsFrameHandler}function aae(e){if(Ob)if(v.isAnimationFrameAsyncStart(e)){let t=B3(e),n=Of.get(t)??[];n.push(e),Of.set(t,n)}else if(v.isAnimationFrameAsyncEnd(e)){let t=B3(e),n=Pf.get(t)??[];n.push(e),Pf.set(t,n)}else v.isAnimationFramePresentation(e)&&e.args?.id&&Ab.set(e.args.id,e)}async function oae(){for(let[e,t]of Of.entries()){let n=Pf.get(e);if(n){re.sortTraceEventsInPlace(t),re.sortTraceEventsInPlace(n);for(let r=0;r<t.length;r++){let a=n.at(r);if(!a)break;let o=t[r],s=Ut.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:o,...o,dur:I.Micro(a.ts-o.ts),args:{data:{beginEvent:o,endEvent:a}}});Nb.push(s);let c=o.args?.id;if(c){let l=Ab.get(c);l&&Mb.set(s,l)}}}}}function iae(){return{animationFrames:Nb,presentationForFrame:Mb}}
function sae(){return["Meta"]}var Of,Pf,Ab,Nb,Mb,Ob,j3=g(()=>{d();Se();ie();i(B3,"threadKey");Of=new Map,Pf=new Map,Ab=new Map,Nb=[],Mb=new Map;i(nae,"reset");Ob=!1;i(rae,"handleUserConfig");i(aae,"handleEvent");i(oae,"finalize");i(iae,"data");i(sae,"deps")});var Ub={};x(Ub,{data:()=>dae,finalize:()=>uae,handleEvent:()=>lae,reset:()=>cae});function cae(){Lb=[],Fb=[]}function lae(e){if(v.isAnimation(e)){Lb.push(e);return}}async function uae(){let e=re.createMatchedSortedSyntheticEvents(Lb);Fb.push(...e)}function dae(){return{animations:Fb}}var Lb,Fb,H3=g(()=>{d();Se();ie();Lb=[],Fb=[];i(cae,"reset");i(lae,"handleEvent");i(uae,"finalize");i(dae,"data")});var Wb={};x(Wb,{data:()=>vu,finalize:()=>yae,handleEvent:()=>pae,reset:()=>mae});function mae(){Gb=[],qb=[],zb=[],yu=new Map,jb=new Map,Hb=new Map}function pae(e){if(v.isFlowPhaseEvent(e)){qb.push(e);return}zb.push(e)}function fae(e){let t=jb.get(e.ts)?.get(e.pid)?.get(e.tid)?.get(e.cat);if(!t)return;let{flows:n,bindingParsed:r}=t;if(!r){for(let a of n)me.getWithDefault(Hb,a,()=>new Map).set(e.ts,e);t.bindingParsed=!0}}function hae(e){let t=gae(e);switch(e.ph){case v.Phase.FLOW_START:{let n={flowId:e.id,times:new Map([[e.ts,void 0]])};yu.set(t,e.id),Bb(e,n.flowId);return}case v.Phase.FLOW_STEP:{let n=yu.get(t);if(n===void 0)return;Bb(e,n);return}case v.Phase.FLOW_END:{let n=yu.get(t);if(n===void 0)return;Bb(e,n),yu.delete(t)}}}function Bb(e,t){let n=me.getWithDefault(jb,e.ts,()=>new Map),r=me.getWithDefault(n,e.pid,()=>new Map),a=me.getWithDefault(r,e.tid,()=>new Map);me.getWithDefault(a,e.cat,()=>({flows:new Set,bindingParsed:!1})).flows.add(t)}function gae(e){return`${e.cat}${q3}${e.
name}${q3}${e.id}`}async function yae(){qb.forEach(hae),zb.forEach(fae),Gb=[...Hb.values()].map(e=>[...e.values()]).map(e=>e.filter(t=>t!==void 0)).filter(e=>e.length>1)}function vu(){return{flows:Gb}}var yu,jb,Hb,qb,zb,Gb,q3,Lf=g(()=>{d();wt();ie();yu=new Map,jb=new Map,Hb=new Map,qb=[],zb=[],Gb=[],q3="-$-";i(mae,"reset");i(pae,"handleEvent");i(fae,"processNonFlowEvent");i(hae,"processFlowEvent");i(Bb,"addFlowIdToEventBinding");i(gae,"flowGroupTokenForFlowPhaseEvent");i(yae,"finalize");i(vu,"data")});var Jb={};x(Jb,{data:()=>bu,finalize:()=>Eae,handleEvent:()=>bae,reset:()=>vae});function vae(){Vb=new Map,$b=new Map,Yb=new Map,Kb=new Map,Xb=new Map}function bae(e){if(v.isAuctionWorkletRunningInProcess(e)){Vb.set(e.args.data.pid,e);return}if(v.isAuctionWorkletDoneWithProcess(e)){$b.set(e.args.data.pid,e);return}if(v.isThreadName(e)){if(e.args.name==="auction_worklet.CrUtilityMain"){Kb.set(e.pid,e);return}e.args.name==="AuctionV8HelperThread"&&Xb.set(e.pid,e)}}function wae(e){switch(e){case"seller":return v.AuctionWorkletType.SELLER;case"bidder":return v.AuctionWorkletType.BIDDER;default:return v.AuctionWorkletType.UNKNOWN}}function z3(e){return Ut.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:e,name:"SyntheticAuctionWorklet",s:v.Scope.THREAD,cat:e.cat,tid:e.tid,ts:e.ts,ph:v.Phase.INSTANT,pid:e.args.data.pid,host:e.args.data.host,target:e.args.data.target,type:wae(e.args.data.type)})}async function Eae(){for(let[e,t]of Kb){let n=Xb.get(e);if(!n)continue;let r=Vb.get(e),
a=$b.get(e),o=null;r?(o={...z3(r),args:{data:{runningInProcessEvent:r,utilityThread:t,v8HelperThread:n}}},a&&(o.args.data.doneWithProcessEvent=a)):a&&(o={...z3(a),args:{data:{doneWithProcessEvent:a,utilityThread:t,v8HelperThread:n}}},r&&(o.args.data.runningInProcessEvent=r)),o!==null&&Yb.set(e,o)}}function bu(){return{worklets:Yb}}var Vb,$b,Yb,Kb,Xb,Ff=g(()=>{d();Se();ie();Vb=new Map,$b=new Map,Yb=new Map,Kb=new Map,Xb=new Map;i(vae,"reset");i(bae,"handleEvent");i(wae,"workletType");i(z3,"makeSyntheticEventBase");i(Eae,"finalize");i(bu,"data")});var ow={};x(ow,{data:()=>ht,finalize:()=>kae,handleEvent:()=>Cae,reset:()=>Sae});function W3(){return{min:I.Micro(Number.POSITIVE_INFINITY),max:I.Micro(Number.NEGATIVE_INFINITY),range:I.Micro(Number.POSITIVE_INFINITY)}}function Sae(){ec=new Map,Qs=new Map,Tu=new Map,rw=new Map,Su=[],ew=v.ProcessID(-1),tw=v.ThreadID(-1),nw=v.ProcessID(-1),Uf=v.ThreadID(-1),Bf=null,jf=new Set,aw=new Map,xu=new Map,Qb=new Map,ir=W3(),Hf=I.Micro(-1),qf=!0}function Zb(e,t){me.getWithDefault(Qb,t.processId,()=>new Map).set(t.frame,t);let r=me.getWithDefault(xu,t.frame,()=>new Map),a=me.getWithDefault(r,t.processId,()=>[]),o=a.at(-1);o&&o.frame.url===t.url||a.push({frame:t,window:{min:e.ts,max:I.Micro(0),range:I.Micro(0)}})}function Cae(e){if(qf&&xae.has(e.name)&&(qf=!1),v.isProcessName(e)&&rw.set(e.pid,e),e.ts!==0&&!e.name.endsWith("::UMA")&&Tae.has(e.ph)){ir.min=I.Micro(Math.min(e.ts,ir.min));let t=e.dur??I.Micro(0);ir.max=I.Micro(Math.max(e.ts+t,ir.max))}if(v.isProcessName(e)&&(e.args.name==="Browser"||e.args.
name==="HeadlessBrowser")){ew=e.pid;return}if(v.isProcessName(e)&&(e.args.name==="Gpu"||e.args.name==="GPU Process")){nw=e.pid;return}if(v.isThreadName(e)&&e.args.name==="CrGpuMain"){Uf=e.tid;return}if(v.isThreadName(e)&&e.args.name==="CrBrowserMain"&&(tw=e.tid),v.isMainFrameViewport(e)&&Bf===null){let t=e.args.data.viewport_rect,n=t[0],r=t[1],a=t[2],o=t[5];Bf={x:n,y:r,width:a,height:o},G3=e.args.data.dpr}if(v.isTracingStartedInBrowser(e)){if(Hf=e.ts,!e.args.data)throw new Error("No frames found in trace data");for(let t of e.args.data.frames??[]){Zb(e,t),t.parent||jf.add(t.processId);let n="isInPrimaryMainFrame"in t,r="isOutermostMainFrame"in t;n&&r?t.isInPrimaryMainFrame&&t.isOutermostMainFrame&&(wu=t.frame,Eu=t.url):r?t.isOutermostMainFrame&&(wu=t.frame,Eu=t.url):!t.parent&&t.url&&(wu=t.frame,Eu=t.url)}return}if(v.isFrameCommittedInBrowser(e)){let t=e.args.data;if(!t||(Zb(e,t),t.parent))return;jf.add(t.processId);return}if(v.isCommitLoad(e)){let t=e.args.data;if(!t)return;let{frame:n,
name:r,url:a}=t;Zb(e,{processId:e.pid,frame:n,name:r,url:a});return}if(v.isThreadName(e)){me.getWithDefault(aw,e.pid,()=>new Map).set(e.tid,e);return}if(v.isNavigationStart(e)&&e.args.data){let t=e.args.data.navigationId;if(Qs.has(t))return;Qs.set(t,e),Tu.set(t,e.args.data.documentLoaderURL);let n=e.args.frame,r=ec.get(n)||[];r.push(e),ec.set(n,r),n===wu&&Su.push(e);return}if(v.isResourceSendRequest(e)){if(e.args.data.resourceType!=="Document")return;let t=e.args.data.requestId;if(!Qs.get(t))return;Tu.set(t,e.args.data.url);return}if(v.isDidCommitSameDocumentNavigation(e)){if(e.args.render_frame_host.frame_type!=="PRIMARY_MAIN_FRAME")return;let n=Su.at(-1)?.args.data?.navigationId??"";Tu.set(n,e.args.url);return}}async function kae(){Hf>=0&&(ir.min=Hf),ir.range=I.Micro(ir.max-ir.min);for(let[,n]of xu){let r=[...n.values()].flat().sort((a,o)=>a.window.min-o.window.min);for(let a=0;a<r.length;a++){let o=r[a],s=r[a+1];s?(o.window.max=I.Micro(s.window.min-1),o.window.range=I.Micro(o.window.
max-o.window.min)):(o.window.max=I.Micro(ir.max),o.window.range=I.Micro(ir.max-o.window.min))}}for(let[n,r]of ec)if(!xu.has(n)){ec.delete(n);for(let a of r)a.args.data&&Qs.delete(a.args.data.navigationId)}let e=Su.at(0),t=j.secondsToMicro(I.Seconds(.5));if(e){let n=e.ts-ir.min<t;e.args.data?.isOutermostMainFrame&&e.args.data?.documentLoaderURL&&n&&(Eu=e.args.data.documentLoaderURL)}}function ht(){return{traceBounds:ir,browserProcessId:ew,browserThreadId:tw,processNames:rw,gpuProcessId:nw,gpuThreadId:Uf===v.ThreadID(-1)?void 0:Uf,viewportRect:Bf||void 0,devicePixelRatio:G3??void 0,mainFrameId:wu,mainFrameURL:Eu,navigationsByFrameId:ec,navigationsByNavigationId:Qs,finalDisplayUrlByNavigationId:Tu,threadsInProcess:aw,rendererProcessesByFrame:xu,topLevelRendererIds:jf,frameByProcessId:Qb,mainFrameNavigations:Su,traceIsGeneric:qf}}var xu,wu,Eu,Qb,ew,tw,nw,Uf,Bf,G3,rw,jf,ir,ec,Qs,Tu,Su,aw,Hf,Tae,qf,xae,sr=g(()=>{d();wt();Se();ie();xu=new Map,wu="",Eu="",Qb=new Map,ew=v.ProcessID(-1),tw=v.ThreadID(
-1),nw=v.ProcessID(-1),Uf=v.ThreadID(-1),Bf=null,G3=null,rw=new Map,jf=new Set;i(W3,"makeNewTraceBounds");ir=W3(),ec=new Map,Qs=new Map,Tu=new Map,Su=[],aw=new Map,Hf=I.Micro(-1),Tae=new Set([v.Phase.BEGIN,v.Phase.END,v.Phase.COMPLETE,v.Phase.INSTANT]),qf=!0,xae=new Set([v.Name.TRACING_STARTED_IN_PAGE,v.Name.TRACING_SESSION_ID_FOR_WORKER,v.Name.TRACING_STARTED_IN_BROWSER,v.Name.CPU_PROFILE]);i(Sae,"reset");i(Zb,"updateRendererProcessByFrame");i(Cae,"handleEvent");i(kae,"finalize");i(ht,"data")});var lw={};x(lw,{data:()=>Wi,deps:()=>Aae,finalize:()=>Dae,handleEvent:()=>Iae,reset:()=>_ae});function zi(e,t,n){Cu.has(e)||Cu.set(e,{});let r=Cu.get(e);if(!r)throw new Error(`Unable to locate trace events for request ID ${e}`);if(Array.isArray(r[t])){let a=r[t],o=n;a.push(...o)}else r[t]=n}function Rae(e){for(let t of e)if(t&&t>0)return t;return 0}function _ae(){sw=new Map,Cu=new Map,Wf=[],Gf=new Map,cw=new Map,Gi=new Map,tc={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map,entityByUrlCache:new Map},iw=[]}function Iae(e){if(v.isResourceChangePriority(e)){zi(e.args.data.requestId,"changePriority",e);return}if(v.isResourceWillSendRequest(e)){zi(e.args.data.requestId,"willSendRequests",[e]);return}if(v.isResourceSendRequest(e)){zi(e.args.data.requestId,"sendRequests",[e]);return}if(v.isResourceReceiveResponse(e)){zi(e.args.data.requestId,"receiveResponse",e);return}if(v.isResourceReceivedData(e)){zi(e.args.data.requestId,"receivedData",[e]);return}if(v.isResourceFinish(
e)){zi(e.args.data.requestId,"resourceFinish",e);return}if(v.isResourceMarkAsCached(e)){zi(e.args.data.requestId,"resourceMarkAsCached",e);return}if(v.isWebSocketCreate(e)||v.isWebSocketInfo(e)||v.isWebSocketTransfer(e)){let t=e.args.data.identifier;Gi.has(t)||(e.args.data.frame?Gi.set(t,{frame:e.args.data.frame,webSocketIdentifier:t,events:[],syntheticConnection:null}):e.args.data.workerId&&Gi.set(t,{workerId:e.args.data.workerId,webSocketIdentifier:t,events:[],syntheticConnection:null})),Gi.get(t)?.events.push(e)}if(v.isLinkPreconnect(e)){iw.push(e);return}}async function Dae(){let{rendererProcessesByFrame:e}=ht();for(let[t,n]of Cu.entries()){if(!n.sendRequests)continue;let r=[];for(let oe=0;oe<n.sendRequests.length-1;oe++){let X=n.sendRequests[oe],J=n.sendRequests[oe+1],nt=X.ts,Te=I.Micro(J.ts-X.ts);if(n.willSendRequests?.[oe]&&n.willSendRequests[oe+1]){let Oe=n.willSendRequests[oe],Wn=n.willSendRequests[oe+1];nt=Oe.ts,Te=I.Micro(Wn.ts-Oe.ts)}r.push({url:X.args.data.url,priority:X.args.
data.priority,requestMethod:X.args.data.requestMethod,ts:nt,dur:Te})}let a=n.sendRequests[0],o=n.sendRequests[n.sendRequests.length-1];if(o.args.data.url.startsWith("data:"))continue;let s=globalThis.isLightrider;if(s&&n.resourceFinish&&n.receiveResponse?.args.data.headers){let oe=n.receiveResponse.args.data.headers.find(X=>X.name==="X-TotalFetchedSize");if(oe){let X=parseFloat(oe.value);isNaN(X)||(n.resourceFinish.args.data.encodedDataLength=X)}}let c=n.resourceFinish?.args.data.encodedDataLength!==0,l=!!n.receiveResponse&&n.receiveResponse.args.data.fromCache&&!n.receiveResponse.args.data.fromServiceWorker&&!c,u=n.resourceMarkAsCached!==void 0,m=u?void 0:n.receiveResponse?.args.data.timing,p;if(s&&n.receiveResponse?.args.data.headers){m={requestTime:j.microToSeconds(n.sendRequests.at(0)?.ts??0),connectEnd:0,connectStart:0,dnsEnd:0,dnsStart:0,proxyEnd:0,proxyStart:0,pushEnd:0,pushStart:0,receiveHeadersEnd:0,receiveHeadersStart:0,sendEnd:0,sendStart:0,sslEnd:0,sslStart:0,workerReady:0,
workerStart:0,...m};let oe=n.receiveResponse.args.data.headers.find(nt=>nt.name==="X-TCPMs"),X=oe?Math.max(0,parseInt(oe.value,10)):0;n.receiveResponse.args.data.protocol.startsWith("h3")?(m.connectStart=0,m.connectEnd=X):(m.connectStart=0,m.sslStart=X/2,m.connectEnd=X,m.sslEnd=X);let J=n.receiveResponse.args.data.headers.find(nt=>nt.name==="X-ResponseMs");J&&(p=Math.max(0,parseInt(J.value,10)))}if(!["blob:","file:","filesystem:","http:","https:"].some(oe=>a.args.data.url.startsWith(oe)))continue;let h=o.args.data.priority,y=h;n.changePriority&&(y=n.changePriority.args.data.priority);let b=n.willSendRequests?.length?I.Micro(n.willSendRequests[0].ts):I.Micro(a.ts),w=n.willSendRequests?.length?I.Micro(n.willSendRequests[n.willSendRequests.length-1].ts):I.Micro(o.ts),C=n.resourceFinish?n.resourceFinish.ts:w,k=n.resourceFinish?.args.data.finishTime?I.Micro(n.resourceFinish.args.data.finishTime*zf):I.Micro(C),R=I.Micro(m?(k||w)-w:0),S=I.Micro(C-(k||C)),_=I.Micro(w-b),q=m?m.requestTime*zf-w:
0,F=I.Micro(ia.clamp(q,0,Number.MAX_VALUE)),G=m?I.Micro(Rae([m.dnsStart*br,m.connectStart*br,m.sendStart*br,n.receiveResponse?n.receiveResponse.ts-w:null])):n.receiveResponse?I.Micro(n.receiveResponse.ts-b):I.Micro(0),K=m?I.Micro(m.requestTime*zf+m.sendStart*br):b,ne=m?I.Micro((m.receiveHeadersEnd-m.sendEnd)*br):I.Micro(0),he=m?I.Micro(((m.receiveHeadersStart??m.receiveHeadersEnd)-m.sendEnd)*br):I.Micro(0),Ge=m?I.Micro(m.requestTime*zf+m.receiveHeadersEnd*br):b,ue=m?I.Micro((k||Ge)-Ge):n.receiveResponse?I.Micro(C-n.receiveResponse.ts):I.Micro(0),Tt=I.Micro(R+S),le=m?I.Micro((m.dnsEnd-m.dnsStart)*br):I.Micro(0),je=m?I.Micro((m.sslEnd-m.sslStart)*br):I.Micro(0),St=m?I.Micro((m.proxyEnd-m.proxyStart)*br):I.Micro(0),gt=m?I.Micro((m.sendEnd-m.sendStart)*br):I.Micro(0),We=m?I.Micro((m.connectEnd-m.connectStart)*br):I.Micro(0),{frame:Ot,url:Qe,renderBlocking:$e}=o.args.data,{encodedDataLength:Me,decodedBodyLength:B}=n.resourceFinish?n.resourceFinish.args.data:{encodedDataLength:0,decodedBodyLength:0},
mt=new URL(Qe).protocol==="https:",pt=re.activeURLForFrameAtTime(Ot,o.ts,e)||"",_e=Ut.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:o,args:{data:{syntheticData:{dnsLookup:le,download:ue,downloadStart:Ge,finishTime:k,initialConnection:We,isDiskCached:l,isHttps:mt,isMemoryCached:u,isPushedResource:c,networkDuration:R,processingDuration:S,proxyNegotiation:St,queueing:F,redirectionDuration:_,requestSent:gt,sendStartTime:K,ssl:je,stalled:G,totalTime:Tt,waiting:ne,serverResponseTime:he},decodedBodyLength:B,encodedDataLength:Me,frame:Ot,fromServiceWorker:n.receiveResponse?.args.data.fromServiceWorker,isLinkPreload:o.args.data.isLinkPreload||!1,mimeType:n.receiveResponse?.args.data.mimeType??"",priority:y,initialPriority:h,protocol:n.receiveResponse?.args.data.protocol??"unknown",redirects:r,renderBlocking:$e??"non_blocking",requestId:t,requestingFrameUrl:pt,requestMethod:o.args.data.requestMethod,resourceType:o.args.data.resourceType??"Other",statusCode:n.receiveResponse?.args.
data.statusCode??0,responseHeaders:n.receiveResponse?.args.data.headers??null,fetchPriorityHint:o.args.data.fetchPriorityHint??"auto",initiator:o.args.data.initiator,stackTrace:o.args.data.stackTrace,timing:m,lrServerResponseTime:p,url:Qe,failed:n.resourceFinish?.args.data.didFail??!1,finished:!!n.resourceFinish,hasResponse:!!n.receiveResponse,connectionId:n.receiveResponse?.args.data.connectionId,connectionReused:n.receiveResponse?.args.data.connectionReused}},cat:"loading",name:v.Name.SYNTHETIC_NETWORK_REQUEST,ph:v.Phase.COMPLETE,dur:I.Micro(C-b),tdur:I.Micro(C-b),ts:I.Micro(b),tts:I.Micro(b),pid:o.pid,tid:o.tid});Wf.push(_e),sw.set(_e.args.data.requestId,_e),pb(_e,tc,n);let He=_e.args.data.initiator?.url||re.getStackTraceTopCallFrameInEventPayload(_e)?.url;if(He){let oe=Gf.get(He)??[];oe.push(_e),Gf.set(He,oe)}}for(let t of Wf){let n=Gf.get(t.args.data.url);if(n)for(let r of n)cw.set(r,t)}Nae()}function Wi(){return{byId:sw,byTime:Wf,eventToInitiator:cw,webSocket:[...Gi.values()],entityMappings:{
entityByEvent:tc.entityByEvent,eventsByEntity:tc.eventsByEntity,createdEntityCache:tc.createdEntityCache,entityByUrlCache:tc.entityByUrlCache},linkPreconnectEvents:iw}}function Aae(){return["Meta"]}function Nae(){Gi.forEach(e=>{let t=null,n=null;for(let r of e.events)v.isWebSocketCreate(r)&&(t=r),v.isWebSocketDestroy(r)&&(n=r);e.syntheticConnection=Mae(t,n,e.events[0])})}function Mae(e,t,n){let{traceBounds:r}=ht(),a=e?e.ts:r.min,s=(t?t.ts:r.max)-a,c=e||t||n;return{name:"SyntheticWebSocketConnection",cat:c.cat,ph:v.Phase.COMPLETE,ts:a,dur:s,pid:c.pid,tid:c.tid,s:c.s,rawSourceEvent:c,_tag:"SyntheticEntryTag",args:{data:{identifier:c.args.data.identifier,priority:"Low",url:c.args.data.url||""}}}}var br,zf,Gi,iw,Cu,sw,Wf,Gf,cw,tc,ku=g(()=>{d();wt();Se();ie();_f();sr();br=1e3,zf=1e6,Gi=new Map,iw=[],Cu=new Map,sw=new Map,Wf=[],Gf=new Map,cw=new Map,tc={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map,entityByUrlCache:new Map};i(zi,"storeTraceEventWithRequestId");i(Rae,
"firstPositiveValueInList");i(_ae,"reset");i(Iae,"handleEvent");i(Dae,"finalize");i(Wi,"data");i(Aae,"deps");i(Nae,"finalizeWebSocketData");i(Mae,"createSyntheticWebSocketConnection")});var Vf,$f,uw=g(()=>{d();Vf=class{static{i(this,"ProfileNode")}callFrame;callUID;self;total;id;parent;children;functionName;depth;deoptReason;constructor(t){this.callFrame=t,this.callUID=`${t.functionName}@${t.scriptId}:${t.lineNumber}:${t.columnNumber}`,this.self=0,this.total=0,this.id=0,this.functionName=t.functionName,this.parent=null,this.children=[]}get scriptId(){return String(this.callFrame.scriptId)}get url(){return this.callFrame.url}get lineNumber(){return this.callFrame.lineNumber}get columnNumber(){return this.callFrame.columnNumber}setFunctionName(t){t!==null&&(this.functionName=t)}},$f=class{static{i(this,"ProfileTreeModel")}root;total;maxDepth;initialize(t){this.root=t,this.assignDepthsAndParents(),this.total=this.calculateTotals(this.root)}assignDepthsAndParents(){let t=this.root;t.depth=-1,t.parent=null,this.maxDepth=0;let n=[t];for(;n.length;){let r=n.pop(),a=r.depth+1;a>this.maxDepth&&(this.maxDepth=a);let o=r.children;for(let s of o)s.depth=a,s.parent=r,n.push(s)}}calculateTotals(t){
let n=[t],r=[];for(;n.length;){let a=n.pop();a.total=a.self,r.push(a),n.push(...a.children)}for(;r.length>1;){let a=r.pop();a.parent&&(a.parent.total+=a.total)}return t.total}}});var Yf={};x(Yf,{CPUProfileDataModel:()=>dw,CPUProfileNode:()=>Ru});var Ru,dw,V3=g(()=>{d();wt();uw();Ru=class extends Vf{static{i(this,"CPUProfileNode")}id;self;positionTicks;deoptReason;constructor(t,n){let r=t.callFrame||{functionName:t.functionName,scriptId:t.scriptId,url:t.url,lineNumber:t.lineNumber-1,columnNumber:t.columnNumber-1};super(r),this.id=t.id,this.self=(t.hitCount||0)*n,this.positionTicks=t.positionTicks,this.deoptReason=t.deoptReason&&t.deoptReason!=="no reason"?t.deoptReason:null}},dw=class extends $f{static{i(this,"CPUProfileDataModel")}profileStartTime;profileEndTime;timestamps;samples;traceIds;lines;totalHitCount;profileHead;#e;gcNode;programNode;idleNode;#t;#o;constructor(t){super(),!!t.head?(this.profileStartTime=t.startTime*1e3,this.profileEndTime=t.endTime*1e3,this.timestamps=t.timestamps,this.compatibilityConversionHeadToNodes(t)):(this.profileStartTime=t.startTime/1e3,this.profileEndTime=t.endTime/1e3,this.timestamps=this.convertTimeDeltas(t)),this.traceIds=t.
traceIds,this.samples=t.samples,this.lines=t.lines,this.totalHitCount=0,this.profileHead=this.translateProfileTree(t.nodes),this.initialize(this.profileHead),this.extractMetaNodes(),this.samples?.length&&(this.sortSamples(),this.normalizeTimestamps(),this.fixMissingSamples())}compatibilityConversionHeadToNodes(t){if(!t.head||t.nodes)return;let n=[];r(t.head),t.nodes=n,delete t.head;function r(a){return n.push(a),a.children=a.children.map(r),a.id}i(r,"convertNodesTree")}convertTimeDeltas(t){if(!t.timeDeltas)return[];let n=t.startTime,r=new Array(t.timeDeltas.length);for(let a=0;a<t.timeDeltas.length;++a)n+=t.timeDeltas[a],r[a]=n;return r}translateProfileTree(t){function n(p){if(!p[0].children){p[0].children=[];for(let f=1;f<p.length;++f){let h=p[f],y=a.get(h.parent);y&&(y.children?y.children.push(h.id):y.children=[h.id])}}}i(n,"buildChildrenFromParents");function r(p,f){if(typeof p[0].hitCount!="number"){if(!f)throw new Error("Error: Neither hitCount nor samples are present in profile.");
for(let h=0;h<p.length;++h)p[h].hitCount=0;for(let h=0;h<f.length;++h){let y=a.get(f[h]);y?.hitCount!==void 0&&y.hitCount++}}}i(r,"buildHitCountFromSamples");let a=new Map;for(let p=0;p<t.length;++p){let f=t[p];a.set(f.id,f)}r(t,this.samples),n(t),this.totalHitCount=t.reduce((p,f)=>p+(f.hitCount||0),0);let o=(this.profileEndTime-this.profileStartTime)/this.totalHitCount,s=t[0],c=new Map([[s.id,s.id]]);this.#e=new Map;let l=new Ru(s,o);if(this.#e.set(s.id,l),!s.children)throw new Error("Missing children for root");let u=s.children.map(()=>l),m=s.children.map(p=>a.get(p));for(;m.length;){let p=u.pop(),f=m.pop();if(!f||!p)continue;f.children||(f.children=[]);let h=new Ru(f,o);p.children.push(h),p=h,c.set(f.id,p.id),u.push.apply(u,f.children.map(()=>p)),m.push.apply(m,f.children.map(y=>a.get(y))),this.#e.set(f.id,h)}return this.samples&&(this.samples=this.samples.map(p=>c.get(p))),l}sortSamples(){if(!this.timestamps||!this.samples)return;let t=this.timestamps,n=this.samples,r=t.map((a,o)=>o);
r.sort((a,o)=>t[a]-t[o]),this.timestamps=[],this.samples=[];for(let a=0;a<r.length;a++){let o=r[a];this.timestamps.push(t[o]),this.samples.push(n[o])}}normalizeTimestamps(){if(!this.samples)return;let t=this.timestamps;if(!t){let n=this.profileStartTime,r=(this.profileEndTime-n)/this.samples.length;t=new Array(this.samples.length+1);for(let a=0;a<t.length;++a)t[a]=n+a*r;this.timestamps=t;return}for(let n=0;n<t.length;++n)t[n]/=1e3;if(this.samples.length===t.length){let n=t.at(-1)||0,r=(n-t[0])/(t.length-1);this.timestamps.push(n+r)}this.profileStartTime=t.at(0)||this.profileStartTime,this.profileEndTime=t.at(-1)||this.profileEndTime}extractMetaNodes(){let t=this.profileHead.children;for(let n=0;n<t.length&&!(this.gcNode&&this.programNode&&this.idleNode);n++){let r=t[n];r.functionName==="(garbage collector)"?this.gcNode=r:r.functionName==="(program)"?this.programNode=r:r.functionName==="(idle)"&&(this.idleNode=r)}}fixMissingSamples(){let t=this.samples;if(!t)return;let n=t.length;if(!this.
programNode||n<3)return;let r=this.#e,a=this.programNode.id,o=this.gcNode?this.gcNode.id:-1,s=this.idleNode?this.idleNode.id:-1,c=t[0],l=t[1];for(let p=1;p<n-1;p++){let f=t[p+1],h=r.get(c),y=r.get(f);if(c===void 0||f===void 0||!h||!y){console.error(`Unexpectedly found undefined nodes: ${c} ${f}`);continue}l===a&&!m(c)&&!m(f)&&u(h)===u(y)&&(t[p]=c),c=l,l=f}function u(p){for(;p.parent?.parent;)p=p.parent;return p}i(u,"bottomNode");function m(p){return p===a||p===o||p===s}i(m,"isSystemNode")}forEachFrame(t,n,r,a){if(!this.profileHead||!this.samples)return;r=r||0,a=a||1/0;let o=this.samples,s=this.timestamps,c=this.#e,l=this.gcNode,u=o.length,m=Wt.lowerBound(s,r,Wt.DEFAULT_COMPARATOR),p=0,f=[],h=this.profileHead.id,y,b=null,w=this.maxDepth+3;this.#t||(this.#t=new Array(w));let C=this.#t;this.#o||(this.#o=new Array(w));let k=this.#o,R,S;for(S=m;S<u&&(y=s[S],!(y>=a));S++){let _=o[S];if(_===h)continue;R=c.get(_);let q=c.get(h)||null;if(q){if(l&&R===l){b=q,t(b.depth+1,l,S,y),C[++p]=y,k[p]=0,h=
_;continue}if(l&&q===l&&b){let F=C[p],G=y-F;k[p-1]+=G,n(b.depth+1,l,S,F,G,G-k[p]),--p,q=b,h=q.id,b=null}for(;R&&R.depth>q.depth;)f.push(R),R=R.parent;for(;q&&q!==R;){let F=C[p],G=y-F;k[p-1]+=G,n(q.depth,q,S,F,G,G-k[p]),--p,R&&R.depth===q.depth&&(f.push(R),R=R.parent),q=q.parent}for(;f.length;){let F=f.pop();if(!F)break;R=F,t(F.depth,F,S,y),C[++p]=y,k[p]=0}h=_}}if(y=s[S]||this.profileEndTime,R&&b&&c.get(h)===l){let _=C[p],q=y-_;k[p-1]+=q,n(b.depth+1,R,S,_,q,q-k[p]),--p,h=b.id}for(let _=c.get(h);_?.parent;_=_.parent){let q=C[p],F=y-q;k[p-1]+=F,n(_.depth,_,S,q,F,F-k[p]),--p}}nodeByIndex(t){return this.samples&&this.#e.get(this.samples[t])||null}nodeById(t){return this.#e.get(t)||null}nodes(){return this.#e?[...this.#e.values()]:null}}});var $3=g(()=>{d();V3();uw()});var gw={};x(gw,{data:()=>hw,finalize:()=>Bae,getProfileCallFunctionName:()=>jae,handleEvent:()=>Uae,reset:()=>Fae});function Lae(e){for(let[t,n]of fw)for(let[r,a]of n){let p=function(){c.forEachFrame(f,h);function f(y,b,w,C){if(o===void 0)return;let k=j.milliToMicro(I.Milli(C)),R=b.id,S=re.makeProfileCall(b,r,w,k,t,o);u.profileCalls.push(S),s.push(u.profileCalls.length-1);let _=La.makeEmptyTraceEntryNode(S,R);_u.set(S,_),_.depth=y,s.length===1&&u.profileTree?.roots.add(_)}i(f,"openFrameCallback");function h(y,b,w,C,k,R){let S=s.pop(),_=S!==void 0&&u.profileCalls[S];if(!_)return;let{callFrame:q,ts:F,pid:G,tid:K}=_,ne=_u.get(_);if(q===void 0||F===void 0||G===void 0||r===void 0||K===void 0||ne===void 0)return;let he=j.milliToMicro(I.Milli(k)),Ge=j.milliToMicro(I.Milli(R));_.dur=he,ne.selfTime=Ge;let ue=s.at(-1),Tt=ue!==void 0&&u.profileCalls.at(ue),le=Tt&&_u.get(Tt);le&&(ne.parent=le,le.children.push(ne))}i(h,"closeFrameCallback")};i(p,"buildProfileCallsForCPUProfile");let o=a.threadId;if(!a.
rawProfile.nodes.length||o===void 0)continue;let s=[],c=new Yf.CPUProfileDataModel(a.rawProfile),l=La.makeEmptyTraceEntryTree();l.maxDepth=c.maxDepth;let u={rawProfile:a.rawProfile,parsedProfile:c,profileCalls:[],profileTree:l,profileId:r};me.getWithDefault(pw,t,()=>new Map).set(o,u),e.isCPUProfile&&p()}}function Fae(){fw=new Map,pw=new Map,_u=new Map}function Uae(e){if(v.isSyntheticCpuProfile(e)){let t=mw(e.pid,e.id);t.rawProfile=e.args.data.cpuProfile,t.threadId=e.tid;return}if(v.isProfile(e)){let t=mw(e.pid,e.id);t.rawProfile.startTime=e.ts,t.threadId=e.tid;return}if(v.isProfileChunk(e)){let n=mw(e.pid,e.id).rawProfile,r=e.args?.data?.cpuProfile||{samples:[]},a=r?.samples||[],o=e.args?.data?.cpuProfile?.trace_ids;for(let l of r?.nodes||[]){let u=typeof l.callFrame.lineNumber>"u"?-1:l.callFrame.lineNumber,m=typeof l.callFrame.columnNumber>"u"?-1:l.callFrame.columnNumber,p=String(l.callFrame.scriptId),f=l.callFrame.url||"",h={...l,callFrame:{...l.callFrame,url:f,lineNumber:u,columnNumber:m,
scriptId:p}};n.nodes.push(h)}let s=e.args.data?.timeDeltas||[],c=e.args.data?.lines||Array(a.length).fill(0);if(n.samples?.push(...a),n.timeDeltas?.push(...s),n.lines?.push(...c),o){n.traceIds??={};for(let l in o)n.traceIds[l]=o[l]}if(n.samples&&n.timeDeltas&&n.samples.length!==n.timeDeltas.length){console.error("Failed to parse CPU profile.");return}if(!n.endTime&&n.timeDeltas){let l=n.timeDeltas;n.endTime=l.reduce((u,m)=>u+m,n.startTime)}return}}async function Bae(e={}){Lae(e)}function hw(){return{profilesInProcess:pw,entryToNode:_u}}function mw(e,t){let n=me.getWithDefault(fw,e,()=>new Map);return me.getWithDefault(n,t,()=>({rawProfile:{startTime:0,endTime:0,nodes:[],samples:[],timeDeltas:[],lines:[]},profileId:t}))}function jae(e,t){let r=e.profilesInProcess.get(t.pid)?.get(t.tid)?.parsedProfile.nodeById(t.nodeId);return r?.functionName?r.functionName:t.callFrame.functionName}var pw,_u,fw,yw=g(()=>{d();wt();$3();Se();ie();pw=new Map,_u=new Map,fw=new Map;i(Lae,"parseCPUProfileData");
i(Fae,"reset");i(Uae,"handleEvent");i(Bae,"finalize");i(hw,"data");i(mw,"getOrCreatePreProcessedData");i(jae,"getProfileCallFunctionName")});var Ew={};x(Ew,{assignIsMainFrame:()=>J3,assignMeta:()=>K3,assignOrigin:()=>X3,assignThreadName:()=>Z3,buildHierarchy:()=>tF,data:()=>Du,deps:()=>Yae,finalize:()=>Vae,handleEvent:()=>Wae,handleUserConfig:()=>zae,makeCompleteEvent:()=>nF,reset:()=>Gae,sanitizeProcesses:()=>Q3,sanitizeThreads:()=>eF});function zae(e){Y3=e}function Gae(){sa=new Map,ww=new Map,Vi={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map,entityByUrlCache:new Map},vw=[],bw=[]}function Wae(e){if(v.isThreadName(e)&&e.args.name?.startsWith("CompositorTileWorker")&&bw.push({pid:e.pid,tid:e.tid}),v.isBegin(e)||v.isEnd(e)){let t=nc(sa,e.pid),n=Iu(t,e.tid),r=nF(e);if(!r)return;n.entries.push(r);return}if(v.isInstant(e)||v.isComplete(e)){let t=nc(sa,e.pid);Iu(t,e.tid).entries.push(e)}if(v.isLayout(e)){let t=nc(sa,e.pid);Iu(t,e.tid).layoutEvents.push(e)}if(v.isRecalcStyle(e)){let t=nc(sa,e.pid);Iu(t,e.tid).recalcStyleEvents.push(e)}}async function Vae(){let{mainFrameId:e,rendererProcessesByFrame:t,threadsInProcess:n}=ht();
Vi=Wi().entityMappings,K3(sa,e,t,n),Q3(sa),tF(sa),eF(sa)}function Du(){return{processes:sa,compositorTileWorkers:$ae(),entryToNode:ww,entityMappings:{entityByEvent:Vi.entityByEvent,eventsByEntity:Vi.eventsByEntity,createdEntityCache:Vi.createdEntityCache,entityByUrlCache:Vi.entityByUrlCache}}}function $ae(){let e=new Map;for(let t of bw){let n=e.get(t.pid)||[];n.push(t.tid),e.set(t.pid,n)}return e}function K3(e,t,n,r){X3(e,n),J3(e,t,n),Z3(e,r)}function X3(e,t){for(let n of t.values())for(let[r,a]of n)for(let o of a.flat()){let s=nc(e,r);if(s.url===null||s.url==="about:blank")try{new URL(o.frame.url),s.url=o.frame.url}catch{s.url=null}}}function J3(e,t,n){for(let[r,a]of n)for(let[o]of a){let s=nc(e,o);r===t&&(s.isOnMainFrame=!0)}}function Z3(e,t){for(let[n,r]of e)for(let[a,o]of t.get(n)??[]){let s=Iu(r,a);s.name=o?.args.name??`${a}`}}function Q3(e){let t=bu().worklets;if(!ht().traceIsGeneric){for(let[r,a]of e)if(a.url===null){let o=t.get(r);o?a.url=o.host:e.delete(r);continue}}}function eF(e){
for(let[,t]of e)for(let[n,r]of t.threads)r.tree?.roots.size||t.threads.delete(n)}function tF(e,t){let n=hw();for(let[r,a]of e)for(let[o,s]of a.threads){if(!s.entries.length){s.tree=La.makeEmptyTraceEntryTree();continue}re.sortTraceEventsInPlace(s.entries);let c=n.profilesInProcess.get(r)?.get(o);if(c){let u=c.parsedProfile,m=u&&new gu.SamplesIntegrator(u,c.profileId,r,o,Y3),p=m?.buildProfileCalls(s.entries);if(m&&p){s.entries=re.mergeEventsInOrder(s.entries,p),s.profileCalls=p;let f=m.jsSampleEvents;f.length&&(s.entries=re.mergeEventsInOrder(s.entries,f))}}let l=La.treify(s.entries,t);s.tree=l.tree;for(let[u,m]of l.entryToNode)ww.set(u,m),mb(u,Vi)}}function nF(e){if(v.isEnd(e)){let n=vw.pop();return n?n.name!==e.name||n.cat!==e.cat?(console.error("Begin/End events mismatch at "+n.ts+" ("+n.name+") vs. "+e.ts+" ("+e.name+")"),null):(n.dur=I.Micro(e.ts-n.ts),null):null}let t={...e,ph:v.Phase.COMPLETE,dur:I.Micro(0)};return vw.push(t),t}function Yae(){return["Meta","Samples","AuctionWorkl\
ets","NetworkRequests"]}var sa,Vi,bw,ww,vw,Y3,Hae,qae,nc,Iu,Kf=g(()=>{d();wt();Se();ie();Ff();_f();sr();ku();yw();sa=new Map,Vi={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map,entityByUrlCache:new Map},bw=Array(),ww=new Map,vw=[],Y3=oa.defaults(),Hae=i(()=>({url:null,isOnMainFrame:!1,threads:new Map}),"makeRendererProcess"),qae=i(()=>({name:null,entries:[],profileCalls:[],layoutEvents:[],recalcStyleEvents:[]}),"makeRendererThread"),nc=i((e,t)=>me.getWithDefault(e,t,Hae),"getOrCreateRendererProcess"),Iu=i((e,t)=>me.getWithDefault(e.threads,t,qae),"getOrCreateRendererThread");i(zae,"handleUserConfig");i(Gae,"reset");i(Wae,"handleEvent");i(Vae,"finalize");i(Du,"data");i($ae,"gatherCompositorThreads");i(K3,"assignMeta");i(X3,"assignOrigin");i(J3,"assignIsMainFrame");i(Z3,"assignThreadName");i(Q3,"sanitizeProcesses");i(eF,"sanitizeThreads");i(tF,"buildHierarchy");i(nF,"makeCompleteEvent");i(Yae,"deps")});var Rw={};x(Rw,{data:()=>kw,deps:()=>toe,finalize:()=>Jae,handleEvent:()=>Xae,reset:()=>Kae});function Kae(){xw=new Map,Sw=new Map,Tw=new Map,Cw=new Map}function Xae(e){}async function Jae(){let{flows:e}=vu(),{entryToNode:t}=Du();for(let n of e){let r=n.at(0);if(!r||(v.isDebuggerAsyncTaskRun(r)&&(r=Tw.get(r)),!r||!v.isDebuggerAsyncTaskScheduled(r)))continue;let a=r.args.taskName,o=n.at(1);if(!o||!v.isDebuggerAsyncTaskRun(o))continue;Tw.set(o,r);let s=Zae(r,t),c=Qae(o,t);if(Cw.set(c||o,{taskName:a,scheduler:s||r}),!s||!c)continue;me.getWithDefault(xw,s,()=>[]).push(c);let u=eoe(o,t);for(let m of u)Sw.set(m,{taskName:a,scheduler:s})}}function Zae(e,t){let n=t.get(e)?.parent;for(;n;){if(v.isProfileCall(n.entry)||rF(n.entry))return n.entry;n=n.parent}return null}function rF(e){let t=v.isConsoleRunTask(e),n=e.name.startsWith("v8")||e.name.startsWith("V8");return v.isJSInvocationEvent(e)&&(t||!n)}function Qae(e,t){return aF(e,t,rF,v.isDebuggerAsyncTaskRun).at(0)}function eoe(e,t){return aF(e,
t,v.isProfileCall,v.isDebuggerAsyncTaskRun)}function aF(e,t,n,r){let a=t.get(e);if(!a)return[];let o=[[...a.children]],s=[];for(let c=0;c<o.length;c++){let l=o[c];for(let u=0;u<l.length;u++){let m=l[u];n(m.entry)?s.push(m.entry):r(m.entry)||o.push([...m.children])}}return s}function kw(){return{schedulerToRunEntryPoints:xw,asyncCallToScheduler:Sw,runEntryPointToScheduler:Cw}}function toe(){return["Renderer","Flows"]}var xw,Tw,Sw,Cw,_w=g(()=>{d();wt();ie();Lf();Kf();xw=new Map,Tw=new Map,Sw=new Map,Cw=new Map;i(Kae,"reset");i(Xae,"handleEvent");i(Jae,"finalize");i(Zae,"findNearestJSAncestor");i(rF,"acceptJSInvocationsPredicate");i(Qae,"findFirstJsInvocationForAsyncTaskRun");i(eoe,"findFirstJSCallsForAsyncTaskRun");i(aF,"findFirstDescendantsOfType");i(kw,"data");i(toe,"deps")});var Dw={};x(Dw,{data:()=>ooe,finalize:()=>aoe,handleEvent:()=>roe,reset:()=>noe});function noe(){Iw=new Map}function roe(e){if(!v.isDOMStats(e))return;me.getWithDefault(Iw,e.args.data.frame,()=>[]).push(e)}async function aoe(){}function ooe(){return{domStatsByFrameId:Iw}}var Iw,oF=g(()=>{d();wt();ie();Iw=new Map;i(noe,"reset");i(roe,"handleEvent");i(aoe,"finalize");i(ooe,"data")});var Lw={};x(Lw,{data:()=>Au,finalize:()=>doe,handleEvent:()=>uoe,reset:()=>ioe,userTimingComparator:()=>Aw});function ioe(){$i=[],Mw=[],Ow=[],Pw=[],rc=[],Nw=new Map}function iF(e){if("dur"in e)return{start:e.ts,end:I.Micro(e.ts+(e.dur??0))};if(v.isConsoleTimeStamp(e)){let{start:t,end:n}=e.args.data||{};if(typeof t=="number"&&typeof n=="number")return{start:I.Micro(t),end:I.Micro(n)}}return{start:e.ts,end:e.ts}}function sF(e){if(e.cat==="blink.user_timing"){let t=e.args.data.beginEvent.args?.detail;if(t){let n=re.parseDevtoolsDetails(t,"devtools");if(n&&"track"in n)return n.track}}else if(v.isConsoleTimeStamp(e)){let t=e.args.data?.track;return typeof t=="string"?t:void 0}}function Aw(e,t,n){let{start:r,end:a}=iF(e),{start:o,end:s}=iF(t),c=re.compareBeginAndEnd(r,o,a,s);if(c)return c;let l=sF(e),u=sF(t);if(l!==u)return 0;let m=n.indexOf(e);return n.indexOf(t)-m}function uoe(e){if(!loe.includes(e.name)){if(v.isUserTimingMeasure(e)&&Nw.set(e.args.traceId,e),v.isPerformanceMeasure(e)){Mw.push(
e);return}v.isPerformanceMark(e)&&Ow.push(e),v.isConsoleTime(e)&&Pw.push(e),v.isConsoleTimeStamp(e)&&rc.push(e)}}async function doe(){let e=[...Mw,...Pw];$i=re.createMatchedSortedSyntheticEvents(e),$i=$i.sort((t,n)=>Aw(t,n,[...$i])),rc=rc.sort((t,n)=>Aw(t,n,[...rc]))}function Au(){return{consoleTimings:$i.filter(e=>e.cat==="blink.console"),performanceMeasures:$i.filter(e=>e.cat==="blink.user_timing"),performanceMarks:Ow,timestampEvents:rc,measureTraceByTraceId:Nw}}var $i,Nw,Mw,Ow,Pw,rc,soe,coe,loe,Fw=g(()=>{d();Se();ie();$i=[],Nw=new Map,Mw=[],Ow=[],Pw=[],rc=[];i(ioe,"reset");soe=["workerStart","redirectStart","redirectEnd","fetchStart","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd"],coe=["navigationStart","unloadEventStart","unloadEventEnd","redirectStart","redirectEnd","fetchStart","commitNavigationEnd","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requ\
estStart","responseStart","responseEnd","domLoading","domInteractive","domContentLoadedEventStart","domContentLoadedEventEnd","domComplete","loadEventStart","loadEventEnd"],loe=[...soe,...coe];i(iF,"getEventTimings");i(sF,"getEventTrack");i(Aw,"userTimingComparator");i(uoe,"handleEvent");i(doe,"finalize");i(Au,"data")});var qw={};x(qw,{data:()=>goe,deps:()=>yoe,extensionDataInConsoleTimeStamp:()=>dF,extensionDataInPerformanceTiming:()=>uF,extractConsoleAPIExtensionEntries:()=>cF,extractPerformanceAPIExtensionEntries:()=>lF,finalize:()=>foe,handleEvent:()=>moe,reset:()=>poe});function moe(e){}function poe(){Nu=[],Hw=[],Uw=[],Bw=[],jw=new Map,Xf=new Map}async function foe(){hoe()}function hoe(){let e=Au().performanceMeasures,t=Au().performanceMarks,n=re.mergeEventsInOrder(e,t);lF(n),cF(),re.sortTraceEventsInPlace(Nu),hu.buildTrackDataFromExtensionEntries(Nu,Uw,jw)}function cF(){let e=Au().timestampEvents;for(let t of e){if(!t.args.data)continue;let n=String(t.args.data.name??t.args.data.message);Xf.set(n,t);let{devtoolsObj:r,userDetail:a}=dF(t),o=t.args.data.start,s=t.args.data.end;if(!r&&!o&&!s)continue;let c=typeof o=="number"?I.Micro(o):Xf.get(String(o))?.ts,l=typeof s=="number"?I.Micro(s):Xf.get(String(s))?.ts;if(l!==void 0&&c===void 0)continue;let u=c??t.ts,m=l??t.ts;if(r){let h={...t,name:n,cat:"d\
evtools.extension",devtoolsObj:r,userDetail:a,rawSourceEvent:t,dur:I.Micro(m-u),ts:u,ph:v.Phase.COMPLETE},y=Ut.SyntheticEventsManager.registerSyntheticEvent(h);Nu.push(y);continue}let p={...t,name:n,cat:"disabled-by-default-v8.inspector",ph:v.Phase.COMPLETE,ts:u,dur:I.Micro(m-u),rawSourceEvent:t},f=Ut.SyntheticEventsManager.registerSyntheticEvent(p);Hw.push(f)}}function lF(e){for(let t of e){let{devtoolsObj:n,userDetail:r}=uF(t);if(!n)continue;let a={name:t.name,ph:Yn.isExtensionPayloadMarker(n)?v.Phase.INSTANT:v.Phase.COMPLETE,pid:t.pid,tid:t.tid,ts:t.ts,dur:t.dur,cat:"devtools.extension",devtoolsObj:n,userDetail:r,rawSourceEvent:v.isSyntheticUserTiming(t)?t.rawSourceEvent:t};if(Yn.isExtensionPayloadMarker(n)){let o=Ut.SyntheticEventsManager.registerSyntheticEvent(a);Bw.push(o);continue}if(Yn.isExtensionEntryObj(a.devtoolsObj)){let o=Ut.SyntheticEventsManager.registerSyntheticEvent(a);Nu.push(o);continue}}}function uF(e){let t=v.isPerformanceMark(e)?e.args.data?.detail:e.args.data.beginEvent.
args.detail;if(!t)return{devtoolsObj:null,userDetail:null};let n=re.parseDevtoolsDetails(t,"devtools"),r=null;try{r=JSON.parse(t),delete r.devtools}catch{}return{devtoolsObj:n,userDetail:r}}function dF(e){if(!e.args.data||!e.args.data.track)return{devtoolsObj:null,userDetail:null};let t=null;try{t=JSON.parse(e.args.data?.devtools||'""')}catch{}return{devtoolsObj:{color:String(e.args.data.color),track:String(e.args.data.track),dataType:"track-entry",trackGroup:e.args.data.trackGroup!==void 0?String(e.args.data.trackGroup):void 0},userDetail:t}}function goe(){return{entryToNode:jw,extensionTrackData:Uw,extensionMarkers:Bw,syntheticConsoleEntriesForTimingsTrack:Hw}}function yoe(){return["UserTimings"]}var Nu,Uw,Bw,jw,Xf,Hw,mF=g(()=>{d();Se();ie();Fw();Nu=[],Uw=[],Bw=[],jw=new Map,Xf=new Map,Hw=[];i(moe,"handleEvent");i(poe,"reset");i(foe,"finalize");i(hoe,"createExtensionFlameChartEntries");i(cF,"extractConsoleAPIExtensionEntries");i(lF,"extractPerformanceAPIExtensionEntries");i(uF,"exten\
sionDataInPerformanceTiming");i(dF,"extensionDataInConsoleTimeStamp");i(goe,"data");i(yoe,"deps")});var Kw={};x(Kw,{data:()=>Yw,deps:()=>Eoe,finalize:()=>woe,handleEvent:()=>boe,reset:()=>voe});function voe(){Ww=[],Vw=[],$w=new Map,zw={},Gw=null,Jf=[],Zf=[]}function boe(e){(v.isPaint(e)||v.isDisplayListItemListSnapshot(e)||v.isUpdateLayer(e)||v.isSetLayerId(e))&&Zf.push(e)}async function woe(){let e=ht();re.sortTraceEventsInPlace(Zf);for(let t of Zf)if(v.isSetLayerId(t)){if(e.mainFrameId!==t.args.data.frame)continue;Gw=t.args.data.layerTreeId}else if(v.isUpdateLayer(t))Jf.push(t);else if(v.isPaint(t)){if(!t.args.data.layerId)continue;Ww.push(t),zw[t.args.data.layerId]=t;continue}else if(v.isDisplayListItemListSnapshot(t)){let n=null;for(let a=Jf.length-1;a>-1;a--){let o=Jf[a];if(o.pid===t.pid&&o.tid===t.tid){n=o;break}}if(!n||n.args.layerTreeId!==Gw)continue;let r=zw[n.args.layerId];if(!r)continue;Vw.push(t),$w.set(r,t)}}function Yw(){return{paints:Ww,snapshots:Vw,paintsToSnapshots:$w}}function Eoe(){return["Meta"]}var Ww,Vw,$w,zw,Gw,Jf,Zf,Xw=g(()=>{d();Se();ie();sr();Ww=[],Vw=[],$w=
new Map,zw={},Gw=null,Jf=[],Zf=[];i(voe,"reset");i(boe,"handleEvent");i(woe,"finalize");i(Yw,"data");i(Eoe,"deps")});var Yi={};x(Yi,{ThreadType:()=>wr,threadsInRenderer:()=>Qf,threadsInTrace:()=>xoe});function Toe(e,t,n){let r=wr.OTHER;return t.name==="CrRendererMain"?r=wr.MAIN_THREAD:t.name==="DedicatedWorker thread"?r=wr.WORKER:t.name?.startsWith("CompositorTileWorker")?r=wr.RASTERIZER:n.worklets.has(e)?r=wr.AUCTION_WORKLET:t.name?.startsWith("ThreadPool")&&(r=wr.THREAD_POOL),r}function Qf(e,t){let n=[];if(e.processes.size)for(let[r,a]of e.processes)for(let[o,s]of a.threads){if(!s.tree)continue;let c=Toe(r,s,t);n.push({name:s.name,pid:r,tid:o,processIsOnMainFrame:a.isOnMainFrame,entries:s.entries,tree:s.tree,type:c,entryToNode:e.entryToNode})}return n}function xoe(e){let t=Jw.get(e);if(t)return t;let n=Qf(e.Renderer,e.AuctionWorklets);if(n.length)return Jw.set(e,n),n;let r=[];if(e.Samples.profilesInProcess.size)for(let[a,o]of e.Samples.profilesInProcess)for(let[s,c]of o)c.profileTree&&r.push({pid:a,tid:s,name:null,entries:c.profileCalls,processIsOnMainFrame:!1,tree:c.profileTree,type:wr.CPU_PROFILE,
entryToNode:e.Samples.entryToNode});return Jw.set(e,r),r}var wr,Jw,Zw=g(()=>{d();(function(e){e.MAIN_THREAD="MAIN_THREAD",e.WORKER="WORKER",e.RASTERIZER="RASTERIZER",e.AUCTION_WORKLET="AUCTION_WORKLET",e.OTHER="OTHER",e.CPU_PROFILE="CPU_PROFILE",e.THREAD_POOL="THREAD_POOL"})(wr||(wr={}));i(Toe,"getThreadTypeForRendererThread");i(Qf,"threadsInRenderer");Jw=new WeakMap;i(xoe,"threadsInTrace")});var t0={};x(t0,{LayerPaintEvent:()=>rh,PendingFrame:()=>ah,TimelineFrameBeginFrameQueue:()=>oh,TimelineFrameModel:()=>nh,data:()=>Roe,deps:()=>_oe,finalize:()=>koe,framesWithinWindow:()=>Ioe,handleEvent:()=>Coe,reset:()=>Soe});function pF(e){return v.isSetLayerId(e)||v.isBeginFrame(e)||v.isDroppedFrame(e)||v.isRequestMainThreadFrame(e)||v.isBeginMainThreadFrame(e)||v.isNeedsBeginFrameChanged(e)||v.isCommit(e)||v.isCompositeLayers(e)||v.isActivateLayerTree(e)||v.isDrawFrame(e)}function fF(e){return e.name===v.Name.RUN_TASK&&e.cat.includes("disabled-by-default-devtools.timeline")}function Soe(){eh=null,th=[]}function Coe(e){(pF(e)||v.isLayerTreeHostImplSnapshot(e)||fF(e)||hF.has(e.name)||v.isPaint(e))&&th.push(e)}async function koe(){re.sortTraceEventsInPlace(th),eh=new nh(th,Du(),bu(),ht(),Yw())}function Roe(){return{frames:eh?.frames()??[],framesById:eh?.framesById()??{}}}function _oe(){return["Meta","Renderer","AuctionWorklets","LayerTree"]}function Ioe(e,t,n){let r=Wt.lowerBound(e,t||
0,(o,s)=>o-s.endTime),a=Wt.lowerBound(e,n||1/0,(o,s)=>o-s.startTime);return e.slice(r,a)}var eh,th,hF,nh,Qw,rh,ah,e0,oh,gF=g(()=>{d();wt();Se();ie();Ff();Xw();sr();Kf();Zw();eh=null,th=[];i(pF,"isFrameEvent");i(fF,"entryIsTopLevel");hF=new Set([v.Name.SCHEDULE_STYLE_RECALCULATION,v.Name.INVALIDATE_LAYOUT,v.Name.BEGIN_MAIN_THREAD_FRAME,v.Name.SCROLL_LAYER]);i(Soe,"reset");i(Coe,"handleEvent");i(koe,"finalize");i(Roe,"data");i(_oe,"deps");nh=class{static{i(this,"TimelineFrameModel")}#e=[];#t={};#o=new oh;#n=null;#a=!1;#c=!1;#r=null;#i=null;#l=null;#s=null;#u=null;#p=null;#d=null;#m=null;#f=null;#h;constructor(t,n,r,a,o){let c=Qf(n,r).filter(l=>l.type===wr.MAIN_THREAD&&l.processIsOnMainFrame).map(l=>({tid:l.tid,pid:l.pid,startTime:l.entries[0].ts}));this.#h=o,this.#R(t,c,a.mainFrameId)}framesById(){return this.#t}frames(){return this.#e}#g(t,n){this.#n||this.#v(t,n),this.#s=t,this.#o.addFrameIfNotExists(n,t,!1,!1)}#y(t,n,r){this.#n||this.#v(t,n),this.#o.addFrameIfNotExists(n,t,!0,r),this.#o.
setDropped(n,!0),this.#o.setPartial(n,r)}#w(t,n){if(!this.#n){this.#v(t,n);return}if(this.#a||!this.#c){this.#u&&((this.#i?this.#i.triggerTime:this.#s||this.#u)>this.#n.startTime&&(this.#n.idle=!0,this.#s=null),this.#u=null);let r=this.#o.processPendingBeginFramesOnDrawFrame(n);for(let a of r){let o=this.#n.idle;this.#v(a.startTime,n),o&&this.#i&&this.#b(),a.isDropped&&(this.#n.dropped=!0),a.isPartial&&(this.#n.isPartial=!0)}}this.#a=!1}#E(){this.#n&&this.#i&&!this.#u&&this.#b()}#T(){this.#n&&(this.#c=!0)}#x(){this.#l&&(this.#i=this.#l,this.#l=null,this.#c=!1,this.#a=!0)}#S(t){this.#r=t}#C(t,n){n&&(this.#u=t)}#v(t,n){this.#n&&this.#k(this.#n,t),this.#n=new Qw(n,t,I.Micro(t-ht().traceBounds.min))}#k(t,n){t.setLayerTree(this.#r),t.setEndTime(n),this.#r&&(this.#r.paints=t.paints);let r=this.#e[this.#e.length-1];this.#e.length&&r&&(t.startTime!==r.endTime||t.startTime>t.endTime)&&console.assert(!1,`Inconsistent frame time for frame ${this.#e.length} (${t.startTime} - ${t.endTime})`);let a=this.#e.
push(t);t.setIndex(a-1),typeof t.mainFrameId=="number"&&(this.#t[t.mainFrameId]=t)}#b(){!this.#i||!this.#n||(this.#n.paints=this.#i.paints,this.#n.mainFrameId=this.#i.mainFrameId,this.#i=null)}#R(t,n,r){let a=0;this.#f=n.length&&n[0].tid||null,this.#m=n.length&&n[0].pid||null;for(let o=0;o<t.length;++o){for(;a+1<n.length&&n[a+1].startTime<=t[o].ts;)this.#f=n[++a].tid,this.#m=n[a].pid;this.#_(t[o],r)}this.#f=null,this.#m=null}#_(t,n){v.isSetLayerId(t)&&t.args.data.frame===n?this.#d=t.args.data.layerTreeId:v.isLayerTreeHostImplSnapshot(t)&&Number(t.id)===this.#d?this.#S({entry:t,paints:[]}):(pF(t)&&this.#I(t),t.tid===this.#f&&t.pid===this.#m&&this.#D(t))}#I(t){t.args.layerTreeId===this.#d&&(v.isBeginFrame(t)?this.#g(t.ts,t.args.frameSeqId):v.isDrawFrame(t)?this.#w(t.ts,t.args.frameSeqId):v.isActivateLayerTree(t)?this.#E():v.isRequestMainThreadFrame(t)?this.#T():v.isNeedsBeginFrameChanged(t)?this.#C(t.ts,t.args.data&&!!t.args.data.needsBeginFrame):v.isDroppedFrame(t)&&this.#y(t.ts,t.args.
frameSeqId,!!t.args.hasPartialUpdate))}#D(t){if(fF(t)&&(this.#p=t.ts),!this.#l&&hF.has(t.name)&&(this.#l=new ah(this.#p||t.ts)),!!this.#l){if(v.isBeginMainThreadFrame(t)&&t.args.data.frameId&&(this.#l.mainFrameId=t.args.data.frameId),v.isPaint(t)){let n=this.#h.paintsToSnapshots.get(t);n&&this.#l.paints.push(new rh(t,n))}(v.isCompositeLayers(t)||v.isCommit(t))&&t.args.layerTreeId===this.#d&&this.#x()}}},Qw=class{static{i(this,"TimelineFrame")}cat="devtools.legacy_frame";name="frame";ph=v.Phase.COMPLETE;ts;pid=v.ProcessID(-1);tid=v.ThreadID(-1);index=-1;startTime;startTimeOffset;endTime;duration;idle;dropped;isPartial;layerTree;paints;mainFrameId;seqId;constructor(t,n,r){this.seqId=t,this.startTime=n,this.ts=n,this.startTimeOffset=r,this.endTime=this.startTime,this.duration=I.Micro(0),this.idle=!1,this.dropped=!1,this.isPartial=!1,this.layerTree=null,this.paints=[],this.mainFrameId=void 0}setIndex(t){this.index=t}setEndTime(t){this.endTime=t,this.duration=I.Micro(this.endTime-this.startTime)}setLayerTree(t){
this.layerTree=t}get dur(){return this.duration}},rh=class{static{i(this,"LayerPaintEvent")}#e;#t;constructor(t,n){this.#e=t,this.#t=n}layerId(){return this.#e.args.data.layerId}event(){return this.#e}picture(){let t=this.#t.args.snapshot.params?.layer_rect,n=this.#t.args.snapshot.skp64;return t&&n?{rect:t,serializedPicture:n}:null}},ah=class{static{i(this,"PendingFrame")}paints;mainFrameId;triggerTime;constructor(t){this.paints=[],this.mainFrameId=void 0,this.triggerTime=t}},e0=class{static{i(this,"BeginFrameInfo")}seqId;startTime;isDropped;isPartial;constructor(t,n,r,a){this.seqId=t,this.startTime=n,this.isDropped=r,this.isPartial=a}},oh=class{static{i(this,"TimelineFrameBeginFrameQueue")}queueFrames=[];mapFrames={};addFrameIfNotExists(t,n,r,a){t in this.mapFrames||(this.mapFrames[t]=new e0(t,n,r,a),this.queueFrames.push(t))}setDropped(t,n){t in this.mapFrames&&(this.mapFrames[t].isDropped=n)}setPartial(t,n){t in this.mapFrames&&(this.mapFrames[t].isPartial=n)}processPendingBeginFramesOnDrawFrame(t){
let n=[];if(t in this.mapFrames){for(;this.queueFrames[0]!==t;){let r=this.queueFrames[0];this.mapFrames[r].isDropped&&n.push(this.mapFrames[r]),delete this.mapFrames[r],this.queueFrames.shift()}n.push(this.mapFrames[t]),delete this.mapFrames[t],this.queueFrames.shift()}return n}};i(Ioe,"framesWithinWindow")});var a0={};x(a0,{data:()=>Moe,deps:()=>Ooe,finalize:()=>Noe,handleEvent:()=>Aoe,reset:()=>Doe});function Doe(){n0=new Map,r0=[]}function Aoe(e){v.isGPUTask(e)&&re.addEventToProcessThread(e,n0)}async function Noe(){let{gpuProcessId:e,gpuThreadId:t}=ht(),n=n0.get(e);n&&t&&(r0=n.get(t)||[])}function Moe(){return{mainGPUThreadTasks:r0}}function Ooe(){return["Meta"]}var n0,r0,yF=g(()=>{d();Se();ie();sr();n0=new Map,r0=[];i(Doe,"reset");i(Aoe,"handleEvent");i(Noe,"finalize");i(Moe,"data");i(Ooe,"deps")});var c0={};x(c0,{data:()=>Uoe,finalize:()=>Foe,handleEvent:()=>Loe,reset:()=>Poe});function Poe(){ac=new Map,ih=new Map,sh=new Map,ch=new Map,o0=new Map,i0=new Map,s0=!1}function Loe(e){if(v.isPaintImage(e)){let t=ac.get(e.pid)||new Map,n=t.get(e.tid)||[];n.push(e),t.set(e.tid,n),ac.set(e.pid,t),e.args.data.url&&me.getWithDefault(o0,e.args.data.url,()=>[]).push(e);return}if(v.isDecodeLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=ih.get(e.pid)||new Map,n=t.get(e.tid)||[];n.push(e),t.set(e.tid,n),ih.set(e.pid,t)}if(v.isDrawLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=ac.get(e.pid)?.get(e.tid)?.at(-1);if(!t)return;sh.set(e.args.LazyPixelRef,t);return}if(v.isDecodeImage(e)){let t=ac.get(e.pid)?.get(e.tid)?.at(-1);if(t){ch.set(e,t);return}let n=ih.get(e.pid)?.get(e.tid)?.at(-1);if(typeof n?.args?.LazyPixelRef>"u")return;let r=sh.get(n.args.LazyPixelRef);if(!r)return;ch.set(e,r)}}async function Foe(e){if(!e.metadata?.hostDPR)return;let{devicePixelRatio:t}=ht();if(t){for(let n of ac.
values())for(let r of n.values())for(let a of r){let o=a.args.data.width/e.metadata.hostDPR,s=a.args.data.height/e.metadata.hostDPR,c=o*t,l=s*t;i0.set(a,{width:c,height:l})}s0=!0}}function Uoe(){return{paintImageByDrawLazyPixelRef:sh,paintImageForEvent:ch,paintImageEventForUrl:o0,paintEventToCorrectedDisplaySize:i0,didCorrectForHostDpr:s0}}var ac,ih,sh,ch,o0,i0,s0,vF=g(()=>{d();wt();ie();sr();ac=new Map,ih=new Map,sh=new Map,ch=new Map,o0=new Map,i0=new Map,s0=!1;i(Poe,"reset");i(Loe,"handleEvent");i(Foe,"finalize");i(Uoe,"data")});var h0={};x(h0,{data:()=>Goe,deps:()=>Woe,finalize:()=>zoe,handleEvent:()=>joe,reset:()=>Boe});function Boe(){l0=new Map,Mu=new Map,u0=new Map,d0=new Map,uh=new Map,lh=new Map,m0=new Map,p0=new Map,f0=new Map}function Ao(e){uh.set(e.event,e.initiator);let t=lh.get(e.initiator)||[];t.push(e.event),lh.set(e.initiator,t)}function joe(e){if(v.isScheduleStyleRecalculation(e))l0.set(e.args.data.frame,e);else if(v.isRecalcStyle(e)){if(e.args.beginData){u0.set(e.args.beginData.frame,e);let t=l0.get(e.args.beginData.frame);t&&Ao({event:e,initiator:t})}}else if(v.isInvalidateLayout(e)){let t=e;if(!Mu.has(e.args.data.frame)){let n=u0.get(e.args.data.frame);if(n){let{endTime:r}=j.eventTimingsMicroSeconds(n),a=uh.get(n);a&&r&&r>e.ts&&(t=a)}}Mu.set(e.args.data.frame,t)}else if(v.isLayout(e)){let t=Mu.get(e.args.beginData.frame);t&&Ao({event:e,initiator:t}),Mu.delete(e.args.beginData.frame)}else if(v.isTimerInstall(e))d0.set(e.args.data.timerId,e);else if(v.isTimerFire(e)){let t=d0.get(e.args.data.timerId);
t&&Ao({event:e,initiator:t})}else if(v.isRequestIdleCallback(e))m0.set(e.args.data.id,e);else if(v.isFireIdleCallback(e)){let t=m0.get(e.args.data.id);t&&Ao({event:e,initiator:t})}else if(v.isWebSocketCreate(e))p0.set(e.args.data.identifier,e);else if(v.isWebSocketInfo(e)||v.isWebSocketTransfer(e)){let t=p0.get(e.args.data.identifier);t&&Ao({event:e,initiator:t})}else if(v.isSchedulePostTaskCallback(e))f0.set(e.args.data.taskId,e);else if(v.isRunPostTaskCallback(e)||v.isAbortPostTaskCallback(e)){let t=f0.get(e.args.data.taskId);t&&Ao({event:e,initiator:t})}}function Hoe(){let e=vu().flows;for(let t=0;t<e.length;t++){let n=e[t];for(let r=0;r<n.length-1;r++)Ao({event:n[r+1],initiator:n[r]})}}function qoe(){let e=kw().schedulerToRunEntryPoints.entries();for(let[t,n]of e)for(let r of n)Ao({event:r,initiator:t})}async function zoe(){Hoe(),qoe()}function Goe(){return{eventToInitiator:uh,initiatorToEvents:lh}}function Woe(){return["Flows","AsyncJSCalls"]}var l0,Mu,u0,uh,lh,d0,m0,p0,f0,bF=g(()=>{
d();Se();ie();_w();Lf();l0=new Map,Mu=new Map,u0=new Map,uh=new Map,lh=new Map,d0=new Map,m0=new Map,p0=new Map,f0=new Map;i(Boe,"reset");i(Ao,"storeInitiator");i(joe,"handleEvent");i(Hoe,"createRelationshipsFromFlows");i(qoe,"createRelationshipsFromAsyncJSCalls");i(zoe,"finalize");i(Goe,"data");i(Woe,"deps")});var y0={};x(y0,{data:()=>Zoe,finalize:()=>Joe,handleEvent:()=>Xoe,handleUserConfig:()=>$oe,reset:()=>Voe});function Voe(){dh.clear(),Ou=null}function $oe(e){Ou=e.maxInvalidationEventsPerEvent}function Yoe(e){let t=dh.get(e);return t||(t={invalidationsForEvent:new Map,invalidationCountForEvent:new Map,lastRecalcStyleEvent:null,pendingInvalidations:[],hasPainted:!1},dh.set(e,t)),t}function Koe(e){return v.isRecalcStyle(e)||v.isLayout(e)?e.args.beginData?.frame??null:e.args?.data?.frame??null}function g0(e,t,n){let r=e.invalidationsForEvent.get(t)||[];r.push(n),Ou!==null&&r.length>Ou&&r.shift(),e.invalidationsForEvent.set(t,r);let a=e.invalidationCountForEvent.get(t)??0;e.invalidationCountForEvent.set(t,a+1)}function Xoe(e){if(Ou===0)return;let t=Koe(e);if(!t)return;let n=Yoe(t);if(v.isRecalcStyle(e)){n.lastRecalcStyleEvent=e;for(let r of n.pendingInvalidations)v.isLayoutInvalidationTracking(r)||g0(n,e,r);return}if(v.isInvalidationTracking(e)){if(n.hasPainted&&(n.pendingInvalidations.length=
0,n.lastRecalcStyleEvent=null,n.hasPainted=!1),n.lastRecalcStyleEvent&&(v.isScheduleStyleInvalidationTracking(e)||v.isStyleRecalcInvalidationTracking(e)||v.isStyleInvalidatorInvalidationTracking(e))){let r=n.lastRecalcStyleEvent,a=r.ts+(r.dur||0);e.ts>=r.ts&&e.ts<=a&&g0(n,r,e)}n.pendingInvalidations.push(e);return}if(v.isPaint(e)){n.hasPainted=!0;return}if(v.isLayout(e))for(let r of n.pendingInvalidations)v.isLayoutInvalidationTracking(r)&&g0(n,e,r)}async function Joe(){}function Zoe(){let e=new Map,t=new Map;for(let n of dh.values()){for(let[r,a]of n.invalidationsForEvent.entries())e.set(r,a);for(let[r,a]of n.invalidationCountForEvent.entries())t.set(r,a)}return{invalidationsForEvent:e,invalidationCountForEvent:t}}var dh,Ou,wF=g(()=>{d();ie();dh=new Map,Ou=null;i(Voe,"reset");i($oe,"handleUserConfig");i(Yoe,"getState");i(Koe,"getFrameId");i(g0,"addInvalidationToEvent");i(Xoe,"handleEvent");i(Joe,"finalize");i(Zoe,"data")});var w0={};x(w0,{MetricName:()=>Un,ScoreClassification:()=>kt,data:()=>b0,deps:()=>oie,finalize:()=>aie,getFrameIdForPageLoadEvent:()=>ph,handleEvent:()=>eie,metricIsLCP:()=>iie,reset:()=>Qoe,scoreClassificationForDOMContentLoaded:()=>SF,scoreClassificationForFirstContentfulPaint:()=>EF,scoreClassificationForLargestContentfulPaint:()=>xF,scoreClassificationForTimeToInteractive:()=>TF,scoreClassificationForTotalBlockingTime:()=>CF});function Qoe(){Lu=new Map,Pu=[],v0=[],mh=new Set}function eie(e){v.eventIsPageLoadEvent(e)&&Pu.push(e)}function tie(e,t){let n=e.args.data?.navigationId;if(!n)throw new Error("Navigation event unexpectedly had no navigation ID.");let r=ph(t),{rendererProcessesByFrame:a}=ht(),o=a.get(r);if(!(!o||!o.get(t.pid))&&!v.isNavigationStart(t)){if(v.isFirstContentfulPaint(t)){let c=I.Micro(t.ts-e.ts),l=EF(c),u={event:t,metricName:Un.FCP,classification:l,navigation:e,timing:c};No(r,n,u);return}if(v.isFirstPaint(t)){let c=I.Micro(t.ts-e.ts),l=kt.UNCLASSIFIED,u={event:t,metricName:Un.
FP,classification:l,navigation:e,timing:c};No(r,n,u);return}if(v.isMarkDOMContent(t)){let c=I.Micro(t.ts-e.ts),l={event:t,metricName:Un.DCL,classification:SF(c),navigation:e,timing:c};No(r,n,l);return}if(v.isInteractiveTime(t)){let c=I.Micro(t.ts-e.ts),l={event:t,metricName:Un.TTI,classification:TF(c),navigation:e,timing:c};No(r,n,l);let u=j.milliToMicro(I.Milli(t.args.args.total_blocking_time_ms)),m={event:t,metricName:Un.TBT,classification:CF(u),navigation:e,timing:u};No(r,n,m);return}if(v.isMarkLoad(t)){let c=I.Micro(t.ts-e.ts),l={event:t,metricName:Un.L,classification:kt.UNCLASSIFIED,navigation:e,timing:c};No(r,n,l);return}if(v.isLargestContentfulPaintCandidate(t)){let c=t.args.data?.candidateIndex;if(!c)throw new Error("Largest Contentful Paint unexpectedly had no candidateIndex.");let l=I.Micro(t.ts-e.ts),u={event:t,metricName:Un.LCP,classification:xF(l),navigation:e,timing:l},m=me.getWithDefault(Lu,r,()=>new Map),f=me.getWithDefault(m,n,()=>new Map).get(Un.LCP);if(f===void 0){mh.
add(u.event),No(r,n,u);return}let h=f.event;if(!v.isLargestContentfulPaintCandidate(h))return;let y=h.args.data?.candidateIndex;if(!y)return;y<c&&(mh.delete(h),mh.add(u.event),No(r,n,u));return}if(!v.isLayoutShift(t))return Zs(t,`Unexpected event type: ${t}`)}}function No(e,t,n){let r=me.getWithDefault(Lu,e,()=>new Map),a=me.getWithDefault(r,t,()=>new Map);a.delete(n.metricName),a.set(n.metricName,n)}function ph(e){if(v.isFirstContentfulPaint(e)||v.isInteractiveTime(e)||v.isLargestContentfulPaintCandidate(e)||v.isNavigationStart(e)||v.isLayoutShift(e)||v.isFirstPaint(e))return e.args.frame;if(v.isMarkDOMContent(e)||v.isMarkLoad(e)){let t=e.args.data?.frame;if(!t)throw new Error("MarkDOMContent unexpectedly had no frame ID.");return t}Zs(e,`Unexpected event type: ${e}`)}function nie(e){if(v.isFirstContentfulPaint(e)||v.isLargestContentfulPaintCandidate(e)||v.isFirstPaint(e)){let t=e.args.data?.navigationId;if(!t)throw new Error("Trace event unexpectedly had no navigation ID.");let{navigationsByNavigationId:n}=ht(),
r=n.get(t);return r||null}if(v.isMarkDOMContent(e)||v.isInteractiveTime(e)||v.isLayoutShift(e)||v.isMarkLoad(e)){let t=ph(e),{navigationsByFrameId:n}=ht();return re.getNavigationForTraceEvent(e,t,n)}return v.isNavigationStart(e)?null:Zs(e,`Unexpected event type: ${e}`)}function EF(e){let t=j.secondsToMicro(I.Seconds(1.8)),n=j.secondsToMicro(I.Seconds(3)),r=kt.BAD;return e<=n&&(r=kt.OK),e<=t&&(r=kt.GOOD),r}function TF(e){let t=j.secondsToMicro(I.Seconds(3.8)),n=j.secondsToMicro(I.Seconds(7.3)),r=kt.BAD;return e<=n&&(r=kt.OK),e<=t&&(r=kt.GOOD),r}function xF(e){let t=j.secondsToMicro(I.Seconds(2.5)),n=j.secondsToMicro(I.Seconds(4)),r=kt.BAD;return e<=n&&(r=kt.OK),e<=t&&(r=kt.GOOD),r}function SF(e){return kt.UNCLASSIFIED}function CF(e){let t=j.milliToMicro(I.Milli(200)),n=j.milliToMicro(I.Milli(600)),r=kt.BAD;return e<=n&&(r=kt.OK),e<=t&&(r=kt.GOOD),r}function rie(){let e=[],n=[...Lu.values()].flatMap(r=>[...r.values()]);for(let r=0;r<n.length;r++){let o=n[r].get(Un.LCP);o?.event&&e.push(o.
event)}return e}async function aie(){Pu.sort((a,o)=>a.ts-o.ts);for(let a of Pu){let o=nie(a);o&&tie(o,a)}let e=rie(),t=ht().mainFrameId,n=Pu.filter(a=>!v.isLargestContentfulPaintCandidate(a));v0=[...e,...n].filter(v.isMarkerEvent).filter(a=>ph(a)===t).sort((a,o)=>a.ts-o.ts)}function b0(){return{metricScoresByFrameId:Lu,allMarkerEvents:v0}}function oie(){return["Meta"]}function iie(e){return e.metricName===Un.LCP}var Lu,v0,Pu,mh,kt,Un,Fu=g(()=>{d();wt();Se();ie();sr();Lu=new Map,v0=[];i(Qoe,"reset");Pu=[],mh=new Set;i(eie,"handleEvent");i(tie,"storePageLoadMetricAgainstNavigationId");i(No,"storeMetricScore");i(ph,"getFrameIdForPageLoadEvent");i(nie,"getNavigationForPageLoadEvent");i(EF,"scoreClassificationForFirstContentfulPaint");i(TF,"scoreClassificationForTimeToInteractive");i(xF,"scoreClassificationForLargestContentfulPaint");i(SF,"scoreClassificationForDOMContentLoaded");i(CF,"scoreClassificationForTotalBlockingTime");i(rie,"gatherFinalLCPEvents");i(aie,"finalize");i(b0,"data");i(oie,
"deps");(function(e){e.GOOD="good",e.OK="ok",e.BAD="bad",e.UNCLASSIFIED="unclassified"})(kt||(kt={}));(function(e){e.FCP="FCP",e.FP="FP",e.L="L",e.LCP="LCP",e.DCL="DCL",e.TTI="TTI",e.TBT="TBT",e.CLS="CLS",e.NAV="Nav"})(Un||(Un={}));i(iie,"metricIsLCP")});var x0={};x(x0,{data:()=>uie,deps:()=>die,finalize:()=>lie,handleEvent:()=>cie,reset:()=>sie});function sie(){E0=new Map,T0=new Map}function cie(e){if(!v.isLargestImagePaintCandidate(e)||!e.args.data)return;me.getWithDefault(E0,e.pid,()=>new Map).set(e.args.data.DOMNodeId,e)}async function lie(){let e=Wi().byTime,{traceBounds:t,navigationsByNavigationId:n}=ht(),r=b0().metricScoresByFrameId;for(let[a,o]of n){let c=r.get(o.args.frame)?.get(a)?.get(Un.LCP)?.event;if(!c||!v.isLargestContentfulPaintCandidate(c))continue;let l=c.args.data?.nodeId;if(!l)continue;let u=E0.get(c.pid)?.get(l),m=u?.args.data?.imageUrl;if(!m)continue;let p=o?.ts??t.min,f=u.ts,h;for(let y of e)if(!(y.ts<p)){if(y.ts>=f)break;if(y.args.data.url===m||y.args.data.redirects.some(b=>b.url===m)){h=y;break}}h&&T0.set(a,h)}}function uie(){return{lcpRequestByNavigationId:T0}}function die(){return["Meta","NetworkRequests","PageLoadMetrics"]}var E0,T0,kF=g(()=>{d();wt();ie();sr();ku();Fu();E0=new Map,T0=new Map;i(sie,"reset");
i(cie,"handleEvent");i(lie,"finalize");i(uie,"data");i(die,"deps")});var C0={};x(C0,{data:()=>hie,finalize:()=>fie,handleEvent:()=>pie,reset:()=>mie});function mie(){S0=new Map}function pie(e){v.isLargestTextPaintCandidate(e)&&e.args.data&&S0.set(e.args.data.DOMNodeId,e)}async function fie(){}function hie(){return S0}var S0,RF=g(()=>{d();ie();S0=new Map;i(mie,"reset");i(pie,"handleEvent");i(fie,"finalize");i(hie,"data")});var I0={};x(I0,{data:()=>_0,deps:()=>wie,finalize:()=>vie,handleEvent:()=>yie,reset:()=>gie,screenshotImageDataUri:()=>bie});function gie(){k0=[],R0=[],hh=[],fh=[],_F={}}function yie(e){v.isLegacyScreenshot(e)?R0.push(e):v.isScreenshot(e)?fh.push(e):v.isPipelineReporter(e)&&k0.push(e)}async function vie(){let e=re.createMatchedSortedSyntheticEvents(k0);_F=Object.fromEntries(e.map(t=>{let n=t.args.data.beginEvent.args,a=("frame_reporter"in n?n.frame_reporter:n.chrome_frame_reporter).frame_sequence,o=I.Micro(t.ts+t.dur);return[a,o]}));for(let t of R0){let{cat:n,name:r,ph:a,pid:o,tid:s}=t,c=Ut.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:t,cat:n,name:r,ph:a,pid:o,tid:s,ts:t.ts,args:{dataUri:`data:image/jpg;base64,${t.args.snapshot}`}});hh.push(c)}}function bie(e){return v.isLegacySyntheticScreenshot(e)?e.args.dataUri:`data:image/jpg;base64,${e.args.snapshot}`}function _0(){return{legacySyntheticScreenshots:hh.length?hh:null,screenshots:fh.length?fh:null}}function wie(){return[
"Meta"]}var k0,R0,fh,hh,_F,D0=g(()=>{d();Se();ie();k0=[],R0=[],fh=[],hh=[],_F={};i(gie,"reset");i(yie,"handleEvent");i(vie,"finalize");i(bie,"screenshotImageDataUri");i(_0,"data");i(wie,"deps")});var O0={};x(O0,{LayoutShiftsThreshold:()=>Ba,MAX_CLUSTER_DURATION:()=>yh,MAX_SHIFT_TIME_DELTA:()=>Uu,data:()=>_ie,deps:()=>Iie,finalize:()=>kie,handleEvent:()=>Tie,reset:()=>Eie,scoreClassificationForLayoutShift:()=>Die});function Eie(){Mo=[],ju=[],bh=[],A0=[],xh=[],Sh=[],wh=[],Th=[],Eh=[],Bu=[],oc=new Set,Kn=[],vh=0,ic=[],N0=-1,M0=new Map}function Tie(e){if(v.isLayoutShift(e)&&!e.args.data?.had_recent_input){Mo.push(e);return}if(v.isLayoutInvalidationTracking(e)){ju.push(e);return}if(v.isScheduleStyleInvalidationTracking(e)&&bh.push(e),v.isStyleRecalcInvalidationTracking(e)&&A0.push(e),v.isPrePaint(e)){xh.push(e);return}if(v.isRenderFrameImplCreateChildFrame(e)&&wh.push(e),v.isDomLoading(e)&&Eh.push(e),v.isLayoutImageUnsized(e)&&Th.push(e),v.isBeginRemoteFontLoad(e)&&Bu.push({display:e.args.display,url:e.args.url,beginRemoteFontLoadEvent:e}),v.isRemoteFontLoaded(e))for(let t of Bu)t.url===e.args.url&&(t.name=e.args.name);v.isPaintImage(e)&&Sh.push(e)}function gh(e){return{min:e,max:e,
range:I.Micro(0)}}function Er(e,t){e.max=t,e.range=I.Micro(e.max-e.min)}function xie(e){let t=_0();if(t.screenshots){let n=re.findPreviousEventBeforeTimestamp(t.screenshots,e),r=n?t.screenshots[t.screenshots.indexOf(n)+1]:null;return{before:n,after:r}}if(t.legacySyntheticScreenshots){let n=re.findPreviousEventBeforeTimestamp(t.legacySyntheticScreenshots,e),r=n?t.legacySyntheticScreenshots[t.legacySyntheticScreenshots.indexOf(n)+1]:null;return{before:n,after:r}}return{before:null,after:null}}function Sie(){let{traceBounds:e}=ht();ic.push({ts:e.min,score:0});for(let t of Kn){let n=0;t.events[0].args.data&&ic.push({ts:t.clusterWindow.min,score:t.events[0].args.data.weighted_score_delta});for(let r=0;r<t.events.length;r++){let a=t.events[r];a.args.data&&(n+=a.args.data.weighted_score_delta,ic.push({ts:a.ts,score:n}))}ic.push({ts:t.clusterWindow.max,score:0})}}function Cie(){oc.clear();for(let e of Mo)if(e.args.data?.impacted_nodes)for(let t of e.args.data.impacted_nodes)oc.add(t.node_id);for(let e of ju)
e.args.data?.nodeId&&oc.add(e.args.data.nodeId);for(let e of bh)e.args.data?.nodeId&&oc.add(e.args.data.nodeId)}async function kie(){Mo.sort((e,t)=>e.ts-t.ts),xh.sort((e,t)=>e.ts-t.ts),ju.sort((e,t)=>e.ts-t.ts),wh.sort((e,t)=>e.ts-t.ts),Eh.sort((e,t)=>e.ts-t.ts),Th.sort((e,t)=>e.ts-t.ts),Bu.sort((e,t)=>e.beginRemoteFontLoadEvent.ts-t.beginRemoteFontLoadEvent.ts),Sh.sort((e,t)=>e.ts-t.ts),await Rie(),Sie(),Cie()}async function Rie(){let{navigationsByFrameId:e,mainFrameId:t,traceBounds:n}=ht(),r=e.get(t)||[];if(Mo.length===0)return;let a=Mo[0].ts,o=Mo[0].ts,s=null;for(let c of Mo){let l=c.ts-a>yh,u=c.ts-o>Uu,m=Wt.nearestIndexFromEnd(r,b=>b.ts<c.ts),p=s!==m&&m!==null;if(l||u||p||!Kn.length){let b=c.ts,w=l?a+yh:1/0,C=u?o+Uu:1/0,k=p?r[m].ts:1/0,R=Math.min(w,C,k);if(Kn.length>0){let _=Kn[Kn.length-1];Er(_.clusterWindow,I.Micro(R))}let S=m===null?v.NO_NAVIGATION:r[m].args.data?.navigationId;Kn.push(Ut.SyntheticEventsManager.registerSyntheticEvent({name:"SyntheticLayoutShiftCluster",rawSourceEvent:c,
events:[],clusterWindow:gh(b),clusterCumulativeScore:0,scoreWindows:{good:gh(b)},navigationId:S,ts:c.ts,pid:c.pid,tid:c.tid,ph:v.Phase.COMPLETE,cat:"",dur:I.Micro(-1)})),a=b}let f=Kn[Kn.length-1],h=m!==null?I.Micro(c.ts-r[m].ts):void 0;if(f.clusterCumulativeScore+=c.args.data?c.args.data.weighted_score_delta:0,!c.args.data)continue;let y=Ut.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:c,...c,name:v.Name.SYNTHETIC_LAYOUT_SHIFT,args:{frame:c.args.frame,data:{...c.args.data,rawEvent:c,navigationId:f.navigationId??void 0}},parsedData:{timeFromNavigation:h,screenshots:xie(c.ts),cumulativeWeightedScoreInWindow:f.clusterCumulativeScore,sessionWindowData:{cumulativeWindowScore:0,id:Kn.length}}});f.events.push(y),Er(f.clusterWindow,c.ts),o=c.ts,s=m}for(let c of Kn){let l=0,u=-1;if(c===Kn[Kn.length-1]){let h=yh+c.clusterWindow.min,y=c.clusterWindow.max+Uu,b=Wt.nearestIndexFromBeginning(r,k=>k.ts>c.clusterWindow.max),w=b?r[b].ts:1/0,C=Math.min(h,y,n.max,w);Er(c.clusterWindow,I.Micro(
C))}let m=0,p=null;for(let h of c.events){l+=h.args.data?h.args.data.weighted_score_delta:0,u=h.parsedData.sessionWindowData.id;let y=h.ts;h.parsedData.sessionWindowData.cumulativeWindowScore=c.clusterCumulativeScore,l<Ba.NEEDS_IMPROVEMENT?Er(c.scoreWindows.good,y):l>=Ba.NEEDS_IMPROVEMENT&&l<Ba.BAD?(c.scoreWindows.needsImprovement||(Er(c.scoreWindows.good,I.Micro(y-1)),c.scoreWindows.needsImprovement=gh(y)),Er(c.scoreWindows.needsImprovement,y)):l>=Ba.BAD&&(c.scoreWindows.bad||(c.scoreWindows.needsImprovement?Er(c.scoreWindows.needsImprovement,I.Micro(y-1)):Er(c.scoreWindows.good,I.Micro(y-1)),c.scoreWindows.bad=gh(h.ts)),Er(c.scoreWindows.bad,y)),c.scoreWindows.bad?Er(c.scoreWindows.bad,c.clusterWindow.max):c.scoreWindows.needsImprovement?Er(c.scoreWindows.needsImprovement,c.clusterWindow.max):Er(c.scoreWindows.good,c.clusterWindow.max);let b=h.args.data?.weighted_score_delta;b!==void 0&&b>m&&(m=b,p=h)}p&&(c.worstShiftEvent=p,c.rawSourceEvent=p),c.ts=c.events[0].ts;let f=j.eventTimingsMicroSeconds(
c.events[c.events.length-1]);c.dur=I.Micro(f.endTime-c.events[0].ts+Uu),l>vh&&(N0=u,vh=l),c.navigationId&&me.getWithDefault(M0,c.navigationId,()=>[]).push(c)}}function _ie(){return{clusters:Kn,sessionMaxScore:vh,clsWindowID:N0,prePaintEvents:xh,layoutInvalidationEvents:ju,scheduleStyleInvalidationEvents:bh,styleRecalcInvalidationEvents:A0,renderFrameImplCreateChildFrameEvents:wh,domLoadingEvents:Eh,layoutImageUnsizedEvents:Th,remoteFonts:Bu,scoreRecords:ic,backendNodeIds:oc,clustersByNavigationId:M0,paintImageEvents:Sh}}function Iie(){return["Screenshots","Meta"]}function Die(e){let t=kt.GOOD;return e>=Ba.NEEDS_IMPROVEMENT&&(t=kt.OK),e>=Ba.BAD&&(t=kt.BAD),t}var yh,Uu,Mo,ju,bh,A0,wh,Eh,Th,Bu,oc,xh,Sh,vh,N0,Kn,M0,ic,Ba,IF=g(()=>{d();wt();Se();ie();sr();Fu();D0();yh=j.milliToMicro(I.Milli(5e3)),Uu=j.milliToMicro(I.Milli(1e3)),Mo=[],ju=[],bh=[],A0=[],wh=[],Eh=[],Th=[],Bu=[],oc=new Set,xh=[],Sh=[],vh=0,N0=-1,Kn=[],M0=new Map,ic=[];i(Eie,"reset");i(Tie,"handleEvent");i(gh,"traceWindowFromTim\
e");i(Er,"updateTraceWindowMax");i(xie,"findScreenshots");i(Sie,"buildScoreRecords");i(Cie,"collectNodes");i(kie,"finalize");i(Rie,"buildLayoutShiftsClusters");i(_ie,"data");i(Iie,"deps");i(Die,"scoreClassificationForLayoutShift");(function(e){e[e.GOOD=0]="GOOD",e[e.NEEDS_IMPROVEMENT=.1]="NEEDS_IMPROVEMENT",e[e.BAD=.25]="BAD"})(Ba||(Ba={}))});var P0={};x(P0,{data:()=>Oie,finalize:()=>Mie,handleEvent:()=>Nie,reset:()=>Aie});function Aie(){Ch=new Map}function Nie(e){if(v.isUpdateCounters(e)){let t=me.getWithDefault(Ch,e.pid,()=>[]);t.push(e),Ch.set(e.pid,t)}}async function Mie(){}function Oie(){return{updateCountersByProcess:Ch}}var Ch,DF=g(()=>{d();wt();ie();Ch=new Map;i(Aie,"reset");i(Nie,"handleEvent");i(Mie,"finalize");i(Oie,"data")});var L0={};x(L0,{data:()=>Uie,finalize:()=>Fie,handleEvent:()=>Lie,reset:()=>Pie});function Pie(){Hu=new Map}function Lie(e){if(v.isTracingStartedInBrowser(e)){for(let t of e.args.data?.frames??[])Hu.set(t.frame,t);return}if(v.isCommitLoad(e)){let t=e.args.data;if(!t)return;let n=Hu.get(t.frame);if(!n)return;Hu.set(t.frame,{...n,url:t.url||n.url,name:t.name||t.name})}}async function Fie(){}function Uie(){return{frames:Hu}}var Hu,AF=g(()=>{d();ie();Hu=new Map;i(Pie,"reset");i(Lie,"handleEvent");i(Fie,"finalize");i(Uie,"data")});var F0={};x(F0,{data:()=>Kie,deps:()=>Bie,finalize:()=>Yie,getScriptGeneratedSizes:()=>Vie,handleEvent:()=>Hie,reset:()=>jie});function NF(e,t){if(t.startsWith("data:")||t.startsWith("blob:")||t.startsWith("javascript:")||t.startsWith("mailto:"))return t;try{return new URL(t,e).href}catch{}return null}function Bie(){return["Meta","NetworkRequests"]}function jie(){qu=new Map}function Hie(e){let t=i((n,r)=>{let a=String(r),o=`${n}.${a}`;return me.getWithDefault(qu,o,()=>({isolate:n,scriptId:a,frame:"",ts:e.ts}))},"getOrMakeScript");if(v.isRundownScriptCompiled(e)&&e.args.data){let{isolate:n,scriptId:r,frame:a}=e.args.data,o=t(n,r);o.frame=a,o.ts=e.ts;return}if(v.isRundownScript(e)){let{isolate:n,scriptId:r,url:a,sourceUrl:o,sourceMapUrl:s,sourceMapUrlElided:c}=e.args.data,l=t(n,r);l.url=a,l.ts=e.ts,o&&(l.sourceUrl=o),c?l.sourceMapUrlElided=!0:s&&(l.sourceMapUrl=s);return}if(v.isRundownScriptSource(e)){let{isolate:n,scriptId:r,sourceText:a}=e.args.data,o=t(n,r);o.content=a;return}if(v.isRundownScriptSourceLarge(
e)){let{isolate:n,scriptId:r,sourceText:a}=e.args.data,o=t(n,r);o.content=(o.content??"")+a;return}}function qie(e,t){for(let n of e.frameByProcessId?.values()){let r=n.get(t);if(r)return r}return null}function zie(e,t){return t.url?e.find(n=>n.args.data.url===t.url)??null:null}function Gie(e){let t=new Map,n=e.mappings();for(let r=0;r<n.length-1;r++){let a=n[r],o=n[r+1];a.lineNumber===o.lineNumber&&t.set(a,o.columnNumber)}return t}function Wie(e){if(!e.sourceMap)throw new Error("expected source map");let t=e.sourceMap,n=e.content??"",r=n.length,a=n.split(`
`),o={},s=r,c=s,l=Gie(e.sourceMap);for(let u of t.mappings()){let m=u.sourceURL,p=u.lineNumber,f=u.columnNumber,h=l.get(u);if(!m)continue;let y=a[p];if(y==null)return{errorMessage:`${t.url()} mapping for line out of bounds: ${p+1}`};if(f>y.length)return{errorMessage:`${t.url()} mapping for column out of bounds: ${p+1}:${f}`};let b=0;if(h!==void 0){if(h>y.length)return{errorMessage:`${t.url()} mapping for last column out of bounds: ${p+1}:${h}`};b=h-f}else b=y.length-f+1;o[m]=(o[m]||0)+b,c-=b}return{files:o,unmappedBytes:c,totalBytes:s}}function Vie(e){return e.sourceMap&&!e.sizes&&(e.sizes=Wie(e)),e.sizes??null}function $ie(e,t){if(t.isFreshRecording||!t.metadata?.sourceMaps)return;if(e.sourceMapUrlElided){if(!e.url)return;let r=t.metadata.sourceMaps.find(a=>a.url===e.url);return r?r.sourceMap:void 0}if(!e.sourceMapUrl)return;if(!e.sourceMapUrl.startsWith("data:")){let r=t.metadata.sourceMaps.find(a=>a.sourceMapUrl===e.sourceMapUrl);if(r)return r.sourceMap}}async function Yie(e){let t=ht(),
n=[...Wi().byId.values()],r=new Set;for(let o of t.frameByProcessId.values())for(let s of o.values())r.add(s.url);for(let o of qu.values())o.request=zie(n,o)??void 0,o.inline=!!o.url&&r.has(o.url);if(!e.resolveSourceMap)return;let a=[];for(let o of qu.values()){if(!o.frame||!o.url||!o.sourceMapUrl&&!o.sourceMapUrlElided)continue;let s=qie(t,o.frame)?.url;if(!s)continue;let c=o.url;o.sourceUrl&&(c=NF(s,o.sourceUrl)??o.sourceUrl);let l;if(o.sourceMapUrl){if(l=NF(c,o.sourceMapUrl),!l)continue;o.sourceMapUrl=l}let u={scriptId:o.scriptId,scriptUrl:o.url,sourceUrl:c,sourceMapUrl:l??"",frame:o.frame,cachedRawSourceMap:$ie(o,e)},m=e.resolveSourceMap(u).then(p=>{p&&(o.sourceMap=p)});a.push(m.catch(p=>{console.error("Uncaught error when resolving source map",u,p)}))}await Promise.all(a)}function Kie(){return{scripts:[...qu.values()]}}var qu,MF=g(()=>{d();wt();ie();sr();ku();i(NF,"completeURL");qu=new Map;i(Bie,"deps");i(jie,"reset");i(Hie,"handleEvent");i(qie,"findFrame");i(zie,"findNetworkReque\
st");i(Gie,"computeMappingEndColumns");i(Wie,"computeGeneratedFileSizes");i(Vie,"getScriptGeneratedSizes");i($ie,"findCachedRawSourceMap");i(Yie,"finalize");i(Kie,"data")});var j0={};x(j0,{data:()=>Qie,finalize:()=>Zie,handleEvent:()=>Jie,reset:()=>Xie});function Xie(){sc=null,cc=null,U0=new Map,B0=[]}function Jie(e){if(v.isStyleRecalcInvalidationTracking(e)&&e.args.data.subtree&&e.args.data.reason===v.StyleRecalcInvalidationReason.RELATED_STYLE_RULE&&cc&&e.args.data.nodeId===cc.backendNodeId){cc.subtree=!0;return}if(v.isSelectorStats(e)&&sc&&e.args.selector_stats){U0.set(sc,{timings:e.args.selector_stats.selector_timings});return}if(v.isStyleInvalidatorInvalidationTracking(e)){let t=new Array;e.args.data.selectors?.forEach(n=>{t.push({selector:n.selector,styleSheetId:n.style_sheet_id})}),t.length>0&&(cc={frame:e.args.data.frame,backendNodeId:e.args.data.nodeId,type:v.InvalidationEventType.StyleInvalidatorInvalidationTracking,selectorList:t,ts:e.ts,tts:e.tts,subtree:!1,lastRecalcStyleEventTs:sc?sc.ts:I.Micro(0)},B0.push(cc))}if(v.isRecalcStyle(e)){sc=e;return}}async function Zie(){}function Qie(){return{dataForRecalcStyleEvent:U0,invalidatedNodeList:B0}}var sc,
cc,U0,B0,OF=g(()=>{d();ie();sc=null,cc=null,U0=new Map,B0=new Array;i(Xie,"reset");i(Jie,"handleEvent");i(Zie,"finalize");i(Qie,"data")});var Y0={};x(Y0,{LONG_INTERACTION_THRESHOLD:()=>G0,categoryOfInteraction:()=>PF,data:()=>$0,deps:()=>sse,finalize:()=>ise,handleEvent:()=>rse,removeNestedInteractionsAndSetProcessingTime:()=>LF,reset:()=>nse,scoreClassificationForInteractionToNextPaint:()=>cse});function nse(){q0=[],z0=[],lc=[],W0=[],V0=[],kh=[],zu=null}function rse(e){if(v.isBeginCommitCompositorFrame(e)){q0.push(e);return}if(v.isParseMetaViewport(e)){z0.push(e);return}if(!v.isEventTiming(e)||(v.isEventTimingEnd(e)&&V0.push(e),!e.args.data||!v.isEventTimingStart(e)))return;let{duration:t,interactionId:n}=e.args.data;t<1||n===void 0||n===0||W0.push(e)}function PF(e){return ase.has(e.type)?"POINTER":ose.has(e.type)?"KEYBOARD":"OTHER"}function LF(e){let t={POINTER:new Map,KEYBOARD:new Map,OTHER:new Map};function n(a){let o=PF(a),s=t[o],c=I.Micro(a.ts+a.dur),l=s.get(c);if(!l){s.set(c,a);return}if(a.ts<l.ts)s.set(c,a);else if(a.ts===l.ts&&a.interactionId===l.interactionId){let u=l.processingEnd-l.processingStart;a.processingEnd-
a.processingStart>u&&s.set(c,a)}a.processingStart<l.processingStart&&(l.processingStart=a.processingStart,H0(l)),a.processingEnd>l.processingEnd&&(l.processingEnd=a.processingEnd,H0(l))}i(n,"storeEventIfEarliestForCategoryAndEndTime");for(let a of e)n(a);let r=Object.values(t).flatMap(a=>Array.from(a.values()));return r.sort((a,o)=>a.ts-o.ts),r}function H0(e){let t=e.args.data.beginEvent,n=e.args.data.endEvent;e.inputDelay=I.Micro(e.processingStart-t.ts),e.mainThreadHandling=I.Micro(e.processingEnd-e.processingStart),e.presentationDelay=I.Micro(n.ts-e.processingEnd)}async function ise(){let{navigationsByFrameId:e}=ht(),t=Wt.mergeOrdered(W0,V0,re.eventTimeComparator),n=new Map;for(let r of t)if(v.isEventTimingStart(r)){let a=n.get(r.id)??[];a.push(r),n.set(r.id,a)}else if(v.isEventTimingEnd(r)){let o=(n.get(r.id)??[]).pop();if(!o)continue;let{type:s,interactionId:c,timeStamp:l,processingStart:u,processingEnd:m}=o.args.data;if(!s||!c||!l||!u||!m)continue;let p=I.Micro(j.milliToMicro(u)-j.
milliToMicro(l)+o.ts),f=I.Micro(j.milliToMicro(m)-j.milliToMicro(l)+o.ts),h=o.args.frame??o.args.data.frame??"",b=re.getNavigationForTraceEvent(o,h,e)?.args.data?.navigationId,w=Ut.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:o,cat:o.cat,name:o.name,pid:o.pid,tid:o.tid,ph:o.ph,processingStart:p,processingEnd:f,inputDelay:I.Micro(-1),mainThreadHandling:I.Micro(-1),presentationDelay:I.Micro(-1),args:{data:{beginEvent:o,endEvent:r,frame:h,navigationId:b}},ts:o.ts,dur:I.Micro(r.ts-o.ts),type:o.args.data.type,interactionId:o.args.data.interactionId});H0(w),lc.push(w)}re.sortTraceEventsInPlace(lc),kh.push(...LF(lc));for(let r of kh)(!zu||zu.dur<r.dur)&&(zu=r)}function $0(){return{beginCommitCompositorFrameEvents:q0,parseMetaViewportEvents:z0,interactionEvents:lc,interactionEventsWithNoNesting:kh,longestInteractionEvent:zu,interactionsOverThreshold:new Set(lc.filter(e=>e.dur>G0))}}function sse(){return["Meta"]}function cse(e){return e<=ese?kt.GOOD:e<=tse?kt.OK:kt.BAD}var q0,z0,
G0,ese,tse,zu,lc,kh,W0,V0,ase,ose,K0=g(()=>{d();wt();Se();ie();sr();Fu();q0=[],z0=[],G0=j.milliToMicro(I.Milli(200)),ese=G0,tse=j.milliToMicro(I.Milli(500)),zu=null,lc=[],kh=[],W0=[],V0=[];i(nse,"reset");i(rse,"handleEvent");ase=new Set(["pointerdown","touchstart","pointerup","touchend","mousedown","mouseup","click"]),ose=new Set(["keydown","keypress","keyup"]);i(PF,"categoryOfInteraction");i(LF,"removeNestedInteractionsAndSetProcessingTime");i(H0,"writeSyntheticTimespans");i(ise,"finalize");i($0,"data");i(sse,"deps");i(cse,"scoreClassificationForInteractionToNextPaint")});var Q0={};x(Q0,{data:()=>Z0,finalize:()=>dse,handleEvent:()=>use,reset:()=>lse});function lse(){Rh=[],X0=new Map,J0=new Map}function use(e){v.isTracingSessionIdForWorker(e)&&Rh.push(e)}async function dse(){for(let e of Rh)e.args.data&&(X0.set(e.args.data.workerThreadId,e.args.data.workerId),J0.set(e.args.data.workerId,e.args.data.url))}function Z0(){return{workerSessionIdEvents:Rh,workerIdByThread:X0,workerURLById:J0}}var Rh,X0,J0,eE=g(()=>{d();ie();Rh=[],X0=new Map,J0=new Map;i(lse,"reset");i(use,"handleEvent");i(dse,"finalize");i(Z0,"data")});var rE={};x(rE,{FORCED_REFLOW_THRESHOLD:()=>UF,LONG_MAIN_THREAD_TASK_THRESHOLD:()=>BF,data:()=>yse,deps:()=>hse,finalize:()=>gse,handleEvent:()=>pse,reset:()=>mse});function mse(){_h=new Map,Ih=new Map,tE=[],nE=[],Gu=[],Dh=[]}function Ah(e,t){let n=me.getWithDefault(_h,e,()=>[]);n.push(t),_h.set(e,n);let r=me.getWithDefault(Ih,t,()=>[]);r.push(e),Ih.set(t,r)}function pse(e){if(fse(e),e.name===v.Name.RUN_TASK){let{duration:t}=j.eventTimingsMicroSeconds(e);t>BF&&Dh.push(e);return}if(v.isFireIdleCallback(e)){let{duration:t}=j.eventTimingsMilliSeconds(e);t>e.args.data.allottedMilliseconds&&Ah(e,"IDLE_CALLBACK_OVER_TIME");return}}function fse(e){if(FF(e,tE),FF(e,nE,v.isJSInvocationEvent(e)),nE.length&&(e.name===v.Name.LAYOUT||e.name===v.Name.RECALC_STYLE)){Gu.push(e);return}tE.length===1&&(Gu.reduce((n,r)=>n+(r.dur||0),0)>=UF&&Gu.forEach(n=>Ah(n,"FORCED_REFLOW")),Gu.length=0)}function FF(e,t,n=!0){let r=t.at(-1);for(;r&&e.ts>r.ts+(r.dur||0);)t.pop(),r=t.at(-1);n&&t.push(e)}function hse(){return[
"UserInteractions","Workers"]}async function gse(){let e=$0().interactionsOverThreshold;for(let t of e)Ah(t,"LONG_INTERACTION");for(let t of Dh)t.tid,!Z0().workerIdByThread.has(t.tid)&&Ah(t,"LONG_TASK");Dh.length=0}function yse(){return{perEvent:_h,perWarning:Ih}}var _h,Ih,tE,nE,Gu,Dh,UF,BF,jF=g(()=>{d();wt();Se();ie();K0();eE();_h=new Map,Ih=new Map,tE=[],nE=[],Gu=[],Dh=[],UF=j.milliToMicro(I.Milli(30)),BF=j.milliToMicro(I.Milli(50));i(mse,"reset");i(Ah,"storeWarning");i(pse,"handleEvent");i(fse,"processForcedReflowWarning");i(FF,"accomodateEventInStack");i(hse,"deps");i(gse,"finalize");i(yse,"data")});var dt={};x(dt,{AnimationFrames:()=>Pb,Animations:()=>Ub,AsyncJSCalls:()=>Rw,AuctionWorklets:()=>Jb,DOMStats:()=>Dw,ExtensionTraceData:()=>qw,Flows:()=>Wb,Frames:()=>t0,GPU:()=>a0,ImagePainting:()=>c0,Initiators:()=>h0,Invalidations:()=>y0,LargestImagePaint:()=>x0,LargestTextPaint:()=>C0,LayerTree:()=>Kw,LayoutShifts:()=>O0,Memory:()=>P0,Meta:()=>ow,NetworkRequests:()=>lw,PageFrames:()=>L0,PageLoadMetrics:()=>w0,Renderer:()=>Ew,Samples:()=>gw,Screenshots:()=>I0,Scripts:()=>F0,SelectorStats:()=>j0,UserInteractions:()=>Y0,UserTimings:()=>Lw,Warnings:()=>rE,Workers:()=>Q0});var HF=g(()=>{d();j3();H3();_w();Ff();oF();mF();Lf();gF();yF();vF();bF();wF();kF();RF();Xw();IF();DF();sr();ku();AF();Fu();Kf();yw();D0();MF();OF();K0();Fw();jF();eE()});var qF={};var zF=g(()=>{d()});var Vt={};x(Vt,{Helpers:()=>vr,ModelHandlers:()=>dt,Threads:()=>Yi,Types:()=>qF});var tn=g(()=>{d();_f();HF();Zw();zF()});var GF=g(()=>{d();tn();Se()});var WF=g(()=>{d();Se();ie()});var Nh={};x(Nh,{computeScriptDuplication:()=>Sse,getNodeModuleName:()=>KF,normalizeDuplication:()=>aE,normalizeSource:()=>YF});function YF(e){e=e.replace(/\?$/,"");let t=e.lastIndexOf("node_modules");return t!==-1&&(e=e.substring(t)),e}function Tse(e){return!!(e.includes("webpack/bootstrap")||e.includes("(webpack)/buildin")||e.includes("external "))}function aE(e){for(let[t,n]of e){if(n.duplicates.sort((r,a)=>a.attributedSize-r.attributedSize),n.duplicates.length>1){let r=n.duplicates[0].attributedSize;n.duplicates=n.duplicates.filter(a=>a.attributedSize/r>=Ese)}if(n.duplicates=n.duplicates.filter(r=>r.attributedSize>=wse),n.duplicates.length<=1){e.delete(t);continue}n.estimatedDuplicateBytes=n.duplicates.slice(1).reduce((r,a)=>r+a.attributedSize,0)}}function VF(e,t,n=0){let r=e.indexOf(t,n);return r===-1?e.length:r}function KF(e){let t=e.split("node_modules/");e=t[t.length-1];let n=VF(e,"/");return e[0]==="@"?e.slice(0,VF(e,"/",n+1)):e.slice(0,n)}function xse(e){let t=new Map;for(let[
n,r]of e){if(!n.includes("node_modules")){t.set(n,r);continue}let a="node_modules/"+KF(n),o=t.get(a)??{duplicates:[],estimatedDuplicateBytes:0};t.set(a,o);for(let{script:s,attributedSize:c}of r.duplicates){let l=o.duplicates.find(u=>u.script===s);l||(l={script:s,attributedSize:0},o.duplicates.push(l)),l.attributedSize+=c}}return t}function $F(e){return new Map([...e].sort((t,n)=>n[1].estimatedDuplicateBytes-t[1].estimatedDuplicateBytes))}function Sse(e,t){let n=new Map;for(let o of e.scripts){if(!o.content||!o.sourceMap)continue;let s=dt.Scripts.getScriptGeneratedSizes(o);if(!s)continue;if("errorMessage"in s){console.error(s.errorMessage);continue}let c=[];n.set(o,c);let l=o.sourceMap.sourceURLs();for(let u=0;u<l.length;u++){if(Tse(l[u]))continue;let m=s.files[l[u]];c.push({source:YF(l[u]),resourceSize:m})}}let r=new Map;for(let[o,s]of n)for(let c of s){let l=r.get(c.source);l||(l={estimatedDuplicateBytes:0,duplicates:[]},r.set(c.source,l));let u=o.request?t.get(o.request?.args.data.requestId)??
1:1,m=Math.round(c.resourceSize*u);l.duplicates.push({script:o,attributedSize:m})}let a=xse(r);return aE(r),aE(a),{duplication:$F(r),duplicationGroupedByNodeModules:$F(a)}}var wse,Ese,XF=g(()=>{d();tn();wse=1024*.5,Ese=.1;i(YF,"normalizeSource");i(Tse,"shouldIgnoreSource");i(aE,"normalizeDuplication");i(VF,"indexOfOrLength");i(KF,"getNodeModuleName");i(xse,"groupByNodeModules");i($F,"sorted");i(Sse,"computeScriptDuplication")});var Mh={};x(Mh,{clearCacheForTrace:()=>Cse,get:()=>iE,stackTraceForEventInTrace:()=>uc});function Cse(e){uc.delete(e)}function iE(e,t){let n=uc.get(t);n||(n=new Map,uc.set(t,n));let r=n.get(e);if(r)return r;let a=null;if(Yn.isSyntheticExtensionEntry(e))a=Rse(e,t);else if(v.isPerformanceMeasureBegin(e))a=ZF(e,t);else{a=kse(e,t);let o=_se(e).filter(s=>!oE(s));if(!a.callFrames.length)a.callFrames=o;else for(let s=0;s<o.length&&s<a.callFrames.length;s++)a.callFrames[s]=o[s]}return a&&n.set(e,a),a}function kse(e,t){let n=t.Renderer.entryToNode.size>0?t.Renderer.entryToNode:t.Samples.entryToNode,r={callFrames:[]},a=r,o,s=n.get(e),c=uc.get(t)||new Map;for(uc.set(t,c);s;){if(!v.isProfileCall(s.entry)){let p=t.AsyncJSCalls.runEntryPointToScheduler.get(s.entry);if(!p){s=s.parent;continue}let f=p&&n.get(p.scheduler);f&&(a=JF(a,p.taskName),s=f);continue}o=s.entry;let l=c.get(s.entry);if(l){a.callFrames.push(...l.callFrames.filter(p=>!oE(p))),a.parent=l.parent,a.description=a.description||l.description;
break}oE(o.callFrame)||a.callFrames.push(o.callFrame);let u=t.AsyncJSCalls.asyncCallToScheduler.get(o),m=u&&n.get(u.scheduler);if(m){a=JF(a,u.taskName),s=m;continue}s=s.parent}return r}function JF(e,t){let n={callFrames:[]};return e.parent=n,n.description=t,n}function Rse(e,t){let n=e.rawSourceEvent;return v.isPerformanceMeasureBegin(n)?ZF(n,t):n?iE(n,t):null}function ZF(e,t){let n=e;return e.args.traceId===void 0||(n=t.UserTimings.measureTraceByTraceId.get(e.args.traceId),!n)?null:iE(n,t)}function oE({columnNumber:e,lineNumber:t,url:n,scriptId:r}){return t===-1&&e===-1&&n===""&&r==="0"}function _se(e){let t=re.getZeroIndexedStackTraceInEventPayload(e)||[],n=[];for(let r of t)n.push({...r,scriptId:String(r.scriptId)});return n}var uc,QF=g(()=>{d();Se();ie();uc=new Map;i(Cse,"clearCacheForTrace");i(iE,"get");i(kse,"getForEvent");i(JF,"addAsyncParentToStack");i(Rse,"getForExtensionEntry");i(ZF,"getForPerformanceMeasure");i(oE,"isNativeJSFunction");i(_se,"getTraceEventPayloadStackAsProtoc\
olCallFrame")});var Oh,Ph,Lh,sE=g(()=>{d();ie();Oh=class{static{i(this,"TraceFilter")}},Ph=class e extends Oh{static{i(this,"VisibleEventsFilter")}visibleTypes;constructor(t){super(),this.visibleTypes=new Set(t)}accept(t){return Yn.isSyntheticExtensionEntry(t)?!0:this.visibleTypes.has(e.eventType(t))}static eventType(t){return t.cat.includes("blink.console")?v.Name.CONSOLE_TIME:t.cat.includes("blink.user_timing")?v.Name.USER_TIMING:t.name}},Lh=class extends Oh{static{i(this,"ExclusiveNameFilter")}#e;constructor(t){super(),this.#e=new Set(t)}accept(t){return!this.#e.has(t.name)}}});function Fh(e){if(v.isProfileCall(e)){let t=Ua.isNativeRuntimeFrame(e.callFrame)?Ua.nativeGroup(e.callFrame.functionName):e.callFrame.functionName,n=e.callFrame.scriptId||e.callFrame.url||"";return`f:${t}@${n}`}return v.isConsoleTimeStamp(e)&&e.args.data?`${e.name}:${e.args.data.name}`:v.isSyntheticNetworkRequest(e)||v.isReceivedDataEvent(e)?`req:${e.args.data.requestId}`:e.name}var Wu,Uh,cE,Bh,lE=g(()=>{d();Se();Db();ie();Wu=class{static{i(this,"Node")}totalTime;selfTime;transferSize;id;event;events;parent;groupId;isGroupNodeInternal;depth;constructor(t,n){this.totalTime=0,this.selfTime=0,this.transferSize=0,this.id=t,this.event=n,this.events=[n],this.groupId="",this.isGroupNodeInternal=!1,this.depth=0}isGroupNode(){return this.isGroupNodeInternal}hasChildren(){throw new Error("Not implemented")}setHasChildren(t){throw new Error("Not implemented")}children(){throw new Error("Not implemented")}searchTree(t,n){n=n||[],this.event&&t(this.event)&&n.push(this);for(let r of this.children().
values())r.searchTree(t,n);return n}},Uh=class extends Wu{static{i(this,"BottomUpRootNode")}childrenInternal;textFilter;filter;startTime;endTime;totalTime;eventGroupIdCallback;calculateTransferSize;forceGroupIdCallback;constructor(t,{textFilter:n,filters:r,startTime:a,endTime:o,eventGroupIdCallback:s,calculateTransferSize:c,forceGroupIdCallback:l}){super("",t[0]),this.childrenInternal=null,this.events=t,this.textFilter=n,this.filter=u=>r.every(m=>m.accept(u)),this.startTime=a,this.endTime=o,this.eventGroupIdCallback=s,this.totalTime=o-a,this.calculateTransferSize=c,this.forceGroupIdCallback=l}hasChildren(){return!0}filterChildren(t){for(let[n,r]of t)r.event&&r.depth<=1&&!this.textFilter.accept(r.event)&&t.delete(n);return t}children(){return this.childrenInternal||(this.childrenInternal=this.filterChildren(this.grouppedTopNodes())),this.childrenInternal}ungroupedTopNodes(){let t=this,n=this.startTime,r=this.endTime,a=new Map,o=[r-n],s=[],c=new Map,l=this.eventGroupIdCallback,u=this.forceGroupIdCallback,
m=i(h=>{if(v.isReceivedDataEvent(h)){let y=Fh(h);this.forceGroupIdCallback&&this.eventGroupIdCallback&&(y=`${y}-${this.eventGroupIdCallback(h)}`);let b=a.get(y);b?b.events.push(h):(b=new Bh(t,y,h,!1,t),a.set(y,b)),h.name==="ResourceReceivedData"?b.transferSize+=h.args.data.encodedDataLength:h.args.data.encodedDataLength>0&&(b.transferSize=h.args.data.encodedDataLength)}},"sumTransferSizeOfInstantEvent");re.forEachEvent(this.events,{onStartEvent:p,onEndEvent:f,onInstantEvent:this.calculateTransferSize?m:void 0,startTime:j.milliToMicro(this.startTime),endTime:j.milliToMicro(this.endTime),eventFilter:this.filter,ignoreAsyncEvents:!1});function p(h){let{startTime:y,endTime:b}=j.eventTimingsMilliSeconds(h),C=(b!==void 0?Math.min(b,r):r)-Math.max(y,n);o[o.length-1]-=C,o.push(C);let k=Fh(h);u&&l&&(k=`${k}-${l(h)}`);let R=!c.has(k);R&&c.set(k,C),s.push(R)}i(p,"onStartEvent");function f(h){let y=Fh(h);u&&l&&(y=`${y}-${l(h)}`);let b=a.get(y);b?b.events.push(h):(b=new Bh(t,y,h,!1,t),a.set(y,b)),b.
selfTime+=o.pop()||0,s.pop()&&(b.totalTime+=c.get(y)||0,c.delete(y)),s.length&&b.setHasChildren(!0)}i(f,"onEndEvent"),this.selfTime=o.pop()||0;for(let h of a)h[1].selfTime<=0&&(!this.calculateTransferSize||h[1].transferSize<=0)&&a.delete(h[0]);return a}grouppedTopNodes(){let t=this.ungroupedTopNodes();if(!this.eventGroupIdCallback)return t;let n=new Map;for(let r of t.values()){let a=this.eventGroupIdCallback(r.event),o=n.get(a);if(!o)o=new cE(a,this,r.events),n.set(a,o);else for(let s of r.events)o.events.push(s);o.addChild(r,r.selfTime,r.selfTime,r.transferSize)}return n}},cE=class extends Wu{static{i(this,"GroupNode")}childrenInternal;isGroupNodeInternal;events;constructor(t,n,r){super(t,r[0]),this.events=r,this.childrenInternal=new Map,this.parent=n,this.isGroupNodeInternal=!0}addChild(t,n,r,a){this.childrenInternal.set(t.id,t),this.selfTime+=n,this.totalTime+=r,this.transferSize+=a,t.parent=this}hasChildren(){return!0}children(){return this.childrenInternal}},Bh=class e extends Wu{static{
i(this,"BottomUpNode")}parent;root;depth;cachedChildren;hasChildrenInternal;constructor(t,n,r,a,o){super(n,r),this.parent=o,this.root=t,this.depth=(o.depth||0)+1,this.cachedChildren=null,this.hasChildrenInternal=a}hasChildren(){return this.hasChildrenInternal}setHasChildren(t){this.hasChildrenInternal=t}children(){if(this.cachedChildren)return this.cachedChildren;let t=[0],n=[],r=[],a=new Map,o=this.root.startTime,s=this.root.endTime,c=o,l=this;re.forEachEvent(this.root.events,{onStartEvent:u,onEndEvent:m,startTime:j.milliToMicro(o),endTime:j.milliToMicro(s),eventFilter:this.root.filter,ignoreAsyncEvents:!1});function u(p){let{startTime:f,endTime:h}=j.eventTimingsMilliSeconds(p),b=(h!==void 0?Math.min(h,s):s)-Math.max(f,o);b<0&&console.assert(!1,"Negative duration of an event"),t[t.length-1]-=b,t.push(b);let w=Fh(p);n.push(w),r.push(p)}i(u,"onStartEvent");function m(p){let{startTime:f,endTime:h}=j.eventTimingsMilliSeconds(p),y=t.pop(),b=n.pop();r.pop();let w;for(w=l;w.depth>1;w=w.parent)
if(w.id!==n[n.length+1-w.depth])return;if(w.id!==b||n.length<l.depth)return;let C=n[n.length-l.depth];if(w=a.get(C),w)w.events.push(p);else{let S=r[r.length-l.depth],_=r.length>l.depth;w=new e(l.root,C,S,_,l),a.set(C,w)}let k=h!==void 0?Math.min(h,s):s,R=k-Math.max(f,c);w.selfTime+=y||0,w.totalTime+=R,c=k}return i(m,"onEndEvent"),this.cachedChildren=this.root.filterChildren(a),this.cachedChildren}searchTree(t,n){return n=n||[],this.event&&t(this.event)&&n.push(this),n}};i(Fh,"generateEventID")});var jh={};x(jh,{summarizeByThirdParty:()=>Ise,summarizeByURL:()=>uE});function n5(e){let t=e.Renderer.processes.values().find(n=>{let r=n.url??"";return n.isOnMainFrame&&!r.startsWith("about:")&&!r.startsWith("chrome:")})?.threads.values().find(n=>n.name==="CrRendererMain");return t?t.entries:[]}function Ise(e,t){let n=n5(e).sort(re.eventTimeComparator),a=r5(n,t,i(s=>e.Renderer.entityMappings.entityByEvent.get(s)?.name??"","groupingFunction"));return Dse(a,e)}function uE(e,t){let n=n5(e).sort(re.eventTimeComparator),a=r5(n,t,i(s=>vr.getNonResolvedURL(s,e)??"","groupingFunction"));return Ase(a,e)}function Dse(e,t){let n=[],r=[...e.children().values()].flat();for(let a of r){if(a.id==="")continue;let o=t.Renderer.entityMappings.entityByEvent.get(a.event);if(!o)continue;let s={transferSize:a.transferSize,mainThreadTime:I.Milli(a.selfTime),entity:o,relatedEvents:t.Renderer.entityMappings.eventsByEntity.get(o)??[]};n.push(s)}return n}function Ase(e,t){let n=[],r=t.NetworkRequests.byTime,a=[
...e.children().values()].flat();for(let o of a){if(o.id===""||typeof o.id!="string")continue;let s=t.Renderer.entityMappings.entityByEvent.get(o.event);if(!s)continue;let c=o.id,u={request:r.find(m=>m.args.data.url===c),url:c,entity:s,transferSize:o.transferSize,mainThreadTime:I.Milli(o.selfTime)};n.push(u)}return n}function r5(e,t,n){let r=re.VISIBLE_TRACE_EVENT_TYPES.values().toArray(),a=new Ph(r.concat([v.Name.SYNTHETIC_NETWORK_REQUEST])),o=j.microToMilli(t.min),s=j.microToMilli(t.max);return new Uh(e,{textFilter:new Lh([]),filters:[a],startTime:o,endTime:s,eventGroupIdCallback:n,calculateTransferSize:!0,forceGroupIdCallback:!0})}var dE=g(()=>{d();tn();Se();ie();sE();lE();i(n5,"collectMainThreadActivity");i(Ise,"summarizeByThirdParty");i(uE,"summarizeByURL");i(Dse,"summarizeBottomUpByEntity");i(Ase,"summarizeBottomUpByURL");i(r5,"getBottomUpTree")});var Vu=g(()=>{d();XF();QF();dE();sE();lE()});var pE={};x(pE,{getLogNormalScore:()=>$u,linearInterpolation:()=>mE});function Pse(e){let t=Math.sign(e);e=Math.abs(e);let n=.254829592,r=-.284496736,a=1.421413741,o=-1.453152027,s=1.061405429,l=1/(1+.3275911*e),u=l*(n+l*(r+l*(a+l*(o+l*s))));return t*(1-u*Math.exp(-e*e))}function $u({median:e,p10:t},n){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;let r=.9061938024368232,a=Math.max(Number.MIN_VALUE,n/e),o=Math.log(a),s=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(s),l=o*r/c,u=(1-Pse(l))/2,m;return n<=t?m=Math.max(.9,Math.min(1,u)):n<=e?m=Math.max(Mse,Math.min(Nse,u)):m=Math.max(0,Math.min(Ose,u)),m}function mE(e,t,n,r,a){let o=(r-t)/(n-e);return t+(a-e)*o}var Nse,Mse,Ose,qh=g(()=>{d();Nse=.8999999999999999,Mse=.5,Ose=.49999999999999994;i(Pse,"erf");i($u,"getLogNormalScore");i(mE,"linearInterpolation")});var fE={};x(fE,{InsightCategory:()=>qe,InsightKeys:()=>ce,InsightWarning:()=>Bn});var Bn,qe,ce,$t=g(()=>{d();(function(e){e.NO_FP="NO_FP",e.NO_LCP="NO_LCP",e.NO_DOCUMENT_REQUEST="NO_DOCUMENT_REQUEST",e.NO_LAYOUT="NO_LAYOUT"})(Bn||(Bn={}));(function(e){e.ALL="All",e.INP="INP",e.LCP="LCP",e.CLS="CLS"})(qe||(qe={}));(function(e){e.LCP_BREAKDOWN="LCPBreakdown",e.INP_BREAKDOWN="INPBreakdown",e.CLS_CULPRITS="CLSCulprits",e.THIRD_PARTIES="ThirdParties",e.DOCUMENT_LATENCY="DocumentLatency",e.DOM_SIZE="DOMSize",e.DUPLICATE_JAVASCRIPT="DuplicatedJavaScript",e.FONT_DISPLAY="FontDisplay",e.FORCED_REFLOW="ForcedReflow",e.IMAGE_DELIVERY="ImageDelivery",e.LCP_DISCOVERY="LCPDiscovery",e.LEGACY_JAVASCRIPT="LegacyJavaScript",e.NETWORK_DEPENDENCY_TREE="NetworkDependencyTree",e.RENDER_BLOCKING="RenderBlocking",e.SLOW_CSS_SELECTOR="SlowCSSSelector",e.VIEWPORT="Viewport",e.MODERN_HTTP="ModernHTTP",e.CACHE="Cache"})(ce||(ce={}))});var Xn={};x(Xn,{calculateDocFirstByteTs:()=>Xi,calculateMetricWeightsForSorting:()=>jse,estimateCompressedContentSize:()=>p5,estimateCompressionRatioForScript:()=>Yu,evaluateCLSMetricScore:()=>c5,evaluateINPMetricScore:()=>s5,evaluateLCPMetricScore:()=>i5,getCLS:()=>Use,getFieldMetricsForInsightSet:()=>u5,getINP:()=>Fse,getInsight:()=>zh,getLCP:()=>Lse,insightBounds:()=>Hse,isRequestCompressed:()=>Gh,isRequestServedFromBrowserCache:()=>d5,metricSavingsForWastedBytes:()=>ja});function zh(e,t){let n=t.model[e];return n instanceof Error?null:n}function Lse(e){let t=zh(ce.LCP_BREAKDOWN,e);return!t||!t.lcpMs||!t.lcpEvent?null:{value:j.milliToMicro(t.lcpMs),event:t.lcpEvent}}function Fse(e){let t=zh(ce.INP_BREAKDOWN,e);return t?.longestInteractionEvent?.dur?{value:t.longestInteractionEvent.dur,event:t.longestInteractionEvent}:null}function Use(e){let t=zh(ce.CLS_CULPRITS,e);if(!t)return{value:0,worstClusterEvent:null};let n=0,r;for(let a of t.clusters)a.clusterCumulativeScore>n&&(n=a.clusterCumulativeScore,
r=a);return{value:n,worstClusterEvent:r??null}}function i5(e){return $u({p10:2500,median:4e3},e)}function s5(e){return $u({p10:200,median:500},e)}function c5(e){return $u({p10:.1,median:.25},e)}function Bse(e,t,n,r=null){return e.find(a=>{let o=r?a[`${r.pageScope}-${r.deviceScope}`]?.record.key:(a["url-ALL"]||a["origin-ALL"])?.record.key;return o?.url&&o.url===t||o?.origin&&o.origin===n})}function l5(e,t,n=null){let r=[];n?r.push(n):(r.push({pageScope:"url",deviceScope:"ALL"}),r.push({pageScope:"origin",deviceScope:"ALL"}));for(let a of r){let o=`${a.pageScope}-${a.deviceScope}`,s=e[o]?.record.metrics[t]?.percentiles?.p75;if(typeof s=="string"&&(s=Number(s)),typeof s=="number"&&Number.isFinite(s))return{value:s,pageScope:a.pageScope}}return null}function Ki(e,t,n=null){let r=l5(e,t,n);if(r){let a=r.value;return{value:j.milliToMicro(a),pageScope:r.pageScope}}return null}function u5(e,t,n=null){let r=t?.cruxFieldData;if(!r)return null;let a=Bse(r,e.url.href,e.url.origin,n);return a?{fcp:Ki(
a,"first_contentful_paint",n),lcp:Ki(a,"largest_contentful_paint",n),inp:Ki(a,"interaction_to_next_paint",n),cls:l5(a,"cumulative_layout_shift",n),lcpBreakdown:{ttfb:Ki(a,"largest_contentful_paint_image_time_to_first_byte",n),loadDelay:Ki(a,"largest_contentful_paint_image_resource_load_delay",n),loadDuration:Ki(a,"largest_contentful_paint_image_resource_load_duration",n),renderDelay:Ki(a,"largest_contentful_paint_image_element_render_delay",n)}}:null}function jse(e,t){let n={lcp:.3333333333333333,inp:.3333333333333333,cls:.3333333333333333};if(!t?.cruxFieldData)return n;let a=u5(e,t);if(!a)return n;let o=a.lcp?.value??null,s=a.inp?.value??null,c=a.cls?.value??null,l=o!==null?i5(j.microToMilli(o)):0,u=s!==null?s5(j.microToMilli(s)):0,m=c!==null?c5(c):0,p=1-l,f=1-u,h=1-m,y=p+f+h;return y&&(n.lcp=p/y,n.inp=f/y,n.cls=h/y),n}function o5(e,t,n){let r=t.simulate(n),a=new Map;n.traverse(c=>{if(c.type!=="network")return;let l=e.get(c.request.requestId);if(!l)return;let u=c.request.transferSize;
a.set(c.request.requestId,u),c.request.transferSize=Math.max(u-l,0)});let o=t.simulate(n);n.traverse(c=>{if(c.type!=="network")return;let l=a.get(c.request.requestId);l!==void 0&&(c.request.transferSize=l)});let s=r.timeInMs-o.timeInMs;return s=Math.round(s/a5)*a5,I.Milli(s)}function ja(e,t){if(!t.navigation||!t.lantern)return;if(!e.size)return{FCP:I.Milli(0),LCP:I.Milli(0)};let n=t.lantern.simulator,r=t.lantern.metrics.firstContentfulPaint.optimisticGraph,a=t.lantern.metrics.largestContentfulPaint.optimisticGraph;return{FCP:o5(e,n,r),LCP:o5(e,n,a)}}function Gh(e){if(!e.args.data.responseHeaders)return!1;let t=[/^content-encoding$/i,/^x-content-encoding-over-network$/i,/^x-original-content-encoding$/i],n=["gzip","br","deflate","zstd"];return e.args.data.responseHeaders.some(r=>t.some(a=>r.name.match(a))&&n.includes(r.value))}function d5(e){if(!e.args.data.responseHeaders||e.args.data.failed)return!1;if(e.args.data.statusCode===304)return!0;let{transferSize:t,resourceSize:n}=m5(e);return(n?
t/n:0)<.01}function m5(e){let t=e.args.data.decodedBodyLength,n=e.args.data.encodedDataLength;return{resourceSize:t,transferSize:n}}function p5(e,t,n){if(!e||d5(e))switch(n){case"Stylesheet":return Math.round(t*.2);case"Script":case"Document":return Math.round(t*.33);default:return Math.round(t*.5)}let{transferSize:r,resourceSize:a}=m5(e),o=r;if(Gh(e)||(o=a),e.args.data.resourceType===n)return o;let s=Number.isFinite(a)&&a>0?o/a:1;return Math.round(t*s)}function Yu(e){if(!e.request)return 1;let t=e.request,n=t.args.data.decodedBodyLength??e.content?.length??0,r=p5(t,n,"Script");return n===0||r===0?1:r/n}function Xi(e){if(e.args.data.protocol==="file")return e.ts;let t=e.args.data.timing;return t?I.Micro(j.secondsToMicro(t.requestTime)+j.milliToMicro(t.receiveHeadersStart??t.receiveHeadersEnd)):null}function Hse(e,t){let r=(e.createOverlays?.()??[]).map(j.traceWindowFromOverlay).filter(o=>!!o),a=j.combineTraceWindowsMicro(r);return a||t}var a5,ca=g(()=>{d();Se();ie();qh();$t();a5=50;i(zh,
"getInsight");i(Lse,"getLCP");i(Fse,"getINP");i(Use,"getCLS");i(i5,"evaluateLCPMetricScore");i(s5,"evaluateINPMetricScore");i(c5,"evaluateCLSMetricScore");i(Bse,"getPageResult");i(l5,"getMetricResult");i(Ki,"getMetricTimingResult");i(u5,"getFieldMetricsForInsightSet");i(jse,"calculateMetricWeightsForSorting");i(o5,"estimateSavingsWithGraphs");i(ja,"metricSavingsForWastedBytes");i(Gh,"isRequestCompressed");i(d5,"isRequestServedFromBrowserCache");i(m5,"getRequestSizes");i(p5,"estimateCompressedContentSize");i(Yu,"estimateCompressionRatioForScript");i(Xi,"calculateDocFirstByteTs");i(Hse,"insightBounds")});var Ku={};x(Ku,{UIStrings:()=>jr,cachingDisabled:()=>y5,computeCacheLifetimeInSeconds:()=>h5,createOverlayForRequest:()=>v5,createOverlays:()=>$se,generateInsight:()=>Vse,getCombinedHeaders:()=>g5,i18nString:()=>hE,isCacheInsight:()=>Wse,isCacheable:()=>f5});function zse(e){return{insightKey:ce.CACHE,strings:jr,title:hE(jr.title),description:hE(jr.description),docs:"https://developer.chrome.com/docs/performance/insights/cache",category:qe.ALL,state:e.requests.length>0?"fail":"pass",...e}}function f5(e){return In.NON_NETWORK_SCHEMES.includes(e.args.data.protocol)?!1:!!(In.CACHEABLE_STATUS_CODES.has(e.args.data.statusCode)&&In.STATIC_RESOURCE_TYPES.has(e.args.data.resourceType||"Other"))}function h5(e,t){if(t?.["max-age"]!==void 0)return t["max-age"];let n=e.find(r=>r.name==="expires")?.value??null;if(n){let r=new Date(n).getTime();return r?Math.ceil((r-Date.now())/1e3):0}return null}function Gse(e){let t=[0,.2,1,3,8,12,24,48,72,168,8760,1/0],n=e/3600,r=t.findIndex(l=>l>=n);if(r===t.length-
1)return 1;if(r===0)return 0;let a=t[r],o=t[r-1],s=r/10,c=(r-1)/10;return mE(o,c,a,s,n)}function g5(e){let t=new Map;for(let n of e){let r=n.name.toLowerCase();t.get(r)?t.set(r,`${t.get(r)}, ${n.value}`):t.set(r,n.value)}return t}function y5(e,t){let n=e?.get("cache-control")??null,r=e?.get("pragma")??null;return!!(!n&&r?.includes("no-cache")||t&&(t["must-revalidate"]||t["no-cache"]||t["no-store"]||t.private))}function Wse(e){return e.insightKey===ce.CACHE}function Vse(e,t){let n=i(c=>j.eventIsInBounds(c,t.bounds),"isWithinContext"),r=e.NetworkRequests.byTime.filter(n),a=[],o=0,s=new Map;for(let c of r){if(!c.args.data.responseHeaders||!f5(c))continue;let l=g5(c.args.data.responseHeaders),u=l.get("cache-control")??null,m=In.parseCacheControl(u);if(y5(l,m))continue;let p=h5(c.args.data.responseHeaders,m);if(p!==null&&(!Number.isFinite(p)||p<=0)||(p=p||0,p/86400>=30))continue;let h=Gse(p);if(h>qse)continue;let y=c.args.data.encodedDataLength||0,b=(1-h)*y;s.set(c.args.data.requestId,b),o+=
b,a.push({request:c,ttl:p,wastedBytes:b})}return a.sort((c,l)=>l.request.args.data.decodedBodyLength-c.request.args.data.decodedBodyLength||c.ttl-l.ttl),zse({relatedEvents:a.map(c=>c.request),requests:a,metricSavings:ja(s,t),wastedBytes:o})}function v5(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function $se(e){return e.requests.map(t=>v5(t.request))}var jr,hE,qse,Wh=g(()=>{d();Se();ca();qh();$t();jr={title:"Use efficient cache lifetimes",description:"A long cache lifetime can speed up repeat visits to your page. [Learn more about caching](https://developer.chrome.com/docs/performance/insights/cache).",requestColumn:"Request",cacheTTL:"Cache TTL",noRequestsToCache:"No requests with inefficient cache policies",others:"{PH1} others"},hE=i((e,t)=>({i18nId:e,values:t}),"i18nString"),qse=.925;i(zse,"finalize");i(f5,"isCacheable");i(h5,"computeCacheLifetimeInSeconds");i(Gse,"getCacheHitProbability");i(g5,"getCombinedHeaders");i(y5,"cachingDisabled");i(Wse,"isCacheInsight");
i(Vse,"generateInsight");i(v5,"createOverlayForRequest");i($se,"createOverlays")});var gE={};x(gE,{AnimationFailureReasons:()=>Yt,LayoutShiftType:()=>Ji,UIStrings:()=>yn,createOverlays:()=>oce,generateInsight:()=>ace,getNonCompositedFailure:()=>w5,i18nString:()=>Oo,isCLSCulpritsInsight:()=>ece});function b5(e,t){let n=e.dur?e.ts+e.dur:e.ts;return n<t.ts&&n>=t.ts-Kse}function w5(e){let t=[],n=e.args.data.beginEvent,r=e.args.data.instantEvents||[];for(let a of r){let o=a.args.data.compositeFailed,s=a.args.data.unsupportedProperties;if(!o)continue;let c=Yse.filter(u=>o&u.flag).map(u=>u.failure),l={name:n.args.data.displayName,failureReasons:c,unsupportedProperties:s,animation:e};t.push(l)}return t}function Xse(e,t,n,r){let a=[];for(let o of e){let s=w5(o);if(!s)continue;a.push(...s);let c=Vh(t,o);if(!c||!b5(o,c))continue;let l=n.get(c);if(l)for(let u of l){let m=r.get(u);if(!m)throw new Error("Unaccounted shift");m.nonCompositedAnimations.push(...s)}}return a}function Jse(e,t){let n=new Map;for(let r of t){let a=Wt.nearestIndexFromBeginning(e,o=>o.ts>=r.ts);if(a!==null)
for(let o=a;o<e.length;o++){let s=e[o];if(s.ts>=r.ts&&s.ts<=r.ts+r.dur&&me.getWithDefault(n,r,()=>[]).push(s),s.ts>r.ts+r.dur)break}}return n}function Vh(e,t){let n=Wt.nearestIndexFromBeginning(e,r=>r.ts>t.ts+(t.dur||0));if(n!==null)return e[n]}function Zse(e,t,n,r,a,o){for(let s of t){let c=Vh(n,s);if(!c)continue;let l=r.get(c);if(l)for(let u of l){let m=a.get(u);if(!m)throw new Error("Unaccounted shift");let p=o.find(f=>{let h=I.Micro(s.ts+(s.dur??0));return f.ts>=s.ts&&f.ts<=h});if(p?.args.frame){let f=p.args.frame,h,y=e.Meta.rendererProcessesByFrame.get(f);y&&y.size>0&&(h=[...y.values()][0]?.[0].frame.url),m.iframes.push({frame:f,url:h})}}}return a}function Qse(e,t,n,r){return n.forEach((a,o)=>{let s=Vh(t,o);if(!s)return;let c=e.find(l=>l.args.data.nodeId===s.args.data.nodeId);if(c)for(let l of a){let u=r.get(l);if(!u)throw new Error("Unaccounted shift");u.unsizedImages.push({backendNodeId:c.args.data.nodeId,paintImageEvent:s})}}),r}function ece(e){return e.insightKey===ce.CLS_CULPRITS}
function tce(e,t,n,r){let a=e.filter(o=>o.args.data.resourceType==="Font"&&o.args.data.mimeType.startsWith("font"));for(let o of a){let s=Vh(t,o);if(!s||!b5(o,s))continue;let c=n.get(s);if(c)for(let l of c){let u=r.get(l);if(!u)throw new Error("Unaccounted shift");u.webFonts.push(o)}}return r}function nce(e,t){let r=[],a=e.events;for(let o of a){let s=t.get(o);if(!s)continue;let c=s.webFonts,l=s.iframes,u=s.nonCompositedAnimations,m=s.unsizedImages;for(let p=0;p<c.length&&r.length<3;p++)r.push({type:Ji.WEB_FONT,description:Oo(yn.webFont)});for(let p=0;p<l.length&&r.length<3;p++)r.push({type:Ji.IFRAMES,description:Oo(yn.injectedIframe)});for(let p=0;p<u.length&&r.length<3;p++)r.push({type:Ji.ANIMATIONS,description:Oo(yn.animation)});for(let p=0;p<m.length&&r.length<3;p++)r.push({type:Ji.UNSIZED_IMAGE,description:Oo(yn.unsizedImage),url:m[p].paintImageEvent.args.data.url||"",backendNodeId:m[p].backendNodeId,frame:m[p].paintImageEvent.args.data.frame||""});if(r.length>=3)break}return r.slice(
0,3)}function rce(e){let t="pass";return e.worstCluster&&(dt.LayoutShifts.scoreClassificationForLayoutShift(e.worstCluster.clusterCumulativeScore)===dt.PageLoadMetrics.ScoreClassification.GOOD?t="informative":t="fail"),{insightKey:ce.CLS_CULPRITS,strings:yn,title:Oo(yn.title),description:Oo(yn.description),docs:"https://developer.chrome.com/docs/performance/insights/cls-culprit",category:qe.CLS,state:t,...e}}function ace(e,t){let n=i(S=>j.eventIsInBounds(S,t.bounds),"isWithinContext"),r=e.Animations.animations.filter(n),a=e.LayoutShifts.renderFrameImplCreateChildFrameEvents.filter(n),o=e.NetworkRequests.byTime.filter(n),s=e.LayoutShifts.domLoadingEvents.filter(n),c=e.LayoutShifts.layoutImageUnsizedEvents.filter(n),l=t.navigation?t.navigationId:v.NO_NAVIGATION,u=e.LayoutShifts.clustersByNavigationId.get(l)??[],p=[...u].sort((S,_)=>_.clusterCumulativeScore-S.clusterCumulativeScore).at(0),f=u.flatMap(S=>S.events),h=e.LayoutShifts.prePaintEvents.filter(n),y=e.LayoutShifts.paintImageEvents.
filter(n),b=new Map,w=Jse(f,h);for(let S of f)b.set(S,{iframes:[],webFonts:[],nonCompositedAnimations:[],unsizedImages:[]});Zse(e,a,h,w,b,s),tce(o,h,w,b),Qse(c,y,w,b);let C=Xse(r,h,w,b),k=[...f];p&&k.push(p);let R=new Map;for(let S of u)R.set(S,nce(S,b));return rce({relatedEvents:k,animationFailures:C,shifts:b,clusters:u,worstCluster:p,topCulpritsByCluster:R})}function oce(e){let n=(e.clusters.toSorted((o,s)=>s.clusterCumulativeScore-o.clusterCumulativeScore)??[])[0];if(!n)return[];let r=I.Micro(n.dur??0),a=I.Micro(n.ts+r);return[{type:"TIMESPAN_BREAKDOWN",sections:[{bounds:{min:n.ts,range:r,max:a},label:Oo(yn.worstLayoutShiftCluster),showDuration:!1}],entry:n.events[0],renderLocation:"ABOVE_EVENT"}]}var yn,Oo,Yt,Ji,Yse,Kse,yE=g(()=>{d();wt();tn();Se();ie();$t();yn={title:"Layout shift culprits",description:"Layout shifts occur when elements move absent any user interaction. [Investigate the causes of layout shifts](https://developer.chrome.com/docs/performance/insights/cls-culprit), s\
uch as elements being added, removed, or their fonts changing as the page loads.",worstLayoutShiftCluster:"Worst layout shift cluster",worstCluster:"Worst cluster",layoutShiftCluster:"Layout shift cluster @ {PH1}",topCulprits:"Top layout shift culprits",injectedIframe:"Injected iframe",webFont:"Web font",animation:"Animation",unsizedImage:"Unsized image element",noLayoutShifts:"No layout shifts",noCulprits:"Could not detect any layout shift culprits"},Oo=i((e,t)=>({i18nId:e,values:t}),"i18nString");(function(e){e.ACCELERATED_ANIMATIONS_DISABLED="ACCELERATED_ANIMATIONS_DISABLED",e.EFFECT_SUPPRESSED_BY_DEVTOOLS="EFFECT_SUPPRESSED_BY_DEVTOOLS",e.INVALID_ANIMATION_OR_EFFECT="INVALID_ANIMATION_OR_EFFECT",e.EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS="EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS",e.EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE="EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE",e.TARGET_HAS_INVALID_COMPOSITING_STATE="TARGET_HAS_INVALID_COMPOSITING_STATE",e.TARGET_HAS_INCOMPATIBLE_ANIMATIONS="TARGET_HAS_INCOMP\
ATIBLE_ANIMATIONS",e.TARGET_HAS_CSS_OFFSET="TARGET_HAS_CSS_OFFSET",e.ANIMATION_AFFECTS_NON_CSS_PROPERTIES="ANIMATION_AFFECTS_NON_CSS_PROPERTIES",e.TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_ON_TARGET="TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_ON_TARGET",e.TRANSFROM_BOX_SIZE_DEPENDENT="TRANSFROM_BOX_SIZE_DEPENDENT",e.FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS="FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS",e.UNSUPPORTED_CSS_PROPERTY="UNSUPPORTED_CSS_PROPERTY",e.MIXED_KEYFRAME_VALUE_TYPES="MIXED_KEYFRAME_VALUE_TYPES",e.TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE="TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE",e.ANIMATION_HAS_NO_VISIBLE_CHANGE="ANIMATION_HAS_NO_VISIBLE_CHANGE",e.AFFECTS_IMPORTANT_PROPERTY="AFFECTS_IMPORTANT_PROPERTY",e.SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY="SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY"})(Yt||(Yt={}));(function(e){e[e.WEB_FONT=0]="WEB_FONT",e[e.IFRAMES=1]="IFRAMES",e[e.ANIMATIONS=2]="ANIMATIONS",e[e.UNSIZED_IMAGE=3]="UNSIZED_IMAGE"})(Ji||(Ji=
{}));Yse=[{flag:1,failure:Yt.ACCELERATED_ANIMATIONS_DISABLED},{flag:2,failure:Yt.EFFECT_SUPPRESSED_BY_DEVTOOLS},{flag:4,failure:Yt.INVALID_ANIMATION_OR_EFFECT},{flag:8,failure:Yt.EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS},{flag:16,failure:Yt.EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE},{flag:32,failure:Yt.TARGET_HAS_INVALID_COMPOSITING_STATE},{flag:64,failure:Yt.TARGET_HAS_INCOMPATIBLE_ANIMATIONS},{flag:128,failure:Yt.TARGET_HAS_CSS_OFFSET},{flag:512,failure:Yt.ANIMATION_AFFECTS_NON_CSS_PROPERTIES},{flag:1024,failure:Yt.TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_ON_TARGET},{flag:2048,failure:Yt.TRANSFROM_BOX_SIZE_DEPENDENT},{flag:4096,failure:Yt.FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS},{flag:8192,failure:Yt.UNSUPPORTED_CSS_PROPERTY},{flag:32768,failure:Yt.MIXED_KEYFRAME_VALUE_TYPES},{flag:65536,failure:Yt.TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE},{flag:1<<17,failure:Yt.ANIMATION_HAS_NO_VISIBLE_CHANGE},{flag:1<<18,failure:Yt.AFFECTS_IMPORTANT_PROPERTY},{flag:1<<19,failure:Yt.SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY}],
Kse=j.secondsToMicro(I.Seconds(.5));i(b5,"isInRootCauseWindow");i(w5,"getNonCompositedFailure");i(Xse,"getNonCompositedFailureRootCauses");i(Jse,"getShiftsByPrePaintEvents");i(Vh,"getNextEvent");i(Zse,"getIframeRootCauses");i(Qse,"getUnsizedImageRootCauses");i(ece,"isCLSCulpritsInsight");i(tce,"getFontRootCauses");i(nce,"getTopCulprits");i(rce,"finalize");i(ace,"generateInsight");i(oce,"createOverlays")});var bE={};x(bE,{UIStrings:()=>ln,createOverlays:()=>mce,generateInsight:()=>dce,i18nString:()=>Tr,isDocumentLatencyInsight:()=>cce});function cce(e){return e.insightKey==="DocumentLatency"}function lce(e){if(globalThis.isLightrider)return e.args.data.lrServerResponseTime??null;if(!e.args.data.timing)return null;let r=j.microToMilli(e.args.data.syntheticData.serverResponseTime);return Math.round(r)}function uce(e){if(Gh(e))return 0;let n=e.args.data.decodedBodyLength,r=0;switch(e.args.data.mimeType){case"text/css":r=Math.round(n*.8);break;case"text/html":case"text/javascript":r=Math.round(n*.67);break;case"text/plain":case"text/xml":case"text/x-component":case"application/javascript":case"application/json":case"application/manifest+json":case"application/vnd.api+json":case"application/xml":case"application/xhtml+xml":case"application/rss+xml":case"application/atom+xml":case"application/vnd.ms-fontobject":case"application/x-font-ttf":case"application/x-font-opentype":case"application/x-f\
ont-truetype":case"image/svg+xml":case"image/x-icon":case"image/vnd.microsoft.icon":case"font/ttf":case"font/eot":case"font/otf":case"font/opentype":r=Math.round(n*.5);break;default:}return r<sce?0:r}function vE(e){let t=!1;return e.data&&(t=!e.data.checklist.usesCompression.value||!e.data.checklist.serverResponseIsFast.value||!e.data.checklist.noRedirects.value),{insightKey:ce.DOCUMENT_LATENCY,strings:ln,title:Tr(ln.title),description:Tr(ln.description),docs:"https://developer.chrome.com/docs/performance/insights/document-latency",category:qe.ALL,state:t?"fail":"pass",...e}}function dce(e,t){if(!t.navigation)return vE({});let n=t.options.insightTimeFormatters?.milli??(h=>({__i18nMillis:h})),r=e.NetworkRequests.byId.get(t.navigationId);if(!r)return vE({warnings:[Bn.NO_DOCUMENT_REQUEST]});let a=lce(r);if(a===null)throw new Error("missing document request timing");let o=a>E5,s=0;a>E5&&(s=Math.max(a-ice,0));let c=Math.round(r.args.data.syntheticData.redirectionDuration/1e3);s+=c;let l={FCP:s,
LCP:s},u=uce(r),m=c===0,p=!o,f=u===0;return vE({relatedEvents:[r],data:{serverResponseTime:a,redirectDuration:I.Milli(c),uncompressedResponseBytes:u,documentRequest:r,checklist:{noRedirects:{label:m?Tr(ln.passingRedirects):Tr(ln.failedRedirects,{PH1:r.args.data.redirects.length,PH2:n(c)}),value:m},serverResponseIsFast:{label:p?Tr(ln.passingServerResponseTime,{PH1:n(a)}):Tr(ln.failedServerResponseTime,{PH1:n(a)}),value:p},usesCompression:{label:Tr(f?ln.passingTextCompression:ln.failedTextCompression),value:f}}},metricSavings:l,wastedBytes:u})}function mce(e){if(!e.data?.documentRequest)return[];let t=[],n=e.data.documentRequest,r=j.milliToMicro(e.data.redirectDuration),a=[];if(e.data.redirectDuration){let o=j.traceWindowFromMicroSeconds(n.ts,n.ts+r);a.push({bounds:o,label:Tr(ln.redirectsLabel),showDuration:!0}),t.push({type:"CANDY_STRIPED_TIME_RANGE",bounds:o,entry:n})}if(!e.data.checklist.serverResponseIsFast.value){let o=j.milliToMicro(e.data.serverResponseTime),s=n.args.data.timing?.
sendEnd??I.Milli(0),c=j.milliToMicro(s),l=j.traceWindowFromMicroSeconds(c,c+o);a.push({bounds:l,label:Tr(ln.serverResponseTimeLabel),showDuration:!0})}if(e.data.uncompressedResponseBytes){let o=j.traceWindowFromMicroSeconds(n.args.data.syntheticData.downloadStart,n.args.data.syntheticData.downloadStart+n.args.data.syntheticData.download);a.push({bounds:o,label:Tr(ln.uncompressedDownload),showDuration:!0}),t.push({type:"CANDY_STRIPED_TIME_RANGE",bounds:o,entry:n})}return a.length&&t.push({type:"TIMESPAN_BREAKDOWN",sections:a,entry:e.data.documentRequest,renderLocation:"BELOW_EVENT"}),t.push({type:"ENTRY_SELECTED",entry:e.data.documentRequest}),t}var ln,Tr,E5,ice,sce,wE=g(()=>{d();Se();ie();ca();$t();ln={title:"Document request latency",description:"Your first network request is the most important. [Reduce its latency](https://developer.chrome.com/docs/performance/insights/document-latency) by avoiding redirects, ensuring a fast server response, and enabling text compression.",passingRedirects:"\
Avoids redirects",failedRedirects:"Had redirects ({PH1} redirects, +{PH2})",passingServerResponseTime:"Server responds quickly (observed {PH1})",failedServerResponseTime:"Server responded slowly (observed {PH1})",passingTextCompression:"Applies text compression",failedTextCompression:"No compression applied",redirectsLabel:"Redirects",serverResponseTimeLabel:"Server response time",uncompressedDownload:"Uncompressed download"},Tr=i((e,t)=>({i18nId:e,values:t}),"i18nString"),E5=600,ice=100,sce=1400;i(cce,"isDocumentLatencyInsight");i(lce,"getServerResponseTime");i(uce,"getCompressionSavings");i(vE,"finalize");i(dce,"generateInsight");i(mce,"createOverlays")});var EE={};x(EE,{UIStrings:()=>vn,createOverlays:()=>vce,generateInsight:()=>yce,i18nString:()=>Xu,isDomSizeInsight:()=>gce});function hce(e){let t=[...e.largeLayoutUpdates,...e.largeStyleRecalcs];return{insightKey:ce.DOM_SIZE,strings:vn,title:Xu(vn.title),description:Xu(vn.description),docs:"https://developer.chrome.com/docs/performance/insights/dom-size",category:qe.INP,state:t.length>0?"informative":"pass",...e,relatedEvents:t}}function gce(e){return e.insightKey===ce.DOM_SIZE}function yce(e,t){let n=i(m=>j.eventIsInBounds(m,t.bounds),"isWithinContext"),r=t.navigation?.tid,a=[],o=[],s=Yi.threadsInRenderer(e.Renderer,e.AuctionWorklets);for(let m of s){if(m.type!==Yi.ThreadType.MAIN_THREAD)continue;if(r===void 0){if(!m.processIsOnMainFrame)continue}else if(m.tid!==r)continue;let p=e.Renderer.processes.get(m.pid)?.threads.get(m.tid);if(!p)continue;let{entries:f,layoutEvents:h,recalcStyleEvents:y}=p;if(!f.length)continue;let b=f[0],w=f[f.length-1],C=j.traceWindowFromMicroSeconds(b.ts,I.Micro(
w.ts+(w.dur??0)));if(j.boundsIncludeTimeRange({timeRange:C,bounds:t.bounds})){for(let k of h){if(k.dur<T5||!n(k))continue;let{dirtyObjects:R}=k.args.beginData;R>pce&&a.push(k)}for(let k of y){if(k.dur<T5||!n(k))continue;let{elementCount:R}=k.args;R>fce&&o.push(k)}}}let c=[...a.map(m=>{let p=m.dur/1e3,f=m.args.beginData.dirtyObjects;return{label:Xu(vn.largeLayout,{PH1:f}),duration:p,size:f,event:m}}),...o.map(m=>{let p=m.dur/1e3,f=m.args.elementCount;return{label:Xu(vn.largeStyleRecalc,{PH1:f}),duration:p,size:f,event:m}})].sort((m,p)=>p.duration-m.duration).slice(0,5),l=e.DOMStats.domStatsByFrameId.get(t.frameId)?.filter(n)??[],u;for(let m of l){let p=t.navigation?.pid;p&&m.pid!==p||(!u||m.args.data.totalElements>u.args.data.totalElements)&&(u=m)}return hce({largeLayoutUpdates:a,largeStyleRecalcs:o,largeUpdates:c,maxDOMStats:u})}function vce(e){return[...e.largeStyleRecalcs,...e.largeLayoutUpdates].map(n=>({type:"ENTRY_OUTLINE",entry:n,outlineReason:"ERROR"}))}var vn,Xu,T5,pce,fce,TE=g(
()=>{d();tn();Se();ie();$t();vn={title:"Optimize DOM size",description:"A large DOM can increase the duration of style calculations and layout reflows, impacting page responsiveness. A large DOM will also increase memory usage. [Learn how to avoid an excessive DOM size](https://developer.chrome.com/docs/performance/insights/dom-size).",statistic:"Statistic",value:"Value",element:"Element",totalElements:"Total elements",maxDOMDepth:"DOM depth",maxChildren:"Most children",topUpdatesDescription:"These are the largest layout and style recalculation events. Their performance impact may be reduced by making the DOM simpler.",duration:"Duration",largeLayout:"Layout ({PH1} objects)",largeStyleRecalc:"Style recalculation ({PH1} elements)"},Xu=i((e,t)=>({i18nId:e,values:t}),"i18nString"),T5=j.milliToMicro(I.Milli(40)),pce=100,fce=300;i(hce,"finalize");i(gce,"isDomSizeInsight");i(yce,"generateInsight");i(vce,"createOverlays")});var SE={};x(SE,{UIStrings:()=>la,createOverlays:()=>Tce,generateInsight:()=>Ece,i18nString:()=>xE,isDuplicatedJavaScriptInsight:()=>wce});function bce(e){let t=e.scriptsWithDuplication.map(n=>n.request).filter(n=>!!n);return{insightKey:ce.DUPLICATE_JAVASCRIPT,strings:la,title:xE(la.title),description:xE(la.description),docs:"https://developer.chrome.com/docs/performance/insights/duplicated-javascript",category:qe.LCP,state:e.duplication.values().next().value?"fail":"pass",relatedEvents:[...new Set(t)],...e}}function wce(e){return e.insightKey===ce.DUPLICATE_JAVASCRIPT}function Ece(e,t){let n=e.Scripts.scripts.filter(l=>l.frame!==t.frameId||l.url?.startsWith("chrome-extension://")?!1:j.timestampIsInBounds(t.bounds,l.ts)),r=new Map;for(let l of n)l.request&&r.set(l.request.args.data.requestId,Yu(l));let{duplication:a,duplicationGroupedByNodeModules:o}=Nh.computeScriptDuplication({scripts:n},r),s=[...a.values().flatMap(l=>l.duplicates.map(u=>u.script))],c=new Map;for(let{duplicates:l}of a.
values())for(let u=1;u<l.length;u++){let m=l[u];if(!m.script.request)continue;let p=m.attributedSize,f=m.script.request.args.data.requestId;c.set(f,(c.get(f)||0)+p)}return bce({duplication:a,duplicationGroupedByNodeModules:o,scriptsWithDuplication:[...new Set(s)],scripts:n,mainDocumentUrl:t.navigation?.args.data?.url??e.Meta.mainFrameURL,metricSavings:ja(c,t),wastedBytes:c.values().reduce((l,u)=>l+u,0)})}function Tce(e){return e.scriptsWithDuplication.map(t=>t.request).filter(t=>!!t).map(t=>({type:"ENTRY_OUTLINE",entry:t,outlineReason:"ERROR"}))}var la,xE,CE=g(()=>{d();Vu();Se();ca();$t();la={title:"Duplicated JavaScript",description:"Remove large, [duplicate JavaScript modules](https://developer.chrome.com/docs/performance/insights/duplicated-javascript) from bundles to reduce unnecessary bytes consumed by network activity.",columnSource:"Source",columnDuplicatedBytes:"Duplicated bytes"},xE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(bce,"finalize");i(wce,"isDuplicatedJavaScriptIns\
ight");i(Ece,"generateInsight");i(Tce,"createOverlays")});var RE={};x(RE,{UIStrings:()=>Ha,createOverlays:()=>kce,generateInsight:()=>Cce,i18nString:()=>kE,isFontDisplayInsight:()=>Sce});function xce(e){return{insightKey:ce.FONT_DISPLAY,strings:Ha,title:kE(Ha.title),description:kE(Ha.description),docs:"https://developer.chrome.com/docs/performance/insights/font-display",category:qe.INP,state:e.fonts.find(t=>t.wastedTime>0)?"fail":"pass",...e}}function Sce(e){return e.insightKey===ce.FONT_DISPLAY}function Cce(e,t){let n=[];for(let a of e.LayoutShifts.remoteFonts){let o=a.beginRemoteFontLoadEvent;if(!j.eventIsInBounds(o,t.bounds))continue;let s=`${o.pid}.${o.args.id}`,c=e.NetworkRequests.byId.get(s);if(!c||!/^(block|fallback|auto)$/.test(a.display))continue;let l=I.Micro(c.args.data.syntheticData.finishTime-c.args.data.syntheticData.sendStartTime),u=ia.floor(j.microToMilli(l),1/5);u!==0&&(u=Math.min(u,3e3),n.push({name:a.name,request:c,display:a.display,wastedTime:u}))}n.sort((a,o)=>o.wastedTime-a.wastedTime);let r=Math.max(...n.map(a=>a.wastedTime));
return xce({relatedEvents:n.map(a=>a.request),fonts:n,metricSavings:{FCP:r}})}function kce(e){return e.fonts.map(t=>({type:"ENTRY_OUTLINE",entry:t.request,outlineReason:t.wastedTime?"ERROR":"INFO"}))}var Ha,kE,_E=g(()=>{d();wt();Se();ie();$t();Ha={title:"Font display",description:"Consider setting [`font-display`](https://developer.chrome.com/docs/performance/insights/font-display) to `swap` or `optional` to ensure text is consistently visible. `swap` can be further optimized to mitigate layout shifts with [font metric overrides](https://developer.chrome.com/blog/font-fallbacks).",fontColumn:"Font",wastedTimeColumn:"Wasted time"},kE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(xce,"finalize");i(Sce,"isFontDisplayInsight");i(Cce,"generateInsight");i(kce,"createOverlays")});var AE={};x(AE,{UIStrings:()=>cr,createOverlayForEvents:()=>DE,createOverlays:()=>Nce,generateInsight:()=>Ace,i18nString:()=>IE,isForcedReflowInsight:()=>Dce});function x5(e){return e.scriptId+":"+e.lineNumber+":"+e.columnNumber}function Rce(e,t){let n=t.Renderer.entryToNode,r=new Map;if(e.length===0)return;for(let o of e){let s=n.get(o);if(!s)continue;let c=s.parent,l,u;for(;c;){let f=c.entry;if(v.isProfileCall(f))l=f.callFrame,u=f;else{v.isFunctionCall(f)&&f.args.data&&v.objectIsCallFrame(f.args.data)&&(l=f.args.data,u=f);break}c=c.parent}if(!l||!u)continue;let m=x5(l),p=me.getWithDefault(r,m,()=>({topLevelFunctionCall:l,totalReflowTime:0,topLevelFunctionCallEvents:[]}));p.totalReflowTime+=o.dur??0,p.topLevelFunctionCallEvents.push(u)}let a;return r.forEach(o=>{(!a||o.totalReflowTime>a.totalReflowTime)&&(a=o)}),a}function _ce(e){return{insightKey:ce.FORCED_REFLOW,strings:cr,title:IE(cr.title),description:IE(cr.description),docs:"https://developer.chrome.com/docs/performance/insights/\
forced-reflow",category:qe.ALL,state:e.aggregatedBottomUpData.length!==0?"fail":"pass",...e}}function Ice(e,t){let n=Mh.get(e,t),r=re.getStackTraceTopCallFrameInEventPayload(e);return n?.callFrames[0]??r??null}function Dce(e){return e.insightKey===ce.FORCED_REFLOW}function Ace(e,t){let n=i(s=>re.frameIDForEvent(s)!==t.frameId?!1:j.eventIsInBounds(s,t.bounds),"isWithinContext"),r=new Map,a=e.Warnings.perWarning.get("FORCED_REFLOW")?.filter(n)??[];for(let s of a){let c=Ice(s,e),l=c?x5(c):"UNATTRIBUTED",u=me.getWithDefault(r,l,()=>({bottomUpData:c,totalTime:0,relatedEvents:[]}));u.totalTime+=s.dur??0,u.relatedEvents.push(s)}let o=Rce(a,e);return _ce({relatedEvents:a,topLevelFunctionCallData:o,aggregatedBottomUpData:[...r.values()]})}function Nce(e){if(!e.topLevelFunctionCallData)return[];let t=[...e.aggregatedBottomUpData.values().flatMap(n=>n.relatedEvents)];return[...DE(e.topLevelFunctionCallData.topLevelFunctionCallEvents,"INFO"),...DE(t)]}function DE(e,t="ERROR"){return e.map(n=>({type:"\
ENTRY_OUTLINE",entry:n,outlineReason:t}))}var cr,IE,NE=g(()=>{d();wt();Vu();Se();ie();$t();cr={title:"Forced reflow",description:"A forced reflow occurs when JavaScript queries geometric properties (such as `offsetWidth`) after styles have been invalidated by a change to the DOM state. This can result in poor performance. Learn more about [forced reflows](https://developer.chrome.com/docs/performance/insights/forced-reflow) and possible mitigations.",relatedStackTrace:"Stack trace",topTimeConsumingFunctionCall:"Top function call",totalReflowTime:"Total reflow time",unattributed:"[unattributed]",anonymous:"(anonymous)"},IE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(x5,"getCallFrameId");i(Rce,"getLargestTopLevelFunctionData");i(_ce,"finalize");i(Ice,"getBottomCallFrameForEvent");i(Dce,"isForcedReflowInsight");i(Ace,"generateInsight");i(Nce,"createOverlays");i(DE,"createOverlayForEvents")});var Yh={};x(Yh,{ImageOptimizationType:()=>Hr,UIStrings:()=>Jn,createOverlayForRequest:()=>R5,createOverlays:()=>jce,generateInsight:()=>Bce,getOptimizationMessage:()=>$h,getOptimizationMessageWithBytes:()=>C5,i18nString:()=>Po,isImageDeliveryInsight:()=>Lce});function Lce(e){return e.insightKey==="ImageDelivery"}function $h(e){switch(e.type){case Hr.ADJUST_COMPRESSION:return Po(Jn.useCompression);case Hr.MODERN_FORMAT_OR_COMPRESSION:return Po(Jn.useModernFormat);case Hr.VIDEO_FORMAT:return Po(Jn.useVideoFormat);case Hr.RESPONSIVE_SIZE:return Po(Jn.useResponsiveSize,{PH1:`${e.fileDimensions.width}x${e.fileDimensions.height}`,PH2:`${e.displayDimensions.width}x${e.displayDimensions.height}`})}}function C5(e){let t=(r=>({__i18nBytes:r}))(e.byteSavings),n=$h(e);return Po(Jn.estimatedSavings,{PH1:n,PH2:t})}function Fce(e){return{insightKey:ce.IMAGE_DELIVERY,strings:Jn,title:Po(Jn.title),description:Po(Jn.description),docs:"https://developer.chrome.com/docs/performance/insights/image-delivery",
category:qe.LCP,state:e.optimizableImages.length>0?"fail":"pass",...e,relatedEvents:new Map(e.optimizableImages.map(t=>[t.request,t.optimizations.map(C5)]))}}function Uce(e){return Math.round(29.1*Math.log10(e.args.data.decodedBodyLength)-100.7)/100}function k5(e,t){return e.ImagePainting.paintEventToCorrectedDisplaySize.get(t)??{width:t.args.data.width,height:t.args.data.height}}function ME(e,t){let{width:n,height:r}=k5(e,t);return{filePixels:t.args.data.srcWidth*t.args.data.srcHeight,displayedPixels:n*r}}function Bce(e,t){let n=i(s=>j.eventIsInBounds(s,t.bounds),"isWithinContext"),r=e.NetworkRequests.byTime.filter(n),a=[];for(let s of r){if(s.args.data.resourceType!=="Image"||s.args.data.mimeType==="image/svg+xml")continue;let c=s.args.data.redirects[0]?.url??s.args.data.url,l=e.ImagePainting.paintImageEventForUrl.get(c)?.filter(n);if(!l?.length)continue;let u=l.reduce((k,R)=>{let S=ME(e,k).displayedPixels,_=ME(e,R).displayedPixels;return S>_?k:R}),{filePixels:m,displayedPixels:p}=ME(
e,u),f=Math.min(s.args.data.decodedBodyLength,s.args.data.encodedDataLength),h=f/m,y=[];if(s.args.data.mimeType==="image/gif"){if(f>Mce){let k=Uce(s),R=Math.round(f*k);y.push({type:Hr.VIDEO_FORMAT,byteSavings:R})}}else if(h>S5){let k=Math.round(S5*m),R=f-k;s.args.data.mimeType!=="image/webp"&&s.args.data.mimeType!=="image/avif"?y.push({type:Hr.MODERN_FORMAT_OR_COMPRESSION,byteSavings:R}):y.push({type:Hr.ADJUST_COMPRESSION,byteSavings:R})}let b=Math.max(0,...y.map(k=>k.byteSavings)),w=b,C=1-p/m;if(C>0&&!u.args.data.isCSS){let k=Math.round(C*f);if(!(u.args.data.isPicture||u.args.data.srcsetAttribute)||k>Pce){w+=Math.round(C*(f-b));let{width:S,height:_}=k5(e,u);y.push({type:Hr.RESPONSIVE_SIZE,byteSavings:k,fileDimensions:{width:Math.round(u.args.data.srcWidth),height:Math.round(u.args.data.srcHeight)},displayDimensions:{width:Math.round(S),height:Math.round(_)}})}}y=y.filter(k=>k.byteSavings>Oce),y.length>0&&a.push({request:s,largestImagePaint:u,optimizations:y,byteSavings:w})}let o=new Map;
for(let s of a)o.set(s.request.args.data.requestId,s.byteSavings);return a.sort((s,c)=>c.byteSavings!==s.byteSavings?c.byteSavings-s.byteSavings:c.request.args.data.decodedBodyLength-s.request.args.data.decodedBodyLength),Fce({optimizableImages:a,metricSavings:ja(o,t),wastedBytes:a.reduce((s,c)=>s+c.byteSavings,0)})}function R5(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function jce(e){return e.optimizableImages.map(t=>R5(t.request))}var Jn,Po,S5,Mce,Oce,Pce,Hr,Kh=g(()=>{d();Se();ca();$t();Jn={title:"Improve image delivery",description:"Reducing the download time of images can improve the perceived load time of the page and LCP. [Learn more about optimizing image size](https://developer.chrome.com/docs/performance/insights/image-delivery)",useCompression:"Increasing the image compression factor could improve this image's download size.",useModernFormat:"Using a modern image format (WebP, AVIF) or increasing the image compression could improve this image's download si\
ze.",useVideoFormat:"Using video formats instead of GIFs can improve the download size of animated content.",useResponsiveSize:"This image file is larger than it needs to be ({PH1}) for its displayed dimensions ({PH2}). Use responsive images to reduce the image download size.",optimizeFile:"Optimize file size",others:"{PH1} others",noOptimizableImages:"No optimizable images",estimatedSavings:"{PH1} (Est {PH2})"},Po=i((e,t)=>({i18nId:e,values:t}),"i18nString"),S5=2/12,Mce=100*1024,Oce=4096,Pce=12288;(function(e){e.ADJUST_COMPRESSION="ADJUST_COMPRESSION",e.MODERN_FORMAT_OR_COMPRESSION="MODERN_FORMAT_OR_COMPRESSION",e.VIDEO_FORMAT="VIDEO_FORMAT",e.RESPONSIVE_SIZE="RESPONSIVE_SIZE"})(Hr||(Hr={}));i(Lce,"isImageDeliveryInsight");i($h,"getOptimizationMessage");i(C5,"getOptimizationMessageWithBytes");i(Fce,"finalize");i(Uce,"estimateGIFPercentSavings");i(k5,"getDisplayedSize");i(ME,"getPixelCounts");i(Bce,"generateInsight");i(R5,"createOverlayForRequest");i(jce,"createOverlays")});var OE={};x(OE,{UIStrings:()=>Dn,createOverlays:()=>zce,createOverlaysForSubpart:()=>I5,generateInsight:()=>qce,i18nString:()=>dc,isINPBreakdownInsight:()=>Hce});function Hce(e){return e.insightKey===ce.INP_BREAKDOWN}function _5(e){let t="pass";return e.longestInteractionEvent&&(dt.UserInteractions.scoreClassificationForInteractionToNextPaint(e.longestInteractionEvent.dur)===dt.PageLoadMetrics.ScoreClassification.GOOD?t="informative":t="fail"),{insightKey:ce.INP_BREAKDOWN,strings:Dn,title:dc(Dn.title),description:dc(Dn.description),docs:"https://developer.chrome.com/docs/performance/insights/inp-breakdown",category:qe.INP,state:t,...e}}function qce(e,t){let n=e.UserInteractions.interactionEventsWithNoNesting.filter(s=>j.eventIsInBounds(s,t.bounds));if(!n.length)return _5({});let r=new Map;for(let s of n){let c=s.interactionId,l=r.get(c);(!l||s.dur>l.dur)&&r.set(c,s)}let a=[...r.values()];a.sort((s,c)=>c.dur-s.dur);let o=Math.min(9,Math.floor(a.length/50));return _5({relatedEvents:[a[0]],
longestInteractionEvent:a[0],highPercentileInteractionEvent:a[o]})}function I5(e,t=-1){let n=j.traceWindowFromMicroSeconds(e.ts,e.ts+e.inputDelay),r=j.traceWindowFromMicroSeconds(n.max,n.max+e.mainThreadHandling),a=j.traceWindowFromMicroSeconds(r.max,r.max+e.presentationDelay),o=[{bounds:n,label:dc(Dn.inputDelay),showDuration:!0},{bounds:r,label:dc(Dn.processingDuration),showDuration:!0},{bounds:a,label:dc(Dn.presentationDelay),showDuration:!0}];return t!==-1&&(o=[o[t]]),[{type:"TIMESPAN_BREAKDOWN",sections:o,renderLocation:"BELOW_EVENT",entry:e}]}function zce(e){let t=e.longestInteractionEvent;return t?I5(t):[]}var Dn,dc,PE=g(()=>{d();tn();Se();$t();Dn={description:"Start investigating [how to improve INP](https://developer.chrome.com/docs/performance/insights/inp-breakdown) by looking at the longest subpart.",title:"INP breakdown",subpart:"Subpart",duration:"Duration",inputDelay:"Input delay",processingDuration:"Processing duration",presentationDelay:"Presentation delay",noInteractions:"\
No interactions detected"},dc=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Hce,"isINPBreakdownInsight");i(_5,"finalize");i(qce,"generateInsight");i(I5,"createOverlaysForSubpart");i(zce,"createOverlays")});var LE={};x(LE,{UIStrings:()=>nn,createOverlays:()=>$ce,generateInsight:()=>Vce,i18nString:()=>Lo,isLCPBreakdownInsight:()=>Gce});function Gce(e){return e.insightKey==="LCPBreakdown"}function D5(...e){return e.some(t=>Number.isNaN(t))}function Wce(e,t,n,r){let a=Xi(t);if(a===null)return null;let o=j.traceWindowFromMicroSeconds(e.ts,a);o.label=Lo(nn.timeToFirstByte);let s=j.traceWindowFromMicroSeconds(o.max,n.ts);if(s.label=Lo(nn.elementRenderDelay),!r)return D5(o.range,s.range)?null:{ttfb:o,renderDelay:s};let c=r.ts,l=r.args.data.syntheticData.finishTime,u=j.traceWindowFromMicroSeconds(o.max,c),m=j.traceWindowFromMicroSeconds(c,l);return s=j.traceWindowFromMicroSeconds(l,n.ts),u.label=Lo(nn.resourceLoadDelay),m.label=Lo(nn.resourceLoadDuration),s.label=Lo(nn.elementRenderDelay),D5(o.range,u.range,m.range,s.range)?null:{ttfb:o,loadDelay:u,loadDuration:m,renderDelay:s}}function Xh(e){let t=[];e.lcpEvent&&t.push(e.lcpEvent),e.lcpRequest&&t.push(e.lcpRequest);let n="pass";return e.lcpMs!==
void 0&&(dt.PageLoadMetrics.scoreClassificationForLargestContentfulPaint(j.milliToMicro(e.lcpMs))===dt.PageLoadMetrics.ScoreClassification.GOOD?n="informative":n="fail"),{insightKey:ce.LCP_BREAKDOWN,strings:nn,title:Lo(nn.title),description:Lo(nn.description),docs:"https://developer.chrome.com/docs/performance/insights/lcp-breakdown",category:qe.LCP,state:n,...e,relatedEvents:t}}function Vce(e,t){if(!t.navigation)return Xh({});let n=e.NetworkRequests,r=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!r)throw new Error("no frame metrics");let a=r.get(t.navigationId);if(!a)throw new Error("no navigation metrics");let o=a.get(dt.PageLoadMetrics.MetricName.LCP),s=o?.event;if(!s||!v.isLargestContentfulPaintCandidate(s))return Xh({warnings:[Bn.NO_LCP]});let c=j.microToMilli(o.timing),l=o.event?.ts?j.microToMilli(o.event?.ts):void 0,u=e.LargestImagePaint.lcpRequestByNavigationId.get(t.navigationId),m=n.byId.get(t.navigationId);return Xh(m?{lcpMs:c,lcpTs:l,lcpEvent:s,lcpRequest:u,subparts:Wce(
t.navigation,m,s,u)??void 0}:{lcpMs:c,lcpTs:l,lcpEvent:s,lcpRequest:u,warnings:[Bn.NO_DOCUMENT_REQUEST]})}function $ce(e){if(!e.subparts||!e.lcpTs)return[];let t=[{type:"TIMESPAN_BREAKDOWN",sections:Object.values(e.subparts).map(n=>({bounds:n,label:n.label,showDuration:!0}))}];return e.lcpRequest&&t.push({type:"ENTRY_OUTLINE",entry:e.lcpRequest,outlineReason:"INFO"}),t}var nn,Lo,FE=g(()=>{d();tn();Se();ie();ca();$t();nn={title:"LCP breakdown",description:"Each [subpart has specific improvement strategies](https://developer.chrome.com/docs/performance/insights/lcp-breakdown). Ideally, most of the LCP time should be spent on loading the resources, not within delays.",timeToFirstByte:"Time to first byte",resourceLoadDelay:"Resource load delay",resourceLoadDuration:"Resource load duration",elementRenderDelay:"Element render delay",subpart:"Subpart",duration:"Duration",fieldDuration:"Field p75",noLcp:"No LCP detected"},Lo=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Gce,"isLCPBreakdownIns\
ight");i(D5,"anyValuesNaN");i(Wce,"determineSubparts");i(Xh,"finalize");i(Vce,"generateInsight");i($ce,"createOverlays")});var UE={};x(UE,{UIStrings:()=>lr,createOverlays:()=>Xce,generateInsight:()=>Kce,getImageData:()=>A5,i18nString:()=>Zi,isLCPDiscoveryInsight:()=>Yce});function Yce(e){return e.insightKey==="LCPDiscovery"}function Ju(e){let t=e.lcpEvent&&e.lcpRequest?[e.lcpEvent,e.lcpRequest]:[];return{insightKey:ce.LCP_DISCOVERY,strings:lr,title:Zi(lr.title),description:Zi(lr.description),docs:"https://developer.chrome.com/docs/performance/insights/lcp-discovery",category:qe.LCP,state:e.lcpRequest&&e.checklist&&(!e.checklist.eagerlyLoaded.value||!e.checklist.requestDiscoverable.value||!e.checklist.priorityHinted.value)?"fail":"pass",...e,relatedEvents:t}}function Kce(e,t){if(!t.navigation)return Ju({});let n=e.NetworkRequests,r=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!r)throw new Error("no frame metrics");let a=r.get(t.navigationId);if(!a)throw new Error("no navigation metrics");let s=a.get(dt.PageLoadMetrics.MetricName.LCP)?.event;if(!s||!v.isLargestContentfulPaintCandidate(s))return Ju(
{warnings:[Bn.NO_LCP]});let c=n.byId.get(t.navigationId);if(!c)return Ju({warnings:[Bn.NO_DOCUMENT_REQUEST]});let l=e.LargestImagePaint.lcpRequestByNavigationId.get(t.navigationId);if(!l)return Ju({lcpEvent:s});let u=l.args.data.initiator?.url,m=l?.args.data.initiator?.type==="parser"&&c.args.data.url===u,p=l?.args.data.isLinkPreload||m,f=s.args.data?.loadingAttr,h=l?.args.data.fetchPriorityHint,y=Xi(c),b=h==="high";return Ju({lcpEvent:s,lcpRequest:l,earliestDiscoveryTimeTs:y?I.Micro(y):void 0,checklist:{priorityHinted:{label:Zi(b?lr.fetchPriorityApplied:lr.fetchPriorityShouldBeApplied),value:b},requestDiscoverable:{label:Zi(lr.requestDiscoverable),value:p},eagerlyLoaded:{label:Zi(lr.lazyLoadNotApplied),value:f!=="lazy"}}})}function A5(e){if(!e.lcpRequest||!e.checklist)return null;let t=!e.checklist.priorityHinted.value,n=!e.checklist.requestDiscoverable.value,r=!e.checklist.eagerlyLoaded.value;if(!(t!==void 0&&n!==void 0&&r!==void 0))return null;let o={checklist:e.checklist,request:e.
lcpRequest,discoveryDelay:null,estimatedSavings:e.metricSavings?.LCP??null};if(e.earliestDiscoveryTimeTs&&e.lcpRequest){let s=e.lcpRequest.ts-e.earliestDiscoveryTimeTs;o.discoveryDelay=I.Micro(s)}return o}function Xce(e){let t=A5(e);if(!t?.discoveryDelay)return[];let n=j.traceWindowFromMicroSeconds(I.Micro(t.request.ts-t.discoveryDelay),t.request.ts);return[{type:"ENTRY_OUTLINE",entry:t.request,outlineReason:"ERROR"},{type:"CANDY_STRIPED_TIME_RANGE",bounds:n,entry:t.request},{type:"TIMESPAN_BREAKDOWN",sections:[{bounds:n,label:`${t.discoveryDelay} microseconds`,showDuration:!1}],entry:t.request,renderLocation:"ABOVE_EVENT"}]}var lr,Zi,BE=g(()=>{d();tn();Se();ie();ca();$t();lr={title:"LCP request discovery",description:"[Optimize LCP](https://developer.chrome.com/docs/performance/insights/lcp-discovery) by making the LCP image discoverable from the HTML immediately, and avoiding lazy-loading",lcpLoadDelay:"LCP image loaded {PH1} after earliest start point.",fetchPriorityApplied:"fetchpr\
iority=high applied",fetchPriorityShouldBeApplied:"fetchpriority=high should be applied",requestDiscoverable:"Request is discoverable in initial document",lazyLoadNotApplied:"lazy load not applied",noLcp:"No LCP detected",noLcpResource:"No LCP resource detected because the LCP is not an image"},Zi=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Yce,"isLCPDiscoveryInsight");i(Ju,"finalize");i(Kce,"generateInsight");i(A5,"getImageData");i(Xce,"createOverlays")});var Jh={};x(Jh,{detectLegacyJavaScript:()=>ale,getCoreJsPolyfillData:()=>M5,getTransformPatterns:()=>HE});function ele(e,t,n){let r=i(o=>`['"]${o}['"]`,"qt"),a="";if(e?a+=`${e}\\.${t}\\s?=[^=]`:a+=`(?:window\\.|[\\s;]+)${t}\\s?=[^=]`,e&&(a+=`|${e}\\[${r(t)}\\]\\s?=[^=]`),a+=`|defineProperty\\(${e||"window"},\\s?${r(t)}`,e&&(a+=`|\\(${e},\\s*{${t}:.*},\\s*{${t}`),e){let o=e.replace(".prototype","");a+=`|{target:${r(o)}[^;]*},{${t}:`}return a+=`|${n.replaceAll(".","\\.")}(?:\\.js)?"`,a}function M5(){return N5.filter(e=>e.corejs).map(e=>({name:e.name,coreJs3Module:e.modules[0]}))}function tle(){let e=[];for(let{name:t,coreJs3Module:n}of M5()){let r=t.split("."),a=r.length>1?r.slice(0,r.length-1).join("."):null,o=r[r.length-1];e.push({name:t,expression:ele(a,o,n)})}return e}function HE(){let e=i((t,n)=>typeof n=="string"?t.split(n).length-1:(t.match(n)??[]).length,"count");return[{name:"@babel/plugin-transform-classes",expression:"Cannot call a class as a function",estimateBytes:i(t=>1e3+(e(
t,"_classCallCheck")-1)*17,"estimateBytes")},{name:"@babel/plugin-transform-regenerator",expression:"Generator is already running|regeneratorRuntime",estimateBytes:i(t=>e(t,/regeneratorRuntime\(?\)?\.a?wrap/g)*80,"estimateBytes")},{name:"@babel/plugin-transform-spread",expression:"Invalid attempt to spread non-iterable instance",estimateBytes:i(t=>1169+e(t,/\.apply\(void 0,\s?_toConsumableArray/g)*20,"estimateBytes")}]}function nle(e,t){let n=t.filter(l=>!l.name.startsWith("@")),r=t.filter(l=>l.name.startsWith("@")),a=0,o=new Set;for(let l of n){let u=jE.dependencies[l.name];if(u)for(let m of u)o.add(m)}a+=[...o].reduce((l,u)=>l+jE.moduleSizes[u],0),a=Math.min(a,jE.maxSize);let s=0;for(let l of r){let u=HE().find(m=>m.name===l.name);!u||!u.estimateBytes||!e||(s+=u.estimateBytes(e))}return a+s}function ale(e,t){if(!e)return{matches:[],estimatedByteSavings:0};let n=rle.match(e);if(t)for(let{name:r,modules:a}of N5){if(n.some(c=>c.name===r))continue;let o=t.sourceURLs().find(c=>a.some(l=>c.
endsWith(`/${l}.js`)||c.includes(`node_modules/${l}/`)));if(!o)continue;let s=t.mappings().find(c=>c.sourceURL===o);s?n.push({name:r,line:s.lineNumber,column:s.columnNumber}):n.push({name:r,line:0,column:0})}return n=n.sort((r,a)=>r.name>a.name?1:r.name===a.name?0:-1),{matches:n,estimatedByteSavings:nle(e,n)}}var Jce,Zce,N5,jE,Qce,rle,O5=g(()=>{d();Jce=[{name:"focus-visible",modules:["focus-visible"]},{name:"Error.prototype.cause",modules:["es.error.cause"]},{name:"Array.prototype.at",modules:["es.array.at","esnext.array.at"],corejs:!0},{name:"Array.prototype.concat",modules:["es.array.concat"],corejs:!0},{name:"Array.prototype.copyWithin",modules:["es.array.copy-within"],corejs:!0},{name:"Array.prototype.every",modules:["es.array.every"],corejs:!0},{name:"Array.prototype.fill",modules:["es.array.fill"],corejs:!0},{name:"Array.prototype.filter",modules:["es.array.filter"],corejs:!0},{name:"Array.prototype.find",modules:["es.array.find"],corejs:!0},{name:"Array.prototype.findIndex",modules:[
"es.array.find-index"],corejs:!0},{name:"Array.prototype.findLast",modules:["es.array.find-last","esnext.array.find-last"],corejs:!0},{name:"Array.prototype.findLastIndex",modules:["es.array.find-last-index","esnext.array.find-last-index"],corejs:!0},{name:"Array.prototype.flat",modules:["es.array.flat"],corejs:!0},{name:"Array.prototype.flatMap",modules:["es.array.flat-map"],corejs:!0},{name:"Array.prototype.forEach",modules:["es.array.for-each"],corejs:!0},{name:"Array.from",modules:["es.array.from"],corejs:!0},{name:"Array.prototype.includes",modules:["es.array.includes"],corejs:!0},{name:"Array.prototype.indexOf",modules:["es.array.index-of"],corejs:!0},{name:"Array.isArray",modules:["es.array.is-array"],corejs:!0},{name:"Array.prototype.join",modules:["es.array.join"],corejs:!0},{name:"Array.prototype.map",modules:["es.array.map"],corejs:!0},{name:"Array.of",modules:["es.array.of"],corejs:!0},{name:"Array.prototype.slice",modules:["es.array.slice"],corejs:!0},{name:"Array.prototyp\
e.some",modules:["es.array.some"],corejs:!0},{name:"Array.prototype.sort",modules:["es.array.sort"],corejs:!0},{name:"Array.prototype.unshift",modules:["es.array.unshift"],corejs:!0},{name:"Math.acosh",modules:["es.math.acosh"],corejs:!0},{name:"Math.asinh",modules:["es.math.asinh"],corejs:!0},{name:"Math.atanh",modules:["es.math.atanh"],corejs:!0},{name:"Math.cbrt",modules:["es.math.cbrt"],corejs:!0},{name:"Math.clz32",modules:["es.math.clz32"],corejs:!0},{name:"Math.cosh",modules:["es.math.cosh"],corejs:!0},{name:"Math.expm1",modules:["es.math.expm1"],corejs:!0},{name:"Math.fround",modules:["es.math.fround"],corejs:!0},{name:"Math.hypot",modules:["es.math.hypot"],corejs:!0},{name:"Math.imul",modules:["es.math.imul"],corejs:!0},{name:"Math.log10",modules:["es.math.log10"],corejs:!0},{name:"Math.log1p",modules:["es.math.log1p"],corejs:!0},{name:"Math.log2",modules:["es.math.log2"],corejs:!0},{name:"Math.sign",modules:["es.math.sign"],corejs:!0},{name:"Math.sinh",modules:["es.math.sinh"],
corejs:!0},{name:"Math.tanh",modules:["es.math.tanh"],corejs:!0},{name:"Math.trunc",modules:["es.math.trunc"],corejs:!0},{name:"Object.assign",modules:["es.object.assign"],corejs:!0},{name:"Object.create",modules:["es.object.create"],corejs:!0},{name:"Object.entries",modules:["es.object.entries"],corejs:!0},{name:"Object.freeze",modules:["es.object.freeze"],corejs:!0},{name:"Object.fromEntries",modules:["es.object.from-entries"],corejs:!0},{name:"Object.getOwnPropertyDescriptor",modules:["es.object.get-own-property-descriptor"],corejs:!0},{name:"Object.getOwnPropertyDescriptors",modules:["es.object.get-own-property-descriptors"],corejs:!0},{name:"Object.getPrototypeOf",modules:["es.object.get-prototype-of"],corejs:!0},{name:"Object.hasOwn",modules:["es.object.has-own","esnext.object.has-own"],corejs:!0},{name:"Object.is",modules:["es.object.is"],corejs:!0},{name:"Object.isExtensible",modules:["es.object.is-extensible"],corejs:!0},{name:"Object.isFrozen",modules:["es.object.is-frozen"],
corejs:!0},{name:"Object.isSealed",modules:["es.object.is-sealed"],corejs:!0},{name:"Object.keys",modules:["es.object.keys"],corejs:!0},{name:"Object.preventExtensions",modules:["es.object.prevent-extensions"],corejs:!0},{name:"Object.seal",modules:["es.object.seal"],corejs:!0},{name:"Object.setPrototypeOf",modules:["es.object.set-prototype-of"],corejs:!0},{name:"Object.values",modules:["es.object.values"],corejs:!0},{name:"Promise.any",modules:["es.promise.any","esnext.promise.any"],corejs:!0},{name:"Reflect.apply",modules:["es.reflect.apply"],corejs:!0},{name:"Reflect.construct",modules:["es.reflect.construct"],corejs:!0},{name:"Reflect.deleteProperty",modules:["es.reflect.delete-property"],corejs:!0},{name:"Reflect.get",modules:["es.reflect.get"],corejs:!0},{name:"Reflect.getOwnPropertyDescriptor",modules:["es.reflect.get-own-property-descriptor"],corejs:!0},{name:"Reflect.getPrototypeOf",modules:["es.reflect.get-prototype-of"],corejs:!0},{name:"Reflect.has",modules:["es.reflect.has"],
corejs:!0},{name:"Reflect.isExtensible",modules:["es.reflect.is-extensible"],corejs:!0},{name:"Reflect.ownKeys",modules:["es.reflect.own-keys"],corejs:!0},{name:"Reflect.preventExtensions",modules:["es.reflect.prevent-extensions"],corejs:!0},{name:"Reflect.setPrototypeOf",modules:["es.reflect.set-prototype-of"],corejs:!0},{name:"String.prototype.codePointAt",modules:["es.string.code-point-at"],corejs:!0},{name:"String.prototype.endsWith",modules:["es.string.ends-with"],corejs:!0},{name:"String.fromCodePoint",modules:["es.string.from-code-point"],corejs:!0},{name:"String.prototype.includes",modules:["es.string.includes"],corejs:!0},{name:"String.prototype.matchAll",modules:["es.string.match-all","esnext.string.match-all"],corejs:!0},{name:"String.raw",modules:["es.string.raw"],corejs:!0},{name:"String.prototype.repeat",modules:["es.string.repeat"],corejs:!0},{name:"String.prototype.replaceAll",modules:["es.string.replace-all","esnext.string.replace-all"],corejs:!0},{name:"String.prototy\
pe.startsWith",modules:["es.string.starts-with"],corejs:!0},{name:"String.prototype.substr",modules:["es.string.substr"],corejs:!0},{name:"String.prototype.trim",modules:["es.string.trim"],corejs:!0},{name:"String.prototype.trimEnd",modules:["es.string.trim-end"],corejs:!0},{name:"String.prototype.trimStart",modules:["es.string.trim-start"],corejs:!0},{name:"String.prototype.link",modules:["es.string.link"],corejs:!0},{name:"Promise.allSettled",modules:["esnext.promise.all-settled"],corejs:!0}],Zce={moduleSizes:[26070,498,282,294,281,467,161,236,229,765,546,339,1608,723,729,1545,438,214,657,111,759,537,209,281,685,217,757,631,293,182,475,79,407,140,366,792,269,222,158,280,188,137,158,105,189,543,160,742,1436,88,904,146,314,375,183,1083,195,503,269,208,334,350,460,568,229,1155,334,266,30,120,309,370,358,1952,1638,304,153,274,1288,192,543,74,144,137,33,336,457,2122,535,711,1323,117,1961,244,557,318,119,124,108,144,96,133,441,210,1627,1956,693,1426,863,637,301,51,708,583,119,600,221,370,728,
1085,552,629,125,1746,97,441,543,2756,371,447,548,243,266,217,99,440,183,546,137,464,207,983,503,237,382,249,675,402,254,223,164,214,191,831,218,202,232,124,249,160,251,217,717,78,561,1627,256,386,225,432,499,394,364,445,634,667,177,346,470,663,142,588,414,617,1559,380,2520,1040,417,289,238,220,214,303,163,141,510,397,137,137,133,133,390,266,137,183,215,191,485,328,575,799,533,148,215,589,589,130,362,562,471,179,186,1266,1456,521,1536,427,444,406,912,150,283,144,485,470,205,1268,796,658,306,3751,814,146,2328,1226,922,237,206,198,250,283,60,3e3],dependencies:{"Array.prototype.at":[0,5,69,105,106,116,164],"Array.prototype.concat":[0,16,21,22,26,34,40,76,78,155,165],"Array.prototype.copyWithin":[0,5,9,37,69,105,106,116,166],"Array.prototype.every":[0,15,17,21,22,26,53,59,76,78,155,167],"Array.prototype.fill":[0,5,10,69,105,106,116,168],"Array.prototype.filter":[0,15,16,21,22,26,53,59,76,78,155,169],"Array.prototype.find":[0,5,15,21,22,26,53,59,69,76,78,105,106,116,155,173],"Array.prototyp\
e.findIndex":[0,5,15,21,22,26,53,59,69,76,78,105,106,116,155,170],"Array.prototype.findLast":[0,5,14,53,59,69,105,106,116,172],"Array.prototype.findLastIndex":[0,5,14,53,59,69,105,106,116,171],"Array.prototype.flat":[0,21,22,26,40,50,53,59,76,78,155,175],"Array.prototype.flatMap":[0,21,22,26,40,50,53,59,76,78,155,174],"Array.prototype.forEach":[0,11,15,17,21,22,26,53,59,76,78,155,176],"Array.from":[0,12,23,24,26,34,53,59,62,63,75,78,88,155,177],"Array.prototype.includes":[0,5,69,105,106,116,178],"Array.prototype.indexOf":[0,17,59,179],"Array.isArray":[0,76,180],"Array.prototype.join":[0,17,181],"Array.prototype.map":[0,15,16,21,22,26,53,59,76,78,155,182],"Array.of":[0,26,34,78,155,183],"Array.prototype.slice":[0,16,19,26,34,76,78,155,184],"Array.prototype.some":[0,15,17,21,22,26,53,59,76,78,155,185],"Array.prototype.sort":[0,17,19,20,26,37,42,43,46,155,156,186],"Array.prototype.unshift":[0,18,37,40,76,187],"Math.acosh":[0,97,188],"Math.asinh":[0,189],"Math.atanh":[0,190],"Math.cbrt":[0,
100,191],"Math.clz32":[0,192],"Math.cosh":[0,93,193],"Math.expm1":[0,93,194],"Math.fround":[0,94,95,99,100,195],"Math.hypot":[0,196],"Math.imul":[0,197],"Math.log10":[0,96,198],"Math.log1p":[0,97,199],"Math.log2":[0,98,200],"Math.sign":[0,100,201],"Math.sinh":[0,93,202],"Math.tanh":[0,93,203],"Math.trunc":[0,204],"Object.assign":[0,104,116,205],"Object.create":[0,69,105,106,116,206],"Object.entries":[0,29,112,116,119,207],"Object.freeze":[0,8,19,51,73,109,113,208],"Object.fromEntries":[0,26,34,53,59,62,63,75,87,88,155,209],"Object.getOwnPropertyDescriptor":[0,210],"Object.getOwnPropertyDescriptors":[0,34,211],"Object.getPrototypeOf":[0,29,112,212],"Object.hasOwn":[0,213],"Object.is":[0,134,217],"Object.isExtensible":[0,8,113,214],"Object.isFrozen":[0,8,215],"Object.isSealed":[0,8,216],"Object.keys":[0,116,218],"Object.preventExtensions":[0,8,19,51,73,109,113,219],"Object.seal":[0,8,19,51,73,109,113,220],"Object.setPrototypeOf":[0,4,58,83,118,221],"Object.values":[0,29,112,116,119,222],
"Promise.any":[0,24,26,47,53,59,62,63,75,87,88,102,122,123,124,125,155,224],"Reflect.apply":[0,52,225],"Reflect.construct":[0,3,19,26,52,55,69,78,105,106,116,155,226],"Reflect.deleteProperty":[0,227],"Reflect.get":[0,29,79,112,230],"Reflect.getOwnPropertyDescriptor":[0,228],"Reflect.getPrototypeOf":[0,29,112,229],"Reflect.has":[0,231],"Reflect.isExtensible":[0,8,113,232],"Reflect.ownKeys":[0,233],"Reflect.preventExtensions":[0,51,234],"Reflect.setPrototypeOf":[0,4,58,83,118,235],"String.prototype.codePointAt":[0,26,141,155,156,236],"String.prototype.endsWith":[0,26,28,59,85,103,155,156,237],"String.fromCodePoint":[0,238],"String.prototype.includes":[0,26,28,85,103,155,156,239],"String.prototype.matchAll":[0,3,6,26,29,31,59,69,78,85,89,90,105,106,112,116,126,127,128,129,130,131,132,135,139,141,155,156,241],"String.raw":[0,26,155,156,242],"String.prototype.repeat":[0,26,142,155,156,243],"String.prototype.replaceAll":[0,26,65,85,128,129,155,156,244],"String.prototype.startsWith":[0,26,28,
59,85,103,155,156,245],"String.prototype.substr":[0,26,155,156,246],"String.prototype.trim":[0,26,144,146,155,156,163,251],"String.prototype.trimEnd":[0,26,143,144,146,155,156,163,247,249],"String.prototype.trimStart":[0,26,144,145,146,155,156,163,248,250],"String.prototype.link":[0,26,30,140,155,156,240],"Promise.allSettled":[0,24,26,47,53,59,62,63,75,87,88,102,122,123,124,125,155,223,252],"focus-visible":[253]},maxSize:155835},N5=Jce,jE=Zce,Qce=class{static{i(this,"CodePatternMatcher")}constructor(e){this.patterns=e}match(e){if(!this.re){let s=this.patterns.map(c=>`(${c.expression})`).join("|");this.re=new RegExp(`(^\r
|\r|
)|${s}`,"g")}this.re.lastIndex=0;let t=new Set,n=[],r,a=0,o=0;for(;(r=this.re.exec(e))!==null;){let s=r.slice(1),[c,...l]=s;if(c){a++,o=r.index+1;continue}let u=this.patterns[l.findIndex(Boolean)];t.has(u)||(t.add(u),n.push({name:u.name,line:a,column:r.index-o}))}return n}};i(ele,"buildPolyfillExpression");i(M5,"getCoreJsPolyfillData");i(tle,"getPolyfillPatterns");i(HE,"getTransformPatterns");i(nle,"estimateWastedBytes");rle=new Qce([...tle(),...HE()]);i(ale,"detectLegacyJavaScript");});var P5=g(()=>{d();O5()});var zE={};x(zE,{UIStrings:()=>ua,createOverlays:()=>ule,generateInsight:()=>lle,i18nString:()=>qE,isLegacyJavaScript:()=>cle});function sle(e){let t=[...e.legacyJavaScriptResults.keys()].map(n=>n.request).filter(n=>!!n);return{insightKey:ce.LEGACY_JAVASCRIPT,strings:ua,title:qE(ua.title),description:qE(ua.description),docs:"https://developer.chrome.com/docs/performance/insights/legacy-javascript",category:qe.ALL,state:t.length?"fail":"pass",relatedEvents:[...new Set(t)],...e}}function cle(e){return e.insightKey===ce.LEGACY_JAVASCRIPT}function lle(e,t){let n=e.Scripts.scripts.filter(s=>s.frame!==t.frameId||s.url?.startsWith("chrome-extension://")?!1:j.timestampIsInBounds(t.bounds,s.ts)||s.request&&j.eventIsInBounds(s.request,t.bounds)),r=new Map,a=new Map;for(let s of n){if(!s.content||s.content.length<L5)continue;let c=ile(s.content,s.sourceMap);if(c.estimatedByteSavings<L5)continue;let l=Yu(s),u=Math.round(c.estimatedByteSavings*l);if(c.estimatedByteSavings=u,r.set(s,c),s.request){let m=s.
request.args.data.requestId;a.set(m,u)}}let o=new Map([...r].sort((s,c)=>c[1].estimatedByteSavings-s[1].estimatedByteSavings));return sle({legacyJavaScriptResults:o,metricSavings:ja(a,t),wastedBytes:a.values().reduce((s,c)=>s+c,0)})}function ule(e){return[...e.legacyJavaScriptResults.keys()].map(t=>t.request).filter(t=>!!t).map(t=>({type:"ENTRY_OUTLINE",entry:t,outlineReason:"ERROR"}))}var ile,ua,qE,L5,GE=g(()=>{d();P5();Se();ca();$t();({detectLegacyJavaScript:ile}=Jh),ua={title:"Legacy JavaScript",description:"Polyfills and transforms enable older browsers to use new JavaScript features. However, many aren't necessary for modern browsers. Consider modifying your JavaScript build process to not transpile [Baseline](https://web.dev/articles/baseline-and-polyfills) features, unless you know you must support older browsers. [Learn why most sites can deploy ES6+ code without transpiling](https://developer.chrome.com/docs/performance/insights/legacy-javascript)",columnScript:"Script",columnWastedBytes:"\
Wasted bytes"},qE=i((e,t)=>({i18nId:e,values:t}),"i18nString"),L5=5e3;i(sle,"finalize");i(cle,"isLegacyJavaScript");i(lle,"generateInsight");i(ule,"createOverlays")});var Zu={};x(Zu,{UIStrings:()=>da,createOverlayForRequest:()=>B5,createOverlays:()=>gle,determineHttp1Requests:()=>U5,generateInsight:()=>hle,i18nString:()=>WE,isModernHTTPInsight:()=>dle});function dle(e){return e.insightKey===ce.MODERN_HTTP}function mle(e,t,n){if(!In.STATIC_RESOURCE_TYPES.has(e.args.data.resourceType))return!1;if(e.args.data.decodedBodyLength<100){let r=t.entityByEvent.get(e);if(r){if(n?.name===r.name)return!0;if(!r.isUnrecognized)return!1}}return!0}function U5(e,t,n){let r=[],a=new Map;for(let s of e){let c=new URL(s.args.data.url);if(!mle(s,t,n)||In.isSyntheticNetworkRequestLocalhost(s))continue;me.getWithDefault(a,c.origin,()=>[]).push(s)}let o=new Set;for(let s of e){if(o.has(s.args.data.url)||s.args.data.fromServiceWorker||!/HTTP\/[01][.\d]?/i.test(s.args.data.protocol))continue;let l=new URL(s.args.data.url);(a.get(l.origin)||[]).length<6||(o.add(s.args.data.url),r.push(s))}return r}function F5(e,t,n){let r=n.simulate(t),a=new Map;t.traverse(c=>{c.type==="networ\
k"&&e.has(c.request.url)&&(a.set(c.request.requestId,c.request.protocol),c.request.protocol="h2")});let o=n.simulate(t);t.traverse(c=>{if(c.type!=="network")return;let l=a.get(c.request.requestId);l!==void 0&&(c.request.protocol=l)});let s=r.timeInMs-o.timeInMs;return ia.floor(s,1/10)}function ple(e,t){if(!t.navigation||!t.lantern)return;let n=new Set(e.map(o=>o.args.data.url)),r=t.lantern.metrics.firstContentfulPaint.optimisticGraph,a=t.lantern.metrics.largestContentfulPaint.optimisticGraph;return{FCP:F5(n,r,t.lantern.simulator),LCP:F5(n,a,t.lantern.simulator)}}function fle(e){return{insightKey:ce.MODERN_HTTP,strings:da,title:WE(da.title),description:WE(da.description),docs:"https://developer.chrome.com/docs/performance/insights/modern-http",category:qe.LCP,state:e.http1Requests.length>0?"fail":"pass",...e,relatedEvents:e.http1Requests}}function hle(e,t){let n=i(l=>j.eventIsInBounds(l,t.bounds),"isWithinContext"),r=e.NetworkRequests.byTime.filter(n),a=e.NetworkRequests.entityMappings,
o=t.navigation?.args.data?.documentLoaderURL??e.Meta.mainFrameURL,s=vr.getEntityForUrl(o,a),c=U5(r,a,s??null);return fle({http1Requests:c,metricSavings:ple(c,t)})}function B5(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function gle(e){return e.http1Requests.map(t=>B5(t))??[]}var da,WE,Zh=g(()=>{d();wt();tn();Se();$t();da={title:"Modern HTTP",description:"HTTP/2 and HTTP/3 offer many benefits over HTTP/1.1, such as multiplexing. [Learn more about using modern HTTP](https://developer.chrome.com/docs/performance/insights/modern-http).",request:"Request",protocol:"Protocol",noOldProtocolRequests:"No requests used HTTP/1.1, or its current use of HTTP/1.1 does not present a significant optimization opportunity. HTTP/1.1 requests are only flagged if six or more static assets originate from the same origin, and they are not served from a local development environment or a third-party source."},WE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(dle,"isModernHTTPInsight");i(mle,
"isMultiplexableStaticAsset");i(U5,"determineHttp1Requests");i(F5,"computeWasteWithGraph");i(ple,"computeMetricSavings");i(fle,"finalize");i(hle,"generateInsight");i(B5,"createOverlayForRequest");i(gle,"createOverlays")});var YE={};x(YE,{ParsedURL:()=>Qu,TOO_MANY_PRECONNECTS_THRESHOLD:()=>eg,UIStrings:()=>Bt,createOverlays:()=>_le,generateInsight:()=>Rle,generatePreconnectCandidates:()=>W5,generatePreconnectedOrigins:()=>G5,handleLinkResponseHeader:()=>z5,i18nString:()=>Qh,isNetworkDependencyTreeInsight:()=>kle,normalizePath:()=>$E,schemeIs:()=>Ile});function j5(e){return{insightKey:ce.NETWORK_DEPENDENCY_TREE,strings:Bt,title:Qh(Bt.title),description:Qh(Bt.description),docs:"https://developer.chrome.com/docs/performance/insights/network-dependency-tree",category:qe.LCP,state:e.fail?"fail":"pass",...e}}function H5(e,t){if(e.args.data.requestId===t.navigationId)return!0;if(e.args.data.isLinkPreload)return!1;let n=e.args.data.resourceType==="Document"&&e.args.data.frame!==t.frameId;if(yle.has(e.args.data.resourceType)||n||e.args.data.mimeType.startsWith("image/")||!(e.args.data.initiator?.url||re.getStackTraceTopCallFrameInEventPayload(e)?.url))return!1;let a=In.isSyntheticNetworkRequestEventRenderBlocking(
e);return In.isSyntheticNetworkRequestHighPriority(e)||a}function VE(e){if(e.children.length===0)return e;let t=e.children[0];for(let n of e.children){let r=VE(n);r.timeFromInitialRequest>t.timeFromInitialRequest&&(t=r)}return t}function q5(e){for(let t of e)t.children.length>0&&(t.children.sort((n,r)=>{let a=VE(n);return VE(r).timeFromInitialRequest-a.timeFromInitialRequest}),q5(t.children))}function wle(e){let t=[],n=new Map,r=I.Micro(0),a=!1,o=[];function s(u){if(u.length===0)return;u.length>=2&&(a=!0);let m=u[0],p=u[u.length-1],f=I.Micro(p.ts+p.dur-m.ts);f>r&&(r=f,o=u);let h=t;for(let y=0;y<u.length;++y){let b=u[y],w=h.find(C=>C.request===b);if(!w){let C=I.Micro(b.ts+b.dur-m.ts);w={request:b,timeFromInitialRequest:C,children:[],relatedRequests:new Set},h.push(w)}u.forEach(C=>w?.relatedRequests.add(C)),n.set(b,y<2?[]:[Qh(Bt.warningDescription)]),h=w.children}}i(s,"addChain");let c=new Set;function l(u){return u.getDependents().filter(m=>m.getDependencies().every(p=>c.has(p)))}if(i(l,
"getNextNodes"),e.lantern?.graph.traverse((u,m)=>{if(c.add(u),u.type!=="network"||!H5(u.rawRequest,e))return;let f=m.filter(h=>h.type==="network").reverse().map(h=>h.rawRequest);f.some(h=>!H5(h,e))||u.isNonNetworkProtocol||s(f)},l),o.length>0){let u=t;for(let m of o){let p=u.find(f=>f.request===m);p?(p.isLongest=!0,u=p.children):console.error("Some request in the longest chain is not found")}}return q5(t),{rootNodes:t,maxTime:r,fail:a,relatedEvents:n}}function mc(e){return new Qu(e).securityOrigin()}function Ele(e){if(!e)return null;let t=e.indexOf("<"),n=e.indexOf(">");if(t!==0||n===-1||n<=t)return null;let r=e.substring(t+1,n).trim();if(!r)return null;let a=e.substring(n+1).trim();if(a){let o=a.split(";");for(let s of o){let c=s.trim();if(!c)continue;let l=c.indexOf("=");if(l===-1)continue;let u=c.substring(0,l).trim().toLowerCase(),m=c.substring(l+1).trim();if(m.startsWith('"')&&m.endsWith('"')&&(m=m.substring(1,m.length-1)),u==="rel"&&m==="preconnect")return{url:r,headerText:e}}}return null}
function z5(e){if(!e)return[];let t=[];for(let n=0;n<e.length;){let r=e.indexOf(">",n);if(r===-1)break;let a=e.indexOf(",",r),o=a!==-1?a:e.length,s=e.substring(n,o);if(o+1<=n){console.warn("unexpected infinite loop, bailing");break}n=o+1;let c=Ele(s.trim());c&&t.push(c)}return t}function G5(e,t,n,r){let a=[];for(let s of e.NetworkRequests.linkPreconnectEvents)a.push({node_id:s.args.data.node_id,frame:s.args.data.frame,url:s.args.data.url,unused:!n.some(c=>mc(s.args.data.url)===mc(c.args.data.url)),crossorigin:r.some(c=>c.origin===mc(s.args.data.url)),source:"DOM"});let o=e.NetworkRequests.byId.get(t.navigationId);return o?.args.data.responseHeaders?.forEach(s=>{s.name.toLowerCase()==="link"&&z5(s.value)?.forEach(l=>a.push({url:l.url,headerText:l.headerText,request:o,unused:!n.some(u=>mc(l.url)===mc(u.args.data.url)),crossorigin:r.some(u=>u.origin===mc(l.url)),source:"ResponseHeader"}))}),a}function Tle(e){return!!e.args.data.timing&&e.args.data.timing.connectEnd>=0&&e.args.data.timing.
connectStart>=0}function xle(e){let{timing:t}=e.args.data;return t?t.dnsStart===-1&&t.dnsEnd===-1&&t.connectStart===-1&&t.connectEnd===-1||t.dnsEnd-t.dnsStart===0&&t.connectEnd-t.connectStart===0:!1}function Sle(e,t){let n=Math.max(0,e.args.data.syntheticData.sendStartTime-t.args.data.syntheticData.finishTime);return j.microToMilli(n)<vle}function Cle(e,t,n,r){let a=new Map;return n.forEach(o=>{if(!Tle(o)||e.NetworkRequests.eventToInitiator.get(o)===t)return;let s=new URL(o.args.data.url);if(s.origin==="null")return;let c=new URL(t.args.data.url).origin;if(s.origin===c||!r.has(o.args.data.url)||xle(o)||!Sle(o,t))return;me.getWithDefault(a,s.origin,()=>[]).push(o)}),a}function W5(e,t,n){if(!t.lantern)return[];let r=e.NetworkRequests.byId.get(t.navigationId);if(!r)return[];let{rtt:a,additionalRttByOrigin:o}=t.lantern.simulator.getOptions(),s=t.lantern.metrics.largestContentfulPaint.pessimisticGraph,c=t.lantern.metrics.firstContentfulPaint.pessimisticGraph,l=new Set;s.traverse(y=>{y.type===
"network"&&l.add(y.request.url)});let u=new Set;c.traverse(y=>{y.type==="network"&&u.add(y.request.url)});let m=Cle(e,r,n,l),p=I.Milli(0),f=I.Milli(0),h=[];return m.forEach(y=>{let b=y[0];if(!b.args.data.timing)return;let w=new Qu(b.args.data.url),C=w.securityOrigin(),k=o.get(C)??0,R=I.Milli(a+k);w.scheme==="https"&&(R=I.Milli(R*2));let S=I.Micro(b.args.data.syntheticData.sendStartTime-r.args.data.syntheticData.finishTime+j.milliToMicro(b.args.data.timing.dnsStart)),_=Math.min(R,j.microToMilli(S));_<ble||(p=Math.max(_,p),u.has(b.args.data.url)&&(f=Math.max(_,f)),h.push({origin:C,wastedMs:_}))}),h=h.sort((y,b)=>b.wastedMs-y.wastedMs),h.slice(0,eg)}function kle(e){return e.insightKey===ce.NETWORK_DEPENDENCY_TREE}function Rle(e,t){if(!t.navigation)return j5({rootNodes:[],maxTime:0,fail:!1,preconnectedOrigins:[],preconnectCandidates:[]});let{rootNodes:n,maxTime:r,fail:a,relatedEvents:o}=wle(t),s=i(m=>j.eventIsInBounds(m,t.bounds),"isWithinContext"),c=e.NetworkRequests.byTime.filter(s),l=W5(
e,t,c),u=G5(e,t,c,l);return j5({rootNodes:n,maxTime:r,fail:a,relatedEvents:o,preconnectedOrigins:u,preconnectCandidates:l})}function _le(e){function t(r,a){r.forEach(o=>{a.push({type:"ENTRY_OUTLINE",entry:o.request,outlineReason:"ERROR"}),t(o.children,a)})}i(t,"walk");let n=[];return t(e.rootNodes,n),n}function $E(e){if(e.indexOf("..")===-1&&e.indexOf(".")===-1)return e;let t=(e[0]==="/"?e.substring(1):e).split("/"),n=[];for(let a of t)a!=="."&&(a===".."?n.pop():n.push(a));let r=n.join("/");return e[0]==="/"&&r&&(r="/"+r),r[r.length-1]!=="/"&&(e[e.length-1]==="/"||t[t.length-1]==="."||t[t.length-1]==="..")&&(r=r+"/"),r}function Ile(e,t){try{return new URL(e).protocol===t}catch{return!1}}var Bt,Qh,yle,vle,ble,eg,Qu,KE=g(()=>{d();wt();Se();ie();$t();Bt={title:"Network dependency tree",description:"[Avoid chaining critical requests](https://developer.chrome.com/docs/performance/insights/network-dependency-tree) by reducing the length of chains, reducing the download size of resources, or \
deferring the download of unnecessary resources to improve page load.",warningDescription:"Avoid chaining critical requests by reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load.",noNetworkDependencyTree:"No rendering tasks impacted by network dependencies",maxCriticalPathLatency:"Max critical path latency:",columnRequest:"Request",columnTime:"Time",preconnectOriginsTableTitle:"Preconnected origins",preconnectOriginsTableDescription:"[preconnect](https://developer.chrome.com/docs/lighthouse/performance/uses-rel-preconnect/) hints help the browser establish a connection earlier in the page load, saving time when the first request for that origin is made. The following are the origins that the page preconnected to.",noPreconnectOrigins:"no origins were preconnected",tooManyPreconnectLinksWarning:"More than 4 `preconnect` connections were found. These should be used sparingly and only to the most \
important origins.",unusedWarning:"Unused preconnect. Only use `preconnect` for origins that the page is likely to request.",crossoriginWarning:"Unused preconnect. Check that the `crossorigin` attribute is used properly.",columnSource:"Source",noPreconnectCandidates:"No additional origins are good candidates for preconnecting",estSavingTableTitle:"Preconnect candidates",estSavingTableDescription:"Add [preconnect](https://developer.chrome.com/docs/lighthouse/performance/uses-rel-preconnect/) hints to your most important origins, but try to use no more than 4.",columnOrigin:"Origin",columnWastedMs:"Est LCP savings"},Qh=i((e,t)=>({i18nId:e,values:t}),"i18nString"),yle=new Set(["Image","XHR","Fetch","EventSource"]),vle=I.Milli(15e3),ble=I.Milli(50),eg=4;i(j5,"finalize");i(H5,"isCritical");i(VE,"findMaxLeafNode");i(q5,"sortRecursively");i(wle,"generateNetworkDependencyTree");i(mc,"getSecurityOrigin");i(Ele,"handleLinkResponseHeaderPart");i(z5,"handleLinkResponseHeader");i(G5,"generatePrecon\
nectedOrigins");i(Tle,"hasValidTiming");i(xle,"hasAlreadyConnectedToOrigin");i(Sle,"socketStartTimeIsBelowThreshold");i(Cle,"candidateRequestsByOrigin");i(W5,"generatePreconnectCandidates");i(kle,"isNetworkDependencyTreeInsight");i(Rle,"generateInsight");i(_le,"createOverlays");i($E,"normalizePath");i(Ile,"schemeIs");Qu=class e{static{i(this,"ParsedURL")}isValid;url;scheme;user;host;port;path;queryParams;fragment;folderPathComponents;lastPathComponent;blobInnerScheme;constructor(t){this.isValid=!1,this.url=t,this.scheme="",this.user="",this.host="",this.port="",this.path="",this.queryParams="",this.fragment="",this.folderPathComponents="",this.lastPathComponent="";let n=this.url.startsWith("blob:"),a=(n?t.substring(5):t).match(e.urlRegex());if(a)this.isValid=!0,n?(this.blobInnerScheme=a[2].toLowerCase(),this.scheme="blob"):this.scheme=a[2].toLowerCase(),this.user=a[3]??"",this.host=a[4]??"",this.port=a[5]??"",this.path=a[6]??"/",this.queryParams=a[7]??"",this.fragment=a[8]??"";else{if(this.
url.startsWith("data:")){this.scheme="data";return}if(this.url.startsWith("blob:")){this.scheme="blob";return}if(this.url==="about:blank"){this.scheme="about";return}this.path=this.url}let o=this.path.lastIndexOf("/",this.path.length-2);o!==-1?this.lastPathComponent=this.path.substring(o+1):this.lastPathComponent=this.path;let s=this.path.lastIndexOf("/");s!==-1&&(this.folderPathComponents=this.path.substring(0,s))}static fromString(t){let n=new e(t.toString());return n.isValid?n:null}static preEncodeSpecialCharactersInPath(t){for(let n of["%",";","#","?"," "])t=t.replaceAll(n,encodeURIComponent(n));return t}static rawPathToEncodedPathString(t){let n=e.preEncodeSpecialCharactersInPath(t);return t.startsWith("/")?new URL(n,"file:///").pathname:new URL("/"+n,"file:///").pathname.substr(1)}static encodedFromParentPathAndName(t,n){return e.concatenate(t,"/",e.preEncodeSpecialCharactersInPath(n))}static urlFromParentUrlAndName(t,n){return e.concatenate(t,"/",e.preEncodeSpecialCharactersInPath(
n))}static encodedPathToRawPathString(t){return decodeURIComponent(t)}static rawPathToUrlString(t){let n=e.preEncodeSpecialCharactersInPath(t.replace(/\\/g,"/"));return n=n.replace(/\\/g,"/"),n.startsWith("file://")||(n.startsWith("/")?n="file://"+n:n="file:///"+n),new URL(n).toString()}static relativePathToUrlString(t,n){let r=e.preEncodeSpecialCharactersInPath(t.replace(/\\/g,"/"));return new URL(r,n).toString()}static urlToRawPathString(t,n){console.assert(t.startsWith("file://"),"This must be a file URL.");let r=decodeURIComponent(t);return n?r.substr(8).replace(/\//g,"\\"):r.substr(7)}static sliceUrlToEncodedPathString(t,n){return t.substring(n)}static substr(t,n,r){return t.substr(n,r)}static substring(t,n,r){return t.substring(n,r)}static prepend(t,n){return t+n}static concatenate(t,...n){return t.concat(...n)}static trim(t){return t.trim()}static slice(t,n,r){return t.slice(n,r)}static join(t,n){return t.join(n)}static split(t,n,r){return t.split(n,r)}static toLowerCase(t){return t.
toLowerCase()}static isValidUrlString(t){return new e(t).isValid}static urlWithoutHash(t){let n=t.indexOf("#");return n!==-1?t.substr(0,n):t}static urlRegex(){if(e.urlRegexInstance)return e.urlRegexInstance;let t=/([A-Za-z][A-Za-z0-9+.-]*):\/\//,n=/(?:([A-Za-z0-9\-._~%!$&'()*+,;=:]*)@)?/,r=/((?:\[::\d?\])|(?:[^\s\/:]*))/,a=/(?::([\d]+))?/,o=/(\/[^#?]*)?/,s=/(?:\?([^#]*))?/,c=/(?:#(.*))?/;return e.urlRegexInstance=new RegExp("^("+t.source+n.source+r.source+a.source+")"+o.source+s.source+c.source+"$"),e.urlRegexInstance}static extractPath(t){let n=this.fromString(t);return n?n.path:""}static extractOrigin(t){let n=this.fromString(t);return n?n.securityOrigin():""}static extractExtension(t){t=e.urlWithoutHash(t);let n=t.indexOf("?");n!==-1&&(t=t.substr(0,n));let r=t.lastIndexOf("/");r!==-1&&(t=t.substr(r+1));let a=t.lastIndexOf(".");if(a!==-1){t=t.substr(a+1);let o=t.indexOf("%");return o!==-1?t.substr(0,o):t}return""}static extractName(t){let n=t.lastIndexOf("/"),r=n!==-1?t.substr(n+1):t;
return n=r.indexOf("?"),n<0?r:r.substr(0,n)}static completeURL(t,n){if(n.startsWith("data:")||n.startsWith("blob:")||n.startsWith("javascript:")||n.startsWith("mailto:"))return n;let r=n.trim(),a=this.fromString(r);if(a?.scheme){let f=a.securityOrigin(),h=$E(a.path),y=a.queryParams&&`?${a.queryParams}`,b=a.fragment&&`#${a.fragment}`;return f+h+y+b}let o=this.fromString(t);if(!o)return null;if(o.isDataURL())return n;if(n.length>1&&n.charAt(0)==="/"&&n.charAt(1)==="/")return o.scheme+":"+n;let s=o.securityOrigin(),c=o.path,l=o.queryParams?"?"+o.queryParams:"";if(!n.length)return s+c+l;if(n.charAt(0)==="#")return s+c+l+n;if(n.charAt(0)==="?")return s+c+n;let u=n.match(/^[^#?]*/);if(!u||!n.length)throw new Error("Invalid href");let m=u[0],p=n.substring(m.length);return m.charAt(0)!=="/"&&(m=o.folderPathComponents+"/"+m),s+$E(m)+p}static splitLineAndColumn(t){let n=t.match(e.urlRegex()),r="",a=t;n&&(r=n[1],a=t.substring(n[1].length));let s=/(?::(\d+))?(?::(\d+))?$/.exec(a),c,l;if(console.assert(
!!s),!s)return{url:t,lineNumber:0,columnNumber:0};typeof s[1]=="string"&&(c=parseInt(s[1],10),c=isNaN(c)?void 0:c-1),typeof s[2]=="string"&&(l=parseInt(s[2],10),l=isNaN(l)?void 0:l-1);let u=r+a.substring(0,a.length-s[0].length);if(s[1]===void 0&&s[2]===void 0){let p=/wasm-function\[\d+\]:0x([a-z0-9]+)$/g.exec(a);p&&typeof p[1]=="string"&&(u=e.removeWasmFunctionInfoFromURL(u),l=parseInt(p[1],16),l=isNaN(l)?void 0:l)}return{url:u,lineNumber:c,columnNumber:l}}static removeWasmFunctionInfoFromURL(t){let n=/:wasm-function\[\d+\]/,r=t.search(n);return r===-1?t:e.substring(t,0,r)}static beginsWithWindowsDriveLetter(t){return/^[A-Za-z]:/.test(t)}static beginsWithScheme(t){return/^[A-Za-z][A-Za-z0-9+.-]*:/.test(t)}static isRelativeURL(t){return!this.beginsWithScheme(t)||this.beginsWithWindowsDriveLetter(t)}isAboutBlank(){return this.url==="about:blank"}isDataURL(){return this.scheme==="data"}extractDataUrlMimeType(){let t=/^data:((?<type>\w+)\/(?<subtype>\w+))?(;base64)?,/,n=this.url.match(t);return{
type:n?.groups?.type,subtype:n?.groups?.subtype}}isBlobURL(){return this.url.startsWith("blob:")}lastPathComponentWithFragment(){return this.lastPathComponent+(this.fragment?"#"+this.fragment:"")}domain(){return this.isDataURL()?"data:":this.host+(this.port?":"+this.port:"")}securityOrigin(){return this.isDataURL()?"data:":(this.isBlobURL()?this.blobInnerScheme:this.scheme)+"://"+this.domain()}urlWithoutScheme(){return this.scheme&&this.url.startsWith(this.scheme+"://")?this.url.substring(this.scheme.length+3):this.url}static urlRegexInstance=null}});var ZE={};x(ZE,{UIStrings:()=>qa,createOverlayForRequest:()=>V5,createOverlays:()=>Fle,generateInsight:()=>Lle,i18nString:()=>JE,isRenderBlockingInsight:()=>Dle});function Dle(e){return e.insightKey==="RenderBlocking"}function Nle(e){let t=new Map;for(let[n,r]of e)n.type==="network"&&t.set(n.request.requestId,{node:n,nodeTiming:r});return t}function Mle(e,t){let n=t.simulator,r=t.metrics.firstContentfulPaint.optimisticGraph,{nodeTimings:a}=t.simulator.simulate(r),o=new Map(a),s=0,c=r.cloneWithRelationships(f=>!e.has(f.id));if(c.type!=="network")throw new Error("minimalFCPGraph not a NetworkNode");let l=Math.max(...Array.from(Array.from(o).map(f=>f[1].endTime))),u=c.request.transferSize,m=u||0;c.request.transferSize=m+s;let p=n.simulate(c).timeInMs;return c.request.transferSize=u,Math.round(Math.max(l-p,0))}function Ole(e,t){return e.LargestImagePaint.lcpRequestByNavigationId.has(t.navigationId)}function Ple(e,t,n){if(!t.lantern)return;let r=Nle(t.lantern.metrics.firstContentfulPaint.optimisticEstimate.
nodeTimings),a={FCP:0,LCP:0},o=new Map,s=new Set;for(let c of n){let l=r.get(c.args.data.requestId);if(!l)continue;let{node:u,nodeTiming:m}=l;u.traverse(f=>s.add(f.id));let p=Math.round(m.duration);p<Ale||o.set(u.id,p)}return o.size&&(a.FCP=Mle(s,t.lantern),Ole(e,t)||(a.LCP=a.FCP)),{metricSavings:a,requestIdToWastedMs:o}}function XE(e){return{insightKey:ce.RENDER_BLOCKING,strings:qa,title:JE(qa.title),description:JE(qa.description),docs:"https://developer.chrome.com/docs/performance/insights/render-blocking",category:qe.LCP,state:e.renderBlockingRequests.length>0?"fail":"pass",...e}}function Lle(e,t){if(!t.navigation)return XE({renderBlockingRequests:[]});let n=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId)?.get(t.navigationId)?.get(dt.PageLoadMetrics.MetricName.FP)?.event?.ts;if(!n)return XE({renderBlockingRequests:[],warnings:[Bn.NO_FP]});let r=[];for(let o of e.NetworkRequests.byTime){if(o.args.data.frame!==t.frameId||!In.isSyntheticNetworkRequestEventRenderBlocking(o)||o.args.
data.syntheticData.finishTime>n)continue;if(o.args.data.renderBlocking==="in_body_parser_blocking"){let c=o.args.data.priority,u=o.args.data.resourceType==="Script"&&c==="High";if(c!=="VeryHigh"&&!u)continue}re.getNavigationForTraceEvent(o,t.frameId,e.Meta.navigationsByFrameId)===t.navigation&&r.push(o)}let a=Ple(e,t,r);return r=r.sort((o,s)=>s.dur-o.dur),XE({relatedEvents:r,renderBlockingRequests:r,...a})}function V5(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function Fle(e){return e.renderBlockingRequests.map(t=>V5(t))}var qa,JE,Ale,QE=g(()=>{d();tn();Se();$t();qa={title:"Render blocking requests",description:"Requests are blocking the page's initial render, which may delay LCP. [Deferring or inlining](https://developer.chrome.com/docs/performance/insights/render-blocking) can move these network requests out of the critical path.",renderBlockingRequest:"Request",duration:"Duration",noRenderBlocking:"No render blocking requests for this navigation"},JE=i((e,t)=>({i18nId:e,
values:t}),"i18nString");i(Dle,"isRenderBlockingInsight");Ale=50;i(Nle,"getNodesAndTimingByRequestId");i(Mle,"estimateSavingsWithGraphs");i(Ole,"hasImageLCP");i(Ple,"computeSavings");i(XE,"finalize");i(Lle,"generateInsight");i(V5,"createOverlayForRequest");i(Fle,"createOverlays")});var tT={};x(tT,{UIStrings:()=>za,createOverlays:()=>zle,generateInsight:()=>qle,i18nString:()=>eT,isSlowCSSSelectorInsight:()=>Hle});function Ble(e,t){let n=new Map;for(let[r,a]of e.dataForRecalcStyleEvent)if(r.args.beginData?.frame===t.frameId&&j.eventIsInBounds(r,t.bounds))for(let o of a.timings){let s=o[zt.Selector]+"_"+o[zt.StyleSheetId],c=n.get(s);c!==void 0?(c[zt.Elapsed]+=o[zt.Elapsed],c[zt.FastRejectCount]+=o[zt.FastRejectCount],c[zt.MatchAttempts]+=o[zt.MatchAttempts],c[zt.MatchCount]+=o[zt.MatchCount]):n.set(s,{...o})}return[...n.values()]}function jle(e){return{insightKey:ce.SLOW_CSS_SELECTOR,strings:za,title:eT(za.title),description:eT(za.description),docs:"https://developer.chrome.com/docs/performance/insights/slow-css-selector",category:qe.ALL,state:e.topSelectorElapsedMs&&e.topSelectorMatchAttempts?"informative":"pass",...e}}function Hle(e){return e.insightKey===ce.SLOW_CSS_SELECTOR}function qle(e,t){let n=e.SelectorStats;if(!n)throw new Error("no selector stats data");let r=Ble(
n,t),a=0,o=0,s=0;r.map(u=>{a+=u[zt.Elapsed],o+=u[zt.MatchAttempts],s+=u[zt.MatchCount]});let c=null,l=null;return r.length>0&&(c=r.reduce((u,m)=>u[zt.Elapsed]>m[zt.Elapsed]?u:m),c&&c[zt.Elapsed]<Ule&&(c=null),l=r.reduce((u,m)=>u[zt.MatchAttempts]>m[zt.MatchAttempts]?u:m)),jle({relatedEvents:[],totalElapsedMs:I.Milli(a/1e3),totalMatchAttempts:o,totalMatchCount:s,topSelectorElapsedMs:c,topSelectorMatchAttempts:l})}function zle(e){return[]}var za,eT,Ule,nT=g(()=>{d();Se();kf();ie();$t();za={title:"CSS Selector costs",description:"If Recalculate Style costs remain high, selector optimization can reduce them. [Optimize the selectors](https://developer.chrome.com/docs/performance/insights/slow-css-selector) with both high elapsed time and high slow-path %. Simpler selectors, fewer selectors, a smaller DOM, and a shallower DOM will all reduce matching costs.",matchAttempts:"Match attempts",matchCount:"Match count",elapsed:"Elapsed time",topSelectors:"Top selectors",total:"Total",enableSelectorData:"\
No CSS selector data was found. CSS selector stats need to be enabled in the performance panel settings.",topSelectorElapsedTime:"Top selector elapsed time",topSelectorMatchAttempt:"Top selector match attempt"},eT=i((e,t)=>({i18nId:e,values:t}),"i18nString"),Ule=500;i(Ble,"aggregateSelectorStats");i(jle,"finalize");i(Hle,"isSlowCSSSelectorInsight");i(qle,"generateInsight");i(zle,"createOverlays")});var aT={};x(aT,{UIStrings:()=>xr,createOverlays:()=>Yle,createOverlaysForSummary:()=>$5,generateInsight:()=>$le,i18nString:()=>rT,isThirdPartyInsight:()=>Vle});function Gle(e,t){let n=[];for(let r of e)r.entity!==t&&n.push(...r.relatedEvents);return n}function Wle(e){return{insightKey:ce.THIRD_PARTIES,strings:xr,title:rT(xr.title),description:rT(xr.description),docs:"https://developer.chrome.com/docs/performance/insights/third-parties",category:qe.ALL,state:e.entitySummaries.find(t=>t.entity!==e.firstPartyEntity)?"informative":"pass",...e}}function Vle(e){return e.insightKey===ce.THIRD_PARTIES}function $le(e,t){let n=jh.summarizeByThirdParty(e,t.bounds),r=t.navigation?.args.data?.documentLoaderURL??e.Meta.mainFrameURL,a=Js.default.getEntity(r)||vr.makeUpEntity(e.Renderer.entityMappings.createdEntityCache,r);return Wle({relatedEvents:Gle(n,a),firstPartyEntity:a,entitySummaries:n})}function $5(e){let t=[];for(let n of e.relatedEvents){if(n.dur===void 0||n.dur<1e3)continue;let r={type:"EN\
TRY_OUTLINE",entry:n,outlineReason:"INFO"};t.push(r)}return t}function Yle(e){let t=[],n=e.entitySummaries??[];for(let r of n){if(r.entity===e.firstPartyEntity)continue;let a=$5(r);t.push(...a)}return t}var xr,rT,oT=g(()=>{d();Jv();Vu();tn();$t();xr={title:"3rd parties",description:"3rd party code can significantly impact load performance. [Reduce and defer loading of 3rd party code](https://developer.chrome.com/docs/performance/insights/third-parties) to prioritize your page's content.",columnThirdParty:"3rd party",columnTransferSize:"Transfer size",columnMainThreadTime:"Main thread time",noThirdParties:"No third parties found"},rT=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Gle,"getRelatedEvents");i(Wle,"finalize");i(Vle,"isThirdPartyInsight");i($le,"generateInsight");i($5,"createOverlaysForSummary");i(Yle,"createOverlays")});var sT={};x(sT,{UIStrings:()=>ma,createOverlays:()=>Jle,generateInsight:()=>Xle,i18nString:()=>tg,isViewportInsight:()=>Kle});function iT(e){return{insightKey:ce.VIEWPORT,strings:ma,title:tg(ma.title),description:tg(ma.description),docs:"https://developer.chrome.com/docs/performance/insights/viewport",category:qe.INP,state:e.mobileOptimized===!1?"fail":"pass",...e}}function Kle(e){return e.insightKey===ce.VIEWPORT}function Xle(e,t){let n=e.UserInteractions.parseMetaViewportEvents.find(a=>a.args.data.frame!==t.frameId?!1:j.eventIsInBounds(a,t.bounds)),r=e.UserInteractions.beginCommitCompositorFrameEvents.filter(a=>a.args.frame!==t.frameId||n&&a.ts<n.ts?!1:j.eventIsInBounds(a,t.bounds));if(!r.length)return iT({mobileOptimized:null,warnings:[Bn.NO_LAYOUT]});for(let a of r)if(!a.args.is_mobile_optimized){let o=[...e.UserInteractions.interactionsOverThreshold.values()].filter(l=>dt.UserInteractions.categoryOfInteraction(l)==="POINTER"&&l.inputDelay>=5e4),s=Math.max(0,...o.map(l=>l.inputDelay))/
1e3,c=ia.clamp(s,0,300);return iT({mobileOptimized:!1,viewportEvent:n,longPointerInteractions:o,metricSavings:{INP:c}})}return iT({mobileOptimized:!0,viewportEvent:n})}function Jle(e){return e.longPointerInteractions?e.longPointerInteractions.map(t=>{let n=Math.min(t.inputDelay,3e5),r=j.traceWindowFromMicroSeconds(I.Micro(t.ts),I.Micro(t.ts+n));return{type:"TIMESPAN_BREAKDOWN",entry:t,sections:[{bounds:r,label:tg(ma.mobileTapDelayLabel),showDuration:!0}],renderLocation:"ABOVE_EVENT"}}):[]}var ma,tg,cT=g(()=>{d();wt();tn();Se();ie();$t();ma={title:"Optimize viewport for mobile",description:"Tap interactions may be [delayed by up to 300 ms](https://developer.chrome.com/docs/performance/insights/viewport) if the viewport is not optimized for mobile.",mobileTapDelayLabel:"Mobile tap delay"},tg=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(iT,"finalize");i(Kle,"isViewportInsight");i(Xle,"generateInsight");i(Jle,"createOverlays")});var ed={};x(ed,{CLSCulprits:()=>gE,Cache:()=>Ku,DOMSize:()=>EE,DocumentLatency:()=>bE,DuplicatedJavaScript:()=>SE,FontDisplay:()=>RE,ForcedReflow:()=>AE,INPBreakdown:()=>OE,ImageDelivery:()=>Yh,LCPBreakdown:()=>LE,LCPDiscovery:()=>UE,LegacyJavaScript:()=>zE,ModernHTTP:()=>Zu,NetworkDependencyTree:()=>YE,RenderBlocking:()=>ZE,SlowCSSSelector:()=>tT,ThirdParties:()=>aT,Viewport:()=>sT});var Y5=g(()=>{d();Wh();yE();wE();TE();CE();_E();NE();Kh();PE();FE();BE();GE();Zh();KE();QE();nT();oT();cT()});var td={};x(td,{Cache:()=>Ku,Common:()=>Xn,Models:()=>ed,ModernHTTP:()=>Zu,Statistics:()=>pE,Types:()=>fE});var lT=g(()=>{d();Wh();ca();Y5();Zh();qh();$t()});var Ga={};x(Ga,{createGraph:()=>mT,createNetworkRequests:()=>dT,createProcessedNavigation:()=>uT});function uT(e,t,n){let r=e.PageLoadMetrics.metricScoresByFrameId.get(t);if(!r)throw new ct.LanternError("missing metric scores for frame");let a=r.get(n);if(!a)throw new ct.LanternError("missing metric scores for specified navigation");let o=i(c=>{let l=a.get(c);if(l?.event)return l.event.ts},"getTimestampOrUndefined");return{timestamps:{firstContentfulPaint:i(c=>{let l=a.get(c);if(!l?.event)throw new ct.LanternError(`missing metric: ${c}`);return l.event.ts},"getTimestamp")(dt.PageLoadMetrics.MetricName.FCP),largestContentfulPaint:o(dt.PageLoadMetrics.MetricName.LCP)}}}function K5(e){return typeof e=="string"&&(e=new URL(e)),{scheme:e.protocol.split(":")[0],host:e.hostname,securityOrigin:e.origin}}function Zle(e){let t=new Map,n=["ServiceWorker thread","DedicatedWorker thread"];for(let r of e.traceEvents){if(r.name!=="thread_name"||!r.args.name||!n.includes(r.args.name))continue;let a=t.
get(r.pid);a?a.push(r.tid):t.set(r.pid,[r.tid])}return t}function Qle(e,t,n){if(n.args.data.hasResponse&&n.args.data.connectionId===void 0)throw new ct.LanternError("Trace is too old");let r;try{r=new URL(n.args.data.url)}catch{return}let a=n.args.data.timing?{workerFetchStart:-1,workerRespondWithSettled:-1,receiveHeadersStart:-1,...n.args.data.timing}:void 0,o=a?a.requestTime*1e3:n.args.data.syntheticData.downloadStart/1e3,s=!1;t.get(n.pid)?.includes(n.tid)&&(s=!0),e.Workers.workerIdByThread.has(n.tid)&&(s=!0);let l=n.args.data.initiator??{type:"other"};if(n.args.data.stackTrace){let p=n.args.data.stackTrace.map(f=>({scriptId:String(f.scriptId),url:f.url,lineNumber:f.lineNumber-1,columnNumber:f.columnNumber-1,functionName:f.functionName}));l.stack={callFrames:p}}let u=n.args.data.resourceType;n.args.data.initiator?.fetchType==="xmlhttprequest"?u="XHR":n.args.data.initiator?.fetchType==="fetch"&&(u="Fetch");let m=n.args.data.decodedBodyLength??0;if(r.protocol==="data:"&&m===0){let p=r.
pathname.indexOf(",");r.pathname.substring(0,p).includes(";base64")?m=atob(r.pathname.substring(p+1)).length:m=r.pathname.length-p-1}return{rawRequest:n,requestId:n.args.data.requestId,connectionId:n.args.data.connectionId??0,connectionReused:n.args.data.connectionReused??!1,url:n.args.data.url,protocol:n.args.data.protocol,parsedURL:K5(r),documentURL:n.args.data.requestingFrameUrl,rendererStartTime:n.ts/1e3,networkRequestTime:o,responseHeadersEndTime:n.args.data.syntheticData.downloadStart/1e3,networkEndTime:n.args.data.syntheticData.finishTime/1e3,transferSize:n.args.data.encodedDataLength,resourceSize:m,fromDiskCache:n.args.data.syntheticData.isDiskCached,fromMemoryCache:n.args.data.syntheticData.isMemoryCached,isLinkPreload:n.args.data.isLinkPreload,finished:n.args.data.finished,failed:n.args.data.failed,statusCode:n.args.data.statusCode,initiator:l,timing:a,resourceType:u,mimeType:n.args.data.mimeType,priority:n.args.data.priority,frameId:n.args.data.frame,fromWorker:s,serverResponseTime:n.
args.data.lrServerResponseTime??void 0,redirects:void 0,redirectSource:void 0,redirectDestination:void 0,initiatorRequest:void 0}}function eue(e,t){if(e.redirectSource)return e.redirectSource;let n=gn.PageDependencyGraph.getNetworkInitiators(e)[0],r=t.get(n)||[];if(r=r.filter(a=>a.responseHeadersEndTime<=e.rendererStartTime&&a.finished&&!a.failed),r.length>1){let a=r.filter(o=>o.resourceType!==iu.NetworkRequestTypes.Other);a.length&&(r=a)}if(r.length>1){let a=r.filter(o=>o.frameId===e.frameId);a.length&&(r=a)}if(r.length>1&&e.initiator.type==="parser"){let a=r.filter(o=>o.resourceType===iu.NetworkRequestTypes.Document);a.length&&(r=a)}if(r.length>1){let a=r.filter(o=>o.isLinkPreload);if(a.length){let o=r.filter(c=>!c.isLinkPreload),s=o.every(c=>c.fromDiskCache||c.fromMemoryCache);o.length&&s&&(r=a)}}return r.length===1?r[0]:null}function tue(e){let t=new Map;for(let n of e){let r=t.get(n.url)||[];r.push(n),t.set(n.url,r)}for(let n of e){let r=eue(n,t);r&&(n.initiatorRequest=r)}}function dT(e,t,n=0,r=Number.
POSITIVE_INFINITY){let a=Zle(e),o=[];for(let c of t.NetworkRequests.byTime)if(c.ts>=n&&c.ts<r){let l=Qle(t,a,c);l&&o.push(l)}let s=[];for(let c of[...o]){if(!c.rawRequest)continue;let l=c.rawRequest.args.data.redirects;if(!l.length){s.push(c);continue}let u=[];for(let m of l){let p=structuredClone(c);p.networkRequestTime=m.ts/1e3,p.rendererStartTime=p.networkRequestTime,p.networkEndTime=(m.ts+m.dur)/1e3,p.responseHeadersEndTime=p.networkEndTime,p.timing={requestTime:p.networkRequestTime/1e3,receiveHeadersStart:p.responseHeadersEndTime,receiveHeadersEnd:p.responseHeadersEndTime,proxyStart:-1,proxyEnd:-1,dnsStart:-1,dnsEnd:-1,connectStart:-1,connectEnd:-1,sslStart:-1,sslEnd:-1,sendStart:-1,sendEnd:-1,workerStart:-1,workerReady:-1,workerFetchStart:-1,workerRespondWithSettled:-1,pushStart:-1,pushEnd:-1},p.url=m.url,p.parsedURL=K5(m.url),p.statusCode=302,p.resourceType=void 0,p.transferSize=400,u.push(p),s.push(p)}u.push(c),s.push(c);for(let m=0;m<u.length;m++){let p=u[m];m>0&&(p.redirectSource=
u[m-1],p.redirects=u.slice(0,m)),m!==u.length-1&&(p.redirectDestination=u[m+1])}for(let m=1;m<u.length;m++)u[m].requestId=`${u[m-1].requestId}:redirect`}return tue(s),s}function nue(e,t){let n=t.Meta,r=n.mainFrameNavigations.length?new Set(n.mainFrameNavigations.map(o=>o.pid)):n.topLevelRendererIds,a=new Map;for(let o of r){let s=n.threadsInProcess.get(o)??[],c=!1;for(let[l,u]of s)if(u.args.name==="CrRendererMain"){a.set(o,l),c=!0;break}if(!c){for(let[l,u]of s)if(u.args.name==="CrBrowserMain"){a.set(o,l),c=!0;break}}}return e.traceEvents.filter(o=>a.get(o.pid)===o.tid)}function mT(e,t,n,r){let a=nue(t,n);if(!r){r={requestedUrl:e[0].url,mainDocumentUrl:""};let o=e[0];for(;o.redirectDestination;)o=o.redirectDestination;r.mainDocumentUrl=o.url}return gn.PageDependencyGraph.createGraph(a,e,r)}var pT=g(()=>{d();tn();su();i(uT,"createProcessedNavigation");i(K5,"createParsedUrl");i(Zle,"findWorkerThreads");i(Qle,"createLanternRequest");i(eue,"chooseInitiatorRequest");i(tue,"linkInitiators");i(
dT,"createNetworkRequests");i(nue,"collectMainThreadEvents");i(mT,"createGraph")});var ng={};x(ng,{TraceParseProgressEvent:()=>Qi,TraceProcessor:()=>nd,sortHandlers:()=>J5});function X5(e,t){return t===.8?e*(.8-.2)+.2:e*t}function J5(e){let t=new Map,n=new Set,r=i(a=>{if(t.has(a))return;if(n.has(a)){let c="";for(let l of n)(c||l===a)&&(c+=`${l}->`);throw c+=a,new Error(`Found dependency cycle in trace event handlers: ${c}`)}n.add(a);let o=e[a];if(!o)return;let s=o.deps?.();s&&s.forEach(r),t.set(a,o)},"visitHandler");for(let a of Object.keys(e))r(a);return t}var fT,Qi,nd,hT=g(()=>{d();tn();Se();lT();su();pT();ie();Qi=class e extends Event{static{i(this,"TraceParseProgressEvent")}data;static eventName="traceparseprogress";constructor(t,n={bubbles:!0}){super(e.eventName,n),this.data=t}};i(X5,"calculateProgress");nd=class extends EventTarget{static{i(this,"TraceProcessor")}#e;#t="IDLE";#o=oa.defaults();#n=null;#a=null;static createWithAllHandlers(){return new fT(dt,oa.defaults())}static getInsightRunners(){return{...ed}}constructor(t,n){super(),this.#r(t),this.#e={Meta:dt.
Meta,...t},n&&(this.#o=n),this.#c()}#c(){for(let t of Object.values(this.#e))"handleUserConfig"in t&&t.handleUserConfig&&t.handleUserConfig(this.#o)}#r(t){if(Object.keys(t).length===Object.keys(dt).length)return;let n=new Set;for(let[a,o]of Object.entries(t)){n.add(a);let s="deps"in o?o.deps():[];for(let c of s)n.add(c)}let r=new Set(Object.keys(t));n.delete("Meta");for(let a of n)if(!r.has(a))throw new Error(`Required handler ${a} not provided.`)}reset(){if(this.#t==="PARSING")throw new Error("Trace processor can't reset while parsing.");let t=Object.values(this.#e);for(let n of t)n.reset();this.#n=null,this.#a=null,this.#t="IDLE"}async parse(t,n){if(this.#t!=="IDLE")throw new Error(`Trace processor can't start parsing when not idle. Current state: ${this.#t}`);typeof n.isCPUProfile>"u"&&n.metadata&&(n.isCPUProfile=n.metadata.dataOrigin===ji.DataOrigin.CPU_PROFILE),n.logger?.start("total");try{this.#t="PARSING",n.logger?.start("parse"),await this.#i(t,n),n.logger?.end("parse"),this.#n&&
!n.isCPUProfile&&(n.logger?.start("insights"),this.#u(this.#n,t,n),n.logger?.end("insights")),this.#t="FINISHED_PARSING"}catch(r){throw this.#t="ERRORED_WHILE_PARSING",r}finally{n.logger?.end("total")}}async#i(t,n){let a=[...J5(this.#e).entries()];for(let[,c]of a)c.reset();n.logger?.start("parse:handleEvent");for(let c=0;c<t.length;++c){if(c%5e4===0&&c){let u=X5(c/t.length,.2);this.dispatchEvent(new Qi({percent:u})),await new Promise(m=>setTimeout(m,0))}let l=t[c];for(let u=0;u<a.length;++u){let[,m]=a[u];m.handleEvent(l)}}n.logger?.end("parse:handleEvent");let o={...n,allTraceEvents:t};for(let c=0;c<a.length;c++){let[l,u]=a[c];u.finalize&&(n.logger?.start(`parse:${l}:finalize`),await new Promise(p=>setTimeout(p,0)),await u.finalize(o),n.logger?.end(`parse:${l}:finalize`));let m=X5(c/a.length,.8);this.dispatchEvent(new Qi({percent:m}))}n.logger?.start("parse:handler.data()");let s={};for(let[c,l]of Object.entries(this.#e))Object.assign(s,{[c]:l.data()});n.logger?.end("parse:handler.data\
()"),this.dispatchEvent(new Qi({percent:1})),this.#n=s}get data(){return this.#t!=="FINISHED_PARSING"?null:this.#n}get insights(){return this.#t!=="FINISHED_PARSING"?null:this.#a}#l(t,n,r,a,o){if(!t.NetworkRequests||!t.Workers||!t.PageLoadMetrics)return;if(!t.NetworkRequests.byTime.length)throw new ct.LanternError("No network requests found in trace");let s=t.Meta.navigationsByFrameId.get(r),c=s?.findIndex(G=>G.args.data?.navigationId===a);if(!s||c===void 0||c===-1)throw new ct.LanternError("Could not find navigation start");let l=s[c].ts,u=c+1<s.length?s[c+1].ts:Number.POSITIVE_INFINITY,p={traceEvents:n.filter(G=>G.ts>=l&&G.ts<u)},f=dT(p,t,l,u),h=mT(f,p,t),y=uT(t,r,a),b=ct.NetworkAnalyzer.analyze(f);if(!b)return;let w={networkAnalysis:b,throttlingMethod:"provided",...o.lanternSettings},C=Pa.Simulator.createSimulator(w),k={graph:h,simulator:C,processedNavigation:y},R=Ft.FirstContentfulPaint.compute(k),S=Ft.LargestContentfulPaint.compute(k,{fcpResult:R}),_=Ft.Interactive.compute(k,{lcpResult:S}),
q=Ft.TotalBlockingTime.compute(k,{fcpResult:R,interactiveResult:_});return{requests:f,graph:h,simulator:C,metrics:{firstContentfulPaint:R,interactive:_,largestContentfulPaint:S,totalBlockingTime:q}}}sortInsightSet(t,n){let r={INPBreakdown:null,LCPBreakdown:null,LCPDiscovery:null,CLSCulprits:null,RenderBlocking:null,NetworkDependencyTree:null,ImageDelivery:null,DocumentLatency:null,FontDisplay:null,Viewport:null,DOMSize:null,ThirdParties:null,DuplicatedJavaScript:null,SlowCSSSelector:null,ForcedReflow:null,Cache:null,ModernHTTP:null,LegacyJavaScript:null},a=Xn.calculateMetricWeightsForSorting(t,n),o=Xn.getLCP(t)?.value,s=o?j.microToMilli(o):I.Milli(0),c=Xn.getCLS(t).value,l=Xn.getINP(t)?.value,u=l?j.microToMilli(l):I.Milli(200),m=s!==void 0?Xn.evaluateLCPMetricScore(s):void 0,p=Xn.evaluateINPMetricScore(u),f=Xn.evaluateCLSMetricScore(c),h=new Map;for(let[C,k]of Object.entries(t.model)){let R=k.metricSavings?.LCP??0,S=k.metricSavings?.INP??0,_=k.metricSavings?.CLS??0,q=s!==void 0?Math.max(
0,s-R):void 0,F=Math.max(0,u-S),G=Math.max(0,c-_),K=0;a.lcp&&R&&m!==void 0&&q!==void 0&&(K+=a.lcp*(Xn.evaluateLCPMetricScore(q)-m)),a.inp&&S&&p!==void 0&&(K+=a.inp*(Xn.evaluateINPMetricScore(F)-p)),a.cls&&_&&f!==void 0&&(K+=a.cls*(Xn.evaluateCLSMetricScore(G)-f)),h.set(C,K)}let y=Object.keys(r),b=Object.keys(t.model);b.sort((C,k)=>{let R=y.indexOf(C),S=y.indexOf(k);return R>=0&&S>=0?R-S:R>=0?-1:S>=0?1:0}),b.sort((C,k)=>(h.get(k)??0)-(h.get(C)??0));let w={};for(let C of b){let k=t.model[C];w[C]=k}t.model=w}#s(t,n){let r=n.options.logger,a,o,s;n.navigation?(a=n.navigationId,o=t.Meta.finalDisplayUrlByNavigationId.get(n.navigationId)??t.Meta.mainFrameURL,s=n.navigation):(a=v.NO_NAVIGATION,o=t.Meta.finalDisplayUrlByNavigationId.get("")??t.Meta.mainFrameURL);let c={};for(let[C,k]of Object.entries(fT.getInsightRunners())){let R;try{r?.start(`insights:${C}`),R=k.generateInsight(t,n),R.frameId=n.frameId;let S=n.navigation?.args.data?.navigationId;S&&(R.navigationId=S),R.createOverlays=()=>k.createOverlays(
R)}catch(S){R=S}finally{r?.end(`insights:${C}`)}Object.assign(c,{[C]:R})}let l=a===v.NO_NAVIGATION,u=j.milliToMicro(I.Milli(5e3)),m=Object.values(c).filter(C=>!(C instanceof Error)).every(C=>C.state==="pass"),p=!c.LCPBreakdown.lcpEvent,f=!c.INPBreakdown.longestInteractionEvent,h=c.CLSCulprits.shifts?.size===0;if(l&&n.bounds.range<u&&m&&p&&f&&h)return;let b;try{b=new URL(o)}catch{return}let w={id:a,url:b,navigation:s,frameId:n.frameId,bounds:n.bounds,model:c};this.#a||(this.#a=new Map),this.#a.set(w.id,w),this.sortInsightSet(w,n.options.metadata??null)}#u(t,n,r){this.#a=new Map;let a=t.Meta.mainFrameNavigations.filter(o=>o.args.frame&&o.args.data?.navigationId);this.#p(t,a,r);for(let[o,s]of a.entries()){let c=s.ts,l=o+1<a.length?a[o+1].ts:t.Meta.traceBounds.max,u=j.traceWindowFromMicroSeconds(c,l);this.#d(s,u,t,n,r)}}#p(t,n,r){let a=n.length>0?j.traceWindowFromMicroSeconds(t.Meta.traceBounds.min,n[0].ts):t.Meta.traceBounds,o={options:r,bounds:a,frameId:t.Meta.mainFrameId};this.#s(t,o)}#d(t,n,r,a,o){
let s=t.args.frame,c=t.args.data?.navigationId,l;try{o.logger?.start("insights:createLanternContext"),l=this.#l(r,a,s,c,o)}catch(m){let p=["mainDocumentRequest not found","missing metric scores for main frame","missing metric: FCP","missing metric: LCP","No network requests found in trace","Trace is too old"];m instanceof ct.LanternError&&p.some(f=>m.message===f)||console.error(m)}finally{o.logger?.end("insights:createLanternContext")}let u={options:o,bounds:n,frameId:s,navigation:t,navigationId:c,lantern:l};this.#s(r,u)}};fT=nd;i(J5,"sortHandlers")});var Z5=g(()=>{d();wt();tn();Se();hT();ie()});var Q5=g(()=>{d()});var e4,gT=g(()=>{d();tn();Se();ie();(function(e){e.DRAWING="drawing",e.RASTERIZING="rasterizing",e.LAYOUT="layout",e.LOADING="loading",e.EXPERIENCE="experience",e.SCRIPTING="scripting",e.MESSAGING="messaging",e.RENDERING="rendering",e.PAINTING="painting",e.GPU="gpu",e.ASYNC="async",e.OTHER="other",e.IDLE="idle"})(e4||(e4={}))});var t4=g(()=>{d();Q5();tn();gT();ie()});var yT=g(()=>{d();GF();WF();Vu();tn();Se();lT();su();pT();Z5();t4();hT();gT();ie()});var Jt=g(()=>{"use strict";d();su();yT();});var n4=g(()=>{"use strict";d();});var r4=g(()=>{"use strict";d();Ve();po();});var rg,a4=g(()=>{"use strict";d();Pl();rg=class e{static{i(this,"ArbitraryEqualityMap")}constructor(){this._equalsFn=e.deepEquals,this._entries=[]}setEqualityFn(t){this._equalsFn=t}has(t){return this._findIndexOf(t)!==-1}get(t){return this._entries[this._findIndexOf(t)]?.value}set(t,n){let r=this._findIndexOf(t);r===-1&&(r=this._entries.length),this._entries[r]={key:t,value:n}}_findIndexOf(t){for(let n=0;n<this._entries.length;n++)if(this._equalsFn(t,this._entries[n].key))return n;return-1}static deepEquals(t,n){return Jr(t,n)}}});function Y(e,t){return Object.assign(e,{request:i((r,a)=>{let o=e.name;for(let f of t||[])if(r&&typeof r=="object"&&r[f]===void 0){let h=new Error(`missing required key "${String(f)}" for computed artifact ${e.name}`);if(Ms)throw h;M.error(`lh:computed:${o}`,h)}let s=t?Object.fromEntries(t.map(f=>[f,r[f]])):r,c=a.computedCache,l=c.get(o)||new rg;c.set(o,l);let u=l.get(s);if(u)return u;let m={msg:`Computing artifact: ${o}`,id:`lh:computed:${o}`};M.time(m,"verbose");let p=e.compute_(s,a);return l.set(s,p),p.then(()=>M.timeEnd(m)).catch(()=>M.timeEnd(m)),p},"request")})}var Ae=g(()=>{"use strict";d();Ve();a4();jp();i(Y,"makeComputedArtifact")});function cue(e,t){return e.endsWith(t)?e.length===t.length||e[e.length-t.length-1]===".":!1}function lue(e,t){let n=e.length-t.length-2,r=e.lastIndexOf(".",n);return r===-1?e:e.slice(r+1)}function vT(e,t,n){if(n.validHosts!==null){let a=n.validHosts;for(let o of a)if(cue(t,o))return o}let r=0;if(t.startsWith("."))for(;r<t.length&&t[r]===".";)r+=1;return e.length===t.length-r?null:lue(t,e)}var o4=g(()=>{d();i(cue,"shareSameDomainSuffix");i(lue,"extractDomainWithSuffix");i(vT,"getDomain")});function bT(e,t){return e.slice(0,-t.length-1)}var i4=g(()=>{d();i(bT,"getDomainWithoutSuffix")});function ag(e,t){let n=0,r=e.length,a=!1;if(!t){if(e.startsWith("data:"))return null;for(;n<e.length&&e.charCodeAt(n)<=32;)n+=1;for(;r>n+1&&e.charCodeAt(r-1)<=32;)r-=1;if(e.charCodeAt(n)===47&&e.charCodeAt(n+1)===47)n+=2;else{let u=e.indexOf(":/",n);if(u!==-1){let m=u-n,p=e.charCodeAt(n),f=e.charCodeAt(n+1),h=e.charCodeAt(n+2),y=e.charCodeAt(n+3),b=e.charCodeAt(n+4);if(!(m===5&&p===104&&f===116&&h===116&&y===112&&b===115)){if(!(m===4&&p===104&&f===116&&h===116&&y===112)){if(!(m===3&&p===119&&f===115&&h===115)){if(!(m===2&&p===119&&f===115))for(let w=n;w<u;w+=1){let C=e.charCodeAt(w)|32;if(!(C>=97&&C<=122||C>=48&&C<=57||C===46||C===45||C===43))return null}}}}for(n=u+2;e.charCodeAt(n)===47;)n+=1}}let s=-1,c=-1,l=-1;for(let u=n;u<r;u+=1){let m=e.charCodeAt(u);if(m===35||m===47||m===63){r=u;break}else m===64?s=u:m===93?c=u:m===58?l=u:m>=65&&m<=90&&(a=!0)}if(s!==-1&&s>n&&s<r&&(n=s+1),e.charCodeAt(n)===91)return c!==-1?e.slice(n+1,c).toLowerCase():null;l!==-1&&l>n&&l<r&&(r=l)}for(;r>n+1&&e.charCodeAt(
r-1)===46;)r-=1;let o=n!==0||r!==e.length?e.slice(n,r):e;return a?o.toLowerCase():o}var s4=g(()=>{d();i(ag,"extractHostname")});function uue(e){if(e.length<7||e.length>15)return!1;let t=0;for(let n=0;n<e.length;n+=1){let r=e.charCodeAt(n);if(r===46)t+=1;else if(r<48||r>57)return!1}return t===3&&e.charCodeAt(0)!==46&&e.charCodeAt(e.length-1)!==46}function due(e){if(e.length<3)return!1;let t=e.startsWith("[")?1:0,n=e.length;if(e[n-1]==="]"&&(n-=1),n-t>39)return!1;let r=!1;for(;t<n;t+=1){let a=e.charCodeAt(t);if(a===58)r=!0;else if(!(a>=48&&a<=57||a>=97&&a<=102||a>=65&&a<=90))return!1}return r}function wT(e){return due(e)||uue(e)}var c4=g(()=>{d();i(uue,"isProbablyIpv4");i(due,"isProbablyIpv6");i(wT,"isIp")});function l4(e){return e>=97&&e<=122||e>=48&&e<=57||e>127}function og(e){if(e.length>255||e.length===0||!l4(e.charCodeAt(0))&&e.charCodeAt(0)!==46&&e.charCodeAt(0)!==95)return!1;let t=-1,n=-1,r=e.length;for(let a=0;a<r;a+=1){let o=e.charCodeAt(a);if(o===46){if(a-t>64||n===46||n===45||n===95)return!1;t=a}else if(!(l4(o)||o===45||o===95))return!1;n=o}return r-t-1<=63&&n!==45}var u4=g(()=>{d();i(l4,"isValidAscii");i(og,"default")});function d4({allowIcannDomains:e=!0,allowPrivateDomains:t=!1,detectIp:n=!0,extractHostname:r=!0,mixedInputs:a=!0,validHosts:o=null,validateHostname:s=!0}){return{allowIcannDomains:e,allowPrivateDomains:t,detectIp:n,extractHostname:r,mixedInputs:a,validHosts:o,validateHostname:s}}function ET(e){return e===void 0?mue:d4(e)}var mue,TT=g(()=>{d();i(d4,"setDefaultsImpl");mue=d4({});i(ET,"setDefaults")});function xT(e,t){return t.length===e.length?"":e.slice(0,-t.length-1)}var m4=g(()=>{d();i(xT,"getSubdomain")});function ST(){return{domain:null,domainWithoutSuffix:null,hostname:null,isIcann:null,isIp:null,isPrivate:null,publicSuffix:null,subdomain:null}}function CT(e){e.domain=null,e.domainWithoutSuffix=null,e.hostname=null,e.isIcann=null,e.isIp=null,e.isPrivate=null,e.publicSuffix=null,e.subdomain=null}function kT(e,t,n,r,a){let o=ET(r);return typeof e!="string"||(o.extractHostname?o.mixedInputs?a.hostname=ag(e,og(e)):a.hostname=ag(e,!1):a.hostname=e,o.detectIp&&a.hostname!==null&&(a.isIp=wT(a.hostname),a.isIp))?a:o.validateHostname&&o.extractHostname&&a.hostname!==null&&!og(a.hostname)?(a.hostname=null,a):(t===0||a.hostname===null||(n(a.hostname,o,a),t===2||a.publicSuffix===null)||(a.domain=vT(a.publicSuffix,a.hostname,o),t===3||a.domain===null)||(a.subdomain=xT(a.hostname,a.domain),t===4)||(a.domainWithoutSuffix=bT(a.domain,a.publicSuffix)),a)}var p4=g(()=>{d();o4();i4();s4();c4();u4();TT();m4();i(ST,"getEmptyResult");i(CT,"resetResult");i(kT,"parseImpl")});function ig(e,t,n){if(!t.allowPrivateDomains&&e.length>3){let r=e.length-1,a=e.charCodeAt(r),o=e.charCodeAt(r-1),s=e.charCodeAt(r-2),c=e.charCodeAt(r-3);if(a===109&&o===111&&s===99&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="com",!0;if(a===103&&o===114&&s===111&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="org",!0;if(a===117&&o===100&&s===101&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="edu",!0;if(a===118&&o===111&&s===103&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="gov",!0;if(a===116&&o===101&&s===110&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="net",!0;if(a===101&&o===100&&s===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="de",!0}return!1}var f4=g(()=>{d();i(ig,"default")});var RT=g(()=>{d();p4();f4();TT()});var h4,g4,y4=g(()=>{d();h4=(function(){let e=[1,{}],t=[0,{city:e}];return[0,{ck:[0,{www:e}],jp:[0,{kawasaki:t,kitakyushu:t,kobe:t,nagoya:t,sapporo:t,sendai:t,yokohama:t}]}]})(),g4=(function(){let e=[1,{}],t=[1,{com:e,edu:e,gov:e,mil:e,net:e,org:e}],n=[1,{com:e,edu:e,gov:e,net:e,org:e}],r=[1,{gov:e}],a=[0,{"*":e}],o=[1,{co:e,com:e,edu:e,gov:e,net:e,org:e}],s=[1,{com:e,edu:e,net:e,org:e}],c=[1,{co:e,net:e,org:e}],l=[1,{co:e,com:e,edu:e,gov:e,mil:e,net:e,nom:e,org:e}],u=[1,{biz:e,com:e,edu:e,gov:e,info:e,net:e,org:e}],m=[1,{gs:e}],p=[0,{nes:e}],f=[1,{k12:e,cc:e,lib:e}],h=[1,{cc:e}],y=[1,{cc:e,lib:e}];return[0,{ac:t,ad:e,ae:[1,{ac:e,co:e,gov:e,mil:e,net:e,org:e,sch:e}],aero:[1,{airline:e,airport:e,"accident-investigation":e,"accident-prevention":e,aerobatic:e,aeroclub:e,aerodrome:e,agents:e,"air-surveillance":e,"air-traffic-control":e,aircraft:e,airtraffic:e,ambulance:e,association:e,author:e,ballooning:e,broker:e,caa:e,cargo:e,catering:e,certification:e,championship:e,charter:e,civilaviation:e,
club:e,conference:e,consultant:e,consulting:e,control:e,council:e,crew:e,design:e,dgca:e,educator:e,emergency:e,engine:e,engineer:e,entertainment:e,equipment:e,exchange:e,express:e,federation:e,flight:e,freight:e,fuel:e,gliding:e,government:e,groundhandling:e,group:e,hanggliding:e,homebuilt:e,insurance:e,journal:e,journalist:e,leasing:e,logistics:e,magazine:e,maintenance:e,marketplace:e,media:e,microlight:e,modelling:e,navigation:e,parachuting:e,paragliding:e,"passenger-association":e,pilot:e,press:e,production:e,recreation:e,repbody:e,res:e,research:e,rotorcraft:e,safety:e,scientist:e,services:e,show:e,skydiving:e,software:e,student:e,taxi:e,trader:e,trading:e,trainer:e,union:e,workinggroup:e,works:e}],af:n,ag:[1,{co:e,com:e,net:e,nom:e,org:e}],ai:[1,{com:e,net:e,off:e,org:e}],al:t,am:[1,{co:e,com:e,commune:e,net:e,org:e}],ao:[1,{co:e,ed:e,edu:e,gov:e,gv:e,it:e,og:e,org:e,pb:e}],aq:e,ar:[1,{bet:e,com:e,coop:e,edu:e,gob:e,gov:e,int:e,mil:e,musica:e,mutual:e,net:e,org:e,seg:e,senasa:e,tur:e}],
arpa:[1,{e164:e,home:e,"in-addr":e,ip6:e,iris:e,uri:e,urn:e}],as:r,asia:e,at:[1,{ac:[1,{sth:e}],co:e,gv:e,or:e}],au:[1,{asn:e,com:e,edu:[1,{act:e,catholic:e,nsw:e,nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],gov:[1,{qld:e,sa:e,tas:e,vic:e,wa:e}],id:e,net:e,org:e,conf:e,oz:e,act:e,nsw:e,nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],aw:[1,{com:e}],ax:e,az:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,int:e,mil:e,name:e,net:e,org:e,pp:e,pro:e}],ba:t,bb:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,net:e,org:e,store:e,tv:e}],bd:a,be:[1,{ac:e}],bf:r,bg:[1,{0:e,1:e,2:e,3:e,4:e,5:e,6:e,7:e,8:e,9:e,a:e,b:e,c:e,d:e,e,f:e,g:e,h:e,i:e,j:e,k:e,l:e,m:e,n:e,o:e,p:e,q:e,r:e,s:e,t:e,u:e,v:e,w:e,x:e,y:e,z:e}],bh:n,bi:[1,{co:e,com:e,edu:e,or:e,org:e}],biz:e,bj:[1,{africa:e,agro:e,architectes:e,assur:e,avocats:e,co:e,com:e,eco:e,econo:e,edu:e,info:e,loisirs:e,money:e,net:e,org:e,ote:e,restaurant:e,resto:e,tourism:e,univ:e}],bm:n,bn:n,bo:[1,{com:e,edu:e,gob:e,int:e,mil:e,net:e,org:e,tv:e,web:e,academia:e,agro:e,arte:e,blog:e,bolivia:e,ciencia:e,
cooperativa:e,democracia:e,deporte:e,ecologia:e,economia:e,empresa:e,indigena:e,industria:e,info:e,medicina:e,movimiento:e,musica:e,natural:e,nombre:e,noticias:e,patria:e,plurinacional:e,politica:e,profesional:e,pueblo:e,revista:e,salud:e,tecnologia:e,tksat:e,transporte:e,wiki:e}],br:[1,{"9guacu":e,abc:e,adm:e,adv:e,agr:e,aju:e,am:e,anani:e,aparecida:e,api:e,app:e,arq:e,art:e,ato:e,b:e,barueri:e,belem:e,bet:e,bhz:e,bib:e,bio:e,blog:e,bmd:e,boavista:e,bsb:e,campinagrande:e,campinas:e,caxias:e,cim:e,cng:e,cnt:e,com:e,contagem:e,coop:e,coz:e,cri:e,cuiaba:e,curitiba:e,def:e,des:e,det:e,dev:e,ecn:e,eco:e,edu:e,emp:e,enf:e,eng:e,esp:e,etc:e,eti:e,far:e,feira:e,flog:e,floripa:e,fm:e,fnd:e,fortal:e,fot:e,foz:e,fst:e,g12:e,geo:e,ggf:e,goiania:e,gov:[1,{ac:e,al:e,am:e,ap:e,ba:e,ce:e,df:e,es:e,go:e,ma:e,mg:e,ms:e,mt:e,pa:e,pb:e,pe:e,pi:e,pr:e,rj:e,rn:e,ro:e,rr:e,rs:e,sc:e,se:e,sp:e,to:e}],gru:e,ia:e,imb:e,ind:e,inf:e,jab:e,jampa:e,jdf:e,joinville:e,jor:e,jus:e,leg:e,leilao:e,lel:e,log:e,londrina:e,
macapa:e,maceio:e,manaus:e,maringa:e,mat:e,med:e,mil:e,morena:e,mp:e,mus:e,natal:e,net:e,niteroi:e,nom:a,not:e,ntr:e,odo:e,ong:e,org:e,osasco:e,palmas:e,poa:e,ppg:e,pro:e,psc:e,psi:e,pvh:e,qsl:e,radio:e,rec:e,recife:e,rep:e,ribeirao:e,rio:e,riobranco:e,riopreto:e,salvador:e,sampa:e,santamaria:e,santoandre:e,saobernardo:e,saogonca:e,seg:e,sjc:e,slg:e,slz:e,social:e,sorocaba:e,srv:e,taxi:e,tc:e,tec:e,teo:e,the:e,tmp:e,trd:e,tur:e,tv:e,udi:e,vet:e,vix:e,vlog:e,wiki:e,xyz:e,zlg:e}],bs:n,bt:n,bv:e,bw:[1,{ac:e,co:e,gov:e,net:e,org:e}],by:[1,{gov:e,mil:e,com:e,of:e}],bz:o,ca:[1,{ab:e,bc:e,mb:e,nb:e,nf:e,nl:e,ns:e,nt:e,nu:e,on:e,pe:e,qc:e,sk:e,yk:e,gc:e}],cat:e,cc:e,cd:r,cf:e,cg:e,ch:e,ci:[1,{ac:e,"xn--aroport-bya":e,aéroport:e,asso:e,co:e,com:e,ed:e,edu:e,go:e,gouv:e,int:e,net:e,or:e,org:e}],ck:a,cl:[1,{co:e,gob:e,gov:e,mil:e}],cm:[1,{co:e,com:e,gov:e,net:e}],cn:[1,{ac:e,com:e,edu:e,gov:e,mil:e,net:e,org:e,"xn--55qx5d":e,公司:e,"xn--od0alg":e,網絡:e,"xn--io0a7i":e,网络:e,ah:e,bj:e,cq:e,
fj:e,gd:e,gs:e,gx:e,gz:e,ha:e,hb:e,he:e,hi:e,hk:e,hl:e,hn:e,jl:e,js:e,jx:e,ln:e,mo:e,nm:e,nx:e,qh:e,sc:e,sd:e,sh:e,sn:e,sx:e,tj:e,tw:e,xj:e,xz:e,yn:e,zj:e}],co:[1,{com:e,edu:e,gov:e,mil:e,net:e,nom:e,org:e}],com:e,coop:e,cr:[1,{ac:e,co:e,ed:e,fi:e,go:e,or:e,sa:e}],cu:[1,{com:e,edu:e,gob:e,inf:e,nat:e,net:e,org:e}],cv:[1,{com:e,edu:e,id:e,int:e,net:e,nome:e,org:e,publ:e}],cw:s,cx:r,cy:[1,{ac:e,biz:e,com:e,ekloges:e,gov:e,ltd:e,mil:e,net:e,org:e,press:e,pro:e,tm:e}],cz:r,de:e,dj:e,dk:e,dm:o,do:[1,{art:e,com:e,edu:e,gob:e,gov:e,mil:e,net:e,org:e,sld:e,web:e}],dz:[1,{art:e,asso:e,com:e,edu:e,gov:e,net:e,org:e,pol:e,soc:e,tm:e}],ec:[1,{abg:e,adm:e,agron:e,arqt:e,art:e,bar:e,chef:e,com:e,cont:e,cpa:e,cue:e,dent:e,dgn:e,disco:e,doc:e,edu:e,eng:e,esm:e,fin:e,fot:e,gal:e,gob:e,gov:e,gye:e,ibr:e,info:e,k12:e,lat:e,loj:e,med:e,mil:e,mktg:e,mon:e,net:e,ntr:e,odont:e,org:e,pro:e,prof:e,psic:e,psiq:e,pub:e,rio:e,rrpp:e,sal:e,tech:e,tul:e,tur:e,uio:e,vet:e,xxx:e}],edu:e,ee:[1,{aip:e,com:e,edu:e,fie:e,
gov:e,lib:e,med:e,org:e,pri:e,riik:e}],eg:[1,{ac:e,com:e,edu:e,eun:e,gov:e,info:e,me:e,mil:e,name:e,net:e,org:e,sci:e,sport:e,tv:e}],er:a,es:[1,{com:e,edu:e,gob:e,nom:e,org:e}],et:[1,{biz:e,com:e,edu:e,gov:e,info:e,name:e,net:e,org:e}],eu:e,fi:[1,{aland:e}],fj:[1,{ac:e,biz:e,com:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],fk:a,fm:s,fo:e,fr:[1,{asso:e,com:e,gouv:e,nom:e,prd:e,tm:e,avoues:e,cci:e,greta:e,"huissier-justice":e}],ga:e,gb:e,gd:[1,{edu:e,gov:e}],ge:[1,{com:e,edu:e,gov:e,net:e,org:e,pvt:e,school:e}],gf:e,gg:c,gh:[1,{biz:e,com:e,edu:e,gov:e,mil:e,net:e,org:e}],gi:[1,{com:e,edu:e,gov:e,ltd:e,mod:e,org:e}],gl:[1,{co:e,com:e,edu:e,net:e,org:e}],gm:e,gn:[1,{ac:e,com:e,edu:e,gov:e,net:e,org:e}],gov:e,gp:[1,{asso:e,com:e,edu:e,mobi:e,net:e,org:e}],gq:e,gr:n,gs:e,gt:[1,{com:e,edu:e,gob:e,ind:e,mil:e,net:e,org:e}],gu:[1,{com:e,edu:e,gov:e,guam:e,info:e,net:e,org:e,web:e}],gw:e,gy:o,hk:[1,{com:e,edu:e,gov:e,idv:e,net:e,org:e,"xn--ciqpn":e,个人:e,"xn--gmqw5a":e,個人:e,"xn--55qx5d":e,
公司:e,"xn--mxtq1m":e,政府:e,"xn--lcvr32d":e,敎育:e,"xn--wcvs22d":e,教育:e,"xn--gmq050i":e,箇人:e,"xn--uc0atv":e,組織:e,"xn--uc0ay4a":e,組织:e,"xn--od0alg":e,網絡:e,"xn--zf0avx":e,網络:e,"xn--mk0axi":e,组織:e,"xn--tn0ag":e,组织:e,"xn--od0aq3b":e,网絡:e,"xn--io0a7i":e,网络:e}],hm:e,hn:[1,{com:e,edu:e,gob:e,mil:e,net:e,org:e}],hr:[1,{com:e,from:e,iz:e,name:e}],ht:[1,{adult:e,art:e,asso:e,com:e,coop:e,edu:e,firm:e,gouv:e,info:e,med:e,net:e,org:e,perso:e,pol:e,pro:e,rel:e,shop:e}],hu:[1,{2e3:e,agrar:e,bolt:e,casino:e,city:e,co:e,erotica:e,erotika:e,film:e,forum:e,games:e,hotel:e,info:e,ingatlan:e,jogasz:e,konyvelo:e,lakas:e,media:e,news:e,org:e,priv:e,reklam:e,sex:e,shop:e,sport:e,suli:e,szex:e,tm:e,tozsde:e,utazas:e,video:e}],id:[1,{ac:e,biz:e,co:e,desa:e,go:e,kop:e,mil:e,my:e,net:e,or:e,ponpes:e,sch:e,web:e}],ie:r,il:[1,{ac:e,co:e,gov:e,idf:e,k12:e,muni:e,net:e,org:e}],"xn--4dbrk0ce":[1,{"xn--4dbgdty6c":e,"xn--5dbhl8d":e,"xn--8dbq2a":e,"xn--hebda8b":e}],ישראל:[
1,{אקדמיה:e,ישוב:e,צהל:e,ממשל:e}],im:[1,{ac:e,co:[1,{ltd:e,plc:e}],com:e,net:e,org:e,tt:e,tv:e}],in:[1,{"5g":e,"6g":e,ac:e,ai:e,am:e,bihar:e,biz:e,business:e,ca:e,cn:e,co:e,com:e,coop:e,cs:e,delhi:e,dr:e,edu:e,er:e,firm:e,gen:e,gov:e,gujarat:e,ind:e,info:e,int:e,internet:e,io:e,me:e,mil:e,net:e,nic:e,org:e,pg:e,post:e,pro:e,res:e,travel:e,tv:e,uk:e,up:e,us:e}],info:e,int:[1,{eu:e}],io:l,iq:t,ir:[1,{ac:e,co:e,gov:e,id:e,net:e,org:e,sch:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e}],is:e,it:[1,{edu:e,gov:e,abr:e,abruzzo:e,"aosta-valley":e,aostavalley:e,bas:e,basilicata:e,cal:e,calabria:e,cam:e,campania:e,"emilia-romagna":e,emiliaromagna:e,emr:e,"friuli-v-giulia":e,"friuli-ve-giulia":e,"friuli-vegiulia":e,"friuli-venezia-giulia":e,"friuli-veneziagiulia":e,"friuli-vgiulia":e,"friuliv-giulia":e,"friulive-giulia":e,friulivegiulia:e,"friulivenezia-giulia":e,friuliveneziagiulia:e,friulivgiulia:e,fvg:e,laz:e,lazio:e,lig:e,liguria:e,lom:e,lombardia:e,lombardy:e,
lucania:e,mar:e,marche:e,mol:e,molise:e,piedmont:e,piemonte:e,pmn:e,pug:e,puglia:e,sar:e,sardegna:e,sardinia:e,sic:e,sicilia:e,sicily:e,taa:e,tos:e,toscana:e,"trentin-sud-tirol":e,"xn--trentin-sd-tirol-rzb":e,"trentin-süd-tirol":e,"trentin-sudtirol":e,"xn--trentin-sdtirol-7vb":e,"trentin-südtirol":e,"trentin-sued-tirol":e,"trentin-suedtirol":e,trentino:e,"trentino-a-adige":e,"trentino-aadige":e,"trentino-alto-adige":e,"trentino-altoadige":e,"trentino-s-tirol":e,"trentino-stirol":e,"trentino-sud-tirol":e,"xn--trentino-sd-tirol-c3b":e,"trentino-süd-tirol":e,"trentino-sudtirol":e,"xn--trentino-sdtirol-szb":e,"trentino-südtirol":e,"trentino-sued-tirol":e,"trentino-suedtirol":e,"trentinoa-adige":e,trentinoaadige:e,"trentinoalto-adige":e,trentinoaltoadige:e,"trentinos-tirol":e,trentinostirol:e,"trentinosud-tirol":e,"xn--trentinosd-tirol-rzb":e,"trentinosüd-tirol":e,trentinosudtirol:e,"xn--trentinosdtirol-7vb":e,trentinosüdtirol:e,"trentinosued-tirol":e,trentinosuedtirol:e,"trentinsud-t\
irol":e,"xn--trentinsd-tirol-6vb":e,"trentinsüd-tirol":e,trentinsudtirol:e,"xn--trentinsdtirol-nsb":e,trentinsüdtirol:e,"trentinsued-tirol":e,trentinsuedtirol:e,tuscany:e,umb:e,umbria:e,"val-d-aosta":e,"val-daosta":e,"vald-aosta":e,valdaosta:e,"valle-aosta":e,"valle-d-aosta":e,"valle-daosta":e,valleaosta:e,"valled-aosta":e,valledaosta:e,"vallee-aoste":e,"xn--valle-aoste-ebb":e,"vallée-aoste":e,"vallee-d-aoste":e,"xn--valle-d-aoste-ehb":e,"vallée-d-aoste":e,valleeaoste:e,"xn--valleaoste-e7a":e,valléeaoste:e,valleedaoste:e,"xn--valledaoste-ebb":e,valléedaoste:e,vao:e,vda:e,ven:e,veneto:e,ag:e,agrigento:e,al:e,alessandria:e,"alto-adige":e,altoadige:e,an:e,ancona:e,"andria-barletta-trani":e,"andria-trani-barletta":e,andriabarlettatrani:e,andriatranibarletta:e,ao:e,aosta:e,aoste:e,ap:e,aq:e,aquila:e,ar:e,arezzo:e,"ascoli-piceno":e,ascolipiceno:e,asti:e,at:e,av:e,avellino:e,ba:e,balsan:e,"balsan-sudtirol":e,"xn--balsan-sdtirol-nsb":e,"balsan-südtirol":e,"balsan-suedtirol":e,bari:e,"ba\
rletta-trani-andria":e,barlettatraniandria:e,belluno:e,benevento:e,bergamo:e,bg:e,bi:e,biella:e,bl:e,bn:e,bo:e,bologna:e,bolzano:e,"bolzano-altoadige":e,bozen:e,"bozen-sudtirol":e,"xn--bozen-sdtirol-2ob":e,"bozen-südtirol":e,"bozen-suedtirol":e,br:e,brescia:e,brindisi:e,bs:e,bt:e,bulsan:e,"bulsan-sudtirol":e,"xn--bulsan-sdtirol-nsb":e,"bulsan-südtirol":e,"bulsan-suedtirol":e,bz:e,ca:e,cagliari:e,caltanissetta:e,"campidano-medio":e,campidanomedio:e,campobasso:e,"carbonia-iglesias":e,carboniaiglesias:e,"carrara-massa":e,carraramassa:e,caserta:e,catania:e,catanzaro:e,cb:e,ce:e,"cesena-forli":e,"xn--cesena-forl-mcb":e,"cesena-forlì":e,cesenaforli:e,"xn--cesenaforl-i8a":e,cesenaforlì:e,ch:e,chieti:e,ci:e,cl:e,cn:e,co:e,como:e,cosenza:e,cr:e,cremona:e,crotone:e,cs:e,ct:e,cuneo:e,cz:e,"dell-ogliastra":e,dellogliastra:e,en:e,enna:e,fc:e,fe:e,fermo:e,ferrara:e,fg:e,fi:e,firenze:e,florence:e,fm:e,foggia:e,"forli-cesena":e,"xn--forl-cesena-fcb":e,"forlì-cesena":e,forlicesena:e,"xn--forlcesen\
a-c8a":e,forlìcesena:e,fr:e,frosinone:e,ge:e,genoa:e,genova:e,go:e,gorizia:e,gr:e,grosseto:e,"iglesias-carbonia":e,iglesiascarbonia:e,im:e,imperia:e,is:e,isernia:e,kr:e,"la-spezia":e,laquila:e,laspezia:e,latina:e,lc:e,le:e,lecce:e,lecco:e,li:e,livorno:e,lo:e,lodi:e,lt:e,lu:e,lucca:e,macerata:e,mantova:e,"massa-carrara":e,massacarrara:e,matera:e,mb:e,mc:e,me:e,"medio-campidano":e,mediocampidano:e,messina:e,mi:e,milan:e,milano:e,mn:e,mo:e,modena:e,monza:e,"monza-brianza":e,"monza-e-della-brianza":e,monzabrianza:e,monzaebrianza:e,monzaedellabrianza:e,ms:e,mt:e,na:e,naples:e,napoli:e,no:e,novara:e,nu:e,nuoro:e,og:e,ogliastra:e,"olbia-tempio":e,olbiatempio:e,or:e,oristano:e,ot:e,pa:e,padova:e,padua:e,palermo:e,parma:e,pavia:e,pc:e,pd:e,pe:e,perugia:e,"pesaro-urbino":e,pesarourbino:e,pescara:e,pg:e,pi:e,piacenza:e,pisa:e,pistoia:e,pn:e,po:e,pordenone:e,potenza:e,pr:e,prato:e,pt:e,pu:e,pv:e,pz:e,ra:e,ragusa:e,ravenna:e,rc:e,re:e,"reggio-calabria":e,"reggio-emilia":e,reggiocalabria:e,reggioemilia:e,
rg:e,ri:e,rieti:e,rimini:e,rm:e,rn:e,ro:e,roma:e,rome:e,rovigo:e,sa:e,salerno:e,sassari:e,savona:e,si:e,siena:e,siracusa:e,so:e,sondrio:e,sp:e,sr:e,ss:e,"xn--sdtirol-n2a":e,südtirol:e,suedtirol:e,sv:e,ta:e,taranto:e,te:e,"tempio-olbia":e,tempioolbia:e,teramo:e,terni:e,tn:e,to:e,torino:e,tp:e,tr:e,"trani-andria-barletta":e,"trani-barletta-andria":e,traniandriabarletta:e,tranibarlettaandria:e,trapani:e,trento:e,treviso:e,trieste:e,ts:e,turin:e,tv:e,ud:e,udine:e,"urbino-pesaro":e,urbinopesaro:e,va:e,varese:e,vb:e,vc:e,ve:e,venezia:e,venice:e,verbania:e,vercelli:e,verona:e,vi:e,"vibo-valentia":e,vibovalentia:e,vicenza:e,viterbo:e,vr:e,vs:e,vt:e,vv:e}],je:c,jm:a,jo:[1,{agri:e,ai:e,com:e,edu:e,eng:e,fm:e,gov:e,mil:e,net:e,org:e,per:e,phd:e,sch:e,tv:e}],jobs:e,jp:[1,{ac:e,ad:e,co:e,ed:e,go:e,gr:e,lg:e,ne:e,or:e,aichi:[1,{aisai:e,ama:e,anjo:e,asuke:e,chiryu:e,chita:e,fuso:e,gamagori:e,handa:e,hazu:e,hekinan:e,higashiura:e,ichinomiya:e,inazawa:e,inuyama:e,isshiki:e,iwakura:e,kanie:e,kariya:e,kasugai:e,
kira:e,kiyosu:e,komaki:e,konan:e,kota:e,mihama:e,miyoshi:e,nishio:e,nisshin:e,obu:e,oguchi:e,oharu:e,okazaki:e,owariasahi:e,seto:e,shikatsu:e,shinshiro:e,shitara:e,tahara:e,takahama:e,tobishima:e,toei:e,togo:e,tokai:e,tokoname:e,toyoake:e,toyohashi:e,toyokawa:e,toyone:e,toyota:e,tsushima:e,yatomi:e}],akita:[1,{akita:e,daisen:e,fujisato:e,gojome:e,hachirogata:e,happou:e,higashinaruse:e,honjo:e,honjyo:e,ikawa:e,kamikoani:e,kamioka:e,katagami:e,kazuno:e,kitaakita:e,kosaka:e,kyowa:e,misato:e,mitane:e,moriyoshi:e,nikaho:e,noshiro:e,odate:e,oga:e,ogata:e,semboku:e,yokote:e,yurihonjo:e}],aomori:[1,{aomori:e,gonohe:e,hachinohe:e,hashikami:e,hiranai:e,hirosaki:e,itayanagi:e,kuroishi:e,misawa:e,mutsu:e,nakadomari:e,noheji:e,oirase:e,owani:e,rokunohe:e,sannohe:e,shichinohe:e,shingo:e,takko:e,towada:e,tsugaru:e,tsuruta:e}],chiba:[1,{abiko:e,asahi:e,chonan:e,chosei:e,choshi:e,chuo:e,funabashi:e,futtsu:e,hanamigawa:e,ichihara:e,ichikawa:e,ichinomiya:e,inzai:e,isumi:e,kamagaya:e,kamogawa:e,kashiwa:e,
katori:e,katsuura:e,kimitsu:e,kisarazu:e,kozaki:e,kujukuri:e,kyonan:e,matsudo:e,midori:e,mihama:e,minamiboso:e,mobara:e,mutsuzawa:e,nagara:e,nagareyama:e,narashino:e,narita:e,noda:e,oamishirasato:e,omigawa:e,onjuku:e,otaki:e,sakae:e,sakura:e,shimofusa:e,shirako:e,shiroi:e,shisui:e,sodegaura:e,sosa:e,tako:e,tateyama:e,togane:e,tohnosho:e,tomisato:e,urayasu:e,yachimata:e,yachiyo:e,yokaichiba:e,yokoshibahikari:e,yotsukaido:e}],ehime:[1,{ainan:e,honai:e,ikata:e,imabari:e,iyo:e,kamijima:e,kihoku:e,kumakogen:e,masaki:e,matsuno:e,matsuyama:e,namikata:e,niihama:e,ozu:e,saijo:e,seiyo:e,shikokuchuo:e,tobe:e,toon:e,uchiko:e,uwajima:e,yawatahama:e}],fukui:[1,{echizen:e,eiheiji:e,fukui:e,ikeda:e,katsuyama:e,mihama:e,minamiechizen:e,obama:e,ohi:e,ono:e,sabae:e,sakai:e,takahama:e,tsuruga:e,wakasa:e}],fukuoka:[1,{ashiya:e,buzen:e,chikugo:e,chikuho:e,chikujo:e,chikushino:e,chikuzen:e,chuo:e,dazaifu:e,fukuchi:e,hakata:e,higashi:e,hirokawa:e,hisayama:e,iizuka:e,inatsuki:e,kaho:e,kasuga:e,kasuya:e,kawara:e,
keisen:e,koga:e,kurate:e,kurogi:e,kurume:e,minami:e,miyako:e,miyama:e,miyawaka:e,mizumaki:e,munakata:e,nakagawa:e,nakama:e,nishi:e,nogata:e,ogori:e,okagaki:e,okawa:e,oki:e,omuta:e,onga:e,onojo:e,oto:e,saigawa:e,sasaguri:e,shingu:e,shinyoshitomi:e,shonai:e,soeda:e,sue:e,tachiarai:e,tagawa:e,takata:e,toho:e,toyotsu:e,tsuiki:e,ukiha:e,umi:e,usui:e,yamada:e,yame:e,yanagawa:e,yukuhashi:e}],fukushima:[1,{aizubange:e,aizumisato:e,aizuwakamatsu:e,asakawa:e,bandai:e,date:e,fukushima:e,furudono:e,futaba:e,hanawa:e,higashi:e,hirata:e,hirono:e,iitate:e,inawashiro:e,ishikawa:e,iwaki:e,izumizaki:e,kagamiishi:e,kaneyama:e,kawamata:e,kitakata:e,kitashiobara:e,koori:e,koriyama:e,kunimi:e,miharu:e,mishima:e,namie:e,nango:e,nishiaizu:e,nishigo:e,okuma:e,omotego:e,ono:e,otama:e,samegawa:e,shimogo:e,shirakawa:e,showa:e,soma:e,sukagawa:e,taishin:e,tamakawa:e,tanagura:e,tenei:e,yabuki:e,yamato:e,yamatsuri:e,yanaizu:e,yugawa:e}],gifu:[1,{anpachi:e,ena:e,gifu:e,ginan:e,godo:e,gujo:e,hashima:e,hichiso:e,hida:e,
higashishirakawa:e,ibigawa:e,ikeda:e,kakamigahara:e,kani:e,kasahara:e,kasamatsu:e,kawaue:e,kitagata:e,mino:e,minokamo:e,mitake:e,mizunami:e,motosu:e,nakatsugawa:e,ogaki:e,sakahogi:e,seki:e,sekigahara:e,shirakawa:e,tajimi:e,takayama:e,tarui:e,toki:e,tomika:e,wanouchi:e,yamagata:e,yaotsu:e,yoro:e}],gunma:[1,{annaka:e,chiyoda:e,fujioka:e,higashiagatsuma:e,isesaki:e,itakura:e,kanna:e,kanra:e,katashina:e,kawaba:e,kiryu:e,kusatsu:e,maebashi:e,meiwa:e,midori:e,minakami:e,naganohara:e,nakanojo:e,nanmoku:e,numata:e,oizumi:e,ora:e,ota:e,shibukawa:e,shimonita:e,shinto:e,showa:e,takasaki:e,takayama:e,tamamura:e,tatebayashi:e,tomioka:e,tsukiyono:e,tsumagoi:e,ueno:e,yoshioka:e}],hiroshima:[1,{asaminami:e,daiwa:e,etajima:e,fuchu:e,fukuyama:e,hatsukaichi:e,higashihiroshima:e,hongo:e,jinsekikogen:e,kaita:e,kui:e,kumano:e,kure:e,mihara:e,miyoshi:e,naka:e,onomichi:e,osakikamijima:e,otake:e,saka:e,sera:e,seranishi:e,shinichi:e,shobara:e,takehara:e}],hokkaido:[1,{abashiri:e,abira:e,aibetsu:e,akabira:e,akkeshi:e,
asahikawa:e,ashibetsu:e,ashoro:e,assabu:e,atsuma:e,bibai:e,biei:e,bifuka:e,bihoro:e,biratori:e,chippubetsu:e,chitose:e,date:e,ebetsu:e,embetsu:e,eniwa:e,erimo:e,esan:e,esashi:e,fukagawa:e,fukushima:e,furano:e,furubira:e,haboro:e,hakodate:e,hamatonbetsu:e,hidaka:e,higashikagura:e,higashikawa:e,hiroo:e,hokuryu:e,hokuto:e,honbetsu:e,horokanai:e,horonobe:e,ikeda:e,imakane:e,ishikari:e,iwamizawa:e,iwanai:e,kamifurano:e,kamikawa:e,kamishihoro:e,kamisunagawa:e,kamoenai:e,kayabe:e,kembuchi:e,kikonai:e,kimobetsu:e,kitahiroshima:e,kitami:e,kiyosato:e,koshimizu:e,kunneppu:e,kuriyama:e,kuromatsunai:e,kushiro:e,kutchan:e,kyowa:e,mashike:e,matsumae:e,mikasa:e,minamifurano:e,mombetsu:e,moseushi:e,mukawa:e,muroran:e,naie:e,nakagawa:e,nakasatsunai:e,nakatombetsu:e,nanae:e,nanporo:e,nayoro:e,nemuro:e,niikappu:e,niki:e,nishiokoppe:e,noboribetsu:e,numata:e,obihiro:e,obira:e,oketo:e,okoppe:e,otaru:e,otobe:e,otofuke:e,otoineppu:e,oumu:e,ozora:e,pippu:e,rankoshi:e,rebun:e,rikubetsu:e,rishiri:e,rishirifuji:e,
saroma:e,sarufutsu:e,shakotan:e,shari:e,shibecha:e,shibetsu:e,shikabe:e,shikaoi:e,shimamaki:e,shimizu:e,shimokawa:e,shinshinotsu:e,shintoku:e,shiranuka:e,shiraoi:e,shiriuchi:e,sobetsu:e,sunagawa:e,taiki:e,takasu:e,takikawa:e,takinoue:e,teshikaga:e,tobetsu:e,tohma:e,tomakomai:e,tomari:e,toya:e,toyako:e,toyotomi:e,toyoura:e,tsubetsu:e,tsukigata:e,urakawa:e,urausu:e,uryu:e,utashinai:e,wakkanai:e,wassamu:e,yakumo:e,yoichi:e}],hyogo:[1,{aioi:e,akashi:e,ako:e,amagasaki:e,aogaki:e,asago:e,ashiya:e,awaji:e,fukusaki:e,goshiki:e,harima:e,himeji:e,ichikawa:e,inagawa:e,itami:e,kakogawa:e,kamigori:e,kamikawa:e,kasai:e,kasuga:e,kawanishi:e,miki:e,minamiawaji:e,nishinomiya:e,nishiwaki:e,ono:e,sanda:e,sannan:e,sasayama:e,sayo:e,shingu:e,shinonsen:e,shiso:e,sumoto:e,taishi:e,taka:e,takarazuka:e,takasago:e,takino:e,tamba:e,tatsuno:e,toyooka:e,yabu:e,yashiro:e,yoka:e,yokawa:e}],ibaraki:[1,{ami:e,asahi:e,bando:e,chikusei:e,daigo:e,fujishiro:e,hitachi:e,hitachinaka:e,hitachiomiya:e,hitachiota:e,ibaraki:e,ina:e,
inashiki:e,itako:e,iwama:e,joso:e,kamisu:e,kasama:e,kashima:e,kasumigaura:e,koga:e,miho:e,mito:e,moriya:e,naka:e,namegata:e,oarai:e,ogawa:e,omitama:e,ryugasaki:e,sakai:e,sakuragawa:e,shimodate:e,shimotsuma:e,shirosato:e,sowa:e,suifu:e,takahagi:e,tamatsukuri:e,tokai:e,tomobe:e,tone:e,toride:e,tsuchiura:e,tsukuba:e,uchihara:e,ushiku:e,yachiyo:e,yamagata:e,yawara:e,yuki:e}],ishikawa:[1,{anamizu:e,hakui:e,hakusan:e,kaga:e,kahoku:e,kanazawa:e,kawakita:e,komatsu:e,nakanoto:e,nanao:e,nomi:e,nonoichi:e,noto:e,shika:e,suzu:e,tsubata:e,tsurugi:e,uchinada:e,wajima:e}],iwate:[1,{fudai:e,fujisawa:e,hanamaki:e,hiraizumi:e,hirono:e,ichinohe:e,ichinoseki:e,iwaizumi:e,iwate:e,joboji:e,kamaishi:e,kanegasaki:e,karumai:e,kawai:e,kitakami:e,kuji:e,kunohe:e,kuzumaki:e,miyako:e,mizusawa:e,morioka:e,ninohe:e,noda:e,ofunato:e,oshu:e,otsuchi:e,rikuzentakata:e,shiwa:e,shizukuishi:e,sumita:e,tanohata:e,tono:e,yahaba:e,yamada:e}],kagawa:[1,{ayagawa:e,higashikagawa:e,kanonji:e,kotohira:e,manno:e,marugame:e,mitoyo:e,
naoshima:e,sanuki:e,tadotsu:e,takamatsu:e,tonosho:e,uchinomi:e,utazu:e,zentsuji:e}],kagoshima:[1,{akune:e,amami:e,hioki:e,isa:e,isen:e,izumi:e,kagoshima:e,kanoya:e,kawanabe:e,kinko:e,kouyama:e,makurazaki:e,matsumoto:e,minamitane:e,nakatane:e,nishinoomote:e,satsumasendai:e,soo:e,tarumizu:e,yusui:e}],kanagawa:[1,{aikawa:e,atsugi:e,ayase:e,chigasaki:e,ebina:e,fujisawa:e,hadano:e,hakone:e,hiratsuka:e,isehara:e,kaisei:e,kamakura:e,kiyokawa:e,matsuda:e,minamiashigara:e,miura:e,nakai:e,ninomiya:e,odawara:e,oi:e,oiso:e,sagamihara:e,samukawa:e,tsukui:e,yamakita:e,yamato:e,yokosuka:e,yugawara:e,zama:e,zushi:e}],kochi:[1,{aki:e,geisei:e,hidaka:e,higashitsuno:e,ino:e,kagami:e,kami:e,kitagawa:e,kochi:e,mihara:e,motoyama:e,muroto:e,nahari:e,nakamura:e,nankoku:e,nishitosa:e,niyodogawa:e,ochi:e,okawa:e,otoyo:e,otsuki:e,sakawa:e,sukumo:e,susaki:e,tosa:e,tosashimizu:e,toyo:e,tsuno:e,umaji:e,yasuda:e,yusuhara:e}],kumamoto:[1,{amakusa:e,arao:e,aso:e,choyo:e,gyokuto:e,kamiamakusa:e,kikuchi:e,kumamoto:e,mashiki:e,
mifune:e,minamata:e,minamioguni:e,nagasu:e,nishihara:e,oguni:e,ozu:e,sumoto:e,takamori:e,uki:e,uto:e,yamaga:e,yamato:e,yatsushiro:e}],kyoto:[1,{ayabe:e,fukuchiyama:e,higashiyama:e,ide:e,ine:e,joyo:e,kameoka:e,kamo:e,kita:e,kizu:e,kumiyama:e,kyotamba:e,kyotanabe:e,kyotango:e,maizuru:e,minami:e,minamiyamashiro:e,miyazu:e,muko:e,nagaokakyo:e,nakagyo:e,nantan:e,oyamazaki:e,sakyo:e,seika:e,tanabe:e,uji:e,ujitawara:e,wazuka:e,yamashina:e,yawata:e}],mie:[1,{asahi:e,inabe:e,ise:e,kameyama:e,kawagoe:e,kiho:e,kisosaki:e,kiwa:e,komono:e,kumano:e,kuwana:e,matsusaka:e,meiwa:e,mihama:e,minamiise:e,misugi:e,miyama:e,nabari:e,shima:e,suzuka:e,tado:e,taiki:e,taki:e,tamaki:e,toba:e,tsu:e,udono:e,ureshino:e,watarai:e,yokkaichi:e}],miyagi:[1,{furukawa:e,higashimatsushima:e,ishinomaki:e,iwanuma:e,kakuda:e,kami:e,kawasaki:e,marumori:e,matsushima:e,minamisanriku:e,misato:e,murata:e,natori:e,ogawara:e,ohira:e,onagawa:e,osaki:e,rifu:e,semine:e,shibata:e,shichikashuku:e,shikama:e,shiogama:e,shiroishi:e,tagajo:e,
taiwa:e,tome:e,tomiya:e,wakuya:e,watari:e,yamamoto:e,zao:e}],miyazaki:[1,{aya:e,ebino:e,gokase:e,hyuga:e,kadogawa:e,kawaminami:e,kijo:e,kitagawa:e,kitakata:e,kitaura:e,kobayashi:e,kunitomi:e,kushima:e,mimata:e,miyakonojo:e,miyazaki:e,morotsuka:e,nichinan:e,nishimera:e,nobeoka:e,saito:e,shiiba:e,shintomi:e,takaharu:e,takanabe:e,takazaki:e,tsuno:e}],nagano:[1,{achi:e,agematsu:e,anan:e,aoki:e,asahi:e,azumino:e,chikuhoku:e,chikuma:e,chino:e,fujimi:e,hakuba:e,hara:e,hiraya:e,iida:e,iijima:e,iiyama:e,iizuna:e,ikeda:e,ikusaka:e,ina:e,karuizawa:e,kawakami:e,kiso:e,kisofukushima:e,kitaaiki:e,komagane:e,komoro:e,matsukawa:e,matsumoto:e,miasa:e,minamiaiki:e,minamimaki:e,minamiminowa:e,minowa:e,miyada:e,miyota:e,mochizuki:e,nagano:e,nagawa:e,nagiso:e,nakagawa:e,nakano:e,nozawaonsen:e,obuse:e,ogawa:e,okaya:e,omachi:e,omi:e,ookuwa:e,ooshika:e,otaki:e,otari:e,sakae:e,sakaki:e,saku:e,sakuho:e,shimosuwa:e,shinanomachi:e,shiojiri:e,suwa:e,suzaka:e,takagi:e,takamori:e,takayama:e,tateshina:e,tatsuno:e,togakushi:e,
togura:e,tomi:e,ueda:e,wada:e,yamagata:e,yamanouchi:e,yasaka:e,yasuoka:e}],nagasaki:[1,{chijiwa:e,futsu:e,goto:e,hasami:e,hirado:e,iki:e,isahaya:e,kawatana:e,kuchinotsu:e,matsuura:e,nagasaki:e,obama:e,omura:e,oseto:e,saikai:e,sasebo:e,seihi:e,shimabara:e,shinkamigoto:e,togitsu:e,tsushima:e,unzen:e}],nara:[1,{ando:e,gose:e,heguri:e,higashiyoshino:e,ikaruga:e,ikoma:e,kamikitayama:e,kanmaki:e,kashiba:e,kashihara:e,katsuragi:e,kawai:e,kawakami:e,kawanishi:e,koryo:e,kurotaki:e,mitsue:e,miyake:e,nara:e,nosegawa:e,oji:e,ouda:e,oyodo:e,sakurai:e,sango:e,shimoichi:e,shimokitayama:e,shinjo:e,soni:e,takatori:e,tawaramoto:e,tenkawa:e,tenri:e,uda:e,yamatokoriyama:e,yamatotakada:e,yamazoe:e,yoshino:e}],niigata:[1,{aga:e,agano:e,gosen:e,itoigawa:e,izumozaki:e,joetsu:e,kamo:e,kariwa:e,kashiwazaki:e,minamiuonuma:e,mitsuke:e,muika:e,murakami:e,myoko:e,nagaoka:e,niigata:e,ojiya:e,omi:e,sado:e,sanjo:e,seiro:e,seirou:e,sekikawa:e,shibata:e,tagami:e,tainai:e,tochio:e,tokamachi:e,tsubame:e,tsunan:e,uonuma:e,
yahiko:e,yoita:e,yuzawa:e}],oita:[1,{beppu:e,bungoono:e,bungotakada:e,hasama:e,hiji:e,himeshima:e,hita:e,kamitsue:e,kokonoe:e,kuju:e,kunisaki:e,kusu:e,oita:e,saiki:e,taketa:e,tsukumi:e,usa:e,usuki:e,yufu:e}],okayama:[1,{akaiwa:e,asakuchi:e,bizen:e,hayashima:e,ibara:e,kagamino:e,kasaoka:e,kibichuo:e,kumenan:e,kurashiki:e,maniwa:e,misaki:e,nagi:e,niimi:e,nishiawakura:e,okayama:e,satosho:e,setouchi:e,shinjo:e,shoo:e,soja:e,takahashi:e,tamano:e,tsuyama:e,wake:e,yakage:e}],okinawa:[1,{aguni:e,ginowan:e,ginoza:e,gushikami:e,haebaru:e,higashi:e,hirara:e,iheya:e,ishigaki:e,ishikawa:e,itoman:e,izena:e,kadena:e,kin:e,kitadaito:e,kitanakagusuku:e,kumejima:e,kunigami:e,minamidaito:e,motobu:e,nago:e,naha:e,nakagusuku:e,nakijin:e,nanjo:e,nishihara:e,ogimi:e,okinawa:e,onna:e,shimoji:e,taketomi:e,tarama:e,tokashiki:e,tomigusuku:e,tonaki:e,urasoe:e,uruma:e,yaese:e,yomitan:e,yonabaru:e,yonaguni:e,zamami:e}],osaka:[1,{abeno:e,chihayaakasaka:e,chuo:e,daito:e,fujiidera:e,habikino:e,hannan:e,higashiosaka:e,
higashisumiyoshi:e,higashiyodogawa:e,hirakata:e,ibaraki:e,ikeda:e,izumi:e,izumiotsu:e,izumisano:e,kadoma:e,kaizuka:e,kanan:e,kashiwara:e,katano:e,kawachinagano:e,kishiwada:e,kita:e,kumatori:e,matsubara:e,minato:e,minoh:e,misaki:e,moriguchi:e,neyagawa:e,nishi:e,nose:e,osakasayama:e,sakai:e,sayama:e,sennan:e,settsu:e,shijonawate:e,shimamoto:e,suita:e,tadaoka:e,taishi:e,tajiri:e,takaishi:e,takatsuki:e,tondabayashi:e,toyonaka:e,toyono:e,yao:e}],saga:[1,{ariake:e,arita:e,fukudomi:e,genkai:e,hamatama:e,hizen:e,imari:e,kamimine:e,kanzaki:e,karatsu:e,kashima:e,kitagata:e,kitahata:e,kiyama:e,kouhoku:e,kyuragi:e,nishiarita:e,ogi:e,omachi:e,ouchi:e,saga:e,shiroishi:e,taku:e,tara:e,tosu:e,yoshinogari:e}],saitama:[1,{arakawa:e,asaka:e,chichibu:e,fujimi:e,fujimino:e,fukaya:e,hanno:e,hanyu:e,hasuda:e,hatogaya:e,hatoyama:e,hidaka:e,higashichichibu:e,higashimatsuyama:e,honjo:e,ina:e,iruma:e,iwatsuki:e,kamiizumi:e,kamikawa:e,kamisato:e,kasukabe:e,kawagoe:e,kawaguchi:e,kawajima:e,kazo:e,kitamoto:e,koshigaya:e,
kounosu:e,kuki:e,kumagaya:e,matsubushi:e,minano:e,misato:e,miyashiro:e,miyoshi:e,moroyama:e,nagatoro:e,namegawa:e,niiza:e,ogano:e,ogawa:e,ogose:e,okegawa:e,omiya:e,otaki:e,ranzan:e,ryokami:e,saitama:e,sakado:e,satte:e,sayama:e,shiki:e,shiraoka:e,soka:e,sugito:e,toda:e,tokigawa:e,tokorozawa:e,tsurugashima:e,urawa:e,warabi:e,yashio:e,yokoze:e,yono:e,yorii:e,yoshida:e,yoshikawa:e,yoshimi:e}],shiga:[1,{aisho:e,gamo:e,higashiomi:e,hikone:e,koka:e,konan:e,kosei:e,koto:e,kusatsu:e,maibara:e,moriyama:e,nagahama:e,nishiazai:e,notogawa:e,omihachiman:e,otsu:e,ritto:e,ryuoh:e,takashima:e,takatsuki:e,torahime:e,toyosato:e,yasu:e}],shimane:[1,{akagi:e,ama:e,gotsu:e,hamada:e,higashiizumo:e,hikawa:e,hikimi:e,izumo:e,kakinoki:e,masuda:e,matsue:e,misato:e,nishinoshima:e,ohda:e,okinoshima:e,okuizumo:e,shimane:e,tamayu:e,tsuwano:e,unnan:e,yakumo:e,yasugi:e,yatsuka:e}],shizuoka:[1,{arai:e,atami:e,fuji:e,fujieda:e,fujikawa:e,fujinomiya:e,fukuroi:e,gotemba:e,haibara:e,hamamatsu:e,higashiizu:e,ito:e,iwata:e,izu:e,
izunokuni:e,kakegawa:e,kannami:e,kawanehon:e,kawazu:e,kikugawa:e,kosai:e,makinohara:e,matsuzaki:e,minamiizu:e,mishima:e,morimachi:e,nishiizu:e,numazu:e,omaezaki:e,shimada:e,shimizu:e,shimoda:e,shizuoka:e,susono:e,yaizu:e,yoshida:e}],tochigi:[1,{ashikaga:e,bato:e,haga:e,ichikai:e,iwafune:e,kaminokawa:e,kanuma:e,karasuyama:e,kuroiso:e,mashiko:e,mibu:e,moka:e,motegi:e,nasu:e,nasushiobara:e,nikko:e,nishikata:e,nogi:e,ohira:e,ohtawara:e,oyama:e,sakura:e,sano:e,shimotsuke:e,shioya:e,takanezawa:e,tochigi:e,tsuga:e,ujiie:e,utsunomiya:e,yaita:e}],tokushima:[1,{aizumi:e,anan:e,ichiba:e,itano:e,kainan:e,komatsushima:e,matsushige:e,mima:e,minami:e,miyoshi:e,mugi:e,nakagawa:e,naruto:e,sanagochi:e,shishikui:e,tokushima:e,wajiki:e}],tokyo:[1,{adachi:e,akiruno:e,akishima:e,aogashima:e,arakawa:e,bunkyo:e,chiyoda:e,chofu:e,chuo:e,edogawa:e,fuchu:e,fussa:e,hachijo:e,hachioji:e,hamura:e,higashikurume:e,higashimurayama:e,higashiyamato:e,hino:e,hinode:e,hinohara:e,inagi:e,itabashi:e,katsushika:e,kita:e,kiyose:e,
kodaira:e,koganei:e,kokubunji:e,komae:e,koto:e,kouzushima:e,kunitachi:e,machida:e,meguro:e,minato:e,mitaka:e,mizuho:e,musashimurayama:e,musashino:e,nakano:e,nerima:e,ogasawara:e,okutama:e,ome:e,oshima:e,ota:e,setagaya:e,shibuya:e,shinagawa:e,shinjuku:e,suginami:e,sumida:e,tachikawa:e,taito:e,tama:e,toshima:e}],tottori:[1,{chizu:e,hino:e,kawahara:e,koge:e,kotoura:e,misasa:e,nanbu:e,nichinan:e,sakaiminato:e,tottori:e,wakasa:e,yazu:e,yonago:e}],toyama:[1,{asahi:e,fuchu:e,fukumitsu:e,funahashi:e,himi:e,imizu:e,inami:e,johana:e,kamiichi:e,kurobe:e,nakaniikawa:e,namerikawa:e,nanto:e,nyuzen:e,oyabe:e,taira:e,takaoka:e,tateyama:e,toga:e,tonami:e,toyama:e,unazuki:e,uozu:e,yamada:e}],wakayama:[1,{arida:e,aridagawa:e,gobo:e,hashimoto:e,hidaka:e,hirogawa:e,inami:e,iwade:e,kainan:e,kamitonda:e,katsuragi:e,kimino:e,kinokawa:e,kitayama:e,koya:e,koza:e,kozagawa:e,kudoyama:e,kushimoto:e,mihama:e,misato:e,nachikatsuura:e,shingu:e,shirahama:e,taiji:e,tanabe:e,wakayama:e,yuasa:e,yura:e}],yamagata:[1,{asahi:e,
funagata:e,higashine:e,iide:e,kahoku:e,kaminoyama:e,kaneyama:e,kawanishi:e,mamurogawa:e,mikawa:e,murayama:e,nagai:e,nakayama:e,nanyo:e,nishikawa:e,obanazawa:e,oe:e,oguni:e,ohkura:e,oishida:e,sagae:e,sakata:e,sakegawa:e,shinjo:e,shirataka:e,shonai:e,takahata:e,tendo:e,tozawa:e,tsuruoka:e,yamagata:e,yamanobe:e,yonezawa:e,yuza:e}],yamaguchi:[1,{abu:e,hagi:e,hikari:e,hofu:e,iwakuni:e,kudamatsu:e,mitou:e,nagato:e,oshima:e,shimonoseki:e,shunan:e,tabuse:e,tokuyama:e,toyota:e,ube:e,yuu:e}],yamanashi:[1,{chuo:e,doshi:e,fuefuki:e,fujikawa:e,fujikawaguchiko:e,fujiyoshida:e,hayakawa:e,hokuto:e,ichikawamisato:e,kai:e,kofu:e,koshu:e,kosuge:e,"minami-alps":e,minobu:e,nakamichi:e,nanbu:e,narusawa:e,nirasaki:e,nishikatsura:e,oshino:e,otsuki:e,showa:e,tabayama:e,tsuru:e,uenohara:e,yamanakako:e,yamanashi:e}],"xn--ehqz56n":e,三重:e,"xn--1lqs03n":e,京都:e,"xn--qqqt11m":e,佐賀:e,"xn--f6qx53a":e,兵庫:e,"xn--djrs72d6uy":e,北海道:e,"xn--mkru45i":e,千葉:e,"xn--0trq7p7nn":e,和歌山:e,"xn--5js045d":e,
埼玉:e,"xn--kbrq7o":e,大分:e,"xn--pssu33l":e,大阪:e,"xn--ntsq17g":e,奈良:e,"xn--uisz3g":e,宮城:e,"xn--6btw5a":e,宮崎:e,"xn--1ctwo":e,富山:e,"xn--6orx2r":e,山口:e,"xn--rht61e":e,山形:e,"xn--rht27z":e,山梨:e,"xn--nit225k":e,岐阜:e,"xn--rht3d":e,岡山:e,"xn--djty4k":e,岩手:e,"xn--klty5x":e,島根:e,"xn--kltx9a":e,広島:e,"xn--kltp7d":e,徳島:e,"xn--c3s14m":e,愛媛:e,"xn--vgu402c":e,愛知:e,"xn--efvn9s":e,新潟:e,"xn--1lqs71d":e,東京:e,"xn--4pvxs":e,栃木:e,"xn--uuwu58a":e,沖縄:e,"xn--zbx025d":e,滋賀:e,"xn--8pvr4u":e,熊本:e,"xn--5rtp49c":e,石川:e,"xn--ntso0iqx3a":e,神奈川:e,"xn--elqq16h":e,福井:e,"xn--4it168d":e,福岡:e,"xn--klt787d":e,福島:e,"xn--rny31h":e,秋田:e,"xn--7t0a264c":e,群馬:e,"xn--uist22h":e,茨城:e,"xn--8ltr62k":e,長崎:e,"xn--2m4a15e":e,長野:e,"xn--32vp30h":e,青森:e,"xn--4it797k":e,静岡:e,"xn--5rtq34k":e,香川:e,"xn--k7yn95e":e,高知:e,"xn--tor131o":e,鳥取:e,"xn--d5qv7z876c":e,鹿児島:e,kawasaki:a,kitakyushu:a,
kobe:a,nagoya:a,sapporo:a,sendai:a,yokohama:a}],ke:[1,{ac:e,co:e,go:e,info:e,me:e,mobi:e,ne:e,or:e,sc:e}],kg:t,kh:a,ki:u,km:[1,{ass:e,com:e,edu:e,gov:e,mil:e,nom:e,org:e,prd:e,tm:e,asso:e,coop:e,gouv:e,medecin:e,notaires:e,pharmaciens:e,presse:e,veterinaire:e}],kn:[1,{edu:e,gov:e,net:e,org:e}],kp:[1,{com:e,edu:e,gov:e,org:e,rep:e,tra:e}],kr:[1,{ac:e,ai:e,co:e,es:e,go:e,hs:e,io:e,it:e,kg:e,me:e,mil:e,ms:e,ne:e,or:e,pe:e,re:e,sc:e,busan:e,chungbuk:e,chungnam:e,daegu:e,daejeon:e,gangwon:e,gwangju:e,gyeongbuk:e,gyeonggi:e,gyeongnam:e,incheon:e,jeju:e,jeonbuk:e,jeonnam:e,seoul:e,ulsan:e}],kw:[1,{com:e,edu:e,emb:e,gov:e,ind:e,net:e,org:e}],ky:s,kz:t,la:[1,{com:e,edu:e,gov:e,info:e,int:e,net:e,org:e,per:e}],lb:n,lc:o,li:e,lk:[1,{ac:e,assn:e,com:e,edu:e,gov:e,grp:e,hotel:e,int:e,ltd:e,net:e,ngo:e,org:e,sch:e,soc:e,web:e}],lr:n,ls:[1,{ac:e,biz:e,co:e,edu:e,gov:e,info:e,net:e,org:e,sc:e}],lt:r,lu:e,lv:[1,{asn:e,com:e,conf:e,edu:e,gov:e,id:e,mil:e,net:e,org:e}],ly:[1,{com:e,edu:e,gov:e,id:e,med:e,
net:e,org:e,plc:e,sch:e}],ma:[1,{ac:e,co:e,gov:e,net:e,org:e,press:e}],mc:[1,{asso:e,tm:e}],md:e,me:[1,{ac:e,co:e,edu:e,gov:e,its:e,net:e,org:e,priv:e}],mg:[1,{co:e,com:e,edu:e,gov:e,mil:e,nom:e,org:e,prd:e}],mh:e,mil:e,mk:[1,{com:e,edu:e,gov:e,inf:e,name:e,net:e,org:e}],ml:[1,{ac:e,art:e,asso:e,com:e,edu:e,gouv:e,gov:e,info:e,inst:e,net:e,org:e,pr:e,presse:e}],mm:a,mn:[1,{edu:e,gov:e,org:e}],mo:n,mobi:e,mp:e,mq:e,mr:r,ms:n,mt:s,mu:[1,{ac:e,co:e,com:e,gov:e,net:e,or:e,org:e}],museum:e,mv:[1,{aero:e,biz:e,com:e,coop:e,edu:e,gov:e,info:e,int:e,mil:e,museum:e,name:e,net:e,org:e,pro:e}],mw:[1,{ac:e,biz:e,co:e,com:e,coop:e,edu:e,gov:e,int:e,net:e,org:e}],mx:[1,{com:e,edu:e,gob:e,net:e,org:e}],my:[1,{biz:e,com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e}],mz:[1,{ac:e,adv:e,co:e,edu:e,gov:e,mil:e,net:e,org:e}],na:[1,{alt:e,co:e,com:e,gov:e,net:e,org:e}],name:e,nc:[1,{asso:e,nom:e}],ne:e,net:e,nf:[1,{arts:e,com:e,firm:e,info:e,net:e,other:e,per:e,rec:e,store:e,web:e}],ng:[1,{com:e,edu:e,gov:e,i:e,mil:e,
mobi:e,name:e,net:e,org:e,sch:e}],ni:[1,{ac:e,biz:e,co:e,com:e,edu:e,gob:e,in:e,info:e,int:e,mil:e,net:e,nom:e,org:e,web:e}],nl:e,no:[1,{fhs:e,folkebibl:e,fylkesbibl:e,idrett:e,museum:e,priv:e,vgs:e,dep:e,herad:e,kommune:e,mil:e,stat:e,aa:m,ah:m,bu:m,fm:m,hl:m,hm:m,"jan-mayen":m,mr:m,nl:m,nt:m,of:m,ol:m,oslo:m,rl:m,sf:m,st:m,svalbard:m,tm:m,tr:m,va:m,vf:m,akrehamn:e,"xn--krehamn-dxa":e,åkrehamn:e,algard:e,"xn--lgrd-poac":e,ålgård:e,arna:e,bronnoysund:e,"xn--brnnysund-m8ac":e,brønnøysund:e,brumunddal:e,bryne:e,drobak:e,"xn--drbak-wua":e,drøbak:e,egersund:e,fetsund:e,floro:e,"xn--flor-jra":e,florø:e,fredrikstad:e,hokksund:e,honefoss:e,"xn--hnefoss-q1a":e,hønefoss:e,jessheim:e,jorpeland:e,"xn--jrpeland-54a":e,jørpeland:e,kirkenes:e,kopervik:e,krokstadelva:e,langevag:e,"xn--langevg-jxa":e,langevåg:e,leirvik:e,mjondalen:e,"xn--mjndalen-64a":e,mjøndalen:e,"mo-i-rana":e,mosjoen:e,"xn--mosjen-eya":e,mosjøen:e,nesoddtangen:e,orkanger:e,osoyro:e,"xn--osyro-wua":e,osøyro:e,raholt:e,"\
xn--rholt-mra":e,råholt:e,sandnessjoen:e,"xn--sandnessjen-ogb":e,sandnessjøen:e,skedsmokorset:e,slattum:e,spjelkavik:e,stathelle:e,stavern:e,stjordalshalsen:e,"xn--stjrdalshalsen-sqb":e,stjørdalshalsen:e,tananger:e,tranby:e,vossevangen:e,aarborte:e,aejrie:e,afjord:e,"xn--fjord-lra":e,åfjord:e,agdenes:e,akershus:p,aknoluokta:e,"xn--koluokta-7ya57h":e,ákŋoluokta:e,al:e,"xn--l-1fa":e,ål:e,alaheadju:e,"xn--laheadju-7ya":e,álaheadju:e,alesund:e,"xn--lesund-hua":e,ålesund:e,alstahaug:e,alta:e,"xn--lt-liac":e,áltá:e,alvdal:e,amli:e,"xn--mli-tla":e,åmli:e,amot:e,"xn--mot-tla":e,åmot:e,andasuolo:e,andebu:e,andoy:e,"xn--andy-ira":e,andøy:e,ardal:e,"xn--rdal-poa":e,årdal:e,aremark:e,arendal:e,"xn--s-1fa":e,ås:e,aseral:e,"xn--seral-lra":e,åseral:e,asker:e,askim:e,askoy:e,"xn--asky-ira":e,askøy:e,askvoll:e,asnes:e,"xn--snes-poa":e,åsnes:e,audnedaln:e,aukra:e,aure:e,aurland:e,"aurskog-holand":e,"xn--aurskog-hland-jnb":e,"aurskog-høland":e,austevoll:e,austrheim:e,averoy:e,"xn--ave\
ry-yua":e,averøy:e,badaddja:e,"xn--bdddj-mrabd":e,bådåddjå:e,"xn--brum-voa":e,bærum:e,bahcavuotna:e,"xn--bhcavuotna-s4a":e,báhcavuotna:e,bahccavuotna:e,"xn--bhccavuotna-k7a":e,báhccavuotna:e,baidar:e,"xn--bidr-5nac":e,báidár:e,bajddar:e,"xn--bjddar-pta":e,bájddar:e,balat:e,"xn--blt-elab":e,bálát:e,balestrand:e,ballangen:e,balsfjord:e,bamble:e,bardu:e,barum:e,batsfjord:e,"xn--btsfjord-9za":e,båtsfjord:e,bearalvahki:e,"xn--bearalvhki-y4a":e,bearalváhki:e,beardu:e,beiarn:e,berg:e,bergen:e,berlevag:e,"xn--berlevg-jxa":e,berlevåg:e,bievat:e,"xn--bievt-0qa":e,bievát:e,bindal:e,birkenes:e,bjarkoy:e,"xn--bjarky-fya":e,bjarkøy:e,bjerkreim:e,bjugn:e,bodo:e,"xn--bod-2na":e,bodø:e,bokn:e,bomlo:e,"xn--bmlo-gra":e,bømlo:e,bremanger:e,bronnoy:e,"xn--brnny-wuac":e,brønnøy:e,budejju:e,buskerud:p,bygland:e,bykle:e,cahcesuolo:e,"xn--hcesuolo-7ya35b":e,čáhcesuolo:e,davvenjarga:e,"xn--davvenjrga-y4a":e,davvenjárga:e,davvesiida:e,deatnu:e,dielddanuorri:e,divtasvuodna:e,divttasvuotna:e,
donna:e,"xn--dnna-gra":e,dønna:e,dovre:e,drammen:e,drangedal:e,dyroy:e,"xn--dyry-ira":e,dyrøy:e,eid:e,eidfjord:e,eidsberg:e,eidskog:e,eidsvoll:e,eigersund:e,elverum:e,enebakk:e,engerdal:e,etne:e,etnedal:e,evenassi:e,"xn--eveni-0qa01ga":e,evenášši:e,evenes:e,"evje-og-hornnes":e,farsund:e,fauske:e,fedje:e,fet:e,finnoy:e,"xn--finny-yua":e,finnøy:e,fitjar:e,fjaler:e,fjell:e,fla:e,"xn--fl-zia":e,flå:e,flakstad:e,flatanger:e,flekkefjord:e,flesberg:e,flora:e,folldal:e,forde:e,"xn--frde-gra":e,førde:e,forsand:e,fosnes:e,"xn--frna-woa":e,fræna:e,frana:e,frei:e,frogn:e,froland:e,frosta:e,froya:e,"xn--frya-hra":e,frøya:e,fuoisku:e,fuossko:e,fusa:e,fyresdal:e,gaivuotna:e,"xn--givuotna-8ya":e,gáivuotna:e,galsa:e,"xn--gls-elac":e,gálsá:e,gamvik:e,gangaviika:e,"xn--ggaviika-8ya47h":e,gáŋgaviika:e,gaular:e,gausdal:e,giehtavuoatna:e,gildeskal:e,"xn--gildeskl-g0a":e,gildeskål:e,giske:e,gjemnes:e,gjerdrum:e,gjerstad:e,gjesdal:e,gjovik:e,"xn--gjvik-wua":e,gjøvik:e,gloppen:e,gol:e,gran:e,grane:e,
granvin:e,gratangen:e,grimstad:e,grong:e,grue:e,gulen:e,guovdageaidnu:e,ha:e,"xn--h-2fa":e,hå:e,habmer:e,"xn--hbmer-xqa":e,hábmer:e,hadsel:e,"xn--hgebostad-g3a":e,hægebostad:e,hagebostad:e,halden:e,halsa:e,hamar:e,hamaroy:e,hammarfeasta:e,"xn--hmmrfeasta-s4ac":e,hámmárfeasta:e,hammerfest:e,hapmir:e,"xn--hpmir-xqa":e,hápmir:e,haram:e,hareid:e,harstad:e,hasvik:e,hattfjelldal:e,haugesund:e,hedmark:[0,{os:e,valer:e,"xn--vler-qoa":e,våler:e}],hemne:e,hemnes:e,hemsedal:e,hitra:e,hjartdal:e,hjelmeland:e,hobol:e,"xn--hobl-ira":e,hobøl:e,hof:e,hol:e,hole:e,holmestrand:e,holtalen:e,"xn--holtlen-hxa":e,holtålen:e,hordaland:[0,{os:e}],hornindal:e,horten:e,hoyanger:e,"xn--hyanger-q1a":e,høyanger:e,hoylandet:e,"xn--hylandet-54a":e,høylandet:e,hurdal:e,hurum:e,hvaler:e,hyllestad:e,ibestad:e,inderoy:e,"xn--indery-fya":e,inderøy:e,iveland:e,ivgu:e,jevnaker:e,jolster:e,"xn--jlster-bya":e,jølster:e,jondal:e,kafjord:e,"xn--kfjord-iua":e,kåfjord:e,karasjohka:e,"xn--krjohka-hwab49j":e,kárášjohka:e,
karasjok:e,karlsoy:e,karmoy:e,"xn--karmy-yua":e,karmøy:e,kautokeino:e,klabu:e,"xn--klbu-woa":e,klæbu:e,klepp:e,kongsberg:e,kongsvinger:e,kraanghke:e,"xn--kranghke-b0a":e,kråanghke:e,kragero:e,"xn--krager-gya":e,kragerø:e,kristiansand:e,kristiansund:e,krodsherad:e,"xn--krdsherad-m8a":e,krødsherad:e,"xn--kvfjord-nxa":e,kvæfjord:e,"xn--kvnangen-k0a":e,kvænangen:e,kvafjord:e,kvalsund:e,kvam:e,kvanangen:e,kvinesdal:e,kvinnherad:e,kviteseid:e,kvitsoy:e,"xn--kvitsy-fya":e,kvitsøy:e,laakesvuemie:e,"xn--lrdal-sra":e,lærdal:e,lahppi:e,"xn--lhppi-xqa":e,láhppi:e,lardal:e,larvik:e,lavagis:e,lavangen:e,leangaviika:e,"xn--leagaviika-52b":e,leaŋgaviika:e,lebesby:e,leikanger:e,leirfjord:e,leka:e,leksvik:e,lenvik:e,lerdal:e,lesja:e,levanger:e,lier:e,lierne:e,lillehammer:e,lillesand:e,lindas:e,"xn--linds-pra":e,lindås:e,lindesnes:e,loabat:e,"xn--loabt-0qa":e,loabát:e,lodingen:e,"xn--ldingen-q1a":e,lødingen:e,lom:e,loppa:e,lorenskog:e,"xn--lrenskog-54a":e,lørenskog:e,loten:e,"xn--lten-gra":e,
løten:e,lund:e,lunner:e,luroy:e,"xn--lury-ira":e,lurøy:e,luster:e,lyngdal:e,lyngen:e,malatvuopmi:e,"xn--mlatvuopmi-s4a":e,málatvuopmi:e,malselv:e,"xn--mlselv-iua":e,målselv:e,malvik:e,mandal:e,marker:e,marnardal:e,masfjorden:e,masoy:e,"xn--msy-ula0h":e,måsøy:e,"matta-varjjat":e,"xn--mtta-vrjjat-k7af":e,"mátta-várjjat":e,meland:e,meldal:e,melhus:e,meloy:e,"xn--mely-ira":e,meløy:e,meraker:e,"xn--merker-kua":e,meråker:e,midsund:e,"midtre-gauldal":e,moareke:e,"xn--moreke-jua":e,moåreke:e,modalen:e,modum:e,molde:e,"more-og-romsdal":[0,{heroy:e,sande:e}],"xn--mre-og-romsdal-qqb":[0,{"xn--hery-ira":e,sande:e}],"møre-og-romsdal":[0,{herøy:e,sande:e}],moskenes:e,moss:e,mosvik:e,muosat:e,"xn--muost-0qa":e,muosát:e,naamesjevuemie:e,"xn--nmesjevuemie-tcba":e,nååmesjevuemie:e,"xn--nry-yla5g":e,nærøy:e,namdalseid:e,namsos:e,namsskogan:e,nannestad:e,naroy:e,narviika:e,narvik:e,naustdal:e,navuotna:e,"xn--nvuotna-hwa":e,návuotna:e,"nedre-eiker":e,nesna:e,nesodden:e,nesseby:e,nesset:e,
nissedal:e,nittedal:e,"nord-aurdal":e,"nord-fron":e,"nord-odal":e,norddal:e,nordkapp:e,nordland:[0,{bo:e,"xn--b-5ga":e,bø:e,heroy:e,"xn--hery-ira":e,herøy:e}],"nordre-land":e,nordreisa:e,"nore-og-uvdal":e,notodden:e,notteroy:e,"xn--nttery-byae":e,nøtterøy:e,odda:e,oksnes:e,"xn--ksnes-uua":e,øksnes:e,omasvuotna:e,oppdal:e,oppegard:e,"xn--oppegrd-ixa":e,oppegård:e,orkdal:e,orland:e,"xn--rland-uua":e,ørland:e,orskog:e,"xn--rskog-uua":e,ørskog:e,orsta:e,"xn--rsta-fra":e,ørsta:e,osen:e,osteroy:e,"xn--ostery-fya":e,osterøy:e,ostfold:[0,{valer:e}],"xn--stfold-9xa":[0,{"xn--vler-qoa":e}],østfold:[0,{våler:e}],"ostre-toten":e,"xn--stre-toten-zcb":e,"østre-toten":e,overhalla:e,"ovre-eiker":e,"xn--vre-eiker-k8a":e,"øvre-eiker":e,oyer:e,"xn--yer-zna":e,øyer:e,oygarden:e,"xn--ygarden-p1a":e,øygarden:e,"oystre-slidre":e,"xn--ystre-slidre-ujb":e,"øystre-slidre":e,porsanger:e,porsangu:e,"xn--porsgu-sta26f":e,porsáŋgu:e,porsgrunn:e,rade:e,"xn--rde-ula":e,råde:e,radoy:e,"xn--rady-ira":e,
radøy:e,"xn--rlingen-mxa":e,rælingen:e,rahkkeravju:e,"xn--rhkkervju-01af":e,ráhkkerávju:e,raisa:e,"xn--risa-5na":e,ráisa:e,rakkestad:e,ralingen:e,rana:e,randaberg:e,rauma:e,rendalen:e,rennebu:e,rennesoy:e,"xn--rennesy-v1a":e,rennesøy:e,rindal:e,ringebu:e,ringerike:e,ringsaker:e,risor:e,"xn--risr-ira":e,risør:e,rissa:e,roan:e,rodoy:e,"xn--rdy-0nab":e,rødøy:e,rollag:e,romsa:e,romskog:e,"xn--rmskog-bya":e,rømskog:e,roros:e,"xn--rros-gra":e,røros:e,rost:e,"xn--rst-0na":e,røst:e,royken:e,"xn--ryken-vua":e,røyken:e,royrvik:e,"xn--ryrvik-bya":e,røyrvik:e,ruovat:e,rygge:e,salangen:e,salat:e,"xn--slat-5na":e,sálat:e,"xn--slt-elab":e,sálát:e,saltdal:e,samnanger:e,sandefjord:e,sandnes:e,sandoy:e,"xn--sandy-yua":e,sandøy:e,sarpsborg:e,sauda:e,sauherad:e,sel:e,selbu:e,selje:e,seljord:e,siellak:e,sigdal:e,siljan:e,sirdal:e,skanit:e,"xn--sknit-yqa":e,skánit:e,skanland:e,"xn--sknland-fxa":e,skånland:e,skaun:e,skedsmo:e,ski:e,skien:e,skierva:e,"xn--skierv-uta":e,skiervá:e,skiptvet:e,
skjak:e,"xn--skjk-soa":e,skjåk:e,skjervoy:e,"xn--skjervy-v1a":e,skjervøy:e,skodje:e,smola:e,"xn--smla-hra":e,smøla:e,snaase:e,"xn--snase-nra":e,snåase:e,snasa:e,"xn--snsa-roa":e,snåsa:e,snillfjord:e,snoasa:e,sogndal:e,sogne:e,"xn--sgne-gra":e,søgne:e,sokndal:e,sola:e,solund:e,somna:e,"xn--smna-gra":e,sømna:e,"sondre-land":e,"xn--sndre-land-0cb":e,"søndre-land":e,songdalen:e,"sor-aurdal":e,"xn--sr-aurdal-l8a":e,"sør-aurdal":e,"sor-fron":e,"xn--sr-fron-q1a":e,"sør-fron":e,"sor-odal":e,"xn--sr-odal-q1a":e,"sør-odal":e,"sor-varanger":e,"xn--sr-varanger-ggb":e,"sør-varanger":e,sorfold:e,"xn--srfold-bya":e,sørfold:e,sorreisa:e,"xn--srreisa-q1a":e,sørreisa:e,sortland:e,sorum:e,"xn--srum-gra":e,sørum:e,spydeberg:e,stange:e,stavanger:e,steigen:e,steinkjer:e,stjordal:e,"xn--stjrdal-s1a":e,stjørdal:e,stokke:e,"stor-elvdal":e,stord:e,stordal:e,storfjord:e,strand:e,stranda:e,stryn:e,sula:e,suldal:e,sund:e,sunndal:e,surnadal:e,sveio:e,svelvik:e,sykkylven:e,tana:e,telemark:[0,{bo:e,"x\
n--b-5ga":e,bø:e}],time:e,tingvoll:e,tinn:e,tjeldsund:e,tjome:e,"xn--tjme-hra":e,tjøme:e,tokke:e,tolga:e,tonsberg:e,"xn--tnsberg-q1a":e,tønsberg:e,torsken:e,"xn--trna-woa":e,træna:e,trana:e,tranoy:e,"xn--trany-yua":e,tranøy:e,troandin:e,trogstad:e,"xn--trgstad-r1a":e,trøgstad:e,tromsa:e,tromso:e,"xn--troms-zua":e,tromsø:e,trondheim:e,trysil:e,tvedestrand:e,tydal:e,tynset:e,tysfjord:e,tysnes:e,"xn--tysvr-vra":e,tysvær:e,tysvar:e,ullensaker:e,ullensvang:e,ulvik:e,unjarga:e,"xn--unjrga-rta":e,unjárga:e,utsira:e,vaapste:e,vadso:e,"xn--vads-jra":e,vadsø:e,"xn--vry-yla5g":e,værøy:e,vaga:e,"xn--vg-yiab":e,vågå:e,vagan:e,"xn--vgan-qoa":e,vågan:e,vagsoy:e,"xn--vgsy-qoa0j":e,vågsøy:e,vaksdal:e,valle:e,vang:e,vanylven:e,vardo:e,"xn--vard-jra":e,vardø:e,varggat:e,"xn--vrggt-xqad":e,várggát:e,varoy:e,vefsn:e,vega:e,vegarshei:e,"xn--vegrshei-c0a":e,vegårshei:e,vennesla:e,verdal:e,verran:e,vestby:e,vestfold:[0,{sande:e}],vestnes:e,"vestre-slidre":e,"vestre-toten":e,vestvagoy:e,"x\
n--vestvgy-ixa6o":e,vestvågøy:e,vevelstad:e,vik:e,vikna:e,vindafjord:e,voagat:e,volda:e,voss:e}],np:a,nr:u,nu:e,nz:[1,{ac:e,co:e,cri:e,geek:e,gen:e,govt:e,health:e,iwi:e,kiwi:e,maori:e,"xn--mori-qsa":e,māori:e,mil:e,net:e,org:e,parliament:e,school:e}],om:[1,{co:e,com:e,edu:e,gov:e,med:e,museum:e,net:e,org:e,pro:e}],onion:e,org:e,pa:[1,{abo:e,ac:e,com:e,edu:e,gob:e,ing:e,med:e,net:e,nom:e,org:e,sld:e}],pe:[1,{com:e,edu:e,gob:e,mil:e,net:e,nom:e,org:e}],pf:[1,{com:e,edu:e,org:e}],pg:a,ph:[1,{com:e,edu:e,gov:e,i:e,mil:e,net:e,ngo:e,org:e}],pk:[1,{ac:e,biz:e,com:e,edu:e,fam:e,gkp:e,gob:e,gog:e,gok:e,gop:e,gos:e,gov:e,net:e,org:e,web:e}],pl:[1,{com:e,net:e,org:e,agro:e,aid:e,atm:e,auto:e,biz:e,edu:e,gmina:e,gsm:e,info:e,mail:e,media:e,miasta:e,mil:e,nieruchomosci:e,nom:e,pc:e,powiat:e,priv:e,realestate:e,rel:e,sex:e,shop:e,sklep:e,sos:e,szkola:e,targi:e,tm:e,tourism:e,travel:e,turystyka:e,gov:[1,{ap:e,griw:e,ic:e,is:e,kmpsp:e,konsulat:e,kppsp:e,kwp:e,kwpsp:e,mup:e,mw:e,oia:e,oirm:e,oke:e,
oow:e,oschr:e,oum:e,pa:e,pinb:e,piw:e,po:e,pr:e,psp:e,psse:e,pup:e,rzgw:e,sa:e,sdn:e,sko:e,so:e,sr:e,starostwo:e,ug:e,ugim:e,um:e,umig:e,upow:e,uppo:e,us:e,uw:e,uzs:e,wif:e,wiih:e,winb:e,wios:e,witd:e,wiw:e,wkz:e,wsa:e,wskr:e,wsse:e,wuoz:e,wzmiuw:e,zp:e,zpisdn:e}],augustow:e,"babia-gora":e,bedzin:e,beskidy:e,bialowieza:e,bialystok:e,bielawa:e,bieszczady:e,boleslawiec:e,bydgoszcz:e,bytom:e,cieszyn:e,czeladz:e,czest:e,dlugoleka:e,elblag:e,elk:e,glogow:e,gniezno:e,gorlice:e,grajewo:e,ilawa:e,jaworzno:e,"jelenia-gora":e,jgora:e,kalisz:e,karpacz:e,kartuzy:e,kaszuby:e,katowice:e,"kazimierz-dolny":e,kepno:e,ketrzyn:e,klodzko:e,kobierzyce:e,kolobrzeg:e,konin:e,konskowola:e,kutno:e,lapy:e,lebork:e,legnica:e,lezajsk:e,limanowa:e,lomza:e,lowicz:e,lubin:e,lukow:e,malbork:e,malopolska:e,mazowsze:e,mazury:e,mielec:e,mielno:e,mragowo:e,naklo:e,nowaruda:e,nysa:e,olawa:e,olecko:e,olkusz:e,olsztyn:e,opoczno:e,opole:e,ostroda:e,ostroleka:e,ostrowiec:e,ostrowwlkp:e,pila:e,pisz:e,podhale:e,podlasie:e,polkowice:e,
pomorskie:e,pomorze:e,prochowice:e,pruszkow:e,przeworsk:e,pulawy:e,radom:e,"rawa-maz":e,rybnik:e,rzeszow:e,sanok:e,sejny:e,skoczow:e,slask:e,slupsk:e,sosnowiec:e,"stalowa-wola":e,starachowice:e,stargard:e,suwalki:e,swidnica:e,swiebodzin:e,swinoujscie:e,szczecin:e,szczytno:e,tarnobrzeg:e,tgory:e,turek:e,tychy:e,ustka:e,walbrzych:e,warmia:e,warszawa:e,waw:e,wegrow:e,wielun:e,wlocl:e,wloclawek:e,wodzislaw:e,wolomin:e,wroclaw:e,zachpomor:e,zagan:e,zarow:e,zgora:e,zgorzelec:e}],pm:e,pn:[1,{co:e,edu:e,gov:e,net:e,org:e}],post:e,pr:[1,{biz:e,com:e,edu:e,gov:e,info:e,isla:e,name:e,net:e,org:e,pro:e,ac:e,est:e,prof:e}],pro:[1,{aaa:e,aca:e,acct:e,avocat:e,bar:e,cpa:e,eng:e,jur:e,law:e,med:e,recht:e}],ps:[1,{com:e,edu:e,gov:e,net:e,org:e,plo:e,sec:e}],pt:[1,{com:e,edu:e,gov:e,int:e,net:e,nome:e,org:e,publ:e}],pw:r,py:[1,{com:e,coop:e,edu:e,gov:e,mil:e,net:e,org:e}],qa:[1,{com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e,sch:e}],re:[1,{asso:e,com:e}],ro:[1,{arts:e,com:e,firm:e,info:e,nom:e,nt:e,org:e,rec:e,
store:e,tm:e,www:e}],rs:[1,{ac:e,co:e,edu:e,gov:e,in:e,org:e}],ru:e,rw:[1,{ac:e,co:e,coop:e,gov:e,mil:e,net:e,org:e}],sa:[1,{com:e,edu:e,gov:e,med:e,net:e,org:e,pub:e,sch:e}],sb:n,sc:n,sd:[1,{com:e,edu:e,gov:e,info:e,med:e,net:e,org:e,tv:e}],se:[1,{a:e,ac:e,b:e,bd:e,brand:e,c:e,d:e,e,f:e,fh:e,fhsk:e,fhv:e,g:e,h:e,i:e,k:e,komforb:e,kommunalforbund:e,komvux:e,l:e,lanbib:e,m:e,n:e,naturbruksgymn:e,o:e,org:e,p:e,parti:e,pp:e,press:e,r:e,s:e,t:e,tm:e,u:e,w:e,x:e,y:e,z:e}],sg:n,sh:[1,{com:e,gov:e,mil:e,net:e,org:e}],si:e,sj:e,sk:e,sl:n,sm:e,sn:[1,{art:e,com:e,edu:e,gouv:e,org:e,perso:e,univ:e}],so:[1,{com:e,edu:e,gov:e,me:e,net:e,org:e}],sr:e,ss:[1,{biz:e,co:e,com:e,edu:e,gov:e,me:e,net:e,org:e,sch:e}],st:[1,{co:e,com:e,consulado:e,edu:e,embaixada:e,mil:e,net:e,org:e,principe:e,saotome:e,store:e}],su:e,sv:[1,{com:e,edu:e,gob:e,org:e,red:e}],sx:r,sy:t,sz:[1,{ac:e,co:e,org:e}],tc:e,td:e,tel:e,tf:e,tg:e,th:[1,{ac:e,co:e,go:e,in:e,mi:e,net:e,or:e}],tj:[1,{ac:e,biz:e,co:e,com:e,edu:e,go:e,gov:e,int:e,
mil:e,name:e,net:e,nic:e,org:e,test:e,web:e}],tk:e,tl:r,tm:l,tn:[1,{com:e,ens:e,fin:e,gov:e,ind:e,info:e,intl:e,mincom:e,nat:e,net:e,org:e,perso:e,tourism:e}],to:t,tr:[1,{av:e,bbs:e,bel:e,biz:e,com:e,dr:e,edu:e,gen:e,gov:e,info:e,k12:e,kep:e,mil:e,name:e,net:e,org:e,pol:e,tel:e,tsk:e,tv:e,web:e,nc:r}],tt:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],tv:e,tw:[1,{club:e,com:e,ebiz:e,edu:e,game:e,gov:e,idv:e,mil:e,net:e,org:e}],tz:[1,{ac:e,co:e,go:e,hotel:e,info:e,me:e,mil:e,mobi:e,ne:e,or:e,sc:e,tv:e}],ua:[1,{com:e,edu:e,gov:e,in:e,net:e,org:e,cherkassy:e,cherkasy:e,chernigov:e,chernihiv:e,chernivtsi:e,chernovtsy:e,ck:e,cn:e,cr:e,crimea:e,cv:e,dn:e,dnepropetrovsk:e,dnipropetrovsk:e,donetsk:e,dp:e,if:e,"ivano-frankivsk":e,kh:e,kharkiv:e,kharkov:e,kherson:e,khmelnitskiy:e,khmelnytskyi:e,kiev:e,kirovograd:e,km:e,kr:e,kropyvnytskyi:e,krym:e,ks:e,kv:e,kyiv:e,lg:e,lt:e,lugansk:e,luhansk:e,lutsk:e,lv:e,lviv:e,mk:e,mykolaiv:e,nikolaev:e,od:e,odesa:e,odessa:e,pl:e,poltava:e,
rivne:e,rovno:e,rv:e,sb:e,sebastopol:e,sevastopol:e,sm:e,sumy:e,te:e,ternopil:e,uz:e,uzhgorod:e,uzhhorod:e,vinnica:e,vinnytsia:e,vn:e,volyn:e,yalta:e,zakarpattia:e,zaporizhzhe:e,zaporizhzhia:e,zhitomir:e,zhytomyr:e,zp:e,zt:e}],ug:[1,{ac:e,co:e,com:e,edu:e,go:e,gov:e,mil:e,ne:e,or:e,org:e,sc:e,us:e}],uk:[1,{ac:e,co:e,gov:e,ltd:e,me:e,net:e,nhs:e,org:e,plc:e,police:e,sch:a}],us:[1,{dni:e,isa:e,nsn:e,ak:f,al:f,ar:f,as:f,az:f,ca:f,co:f,ct:f,dc:f,de:h,fl:f,ga:f,gu:f,hi:y,ia:f,id:f,il:f,in:f,ks:f,ky:f,la:f,ma:[1,{k12:[1,{chtr:e,paroch:e,pvt:e}],cc:e,lib:e}],md:f,me:f,mi:[1,{k12:e,cc:e,lib:e,"ann-arbor":e,cog:e,dst:e,eaton:e,gen:e,mus:e,tec:e,washtenaw:e}],mn:f,mo:f,ms:[1,{k12:e,cc:e}],mt:f,nc:f,nd:y,ne:f,nh:f,nj:f,nm:f,nv:f,ny:f,oh:f,ok:f,or:f,pa:f,pr:f,ri:y,sc:f,sd:y,tn:f,tx:f,ut:f,va:f,vi:f,vt:f,wa:f,wi:f,wv:h,wy:f}],uy:[1,{com:e,edu:e,gub:e,mil:e,net:e,org:e}],uz:[1,{co:e,com:e,net:e,org:e}],va:e,vc:t,ve:[1,{arts:e,bib:e,co:e,com:e,e12:e,edu:e,emprende:e,firm:e,gob:e,gov:e,info:e,int:e,mil:e,
net:e,nom:e,org:e,rar:e,rec:e,store:e,tec:e,web:e}],vg:[1,{edu:e}],vi:[1,{co:e,com:e,k12:e,net:e,org:e}],vn:[1,{ac:e,ai:e,biz:e,com:e,edu:e,gov:e,health:e,id:e,info:e,int:e,io:e,name:e,net:e,org:e,pro:e,angiang:e,bacgiang:e,backan:e,baclieu:e,bacninh:e,"baria-vungtau":e,bentre:e,binhdinh:e,binhduong:e,binhphuoc:e,binhthuan:e,camau:e,cantho:e,caobang:e,daklak:e,daknong:e,danang:e,dienbien:e,dongnai:e,dongthap:e,gialai:e,hagiang:e,haiduong:e,haiphong:e,hanam:e,hanoi:e,hatinh:e,haugiang:e,hoabinh:e,hungyen:e,khanhhoa:e,kiengiang:e,kontum:e,laichau:e,lamdong:e,langson:e,laocai:e,longan:e,namdinh:e,nghean:e,ninhbinh:e,ninhthuan:e,phutho:e,phuyen:e,quangbinh:e,quangnam:e,quangngai:e,quangninh:e,quangtri:e,soctrang:e,sonla:e,tayninh:e,thaibinh:e,thainguyen:e,thanhhoa:e,thanhphohochiminh:e,thuathienhue:e,tiengiang:e,travinh:e,tuyenquang:e,vinhlong:e,vinhphuc:e,yenbai:e}],vu:s,wf:e,ws:n,yt:e,"xn--mgbaam7a8h":e,امارات:e,"xn--y9a3aq":e,հայ:e,"xn--54b7fta0cc":e,বাংলা:e,"xn--90ae":e,
бг:e,"xn--mgbcpq6gpa1a":e,البحرين:e,"xn--90ais":e,бел:e,"xn--fiqs8s":e,中国:e,"xn--fiqz9s":e,中國:e,"xn--lgbbat1ad8j":e,الجزائر:e,"xn--wgbh1c":e,مصر:e,"xn--e1a4c":e,ею:e,"xn--qxa6a":e,ευ:e,"xn--mgbah1a3hjkrd":e,موريتانيا:e,"xn--node":e,გე:e,"xn--qxam":e,ελ:e,"xn--j6w193g":[1,{"xn--gmqw5a":e,"xn--55qx5d":e,"xn--mxtq1m":e,"xn--wcvs22d":e,"xn--uc0atv":e,"xn--od0alg":e}],香港:[1,{個人:e,公司:e,政府:e,教育:e,組織:e,網絡:e}],"xn--2scrj9c":e,ಭಾರತ:e,"xn--3hcrj9c":e,ଭାରତ:e,"xn--45br5cyl":e,ভাৰত:e,"xn--h2breg3eve":e,भारतम्:e,"xn--h2brj9c8c":e,भारोत:e,"xn--mgbgu82a":e,ڀارت:e,"xn--rvc1e0am3e":e,ഭാരതം:e,"xn--h2brj9c":e,भारत:e,"xn--mgbbh1a":e,بارت:e,"xn--mgbbh1a71e":e,بھارت:e,"xn--fpcrj9c3d":e,భారత్:e,"xn--gecrj9c":e,ભારત:e,"xn--s9brj9c":e,ਭਾਰਤ:e,"xn--45brj9c":e,ভারত:e,"xn--xkc2dl3a5ee0h":e,இந்தியா:e,"xn--mgba3a4f16a":e,
ایران:e,"xn--mgba3a4fra":e,ايران:e,"xn--mgbtx2b":e,عراق:e,"xn--mgbayh7gpa":e,الاردن:e,"xn--3e0b707e":e,한국:e,"xn--80ao21a":e,қаз:e,"xn--q7ce6a":e,ລາວ:e,"xn--fzc2c9e2c":e,ලංකා:e,"xn--xkc2al3hye2a":e,இலங்கை:e,"xn--mgbc0a9azcg":e,المغرب:e,"xn--d1alf":e,мкд:e,"xn--l1acc":e,мон:e,"xn--mix891f":e,澳門:e,"xn--mix082f":e,澳门:e,"xn--mgbx4cd0ab":e,مليسيا:e,"xn--mgb9awbf":e,عمان:e,"xn--mgbai9azgqp6j":e,پاکستان:e,"xn--mgbai9a5eva00b":e,پاكستان:e,"xn--ygbi2ammx":e,فلسطين:e,"xn--90a3ac":[1,{"xn--80au":e,"xn--90azh":e,"xn--d1at":e,"xn--c1avg":e,"xn--o1ac":e,"xn--o1ach":e}],срб:[1,{ак:e,обр:e,од:e,орг:e,пр:e,упр:e}],"xn--p1ai":e,рф:e,"xn--wgbl6a":e,قطر:e,"xn--mgberp4a5d4ar":e,السعودية:e,"xn--mgberp4a5d4a87g":e,السعودیة:e,"xn--mgbqly7c0a67fbc":e,السعودیۃ:e,"xn--mgbqly7cvafr":e,السعوديه:e,"xn--mgbpl2fh":e,سودان:e,"xn--yfro4i67o":e,新加坡:e,"xn-\
-clchc0ea0b2g2a9gcd":e,சிங்கப்பூர்:e,"xn--ogbpf8fl":e,سورية:e,"xn--mgbtf8fl":e,سوريا:e,"xn--o3cw4h":[1,{"xn--o3cyx2a":e,"xn--12co0c3b4eva":e,"xn--m3ch0j3a":e,"xn--h3cuzk1di":e,"xn--12c1fe0br":e,"xn--12cfi8ixb8l":e}],ไทย:[1,{ทหาร:e,ธุรกิจ:e,เน็ต:e,รัฐบาล:e,ศึกษา:e,องค์กร:e}],"xn--pgbs0dh":e,تونس:e,"xn--kpry57d":e,台灣:e,"xn--kprw13d":e,台湾:e,"xn--nnx388a":e,臺灣:e,"xn--j1amh":e,укр:e,"xn--mgb2ddes":e,اليمن:e,xxx:e,ye:t,za:[0,{ac:e,agric:e,alt:e,co:e,edu:e,gov:e,grondar:e,law:e,mil:e,net:e,ngo:e,nic:e,nis:e,nom:e,org:e,school:e,tm:e,web:e}],zm:[1,{ac:e,biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,net:e,org:e,sch:e}],zw:[1,{ac:e,co:e,gov:e,mil:e,org:e}],aaa:e,aarp:e,abb:e,abbott:e,abbvie:e,abc:e,able:e,abogado:e,abudhabi:e,academy:e,accenture:e,accountant:e,accountants:e,aco:e,actor:e,ads:e,adult:e,aeg:e,aetna:e,afl:e,africa:e,agakhan:e,agency:e,aig:e,airbus:e,airforce:e,airtel:e,
akdn:e,alibaba:e,alipay:e,allfinanz:e,allstate:e,ally:e,alsace:e,alstom:e,amazon:e,americanexpress:e,americanfamily:e,amex:e,amfam:e,amica:e,amsterdam:e,analytics:e,android:e,anquan:e,anz:e,aol:e,apartments:e,app:e,apple:e,aquarelle:e,arab:e,aramco:e,archi:e,army:e,art:e,arte:e,asda:e,associates:e,athleta:e,attorney:e,auction:e,audi:e,audible:e,audio:e,auspost:e,author:e,auto:e,autos:e,aws:e,axa:e,azure:e,baby:e,baidu:e,banamex:e,band:e,bank:e,bar:e,barcelona:e,barclaycard:e,barclays:e,barefoot:e,bargains:e,baseball:e,basketball:e,bauhaus:e,bayern:e,bbc:e,bbt:e,bbva:e,bcg:e,bcn:e,beats:e,beauty:e,beer:e,berlin:e,best:e,bestbuy:e,bet:e,bharti:e,bible:e,bid:e,bike:e,bing:e,bingo:e,bio:e,black:e,blackfriday:e,blockbuster:e,blog:e,bloomberg:e,blue:e,bms:e,bmw:e,bnpparibas:e,boats:e,boehringer:e,bofa:e,bom:e,bond:e,boo:e,book:e,booking:e,bosch:e,bostik:e,boston:e,bot:e,boutique:e,box:e,bradesco:e,bridgestone:e,broadway:e,broker:e,brother:e,brussels:e,build:e,builders:e,business:e,buy:e,buzz:e,
bzh:e,cab:e,cafe:e,cal:e,call:e,calvinklein:e,cam:e,camera:e,camp:e,canon:e,capetown:e,capital:e,capitalone:e,car:e,caravan:e,cards:e,care:e,career:e,careers:e,cars:e,casa:e,case:e,cash:e,casino:e,catering:e,catholic:e,cba:e,cbn:e,cbre:e,center:e,ceo:e,cern:e,cfa:e,cfd:e,chanel:e,channel:e,charity:e,chase:e,chat:e,cheap:e,chintai:e,christmas:e,chrome:e,church:e,cipriani:e,circle:e,cisco:e,citadel:e,citi:e,citic:e,city:e,claims:e,cleaning:e,click:e,clinic:e,clinique:e,clothing:e,cloud:e,club:e,clubmed:e,coach:e,codes:e,coffee:e,college:e,cologne:e,commbank:e,community:e,company:e,compare:e,computer:e,comsec:e,condos:e,construction:e,consulting:e,contact:e,contractors:e,cooking:e,cool:e,corsica:e,country:e,coupon:e,coupons:e,courses:e,cpa:e,credit:e,creditcard:e,creditunion:e,cricket:e,crown:e,crs:e,cruise:e,cruises:e,cuisinella:e,cymru:e,cyou:e,dad:e,dance:e,data:e,date:e,dating:e,datsun:e,day:e,dclk:e,dds:e,deal:e,dealer:e,deals:e,degree:e,delivery:e,dell:e,deloitte:e,delta:e,democrat:e,
dental:e,dentist:e,desi:e,design:e,dev:e,dhl:e,diamonds:e,diet:e,digital:e,direct:e,directory:e,discount:e,discover:e,dish:e,diy:e,dnp:e,docs:e,doctor:e,dog:e,domains:e,dot:e,download:e,drive:e,dtv:e,dubai:e,dunlop:e,dupont:e,durban:e,dvag:e,dvr:e,earth:e,eat:e,eco:e,edeka:e,education:e,email:e,emerck:e,energy:e,engineer:e,engineering:e,enterprises:e,epson:e,equipment:e,ericsson:e,erni:e,esq:e,estate:e,eurovision:e,eus:e,events:e,exchange:e,expert:e,exposed:e,express:e,extraspace:e,fage:e,fail:e,fairwinds:e,faith:e,family:e,fan:e,fans:e,farm:e,farmers:e,fashion:e,fast:e,fedex:e,feedback:e,ferrari:e,ferrero:e,fidelity:e,fido:e,film:e,final:e,finance:e,financial:e,fire:e,firestone:e,firmdale:e,fish:e,fishing:e,fit:e,fitness:e,flickr:e,flights:e,flir:e,florist:e,flowers:e,fly:e,foo:e,food:e,football:e,ford:e,forex:e,forsale:e,forum:e,foundation:e,fox:e,free:e,fresenius:e,frl:e,frogans:e,frontier:e,ftr:e,fujitsu:e,fun:e,fund:e,furniture:e,futbol:e,fyi:e,gal:e,gallery:e,gallo:e,gallup:e,game:e,
games:e,gap:e,garden:e,gay:e,gbiz:e,gdn:e,gea:e,gent:e,genting:e,george:e,ggee:e,gift:e,gifts:e,gives:e,giving:e,glass:e,gle:e,global:e,globo:e,gmail:e,gmbh:e,gmo:e,gmx:e,godaddy:e,gold:e,goldpoint:e,golf:e,goo:e,goodyear:e,goog:e,google:e,gop:e,got:e,grainger:e,graphics:e,gratis:e,green:e,gripe:e,grocery:e,group:e,gucci:e,guge:e,guide:e,guitars:e,guru:e,hair:e,hamburg:e,hangout:e,haus:e,hbo:e,hdfc:e,hdfcbank:e,health:e,healthcare:e,help:e,helsinki:e,here:e,hermes:e,hiphop:e,hisamitsu:e,hitachi:e,hiv:e,hkt:e,hockey:e,holdings:e,holiday:e,homedepot:e,homegoods:e,homes:e,homesense:e,honda:e,horse:e,hospital:e,host:e,hosting:e,hot:e,hotel:e,hotels:e,hotmail:e,house:e,how:e,hsbc:e,hughes:e,hyatt:e,hyundai:e,ibm:e,icbc:e,ice:e,icu:e,ieee:e,ifm:e,ikano:e,imamat:e,imdb:e,immo:e,immobilien:e,inc:e,industries:e,infiniti:e,ing:e,ink:e,institute:e,insurance:e,insure:e,international:e,intuit:e,investments:e,ipiranga:e,irish:e,ismaili:e,ist:e,istanbul:e,itau:e,itv:e,jaguar:e,java:e,jcb:e,jeep:e,jetzt:e,
jewelry:e,jio:e,jll:e,jmp:e,jnj:e,joburg:e,jot:e,joy:e,jpmorgan:e,jprs:e,juegos:e,juniper:e,kaufen:e,kddi:e,kerryhotels:e,kerryproperties:e,kfh:e,kia:e,kids:e,kim:e,kindle:e,kitchen:e,kiwi:e,koeln:e,komatsu:e,kosher:e,kpmg:e,kpn:e,krd:e,kred:e,kuokgroup:e,kyoto:e,lacaixa:e,lamborghini:e,lamer:e,land:e,landrover:e,lanxess:e,lasalle:e,lat:e,latino:e,latrobe:e,law:e,lawyer:e,lds:e,lease:e,leclerc:e,lefrak:e,legal:e,lego:e,lexus:e,lgbt:e,lidl:e,life:e,lifeinsurance:e,lifestyle:e,lighting:e,like:e,lilly:e,limited:e,limo:e,lincoln:e,link:e,live:e,living:e,llc:e,llp:e,loan:e,loans:e,locker:e,locus:e,lol:e,london:e,lotte:e,lotto:e,love:e,lpl:e,lplfinancial:e,ltd:e,ltda:e,lundbeck:e,luxe:e,luxury:e,madrid:e,maif:e,maison:e,makeup:e,man:e,management:e,mango:e,map:e,market:e,marketing:e,markets:e,marriott:e,marshalls:e,mattel:e,mba:e,mckinsey:e,med:e,media:e,meet:e,melbourne:e,meme:e,memorial:e,men:e,menu:e,merck:e,merckmsd:e,miami:e,microsoft:e,mini:e,mint:e,mit:e,mitsubishi:e,mlb:e,mls:e,mma:e,
mobile:e,moda:e,moe:e,moi:e,mom:e,monash:e,money:e,monster:e,mormon:e,mortgage:e,moscow:e,moto:e,motorcycles:e,mov:e,movie:e,msd:e,mtn:e,mtr:e,music:e,nab:e,nagoya:e,navy:e,nba:e,nec:e,netbank:e,netflix:e,network:e,neustar:e,new:e,news:e,next:e,nextdirect:e,nexus:e,nfl:e,ngo:e,nhk:e,nico:e,nike:e,nikon:e,ninja:e,nissan:e,nissay:e,nokia:e,norton:e,now:e,nowruz:e,nowtv:e,nra:e,nrw:e,ntt:e,nyc:e,obi:e,observer:e,office:e,okinawa:e,olayan:e,olayangroup:e,ollo:e,omega:e,one:e,ong:e,onl:e,online:e,ooo:e,open:e,oracle:e,orange:e,organic:e,origins:e,osaka:e,otsuka:e,ott:e,ovh:e,page:e,panasonic:e,paris:e,pars:e,partners:e,parts:e,party:e,pay:e,pccw:e,pet:e,pfizer:e,pharmacy:e,phd:e,philips:e,phone:e,photo:e,photography:e,photos:e,physio:e,pics:e,pictet:e,pictures:e,pid:e,pin:e,ping:e,pink:e,pioneer:e,pizza:e,place:e,play:e,playstation:e,plumbing:e,plus:e,pnc:e,pohl:e,poker:e,politie:e,porn:e,praxi:e,press:e,prime:e,prod:e,productions:e,prof:e,progressive:e,promo:e,properties:e,property:e,protection:e,
pru:e,prudential:e,pub:e,pwc:e,qpon:e,quebec:e,quest:e,racing:e,radio:e,read:e,realestate:e,realtor:e,realty:e,recipes:e,red:e,redumbrella:e,rehab:e,reise:e,reisen:e,reit:e,reliance:e,ren:e,rent:e,rentals:e,repair:e,report:e,republican:e,rest:e,restaurant:e,review:e,reviews:e,rexroth:e,rich:e,richardli:e,ricoh:e,ril:e,rio:e,rip:e,rocks:e,rodeo:e,rogers:e,room:e,rsvp:e,rugby:e,ruhr:e,run:e,rwe:e,ryukyu:e,saarland:e,safe:e,safety:e,sakura:e,sale:e,salon:e,samsclub:e,samsung:e,sandvik:e,sandvikcoromant:e,sanofi:e,sap:e,sarl:e,sas:e,save:e,saxo:e,sbi:e,sbs:e,scb:e,schaeffler:e,schmidt:e,scholarships:e,school:e,schule:e,schwarz:e,science:e,scot:e,search:e,seat:e,secure:e,security:e,seek:e,select:e,sener:e,services:e,seven:e,sew:e,sex:e,sexy:e,sfr:e,shangrila:e,sharp:e,shell:e,shia:e,shiksha:e,shoes:e,shop:e,shopping:e,shouji:e,show:e,silk:e,sina:e,singles:e,site:e,ski:e,skin:e,sky:e,skype:e,sling:e,smart:e,smile:e,sncf:e,soccer:e,social:e,softbank:e,software:e,sohu:e,solar:e,solutions:e,song:e,
sony:e,soy:e,spa:e,space:e,sport:e,spot:e,srl:e,stada:e,staples:e,star:e,statebank:e,statefarm:e,stc:e,stcgroup:e,stockholm:e,storage:e,store:e,stream:e,studio:e,study:e,style:e,sucks:e,supplies:e,supply:e,support:e,surf:e,surgery:e,suzuki:e,swatch:e,swiss:e,sydney:e,systems:e,tab:e,taipei:e,talk:e,taobao:e,target:e,tatamotors:e,tatar:e,tattoo:e,tax:e,taxi:e,tci:e,tdk:e,team:e,tech:e,technology:e,temasek:e,tennis:e,teva:e,thd:e,theater:e,theatre:e,tiaa:e,tickets:e,tienda:e,tips:e,tires:e,tirol:e,tjmaxx:e,tjx:e,tkmaxx:e,tmall:e,today:e,tokyo:e,tools:e,top:e,toray:e,toshiba:e,total:e,tours:e,town:e,toyota:e,toys:e,trade:e,trading:e,training:e,travel:e,travelers:e,travelersinsurance:e,trust:e,trv:e,tube:e,tui:e,tunes:e,tushu:e,tvs:e,ubank:e,ubs:e,unicom:e,university:e,uno:e,uol:e,ups:e,vacations:e,vana:e,vanguard:e,vegas:e,ventures:e,verisign:e,versicherung:e,vet:e,viajes:e,video:e,vig:e,viking:e,villas:e,vin:e,vip:e,virgin:e,visa:e,vision:e,viva:e,vivo:e,vlaanderen:e,vodka:e,volvo:e,vote:e,
voting:e,voto:e,voyage:e,wales:e,walmart:e,walter:e,wang:e,wanggou:e,watch:e,watches:e,weather:e,weatherchannel:e,webcam:e,weber:e,website:e,wed:e,wedding:e,weibo:e,weir:e,whoswho:e,wien:e,wiki:e,williamhill:e,win:e,windows:e,wine:e,winners:e,wme:e,wolterskluwer:e,woodside:e,work:e,works:e,world:e,wow:e,wtc:e,wtf:e,xbox:e,xerox:e,xihuan:e,xin:e,"xn--11b4c3d":e,कॉम:e,"xn--1ck2e1b":e,セール:e,"xn--1qqw23a":e,佛山:e,"xn--30rr7y":e,慈善:e,"xn--3bst00m":e,集团:e,"xn--3ds443g":e,在线:e,"xn--3pxu8k":e,点看:e,"xn--42c2d9a":e,คอม:e,"xn--45q11c":e,八卦:e,"xn--4gbrim":e,موقع:e,"xn--55qw42g":e,公益:e,"xn--55qx5d":e,公司:e,"xn--5su34j936bgsg":e,香格里拉:e,"xn--5tzm5g":e,网站:e,"xn--6frz82g":e,移动:e,"xn--6qq986b3xl":e,我爱你:e,"xn--80adxhks":e,москва:e,"xn--80aqecdr1a":e,католик:e,"xn--80asehdb":e,онлайн:e,"xn--80aswg":e,сайт:e,"xn--8y0a063a":e,联通:e,"xn--9dbq2a":e,קום:e,"xn--9et52u":e,时尚:e,"xn--9krt00a":e,微博:e,"xn--\
b4w605ferd":e,淡马锡:e,"xn--bck1b9a5dre4c":e,ファッション:e,"xn--c1avg":e,орг:e,"xn--c2br7g":e,नेट:e,"xn--cck2b3b":e,ストア:e,"xn--cckwcxetd":e,アマゾン:e,"xn--cg4bki":e,삼성:e,"xn--czr694b":e,商标:e,"xn--czrs0t":e,商店:e,"xn--czru2d":e,商城:e,"xn--d1acj3b":e,дети:e,"xn--eckvdtc9d":e,ポイント:e,"xn--efvy88h":e,新闻:e,"xn--fct429k":e,家電:e,"xn--fhbei":e,كوم:e,"xn--fiq228c5hs":e,中文网:e,"xn--fiq64b":e,中信:e,"xn--fjq720a":e,娱乐:e,"xn--flw351e":e,谷歌:e,"xn--fzys8d69uvgm":e,電訊盈科:e,"xn--g2xx48c":e,购物:e,"xn--gckr3f0f":e,クラウド:e,"xn--gk3at1e":e,通販:e,"xn--hxt814e":e,网店:e,"xn--i1b6b1a6a2e":e,संगठन:e,"xn--imr513n":e,餐厅:e,"xn--io0a7i":e,网络:e,"xn--j1aef":e,ком:e,"xn--jlq480n2rg":e,亚马逊:e,"xn--jvr189m":e,食品:e,"xn--kcrx77d1x4a":e,飞利浦:e,"xn--kput3i":e,手机:e,"xn--mgba3a3ejt":e,ارامكو:e,"xn--mgba7c0bbn0a":e,العليان:e,"xn--mgbab2bd":e,بازار:e,"xn--mgbca7dzdo":e,
ابوظبي:e,"xn--mgbi4ecexp":e,كاثوليك:e,"xn--mgbt3dhd":e,همراه:e,"xn--mk1bu44c":e,닷컴:e,"xn--mxtq1m":e,政府:e,"xn--ngbc5azd":e,شبكة:e,"xn--ngbe9e0a":e,بيتك:e,"xn--ngbrx":e,عرب:e,"xn--nqv7f":e,机构:e,"xn--nqv7fs00ema":e,组织机构:e,"xn--nyqy26a":e,健康:e,"xn--otu796d":e,招聘:e,"xn--p1acf":e,рус:e,"xn--pssy2u":e,大拿:e,"xn--q9jyb4c":e,みんな:e,"xn--qcka1pmc":e,グーグル:e,"xn--rhqv96g":e,世界:e,"xn--rovu88b":e,書籍:e,"xn--ses554g":e,网址:e,"xn--t60b56a":e,닷넷:e,"xn--tckwe":e,コム:e,"xn--tiq49xqyj":e,天主教:e,"xn--unup4y":e,游戏:e,"xn--vermgensberater-ctb":e,vermögensberater:e,"xn--vermgensberatung-pwb":e,vermögensberatung:e,"xn--vhquv":e,企业:e,"xn--vuq861b":e,信息:e,"xn--w4r85el8fhu5dnra":e,嘉里大酒店:e,"xn--w4rs40l":e,嘉里:e,"xn--xhq521b":e,广东:e,"xn--zfr164b":e,政务:e,xyz:e,yachts:e,yahoo:e,yamaxun:e,yandex:e,yodobashi:e,yoga:e,yokohama:e,you:e,youtube:e,yun:e,zappos:e,zara:e,zero:e,zip:e,zone:e,zuerich:e}]})()});function v4(e,t,n){let r=null,a=t;for(;a!==void 0&&(a[0]===1&&(r={index:n+1}),n!==-1);){let o=a[1];a=Object.prototype.hasOwnProperty.call(o,e[n])?o[e[n]]:o["*"],n-=1}return r}function _T(e,t,n){var r;if(ig(e,t,n))return;let a=e.split("."),o=v4(a,h4,a.length-1);if(o!==null){n.publicSuffix=a.slice(o.index+1).join(".");return}let s=v4(a,g4,a.length-1);if(s!==null){n.publicSuffix=a.slice(s.index).join(".");return}n.publicSuffix=(r=a[a.length-1])!==null&&r!==void 0?r:null}var b4=g(()=>{d();RT();y4();i(v4,"lookupInTrie");i(_T,"suffixLookup")});function E4(e,t={}){return CT(w4),kT(e,3,_T,t,w4).domain}var w4,T4=g(()=>{d();RT();b4();w4=ST();i(E4,"getDomain")});var it,pue,x4,S4,z,fue,rn=g(()=>{"use strict";d();A();it={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",noLcp:"The page did not display content that qualifies as a Largest Contentful Paint (LCP). Ensure the page has a valid LCP element and then try again. ({errorCode})",pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL an\
d that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The \
page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results.",targetCrashed:"Browser tab has unexpectedly crashed."},pue=T("core/lib/lh-error.js",it),x4="__LighthouseErrorSentinel",S4="__ErrorSentinel",z=class e extends Error{static{i(this,"LighthouseError")}constructor(t,n,r){
super(t.code,r),this.name="LighthouseError",this.code=t.code,this.friendlyMessage=pue(t.message,{errorCode:this.code,...n}),this.lhrRuntimeError=!!t.lhrRuntimeError,n&&Object.assign(this,n),Error.captureStackTrace(this,e)}static fromProtocolMessage(t,n){let r=Object.values(e.errors).filter(s=>s.pattern).find(s=>s.pattern&&s.pattern.test(n.message));if(r)return new e(r);let a=`(${t}): ${n.message}`;n.data&&(a+=` (${n.data})`);let o=new Error(`Protocol error ${a}`);return Object.assign(o,{protocolMethod:t,protocolError:n.message})}static stringifyReplacer(t){if(t instanceof e){let{name:n,code:r,message:a,friendlyMessage:o,lhrRuntimeError:s,stack:c,cause:l,...u}=t;return{sentinel:x4,code:r,stack:c,cause:l,properties:u}}if(t instanceof Error){let{message:n,stack:r,cause:a}=t,o=t.code;return{sentinel:S4,message:n,code:o,stack:r,cause:a}}throw new Error("Invalid value for LighthouseError stringification")}static parseReviver(t,n){if(typeof n=="object"&&n!==null){if(n.sentinel===x4){let{code:r,
stack:a,cause:o,properties:s}=n,c=e.errors[r],l=new e(c,s,{cause:o});return l.stack=a,l}if(n.sentinel===S4){let{message:r,code:a,stack:o,cause:s}=n,c=s?{cause:s}:void 0,l=new Error(r,c);return Object.assign(l,{code:a,stack:o}),l}}return n}},fue={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:it.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:it.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:it.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:it.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:it.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:it.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:it.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:it.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:it.
badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:it.badTraceRecording},NO_LCP:{code:"NO_LCP",message:it.noLcp},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:it.noLcp},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:it.oldChromeDoesNotSupportFeature},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:it.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:it.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:it.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:it.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:it.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:it.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:it.pageLoadFailedInterstitial,
lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:it.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:it.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:it.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:it.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:it.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:it.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:it.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:it.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:it.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:it.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:it.erroredRequiredArtifact},
TARGET_CRASHED:{code:"TARGET_CRASHED",message:it.targetCrashed,lhrRuntimeError:!0}};z.errors=fue;z.NO_ERROR="NO_ERROR";z.UNKNOWN_ERROR="UNKNOWN_ERROR"});function bue(e){return!e||!e.startsWith("chrome://")?e:(e.endsWith("/")&&(e=e.replace(/\/$/,"")),e.replace(/^chrome:\/\/chrome\//,"chrome://"))}var hue,gue,yue,vue,sg,Ce,un=g(()=>{"use strict";d();T4();Zr();rn();hue=["https:","http:","chrome:","chrome-extension:"],gue=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],yue=["localhost","127.0.0.1"],vue=["blob","data","intent","file","filesystem","chrome-extension"];i(bue,"rewriteChromeInternalUrl");sg=class e{static{i(this,"UrlUtils")}static isValid(t){try{return new URL(t),!0}catch{return!1}}static hostsMatch(t,n){try{return new URL(t).host===new URL(n).host}catch{return!1}}static originsMatch(t,n){try{return new URL(t).origin===new URL(n).origin}catch{return!1}}static getOrigin(t){try{let n=new URL(t);return n.protocol==="chrome-extension:"?ot.getChromeExtensionOrigin(t):n.host&&n.origin||null}catch{return null}}static getRootDomain(t){let n=ot.createOrReturnURL(t);return E4(n.href)||n.hostname}static rootDomainsMatch(t,n){
let r,a;try{r=ot.createOrReturnURL(t),a=ot.createOrReturnURL(n)}catch{return!1}if(!r.hostname||!a.hostname)return!1;let o=e.getRootDomain(r),s=e.getRootDomain(a);return o===s}static getURLDisplayName(t,n){return ot.getURLDisplayName(new URL(t),n)}static elideDataURI(t){try{return new URL(t).protocol==="data:"?ot.truncate(t,100):t}catch{return t}}static equalWithExcludedFragments(t,n){[t,n]=[t,n].map(bue);try{let r=new URL(t);r.hash="";let a=new URL(n);return a.hash="",r.href===a.href}catch{return!1}}static isProtocolAllowed(t){try{let n=new URL(t);return hue.includes(n.protocol)}catch{return!1}}static isLikeLocalhost(t){return yue.includes(t)||t.endsWith(".localhost")}static isSecureScheme(t){return gue.includes(t)}static isNonNetworkProtocol(t){let n=t.includes(":")?t.slice(0,t.indexOf(":")):t;return vue.includes(n)}static guessMimeType(t){let n;try{n=new URL(t)}catch{return}if(n.protocol==="data:"){let o=n.pathname.match(/^(image\/(png|jpeg|svg\+xml|webp|gif|avif))[;,]/);return o?o[1]:
void 0}let r=n.pathname.toLowerCase().match(/\.(png|jpeg|jpg|svg|webp|gif|avif)$/);if(!r)return;let a=r[1];return a==="svg"?"image/svg+xml":a==="jpg"?"image/jpeg":`image/${a}`}static normalizeUrl(t){if(t&&this.isValid(t)&&this.isProtocolAllowed(t))return new URL(t).href;throw new z(z.errors.INVALID_URL)}};sg.INVALID_URL_DEBUG_STRING="Lighthouse was unable to determine the URL of some script executions. It's possible a Chrome extension or other eval'd code is the source.";Ce=sg});var C4,k4,R4,_4,I4,D4,A4,cg,lt,qr=g(()=>{"use strict";d();Cn();Jt();un();C4="X-TCPMs",k4="X-SSLMs",R4="X-RequestMs",_4="X-ResponseMs",I4="X-TotalMs",D4="X-TotalFetchedSize",A4="X-ProtocolIsH2",cg={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch",FedCM:"FedCM"},lt=class e{static{i(this,"NetworkRequest")}constructor(){this.requestId="",this.connectionId=0,this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.rendererStartTime=-1,this.networkRequestTime=-1,this.responseHeadersEndTime=-1,this.networkEndTime=-1,this.transferSize=0,this.responseHeadersTransferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.
fromMemoryCache=!1,this.fromPrefetchCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.sessionTargetType=void 0,this.fromWorker=!1,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(t){this.initiatorRequest=t}onRequestWillBeSent(t){this.requestId=t.requestId;let n;try{n=new URL(t.request.url)}catch{return}this.url=t.request.url,this.documentURL=t.documentURL,this.parsedURL={scheme:n.protocol.split(":")[0],host:n.hostname,securityOrigin:n.origin},this.isSecure=Ce.isSecureScheme(this.parsedURL.scheme),this.rendererStartTime=
t.timestamp*1e3,this.networkRequestTime=this.rendererStartTime,this.responseHeadersEndTime=this.rendererStartTime,this.requestMethod=t.request.method,this.initiator=t.initiator,this.resourceType=t.type&&cg[t.type],this.priority=t.request.initialPriority,this.frameId=t.frameId,this.isLinkPreload=t.initiator.type==="preload"||!!t.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(t){this._onResponse(t.response,t.timestamp,t.type),this._updateProtocolForLightrider(),this.frameId=t.frameId}onResponseReceivedExtraInfo(t){this.responseHeadersText=t.headersText||""}onDataReceived(t){this.resourceSize+=t.dataLength,t.encodedDataLength!==-1&&(this.transferSize+=t.encodedDataLength)}onLoadingFinished(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,t.encodedDataLength>=0&&(this.transferSize=t.encodedDataLength),this._updateResponseHeadersEndTimeIfNecessary(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onLoadingFailed(t){
this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,this.failed=!0,this.resourceType=t.type&&cg[t.type],this.localizedFailDescription=t.errorText,this._updateResponseHeadersEndTimeIfNecessary(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(t){this.priority=t.newPriority}onRedirectResponse(t){if(!t.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(t.redirectResponse,t.timestamp,t.type),this.resourceType=void 0,this.finished=!0,this.networkEndTime=t.timestamp*1e3,this._updateResponseHeadersEndTimeIfNecessary()}setSession(t){this.sessionId=t}get isOutOfProcessIframe(){return this.sessionTargetType==="iframe"}_onResponse(t,n,r){this.url=t.url,this.connectionId=t.connectionId,this.connectionReused=t.connectionReused,t.protocol&&(this.protocol=t.protocol),this.responseTimestamp=n*1e3,this.transferSize=t.encodedDataLength,this.responseHeadersTransferSize=t.encodedDataLength,typeof t.fromDiskCache==
"boolean"&&(this.fromDiskCache=t.fromDiskCache),typeof t.fromPrefetchCache=="boolean"&&(this.fromPrefetchCache=t.fromPrefetchCache),this.statusCode=t.status,this.timing=t.timing,r&&(this.resourceType=cg[r]),this.mimeType=t.mimeType,this.responseHeaders=e._headersDictToHeadersArray(t.headers),this.fetchedViaServiceWorker=!!t.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(t){if(t.requestTime===-1||t.receiveHeadersEnd===-1)return;this.networkRequestTime=t.requestTime*1e3;let n=this.networkRequestTime+t.receiveHeadersEnd;this.responseHeadersEndTime=n,this.responseTimestamp!==void 0&&(this.responseHeadersEndTime=Math.min(this.responseHeadersEndTime,this.responseTimestamp)),this.responseHeadersEndTime=Math.max(this.responseHeadersEndTime,this.networkRequestTime),this.networkEndTime=Math.max(this.networkEndTime,this.responseHeadersEndTime)}_updateResponseHeadersEndTimeIfNecessary(){
this.responseHeadersEndTime=Math.min(this.networkEndTime,this.responseHeadersEndTime)}_updateTransferSizeForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(r=>r.name===D4);if(!t)return;let n=parseFloat(t.value);isNaN(n)||(this.transferSize=n)}_updateProtocolForLightrider(){globalThis.isLightrider&&this.responseHeaders.some(t=>t.name===A4)&&(this.protocol="h2")}_updateTimingsForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(p=>p.name===I4);if(!t)return;let n=parseInt(t.value),r=this.responseHeaders.find(p=>p.name===C4),a=this.responseHeaders.find(p=>p.name===k4),o=this.responseHeaders.find(p=>p.name===R4),s=this.responseHeaders.find(p=>p.name===_4),c=r?Math.max(0,parseInt(r.value)):0,l=a?Math.max(0,parseInt(a.value)):0,u=o?Math.max(0,parseInt(o.value)):0,m=s?Math.max(0,parseInt(s.value)):0;if(!Number.isNaN(c+u+m+n)){if(c+u+m!==n){if(Math.abs(c+u+m-n)>=25)return;n=c+u+m}l>c||(this.lrStatistics={endTimeDeltaMs:this.networkEndTime-
(this.networkRequestTime+n),TCPMs:c,requestMs:u,responseMs:m},this.serverResponseTime=m)}}static getRequestIdForBackend(t){return t.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(t){let n=[];for(let r of Object.keys(t)){let a=t[r].split(`
`);for(let o=0;o<a.length;++o)n.push({name:r,value:a[o]})}return n}static get TYPES(){return cg}static asLanternNetworkRequest(t){let n=t.timing,r;return globalThis.isLightrider&&t.lrStatistics&&(t.protocol.startsWith("h3")?n={connectStart:0,connectEnd:t.lrStatistics.TCPMs}:(n={connectStart:0,sslStart:t.lrStatistics.TCPMs/2,connectEnd:t.lrStatistics.TCPMs,sslEnd:t.lrStatistics.TCPMs},r=t.lrStatistics.requestMs)),t.fromWorker=t.sessionTargetType==="worker",{rawRequest:t,...t,timing:n,serverResponseTime:r}}static isNonNetworkRequest(t){return Ce.isNonNetworkProtocol(t.protocol)||Ce.isNonNetworkProtocol(t.parsedURL.scheme)}static isSecureRequest(t){return Ce.isSecureScheme(t.parsedURL.scheme)||Ce.isSecureScheme(t.protocol)||Ce.isLikeLocalhost(t.parsedURL.host)||e.isHstsRequest(t)}static isHstsRequest(t){let n=t.redirectDestination;return n?t.responseHeaders.find(o=>o.name==="Non-Authoritative-Reason")?.value==="HSTS"&&e.isSecureRequest(n):!1}static isContentEncoded(t){let n=globalThis.isLightrider?
[/^x-original-content-encoding$/i]:[/^content-encoding$/i,/^x-content-encoding-over-network$/i],r=["gzip","br","deflate","zstd"];return t.responseHeaders.some(a=>n.some(o=>a.name.match(o))&&r.includes(a.value))}static getResourceSizeOnNetwork(t){return Math.min(t.resourceSize||0,t.transferSize||1/0)}};lt.HEADER_TCP=C4;lt.HEADER_SSL=k4;lt.HEADER_REQ=R4;lt.HEADER_RES=_4;lt.HEADER_TOTAL=I4;lt.HEADER_FETCHED_SIZE=D4;lt.HEADER_PROTOCOL_IS_H2=A4});var wue,pc,IT=g(()=>{"use strict";d();Ta();Ve();Cn();Jt();qr();wue=Ye,pc=class e extends wue{static{i(this,"NetworkRecorder")}constructor(){super(),this._records=[],this._recordsById=new Map}getRawRecords(){return Array.from(this._records)}onRequestStarted(t){this._records.push(t),this._recordsById.set(t.requestId,t),this.emit("requeststarted",t)}onRequestFinished(t){this.emit("requestfinished",t)}onRequestWillBeSent(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);if(!r){let s=new lt;s.onRequestWillBeSent(n),s.sessionId=t.sessionId,s.sessionTargetType=t.targetType,this.onRequestStarted(s),M.verbose("network",`request will be sent to ${s.url}`);return}if(!n.redirectResponse)return;let a={...n,initiator:r.initiator,requestId:`${r.requestId}:redirect`},o=new lt;o.onRequestWillBeSent(a),r.onRedirectResponse(n),M.verbose("network",`${r.url} redirected to ${o.url}`),r.redirectDestination=o,o.redirectSource=r,this.onRequestStarted(o),this.onRequestFinished(
r)}onRequestServedFromCache(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(M.verbose("network",`${r.url} served from cache`),r.onRequestServedFromCache())}onResponseReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(M.verbose("network",`${r.url} response received`),r.onResponseReceived(n))}onResponseReceivedExtraInfo(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(M.verbose("network",`${r.url} response received extra info`),r.onResponseReceivedExtraInfo(n))}onDataReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(M.verbose("network",`${r.url} data received`),r.onDataReceived(n))}onLoadingFinished(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(M.verbose("network",`${r.url} loading finished`),r.onLoadingFinished(n),this.onRequestFinished(
r))}onLoadingFailed(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(M.verbose("network",`${r.url} loading failed`),r.onLoadingFailed(n),this.onRequestFinished(r))}onResourceChangedPriority(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&r.onResourceChangedPriority(n)}dispatch(t){switch(t.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(t);case"Network.requestServedFromCache":return this.onRequestServedFromCache(t);case"Network.responseReceived":return this.onResponseReceived(t);case"Network.responseReceivedExtraInfo":return this.onResponseReceivedExtraInfo(t);case"Network.dataReceived":return this.onDataReceived(t);case"Network.loadingFinished":return this.onLoadingFinished(t);case"Network.loadingFailed":return this.onLoadingFailed(t);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(t);default:return}}_findRealRequestAndSetSession(t,n,r){let a=this.
_recordsById.get(t);if(!(!a||!a.isValid)){for(;a.redirectDestination;)a=a.redirectDestination;return a.setSession(r),a.sessionTargetType=n,a}}static _chooseInitiatorRequest(t,n){if(t.redirectSource)return t.redirectSource;let r=gn.PageDependencyGraph.getNetworkInitiators(t)[0],a=n.get(r)||[];if(a=a.filter(o=>o.responseHeadersEndTime<=t.rendererStartTime&&o.finished&&!o.failed),a.length>1){let o=a.filter(s=>s.resourceType!==lt.TYPES.Other);o.length&&(a=o)}if(a.length>1){let o=a.filter(s=>s.frameId===t.frameId);o.length&&(a=o)}if(a.length>1&&t.initiator.type==="parser"){let o=a.filter(s=>s.resourceType===lt.TYPES.Document);o.length&&(a=o)}if(a.length>1){let o=a.filter(s=>s.isLinkPreload);if(o.length){let s=a.filter(l=>!l.isLinkPreload),c=s.every(l=>l.fromDiskCache||l.fromMemoryCache);s.length&&c&&(a=o)}}return a.length===1?a[0]:null}static recordsFromLogs(t){let n=new e;t.forEach(o=>n.dispatch(o));let r=n.getRawRecords().filter(o=>o.isValid),a=new Map;for(let o of r){let s=a.get(o.url)||
[];s.push(o),a.set(o.url,s)}for(let o of r){let s=e._chooseInitiatorRequest(o,a);s&&o.setInitiatorRequest(s);let c=o;for(;c.redirectDestination;)c=c.redirectDestination;if(c===o||c.redirects)continue;let l=[];for(let u=c.redirectSource;u;u=u.redirectSource)l.unshift(u);c.redirects=l}return r}}});var DT,Re,Mt=g(()=>{"use strict";d();Cn();Ae();IT();DT=class{static{i(this,"NetworkRecords")}static async compute_(t){return pc.recordsFromLogs(t)}},Re=Y(DT,null)});var AT,zr,es=g(()=>{"use strict";d();Ve();Jt();Ae();Mt();AT=class{static{i(this,"NetworkAnalysis")}static async compute_(t,n){let r=await Re.request(t,n),a=ct.NetworkAnalyzer.analyze(r);return a||(M.error("NetworkAnalysis","Network analysis failed due to lack of transfer data"),{throughput:0,rtt:Number.POSITIVE_INFINITY,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map})}},zr=Y(AT,null)});var NT,Fo,rd=g(()=>{"use strict";d();Ae();Jt();es();NT=class{static{i(this,"LoadSimulator")}static async compute_(t,n){let r=await zr.request(t.devtoolsLog,n);return Pa.Simulator.createSimulator({...t.settings,networkAnalysis:r})}static convertAnalysisToSaveableLanternData(t){let n={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(let[r,a]of t.additionalRttByOrigin.entries())r.startsWith("http")&&(n.additionalRttByOrigin[r]=a);for(let[r,a]of t.serverResponseTimeByOrigin.entries())r.startsWith("http")&&(n.serverResponseTimeByOrigin[r]=a);return n}},Fo=Y(NT,["devtoolsLog","settings"])});async function OT(e,t,n){let r=hr.createWriteStream(n?t+".gz":t);n?await Qy.promises.pipeline(e,nL(),r):await Qy.promises.pipeline(e,r)}function MT(e,t){if(hr.existsSync(e+".gz")&&(e=e+".gz"),!e.endsWith(".json.gz"))return JSON.parse(hr.readFileSync(e,"utf8"),t);let n=rL(hr.readFileSync(e));return JSON.parse(n.toString("utf8"),t)}function N4(e,t){return e.endsWith(t)||e.endsWith(t+".gz")}function P4(e){if(M.log("Reading artifacts from disk:",e),!hr.existsSync(e))throw new Error("No saved artifacts found at "+e);let t=MT(At.join(e,lg),z.parseReviver),n=hr.readdirSync(e);return n.filter(r=>N4(r,hc)).forEach(r=>{let a=MT(At.join(e,r));r.startsWith(hc)?t.DevtoolsLog=a:r.startsWith(ug)&&(t.DevtoolsLogError=a)}),n.filter(r=>N4(r,fc)).forEach(r=>{let a=MT(At.join(e,r));Array.isArray(a)&&(a={traceEvents:a}),r.startsWith(fc)?t.Trace=a:r.startsWith(ug)&&(t.TraceError=a)}),Array.isArray(t.Timing)&&t.Timing.forEach(r=>r.gather=!0),t}function Eue(e,t){return t instanceof Error?z.stringifyReplacer(t):
t}async function L4(e,t,n={}){let r={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};M.time(r),hr.mkdirSync(t,{recursive:!0});let a=hr.readdirSync(t);for(let p of a)(p.endsWith(fc)||p.endsWith(hc)||p.endsWith(fc+".gz")||p.endsWith(hc+".gz")||p===lg||p===lg+".gz")&&hr.unlinkSync(`${t}/${p}`);let{DevtoolsLog:o,Trace:s,DevtoolsLogError:c,TraceError:l,...u}=e;s&&await M4(s,`${t}/${fc}`,n),l&&await M4(l,`${t}/${ug}${fc}`,n),o&&await O4(o,`${t}/${hc}`,n),c&&await O4(c,`${t}/${ug}${hc}`,n);let m=JSON.stringify(u,Eue,2);await OT(function*(){yield m,yield`
`},`${t}/${lg}`,!!n.gzip),M.log("Artifacts saved to disk in folder:",t),M.timeEnd(r)}function F4(e,t){hr.writeFileSync(`${t}/lhr.report.json`,JSON.stringify(e,null,2))}function*U4(e){if(yield`[
`,e.length>0){let n=e[Symbol.iterator](),r=n.next().value;yield`  ${JSON.stringify(r)}`;let a=500,o="";for(let s of n)o+=`,
  ${JSON.stringify(s)}`,a--,a===0&&(yield o,a=500,o="");yield o}yield`
]`}function*Tue(e){let{traceEvents:t,...n}=e;yield`{
`,yield'"traceEvents": ',yield*U4(t);for(let[r,a]of Object.entries(n))yield`,
"${r}": ${JSON.stringify(a,null,2)}`;yield`}
`}function M4(e,t,n={}){let r=Tue(e);return OT(r,t,!!n.gzip)}function O4(e,t,n={}){return OT(function*(){yield*U4(e),yield`
`},t,!!n.gzip)}var lg,fc,hc,ug,B4=g(()=>{"use strict";d();fo();ho();ev();Hl();aL();Ve();Jt();n4();r4();es();rd();rn();tf();lg="artifacts.json",fc="trace.json",hc="devtoolslog.json",ug="pageLoadError.";i(OT,"writeJson");i(MT,"readJson");i(N4,"endsWithSuffix");i(P4,"loadArtifacts");i(Eue,"stringifyReplacer");i(L4,"saveArtifacts");i(F4,"saveLhr");i(U4,"arrayOfObjectsJsonGenerator");i(Tue,"traceJsonGenerator");i(M4,"saveTrace");i(O4,"saveDevtoolsLog")});var Bo={};x(Bo,{defaultSettings:()=>Sr,nonSimulatedSettingsOverrides:()=>yc,screenEmulationMetrics:()=>dg,throttling:()=>gc,userAgents:()=>Uo});var gc,Sue,Cue,dg,kue,Rue,Uo,Sr,yc,Wa=g(()=>{"use strict";d();Jt();gc=Pa.Constants.throttling,Sue={mobile:!0,width:412,height:823,deviceScaleFactor:1.75,disabled:!1},Cue={mobile:!1,width:1350,height:940,deviceScaleFactor:1,disabled:!1},dg={mobile:Sue,desktop:Cue},kue="Mozilla/5.0 (Linux; Android 11; moto g power (2022)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36",Rue="Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36",Uo={mobile:kue,desktop:Rue},Sr={output:"json",maxWaitForFcp:30*1e3,maxWaitForLoad:45*1e3,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,formFactor:"mobile",throttling:gc.mobileSlow4G,throttlingMethod:"simulate",screenEmulation:dg.mobile,emulatedUserAgent:Uo.mobile,auditMode:!1,gatherMode:!1,
clearStorageTypes:["file_systems","shader_cache","service_workers","cache_storage"],disableStorageReset:!1,debugNavigation:!1,channel:"node",usePassiveGathering:!1,disableFullPageScreenshot:!1,skipAboutBlank:!1,blankPage:"about:blank",ignoreStatusCode:!1,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null},yc={pauseAfterFcpMs:5250,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250}});var Le,ze,j4,mg,PT=g(()=>{"use strict";d();Cn();Wa();A();Le={performanceCategoryTitle:"Performance",metricGroupTitle:"Metrics",insightsGroupTitle:"Insights",insightsGroupDescription:"These insights are also available in the Chrome DevTools Performance Panel - [record a trace](https://developer.chrome.com/docs/devtools/performance/reference) to view more detailed information.",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",diagnosticsGroupTitle:"Diagnostics",diagnosticsGroupDescription:"More information about the performance of your application. These num\
bers don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",a11yCategoryDescription:"These checks highlight opportunities to [improve the accessibility of your web app](https://developer.chrome.com/docs/lighthouse/accessibility/). Automatic detection can only detect a subset of issues and does not guarantee the accessibility of your web app, so [manual testing](https://web.dev/articles/how-to-review) is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://web.dev/articles/how-to-review).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility best practices.",a11yColorContrastGroupTitle:"Contrast",a11yColorContrastGroupDescription:"These are opportunities to improve the legibil\
ity of your content.",a11yNamesLabelsGroupTitle:"Names and labels",a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio and video",a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improv\
e the experience for users with hearing or vision impairments.",a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or list data using assistive technology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is following basic search engine optimization advice. There are many additional factors Lighthouse does not score here that may affect your search ranking, including performance on [Core Web Vitals](https://web.dev/explore/vitals). [Learn more about Google Search Essentials](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",seoMobileGroupDescription:"Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn h\
ow to make pages mobile-friendly](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better understand your app’s content.",seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",bestPracticesCategoryTitle:"Best Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General"},ze=T("core/config/default-config.js",Le),j4={settings:Sr,artifacts:[{id:"DevtoolsLog",gatherer:"devtools-log"},{id:"Trace",gatherer:"trace"},{id:"Accessibility",gatherer:"accessibility"},{id:"AnchorElements",gatherer:"anchor-elements"},{id:"ConsoleMessages",gatherer:"console-messages"},{id:"CSSUsage",gatherer:"css-usage"},{id:"Doctype",gatherer:"dobetterweb/do\
ctype"},{id:"Inputs",gatherer:"inputs"},{id:"IFrameElements",gatherer:"iframe-elements"},{id:"ImageElements",gatherer:"image-elements"},{id:"InspectorIssues",gatherer:"inspector-issues"},{id:"JsUsage",gatherer:"js-usage"},{id:"LinkElements",gatherer:"link-elements"},{id:"MainDocumentContent",gatherer:"main-document-content"},{id:"MetaElements",gatherer:"meta-elements"},{id:"NetworkUserAgent",gatherer:"network-user-agent"},{id:"RobotsTxt",gatherer:"seo/robots-txt"},{id:"Scripts",gatherer:"scripts"},{id:"SourceMaps",gatherer:"source-maps"},{id:"Stacks",gatherer:"stacks"},{id:"Stylesheets",gatherer:"stylesheets"},{id:"TraceElements",gatherer:"trace-elements"},{id:"ViewportDimensions",gatherer:"viewport-dimensions"},{id:"FullPageScreenshot",gatherer:"full-page-screenshot"},{id:"BFCacheFailures",gatherer:"bf-cache-failures"}],audits:["is-on-https","redirects-http","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/speed-index","screenshot-thumbnails","final-screens\
hot","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","metrics/interaction-to-next-paint","errors-in-console","server-response-time","metrics/interactive","user-timings","redirects","image-aspect-ratio","image-size-responsive","deprecations","third-party-cookies","mainthread-work-breakdown","bootup-time","diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","resource-summary","layout-shifts","long-tasks","non-composited-animations","unsized-images","valid-source-maps","csp-xss","has-hsts","origin-isolation","clickjacking-mitigation","trusted-types-xss","script-treemap-data","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-allowed-role","accessibility/aria-command-name","accessibility/aria-conditional-attr","accessibility/aria-deprecated-role","accessibility/aria-dialog-name","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-inpu\
t-field-name","accessibility/aria-meter-name","accessibility/aria-progressbar-name","accessibility/aria-prohibited-attr","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-text","accessibility/aria-toggle-field-name","accessibility/aria-tooltip-name","accessibility/aria-treeitem-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id-aria","accessibility/empty-heading","accessibility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/html-xml-lang-mismatch","accessibility/identical-links-same-purpose","accessibility/image-alt","accessibility/image-redundant-a\
lt","accessibility/input-button-name","accessibility/input-image-alt","accessibility/label-content-name-mismatch","accessibility/label","accessibility/landmark-one-main","accessibility/link-name","accessibility/link-in-text-block","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/select-name","accessibility/skip-link","accessibility/tabindex","accessibility/table-duplicate-name","accessibility/table-fake-caption","accessibility/target-size","accessibility/td-has-header","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessibility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","acce\
ssibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/total-byte-weight","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","dobetterweb/doctype","dobetterweb/charset","dobetterweb/geolocation-on-start","dobetterweb/inspector-issues","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/paste-preventing-inputs","seo/meta-description","seo/http-status-code","seo/link-text","seo/crawlable-anchors","seo/is-crawlable","seo/robots-txt","seo/hreflang","seo/canonical","seo/manual/structured-data","bf-cache","insights/cache-insight","insights/cls-culprits-insight","insights/document-latency-insight","insights/dom-size-insight","insights/duplicated-javascript-insight","insights/font-display-insight","insights/forced-reflow-insight","insights/image-delivery-insight","insights/inp-breakdown-ins\
ight","insights/lcp-breakdown-insight","insights/lcp-discovery-insight","insights/legacy-javascript-insight","insights/modern-http-insight","insights/network-dependency-tree-insight","insights/render-blocking-insight","insights/third-parties-insight","insights/viewport-insight"],groups:{metrics:{title:ze(Le.metricGroupTitle)},insights:{title:ze(Le.insightsGroupTitle),description:ze(Le.insightsGroupDescription)},diagnostics:{title:ze(Le.diagnosticsGroupTitle),description:ze(Le.diagnosticsGroupDescription)},"a11y-best-practices":{title:ze(Le.a11yBestPracticesGroupTitle),description:ze(Le.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:ze(Le.a11yColorContrastGroupTitle),description:ze(Le.a11yColorContrastGroupDescription)},"a11y-names-labels":{title:ze(Le.a11yNamesLabelsGroupTitle),description:ze(Le.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:ze(Le.a11yNavigationGroupTitle),description:ze(Le.a11yNavigationGroupDescription)},"a11y-aria":{title:ze(Le.a11yAriaGroupTitle),
description:ze(Le.a11yAriaGroupDescription)},"a11y-language":{title:ze(Le.a11yLanguageGroupTitle),description:ze(Le.a11yLanguageGroupDescription)},"a11y-audio-video":{title:ze(Le.a11yAudioVideoGroupTitle),description:ze(Le.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:ze(Le.a11yTablesListsVideoGroupTitle),description:ze(Le.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:ze(Le.seoMobileGroupTitle),description:ze(Le.seoMobileGroupDescription)},"seo-content":{title:ze(Le.seoContentGroupTitle),description:ze(Le.seoContentGroupDescription)},"seo-crawl":{title:ze(Le.seoCrawlingGroupTitle),description:ze(Le.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:ze(Le.bestPracticesTrustSafetyGroupTitle)},"best-practices-ux":{title:ze(Le.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:ze(Le.bestPracticesBrowserCompatGroupTitle)},"best-practices-general":{title:ze(Le.bestPracticesGeneralGroupTitle)},hidden:{title:""}},categories:{performance:{
title:ze(Le.performanceCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"first-contentful-paint",weight:10,group:"metrics",acronym:"FCP"},{id:"largest-contentful-paint",weight:25,group:"metrics",acronym:"LCP"},{id:"total-blocking-time",weight:30,group:"metrics",acronym:"TBT"},{id:"cumulative-layout-shift",weight:25,group:"metrics",acronym:"CLS"},{id:"speed-index",weight:10,group:"metrics",acronym:"SI"},{id:"interaction-to-next-paint",weight:0,group:"metrics",acronym:"INP"},{id:"cache-insight",weight:0,group:"insights"},{id:"cls-culprits-insight",weight:0,group:"insights"},{id:"document-latency-insight",weight:0,group:"insights"},{id:"dom-size-insight",weight:0,group:"insights"},{id:"duplicated-javascript-insight",weight:0,group:"insights"},{id:"font-display-insight",weight:0,group:"insights"},{id:"forced-reflow-insight",weight:0,group:"insights"},{id:"image-delivery-insight",weight:0,group:"insights"},{id:"inp-breakdown-insight",weight:0,group:"insights"},
{id:"lcp-breakdown-insight",weight:0,group:"insights"},{id:"lcp-discovery-insight",weight:0,group:"insights"},{id:"legacy-javascript-insight",weight:0,group:"insights"},{id:"modern-http-insight",weight:0,group:"insights"},{id:"network-dependency-tree-insight",weight:0,group:"insights"},{id:"render-blocking-insight",weight:0,group:"insights"},{id:"third-parties-insight",weight:0,group:"insights"},{id:"viewport-insight",weight:0,group:"insights"},{id:"interactive",weight:0,group:"hidden",acronym:"TTI"},{id:"max-potential-fid",weight:0,group:"hidden"},{id:"unminified-css",weight:0,group:"diagnostics"},{id:"unminified-javascript",weight:0,group:"diagnostics"},{id:"unused-css-rules",weight:0,group:"diagnostics"},{id:"unused-javascript",weight:0,group:"diagnostics"},{id:"total-byte-weight",weight:0,group:"diagnostics"},{id:"user-timings",weight:0,group:"diagnostics"},{id:"bootup-time",weight:0,group:"diagnostics"},{id:"mainthread-work-breakdown",weight:0,group:"diagnostics"},{id:"long-tasks",
weight:0,group:"diagnostics"},{id:"non-composited-animations",weight:0,group:"diagnostics"},{id:"unsized-images",weight:0,group:"diagnostics"},{id:"bf-cache",weight:0,group:"diagnostics"},{id:"network-requests",weight:0,group:"hidden"},{id:"network-rtt",weight:0,group:"hidden"},{id:"network-server-latency",weight:0,group:"hidden"},{id:"main-thread-tasks",weight:0,group:"hidden"},{id:"diagnostics",weight:0,group:"hidden"},{id:"metrics",weight:0,group:"hidden"},{id:"screenshot-thumbnails",weight:0,group:"hidden"},{id:"final-screenshot",weight:0,group:"hidden"},{id:"script-treemap-data",weight:0,group:"hidden"},{id:"resource-summary",weight:0,group:"hidden"},{id:"redirects",weight:0,group:"hidden"},{id:"server-response-time",weight:0,group:"hidden"},{id:"layout-shifts",weight:0,group:"hidden"}]},accessibility:{title:ze(Le.a11yCategoryTitle),description:ze(Le.a11yCategoryDescription),manualDescription:ze(Le.a11yCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[
{id:"accesskeys",weight:7,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-command-name",weight:7,group:"a11y-aria"},{id:"aria-conditional-attr",weight:7,group:"a11y-aria"},{id:"aria-deprecated-role",weight:1,group:"a11y-aria"},{id:"aria-dialog-name",weight:7,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:7,group:"a11y-aria"},{id:"aria-input-field-name",weight:7,group:"a11y-aria"},{id:"aria-meter-name",weight:7,group:"a11y-aria"},{id:"aria-progressbar-name",weight:7,group:"a11y-aria"},{id:"aria-prohibited-attr",weight:7,group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:10,group:"a11y-aria"},{id:"aria-text",weight:7,group:"a11y-aria"},{id:"aria-toggle-field-name",weight:7,group:"a11y-aria"},{id:"aria-tooltip-name",weight:7,group:"a11y-a\
ria"},{id:"aria-treeitem-name",weight:7,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,group:"a11y-aria"},{id:"aria-valid-attr",weight:10,group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:7,group:"a11y-navigation"},{id:"color-contrast",weight:7,group:"a11y-color-contrast"},{id:"definition-list",weight:7,group:"a11y-tables-lists"},{id:"dlitem",weight:7,group:"a11y-tables-lists"},{id:"document-title",weight:7,group:"a11y-names-labels"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:3,group:"a11y-names-labels"},{id:"frame-title",weight:7,group:"a11y-names-labels"},{id:"heading-order",weight:3,group:"a11y-navigation"},{id:"html-has-lang",weight:7,group:"a11y-language"},{id:"html-lang-valid",weight:7,group:"a11y-language"},{id:"html-xml-lang-mismatch",weight:3,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"input-button-name",weight:10,group:"a11y-names-labels"},
{id:"input-image-alt",weight:10,group:"a11y-names-labels"},{id:"label",weight:10,group:"a11y-names-labels"},{id:"link-in-text-block",weight:7,group:"a11y-color-contrast"},{id:"link-name",weight:7,group:"a11y-names-labels"},{id:"list",weight:7,group:"a11y-tables-lists"},{id:"listitem",weight:7,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:7,group:"a11y-names-labels"},{id:"select-name",weight:10,group:"a11y-names-labels"},{id:"skip-link",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:7,group:"a11y-navigation"},{id:"target-size",weight:7,group:"a11y-best-practices"},{id:"td-headers-attr",weight:7,group:"a11y-tables-lists"},{id:"th-has-data-cells",weight:7,group:"a11y-tables-lists"},{id:"valid-lang",weight:7,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"landmark-one-main",weight:3,group:"a11y-best-practices"},{id:"focusab\
le-controls",weight:0},{id:"interactive-element-affordance",weight:0},{id:"logical-tab-order",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"focus-traps",weight:0},{id:"managed-focus",weight:0},{id:"use-landmarks",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"custom-controls-labels",weight:0},{id:"custom-controls-roles",weight:0},{id:"table-duplicate-name",weight:0,group:"a11y-best-practices"},{id:"empty-heading",weight:0,group:"a11y-best-practices"},{id:"aria-allowed-role",weight:0,group:"a11y-best-practices"},{id:"image-redundant-alt",weight:0,group:"a11y-names-labels"},{id:"identical-links-same-purpose",weight:0,group:"a11y-best-practices"},{id:"label-content-name-mismatch",weight:0,group:"hidden"},{id:"table-fake-caption",weight:0,group:"hidden"},{id:"td-has-header",weight:0,group:"hidden"}]},"best-practices":{title:ze(Le.bestPracticesCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"is-on-https",weight:5,group:"best-practices-tru\
st-safety"},{id:"redirects-http",weight:1,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,group:"best-practices-trust-safety"},{id:"csp-xss",weight:0,group:"best-practices-trust-safety"},{id:"has-hsts",weight:0,group:"best-practices-trust-safety"},{id:"origin-isolation",weight:0,group:"best-practices-trust-safety"},{id:"clickjacking-mitigation",weight:0,group:"best-practices-trust-safety"},{id:"trusted-types-xss",weight:0,group:"best-practices-trust-safety"},{id:"paste-preventing-inputs",weight:3,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"js-libraries",weight:0,group:"best-practices-general"},{id:"deprecations",weight:5,group:"best-practices-general"},{id:"\
third-party-cookies",weight:5,group:"best-practices-general"},{id:"errors-in-console",weight:1,group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-practices-general"},{id:"inspector-issues",weight:1,group:"best-practices-general"}]},seo:{title:ze(Le.seoCategoryTitle),description:ze(Le.seoCategoryDescription),manualDescription:ze(Le.seoCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"is-crawlable",weight:93/23,group:"seo-crawl"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-content"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,group:"seo-content"},{id:"structured-data",weight:0}]}}};Object.defineProperty(j4,"UIStrings",
{enumerable:!1,get:i(()=>Le,"get")});mg=j4});function H4(e,t){let n={timespan:0,snapshot:1,navigation:2},r=Math.min(...e.instance.meta.supportedModes.map(o=>n[o])),a=Math.min(...t.instance.meta.supportedModes.map(o=>n[o]));return r===n.timespan?a===n.timespan:r===n.snapshot?a===n.snapshot:!0}function q4(e,t){let n=t.split("/");if(n.length===2&&(t=n[1]),!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories?.[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}function _ue(e){let t=e.gatherer.instance;if(typeof t.meta!="object")throw new Error(`Gatherer for ${e.id} did not provide a meta object.`);if(t.meta.supportedModes.length===0)throw new Error(`Gatherer for ${e.id} did not support any gather modes.`);if(typeof t.getArtifact!="function"||t.getArtifact===fe.prototype.getArtifact)throw new Error(`Gatherer for ${e.id} did not define a "getArtifact" method.`)}function LT(e){let{implementation:t,path:n}=e,
r=n||t?.meta?.id||"Unknown audit";if(typeof t.audit!="function"||t.audit===E.audit)throw new Error(`${r} has no audit() method.`);if(typeof t.meta.id!="string")throw new Error(`${r} has no meta.id property, or the property is not a string.`);if(!Qr(t.meta.title))throw new Error(`${r} has no meta.title property, or the property is not a string.`);let a=t.meta.scoreDisplayMode||E.SCORING_MODES.BINARY;if(!Qr(t.meta.failureTitle)&&a===E.SCORING_MODES.BINARY)throw new Error(`${r} has no meta.failureTitle and should.`);if(Qr(t.meta.description)){if(t.meta.description==="")throw new Error(`${r} has an empty meta.description string. Please add a description for the UI.`)}else throw new Error(`${r} has no meta.description property, or the property is not a string.`);if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(`${r} has no meta.requiredArtifacts property, or the property is not an array.`)}function Iue(e,t,n){if(!e)return;let r=new Map((t||[]).map(a=>[a.implementation.meta.id,a]));
Object.keys(e).forEach(a=>{e[a].auditRefs.forEach((o,s)=>{if(!o.id)throw new Error(`missing an audit id at ${a}[${s}]`);let c=r.get(o.id);if(!c)throw new Error(`could not find ${o.id} audit for category ${a}`);let u=c.implementation.meta.scoreDisplayMode==="manual";if(a==="accessibility"&&!o.group&&!u)throw new Error(`${o.id} accessibility audit does not have a group`);if(o.weight>0&&u)throw new Error(`${o.id} is manual but has a positive weight`);if(o.group&&(!n||!n[o.group]))throw new Error(`${o.id} references unknown group ${o.group}`)})})}function FT(e){if(!e.formFactor)throw new Error("`settings.formFactor` must be defined as 'mobile' or 'desktop'. See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md");if(!e.screenEmulation.disabled&&e.screenEmulation.mobile!==(e.formFactor==="mobile"))throw new Error(`Screen emulation mobile setting (${e.screenEmulation.mobile}) does not match formFactor setting (${e.formFactor}). See https://github.com/GoogleChrome/lighthou\
se/blob/main/docs/emulation.md`);let t=e.skipAudits?.find(n=>e.onlyAudits?.includes(n));if(t)throw new Error(`${t} appears in both skipAudits and onlyAudits`)}function Due(e){let t=new Set;for(let n of e){if(_ue(n),t.has(n.id))throw new Error(`Config defined multiple artifacts with id '${n.id}'`);if(t.add(n.id),!!n.dependencies)for(let[r,{id:a}]of Object.entries(n.dependencies))t.has(a)||UT(n.id,r)}}function z4(e){Due(e.artifacts||[]);for(let t of e.audits||[])LT(t);Iue(e.categories,e.audits,e.groups),FT(e.settings)}function UT(e,t){throw new Error([`Failed to find dependency "${t}" for "${e}" artifact`,"Check that...",`  1. A gatherer exposes a matching Symbol that satisfies "${t}".`,`  2. "${t}" is configured to run before "${e}"`].join(`
`))}function G4(e,t){throw new Error([`Dependency "${t}" for "${e}" artifact is invalid.`,"The dependency must be collected before the dependent."].join(`
`))}var BT=g(()=>{"use strict";d();$();bt();A();i(H4,"isValidArtifactDependency");i(q4,"assertValidPluginName");i(_ue,"assertValidArtifact");i(LT,"assertValidAudit");i(Iue,"assertValidCategories");i(FT,"assertValidSettings");i(Due,"assertValidArtifacts");i(z4,"assertValidConfig");i(UT,"throwInvalidDependencyOrder");i(G4,"throwInvalidArtifactDependency")});function W4(e,t){if(!e)return new Set;t=t||Object.keys(e);let r=t.map(a=>e[a]).flatMap(a=>a?.auditRefs||[]);return new Set(r.map(a=>a.id))}function Lue(e,t){if(!e)return null;if(!t)return e;let n=new Map(e.map(o=>[o.id,o])),r=new Set([...Pue,...t.flatMap(o=>o.implementation.meta.requiredArtifacts)]),a=0;for(;a!==r.size;){a=r.size;for(let o of r){let s=n.get(o);if(s&&s.dependencies)for(let c of Object.values(s.dependencies))r.add(c.id)}}return e.filter(o=>r.has(o.id))}function Fue(e,t){return e?e.filter(n=>n.gatherer.instance.meta.supportedModes.includes(t)):null}function Uue(e,t){if(!e)return null;let n=new Set(t.map(r=>r.id).concat(Mue));return e.filter(r=>r.implementation.meta.requiredArtifacts.every(o=>n.has(o)))}function Bue(e,t){return e?e.filter(n=>{let r=n.implementation.meta;return!r.supportedModes||r.supportedModes.includes(t)}):null}function jue(e,t){if(!e)return null;let n=Object.entries(e).filter(([r,a])=>!a.supportedModes||a.supportedModes.includes(t));return Object.fromEntries(
n)}function Hue(e,t){if(!e||!t)return e;let n=Object.entries(e).filter(([r])=>t.includes(r));return Object.fromEntries(n)}function que(e,t){if(!t)return;let n=t.filter(r=>!e?.[r]);if(n.length)throw new Error(`unrecognized category in 'onlyCategories': ${n.join(", ")}`)}function V4(e,t){if(!e)return e;let n=new Map(t.map(a=>[a.implementation.meta.id,a.implementation.meta])),r=Object.entries(e).map(([a,o])=>{let s={...o,auditRefs:o.auditRefs.filter(u=>n.has(u.id))},c=s.auditRefs.length<o.auditRefs.length,l=s.auditRefs.every(u=>{let m=n.get(u.id);return m?m.scoreDisplayMode===E.SCORING_MODES.MANUAL:!1});return c&&l&&(s.auditRefs=[]),[a,s]}).filter(a=>typeof a[1]=="object"&&a[1].auditRefs.length);return Object.fromEntries(r)}function $4(e,t){let n=Fue(e.artifacts,t),r=Bue(e.audits,t),a=Uue(r,n||[]),o=jue(e.categories,t),s=V4(o,a||[]);return{...e,artifacts:n,audits:a,categories:s}}function Y4(e,t){let{onlyAudits:n,onlyCategories:r,skipAudits:a}=t;if(n&&!n.length)throw new Error("onlyAudits \
cannot be an empty array.");if(r&&!r.length)throw new Error("onlyCategories cannot be an empty array.");que(e.categories,r);let o=W4(e.categories,void 0);r?o=W4(e.categories,r):n?o=new Set:(!e.categories||!Object.keys(e.categories).length)&&(o=new Set(e.audits?.map(p=>p.implementation.meta.id)));let s=new Set([...o,...n||[],...Oue].filter(p=>!a||!a.includes(p))),c=s.size&&e.audits?e.audits.filter(p=>s.has(p.implementation.meta.id)):e.audits,l=V4(e.categories,c||[]),u=Hue(l,r),m=Lue(e.artifacts,c);return m&&e.settings.disableFullPageScreenshot&&(m=m.filter(({id:p})=>p!=="FullPageScreenshot")),{...e,artifacts:m,audits:c,categories:u}}var Nue,Mue,Oue,Pue,K4=g(()=>{"use strict";d();$();Nue={fetchTime:"",LighthouseRunWarnings:"",BenchmarkIndex:"",HostDPR:"",settings:"",Timing:"",URL:"",PageLoadError:"",HostFormFactor:"",HostUserAgent:"",HostProduct:"",GatherContext:""},Mue=Object.keys(Nue),Oue=[],Pue=["Stacks","NetworkUserAgent","FullPageScreenshot"];i(W4,"getAuditIdsInCategories");i(Lue,"f\
ilterArtifactsByAvailableAudits");i(Fue,"filterArtifactsByGatherMode");i(Uue,"filterAuditsByAvailableArtifacts");i(Bue,"filterAuditsByGatherMode");i(jue,"filterCategoriesByGatherMode");i(Hue,"filterCategoriesByExplicitFilters");i(que,"errorOnUnknownOnlyCategories");i(V4,"filterCategoriesByAvailableAudits");i($4,"filterConfigByGatherMode");i(Y4,"filterConfigByExplicitFilters")});function X4(e){return Array.isArray(e)&&e.every(od)}function od(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function zue(e){return typeof e!="string"?!1:e==="navigation"||e==="timespan"||e==="snapshot"}function Gue(e){return Array.isArray(e)?e.every(zue):!1}function ad(e,t,n=""){n&&(n+=" ");let r=Object.keys(e);if(r.length>0){let a=r.join(", ");throw new Error(`${t} has unrecognized ${n}properties: [${a}]`)}}var jT,J4,Z4=g(()=>{"use strict";d();A();i(X4,"isArrayOfUnknownObjects");i(od,"isObjectOfUnknownProperties");i(zue,"objectIsGatherMode");i(Gue,"isArrayOfGatherModes");i(ad,"assertNoExcessProperties");jT=class e{static{i(this,"ConfigPlugin")}static _parseAuditsList(t,n){if(t!==void 0){if(!X4(t))throw new Error(`${n} has an invalid audits array.`);return t.map(r=>{let{path:a,...o}=r;if(ad(o,n,"audit"),typeof a!="string")throw new Error(`${n} has a missing audit path.`);return{path:a}})}}static _parseAuditRefsList(t,n){if(!X4(t))throw new Error(`${n} has no valid auditsR\
efs.`);return t.map(r=>{let{id:a,weight:o,group:s,...c}=r;if(ad(c,n,"auditRef"),typeof a!="string")throw new Error(`${n} has an invalid auditRef id.`);if(typeof o!="number")throw new Error(`${n} has an invalid auditRef weight.`);if(typeof s!="string"&&typeof s<"u")throw new Error(`${n} has an invalid auditRef group.`);let l=s&&`${n}-${s}`;return{id:a,weight:o,group:l}})}static _parseCategory(t,n){if(!od(t))throw new Error(`${n} has no valid category.`);let{title:r,description:a,manualDescription:o,auditRefs:s,supportedModes:c,...l}=t;if(ad(l,n,"category"),!Qr(r))throw new Error(`${n} has an invalid category tile.`);if(!Qr(a)&&a!==void 0)throw new Error(`${n} has an invalid category description.`);if(!Qr(o)&&o!==void 0)throw new Error(`${n} has an invalid category manualDescription.`);if(!Gue(c)&&c!==void 0)throw new Error(`${n} supportedModes must be an array, valid array values are "navigation", "timespan", and "snapshot".`);let u=e._parseAuditRefsList(s,n);return{title:r,auditRefs:u,
description:a,manualDescription:o,supportedModes:c}}static _parseGroups(t,n){if(t===void 0)return;if(!od(t))throw new Error(`${n} groups json is not defined as an object.`);let r=Object.entries(t),a={};return r.forEach(([o,s])=>{if(!od(s))throw new Error(`${n} has a group not defined as an object.`);let{title:c,description:l,...u}=s;if(ad(u,n,"group"),!Qr(c))throw new Error(`${n} has an invalid group title.`);if(!Qr(l)&&l!==void 0)throw new Error(`${n} has an invalid group description.`);a[`${n}-${o}`]={title:c,description:l}}),a}static parsePlugin(t,n){if(t=JSON.parse(JSON.stringify(t)),!od(t))throw new Error(`${n} is not defined as an object.`);let{audits:r,category:a,groups:o,...s}=t;return ad(s,n),{audits:e._parseAuditsList(r,n),categories:{[n]:e._parseCategory(a,n)},groups:e._parseGroups(o,n)}}},J4=jT});var Q4,e8=g(()=>{"use strict";d();fo();Ps();Q4=`/*! axe v4.11.0
 * Copyright (c) 2015 - 2025 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
!function e(t){var n=t,r=t.document;function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=o||{},i=(o.version="4.11.0","function"==typeof define&&define.amd&&define("axe-core",[],(function(){return o})),"object"===("undefined"==typeof module?"undefined":a(module))&&module.exports&&"function"==typeof e.toString&&(o.source="("+e.toString()+')(typeof window === "object" ? window : this);',module.exports=o),"function"==typeof t.getComputedStyle&&(t.axe=o),["precision","format","inGamut"]),l=["space"],u=["algorithm"],s=["method"],c=["maxDeltaE","deltaEMethod","steps","maxSteps"],d=["variant"],p=["matches"],f=["chromium"],m=["noImplicit"],h=["noPresentational"],g=["node"],v=["relatedNodes"],b=["node"],y=["node"],D=["environmentData"],w=["environmentData"],x=["environmentData"],E=["environmentData"],A=["environmentD\
ata"];function F(e,t,n){return(t=Y(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function C(e,t,n){var r;return N()?Reflect.construct.apply(null,arguments):((r=[null]).push.apply(r,t),t=new(e.bind.apply(e,r)),n&&_(t,n.prototype),t)}function k(e,t){if(null==e)return{};var n,r=((e,t)=>{if(null==e)return{};var n,r={};for(n in e)!{}.hasOwnProperty.call(e,n)||-1!==t.indexOf(n)||(r[n]=e[n]);return r})(e,t);if(Object.getOwnPropertySymbols)for(var a=Object.getOwnPropertySymbols(e),o=0;o<a.length;o++)n=a[o],-1===t.indexOf(n)&&{}.propertyIsEnumerable.call(e,n)&&(r[n]=e[n]);return r}function R(e,t,n){t=T(t);var r=e;if((t=N()?Reflect.construct(t,n||[],T(e).constructor):t.apply(e,n))&&("object"==a(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");if(void 0!==(t=r))return t;throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}function N(){t\
ry{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){})))}catch(e){}return(N=function(){return!!e})()}function T(e){return(T=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function S(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&_(e,t)}function _(e,t){return(_=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}function O(){return(O=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n,r=arguments[t];for(n in r)!{}.hasOwnProperty.call(r,n)||(e[n]=r[n])}return e}).apply(null,arguments)}function M(e){return(e=>{if(Array.isArray(e))return Z(e)})(e)||P(e)||X(e)||(()=>{throw new TypeError("Invalid attempt to s\
pread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")})()}function P(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function I(e,t,n){j(e,t),t.set(e,n)}function B(e,t){j(e,t),t.add(e)}function j(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function L(e,t){return e.get(z(e,t))}function q(e,t,n){e.set(z(e,t),n)}function z(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}function V(e,t){return $(e)||((e,t)=>{var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,a,o,i,l=[],u=!0,s=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;u=!1}else for(;!(u=(r=o.call(n)).done)&&(l.push(r.value),l.length!==t);u=!0);}catch(e){s=!0,a=e}finally{try{if(!u&&null!=n.return&&(i=n.ret\
urn(),Object(i)!==i))return}finally{if(s)throw a}}return l}})(e,t)||X(e,t)||G()}function G(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function $(e){if(Array.isArray(e))return e}function H(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function U(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,Y(r.key),r)}}function W(e,t,n){return t&&U(e.prototype,t),n&&U(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function Y(e){return e=((e,t)=>{if("object"!=a(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return String(e);if(n=n.call(e,"string"),"object"==a(n))throw new TypeError("@@toPrimitive must return a primitive value.");return n})(e),"symbol"==a(e)?e:e+""}function K(e,t){var n,r,a,o,i="undefined"!=typeof Symbol&&e[Symbol.\
iterator]||e["@@iterator"];if(i)return a=!(r=!0),{s:function(){i=i.call(e)},n:function(){var e=i.next();return r=e.done,e},e:function(e){a=!0,n=e},f:function(){try{r||null==i.return||i.return()}finally{if(a)throw n}}};if(Array.isArray(e)||(i=X(e))||t&&e&&"number"==typeof e.length)return i&&(e=i),o=0,{s:t=function(){},n:function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function X(e,t){var n;if(e)return"string"==typeof e?Z(e,t):"Map"===(n="Object"===(n={}.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?Z(e,t):void 0}function Z(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof \
Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var J,Q,ee,te,ne,re,ae,oe,ie,le,ue=void 0;function se(e,t){return function(){return t||e((t={exports:{}}).exports,t),t.exports}}function ce(e,t){for(var n in t)me(e,n,{get:t[n],enumerable:!0})}function de(e){return function(e,t,n){if(t&&"object"===a(t)||"function"==typeof t){var r,o=K(ve(t));try{for(o.s();!(r=o.n()).done;)(()=>{var a=r.value;ge.call(e,a)||"default"===a||me(e,a,{get:function(){return t[a]},enumerable:!(n=be(t,a))||n.enumerable})})()}catch(e){o.e(e)}finally{o.f()}}return e}((t=me(null!=e?fe(he(e)):{},"default",e&&e.__esModule&&"default"in e?{get:function(){return e.default},enumerable:!0}:{value:e,enumerable:!0}),me(t,"__esModule",{value:!0})),e);var t}function pe(e,t,n){(t="symbol"!==a(t)?t+"":t)in e?me(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n}var fe=Object.create,me=Object.defineProperty\
,he=Object.getPrototypeOf,ge=Object.prototype.hasOwnProperty,ve=Object.getOwnPropertyNames,be=Object.getOwnPropertyDescriptor,ye=se((function(e,o){var i;i=function(){function e(e){return"function"==typeof e}var o=Array.isArray||function(e){return"[object Array]"===Object.prototype.toString.call(e)},i=0,l=void 0,u=void 0,s=function(e,t){h[i]=e,h[i+1]=t,2===(i+=2)&&(u?u(g):D())},c=void 0!==t?t:void 0,d=(d=c||{}).MutationObserver||d.WebKitMutationObserver,p="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),f="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function m(){var e=setTimeout;return function(){return e(g,1)}}var h=new Array(1e3);function g(){for(var e=0;e<i;e+=2)(0,h[e])(h[e+1]),h[e]=void 0,h[e+1]=void 0;i=0}var v,b,y,D=void 0;function w(e,t){var n,r=this,a=new this.constructor(A),o=(void 0===a[E]&&B(a),r._state);return o?(n=arguments[o-1],s((function(){return P(o,a,n,\
r._result)}))):O(r,a,e,t),a}function x(e){var t;return e&&"object"===a(e)&&e.constructor===this?e:(N(t=new this(A),e),t)}D=p?function(){return process.nextTick(g)}:d?(b=0,p=new d(g),y=r.createTextNode(""),p.observe(y,{characterData:!0}),function(){y.data=b=++b%2}):f?((v=new MessageChannel).port1.onmessage=g,function(){return v.port2.postMessage(0)}):(void 0===c?function(){try{var e=Function("return this")().require("vertx");return void 0!==(l=e.runOnLoop||e.runOnContext)?function(){l(g)}:m()}catch(e){return m()}}:m)();var E=Math.random().toString(36).substring(2);function A(){}var F=void 0,C=1,k=2;function R(t,n,r){var a,o;n.constructor===t.constructor&&r===w&&n.constructor.resolve===x?(a=t,(o=n)._state===C?S(a,o._result):o._state===k?_(a,o._result):O(o,void 0,(function(e){return N(a,e)}),(function(e){return _(a,e)}))):void 0!==r&&e(r)?function(e,t,n){s((function(e){var r=!1,a=((e,t,n,r)=>{try{e.call(t,n,r)}catch(e){return e}})(n,t,(function(n){r||(r=!0,(t!==n?N:S)(e,n))}),(function(t)\
{r||(r=!0,_(e,t))}),e._label);!r&&a&&(r=!0,_(e,a))}),e)}(t,n,r):S(t,n)}function N(e,t){if(e===t)_(e,new TypeError("You cannot resolve a promise with itself"));else if(r=a(n=t),null===n||"object"!==r&&"function"!==r)S(e,t);else{n=void 0;try{n=t.then}catch(t){return void _(e,t)}R(e,t,n)}var n,r}function T(e){e._onerror&&e._onerror(e._result),M(e)}function S(e,t){e._state===F&&(e._result=t,e._state=C,0!==e._subscribers.length)&&s(M,e)}function _(e,t){e._state===F&&(e._state=k,e._result=t,s(T,e))}function O(e,t,n,r){var a=e._subscribers,o=a.length;e._onerror=null,a[o]=t,a[o+C]=n,a[o+k]=r,0===o&&e._state&&s(M,e)}function M(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r,a=void 0,o=e._result,i=0;i<t.length;i+=3)r=t[i],a=t[i+n],r?P(n,r,a,o):a(o);e._subscribers.length=0}}function P(t,n,r,a){var o=e(r),i=void 0,l=void 0,u=!0;if(o){try{i=r(a)}catch(t){u=!1,l=t}if(n===i)return void _(n,new TypeError("A promises callback cannot return that same promise."))}else i=a;n._state===F&&(o&&\
u?N(n,i):!1===u?_(n,l):t===C?S(n,i):t===k&&_(n,i))}var I=0;function B(e){e[E]=I++,e._state=void 0,e._result=void 0,e._subscribers=[]}L.prototype._enumerate=function(e){for(var t=0;this._state===F&&t<e.length;t++)this._eachEntry(e[t],t)},L.prototype._eachEntry=function(e,t){var n=this._instanceConstructor,r=n.resolve;if(r===x){var a,o=void 0,i=void 0,l=!1;try{o=e.then}catch(t){l=!0,i=t}o===w&&e._state!==F?this._settledAt(e._state,t,e._result):"function"!=typeof o?(this._remaining--,this._result[t]=e):n===q?(a=new n(A),l?_(a,i):R(a,e,o),this._willSettleAt(a,t)):this._willSettleAt(new n((function(t){return t(e)})),t)}else this._willSettleAt(r(e),t)},L.prototype._settledAt=function(e,t,n){var r=this.promise;r._state===F&&(this._remaining--,e===k?_(r,n):this._result[t]=n),0===this._remaining&&S(r,this._result)},L.prototype._willSettleAt=function(e,t){var n=this;O(e,void 0,(function(e){return n._settledAt(C,t,e)}),(function(e){return n._settledAt(k,t,e)}))};var j=L;function L(e,t){this._inst\
anceConstructor=e,this.promise=new e(A),this.promise[E]||B(this.promise),o(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0!==this.length&&(this.length=this.length||0,this._enumerate(t),0!==this._remaining)||S(this.promise,this._result)):_(this.promise,new Error("Array Methods must be provided an Array"))}z.prototype.catch=function(e){return this.then(null,e)},z.prototype.finally=function(t){var n=this.constructor;return e(t)?this.then((function(e){return n.resolve(t()).then((function(){return e}))}),(function(e){return n.resolve(t()).then((function(){throw e}))})):this.then(t,t)};var q=z;function z(e){if(this[E]=I++,this._result=this._state=void 0,this._subscribers=[],A!==e){if("function"!=typeof e)throw new TypeError("You must pass a resolver function as the first argument to the promise constructor");if(!(this instanceof z))throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be calle\
d as a function.");var t=this;try{e((function(e){N(t,e)}),(function(e){_(t,e)}))}catch(e){_(t,e)}}}return q.prototype.then=w,q.all=function(e){return new j(this,e).promise},q.race=function(e){var t=this;return o(e)?new t((function(n,r){for(var a=e.length,o=0;o<a;o++)t.resolve(e[o]).then(n,r)})):new t((function(e,t){return t(new TypeError("You must pass an array to race."))}))},q.resolve=x,q.reject=function(e){var t=new this(A);return _(t,e),t},q._setScheduler=function(e){u=e},q._setAsap=function(e){s=e},q._asap=s,q.polyfill=function(){var e=void 0;if(void 0!==n)e=n;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var r=null;try{r=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===r&&!t.cast)return}e.Promise=q},q.Promise=q},"object"===a(e)&&void 0!==o?o.exports=i():"function"==typeof define&&define.amd?define(i)\
:e.ES6Promise=i()})),De=se((function(e){var t,n,r=1e5,o=(t=Object.prototype.toString,n=Object.prototype.hasOwnProperty,{Class:function(e){return t.call(e).replace(/^\\[object *|\\]$/g,"")},HasProperty:function(e,t){return t in e},HasOwnProperty:function(e,t){return n.call(e,t)},IsCallable:function(e){return"function"==typeof e},ToInt32:function(e){return e>>0},ToUint32:function(e){return e>>>0}}),i=Math.LN2,l=Math.abs,u=Math.floor,s=Math.log,c=Math.min,d=Math.pow,p=Math.round;function f(e,t,n){return e<t?t:n<e?n:e}var m,h,g,v,b,y,D,w,x,E,A,F=Object.getOwnPropertyNames||function(e){if(e!==Object(e))throw new TypeError("Object.getOwnPropertyNames called on non-object");var t,n=[];for(t in e)o.HasOwnProperty(e,t)&&n.push(t);return n};function C(e){if(F&&m)for(var t=F(e),n=0;n<t.length;n+=1)m(e,t[n],{value:e[t[n]],writable:!1,enumerable:!1,configurable:!1})}function k(e){if(m){if(e.length>r)throw new RangeError("Array too large for polyfill");for(var t=0;t<e.length;t+=1)(t=>{m(e,t,{get:funct\
ion(){return e._getter(t)},set:function(n){e._setter(t,n)},enumerable:!0,configurable:!1})})(t)}}function R(e,t){return e<<(t=32-t)>>t}function N(e,t){return e<<(t=32-t)>>>t}function T(e){return N(e[0],8)}function S(e,t,n){var r,a,o,p,f,m,h,g=(1<<t-1)-1;function v(e){var t=u(e);return(e=e-t)<.5||!(.5<e||t%2)?t:t+1}for(e!=e?(a=(1<<t)-1,o=d(2,n-1),r=0):e===1/0||e===-1/0?(a=(1<<t)-1,r=e<(o=0)?1:0):0===e?r=1/e==-1/(o=a=0)?1:0:(r=e<0,(e=l(e))>=d(2,1-g)?(a=c(u(s(e)/i),1023),2<=(o=v(e/d(2,a)*d(2,n)))/d(2,n)&&(a+=1,o=1),g<a?(a=(1<<t)-1,o=0):(a+=g,o-=d(2,n))):(a=0,o=v(e/d(2,1-g-n)))),f=[],p=n;p;--p)f.push(o%2?1:0),o=u(o/2);for(p=t;p;--p)f.push(a%2?1:0),a=u(a/2);for(f.push(r?1:0),f.reverse(),m=f.join(""),h=[];m.length;)h.push(parseInt(m.substring(0,8),2)),m=m.substring(8);return h}function _(e,t,n){for(var r,a,o,i,l,u,s=[],c=e.length;c;--c)for(a=e[c-1],r=8;r;--r)s.push(a%2?1:0),a>>=1;return s.reverse(),u=s.join(""),o=(1<<t-1)-1,i=parseInt(u.substring(0,1),2)?-1:1,l=parseInt(u.substring(1,1+t),2)\
,u=parseInt(u.substring(1+t),2),l===(1<<t)-1?0===u?1/0*i:NaN:0<l?i*d(2,l-o)*(1+u/d(2,n)):0!==u?i*d(2,-(o-1))*(u/d(2,n)):i<0?-0:0}function O(e){if((e=o.ToInt32(e))<0)throw new RangeError("ArrayBuffer size is not a small enough positive integer");var t;for(this.byteLength=e,this._bytes=[],this._bytes.length=e,t=0;t<this.byteLength;t+=1)this._bytes[t]=0;C(this)}function M(){}function P(e,t,n){var r=function(e,t,n){var i,l,u,s;if(arguments.length&&"number"!=typeof e)if("object"===a(e)&&e.constructor===r)for(this.length=(i=e).length,this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new O(this.byteLength),u=this.byteOffset=0;u<this.length;u+=1)this._setter(u,i._getter(u));else if("object"!==a(e)||e instanceof O||"ArrayBuffer"===o.Class(e)){if("object"!==a(e)||!(e instanceof O||"ArrayBuffer"===o.Class(e)))throw new TypeError("Unexpected argument type(s)");if(this.buffer=e,this.byteOffset=o.ToUint32(t),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of \
range");if(this.byteOffset%this.BYTES_PER_ELEMENT)throw new RangeError("ArrayBuffer length minus the byteOffset is not a multiple of the element size.");if(arguments.length<3){if(this.byteLength=this.buffer.byteLength-this.byteOffset,this.byteLength%this.BYTES_PER_ELEMENT)throw new RangeError("length of buffer minus byteOffset not a multiple of the element size");this.length=this.byteLength/this.BYTES_PER_ELEMENT}else this.length=o.ToUint32(n),this.byteLength=this.length*this.BYTES_PER_ELEMENT;if(this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer")}else for(this.length=o.ToUint32((l=e).length),this.byteLength=this.length*this.BYTES_PER_ELEMENT,this.buffer=new O(this.byteLength),u=this.byteOffset=0;u<this.length;u+=1)s=l[u],this._setter(u,Number(s));else{if(this.length=o.ToInt32(e),n<0)throw new RangeError("ArrayBufferView size is not a small enough positive integer");this.byteLength=this.leng\
th*this.BYTES_PER_ELEMENT,this.buffer=new O(this.byteLength),this.byteOffset=0}this.constructor=r,C(this),k(this)};return(r.prototype=new M).BYTES_PER_ELEMENT=e,r.prototype._pack=t,r.prototype._unpack=n,r.BYTES_PER_ELEMENT=e,r.prototype.get=r.prototype._getter=function(e){if(arguments.length<1)throw new SyntaxError("Not enough arguments");if(!((e=o.ToUint32(e))>=this.length)){for(var t=[],n=0,r=this.byteOffset+e*this.BYTES_PER_ELEMENT;n<this.BYTES_PER_ELEMENT;n+=1,r+=1)t.push(this.buffer._bytes[r]);return this._unpack(t)}},r.prototype._setter=function(e,t){if(arguments.length<2)throw new SyntaxError("Not enough arguments");if((e=o.ToUint32(e))<this.length)for(var n=this._pack(t),r=0,a=this.byteOffset+e*this.BYTES_PER_ELEMENT;r<this.BYTES_PER_ELEMENT;r+=1,a+=1)this.buffer._bytes[a]=n[r]},r.prototype.set=function(e,t){if(arguments.length<1)throw new SyntaxError("Not enough arguments");var n,r,i,l,u,s,c,d,p,f;if("object"===a(e)&&e.constructor===this.constructor){if(n=e,(i=o.ToUint32(t))+n\
.length>this.length)throw new RangeError("Offset plus length of array is out of range");if(d=this.byteOffset+i*this.BYTES_PER_ELEMENT,p=n.length*this.BYTES_PER_ELEMENT,n.buffer===this.buffer){for(f=[],u=0,s=n.byteOffset;u<p;u+=1,s+=1)f[u]=n.buffer._bytes[s];for(u=0,c=d;u<p;u+=1,c+=1)this.buffer._bytes[c]=f[u]}else for(u=0,s=n.byteOffset,c=d;u<p;u+=1,s+=1,c+=1)this.buffer._bytes[c]=n.buffer._bytes[s]}else{if("object"!==a(e)||void 0===e.length)throw new TypeError("Unexpected argument type(s)");if(l=o.ToUint32((r=e).length),(i=o.ToUint32(t))+l>this.length)throw new RangeError("Offset plus length of array is out of range");for(u=0;u<l;u+=1)s=r[u],this._setter(i+u,Number(s))}},r.prototype.subarray=function(e,t){return e=o.ToInt32(e),t=o.ToInt32(t),arguments.length<1&&(e=0),arguments.length<2&&(t=this.length),e<0&&(e=this.length+e),t<0&&(t=this.length+t),e=f(e,0,this.length),t=(t=f(t,0,this.length))-e,new this.constructor(this.buffer,this.byteOffset+e*this.BYTES_PER_ELEMENT,t=t<0?0:t)},r}fun\
ction I(e,t){return o.IsCallable(e.get)?e.get(t):e[t]}function B(t,n,r){if(0===arguments.length)t=new e.ArrayBuffer(0);else if(!(t instanceof e.ArrayBuffer||"ArrayBuffer"===o.Class(t)))throw new TypeError("TypeError");if(this.buffer=t||new e.ArrayBuffer(0),this.byteOffset=o.ToUint32(n),this.byteOffset>this.buffer.byteLength)throw new RangeError("byteOffset out of range");if(this.byteLength=arguments.length<3?this.buffer.byteLength-this.byteOffset:o.ToUint32(r),this.byteOffset+this.byteLength>this.buffer.byteLength)throw new RangeError("byteOffset and length reference an area beyond the end of the buffer");C(this)}function j(t){return function(n,r){if((n=o.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");n+=this.byteOffset;for(var a=new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT),i=[],l=0;l<t.BYTES_PER_ELEMENT;l+=1)i.push(I(a,l));return Boolean(r)===Boolean(A)&&i.reverse(),I(new t(new e.Uint8Array(i).buffer),0)}}function L(t){return f\
unction(n,r,a){if((n=o.ToUint32(n))+t.BYTES_PER_ELEMENT>this.byteLength)throw new RangeError("Array index out of range");r=new t([r]);for(var i=new e.Uint8Array(r.buffer),l=[],u=0;u<t.BYTES_PER_ELEMENT;u+=1)l.push(I(i,u));Boolean(a)===Boolean(A)&&l.reverse(),new e.Uint8Array(this.buffer,n,t.BYTES_PER_ELEMENT).set(l)}}m=Object.defineProperty&&(()=>{try{return Object.defineProperty({},"x",{}),1}catch(e){}})()?Object.defineProperty:function(e,t,n){if(!e===Object(e))throw new TypeError("Object.defineProperty called on non-object");return o.HasProperty(n,"get")&&Object.prototype.__defineGetter__&&Object.prototype.__defineGetter__.call(e,t,n.get),o.HasProperty(n,"set")&&Object.prototype.__defineSetter__&&Object.prototype.__defineSetter__.call(e,t,n.set),o.HasProperty(n,"value")&&(e[t]=n.value),e},e.ArrayBuffer=e.ArrayBuffer||O,E=P(1,(function(e){return[255&e]}),(function(e){return R(e[0],8)})),h=P(1,(function(e){return[255&e]}),T),g=P(1,(function(e){return[(e=p(Number(e)))<0?0:255<e?255:255&\
e]}),T),v=P(2,(function(e){return[e>>8&255,255&e]}),(function(e){return R(e[0]<<8|e[1],16)})),b=P(2,(function(e){return[e>>8&255,255&e]}),(function(e){return N(e[0]<<8|e[1],16)})),y=P(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return R(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),D=P(4,(function(e){return[e>>24&255,e>>16&255,e>>8&255,255&e]}),(function(e){return N(e[0]<<24|e[1]<<16|e[2]<<8|e[3],32)})),w=P(4,(function(e){return S(e,8,23)}),(function(e){return _(e,8,23)})),x=P(8,(function(e){return S(e,11,52)}),(function(e){return _(e,11,52)})),e.Int8Array=e.Int8Array||E,e.Uint8Array=e.Uint8Array||h,e.Uint8ClampedArray=e.Uint8ClampedArray||g,e.Int16Array=e.Int16Array||v,e.Uint16Array=e.Uint16Array||b,e.Int32Array=e.Int32Array||y,e.Uint32Array=e.Uint32Array||D,e.Float32Array=e.Float32Array||w,e.Float64Array=e.Float64Array||x,E=new e.Uint16Array([4660]),A=18===I(new e.Uint8Array(E.buffer),0),B.prototype.getUint8=j(e.Uint8Array),B.prototype.getInt8=j(e.Int8Array),B.pr\
ototype.getUint16=j(e.Uint16Array),B.prototype.getInt16=j(e.Int16Array),B.prototype.getUint32=j(e.Uint32Array),B.prototype.getInt32=j(e.Int32Array),B.prototype.getFloat32=j(e.Float32Array),B.prototype.getFloat64=j(e.Float64Array),B.prototype.setUint8=L(e.Uint8Array),B.prototype.setInt8=L(e.Int8Array),B.prototype.setUint16=L(e.Uint16Array),B.prototype.setInt16=L(e.Int16Array),B.prototype.setUint32=L(e.Uint32Array),B.prototype.setInt32=L(e.Int32Array),B.prototype.setFloat32=L(e.Float32Array),B.prototype.setFloat64=L(e.Float64Array),e.DataView=e.DataView||B})),we=se((function(e){function r(){if(void 0===this)throw new TypeError("Constructor WeakMap requires 'new'");if(c(this,"_id","_WeakMap_"+i()+"."+i()),0<arguments.length)throw new TypeError("WeakMap iterable is not supported")}function o(e,t){if(!l(e)||!u.call(e,"_id"))throw new TypeError(t+" method called on incompatible receiver "+a(e))}function i(){return Math.random().toString().substring(2)}function l(e){return Object(e)===e}var u\
,s,c;(e="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:void 0!==t?t:void 0!==n?n:e).WeakMap||(u=Object.prototype.hasOwnProperty,s=Object.defineProperty&&(()=>{try{return 1===Object.defineProperty({},"x",{value:1}).x}catch(e){}})(),e.WeakMap=((c=function(e,t,n){s?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n})(r.prototype,"delete",(function(e){var t;return o(this,"delete"),!!l(e)&&!(!(t=e[this._id])||t[0]!==e||(delete e[this._id],0))})),c(r.prototype,"get",(function(e){var t;return o(this,"get"),l(e)&&(t=e[this._id])&&t[0]===e?t[1]:void 0})),c(r.prototype,"has",(function(e){var t;return o(this,"has"),!!l(e)&&!(!(t=e[this._id])||t[0]!==e)})),c(r.prototype,"set",(function(e,t){var n;if(o(this,"set"),l(e))return(n=e[this._id])&&n[0]===e?n[1]=t:c(e,this._id,[e,t]),this;throw new TypeError("Invalid value used as weak map key")})),c(r,"_polyfill",!0),r))})),xe=se((function(e,r){function o(e){return e&&e.Math===Math&&e}r.exports=o("object"==("\
undefined"==typeof globalThis?"undefined":a(globalThis))&&globalThis)||o("object"==(void 0===t?"undefined":a(t))&&t)||o("object"==("undefined"==typeof self?"undefined":a(self))&&self)||o("object"==(void 0===n?"undefined":a(n))&&n)||o("object"==a(e)&&e)||function(){return this}()||Function("return this")()})),Ee=se((function(e,t){t.exports=function(e){try{return!!e()}catch(e){return!0}}})),Ae=se((function(e,t){var n=Ee();t.exports=!n((function(){var e=function(){}.bind();return"function"!=typeof e||e.hasOwnProperty("prototype")}))})),Fe=se((function(e,t){var n=Ae(),r=Function.prototype,o=r.apply,i=r.call;t.exports="object"==("undefined"==typeof Reflect?"undefined":a(Reflect))&&Reflect.apply||(n?i.bind(o):function(){return i.apply(o,arguments)})})),Ce=se((function(e,t){var n=Ae(),r=(a=Function.prototype).call,a=n&&a.bind.bind(r,r);t.exports=n?a:function(e){return function(){return r.apply(e,arguments)}}})),ke=se((function(e,t){var n=Ce(),r=n({}.toString),a=n("".slice);t.exports=function(\
e){return a(r(e),8,-1)}})),Re=se((function(e,t){var n=ke(),r=Ce();t.exports=function(e){if("Function"===n(e))return r(e)}})),Ne=se((function(e,t){var n="object"==(void 0===r?"undefined":a(r))&&r.all;t.exports=void 0===n&&void 0!==n?function(e){return"function"==typeof e||e===n}:function(e){return"function"==typeof e}})),Te=se((function(e,t){var n=Ee();t.exports=!n((function(){return 7!==Object.defineProperty({},1,{get:function(){return 7}})[1]}))})),Se=se((function(e,t){var n=Ae(),r=Function.prototype.call;t.exports=n?r.bind(r):function(){return r.apply(r,arguments)}})),_e=se((function(e){var t={}.propertyIsEnumerable,n=Object.getOwnPropertyDescriptor,r=n&&!t.call({1:2},1);e.f=r?function(e){return!!(e=n(this,e))&&e.enumerable}:t})),Oe=se((function(e,t){t.exports=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}}})),Me=se((function(e,t){var n=Ce(),r=Ee(),a=ke(),o=Object,i=n("".split);t.exports=r((function(){return!o("z").propertyIsEnumerable(0)}))?funct\
ion(e){return"String"===a(e)?i(e,""):o(e)}:o})),Pe=se((function(e,t){t.exports=function(e){return null==e}})),Ie=se((function(e,t){var n=Pe(),r=TypeError;t.exports=function(e){if(n(e))throw new r("Can't call method on "+e);return e}})),Be=se((function(e,t){var n=Me(),r=Ie();t.exports=function(e){return n(r(e))}})),je=se((function(e,t){var n=Ne();t.exports=function(e){return"object"==a(e)?null!==e:n(e)}})),Le=se((function(e,t){t.exports={}})),qe=se((function(e,t){function n(e){return o(e)?e:vo