import '../../ui/components/highlighting/highlighting.js';
import type * as Common from '../../core/common/common.js';
import * as Workspace from '../../models/workspace/workspace.js';
import * as QuickOpen from '../../ui/legacy/components/quick_open/quick_open.js';
import { type TemplateResult } from '../../ui/lit/lit.js';
export declare class FilteredUISourceCodeListProvider extends QuickOpen.FilteredListWidget.Provider {
    private queryLineNumberAndColumnNumber;
    private defaultScores;
    private scorer;
    private uiSourceCodes;
    private readonly uiSourceCodeIds;
    private query;
    constructor(jslogContext: string);
    private projectRemoved;
    private populate;
    private filterUISourceCode;
    uiSourceCodeSelected(_uiSourceCode: Workspace.UISourceCode.UISourceCode | null, _lineNumber?: number, _columnNumber?: number): void;
    filterProject(_project: Workspace.Workspace.Project): boolean;
    itemCount(): number;
    itemContentTypeAt(itemIndex: number): Common.ResourceType.ResourceType;
    itemKeyAt(itemIndex: number): string;
    setDefaultScores(defaultScores: Map<Workspace.UISourceCode.UISourceCode, number> | null): void;
    itemScoreAt(itemIndex: number, query: string): number;
    renderItem(itemIndex: number, query: string): TemplateResult;
    private renderSubtitleElement;
    selectItem(itemIndex: number | null, promptValue: string): void;
    rewriteQuery(query: string): string;
    private uiSourceCodeAdded;
    notFoundText(): string;
    attach(): void;
    detach(): void;
}
