import"../../ui/components/switch/switch.js";import{createIcon as e}from"../../ui/kit/kit.js";import"../../ui/components/chrome_link/chrome_link.js";import*as t from"../../core/common/common.js";import*as i from"../../core/host/host.js";import*as s from"../../core/i18n/i18n.js";import*as r from"../../core/root/root.js";import*as o from"../../core/sdk/sdk.js";import"../../ui/components/buttons/buttons.js";import*as n from"../../ui/components/input/input.js";import*as a from"../../ui/i18n/i18n.js";import*as c from"../../ui/legacy/legacy.js";import*as l from"../../ui/lit/lit.js";import{Directives as d,html as u,nothing as h,render as g}from"../../ui/lit/lit.js";import*as p from"../../ui/visual_logging/visual_logging.js";import"../../ui/legacy/components/data_grid/data_grid.js";import*as m from"../../core/platform/platform.js";import*as y from"../../models/issues_manager/issues_manager.js";import*as v from"../network/forward/forward.js";var w=`.overflow-auto{height:100%}.controls{display:flex;flex-direction:column;padding:var(--sys-size-5) var(--sys-size-3) var(--sys-size-5) var(--sys-size-5);min-width:var(--sys-size-33)}.header{display:flex;flex-direction:column;gap:var(--sys-size-2);padding-left:var(--sys-size-5)}h1{margin:0;font:var(--sys-typescale-headline4)}.card-container{max-width:100%}.card{display:flex;flex-direction:column;padding:var(--sys-size-6) var(--sys-size-8);gap:var(--sys-size-6);&.enterprise-disabled{color:var(--sys-color-token-subtle)}}.card-header{display:flex;align-items:center}.card-header > .lhs{width:100%;display:flex;justify-content:space-between;align-items:center;padding-right:var(--sys-size-9);& > devtools-icon{height:var(--sys-size-11);width:var(--sys-size-11)}}.text{display:flex;flex-direction:column;gap:var(--sys-size-2)}h2{font:var(--sys-typescale-headline5);margin:0}.body{font:var(--sys-typescale-body4-regular)}.checkbox-label{gap:var(--sys-size-8);display:flex;align-items:center}.card-row{padding-top:var(--sys-size-4);padding-bottom:var(--sys-size-4);padding-left:var(--sys-size-8)}h3{font:var(--sys-typescale-body4-medium);margin:0}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.enterprise{display:flex;flex-direction:row;justify-content:space-between;gap:var(--sys-size-9);padding:var(--sys-size-6) var(--sys-size-8) var(--sys-size-6) var(--sys-size-11);align-items:center;> .anchor{display:flex;flex-direction:row;gap:var(--sys-size-9)}}input[type="checkbox"]{flex-shrink:0}.main-text{color:var(--sys-color-on-surface)}.subtext{color:var(--sys-color-on-surface-subtle)}\n/*# sourceURL=${import.meta.resolve("./cookieControlsView.css")} */`;const{ref:S}=d,b={viewTitle:"Controls",viewExplanation:"Test how this site will perform if third-party cookies are limited in ChatGPT Atlas",cardTitle:"Temporarily limit third-party cookies",cardDisclaimer:"Only when DevTools is open",siteReloadMessage:"To apply your updated controls, reload the page",exceptions:"Exceptions",exceptionsExplanation:"Scenarios that grant access to third-party cookies",gracePeriodTitle:"Third-party cookie grace period",gracePeriodExplanation:"If this site or a site embedded on it is enrolled in the {PH1}, then the site can access third-party cookies",enrollGracePeriod:"To use this, enroll this site or sites embedded on it in the {PH1}",gracePeriod:"grace period",heuristicTitle:"Heuristics based exception",heuristicExplanation:"In {PH1} like pop-ups or redirects, a site embedded on this site can access third-party cookies",scenarios:"predefined scenarios",enterpriseDisclaimer:"Your organization manages third-party cookie access for this site",enterpriseTooltip:"This setting is managed by your organization",viewDetails:"View details",enableFlag:"To use this, set {PH1} to Default",tpcdMetadataGrants:"#tpcd-metadata-grants",tpcdHeuristicsGrants:"#tpcd-heuristics-grants"},k=s.i18n.registerUIStrings("panels/security/CookieControlsView.ts",b),f=s.i18n.getLocalizedString.bind(void 0,k),x=a.getFormatLocalizedString.bind(void 0,k);function C(e){return u`
    <devtools-chrome-link href="chrome://flags/#${e}" tabindex="0">
     ${e}
    </devtools-chrome-link>`}const T=(e,i,s)=>{const r=t.Settings.Settings.instance().createSetting("enterprise-enabled",!(!e.thirdPartyControlsDict||!e.thirdPartyControlsDict.managedBlockThirdPartyCookies||"boolean"!=typeof e.thirdPartyControlsDict.managedBlockThirdPartyCookies)&&e.thirdPartyControlsDict.managedBlockThirdPartyCookies,"Global"),o=t.Settings.Settings.instance().createSetting("cookie-control-override-enabled",!!e.thirdPartyControlsDict?.thirdPartyCookieRestrictionEnabled&&e.thirdPartyControlsDict.thirdPartyCookieRestrictionEnabled,"Global"),n=t.Settings.Settings.instance().createSetting("grace-period-mitigation-disabled",!e.thirdPartyControlsDict?.thirdPartyCookieMetadataEnabled||e.thirdPartyControlsDict.thirdPartyCookieMetadataEnabled,"Global"),a=t.Settings.Settings.instance().createSetting("heuristic-mitigation-disabled",!e.thirdPartyControlsDict?.thirdPartyCookieHeuristicsEnabled||e.thirdPartyControlsDict.thirdPartyCookieHeuristicsEnabled,"Global"),l=u`
      <div class="card-header">
        <div class="lhs">
          <div class="text">
            <h2 class="main-text">${f(b.cardTitle)}</h2>
            <div class="body subtext">${f(b.cardDisclaimer)}</div>
          </div>
          ${Boolean(r.get())?u`
            <devtools-icon
              tabindex="0"
              name="domain"
              ${S(e=>{c.Tooltip.Tooltip.install(e,f(b.enterpriseTooltip)),e.role="img"})}>
            </devtools-icon>`:h}
        </div>
        <div>
          <devtools-switch
            .checked=${Boolean(o.get())}
            .disabled=${Boolean(r.get())}
            .label=${"Temporarily limit third-party cookies, only when DevTools is open"}
            data-testid="cookie-control-override"
            @switchchange=${()=>{e.inputChanged(!o.get(),o)}}
            jslog=${p.toggle(o.name).track({click:!0})}
          >
          </devtools-switch>
        </div>
      </div>
    `,d=!!e.thirdPartyControlsDict&&!e.thirdPartyControlsDict.thirdPartyCookieMetadataEnabled||r.get()||!o.get()||!e.isGracePeriodActive,m=u`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${d}
            .checked=${!d&&!Boolean(n.get())}
            @change=${()=>{e.inputChanged(!n.get(),n)}}
            jslog=${p.toggle(n.name).track({click:!0})}
          >
          <div class="text">
            <div class="body main-text">${f(b.gracePeriodTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?x(b.gracePeriodExplanation,{PH1:f(b.gracePeriod)}):e.thirdPartyControlsDict&&!e.thirdPartyControlsDict?.thirdPartyCookieMetadataEnabled?x(b.enableFlag,{PH1:C(b.tpcdMetadataGrants)}):x(e.isGracePeriodActive?b.gracePeriodExplanation:b.enrollGracePeriod,{PH1:c.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period" jslog=${p.link("grace-period-link").track({click:!0})}>${f(b.gracePeriod)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,y=!!e.thirdPartyControlsDict&&!e.thirdPartyControlsDict.thirdPartyCookieHeuristicsEnabled||r.get()||!o.get(),v=u`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${y}
            .checked=${!y&&!Boolean(a.get())}
            @change=${()=>{e.inputChanged(!a.get(),a)}}
            jslog=${p.toggle(a.name).track({click:!0})}
          >
          <div class='text'>
            <div class="body main-text">${f(b.heuristicTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?x(b.heuristicExplanation,{PH1:f(b.scenarios)}):e.thirdPartyControlsDict&&!e.thirdPartyControlsDict.thirdPartyCookieHeuristicsEnabled?x(b.enableFlag,{PH1:C(b.tpcdHeuristicsGrants)}):x(b.heuristicExplanation,{PH1:c.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/heuristics-based-exceptions" jslog=${p.link("heuristic-link").track({click:!0})}>${f(b.scenarios)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,w=u`
      <div class="enterprise">
        <div class="text body">${f(b.enterpriseDisclaimer)}</div>
          <div class="anchor">
            <devtools-icon
            name="domain"
            ></devtools-icon>
            <devtools-button
            @click=${e.openChromeCookieSettings}
            aria-label="View details of third-party cookie access in Settings"
            .variant=${"outlined"}
            jslog=${p.action("view-details").track({click:!0})}>
            ${f(b.viewDetails)}
          </devtools-button>
        </div>
      </div>
    `;g(u`
      <div class="overflow-auto">
        <div class="controls">
          <div class="header">
            <h1>${f(b.viewTitle)}</h1>
            <div class="body">${f(b.viewExplanation)}</div>
          </div>
          <devtools-card class="card-container">
            <div class=${Boolean(r.get())?"card enterprise-disabled":"card"}>
              ${l}
              <div>
                <div class="card-row text">
                  <h3 class="main-text">${f(b.exceptions)}</h3>
                  <div class="body subtext">${f(b.exceptionsExplanation)}</div>
                </div>
                ${m}
                ${v}
              </div>
            </div>
          </devtools-card>
          ${Boolean(r.get())?w:h}
        </div>
      </div>
    `,s)};function E(){c.InspectorView.InspectorView.instance().displayDebuggedTabReloadRequiredWarning(f(b.siteReloadMessage))}class I extends c.Widget.VBox{#e;#t;#i;constructor(e,t=T){super(e,{useShadowDom:!0}),this.#e=t,this.#t=!1,this.#i=r.Runtime.hostConfig.thirdPartyCookieControls,this.registerRequiredCSS(n.checkboxStyles,w),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.ResourceAdded,this.checkGracePeriodActive,this),this.checkGracePeriodActive().catch(e=>{console.error(e)}),this.requestUpdate()}performUpdate(){this.#e({thirdPartyControlsDict:this.#i,isGracePeriodActive:this.#t,inputChanged:this.inputChanged.bind(this),openChromeCookieSettings:this.openChromeCookieSettings.bind(this)},this,this.contentElement)}inputChanged(e,t){t.set(e),E(),this.requestUpdate()}openChromeCookieSettings(){const e=o.TargetManager.TargetManager.instance().rootTarget();if(null===e)return;const t="chrome://settings/cookies";e.targetAgent().invoke_createTarget({url:t}).then(e=>{e.getError()&&i.InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(t)})}#s(){this.#t=!1,this.checkGracePeriodActive().catch(e=>{console.error(e)})}async checkGracePeriodActive(e){if(!this.#i||!this.#i.thirdPartyCookieMetadataEnabled)return;if(this.#t)return;const t=o.TargetManager.TargetManager.instance().primaryPageTarget();if(!t)return;const i=[];if(e)i.push(e.data.url);else for(const e of o.TargetManager.TargetManager.instance().models(o.ResourceTreeModel.ResourceTreeModel))e.forAllResources(e=>(i.push(e.url),!0));const s=await t.storageAgent().invoke_getAffectedUrlsForThirdPartyCookieMetadata({firstPartyUrl:t.inspectedURL(),thirdPartyUrls:i});s.matchedUrls&&s.matchedUrls.length>0&&(this.#t=!0,this.requestUpdate())}}var R=Object.freeze({__proto__:null,CookieControlsView:I,i18nFormatString:x,i18nString:f,showInfobar:E}),P=`.report{display:flex;flex-direction:column;width:100%;height:100%;max-height:100%;gap:var(--sys-size-6);padding-top:var(--sys-size-5)}.header{display:flex;flex-direction:column;flex-shrink:0;gap:var(--sys-size-2);padding-left:var(--sys-size-6);padding-right:var(--sys-size-6);min-width:var(--sys-size-31);h1{font:var(--sys-typescale-headline4);margin:0}}.body{font:var(--sys-typescale-body4-regular)}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.filter{padding-right:var(--sys-size-6);flex-shrink:0}.filters-container{display:flex;padding-left:var(--sys-size-5)}devtools-data-grid{flex:auto;margin-left:-1px}.empty-report{display:flex;flex-direction:column;align-items:center;gap:var(--sys-size-2);padding:var(--sys-size-11) var(--sys-size-6) 0 var(--sys-size-6);flex-shrink:0;min-width:var(--sys-size-31)}.empty-report-title{font:var(--sys-typescale-headline5)}.cookie-off{width:var(--sys-size-11);height:var(--sys-size-11)}\n/*# sourceURL=${import.meta.resolve("./cookieReportView.css")} */`;const{render:A,html:L,Directives:{ref:M}}=l,D={title:"Third-party cookies",body:"This site might not work if third-party cookies and other cookies are limited in Chrome.",learnMoreLink:"Learn more about how third-party cookies are used",name:"Name",domain:"Domain",type:"Type",platform:"Platform",recommendation:"Recommendation",status:"Status",allowed:"Allowed",allowedByException:"Allowed by exception",blocked:"Blocked",unknown:"Unknown",report:"Third-Party Cookie Report",emptyReport:"Not a crumb left",emptyReportExplanation:"No issues with third-party cookies found",gitHubResource:"Review {PH1} from third-party site",guidance:"guidance",gracePeriod:"Review {PH1}. Grace period exception is active.",reportedIssues:"reported issues",heuristics:"Action needed later. Heuristics based exception is active.",other:"Contact third-party site for more info",adCookieTypeString:"Advertising",analyticsCookieTypeString:"Analytics",socialCookieTypeString:"Social",videoCookieTypeString:"Video",utilityCookieTypeString:"Utility",hostingCookieTypeString:"Hosting",marketingCookieTypeString:"Marketing",customerSuccessCookieTypeString:"Customer Success",contentCookieTypeString:"Content",cdnCookieTypeString:"CDN",tagManagerCookieTypeString:"Tag Manager",consentProviderCookieTypeString:"Consent Provider",otherCookieTypeString:"Other",showRequestsWithThisCookie:"Show requests with this cookie"},H=s.i18n.registerUIStrings("panels/security/CookieReportView.ts",D),U=s.i18n.getLocalizedString.bind(void 0,H),F=(e,t,i)=>{A(L`
        <div class="report overflow-auto">
            <div class="header">
              <h1>${U(D.title)}</h1>
              <div class="body">${U(D.body)} <x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/prepare/audit-cookies" jslog=${p.link("learn-more").track({click:!0})}>${U(D.learnMoreLink)}</x-link></div>
            </div>
            ${e.cookieRows.length>0?L`
                <div class="filters-container">
                  <devtools-toolbar>
                    <devtools-toolbar-input
                      type="filter"
                      style="flex-grow: 0.4;"
                      @change=${e.onSearchFilterChanged}
                      value=${e.searchText}
                    ></devtools-toolbar-input>
                  </devtools-toolbar>
                  <devtools-named-bit-set-filter
                    class="filter"
                    aria-label="Third-party cookie status filters"
                    @filterChanged=${e.onFilterChanged}
                    .options=${{items:e.filterItems}}
                    ${M(e=>{e instanceof c.FilterBar.NamedBitSetFilterUIElement&&(t.namedBitSetFilterUI=e.getOrCreateNamedBitSetFilterUI())})}
                  ></devtools-named-bit-set-filter>
                </div>
                <!-- @ts-ignore -->
                <devtools-data-grid
                  name=${U(D.report)}
                  striped
                  .filters=${e.filters}
                  @sort=${e.onSortingChanged}
                  @contextmenu=${e.populateContextMenu.bind(e)}
                >
                  <table>
                    <tr>
                      <th id="name" sortable>${U(D.name)}</th>
                      <th id="domain" sortable>${U(D.domain)}</th>
                      <th id="type" sortable>${U(D.type)}</th>
                      <th id="platform" sortable>${U(D.platform)}</th>
                      <th id="status" sortable>${U(D.status)}</th>
                      <th id="recommendation" sortable>${U(D.recommendation)}</th>
                    </tr>
                    ${[...e.cookieRows.values()].map(e=>L`
                      <tr data-name=${e.name} data-domain=${e.domain}>
                        <td>${e.name}</td>
                        <td>${e.domain}</td>
                        <td>${$.getCookieTypeString(e.type)}</td>
                        <td>${e.platform??U(D.unknown)}</td>
                        <td>${$.getStatusString(e.status)}</td>
                        <td>${$.getRecommendation(e.domain,e.insight)}</td>
                      </tr>
                    `)}
                  </table>
                </devtools-data-grid>
              `:L`
                <div class="empty-report">
                  <devtools-icon
                    class="cookie-off"
                    name="cookie_off"
                  ></devtools-icon>
                  <div class="empty-report-title">
                    ${U(D.emptyReport)}
                  </div>
                  <div class="body">
                    ${U(D.emptyReportExplanation)}
                  </div>
                </div>
              `}

        </div>
    `,i)};class $ extends c.Widget.VBox{#r;namedBitSetFilterUI;#o=new Map;#e;filterItems=[];searchText;constructor(e,i=F){super(e,{useShadowDom:!0}),this.#e=i,this.registerRequiredCSS(P),this.searchText=t.Settings.Settings.instance().createSetting("cookie-report-search-query","").get(),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),this.#r=y.IssuesManager.IssuesManager.instance(),this.#r.addEventListener("IssueAdded",this.#n,this);for(const e of this.#r.issues())e instanceof y.CookieIssue.CookieIssue&&this.#a(e);this.requestUpdate()}performUpdate(){this.filterItems=this.#c();const e={cookieRows:[...this.#o.values()].filter(e=>!this.namedBitSetFilterUI||this.namedBitSetFilterUI.accept($.getStatusString(e.status))),filters:[{key:"name,domain",regex:RegExp(m.StringUtilities.escapeForRegExp(this.searchText),"i"),negative:!1}],searchText:this.searchText,filterItems:this.filterItems,onSearchFilterChanged:e=>this.onSearchFilterChanged(e),onFilterChanged:()=>this.requestUpdate(),onSortingChanged:()=>this.requestUpdate(),populateContextMenu:this.populateContextMenu.bind(this)};this.#e(e,this,this.contentElement)}#s(){this.#o.clear(),this.namedBitSetFilterUI=void 0,this.requestUpdate()}#n(e){if(e.data.issue instanceof y.CookieIssue.CookieIssue){if(this.#o.has(e.data.issue.cookieId()))return;this.#a(e.data.issue),this.requestUpdate()}}#a(e){const t=e.makeCookieReportEntry();t&&this.#o.set(e.cookieId(),t)}onSearchFilterChanged(e){this.searchText=e.detail?e.detail:"",t.Settings.Settings.instance().createSetting("cookie-report-search-query","").set(this.searchText),this.requestUpdate()}#c(){const e=[];return this.#o.values().some(e=>0===e.status)&&e.push({name:D.blocked,label:()=>U(D.blocked),title:D.blocked,jslogContext:"blocked"}),this.#o.values().some(e=>1===e.status)&&e.push({name:D.allowed,label:()=>U(D.allowed),title:D.allowed,jslogContext:"allowed"}),this.#o.values().some(e=>2===e.status||3===e.status)&&e.push({name:D.allowedByException,label:()=>U(D.allowedByException),title:D.allowedByException,jslogContext:"allowed-by-exception"}),e}populateContextMenu(e){const{menu:i,element:s}=e.detail,{domain:r,name:o}=s?.dataset;r&&o&&i.revealSection().appendItem(U(D.showRequestsWithThisCookie),()=>{const e=v.UIFilter.UIRequestFilter.filters([{filterType:v.UIFilter.FilterType.CookieDomain,filterValue:r},{filterType:v.UIFilter.FilterType.CookieName,filterValue:o}]);t.Revealer.reveal(e)},{jslogContext:"show-requests-with-this-cookie"})}static getStatusString(e){switch(e){case 0:return U(D.blocked);case 2:case 3:return U(D.allowedByException);case 1:return U(D.allowed)}}static getRecommendation(e,t){const i=document.createElement("div");return A($.getRecommendationText(e,t),i,{host:this}),i}static getRecommendationText(e,i){if(!i)return L`${U(D.other)}`;switch(i.type){case"GitHubResource":{const e=c.XLink.XLink.create(i.tableEntryUrl?i.tableEntryUrl:"https://github.com/privacysandbox/privacy-sandbox-dev-support/blob/main/3pc-migration-readiness.md",U(D.guidance),void 0,void 0,"readiness-list-link");return L`${a.getFormatLocalizedString(H,D.gitHubResource,{PH1:e})}`}case"GracePeriod":{const i=o.TargetManager.TargetManager.instance().primaryPageTarget()?.inspectedURL(),s=c.XLink.XLink.create("https://developers.google.com/privacy-sandbox/cookies/dashboard?url="+(i?t.ParsedURL.ParsedURL.fromString(i)?.host+"+":"")+("."===e.charAt(0)?e.substring(1):e),U(D.reportedIssues),void 0,void 0,"compatibility-lookup-link");return L`${a.getFormatLocalizedString(H,D.gracePeriod,{PH1:s})}`}case"Heuristics":return L`${U(D.heuristics)}`;default:return L`${U(D.other)}`}}static getCookieTypeString(e){if(!e)return U(D.otherCookieTypeString);switch(e){case"ad":return U(D.adCookieTypeString);case"analytics":return U(D.analyticsCookieTypeString);case"social":return U(D.socialCookieTypeString);case"video":return U(D.videoCookieTypeString);case"utility":return U(D.utilityCookieTypeString);case"hosting":return U(D.hostingCookieTypeString);case"marketing":return U(D.marketingCookieTypeString);case"customer-success":return U(D.customerSuccessCookieTypeString);case"content":return U(D.contentCookieTypeString);case"cdn":return U(D.cdnCookieTypeString);case"tag-manager":return U(D.tagManagerCookieTypeString);case"consent-provider":return U(D.consentProviderCookieTypeString);default:return U(D.otherCookieTypeString)}}}var V=Object.freeze({__proto__:null,CookieReportView:$,i18nString:U});const O={theSecurityOfThisPageIsUnknown:"The security of this page is unknown.",thisPageIsNotSecure:"This page is not secure.",thisPageIsSecureValidHttps:"This page is secure (valid HTTPS).",thisPageIsNotSecureBrokenHttps:"This page is not secure (broken HTTPS).",cipherWithMAC:"{PH1} with {PH2}",keyExchangeWithGroup:"{PH1} with {PH2}"},N=s.i18n.registerUIStrings("panels/security/SecurityModel.ts",O),B=s.i18n.getLocalizedString.bind(void 0,N),z=s.i18n.getLazilyComputedLocalizedString.bind(void 0,N);class G extends o.SDKModel.SDKModel{dispatcher;securityAgent;constructor(e){super(e),this.dispatcher=new J(this),this.securityAgent=e.securityAgent(),e.registerSecurityDispatcher(this.dispatcher),this.securityAgent.invoke_enable()}resourceTreeModel(){return this.target().model(o.ResourceTreeModel.ResourceTreeModel)}networkManager(){return this.target().model(o.NetworkManager.NetworkManager)}}function q(e,t){const i=["info","insecure-broken","insecure","neutral","secure","unknown"];return i.indexOf(e)-i.indexOf(t)}var j;o.SDKModel.SDKModel.register(G,{capabilities:512,autostart:!1}),function(e){e.VisibleSecurityStateChanged="VisibleSecurityStateChanged"}(j||(j={}));const W={unknown:z(O.theSecurityOfThisPageIsUnknown),insecure:z(O.thisPageIsNotSecure),neutral:z(O.thisPageIsNotSecure),secure:z(O.thisPageIsSecureValidHttps),"insecure-broken":z(O.thisPageIsNotSecureBrokenHttps)};class _{securityState;certificateSecurityState;safetyTipInfo;securityStateIssueIds;constructor(e,t,i,s){this.securityState=e,this.certificateSecurityState=t?new K(t):null,this.safetyTipInfo=i?new X(i):null,this.securityStateIssueIds=s}}class K{protocol;keyExchange;keyExchangeGroup;cipher;mac;certificate;subjectName;issuer;validFrom;validTo;certificateNetworkError;certificateHasWeakSignature;certificateHasSha1Signature;modernSSL;obsoleteSslProtocol;obsoleteSslKeyExchange;obsoleteSslCipher;obsoleteSslSignature;constructor(e){this.protocol=e.protocol,this.keyExchange=e.keyExchange,this.keyExchangeGroup=e.keyExchangeGroup||null,this.cipher=e.cipher,this.mac=e.mac||null,this.certificate=e.certificate,this.subjectName=e.subjectName,this.issuer=e.issuer,this.validFrom=e.validFrom,this.validTo=e.validTo,this.certificateNetworkError=e.certificateNetworkError||null,this.certificateHasWeakSignature=e.certificateHasWeakSignature,this.certificateHasSha1Signature=e.certificateHasSha1Signature,this.modernSSL=e.modernSSL,this.obsoleteSslProtocol=e.obsoleteSslProtocol,this.obsoleteSslKeyExchange=e.obsoleteSslKeyExchange,this.obsoleteSslCipher=e.obsoleteSslCipher,this.obsoleteSslSignature=e.obsoleteSslSignature}isCertificateExpiringSoon(){const e=new Date(1e3*this.validTo).getTime();return e<new Date(Date.now()).setHours(48)&&e>Date.now()}getKeyExchangeName(){return this.keyExchangeGroup?this.keyExchange?B(O.keyExchangeWithGroup,{PH1:this.keyExchange,PH2:this.keyExchangeGroup}):this.keyExchangeGroup:this.keyExchange}getCipherFullName(){return this.mac?B(O.cipherWithMAC,{PH1:this.cipher,PH2:this.mac}):this.cipher}}class X{safetyTipStatus;safeUrl;constructor(e){this.safetyTipStatus=e.safetyTipStatus,this.safeUrl=e.safeUrl||null}}class Y{securityState;title;summary;description;certificate;mixedContentType;recommendations;constructor(e,t,i,s,r=[],o="none",n=[]){this.securityState=e,this.title=t,this.summary=i,this.description=s,this.certificate=r,this.mixedContentType=o,this.recommendations=n}}class J{model;constructor(e){this.model=e}securityStateChanged(e){}visibleSecurityStateChanged({visibleSecurityState:e}){const t=new _(e.securityState,e.certificateSecurityState||null,e.safetyTipInfo||null,e.securityStateIssueIds);this.model.dispatchEventToListeners(j.VisibleSecurityStateChanged,t)}certificateError(e){}}var Q=Object.freeze({__proto__:null,CertificateSecurityState:K,get Events(){return j},PageVisibleSecurityState:_,SecurityModel:G,SecurityStyleExplanation:Y,SummaryMessages:W,securityStateCompare:q}),Z=`.lock-icon,\n.security-property{height:var(--sys-size-9);width:var(--sys-size-9)}.lock-icon-secure{color:var(--sys-color-green)}.lock-icon-insecure{color:var(--sys-color-error)}.lock-icon-insecure-broken{color:var(--sys-color-error)}.security-property-secure{color:var(--sys-color-green)}.security-property-neutral{color:var(--sys-color-error)}.security-property-insecure{color:var(--sys-color-error)}.security-property-insecure-broken{color:var(--sys-color-error)}.security-property-info{color:var(--sys-color-on-surface-subtle)}.security-property-unknown{color:var(--sys-color-on-surface-subtle)}.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n.url-scheme-insecure,\n.url-scheme-insecure-broken{color:var(--sys-color-error)}\n/*# sourceURL=${import.meta.resolve("./lockIcon.css")} */`,ee=`.devtools-link{display:inline-block}.security-main-view{overflow:hidden auto;background-color:var(--sys-color-cdt-base-container)}.security-main-view > div{flex-shrink:0}.security-summary-section-title{font-size:15px;margin:12px 16px;user-select:text}.lock-spectrum{margin:8px 16px;display:flex;align-items:flex-start}.security-summary .lock-icon{flex:none;width:16px;height:16px;margin:0}.security-summary .lock-icon-neutral{margin:0 16px}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n.security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n.security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n.security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:var(--sys-color-state-disabled)}@media (forced-colors: active){.security-summary-neutral .lock-icon-neutral{color:Highlight}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n  .security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n  .security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n  .security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:canvastext}}.triangle-pointer-container{margin:8px 24px 0;padding:0}.triangle-pointer-wrapper{transform:translateX(0);transition:transform 0.3s}.triangle-pointer{width:12px;height:12px;margin-bottom:-6px;margin-left:-6px;transform:rotate(-45deg);border-style:solid;border-width:1px 1px 0 0;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline)}.security-summary-secure .triangle-pointer-wrapper{transform:translateX(0)}.security-summary-neutral .triangle-pointer-wrapper{transform:translateX(32px)}.security-summary-insecure .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-insecure-broken .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-text{padding:16px 24px;border-style:solid;border-width:1px 0;font-size:15px;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline);user-select:text}.security-summary-secure .triangle-pointer,\n.security-summary-secure .security-summary-text,\n.security-explanation-title-secure{color:var(--sys-color-green)}.security-summary-insecure-broken .triangle-pointer,\n.security-summary-insecure-broken .security-summary-text,\n.security-explanation-title-neutral,\n.security-explanation-title-insecure,\n.security-explanation-title-insecure-broken{color:var(--sys-color-error)}.security-explanation-list{padding-bottom:16px}.security-explanation-list:empty{border-bottom:none;padding:0}.security-explanations-main{margin-top:-5px;background-color:var(--sys-color-cdt-base-container);border-bottom:1px solid var(--sys-color-divider)}.security-explanations-extra{background-color:transparent}.security-explanation{padding:11px;display:flex;white-space:nowrap;border:none;color:var(--sys-color-token-subtle)}.security-explanation-text{flex:auto;white-space:normal;max-width:400px}.origin-button{margin-top:var(--sys-size-4)}.security-explanation .security-property{flex:none;width:16px;height:16px;margin-right:16px}.security-explanation-title{color:var(--sys-color-token-subtle);margin-top:1px;margin-bottom:8px}.security-mixed-content{margin-top:8px}.security-explanation-recommendations{padding-inline-start:16px}.security-explanation-recommendations > li{margin-bottom:4px}\n/*# sourceURL=${import.meta.resolve("./mainView.css")} */`;class te extends c.TreeOutline.TreeElement{constructor(e="",t=!1,i){super(e,t,i),c.ARIAUtils.setLabel(this.listItemElement,e)}get elemId(){return"overview"}showElement(){throw new Error("Unimplemented Method")}onselect(e){if(e){const e=this.elemId;this.listItemElement.dispatchEvent(new CustomEvent("update-sidebar-selection",{bubbles:!0,composed:!0,detail:{id:e}})),this.showElement()}return!1}}class ie extends Event{static eventName="showorigin";origin;constructor(e){super(ie.eventName,{bubbles:!0,composed:!0}),this.origin=e}}class se extends te{#l;#d;#u=null;constructor(e,t,i=null){super(),this.#d=t,this.#u=i,this.listItemElement.classList.add(e),this.#l=null,this.setSecurityState("unknown")}setSecurityState(e){this.#l=e,this.#d(this)}securityState(){return this.#l}origin(){return this.#u}showElement(){this.listItemElement.dispatchEvent(new ie(this.#u))}}var re=`.title-section{padding:16px 0 24px;border-bottom:1px solid var(--sys-color-divider)}.title-section-header{padding-left:16px;padding-bottom:10px;font-size:14px}.security-origin-view{overflow:hidden scroll;display:block;user-select:text}.security-origin-view .origin-view-section{border-bottom:1px solid var(--sys-color-divider);padding:12px 6px 12px 24px;font-size:12px}.origin-view-notes{margin-top:2px;color:var(--sys-color-token-subtle)}.origin-view-section-notes{margin-top:6px;color:var(--sys-color-token-subtle)}.security-origin-view .origin-display{font-size:12px;padding-left:var(--sys-size-8);display:flex;align-items:center}.title-section > .view-network-button{padding:6px 0 0 16px}.security-origin-view .origin-display devtools-icon{width:var(--sys-size-8);height:var(--sys-size-8);margin-right:var(--sys-size-6)}.security-origin-view .origin-view-section-title{margin-top:4px;margin-bottom:4px;font-weight:bold}.security-origin-view .details-table{border-spacing:0}.security-origin-view .details-table-row{white-space:nowrap;overflow:hidden;line-height:22px;vertical-align:top}.security-origin-view .details-table-row > td{padding:0}.security-origin-view .details-table-row > td:first-child{color:var(--sys-color-token-subtle);width:calc(120px + 1em);text-align:right;padding-right:1em}.security-origin-view .details-table-row > td:nth-child(2){white-space:normal}.security-origin-view .sct-details .details-table .details-table-row:last-child td:last-child{border-bottom:1px solid var(--sys-color-divider);padding-bottom:10px}.security-origin-view .sct-details .details-table:last-child .details-table-row:last-child td:last-child{border-bottom:none;padding-bottom:0}.security-origin-view .details-toggle{margin-left:126px}.security-origin-view .sct-toggle{margin-left:145px;padding-top:5px}.security-origin-view .details-table .empty-san{color:var(--sys-color-state-disabled)}.security-origin-view .details-table .san-entry{display:block}.security-origin-view .truncated-san .truncated-entry{display:none}.origin-view-section:last-child{border-bottom:none}.devtools-link{display:inline-flex}\n/*# sourceURL=${import.meta.resolve("./originView.css")} */`;class oe extends te{constructor(t,i){super(t,!1,i),this.setLeadingIcons([e("gear","cookie-icon")])}get elemId(){return"controls"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showFlagControls",{bubbles:!0,composed:!0}))}}class ne extends te{constructor(t,i){super(t,!1,i),this.setLeadingIcons([e("cookie","cookie-icon")])}get elemId(){return"report"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showCookieReport",{bubbles:!0,composed:!0}))}}var ae=`.tree-outline-disclosure{width:100%}.tree-outline li.security-group-list-item{& + ol{padding-left:0}&::before{display:none}&:not(:first-child){margin-top:var(--sys-size-6)}}.security-main-view-reload-message{color:var(--sys-color-token-subtle)}.tree-outline li.security-sidebar-origins + .children > li{&.selected{.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n    .url-scheme-insecure,\n    .url-scheme-insecure-broken{color:var(--sys-color-error)}}}.security-main-view-reload-message,\n.tree-outline li.security-sidebar-origins,\n.tree-outline li.security-group-list-item,\n.tree-outline span{font:var(--sys-typescale-body4-medium);&:hover:not(:has(devtools-checkbox)) .selection{background:transparent}}.tree-outline li{& .leading-icons{flex:none}& .tree-element-title,\n  .highlighted-url,\n  .title{overflow:hidden;text-overflow:ellipsis}}\n/*# sourceURL=${import.meta.resolve("./sidebar.css")} */`;const ce={security:"Security",privacy:"Privacy",cookieReport:"Third-party cookies",flagControls:"Controls",mainOrigin:"Main origin",nonsecureOrigins:"Non-secure origins",secureOrigins:"Secure origins",unknownCanceled:"Unknown / canceled",overview:"Overview",reloadToViewDetails:"Reload to view details"},le=s.i18n.registerUIStrings("panels/security/SecurityPanelSidebar.ts",ce),de=s.i18n.getLocalizedString.bind(void 0,le);class ue extends c.Widget.VBox{#h;sidebarTree;#g;#p;securityOverviewElement;#m;cookieReportTreeElement;#y;#v;#w;constructor(e){if(super(e),this.#h=t.Settings.Settings.instance().createSetting("security-last-selected-element-path",""),this.#w=null,this.sidebarTree=new c.TreeOutline.TreeOutlineInShadow("NavigationTree"),this.sidebarTree.registerRequiredCSS(Z,ae),this.sidebarTree.element.classList.add("security-sidebar"),this.contentElement.appendChild(this.sidebarTree.element),r.Runtime.hostConfig.devToolsPrivacyUI?.enabled){const e=this.#S(de(ce.privacy),"privacy");this.#m=new oe(de(ce.flagControls),"cookie-flag-controls"),e.appendChild(this.#m),this.cookieReportTreeElement=new ne(de(ce.cookieReport),"cookie-report"),e.appendChild(this.cookieReportTreeElement),""===this.#h.get()&&this.#h.set(this.#m.elemId)}const i=de(ce.security),s=this.#S(i,"security");this.securityOverviewElement=new se("security-main-view-sidebar-tree-item",this.#d),this.securityOverviewElement.tooltip=de(ce.overview),s.appendChild(this.securityOverviewElement),this.#g=new Map([[Ee.MainOrigin,{title:de(ce.mainOrigin)}],[Ee.NonSecure,{title:de(ce.nonsecureOrigins),icon:ke("insecure","lock-icon lock-icon-insecure")}],[Ee.Secure,{title:de(ce.secureOrigins),icon:ke("secure","lock-icon lock-icon-secure")}],[Ee.Unknown,{title:de(ce.unknownCanceled),icon:ke("unknown","lock-icon lock-icon-unknown")}]]),this.#p=new Map;for(const e of Object.values(Ee)){const t=this.#b(this.#g.get(e)?.title,this.#g.get(e)?.icon);this.#p.set(e,t),s.appendChild(t)}this.#v=new c.TreeOutline.TreeElement(de(ce.reloadToViewDetails)),this.#v.selectable=!1,this.#v.listItemElement.classList.add("security-main-view-reload-message");this.#p.get(Ee.MainOrigin).appendChild(this.#v),this.#k(),this.#y=new Map,this.element.addEventListener("update-sidebar-selection",e=>{const t=e.detail.id;this.#h.set(t)}),this.showLastSelectedElement()}showLastSelectedElement(){this.#m&&this.#h.get()===this.#m.elemId?(this.#m.select(),this.#m.showElement()):this.#h.get()===this.cookieReportTreeElement?.elemId?(this.cookieReportTreeElement.select(),this.cookieReportTreeElement.showElement()):(this.securityOverviewElement.select(),this.securityOverviewElement.showElement())}#S(e,t){const i=new c.TreeOutline.TreeElement(e,!0,t);return i.listItemElement.classList.add("security-group-list-item"),i.setCollapsible(!1),i.selectable=!1,this.sidebarTree.appendChild(i),c.ARIAUtils.markAsHeading(i.listItemElement,3),c.ARIAUtils.setLabel(i.childrenListElement,e),i}#f(e){return this.#g.get(e)?.title}#x(e){return this.#p.get(e)}#b(e,t){const i=new c.TreeOutline.TreeElement(e,!0);return i.selectable=!1,i.expand(),i.listItemElement.classList.add("security-sidebar-origins"),t&&i.setLeadingIcons([t]),c.ARIAUtils.setLabel(i.childrenListElement,e),i}toggleOriginsList(e){for(const t of this.#p.values())t.hidden=e}addOrigin(e,t){this.#v.hidden=!0;const i=new se("security-sidebar-tree-item",this.#d,e);i.tooltip=e,this.#y.set(e,i),this.updateOrigin(e,t)}setMainOrigin(e){this.#w=e}get mainOrigin(){return this.#w}get originGroups(){return this.#p}updateOrigin(e,t){const i=this.#y.get(e);let s;if(i.setSecurityState(t),e===this.#w)s=this.#p.get(Ee.MainOrigin),s.title=de(ce.mainOrigin),s.setLeadingIcons([fe(t,`lock-icon lock-icon-${t}`)]),c.ARIAUtils.setLabel(s.childrenListElement,s.title);else switch(t){case"secure":s=this.#x(Ee.Secure);break;case"unknown":s=this.#x(Ee.Unknown);break;default:s=this.#x(Ee.NonSecure)}const r=i.parent;r!==s&&(r&&(r.removeChild(i),0===r.childCount()&&(r.hidden=!0)),s.appendChild(i),s.hidden=!1)}#k(){for(const[e,t]of this.#p)if(e===Ee.MainOrigin){for(let e=t.childCount()-1;e>0;e--)t.removeChildAtIndex(e);t.title=this.#f(Ee.MainOrigin),t.hidden=!1,this.#v.hidden=!1}else t.removeChildren(),t.hidden=!0}clearOrigins(){this.#k(),this.#y.clear()}focus(){this.sidebarTree.focus()}#d(e){if(e instanceof se){const t=e.securityState()??"unknown",i=e.listItemElement.classList.contains("security-main-view-sidebar-tree-item"),s=i?fe(t,`lock-icon lock-icon-${t}`):ke(t,`security-property security-property-${t}`),r=i?(()=>{const e=document.createElement("span");return e.classList.add("title"),e.textContent=de(ce.overview),e})():xe(e.origin()??m.DevToolsPath.EmptyUrlString,t);e.setLeadingIcons([s]),e.listItemElement.lastChild&&e.listItemElement.removeChild(e.listItemElement.lastChild),e.listItemElement.appendChild(r)}}}const{widgetConfig:he}=c.Widget,ge={securityOverview:"Security overview",secure:"Secure",info:"Info",notSecure:"Not secure",viewCertificate:"View certificate",notSecureBroken:"Not secure (broken)",thisPageIsDangerousFlaggedBy:"This page is dangerous (flagged by Google Safe Browsing).",flaggedByGoogleSafeBrowsing:"Flagged by Google Safe Browsing",toCheckThisPagesStatusVisit:"To check this page's status, visit g.co/safebrowsingstatus.",thisIsAnErrorPage:"This is an error page.",thisPageIsInsecureUnencrypted:"This page is insecure (unencrypted HTTP).",thisPageHasANonhttpsSecureOrigin:"This page has a non-HTTPS secure origin.",thisPageIsSuspicious:"This page is suspicious",chromeHasDeterminedThatThisSiteS:"Chrome has determined that this site could be fake or fraudulent.",ifYouBelieveThisIsShownIn:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",possibleSpoofingUrl:"Possible spoofing URL",thisSitesHostnameLooksSimilarToP:"This site's hostname looks similar to {PH1}. Attackers sometimes mimic sites by making small, hard-to-see changes to the domain name.",ifYouBelieveThisIsShownInErrorSafety:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",thisPageIsSuspiciousFlaggedBy:"This page is suspicious (flagged by Chrome).",certificate:"Certificate",insecureSha:"insecure (SHA-1)",theCertificateChainForThisSite:"The certificate chain for this site contains a certificate signed using SHA-1.",subjectAlternativeNameMissing:"`Subject Alternative Name` missing",theCertificateForThisSiteDoesNot:"The certificate for this site does not contain a `Subject Alternative Name` extension containing a domain name or IP address.",missing:"missing",thisSiteIsMissingAValidTrusted:"This site is missing a valid, trusted certificate ({PH1}).",validAndTrusted:"valid and trusted",theConnectionToThisSiteIsUsingA:"The connection to this site is using a valid, trusted server certificate issued by {PH1}.",publickeypinningBypassed:"Public-Key-Pinning bypassed",publickeypinningWasBypassedByA:"Public-Key-Pinning was bypassed by a local root certificate.",certificateExpiresSoon:"Certificate expires soon",theCertificateForThisSiteExpires:"The certificate for this site expires in less than 48 hours and needs to be renewed.",connection:"Connection",secureConnectionSettings:"secure connection settings",theConnectionToThisSiteIs:"The connection to this site is encrypted and authenticated using {PH1}, {PH2}, and {PH3}.",sIsObsoleteEnableTlsOrLater:"{PH1} is obsolete. Enable TLS 1.2 or later.",rsaKeyExchangeIsObsoleteEnableAn:"RSA key exchange is obsolete. Enable an ECDHE-based cipher suite.",sIsObsoleteEnableAnAesgcmbased:"{PH1} is obsolete. Enable an AES-GCM-based cipher suite.",theServerSignatureUsesShaWhichIs:"The server signature uses SHA-1, which is obsolete. Enable a SHA-2 signature algorithm instead. (Note this is different from the signature in the certificate.)",obsoleteConnectionSettings:"obsolete connection settings",resources:"Resources",activeMixedContent:"active mixed content",youHaveRecentlyAllowedNonsecure:"You have recently allowed non-secure content (such as scripts or iframes) to run on this site.",mixedContent:"mixed content",thisPageIncludesHttpResources:"This page includes HTTP resources.",nonsecureForm:"non-secure form",thisPageIncludesAFormWithA:'This page includes a form with a non-secure "action" attribute.',activeContentWithCertificate:"active content with certificate errors",youHaveRecentlyAllowedContent:"You have recently allowed content loaded with certificate errors (such as scripts or iframes) to run on this site.",contentWithCertificateErrors:"content with certificate errors",thisPageIncludesResourcesThat:"This page includes resources that were loaded with certificate errors.",allServedSecurely:"all served securely",allResourcesOnThisPageAreServed:"All resources on this page are served securely.",blockedMixedContent:"Blocked mixed content",yourPageRequestedNonsecure:"Your page requested non-secure resources that were blocked.",reloadThePageToRecordRequestsFor:"Reload the page to record requests for HTTP resources.",viewDRequestsInNetworkPanel:"{n, plural, =1 {View # request in Network Panel} other {View # requests in Network Panel}}",origin:"Origin",viewRequestsInNetworkPanel:"View requests in Network Panel",protocol:"Protocol",keyExchange:"Key exchange",cipher:"Cipher",serverSignature:"Server signature",encryptedClientHello:"Encrypted ClientHello",certificateTransparency:"Certificate Transparency",subject:"Subject",validFrom:"Valid from",validUntil:"Valid until",issuer:"Issuer",openFullCertificateDetails:"Open full certificate details",sct:"SCT",logName:"Log name",logId:"Log ID",validationStatus:"Validation status",source:"Source",issuedAt:"Issued at",hashAlgorithm:"Hash algorithm",signatureAlgorithm:"Signature algorithm",signatureData:"Signature data",showFullDetails:"Show full details",hideFullDetails:"Hide full details",thisRequestCompliesWithChromes:"This request complies with `Chrome`'s Certificate Transparency policy.",thisRequestDoesNotComplyWith:"This request does not comply with `Chrome`'s Certificate Transparency policy.",thisResponseWasLoadedFromCache:"This response was loaded from cache. Some security details might be missing.",theSecurityDetailsAboveAreFrom:"The security details above are from the first inspected response.",thisOriginIsANonhttpsSecure:"This origin is a non-HTTPS secure origin.",yourConnectionToThisOriginIsNot:"Your connection to this origin is not secure.",noSecurityInformation:"No security information",noSecurityDetailsAreAvailableFor:"No security details are available for this origin.",na:"(n/a)",showLess:"Show less",showMoreSTotal:"Show more ({PH1} total)",unknownField:"unknown",enabled:"enabled"},pe=s.i18n.registerUIStrings("panels/security/SecurityPanel.ts",ge),me=s.i18n.getLocalizedString.bind(void 0,pe);let ye;const ve=new Map([[513,"RSA with SHA-1"],[1025,"RSA with SHA-256"],[1281,"RSA with SHA-384"],[1537,"RSA with SHA-512"],[1027,"ECDSA with SHA-256"],[1283,"ECDSA with SHA-384"],[2052,"RSA-PSS with SHA-256"],[2053,"RSA-PSS with SHA-384"],[2054,"RSA-PSS with SHA-512"]]),we="lock",Se="warning",be="indeterminate-question-box";function ke(t,i){let s;switch(t){case"neutral":case"insecure":case"insecure-broken":s=Se;break;case"secure":s=we;break;case"info":case"unknown":s=be}return e(s,i)}function fe(t,i){let s;switch(t){case"unknown":case"neutral":s=be;break;case"insecure":case"insecure-broken":s=Se;break;case"secure":s=we;break;case"info":throw new Error(`Unexpected security state ${t}`)}return e(s,i)}function xe(e,t){const i="://",s=e.indexOf(i);if(-1===s){const t=document.createElement("span");return t.textContent=e,t}const r=document.createElement("span");r.classList.add("highlighted-url");const o=e.substr(0,s),n=e.substr(s+3);return r.createChild("span","url-scheme-"+t).textContent=o,r.createChild("span","url-scheme-separator").textContent=i,r.createChild("span").textContent=n,r}const Ce=(e,t,i)=>{g(u`
    <devtools-split-view direction="column" name="security"
      ${c.Widget.widgetRef(c.SplitWidget.SplitWidget,e=>{t.splitWidget=e})}>
      <devtools-widget
        slot="sidebar"
        .widgetConfig=${he(ue)}
        @showCookieReport=${()=>t.setVisibleView(new $)}
        @showFlagControls=${()=>t.setVisibleView(new I)}
        ${c.Widget.widgetRef(ue,e=>{t.sidebar=e})}>
      </devtools-widget>
  </devtools-split-view>`,i)};class Te extends c.Panel.Panel{view;mainView;sidebar;lastResponseReceivedForLoaderId;origins;filterRequestCounts;visibleView;eventListeners;securityModel;splitWidget;constructor(e=Ce){super("security"),this.view=e,this.update(),this.sidebar.setMinimumSize(100,25),this.sidebar.element.classList.add("panel-sidebar"),this.sidebar.element.setAttribute("jslog",`${p.pane("sidebar").track({resize:!0})}`),this.mainView=new Ie,this.mainView.panel=this,this.element.addEventListener(ie.eventName,e=>{e.origin?this.showOrigin(e.origin):this.setVisibleView(this.mainView)}),this.lastResponseReceivedForLoaderId=new Map,this.origins=new Map,this.filterRequestCounts=new Map,this.visibleView=null,this.eventListeners=[],this.securityModel=null,o.TargetManager.TargetManager.instance().observeModels(G,this,{scoped:!0}),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.onPrimaryPageChanged,this),this.sidebar.showLastSelectedElement()}static instance(e={forceNew:null}){const{forceNew:t}=e;return ye&&!t||(ye=new Te),ye}static createCertificateViewerButtonForOrigin(e,t){const s=c.UIUtils.createTextButton(e,async e=>{e.consume();const s=await o.NetworkManager.MultitargetNetworkManager.instance().getCertificate(t);s.length>0&&i.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(s)},{className:"origin-button",jslogContext:"security.view-certificate-for-origin",title:e});return c.ARIAUtils.markAsButton(s),s}static createCertificateViewerButtonForCert(e,t){const s=c.UIUtils.createTextButton(e,e=>{e.consume(),i.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(t)},{className:"origin-button",jslogContext:"security.view-certificate"});return c.ARIAUtils.markAsButton(s),s}update(){this.view({panel:this},this,this.contentElement)}updateVisibleSecurityState(e){this.sidebar.securityOverviewElement.setSecurityState(e.securityState),this.mainView.updateVisibleSecurityState(e)}onVisibleSecurityStateChanged({data:e}){this.updateVisibleSecurityState(e)}showOrigin(e){const t=this.origins.get(e);t&&(t.originView||(t.originView=new Re(e,t)),this.setVisibleView(t.originView))}wasShown(){super.wasShown(),this.visibleView||this.sidebar.showLastSelectedElement()}focus(){this.sidebar.focus()}setVisibleView(e){this.visibleView!==e&&(this.visibleView&&this.visibleView.detach(),this.visibleView=e,e&&this.splitWidget.setMainWidget(e))}onResponseReceived(e){const i=e.data.request;i.resourceType()===t.ResourceType.resourceTypes.Document&&i.loaderId&&this.lastResponseReceivedForLoaderId.set(i.loaderId,i)}processRequest(e){const i=t.ParsedURL.ParsedURL.extractOrigin(e.url());if(!i)return;let s=e.securityState();"blockable"!==e.mixedContentType&&"optionally-blockable"!==e.mixedContentType||(s="insecure");const r=this.origins.get(i);if(r){if(q(s,r.securityState)<0){r.securityState=s;const t=e.securityDetails();t&&(r.securityDetails=t),this.sidebar.updateOrigin(i,s),r.originView&&r.originView.setSecurityState(s)}}else{const t={securityState:s,securityDetails:e.securityDetails(),loadedFromCache:e.cached(),originView:void 0};this.origins.set(i,t),this.sidebar.addOrigin(i,s)}}onRequestFinished(e){const t=e.data;this.updateFilterRequestCounts(t),this.processRequest(t)}updateFilterRequestCounts(e){if("none"===e.mixedContentType)return;let t="all";e.wasBlocked()?t="blocked":"blockable"===e.mixedContentType?t="block-overridden":"optionally-blockable"===e.mixedContentType&&(t="displayed");const i=this.filterRequestCounts.get(t);i?this.filterRequestCounts.set(t,i+1):this.filterRequestCounts.set(t,1),this.mainView.refreshExplanations()}filterRequestCount(e){return this.filterRequestCounts.get(e)||0}modelAdded(e){if(e.target()!==e.target().outermostTarget())return;this.securityModel=e;const i=e.resourceTreeModel(),s=e.networkManager();this.eventListeners.length&&t.EventTarget.removeEventListeners(this.eventListeners),this.eventListeners=[e.addEventListener(j.VisibleSecurityStateChanged,this.onVisibleSecurityStateChanged,this),i.addEventListener(o.ResourceTreeModel.Events.InterstitialShown,this.onInterstitialShown,this),i.addEventListener(o.ResourceTreeModel.Events.InterstitialHidden,this.onInterstitialHidden,this),s.addEventListener(o.NetworkManager.Events.ResponseReceived,this.onResponseReceived,this),s.addEventListener(o.NetworkManager.Events.RequestFinished,this.onRequestFinished,this)],i.isInterstitialShowing&&this.onInterstitialShown()}modelRemoved(e){this.securityModel===e&&(this.securityModel=null,t.EventTarget.removeEventListeners(this.eventListeners))}onPrimaryPageChanged(e){const{frame:i}=e.data,s=this.lastResponseReceivedForLoaderId.get(i.loaderId);this.sidebar.showLastSelectedElement(),this.sidebar.clearOrigins(),this.origins.clear(),this.lastResponseReceivedForLoaderId.clear(),this.filterRequestCounts.clear(),this.mainView.refreshExplanations();const r=t.ParsedURL.ParsedURL.extractOrigin(s?s.url():i.url);this.sidebar.setMainOrigin(r),s&&this.processRequest(s)}onInterstitialShown(){this.sidebar.showLastSelectedElement(),this.sidebar.toggleOriginsList(!0)}onInterstitialHidden(){this.sidebar.toggleOriginsList(!1)}}var Ee;!function(e){e.MainOrigin="MainOrigin",e.NonSecure="NonSecure",e.Secure="Secure",e.Unknown="Unknown"}(Ee||(Ee={}));class Ie extends c.Widget.VBox{panel;summarySection;securityExplanationsMain;securityExplanationsExtra;lockSpectrum;summaryText;explanations;securityState;constructor(e){super(e,{jslog:`${p.pane("security.main-view")}`}),this.registerRequiredCSS(Z,ee),this.setMinimumSize(200,100),this.contentElement.classList.add("security-main-view"),this.summarySection=this.contentElement.createChild("div","security-summary"),this.securityExplanationsMain=this.contentElement.createChild("div","security-explanation-list security-explanations-main"),this.securityExplanationsExtra=this.contentElement.createChild("div","security-explanation-list security-explanations-extra");const t=this.summarySection.createChild("div","security-summary-section-title");t.textContent=me(ge.securityOverview),c.ARIAUtils.markAsHeading(t,1);const i=this.summarySection.createChild("div","lock-spectrum");this.lockSpectrum=new Map([["secure",i.appendChild(fe("secure","lock-icon lock-icon-secure"))],["neutral",i.appendChild(fe("neutral","lock-icon lock-icon-neutral"))],["insecure",i.appendChild(fe("insecure","lock-icon lock-icon-insecure"))]]),c.Tooltip.Tooltip.install(this.getLockSpectrumDiv("secure"),me(ge.secure)),c.Tooltip.Tooltip.install(this.getLockSpectrumDiv("neutral"),me(ge.info)),c.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),me(ge.notSecure)),this.summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer"),this.summaryText=this.summarySection.createChild("div","security-summary-text"),c.ARIAUtils.markAsHeading(this.summaryText,2),this.explanations=null,this.securityState=null}getLockSpectrumDiv(e){const t=this.lockSpectrum.get(e);if(!t)throw new Error(`Invalid argument: ${e}`);return t}addExplanation(e,t){const i=e.createChild("div","security-explanation");i.classList.add("security-explanation-"+t.securityState);const s=ke(t.securityState,"security-property security-property-"+t.securityState);i.appendChild(s);const r=i.createChild("div","security-explanation-text"),o=r.createChild("div","security-explanation-title");if(t.title?(o.createChild("span").textContent=t.title+" - ",o.createChild("span","security-explanation-title-"+t.securityState).textContent=t.summary):o.textContent=t.summary,r.createChild("div").textContent=t.description,t.certificate.length&&r.appendChild(Te.createCertificateViewerButtonForCert(me(ge.viewCertificate),t.certificate)),t.recommendations?.length){const e=r.createChild("ul","security-explanation-recommendations");for(const i of t.recommendations)e.createChild("li").textContent=i}return r}updateVisibleSecurityState(e){this.summarySection.classList.remove("security-summary-"+this.securityState),this.securityState=e.securityState,this.summarySection.classList.add("security-summary-"+this.securityState),"insecure"===this.securityState?(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure-broken"),c.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),me(ge.notSecure))):"insecure-broken"===this.securityState&&(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure"),c.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),me(ge.notSecureBroken)));const{summary:t,explanations:i}=this.getSecuritySummaryAndExplanations(e);this.summaryText.textContent=t||W[this.securityState](),this.explanations=this.orderExplanations(i),this.refreshExplanations()}getSecuritySummaryAndExplanations(e){const{securityState:t,securityStateIssueIds:i}=e;let s;const r=[];if(s=this.explainSafetyTipSecurity(e,s,r),i.includes("malicious-content"))s=me(ge.thisPageIsDangerousFlaggedBy),r.unshift(new Y("insecure",void 0,me(ge.flaggedByGoogleSafeBrowsing),me(ge.toCheckThisPagesStatusVisit)));else{if(i.includes("is-error-page")&&null===e.certificateSecurityState?.certificateNetworkError)return s=me(ge.thisIsAnErrorPage),{summary:s,explanations:r};"insecure-broken"===t&&i.includes("scheme-is-not-cryptographic")&&(s=s||me(ge.thisPageIsInsecureUnencrypted))}return i.includes("scheme-is-not-cryptographic")?("neutral"!==t||i.includes("insecure-origin")||(s=me(ge.thisPageHasANonhttpsSecureOrigin)),{summary:s,explanations:r}):(this.explainCertificateSecurity(e,r),this.explainConnectionSecurity(e,r),this.explainContentSecurity(e,r),{summary:s,explanations:r})}explainSafetyTipSecurity(e,t,i){const{securityStateIssueIds:s,safetyTipInfo:r}=e,o=[];if(s.includes("bad_reputation")){const e=`${me(ge.chromeHasDeterminedThatThisSiteS)}\n\n${me(ge.ifYouBelieveThisIsShownIn)}`;o.push({summary:me(ge.thisPageIsSuspicious),description:e})}else if(s.includes("lookalike")&&r?.safeUrl){const e=new URL(r.safeUrl).hostname,t=`${me(ge.thisSitesHostnameLooksSimilarToP,{PH1:e})}\n\n${me(ge.ifYouBelieveThisIsShownInErrorSafety)}`;o.push({summary:me(ge.possibleSpoofingUrl),description:t})}return o.length>0&&(t=t||me(ge.thisPageIsSuspiciousFlaggedBy),i.push(new Y("insecure",void 0,o[0].summary,o[0].description))),t}explainCertificateSecurity(e,t){const{certificateSecurityState:i,securityStateIssueIds:s}=e,r=me(ge.certificate);if(i?.certificateHasSha1Signature){const e=me(ge.insecureSha),s=me(ge.theCertificateChainForThisSite);i.certificateHasWeakSignature?t.push(new Y("insecure",r,e,s,i.certificate,"none")):t.push(new Y("neutral",r,e,s,i.certificate,"none"))}i&&s.includes("cert-missing-subject-alt-name")&&t.push(new Y("insecure",r,me(ge.subjectAlternativeNameMissing),me(ge.theCertificateForThisSiteDoesNot),i.certificate,"none")),i&&null!==i.certificateNetworkError?t.push(new Y("insecure",r,me(ge.missing),me(ge.thisSiteIsMissingAValidTrusted,{PH1:i.certificateNetworkError}),i.certificate,"none")):i&&!i.certificateHasSha1Signature&&t.push(new Y("secure",r,me(ge.validAndTrusted),me(ge.theConnectionToThisSiteIsUsingA,{PH1:i.issuer}),i.certificate,"none")),s.includes("pkp-bypassed")&&t.push(new Y("info",r,me(ge.publickeypinningBypassed),me(ge.publickeypinningWasBypassedByA))),i?.isCertificateExpiringSoon()&&t.push(new Y("info",void 0,me(ge.certificateExpiresSoon),me(ge.theCertificateForThisSiteExpires)))}explainConnectionSecurity(e,t){const i=e.certificateSecurityState;if(!i)return;const s=me(ge.connection);if(i.modernSSL)return void t.push(new Y("secure",s,me(ge.secureConnectionSettings),me(ge.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()})));const r=[];i.obsoleteSslProtocol&&r.push(me(ge.sIsObsoleteEnableTlsOrLater,{PH1:i.protocol})),i.obsoleteSslKeyExchange&&r.push(me(ge.rsaKeyExchangeIsObsoleteEnableAn)),i.obsoleteSslCipher&&r.push(me(ge.sIsObsoleteEnableAnAesgcmbased,{PH1:i.cipher})),i.obsoleteSslSignature&&r.push(me(ge.theServerSignatureUsesShaWhichIs)),t.push(new Y("info",s,me(ge.obsoleteConnectionSettings),me(ge.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()}),void 0,void 0,r))}explainContentSecurity(e,t){let i=!0;const s=me(ge.resources),r=e.securityStateIssueIds;r.includes("ran-mixed-content")&&(i=!1,t.push(new Y("insecure",s,me(ge.activeMixedContent),me(ge.youHaveRecentlyAllowedNonsecure),[],"blockable"))),r.includes("displayed-mixed-content")&&(i=!1,t.push(new Y("neutral",s,me(ge.mixedContent),me(ge.thisPageIncludesHttpResources),[],"optionally-blockable"))),r.includes("contained-mixed-form")&&(i=!1,t.push(new Y("neutral",s,me(ge.nonsecureForm),me(ge.thisPageIncludesAFormWithA)))),null===e.certificateSecurityState?.certificateNetworkError&&(r.includes("ran-content-with-cert-error")&&(i=!1,t.push(new Y("insecure",s,me(ge.activeContentWithCertificate),me(ge.youHaveRecentlyAllowedContent)))),r.includes("displayed-content-with-cert-errors")&&(i=!1,t.push(new Y("neutral",s,me(ge.contentWithCertificateErrors),me(ge.thisPageIncludesResourcesThat))))),i&&(r.includes("scheme-is-not-cryptographic")||t.push(new Y("secure",s,me(ge.allServedSecurely),me(ge.allResourcesOnThisPageAreServed))))}orderExplanations(e){if(0===e.length)return e;const t=["insecure","neutral","secure","info"],i=[];for(const s of t)i.push(...e.filter(e=>e.securityState===s));return i}refreshExplanations(){if(this.securityExplanationsMain.removeChildren(),this.securityExplanationsExtra.removeChildren(),this.explanations){for(const e of this.explanations)if("info"===e.securityState)this.addExplanation(this.securityExplanationsExtra,e);else switch(e.mixedContentType){case"blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"block-overridden");break;case"optionally-blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"displayed");break;default:this.addExplanation(this.securityExplanationsMain,e)}if(this.panel.filterRequestCount("blocked")>0){const e={securityState:"info",summary:me(ge.blockedMixedContent),description:me(ge.yourPageRequestedNonsecure),mixedContentType:"blockable",certificate:[],title:""};this.addMixedContentExplanation(this.securityExplanationsMain,e,"blocked")}}}addMixedContentExplanation(e,t,i){const s=this.addExplanation(e,t),r=this.panel.filterRequestCount(i);if(!r){return void(s.createChild("div","security-mixed-content").textContent=me(ge.reloadThePageToRecordRequestsFor))}const o=s.createChild("button","security-mixed-content devtools-link text-button link-style");c.ARIAUtils.markAsLink(o),o.tabIndex=0,o.textContent=me(ge.viewDRequestsInNetworkPanel,{n:r}),o.addEventListener("click",this.showNetworkFilter.bind(this,i))}showNetworkFilter(e,i){i.consume(),t.Revealer.reveal(v.UIFilter.UIRequestFilter.filters([{filterType:v.UIFilter.FilterType.MixedContent,filterValue:e}]))}}class Re extends c.Widget.VBox{originLockIcon;constructor(e,i){super({jslog:`${p.pane("security.origin-view")}`}),this.registerRequiredCSS(re,Z),this.setMinimumSize(200,100),this.element.classList.add("security-origin-view");const r=this.element.createChild("div","title-section"),o=r.createChild("div","title-section-header");o.textContent=me(ge.origin),c.ARIAUtils.markAsHeading(o,1);const n=r.createChild("div","origin-display");this.originLockIcon=n.createChild("span");const a=ke(i.securityState,`security-property security-property-${i.securityState}`);this.originLockIcon.appendChild(a),n.appendChild(xe(e,i.securityState));const l=r.createChild("div","view-network-button"),d=c.UIUtils.createTextButton(me(ge.viewRequestsInNetworkPanel),i=>{i.consume();const s=new t.ParsedURL.ParsedURL(e);t.Revealer.reveal(v.UIFilter.UIRequestFilter.filters([{filterType:v.UIFilter.FilterType.Domain,filterValue:s.host},{filterType:v.UIFilter.FilterType.Scheme,filterValue:s.scheme}]))},{jslogContext:"reveal-in-network"});if(l.appendChild(d),c.ARIAUtils.markAsLink(d),i.securityDetails){const u=this.element.createChild("div","origin-view-section"),h=u.createChild("div","origin-view-section-title");h.textContent=me(ge.connection),c.ARIAUtils.markAsHeading(h,2);let g=new Pe;if(u.appendChild(g.element()),g.addRow(me(ge.protocol),i.securityDetails.protocol),i.securityDetails.keyExchange&&i.securityDetails.keyExchangeGroup?g.addRow(me(ge.keyExchange),i.securityDetails.keyExchange+" with "+i.securityDetails.keyExchangeGroup):i.securityDetails.keyExchange?g.addRow(me(ge.keyExchange),i.securityDetails.keyExchange):i.securityDetails.keyExchangeGroup&&g.addRow(me(ge.keyExchange),i.securityDetails.keyExchangeGroup),i.securityDetails.serverSignatureAlgorithm){let I=ve.get(i.securityDetails.serverSignatureAlgorithm);I??=me(ge.unknownField)+" ("+i.securityDetails.serverSignatureAlgorithm+")",g.addRow(me(ge.serverSignature),I)}g.addRow(me(ge.cipher),i.securityDetails.cipher+(i.securityDetails.mac?" with "+i.securityDetails.mac:"")),i.securityDetails.encryptedClientHello&&g.addRow(me(ge.encryptedClientHello),me(ge.enabled));const m=this.element.createChild("div","origin-view-section"),y=m.createChild("div","origin-view-section-title");y.textContent=me(ge.certificate),c.ARIAUtils.markAsHeading(y,2);const w=i.securityDetails.signedCertificateTimestampList.length,S=i.securityDetails.certificateTransparencyCompliance;let b;if(w||"unknown"!==S){b=this.element.createChild("div","origin-view-section");const R=b.createChild("div","origin-view-section-title");R.textContent=me(ge.certificateTransparency),c.ARIAUtils.markAsHeading(R,2)}const k=this.createSanDiv(i.securityDetails.sanList),f=new Date(1e3*i.securityDetails.validFrom).toUTCString(),x=new Date(1e3*i.securityDetails.validTo).toUTCString();if(g=new Pe,m.appendChild(g.element()),g.addRow(me(ge.subject),i.securityDetails.subjectName),g.addRow(s.i18n.lockedString("SAN"),k),g.addRow(me(ge.validFrom),f),g.addRow(me(ge.validUntil),x),g.addRow(me(ge.issuer),i.securityDetails.issuer),g.addRow("",Te.createCertificateViewerButtonForOrigin(me(ge.openFullCertificateDetails),e)),!b)return;const C=new Pe;C.element().classList.add("sct-summary"),b.appendChild(C.element());for(let P=0;P<w;P++){const A=i.securityDetails.signedCertificateTimestampList[P];C.addRow(me(ge.sct),A.logDescription+" ("+A.origin+", "+A.status+")")}const T=b.createChild("div","sct-details");T.classList.add("hidden");for(let L=0;L<w;L++){const M=new Pe;T.appendChild(M.element());const D=i.securityDetails.signedCertificateTimestampList[L];M.addRow(me(ge.logName),D.logDescription),M.addRow(me(ge.logId),D.logId.replace(/(.{2})/g,"$1 ")),M.addRow(me(ge.validationStatus),D.status),M.addRow(me(ge.source),D.origin),M.addRow(me(ge.issuedAt),new Date(D.timestamp).toUTCString()),M.addRow(me(ge.hashAlgorithm),D.hashAlgorithm),M.addRow(me(ge.signatureAlgorithm),D.signatureAlgorithm),M.addRow(me(ge.signatureData),D.signatureData.replace(/(.{2})/g,"$1 "))}if(w){function H(){let e;const t=!T.classList.contains("hidden");e=me(t?ge.showFullDetails:ge.hideFullDetails),U.textContent=e,c.ARIAUtils.setLabel(U,e),c.ARIAUtils.setExpanded(U,!t),C.element().classList.toggle("hidden"),T.classList.toggle("hidden")}const U=c.UIUtils.createTextButton(me(ge.showFullDetails),H,{className:"details-toggle",jslogContext:"security.toggle-scts-details"});b.appendChild(U)}switch(S){case"compliant":b.createChild("div","origin-view-section-notes").textContent=me(ge.thisRequestCompliesWithChromes);break;case"not-compliant":b.createChild("div","origin-view-section-notes").textContent=me(ge.thisRequestDoesNotComplyWith)}const E=this.element.createChild("div","origin-view-section origin-view-notes");i.loadedFromCache&&(E.createChild("div").textContent=me(ge.thisResponseWasLoadedFromCache)),E.createChild("div").textContent=me(ge.theSecurityDetailsAboveAreFrom)}else if("secure"===i.securityState){const F=this.element.createChild("div","origin-view-section"),$=F.createChild("div","origin-view-section-title");$.textContent=me(ge.secure),c.ARIAUtils.markAsHeading($,2),F.createChild("div").textContent=me(ge.thisOriginIsANonhttpsSecure)}else if("unknown"!==i.securityState){const V=this.element.createChild("div","origin-view-section"),O=V.createChild("div","origin-view-section-title");O.textContent=me(ge.notSecure),c.ARIAUtils.markAsHeading(O,2),V.createChild("div").textContent=me(ge.yourConnectionToThisOriginIsNot)}else{const N=this.element.createChild("div","origin-view-section"),B=N.createChild("div","origin-view-section-title");B.textContent=me(ge.noSecurityInformation),c.ARIAUtils.markAsHeading(B,2),N.createChild("div").textContent=me(ge.noSecurityDetailsAreAvailableFor)}}createSanDiv(e){const t=document.createElement("div");if(0===e.length)t.textContent=me(ge.na),t.classList.add("empty-san");else{const i=2,s=e.length>i+1;for(let r=0;r<e.length;r++){const o=t.createChild("span","san-entry");o.textContent=e[r],s&&r>=i&&o.classList.add("truncated-entry")}if(s){function n(){const i=t.classList.contains("truncated-san");let s;i?(t.classList.remove("truncated-san"),s=me(ge.showLess)):(t.classList.add("truncated-san"),s=me(ge.showMoreSTotal,{PH1:e.length})),a.textContent=s,c.ARIAUtils.setLabel(a,s),c.ARIAUtils.setExpanded(a,i)}const a=c.UIUtils.createTextButton(me(ge.showMoreSTotal,{PH1:e.length}),n,{jslogContext:"security.toggle-san-truncation"});t.appendChild(a),n()}}return t}setSecurityState(e){this.originLockIcon.removeChildren();const t=ke(e,`security-property security-property-${e}`);this.originLockIcon.appendChild(t)}}class Pe{#C;constructor(){this.#C=document.createElement("table"),this.#C.classList.add("details-table")}element(){return this.#C}addRow(e,t){const i=this.#C.createChild("tr","details-table-row");i.createChild("td").textContent=e;const s=i.createChild("td");"string"==typeof t?s.textContent=t:s.appendChild(t)}}var Ae=Object.freeze({__proto__:null,get OriginGroup(){return Ee},SecurityDetailsTable:Pe,SecurityMainView:Ie,SecurityOriginView:Re,SecurityPanel:Te,SecurityRevealer:class{async reveal(){await c.ViewManager.ViewManager.instance().showView("security");const e=c.ViewManager.ViewManager.instance().view("security");if(e){const t=await e.widget();if(!(t instanceof Te&&t.sidebar.cookieReportTreeElement))throw new Error("Expected securityPanel to be an instance of SecurityPanel with a cookieReportTreeElement in the sidebar");t.sidebar.cookieReportTreeElement.select(!1,!0)}}},createHighlightedUrl:xe,getSecurityStateIconForDetailedView:ke,getSecurityStateIconForOverview:fe});export{R as CookieControlsView,V as CookieReportView,Q as SecurityModel,Ae as SecurityPanel};
//# sourceMappingURL=security.js.map
