import * as SDK from '../../core/sdk/sdk.js';
import * as Protocol from '../../generated/protocol.js';
import * as UI from '../../ui/legacy/legacy.js';
export declare class ScreencastView extends UI.Widget.VBox implements SDK.OverlayModel.Highlighter {
    #private;
    private readonly screenCaptureModel;
    private domModel;
    private readonly overlayModel;
    private resourceTreeModel;
    private networkManager;
    private readonly inputModel;
    private shortcuts;
    private scrollOffsetX;
    private scrollOffsetY;
    private screenZoom;
    private screenOffsetTop;
    private pageScaleFactor;
    private imageElement;
    private viewportElement;
    private glassPaneElement;
    private canvasElement;
    private titleElement;
    private context;
    private imageZoom;
    private tagNameElement;
    private attributeElement;
    private nodeWidthElement;
    private nodeHeightElement;
    private model;
    private highlightConfig;
    private navigationUrl;
    private navigationBack;
    private navigationForward;
    private canvasContainerElement?;
    private checkerboardPattern?;
    private targetInactive?;
    private deferredCasting?;
    private highlightNode?;
    private config?;
    private node?;
    private inspectModeConfig?;
    private navigationBar?;
    private navigationReload?;
    private navigationProgressBar?;
    private touchInputToggle?;
    private mouseInputToggle?;
    private touchInputToggleIcon?;
    private mouseInputToggleIcon?;
    private historyIndex?;
    private historyEntries?;
    private isCasting;
    private screencastOperationId?;
    constructor(screenCaptureModel: SDK.ScreenCaptureModel.ScreenCaptureModel);
    initialize(): void;
    willHide(): void;
    private startCasting;
    private stopCasting;
    private screencastFrame;
    private isGlassPaneActive;
    private screencastVisibilityChanged;
    private onSuspendStateChange;
    private updateGlasspane;
    private handleMouseEvent;
    private handleWheelEvent;
    private handleKeyEvent;
    private handleBlurEvent;
    private handleContextMenuEvent;
    private convertIntoScreenSpace;
    onResize(): void;
    highlightInOverlay(data: SDK.OverlayModel.HighlightData, config: Protocol.Overlay.HighlightConfig | null): void;
    private updateHighlightInOverlayAndRepaint;
    private scaleModel;
    private repaint;
    private cssColor;
    private quadToPath;
    private drawOutlinedQuad;
    private drawOutlinedQuadWithClip;
    private drawElementTitle;
    private viewportDimensions;
    setInspectMode(mode: Protocol.Overlay.InspectMode, config: Protocol.Overlay.HighlightConfig): Promise<void>;
    highlightFrame(_frameId: string): void;
    private createCheckerboardPattern;
    private createNavigationBar;
    private navigateToHistoryEntry;
    private navigateReload;
    private navigationUrlKeyUp;
    private requestNavigationHistoryEvent;
    private requestNavigationHistory;
    private focusNavigationBar;
}
export declare const BORDERS_SIZE = 44;
export declare const NAVBAR_HEIGHT = 29;
export declare const HTTP_REGEX: RegExp;
export declare const SCHEME_REGEX: RegExp;
export declare class ProgressTracker {
    private element;
    private requestIds;
    private startedRequests;
    private finishedRequests;
    private maxDisplayedProgress;
    constructor(resourceTreeModel: SDK.ResourceTreeModel.ResourceTreeModel | null, networkManager: SDK.NetworkManager.NetworkManager | null, element: HTMLElement);
    private onPrimaryPageChanged;
    private onLoad;
    private navigationProgressVisible;
    private onRequestStarted;
    private onRequestFinished;
    private updateProgress;
    private displayProgress;
}
