import*as e from"../../core/common/common.js";import*as t from"../../core/platform/platform.js";import*as o from"../../core/sdk/sdk.js";import*as s from"../../models/text_utils/text_utils.js";import*as r from"../../models/workspace/workspace.js";import"../../ui/components/highlighting/highlighting.js";import"../../ui/legacy/components/data_grid/data_grid.js";import*as i from"../../core/i18n/i18n.js";import*as n from"../../ui/legacy/legacy.js";import{Directives as a,render as c,html as l,nothing as d,i18nTemplate as u}from"../../ui/lit/lit.js";import*as g from"../../core/host/host.js";import*as h from"../../models/bindings/bindings.js";import"../../ui/components/buttons/buttons.js";import*as p from"../../ui/visual_logging/visual_logging.js";var v;!function(e){e.CoverageUpdated="CoverageUpdated",e.CoverageReset="CoverageReset",e.SourceMapResolved="SourceMapResolved"}(v||(v={}));class f extends o.SDKModel.SDKModel{cpuProfilerModel;cssModel;debuggerModel;coverageByURL;coverageByContentProvider;coverageUpdateTimes;suspensionState;pollTimer;currentPollPromise;shouldResumePollingOnResume;jsBacklog;cssBacklog;performanceTraceRecording;sourceMapManager;willResolveSourceMaps;processSourceMapBacklog;constructor(e){super(e),this.cpuProfilerModel=e.model(o.CPUProfilerModel.CPUProfilerModel),this.cssModel=e.model(o.CSSModel.CSSModel),this.debuggerModel=e.model(o.DebuggerModel.DebuggerModel),this.sourceMapManager=this.debuggerModel?.sourceMapManager()||null,this.sourceMapManager?.addEventListener(o.SourceMapManager.Events.SourceMapAttached,this.sourceMapAttached,this),this.coverageByURL=new Map,this.coverageByContentProvider=new Map,this.coverageUpdateTimes=new Set,this.suspensionState="Active",this.pollTimer=null,this.currentPollPromise=null,this.shouldResumePollingOnResume=!1,this.jsBacklog=[],this.cssBacklog=[],this.performanceTraceRecording=!1,this.willResolveSourceMaps=!1,this.processSourceMapBacklog=[]}async start(e){if("Active"!==this.suspensionState)throw new Error("Cannot start CoverageModel while it is not active.");const t=[];return this.cssModel&&(this.clearCSS(),this.cssModel.addEventListener(o.CSSModel.Events.StyleSheetAdded,this.handleStyleSheetAdded,this),t.push(this.cssModel.startCoverage())),this.cpuProfilerModel&&t.push(this.cpuProfilerModel.startPreciseCoverage(e,this.preciseCoverageDeltaUpdate.bind(this))),await Promise.all(t),Boolean(this.cssModel||this.cpuProfilerModel)}async sourceMapAttached(e){const t=e.data.client,o=e.data.sourceMap;this.processSourceMapBacklog.push({script:t,sourceMap:o}),this.willResolveSourceMaps||(this.willResolveSourceMaps=!0,setTimeout(this.resolveSourceMapsAndUpdate.bind(this),500))}async resolveSourceMapsAndUpdate(){this.willResolveSourceMaps=!1;const e=this.processSourceMapBacklog;this.processSourceMapBacklog=[],await Promise.all(e.map(({script:e,sourceMap:t})=>this.resolveSourceMap(e,t))),this.dispatchEventToListeners(v.SourceMapResolved)}async resolveSourceMap(e,t){const o=e.sourceURL,r=this.coverageByURL.get(o);if(r&&0===r.sourcesURLCoverageInfo.size){const o=s.ContentData.ContentData.contentDataOrEmpty(await e.requestContentData()),[i,n]=this.calculateSizeForSources(t,o.textObj,e.contentLength);r.setSourceSegments(n);for(const e of t.sourceURLs())this.addCoverageForSource(e,i.get(e)||0,r.type(),r)}}async preciseCoverageDeltaUpdate(e,t){this.coverageUpdateTimes.add(e);const o=await this.backlogOrProcessJSCoverage(t,e);o.length&&this.dispatchEventToListeners(v.CoverageUpdated,o)}async stop(){await this.stopPolling();const e=[];this.cpuProfilerModel&&e.push(this.cpuProfilerModel.stopPreciseCoverage()),this.cssModel&&(e.push(this.cssModel.stopCoverage()),this.cssModel.removeEventListener(o.CSSModel.Events.StyleSheetAdded,this.handleStyleSheetAdded,this)),await Promise.all(e)}reset(){this.coverageByURL=new Map,this.coverageByContentProvider=new Map,this.coverageUpdateTimes=new Set,this.dispatchEventToListeners(v.CoverageReset)}async startPolling(){this.currentPollPromise||"Active"!==this.suspensionState||await this.pollLoop()}async pollLoop(){this.clearTimer(),this.currentPollPromise=this.pollAndCallback(),await this.currentPollPromise,("Active"===this.suspensionState||this.performanceTraceRecording)&&(this.pollTimer=window.setTimeout(()=>this.pollLoop(),200))}async stopPolling(){this.clearTimer(),await this.currentPollPromise,this.currentPollPromise=null,await this.pollAndCallback()}async pollAndCallback(){if("Suspended"===this.suspensionState&&!this.performanceTraceRecording)return;const e=await this.takeAllCoverage();console.assert("Suspended"!==this.suspensionState||Boolean(this.performanceTraceRecording),"CoverageModel was suspended while polling."),e.length&&this.dispatchEventToListeners(v.CoverageUpdated,e)}clearTimer(){this.pollTimer&&(clearTimeout(this.pollTimer),this.pollTimer=null)}async preSuspendModel(e){"Active"===this.suspensionState&&(this.suspensionState="Suspending","performance-timeline"!==e?this.currentPollPromise&&(await this.stopPolling(),this.shouldResumePollingOnResume=!0):this.performanceTraceRecording=!0)}async suspendModel(e){this.suspensionState="Suspended"}async resumeModel(){}async postResumeModel(){this.suspensionState="Active",this.performanceTraceRecording=!1,this.shouldResumePollingOnResume&&(this.shouldResumePollingOnResume=!1,await this.startPolling())}entries(){return Array.from(this.coverageByURL.values())}getCoverageForUrl(e){return this.coverageByURL.get(e)||null}usageForRange(e,t,o){const s=this.coverageByContentProvider.get(e);return s?.usageForRange(t,o)}clearCSS(){for(const e of this.coverageByContentProvider.values()){if(1!==e.type())continue;const t=e.getContentProvider();this.coverageByContentProvider.delete(t);const o=this.coverageByURL.get(e.url());if(!o)continue;const s=`${t.startLine}:${t.startColumn}`;o.removeCoverageEntry(s,e),0===o.numberOfEntries()&&this.coverageByURL.delete(e.url())}if(this.cssModel)for(const e of this.cssModel.getAllStyleSheetHeaders())this.addStyleSheetToCSSCoverage(e)}async takeAllCoverage(){const[e,t]=await Promise.all([this.takeCSSCoverage(),this.takeJSCoverage()]);return[...e,...t]}async takeJSCoverage(){if(!this.cpuProfilerModel)return[];const{coverage:e,timestamp:t}=await this.cpuProfilerModel.takePreciseCoverage();return this.coverageUpdateTimes.add(t),await this.backlogOrProcessJSCoverage(e,t)}async backlogOrProcessJSCoverage(e,t){if(e.length>0&&this.jsBacklog.push({rawCoverageData:e,stamp:t}),"Active"!==this.suspensionState)return[];const o=(e,t)=>e.stamp-t.stamp,s=[];for(const{rawCoverageData:e,stamp:t}of this.jsBacklog.sort(o))s.push(await this.processJSCoverage(e,t));return this.jsBacklog=[],s.flat()}async processJSBacklog(){this.backlogOrProcessJSCoverage([],0)}async processJSCoverage(e,t){if(!this.debuggerModel)return[];const o=[];for(const s of e){const e=this.debuggerModel.scriptForId(s.scriptId);if(!e)continue;const r=[];let i=2;for(const e of s.functions){!1!==e.isBlockCoverage||1===e.ranges.length&&!e.ranges[0].count||(i|=4);for(const t of e.ranges)r.push(t)}const n=await this.addCoverage(e,e.contentLength,e.lineOffset,e.columnOffset,r,i,t);n&&o.push(...n)}return o}handleStyleSheetAdded(e){this.addStyleSheetToCSSCoverage(e.data)}async takeCSSCoverage(){if(!this.cssModel||"Active"!==this.suspensionState)return[];const{coverage:e,timestamp:t}=await this.cssModel.takeCoverageDelta();return this.coverageUpdateTimes.add(t),await this.backlogOrProcessCSSCoverage(e,t)}async backlogOrProcessCSSCoverage(e,t){if(e.length>0&&this.cssBacklog.push({rawCoverageData:e,stamp:t}),"Active"!==this.suspensionState)return[];const o=(e,t)=>e.stamp-t.stamp,s=[];for(const{rawCoverageData:e,stamp:t}of this.cssBacklog.sort(o))s.push(await this.processCSSCoverage(e,t));return this.cssBacklog=[],s.flat()}async processCSSCoverage(e,t){if(!this.cssModel)return[];const o=[],s=new Map;for(const t of e){const e=this.cssModel.styleSheetHeaderForId(t.styleSheetId);if(!e)continue;let o=s.get(e);o||(o=[],s.set(e,o)),o.push({startOffset:t.startOffset,endOffset:t.endOffset,count:Number(t.used)})}for(const e of s){const s=e[0],r=e[1],i=await this.addCoverage(s,s.contentLength,s.startLine,s.startColumn,r,1,t);i&&o.push(...i)}return o}static convertToDisjointSegments(e,t){e.sort((e,t)=>e.startOffset-t.startOffset);const o=[],s=[];for(const t of e){let e=s[s.length-1];for(;e&&e.endOffset<=t.startOffset;)r(e.endOffset,e.count),s.pop(),e=s[s.length-1];r(t.startOffset,e?e.count:0),s.push(t)}for(let e=s.pop();e;e=s.pop())r(e.endOffset,e.count);function r(e,s){const r=o[o.length-1];if(r){if(r.end===e)return;if(r.count===s)return void(r.end=e)}o.push({end:e,count:s,stamp:t})}return o}addStyleSheetToCSSCoverage(e){this.addCoverage(e,e.contentLength,e.startLine,e.startColumn,[],1,Date.now())}calculateSizeForSources(e,t,o){const s=new Map,r=[],i=function(e,o,s,r){if(e===s)return r-o;if(t){const i=t.offsetFromPosition(e,o);return t.offsetFromPosition(s,r)-i}return r},n=e.mappings();if(0===n.length)return[s,r];let a=n[0],c=0;c+=t?t.offsetFromPosition(a.lineNumber,a.columnNumber):i(0,0,a.lineNumber,a.columnNumber),r.push({end:c,sourceUrl:""});for(let l=0;l<n.length;l++){const d=n[l],u=e.findEntryRanges(d.lineNumber,d.columnNumber);if(u){const e=u.range,r=u.sourceURL,a=s.get(r)||0;let c=0;if(l===n.length-1){c=o-t.offsetFromPosition(e.startLine,e.startColumn)}else c=i(e.startLine,e.startColumn,e.endLine,e.endColumn);s.set(r,a+c)}if(c+=i(a.lineNumber,a.columnNumber,d.lineNumber,d.columnNumber),d.sourceURL!==a.sourceURL)if(t){const e=t.offsetFromPosition(d.lineNumber,d.columnNumber);r.push({end:e,sourceUrl:a.sourceURL||""})}else r.push({end:c,sourceUrl:a.sourceURL||""});a=d,l===n.length-1&&r.push({end:o,sourceUrl:d.sourceURL||""})}return[s,r]}async addCoverage(e,t,o,r,i,n,a){const c=[],l=e.contentURL();if(!l)return null;let d=this.coverageByURL.get(l),u=!1;if(!d){u=!0,d=new S(l),this.coverageByURL.set(l,d);const o=await(this.sourceMapManager?.sourceMapForClientPromise(e));if(o){const r=s.ContentData.ContentData.contentDataOrEmpty(await e.requestContentData()),[i,a]=this.calculateSizeForSources(o,r.textObj,t);d.setSourceSegments(a);for(const e of o.sourceURLs()){const t=this.addCoverageForSource(e,i.get(e)||0,n,d);t&&c.push(t)}}}const g=d.ensureEntry(e,t,o,r,n);this.coverageByContentProvider.set(e,g);const h=f.convertToDisjointSegments(i,a),p=h[h.length-1];p&&p.end<t&&h.push({end:t,stamp:a,count:0});const v=g.mergeCoverage(h);if(!u&&0===v)return null;d.addToSizes(v,0);for(const[e,t]of g.sourceDeltaMap){const o=d.sourcesURLCoverageInfo.get(e);o&&(o.addToSizes(t,0),o.lastSourceUsedRange=g.sourceUsedRangeMap.get(e)||[])}return c.push(g),c}addCoverageForSource(e,t,o,s){const i=r.Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(e),n=new C(e,s),a=n.ensureEntry(i,t,0,0,o);return s.sourcesURLCoverageInfo.set(e,n),a}async exportReport(t){const o=[],s=Array.from(this.coverageByURL.keys()).sort();for(const t of s){const s=this.coverageByURL.get(t);if(!s)continue;const r=s.url();r.startsWith("extensions::")||e.ParsedURL.schemeIs(r,"chrome-extension:")||o.push(...await s.entriesForExport())}await t.write(JSON.stringify(o,void 0,2)),t.close()}}function m(e,t){const[o,s]=e.split(":"),[r,i]=t.split(":");return Number.parseInt(o,10)-Number.parseInt(r,10)||Number.parseInt(s,10)-Number.parseInt(i,10)}o.SDKModel.SDKModel.register(f,{capabilities:0,autostart:!1});class S extends e.ObjectWrapper.ObjectWrapper{#e;coverageInfoByLocation;#t;#o;#s;#r;sourcesURLCoverageInfo=new Map;sourceSegments;constructor(e){super(),this.#e=e,this.coverageInfoByLocation=new Map,this.#t=0,this.#o=0,this.#r=!1}url(){return this.#e}type(){return this.#s}size(){return this.#t}usedSize(){return this.#o}unusedSize(){return this.#t-this.#o}usedPercentage(){return 0===this.#t?0:this.unusedSize()&&this.size()?this.usedSize()/this.size():0}unusedPercentage(){return 0===this.#t?1:this.unusedSize()/this.size()}isContentScript(){return this.#r}entries(){return this.coverageInfoByLocation.values()}numberOfEntries(){return this.coverageInfoByLocation.size}removeCoverageEntry(e,t){this.coverageInfoByLocation.delete(e)&&this.addToSizes(-t.getUsedSize(),-t.getSize())}addToSizes(e,t){this.#o+=e,this.#t+=t,0===e&&0===t||this.dispatchEventToListeners(S.Events.SizesChanged)}setSourceSegments(e){this.sourceSegments=e}ensureEntry(e,t,s,r,i){const n=`${s}:${r}`;let a=this.coverageInfoByLocation.get(n);return 2&i&&!this.coverageInfoByLocation.size&&e instanceof o.Script.Script&&(this.#r=e.isContentScript()),this.#s|=i,a?(a.addCoverageType(i),a):(2&i&&!this.coverageInfoByLocation.size&&e instanceof o.Script.Script&&(this.#r=e.isContentScript()),a=new b(e,t,s,r,i,this),this.coverageInfoByLocation.set(n,a),this.addToSizes(0,t),a)}async getFullText(){let e=!1;const t=this.url();for(const o of this.coverageInfoByLocation.values()){const{lineOffset:s,columnOffset:r}=o.getOffsets();if(s||r){e=Boolean(t);break}}if(!e)return null;const r=o.ResourceTreeModel.ResourceTreeModel.resourceForURL(t);if(!r)return null;return s.ContentData.ContentData.contentDataOrEmpty(await r.requestContentData()).textObj}entriesForExportBasedOnFullText(e){const t=Array.from(this.coverageInfoByLocation.keys()).sort(m),o={url:this.url(),ranges:[],text:e.value()};for(const s of t){const t=this.coverageInfoByLocation.get(s);if(!t)continue;const{lineOffset:r,columnOffset:i}=t.getOffsets(),n=e?e.offsetFromPosition(r,i):0;o.ranges.push(...t.rangesForExport(n))}return o}async entriesForExportBasedOnContent(){const e=Array.from(this.coverageInfoByLocation.keys()).sort(m),t=[];for(const o of e){const e=this.coverageInfoByLocation.get(o);if(!e)continue;const r={url:this.url(),ranges:e.rangesForExport(),text:s.ContentData.ContentData.textOr(await e.getContentProvider().requestContentData(),null)};t.push(r)}return t}async entriesForExport(){const e=await this.getFullText();return e?[await this.entriesForExportBasedOnFullText(e)]:await this.entriesForExportBasedOnContent()}}class C extends S{generatedURLCoverageInfo;lastSourceUsedRange=[];constructor(e,t){super(e),this.generatedURLCoverageInfo=t}}!function(e){let t;!function(e){e.SizesChanged="SizesChanged"}(t=e.Events||(e.Events={}))}(S||(S={}));const y=(e,t)=>{const o=[];let s=0,r=0;for(;s<e.length&&r<t.length;){const i=e[s],n=t[r],a=(i.count||0)+(n.count||0),c=Math.min(i.end,n.end),l=o[o.length-1],d=Math.min(i.stamp,n.stamp);l?.count!==a||l.stamp!==d?o.push({end:c,count:a,stamp:d}):l.end=c,i.end<=n.end&&s++,i.end>=n.end&&r++}for(;s<e.length;s++)o.push(e[s]);for(;r<t.length;r++)o.push(t[r]);return o};class b{contentProvider;size;usedSize;statsByTimestamp;lineOffset;columnOffset;coverageType;segments;generatedUrlCoverageInfo;sourceUsedSizeMap=new Map;sourceDeltaMap=new Map;sourceUsedRangeMap=new Map;constructor(e,t,o,s,r,i){this.contentProvider=e,this.size=t,this.usedSize=0,this.statsByTimestamp=new Map,this.lineOffset=o,this.columnOffset=s,this.coverageType=r,this.generatedUrlCoverageInfo=i,this.segments=[]}getContentProvider(){return this.contentProvider}url(){return this.contentProvider.contentURL()}type(){return this.coverageType}addCoverageType(e){this.coverageType|=e}getOffsets(){return{lineOffset:this.lineOffset,columnOffset:this.columnOffset}}mergeCoverage(e){const t=this.usedSize;return this.segments=y(this.segments,e),this.updateStats(),this.generatedUrlCoverageInfo.sourceSegments&&this.generatedUrlCoverageInfo.sourceSegments.length>0&&this.updateSourceCoverage(),this.usedSize-t}getSize(){return this.size}getUsedSize(){return this.usedSize}usageForRange(e,o){let s=t.ArrayUtilities.upperBound(this.segments,e,(e,t)=>e-t.end);for(;s<this.segments.length&&this.segments[s].end<o;++s)if(this.segments[s].count)return!0;return s<this.segments.length&&Boolean(this.segments[s].count)}updateStats(){this.statsByTimestamp=new Map,this.usedSize=0;let e=0;for(const t of this.segments){let o=this.statsByTimestamp.get(t.stamp);if(void 0===o&&(o=0),t.count){const s=t.end-e;this.usedSize+=s,this.statsByTimestamp.set(t.stamp,o+s)}e=t.end}}updateSourceCoverage(){const e=new Map;this.sourceDeltaMap=new Map,this.sourceUsedRangeMap=new Map;const t=this.generatedUrlCoverageInfo.sourceSegments||[];let o=0,s=0;for(const r of this.segments){const i=r.end;if(r.count)for(let r=s;r<t.length;r++){const n=0===r?0:t[r-1].end+1,a=t[r].end,c=Math.max(o,n),l=Math.min(i,a);if(c<=l){const o=l-c+1,i={start:c,end:l};e.has(t[r].sourceUrl)?e.set(t[r].sourceUrl,e.get(t[r].sourceUrl)+o):e.set(t[r].sourceUrl,o),this.sourceUsedRangeMap.has(t[r].sourceUrl)?this.sourceUsedRangeMap.get(t[r].sourceUrl)?.push(i):this.sourceUsedRangeMap.set(t[r].sourceUrl,[i]),s=r}if(i<a)break}o=i+1}for(const[t,o]of e){const e=this.sourceUsedSizeMap.get(t)||0;e!==o&&(this.sourceUsedSizeMap.set(t,o),this.sourceDeltaMap.set(t,o-e))}}rangesForExport(e=0){const t=[];let o=0;for(const s of this.segments){if(s.count){const r=t.length>0?t[t.length-1]:null;r?.end===o+e?r.end=s.end+e:t.push({start:o+e,end:s.end+e})}o=s.end}return t}}var w=Object.freeze({__proto__:null,CoverageInfo:b,CoverageModel:f,get Events(){return v},SourceURLCoverageInfo:C,get URLCoverageInfo(){return S},mergeSegments:y}),P=`.data-grid{border:none}.data-grid td .url-outer{width:100%;display:inline-flex;justify-content:flex-start}.data-grid td .url-outer .filter-highlight{font-weight:bold}.data-grid td .url-prefix{overflow-x:hidden;text-overflow:ellipsis}.data-grid td .url-suffix{flex:none}.data-grid td .bar{display:inline-block;height:8px;border:1px solid transparent}.data-grid td .bar-unused-size{background-color:var(--app-color-coverage-unused)}.data-grid td .bar-used-size{background-color:var(--app-color-coverage-used)}.data-grid td .percent-value{width:7ex;display:inline-block;color:var(--sys-color-on-surface-subtle)}@media (forced-colors: active){.data-grid td .bar-container{forced-color-adjust:none}.data-grid td .bar-unused-size{background-color:ButtonText}.data-grid td .bar-used-size{background-color:ButtonFace}.data-grid td .bar{border-color:ButtonText}.data-grid .selected td .bar{border-top-color:HighlightText;border-bottom-color:HighlightText}.data-grid .selected td .bar:last-child{border-right-color:HighlightText}.data-grid .selected td .bar:first-child{border-left-color:HighlightText}.data-grid:focus tr.selected span.percent-value{color:HighlightText}}\n/*# sourceURL=${import.meta.resolve("./coverageListView.css")} */`;const M={css:"CSS",jsPerFunction:"JS (per function)",jsPerBlock:"JS (per block)",url:"URL",type:"Type",totalBytes:"Total Bytes",unusedBytes:"Unused Bytes",usageVisualization:"Usage Visualization",codeCoverage:"Code Coverage",jsCoverageWithPerFunction:"JS coverage with per function granularity: Once a function was executed, the whole function is marked as covered.",jsCoverageWithPerBlock:"JS coverage with per block granularity: Once a block of JavaScript was executed, that block is marked as covered.",sBytes:"{n, plural, =1 {# byte} other {# bytes}}",sBytesS:"{n, plural, =1 {# byte, {percentage}} other {# bytes, {percentage}}}",sBytesSBelongToFunctionsThatHave:"{PH1} bytes ({PH2}) belong to functions that have not (yet) been executed.",sBytesSBelongToBlocksOf:"{PH1} bytes ({PH2}) belong to blocks of JavaScript that have not (yet) been executed.",sBytesSBelongToFunctionsThatHaveExecuted:"{PH1} bytes ({PH2}) belong to functions that have executed at least once.",sBytesSBelongToBlocksOfJavascript:"{PH1} bytes ({PH2}) belong to blocks of JavaScript that have executed at least once.",sOfFileUnusedSOfFileUsed:"{PH1} % of file unused, {PH2} % of file used"},R=i.i18n.registerUIStrings("panels/coverage/CoverageListView.ts",M),x=i.i18n.getLocalizedString.bind(void 0,R),{styleMap:B,repeat:U}=a;function T(e){const t=[];return 1&e&&t.push(x(M.css)),4&e?t.push(x(M.jsPerFunction)):2&e&&t.push(x(M.jsPerBlock)),t.join("+")}const k=e=>function(){I||(I=new Intl.NumberFormat(i.DevToolsLocale.DevToolsLocale.instance().locale));return I}().format(e??0),L=e=>function(){z||(z=new Intl.NumberFormat(i.DevToolsLocale.DevToolsLocale.instance().locale,{style:"percent",maximumFractionDigits:1}));return z}().format(e??0),$=(e,t,o)=>{c(l`
    <style>${P}</style>
    <devtools-data-grid class="flex-auto" name=${x(M.codeCoverage)} striped autofocus resize="last"
      .template=${l`
        <table>
          <tr>
            <th id="url" width="250px" weight="3" sortable>${x(M.url)}</th>
            <th id="type" width="45px" weight="1" fixed sortable>${x(M.type)}</th>
            <th id="size" width="60px" align="right" weight="1" fixed sortable>${x(M.totalBytes)}</th>
            <th id="unused-size" width="100px" align="right" weight="1" fixed sortable sort="descending">${x(M.unusedBytes)}</th>
            <th id="bars" width="250px" weight="1" sortable>${x(M.usageVisualization)}</th>
          </tr>
          ${U(e.items,e=>e.url,t=>O(t,e))}
        </table>`}>
      </devtools-data-grid>`,o)};class F extends n.Widget.VBox{#i;#n=[];#a=null;#c=0;#l;constructor(e,t=$){super(e,{useShadowDom:!0,delegatesFocus:!0}),this.#l=t,this.#i=null}set highlightRegExp(e){this.#i=e,this.requestUpdate()}get highlightRegExp(){return this.#i}set coverageInfo(e){this.#n=e,this.#c=e.reduce((e,t)=>Math.max(e,t.size),0),this.requestUpdate()}get coverageInfo(){return this.#n}performUpdate(){const e={items:this.#n,selectedUrl:this.#a,maxSize:this.#c,onOpen:e=>{this.selectedUrl=e},highlightRegExp:this.#i};this.#l(e,{},this.contentElement)}reset(){this.#n=[],this.#c=0,this.requestUpdate()}set selectedUrl(t){if(!this.#n.find(e=>e.url===t))return;this.#a!==t&&(this.#a=t,this.requestUpdate());const o=t?r.Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(t):null;o&&e.Revealer.reveal(o)}get selectedUrl(){return this.#a}}let z=null;let I=null;function O(e,t){const o=/^(.*)(\/[^/]*)$/.exec(e.url);return l`
    <style>${P}</style>
    <tr data-url=${e.url} selected=${e.url===t.selectedUrl}
        @open=${()=>t.onOpen(e.url)}>
      <td data-value=${e.url} title=${e.url} aria-label=${e.url}>
        <devtools-highlight ranges=${function(e){const o=t.highlightRegExp?.exec(e);return o?.length?`${o.index},${o[0].length}`:""}(e.url)} class="url-outer" aria-hidden="true">
          <div class="url-prefix">${o?o[1]:e.url}</div>
          <div class="url-suffix">${o?o[2]:""}</div>
        </devtools-highlight>
      </td>
      <td data-value=${T(e.type)}
          title=${4&e.type?x(M.jsCoverageWithPerFunction):2&e.type?x(M.jsCoverageWithPerBlock):""}>
        ${T(e.type)}
      </td>
      <td data-value=${e.size} aria-label=${x(M.sBytes,{n:e.size||0})}>
        <span>${k(e.size)}</span>
      </td>
      <td data-value=${e.unusedSize} aria-label=${x(M.sBytesS,{n:e.unusedSize,percentage:L(e.unusedPercentage)})}>
        <span>${k(e.unusedSize)}</span>
        <span class="percent-value">
          ${L(e.unusedPercentage)}
        </span>
      </td>
      <td data-value=${e.unusedSize} aria-label=${x(M.sOfFileUnusedSOfFileUsed,{PH1:L(e.unusedPercentage),PH2:L(e.usedPercentage)})}>
        <div class="bar-container">
          ${e.unusedSize>0?l`
            <div class="bar bar-unused-size"
                title=${4&e.type?x(M.sBytesSBelongToFunctionsThatHave,{PH1:e.unusedSize,PH2:L(e.unusedPercentage)}):2&e.type?x(M.sBytesSBelongToBlocksOf,{PH1:e.unusedSize,PH2:L(e.unusedPercentage)}):""}
                  style=${B({width:(e.unusedSize/t.maxSize*100||0)+"%"})}>
            </div>`:d}
          ${e.usedSize>0?l`
            <div class="bar bar-used-size"
                  title=${4&e.type?x(M.sBytesSBelongToFunctionsThatHaveExecuted,{PH1:e.usedSize,PH2:L(e.usedPercentage)}):2&e.type?x(M.sBytesSBelongToBlocksOfJavascript,{PH1:e.usedSize,PH2:L(e.usedPercentage)}):""}
                style=${B({width:(e.usedSize/t.maxSize*100||0)+"%"})}>
            </div>`:d}
        </div>
      </td>
      ${e.sources.length>0?l`
        <td><table>
          ${U(e.sources,e=>e.url,e=>O(e,t))}
        </table></td>`:d}
    </tr>`}var E=Object.freeze({__proto__:null,CoverageListView:F,DEFAULT_VIEW:$,coverageTypeToString:T});const D="coverage";class A{coverageModel;textByProvider;uiSourceCodeByContentProvider;#d;#u;#g;constructor(e,o,s,i){this.coverageModel=e,this.#d=o,this.#u=s,this.#g=i,this.textByProvider=new Map,this.uiSourceCodeByContentProvider=new t.MapUtilities.Multimap;for(const e of this.#d.uiSourceCodes())e.setDecorationData(D,this);this.#d.addEventListener(r.Workspace.Events.UISourceCodeAdded,this.onUISourceCodeAdded,this)}reset(){for(const e of this.#d.uiSourceCodes())e.setDecorationData(D,void 0)}dispose(){this.reset(),this.#d.removeEventListener(r.Workspace.Events.UISourceCodeAdded,this.onUISourceCodeAdded,this)}update(e){for(const t of e)for(const e of this.uiSourceCodeByContentProvider.get(t.getContentProvider()))e.setDecorationData(D,this)}async usageByLine(e,t){const o=[];await this.updateTexts(e,t);for(const{startLine:s,startColumn:r,endLine:i,endColumn:n}of t){const t=this.rawLocationsForSourceLocation(e,s,r),a=this.rawLocationsForSourceLocation(e,i,n),[c,l]=await Promise.all([t,a]);let d;for(let e=0,t=0;e<c.length;++e){const o=c[e];for(;t<l.length&&A.compareLocations(o,l[t])>=0;)++t;if(t>=l.length||l[t].id!==o.id)continue;const s=l[t++],r=this.textByProvider.get(s.contentProvider);if(!r)continue;const i=r.value();let n=Math.min(r.offsetFromPosition(o.line,o.column),i.length-1),a=Math.min(r.offsetFromPosition(s.line,s.column),i.length-1);for(;n<=a&&/\s/.test(i[n]);)++n;for(;n<=a&&/\s/.test(i[a]);)--a;if(n<=a&&(d=this.coverageModel.usageForRange(s.contentProvider,n,a)),d)break}o.push(d)}return o}async updateTexts(e,t){const o=[];for(const s of t)for(const t of await this.rawLocationsForSourceLocation(e,s.startLine,0))this.textByProvider.has(t.contentProvider)||(this.textByProvider.set(t.contentProvider,null),this.uiSourceCodeByContentProvider.set(t.contentProvider,e),o.push(this.updateTextForProvider(t.contentProvider)));await Promise.all(o)}async updateTextForProvider(e){const t=s.ContentData.ContentData.contentDataOrEmpty(await e.requestContentData());this.textByProvider.set(e,t.textObj)}async rawLocationsForSourceLocation(e,t,o){const s=[],i=e.contentType();if(i.hasScripts()){let r=await this.#u.uiLocationToRawLocations(e,t,o);r=r.filter(e=>!!e.script());for(const e of r){const t=e.script();t&&(t.isInlineScript()&&i.isDocument()&&(e.lineNumber-=t.lineOffset,e.lineNumber||(e.columnNumber-=t.columnOffset)),s.push({id:`js:${e.scriptId}`,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}if(i.isStyleSheet()||i.isDocument()){const n=this.#g.uiLocationToRawLocations(new r.UISourceCode.UILocation(e,t,o));for(const e of n){const t=e.header();t&&(t.isInline&&i.isDocument()&&(e.lineNumber-=t.startLine,e.lineNumber||(e.columnNumber-=t.startColumn)),s.push({id:`css:${e.styleSheetId}`,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}return s.sort(A.compareLocations)}static compareLocations(e,t){return e.id.localeCompare(t.id)||e.line-t.line||e.column-t.column}onUISourceCodeAdded(e){e.data.setDecorationData(D,this)}}var j=Object.freeze({__proto__:null,CoverageDecorationManager:A,decoratorType:D}),H=`:host{overflow:hidden}.coverage-toolbar-container{display:flex;border-bottom:1px solid var(--sys-color-divider);flex:0 0 auto}.coverage-toolbar{flex:auto}.coverage-toolbar-summary{background-color:var(--sys-color-cdt-base-container);border-top:1px solid var(--sys-color-divider);padding-left:5px;flex:0 0 19px;display:flex;padding-right:5px}.coverage-toolbar-summary .coverage-message{padding-top:2px;padding-left:1ex;text-overflow:ellipsis;white-space:nowrap;overflow:hidden}.coverage-results{overflow-y:auto;display:flex;flex:auto}.bfcache-page,\n.prerender-page{justify-content:center;align-items:center;padding:20px}.bfcache-page .message,\n.prerender-page .message{white-space:pre-line;text-align:center}.inline-button{display:inline-flex;border:1px solid var(--sys-color-neutral-outline);border-radius:4px;position:relative;vertical-align:sub;margin:2px;background-color:var(--sys-color-cdt-base-container);justify-content:center;width:28px}.inline-button:hover{border-color:transparent;background-color:var(--sys-color-state-hover-on-subtle)}\n/*# sourceURL=${import.meta.resolve("./coverageView.css")} */`;const N={chooseCoverageGranularityPer:"Choose coverage granularity: Per function has low overhead, per block has significant overhead.",perFunction:"Per function",perBlock:"Per block",filterByUrl:"Filter by URL",filterCoverageByType:"Filter coverage by type",all:"All",css:"CSS",javascript:"JavaScript",includeExtensionContentScripts:"Include extension content scripts",contentScripts:"Content scripts",noCoverageData:"No coverage data",reloadPage:"Reload page",startRecording:"Start recording",clickTheReloadButtonSToReloadAnd:'Click the "{PH1}" button to reload and start capturing coverage.',clickTheRecordButtonSToStart:'Click the "{PH1}" button to start capturing coverage.',bfcacheNoCapture:"Could not capture coverage info because the page was served from the back/forward cache.",activationNoCapture:"Could not capture coverage info because the page was prerendered in the background.",reloadPrompt:"Click the reload button {PH1} to reload and get coverage.",filteredSTotalS:"Filtered: {PH1}  Total: {PH2}",sOfSSUsedSoFarSUnused:"{PH1} of {PH2} ({PH3}%) used so far, {PH4} unused."},W=i.i18n.registerUIStrings("panels/coverage/CoverageView.ts",N),V=i.i18n.getLocalizedString.bind(void 0,W),_=u.bind(void 0,W),{ref:J}=a,{bindToAction:q,bindToSetting:G}=n.UIUtils,{widgetConfig:K}=n.Widget;let X;const Q=(e,t,o)=>{var s,r;c(l`
      <style>${H}</style>
      <div class="coverage-toolbar-container" jslog=${p.toolbar()} role="toolbar">
        <devtools-toolbar class="coverage-toolbar" role="presentation" wrappable>
          <select title=${V(N.chooseCoverageGranularityPer)}
              aria-label=${V(N.chooseCoverageGranularityPer)}
              jslog=${p.dropDown("coverage-type").track({change:!0})}
              @change=${t=>e.onCoverageTypeChanged(t.target.selectedIndex)}
              .selectedIndex=${e.coverageType}
              ?disabled=${e.recording}>
            <option value=${6}
                    jslog=${p.item("6").track({click:!0})}>
                 ${V(N.perFunction)}
            </option>
            <option value=${2}
                    jslog=${p.item("2").track({click:!0})}>
              ${V(N.perBlock)}
            </option>
          </select>
          <devtools-button ${q(e.supportsRecordOnReload&&!e.recording?"coverage.start-with-reload":"coverage.toggle-recording")}>
          </devtools-button>
          <devtools-button ${q("coverage.clear")}></devtools-button>
          <div class="toolbar-divider"></div>
          <devtools-button ${q("coverage.export")}></devtools-button>
          <div class="toolbar-divider"></div>
          <devtools-toolbar-input type="filter" placeholder=${V(N.filterByUrl)}
              ?disabled=${!Boolean(e.coverageInfo)}
               @change=${t=>e.onFilterChanged(t.detail)}
               style="flex-grow:1; flex-shrink:1">
          </devtools-toolbar-input>
          <div class="toolbar-divider"></div>
          <select title=${V(N.filterCoverageByType)}
              aria-label=${V(N.filterCoverageByType)}
              jslog=${p.dropDown("coverage-by-type").track({change:!0})}
              ?disabled=${!Boolean(e.coverageInfo)}
              @change=${t=>e.onTypeFilterChanged(Number(t.target.selectedOptions[0]?.value))}>
            <option value="" jslog=${p.item("").track({click:!0})}
                    .selected=${null===e.typeFilter}>${V(N.all)}</option>
            <option value=${1}
                    jslog=${p.item("1").track({click:!0})}
                    .selected=${1===e.typeFilter}>
              ${V(N.css)}
            </option>
            <option value=${6}
                   jslog=${p.item("6").track({click:!0})}
                   .selected=${null!==e.typeFilter&&Boolean(6&e.typeFilter)}>
              ${V(N.javascript)}
            </option>
          </select>
          <div class="toolbar-divider"></div>
          <devtools-checkbox title=${V(N.includeExtensionContentScripts)}
              ${G(e.showContentScriptsSetting)}
              ?disabled=${!Boolean(e.coverageInfo)}>
            ${V(N.contentScripts)}
          </devtools-checkbox>
        </devtools-toolbar>
      </div>
      <div class="coverage-results">
        ${e.needsReload?(s="bfcache-page"===e.needsReload?V(N.bfcacheNoCapture):V(N.activationNoCapture),r=e.needsReload,l`
    <div class="widget vbox ${r}">
      <div class="message">${s}</div>
      <span class="message">
        ${_(N.reloadPrompt,{PH1:l`
          <devtools-button class="inline-button" ${q("inspector-main.reload")}></devtools-button>`})}
      </span>
    </div>`):e.coverageInfo?l`
          <devtools-widget autofocus class="results" .widgetConfig=${K(F,{coverageInfo:e.coverageInfo,highlightRegExp:e.textFilter,selectedUrl:e.selectedUrl})}
            ${J(e=>{e instanceof HTMLElement&&(t.focusResults=()=>{e.focus()})})}>`:function(e){if(e)return l`
      <devtools-widget .widgetConfig=${K(n.EmptyWidget.EmptyWidget,{header:V(N.noCoverageData),link:"https://developer.chrome.com/docs/devtools/coverage",text:V(N.clickTheReloadButtonSToReloadAnd,{PH1:V(N.reloadPage)})})}>
        <devtools-button ${q("coverage.start-with-reload")}
                          .variant=${"tonal"} .iconName=${void 0}>
          ${V(N.reloadPage)}
        </devtools-button>
      </devtools-widget>`;return l`
    <devtools-widget .widgetConfig=${K(n.EmptyWidget.EmptyWidget,{header:V(N.noCoverageData),link:"https://developer.chrome.com/docs/devtools/coverage",text:V(N.clickTheRecordButtonSToStart,{PH1:V(N.startRecording)})})}>
      <devtools-button ${q("coverage.toggle-recording")}
                       .variant=${"tonal"} .iconName=${void 0}>
        ${V(N.startRecording)}
      </devtools-button>
    </devtools-widget>`}(e.supportsRecordOnReload)}
      </div>
      <div class="coverage-toolbar-summary">
        <div class="coverage-message">
            ${e.statusMessage}
        </div>
    </div>`,o)};class Y extends n.Widget.VBox{#h;#p;#v;#f;#m;#S;#C;#y;#b;#l;#w;#P=null;#M="";#R={focusResults:()=>{}};#n=null;#a=null;constructor(t=Q){super({jslog:`${p.panel("coverage").track({resize:!0})}`,useShadowDom:!0,delegatesFocus:!0}),this.registerRequiredCSS(H),this.#l=t,this.#h=null,this.#p=null,this.#v=e.Settings.Settings.instance().createSetting("coverage-view-coverage-type",0),this.#f=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.toggle-recording");const s=o.TargetManager.TargetManager.instance().primaryPageTarget();this.#w=Boolean(s?.model(o.ResourceTreeModel.ResourceTreeModel)),this.#m=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.clear"),this.#m.setEnabled(!1),this.#S=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.export"),this.#S.setEnabled(!1),this.#C=null,this.#y=null,this.#b=e.Settings.Settings.instance().createSetting("show-content-scripts",!1),this.#b.addChangeListener(this.#x,this),this.requestUpdate()}performUpdate(){const e={coverageType:this.#v.get(),recording:this.#f.toggled(),supportsRecordOnReload:this.#w,typeFilter:this.#y,showContentScriptsSetting:this.#b,needsReload:this.#P,coverageInfo:this.#n,textFilter:this.#C,selectedUrl:this.#a,statusMessage:this.#M,onCoverageTypeChanged:this.#B.bind(this),onFilterChanged:e=>{this.#C=e?t.StringUtilities.createPlainTextSearchRegex(e,"i"):null,this.#x()},onTypeFilterChanged:this.#U.bind(this)};this.#l(e,this.#R,this.contentElement)}static instance(){return X||(X=new Y),X}static removeInstance(){X=void 0}clear(){this.#h&&this.#h.reset(),this.#T()}#T(){this.#p&&(this.#p.dispose(),this.#p=null),this.#P=null,this.#n=null,this.#M="",this.#S.setEnabled(!1),this.requestUpdate()}toggleRecording(){!this.#f.toggled()?this.startRecording({reload:!1,jsCoveragePerBlock:this.isBlockCoverageSelected()}):this.stopRecording()}isBlockCoverageSelected(){return 2===this.#v.get()}#k(e){const t=e?1:0;this.#v.set(t)}#B(e){this.#v.set(e)}async startRecording(e){this.#T();const t=o.TargetManager.TargetManager.instance().primaryPageTarget();if(!t)return;const{reload:s,jsCoveragePerBlock:i}={reload:!1,jsCoveragePerBlock:!1,...e};if(this.#h&&!s||(this.#h=t.model(f)),!this.#h)return;g.userMetrics.actionTaken(g.UserMetrics.Action.CoverageStarted),i&&g.userMetrics.actionTaken(g.UserMetrics.Action.CoverageStartedPerBlock);if(!await this.#h.start(Boolean(i)))return;this.#k(Boolean(i)),this.#h.addEventListener(v.CoverageUpdated,this.#L,this),this.#h.addEventListener(v.SourceMapResolved,this.#$,this);const n=t.model(o.ResourceTreeModel.ResourceTreeModel);o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#F,this),this.#p=new A(this.#h,r.Workspace.WorkspaceImpl.instance(),h.DebuggerWorkspaceBinding.DebuggerWorkspaceBinding.instance(),h.CSSWorkspaceBinding.CSSWorkspaceBinding.instance()),this.#f.setToggled(!0),this.#m.setEnabled(!1),this.#n=[],this.#P=null,this.requestUpdate(),await this.updateComplete,this.#R.focusResults(),s&&n?n.reloadPage():this.#h.startPolling()}#L(e){const t=e.data;this.#z(t)}#$(){const e=(this.#h?.entries()||[]).map(e=>this.#I(e)).filter(e=>this.#O(e)).map(e=>({...e,sources:e.sources.filter(e=>this.#O(e))}));this.#n=e}#I(e){return{url:e.url(),type:e.type(),size:e.size(),usedSize:e.usedSize(),unusedSize:e.unusedSize(),usedPercentage:e.usedPercentage(),unusedPercentage:e.unusedPercentage(),sources:[...e.sourcesURLCoverageInfo.values()].map(this.#I,this),isContentScript:e.isContentScript(),generatedUrl:e instanceof C?e.generatedURLCoverageInfo.url():void 0}}async stopRecording(){o.TargetManager.TargetManager.instance().removeModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#F,this),this.#h&&(await this.#h.stop(),this.#h.removeEventListener(v.CoverageUpdated,this.#L,this)),this.#f.setToggled(!1),this.#m.setEnabled(!0),this.requestUpdate()}async#F(e){const t=e.data.frame,o=t.resourceTreeModel().target().model(f);if(o){if(this.#h!==o){this.#h&&(await this.#h.stop(),this.#h.removeEventListener(v.CoverageUpdated,this.#L,this)),this.#h=o;if(!await this.#h.start(this.isBlockCoverageSelected()))return;this.#h.addEventListener(v.CoverageUpdated,this.#L,this),this.#p=new A(this.#h,r.Workspace.WorkspaceImpl.instance(),h.DebuggerWorkspaceBinding.DebuggerWorkspaceBinding.instance(),h.CSSWorkspaceBinding.CSSWorkspaceBinding.instance())}"Activation"===e.data.type?this.#P="prerender-page":t.backForwardCacheDetails.restoredFromCache?this.#P="bfcache-page":(this.#P=null,this.#n=[]),this.requestUpdate(),this.#h.reset(),this.#p?.reset(),this.#h.startPolling()}}#z(e){this.#E(),this.#$(),this.#S.setEnabled(null!==this.#h&&this.#h.entries().length>0),this.#p?.update(e),this.requestUpdate()}#E(){const e={total:0,unused:0},t={total:0,unused:0},o=null!==this.#C;if(this.#h)for(const o of this.#h.entries()){e.total+=o.size(),e.unused+=o.unusedSize();const s=this.#I(o);if(this.#O(s))if(this.#C?.test(o.url()))t.total+=o.size(),t.unused+=o.unusedSize();else for(const e of o.sourcesURLCoverageInfo.values())this.#O(this.#I(e))&&(t.total+=e.size(),t.unused+=e.unusedSize())}function s({total:e,unused:t}){const o=e-t,s=e?Math.round(100*o/e):0;return V(N.sOfSSUsedSoFarSUnused,{PH1:i.ByteUtilities.bytesToString(o),PH2:i.ByteUtilities.bytesToString(e),PH3:s,PH4:i.ByteUtilities.bytesToString(t)})}this.#M=o?V(N.filteredSTotalS,{PH1:s(t),PH2:s(e)}):s(e)}#x(){this.#$(),this.#E(),this.requestUpdate()}#U(e){g.userMetrics.actionTaken(g.UserMetrics.Action.CoverageReportFiltered),this.#y=e,this.#$(),this.#E(),this.requestUpdate()}#O(e){const t=e.url;if(t.startsWith(Y.EXTENSION_BINDINGS_URL_PREFIX))return!1;if(e.isContentScript&&!this.#b.get())return!1;if(this.#y&&!(e.type&this.#y))return!1;if(e.sources.length>0)for(const t of e.sources)if(this.#O(t))return!0;return!this.#C||this.#C.test(t)}async exportReport(){const e=new h.FileUtils.FileOutputStream,o=`Coverage-${t.DateUtilities.toISO8601Compact(new Date)}.json`;await e.open(o)&&this.#h&&await this.#h.exportReport(e)}selectCoverageItemByUrl(e){this.#a=e,this.requestUpdate()}static EXTENSION_BINDINGS_URL_PREFIX="extensions::";wasShown(){n.Context.Context.instance().setFlavor(Y,this),super.wasShown()}willHide(){super.willHide(),n.Context.Context.instance().setFlavor(Y,null)}get model(){return this.#h}}var Z=Object.freeze({__proto__:null,ActionDelegate:class{handleAction(e,t){const o="coverage";return n.ViewManager.ViewManager.instance().showView(o,!1,!0).then(()=>{const e=n.ViewManager.ViewManager.instance().view(o);return e?.widget()}).then(e=>this.#D(e,t)),!0}#D(e,t){switch(t){case"coverage.toggle-recording":e.toggleRecording();break;case"coverage.start-with-reload":e.startRecording({reload:!0,jsCoveragePerBlock:e.isBlockCoverageSelected()});break;case"coverage.clear":e.clear();break;case"coverage.export":e.exportReport();break;default:console.assert(!1,`Unknown action: ${t}`)}}},CoverageView:Y,DEFAULT_VIEW:Q});export{j as CoverageDecorationManager,E as CoverageListView,w as CoverageModel,Z as CoverageView};
//# sourceMappingURL=coverage.js.map
