import * as Common from '../../core/common/common.js';
import * as Platform from '../../core/platform/platform.js';
import * as TextUtils from '../text_utils/text_utils.js';
import { type IsolatedFileSystemManager } from './IsolatedFileSystemManager.js';
import { PlatformFileSystem, PlatformFileSystemType } from './PlatformFileSystem.js';
export declare class IsolatedFileSystem extends PlatformFileSystem {
    #private;
    private readonly manager;
    private readonly domFileSystem;
    private readonly excludedFoldersSetting;
    private readonly excludedEmbedderFolders;
    private readonly fileLocks;
    constructor(manager: IsolatedFileSystemManager, path: Platform.DevToolsPath.UrlString, embedderPath: Platform.DevToolsPath.RawPathString, domFileSystem: FileSystem, type: PlatformFileSystemType, automatic: boolean);
    static create(manager: IsolatedFileSystemManager, path: Platform.DevToolsPath.UrlString, embedderPath: Platform.DevToolsPath.RawPathString, type: PlatformFileSystemType, name: string, rootURL: string, automatic: boolean): Promise<IsolatedFileSystem | null>;
    static errorMessage(error: DOMError): string;
    private serializedFileOperation;
    getMetadata(path: Platform.DevToolsPath.EncodedPathString): Promise<Metadata | null>;
    initialFilePaths(): Platform.DevToolsPath.EncodedPathString[];
    initialGitFolders(): Platform.DevToolsPath.EncodedPathString[];
    embedderPath(): Platform.DevToolsPath.RawPathString;
    private initializeFilePaths;
    private createFoldersIfNotExist;
    createFile(path: Platform.DevToolsPath.EncodedPathString, name: Platform.DevToolsPath.RawPathString | null): Promise<Platform.DevToolsPath.EncodedPathString | null>;
    deleteFile(path: Platform.DevToolsPath.EncodedPathString): Promise<boolean>;
    deleteDirectoryRecursively(path: Platform.DevToolsPath.EncodedPathString): Promise<boolean>;
    requestFileBlob(path: Platform.DevToolsPath.EncodedPathString): Promise<Blob | null>;
    requestFileContent(path: Platform.DevToolsPath.EncodedPathString): Promise<TextUtils.ContentData.ContentDataOrError>;
    private innerRequestFileContent;
    setFileContent(path: Platform.DevToolsPath.EncodedPathString, content: string, isBase64: boolean): Promise<void>;
    renameFile(path: Platform.DevToolsPath.EncodedPathString, newName: Platform.DevToolsPath.RawPathString, callback: (arg0: boolean, arg1?: string | undefined) => void): void;
    private readDirectory;
    private requestEntries;
    private saveExcludedFolders;
    addExcludedFolder(path: Platform.DevToolsPath.EncodedPathString): void;
    removeExcludedFolder(path: Platform.DevToolsPath.EncodedPathString): void;
    fileSystemRemoved(): void;
    isFileExcluded(folderPath: Platform.DevToolsPath.EncodedPathString): boolean;
    excludedFolders(): Set<Platform.DevToolsPath.EncodedPathString>;
    searchInPath(query: string, progress: Common.Progress.Progress): Promise<string[]>;
    indexContent(progress: Common.Progress.Progress): void;
    mimeFromPath(path: Platform.DevToolsPath.UrlString): string;
    canExcludeFolder(path: Platform.DevToolsPath.EncodedPathString): boolean;
    contentType(path: string): Common.ResourceType.ResourceType;
    tooltipForURL(url: Platform.DevToolsPath.UrlString): string;
    supportsAutomapping(): boolean;
}
export declare const BinaryExtensions: Set<string>;
