import*as e from"../../core/common/common.js";import*as t from"../../core/host/host.js";import*as n from"../../core/root/root.js";function i(){return Boolean(localStorage.getItem("debugAiCodeCompletionEnabled"))}function s(...e){i()&&console.log(...e)}globalThis.setDebugAiCodeCompletionEnabled=function(e){e?localStorage.setItem("debugAiCodeCompletionEnabled","true"):localStorage.removeItem("debugAiCodeCompletionEnabled")};const o="/**\n * This file describes the execution environment of the Chrome DevTools Console.\n * The code is JavaScript, but with special global functions and variables.\n * Top-level await is available.\n * The console has direct access to the inspected page's `window` and `document`.\n */\n\n/**\n * @description Returns the value of the most recently evaluated expression.\n */\nlet $_;\n\n/**\n * @description A reference to the most recently selected DOM element.\n * $0, $1, $2, $3, $4 can be used to reference the last five selected DOM elements.\n */\nlet $0;\n\n/**\n * @description A query selector alias. $$('.my-class') is equivalent to document.querySelectorAll('.my-class').\n */\nfunction $$(selector, startNode) {}\n\n/**\n * @description An XPath selector. $x('//p') returns an array of all <p> elements.\n */\nfunction $x(path, startNode) {}\n\nfunction clear() {}\n\nfunction copy(object) {}\n\n/**\n * @description Selects and reveals the specified element in the Elements panel.\n */\nfunction inspect(object) {}\n\nfunction keys(object) {}\n\nfunction values(object) {}\n\n/**\n * @description When the specified function is called, the debugger is invoked.\n */\nfunction debug(func) {}\n\n/**\n * @description Stops the debugging of the specified function.\n */\nfunction undebug(func) {}\n\n/**\n * @description Logs a message to the console whenever the specified function is called,\n * along with the arguments passed to it.\n */\nfunction monitor(func) {}\n\n/**\n * @description Stops monitoring the specified function.\n */\nfunction unmonitor(func) {}\n\n/**\n * @description Logs all events dispatched to the specified object to the console.\n */\nfunction monitorEvents(object, events) {}\n\n/**\n * @description Returns an object containing all event listeners registered on the specified object.\n */\nfunction getEventListeners(object) {}\n\n/**\n * The global `console` object has several helpful methods\n */\nconst console = {\n  log: (...args) => {},\n  warn: (...args) => {},\n  error: (...args) => {},\n  info: (...args) => {},\n  debug: (...args) => {},\n  assert: (assertion, ...args) => {},\n  dir: (object) => {}, // Displays an interactive property listing of an object.\n  dirxml: (object) => {}, // Displays an XML/HTML representation of an object.\n  table: (data, columns) => {}, // Displays tabular data as a table.\n  group: (label) => {}, // Creates a new inline collapsible group.\n  groupEnd: () => {},\n  time: (label) => {}, // Starts a timer.\n  timeEnd: (label) => {} // Stops a timer and logs the elapsed time.\n};";let r=class extends e.ObjectWrapper.ObjectWrapper{#e;#t;#n;#i;#s;#o=crypto.randomUUID();#r;#a;constructor(e,t,n,i){super(),this.#r=e.aidaClient,this.#a=e.serverSideLoggingEnabled??!1,this.#i=t,this.#e=i??[],this.#s=n}#c=e.Debouncer.debounce((e,t,n,i)=>{this.#l(this.#d(e,t,i),n)},200);#d(e,i,s="JAVASCRIPT",r){const a=t.AidaClient.convertToUserTierEnum(this.#u);e="\n"+e;let c=r??void 0;return c||(c="console"===this.#i?[{path:"devtools-console-context.js",content:o,included_reason:t.AidaClient.Reason.RELATED_FILE}]:void 0),{client:t.AidaClient.CLIENT_NAME,prefix:e,suffix:i,options:{inference_language:s,temperature:(l=this.#p.temperature,"number"==typeof l&&l>=0?l:void 0),model_id:this.#p.modelId||void 0,stop_sequences:this.#e},metadata:{disable_user_content_logging:!this.#a,string_session_id:this.#o,user_tier:a,client_version:n.Runtime.getChromeVersion()},additional_files:c};var l}async#h(e){const t=this.#g(e);if(t)return{response:t,fromCache:!0};const n=await this.#r.completeCode(e);return n?(this.#m(e,n),{response:n,fromCache:!1}):{response:null,fromCache:!1}}#f(e){if(!e.generatedSamples.length)return null;const t=this.#s?.getCompletionHint();return t?e.generatedSamples.find(e=>e.generationString.startsWith(t))??e.generatedSamples[0]:e.generatedSamples[0]}async#C(e,n){const{response:i,fromCache:o}=await this.#h(e);if(s("At cursor position",n,{request:e,response:i,fromCache:o}),!i)return null;const r=this.#f(i);if(!r)return null;if(r.attributionMetadata?.attributionAction===t.AidaClient.RecitationAction.BLOCK)return null;if(this.#b(r.generationString,e))return null;const a=this.#v(r.generationString,e);return 0===a.length?null:{suggestionText:a,sampleId:r.sampleId,fromCache:o,citations:r.attributionMetadata?.citations??[],rpcGlobalId:i.metadata.rpcGlobalId}}async#l(e,n){const i=performance.now();this.dispatchEventToListeners("RequestTriggered",{}),t.userMetrics.actionTaken(t.UserMetrics.Action.AiCodeCompletionRequestTriggered);try{const o=await this.#C(e,n);if(!o)return void this.dispatchEventToListeners("ResponseReceived",{});const{suggestionText:r,sampleId:a,fromCache:c,citations:l,rpcGlobalId:d}=o,u=Math.max(500-(performance.now()-i),0);this.#t=window.setTimeout(()=>{const e=this.#s?.getSelectionHead();e===n?(this.#s?.setAiAutoCompletion({text:r,from:n,rpcGlobalId:d,sampleId:a,startTime:i,onImpression:this.registerUserImpression.bind(this),clearCachedRequest:this.clearCachedRequest.bind(this)}),c&&t.userMetrics.actionTaken(t.UserMetrics.Action.AiCodeCompletionResponseServedFromCache),s("Suggestion dispatched to the editor",r,"at cursor position",n),this.dispatchEventToListeners("ResponseReceived",{citations:l})):this.dispatchEventToListeners("ResponseReceived",{})},u)}catch(e){s("Error while fetching code completion suggestions from AIDA",e),this.dispatchEventToListeners("ResponseReceived",{}),t.userMetrics.actionTaken(t.UserMetrics.Action.AiCodeCompletionError)}}get#u(){return n.Runtime.hostConfig.devToolsAiCodeCompletion?.userTier}get#p(){const e=n.Runtime.hostConfig.devToolsAiCodeCompletion?.temperature,t=n.Runtime.hostConfig.devToolsAiCodeCompletion?.modelId;return{temperature:e,modelId:t}}#v(e,t){const n=t.suffix;if(!n)return e;for(let t=Math.min(e.length,n.length);t>0;t--){const i=n.substring(0,t);if(e.endsWith(i))return e.slice(0,-t)}return e}#b(e,t){const{prefix:n,suffix:i}=t;return Boolean(n.includes(e.trim())||i?.includes(e.trim()))}#g(e){if(!this.#n||this.#n.request.suffix!==e.suffix||JSON.stringify(this.#n.request.options)!==JSON.stringify(e.options))return null;const t=[];for(const n of this.#n.response.generatedSamples){const i=this.#n.request.prefix+n.generationString;i.startsWith(e.prefix)&&t.push({generationString:i.substring(e.prefix.length),sampleId:n.sampleId,score:n.score,attributionMetadata:n.attributionMetadata})}return 0===t.length?null:{generatedSamples:t,metadata:this.#n.response.metadata}}#m(e,t){this.#n={request:e,response:t}}registerUserImpression(e,n,i){const o=Math.floor(n/1e3),r=n%1e3,a=Math.floor(1e6*r);this.#r.registerClientEvent({corresponding_aida_rpc_global_id:e,disable_user_content_logging:!0,complete_code_client_event:{user_impression:{sample:{sample_id:i},latency:{duration:{seconds:o,nanos:a}}}}}),s("Registered user impression with latency {seconds:",o,", nanos:",a,"}"),t.userMetrics.actionTaken(t.UserMetrics.Action.AiCodeCompletionSuggestionDisplayed)}registerUserAcceptance(e,n){this.#r.registerClientEvent({corresponding_aida_rpc_global_id:e,disable_user_content_logging:!0,complete_code_client_event:{user_acceptance:{sample:{sample_id:n}}}}),s("Registered user acceptance"),t.userMetrics.actionTaken(t.UserMetrics.Action.AiCodeCompletionSuggestionAccepted)}clearCachedRequest(){this.#n=void 0}onTextChanged(e,t,n,i){this.#c(e,t,n,i)}async completeCode(e,t,n,i,o){const r=this.#d(e,t,i,o),{response:a,fromCache:c}=await this.#h(r);return s("At cursor position",n,{request:r,response:a,fromCache:c}),a?{response:a,fromCache:c}:{response:null,fromCache:!1}}remove(){this.#t&&(clearTimeout(this.#t),this.#t=void 0),this.#s?.setAiAutoCompletion(null)}static isAiCodeCompletionEnabled(e){if(!e.startsWith("en-"))return!1;const t=n.Runtime.hostConfig.aidaAvailability;return!(!t||t.blockedByGeo||t.blockedByAge||t.blockedByEnterprisePolicy)&&Boolean(t.enabled&&n.Runtime.hostConfig.devToolsAiCodeCompletion?.enabled)}};var a=Object.freeze({__proto__:null,AIDA_REQUEST_DEBOUNCE_TIMEOUT_MS:200,AiCodeCompletion:r,DELAY_BEFORE_SHOWING_RESPONSE_MS:500,consoleAdditionalContextFileContent:o});export{a as AiCodeCompletion,s as debugLog,i as isDebugMode};
//# sourceMappingURL=ai_code_completion.js.map
