
#ifndef DAWNNATIVE_DAWN_PLATFORM_AUTOGEN_H_
#define DAWNNATIVE_DAWN_PLATFORM_AUTOGEN_H_

#include "dawn/webgpu_cpp.h"
#include "dawn/native/Forward.h"

// Use our autogenerated version of the wgpu structures that point to dawn::native object types
// (wgpu::Buffer is dawn::native::BufferBase*)
#include <dawn/native/wgpu_structs_autogen.h>


namespace dawn::native {

    inline const WGPUChainedStruct* ToAPI(const ChainedStruct* rhs) {
        return reinterpret_cast<const WGPUChainedStruct*>(rhs);
    }
    inline WGPUChainedStruct* ToAPI(ChainedStruct* rhs) {
        return reinterpret_cast<WGPUChainedStruct*>(rhs);
    }
    inline const ChainedStruct* FromAPI(const WGPUChainedStruct* rhs) {
        return reinterpret_cast<const ChainedStruct*>(rhs);
    }
    inline ChainedStruct* FromAPI(WGPUChainedStruct* rhs) {
        return reinterpret_cast<ChainedStruct*>(rhs);
    }
    inline const wgpu::ChainedStruct* ToCppAPI(const ChainedStruct* rhs) {
        return reinterpret_cast<const wgpu::ChainedStruct*>(rhs);
    }
    inline wgpu::ChainedStruct* ToCppAPI(ChainedStruct* rhs) {
        return reinterpret_cast<wgpu::ChainedStruct*>(rhs);
    }
    inline const ChainedStruct* FromCppAPI(const wgpu::ChainedStruct* rhs) {
        return reinterpret_cast<const ChainedStruct*>(rhs);
    }
    inline ChainedStruct* FromCppAPI(wgpu::ChainedStruct* rhs) {
        return reinterpret_cast<ChainedStruct*>(rhs);
    }

    inline const WGPUAdapterPropertiesD3D* ToAPI(const AdapterPropertiesD3D* rhs) {
        return reinterpret_cast<const WGPUAdapterPropertiesD3D*>(rhs);
    }
    inline WGPUAdapterPropertiesD3D* ToAPI(AdapterPropertiesD3D* rhs) {
        return reinterpret_cast<WGPUAdapterPropertiesD3D*>(rhs);
    }
    inline const AdapterPropertiesD3D* FromAPI(const WGPUAdapterPropertiesD3D* rhs) {
        return reinterpret_cast<const AdapterPropertiesD3D*>(rhs);
    }
    inline AdapterPropertiesD3D* FromAPI(WGPUAdapterPropertiesD3D* rhs) {
        return reinterpret_cast<AdapterPropertiesD3D*>(rhs);
    }
    inline const wgpu::AdapterPropertiesD3D* ToCppAPI(const AdapterPropertiesD3D* rhs) {
        return reinterpret_cast<const wgpu::AdapterPropertiesD3D*>(rhs);
    }
    inline wgpu::AdapterPropertiesD3D* ToCppAPI(AdapterPropertiesD3D* rhs) {
        return reinterpret_cast<wgpu::AdapterPropertiesD3D*>(rhs);
    }
    inline const AdapterPropertiesD3D* FromCppAPI(const wgpu::AdapterPropertiesD3D* rhs) {
        return reinterpret_cast<const AdapterPropertiesD3D*>(rhs);
    }
    inline AdapterPropertiesD3D* FromCppAPI(wgpu::AdapterPropertiesD3D* rhs) {
        return reinterpret_cast<AdapterPropertiesD3D*>(rhs);
    }

    inline const WGPUAdapterPropertiesVk* ToAPI(const AdapterPropertiesVk* rhs) {
        return reinterpret_cast<const WGPUAdapterPropertiesVk*>(rhs);
    }
    inline WGPUAdapterPropertiesVk* ToAPI(AdapterPropertiesVk* rhs) {
        return reinterpret_cast<WGPUAdapterPropertiesVk*>(rhs);
    }
    inline const AdapterPropertiesVk* FromAPI(const WGPUAdapterPropertiesVk* rhs) {
        return reinterpret_cast<const AdapterPropertiesVk*>(rhs);
    }
    inline AdapterPropertiesVk* FromAPI(WGPUAdapterPropertiesVk* rhs) {
        return reinterpret_cast<AdapterPropertiesVk*>(rhs);
    }
    inline const wgpu::AdapterPropertiesVk* ToCppAPI(const AdapterPropertiesVk* rhs) {
        return reinterpret_cast<const wgpu::AdapterPropertiesVk*>(rhs);
    }
    inline wgpu::AdapterPropertiesVk* ToCppAPI(AdapterPropertiesVk* rhs) {
        return reinterpret_cast<wgpu::AdapterPropertiesVk*>(rhs);
    }
    inline const AdapterPropertiesVk* FromCppAPI(const wgpu::AdapterPropertiesVk* rhs) {
        return reinterpret_cast<const AdapterPropertiesVk*>(rhs);
    }
    inline AdapterPropertiesVk* FromCppAPI(wgpu::AdapterPropertiesVk* rhs) {
        return reinterpret_cast<AdapterPropertiesVk*>(rhs);
    }

    inline const WGPUAdapterPropertiesWGPU* ToAPI(const AdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<const WGPUAdapterPropertiesWGPU*>(rhs);
    }
    inline WGPUAdapterPropertiesWGPU* ToAPI(AdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<WGPUAdapterPropertiesWGPU*>(rhs);
    }
    inline const AdapterPropertiesWGPU* FromAPI(const WGPUAdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<const AdapterPropertiesWGPU*>(rhs);
    }
    inline AdapterPropertiesWGPU* FromAPI(WGPUAdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<AdapterPropertiesWGPU*>(rhs);
    }
    inline const wgpu::AdapterPropertiesWGPU* ToCppAPI(const AdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<const wgpu::AdapterPropertiesWGPU*>(rhs);
    }
    inline wgpu::AdapterPropertiesWGPU* ToCppAPI(AdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<wgpu::AdapterPropertiesWGPU*>(rhs);
    }
    inline const AdapterPropertiesWGPU* FromCppAPI(const wgpu::AdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<const AdapterPropertiesWGPU*>(rhs);
    }
    inline AdapterPropertiesWGPU* FromCppAPI(wgpu::AdapterPropertiesWGPU* rhs) {
        return reinterpret_cast<AdapterPropertiesWGPU*>(rhs);
    }

    inline const WGPUBindGroupDynamicBindingArray* ToAPI(const BindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<const WGPUBindGroupDynamicBindingArray*>(rhs);
    }
    inline WGPUBindGroupDynamicBindingArray* ToAPI(BindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<WGPUBindGroupDynamicBindingArray*>(rhs);
    }
    inline const BindGroupDynamicBindingArray* FromAPI(const WGPUBindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<const BindGroupDynamicBindingArray*>(rhs);
    }
    inline BindGroupDynamicBindingArray* FromAPI(WGPUBindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<BindGroupDynamicBindingArray*>(rhs);
    }
    inline const wgpu::BindGroupDynamicBindingArray* ToCppAPI(const BindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<const wgpu::BindGroupDynamicBindingArray*>(rhs);
    }
    inline wgpu::BindGroupDynamicBindingArray* ToCppAPI(BindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<wgpu::BindGroupDynamicBindingArray*>(rhs);
    }
    inline const BindGroupDynamicBindingArray* FromCppAPI(const wgpu::BindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<const BindGroupDynamicBindingArray*>(rhs);
    }
    inline BindGroupDynamicBindingArray* FromCppAPI(wgpu::BindGroupDynamicBindingArray* rhs) {
        return reinterpret_cast<BindGroupDynamicBindingArray*>(rhs);
    }

    inline const WGPUBindGroupEntryContents* ToAPI(const BindGroupEntryContents* rhs) {
        return reinterpret_cast<const WGPUBindGroupEntryContents*>(rhs);
    }
    inline WGPUBindGroupEntryContents* ToAPI(BindGroupEntryContents* rhs) {
        return reinterpret_cast<WGPUBindGroupEntryContents*>(rhs);
    }
    inline const BindGroupEntryContents* FromAPI(const WGPUBindGroupEntryContents* rhs) {
        return reinterpret_cast<const BindGroupEntryContents*>(rhs);
    }
    inline BindGroupEntryContents* FromAPI(WGPUBindGroupEntryContents* rhs) {
        return reinterpret_cast<BindGroupEntryContents*>(rhs);
    }
    inline const wgpu::BindGroupEntryContents* ToCppAPI(const BindGroupEntryContents* rhs) {
        return reinterpret_cast<const wgpu::BindGroupEntryContents*>(rhs);
    }
    inline wgpu::BindGroupEntryContents* ToCppAPI(BindGroupEntryContents* rhs) {
        return reinterpret_cast<wgpu::BindGroupEntryContents*>(rhs);
    }
    inline const BindGroupEntryContents* FromCppAPI(const wgpu::BindGroupEntryContents* rhs) {
        return reinterpret_cast<const BindGroupEntryContents*>(rhs);
    }
    inline BindGroupEntryContents* FromCppAPI(wgpu::BindGroupEntryContents* rhs) {
        return reinterpret_cast<BindGroupEntryContents*>(rhs);
    }

    inline const WGPUBlendComponent* ToAPI(const BlendComponent* rhs) {
        return reinterpret_cast<const WGPUBlendComponent*>(rhs);
    }
    inline WGPUBlendComponent* ToAPI(BlendComponent* rhs) {
        return reinterpret_cast<WGPUBlendComponent*>(rhs);
    }
    inline const BlendComponent* FromAPI(const WGPUBlendComponent* rhs) {
        return reinterpret_cast<const BlendComponent*>(rhs);
    }
    inline BlendComponent* FromAPI(WGPUBlendComponent* rhs) {
        return reinterpret_cast<BlendComponent*>(rhs);
    }
    inline const wgpu::BlendComponent* ToCppAPI(const BlendComponent* rhs) {
        return reinterpret_cast<const wgpu::BlendComponent*>(rhs);
    }
    inline wgpu::BlendComponent* ToCppAPI(BlendComponent* rhs) {
        return reinterpret_cast<wgpu::BlendComponent*>(rhs);
    }
    inline const BlendComponent* FromCppAPI(const wgpu::BlendComponent* rhs) {
        return reinterpret_cast<const BlendComponent*>(rhs);
    }
    inline BlendComponent* FromCppAPI(wgpu::BlendComponent* rhs) {
        return reinterpret_cast<BlendComponent*>(rhs);
    }

    inline const WGPUBufferBindingLayout* ToAPI(const BufferBindingLayout* rhs) {
        return reinterpret_cast<const WGPUBufferBindingLayout*>(rhs);
    }
    inline WGPUBufferBindingLayout* ToAPI(BufferBindingLayout* rhs) {
        return reinterpret_cast<WGPUBufferBindingLayout*>(rhs);
    }
    inline const BufferBindingLayout* FromAPI(const WGPUBufferBindingLayout* rhs) {
        return reinterpret_cast<const BufferBindingLayout*>(rhs);
    }
    inline BufferBindingLayout* FromAPI(WGPUBufferBindingLayout* rhs) {
        return reinterpret_cast<BufferBindingLayout*>(rhs);
    }
    inline const wgpu::BufferBindingLayout* ToCppAPI(const BufferBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::BufferBindingLayout*>(rhs);
    }
    inline wgpu::BufferBindingLayout* ToCppAPI(BufferBindingLayout* rhs) {
        return reinterpret_cast<wgpu::BufferBindingLayout*>(rhs);
    }
    inline const BufferBindingLayout* FromCppAPI(const wgpu::BufferBindingLayout* rhs) {
        return reinterpret_cast<const BufferBindingLayout*>(rhs);
    }
    inline BufferBindingLayout* FromCppAPI(wgpu::BufferBindingLayout* rhs) {
        return reinterpret_cast<BufferBindingLayout*>(rhs);
    }

    inline const WGPUBufferHostMappedPointer* ToAPI(const BufferHostMappedPointer* rhs) {
        return reinterpret_cast<const WGPUBufferHostMappedPointer*>(rhs);
    }
    inline WGPUBufferHostMappedPointer* ToAPI(BufferHostMappedPointer* rhs) {
        return reinterpret_cast<WGPUBufferHostMappedPointer*>(rhs);
    }
    inline const BufferHostMappedPointer* FromAPI(const WGPUBufferHostMappedPointer* rhs) {
        return reinterpret_cast<const BufferHostMappedPointer*>(rhs);
    }
    inline BufferHostMappedPointer* FromAPI(WGPUBufferHostMappedPointer* rhs) {
        return reinterpret_cast<BufferHostMappedPointer*>(rhs);
    }
    inline const wgpu::BufferHostMappedPointer* ToCppAPI(const BufferHostMappedPointer* rhs) {
        return reinterpret_cast<const wgpu::BufferHostMappedPointer*>(rhs);
    }
    inline wgpu::BufferHostMappedPointer* ToCppAPI(BufferHostMappedPointer* rhs) {
        return reinterpret_cast<wgpu::BufferHostMappedPointer*>(rhs);
    }
    inline const BufferHostMappedPointer* FromCppAPI(const wgpu::BufferHostMappedPointer* rhs) {
        return reinterpret_cast<const BufferHostMappedPointer*>(rhs);
    }
    inline BufferHostMappedPointer* FromCppAPI(wgpu::BufferHostMappedPointer* rhs) {
        return reinterpret_cast<BufferHostMappedPointer*>(rhs);
    }

    inline const WGPUColor* ToAPI(const Color* rhs) {
        return reinterpret_cast<const WGPUColor*>(rhs);
    }
    inline WGPUColor* ToAPI(Color* rhs) {
        return reinterpret_cast<WGPUColor*>(rhs);
    }
    inline const Color* FromAPI(const WGPUColor* rhs) {
        return reinterpret_cast<const Color*>(rhs);
    }
    inline Color* FromAPI(WGPUColor* rhs) {
        return reinterpret_cast<Color*>(rhs);
    }
    inline const wgpu::Color* ToCppAPI(const Color* rhs) {
        return reinterpret_cast<const wgpu::Color*>(rhs);
    }
    inline wgpu::Color* ToCppAPI(Color* rhs) {
        return reinterpret_cast<wgpu::Color*>(rhs);
    }
    inline const Color* FromCppAPI(const wgpu::Color* rhs) {
        return reinterpret_cast<const Color*>(rhs);
    }
    inline Color* FromCppAPI(wgpu::Color* rhs) {
        return reinterpret_cast<Color*>(rhs);
    }

    inline const WGPUColorTargetStateExpandResolveTextureDawn* ToAPI(const ColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<const WGPUColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline WGPUColorTargetStateExpandResolveTextureDawn* ToAPI(ColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<WGPUColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline const ColorTargetStateExpandResolveTextureDawn* FromAPI(const WGPUColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<const ColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline ColorTargetStateExpandResolveTextureDawn* FromAPI(WGPUColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<ColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline const wgpu::ColorTargetStateExpandResolveTextureDawn* ToCppAPI(const ColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<const wgpu::ColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline wgpu::ColorTargetStateExpandResolveTextureDawn* ToCppAPI(ColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<wgpu::ColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline const ColorTargetStateExpandResolveTextureDawn* FromCppAPI(const wgpu::ColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<const ColorTargetStateExpandResolveTextureDawn*>(rhs);
    }
    inline ColorTargetStateExpandResolveTextureDawn* FromCppAPI(wgpu::ColorTargetStateExpandResolveTextureDawn* rhs) {
        return reinterpret_cast<ColorTargetStateExpandResolveTextureDawn*>(rhs);
    }

    inline const WGPUCommandBufferDescriptor* ToAPI(const CommandBufferDescriptor* rhs) {
        return reinterpret_cast<const WGPUCommandBufferDescriptor*>(rhs);
    }
    inline WGPUCommandBufferDescriptor* ToAPI(CommandBufferDescriptor* rhs) {
        return reinterpret_cast<WGPUCommandBufferDescriptor*>(rhs);
    }
    inline const CommandBufferDescriptor* FromAPI(const WGPUCommandBufferDescriptor* rhs) {
        return reinterpret_cast<const CommandBufferDescriptor*>(rhs);
    }
    inline CommandBufferDescriptor* FromAPI(WGPUCommandBufferDescriptor* rhs) {
        return reinterpret_cast<CommandBufferDescriptor*>(rhs);
    }
    inline const wgpu::CommandBufferDescriptor* ToCppAPI(const CommandBufferDescriptor* rhs) {
        return reinterpret_cast<const wgpu::CommandBufferDescriptor*>(rhs);
    }
    inline wgpu::CommandBufferDescriptor* ToCppAPI(CommandBufferDescriptor* rhs) {
        return reinterpret_cast<wgpu::CommandBufferDescriptor*>(rhs);
    }
    inline const CommandBufferDescriptor* FromCppAPI(const wgpu::CommandBufferDescriptor* rhs) {
        return reinterpret_cast<const CommandBufferDescriptor*>(rhs);
    }
    inline CommandBufferDescriptor* FromCppAPI(wgpu::CommandBufferDescriptor* rhs) {
        return reinterpret_cast<CommandBufferDescriptor*>(rhs);
    }

    inline const WGPUCompatibilityModeLimits* ToAPI(const CompatibilityModeLimits* rhs) {
        return reinterpret_cast<const WGPUCompatibilityModeLimits*>(rhs);
    }
    inline WGPUCompatibilityModeLimits* ToAPI(CompatibilityModeLimits* rhs) {
        return reinterpret_cast<WGPUCompatibilityModeLimits*>(rhs);
    }
    inline const CompatibilityModeLimits* FromAPI(const WGPUCompatibilityModeLimits* rhs) {
        return reinterpret_cast<const CompatibilityModeLimits*>(rhs);
    }
    inline CompatibilityModeLimits* FromAPI(WGPUCompatibilityModeLimits* rhs) {
        return reinterpret_cast<CompatibilityModeLimits*>(rhs);
    }
    inline const wgpu::CompatibilityModeLimits* ToCppAPI(const CompatibilityModeLimits* rhs) {
        return reinterpret_cast<const wgpu::CompatibilityModeLimits*>(rhs);
    }
    inline wgpu::CompatibilityModeLimits* ToCppAPI(CompatibilityModeLimits* rhs) {
        return reinterpret_cast<wgpu::CompatibilityModeLimits*>(rhs);
    }
    inline const CompatibilityModeLimits* FromCppAPI(const wgpu::CompatibilityModeLimits* rhs) {
        return reinterpret_cast<const CompatibilityModeLimits*>(rhs);
    }
    inline CompatibilityModeLimits* FromCppAPI(wgpu::CompatibilityModeLimits* rhs) {
        return reinterpret_cast<CompatibilityModeLimits*>(rhs);
    }

    inline const WGPUConstantEntry* ToAPI(const ConstantEntry* rhs) {
        return reinterpret_cast<const WGPUConstantEntry*>(rhs);
    }
    inline WGPUConstantEntry* ToAPI(ConstantEntry* rhs) {
        return reinterpret_cast<WGPUConstantEntry*>(rhs);
    }
    inline const ConstantEntry* FromAPI(const WGPUConstantEntry* rhs) {
        return reinterpret_cast<const ConstantEntry*>(rhs);
    }
    inline ConstantEntry* FromAPI(WGPUConstantEntry* rhs) {
        return reinterpret_cast<ConstantEntry*>(rhs);
    }
    inline const wgpu::ConstantEntry* ToCppAPI(const ConstantEntry* rhs) {
        return reinterpret_cast<const wgpu::ConstantEntry*>(rhs);
    }
    inline wgpu::ConstantEntry* ToCppAPI(ConstantEntry* rhs) {
        return reinterpret_cast<wgpu::ConstantEntry*>(rhs);
    }
    inline const ConstantEntry* FromCppAPI(const wgpu::ConstantEntry* rhs) {
        return reinterpret_cast<const ConstantEntry*>(rhs);
    }
    inline ConstantEntry* FromCppAPI(wgpu::ConstantEntry* rhs) {
        return reinterpret_cast<ConstantEntry*>(rhs);
    }

    inline const WGPUCopyTextureForBrowserOptions* ToAPI(const CopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<const WGPUCopyTextureForBrowserOptions*>(rhs);
    }
    inline WGPUCopyTextureForBrowserOptions* ToAPI(CopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<WGPUCopyTextureForBrowserOptions*>(rhs);
    }
    inline const CopyTextureForBrowserOptions* FromAPI(const WGPUCopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<const CopyTextureForBrowserOptions*>(rhs);
    }
    inline CopyTextureForBrowserOptions* FromAPI(WGPUCopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<CopyTextureForBrowserOptions*>(rhs);
    }
    inline const wgpu::CopyTextureForBrowserOptions* ToCppAPI(const CopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<const wgpu::CopyTextureForBrowserOptions*>(rhs);
    }
    inline wgpu::CopyTextureForBrowserOptions* ToCppAPI(CopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<wgpu::CopyTextureForBrowserOptions*>(rhs);
    }
    inline const CopyTextureForBrowserOptions* FromCppAPI(const wgpu::CopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<const CopyTextureForBrowserOptions*>(rhs);
    }
    inline CopyTextureForBrowserOptions* FromCppAPI(wgpu::CopyTextureForBrowserOptions* rhs) {
        return reinterpret_cast<CopyTextureForBrowserOptions*>(rhs);
    }

    inline const WGPUDawnAdapterPropertiesPowerPreference* ToAPI(const DawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<const WGPUDawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline WGPUDawnAdapterPropertiesPowerPreference* ToAPI(DawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<WGPUDawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline const DawnAdapterPropertiesPowerPreference* FromAPI(const WGPUDawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<const DawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline DawnAdapterPropertiesPowerPreference* FromAPI(WGPUDawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<DawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline const wgpu::DawnAdapterPropertiesPowerPreference* ToCppAPI(const DawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<const wgpu::DawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline wgpu::DawnAdapterPropertiesPowerPreference* ToCppAPI(DawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<wgpu::DawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline const DawnAdapterPropertiesPowerPreference* FromCppAPI(const wgpu::DawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<const DawnAdapterPropertiesPowerPreference*>(rhs);
    }
    inline DawnAdapterPropertiesPowerPreference* FromCppAPI(wgpu::DawnAdapterPropertiesPowerPreference* rhs) {
        return reinterpret_cast<DawnAdapterPropertiesPowerPreference*>(rhs);
    }

    inline const WGPUDawnBufferDescriptorErrorInfoFromWireClient* ToAPI(const DawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<const WGPUDawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline WGPUDawnBufferDescriptorErrorInfoFromWireClient* ToAPI(DawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<WGPUDawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline const DawnBufferDescriptorErrorInfoFromWireClient* FromAPI(const WGPUDawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<const DawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline DawnBufferDescriptorErrorInfoFromWireClient* FromAPI(WGPUDawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<DawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline const wgpu::DawnBufferDescriptorErrorInfoFromWireClient* ToCppAPI(const DawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<const wgpu::DawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline wgpu::DawnBufferDescriptorErrorInfoFromWireClient* ToCppAPI(DawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<wgpu::DawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline const DawnBufferDescriptorErrorInfoFromWireClient* FromCppAPI(const wgpu::DawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<const DawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }
    inline DawnBufferDescriptorErrorInfoFromWireClient* FromCppAPI(wgpu::DawnBufferDescriptorErrorInfoFromWireClient* rhs) {
        return reinterpret_cast<DawnBufferDescriptorErrorInfoFromWireClient*>(rhs);
    }

    inline const WGPUDawnCacheDeviceDescriptor* ToAPI(const DawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<const WGPUDawnCacheDeviceDescriptor*>(rhs);
    }
    inline WGPUDawnCacheDeviceDescriptor* ToAPI(DawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<WGPUDawnCacheDeviceDescriptor*>(rhs);
    }
    inline const DawnCacheDeviceDescriptor* FromAPI(const WGPUDawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<const DawnCacheDeviceDescriptor*>(rhs);
    }
    inline DawnCacheDeviceDescriptor* FromAPI(WGPUDawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<DawnCacheDeviceDescriptor*>(rhs);
    }
    inline const wgpu::DawnCacheDeviceDescriptor* ToCppAPI(const DawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DawnCacheDeviceDescriptor*>(rhs);
    }
    inline wgpu::DawnCacheDeviceDescriptor* ToCppAPI(DawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<wgpu::DawnCacheDeviceDescriptor*>(rhs);
    }
    inline const DawnCacheDeviceDescriptor* FromCppAPI(const wgpu::DawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<const DawnCacheDeviceDescriptor*>(rhs);
    }
    inline DawnCacheDeviceDescriptor* FromCppAPI(wgpu::DawnCacheDeviceDescriptor* rhs) {
        return reinterpret_cast<DawnCacheDeviceDescriptor*>(rhs);
    }

    inline const WGPUDawnCompilationMessageUtf16* ToAPI(const DawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<const WGPUDawnCompilationMessageUtf16*>(rhs);
    }
    inline WGPUDawnCompilationMessageUtf16* ToAPI(DawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<WGPUDawnCompilationMessageUtf16*>(rhs);
    }
    inline const DawnCompilationMessageUtf16* FromAPI(const WGPUDawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<const DawnCompilationMessageUtf16*>(rhs);
    }
    inline DawnCompilationMessageUtf16* FromAPI(WGPUDawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<DawnCompilationMessageUtf16*>(rhs);
    }
    inline const wgpu::DawnCompilationMessageUtf16* ToCppAPI(const DawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<const wgpu::DawnCompilationMessageUtf16*>(rhs);
    }
    inline wgpu::DawnCompilationMessageUtf16* ToCppAPI(DawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<wgpu::DawnCompilationMessageUtf16*>(rhs);
    }
    inline const DawnCompilationMessageUtf16* FromCppAPI(const wgpu::DawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<const DawnCompilationMessageUtf16*>(rhs);
    }
    inline DawnCompilationMessageUtf16* FromCppAPI(wgpu::DawnCompilationMessageUtf16* rhs) {
        return reinterpret_cast<DawnCompilationMessageUtf16*>(rhs);
    }

    inline const WGPUDawnConsumeAdapterDescriptor* ToAPI(const DawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<const WGPUDawnConsumeAdapterDescriptor*>(rhs);
    }
    inline WGPUDawnConsumeAdapterDescriptor* ToAPI(DawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<WGPUDawnConsumeAdapterDescriptor*>(rhs);
    }
    inline const DawnConsumeAdapterDescriptor* FromAPI(const WGPUDawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<const DawnConsumeAdapterDescriptor*>(rhs);
    }
    inline DawnConsumeAdapterDescriptor* FromAPI(WGPUDawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<DawnConsumeAdapterDescriptor*>(rhs);
    }
    inline const wgpu::DawnConsumeAdapterDescriptor* ToCppAPI(const DawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DawnConsumeAdapterDescriptor*>(rhs);
    }
    inline wgpu::DawnConsumeAdapterDescriptor* ToCppAPI(DawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<wgpu::DawnConsumeAdapterDescriptor*>(rhs);
    }
    inline const DawnConsumeAdapterDescriptor* FromCppAPI(const wgpu::DawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<const DawnConsumeAdapterDescriptor*>(rhs);
    }
    inline DawnConsumeAdapterDescriptor* FromCppAPI(wgpu::DawnConsumeAdapterDescriptor* rhs) {
        return reinterpret_cast<DawnConsumeAdapterDescriptor*>(rhs);
    }

    inline const WGPUDawnDeviceAllocatorControl* ToAPI(const DawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<const WGPUDawnDeviceAllocatorControl*>(rhs);
    }
    inline WGPUDawnDeviceAllocatorControl* ToAPI(DawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<WGPUDawnDeviceAllocatorControl*>(rhs);
    }
    inline const DawnDeviceAllocatorControl* FromAPI(const WGPUDawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<const DawnDeviceAllocatorControl*>(rhs);
    }
    inline DawnDeviceAllocatorControl* FromAPI(WGPUDawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<DawnDeviceAllocatorControl*>(rhs);
    }
    inline const wgpu::DawnDeviceAllocatorControl* ToCppAPI(const DawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<const wgpu::DawnDeviceAllocatorControl*>(rhs);
    }
    inline wgpu::DawnDeviceAllocatorControl* ToCppAPI(DawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<wgpu::DawnDeviceAllocatorControl*>(rhs);
    }
    inline const DawnDeviceAllocatorControl* FromCppAPI(const wgpu::DawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<const DawnDeviceAllocatorControl*>(rhs);
    }
    inline DawnDeviceAllocatorControl* FromCppAPI(wgpu::DawnDeviceAllocatorControl* rhs) {
        return reinterpret_cast<DawnDeviceAllocatorControl*>(rhs);
    }

    inline const WGPUDawnDrmFormatProperties* ToAPI(const DawnDrmFormatProperties* rhs) {
        return reinterpret_cast<const WGPUDawnDrmFormatProperties*>(rhs);
    }
    inline WGPUDawnDrmFormatProperties* ToAPI(DawnDrmFormatProperties* rhs) {
        return reinterpret_cast<WGPUDawnDrmFormatProperties*>(rhs);
    }
    inline const DawnDrmFormatProperties* FromAPI(const WGPUDawnDrmFormatProperties* rhs) {
        return reinterpret_cast<const DawnDrmFormatProperties*>(rhs);
    }
    inline DawnDrmFormatProperties* FromAPI(WGPUDawnDrmFormatProperties* rhs) {
        return reinterpret_cast<DawnDrmFormatProperties*>(rhs);
    }
    inline const wgpu::DawnDrmFormatProperties* ToCppAPI(const DawnDrmFormatProperties* rhs) {
        return reinterpret_cast<const wgpu::DawnDrmFormatProperties*>(rhs);
    }
    inline wgpu::DawnDrmFormatProperties* ToCppAPI(DawnDrmFormatProperties* rhs) {
        return reinterpret_cast<wgpu::DawnDrmFormatProperties*>(rhs);
    }
    inline const DawnDrmFormatProperties* FromCppAPI(const wgpu::DawnDrmFormatProperties* rhs) {
        return reinterpret_cast<const DawnDrmFormatProperties*>(rhs);
    }
    inline DawnDrmFormatProperties* FromCppAPI(wgpu::DawnDrmFormatProperties* rhs) {
        return reinterpret_cast<DawnDrmFormatProperties*>(rhs);
    }

    inline const WGPUDawnEncoderInternalUsageDescriptor* ToAPI(const DawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const WGPUDawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline WGPUDawnEncoderInternalUsageDescriptor* ToAPI(DawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<WGPUDawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline const DawnEncoderInternalUsageDescriptor* FromAPI(const WGPUDawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const DawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline DawnEncoderInternalUsageDescriptor* FromAPI(WGPUDawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<DawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline const wgpu::DawnEncoderInternalUsageDescriptor* ToCppAPI(const DawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline wgpu::DawnEncoderInternalUsageDescriptor* ToCppAPI(DawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<wgpu::DawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline const DawnEncoderInternalUsageDescriptor* FromCppAPI(const wgpu::DawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const DawnEncoderInternalUsageDescriptor*>(rhs);
    }
    inline DawnEncoderInternalUsageDescriptor* FromCppAPI(wgpu::DawnEncoderInternalUsageDescriptor* rhs) {
        return reinterpret_cast<DawnEncoderInternalUsageDescriptor*>(rhs);
    }

    inline const WGPUDawnFakeBufferOOMForTesting* ToAPI(const DawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<const WGPUDawnFakeBufferOOMForTesting*>(rhs);
    }
    inline WGPUDawnFakeBufferOOMForTesting* ToAPI(DawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<WGPUDawnFakeBufferOOMForTesting*>(rhs);
    }
    inline const DawnFakeBufferOOMForTesting* FromAPI(const WGPUDawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<const DawnFakeBufferOOMForTesting*>(rhs);
    }
    inline DawnFakeBufferOOMForTesting* FromAPI(WGPUDawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<DawnFakeBufferOOMForTesting*>(rhs);
    }
    inline const wgpu::DawnFakeBufferOOMForTesting* ToCppAPI(const DawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<const wgpu::DawnFakeBufferOOMForTesting*>(rhs);
    }
    inline wgpu::DawnFakeBufferOOMForTesting* ToCppAPI(DawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<wgpu::DawnFakeBufferOOMForTesting*>(rhs);
    }
    inline const DawnFakeBufferOOMForTesting* FromCppAPI(const wgpu::DawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<const DawnFakeBufferOOMForTesting*>(rhs);
    }
    inline DawnFakeBufferOOMForTesting* FromCppAPI(wgpu::DawnFakeBufferOOMForTesting* rhs) {
        return reinterpret_cast<DawnFakeBufferOOMForTesting*>(rhs);
    }

    inline const WGPUDawnFakeDeviceInitializeErrorForTesting* ToAPI(const DawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<const WGPUDawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline WGPUDawnFakeDeviceInitializeErrorForTesting* ToAPI(DawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<WGPUDawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline const DawnFakeDeviceInitializeErrorForTesting* FromAPI(const WGPUDawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<const DawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline DawnFakeDeviceInitializeErrorForTesting* FromAPI(WGPUDawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<DawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline const wgpu::DawnFakeDeviceInitializeErrorForTesting* ToCppAPI(const DawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<const wgpu::DawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline wgpu::DawnFakeDeviceInitializeErrorForTesting* ToCppAPI(DawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<wgpu::DawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline const DawnFakeDeviceInitializeErrorForTesting* FromCppAPI(const wgpu::DawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<const DawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }
    inline DawnFakeDeviceInitializeErrorForTesting* FromCppAPI(wgpu::DawnFakeDeviceInitializeErrorForTesting* rhs) {
        return reinterpret_cast<DawnFakeDeviceInitializeErrorForTesting*>(rhs);
    }

    inline const WGPUDawnHostMappedPointerLimits* ToAPI(const DawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<const WGPUDawnHostMappedPointerLimits*>(rhs);
    }
    inline WGPUDawnHostMappedPointerLimits* ToAPI(DawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<WGPUDawnHostMappedPointerLimits*>(rhs);
    }
    inline const DawnHostMappedPointerLimits* FromAPI(const WGPUDawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<const DawnHostMappedPointerLimits*>(rhs);
    }
    inline DawnHostMappedPointerLimits* FromAPI(WGPUDawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<DawnHostMappedPointerLimits*>(rhs);
    }
    inline const wgpu::DawnHostMappedPointerLimits* ToCppAPI(const DawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<const wgpu::DawnHostMappedPointerLimits*>(rhs);
    }
    inline wgpu::DawnHostMappedPointerLimits* ToCppAPI(DawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<wgpu::DawnHostMappedPointerLimits*>(rhs);
    }
    inline const DawnHostMappedPointerLimits* FromCppAPI(const wgpu::DawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<const DawnHostMappedPointerLimits*>(rhs);
    }
    inline DawnHostMappedPointerLimits* FromCppAPI(wgpu::DawnHostMappedPointerLimits* rhs) {
        return reinterpret_cast<DawnHostMappedPointerLimits*>(rhs);
    }

    inline const WGPUDawnInjectedInvalidSType* ToAPI(const DawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<const WGPUDawnInjectedInvalidSType*>(rhs);
    }
    inline WGPUDawnInjectedInvalidSType* ToAPI(DawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<WGPUDawnInjectedInvalidSType*>(rhs);
    }
    inline const DawnInjectedInvalidSType* FromAPI(const WGPUDawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<const DawnInjectedInvalidSType*>(rhs);
    }
    inline DawnInjectedInvalidSType* FromAPI(WGPUDawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<DawnInjectedInvalidSType*>(rhs);
    }
    inline const wgpu::DawnInjectedInvalidSType* ToCppAPI(const DawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<const wgpu::DawnInjectedInvalidSType*>(rhs);
    }
    inline wgpu::DawnInjectedInvalidSType* ToCppAPI(DawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<wgpu::DawnInjectedInvalidSType*>(rhs);
    }
    inline const DawnInjectedInvalidSType* FromCppAPI(const wgpu::DawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<const DawnInjectedInvalidSType*>(rhs);
    }
    inline DawnInjectedInvalidSType* FromCppAPI(wgpu::DawnInjectedInvalidSType* rhs) {
        return reinterpret_cast<DawnInjectedInvalidSType*>(rhs);
    }

    inline const WGPUDawnRenderPassColorAttachmentRenderToSingleSampled* ToAPI(const DawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<const WGPUDawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline WGPUDawnRenderPassColorAttachmentRenderToSingleSampled* ToAPI(DawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<WGPUDawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline const DawnRenderPassColorAttachmentRenderToSingleSampled* FromAPI(const WGPUDawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<const DawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline DawnRenderPassColorAttachmentRenderToSingleSampled* FromAPI(WGPUDawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<DawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline const wgpu::DawnRenderPassColorAttachmentRenderToSingleSampled* ToCppAPI(const DawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<const wgpu::DawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline wgpu::DawnRenderPassColorAttachmentRenderToSingleSampled* ToCppAPI(DawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<wgpu::DawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline const DawnRenderPassColorAttachmentRenderToSingleSampled* FromCppAPI(const wgpu::DawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<const DawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }
    inline DawnRenderPassColorAttachmentRenderToSingleSampled* FromCppAPI(wgpu::DawnRenderPassColorAttachmentRenderToSingleSampled* rhs) {
        return reinterpret_cast<DawnRenderPassColorAttachmentRenderToSingleSampled*>(rhs);
    }

    inline const WGPUDawnShaderModuleSPIRVOptionsDescriptor* ToAPI(const DawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<const WGPUDawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline WGPUDawnShaderModuleSPIRVOptionsDescriptor* ToAPI(DawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<WGPUDawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline const DawnShaderModuleSPIRVOptionsDescriptor* FromAPI(const WGPUDawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<const DawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline DawnShaderModuleSPIRVOptionsDescriptor* FromAPI(WGPUDawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<DawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline const wgpu::DawnShaderModuleSPIRVOptionsDescriptor* ToCppAPI(const DawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline wgpu::DawnShaderModuleSPIRVOptionsDescriptor* ToCppAPI(DawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<wgpu::DawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline const DawnShaderModuleSPIRVOptionsDescriptor* FromCppAPI(const wgpu::DawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<const DawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }
    inline DawnShaderModuleSPIRVOptionsDescriptor* FromCppAPI(wgpu::DawnShaderModuleSPIRVOptionsDescriptor* rhs) {
        return reinterpret_cast<DawnShaderModuleSPIRVOptionsDescriptor*>(rhs);
    }

    inline const WGPUDawnTexelCopyBufferRowAlignmentLimits* ToAPI(const DawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<const WGPUDawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline WGPUDawnTexelCopyBufferRowAlignmentLimits* ToAPI(DawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<WGPUDawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline const DawnTexelCopyBufferRowAlignmentLimits* FromAPI(const WGPUDawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<const DawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline DawnTexelCopyBufferRowAlignmentLimits* FromAPI(WGPUDawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<DawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline const wgpu::DawnTexelCopyBufferRowAlignmentLimits* ToCppAPI(const DawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<const wgpu::DawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline wgpu::DawnTexelCopyBufferRowAlignmentLimits* ToCppAPI(DawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<wgpu::DawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline const DawnTexelCopyBufferRowAlignmentLimits* FromCppAPI(const wgpu::DawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<const DawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }
    inline DawnTexelCopyBufferRowAlignmentLimits* FromCppAPI(wgpu::DawnTexelCopyBufferRowAlignmentLimits* rhs) {
        return reinterpret_cast<DawnTexelCopyBufferRowAlignmentLimits*>(rhs);
    }

    inline const WGPUDawnTextureInternalUsageDescriptor* ToAPI(const DawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const WGPUDawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline WGPUDawnTextureInternalUsageDescriptor* ToAPI(DawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<WGPUDawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline const DawnTextureInternalUsageDescriptor* FromAPI(const WGPUDawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const DawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline DawnTextureInternalUsageDescriptor* FromAPI(WGPUDawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<DawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline const wgpu::DawnTextureInternalUsageDescriptor* ToCppAPI(const DawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline wgpu::DawnTextureInternalUsageDescriptor* ToCppAPI(DawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<wgpu::DawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline const DawnTextureInternalUsageDescriptor* FromCppAPI(const wgpu::DawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<const DawnTextureInternalUsageDescriptor*>(rhs);
    }
    inline DawnTextureInternalUsageDescriptor* FromCppAPI(wgpu::DawnTextureInternalUsageDescriptor* rhs) {
        return reinterpret_cast<DawnTextureInternalUsageDescriptor*>(rhs);
    }

    inline const WGPUDawnTogglesDescriptor* ToAPI(const DawnTogglesDescriptor* rhs) {
        return reinterpret_cast<const WGPUDawnTogglesDescriptor*>(rhs);
    }
    inline WGPUDawnTogglesDescriptor* ToAPI(DawnTogglesDescriptor* rhs) {
        return reinterpret_cast<WGPUDawnTogglesDescriptor*>(rhs);
    }
    inline const DawnTogglesDescriptor* FromAPI(const WGPUDawnTogglesDescriptor* rhs) {
        return reinterpret_cast<const DawnTogglesDescriptor*>(rhs);
    }
    inline DawnTogglesDescriptor* FromAPI(WGPUDawnTogglesDescriptor* rhs) {
        return reinterpret_cast<DawnTogglesDescriptor*>(rhs);
    }
    inline const wgpu::DawnTogglesDescriptor* ToCppAPI(const DawnTogglesDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DawnTogglesDescriptor*>(rhs);
    }
    inline wgpu::DawnTogglesDescriptor* ToCppAPI(DawnTogglesDescriptor* rhs) {
        return reinterpret_cast<wgpu::DawnTogglesDescriptor*>(rhs);
    }
    inline const DawnTogglesDescriptor* FromCppAPI(const wgpu::DawnTogglesDescriptor* rhs) {
        return reinterpret_cast<const DawnTogglesDescriptor*>(rhs);
    }
    inline DawnTogglesDescriptor* FromCppAPI(wgpu::DawnTogglesDescriptor* rhs) {
        return reinterpret_cast<DawnTogglesDescriptor*>(rhs);
    }

    inline const WGPUDawnWGSLBlocklist* ToAPI(const DawnWGSLBlocklist* rhs) {
        return reinterpret_cast<const WGPUDawnWGSLBlocklist*>(rhs);
    }
    inline WGPUDawnWGSLBlocklist* ToAPI(DawnWGSLBlocklist* rhs) {
        return reinterpret_cast<WGPUDawnWGSLBlocklist*>(rhs);
    }
    inline const DawnWGSLBlocklist* FromAPI(const WGPUDawnWGSLBlocklist* rhs) {
        return reinterpret_cast<const DawnWGSLBlocklist*>(rhs);
    }
    inline DawnWGSLBlocklist* FromAPI(WGPUDawnWGSLBlocklist* rhs) {
        return reinterpret_cast<DawnWGSLBlocklist*>(rhs);
    }
    inline const wgpu::DawnWGSLBlocklist* ToCppAPI(const DawnWGSLBlocklist* rhs) {
        return reinterpret_cast<const wgpu::DawnWGSLBlocklist*>(rhs);
    }
    inline wgpu::DawnWGSLBlocklist* ToCppAPI(DawnWGSLBlocklist* rhs) {
        return reinterpret_cast<wgpu::DawnWGSLBlocklist*>(rhs);
    }
    inline const DawnWGSLBlocklist* FromCppAPI(const wgpu::DawnWGSLBlocklist* rhs) {
        return reinterpret_cast<const DawnWGSLBlocklist*>(rhs);
    }
    inline DawnWGSLBlocklist* FromCppAPI(wgpu::DawnWGSLBlocklist* rhs) {
        return reinterpret_cast<DawnWGSLBlocklist*>(rhs);
    }

    inline const WGPUDawnWireWGSLControl* ToAPI(const DawnWireWGSLControl* rhs) {
        return reinterpret_cast<const WGPUDawnWireWGSLControl*>(rhs);
    }
    inline WGPUDawnWireWGSLControl* ToAPI(DawnWireWGSLControl* rhs) {
        return reinterpret_cast<WGPUDawnWireWGSLControl*>(rhs);
    }
    inline const DawnWireWGSLControl* FromAPI(const WGPUDawnWireWGSLControl* rhs) {
        return reinterpret_cast<const DawnWireWGSLControl*>(rhs);
    }
    inline DawnWireWGSLControl* FromAPI(WGPUDawnWireWGSLControl* rhs) {
        return reinterpret_cast<DawnWireWGSLControl*>(rhs);
    }
    inline const wgpu::DawnWireWGSLControl* ToCppAPI(const DawnWireWGSLControl* rhs) {
        return reinterpret_cast<const wgpu::DawnWireWGSLControl*>(rhs);
    }
    inline wgpu::DawnWireWGSLControl* ToCppAPI(DawnWireWGSLControl* rhs) {
        return reinterpret_cast<wgpu::DawnWireWGSLControl*>(rhs);
    }
    inline const DawnWireWGSLControl* FromCppAPI(const wgpu::DawnWireWGSLControl* rhs) {
        return reinterpret_cast<const DawnWireWGSLControl*>(rhs);
    }
    inline DawnWireWGSLControl* FromCppAPI(wgpu::DawnWireWGSLControl* rhs) {
        return reinterpret_cast<DawnWireWGSLControl*>(rhs);
    }

    inline const WGPUDynamicBindingArrayLayout* ToAPI(const DynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<const WGPUDynamicBindingArrayLayout*>(rhs);
    }
    inline WGPUDynamicBindingArrayLayout* ToAPI(DynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<WGPUDynamicBindingArrayLayout*>(rhs);
    }
    inline const DynamicBindingArrayLayout* FromAPI(const WGPUDynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<const DynamicBindingArrayLayout*>(rhs);
    }
    inline DynamicBindingArrayLayout* FromAPI(WGPUDynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<DynamicBindingArrayLayout*>(rhs);
    }
    inline const wgpu::DynamicBindingArrayLayout* ToCppAPI(const DynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<const wgpu::DynamicBindingArrayLayout*>(rhs);
    }
    inline wgpu::DynamicBindingArrayLayout* ToCppAPI(DynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<wgpu::DynamicBindingArrayLayout*>(rhs);
    }
    inline const DynamicBindingArrayLayout* FromCppAPI(const wgpu::DynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<const DynamicBindingArrayLayout*>(rhs);
    }
    inline DynamicBindingArrayLayout* FromCppAPI(wgpu::DynamicBindingArrayLayout* rhs) {
        return reinterpret_cast<DynamicBindingArrayLayout*>(rhs);
    }

    inline const WGPUDynamicBindingArrayLimits* ToAPI(const DynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<const WGPUDynamicBindingArrayLimits*>(rhs);
    }
    inline WGPUDynamicBindingArrayLimits* ToAPI(DynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<WGPUDynamicBindingArrayLimits*>(rhs);
    }
    inline const DynamicBindingArrayLimits* FromAPI(const WGPUDynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<const DynamicBindingArrayLimits*>(rhs);
    }
    inline DynamicBindingArrayLimits* FromAPI(WGPUDynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<DynamicBindingArrayLimits*>(rhs);
    }
    inline const wgpu::DynamicBindingArrayLimits* ToCppAPI(const DynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<const wgpu::DynamicBindingArrayLimits*>(rhs);
    }
    inline wgpu::DynamicBindingArrayLimits* ToCppAPI(DynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<wgpu::DynamicBindingArrayLimits*>(rhs);
    }
    inline const DynamicBindingArrayLimits* FromCppAPI(const wgpu::DynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<const DynamicBindingArrayLimits*>(rhs);
    }
    inline DynamicBindingArrayLimits* FromCppAPI(wgpu::DynamicBindingArrayLimits* rhs) {
        return reinterpret_cast<DynamicBindingArrayLimits*>(rhs);
    }

    inline const WGPUExtent2D* ToAPI(const Extent2D* rhs) {
        return reinterpret_cast<const WGPUExtent2D*>(rhs);
    }
    inline WGPUExtent2D* ToAPI(Extent2D* rhs) {
        return reinterpret_cast<WGPUExtent2D*>(rhs);
    }
    inline const Extent2D* FromAPI(const WGPUExtent2D* rhs) {
        return reinterpret_cast<const Extent2D*>(rhs);
    }
    inline Extent2D* FromAPI(WGPUExtent2D* rhs) {
        return reinterpret_cast<Extent2D*>(rhs);
    }
    inline const wgpu::Extent2D* ToCppAPI(const Extent2D* rhs) {
        return reinterpret_cast<const wgpu::Extent2D*>(rhs);
    }
    inline wgpu::Extent2D* ToCppAPI(Extent2D* rhs) {
        return reinterpret_cast<wgpu::Extent2D*>(rhs);
    }
    inline const Extent2D* FromCppAPI(const wgpu::Extent2D* rhs) {
        return reinterpret_cast<const Extent2D*>(rhs);
    }
    inline Extent2D* FromCppAPI(wgpu::Extent2D* rhs) {
        return reinterpret_cast<Extent2D*>(rhs);
    }

    inline const WGPUExtent3D* ToAPI(const Extent3D* rhs) {
        return reinterpret_cast<const WGPUExtent3D*>(rhs);
    }
    inline WGPUExtent3D* ToAPI(Extent3D* rhs) {
        return reinterpret_cast<WGPUExtent3D*>(rhs);
    }
    inline const Extent3D* FromAPI(const WGPUExtent3D* rhs) {
        return reinterpret_cast<const Extent3D*>(rhs);
    }
    inline Extent3D* FromAPI(WGPUExtent3D* rhs) {
        return reinterpret_cast<Extent3D*>(rhs);
    }
    inline const wgpu::Extent3D* ToCppAPI(const Extent3D* rhs) {
        return reinterpret_cast<const wgpu::Extent3D*>(rhs);
    }
    inline wgpu::Extent3D* ToCppAPI(Extent3D* rhs) {
        return reinterpret_cast<wgpu::Extent3D*>(rhs);
    }
    inline const Extent3D* FromCppAPI(const wgpu::Extent3D* rhs) {
        return reinterpret_cast<const Extent3D*>(rhs);
    }
    inline Extent3D* FromCppAPI(wgpu::Extent3D* rhs) {
        return reinterpret_cast<Extent3D*>(rhs);
    }

    inline const WGPUExternalTextureBindingEntry* ToAPI(const ExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<const WGPUExternalTextureBindingEntry*>(rhs);
    }
    inline WGPUExternalTextureBindingEntry* ToAPI(ExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<WGPUExternalTextureBindingEntry*>(rhs);
    }
    inline const ExternalTextureBindingEntry* FromAPI(const WGPUExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<const ExternalTextureBindingEntry*>(rhs);
    }
    inline ExternalTextureBindingEntry* FromAPI(WGPUExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<ExternalTextureBindingEntry*>(rhs);
    }
    inline const wgpu::ExternalTextureBindingEntry* ToCppAPI(const ExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<const wgpu::ExternalTextureBindingEntry*>(rhs);
    }
    inline wgpu::ExternalTextureBindingEntry* ToCppAPI(ExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<wgpu::ExternalTextureBindingEntry*>(rhs);
    }
    inline const ExternalTextureBindingEntry* FromCppAPI(const wgpu::ExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<const ExternalTextureBindingEntry*>(rhs);
    }
    inline ExternalTextureBindingEntry* FromCppAPI(wgpu::ExternalTextureBindingEntry* rhs) {
        return reinterpret_cast<ExternalTextureBindingEntry*>(rhs);
    }

    inline const WGPUExternalTextureBindingLayout* ToAPI(const ExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<const WGPUExternalTextureBindingLayout*>(rhs);
    }
    inline WGPUExternalTextureBindingLayout* ToAPI(ExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<WGPUExternalTextureBindingLayout*>(rhs);
    }
    inline const ExternalTextureBindingLayout* FromAPI(const WGPUExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<const ExternalTextureBindingLayout*>(rhs);
    }
    inline ExternalTextureBindingLayout* FromAPI(WGPUExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<ExternalTextureBindingLayout*>(rhs);
    }
    inline const wgpu::ExternalTextureBindingLayout* ToCppAPI(const ExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::ExternalTextureBindingLayout*>(rhs);
    }
    inline wgpu::ExternalTextureBindingLayout* ToCppAPI(ExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<wgpu::ExternalTextureBindingLayout*>(rhs);
    }
    inline const ExternalTextureBindingLayout* FromCppAPI(const wgpu::ExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<const ExternalTextureBindingLayout*>(rhs);
    }
    inline ExternalTextureBindingLayout* FromCppAPI(wgpu::ExternalTextureBindingLayout* rhs) {
        return reinterpret_cast<ExternalTextureBindingLayout*>(rhs);
    }

    inline const WGPUFuture* ToAPI(const Future* rhs) {
        return reinterpret_cast<const WGPUFuture*>(rhs);
    }
    inline WGPUFuture* ToAPI(Future* rhs) {
        return reinterpret_cast<WGPUFuture*>(rhs);
    }
    inline const Future* FromAPI(const WGPUFuture* rhs) {
        return reinterpret_cast<const Future*>(rhs);
    }
    inline Future* FromAPI(WGPUFuture* rhs) {
        return reinterpret_cast<Future*>(rhs);
    }
    inline const wgpu::Future* ToCppAPI(const Future* rhs) {
        return reinterpret_cast<const wgpu::Future*>(rhs);
    }
    inline wgpu::Future* ToCppAPI(Future* rhs) {
        return reinterpret_cast<wgpu::Future*>(rhs);
    }
    inline const Future* FromCppAPI(const wgpu::Future* rhs) {
        return reinterpret_cast<const Future*>(rhs);
    }
    inline Future* FromCppAPI(wgpu::Future* rhs) {
        return reinterpret_cast<Future*>(rhs);
    }

    inline const WGPUInstanceLimits* ToAPI(const InstanceLimits* rhs) {
        return reinterpret_cast<const WGPUInstanceLimits*>(rhs);
    }
    inline WGPUInstanceLimits* ToAPI(InstanceLimits* rhs) {
        return reinterpret_cast<WGPUInstanceLimits*>(rhs);
    }
    inline const InstanceLimits* FromAPI(const WGPUInstanceLimits* rhs) {
        return reinterpret_cast<const InstanceLimits*>(rhs);
    }
    inline InstanceLimits* FromAPI(WGPUInstanceLimits* rhs) {
        return reinterpret_cast<InstanceLimits*>(rhs);
    }
    inline const wgpu::InstanceLimits* ToCppAPI(const InstanceLimits* rhs) {
        return reinterpret_cast<const wgpu::InstanceLimits*>(rhs);
    }
    inline wgpu::InstanceLimits* ToCppAPI(InstanceLimits* rhs) {
        return reinterpret_cast<wgpu::InstanceLimits*>(rhs);
    }
    inline const InstanceLimits* FromCppAPI(const wgpu::InstanceLimits* rhs) {
        return reinterpret_cast<const InstanceLimits*>(rhs);
    }
    inline InstanceLimits* FromCppAPI(wgpu::InstanceLimits* rhs) {
        return reinterpret_cast<InstanceLimits*>(rhs);
    }

    inline const WGPUMemoryHeapInfo* ToAPI(const MemoryHeapInfo* rhs) {
        return reinterpret_cast<const WGPUMemoryHeapInfo*>(rhs);
    }
    inline WGPUMemoryHeapInfo* ToAPI(MemoryHeapInfo* rhs) {
        return reinterpret_cast<WGPUMemoryHeapInfo*>(rhs);
    }
    inline const MemoryHeapInfo* FromAPI(const WGPUMemoryHeapInfo* rhs) {
        return reinterpret_cast<const MemoryHeapInfo*>(rhs);
    }
    inline MemoryHeapInfo* FromAPI(WGPUMemoryHeapInfo* rhs) {
        return reinterpret_cast<MemoryHeapInfo*>(rhs);
    }
    inline const wgpu::MemoryHeapInfo* ToCppAPI(const MemoryHeapInfo* rhs) {
        return reinterpret_cast<const wgpu::MemoryHeapInfo*>(rhs);
    }
    inline wgpu::MemoryHeapInfo* ToCppAPI(MemoryHeapInfo* rhs) {
        return reinterpret_cast<wgpu::MemoryHeapInfo*>(rhs);
    }
    inline const MemoryHeapInfo* FromCppAPI(const wgpu::MemoryHeapInfo* rhs) {
        return reinterpret_cast<const MemoryHeapInfo*>(rhs);
    }
    inline MemoryHeapInfo* FromCppAPI(wgpu::MemoryHeapInfo* rhs) {
        return reinterpret_cast<MemoryHeapInfo*>(rhs);
    }

    inline const WGPUMultisampleState* ToAPI(const MultisampleState* rhs) {
        return reinterpret_cast<const WGPUMultisampleState*>(rhs);
    }
    inline WGPUMultisampleState* ToAPI(MultisampleState* rhs) {
        return reinterpret_cast<WGPUMultisampleState*>(rhs);
    }
    inline const MultisampleState* FromAPI(const WGPUMultisampleState* rhs) {
        return reinterpret_cast<const MultisampleState*>(rhs);
    }
    inline MultisampleState* FromAPI(WGPUMultisampleState* rhs) {
        return reinterpret_cast<MultisampleState*>(rhs);
    }
    inline const wgpu::MultisampleState* ToCppAPI(const MultisampleState* rhs) {
        return reinterpret_cast<const wgpu::MultisampleState*>(rhs);
    }
    inline wgpu::MultisampleState* ToCppAPI(MultisampleState* rhs) {
        return reinterpret_cast<wgpu::MultisampleState*>(rhs);
    }
    inline const MultisampleState* FromCppAPI(const wgpu::MultisampleState* rhs) {
        return reinterpret_cast<const MultisampleState*>(rhs);
    }
    inline MultisampleState* FromCppAPI(wgpu::MultisampleState* rhs) {
        return reinterpret_cast<MultisampleState*>(rhs);
    }

    inline const WGPUOrigin2D* ToAPI(const Origin2D* rhs) {
        return reinterpret_cast<const WGPUOrigin2D*>(rhs);
    }
    inline WGPUOrigin2D* ToAPI(Origin2D* rhs) {
        return reinterpret_cast<WGPUOrigin2D*>(rhs);
    }
    inline const Origin2D* FromAPI(const WGPUOrigin2D* rhs) {
        return reinterpret_cast<const Origin2D*>(rhs);
    }
    inline Origin2D* FromAPI(WGPUOrigin2D* rhs) {
        return reinterpret_cast<Origin2D*>(rhs);
    }
    inline const wgpu::Origin2D* ToCppAPI(const Origin2D* rhs) {
        return reinterpret_cast<const wgpu::Origin2D*>(rhs);
    }
    inline wgpu::Origin2D* ToCppAPI(Origin2D* rhs) {
        return reinterpret_cast<wgpu::Origin2D*>(rhs);
    }
    inline const Origin2D* FromCppAPI(const wgpu::Origin2D* rhs) {
        return reinterpret_cast<const Origin2D*>(rhs);
    }
    inline Origin2D* FromCppAPI(wgpu::Origin2D* rhs) {
        return reinterpret_cast<Origin2D*>(rhs);
    }

    inline const WGPUOrigin3D* ToAPI(const Origin3D* rhs) {
        return reinterpret_cast<const WGPUOrigin3D*>(rhs);
    }
    inline WGPUOrigin3D* ToAPI(Origin3D* rhs) {
        return reinterpret_cast<WGPUOrigin3D*>(rhs);
    }
    inline const Origin3D* FromAPI(const WGPUOrigin3D* rhs) {
        return reinterpret_cast<const Origin3D*>(rhs);
    }
    inline Origin3D* FromAPI(WGPUOrigin3D* rhs) {
        return reinterpret_cast<Origin3D*>(rhs);
    }
    inline const wgpu::Origin3D* ToCppAPI(const Origin3D* rhs) {
        return reinterpret_cast<const wgpu::Origin3D*>(rhs);
    }
    inline wgpu::Origin3D* ToCppAPI(Origin3D* rhs) {
        return reinterpret_cast<wgpu::Origin3D*>(rhs);
    }
    inline const Origin3D* FromCppAPI(const wgpu::Origin3D* rhs) {
        return reinterpret_cast<const Origin3D*>(rhs);
    }
    inline Origin3D* FromCppAPI(wgpu::Origin3D* rhs) {
        return reinterpret_cast<Origin3D*>(rhs);
    }

    inline const WGPUPassTimestampWrites* ToAPI(const PassTimestampWrites* rhs) {
        return reinterpret_cast<const WGPUPassTimestampWrites*>(rhs);
    }
    inline WGPUPassTimestampWrites* ToAPI(PassTimestampWrites* rhs) {
        return reinterpret_cast<WGPUPassTimestampWrites*>(rhs);
    }
    inline const PassTimestampWrites* FromAPI(const WGPUPassTimestampWrites* rhs) {
        return reinterpret_cast<const PassTimestampWrites*>(rhs);
    }
    inline PassTimestampWrites* FromAPI(WGPUPassTimestampWrites* rhs) {
        return reinterpret_cast<PassTimestampWrites*>(rhs);
    }
    inline const wgpu::PassTimestampWrites* ToCppAPI(const PassTimestampWrites* rhs) {
        return reinterpret_cast<const wgpu::PassTimestampWrites*>(rhs);
    }
    inline wgpu::PassTimestampWrites* ToCppAPI(PassTimestampWrites* rhs) {
        return reinterpret_cast<wgpu::PassTimestampWrites*>(rhs);
    }
    inline const PassTimestampWrites* FromCppAPI(const wgpu::PassTimestampWrites* rhs) {
        return reinterpret_cast<const PassTimestampWrites*>(rhs);
    }
    inline PassTimestampWrites* FromCppAPI(wgpu::PassTimestampWrites* rhs) {
        return reinterpret_cast<PassTimestampWrites*>(rhs);
    }

    inline const WGPUPipelineLayoutStorageAttachment* ToAPI(const PipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<const WGPUPipelineLayoutStorageAttachment*>(rhs);
    }
    inline WGPUPipelineLayoutStorageAttachment* ToAPI(PipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<WGPUPipelineLayoutStorageAttachment*>(rhs);
    }
    inline const PipelineLayoutStorageAttachment* FromAPI(const WGPUPipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<const PipelineLayoutStorageAttachment*>(rhs);
    }
    inline PipelineLayoutStorageAttachment* FromAPI(WGPUPipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<PipelineLayoutStorageAttachment*>(rhs);
    }
    inline const wgpu::PipelineLayoutStorageAttachment* ToCppAPI(const PipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<const wgpu::PipelineLayoutStorageAttachment*>(rhs);
    }
    inline wgpu::PipelineLayoutStorageAttachment* ToCppAPI(PipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<wgpu::PipelineLayoutStorageAttachment*>(rhs);
    }
    inline const PipelineLayoutStorageAttachment* FromCppAPI(const wgpu::PipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<const PipelineLayoutStorageAttachment*>(rhs);
    }
    inline PipelineLayoutStorageAttachment* FromCppAPI(wgpu::PipelineLayoutStorageAttachment* rhs) {
        return reinterpret_cast<PipelineLayoutStorageAttachment*>(rhs);
    }

    inline const WGPUPrimitiveState* ToAPI(const PrimitiveState* rhs) {
        return reinterpret_cast<const WGPUPrimitiveState*>(rhs);
    }
    inline WGPUPrimitiveState* ToAPI(PrimitiveState* rhs) {
        return reinterpret_cast<WGPUPrimitiveState*>(rhs);
    }
    inline const PrimitiveState* FromAPI(const WGPUPrimitiveState* rhs) {
        return reinterpret_cast<const PrimitiveState*>(rhs);
    }
    inline PrimitiveState* FromAPI(WGPUPrimitiveState* rhs) {
        return reinterpret_cast<PrimitiveState*>(rhs);
    }
    inline const wgpu::PrimitiveState* ToCppAPI(const PrimitiveState* rhs) {
        return reinterpret_cast<const wgpu::PrimitiveState*>(rhs);
    }
    inline wgpu::PrimitiveState* ToCppAPI(PrimitiveState* rhs) {
        return reinterpret_cast<wgpu::PrimitiveState*>(rhs);
    }
    inline const PrimitiveState* FromCppAPI(const wgpu::PrimitiveState* rhs) {
        return reinterpret_cast<const PrimitiveState*>(rhs);
    }
    inline PrimitiveState* FromCppAPI(wgpu::PrimitiveState* rhs) {
        return reinterpret_cast<PrimitiveState*>(rhs);
    }

    inline const WGPUQuerySetDescriptor* ToAPI(const QuerySetDescriptor* rhs) {
        return reinterpret_cast<const WGPUQuerySetDescriptor*>(rhs);
    }
    inline WGPUQuerySetDescriptor* ToAPI(QuerySetDescriptor* rhs) {
        return reinterpret_cast<WGPUQuerySetDescriptor*>(rhs);
    }
    inline const QuerySetDescriptor* FromAPI(const WGPUQuerySetDescriptor* rhs) {
        return reinterpret_cast<const QuerySetDescriptor*>(rhs);
    }
    inline QuerySetDescriptor* FromAPI(WGPUQuerySetDescriptor* rhs) {
        return reinterpret_cast<QuerySetDescriptor*>(rhs);
    }
    inline const wgpu::QuerySetDescriptor* ToCppAPI(const QuerySetDescriptor* rhs) {
        return reinterpret_cast<const wgpu::QuerySetDescriptor*>(rhs);
    }
    inline wgpu::QuerySetDescriptor* ToCppAPI(QuerySetDescriptor* rhs) {
        return reinterpret_cast<wgpu::QuerySetDescriptor*>(rhs);
    }
    inline const QuerySetDescriptor* FromCppAPI(const wgpu::QuerySetDescriptor* rhs) {
        return reinterpret_cast<const QuerySetDescriptor*>(rhs);
    }
    inline QuerySetDescriptor* FromCppAPI(wgpu::QuerySetDescriptor* rhs) {
        return reinterpret_cast<QuerySetDescriptor*>(rhs);
    }

    inline const WGPUQueueDescriptor* ToAPI(const QueueDescriptor* rhs) {
        return reinterpret_cast<const WGPUQueueDescriptor*>(rhs);
    }
    inline WGPUQueueDescriptor* ToAPI(QueueDescriptor* rhs) {
        return reinterpret_cast<WGPUQueueDescriptor*>(rhs);
    }
    inline const QueueDescriptor* FromAPI(const WGPUQueueDescriptor* rhs) {
        return reinterpret_cast<const QueueDescriptor*>(rhs);
    }
    inline QueueDescriptor* FromAPI(WGPUQueueDescriptor* rhs) {
        return reinterpret_cast<QueueDescriptor*>(rhs);
    }
    inline const wgpu::QueueDescriptor* ToCppAPI(const QueueDescriptor* rhs) {
        return reinterpret_cast<const wgpu::QueueDescriptor*>(rhs);
    }
    inline wgpu::QueueDescriptor* ToCppAPI(QueueDescriptor* rhs) {
        return reinterpret_cast<wgpu::QueueDescriptor*>(rhs);
    }
    inline const QueueDescriptor* FromCppAPI(const wgpu::QueueDescriptor* rhs) {
        return reinterpret_cast<const QueueDescriptor*>(rhs);
    }
    inline QueueDescriptor* FromCppAPI(wgpu::QueueDescriptor* rhs) {
        return reinterpret_cast<QueueDescriptor*>(rhs);
    }

    inline const WGPURenderBundleDescriptor* ToAPI(const RenderBundleDescriptor* rhs) {
        return reinterpret_cast<const WGPURenderBundleDescriptor*>(rhs);
    }
    inline WGPURenderBundleDescriptor* ToAPI(RenderBundleDescriptor* rhs) {
        return reinterpret_cast<WGPURenderBundleDescriptor*>(rhs);
    }
    inline const RenderBundleDescriptor* FromAPI(const WGPURenderBundleDescriptor* rhs) {
        return reinterpret_cast<const RenderBundleDescriptor*>(rhs);
    }
    inline RenderBundleDescriptor* FromAPI(WGPURenderBundleDescriptor* rhs) {
        return reinterpret_cast<RenderBundleDescriptor*>(rhs);
    }
    inline const wgpu::RenderBundleDescriptor* ToCppAPI(const RenderBundleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::RenderBundleDescriptor*>(rhs);
    }
    inline wgpu::RenderBundleDescriptor* ToCppAPI(RenderBundleDescriptor* rhs) {
        return reinterpret_cast<wgpu::RenderBundleDescriptor*>(rhs);
    }
    inline const RenderBundleDescriptor* FromCppAPI(const wgpu::RenderBundleDescriptor* rhs) {
        return reinterpret_cast<const RenderBundleDescriptor*>(rhs);
    }
    inline RenderBundleDescriptor* FromCppAPI(wgpu::RenderBundleDescriptor* rhs) {
        return reinterpret_cast<RenderBundleDescriptor*>(rhs);
    }

    inline const WGPURenderBundleEncoderDescriptor* ToAPI(const RenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<const WGPURenderBundleEncoderDescriptor*>(rhs);
    }
    inline WGPURenderBundleEncoderDescriptor* ToAPI(RenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<WGPURenderBundleEncoderDescriptor*>(rhs);
    }
    inline const RenderBundleEncoderDescriptor* FromAPI(const WGPURenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<const RenderBundleEncoderDescriptor*>(rhs);
    }
    inline RenderBundleEncoderDescriptor* FromAPI(WGPURenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<RenderBundleEncoderDescriptor*>(rhs);
    }
    inline const wgpu::RenderBundleEncoderDescriptor* ToCppAPI(const RenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<const wgpu::RenderBundleEncoderDescriptor*>(rhs);
    }
    inline wgpu::RenderBundleEncoderDescriptor* ToCppAPI(RenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<wgpu::RenderBundleEncoderDescriptor*>(rhs);
    }
    inline const RenderBundleEncoderDescriptor* FromCppAPI(const wgpu::RenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<const RenderBundleEncoderDescriptor*>(rhs);
    }
    inline RenderBundleEncoderDescriptor* FromCppAPI(wgpu::RenderBundleEncoderDescriptor* rhs) {
        return reinterpret_cast<RenderBundleEncoderDescriptor*>(rhs);
    }

    inline const WGPURenderPassDepthStencilAttachment* ToAPI(const RenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<const WGPURenderPassDepthStencilAttachment*>(rhs);
    }
    inline WGPURenderPassDepthStencilAttachment* ToAPI(RenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<WGPURenderPassDepthStencilAttachment*>(rhs);
    }
    inline const RenderPassDepthStencilAttachment* FromAPI(const WGPURenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<const RenderPassDepthStencilAttachment*>(rhs);
    }
    inline RenderPassDepthStencilAttachment* FromAPI(WGPURenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<RenderPassDepthStencilAttachment*>(rhs);
    }
    inline const wgpu::RenderPassDepthStencilAttachment* ToCppAPI(const RenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<const wgpu::RenderPassDepthStencilAttachment*>(rhs);
    }
    inline wgpu::RenderPassDepthStencilAttachment* ToCppAPI(RenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<wgpu::RenderPassDepthStencilAttachment*>(rhs);
    }
    inline const RenderPassDepthStencilAttachment* FromCppAPI(const wgpu::RenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<const RenderPassDepthStencilAttachment*>(rhs);
    }
    inline RenderPassDepthStencilAttachment* FromCppAPI(wgpu::RenderPassDepthStencilAttachment* rhs) {
        return reinterpret_cast<RenderPassDepthStencilAttachment*>(rhs);
    }

    inline const WGPURenderPassDescriptorExpandResolveRect* ToAPI(const RenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<const WGPURenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline WGPURenderPassDescriptorExpandResolveRect* ToAPI(RenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<WGPURenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline const RenderPassDescriptorExpandResolveRect* FromAPI(const WGPURenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<const RenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline RenderPassDescriptorExpandResolveRect* FromAPI(WGPURenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<RenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline const wgpu::RenderPassDescriptorExpandResolveRect* ToCppAPI(const RenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<const wgpu::RenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline wgpu::RenderPassDescriptorExpandResolveRect* ToCppAPI(RenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<wgpu::RenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline const RenderPassDescriptorExpandResolveRect* FromCppAPI(const wgpu::RenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<const RenderPassDescriptorExpandResolveRect*>(rhs);
    }
    inline RenderPassDescriptorExpandResolveRect* FromCppAPI(wgpu::RenderPassDescriptorExpandResolveRect* rhs) {
        return reinterpret_cast<RenderPassDescriptorExpandResolveRect*>(rhs);
    }

    inline const WGPURenderPassDescriptorResolveRect* ToAPI(const RenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<const WGPURenderPassDescriptorResolveRect*>(rhs);
    }
    inline WGPURenderPassDescriptorResolveRect* ToAPI(RenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<WGPURenderPassDescriptorResolveRect*>(rhs);
    }
    inline const RenderPassDescriptorResolveRect* FromAPI(const WGPURenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<const RenderPassDescriptorResolveRect*>(rhs);
    }
    inline RenderPassDescriptorResolveRect* FromAPI(WGPURenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<RenderPassDescriptorResolveRect*>(rhs);
    }
    inline const wgpu::RenderPassDescriptorResolveRect* ToCppAPI(const RenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<const wgpu::RenderPassDescriptorResolveRect*>(rhs);
    }
    inline wgpu::RenderPassDescriptorResolveRect* ToCppAPI(RenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<wgpu::RenderPassDescriptorResolveRect*>(rhs);
    }
    inline const RenderPassDescriptorResolveRect* FromCppAPI(const wgpu::RenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<const RenderPassDescriptorResolveRect*>(rhs);
    }
    inline RenderPassDescriptorResolveRect* FromCppAPI(wgpu::RenderPassDescriptorResolveRect* rhs) {
        return reinterpret_cast<RenderPassDescriptorResolveRect*>(rhs);
    }

    inline const WGPURenderPassMaxDrawCount* ToAPI(const RenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<const WGPURenderPassMaxDrawCount*>(rhs);
    }
    inline WGPURenderPassMaxDrawCount* ToAPI(RenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<WGPURenderPassMaxDrawCount*>(rhs);
    }
    inline const RenderPassMaxDrawCount* FromAPI(const WGPURenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<const RenderPassMaxDrawCount*>(rhs);
    }
    inline RenderPassMaxDrawCount* FromAPI(WGPURenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<RenderPassMaxDrawCount*>(rhs);
    }
    inline const wgpu::RenderPassMaxDrawCount* ToCppAPI(const RenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<const wgpu::RenderPassMaxDrawCount*>(rhs);
    }
    inline wgpu::RenderPassMaxDrawCount* ToCppAPI(RenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<wgpu::RenderPassMaxDrawCount*>(rhs);
    }
    inline const RenderPassMaxDrawCount* FromCppAPI(const wgpu::RenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<const RenderPassMaxDrawCount*>(rhs);
    }
    inline RenderPassMaxDrawCount* FromCppAPI(wgpu::RenderPassMaxDrawCount* rhs) {
        return reinterpret_cast<RenderPassMaxDrawCount*>(rhs);
    }

    inline const WGPURequestAdapterWebGPUBackendOptions* ToAPI(const RequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<const WGPURequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline WGPURequestAdapterWebGPUBackendOptions* ToAPI(RequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<WGPURequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline const RequestAdapterWebGPUBackendOptions* FromAPI(const WGPURequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<const RequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline RequestAdapterWebGPUBackendOptions* FromAPI(WGPURequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<RequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline const wgpu::RequestAdapterWebGPUBackendOptions* ToCppAPI(const RequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<const wgpu::RequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline wgpu::RequestAdapterWebGPUBackendOptions* ToCppAPI(RequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<wgpu::RequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline const RequestAdapterWebGPUBackendOptions* FromCppAPI(const wgpu::RequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<const RequestAdapterWebGPUBackendOptions*>(rhs);
    }
    inline RequestAdapterWebGPUBackendOptions* FromCppAPI(wgpu::RequestAdapterWebGPUBackendOptions* rhs) {
        return reinterpret_cast<RequestAdapterWebGPUBackendOptions*>(rhs);
    }

    inline const WGPURequestAdapterWebXROptions* ToAPI(const RequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<const WGPURequestAdapterWebXROptions*>(rhs);
    }
    inline WGPURequestAdapterWebXROptions* ToAPI(RequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<WGPURequestAdapterWebXROptions*>(rhs);
    }
    inline const RequestAdapterWebXROptions* FromAPI(const WGPURequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<const RequestAdapterWebXROptions*>(rhs);
    }
    inline RequestAdapterWebXROptions* FromAPI(WGPURequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<RequestAdapterWebXROptions*>(rhs);
    }
    inline const wgpu::RequestAdapterWebXROptions* ToCppAPI(const RequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<const wgpu::RequestAdapterWebXROptions*>(rhs);
    }
    inline wgpu::RequestAdapterWebXROptions* ToCppAPI(RequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<wgpu::RequestAdapterWebXROptions*>(rhs);
    }
    inline const RequestAdapterWebXROptions* FromCppAPI(const wgpu::RequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<const RequestAdapterWebXROptions*>(rhs);
    }
    inline RequestAdapterWebXROptions* FromCppAPI(wgpu::RequestAdapterWebXROptions* rhs) {
        return reinterpret_cast<RequestAdapterWebXROptions*>(rhs);
    }

    inline const WGPUSamplerBindingLayout* ToAPI(const SamplerBindingLayout* rhs) {
        return reinterpret_cast<const WGPUSamplerBindingLayout*>(rhs);
    }
    inline WGPUSamplerBindingLayout* ToAPI(SamplerBindingLayout* rhs) {
        return reinterpret_cast<WGPUSamplerBindingLayout*>(rhs);
    }
    inline const SamplerBindingLayout* FromAPI(const WGPUSamplerBindingLayout* rhs) {
        return reinterpret_cast<const SamplerBindingLayout*>(rhs);
    }
    inline SamplerBindingLayout* FromAPI(WGPUSamplerBindingLayout* rhs) {
        return reinterpret_cast<SamplerBindingLayout*>(rhs);
    }
    inline const wgpu::SamplerBindingLayout* ToCppAPI(const SamplerBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::SamplerBindingLayout*>(rhs);
    }
    inline wgpu::SamplerBindingLayout* ToCppAPI(SamplerBindingLayout* rhs) {
        return reinterpret_cast<wgpu::SamplerBindingLayout*>(rhs);
    }
    inline const SamplerBindingLayout* FromCppAPI(const wgpu::SamplerBindingLayout* rhs) {
        return reinterpret_cast<const SamplerBindingLayout*>(rhs);
    }
    inline SamplerBindingLayout* FromCppAPI(wgpu::SamplerBindingLayout* rhs) {
        return reinterpret_cast<SamplerBindingLayout*>(rhs);
    }

    inline const WGPUShaderModuleCompilationOptions* ToAPI(const ShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<const WGPUShaderModuleCompilationOptions*>(rhs);
    }
    inline WGPUShaderModuleCompilationOptions* ToAPI(ShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<WGPUShaderModuleCompilationOptions*>(rhs);
    }
    inline const ShaderModuleCompilationOptions* FromAPI(const WGPUShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<const ShaderModuleCompilationOptions*>(rhs);
    }
    inline ShaderModuleCompilationOptions* FromAPI(WGPUShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<ShaderModuleCompilationOptions*>(rhs);
    }
    inline const wgpu::ShaderModuleCompilationOptions* ToCppAPI(const ShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<const wgpu::ShaderModuleCompilationOptions*>(rhs);
    }
    inline wgpu::ShaderModuleCompilationOptions* ToCppAPI(ShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<wgpu::ShaderModuleCompilationOptions*>(rhs);
    }
    inline const ShaderModuleCompilationOptions* FromCppAPI(const wgpu::ShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<const ShaderModuleCompilationOptions*>(rhs);
    }
    inline ShaderModuleCompilationOptions* FromCppAPI(wgpu::ShaderModuleCompilationOptions* rhs) {
        return reinterpret_cast<ShaderModuleCompilationOptions*>(rhs);
    }

    inline const WGPUShaderSourceSPIRV* ToAPI(const ShaderSourceSPIRV* rhs) {
        return reinterpret_cast<const WGPUShaderSourceSPIRV*>(rhs);
    }
    inline WGPUShaderSourceSPIRV* ToAPI(ShaderSourceSPIRV* rhs) {
        return reinterpret_cast<WGPUShaderSourceSPIRV*>(rhs);
    }
    inline const ShaderSourceSPIRV* FromAPI(const WGPUShaderSourceSPIRV* rhs) {
        return reinterpret_cast<const ShaderSourceSPIRV*>(rhs);
    }
    inline ShaderSourceSPIRV* FromAPI(WGPUShaderSourceSPIRV* rhs) {
        return reinterpret_cast<ShaderSourceSPIRV*>(rhs);
    }
    inline const wgpu::ShaderSourceSPIRV* ToCppAPI(const ShaderSourceSPIRV* rhs) {
        return reinterpret_cast<const wgpu::ShaderSourceSPIRV*>(rhs);
    }
    inline wgpu::ShaderSourceSPIRV* ToCppAPI(ShaderSourceSPIRV* rhs) {
        return reinterpret_cast<wgpu::ShaderSourceSPIRV*>(rhs);
    }
    inline const ShaderSourceSPIRV* FromCppAPI(const wgpu::ShaderSourceSPIRV* rhs) {
        return reinterpret_cast<const ShaderSourceSPIRV*>(rhs);
    }
    inline ShaderSourceSPIRV* FromCppAPI(wgpu::ShaderSourceSPIRV* rhs) {
        return reinterpret_cast<ShaderSourceSPIRV*>(rhs);
    }

    inline const WGPUShaderSourceWGSL* ToAPI(const ShaderSourceWGSL* rhs) {
        return reinterpret_cast<const WGPUShaderSourceWGSL*>(rhs);
    }
    inline WGPUShaderSourceWGSL* ToAPI(ShaderSourceWGSL* rhs) {
        return reinterpret_cast<WGPUShaderSourceWGSL*>(rhs);
    }
    inline const ShaderSourceWGSL* FromAPI(const WGPUShaderSourceWGSL* rhs) {
        return reinterpret_cast<const ShaderSourceWGSL*>(rhs);
    }
    inline ShaderSourceWGSL* FromAPI(WGPUShaderSourceWGSL* rhs) {
        return reinterpret_cast<ShaderSourceWGSL*>(rhs);
    }
    inline const wgpu::ShaderSourceWGSL* ToCppAPI(const ShaderSourceWGSL* rhs) {
        return reinterpret_cast<const wgpu::ShaderSourceWGSL*>(rhs);
    }
    inline wgpu::ShaderSourceWGSL* ToCppAPI(ShaderSourceWGSL* rhs) {
        return reinterpret_cast<wgpu::ShaderSourceWGSL*>(rhs);
    }
    inline const ShaderSourceWGSL* FromCppAPI(const wgpu::ShaderSourceWGSL* rhs) {
        return reinterpret_cast<const ShaderSourceWGSL*>(rhs);
    }
    inline ShaderSourceWGSL* FromCppAPI(wgpu::ShaderSourceWGSL* rhs) {
        return reinterpret_cast<ShaderSourceWGSL*>(rhs);
    }

    inline const WGPUSharedBufferMemoryBeginAccessDescriptor* ToAPI(const SharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline WGPUSharedBufferMemoryBeginAccessDescriptor* ToAPI(SharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline const SharedBufferMemoryBeginAccessDescriptor* FromAPI(const WGPUSharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const SharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline SharedBufferMemoryBeginAccessDescriptor* FromAPI(WGPUSharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<SharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline const wgpu::SharedBufferMemoryBeginAccessDescriptor* ToCppAPI(const SharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline wgpu::SharedBufferMemoryBeginAccessDescriptor* ToCppAPI(SharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline const SharedBufferMemoryBeginAccessDescriptor* FromCppAPI(const wgpu::SharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const SharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }
    inline SharedBufferMemoryBeginAccessDescriptor* FromCppAPI(wgpu::SharedBufferMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<SharedBufferMemoryBeginAccessDescriptor*>(rhs);
    }

    inline const WGPUSharedBufferMemoryDescriptor* ToAPI(const SharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedBufferMemoryDescriptor*>(rhs);
    }
    inline WGPUSharedBufferMemoryDescriptor* ToAPI(SharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedBufferMemoryDescriptor*>(rhs);
    }
    inline const SharedBufferMemoryDescriptor* FromAPI(const WGPUSharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<const SharedBufferMemoryDescriptor*>(rhs);
    }
    inline SharedBufferMemoryDescriptor* FromAPI(WGPUSharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<SharedBufferMemoryDescriptor*>(rhs);
    }
    inline const wgpu::SharedBufferMemoryDescriptor* ToCppAPI(const SharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedBufferMemoryDescriptor*>(rhs);
    }
    inline wgpu::SharedBufferMemoryDescriptor* ToCppAPI(SharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedBufferMemoryDescriptor*>(rhs);
    }
    inline const SharedBufferMemoryDescriptor* FromCppAPI(const wgpu::SharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<const SharedBufferMemoryDescriptor*>(rhs);
    }
    inline SharedBufferMemoryDescriptor* FromCppAPI(wgpu::SharedBufferMemoryDescriptor* rhs) {
        return reinterpret_cast<SharedBufferMemoryDescriptor*>(rhs);
    }

    inline const WGPUSharedBufferMemoryEndAccessState* ToAPI(const SharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<const WGPUSharedBufferMemoryEndAccessState*>(rhs);
    }
    inline WGPUSharedBufferMemoryEndAccessState* ToAPI(SharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<WGPUSharedBufferMemoryEndAccessState*>(rhs);
    }
    inline const SharedBufferMemoryEndAccessState* FromAPI(const WGPUSharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<const SharedBufferMemoryEndAccessState*>(rhs);
    }
    inline SharedBufferMemoryEndAccessState* FromAPI(WGPUSharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<SharedBufferMemoryEndAccessState*>(rhs);
    }
    inline const wgpu::SharedBufferMemoryEndAccessState* ToCppAPI(const SharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<const wgpu::SharedBufferMemoryEndAccessState*>(rhs);
    }
    inline wgpu::SharedBufferMemoryEndAccessState* ToCppAPI(SharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<wgpu::SharedBufferMemoryEndAccessState*>(rhs);
    }
    inline const SharedBufferMemoryEndAccessState* FromCppAPI(const wgpu::SharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<const SharedBufferMemoryEndAccessState*>(rhs);
    }
    inline SharedBufferMemoryEndAccessState* FromCppAPI(wgpu::SharedBufferMemoryEndAccessState* rhs) {
        return reinterpret_cast<SharedBufferMemoryEndAccessState*>(rhs);
    }

    inline const WGPUSharedBufferMemoryProperties* ToAPI(const SharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<const WGPUSharedBufferMemoryProperties*>(rhs);
    }
    inline WGPUSharedBufferMemoryProperties* ToAPI(SharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<WGPUSharedBufferMemoryProperties*>(rhs);
    }
    inline const SharedBufferMemoryProperties* FromAPI(const WGPUSharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<const SharedBufferMemoryProperties*>(rhs);
    }
    inline SharedBufferMemoryProperties* FromAPI(WGPUSharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<SharedBufferMemoryProperties*>(rhs);
    }
    inline const wgpu::SharedBufferMemoryProperties* ToCppAPI(const SharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<const wgpu::SharedBufferMemoryProperties*>(rhs);
    }
    inline wgpu::SharedBufferMemoryProperties* ToCppAPI(SharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<wgpu::SharedBufferMemoryProperties*>(rhs);
    }
    inline const SharedBufferMemoryProperties* FromCppAPI(const wgpu::SharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<const SharedBufferMemoryProperties*>(rhs);
    }
    inline SharedBufferMemoryProperties* FromCppAPI(wgpu::SharedBufferMemoryProperties* rhs) {
        return reinterpret_cast<SharedBufferMemoryProperties*>(rhs);
    }

    inline const WGPUSharedFenceDXGISharedHandleDescriptor* ToAPI(const SharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline WGPUSharedFenceDXGISharedHandleDescriptor* ToAPI(SharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline const SharedFenceDXGISharedHandleDescriptor* FromAPI(const WGPUSharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline SharedFenceDXGISharedHandleDescriptor* FromAPI(WGPUSharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<SharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceDXGISharedHandleDescriptor* ToCppAPI(const SharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceDXGISharedHandleDescriptor* ToCppAPI(SharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline const SharedFenceDXGISharedHandleDescriptor* FromCppAPI(const wgpu::SharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceDXGISharedHandleDescriptor*>(rhs);
    }
    inline SharedFenceDXGISharedHandleDescriptor* FromCppAPI(wgpu::SharedFenceDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<SharedFenceDXGISharedHandleDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceDXGISharedHandleExportInfo* ToAPI(const SharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline WGPUSharedFenceDXGISharedHandleExportInfo* ToAPI(SharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline const SharedFenceDXGISharedHandleExportInfo* FromAPI(const WGPUSharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline SharedFenceDXGISharedHandleExportInfo* FromAPI(WGPUSharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<SharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceDXGISharedHandleExportInfo* ToCppAPI(const SharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceDXGISharedHandleExportInfo* ToCppAPI(SharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline const SharedFenceDXGISharedHandleExportInfo* FromCppAPI(const wgpu::SharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceDXGISharedHandleExportInfo*>(rhs);
    }
    inline SharedFenceDXGISharedHandleExportInfo* FromCppAPI(wgpu::SharedFenceDXGISharedHandleExportInfo* rhs) {
        return reinterpret_cast<SharedFenceDXGISharedHandleExportInfo*>(rhs);
    }

    inline const WGPUSharedFenceEGLSyncDescriptor* ToAPI(const SharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline WGPUSharedFenceEGLSyncDescriptor* ToAPI(SharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline const SharedFenceEGLSyncDescriptor* FromAPI(const WGPUSharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline SharedFenceEGLSyncDescriptor* FromAPI(WGPUSharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<SharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceEGLSyncDescriptor* ToCppAPI(const SharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceEGLSyncDescriptor* ToCppAPI(SharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline const SharedFenceEGLSyncDescriptor* FromCppAPI(const wgpu::SharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceEGLSyncDescriptor*>(rhs);
    }
    inline SharedFenceEGLSyncDescriptor* FromCppAPI(wgpu::SharedFenceEGLSyncDescriptor* rhs) {
        return reinterpret_cast<SharedFenceEGLSyncDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceEGLSyncExportInfo* ToAPI(const SharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline WGPUSharedFenceEGLSyncExportInfo* ToAPI(SharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline const SharedFenceEGLSyncExportInfo* FromAPI(const WGPUSharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline SharedFenceEGLSyncExportInfo* FromAPI(WGPUSharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<SharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceEGLSyncExportInfo* ToCppAPI(const SharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceEGLSyncExportInfo* ToCppAPI(SharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline const SharedFenceEGLSyncExportInfo* FromCppAPI(const wgpu::SharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceEGLSyncExportInfo*>(rhs);
    }
    inline SharedFenceEGLSyncExportInfo* FromCppAPI(wgpu::SharedFenceEGLSyncExportInfo* rhs) {
        return reinterpret_cast<SharedFenceEGLSyncExportInfo*>(rhs);
    }

    inline const WGPUSharedFenceMTLSharedEventDescriptor* ToAPI(const SharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline WGPUSharedFenceMTLSharedEventDescriptor* ToAPI(SharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline const SharedFenceMTLSharedEventDescriptor* FromAPI(const WGPUSharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline SharedFenceMTLSharedEventDescriptor* FromAPI(WGPUSharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<SharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceMTLSharedEventDescriptor* ToCppAPI(const SharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceMTLSharedEventDescriptor* ToCppAPI(SharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline const SharedFenceMTLSharedEventDescriptor* FromCppAPI(const wgpu::SharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceMTLSharedEventDescriptor*>(rhs);
    }
    inline SharedFenceMTLSharedEventDescriptor* FromCppAPI(wgpu::SharedFenceMTLSharedEventDescriptor* rhs) {
        return reinterpret_cast<SharedFenceMTLSharedEventDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceMTLSharedEventExportInfo* ToAPI(const SharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline WGPUSharedFenceMTLSharedEventExportInfo* ToAPI(SharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline const SharedFenceMTLSharedEventExportInfo* FromAPI(const WGPUSharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline SharedFenceMTLSharedEventExportInfo* FromAPI(WGPUSharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<SharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceMTLSharedEventExportInfo* ToCppAPI(const SharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceMTLSharedEventExportInfo* ToCppAPI(SharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline const SharedFenceMTLSharedEventExportInfo* FromCppAPI(const wgpu::SharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceMTLSharedEventExportInfo*>(rhs);
    }
    inline SharedFenceMTLSharedEventExportInfo* FromCppAPI(wgpu::SharedFenceMTLSharedEventExportInfo* rhs) {
        return reinterpret_cast<SharedFenceMTLSharedEventExportInfo*>(rhs);
    }

    inline const WGPUSharedFenceSyncFDDescriptor* ToAPI(const SharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceSyncFDDescriptor*>(rhs);
    }
    inline WGPUSharedFenceSyncFDDescriptor* ToAPI(SharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceSyncFDDescriptor*>(rhs);
    }
    inline const SharedFenceSyncFDDescriptor* FromAPI(const WGPUSharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceSyncFDDescriptor*>(rhs);
    }
    inline SharedFenceSyncFDDescriptor* FromAPI(WGPUSharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<SharedFenceSyncFDDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceSyncFDDescriptor* ToCppAPI(const SharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceSyncFDDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceSyncFDDescriptor* ToCppAPI(SharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceSyncFDDescriptor*>(rhs);
    }
    inline const SharedFenceSyncFDDescriptor* FromCppAPI(const wgpu::SharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceSyncFDDescriptor*>(rhs);
    }
    inline SharedFenceSyncFDDescriptor* FromCppAPI(wgpu::SharedFenceSyncFDDescriptor* rhs) {
        return reinterpret_cast<SharedFenceSyncFDDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceSyncFDExportInfo* ToAPI(const SharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceSyncFDExportInfo*>(rhs);
    }
    inline WGPUSharedFenceSyncFDExportInfo* ToAPI(SharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceSyncFDExportInfo*>(rhs);
    }
    inline const SharedFenceSyncFDExportInfo* FromAPI(const WGPUSharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceSyncFDExportInfo*>(rhs);
    }
    inline SharedFenceSyncFDExportInfo* FromAPI(WGPUSharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<SharedFenceSyncFDExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceSyncFDExportInfo* ToCppAPI(const SharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceSyncFDExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceSyncFDExportInfo* ToCppAPI(SharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceSyncFDExportInfo*>(rhs);
    }
    inline const SharedFenceSyncFDExportInfo* FromCppAPI(const wgpu::SharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceSyncFDExportInfo*>(rhs);
    }
    inline SharedFenceSyncFDExportInfo* FromCppAPI(wgpu::SharedFenceSyncFDExportInfo* rhs) {
        return reinterpret_cast<SharedFenceSyncFDExportInfo*>(rhs);
    }

    inline const WGPUSharedFenceVkSemaphoreOpaqueFDDescriptor* ToAPI(const SharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline WGPUSharedFenceVkSemaphoreOpaqueFDDescriptor* ToAPI(SharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline const SharedFenceVkSemaphoreOpaqueFDDescriptor* FromAPI(const WGPUSharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline SharedFenceVkSemaphoreOpaqueFDDescriptor* FromAPI(WGPUSharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceVkSemaphoreOpaqueFDDescriptor* ToCppAPI(const SharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceVkSemaphoreOpaqueFDDescriptor* ToCppAPI(SharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline const SharedFenceVkSemaphoreOpaqueFDDescriptor* FromCppAPI(const wgpu::SharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }
    inline SharedFenceVkSemaphoreOpaqueFDDescriptor* FromCppAPI(wgpu::SharedFenceVkSemaphoreOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreOpaqueFDDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceVkSemaphoreOpaqueFDExportInfo* ToAPI(const SharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline WGPUSharedFenceVkSemaphoreOpaqueFDExportInfo* ToAPI(SharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline const SharedFenceVkSemaphoreOpaqueFDExportInfo* FromAPI(const WGPUSharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline SharedFenceVkSemaphoreOpaqueFDExportInfo* FromAPI(WGPUSharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceVkSemaphoreOpaqueFDExportInfo* ToCppAPI(const SharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceVkSemaphoreOpaqueFDExportInfo* ToCppAPI(SharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline const SharedFenceVkSemaphoreOpaqueFDExportInfo* FromCppAPI(const wgpu::SharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }
    inline SharedFenceVkSemaphoreOpaqueFDExportInfo* FromCppAPI(wgpu::SharedFenceVkSemaphoreOpaqueFDExportInfo* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreOpaqueFDExportInfo*>(rhs);
    }

    inline const WGPUSharedFenceVkSemaphoreZirconHandleDescriptor* ToAPI(const SharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline WGPUSharedFenceVkSemaphoreZirconHandleDescriptor* ToAPI(SharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline const SharedFenceVkSemaphoreZirconHandleDescriptor* FromAPI(const WGPUSharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline SharedFenceVkSemaphoreZirconHandleDescriptor* FromAPI(WGPUSharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceVkSemaphoreZirconHandleDescriptor* ToCppAPI(const SharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceVkSemaphoreZirconHandleDescriptor* ToCppAPI(SharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline const SharedFenceVkSemaphoreZirconHandleDescriptor* FromCppAPI(const wgpu::SharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }
    inline SharedFenceVkSemaphoreZirconHandleDescriptor* FromCppAPI(wgpu::SharedFenceVkSemaphoreZirconHandleDescriptor* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreZirconHandleDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceVkSemaphoreZirconHandleExportInfo* ToAPI(const SharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline WGPUSharedFenceVkSemaphoreZirconHandleExportInfo* ToAPI(SharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline const SharedFenceVkSemaphoreZirconHandleExportInfo* FromAPI(const WGPUSharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline SharedFenceVkSemaphoreZirconHandleExportInfo* FromAPI(WGPUSharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceVkSemaphoreZirconHandleExportInfo* ToCppAPI(const SharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceVkSemaphoreZirconHandleExportInfo* ToCppAPI(SharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline const SharedFenceVkSemaphoreZirconHandleExportInfo* FromCppAPI(const wgpu::SharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }
    inline SharedFenceVkSemaphoreZirconHandleExportInfo* FromCppAPI(wgpu::SharedFenceVkSemaphoreZirconHandleExportInfo* rhs) {
        return reinterpret_cast<SharedFenceVkSemaphoreZirconHandleExportInfo*>(rhs);
    }

    inline const WGPUSharedTextureMemoryAHardwareBufferDescriptor* ToAPI(const SharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryAHardwareBufferDescriptor* ToAPI(SharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryAHardwareBufferDescriptor* FromAPI(const WGPUSharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline SharedTextureMemoryAHardwareBufferDescriptor* FromAPI(WGPUSharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryAHardwareBufferDescriptor* ToCppAPI(const SharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryAHardwareBufferDescriptor* ToCppAPI(SharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryAHardwareBufferDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }
    inline SharedTextureMemoryAHardwareBufferDescriptor* FromCppAPI(wgpu::SharedTextureMemoryAHardwareBufferDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryAHardwareBufferDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryD3D11BeginState* ToAPI(const SharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline WGPUSharedTextureMemoryD3D11BeginState* ToAPI(SharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline const SharedTextureMemoryD3D11BeginState* FromAPI(const WGPUSharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline SharedTextureMemoryD3D11BeginState* FromAPI(WGPUSharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<SharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryD3D11BeginState* ToCppAPI(const SharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline wgpu::SharedTextureMemoryD3D11BeginState* ToCppAPI(SharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline const SharedTextureMemoryD3D11BeginState* FromCppAPI(const wgpu::SharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryD3D11BeginState*>(rhs);
    }
    inline SharedTextureMemoryD3D11BeginState* FromCppAPI(wgpu::SharedTextureMemoryD3D11BeginState* rhs) {
        return reinterpret_cast<SharedTextureMemoryD3D11BeginState*>(rhs);
    }

    inline const WGPUSharedTextureMemoryD3DSwapchainBeginState* ToAPI(const SharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline WGPUSharedTextureMemoryD3DSwapchainBeginState* ToAPI(SharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline const SharedTextureMemoryD3DSwapchainBeginState* FromAPI(const WGPUSharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline SharedTextureMemoryD3DSwapchainBeginState* FromAPI(WGPUSharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<SharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryD3DSwapchainBeginState* ToCppAPI(const SharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline wgpu::SharedTextureMemoryD3DSwapchainBeginState* ToCppAPI(SharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline const SharedTextureMemoryD3DSwapchainBeginState* FromCppAPI(const wgpu::SharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }
    inline SharedTextureMemoryD3DSwapchainBeginState* FromCppAPI(wgpu::SharedTextureMemoryD3DSwapchainBeginState* rhs) {
        return reinterpret_cast<SharedTextureMemoryD3DSwapchainBeginState*>(rhs);
    }

    inline const WGPUSharedTextureMemoryDmaBufPlane* ToAPI(const SharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline WGPUSharedTextureMemoryDmaBufPlane* ToAPI(SharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline const SharedTextureMemoryDmaBufPlane* FromAPI(const WGPUSharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline SharedTextureMemoryDmaBufPlane* FromAPI(WGPUSharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<SharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryDmaBufPlane* ToCppAPI(const SharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline wgpu::SharedTextureMemoryDmaBufPlane* ToCppAPI(SharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline const SharedTextureMemoryDmaBufPlane* FromCppAPI(const wgpu::SharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDmaBufPlane*>(rhs);
    }
    inline SharedTextureMemoryDmaBufPlane* FromCppAPI(wgpu::SharedTextureMemoryDmaBufPlane* rhs) {
        return reinterpret_cast<SharedTextureMemoryDmaBufPlane*>(rhs);
    }

    inline const WGPUSharedTextureMemoryDXGISharedHandleDescriptor* ToAPI(const SharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryDXGISharedHandleDescriptor* ToAPI(SharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryDXGISharedHandleDescriptor* FromAPI(const WGPUSharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline SharedTextureMemoryDXGISharedHandleDescriptor* FromAPI(WGPUSharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryDXGISharedHandleDescriptor* ToCppAPI(const SharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryDXGISharedHandleDescriptor* ToCppAPI(SharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryDXGISharedHandleDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }
    inline SharedTextureMemoryDXGISharedHandleDescriptor* FromCppAPI(wgpu::SharedTextureMemoryDXGISharedHandleDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryDXGISharedHandleDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryEGLImageDescriptor* ToAPI(const SharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryEGLImageDescriptor* ToAPI(SharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryEGLImageDescriptor* FromAPI(const WGPUSharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline SharedTextureMemoryEGLImageDescriptor* FromAPI(WGPUSharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryEGLImageDescriptor* ToCppAPI(const SharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryEGLImageDescriptor* ToCppAPI(SharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryEGLImageDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryEGLImageDescriptor*>(rhs);
    }
    inline SharedTextureMemoryEGLImageDescriptor* FromCppAPI(wgpu::SharedTextureMemoryEGLImageDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryEGLImageDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryIOSurfaceDescriptor* ToAPI(const SharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryIOSurfaceDescriptor* ToAPI(SharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryIOSurfaceDescriptor* FromAPI(const WGPUSharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline SharedTextureMemoryIOSurfaceDescriptor* FromAPI(WGPUSharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryIOSurfaceDescriptor* ToCppAPI(const SharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryIOSurfaceDescriptor* ToCppAPI(SharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryIOSurfaceDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }
    inline SharedTextureMemoryIOSurfaceDescriptor* FromCppAPI(wgpu::SharedTextureMemoryIOSurfaceDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryIOSurfaceDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryOpaqueFDDescriptor* ToAPI(const SharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryOpaqueFDDescriptor* ToAPI(SharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryOpaqueFDDescriptor* FromAPI(const WGPUSharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline SharedTextureMemoryOpaqueFDDescriptor* FromAPI(WGPUSharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryOpaqueFDDescriptor* ToCppAPI(const SharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryOpaqueFDDescriptor* ToCppAPI(SharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryOpaqueFDDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }
    inline SharedTextureMemoryOpaqueFDDescriptor* FromCppAPI(wgpu::SharedTextureMemoryOpaqueFDDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryOpaqueFDDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryVkDedicatedAllocationDescriptor* ToAPI(const SharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryVkDedicatedAllocationDescriptor* ToAPI(SharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryVkDedicatedAllocationDescriptor* FromAPI(const WGPUSharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline SharedTextureMemoryVkDedicatedAllocationDescriptor* FromAPI(WGPUSharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryVkDedicatedAllocationDescriptor* ToCppAPI(const SharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryVkDedicatedAllocationDescriptor* ToCppAPI(SharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryVkDedicatedAllocationDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }
    inline SharedTextureMemoryVkDedicatedAllocationDescriptor* FromCppAPI(wgpu::SharedTextureMemoryVkDedicatedAllocationDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryVkDedicatedAllocationDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryVkImageLayoutBeginState* ToAPI(const SharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline WGPUSharedTextureMemoryVkImageLayoutBeginState* ToAPI(SharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline const SharedTextureMemoryVkImageLayoutBeginState* FromAPI(const WGPUSharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline SharedTextureMemoryVkImageLayoutBeginState* FromAPI(WGPUSharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<SharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryVkImageLayoutBeginState* ToCppAPI(const SharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline wgpu::SharedTextureMemoryVkImageLayoutBeginState* ToCppAPI(SharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline const SharedTextureMemoryVkImageLayoutBeginState* FromCppAPI(const wgpu::SharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }
    inline SharedTextureMemoryVkImageLayoutBeginState* FromCppAPI(wgpu::SharedTextureMemoryVkImageLayoutBeginState* rhs) {
        return reinterpret_cast<SharedTextureMemoryVkImageLayoutBeginState*>(rhs);
    }

    inline const WGPUSharedTextureMemoryVkImageLayoutEndState* ToAPI(const SharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline WGPUSharedTextureMemoryVkImageLayoutEndState* ToAPI(SharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline const SharedTextureMemoryVkImageLayoutEndState* FromAPI(const WGPUSharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline SharedTextureMemoryVkImageLayoutEndState* FromAPI(WGPUSharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<SharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryVkImageLayoutEndState* ToCppAPI(const SharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline wgpu::SharedTextureMemoryVkImageLayoutEndState* ToCppAPI(SharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline const SharedTextureMemoryVkImageLayoutEndState* FromCppAPI(const wgpu::SharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }
    inline SharedTextureMemoryVkImageLayoutEndState* FromCppAPI(wgpu::SharedTextureMemoryVkImageLayoutEndState* rhs) {
        return reinterpret_cast<SharedTextureMemoryVkImageLayoutEndState*>(rhs);
    }

    inline const WGPUSharedTextureMemoryZirconHandleDescriptor* ToAPI(const SharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryZirconHandleDescriptor* ToAPI(SharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryZirconHandleDescriptor* FromAPI(const WGPUSharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline SharedTextureMemoryZirconHandleDescriptor* FromAPI(WGPUSharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryZirconHandleDescriptor* ToCppAPI(const SharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryZirconHandleDescriptor* ToCppAPI(SharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryZirconHandleDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }
    inline SharedTextureMemoryZirconHandleDescriptor* FromCppAPI(wgpu::SharedTextureMemoryZirconHandleDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryZirconHandleDescriptor*>(rhs);
    }

    inline const WGPUStaticSamplerBindingLayout* ToAPI(const StaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<const WGPUStaticSamplerBindingLayout*>(rhs);
    }
    inline WGPUStaticSamplerBindingLayout* ToAPI(StaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<WGPUStaticSamplerBindingLayout*>(rhs);
    }
    inline const StaticSamplerBindingLayout* FromAPI(const WGPUStaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<const StaticSamplerBindingLayout*>(rhs);
    }
    inline StaticSamplerBindingLayout* FromAPI(WGPUStaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<StaticSamplerBindingLayout*>(rhs);
    }
    inline const wgpu::StaticSamplerBindingLayout* ToCppAPI(const StaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::StaticSamplerBindingLayout*>(rhs);
    }
    inline wgpu::StaticSamplerBindingLayout* ToCppAPI(StaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<wgpu::StaticSamplerBindingLayout*>(rhs);
    }
    inline const StaticSamplerBindingLayout* FromCppAPI(const wgpu::StaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<const StaticSamplerBindingLayout*>(rhs);
    }
    inline StaticSamplerBindingLayout* FromCppAPI(wgpu::StaticSamplerBindingLayout* rhs) {
        return reinterpret_cast<StaticSamplerBindingLayout*>(rhs);
    }

    inline const WGPUStencilFaceState* ToAPI(const StencilFaceState* rhs) {
        return reinterpret_cast<const WGPUStencilFaceState*>(rhs);
    }
    inline WGPUStencilFaceState* ToAPI(StencilFaceState* rhs) {
        return reinterpret_cast<WGPUStencilFaceState*>(rhs);
    }
    inline const StencilFaceState* FromAPI(const WGPUStencilFaceState* rhs) {
        return reinterpret_cast<const StencilFaceState*>(rhs);
    }
    inline StencilFaceState* FromAPI(WGPUStencilFaceState* rhs) {
        return reinterpret_cast<StencilFaceState*>(rhs);
    }
    inline const wgpu::StencilFaceState* ToCppAPI(const StencilFaceState* rhs) {
        return reinterpret_cast<const wgpu::StencilFaceState*>(rhs);
    }
    inline wgpu::StencilFaceState* ToCppAPI(StencilFaceState* rhs) {
        return reinterpret_cast<wgpu::StencilFaceState*>(rhs);
    }
    inline const StencilFaceState* FromCppAPI(const wgpu::StencilFaceState* rhs) {
        return reinterpret_cast<const StencilFaceState*>(rhs);
    }
    inline StencilFaceState* FromCppAPI(wgpu::StencilFaceState* rhs) {
        return reinterpret_cast<StencilFaceState*>(rhs);
    }

    inline const WGPUStorageTextureBindingLayout* ToAPI(const StorageTextureBindingLayout* rhs) {
        return reinterpret_cast<const WGPUStorageTextureBindingLayout*>(rhs);
    }
    inline WGPUStorageTextureBindingLayout* ToAPI(StorageTextureBindingLayout* rhs) {
        return reinterpret_cast<WGPUStorageTextureBindingLayout*>(rhs);
    }
    inline const StorageTextureBindingLayout* FromAPI(const WGPUStorageTextureBindingLayout* rhs) {
        return reinterpret_cast<const StorageTextureBindingLayout*>(rhs);
    }
    inline StorageTextureBindingLayout* FromAPI(WGPUStorageTextureBindingLayout* rhs) {
        return reinterpret_cast<StorageTextureBindingLayout*>(rhs);
    }
    inline const wgpu::StorageTextureBindingLayout* ToCppAPI(const StorageTextureBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::StorageTextureBindingLayout*>(rhs);
    }
    inline wgpu::StorageTextureBindingLayout* ToCppAPI(StorageTextureBindingLayout* rhs) {
        return reinterpret_cast<wgpu::StorageTextureBindingLayout*>(rhs);
    }
    inline const StorageTextureBindingLayout* FromCppAPI(const wgpu::StorageTextureBindingLayout* rhs) {
        return reinterpret_cast<const StorageTextureBindingLayout*>(rhs);
    }
    inline StorageTextureBindingLayout* FromCppAPI(wgpu::StorageTextureBindingLayout* rhs) {
        return reinterpret_cast<StorageTextureBindingLayout*>(rhs);
    }

    inline const WGPUSubgroupMatrixConfig* ToAPI(const SubgroupMatrixConfig* rhs) {
        return reinterpret_cast<const WGPUSubgroupMatrixConfig*>(rhs);
    }
    inline WGPUSubgroupMatrixConfig* ToAPI(SubgroupMatrixConfig* rhs) {
        return reinterpret_cast<WGPUSubgroupMatrixConfig*>(rhs);
    }
    inline const SubgroupMatrixConfig* FromAPI(const WGPUSubgroupMatrixConfig* rhs) {
        return reinterpret_cast<const SubgroupMatrixConfig*>(rhs);
    }
    inline SubgroupMatrixConfig* FromAPI(WGPUSubgroupMatrixConfig* rhs) {
        return reinterpret_cast<SubgroupMatrixConfig*>(rhs);
    }
    inline const wgpu::SubgroupMatrixConfig* ToCppAPI(const SubgroupMatrixConfig* rhs) {
        return reinterpret_cast<const wgpu::SubgroupMatrixConfig*>(rhs);
    }
    inline wgpu::SubgroupMatrixConfig* ToCppAPI(SubgroupMatrixConfig* rhs) {
        return reinterpret_cast<wgpu::SubgroupMatrixConfig*>(rhs);
    }
    inline const SubgroupMatrixConfig* FromCppAPI(const wgpu::SubgroupMatrixConfig* rhs) {
        return reinterpret_cast<const SubgroupMatrixConfig*>(rhs);
    }
    inline SubgroupMatrixConfig* FromCppAPI(wgpu::SubgroupMatrixConfig* rhs) {
        return reinterpret_cast<SubgroupMatrixConfig*>(rhs);
    }

    inline const WGPUSupportedFeatures* ToAPI(const SupportedFeatures* rhs) {
        return reinterpret_cast<const WGPUSupportedFeatures*>(rhs);
    }
    inline WGPUSupportedFeatures* ToAPI(SupportedFeatures* rhs) {
        return reinterpret_cast<WGPUSupportedFeatures*>(rhs);
    }
    inline const SupportedFeatures* FromAPI(const WGPUSupportedFeatures* rhs) {
        return reinterpret_cast<const SupportedFeatures*>(rhs);
    }
    inline SupportedFeatures* FromAPI(WGPUSupportedFeatures* rhs) {
        return reinterpret_cast<SupportedFeatures*>(rhs);
    }
    inline const wgpu::SupportedFeatures* ToCppAPI(const SupportedFeatures* rhs) {
        return reinterpret_cast<const wgpu::SupportedFeatures*>(rhs);
    }
    inline wgpu::SupportedFeatures* ToCppAPI(SupportedFeatures* rhs) {
        return reinterpret_cast<wgpu::SupportedFeatures*>(rhs);
    }
    inline const SupportedFeatures* FromCppAPI(const wgpu::SupportedFeatures* rhs) {
        return reinterpret_cast<const SupportedFeatures*>(rhs);
    }
    inline SupportedFeatures* FromCppAPI(wgpu::SupportedFeatures* rhs) {
        return reinterpret_cast<SupportedFeatures*>(rhs);
    }

    inline const WGPUSupportedInstanceFeatures* ToAPI(const SupportedInstanceFeatures* rhs) {
        return reinterpret_cast<const WGPUSupportedInstanceFeatures*>(rhs);
    }
    inline WGPUSupportedInstanceFeatures* ToAPI(SupportedInstanceFeatures* rhs) {
        return reinterpret_cast<WGPUSupportedInstanceFeatures*>(rhs);
    }
    inline const SupportedInstanceFeatures* FromAPI(const WGPUSupportedInstanceFeatures* rhs) {
        return reinterpret_cast<const SupportedInstanceFeatures*>(rhs);
    }
    inline SupportedInstanceFeatures* FromAPI(WGPUSupportedInstanceFeatures* rhs) {
        return reinterpret_cast<SupportedInstanceFeatures*>(rhs);
    }
    inline const wgpu::SupportedInstanceFeatures* ToCppAPI(const SupportedInstanceFeatures* rhs) {
        return reinterpret_cast<const wgpu::SupportedInstanceFeatures*>(rhs);
    }
    inline wgpu::SupportedInstanceFeatures* ToCppAPI(SupportedInstanceFeatures* rhs) {
        return reinterpret_cast<wgpu::SupportedInstanceFeatures*>(rhs);
    }
    inline const SupportedInstanceFeatures* FromCppAPI(const wgpu::SupportedInstanceFeatures* rhs) {
        return reinterpret_cast<const SupportedInstanceFeatures*>(rhs);
    }
    inline SupportedInstanceFeatures* FromCppAPI(wgpu::SupportedInstanceFeatures* rhs) {
        return reinterpret_cast<SupportedInstanceFeatures*>(rhs);
    }

    inline const WGPUSupportedWGSLLanguageFeatures* ToAPI(const SupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<const WGPUSupportedWGSLLanguageFeatures*>(rhs);
    }
    inline WGPUSupportedWGSLLanguageFeatures* ToAPI(SupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<WGPUSupportedWGSLLanguageFeatures*>(rhs);
    }
    inline const SupportedWGSLLanguageFeatures* FromAPI(const WGPUSupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<const SupportedWGSLLanguageFeatures*>(rhs);
    }
    inline SupportedWGSLLanguageFeatures* FromAPI(WGPUSupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<SupportedWGSLLanguageFeatures*>(rhs);
    }
    inline const wgpu::SupportedWGSLLanguageFeatures* ToCppAPI(const SupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<const wgpu::SupportedWGSLLanguageFeatures*>(rhs);
    }
    inline wgpu::SupportedWGSLLanguageFeatures* ToCppAPI(SupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<wgpu::SupportedWGSLLanguageFeatures*>(rhs);
    }
    inline const SupportedWGSLLanguageFeatures* FromCppAPI(const wgpu::SupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<const SupportedWGSLLanguageFeatures*>(rhs);
    }
    inline SupportedWGSLLanguageFeatures* FromCppAPI(wgpu::SupportedWGSLLanguageFeatures* rhs) {
        return reinterpret_cast<SupportedWGSLLanguageFeatures*>(rhs);
    }

    inline const WGPUSurfaceCapabilities* ToAPI(const SurfaceCapabilities* rhs) {
        return reinterpret_cast<const WGPUSurfaceCapabilities*>(rhs);
    }
    inline WGPUSurfaceCapabilities* ToAPI(SurfaceCapabilities* rhs) {
        return reinterpret_cast<WGPUSurfaceCapabilities*>(rhs);
    }
    inline const SurfaceCapabilities* FromAPI(const WGPUSurfaceCapabilities* rhs) {
        return reinterpret_cast<const SurfaceCapabilities*>(rhs);
    }
    inline SurfaceCapabilities* FromAPI(WGPUSurfaceCapabilities* rhs) {
        return reinterpret_cast<SurfaceCapabilities*>(rhs);
    }
    inline const wgpu::SurfaceCapabilities* ToCppAPI(const SurfaceCapabilities* rhs) {
        return reinterpret_cast<const wgpu::SurfaceCapabilities*>(rhs);
    }
    inline wgpu::SurfaceCapabilities* ToCppAPI(SurfaceCapabilities* rhs) {
        return reinterpret_cast<wgpu::SurfaceCapabilities*>(rhs);
    }
    inline const SurfaceCapabilities* FromCppAPI(const wgpu::SurfaceCapabilities* rhs) {
        return reinterpret_cast<const SurfaceCapabilities*>(rhs);
    }
    inline SurfaceCapabilities* FromCppAPI(wgpu::SurfaceCapabilities* rhs) {
        return reinterpret_cast<SurfaceCapabilities*>(rhs);
    }

    inline const WGPUSurfaceColorManagement* ToAPI(const SurfaceColorManagement* rhs) {
        return reinterpret_cast<const WGPUSurfaceColorManagement*>(rhs);
    }
    inline WGPUSurfaceColorManagement* ToAPI(SurfaceColorManagement* rhs) {
        return reinterpret_cast<WGPUSurfaceColorManagement*>(rhs);
    }
    inline const SurfaceColorManagement* FromAPI(const WGPUSurfaceColorManagement* rhs) {
        return reinterpret_cast<const SurfaceColorManagement*>(rhs);
    }
    inline SurfaceColorManagement* FromAPI(WGPUSurfaceColorManagement* rhs) {
        return reinterpret_cast<SurfaceColorManagement*>(rhs);
    }
    inline const wgpu::SurfaceColorManagement* ToCppAPI(const SurfaceColorManagement* rhs) {
        return reinterpret_cast<const wgpu::SurfaceColorManagement*>(rhs);
    }
    inline wgpu::SurfaceColorManagement* ToCppAPI(SurfaceColorManagement* rhs) {
        return reinterpret_cast<wgpu::SurfaceColorManagement*>(rhs);
    }
    inline const SurfaceColorManagement* FromCppAPI(const wgpu::SurfaceColorManagement* rhs) {
        return reinterpret_cast<const SurfaceColorManagement*>(rhs);
    }
    inline SurfaceColorManagement* FromCppAPI(wgpu::SurfaceColorManagement* rhs) {
        return reinterpret_cast<SurfaceColorManagement*>(rhs);
    }

    inline const WGPUSurfaceConfiguration* ToAPI(const SurfaceConfiguration* rhs) {
        return reinterpret_cast<const WGPUSurfaceConfiguration*>(rhs);
    }
    inline WGPUSurfaceConfiguration* ToAPI(SurfaceConfiguration* rhs) {
        return reinterpret_cast<WGPUSurfaceConfiguration*>(rhs);
    }
    inline const SurfaceConfiguration* FromAPI(const WGPUSurfaceConfiguration* rhs) {
        return reinterpret_cast<const SurfaceConfiguration*>(rhs);
    }
    inline SurfaceConfiguration* FromAPI(WGPUSurfaceConfiguration* rhs) {
        return reinterpret_cast<SurfaceConfiguration*>(rhs);
    }
    inline const wgpu::SurfaceConfiguration* ToCppAPI(const SurfaceConfiguration* rhs) {
        return reinterpret_cast<const wgpu::SurfaceConfiguration*>(rhs);
    }
    inline wgpu::SurfaceConfiguration* ToCppAPI(SurfaceConfiguration* rhs) {
        return reinterpret_cast<wgpu::SurfaceConfiguration*>(rhs);
    }
    inline const SurfaceConfiguration* FromCppAPI(const wgpu::SurfaceConfiguration* rhs) {
        return reinterpret_cast<const SurfaceConfiguration*>(rhs);
    }
    inline SurfaceConfiguration* FromCppAPI(wgpu::SurfaceConfiguration* rhs) {
        return reinterpret_cast<SurfaceConfiguration*>(rhs);
    }

    inline const WGPUSurfaceDescriptorFromWindowsCoreWindow* ToAPI(const SurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<const WGPUSurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline WGPUSurfaceDescriptorFromWindowsCoreWindow* ToAPI(SurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<WGPUSurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline const SurfaceDescriptorFromWindowsCoreWindow* FromAPI(const WGPUSurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<const SurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline SurfaceDescriptorFromWindowsCoreWindow* FromAPI(WGPUSurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<SurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline const wgpu::SurfaceDescriptorFromWindowsCoreWindow* ToCppAPI(const SurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<const wgpu::SurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline wgpu::SurfaceDescriptorFromWindowsCoreWindow* ToCppAPI(SurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<wgpu::SurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline const SurfaceDescriptorFromWindowsCoreWindow* FromCppAPI(const wgpu::SurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<const SurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }
    inline SurfaceDescriptorFromWindowsCoreWindow* FromCppAPI(wgpu::SurfaceDescriptorFromWindowsCoreWindow* rhs) {
        return reinterpret_cast<SurfaceDescriptorFromWindowsCoreWindow*>(rhs);
    }

    inline const WGPUSurfaceDescriptorFromWindowsUWPSwapChainPanel* ToAPI(const SurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<const WGPUSurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline WGPUSurfaceDescriptorFromWindowsUWPSwapChainPanel* ToAPI(SurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<WGPUSurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline const SurfaceDescriptorFromWindowsUWPSwapChainPanel* FromAPI(const WGPUSurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<const SurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline SurfaceDescriptorFromWindowsUWPSwapChainPanel* FromAPI(WGPUSurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<SurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline const wgpu::SurfaceDescriptorFromWindowsUWPSwapChainPanel* ToCppAPI(const SurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<const wgpu::SurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline wgpu::SurfaceDescriptorFromWindowsUWPSwapChainPanel* ToCppAPI(SurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<wgpu::SurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline const SurfaceDescriptorFromWindowsUWPSwapChainPanel* FromCppAPI(const wgpu::SurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<const SurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }
    inline SurfaceDescriptorFromWindowsUWPSwapChainPanel* FromCppAPI(wgpu::SurfaceDescriptorFromWindowsUWPSwapChainPanel* rhs) {
        return reinterpret_cast<SurfaceDescriptorFromWindowsUWPSwapChainPanel*>(rhs);
    }

    inline const WGPUSurfaceDescriptorFromWindowsWinUISwapChainPanel* ToAPI(const SurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<const WGPUSurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline WGPUSurfaceDescriptorFromWindowsWinUISwapChainPanel* ToAPI(SurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<WGPUSurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline const SurfaceDescriptorFromWindowsWinUISwapChainPanel* FromAPI(const WGPUSurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<const SurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline SurfaceDescriptorFromWindowsWinUISwapChainPanel* FromAPI(WGPUSurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<SurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline const wgpu::SurfaceDescriptorFromWindowsWinUISwapChainPanel* ToCppAPI(const SurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<const wgpu::SurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline wgpu::SurfaceDescriptorFromWindowsWinUISwapChainPanel* ToCppAPI(SurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<wgpu::SurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline const SurfaceDescriptorFromWindowsWinUISwapChainPanel* FromCppAPI(const wgpu::SurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<const SurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }
    inline SurfaceDescriptorFromWindowsWinUISwapChainPanel* FromCppAPI(wgpu::SurfaceDescriptorFromWindowsWinUISwapChainPanel* rhs) {
        return reinterpret_cast<SurfaceDescriptorFromWindowsWinUISwapChainPanel*>(rhs);
    }

    inline const WGPUSurfaceSourceAndroidNativeWindow* ToAPI(const SurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<const WGPUSurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline WGPUSurfaceSourceAndroidNativeWindow* ToAPI(SurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<WGPUSurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline const SurfaceSourceAndroidNativeWindow* FromAPI(const WGPUSurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<const SurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline SurfaceSourceAndroidNativeWindow* FromAPI(WGPUSurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<SurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline const wgpu::SurfaceSourceAndroidNativeWindow* ToCppAPI(const SurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<const wgpu::SurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline wgpu::SurfaceSourceAndroidNativeWindow* ToCppAPI(SurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<wgpu::SurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline const SurfaceSourceAndroidNativeWindow* FromCppAPI(const wgpu::SurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<const SurfaceSourceAndroidNativeWindow*>(rhs);
    }
    inline SurfaceSourceAndroidNativeWindow* FromCppAPI(wgpu::SurfaceSourceAndroidNativeWindow* rhs) {
        return reinterpret_cast<SurfaceSourceAndroidNativeWindow*>(rhs);
    }

    inline const WGPUSurfaceSourceMetalLayer* ToAPI(const SurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<const WGPUSurfaceSourceMetalLayer*>(rhs);
    }
    inline WGPUSurfaceSourceMetalLayer* ToAPI(SurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<WGPUSurfaceSourceMetalLayer*>(rhs);
    }
    inline const SurfaceSourceMetalLayer* FromAPI(const WGPUSurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<const SurfaceSourceMetalLayer*>(rhs);
    }
    inline SurfaceSourceMetalLayer* FromAPI(WGPUSurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<SurfaceSourceMetalLayer*>(rhs);
    }
    inline const wgpu::SurfaceSourceMetalLayer* ToCppAPI(const SurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<const wgpu::SurfaceSourceMetalLayer*>(rhs);
    }
    inline wgpu::SurfaceSourceMetalLayer* ToCppAPI(SurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<wgpu::SurfaceSourceMetalLayer*>(rhs);
    }
    inline const SurfaceSourceMetalLayer* FromCppAPI(const wgpu::SurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<const SurfaceSourceMetalLayer*>(rhs);
    }
    inline SurfaceSourceMetalLayer* FromCppAPI(wgpu::SurfaceSourceMetalLayer* rhs) {
        return reinterpret_cast<SurfaceSourceMetalLayer*>(rhs);
    }

    inline const WGPUSurfaceSourceWaylandSurface* ToAPI(const SurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<const WGPUSurfaceSourceWaylandSurface*>(rhs);
    }
    inline WGPUSurfaceSourceWaylandSurface* ToAPI(SurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<WGPUSurfaceSourceWaylandSurface*>(rhs);
    }
    inline const SurfaceSourceWaylandSurface* FromAPI(const WGPUSurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<const SurfaceSourceWaylandSurface*>(rhs);
    }
    inline SurfaceSourceWaylandSurface* FromAPI(WGPUSurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<SurfaceSourceWaylandSurface*>(rhs);
    }
    inline const wgpu::SurfaceSourceWaylandSurface* ToCppAPI(const SurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<const wgpu::SurfaceSourceWaylandSurface*>(rhs);
    }
    inline wgpu::SurfaceSourceWaylandSurface* ToCppAPI(SurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<wgpu::SurfaceSourceWaylandSurface*>(rhs);
    }
    inline const SurfaceSourceWaylandSurface* FromCppAPI(const wgpu::SurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<const SurfaceSourceWaylandSurface*>(rhs);
    }
    inline SurfaceSourceWaylandSurface* FromCppAPI(wgpu::SurfaceSourceWaylandSurface* rhs) {
        return reinterpret_cast<SurfaceSourceWaylandSurface*>(rhs);
    }

    inline const WGPUSurfaceSourceWindowsHWND* ToAPI(const SurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<const WGPUSurfaceSourceWindowsHWND*>(rhs);
    }
    inline WGPUSurfaceSourceWindowsHWND* ToAPI(SurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<WGPUSurfaceSourceWindowsHWND*>(rhs);
    }
    inline const SurfaceSourceWindowsHWND* FromAPI(const WGPUSurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<const SurfaceSourceWindowsHWND*>(rhs);
    }
    inline SurfaceSourceWindowsHWND* FromAPI(WGPUSurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<SurfaceSourceWindowsHWND*>(rhs);
    }
    inline const wgpu::SurfaceSourceWindowsHWND* ToCppAPI(const SurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<const wgpu::SurfaceSourceWindowsHWND*>(rhs);
    }
    inline wgpu::SurfaceSourceWindowsHWND* ToCppAPI(SurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<wgpu::SurfaceSourceWindowsHWND*>(rhs);
    }
    inline const SurfaceSourceWindowsHWND* FromCppAPI(const wgpu::SurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<const SurfaceSourceWindowsHWND*>(rhs);
    }
    inline SurfaceSourceWindowsHWND* FromCppAPI(wgpu::SurfaceSourceWindowsHWND* rhs) {
        return reinterpret_cast<SurfaceSourceWindowsHWND*>(rhs);
    }

    inline const WGPUSurfaceSourceXCBWindow* ToAPI(const SurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<const WGPUSurfaceSourceXCBWindow*>(rhs);
    }
    inline WGPUSurfaceSourceXCBWindow* ToAPI(SurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<WGPUSurfaceSourceXCBWindow*>(rhs);
    }
    inline const SurfaceSourceXCBWindow* FromAPI(const WGPUSurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<const SurfaceSourceXCBWindow*>(rhs);
    }
    inline SurfaceSourceXCBWindow* FromAPI(WGPUSurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<SurfaceSourceXCBWindow*>(rhs);
    }
    inline const wgpu::SurfaceSourceXCBWindow* ToCppAPI(const SurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<const wgpu::SurfaceSourceXCBWindow*>(rhs);
    }
    inline wgpu::SurfaceSourceXCBWindow* ToCppAPI(SurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<wgpu::SurfaceSourceXCBWindow*>(rhs);
    }
    inline const SurfaceSourceXCBWindow* FromCppAPI(const wgpu::SurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<const SurfaceSourceXCBWindow*>(rhs);
    }
    inline SurfaceSourceXCBWindow* FromCppAPI(wgpu::SurfaceSourceXCBWindow* rhs) {
        return reinterpret_cast<SurfaceSourceXCBWindow*>(rhs);
    }

    inline const WGPUSurfaceSourceXlibWindow* ToAPI(const SurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<const WGPUSurfaceSourceXlibWindow*>(rhs);
    }
    inline WGPUSurfaceSourceXlibWindow* ToAPI(SurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<WGPUSurfaceSourceXlibWindow*>(rhs);
    }
    inline const SurfaceSourceXlibWindow* FromAPI(const WGPUSurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<const SurfaceSourceXlibWindow*>(rhs);
    }
    inline SurfaceSourceXlibWindow* FromAPI(WGPUSurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<SurfaceSourceXlibWindow*>(rhs);
    }
    inline const wgpu::SurfaceSourceXlibWindow* ToCppAPI(const SurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<const wgpu::SurfaceSourceXlibWindow*>(rhs);
    }
    inline wgpu::SurfaceSourceXlibWindow* ToCppAPI(SurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<wgpu::SurfaceSourceXlibWindow*>(rhs);
    }
    inline const SurfaceSourceXlibWindow* FromCppAPI(const wgpu::SurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<const SurfaceSourceXlibWindow*>(rhs);
    }
    inline SurfaceSourceXlibWindow* FromCppAPI(wgpu::SurfaceSourceXlibWindow* rhs) {
        return reinterpret_cast<SurfaceSourceXlibWindow*>(rhs);
    }

    inline const WGPUSurfaceTexture* ToAPI(const SurfaceTexture* rhs) {
        return reinterpret_cast<const WGPUSurfaceTexture*>(rhs);
    }
    inline WGPUSurfaceTexture* ToAPI(SurfaceTexture* rhs) {
        return reinterpret_cast<WGPUSurfaceTexture*>(rhs);
    }
    inline const SurfaceTexture* FromAPI(const WGPUSurfaceTexture* rhs) {
        return reinterpret_cast<const SurfaceTexture*>(rhs);
    }
    inline SurfaceTexture* FromAPI(WGPUSurfaceTexture* rhs) {
        return reinterpret_cast<SurfaceTexture*>(rhs);
    }
    inline const wgpu::SurfaceTexture* ToCppAPI(const SurfaceTexture* rhs) {
        return reinterpret_cast<const wgpu::SurfaceTexture*>(rhs);
    }
    inline wgpu::SurfaceTexture* ToCppAPI(SurfaceTexture* rhs) {
        return reinterpret_cast<wgpu::SurfaceTexture*>(rhs);
    }
    inline const SurfaceTexture* FromCppAPI(const wgpu::SurfaceTexture* rhs) {
        return reinterpret_cast<const SurfaceTexture*>(rhs);
    }
    inline SurfaceTexture* FromCppAPI(wgpu::SurfaceTexture* rhs) {
        return reinterpret_cast<SurfaceTexture*>(rhs);
    }

    inline const WGPUTexelBufferBindingEntry* ToAPI(const TexelBufferBindingEntry* rhs) {
        return reinterpret_cast<const WGPUTexelBufferBindingEntry*>(rhs);
    }
    inline WGPUTexelBufferBindingEntry* ToAPI(TexelBufferBindingEntry* rhs) {
        return reinterpret_cast<WGPUTexelBufferBindingEntry*>(rhs);
    }
    inline const TexelBufferBindingEntry* FromAPI(const WGPUTexelBufferBindingEntry* rhs) {
        return reinterpret_cast<const TexelBufferBindingEntry*>(rhs);
    }
    inline TexelBufferBindingEntry* FromAPI(WGPUTexelBufferBindingEntry* rhs) {
        return reinterpret_cast<TexelBufferBindingEntry*>(rhs);
    }
    inline const wgpu::TexelBufferBindingEntry* ToCppAPI(const TexelBufferBindingEntry* rhs) {
        return reinterpret_cast<const wgpu::TexelBufferBindingEntry*>(rhs);
    }
    inline wgpu::TexelBufferBindingEntry* ToCppAPI(TexelBufferBindingEntry* rhs) {
        return reinterpret_cast<wgpu::TexelBufferBindingEntry*>(rhs);
    }
    inline const TexelBufferBindingEntry* FromCppAPI(const wgpu::TexelBufferBindingEntry* rhs) {
        return reinterpret_cast<const TexelBufferBindingEntry*>(rhs);
    }
    inline TexelBufferBindingEntry* FromCppAPI(wgpu::TexelBufferBindingEntry* rhs) {
        return reinterpret_cast<TexelBufferBindingEntry*>(rhs);
    }

    inline const WGPUTexelBufferBindingLayout* ToAPI(const TexelBufferBindingLayout* rhs) {
        return reinterpret_cast<const WGPUTexelBufferBindingLayout*>(rhs);
    }
    inline WGPUTexelBufferBindingLayout* ToAPI(TexelBufferBindingLayout* rhs) {
        return reinterpret_cast<WGPUTexelBufferBindingLayout*>(rhs);
    }
    inline const TexelBufferBindingLayout* FromAPI(const WGPUTexelBufferBindingLayout* rhs) {
        return reinterpret_cast<const TexelBufferBindingLayout*>(rhs);
    }
    inline TexelBufferBindingLayout* FromAPI(WGPUTexelBufferBindingLayout* rhs) {
        return reinterpret_cast<TexelBufferBindingLayout*>(rhs);
    }
    inline const wgpu::TexelBufferBindingLayout* ToCppAPI(const TexelBufferBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::TexelBufferBindingLayout*>(rhs);
    }
    inline wgpu::TexelBufferBindingLayout* ToCppAPI(TexelBufferBindingLayout* rhs) {
        return reinterpret_cast<wgpu::TexelBufferBindingLayout*>(rhs);
    }
    inline const TexelBufferBindingLayout* FromCppAPI(const wgpu::TexelBufferBindingLayout* rhs) {
        return reinterpret_cast<const TexelBufferBindingLayout*>(rhs);
    }
    inline TexelBufferBindingLayout* FromCppAPI(wgpu::TexelBufferBindingLayout* rhs) {
        return reinterpret_cast<TexelBufferBindingLayout*>(rhs);
    }

    inline const WGPUTexelBufferViewDescriptor* ToAPI(const TexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<const WGPUTexelBufferViewDescriptor*>(rhs);
    }
    inline WGPUTexelBufferViewDescriptor* ToAPI(TexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<WGPUTexelBufferViewDescriptor*>(rhs);
    }
    inline const TexelBufferViewDescriptor* FromAPI(const WGPUTexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<const TexelBufferViewDescriptor*>(rhs);
    }
    inline TexelBufferViewDescriptor* FromAPI(WGPUTexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<TexelBufferViewDescriptor*>(rhs);
    }
    inline const wgpu::TexelBufferViewDescriptor* ToCppAPI(const TexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<const wgpu::TexelBufferViewDescriptor*>(rhs);
    }
    inline wgpu::TexelBufferViewDescriptor* ToCppAPI(TexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<wgpu::TexelBufferViewDescriptor*>(rhs);
    }
    inline const TexelBufferViewDescriptor* FromCppAPI(const wgpu::TexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<const TexelBufferViewDescriptor*>(rhs);
    }
    inline TexelBufferViewDescriptor* FromCppAPI(wgpu::TexelBufferViewDescriptor* rhs) {
        return reinterpret_cast<TexelBufferViewDescriptor*>(rhs);
    }

    inline const WGPUTexelCopyBufferLayout* ToAPI(const TexelCopyBufferLayout* rhs) {
        return reinterpret_cast<const WGPUTexelCopyBufferLayout*>(rhs);
    }
    inline WGPUTexelCopyBufferLayout* ToAPI(TexelCopyBufferLayout* rhs) {
        return reinterpret_cast<WGPUTexelCopyBufferLayout*>(rhs);
    }
    inline const TexelCopyBufferLayout* FromAPI(const WGPUTexelCopyBufferLayout* rhs) {
        return reinterpret_cast<const TexelCopyBufferLayout*>(rhs);
    }
    inline TexelCopyBufferLayout* FromAPI(WGPUTexelCopyBufferLayout* rhs) {
        return reinterpret_cast<TexelCopyBufferLayout*>(rhs);
    }
    inline const wgpu::TexelCopyBufferLayout* ToCppAPI(const TexelCopyBufferLayout* rhs) {
        return reinterpret_cast<const wgpu::TexelCopyBufferLayout*>(rhs);
    }
    inline wgpu::TexelCopyBufferLayout* ToCppAPI(TexelCopyBufferLayout* rhs) {
        return reinterpret_cast<wgpu::TexelCopyBufferLayout*>(rhs);
    }
    inline const TexelCopyBufferLayout* FromCppAPI(const wgpu::TexelCopyBufferLayout* rhs) {
        return reinterpret_cast<const TexelCopyBufferLayout*>(rhs);
    }
    inline TexelCopyBufferLayout* FromCppAPI(wgpu::TexelCopyBufferLayout* rhs) {
        return reinterpret_cast<TexelCopyBufferLayout*>(rhs);
    }

    inline const WGPUTextureBindingLayout* ToAPI(const TextureBindingLayout* rhs) {
        return reinterpret_cast<const WGPUTextureBindingLayout*>(rhs);
    }
    inline WGPUTextureBindingLayout* ToAPI(TextureBindingLayout* rhs) {
        return reinterpret_cast<WGPUTextureBindingLayout*>(rhs);
    }
    inline const TextureBindingLayout* FromAPI(const WGPUTextureBindingLayout* rhs) {
        return reinterpret_cast<const TextureBindingLayout*>(rhs);
    }
    inline TextureBindingLayout* FromAPI(WGPUTextureBindingLayout* rhs) {
        return reinterpret_cast<TextureBindingLayout*>(rhs);
    }
    inline const wgpu::TextureBindingLayout* ToCppAPI(const TextureBindingLayout* rhs) {
        return reinterpret_cast<const wgpu::TextureBindingLayout*>(rhs);
    }
    inline wgpu::TextureBindingLayout* ToCppAPI(TextureBindingLayout* rhs) {
        return reinterpret_cast<wgpu::TextureBindingLayout*>(rhs);
    }
    inline const TextureBindingLayout* FromCppAPI(const wgpu::TextureBindingLayout* rhs) {
        return reinterpret_cast<const TextureBindingLayout*>(rhs);
    }
    inline TextureBindingLayout* FromCppAPI(wgpu::TextureBindingLayout* rhs) {
        return reinterpret_cast<TextureBindingLayout*>(rhs);
    }

    inline const WGPUTextureBindingViewDimensionDescriptor* ToAPI(const TextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<const WGPUTextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline WGPUTextureBindingViewDimensionDescriptor* ToAPI(TextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<WGPUTextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline const TextureBindingViewDimensionDescriptor* FromAPI(const WGPUTextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<const TextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline TextureBindingViewDimensionDescriptor* FromAPI(WGPUTextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<TextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline const wgpu::TextureBindingViewDimensionDescriptor* ToCppAPI(const TextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<const wgpu::TextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline wgpu::TextureBindingViewDimensionDescriptor* ToCppAPI(TextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<wgpu::TextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline const TextureBindingViewDimensionDescriptor* FromCppAPI(const wgpu::TextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<const TextureBindingViewDimensionDescriptor*>(rhs);
    }
    inline TextureBindingViewDimensionDescriptor* FromCppAPI(wgpu::TextureBindingViewDimensionDescriptor* rhs) {
        return reinterpret_cast<TextureBindingViewDimensionDescriptor*>(rhs);
    }

    inline const WGPUTextureComponentSwizzle* ToAPI(const TextureComponentSwizzle* rhs) {
        return reinterpret_cast<const WGPUTextureComponentSwizzle*>(rhs);
    }
    inline WGPUTextureComponentSwizzle* ToAPI(TextureComponentSwizzle* rhs) {
        return reinterpret_cast<WGPUTextureComponentSwizzle*>(rhs);
    }
    inline const TextureComponentSwizzle* FromAPI(const WGPUTextureComponentSwizzle* rhs) {
        return reinterpret_cast<const TextureComponentSwizzle*>(rhs);
    }
    inline TextureComponentSwizzle* FromAPI(WGPUTextureComponentSwizzle* rhs) {
        return reinterpret_cast<TextureComponentSwizzle*>(rhs);
    }
    inline const wgpu::TextureComponentSwizzle* ToCppAPI(const TextureComponentSwizzle* rhs) {
        return reinterpret_cast<const wgpu::TextureComponentSwizzle*>(rhs);
    }
    inline wgpu::TextureComponentSwizzle* ToCppAPI(TextureComponentSwizzle* rhs) {
        return reinterpret_cast<wgpu::TextureComponentSwizzle*>(rhs);
    }
    inline const TextureComponentSwizzle* FromCppAPI(const wgpu::TextureComponentSwizzle* rhs) {
        return reinterpret_cast<const TextureComponentSwizzle*>(rhs);
    }
    inline TextureComponentSwizzle* FromCppAPI(wgpu::TextureComponentSwizzle* rhs) {
        return reinterpret_cast<TextureComponentSwizzle*>(rhs);
    }

    inline const WGPUVertexAttribute* ToAPI(const VertexAttribute* rhs) {
        return reinterpret_cast<const WGPUVertexAttribute*>(rhs);
    }
    inline WGPUVertexAttribute* ToAPI(VertexAttribute* rhs) {
        return reinterpret_cast<WGPUVertexAttribute*>(rhs);
    }
    inline const VertexAttribute* FromAPI(const WGPUVertexAttribute* rhs) {
        return reinterpret_cast<const VertexAttribute*>(rhs);
    }
    inline VertexAttribute* FromAPI(WGPUVertexAttribute* rhs) {
        return reinterpret_cast<VertexAttribute*>(rhs);
    }
    inline const wgpu::VertexAttribute* ToCppAPI(const VertexAttribute* rhs) {
        return reinterpret_cast<const wgpu::VertexAttribute*>(rhs);
    }
    inline wgpu::VertexAttribute* ToCppAPI(VertexAttribute* rhs) {
        return reinterpret_cast<wgpu::VertexAttribute*>(rhs);
    }
    inline const VertexAttribute* FromCppAPI(const wgpu::VertexAttribute* rhs) {
        return reinterpret_cast<const VertexAttribute*>(rhs);
    }
    inline VertexAttribute* FromCppAPI(wgpu::VertexAttribute* rhs) {
        return reinterpret_cast<VertexAttribute*>(rhs);
    }

    inline const WGPUYCbCrVkDescriptor* ToAPI(const YCbCrVkDescriptor* rhs) {
        return reinterpret_cast<const WGPUYCbCrVkDescriptor*>(rhs);
    }
    inline WGPUYCbCrVkDescriptor* ToAPI(YCbCrVkDescriptor* rhs) {
        return reinterpret_cast<WGPUYCbCrVkDescriptor*>(rhs);
    }
    inline const YCbCrVkDescriptor* FromAPI(const WGPUYCbCrVkDescriptor* rhs) {
        return reinterpret_cast<const YCbCrVkDescriptor*>(rhs);
    }
    inline YCbCrVkDescriptor* FromAPI(WGPUYCbCrVkDescriptor* rhs) {
        return reinterpret_cast<YCbCrVkDescriptor*>(rhs);
    }
    inline const wgpu::YCbCrVkDescriptor* ToCppAPI(const YCbCrVkDescriptor* rhs) {
        return reinterpret_cast<const wgpu::YCbCrVkDescriptor*>(rhs);
    }
    inline wgpu::YCbCrVkDescriptor* ToCppAPI(YCbCrVkDescriptor* rhs) {
        return reinterpret_cast<wgpu::YCbCrVkDescriptor*>(rhs);
    }
    inline const YCbCrVkDescriptor* FromCppAPI(const wgpu::YCbCrVkDescriptor* rhs) {
        return reinterpret_cast<const YCbCrVkDescriptor*>(rhs);
    }
    inline YCbCrVkDescriptor* FromCppAPI(wgpu::YCbCrVkDescriptor* rhs) {
        return reinterpret_cast<YCbCrVkDescriptor*>(rhs);
    }

    inline const WGPUAdapterPropertiesMemoryHeaps* ToAPI(const AdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<const WGPUAdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline WGPUAdapterPropertiesMemoryHeaps* ToAPI(AdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<WGPUAdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline const AdapterPropertiesMemoryHeaps* FromAPI(const WGPUAdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<const AdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline AdapterPropertiesMemoryHeaps* FromAPI(WGPUAdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<AdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline const wgpu::AdapterPropertiesMemoryHeaps* ToCppAPI(const AdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<const wgpu::AdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline wgpu::AdapterPropertiesMemoryHeaps* ToCppAPI(AdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<wgpu::AdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline const AdapterPropertiesMemoryHeaps* FromCppAPI(const wgpu::AdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<const AdapterPropertiesMemoryHeaps*>(rhs);
    }
    inline AdapterPropertiesMemoryHeaps* FromCppAPI(wgpu::AdapterPropertiesMemoryHeaps* rhs) {
        return reinterpret_cast<AdapterPropertiesMemoryHeaps*>(rhs);
    }

    inline const WGPUAdapterPropertiesSubgroupMatrixConfigs* ToAPI(const AdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<const WGPUAdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline WGPUAdapterPropertiesSubgroupMatrixConfigs* ToAPI(AdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<WGPUAdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline const AdapterPropertiesSubgroupMatrixConfigs* FromAPI(const WGPUAdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<const AdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline AdapterPropertiesSubgroupMatrixConfigs* FromAPI(WGPUAdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<AdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline const wgpu::AdapterPropertiesSubgroupMatrixConfigs* ToCppAPI(const AdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<const wgpu::AdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline wgpu::AdapterPropertiesSubgroupMatrixConfigs* ToCppAPI(AdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<wgpu::AdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline const AdapterPropertiesSubgroupMatrixConfigs* FromCppAPI(const wgpu::AdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<const AdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }
    inline AdapterPropertiesSubgroupMatrixConfigs* FromCppAPI(wgpu::AdapterPropertiesSubgroupMatrixConfigs* rhs) {
        return reinterpret_cast<AdapterPropertiesSubgroupMatrixConfigs*>(rhs);
    }

    inline const WGPUAHardwareBufferProperties* ToAPI(const AHardwareBufferProperties* rhs) {
        return reinterpret_cast<const WGPUAHardwareBufferProperties*>(rhs);
    }
    inline WGPUAHardwareBufferProperties* ToAPI(AHardwareBufferProperties* rhs) {
        return reinterpret_cast<WGPUAHardwareBufferProperties*>(rhs);
    }
    inline const AHardwareBufferProperties* FromAPI(const WGPUAHardwareBufferProperties* rhs) {
        return reinterpret_cast<const AHardwareBufferProperties*>(rhs);
    }
    inline AHardwareBufferProperties* FromAPI(WGPUAHardwareBufferProperties* rhs) {
        return reinterpret_cast<AHardwareBufferProperties*>(rhs);
    }
    inline const wgpu::AHardwareBufferProperties* ToCppAPI(const AHardwareBufferProperties* rhs) {
        return reinterpret_cast<const wgpu::AHardwareBufferProperties*>(rhs);
    }
    inline wgpu::AHardwareBufferProperties* ToCppAPI(AHardwareBufferProperties* rhs) {
        return reinterpret_cast<wgpu::AHardwareBufferProperties*>(rhs);
    }
    inline const AHardwareBufferProperties* FromCppAPI(const wgpu::AHardwareBufferProperties* rhs) {
        return reinterpret_cast<const AHardwareBufferProperties*>(rhs);
    }
    inline AHardwareBufferProperties* FromCppAPI(wgpu::AHardwareBufferProperties* rhs) {
        return reinterpret_cast<AHardwareBufferProperties*>(rhs);
    }

    inline const WGPUBindGroupEntry* ToAPI(const BindGroupEntry* rhs) {
        return reinterpret_cast<const WGPUBindGroupEntry*>(rhs);
    }
    inline WGPUBindGroupEntry* ToAPI(BindGroupEntry* rhs) {
        return reinterpret_cast<WGPUBindGroupEntry*>(rhs);
    }
    inline const BindGroupEntry* FromAPI(const WGPUBindGroupEntry* rhs) {
        return reinterpret_cast<const BindGroupEntry*>(rhs);
    }
    inline BindGroupEntry* FromAPI(WGPUBindGroupEntry* rhs) {
        return reinterpret_cast<BindGroupEntry*>(rhs);
    }
    inline const wgpu::BindGroupEntry* ToCppAPI(const BindGroupEntry* rhs) {
        return reinterpret_cast<const wgpu::BindGroupEntry*>(rhs);
    }
    inline wgpu::BindGroupEntry* ToCppAPI(BindGroupEntry* rhs) {
        return reinterpret_cast<wgpu::BindGroupEntry*>(rhs);
    }
    inline const BindGroupEntry* FromCppAPI(const wgpu::BindGroupEntry* rhs) {
        return reinterpret_cast<const BindGroupEntry*>(rhs);
    }
    inline BindGroupEntry* FromCppAPI(wgpu::BindGroupEntry* rhs) {
        return reinterpret_cast<BindGroupEntry*>(rhs);
    }

    inline const WGPUBindGroupLayoutDynamicBindingArray* ToAPI(const BindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<const WGPUBindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline WGPUBindGroupLayoutDynamicBindingArray* ToAPI(BindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<WGPUBindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline const BindGroupLayoutDynamicBindingArray* FromAPI(const WGPUBindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<const BindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline BindGroupLayoutDynamicBindingArray* FromAPI(WGPUBindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<BindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline const wgpu::BindGroupLayoutDynamicBindingArray* ToCppAPI(const BindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<const wgpu::BindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline wgpu::BindGroupLayoutDynamicBindingArray* ToCppAPI(BindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<wgpu::BindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline const BindGroupLayoutDynamicBindingArray* FromCppAPI(const wgpu::BindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<const BindGroupLayoutDynamicBindingArray*>(rhs);
    }
    inline BindGroupLayoutDynamicBindingArray* FromCppAPI(wgpu::BindGroupLayoutDynamicBindingArray* rhs) {
        return reinterpret_cast<BindGroupLayoutDynamicBindingArray*>(rhs);
    }

    inline const WGPUBindGroupLayoutEntry* ToAPI(const BindGroupLayoutEntry* rhs) {
        return reinterpret_cast<const WGPUBindGroupLayoutEntry*>(rhs);
    }
    inline WGPUBindGroupLayoutEntry* ToAPI(BindGroupLayoutEntry* rhs) {
        return reinterpret_cast<WGPUBindGroupLayoutEntry*>(rhs);
    }
    inline const BindGroupLayoutEntry* FromAPI(const WGPUBindGroupLayoutEntry* rhs) {
        return reinterpret_cast<const BindGroupLayoutEntry*>(rhs);
    }
    inline BindGroupLayoutEntry* FromAPI(WGPUBindGroupLayoutEntry* rhs) {
        return reinterpret_cast<BindGroupLayoutEntry*>(rhs);
    }
    inline const wgpu::BindGroupLayoutEntry* ToCppAPI(const BindGroupLayoutEntry* rhs) {
        return reinterpret_cast<const wgpu::BindGroupLayoutEntry*>(rhs);
    }
    inline wgpu::BindGroupLayoutEntry* ToCppAPI(BindGroupLayoutEntry* rhs) {
        return reinterpret_cast<wgpu::BindGroupLayoutEntry*>(rhs);
    }
    inline const BindGroupLayoutEntry* FromCppAPI(const wgpu::BindGroupLayoutEntry* rhs) {
        return reinterpret_cast<const BindGroupLayoutEntry*>(rhs);
    }
    inline BindGroupLayoutEntry* FromCppAPI(wgpu::BindGroupLayoutEntry* rhs) {
        return reinterpret_cast<BindGroupLayoutEntry*>(rhs);
    }

    inline const WGPUBlendState* ToAPI(const BlendState* rhs) {
        return reinterpret_cast<const WGPUBlendState*>(rhs);
    }
    inline WGPUBlendState* ToAPI(BlendState* rhs) {
        return reinterpret_cast<WGPUBlendState*>(rhs);
    }
    inline const BlendState* FromAPI(const WGPUBlendState* rhs) {
        return reinterpret_cast<const BlendState*>(rhs);
    }
    inline BlendState* FromAPI(WGPUBlendState* rhs) {
        return reinterpret_cast<BlendState*>(rhs);
    }
    inline const wgpu::BlendState* ToCppAPI(const BlendState* rhs) {
        return reinterpret_cast<const wgpu::BlendState*>(rhs);
    }
    inline wgpu::BlendState* ToCppAPI(BlendState* rhs) {
        return reinterpret_cast<wgpu::BlendState*>(rhs);
    }
    inline const BlendState* FromCppAPI(const wgpu::BlendState* rhs) {
        return reinterpret_cast<const BlendState*>(rhs);
    }
    inline BlendState* FromCppAPI(wgpu::BlendState* rhs) {
        return reinterpret_cast<BlendState*>(rhs);
    }

    inline const WGPUBufferDescriptor* ToAPI(const BufferDescriptor* rhs) {
        return reinterpret_cast<const WGPUBufferDescriptor*>(rhs);
    }
    inline WGPUBufferDescriptor* ToAPI(BufferDescriptor* rhs) {
        return reinterpret_cast<WGPUBufferDescriptor*>(rhs);
    }
    inline const BufferDescriptor* FromAPI(const WGPUBufferDescriptor* rhs) {
        return reinterpret_cast<const BufferDescriptor*>(rhs);
    }
    inline BufferDescriptor* FromAPI(WGPUBufferDescriptor* rhs) {
        return reinterpret_cast<BufferDescriptor*>(rhs);
    }
    inline const wgpu::BufferDescriptor* ToCppAPI(const BufferDescriptor* rhs) {
        return reinterpret_cast<const wgpu::BufferDescriptor*>(rhs);
    }
    inline wgpu::BufferDescriptor* ToCppAPI(BufferDescriptor* rhs) {
        return reinterpret_cast<wgpu::BufferDescriptor*>(rhs);
    }
    inline const BufferDescriptor* FromCppAPI(const wgpu::BufferDescriptor* rhs) {
        return reinterpret_cast<const BufferDescriptor*>(rhs);
    }
    inline BufferDescriptor* FromCppAPI(wgpu::BufferDescriptor* rhs) {
        return reinterpret_cast<BufferDescriptor*>(rhs);
    }

    inline const WGPUCommandEncoderDescriptor* ToAPI(const CommandEncoderDescriptor* rhs) {
        return reinterpret_cast<const WGPUCommandEncoderDescriptor*>(rhs);
    }
    inline WGPUCommandEncoderDescriptor* ToAPI(CommandEncoderDescriptor* rhs) {
        return reinterpret_cast<WGPUCommandEncoderDescriptor*>(rhs);
    }
    inline const CommandEncoderDescriptor* FromAPI(const WGPUCommandEncoderDescriptor* rhs) {
        return reinterpret_cast<const CommandEncoderDescriptor*>(rhs);
    }
    inline CommandEncoderDescriptor* FromAPI(WGPUCommandEncoderDescriptor* rhs) {
        return reinterpret_cast<CommandEncoderDescriptor*>(rhs);
    }
    inline const wgpu::CommandEncoderDescriptor* ToCppAPI(const CommandEncoderDescriptor* rhs) {
        return reinterpret_cast<const wgpu::CommandEncoderDescriptor*>(rhs);
    }
    inline wgpu::CommandEncoderDescriptor* ToCppAPI(CommandEncoderDescriptor* rhs) {
        return reinterpret_cast<wgpu::CommandEncoderDescriptor*>(rhs);
    }
    inline const CommandEncoderDescriptor* FromCppAPI(const wgpu::CommandEncoderDescriptor* rhs) {
        return reinterpret_cast<const CommandEncoderDescriptor*>(rhs);
    }
    inline CommandEncoderDescriptor* FromCppAPI(wgpu::CommandEncoderDescriptor* rhs) {
        return reinterpret_cast<CommandEncoderDescriptor*>(rhs);
    }

    inline const WGPUCompilationMessage* ToAPI(const CompilationMessage* rhs) {
        return reinterpret_cast<const WGPUCompilationMessage*>(rhs);
    }
    inline WGPUCompilationMessage* ToAPI(CompilationMessage* rhs) {
        return reinterpret_cast<WGPUCompilationMessage*>(rhs);
    }
    inline const CompilationMessage* FromAPI(const WGPUCompilationMessage* rhs) {
        return reinterpret_cast<const CompilationMessage*>(rhs);
    }
    inline CompilationMessage* FromAPI(WGPUCompilationMessage* rhs) {
        return reinterpret_cast<CompilationMessage*>(rhs);
    }
    inline const wgpu::CompilationMessage* ToCppAPI(const CompilationMessage* rhs) {
        return reinterpret_cast<const wgpu::CompilationMessage*>(rhs);
    }
    inline wgpu::CompilationMessage* ToCppAPI(CompilationMessage* rhs) {
        return reinterpret_cast<wgpu::CompilationMessage*>(rhs);
    }
    inline const CompilationMessage* FromCppAPI(const wgpu::CompilationMessage* rhs) {
        return reinterpret_cast<const CompilationMessage*>(rhs);
    }
    inline CompilationMessage* FromCppAPI(wgpu::CompilationMessage* rhs) {
        return reinterpret_cast<CompilationMessage*>(rhs);
    }

    inline const WGPUComputePassDescriptor* ToAPI(const ComputePassDescriptor* rhs) {
        return reinterpret_cast<const WGPUComputePassDescriptor*>(rhs);
    }
    inline WGPUComputePassDescriptor* ToAPI(ComputePassDescriptor* rhs) {
        return reinterpret_cast<WGPUComputePassDescriptor*>(rhs);
    }
    inline const ComputePassDescriptor* FromAPI(const WGPUComputePassDescriptor* rhs) {
        return reinterpret_cast<const ComputePassDescriptor*>(rhs);
    }
    inline ComputePassDescriptor* FromAPI(WGPUComputePassDescriptor* rhs) {
        return reinterpret_cast<ComputePassDescriptor*>(rhs);
    }
    inline const wgpu::ComputePassDescriptor* ToCppAPI(const ComputePassDescriptor* rhs) {
        return reinterpret_cast<const wgpu::ComputePassDescriptor*>(rhs);
    }
    inline wgpu::ComputePassDescriptor* ToCppAPI(ComputePassDescriptor* rhs) {
        return reinterpret_cast<wgpu::ComputePassDescriptor*>(rhs);
    }
    inline const ComputePassDescriptor* FromCppAPI(const wgpu::ComputePassDescriptor* rhs) {
        return reinterpret_cast<const ComputePassDescriptor*>(rhs);
    }
    inline ComputePassDescriptor* FromCppAPI(wgpu::ComputePassDescriptor* rhs) {
        return reinterpret_cast<ComputePassDescriptor*>(rhs);
    }

    inline const WGPUComputeState* ToAPI(const ComputeState* rhs) {
        return reinterpret_cast<const WGPUComputeState*>(rhs);
    }
    inline WGPUComputeState* ToAPI(ComputeState* rhs) {
        return reinterpret_cast<WGPUComputeState*>(rhs);
    }
    inline const ComputeState* FromAPI(const WGPUComputeState* rhs) {
        return reinterpret_cast<const ComputeState*>(rhs);
    }
    inline ComputeState* FromAPI(WGPUComputeState* rhs) {
        return reinterpret_cast<ComputeState*>(rhs);
    }
    inline const wgpu::ComputeState* ToCppAPI(const ComputeState* rhs) {
        return reinterpret_cast<const wgpu::ComputeState*>(rhs);
    }
    inline wgpu::ComputeState* ToCppAPI(ComputeState* rhs) {
        return reinterpret_cast<wgpu::ComputeState*>(rhs);
    }
    inline const ComputeState* FromCppAPI(const wgpu::ComputeState* rhs) {
        return reinterpret_cast<const ComputeState*>(rhs);
    }
    inline ComputeState* FromCppAPI(wgpu::ComputeState* rhs) {
        return reinterpret_cast<ComputeState*>(rhs);
    }

    inline const WGPUDawnDrmFormatCapabilities* ToAPI(const DawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<const WGPUDawnDrmFormatCapabilities*>(rhs);
    }
    inline WGPUDawnDrmFormatCapabilities* ToAPI(DawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<WGPUDawnDrmFormatCapabilities*>(rhs);
    }
    inline const DawnDrmFormatCapabilities* FromAPI(const WGPUDawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<const DawnDrmFormatCapabilities*>(rhs);
    }
    inline DawnDrmFormatCapabilities* FromAPI(WGPUDawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<DawnDrmFormatCapabilities*>(rhs);
    }
    inline const wgpu::DawnDrmFormatCapabilities* ToCppAPI(const DawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<const wgpu::DawnDrmFormatCapabilities*>(rhs);
    }
    inline wgpu::DawnDrmFormatCapabilities* ToCppAPI(DawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<wgpu::DawnDrmFormatCapabilities*>(rhs);
    }
    inline const DawnDrmFormatCapabilities* FromCppAPI(const wgpu::DawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<const DawnDrmFormatCapabilities*>(rhs);
    }
    inline DawnDrmFormatCapabilities* FromCppAPI(wgpu::DawnDrmFormatCapabilities* rhs) {
        return reinterpret_cast<DawnDrmFormatCapabilities*>(rhs);
    }

    inline const WGPUDepthStencilState* ToAPI(const DepthStencilState* rhs) {
        return reinterpret_cast<const WGPUDepthStencilState*>(rhs);
    }
    inline WGPUDepthStencilState* ToAPI(DepthStencilState* rhs) {
        return reinterpret_cast<WGPUDepthStencilState*>(rhs);
    }
    inline const DepthStencilState* FromAPI(const WGPUDepthStencilState* rhs) {
        return reinterpret_cast<const DepthStencilState*>(rhs);
    }
    inline DepthStencilState* FromAPI(WGPUDepthStencilState* rhs) {
        return reinterpret_cast<DepthStencilState*>(rhs);
    }
    inline const wgpu::DepthStencilState* ToCppAPI(const DepthStencilState* rhs) {
        return reinterpret_cast<const wgpu::DepthStencilState*>(rhs);
    }
    inline wgpu::DepthStencilState* ToCppAPI(DepthStencilState* rhs) {
        return reinterpret_cast<wgpu::DepthStencilState*>(rhs);
    }
    inline const DepthStencilState* FromCppAPI(const wgpu::DepthStencilState* rhs) {
        return reinterpret_cast<const DepthStencilState*>(rhs);
    }
    inline DepthStencilState* FromCppAPI(wgpu::DepthStencilState* rhs) {
        return reinterpret_cast<DepthStencilState*>(rhs);
    }

    inline const WGPUExternalTextureDescriptor* ToAPI(const ExternalTextureDescriptor* rhs) {
        return reinterpret_cast<const WGPUExternalTextureDescriptor*>(rhs);
    }
    inline WGPUExternalTextureDescriptor* ToAPI(ExternalTextureDescriptor* rhs) {
        return reinterpret_cast<WGPUExternalTextureDescriptor*>(rhs);
    }
    inline const ExternalTextureDescriptor* FromAPI(const WGPUExternalTextureDescriptor* rhs) {
        return reinterpret_cast<const ExternalTextureDescriptor*>(rhs);
    }
    inline ExternalTextureDescriptor* FromAPI(WGPUExternalTextureDescriptor* rhs) {
        return reinterpret_cast<ExternalTextureDescriptor*>(rhs);
    }
    inline const wgpu::ExternalTextureDescriptor* ToCppAPI(const ExternalTextureDescriptor* rhs) {
        return reinterpret_cast<const wgpu::ExternalTextureDescriptor*>(rhs);
    }
    inline wgpu::ExternalTextureDescriptor* ToCppAPI(ExternalTextureDescriptor* rhs) {
        return reinterpret_cast<wgpu::ExternalTextureDescriptor*>(rhs);
    }
    inline const ExternalTextureDescriptor* FromCppAPI(const wgpu::ExternalTextureDescriptor* rhs) {
        return reinterpret_cast<const ExternalTextureDescriptor*>(rhs);
    }
    inline ExternalTextureDescriptor* FromCppAPI(wgpu::ExternalTextureDescriptor* rhs) {
        return reinterpret_cast<ExternalTextureDescriptor*>(rhs);
    }

    inline const WGPUFutureWaitInfo* ToAPI(const FutureWaitInfo* rhs) {
        return reinterpret_cast<const WGPUFutureWaitInfo*>(rhs);
    }
    inline WGPUFutureWaitInfo* ToAPI(FutureWaitInfo* rhs) {
        return reinterpret_cast<WGPUFutureWaitInfo*>(rhs);
    }
    inline const FutureWaitInfo* FromAPI(const WGPUFutureWaitInfo* rhs) {
        return reinterpret_cast<const FutureWaitInfo*>(rhs);
    }
    inline FutureWaitInfo* FromAPI(WGPUFutureWaitInfo* rhs) {
        return reinterpret_cast<FutureWaitInfo*>(rhs);
    }
    inline const wgpu::FutureWaitInfo* ToCppAPI(const FutureWaitInfo* rhs) {
        return reinterpret_cast<const wgpu::FutureWaitInfo*>(rhs);
    }
    inline wgpu::FutureWaitInfo* ToCppAPI(FutureWaitInfo* rhs) {
        return reinterpret_cast<wgpu::FutureWaitInfo*>(rhs);
    }
    inline const FutureWaitInfo* FromCppAPI(const wgpu::FutureWaitInfo* rhs) {
        return reinterpret_cast<const FutureWaitInfo*>(rhs);
    }
    inline FutureWaitInfo* FromCppAPI(wgpu::FutureWaitInfo* rhs) {
        return reinterpret_cast<FutureWaitInfo*>(rhs);
    }

    inline const WGPUImageCopyExternalTexture* ToAPI(const ImageCopyExternalTexture* rhs) {
        return reinterpret_cast<const WGPUImageCopyExternalTexture*>(rhs);
    }
    inline WGPUImageCopyExternalTexture* ToAPI(ImageCopyExternalTexture* rhs) {
        return reinterpret_cast<WGPUImageCopyExternalTexture*>(rhs);
    }
    inline const ImageCopyExternalTexture* FromAPI(const WGPUImageCopyExternalTexture* rhs) {
        return reinterpret_cast<const ImageCopyExternalTexture*>(rhs);
    }
    inline ImageCopyExternalTexture* FromAPI(WGPUImageCopyExternalTexture* rhs) {
        return reinterpret_cast<ImageCopyExternalTexture*>(rhs);
    }
    inline const wgpu::ImageCopyExternalTexture* ToCppAPI(const ImageCopyExternalTexture* rhs) {
        return reinterpret_cast<const wgpu::ImageCopyExternalTexture*>(rhs);
    }
    inline wgpu::ImageCopyExternalTexture* ToCppAPI(ImageCopyExternalTexture* rhs) {
        return reinterpret_cast<wgpu::ImageCopyExternalTexture*>(rhs);
    }
    inline const ImageCopyExternalTexture* FromCppAPI(const wgpu::ImageCopyExternalTexture* rhs) {
        return reinterpret_cast<const ImageCopyExternalTexture*>(rhs);
    }
    inline ImageCopyExternalTexture* FromCppAPI(wgpu::ImageCopyExternalTexture* rhs) {
        return reinterpret_cast<ImageCopyExternalTexture*>(rhs);
    }

    inline const WGPUInstanceDescriptor* ToAPI(const InstanceDescriptor* rhs) {
        return reinterpret_cast<const WGPUInstanceDescriptor*>(rhs);
    }
    inline WGPUInstanceDescriptor* ToAPI(InstanceDescriptor* rhs) {
        return reinterpret_cast<WGPUInstanceDescriptor*>(rhs);
    }
    inline const InstanceDescriptor* FromAPI(const WGPUInstanceDescriptor* rhs) {
        return reinterpret_cast<const InstanceDescriptor*>(rhs);
    }
    inline InstanceDescriptor* FromAPI(WGPUInstanceDescriptor* rhs) {
        return reinterpret_cast<InstanceDescriptor*>(rhs);
    }
    inline const wgpu::InstanceDescriptor* ToCppAPI(const InstanceDescriptor* rhs) {
        return reinterpret_cast<const wgpu::InstanceDescriptor*>(rhs);
    }
    inline wgpu::InstanceDescriptor* ToCppAPI(InstanceDescriptor* rhs) {
        return reinterpret_cast<wgpu::InstanceDescriptor*>(rhs);
    }
    inline const InstanceDescriptor* FromCppAPI(const wgpu::InstanceDescriptor* rhs) {
        return reinterpret_cast<const InstanceDescriptor*>(rhs);
    }
    inline InstanceDescriptor* FromCppAPI(wgpu::InstanceDescriptor* rhs) {
        return reinterpret_cast<InstanceDescriptor*>(rhs);
    }

    inline const WGPULimits* ToAPI(const Limits* rhs) {
        return reinterpret_cast<const WGPULimits*>(rhs);
    }
    inline WGPULimits* ToAPI(Limits* rhs) {
        return reinterpret_cast<WGPULimits*>(rhs);
    }
    inline const Limits* FromAPI(const WGPULimits* rhs) {
        return reinterpret_cast<const Limits*>(rhs);
    }
    inline Limits* FromAPI(WGPULimits* rhs) {
        return reinterpret_cast<Limits*>(rhs);
    }
    inline const wgpu::Limits* ToCppAPI(const Limits* rhs) {
        return reinterpret_cast<const wgpu::Limits*>(rhs);
    }
    inline wgpu::Limits* ToCppAPI(Limits* rhs) {
        return reinterpret_cast<wgpu::Limits*>(rhs);
    }
    inline const Limits* FromCppAPI(const wgpu::Limits* rhs) {
        return reinterpret_cast<const Limits*>(rhs);
    }
    inline Limits* FromCppAPI(wgpu::Limits* rhs) {
        return reinterpret_cast<Limits*>(rhs);
    }

    inline const WGPUPipelineLayoutPixelLocalStorage* ToAPI(const PipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<const WGPUPipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline WGPUPipelineLayoutPixelLocalStorage* ToAPI(PipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<WGPUPipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline const PipelineLayoutPixelLocalStorage* FromAPI(const WGPUPipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<const PipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline PipelineLayoutPixelLocalStorage* FromAPI(WGPUPipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<PipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline const wgpu::PipelineLayoutPixelLocalStorage* ToCppAPI(const PipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<const wgpu::PipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline wgpu::PipelineLayoutPixelLocalStorage* ToCppAPI(PipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<wgpu::PipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline const PipelineLayoutPixelLocalStorage* FromCppAPI(const wgpu::PipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<const PipelineLayoutPixelLocalStorage*>(rhs);
    }
    inline PipelineLayoutPixelLocalStorage* FromCppAPI(wgpu::PipelineLayoutPixelLocalStorage* rhs) {
        return reinterpret_cast<PipelineLayoutPixelLocalStorage*>(rhs);
    }

    inline const WGPURenderPassColorAttachment* ToAPI(const RenderPassColorAttachment* rhs) {
        return reinterpret_cast<const WGPURenderPassColorAttachment*>(rhs);
    }
    inline WGPURenderPassColorAttachment* ToAPI(RenderPassColorAttachment* rhs) {
        return reinterpret_cast<WGPURenderPassColorAttachment*>(rhs);
    }
    inline const RenderPassColorAttachment* FromAPI(const WGPURenderPassColorAttachment* rhs) {
        return reinterpret_cast<const RenderPassColorAttachment*>(rhs);
    }
    inline RenderPassColorAttachment* FromAPI(WGPURenderPassColorAttachment* rhs) {
        return reinterpret_cast<RenderPassColorAttachment*>(rhs);
    }
    inline const wgpu::RenderPassColorAttachment* ToCppAPI(const RenderPassColorAttachment* rhs) {
        return reinterpret_cast<const wgpu::RenderPassColorAttachment*>(rhs);
    }
    inline wgpu::RenderPassColorAttachment* ToCppAPI(RenderPassColorAttachment* rhs) {
        return reinterpret_cast<wgpu::RenderPassColorAttachment*>(rhs);
    }
    inline const RenderPassColorAttachment* FromCppAPI(const wgpu::RenderPassColorAttachment* rhs) {
        return reinterpret_cast<const RenderPassColorAttachment*>(rhs);
    }
    inline RenderPassColorAttachment* FromCppAPI(wgpu::RenderPassColorAttachment* rhs) {
        return reinterpret_cast<RenderPassColorAttachment*>(rhs);
    }

    inline const WGPURenderPassStorageAttachment* ToAPI(const RenderPassStorageAttachment* rhs) {
        return reinterpret_cast<const WGPURenderPassStorageAttachment*>(rhs);
    }
    inline WGPURenderPassStorageAttachment* ToAPI(RenderPassStorageAttachment* rhs) {
        return reinterpret_cast<WGPURenderPassStorageAttachment*>(rhs);
    }
    inline const RenderPassStorageAttachment* FromAPI(const WGPURenderPassStorageAttachment* rhs) {
        return reinterpret_cast<const RenderPassStorageAttachment*>(rhs);
    }
    inline RenderPassStorageAttachment* FromAPI(WGPURenderPassStorageAttachment* rhs) {
        return reinterpret_cast<RenderPassStorageAttachment*>(rhs);
    }
    inline const wgpu::RenderPassStorageAttachment* ToCppAPI(const RenderPassStorageAttachment* rhs) {
        return reinterpret_cast<const wgpu::RenderPassStorageAttachment*>(rhs);
    }
    inline wgpu::RenderPassStorageAttachment* ToCppAPI(RenderPassStorageAttachment* rhs) {
        return reinterpret_cast<wgpu::RenderPassStorageAttachment*>(rhs);
    }
    inline const RenderPassStorageAttachment* FromCppAPI(const wgpu::RenderPassStorageAttachment* rhs) {
        return reinterpret_cast<const RenderPassStorageAttachment*>(rhs);
    }
    inline RenderPassStorageAttachment* FromCppAPI(wgpu::RenderPassStorageAttachment* rhs) {
        return reinterpret_cast<RenderPassStorageAttachment*>(rhs);
    }

    inline const WGPURequestAdapterOptions* ToAPI(const RequestAdapterOptions* rhs) {
        return reinterpret_cast<const WGPURequestAdapterOptions*>(rhs);
    }
    inline WGPURequestAdapterOptions* ToAPI(RequestAdapterOptions* rhs) {
        return reinterpret_cast<WGPURequestAdapterOptions*>(rhs);
    }
    inline const RequestAdapterOptions* FromAPI(const WGPURequestAdapterOptions* rhs) {
        return reinterpret_cast<const RequestAdapterOptions*>(rhs);
    }
    inline RequestAdapterOptions* FromAPI(WGPURequestAdapterOptions* rhs) {
        return reinterpret_cast<RequestAdapterOptions*>(rhs);
    }
    inline const wgpu::RequestAdapterOptions* ToCppAPI(const RequestAdapterOptions* rhs) {
        return reinterpret_cast<const wgpu::RequestAdapterOptions*>(rhs);
    }
    inline wgpu::RequestAdapterOptions* ToCppAPI(RequestAdapterOptions* rhs) {
        return reinterpret_cast<wgpu::RequestAdapterOptions*>(rhs);
    }
    inline const RequestAdapterOptions* FromCppAPI(const wgpu::RequestAdapterOptions* rhs) {
        return reinterpret_cast<const RequestAdapterOptions*>(rhs);
    }
    inline RequestAdapterOptions* FromCppAPI(wgpu::RequestAdapterOptions* rhs) {
        return reinterpret_cast<RequestAdapterOptions*>(rhs);
    }

    inline const WGPUSamplerDescriptor* ToAPI(const SamplerDescriptor* rhs) {
        return reinterpret_cast<const WGPUSamplerDescriptor*>(rhs);
    }
    inline WGPUSamplerDescriptor* ToAPI(SamplerDescriptor* rhs) {
        return reinterpret_cast<WGPUSamplerDescriptor*>(rhs);
    }
    inline const SamplerDescriptor* FromAPI(const WGPUSamplerDescriptor* rhs) {
        return reinterpret_cast<const SamplerDescriptor*>(rhs);
    }
    inline SamplerDescriptor* FromAPI(WGPUSamplerDescriptor* rhs) {
        return reinterpret_cast<SamplerDescriptor*>(rhs);
    }
    inline const wgpu::SamplerDescriptor* ToCppAPI(const SamplerDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SamplerDescriptor*>(rhs);
    }
    inline wgpu::SamplerDescriptor* ToCppAPI(SamplerDescriptor* rhs) {
        return reinterpret_cast<wgpu::SamplerDescriptor*>(rhs);
    }
    inline const SamplerDescriptor* FromCppAPI(const wgpu::SamplerDescriptor* rhs) {
        return reinterpret_cast<const SamplerDescriptor*>(rhs);
    }
    inline SamplerDescriptor* FromCppAPI(wgpu::SamplerDescriptor* rhs) {
        return reinterpret_cast<SamplerDescriptor*>(rhs);
    }

    inline const WGPUShaderModuleDescriptor* ToAPI(const ShaderModuleDescriptor* rhs) {
        return reinterpret_cast<const WGPUShaderModuleDescriptor*>(rhs);
    }
    inline WGPUShaderModuleDescriptor* ToAPI(ShaderModuleDescriptor* rhs) {
        return reinterpret_cast<WGPUShaderModuleDescriptor*>(rhs);
    }
    inline const ShaderModuleDescriptor* FromAPI(const WGPUShaderModuleDescriptor* rhs) {
        return reinterpret_cast<const ShaderModuleDescriptor*>(rhs);
    }
    inline ShaderModuleDescriptor* FromAPI(WGPUShaderModuleDescriptor* rhs) {
        return reinterpret_cast<ShaderModuleDescriptor*>(rhs);
    }
    inline const wgpu::ShaderModuleDescriptor* ToCppAPI(const ShaderModuleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::ShaderModuleDescriptor*>(rhs);
    }
    inline wgpu::ShaderModuleDescriptor* ToCppAPI(ShaderModuleDescriptor* rhs) {
        return reinterpret_cast<wgpu::ShaderModuleDescriptor*>(rhs);
    }
    inline const ShaderModuleDescriptor* FromCppAPI(const wgpu::ShaderModuleDescriptor* rhs) {
        return reinterpret_cast<const ShaderModuleDescriptor*>(rhs);
    }
    inline ShaderModuleDescriptor* FromCppAPI(wgpu::ShaderModuleDescriptor* rhs) {
        return reinterpret_cast<ShaderModuleDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceDescriptor* ToAPI(const SharedFenceDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedFenceDescriptor*>(rhs);
    }
    inline WGPUSharedFenceDescriptor* ToAPI(SharedFenceDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedFenceDescriptor*>(rhs);
    }
    inline const SharedFenceDescriptor* FromAPI(const WGPUSharedFenceDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceDescriptor*>(rhs);
    }
    inline SharedFenceDescriptor* FromAPI(WGPUSharedFenceDescriptor* rhs) {
        return reinterpret_cast<SharedFenceDescriptor*>(rhs);
    }
    inline const wgpu::SharedFenceDescriptor* ToCppAPI(const SharedFenceDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceDescriptor*>(rhs);
    }
    inline wgpu::SharedFenceDescriptor* ToCppAPI(SharedFenceDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedFenceDescriptor*>(rhs);
    }
    inline const SharedFenceDescriptor* FromCppAPI(const wgpu::SharedFenceDescriptor* rhs) {
        return reinterpret_cast<const SharedFenceDescriptor*>(rhs);
    }
    inline SharedFenceDescriptor* FromCppAPI(wgpu::SharedFenceDescriptor* rhs) {
        return reinterpret_cast<SharedFenceDescriptor*>(rhs);
    }

    inline const WGPUSharedFenceExportInfo* ToAPI(const SharedFenceExportInfo* rhs) {
        return reinterpret_cast<const WGPUSharedFenceExportInfo*>(rhs);
    }
    inline WGPUSharedFenceExportInfo* ToAPI(SharedFenceExportInfo* rhs) {
        return reinterpret_cast<WGPUSharedFenceExportInfo*>(rhs);
    }
    inline const SharedFenceExportInfo* FromAPI(const WGPUSharedFenceExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceExportInfo*>(rhs);
    }
    inline SharedFenceExportInfo* FromAPI(WGPUSharedFenceExportInfo* rhs) {
        return reinterpret_cast<SharedFenceExportInfo*>(rhs);
    }
    inline const wgpu::SharedFenceExportInfo* ToCppAPI(const SharedFenceExportInfo* rhs) {
        return reinterpret_cast<const wgpu::SharedFenceExportInfo*>(rhs);
    }
    inline wgpu::SharedFenceExportInfo* ToCppAPI(SharedFenceExportInfo* rhs) {
        return reinterpret_cast<wgpu::SharedFenceExportInfo*>(rhs);
    }
    inline const SharedFenceExportInfo* FromCppAPI(const wgpu::SharedFenceExportInfo* rhs) {
        return reinterpret_cast<const SharedFenceExportInfo*>(rhs);
    }
    inline SharedFenceExportInfo* FromCppAPI(wgpu::SharedFenceExportInfo* rhs) {
        return reinterpret_cast<SharedFenceExportInfo*>(rhs);
    }

    inline const WGPUSharedTextureMemoryAHardwareBufferProperties* ToAPI(const SharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline WGPUSharedTextureMemoryAHardwareBufferProperties* ToAPI(SharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline const SharedTextureMemoryAHardwareBufferProperties* FromAPI(const WGPUSharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<const SharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline SharedTextureMemoryAHardwareBufferProperties* FromAPI(WGPUSharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<SharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryAHardwareBufferProperties* ToCppAPI(const SharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline wgpu::SharedTextureMemoryAHardwareBufferProperties* ToCppAPI(SharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline const SharedTextureMemoryAHardwareBufferProperties* FromCppAPI(const wgpu::SharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<const SharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }
    inline SharedTextureMemoryAHardwareBufferProperties* FromCppAPI(wgpu::SharedTextureMemoryAHardwareBufferProperties* rhs) {
        return reinterpret_cast<SharedTextureMemoryAHardwareBufferProperties*>(rhs);
    }

    inline const WGPUSharedTextureMemoryBeginAccessDescriptor* ToAPI(const SharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryBeginAccessDescriptor* ToAPI(SharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryBeginAccessDescriptor* FromAPI(const WGPUSharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline SharedTextureMemoryBeginAccessDescriptor* FromAPI(WGPUSharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryBeginAccessDescriptor* ToCppAPI(const SharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryBeginAccessDescriptor* ToCppAPI(SharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryBeginAccessDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }
    inline SharedTextureMemoryBeginAccessDescriptor* FromCppAPI(wgpu::SharedTextureMemoryBeginAccessDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryBeginAccessDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryDmaBufDescriptor* ToAPI(const SharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryDmaBufDescriptor* ToAPI(SharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryDmaBufDescriptor* FromAPI(const WGPUSharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline SharedTextureMemoryDmaBufDescriptor* FromAPI(WGPUSharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryDmaBufDescriptor* ToCppAPI(const SharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryDmaBufDescriptor* ToCppAPI(SharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryDmaBufDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDmaBufDescriptor*>(rhs);
    }
    inline SharedTextureMemoryDmaBufDescriptor* FromCppAPI(wgpu::SharedTextureMemoryDmaBufDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryDmaBufDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryMetalEndAccessState* ToAPI(const SharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline WGPUSharedTextureMemoryMetalEndAccessState* ToAPI(SharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline const SharedTextureMemoryMetalEndAccessState* FromAPI(const WGPUSharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline SharedTextureMemoryMetalEndAccessState* FromAPI(WGPUSharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<SharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryMetalEndAccessState* ToCppAPI(const SharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline wgpu::SharedTextureMemoryMetalEndAccessState* ToCppAPI(SharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline const SharedTextureMemoryMetalEndAccessState* FromCppAPI(const wgpu::SharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryMetalEndAccessState*>(rhs);
    }
    inline SharedTextureMemoryMetalEndAccessState* FromCppAPI(wgpu::SharedTextureMemoryMetalEndAccessState* rhs) {
        return reinterpret_cast<SharedTextureMemoryMetalEndAccessState*>(rhs);
    }

    inline const WGPUSurfaceDescriptor* ToAPI(const SurfaceDescriptor* rhs) {
        return reinterpret_cast<const WGPUSurfaceDescriptor*>(rhs);
    }
    inline WGPUSurfaceDescriptor* ToAPI(SurfaceDescriptor* rhs) {
        return reinterpret_cast<WGPUSurfaceDescriptor*>(rhs);
    }
    inline const SurfaceDescriptor* FromAPI(const WGPUSurfaceDescriptor* rhs) {
        return reinterpret_cast<const SurfaceDescriptor*>(rhs);
    }
    inline SurfaceDescriptor* FromAPI(WGPUSurfaceDescriptor* rhs) {
        return reinterpret_cast<SurfaceDescriptor*>(rhs);
    }
    inline const wgpu::SurfaceDescriptor* ToCppAPI(const SurfaceDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SurfaceDescriptor*>(rhs);
    }
    inline wgpu::SurfaceDescriptor* ToCppAPI(SurfaceDescriptor* rhs) {
        return reinterpret_cast<wgpu::SurfaceDescriptor*>(rhs);
    }
    inline const SurfaceDescriptor* FromCppAPI(const wgpu::SurfaceDescriptor* rhs) {
        return reinterpret_cast<const SurfaceDescriptor*>(rhs);
    }
    inline SurfaceDescriptor* FromCppAPI(wgpu::SurfaceDescriptor* rhs) {
        return reinterpret_cast<SurfaceDescriptor*>(rhs);
    }

    inline const WGPUTexelCopyBufferInfo* ToAPI(const TexelCopyBufferInfo* rhs) {
        return reinterpret_cast<const WGPUTexelCopyBufferInfo*>(rhs);
    }
    inline WGPUTexelCopyBufferInfo* ToAPI(TexelCopyBufferInfo* rhs) {
        return reinterpret_cast<WGPUTexelCopyBufferInfo*>(rhs);
    }
    inline const TexelCopyBufferInfo* FromAPI(const WGPUTexelCopyBufferInfo* rhs) {
        return reinterpret_cast<const TexelCopyBufferInfo*>(rhs);
    }
    inline TexelCopyBufferInfo* FromAPI(WGPUTexelCopyBufferInfo* rhs) {
        return reinterpret_cast<TexelCopyBufferInfo*>(rhs);
    }
    inline const wgpu::TexelCopyBufferInfo* ToCppAPI(const TexelCopyBufferInfo* rhs) {
        return reinterpret_cast<const wgpu::TexelCopyBufferInfo*>(rhs);
    }
    inline wgpu::TexelCopyBufferInfo* ToCppAPI(TexelCopyBufferInfo* rhs) {
        return reinterpret_cast<wgpu::TexelCopyBufferInfo*>(rhs);
    }
    inline const TexelCopyBufferInfo* FromCppAPI(const wgpu::TexelCopyBufferInfo* rhs) {
        return reinterpret_cast<const TexelCopyBufferInfo*>(rhs);
    }
    inline TexelCopyBufferInfo* FromCppAPI(wgpu::TexelCopyBufferInfo* rhs) {
        return reinterpret_cast<TexelCopyBufferInfo*>(rhs);
    }

    inline const WGPUTexelCopyTextureInfo* ToAPI(const TexelCopyTextureInfo* rhs) {
        return reinterpret_cast<const WGPUTexelCopyTextureInfo*>(rhs);
    }
    inline WGPUTexelCopyTextureInfo* ToAPI(TexelCopyTextureInfo* rhs) {
        return reinterpret_cast<WGPUTexelCopyTextureInfo*>(rhs);
    }
    inline const TexelCopyTextureInfo* FromAPI(const WGPUTexelCopyTextureInfo* rhs) {
        return reinterpret_cast<const TexelCopyTextureInfo*>(rhs);
    }
    inline TexelCopyTextureInfo* FromAPI(WGPUTexelCopyTextureInfo* rhs) {
        return reinterpret_cast<TexelCopyTextureInfo*>(rhs);
    }
    inline const wgpu::TexelCopyTextureInfo* ToCppAPI(const TexelCopyTextureInfo* rhs) {
        return reinterpret_cast<const wgpu::TexelCopyTextureInfo*>(rhs);
    }
    inline wgpu::TexelCopyTextureInfo* ToCppAPI(TexelCopyTextureInfo* rhs) {
        return reinterpret_cast<wgpu::TexelCopyTextureInfo*>(rhs);
    }
    inline const TexelCopyTextureInfo* FromCppAPI(const wgpu::TexelCopyTextureInfo* rhs) {
        return reinterpret_cast<const TexelCopyTextureInfo*>(rhs);
    }
    inline TexelCopyTextureInfo* FromCppAPI(wgpu::TexelCopyTextureInfo* rhs) {
        return reinterpret_cast<TexelCopyTextureInfo*>(rhs);
    }

    inline const WGPUTextureComponentSwizzleDescriptor* ToAPI(const TextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<const WGPUTextureComponentSwizzleDescriptor*>(rhs);
    }
    inline WGPUTextureComponentSwizzleDescriptor* ToAPI(TextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<WGPUTextureComponentSwizzleDescriptor*>(rhs);
    }
    inline const TextureComponentSwizzleDescriptor* FromAPI(const WGPUTextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<const TextureComponentSwizzleDescriptor*>(rhs);
    }
    inline TextureComponentSwizzleDescriptor* FromAPI(WGPUTextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<TextureComponentSwizzleDescriptor*>(rhs);
    }
    inline const wgpu::TextureComponentSwizzleDescriptor* ToCppAPI(const TextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<const wgpu::TextureComponentSwizzleDescriptor*>(rhs);
    }
    inline wgpu::TextureComponentSwizzleDescriptor* ToCppAPI(TextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<wgpu::TextureComponentSwizzleDescriptor*>(rhs);
    }
    inline const TextureComponentSwizzleDescriptor* FromCppAPI(const wgpu::TextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<const TextureComponentSwizzleDescriptor*>(rhs);
    }
    inline TextureComponentSwizzleDescriptor* FromCppAPI(wgpu::TextureComponentSwizzleDescriptor* rhs) {
        return reinterpret_cast<TextureComponentSwizzleDescriptor*>(rhs);
    }

    inline const WGPUTextureDescriptor* ToAPI(const TextureDescriptor* rhs) {
        return reinterpret_cast<const WGPUTextureDescriptor*>(rhs);
    }
    inline WGPUTextureDescriptor* ToAPI(TextureDescriptor* rhs) {
        return reinterpret_cast<WGPUTextureDescriptor*>(rhs);
    }
    inline const TextureDescriptor* FromAPI(const WGPUTextureDescriptor* rhs) {
        return reinterpret_cast<const TextureDescriptor*>(rhs);
    }
    inline TextureDescriptor* FromAPI(WGPUTextureDescriptor* rhs) {
        return reinterpret_cast<TextureDescriptor*>(rhs);
    }
    inline const wgpu::TextureDescriptor* ToCppAPI(const TextureDescriptor* rhs) {
        return reinterpret_cast<const wgpu::TextureDescriptor*>(rhs);
    }
    inline wgpu::TextureDescriptor* ToCppAPI(TextureDescriptor* rhs) {
        return reinterpret_cast<wgpu::TextureDescriptor*>(rhs);
    }
    inline const TextureDescriptor* FromCppAPI(const wgpu::TextureDescriptor* rhs) {
        return reinterpret_cast<const TextureDescriptor*>(rhs);
    }
    inline TextureDescriptor* FromCppAPI(wgpu::TextureDescriptor* rhs) {
        return reinterpret_cast<TextureDescriptor*>(rhs);
    }

    inline const WGPUVertexBufferLayout* ToAPI(const VertexBufferLayout* rhs) {
        return reinterpret_cast<const WGPUVertexBufferLayout*>(rhs);
    }
    inline WGPUVertexBufferLayout* ToAPI(VertexBufferLayout* rhs) {
        return reinterpret_cast<WGPUVertexBufferLayout*>(rhs);
    }
    inline const VertexBufferLayout* FromAPI(const WGPUVertexBufferLayout* rhs) {
        return reinterpret_cast<const VertexBufferLayout*>(rhs);
    }
    inline VertexBufferLayout* FromAPI(WGPUVertexBufferLayout* rhs) {
        return reinterpret_cast<VertexBufferLayout*>(rhs);
    }
    inline const wgpu::VertexBufferLayout* ToCppAPI(const VertexBufferLayout* rhs) {
        return reinterpret_cast<const wgpu::VertexBufferLayout*>(rhs);
    }
    inline wgpu::VertexBufferLayout* ToCppAPI(VertexBufferLayout* rhs) {
        return reinterpret_cast<wgpu::VertexBufferLayout*>(rhs);
    }
    inline const VertexBufferLayout* FromCppAPI(const wgpu::VertexBufferLayout* rhs) {
        return reinterpret_cast<const VertexBufferLayout*>(rhs);
    }
    inline VertexBufferLayout* FromCppAPI(wgpu::VertexBufferLayout* rhs) {
        return reinterpret_cast<VertexBufferLayout*>(rhs);
    }

    inline const WGPUAdapterInfo* ToAPI(const AdapterInfo* rhs) {
        return reinterpret_cast<const WGPUAdapterInfo*>(rhs);
    }
    inline WGPUAdapterInfo* ToAPI(AdapterInfo* rhs) {
        return reinterpret_cast<WGPUAdapterInfo*>(rhs);
    }
    inline const AdapterInfo* FromAPI(const WGPUAdapterInfo* rhs) {
        return reinterpret_cast<const AdapterInfo*>(rhs);
    }
    inline AdapterInfo* FromAPI(WGPUAdapterInfo* rhs) {
        return reinterpret_cast<AdapterInfo*>(rhs);
    }
    inline const wgpu::AdapterInfo* ToCppAPI(const AdapterInfo* rhs) {
        return reinterpret_cast<const wgpu::AdapterInfo*>(rhs);
    }
    inline wgpu::AdapterInfo* ToCppAPI(AdapterInfo* rhs) {
        return reinterpret_cast<wgpu::AdapterInfo*>(rhs);
    }
    inline const AdapterInfo* FromCppAPI(const wgpu::AdapterInfo* rhs) {
        return reinterpret_cast<const AdapterInfo*>(rhs);
    }
    inline AdapterInfo* FromCppAPI(wgpu::AdapterInfo* rhs) {
        return reinterpret_cast<AdapterInfo*>(rhs);
    }

    inline const WGPUBindGroupDescriptor* ToAPI(const BindGroupDescriptor* rhs) {
        return reinterpret_cast<const WGPUBindGroupDescriptor*>(rhs);
    }
    inline WGPUBindGroupDescriptor* ToAPI(BindGroupDescriptor* rhs) {
        return reinterpret_cast<WGPUBindGroupDescriptor*>(rhs);
    }
    inline const BindGroupDescriptor* FromAPI(const WGPUBindGroupDescriptor* rhs) {
        return reinterpret_cast<const BindGroupDescriptor*>(rhs);
    }
    inline BindGroupDescriptor* FromAPI(WGPUBindGroupDescriptor* rhs) {
        return reinterpret_cast<BindGroupDescriptor*>(rhs);
    }
    inline const wgpu::BindGroupDescriptor* ToCppAPI(const BindGroupDescriptor* rhs) {
        return reinterpret_cast<const wgpu::BindGroupDescriptor*>(rhs);
    }
    inline wgpu::BindGroupDescriptor* ToCppAPI(BindGroupDescriptor* rhs) {
        return reinterpret_cast<wgpu::BindGroupDescriptor*>(rhs);
    }
    inline const BindGroupDescriptor* FromCppAPI(const wgpu::BindGroupDescriptor* rhs) {
        return reinterpret_cast<const BindGroupDescriptor*>(rhs);
    }
    inline BindGroupDescriptor* FromCppAPI(wgpu::BindGroupDescriptor* rhs) {
        return reinterpret_cast<BindGroupDescriptor*>(rhs);
    }

    inline const WGPUBindGroupLayoutDescriptor* ToAPI(const BindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<const WGPUBindGroupLayoutDescriptor*>(rhs);
    }
    inline WGPUBindGroupLayoutDescriptor* ToAPI(BindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<WGPUBindGroupLayoutDescriptor*>(rhs);
    }
    inline const BindGroupLayoutDescriptor* FromAPI(const WGPUBindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<const BindGroupLayoutDescriptor*>(rhs);
    }
    inline BindGroupLayoutDescriptor* FromAPI(WGPUBindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<BindGroupLayoutDescriptor*>(rhs);
    }
    inline const wgpu::BindGroupLayoutDescriptor* ToCppAPI(const BindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<const wgpu::BindGroupLayoutDescriptor*>(rhs);
    }
    inline wgpu::BindGroupLayoutDescriptor* ToCppAPI(BindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<wgpu::BindGroupLayoutDescriptor*>(rhs);
    }
    inline const BindGroupLayoutDescriptor* FromCppAPI(const wgpu::BindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<const BindGroupLayoutDescriptor*>(rhs);
    }
    inline BindGroupLayoutDescriptor* FromCppAPI(wgpu::BindGroupLayoutDescriptor* rhs) {
        return reinterpret_cast<BindGroupLayoutDescriptor*>(rhs);
    }

    inline const WGPUColorTargetState* ToAPI(const ColorTargetState* rhs) {
        return reinterpret_cast<const WGPUColorTargetState*>(rhs);
    }
    inline WGPUColorTargetState* ToAPI(ColorTargetState* rhs) {
        return reinterpret_cast<WGPUColorTargetState*>(rhs);
    }
    inline const ColorTargetState* FromAPI(const WGPUColorTargetState* rhs) {
        return reinterpret_cast<const ColorTargetState*>(rhs);
    }
    inline ColorTargetState* FromAPI(WGPUColorTargetState* rhs) {
        return reinterpret_cast<ColorTargetState*>(rhs);
    }
    inline const wgpu::ColorTargetState* ToCppAPI(const ColorTargetState* rhs) {
        return reinterpret_cast<const wgpu::ColorTargetState*>(rhs);
    }
    inline wgpu::ColorTargetState* ToCppAPI(ColorTargetState* rhs) {
        return reinterpret_cast<wgpu::ColorTargetState*>(rhs);
    }
    inline const ColorTargetState* FromCppAPI(const wgpu::ColorTargetState* rhs) {
        return reinterpret_cast<const ColorTargetState*>(rhs);
    }
    inline ColorTargetState* FromCppAPI(wgpu::ColorTargetState* rhs) {
        return reinterpret_cast<ColorTargetState*>(rhs);
    }

    inline const WGPUCompilationInfo* ToAPI(const CompilationInfo* rhs) {
        return reinterpret_cast<const WGPUCompilationInfo*>(rhs);
    }
    inline WGPUCompilationInfo* ToAPI(CompilationInfo* rhs) {
        return reinterpret_cast<WGPUCompilationInfo*>(rhs);
    }
    inline const CompilationInfo* FromAPI(const WGPUCompilationInfo* rhs) {
        return reinterpret_cast<const CompilationInfo*>(rhs);
    }
    inline CompilationInfo* FromAPI(WGPUCompilationInfo* rhs) {
        return reinterpret_cast<CompilationInfo*>(rhs);
    }
    inline const wgpu::CompilationInfo* ToCppAPI(const CompilationInfo* rhs) {
        return reinterpret_cast<const wgpu::CompilationInfo*>(rhs);
    }
    inline wgpu::CompilationInfo* ToCppAPI(CompilationInfo* rhs) {
        return reinterpret_cast<wgpu::CompilationInfo*>(rhs);
    }
    inline const CompilationInfo* FromCppAPI(const wgpu::CompilationInfo* rhs) {
        return reinterpret_cast<const CompilationInfo*>(rhs);
    }
    inline CompilationInfo* FromCppAPI(wgpu::CompilationInfo* rhs) {
        return reinterpret_cast<CompilationInfo*>(rhs);
    }

    inline const WGPUComputePipelineDescriptor* ToAPI(const ComputePipelineDescriptor* rhs) {
        return reinterpret_cast<const WGPUComputePipelineDescriptor*>(rhs);
    }
    inline WGPUComputePipelineDescriptor* ToAPI(ComputePipelineDescriptor* rhs) {
        return reinterpret_cast<WGPUComputePipelineDescriptor*>(rhs);
    }
    inline const ComputePipelineDescriptor* FromAPI(const WGPUComputePipelineDescriptor* rhs) {
        return reinterpret_cast<const ComputePipelineDescriptor*>(rhs);
    }
    inline ComputePipelineDescriptor* FromAPI(WGPUComputePipelineDescriptor* rhs) {
        return reinterpret_cast<ComputePipelineDescriptor*>(rhs);
    }
    inline const wgpu::ComputePipelineDescriptor* ToCppAPI(const ComputePipelineDescriptor* rhs) {
        return reinterpret_cast<const wgpu::ComputePipelineDescriptor*>(rhs);
    }
    inline wgpu::ComputePipelineDescriptor* ToCppAPI(ComputePipelineDescriptor* rhs) {
        return reinterpret_cast<wgpu::ComputePipelineDescriptor*>(rhs);
    }
    inline const ComputePipelineDescriptor* FromCppAPI(const wgpu::ComputePipelineDescriptor* rhs) {
        return reinterpret_cast<const ComputePipelineDescriptor*>(rhs);
    }
    inline ComputePipelineDescriptor* FromCppAPI(wgpu::ComputePipelineDescriptor* rhs) {
        return reinterpret_cast<ComputePipelineDescriptor*>(rhs);
    }

    inline const WGPUDawnFormatCapabilities* ToAPI(const DawnFormatCapabilities* rhs) {
        return reinterpret_cast<const WGPUDawnFormatCapabilities*>(rhs);
    }
    inline WGPUDawnFormatCapabilities* ToAPI(DawnFormatCapabilities* rhs) {
        return reinterpret_cast<WGPUDawnFormatCapabilities*>(rhs);
    }
    inline const DawnFormatCapabilities* FromAPI(const WGPUDawnFormatCapabilities* rhs) {
        return reinterpret_cast<const DawnFormatCapabilities*>(rhs);
    }
    inline DawnFormatCapabilities* FromAPI(WGPUDawnFormatCapabilities* rhs) {
        return reinterpret_cast<DawnFormatCapabilities*>(rhs);
    }
    inline const wgpu::DawnFormatCapabilities* ToCppAPI(const DawnFormatCapabilities* rhs) {
        return reinterpret_cast<const wgpu::DawnFormatCapabilities*>(rhs);
    }
    inline wgpu::DawnFormatCapabilities* ToCppAPI(DawnFormatCapabilities* rhs) {
        return reinterpret_cast<wgpu::DawnFormatCapabilities*>(rhs);
    }
    inline const DawnFormatCapabilities* FromCppAPI(const wgpu::DawnFormatCapabilities* rhs) {
        return reinterpret_cast<const DawnFormatCapabilities*>(rhs);
    }
    inline DawnFormatCapabilities* FromCppAPI(wgpu::DawnFormatCapabilities* rhs) {
        return reinterpret_cast<DawnFormatCapabilities*>(rhs);
    }

    inline const WGPUDeviceDescriptor* ToAPI(const DeviceDescriptor* rhs) {
        return reinterpret_cast<const WGPUDeviceDescriptor*>(rhs);
    }
    inline WGPUDeviceDescriptor* ToAPI(DeviceDescriptor* rhs) {
        return reinterpret_cast<WGPUDeviceDescriptor*>(rhs);
    }
    inline const DeviceDescriptor* FromAPI(const WGPUDeviceDescriptor* rhs) {
        return reinterpret_cast<const DeviceDescriptor*>(rhs);
    }
    inline DeviceDescriptor* FromAPI(WGPUDeviceDescriptor* rhs) {
        return reinterpret_cast<DeviceDescriptor*>(rhs);
    }
    inline const wgpu::DeviceDescriptor* ToCppAPI(const DeviceDescriptor* rhs) {
        return reinterpret_cast<const wgpu::DeviceDescriptor*>(rhs);
    }
    inline wgpu::DeviceDescriptor* ToCppAPI(DeviceDescriptor* rhs) {
        return reinterpret_cast<wgpu::DeviceDescriptor*>(rhs);
    }
    inline const DeviceDescriptor* FromCppAPI(const wgpu::DeviceDescriptor* rhs) {
        return reinterpret_cast<const DeviceDescriptor*>(rhs);
    }
    inline DeviceDescriptor* FromCppAPI(wgpu::DeviceDescriptor* rhs) {
        return reinterpret_cast<DeviceDescriptor*>(rhs);
    }

    inline const WGPUPipelineLayoutDescriptor* ToAPI(const PipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<const WGPUPipelineLayoutDescriptor*>(rhs);
    }
    inline WGPUPipelineLayoutDescriptor* ToAPI(PipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<WGPUPipelineLayoutDescriptor*>(rhs);
    }
    inline const PipelineLayoutDescriptor* FromAPI(const WGPUPipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<const PipelineLayoutDescriptor*>(rhs);
    }
    inline PipelineLayoutDescriptor* FromAPI(WGPUPipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<PipelineLayoutDescriptor*>(rhs);
    }
    inline const wgpu::PipelineLayoutDescriptor* ToCppAPI(const PipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<const wgpu::PipelineLayoutDescriptor*>(rhs);
    }
    inline wgpu::PipelineLayoutDescriptor* ToCppAPI(PipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<wgpu::PipelineLayoutDescriptor*>(rhs);
    }
    inline const PipelineLayoutDescriptor* FromCppAPI(const wgpu::PipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<const PipelineLayoutDescriptor*>(rhs);
    }
    inline PipelineLayoutDescriptor* FromCppAPI(wgpu::PipelineLayoutDescriptor* rhs) {
        return reinterpret_cast<PipelineLayoutDescriptor*>(rhs);
    }

    inline const WGPURenderPassPixelLocalStorage* ToAPI(const RenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<const WGPURenderPassPixelLocalStorage*>(rhs);
    }
    inline WGPURenderPassPixelLocalStorage* ToAPI(RenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<WGPURenderPassPixelLocalStorage*>(rhs);
    }
    inline const RenderPassPixelLocalStorage* FromAPI(const WGPURenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<const RenderPassPixelLocalStorage*>(rhs);
    }
    inline RenderPassPixelLocalStorage* FromAPI(WGPURenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<RenderPassPixelLocalStorage*>(rhs);
    }
    inline const wgpu::RenderPassPixelLocalStorage* ToCppAPI(const RenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<const wgpu::RenderPassPixelLocalStorage*>(rhs);
    }
    inline wgpu::RenderPassPixelLocalStorage* ToCppAPI(RenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<wgpu::RenderPassPixelLocalStorage*>(rhs);
    }
    inline const RenderPassPixelLocalStorage* FromCppAPI(const wgpu::RenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<const RenderPassPixelLocalStorage*>(rhs);
    }
    inline RenderPassPixelLocalStorage* FromCppAPI(wgpu::RenderPassPixelLocalStorage* rhs) {
        return reinterpret_cast<RenderPassPixelLocalStorage*>(rhs);
    }

    inline const WGPUSharedTextureMemoryDescriptor* ToAPI(const SharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryDescriptor*>(rhs);
    }
    inline WGPUSharedTextureMemoryDescriptor* ToAPI(SharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryDescriptor* FromAPI(const WGPUSharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDescriptor*>(rhs);
    }
    inline SharedTextureMemoryDescriptor* FromAPI(WGPUSharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryDescriptor*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryDescriptor* ToCppAPI(const SharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryDescriptor*>(rhs);
    }
    inline wgpu::SharedTextureMemoryDescriptor* ToCppAPI(SharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryDescriptor*>(rhs);
    }
    inline const SharedTextureMemoryDescriptor* FromCppAPI(const wgpu::SharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<const SharedTextureMemoryDescriptor*>(rhs);
    }
    inline SharedTextureMemoryDescriptor* FromCppAPI(wgpu::SharedTextureMemoryDescriptor* rhs) {
        return reinterpret_cast<SharedTextureMemoryDescriptor*>(rhs);
    }

    inline const WGPUSharedTextureMemoryEndAccessState* ToAPI(const SharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryEndAccessState*>(rhs);
    }
    inline WGPUSharedTextureMemoryEndAccessState* ToAPI(SharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryEndAccessState*>(rhs);
    }
    inline const SharedTextureMemoryEndAccessState* FromAPI(const WGPUSharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryEndAccessState*>(rhs);
    }
    inline SharedTextureMemoryEndAccessState* FromAPI(WGPUSharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<SharedTextureMemoryEndAccessState*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryEndAccessState* ToCppAPI(const SharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryEndAccessState*>(rhs);
    }
    inline wgpu::SharedTextureMemoryEndAccessState* ToCppAPI(SharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryEndAccessState*>(rhs);
    }
    inline const SharedTextureMemoryEndAccessState* FromCppAPI(const wgpu::SharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<const SharedTextureMemoryEndAccessState*>(rhs);
    }
    inline SharedTextureMemoryEndAccessState* FromCppAPI(wgpu::SharedTextureMemoryEndAccessState* rhs) {
        return reinterpret_cast<SharedTextureMemoryEndAccessState*>(rhs);
    }

    inline const WGPUSharedTextureMemoryProperties* ToAPI(const SharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryProperties*>(rhs);
    }
    inline WGPUSharedTextureMemoryProperties* ToAPI(SharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryProperties*>(rhs);
    }
    inline const SharedTextureMemoryProperties* FromAPI(const WGPUSharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<const SharedTextureMemoryProperties*>(rhs);
    }
    inline SharedTextureMemoryProperties* FromAPI(WGPUSharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<SharedTextureMemoryProperties*>(rhs);
    }
    inline const wgpu::SharedTextureMemoryProperties* ToCppAPI(const SharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<const wgpu::SharedTextureMemoryProperties*>(rhs);
    }
    inline wgpu::SharedTextureMemoryProperties* ToCppAPI(SharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<wgpu::SharedTextureMemoryProperties*>(rhs);
    }
    inline const SharedTextureMemoryProperties* FromCppAPI(const wgpu::SharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<const SharedTextureMemoryProperties*>(rhs);
    }
    inline SharedTextureMemoryProperties* FromCppAPI(wgpu::SharedTextureMemoryProperties* rhs) {
        return reinterpret_cast<SharedTextureMemoryProperties*>(rhs);
    }

    inline const WGPUTextureViewDescriptor* ToAPI(const TextureViewDescriptor* rhs) {
        return reinterpret_cast<const WGPUTextureViewDescriptor*>(rhs);
    }
    inline WGPUTextureViewDescriptor* ToAPI(TextureViewDescriptor* rhs) {
        return reinterpret_cast<WGPUTextureViewDescriptor*>(rhs);
    }
    inline const TextureViewDescriptor* FromAPI(const WGPUTextureViewDescriptor* rhs) {
        return reinterpret_cast<const TextureViewDescriptor*>(rhs);
    }
    inline TextureViewDescriptor* FromAPI(WGPUTextureViewDescriptor* rhs) {
        return reinterpret_cast<TextureViewDescriptor*>(rhs);
    }
    inline const wgpu::TextureViewDescriptor* ToCppAPI(const TextureViewDescriptor* rhs) {
        return reinterpret_cast<const wgpu::TextureViewDescriptor*>(rhs);
    }
    inline wgpu::TextureViewDescriptor* ToCppAPI(TextureViewDescriptor* rhs) {
        return reinterpret_cast<wgpu::TextureViewDescriptor*>(rhs);
    }
    inline const TextureViewDescriptor* FromCppAPI(const wgpu::TextureViewDescriptor* rhs) {
        return reinterpret_cast<const TextureViewDescriptor*>(rhs);
    }
    inline TextureViewDescriptor* FromCppAPI(wgpu::TextureViewDescriptor* rhs) {
        return reinterpret_cast<TextureViewDescriptor*>(rhs);
    }

    inline const WGPUVertexState* ToAPI(const VertexState* rhs) {
        return reinterpret_cast<const WGPUVertexState*>(rhs);
    }
    inline WGPUVertexState* ToAPI(VertexState* rhs) {
        return reinterpret_cast<WGPUVertexState*>(rhs);
    }
    inline const VertexState* FromAPI(const WGPUVertexState* rhs) {
        return reinterpret_cast<const VertexState*>(rhs);
    }
    inline VertexState* FromAPI(WGPUVertexState* rhs) {
        return reinterpret_cast<VertexState*>(rhs);
    }
    inline const wgpu::VertexState* ToCppAPI(const VertexState* rhs) {
        return reinterpret_cast<const wgpu::VertexState*>(rhs);
    }
    inline wgpu::VertexState* ToCppAPI(VertexState* rhs) {
        return reinterpret_cast<wgpu::VertexState*>(rhs);
    }
    inline const VertexState* FromCppAPI(const wgpu::VertexState* rhs) {
        return reinterpret_cast<const VertexState*>(rhs);
    }
    inline VertexState* FromCppAPI(wgpu::VertexState* rhs) {
        return reinterpret_cast<VertexState*>(rhs);
    }

    inline const WGPUFragmentState* ToAPI(const FragmentState* rhs) {
        return reinterpret_cast<const WGPUFragmentState*>(rhs);
    }
    inline WGPUFragmentState* ToAPI(FragmentState* rhs) {
        return reinterpret_cast<WGPUFragmentState*>(rhs);
    }
    inline const FragmentState* FromAPI(const WGPUFragmentState* rhs) {
        return reinterpret_cast<const FragmentState*>(rhs);
    }
    inline FragmentState* FromAPI(WGPUFragmentState* rhs) {
        return reinterpret_cast<FragmentState*>(rhs);
    }
    inline const wgpu::FragmentState* ToCppAPI(const FragmentState* rhs) {
        return reinterpret_cast<const wgpu::FragmentState*>(rhs);
    }
    inline wgpu::FragmentState* ToCppAPI(FragmentState* rhs) {
        return reinterpret_cast<wgpu::FragmentState*>(rhs);
    }
    inline const FragmentState* FromCppAPI(const wgpu::FragmentState* rhs) {
        return reinterpret_cast<const FragmentState*>(rhs);
    }
    inline FragmentState* FromCppAPI(wgpu::FragmentState* rhs) {
        return reinterpret_cast<FragmentState*>(rhs);
    }

    inline const WGPURenderPassDescriptor* ToAPI(const RenderPassDescriptor* rhs) {
        return reinterpret_cast<const WGPURenderPassDescriptor*>(rhs);
    }
    inline WGPURenderPassDescriptor* ToAPI(RenderPassDescriptor* rhs) {
        return reinterpret_cast<WGPURenderPassDescriptor*>(rhs);
    }
    inline const RenderPassDescriptor* FromAPI(const WGPURenderPassDescriptor* rhs) {
        return reinterpret_cast<const RenderPassDescriptor*>(rhs);
    }
    inline RenderPassDescriptor* FromAPI(WGPURenderPassDescriptor* rhs) {
        return reinterpret_cast<RenderPassDescriptor*>(rhs);
    }
    inline const wgpu::RenderPassDescriptor* ToCppAPI(const RenderPassDescriptor* rhs) {
        return reinterpret_cast<const wgpu::RenderPassDescriptor*>(rhs);
    }
    inline wgpu::RenderPassDescriptor* ToCppAPI(RenderPassDescriptor* rhs) {
        return reinterpret_cast<wgpu::RenderPassDescriptor*>(rhs);
    }
    inline const RenderPassDescriptor* FromCppAPI(const wgpu::RenderPassDescriptor* rhs) {
        return reinterpret_cast<const RenderPassDescriptor*>(rhs);
    }
    inline RenderPassDescriptor* FromCppAPI(wgpu::RenderPassDescriptor* rhs) {
        return reinterpret_cast<RenderPassDescriptor*>(rhs);
    }

    inline const WGPURenderPipelineDescriptor* ToAPI(const RenderPipelineDescriptor* rhs) {
        return reinterpret_cast<const WGPURenderPipelineDescriptor*>(rhs);
    }
    inline WGPURenderPipelineDescriptor* ToAPI(RenderPipelineDescriptor* rhs) {
        return reinterpret_cast<WGPURenderPipelineDescriptor*>(rhs);
    }
    inline const RenderPipelineDescriptor* FromAPI(const WGPURenderPipelineDescriptor* rhs) {
        return reinterpret_cast<const RenderPipelineDescriptor*>(rhs);
    }
    inline RenderPipelineDescriptor* FromAPI(WGPURenderPipelineDescriptor* rhs) {
        return reinterpret_cast<RenderPipelineDescriptor*>(rhs);
    }
    inline const wgpu::RenderPipelineDescriptor* ToCppAPI(const RenderPipelineDescriptor* rhs) {
        return reinterpret_cast<const wgpu::RenderPipelineDescriptor*>(rhs);
    }
    inline wgpu::RenderPipelineDescriptor* ToCppAPI(RenderPipelineDescriptor* rhs) {
        return reinterpret_cast<wgpu::RenderPipelineDescriptor*>(rhs);
    }
    inline const RenderPipelineDescriptor* FromCppAPI(const wgpu::RenderPipelineDescriptor* rhs) {
        return reinterpret_cast<const RenderPipelineDescriptor*>(rhs);
    }
    inline RenderPipelineDescriptor* FromCppAPI(wgpu::RenderPipelineDescriptor* rhs) {
        return reinterpret_cast<RenderPipelineDescriptor*>(rhs);
    }


    inline const WGPUAdapterImpl* ToAPI(const AdapterBase* rhs) {
        return reinterpret_cast<const WGPUAdapterImpl*>(rhs);
    }

    inline WGPUAdapterImpl* ToAPI(AdapterBase* rhs) {
        return reinterpret_cast<WGPUAdapterImpl*>(rhs);
    }

    inline const AdapterBase* FromAPI(const WGPUAdapterImpl* rhs) {
        return reinterpret_cast<const AdapterBase*>(rhs);
    }

    inline AdapterBase* FromAPI(WGPUAdapterImpl* rhs) {
        return reinterpret_cast<AdapterBase*>(rhs);
    }
    inline const WGPUBindGroupImpl* ToAPI(const BindGroupBase* rhs) {
        return reinterpret_cast<const WGPUBindGroupImpl*>(rhs);
    }

    inline WGPUBindGroupImpl* ToAPI(BindGroupBase* rhs) {
        return reinterpret_cast<WGPUBindGroupImpl*>(rhs);
    }

    inline const BindGroupBase* FromAPI(const WGPUBindGroupImpl* rhs) {
        return reinterpret_cast<const BindGroupBase*>(rhs);
    }

    inline BindGroupBase* FromAPI(WGPUBindGroupImpl* rhs) {
        return reinterpret_cast<BindGroupBase*>(rhs);
    }
    inline const WGPUBindGroupLayoutImpl* ToAPI(const BindGroupLayoutBase* rhs) {
        return reinterpret_cast<const WGPUBindGroupLayoutImpl*>(rhs);
    }

    inline WGPUBindGroupLayoutImpl* ToAPI(BindGroupLayoutBase* rhs) {
        return reinterpret_cast<WGPUBindGroupLayoutImpl*>(rhs);
    }

    inline const BindGroupLayoutBase* FromAPI(const WGPUBindGroupLayoutImpl* rhs) {
        return reinterpret_cast<const BindGroupLayoutBase*>(rhs);
    }

    inline BindGroupLayoutBase* FromAPI(WGPUBindGroupLayoutImpl* rhs) {
        return reinterpret_cast<BindGroupLayoutBase*>(rhs);
    }
    inline const WGPUBufferImpl* ToAPI(const BufferBase* rhs) {
        return reinterpret_cast<const WGPUBufferImpl*>(rhs);
    }

    inline WGPUBufferImpl* ToAPI(BufferBase* rhs) {
        return reinterpret_cast<WGPUBufferImpl*>(rhs);
    }

    inline const BufferBase* FromAPI(const WGPUBufferImpl* rhs) {
        return reinterpret_cast<const BufferBase*>(rhs);
    }

    inline BufferBase* FromAPI(WGPUBufferImpl* rhs) {
        return reinterpret_cast<BufferBase*>(rhs);
    }
    inline const WGPUCommandBufferImpl* ToAPI(const CommandBufferBase* rhs) {
        return reinterpret_cast<const WGPUCommandBufferImpl*>(rhs);
    }

    inline WGPUCommandBufferImpl* ToAPI(CommandBufferBase* rhs) {
        return reinterpret_cast<WGPUCommandBufferImpl*>(rhs);
    }

    inline const CommandBufferBase* FromAPI(const WGPUCommandBufferImpl* rhs) {
        return reinterpret_cast<const CommandBufferBase*>(rhs);
    }

    inline CommandBufferBase* FromAPI(WGPUCommandBufferImpl* rhs) {
        return reinterpret_cast<CommandBufferBase*>(rhs);
    }
    inline const WGPUCommandEncoderImpl* ToAPI(const CommandEncoderBase* rhs) {
        return reinterpret_cast<const WGPUCommandEncoderImpl*>(rhs);
    }

    inline WGPUCommandEncoderImpl* ToAPI(CommandEncoderBase* rhs) {
        return reinterpret_cast<WGPUCommandEncoderImpl*>(rhs);
    }

    inline const CommandEncoderBase* FromAPI(const WGPUCommandEncoderImpl* rhs) {
        return reinterpret_cast<const CommandEncoderBase*>(rhs);
    }

    inline CommandEncoderBase* FromAPI(WGPUCommandEncoderImpl* rhs) {
        return reinterpret_cast<CommandEncoderBase*>(rhs);
    }
    inline const WGPUComputePassEncoderImpl* ToAPI(const ComputePassEncoderBase* rhs) {
        return reinterpret_cast<const WGPUComputePassEncoderImpl*>(rhs);
    }

    inline WGPUComputePassEncoderImpl* ToAPI(ComputePassEncoderBase* rhs) {
        return reinterpret_cast<WGPUComputePassEncoderImpl*>(rhs);
    }

    inline const ComputePassEncoderBase* FromAPI(const WGPUComputePassEncoderImpl* rhs) {
        return reinterpret_cast<const ComputePassEncoderBase*>(rhs);
    }

    inline ComputePassEncoderBase* FromAPI(WGPUComputePassEncoderImpl* rhs) {
        return reinterpret_cast<ComputePassEncoderBase*>(rhs);
    }
    inline const WGPUComputePipelineImpl* ToAPI(const ComputePipelineBase* rhs) {
        return reinterpret_cast<const WGPUComputePipelineImpl*>(rhs);
    }

    inline WGPUComputePipelineImpl* ToAPI(ComputePipelineBase* rhs) {
        return reinterpret_cast<WGPUComputePipelineImpl*>(rhs);
    }

    inline const ComputePipelineBase* FromAPI(const WGPUComputePipelineImpl* rhs) {
        return reinterpret_cast<const ComputePipelineBase*>(rhs);
    }

    inline ComputePipelineBase* FromAPI(WGPUComputePipelineImpl* rhs) {
        return reinterpret_cast<ComputePipelineBase*>(rhs);
    }
    inline const WGPUDeviceImpl* ToAPI(const DeviceBase* rhs) {
        return reinterpret_cast<const WGPUDeviceImpl*>(rhs);
    }

    inline WGPUDeviceImpl* ToAPI(DeviceBase* rhs) {
        return reinterpret_cast<WGPUDeviceImpl*>(rhs);
    }

    inline const DeviceBase* FromAPI(const WGPUDeviceImpl* rhs) {
        return reinterpret_cast<const DeviceBase*>(rhs);
    }

    inline DeviceBase* FromAPI(WGPUDeviceImpl* rhs) {
        return reinterpret_cast<DeviceBase*>(rhs);
    }
    inline const WGPUExternalTextureImpl* ToAPI(const ExternalTextureBase* rhs) {
        return reinterpret_cast<const WGPUExternalTextureImpl*>(rhs);
    }

    inline WGPUExternalTextureImpl* ToAPI(ExternalTextureBase* rhs) {
        return reinterpret_cast<WGPUExternalTextureImpl*>(rhs);
    }

    inline const ExternalTextureBase* FromAPI(const WGPUExternalTextureImpl* rhs) {
        return reinterpret_cast<const ExternalTextureBase*>(rhs);
    }

    inline ExternalTextureBase* FromAPI(WGPUExternalTextureImpl* rhs) {
        return reinterpret_cast<ExternalTextureBase*>(rhs);
    }
    inline const WGPUInstanceImpl* ToAPI(const InstanceBase* rhs) {
        return reinterpret_cast<const WGPUInstanceImpl*>(rhs);
    }

    inline WGPUInstanceImpl* ToAPI(InstanceBase* rhs) {
        return reinterpret_cast<WGPUInstanceImpl*>(rhs);
    }

    inline const InstanceBase* FromAPI(const WGPUInstanceImpl* rhs) {
        return reinterpret_cast<const InstanceBase*>(rhs);
    }

    inline InstanceBase* FromAPI(WGPUInstanceImpl* rhs) {
        return reinterpret_cast<InstanceBase*>(rhs);
    }
    inline const WGPUPipelineLayoutImpl* ToAPI(const PipelineLayoutBase* rhs) {
        return reinterpret_cast<const WGPUPipelineLayoutImpl*>(rhs);
    }

    inline WGPUPipelineLayoutImpl* ToAPI(PipelineLayoutBase* rhs) {
        return reinterpret_cast<WGPUPipelineLayoutImpl*>(rhs);
    }

    inline const PipelineLayoutBase* FromAPI(const WGPUPipelineLayoutImpl* rhs) {
        return reinterpret_cast<const PipelineLayoutBase*>(rhs);
    }

    inline PipelineLayoutBase* FromAPI(WGPUPipelineLayoutImpl* rhs) {
        return reinterpret_cast<PipelineLayoutBase*>(rhs);
    }
    inline const WGPUQuerySetImpl* ToAPI(const QuerySetBase* rhs) {
        return reinterpret_cast<const WGPUQuerySetImpl*>(rhs);
    }

    inline WGPUQuerySetImpl* ToAPI(QuerySetBase* rhs) {
        return reinterpret_cast<WGPUQuerySetImpl*>(rhs);
    }

    inline const QuerySetBase* FromAPI(const WGPUQuerySetImpl* rhs) {
        return reinterpret_cast<const QuerySetBase*>(rhs);
    }

    inline QuerySetBase* FromAPI(WGPUQuerySetImpl* rhs) {
        return reinterpret_cast<QuerySetBase*>(rhs);
    }
    inline const WGPUQueueImpl* ToAPI(const QueueBase* rhs) {
        return reinterpret_cast<const WGPUQueueImpl*>(rhs);
    }

    inline WGPUQueueImpl* ToAPI(QueueBase* rhs) {
        return reinterpret_cast<WGPUQueueImpl*>(rhs);
    }

    inline const QueueBase* FromAPI(const WGPUQueueImpl* rhs) {
        return reinterpret_cast<const QueueBase*>(rhs);
    }

    inline QueueBase* FromAPI(WGPUQueueImpl* rhs) {
        return reinterpret_cast<QueueBase*>(rhs);
    }
    inline const WGPURenderBundleImpl* ToAPI(const RenderBundleBase* rhs) {
        return reinterpret_cast<const WGPURenderBundleImpl*>(rhs);
    }

    inline WGPURenderBundleImpl* ToAPI(RenderBundleBase* rhs) {
        return reinterpret_cast<WGPURenderBundleImpl*>(rhs);
    }

    inline const RenderBundleBase* FromAPI(const WGPURenderBundleImpl* rhs) {
        return reinterpret_cast<const RenderBundleBase*>(rhs);
    }

    inline RenderBundleBase* FromAPI(WGPURenderBundleImpl* rhs) {
        return reinterpret_cast<RenderBundleBase*>(rhs);
    }
    inline const WGPURenderBundleEncoderImpl* ToAPI(const RenderBundleEncoderBase* rhs) {
        return reinterpret_cast<const WGPURenderBundleEncoderImpl*>(rhs);
    }

    inline WGPURenderBundleEncoderImpl* ToAPI(RenderBundleEncoderBase* rhs) {
        return reinterpret_cast<WGPURenderBundleEncoderImpl*>(rhs);
    }

    inline const RenderBundleEncoderBase* FromAPI(const WGPURenderBundleEncoderImpl* rhs) {
        return reinterpret_cast<const RenderBundleEncoderBase*>(rhs);
    }

    inline RenderBundleEncoderBase* FromAPI(WGPURenderBundleEncoderImpl* rhs) {
        return reinterpret_cast<RenderBundleEncoderBase*>(rhs);
    }
    inline const WGPURenderPassEncoderImpl* ToAPI(const RenderPassEncoderBase* rhs) {
        return reinterpret_cast<const WGPURenderPassEncoderImpl*>(rhs);
    }

    inline WGPURenderPassEncoderImpl* ToAPI(RenderPassEncoderBase* rhs) {
        return reinterpret_cast<WGPURenderPassEncoderImpl*>(rhs);
    }

    inline const RenderPassEncoderBase* FromAPI(const WGPURenderPassEncoderImpl* rhs) {
        return reinterpret_cast<const RenderPassEncoderBase*>(rhs);
    }

    inline RenderPassEncoderBase* FromAPI(WGPURenderPassEncoderImpl* rhs) {
        return reinterpret_cast<RenderPassEncoderBase*>(rhs);
    }
    inline const WGPURenderPipelineImpl* ToAPI(const RenderPipelineBase* rhs) {
        return reinterpret_cast<const WGPURenderPipelineImpl*>(rhs);
    }

    inline WGPURenderPipelineImpl* ToAPI(RenderPipelineBase* rhs) {
        return reinterpret_cast<WGPURenderPipelineImpl*>(rhs);
    }

    inline const RenderPipelineBase* FromAPI(const WGPURenderPipelineImpl* rhs) {
        return reinterpret_cast<const RenderPipelineBase*>(rhs);
    }

    inline RenderPipelineBase* FromAPI(WGPURenderPipelineImpl* rhs) {
        return reinterpret_cast<RenderPipelineBase*>(rhs);
    }
    inline const WGPUSamplerImpl* ToAPI(const SamplerBase* rhs) {
        return reinterpret_cast<const WGPUSamplerImpl*>(rhs);
    }

    inline WGPUSamplerImpl* ToAPI(SamplerBase* rhs) {
        return reinterpret_cast<WGPUSamplerImpl*>(rhs);
    }

    inline const SamplerBase* FromAPI(const WGPUSamplerImpl* rhs) {
        return reinterpret_cast<const SamplerBase*>(rhs);
    }

    inline SamplerBase* FromAPI(WGPUSamplerImpl* rhs) {
        return reinterpret_cast<SamplerBase*>(rhs);
    }
    inline const WGPUShaderModuleImpl* ToAPI(const ShaderModuleBase* rhs) {
        return reinterpret_cast<const WGPUShaderModuleImpl*>(rhs);
    }

    inline WGPUShaderModuleImpl* ToAPI(ShaderModuleBase* rhs) {
        return reinterpret_cast<WGPUShaderModuleImpl*>(rhs);
    }

    inline const ShaderModuleBase* FromAPI(const WGPUShaderModuleImpl* rhs) {
        return reinterpret_cast<const ShaderModuleBase*>(rhs);
    }

    inline ShaderModuleBase* FromAPI(WGPUShaderModuleImpl* rhs) {
        return reinterpret_cast<ShaderModuleBase*>(rhs);
    }
    inline const WGPUSharedBufferMemoryImpl* ToAPI(const SharedBufferMemoryBase* rhs) {
        return reinterpret_cast<const WGPUSharedBufferMemoryImpl*>(rhs);
    }

    inline WGPUSharedBufferMemoryImpl* ToAPI(SharedBufferMemoryBase* rhs) {
        return reinterpret_cast<WGPUSharedBufferMemoryImpl*>(rhs);
    }

    inline const SharedBufferMemoryBase* FromAPI(const WGPUSharedBufferMemoryImpl* rhs) {
        return reinterpret_cast<const SharedBufferMemoryBase*>(rhs);
    }

    inline SharedBufferMemoryBase* FromAPI(WGPUSharedBufferMemoryImpl* rhs) {
        return reinterpret_cast<SharedBufferMemoryBase*>(rhs);
    }
    inline const WGPUSharedFenceImpl* ToAPI(const SharedFenceBase* rhs) {
        return reinterpret_cast<const WGPUSharedFenceImpl*>(rhs);
    }

    inline WGPUSharedFenceImpl* ToAPI(SharedFenceBase* rhs) {
        return reinterpret_cast<WGPUSharedFenceImpl*>(rhs);
    }

    inline const SharedFenceBase* FromAPI(const WGPUSharedFenceImpl* rhs) {
        return reinterpret_cast<const SharedFenceBase*>(rhs);
    }

    inline SharedFenceBase* FromAPI(WGPUSharedFenceImpl* rhs) {
        return reinterpret_cast<SharedFenceBase*>(rhs);
    }
    inline const WGPUSharedTextureMemoryImpl* ToAPI(const SharedTextureMemoryBase* rhs) {
        return reinterpret_cast<const WGPUSharedTextureMemoryImpl*>(rhs);
    }

    inline WGPUSharedTextureMemoryImpl* ToAPI(SharedTextureMemoryBase* rhs) {
        return reinterpret_cast<WGPUSharedTextureMemoryImpl*>(rhs);
    }

    inline const SharedTextureMemoryBase* FromAPI(const WGPUSharedTextureMemoryImpl* rhs) {
        return reinterpret_cast<const SharedTextureMemoryBase*>(rhs);
    }

    inline SharedTextureMemoryBase* FromAPI(WGPUSharedTextureMemoryImpl* rhs) {
        return reinterpret_cast<SharedTextureMemoryBase*>(rhs);
    }
    inline const WGPUSurfaceImpl* ToAPI(const SurfaceBase* rhs) {
        return reinterpret_cast<const WGPUSurfaceImpl*>(rhs);
    }

    inline WGPUSurfaceImpl* ToAPI(SurfaceBase* rhs) {
        return reinterpret_cast<WGPUSurfaceImpl*>(rhs);
    }

    inline const SurfaceBase* FromAPI(const WGPUSurfaceImpl* rhs) {
        return reinterpret_cast<const SurfaceBase*>(rhs);
    }

    inline SurfaceBase* FromAPI(WGPUSurfaceImpl* rhs) {
        return reinterpret_cast<SurfaceBase*>(rhs);
    }
    inline const WGPUTexelBufferViewImpl* ToAPI(const TexelBufferViewBase* rhs) {
        return reinterpret_cast<const WGPUTexelBufferViewImpl*>(rhs);
    }

    inline WGPUTexelBufferViewImpl* ToAPI(TexelBufferViewBase* rhs) {
        return reinterpret_cast<WGPUTexelBufferViewImpl*>(rhs);
    }

    inline const TexelBufferViewBase* FromAPI(const WGPUTexelBufferViewImpl* rhs) {
        return reinterpret_cast<const TexelBufferViewBase*>(rhs);
    }

    inline TexelBufferViewBase* FromAPI(WGPUTexelBufferViewImpl* rhs) {
        return reinterpret_cast<TexelBufferViewBase*>(rhs);
    }
    inline const WGPUTextureImpl* ToAPI(const TextureBase* rhs) {
        return reinterpret_cast<const WGPUTextureImpl*>(rhs);
    }

    inline WGPUTextureImpl* ToAPI(TextureBase* rhs) {
        return reinterpret_cast<WGPUTextureImpl*>(rhs);
    }

    inline const TextureBase* FromAPI(const WGPUTextureImpl* rhs) {
        return reinterpret_cast<const TextureBase*>(rhs);
    }

    inline TextureBase* FromAPI(WGPUTextureImpl* rhs) {
        return reinterpret_cast<TextureBase*>(rhs);
    }
    inline const WGPUTextureViewImpl* ToAPI(const TextureViewBase* rhs) {
        return reinterpret_cast<const WGPUTextureViewImpl*>(rhs);
    }

    inline WGPUTextureViewImpl* ToAPI(TextureViewBase* rhs) {
        return reinterpret_cast<WGPUTextureViewImpl*>(rhs);
    }

    inline const TextureViewBase* FromAPI(const WGPUTextureViewImpl* rhs) {
        return reinterpret_cast<const TextureViewBase*>(rhs);
    }

    inline TextureViewBase* FromAPI(WGPUTextureViewImpl* rhs) {
        return reinterpret_cast<TextureViewBase*>(rhs);
    }

    template <typename T>
    struct EnumCount;

    template<>
    struct EnumCount<wgpu::AddressMode> {
        static constexpr uint32_t value = 4;
    };
    template<>
    struct EnumCount<wgpu::BackendType> {
        static constexpr uint32_t value = 9;
    };
    template<>
    struct EnumCount<wgpu::BlendFactor> {
        static constexpr uint32_t value = 18;
    };
    template<>
    struct EnumCount<wgpu::BlendOperation> {
        static constexpr uint32_t value = 6;
    };
    template<>
    struct EnumCount<wgpu::BufferBindingType> {
        static constexpr uint32_t value = 5;
    };
    template<>
    struct EnumCount<wgpu::CompareFunction> {
        static constexpr uint32_t value = 9;
    };
    template<>
    struct EnumCount<wgpu::ComponentSwizzle> {
        static constexpr uint32_t value = 7;
    };
    template<>
    struct EnumCount<wgpu::CompositeAlphaMode> {
        static constexpr uint32_t value = 5;
    };
    template<>
    struct EnumCount<wgpu::CullMode> {
        static constexpr uint32_t value = 4;
    };
    template<>
    struct EnumCount<wgpu::DynamicBindingKind> {
        static constexpr uint32_t value = 2;
    };
    template<>
    struct EnumCount<wgpu::FeatureLevel> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::FilterMode> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::FrontFace> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::IndexFormat> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::MipmapFilterMode> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::OptionalBool> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::PowerPreference> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::PresentMode> {
        static constexpr uint32_t value = 5;
    };
    template<>
    struct EnumCount<wgpu::PrimitiveTopology> {
        static constexpr uint32_t value = 6;
    };
    template<>
    struct EnumCount<wgpu::SamplerBindingType> {
        static constexpr uint32_t value = 5;
    };
    template<>
    struct EnumCount<wgpu::StencilOperation> {
        static constexpr uint32_t value = 9;
    };
    template<>
    struct EnumCount<wgpu::StorageTextureAccess> {
        static constexpr uint32_t value = 5;
    };
    template<>
    struct EnumCount<wgpu::StoreOp> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::TexelBufferAccess> {
        static constexpr uint32_t value = 3;
    };
    template<>
    struct EnumCount<wgpu::TextureDimension> {
        static constexpr uint32_t value = 4;
    };
    template<>
    struct EnumCount<wgpu::TextureSampleType> {
        static constexpr uint32_t value = 7;
    };
    template<>
    struct EnumCount<wgpu::TextureViewDimension> {
        static constexpr uint32_t value = 7;
    };
    template<>
    struct EnumCount<wgpu::VertexStepMode> {
        static constexpr uint32_t value = 3;
    };

    inline WGPUAdapterType ToAPI(wgpu::AdapterType rhs) {
        return static_cast<WGPUAdapterType>(rhs);
    }
    inline WGPUAddressMode ToAPI(wgpu::AddressMode rhs) {
        return static_cast<WGPUAddressMode>(rhs);
    }
    inline WGPUAlphaMode ToAPI(wgpu::AlphaMode rhs) {
        return static_cast<WGPUAlphaMode>(rhs);
    }
    inline WGPUBackendType ToAPI(wgpu::BackendType rhs) {
        return static_cast<WGPUBackendType>(rhs);
    }
    inline WGPUBlendFactor ToAPI(wgpu::BlendFactor rhs) {
        return static_cast<WGPUBlendFactor>(rhs);
    }
    inline WGPUBlendOperation ToAPI(wgpu::BlendOperation rhs) {
        return static_cast<WGPUBlendOperation>(rhs);
    }
    inline WGPUBufferBindingType ToAPI(wgpu::BufferBindingType rhs) {
        return static_cast<WGPUBufferBindingType>(rhs);
    }
    inline WGPUBufferMapState ToAPI(wgpu::BufferMapState rhs) {
        return static_cast<WGPUBufferMapState>(rhs);
    }
    inline WGPUCallbackMode ToAPI(wgpu::CallbackMode rhs) {
        return static_cast<WGPUCallbackMode>(rhs);
    }
    inline WGPUCompareFunction ToAPI(wgpu::CompareFunction rhs) {
        return static_cast<WGPUCompareFunction>(rhs);
    }
    inline WGPUCompilationInfoRequestStatus ToAPI(wgpu::CompilationInfoRequestStatus rhs) {
        return static_cast<WGPUCompilationInfoRequestStatus>(rhs);
    }
    inline WGPUCompilationMessageType ToAPI(wgpu::CompilationMessageType rhs) {
        return static_cast<WGPUCompilationMessageType>(rhs);
    }
    inline WGPUComponentSwizzle ToAPI(wgpu::ComponentSwizzle rhs) {
        return static_cast<WGPUComponentSwizzle>(rhs);
    }
    inline WGPUCompositeAlphaMode ToAPI(wgpu::CompositeAlphaMode rhs) {
        return static_cast<WGPUCompositeAlphaMode>(rhs);
    }
    inline WGPUCreatePipelineAsyncStatus ToAPI(wgpu::CreatePipelineAsyncStatus rhs) {
        return static_cast<WGPUCreatePipelineAsyncStatus>(rhs);
    }
    inline WGPUCullMode ToAPI(wgpu::CullMode rhs) {
        return static_cast<WGPUCullMode>(rhs);
    }
    inline WGPUDeviceLostReason ToAPI(wgpu::DeviceLostReason rhs) {
        return static_cast<WGPUDeviceLostReason>(rhs);
    }
    inline WGPUDynamicBindingKind ToAPI(wgpu::DynamicBindingKind rhs) {
        return static_cast<WGPUDynamicBindingKind>(rhs);
    }
    inline WGPUErrorFilter ToAPI(wgpu::ErrorFilter rhs) {
        return static_cast<WGPUErrorFilter>(rhs);
    }
    inline WGPUErrorType ToAPI(wgpu::ErrorType rhs) {
        return static_cast<WGPUErrorType>(rhs);
    }
    inline WGPUExternalTextureRotation ToAPI(wgpu::ExternalTextureRotation rhs) {
        return static_cast<WGPUExternalTextureRotation>(rhs);
    }
    inline WGPUFeatureLevel ToAPI(wgpu::FeatureLevel rhs) {
        return static_cast<WGPUFeatureLevel>(rhs);
    }
    inline WGPUFeatureName ToAPI(wgpu::FeatureName rhs) {
        return static_cast<WGPUFeatureName>(rhs);
    }
    inline WGPUFilterMode ToAPI(wgpu::FilterMode rhs) {
        return static_cast<WGPUFilterMode>(rhs);
    }
    inline WGPUFrontFace ToAPI(wgpu::FrontFace rhs) {
        return static_cast<WGPUFrontFace>(rhs);
    }
    inline WGPUIndexFormat ToAPI(wgpu::IndexFormat rhs) {
        return static_cast<WGPUIndexFormat>(rhs);
    }
    inline WGPUInstanceFeatureName ToAPI(wgpu::InstanceFeatureName rhs) {
        return static_cast<WGPUInstanceFeatureName>(rhs);
    }
    inline WGPULoadOp ToAPI(wgpu::LoadOp rhs) {
        return static_cast<WGPULoadOp>(rhs);
    }
    inline WGPULoggingType ToAPI(wgpu::LoggingType rhs) {
        return static_cast<WGPULoggingType>(rhs);
    }
    inline WGPUMapAsyncStatus ToAPI(wgpu::MapAsyncStatus rhs) {
        return static_cast<WGPUMapAsyncStatus>(rhs);
    }
    inline WGPUMipmapFilterMode ToAPI(wgpu::MipmapFilterMode rhs) {
        return static_cast<WGPUMipmapFilterMode>(rhs);
    }
    inline WGPUOptionalBool ToAPI(wgpu::OptionalBool rhs) {
        return static_cast<WGPUOptionalBool>(rhs);
    }
    inline WGPUPopErrorScopeStatus ToAPI(wgpu::PopErrorScopeStatus rhs) {
        return static_cast<WGPUPopErrorScopeStatus>(rhs);
    }
    inline WGPUPowerPreference ToAPI(wgpu::PowerPreference rhs) {
        return static_cast<WGPUPowerPreference>(rhs);
    }
    inline WGPUPredefinedColorSpace ToAPI(wgpu::PredefinedColorSpace rhs) {
        return static_cast<WGPUPredefinedColorSpace>(rhs);
    }
    inline WGPUPresentMode ToAPI(wgpu::PresentMode rhs) {
        return static_cast<WGPUPresentMode>(rhs);
    }
    inline WGPUPrimitiveTopology ToAPI(wgpu::PrimitiveTopology rhs) {
        return static_cast<WGPUPrimitiveTopology>(rhs);
    }
    inline WGPUQueryType ToAPI(wgpu::QueryType rhs) {
        return static_cast<WGPUQueryType>(rhs);
    }
    inline WGPUQueueWorkDoneStatus ToAPI(wgpu::QueueWorkDoneStatus rhs) {
        return static_cast<WGPUQueueWorkDoneStatus>(rhs);
    }
    inline WGPURequestAdapterStatus ToAPI(wgpu::RequestAdapterStatus rhs) {
        return static_cast<WGPURequestAdapterStatus>(rhs);
    }
    inline WGPURequestDeviceStatus ToAPI(wgpu::RequestDeviceStatus rhs) {
        return static_cast<WGPURequestDeviceStatus>(rhs);
    }
    inline WGPUSamplerBindingType ToAPI(wgpu::SamplerBindingType rhs) {
        return static_cast<WGPUSamplerBindingType>(rhs);
    }
    inline WGPUSharedFenceType ToAPI(wgpu::SharedFenceType rhs) {
        return static_cast<WGPUSharedFenceType>(rhs);
    }
    inline WGPUStatus ToAPI(wgpu::Status rhs) {
        return static_cast<WGPUStatus>(rhs);
    }
    inline WGPUStencilOperation ToAPI(wgpu::StencilOperation rhs) {
        return static_cast<WGPUStencilOperation>(rhs);
    }
    inline WGPUStorageTextureAccess ToAPI(wgpu::StorageTextureAccess rhs) {
        return static_cast<WGPUStorageTextureAccess>(rhs);
    }
    inline WGPUStoreOp ToAPI(wgpu::StoreOp rhs) {
        return static_cast<WGPUStoreOp>(rhs);
    }
    inline WGPUSType ToAPI(wgpu::SType rhs) {
        return static_cast<WGPUSType>(rhs);
    }
    inline WGPUSubgroupMatrixComponentType ToAPI(wgpu::SubgroupMatrixComponentType rhs) {
        return static_cast<WGPUSubgroupMatrixComponentType>(rhs);
    }
    inline WGPUSurfaceGetCurrentTextureStatus ToAPI(wgpu::SurfaceGetCurrentTextureStatus rhs) {
        return static_cast<WGPUSurfaceGetCurrentTextureStatus>(rhs);
    }
    inline WGPUTexelBufferAccess ToAPI(wgpu::TexelBufferAccess rhs) {
        return static_cast<WGPUTexelBufferAccess>(rhs);
    }
    inline WGPUTextureAspect ToAPI(wgpu::TextureAspect rhs) {
        return static_cast<WGPUTextureAspect>(rhs);
    }
    inline WGPUTextureDimension ToAPI(wgpu::TextureDimension rhs) {
        return static_cast<WGPUTextureDimension>(rhs);
    }
    inline WGPUTextureFormat ToAPI(wgpu::TextureFormat rhs) {
        return static_cast<WGPUTextureFormat>(rhs);
    }
    inline WGPUTextureSampleType ToAPI(wgpu::TextureSampleType rhs) {
        return static_cast<WGPUTextureSampleType>(rhs);
    }
    inline WGPUTextureViewDimension ToAPI(wgpu::TextureViewDimension rhs) {
        return static_cast<WGPUTextureViewDimension>(rhs);
    }
    inline WGPUToneMappingMode ToAPI(wgpu::ToneMappingMode rhs) {
        return static_cast<WGPUToneMappingMode>(rhs);
    }
    inline WGPUVertexFormat ToAPI(wgpu::VertexFormat rhs) {
        return static_cast<WGPUVertexFormat>(rhs);
    }
    inline WGPUVertexStepMode ToAPI(wgpu::VertexStepMode rhs) {
        return static_cast<WGPUVertexStepMode>(rhs);
    }
    inline WGPUWaitStatus ToAPI(wgpu::WaitStatus rhs) {
        return static_cast<WGPUWaitStatus>(rhs);
    }
    inline WGPUWGSLLanguageFeatureName ToAPI(wgpu::WGSLLanguageFeatureName rhs) {
        return static_cast<WGPUWGSLLanguageFeatureName>(rhs);
    }
    inline WGPUBufferUsage ToAPI(wgpu::BufferUsage rhs) {
        return static_cast<WGPUBufferUsage>(rhs);
    }
    inline WGPUColorWriteMask ToAPI(wgpu::ColorWriteMask rhs) {
        return static_cast<WGPUColorWriteMask>(rhs);
    }
    inline WGPUHeapProperty ToAPI(wgpu::HeapProperty rhs) {
        return static_cast<WGPUHeapProperty>(rhs);
    }
    inline WGPUMapMode ToAPI(wgpu::MapMode rhs) {
        return static_cast<WGPUMapMode>(rhs);
    }
    inline WGPUShaderStage ToAPI(wgpu::ShaderStage rhs) {
        return static_cast<WGPUShaderStage>(rhs);
    }
    inline WGPUTextureUsage ToAPI(wgpu::TextureUsage rhs) {
        return static_cast<WGPUTextureUsage>(rhs);
    }

    inline wgpu::AdapterType FromAPI(WGPUAdapterType rhs) {
        return static_cast<wgpu::AdapterType>(rhs);
    }
    inline wgpu::AddressMode FromAPI(WGPUAddressMode rhs) {
        return static_cast<wgpu::AddressMode>(rhs);
    }
    inline wgpu::AlphaMode FromAPI(WGPUAlphaMode rhs) {
        return static_cast<wgpu::AlphaMode>(rhs);
    }
    inline wgpu::BackendType FromAPI(WGPUBackendType rhs) {
        return static_cast<wgpu::BackendType>(rhs);
    }
    inline wgpu::BlendFactor FromAPI(WGPUBlendFactor rhs) {
        return static_cast<wgpu::BlendFactor>(rhs);
    }
    inline wgpu::BlendOperation FromAPI(WGPUBlendOperation rhs) {
        return static_cast<wgpu::BlendOperation>(rhs);
    }
    inline wgpu::BufferBindingType FromAPI(WGPUBufferBindingType rhs) {
        return static_cast<wgpu::BufferBindingType>(rhs);
    }
    inline wgpu::BufferMapState FromAPI(WGPUBufferMapState rhs) {
        return static_cast<wgpu::BufferMapState>(rhs);
    }
    inline wgpu::CallbackMode FromAPI(WGPUCallbackMode rhs) {
        return static_cast<wgpu::CallbackMode>(rhs);
    }
    inline wgpu::CompareFunction FromAPI(WGPUCompareFunction rhs) {
        return static_cast<wgpu::CompareFunction>(rhs);
    }
    inline wgpu::CompilationInfoRequestStatus FromAPI(WGPUCompilationInfoRequestStatus rhs) {
        return static_cast<wgpu::CompilationInfoRequestStatus>(rhs);
    }
    inline wgpu::CompilationMessageType FromAPI(WGPUCompilationMessageType rhs) {
        return static_cast<wgpu::CompilationMessageType>(rhs);
    }
    inline wgpu::ComponentSwizzle FromAPI(WGPUComponentSwizzle rhs) {
        return static_cast<wgpu::ComponentSwizzle>(rhs);
    }
    inline wgpu::CompositeAlphaMode FromAPI(WGPUCompositeAlphaMode rhs) {
        return static_cast<wgpu::CompositeAlphaMode>(rhs);
    }
    inline wgpu::CreatePipelineAsyncStatus FromAPI(WGPUCreatePipelineAsyncStatus rhs) {
        return static_cast<wgpu::CreatePipelineAsyncStatus>(rhs);
    }
    inline wgpu::CullMode FromAPI(WGPUCullMode rhs) {
        return static_cast<wgpu::CullMode>(rhs);
    }
    inline wgpu::DeviceLostReason FromAPI(WGPUDeviceLostReason rhs) {
        return static_cast<wgpu::DeviceLostReason>(rhs);
    }
    inline wgpu::DynamicBindingKind FromAPI(WGPUDynamicBindingKind rhs) {
        return static_cast<wgpu::DynamicBindingKind>(rhs);
    }
    inline wgpu::ErrorFilter FromAPI(WGPUErrorFilter rhs) {
        return static_cast<wgpu::ErrorFilter>(rhs);
    }
    inline wgpu::ErrorType FromAPI(WGPUErrorType rhs) {
        return static_cast<wgpu::ErrorType>(rhs);
    }
    inline wgpu::ExternalTextureRotation FromAPI(WGPUExternalTextureRotation rhs) {
        return static_cast<wgpu::ExternalTextureRotation>(rhs);
    }
    inline wgpu::FeatureLevel FromAPI(WGPUFeatureLevel rhs) {
        return static_cast<wgpu::FeatureLevel>(rhs);
    }
    inline wgpu::FeatureName FromAPI(WGPUFeatureName rhs) {
        return static_cast<wgpu::FeatureName>(rhs);
    }
    inline wgpu::FilterMode FromAPI(WGPUFilterMode rhs) {
        return static_cast<wgpu::FilterMode>(rhs);
    }
    inline wgpu::FrontFace FromAPI(WGPUFrontFace rhs) {
        return static_cast<wgpu::FrontFace>(rhs);
    }
    inline wgpu::IndexFormat FromAPI(WGPUIndexFormat rhs) {
        return static_cast<wgpu::IndexFormat>(rhs);
    }
    inline wgpu::InstanceFeatureName FromAPI(WGPUInstanceFeatureName rhs) {
        return static_cast<wgpu::InstanceFeatureName>(rhs);
    }
    inline wgpu::LoadOp FromAPI(WGPULoadOp rhs) {
        return static_cast<wgpu::LoadOp>(rhs);
    }
    inline wgpu::LoggingType FromAPI(WGPULoggingType rhs) {
        return static_cast<wgpu::LoggingType>(rhs);
    }
    inline wgpu::MapAsyncStatus FromAPI(WGPUMapAsyncStatus rhs) {
        return static_cast<wgpu::MapAsyncStatus>(rhs);
    }
    inline wgpu::MipmapFilterMode FromAPI(WGPUMipmapFilterMode rhs) {
        return static_cast<wgpu::MipmapFilterMode>(rhs);
    }
    inline wgpu::OptionalBool FromAPI(WGPUOptionalBool rhs) {
        return static_cast<wgpu::OptionalBool>(rhs);
    }
    inline wgpu::PopErrorScopeStatus FromAPI(WGPUPopErrorScopeStatus rhs) {
        return static_cast<wgpu::PopErrorScopeStatus>(rhs);
    }
    inline wgpu::PowerPreference FromAPI(WGPUPowerPreference rhs) {
        return static_cast<wgpu::PowerPreference>(rhs);
    }
    inline wgpu::PredefinedColorSpace FromAPI(WGPUPredefinedColorSpace rhs) {
        return static_cast<wgpu::PredefinedColorSpace>(rhs);
    }
    inline wgpu::PresentMode FromAPI(WGPUPresentMode rhs) {
        return static_cast<wgpu::PresentMode>(rhs);
    }
    inline wgpu::PrimitiveTopology FromAPI(WGPUPrimitiveTopology rhs) {
        return static_cast<wgpu::PrimitiveTopology>(rhs);
    }
    inline wgpu::QueryType FromAPI(WGPUQueryType rhs) {
        return static_cast<wgpu::QueryType>(rhs);
    }
    inline wgpu::QueueWorkDoneStatus FromAPI(WGPUQueueWorkDoneStatus rhs) {
        return static_cast<wgpu::QueueWorkDoneStatus>(rhs);
    }
    inline wgpu::RequestAdapterStatus FromAPI(WGPURequestAdapterStatus rhs) {
        return static_cast<wgpu::RequestAdapterStatus>(rhs);
    }
    inline wgpu::RequestDeviceStatus FromAPI(WGPURequestDeviceStatus rhs) {
        return static_cast<wgpu::RequestDeviceStatus>(rhs);
    }
    inline wgpu::SamplerBindingType FromAPI(WGPUSamplerBindingType rhs) {
        return static_cast<wgpu::SamplerBindingType>(rhs);
    }
    inline wgpu::SharedFenceType FromAPI(WGPUSharedFenceType rhs) {
        return static_cast<wgpu::SharedFenceType>(rhs);
    }
    inline wgpu::Status FromAPI(WGPUStatus rhs) {
        return static_cast<wgpu::Status>(rhs);
    }
    inline wgpu::StencilOperation FromAPI(WGPUStencilOperation rhs) {
        return static_cast<wgpu::StencilOperation>(rhs);
    }
    inline wgpu::StorageTextureAccess FromAPI(WGPUStorageTextureAccess rhs) {
        return static_cast<wgpu::StorageTextureAccess>(rhs);
    }
    inline wgpu::StoreOp FromAPI(WGPUStoreOp rhs) {
        return static_cast<wgpu::StoreOp>(rhs);
    }
    inline wgpu::SType FromAPI(WGPUSType rhs) {
        return static_cast<wgpu::SType>(rhs);
    }
    inline wgpu::SubgroupMatrixComponentType FromAPI(WGPUSubgroupMatrixComponentType rhs) {
        return static_cast<wgpu::SubgroupMatrixComponentType>(rhs);
    }
    inline wgpu::SurfaceGetCurrentTextureStatus FromAPI(WGPUSurfaceGetCurrentTextureStatus rhs) {
        return static_cast<wgpu::SurfaceGetCurrentTextureStatus>(rhs);
    }
    inline wgpu::TexelBufferAccess FromAPI(WGPUTexelBufferAccess rhs) {
        return static_cast<wgpu::TexelBufferAccess>(rhs);
    }
    inline wgpu::TextureAspect FromAPI(WGPUTextureAspect rhs) {
        return static_cast<wgpu::TextureAspect>(rhs);
    }
    inline wgpu::TextureDimension FromAPI(WGPUTextureDimension rhs) {
        return static_cast<wgpu::TextureDimension>(rhs);
    }
    inline wgpu::TextureFormat FromAPI(WGPUTextureFormat rhs) {
        return static_cast<wgpu::TextureFormat>(rhs);
    }
    inline wgpu::TextureSampleType FromAPI(WGPUTextureSampleType rhs) {
        return static_cast<wgpu::TextureSampleType>(rhs);
    }
    inline wgpu::TextureViewDimension FromAPI(WGPUTextureViewDimension rhs) {
        return static_cast<wgpu::TextureViewDimension>(rhs);
    }
    inline wgpu::ToneMappingMode FromAPI(WGPUToneMappingMode rhs) {
        return static_cast<wgpu::ToneMappingMode>(rhs);
    }
    inline wgpu::VertexFormat FromAPI(WGPUVertexFormat rhs) {
        return static_cast<wgpu::VertexFormat>(rhs);
    }
    inline wgpu::VertexStepMode FromAPI(WGPUVertexStepMode rhs) {
        return static_cast<wgpu::VertexStepMode>(rhs);
    }
    inline wgpu::WaitStatus FromAPI(WGPUWaitStatus rhs) {
        return static_cast<wgpu::WaitStatus>(rhs);
    }
    inline wgpu::WGSLLanguageFeatureName FromAPI(WGPUWGSLLanguageFeatureName rhs) {
        return static_cast<wgpu::WGSLLanguageFeatureName>(rhs);
    }
}  // namespace dawn::native

#endif  // DAWNNATIVE_DAWN_PLATFORM_AUTOGEN_H_
