// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/web_runtime_features_base.cc.tmpl
// and input files:
//   ../../third_party/blink/renderer/platform/runtime_enabled_features.json5


#include "third_party/blink/public/platform/web_runtime_features_base.h"

#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {

// static
void WebRuntimeFeaturesBase::EnableAccessibilityAriaVirtualContent(bool enable) {
  RuntimeEnabledFeatures::SetAccessibilityAriaVirtualContentEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAccessibilityAriaVirtualContentEnabled() {
  return RuntimeEnabledFeatures::AccessibilityAriaVirtualContentEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAccessibilityCustomElementRoleNone(bool enable) {
  RuntimeEnabledFeatures::SetAccessibilityCustomElementRoleNoneEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAccessibilityCustomElementRoleNoneEnabled() {
  return RuntimeEnabledFeatures::AccessibilityCustomElementRoleNoneEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAccessibilityOSLevelBoldText(bool enable) {
  RuntimeEnabledFeatures::SetAccessibilityOSLevelBoldTextEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAccessibilityOSLevelBoldTextEnabled() {
  return RuntimeEnabledFeatures::AccessibilityOSLevelBoldTextEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAccessibilityUseAXPositionForDocumentMarkers(bool enable) {
  RuntimeEnabledFeatures::SetAccessibilityUseAXPositionForDocumentMarkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAccessibilityUseAXPositionForDocumentMarkersEnabled() {
  return RuntimeEnabledFeatures::AccessibilityUseAXPositionForDocumentMarkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAdInterestGroupAPI(bool enable) {
  RuntimeEnabledFeatures::SetAdInterestGroupAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAdInterestGroupAPIEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::AdInterestGroupAPIEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableAdTagging(bool enable) {
  RuntimeEnabledFeatures::SetAdTaggingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAdTaggingEnabled() {
  return RuntimeEnabledFeatures::AdTaggingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAIPromptAPI(bool enable) {
  RuntimeEnabledFeatures::SetAIPromptAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAIPromptAPIEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::AIPromptAPIEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableAIPromptAPIForExtension(bool enable) {
  RuntimeEnabledFeatures::SetAIPromptAPIForExtensionEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAIPromptAPIForExtensionEnabled() {
  return RuntimeEnabledFeatures::AIPromptAPIForExtensionEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAIPromptAPIForWorkers(bool enable) {
  RuntimeEnabledFeatures::SetAIPromptAPIForWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAIPromptAPIForWorkersEnabled() {
  return RuntimeEnabledFeatures::AIPromptAPIForWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAIRewriterAPIForWorkers(bool enable) {
  RuntimeEnabledFeatures::SetAIRewriterAPIForWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAIRewriterAPIForWorkersEnabled() {
  return RuntimeEnabledFeatures::AIRewriterAPIForWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAISummarizationAPIForWorkers(bool enable) {
  RuntimeEnabledFeatures::SetAISummarizationAPIForWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAISummarizationAPIForWorkersEnabled() {
  return RuntimeEnabledFeatures::AISummarizationAPIForWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAIWriterAPIForWorkers(bool enable) {
  RuntimeEnabledFeatures::SetAIWriterAPIForWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAIWriterAPIForWorkersEnabled() {
  return RuntimeEnabledFeatures::AIWriterAPIForWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAndroidDownloadableFontsMatching(bool enable) {
  RuntimeEnabledFeatures::SetAndroidDownloadableFontsMatchingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAndroidDownloadableFontsMatchingEnabled() {
  return RuntimeEnabledFeatures::AndroidDownloadableFontsMatchingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAOMAriaRelationshipProperties(bool enable) {
  RuntimeEnabledFeatures::SetAOMAriaRelationshipPropertiesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAOMAriaRelationshipPropertiesEnabled() {
  return RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAOMAriaRelationshipPropertiesAriaOwns(bool enable) {
  RuntimeEnabledFeatures::SetAOMAriaRelationshipPropertiesAriaOwnsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAOMAriaRelationshipPropertiesAriaOwnsEnabled() {
  return RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesAriaOwnsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAttributionReporting(bool enable) {
  RuntimeEnabledFeatures::SetAttributionReportingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAttributionReportingEnabled() {
  return RuntimeEnabledFeatures::AttributionReportingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAudioOutputDevices(bool enable) {
  RuntimeEnabledFeatures::SetAudioOutputDevicesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAudioOutputDevicesEnabled() {
  return RuntimeEnabledFeatures::AudioOutputDevicesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAuthenticatorPasswordsOnlyImmediateRequests(bool enable) {
  RuntimeEnabledFeatures::SetAuthenticatorPasswordsOnlyImmediateRequestsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAuthenticatorPasswordsOnlyImmediateRequestsEnabled() {
  return RuntimeEnabledFeatures::AuthenticatorPasswordsOnlyImmediateRequestsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAutofill(bool enable) {
  RuntimeEnabledFeatures::SetAutofillEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAutofillEnabled() {
  return RuntimeEnabledFeatures::AutofillEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableAutomationControlled(bool enable) {
  RuntimeEnabledFeatures::SetAutomationControlledEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsAutomationControlledEnabled() {
  return RuntimeEnabledFeatures::AutomationControlledEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBackForwardCache(bool enable) {
  RuntimeEnabledFeatures::SetBackForwardCacheEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBackForwardCacheEnabled() {
  return RuntimeEnabledFeatures::BackForwardCacheEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBackgroundFetch(bool enable) {
  RuntimeEnabledFeatures::SetBackgroundFetchEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBackgroundFetchEnabled() {
  return RuntimeEnabledFeatures::BackgroundFetchEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBlinkExtensionWebView(bool enable) {
  RuntimeEnabledFeatures::SetBlinkExtensionWebViewEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBlinkExtensionWebViewEnabled() {
  return RuntimeEnabledFeatures::BlinkExtensionWebViewEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBlinkExtensionWebViewMediaIntegrity(bool enable) {
  RuntimeEnabledFeatures::SetBlinkExtensionWebViewMediaIntegrityEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBlinkExtensionWebViewMediaIntegrityEnabled() {
  return RuntimeEnabledFeatures::BlinkExtensionWebViewMediaIntegrityEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBoundaryEventDispatchTracksNodeRemoval(bool enable) {
  RuntimeEnabledFeatures::SetBoundaryEventDispatchTracksNodeRemovalEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBoundaryEventDispatchTracksNodeRemovalEnabled() {
  return RuntimeEnabledFeatures::BoundaryEventDispatchTracksNodeRemovalEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBrowserInitiatedAutomaticPictureInPicture(bool enable) {
  RuntimeEnabledFeatures::SetBrowserInitiatedAutomaticPictureInPictureEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBrowserInitiatedAutomaticPictureInPictureEnabled() {
  return RuntimeEnabledFeatures::BrowserInitiatedAutomaticPictureInPictureEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBrowserVerifiedUserActivationKeyboard(bool enable) {
  RuntimeEnabledFeatures::SetBrowserVerifiedUserActivationKeyboardEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBrowserVerifiedUserActivationKeyboardEnabled() {
  return RuntimeEnabledFeatures::BrowserVerifiedUserActivationKeyboardEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableBrowserVerifiedUserActivationMouse(bool enable) {
  RuntimeEnabledFeatures::SetBrowserVerifiedUserActivationMouseEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsBrowserVerifiedUserActivationMouseEnabled() {
  return RuntimeEnabledFeatures::BrowserVerifiedUserActivationMouseEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableCanvas2dImageChromium(bool enable) {
  RuntimeEnabledFeatures::SetCanvas2dImageChromiumEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCanvas2dImageChromiumEnabled() {
  return RuntimeEnabledFeatures::Canvas2dImageChromiumEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableCompositeBGColorAnimation(bool enable) {
  RuntimeEnabledFeatures::SetCompositeBGColorAnimationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCompositeBGColorAnimationEnabled() {
  return RuntimeEnabledFeatures::CompositeBGColorAnimationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableCompositeClipPathAnimation(bool enable) {
  RuntimeEnabledFeatures::SetCompositeClipPathAnimationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCompositeClipPathAnimationEnabled() {
  return RuntimeEnabledFeatures::CompositeClipPathAnimationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableCompositedSelectionUpdate(bool enable) {
  RuntimeEnabledFeatures::SetCompositedSelectionUpdateEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCompositedSelectionUpdateEnabled() {
  return RuntimeEnabledFeatures::CompositedSelectionUpdateEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableCompressionDictionaryTransport(bool enable) {
  RuntimeEnabledFeatures::SetCompressionDictionaryTransportEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCompressionDictionaryTransportEnabled() {
  return RuntimeEnabledFeatures::CompressionDictionaryTransportEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableControlledFrame(bool enable) {
  RuntimeEnabledFeatures::SetControlledFrameEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsControlledFrameEnabled() {
  return RuntimeEnabledFeatures::ControlledFrameEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableCSPHashesV1(bool enable) {
  RuntimeEnabledFeatures::SetCSPHashesV1Enabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCSPHashesV1EnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::CSPHashesV1EnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableCSSMasonryLayout(bool enable) {
  RuntimeEnabledFeatures::SetCSSMasonryLayoutEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsCSSMasonryLayoutEnabled() {
  return RuntimeEnabledFeatures::CSSMasonryLayoutEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableDecoupleComputedBorderWidthFromStyle(bool enable) {
  RuntimeEnabledFeatures::SetDecoupleComputedBorderWidthFromStyleEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsDecoupleComputedBorderWidthFromStyleEnabled() {
  return RuntimeEnabledFeatures::DecoupleComputedBorderWidthFromStyleEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableDecoupleResolvedColumnRuleWidthFromStyle(bool enable) {
  RuntimeEnabledFeatures::SetDecoupleResolvedColumnRuleWidthFromStyleEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsDecoupleResolvedColumnRuleWidthFromStyleEnabled() {
  return RuntimeEnabledFeatures::DecoupleResolvedColumnRuleWidthFromStyleEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableDigitalGoods(bool enable) {
  RuntimeEnabledFeatures::SetDigitalGoodsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsDigitalGoodsEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::DigitalGoodsEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableDirectSockets(bool enable) {
  RuntimeEnabledFeatures::SetDirectSocketsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsDirectSocketsEnabled() {
  return RuntimeEnabledFeatures::DirectSocketsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableDisplayCutoutAPI(bool enable) {
  RuntimeEnabledFeatures::SetDisplayCutoutAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsDisplayCutoutAPIEnabled() {
  return RuntimeEnabledFeatures::DisplayCutoutAPIEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableDocumentPolicyNegotiation(bool enable) {
  RuntimeEnabledFeatures::SetDocumentPolicyNegotiationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsDocumentPolicyNegotiationEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::DocumentPolicyNegotiationEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableElementCapture(bool enable) {
  RuntimeEnabledFeatures::SetElementCaptureEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsElementCaptureEnabled() {
  return RuntimeEnabledFeatures::ElementCaptureEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableEyeDropperAPI(bool enable) {
  RuntimeEnabledFeatures::SetEyeDropperAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsEyeDropperAPIEnabled() {
  return RuntimeEnabledFeatures::EyeDropperAPIEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCm(bool enable) {
  RuntimeEnabledFeatures::SetFedCmEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmEnabled() {
  return RuntimeEnabledFeatures::FedCmEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmAutofill(bool enable) {
  RuntimeEnabledFeatures::SetFedCmAutofillEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmAutofillEnabled() {
  return RuntimeEnabledFeatures::FedCmAutofillEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmDelegation(bool enable) {
  RuntimeEnabledFeatures::SetFedCmDelegationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmDelegationEnabled() {
  return RuntimeEnabledFeatures::FedCmDelegationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmErrorAttribute(bool enable) {
  RuntimeEnabledFeatures::SetFedCmErrorAttributeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmErrorAttributeEnabled() {
  return RuntimeEnabledFeatures::FedCmErrorAttributeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmIdPRegistration(bool enable) {
  RuntimeEnabledFeatures::SetFedCmIdPRegistrationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmIdPRegistrationEnabled() {
  return RuntimeEnabledFeatures::FedCmIdPRegistrationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmLightweightMode(bool enable) {
  RuntimeEnabledFeatures::SetFedCmLightweightModeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmLightweightModeEnabled() {
  return RuntimeEnabledFeatures::FedCmLightweightModeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmMultipleIdentityProviders(bool enable) {
  RuntimeEnabledFeatures::SetFedCmMultipleIdentityProvidersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmMultipleIdentityProvidersEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::FedCmMultipleIdentityProvidersEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableFedCmNonStringToken(bool enable) {
  RuntimeEnabledFeatures::SetFedCmNonStringTokenEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFedCmNonStringTokenEnabled() {
  return RuntimeEnabledFeatures::FedCmNonStringTokenEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFencedFrames(bool enable) {
  RuntimeEnabledFeatures::SetFencedFramesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFencedFramesEnabled() {
  return RuntimeEnabledFeatures::FencedFramesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFencedFramesDefaultMode(bool enable) {
  RuntimeEnabledFeatures::SetFencedFramesDefaultModeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFencedFramesDefaultModeEnabled() {
  return RuntimeEnabledFeatures::FencedFramesDefaultModeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFencedFramesLocalUnpartitionedDataAccess(bool enable) {
  RuntimeEnabledFeatures::SetFencedFramesLocalUnpartitionedDataAccessEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFencedFramesLocalUnpartitionedDataAccessEnabled() {
  return RuntimeEnabledFeatures::FencedFramesLocalUnpartitionedDataAccessEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFileSystem(bool enable) {
  RuntimeEnabledFeatures::SetFileSystemEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFileSystemEnabled() {
  return RuntimeEnabledFeatures::FileSystemEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFledge(bool enable) {
  RuntimeEnabledFeatures::SetFledgeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFledgeEnabled() {
  return RuntimeEnabledFeatures::FledgeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFledgeDeprecatedRenderURLReplacements(bool enable) {
  RuntimeEnabledFeatures::SetFledgeDeprecatedRenderURLReplacementsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFledgeDeprecatedRenderURLReplacementsEnabled() {
  return RuntimeEnabledFeatures::FledgeDeprecatedRenderURLReplacementsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFledgeMultiBid(bool enable) {
  RuntimeEnabledFeatures::SetFledgeMultiBidEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFledgeMultiBidEnabled() {
  return RuntimeEnabledFeatures::FledgeMultiBidEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFledgeRealTimeReporting(bool enable) {
  RuntimeEnabledFeatures::SetFledgeRealTimeReportingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFledgeRealTimeReportingEnabled() {
  return RuntimeEnabledFeatures::FledgeRealTimeReportingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableForcedColors(bool enable) {
  RuntimeEnabledFeatures::SetForcedColorsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsForcedColorsEnabled() {
  return RuntimeEnabledFeatures::ForcedColorsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableFractionalScrollOffsets(bool enable) {
  RuntimeEnabledFeatures::SetFractionalScrollOffsetsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsFractionalScrollOffsetsEnabled() {
  return RuntimeEnabledFeatures::FractionalScrollOffsetsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableGamepadMultitouch(bool enable) {
  RuntimeEnabledFeatures::SetGamepadMultitouchEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsGamepadMultitouchEnabled() {
  return RuntimeEnabledFeatures::GamepadMultitouchEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableGamepadRawInputChangeEvent(bool enable) {
  RuntimeEnabledFeatures::SetGamepadRawInputChangeEventEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsGamepadRawInputChangeEventEnabled() {
  return RuntimeEnabledFeatures::GamepadRawInputChangeEventEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableGeolocationElement(bool enable) {
  RuntimeEnabledFeatures::SetGeolocationElementEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsGeolocationElementEnabled() {
  return RuntimeEnabledFeatures::GeolocationElementEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableGetAllScreensMedia(bool enable) {
  RuntimeEnabledFeatures::SetGetAllScreensMediaEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsGetAllScreensMediaEnabled() {
  return RuntimeEnabledFeatures::GetAllScreensMediaEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableGetDisplayMedia(bool enable) {
  RuntimeEnabledFeatures::SetGetDisplayMediaEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsGetDisplayMediaEnabled() {
  return RuntimeEnabledFeatures::GetDisplayMediaEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableImplicitRootScroller(bool enable) {
  RuntimeEnabledFeatures::SetImplicitRootScrollerEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsImplicitRootScrollerEnabled() {
  return RuntimeEnabledFeatures::ImplicitRootScrollerEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableInstalledApp(bool enable) {
  RuntimeEnabledFeatures::SetInstalledAppEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsInstalledAppEnabled() {
  return RuntimeEnabledFeatures::InstalledAppEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableIntegrityPolicyScript(bool enable) {
  RuntimeEnabledFeatures::SetIntegrityPolicyScriptEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsIntegrityPolicyScriptEnabled() {
  return RuntimeEnabledFeatures::IntegrityPolicyScriptEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableInterestGroupsInSharedStorageWorklet(bool enable) {
  RuntimeEnabledFeatures::SetInterestGroupsInSharedStorageWorkletEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsInterestGroupsInSharedStorageWorkletEnabled() {
  return RuntimeEnabledFeatures::InterestGroupsInSharedStorageWorkletEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableLanguageDetectionAPIForWorkers(bool enable) {
  RuntimeEnabledFeatures::SetLanguageDetectionAPIForWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsLanguageDetectionAPIForWorkersEnabled() {
  return RuntimeEnabledFeatures::LanguageDetectionAPIForWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableLockedMode(bool enable) {
  RuntimeEnabledFeatures::SetLockedModeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsLockedModeEnabled() {
  return RuntimeEnabledFeatures::LockedModeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableManualText(bool enable) {
  RuntimeEnabledFeatures::SetManualTextEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsManualTextEnabled() {
  return RuntimeEnabledFeatures::ManualTextEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableMediaControlsExpandGesture(bool enable) {
  RuntimeEnabledFeatures::SetMediaControlsExpandGestureEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsMediaControlsExpandGestureEnabled() {
  return RuntimeEnabledFeatures::MediaControlsExpandGestureEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableMediaControlsOverlayPlayButton(bool enable) {
  RuntimeEnabledFeatures::SetMediaControlsOverlayPlayButtonEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsMediaControlsOverlayPlayButtonEnabled() {
  return RuntimeEnabledFeatures::MediaControlsOverlayPlayButtonEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableMediaEngagementBypassAutoplayPolicies(bool enable) {
  RuntimeEnabledFeatures::SetMediaEngagementBypassAutoplayPoliciesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsMediaEngagementBypassAutoplayPoliciesEnabled() {
  return RuntimeEnabledFeatures::MediaEngagementBypassAutoplayPoliciesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableMediaSession(bool enable) {
  RuntimeEnabledFeatures::SetMediaSessionEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsMediaSessionEnabled() {
  return RuntimeEnabledFeatures::MediaSessionEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableNetInfoDownlinkMax(bool enable) {
  RuntimeEnabledFeatures::SetNetInfoDownlinkMaxEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsNetInfoDownlinkMaxEnabled() {
  return RuntimeEnabledFeatures::NetInfoDownlinkMaxEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableNotificationContentImage(bool enable) {
  RuntimeEnabledFeatures::SetNotificationContentImageEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsNotificationContentImageEnabled() {
  return RuntimeEnabledFeatures::NotificationContentImageEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableNotifications(bool enable) {
  RuntimeEnabledFeatures::SetNotificationsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsNotificationsEnabled() {
  return RuntimeEnabledFeatures::NotificationsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableOriginTrialsSampleAPI(bool enable) {
  RuntimeEnabledFeatures::SetOriginTrialsSampleAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsOriginTrialsSampleAPIEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::OriginTrialsSampleAPIEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableOriginTrialsSampleAPIDeprecation(bool enable) {
  RuntimeEnabledFeatures::SetOriginTrialsSampleAPIDeprecationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsOriginTrialsSampleAPIDeprecationEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::OriginTrialsSampleAPIDeprecationEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnablePaymentApp(bool enable) {
  RuntimeEnabledFeatures::SetPaymentAppEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPaymentAppEnabled() {
  return RuntimeEnabledFeatures::PaymentAppEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePaymentRequest(bool enable) {
  RuntimeEnabledFeatures::SetPaymentRequestEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPaymentRequestEnabled() {
  return RuntimeEnabledFeatures::PaymentRequestEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePerformanceManagerInstrumentation(bool enable) {
  RuntimeEnabledFeatures::SetPerformanceManagerInstrumentationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPerformanceManagerInstrumentationEnabled() {
  return RuntimeEnabledFeatures::PerformanceManagerInstrumentationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePeriodicBackgroundSync(bool enable) {
  RuntimeEnabledFeatures::SetPeriodicBackgroundSyncEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPeriodicBackgroundSyncEnabled() {
  return RuntimeEnabledFeatures::PeriodicBackgroundSyncEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePermissionElement(bool enable) {
  RuntimeEnabledFeatures::SetPermissionElementEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPermissionElementEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::PermissionElementEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnablePermissions(bool enable) {
  RuntimeEnabledFeatures::SetPermissionsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPermissionsEnabled() {
  return RuntimeEnabledFeatures::PermissionsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePNaCl(bool enable) {
  RuntimeEnabledFeatures::SetPNaClEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPNaClEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::PNaClEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnablePreciseMemoryInfo(bool enable) {
  RuntimeEnabledFeatures::SetPreciseMemoryInfoEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPreciseMemoryInfoEnabled() {
  return RuntimeEnabledFeatures::PreciseMemoryInfoEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePreferredAudioOutputDevices(bool enable) {
  RuntimeEnabledFeatures::SetPreferredAudioOutputDevicesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPreferredAudioOutputDevicesEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::PreferredAudioOutputDevicesEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnablePrerenderUntilScript(bool enable) {
  RuntimeEnabledFeatures::SetPrerenderUntilScriptEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPrerenderUntilScriptEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::PrerenderUntilScriptEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnablePresentation(bool enable) {
  RuntimeEnabledFeatures::SetPresentationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPresentationEnabled() {
  return RuntimeEnabledFeatures::PresentationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePrivateStateTokens(bool enable) {
  RuntimeEnabledFeatures::SetPrivateStateTokensEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPrivateStateTokensEnabled() {
  return RuntimeEnabledFeatures::PrivateStateTokensEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePrivateStateTokensAlwaysAllowIssuance(bool enable) {
  RuntimeEnabledFeatures::SetPrivateStateTokensAlwaysAllowIssuanceEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPrivateStateTokensAlwaysAllowIssuanceEnabled() {
  return RuntimeEnabledFeatures::PrivateStateTokensAlwaysAllowIssuanceEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePushMessaging(bool enable) {
  RuntimeEnabledFeatures::SetPushMessagingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPushMessagingEnabled() {
  return RuntimeEnabledFeatures::PushMessagingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnablePushMessagingSubscriptionChange(bool enable) {
  RuntimeEnabledFeatures::SetPushMessagingSubscriptionChangeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsPushMessagingSubscriptionChangeEnabled() {
  return RuntimeEnabledFeatures::PushMessagingSubscriptionChangeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableRegionCapture(bool enable) {
  RuntimeEnabledFeatures::SetRegionCaptureEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsRegionCaptureEnabled() {
  return RuntimeEnabledFeatures::RegionCaptureEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableRemotePlayback(bool enable) {
  RuntimeEnabledFeatures::SetRemotePlaybackEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsRemotePlaybackEnabled() {
  return RuntimeEnabledFeatures::RemotePlaybackEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableRestrictGamepadAccess(bool enable) {
  RuntimeEnabledFeatures::SetRestrictGamepadAccessEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsRestrictGamepadAccessEnabled() {
  return RuntimeEnabledFeatures::RestrictGamepadAccessEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableScriptedSpeechRecognition(bool enable) {
  RuntimeEnabledFeatures::SetScriptedSpeechRecognitionEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsScriptedSpeechRecognitionEnabled() {
  return RuntimeEnabledFeatures::ScriptedSpeechRecognitionEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableScriptedSpeechSynthesis(bool enable) {
  RuntimeEnabledFeatures::SetScriptedSpeechSynthesisEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsScriptedSpeechSynthesisEnabled() {
  return RuntimeEnabledFeatures::ScriptedSpeechSynthesisEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSecurePaymentConfirmation(bool enable) {
  RuntimeEnabledFeatures::SetSecurePaymentConfirmationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSecurePaymentConfirmationEnabled() {
  return RuntimeEnabledFeatures::SecurePaymentConfirmationEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSecurePaymentConfirmationDebug(bool enable) {
  RuntimeEnabledFeatures::SetSecurePaymentConfirmationDebugEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSecurePaymentConfirmationDebugEnabled() {
  return RuntimeEnabledFeatures::SecurePaymentConfirmationDebugEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSendBeaconThrowForBlobWithNonSimpleType(bool enable) {
  RuntimeEnabledFeatures::SetSendBeaconThrowForBlobWithNonSimpleTypeEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSendBeaconThrowForBlobWithNonSimpleTypeEnabled() {
  return RuntimeEnabledFeatures::SendBeaconThrowForBlobWithNonSimpleTypeEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSensorExtraClasses(bool enable) {
  RuntimeEnabledFeatures::SetSensorExtraClassesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSensorExtraClassesEnabled() {
  return RuntimeEnabledFeatures::SensorExtraClassesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSharedArrayBuffer(bool enable) {
  RuntimeEnabledFeatures::SetSharedArrayBufferEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSharedArrayBufferEnabled() {
  return RuntimeEnabledFeatures::SharedArrayBufferEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSharedArrayBufferUnrestrictedAccessAllowed(bool enable) {
  RuntimeEnabledFeatures::SetSharedArrayBufferUnrestrictedAccessAllowedEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSharedArrayBufferUnrestrictedAccessAllowedEnabled() {
  return RuntimeEnabledFeatures::SharedArrayBufferUnrestrictedAccessAllowedEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSharedStorageAPI(bool enable) {
  RuntimeEnabledFeatures::SetSharedStorageAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSharedStorageAPIEnabled() {
  return RuntimeEnabledFeatures::SharedStorageAPIEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSharedWorker(bool enable) {
  RuntimeEnabledFeatures::SetSharedWorkerEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSharedWorkerEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::SharedWorkerEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableSideRelativeBackgroundPosition(bool enable) {
  RuntimeEnabledFeatures::SetSideRelativeBackgroundPositionEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSideRelativeBackgroundPositionEnabled() {
  return RuntimeEnabledFeatures::SideRelativeBackgroundPositionEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableSmartZoom(bool enable) {
  RuntimeEnabledFeatures::SetSmartZoomEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsSmartZoomEnabled() {
  return RuntimeEnabledFeatures::SmartZoomEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableStandardizedBrowserZoom(bool enable) {
  RuntimeEnabledFeatures::SetStandardizedBrowserZoomEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsStandardizedBrowserZoomEnabled() {
  return RuntimeEnabledFeatures::StandardizedBrowserZoomEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTextFragmentIdentifiers(bool enable) {
  RuntimeEnabledFeatures::SetTextFragmentIdentifiersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTextFragmentIdentifiersEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::TextFragmentIdentifiersEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableTimerThrottlingForBackgroundTabs(bool enable) {
  RuntimeEnabledFeatures::SetTimerThrottlingForBackgroundTabsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTimerThrottlingForBackgroundTabsEnabled() {
  return RuntimeEnabledFeatures::TimerThrottlingForBackgroundTabsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTopicsAPI(bool enable) {
  RuntimeEnabledFeatures::SetTopicsAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTopicsAPIEnabled() {
  return RuntimeEnabledFeatures::TopicsAPIEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTopicsDocumentAPI(bool enable) {
  RuntimeEnabledFeatures::SetTopicsDocumentAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTopicsDocumentAPIEnabled() {
  return RuntimeEnabledFeatures::TopicsDocumentAPIEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTopicsImgAPI(bool enable) {
  RuntimeEnabledFeatures::SetTopicsImgAPIEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTopicsImgAPIEnabled() {
  return RuntimeEnabledFeatures::TopicsImgAPIEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTouchDragAndContextMenu(bool enable) {
  RuntimeEnabledFeatures::SetTouchDragAndContextMenuEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTouchDragAndContextMenuEnabled() {
  return RuntimeEnabledFeatures::TouchDragAndContextMenuEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTouchDragAndDrop(bool enable) {
  RuntimeEnabledFeatures::SetTouchDragAndDropEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTouchDragAndDropEnabled() {
  return RuntimeEnabledFeatures::TouchDragAndDropEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableTouchEventFeatureDetection(bool enable) {
  RuntimeEnabledFeatures::SetTouchEventFeatureDetectionEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTouchEventFeatureDetectionEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::TouchEventFeatureDetectionEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableTranslationAPIForWorkers(bool enable) {
  RuntimeEnabledFeatures::SetTranslationAPIForWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsTranslationAPIForWorkersEnabled() {
  return RuntimeEnabledFeatures::TranslationAPIForWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableV8IdleTasks(bool enable) {
  RuntimeEnabledFeatures::SetV8IdleTasksEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsV8IdleTasksEnabled() {
  return RuntimeEnabledFeatures::V8IdleTasksEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebAudioBypassOutputBufferingOptOut(bool enable) {
  RuntimeEnabledFeatures::SetWebAudioBypassOutputBufferingOptOutEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebAudioBypassOutputBufferingOptOutEnabled() {
  return RuntimeEnabledFeatures::WebAudioBypassOutputBufferingOptOutEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebAuthenticationAmbient(bool enable) {
  RuntimeEnabledFeatures::SetWebAuthenticationAmbientEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebAuthenticationAmbientEnabled() {
  return RuntimeEnabledFeatures::WebAuthenticationAmbientEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebAuthenticationConditionalCreate(bool enable) {
  RuntimeEnabledFeatures::SetWebAuthenticationConditionalCreateEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebAuthenticationConditionalCreateEnabled() {
  return RuntimeEnabledFeatures::WebAuthenticationConditionalCreateEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebAuthenticationImmediateGet(bool enable) {
  RuntimeEnabledFeatures::SetWebAuthenticationImmediateGetEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebAuthenticationImmediateGetEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::WebAuthenticationImmediateGetEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableWebAuthenticationRemoteDesktopSupport(bool enable) {
  RuntimeEnabledFeatures::SetWebAuthenticationRemoteDesktopSupportEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebAuthenticationRemoteDesktopSupportEnabled() {
  return RuntimeEnabledFeatures::WebAuthenticationRemoteDesktopSupportEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebBluetooth(bool enable) {
  RuntimeEnabledFeatures::SetWebBluetoothEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebBluetoothEnabled() {
  return RuntimeEnabledFeatures::WebBluetoothEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebBluetoothGetDevices(bool enable) {
  RuntimeEnabledFeatures::SetWebBluetoothGetDevicesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebBluetoothGetDevicesEnabled() {
  return RuntimeEnabledFeatures::WebBluetoothGetDevicesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebBluetoothWatchAdvertisements(bool enable) {
  RuntimeEnabledFeatures::SetWebBluetoothWatchAdvertisementsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebBluetoothWatchAdvertisementsEnabled() {
  return RuntimeEnabledFeatures::WebBluetoothWatchAdvertisementsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebGLDeveloperExtensions(bool enable) {
  RuntimeEnabledFeatures::SetWebGLDeveloperExtensionsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebGLDeveloperExtensionsEnabled() {
  return RuntimeEnabledFeatures::WebGLDeveloperExtensionsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebGLDraftExtensions(bool enable) {
  RuntimeEnabledFeatures::SetWebGLDraftExtensionsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebGLDraftExtensionsEnabled() {
  return RuntimeEnabledFeatures::WebGLDraftExtensionsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebGLImageChromium(bool enable) {
  RuntimeEnabledFeatures::SetWebGLImageChromiumEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebGLImageChromiumEnabled() {
  return RuntimeEnabledFeatures::WebGLImageChromiumEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebGPUDeveloperFeatures(bool enable) {
  RuntimeEnabledFeatures::SetWebGPUDeveloperFeaturesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebGPUDeveloperFeaturesEnabled() {
  return RuntimeEnabledFeatures::WebGPUDeveloperFeaturesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebGPUExperimentalFeatures(bool enable) {
  RuntimeEnabledFeatures::SetWebGPUExperimentalFeaturesEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebGPUExperimentalFeaturesEnabled() {
  return RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebGPUImmediatesFeature(bool enable) {
  RuntimeEnabledFeatures::SetWebGPUImmediatesFeatureEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebGPUImmediatesFeatureEnabled() {
  return RuntimeEnabledFeatures::WebGPUImmediatesFeatureEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebHIDOnServiceWorkers(bool enable) {
  RuntimeEnabledFeatures::SetWebHIDOnServiceWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebHIDOnServiceWorkersEnabled() {
  return RuntimeEnabledFeatures::WebHIDOnServiceWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebIdentityDigitalCredentials(bool enable) {
  RuntimeEnabledFeatures::SetWebIdentityDigitalCredentialsEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebIdentityDigitalCredentialsEnabled() {
  return RuntimeEnabledFeatures::WebIdentityDigitalCredentialsEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebIdentityDigitalCredentialsCreation(bool enable) {
  RuntimeEnabledFeatures::SetWebIdentityDigitalCredentialsCreationEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebIdentityDigitalCredentialsCreationEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::WebIdentityDigitalCredentialsCreationEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableWebNFC(bool enable) {
  RuntimeEnabledFeatures::SetWebNFCEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebNFCEnabled() {
  return RuntimeEnabledFeatures::WebNFCEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebOTP(bool enable) {
  RuntimeEnabledFeatures::SetWebOTPEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebOTPEnabled() {
  return RuntimeEnabledFeatures::WebOTPEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebOTPAssertionFeaturePolicy(bool enable) {
  RuntimeEnabledFeatures::SetWebOTPAssertionFeaturePolicyEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebOTPAssertionFeaturePolicyEnabled() {
  return RuntimeEnabledFeatures::WebOTPAssertionFeaturePolicyEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebShare(bool enable) {
  RuntimeEnabledFeatures::SetWebShareEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebShareEnabled() {
  return RuntimeEnabledFeatures::WebShareEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebUSB(bool enable) {
  RuntimeEnabledFeatures::SetWebUSBEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebUSBEnabled() {
  return RuntimeEnabledFeatures::WebUSBEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebUSBOnServiceWorkers(bool enable) {
  RuntimeEnabledFeatures::SetWebUSBOnServiceWorkersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebUSBOnServiceWorkersEnabled() {
  return RuntimeEnabledFeatures::WebUSBOnServiceWorkersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXR(bool enable) {
  RuntimeEnabledFeatures::SetWebXREnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXREnabled() {
  return RuntimeEnabledFeatures::WebXREnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRFrameRate(bool enable) {
  RuntimeEnabledFeatures::SetWebXRFrameRateEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRFrameRateEnabled() {
  return RuntimeEnabledFeatures::WebXRFrameRateEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRFrontFacing(bool enable) {
  RuntimeEnabledFeatures::SetWebXRFrontFacingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRFrontFacingEnabled() {
  return RuntimeEnabledFeatures::WebXRFrontFacingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRGPUBinding(bool enable) {
  RuntimeEnabledFeatures::SetWebXRGPUBindingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRGPUBindingEnabled() {
  return RuntimeEnabledFeatures::WebXRGPUBindingEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRImageTracking(bool enable) {
  RuntimeEnabledFeatures::SetWebXRImageTrackingEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRImageTrackingEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::WebXRImageTrackingEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRLayers(bool enable) {
  RuntimeEnabledFeatures::SetWebXRLayersEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRLayersEnabled() {
  return RuntimeEnabledFeatures::WebXRLayersEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRLayersCommon(bool enable) {
  RuntimeEnabledFeatures::SetWebXRLayersCommonEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRLayersCommonEnabled() {
  return RuntimeEnabledFeatures::WebXRLayersCommonEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRPlaneDetection(bool enable) {
  RuntimeEnabledFeatures::SetWebXRPlaneDetectionEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRPlaneDetectionEnabledByRuntimeFlag() {
  return RuntimeEnabledFeatures::WebXRPlaneDetectionEnabledByRuntimeFlag();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRPoseMotionData(bool enable) {
  RuntimeEnabledFeatures::SetWebXRPoseMotionDataEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRPoseMotionDataEnabled() {
  return RuntimeEnabledFeatures::WebXRPoseMotionDataEnabled();
}

// static
void WebRuntimeFeaturesBase::EnableWebXRSpecParity(bool enable) {
  RuntimeEnabledFeatures::SetWebXRSpecParityEnabled(enable);
}

// static
bool WebRuntimeFeaturesBase::IsWebXRSpecParityEnabled() {
  return RuntimeEnabledFeatures::WebXRSpecParityEnabled();
}

}  // namespace blink
