
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated. Do not edit. Just generate.
//
// Manually re-generate:
// $ ninja -C ... third_party/blink/renderer/core/sanitizer:generated

#include "third_party/blink/renderer/core/sanitizer/sanitizer_builtins.h"
#include "third_party/blink/renderer/core/sanitizer/sanitizer.h"

#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/core/mathml_names.h"
#include "third_party/blink/renderer/core/svg_names.h"
#include "third_party/blink/renderer/core/xlink_names.h"
#include "third_party/blink/renderer/core/xml_names.h"
#include "third_party/blink/renderer/core/xmlns_names.h"

namespace blink {
namespace sanitizer_generated_builtins {

Sanitizer* BuildDefaultConfig() {
Sanitizer* sanitizer = MakeGarbageCollected<Sanitizer>(
  /* elements */
  std::make_unique<SanitizerNameSet>(
    std::initializer_list<SanitizerNameSet::ValueType>({
      mathml_names::kMathTag,
      mathml_names::kMerrorTag,
      mathml_names::kMfracTag,
      mathml_names::kMiTag,
      mathml_names::kMmultiscriptsTag,
      mathml_names::kMnTag,
      mathml_names::kMoTag,
      mathml_names::kMoverTag,
      mathml_names::kMpaddedTag,
      mathml_names::kMphantomTag,
      mathml_names::kMprescriptsTag,
      mathml_names::kMrootTag,
      mathml_names::kMrowTag,
      mathml_names::kMsTag,
      mathml_names::kMspaceTag,
      mathml_names::kMsqrtTag,
      mathml_names::kMstyleTag,
      mathml_names::kMsubTag,
      mathml_names::kMsubsupTag,
      mathml_names::kMsupTag,
      mathml_names::kMtableTag,
      mathml_names::kMtdTag,
      mathml_names::kMtextTag,
      mathml_names::kMtrTag,
      mathml_names::kMunderTag,
      mathml_names::kMunderoverTag,
      mathml_names::kSemanticsTag,
      html_names::kATag,
      html_names::kAbbrTag,
      html_names::kAddressTag,
      html_names::kArticleTag,
      html_names::kAsideTag,
      html_names::kBTag,
      html_names::kBdiTag,
      html_names::kBdoTag,
      html_names::kBlockquoteTag,
      html_names::kBodyTag,
      html_names::kBrTag,
      html_names::kCaptionTag,
      html_names::kCiteTag,
      html_names::kCodeTag,
      html_names::kColTag,
      html_names::kColgroupTag,
      html_names::kDataTag,
      html_names::kDdTag,
      html_names::kDelTag,
      html_names::kDfnTag,
      html_names::kDivTag,
      html_names::kDlTag,
      html_names::kDtTag,
      html_names::kEmTag,
      html_names::kFigcaptionTag,
      html_names::kFigureTag,
      html_names::kFooterTag,
      html_names::kH1Tag,
      html_names::kH2Tag,
      html_names::kH3Tag,
      html_names::kH4Tag,
      html_names::kH5Tag,
      html_names::kH6Tag,
      html_names::kHeadTag,
      html_names::kHeaderTag,
      html_names::kHgroupTag,
      html_names::kHrTag,
      html_names::kHTMLTag,
      html_names::kITag,
      html_names::kInsTag,
      html_names::kKbdTag,
      html_names::kLiTag,
      html_names::kMainTag,
      html_names::kMarkTag,
      html_names::kMenuTag,
      html_names::kNavTag,
      html_names::kOlTag,
      html_names::kPTag,
      html_names::kPreTag,
      html_names::kQTag,
      html_names::kRpTag,
      html_names::kRtTag,
      html_names::kRubyTag,
      html_names::kSTag,
      html_names::kSampTag,
      html_names::kSearchTag,
      html_names::kSectionTag,
      html_names::kSmallTag,
      html_names::kSpanTag,
      html_names::kStrongTag,
      html_names::kSubTag,
      html_names::kSupTag,
      html_names::kTableTag,
      html_names::kTbodyTag,
      html_names::kTdTag,
      html_names::kTfootTag,
      html_names::kThTag,
      html_names::kTheadTag,
      html_names::kTimeTag,
      html_names::kTitleTag,
      html_names::kTrTag,
      html_names::kUTag,
      html_names::kUlTag,
      html_names::kVarTag,
      html_names::kWbrTag,
      svg_names::kATag,
      svg_names::kCircleTag,
      svg_names::kDefsTag,
      svg_names::kDescTag,
      svg_names::kEllipseTag,
      svg_names::kForeignObjectTag,
      svg_names::kGTag,
      svg_names::kLineTag,
      svg_names::kMarkerTag,
      svg_names::kMetadataTag,
      svg_names::kPathTag,
      svg_names::kPolygonTag,
      svg_names::kPolylineTag,
      svg_names::kRectTag,
      svg_names::kSVGTag,
      svg_names::kTextTag,
      svg_names::kTextPathTag,
      svg_names::kTitleTag,
      svg_names::kTSpanTag,
    })
  ),
  /* removeElements */ nullptr,
  /* replaceWithChildrenElements */ nullptr,
  /* attributes */
  std::make_unique<SanitizerNameSet>(
    std::initializer_list<SanitizerNameSet::ValueType>({
      svg_names::kAlignmentBaselineAttr,
      svg_names::kBaselineShiftAttr,
      svg_names::kClipPathAttr,
      svg_names::kClipRuleAttr,
      svg_names::kColorAttr,
      svg_names::kColorInterpolationAttr,
      svg_names::kCursorAttr,
      html_names::kDirAttr,
      svg_names::kDirectionAttr,
      svg_names::kDisplayAttr,
      mathml_names::kDisplaystyleAttr,
      svg_names::kDominantBaselineAttr,
      svg_names::kFillAttr,
      svg_names::kFillOpacityAttr,
      svg_names::kFillRuleAttr,
      svg_names::kFontFamilyAttr,
      svg_names::kFontSizeAttr,
      svg_names::kFontSizeAdjustAttr,
      svg_names::kFontStretchAttr,
      svg_names::kFontStyleAttr,
      svg_names::kFontVariantAttr,
      svg_names::kFontWeightAttr,
      svg_names::kLangAttr,
      svg_names::kLetterSpacingAttr,
      svg_names::kMarkerEndAttr,
      svg_names::kMarkerMidAttr,
      svg_names::kMarkerStartAttr,
      mathml_names::kMathbackgroundAttr,
      mathml_names::kMathcolorAttr,
      mathml_names::kMathsizeAttr,
      svg_names::kOpacityAttr,
      svg_names::kPaintOrderAttr,
      svg_names::kPointerEventsAttr,
      mathml_names::kScriptlevelAttr,
      svg_names::kShapeRenderingAttr,
      svg_names::kStopColorAttr,
      svg_names::kStopOpacityAttr,
      svg_names::kStrokeAttr,
      svg_names::kStrokeDasharrayAttr,
      svg_names::kStrokeDashoffsetAttr,
      svg_names::kStrokeLinecapAttr,
      svg_names::kStrokeLinejoinAttr,
      svg_names::kStrokeMiterlimitAttr,
      svg_names::kStrokeOpacityAttr,
      svg_names::kStrokeWidthAttr,
      svg_names::kTextAnchorAttr,
      svg_names::kTextDecorationAttr,
      svg_names::kTextRenderingAttr,
      svg_names::kTitleAttr,
      svg_names::kTransformAttr,
      svg_names::kTransformOriginAttr,
      svg_names::kUnicodeBidiAttr,
      svg_names::kVectorEffectAttr,
      svg_names::kVisibilityAttr,
      svg_names::kWordSpacingAttr,
      svg_names::kWritingModeAttr,
    })
  ),
  /* removeAttributes */ nullptr,
  /* elements[attributes] */
  SanitizerNameMap(
    std::initializer_list<SanitizerNameMap::ValueType>({
      SanitizerNameMap::ValueType(
        mathml_names::kMathTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMerrorTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMfracTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMiTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMmultiscriptsTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMnTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMoTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kFormAttr,
          mathml_names::kLargeopAttr,
          mathml_names::kLspaceAttr,
          mathml_names::kMaxsizeAttr,
          mathml_names::kMinsizeAttr,
          mathml_names::kMovablelimitsAttr,
          mathml_names::kRspaceAttr,
          mathml_names::kStretchyAttr,
          mathml_names::kSymmetricAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMoverTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kAccentAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMpaddedTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kDepthAttr,
          svg_names::kHeightAttr,
          mathml_names::kLspaceAttr,
          mathml_names::kVoffsetAttr,
          svg_names::kWidthAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMphantomTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMprescriptsTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMrootTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMrowTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMsTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMspaceTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kDepthAttr,
          svg_names::kHeightAttr,
          svg_names::kWidthAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMsqrtTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMstyleTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMsubTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMsubsupTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMsupTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMtableTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMtdTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kColumnspanAttr,
          mathml_names::kRowspanAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMtextTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMtrTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMunderTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kAccentunderAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kMunderoverTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          mathml_names::kAccentAttr,
          mathml_names::kAccentunderAttr,
      }))),
      SanitizerNameMap::ValueType(
        mathml_names::kSemanticsTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kATag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kHrefAttr,
          svg_names::kHreflangAttr,
          svg_names::kTypeAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kAbbrTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kAddressTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kArticleTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kAsideTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kBTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kBdiTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kBdoTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kBlockquoteTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kCiteAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kBodyTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kBrTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kCaptionTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kCiteTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kCodeTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kColTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kSpanAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kColgroupTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kSpanAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDataTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kValueAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDdTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDelTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kCiteAttr,
          html_names::kDatetimeAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDfnTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDivTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDlTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kDtTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kEmTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kFigcaptionTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kFigureTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kFooterTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kH1Tag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kH2Tag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kH3Tag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kH4Tag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kH5Tag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kH6Tag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kHeadTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kHeaderTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kHgroupTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kHrTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kHTMLTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kITag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kInsTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kCiteAttr,
          html_names::kDatetimeAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kKbdTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kLiTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kValueAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kMainTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kMarkTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kMenuTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kNavTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kOlTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kReversedAttr,
          html_names::kStartAttr,
          svg_names::kTypeAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kPTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kPreTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kQTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kRpTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kRtTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kRubyTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSampTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSearchTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSectionTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSmallTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSpanTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kStrongTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSubTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kSupTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTableTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTbodyTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTdTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kColspanAttr,
          html_names::kHeadersAttr,
          mathml_names::kRowspanAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTfootTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kThTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kAbbrAttr,
          html_names::kColspanAttr,
          html_names::kHeadersAttr,
          mathml_names::kRowspanAttr,
          html_names::kScopeAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTheadTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTimeTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          html_names::kDatetimeAttr,
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTitleTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kTrTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kUTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kUlTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kVarTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        html_names::kWbrTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kATag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kHrefAttr,
          svg_names::kHreflangAttr,
          svg_names::kTypeAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kCircleTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kCxAttr,
          svg_names::kCyAttr,
          svg_names::kPathLengthAttr,
          svg_names::kRAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kDefsTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kDescTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kEllipseTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kCxAttr,
          svg_names::kCyAttr,
          svg_names::kPathLengthAttr,
          svg_names::kRxAttr,
          svg_names::kRyAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kForeignObjectTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kHeightAttr,
          svg_names::kWidthAttr,
          svg_names::kXAttr,
          svg_names::kYAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kGTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kLineTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kPathLengthAttr,
          svg_names::kX1Attr,
          svg_names::kX2Attr,
          svg_names::kY1Attr,
          svg_names::kY2Attr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kMarkerTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kMarkerHeightAttr,
          svg_names::kMarkerUnitsAttr,
          svg_names::kMarkerWidthAttr,
          svg_names::kOrientAttr,
          svg_names::kPreserveAspectRatioAttr,
          svg_names::kRefXAttr,
          svg_names::kRefYAttr,
          svg_names::kViewBoxAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kMetadataTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kPathTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kDAttr,
          svg_names::kPathLengthAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kPolygonTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kPathLengthAttr,
          svg_names::kPointsAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kPolylineTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kPathLengthAttr,
          svg_names::kPointsAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kRectTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kHeightAttr,
          svg_names::kPathLengthAttr,
          svg_names::kRxAttr,
          svg_names::kRyAttr,
          svg_names::kWidthAttr,
          svg_names::kXAttr,
          svg_names::kYAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kSVGTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kHeightAttr,
          svg_names::kPreserveAspectRatioAttr,
          svg_names::kViewBoxAttr,
          svg_names::kWidthAttr,
          svg_names::kXAttr,
          svg_names::kYAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kTextTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kDxAttr,
          svg_names::kDyAttr,
          svg_names::kLengthAdjustAttr,
          svg_names::kRotateAttr,
          svg_names::kTextLengthAttr,
          svg_names::kXAttr,
          svg_names::kYAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kTextPathTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kLengthAdjustAttr,
          svg_names::kMethodAttr,
          svg_names::kPathAttr,
          svg_names::kSpacingAttr,
          svg_names::kStartOffsetAttr,
          svg_names::kTextLengthAttr,
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kTitleTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
      }))),
      SanitizerNameMap::ValueType(
        svg_names::kTSpanTag,
        SanitizerNameMap::MappedType(std::initializer_list<SanitizerNameMap::MappedType::ValueType>({
          svg_names::kDxAttr,
          svg_names::kDyAttr,
          svg_names::kLengthAdjustAttr,
          svg_names::kRotateAttr,
          svg_names::kTextLengthAttr,
          svg_names::kXAttr,
          svg_names::kYAttr,
      }))),
    })
  ),
  /* elements[removeAttributes] */
  SanitizerNameMap(
    std::initializer_list<SanitizerNameMap::ValueType>({
    })
  ),
  /* comments */ false,
  /* dataAttributes */ false

);
return sanitizer;
}
}  // namespace sanitizer_generated_builtins
}  // namespace blink
