// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Storage_h
#define blink_protocol_Storage_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/network.h"

namespace blink {
namespace protocol {
namespace Storage {
using SerializedStorageKey = String;
using StorageType = String;
class UsageForType;
class TrustTokens;
using InterestGroupAuctionId = String;
using InterestGroupAccessType = String;
using InterestGroupAuctionEventType = String;
using InterestGroupAuctionFetchType = String;
using SharedStorageAccessScope = String;
using SharedStorageAccessMethod = String;
class SharedStorageEntry;
class SharedStorageMetadata;
class SharedStoragePrivateAggregationConfig;
class SharedStorageReportingMetadata;
class SharedStorageUrlWithMetadata;
class SharedStorageAccessParams;
using StorageBucketsDurability = String;
class StorageBucket;
class StorageBucketInfo;
using AttributionReportingSourceType = String;
using UnsignedInt64AsBase10 = String;
using UnsignedInt128AsBase16 = String;
using SignedInt64AsBase10 = String;
class AttributionReportingFilterDataEntry;
class AttributionReportingFilterConfig;
class AttributionReportingFilterPair;
class AttributionReportingAggregationKeysEntry;
class AttributionReportingEventReportWindows;
using AttributionReportingTriggerDataMatching = String;
class AttributionReportingAggregatableDebugReportingData;
class AttributionReportingAggregatableDebugReportingConfig;
class AttributionScopesData;
class AttributionReportingNamedBudgetDef;
class AttributionReportingSourceRegistration;
using AttributionReportingSourceRegistrationResult = String;
using AttributionReportingSourceRegistrationTimeConfig = String;
class AttributionReportingAggregatableValueDictEntry;
class AttributionReportingAggregatableValueEntry;
class AttributionReportingEventTriggerData;
class AttributionReportingAggregatableTriggerData;
class AttributionReportingAggregatableDedupKey;
class AttributionReportingNamedBudgetCandidate;
class AttributionReportingTriggerRegistration;
using AttributionReportingEventLevelResult = String;
using AttributionReportingAggregatableResult = String;
using AttributionReportingReportResult = String;
class RelatedWebsiteSet;

// ------------- Forward and enum declarations.

namespace StorageTypeEnum {
CORE_EXPORT extern const char Cookies[];
CORE_EXPORT extern const char File_systems[];
CORE_EXPORT extern const char Indexeddb[];
CORE_EXPORT extern const char Local_storage[];
CORE_EXPORT extern const char Shader_cache[];
CORE_EXPORT extern const char Websql[];
CORE_EXPORT extern const char Service_workers[];
CORE_EXPORT extern const char Cache_storage[];
CORE_EXPORT extern const char Interest_groups[];
CORE_EXPORT extern const char Shared_storage[];
CORE_EXPORT extern const char Storage_buckets[];
CORE_EXPORT extern const char All[];
CORE_EXPORT extern const char Other[];
} // namespace StorageTypeEnum

namespace InterestGroupAccessTypeEnum {
CORE_EXPORT extern const char Join[];
CORE_EXPORT extern const char Leave[];
CORE_EXPORT extern const char Update[];
CORE_EXPORT extern const char Loaded[];
CORE_EXPORT extern const char Bid[];
CORE_EXPORT extern const char Win[];
CORE_EXPORT extern const char AdditionalBid[];
CORE_EXPORT extern const char AdditionalBidWin[];
CORE_EXPORT extern const char TopLevelBid[];
CORE_EXPORT extern const char TopLevelAdditionalBid[];
CORE_EXPORT extern const char Clear[];
} // namespace InterestGroupAccessTypeEnum

namespace InterestGroupAuctionEventTypeEnum {
CORE_EXPORT extern const char Started[];
CORE_EXPORT extern const char ConfigResolved[];
} // namespace InterestGroupAuctionEventTypeEnum

namespace InterestGroupAuctionFetchTypeEnum {
CORE_EXPORT extern const char BidderJs[];
CORE_EXPORT extern const char BidderWasm[];
CORE_EXPORT extern const char SellerJs[];
CORE_EXPORT extern const char BidderTrustedSignals[];
CORE_EXPORT extern const char SellerTrustedSignals[];
} // namespace InterestGroupAuctionFetchTypeEnum

namespace SharedStorageAccessScopeEnum {
CORE_EXPORT extern const char Window[];
CORE_EXPORT extern const char SharedStorageWorklet[];
CORE_EXPORT extern const char ProtectedAudienceWorklet[];
CORE_EXPORT extern const char Header[];
} // namespace SharedStorageAccessScopeEnum

namespace SharedStorageAccessMethodEnum {
CORE_EXPORT extern const char AddModule[];
CORE_EXPORT extern const char CreateWorklet[];
CORE_EXPORT extern const char SelectURL[];
CORE_EXPORT extern const char Run[];
CORE_EXPORT extern const char BatchUpdate[];
CORE_EXPORT extern const char Set[];
CORE_EXPORT extern const char Append[];
CORE_EXPORT extern const char Delete[];
CORE_EXPORT extern const char Clear[];
CORE_EXPORT extern const char Get[];
CORE_EXPORT extern const char Keys[];
CORE_EXPORT extern const char Values[];
CORE_EXPORT extern const char Entries[];
CORE_EXPORT extern const char Length[];
CORE_EXPORT extern const char RemainingBudget[];
} // namespace SharedStorageAccessMethodEnum

namespace StorageBucketsDurabilityEnum {
CORE_EXPORT extern const char Relaxed[];
CORE_EXPORT extern const char Strict[];
} // namespace StorageBucketsDurabilityEnum

namespace AttributionReportingSourceTypeEnum {
CORE_EXPORT extern const char Navigation[];
CORE_EXPORT extern const char Event[];
} // namespace AttributionReportingSourceTypeEnum

namespace AttributionReportingTriggerDataMatchingEnum {
CORE_EXPORT extern const char Exact[];
CORE_EXPORT extern const char Modulus[];
} // namespace AttributionReportingTriggerDataMatchingEnum

namespace AttributionReportingSourceRegistrationResultEnum {
CORE_EXPORT extern const char Success[];
CORE_EXPORT extern const char InternalError[];
CORE_EXPORT extern const char InsufficientSourceCapacity[];
CORE_EXPORT extern const char InsufficientUniqueDestinationCapacity[];
CORE_EXPORT extern const char ExcessiveReportingOrigins[];
CORE_EXPORT extern const char ProhibitedByBrowserPolicy[];
CORE_EXPORT extern const char SuccessNoised[];
CORE_EXPORT extern const char DestinationReportingLimitReached[];
CORE_EXPORT extern const char DestinationGlobalLimitReached[];
CORE_EXPORT extern const char DestinationBothLimitsReached[];
CORE_EXPORT extern const char ReportingOriginsPerSiteLimitReached[];
CORE_EXPORT extern const char ExceedsMaxChannelCapacity[];
CORE_EXPORT extern const char ExceedsMaxScopesChannelCapacity[];
CORE_EXPORT extern const char ExceedsMaxTriggerStateCardinality[];
CORE_EXPORT extern const char ExceedsMaxEventStatesLimit[];
CORE_EXPORT extern const char DestinationPerDayReportingLimitReached[];
} // namespace AttributionReportingSourceRegistrationResultEnum

namespace AttributionReportingSourceRegistrationTimeConfigEnum {
CORE_EXPORT extern const char Include[];
CORE_EXPORT extern const char Exclude[];
} // namespace AttributionReportingSourceRegistrationTimeConfigEnum

namespace AttributionReportingEventLevelResultEnum {
CORE_EXPORT extern const char Success[];
CORE_EXPORT extern const char SuccessDroppedLowerPriority[];
CORE_EXPORT extern const char InternalError[];
CORE_EXPORT extern const char NoCapacityForAttributionDestination[];
CORE_EXPORT extern const char NoMatchingSources[];
CORE_EXPORT extern const char Deduplicated[];
CORE_EXPORT extern const char ExcessiveAttributions[];
CORE_EXPORT extern const char PriorityTooLow[];
CORE_EXPORT extern const char NeverAttributedSource[];
CORE_EXPORT extern const char ExcessiveReportingOrigins[];
CORE_EXPORT extern const char NoMatchingSourceFilterData[];
CORE_EXPORT extern const char ProhibitedByBrowserPolicy[];
CORE_EXPORT extern const char NoMatchingConfigurations[];
CORE_EXPORT extern const char ExcessiveReports[];
CORE_EXPORT extern const char FalselyAttributedSource[];
CORE_EXPORT extern const char ReportWindowPassed[];
CORE_EXPORT extern const char NotRegistered[];
CORE_EXPORT extern const char ReportWindowNotStarted[];
CORE_EXPORT extern const char NoMatchingTriggerData[];
} // namespace AttributionReportingEventLevelResultEnum

namespace AttributionReportingAggregatableResultEnum {
CORE_EXPORT extern const char Success[];
CORE_EXPORT extern const char InternalError[];
CORE_EXPORT extern const char NoCapacityForAttributionDestination[];
CORE_EXPORT extern const char NoMatchingSources[];
CORE_EXPORT extern const char ExcessiveAttributions[];
CORE_EXPORT extern const char ExcessiveReportingOrigins[];
CORE_EXPORT extern const char NoHistograms[];
CORE_EXPORT extern const char InsufficientBudget[];
CORE_EXPORT extern const char InsufficientNamedBudget[];
CORE_EXPORT extern const char NoMatchingSourceFilterData[];
CORE_EXPORT extern const char NotRegistered[];
CORE_EXPORT extern const char ProhibitedByBrowserPolicy[];
CORE_EXPORT extern const char Deduplicated[];
CORE_EXPORT extern const char ReportWindowPassed[];
CORE_EXPORT extern const char ExcessiveReports[];
} // namespace AttributionReportingAggregatableResultEnum

namespace AttributionReportingReportResultEnum {
CORE_EXPORT extern const char Sent[];
CORE_EXPORT extern const char Prohibited[];
CORE_EXPORT extern const char FailedToAssemble[];
CORE_EXPORT extern const char Expired[];
} // namespace AttributionReportingReportResultEnum

// ------------- Type and builder declarations.

class CORE_EXPORT UsageForType : public ::crdtp::ProtocolObject<UsageForType> {
public:
    ~UsageForType() override;  // Defined below

    String getStorageType() { return m_storageType; }
    void setStorageType(const String& value);  // Defined below

    double getUsage() { return m_usage; }
    void setUsage(double value);  // Defined below

    template<int STATE>
    class UsageForTypeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageTypeSet = 1 << 1,
            UsageSet = 1 << 2,
            AllFieldsSet = (StorageTypeSet | UsageSet | 0)};


        UsageForTypeBuilder<STATE | StorageTypeSet>& setStorageType(const String& value);  // Defined below

        UsageForTypeBuilder<STATE | UsageSet>& setUsage(double value);  // Defined below

        std::unique_ptr<UsageForType> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UsageForType;
        UsageForTypeBuilder() : m_result(new UsageForType()) { }

        template<int STEP> UsageForTypeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UsageForTypeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::UsageForType> m_result;
    };

    static UsageForTypeBuilder<0> create()
    {
        return UsageForTypeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UsageForType();  // Defined below

    String m_storageType;
    double m_usage;
};


class CORE_EXPORT TrustTokens : public ::crdtp::ProtocolObject<TrustTokens> {
public:
    ~TrustTokens() override;  // Defined below

    String getIssuerOrigin() { return m_issuerOrigin; }
    void setIssuerOrigin(const String& value);  // Defined below

    double getCount() { return m_count; }
    void setCount(double value);  // Defined below

    template<int STATE>
    class TrustTokensBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IssuerOriginSet = 1 << 1,
            CountSet = 1 << 2,
            AllFieldsSet = (IssuerOriginSet | CountSet | 0)};


        TrustTokensBuilder<STATE | IssuerOriginSet>& setIssuerOrigin(const String& value);  // Defined below

        TrustTokensBuilder<STATE | CountSet>& setCount(double value);  // Defined below

        std::unique_ptr<TrustTokens> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TrustTokens;
        TrustTokensBuilder() : m_result(new TrustTokens()) { }

        template<int STEP> TrustTokensBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TrustTokensBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::TrustTokens> m_result;
    };

    static TrustTokensBuilder<0> create()
    {
        return TrustTokensBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TrustTokens();  // Defined below

    String m_issuerOrigin;
    double m_count;
};


class CORE_EXPORT SharedStorageEntry : public ::crdtp::ProtocolObject<SharedStorageEntry> {
public:
    ~SharedStorageEntry() override;  // Defined below

    String getKey() { return m_key; }
    void setKey(const String& value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    template<int STATE>
    class SharedStorageEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (KeySet | ValueSet | 0)};


        SharedStorageEntryBuilder<STATE | KeySet>& setKey(const String& value);  // Defined below

        SharedStorageEntryBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        std::unique_ptr<SharedStorageEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageEntry;
        SharedStorageEntryBuilder() : m_result(new SharedStorageEntry()) { }

        template<int STEP> SharedStorageEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageEntry> m_result;
    };

    static SharedStorageEntryBuilder<0> create()
    {
        return SharedStorageEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageEntry();  // Defined below

    String m_key;
    String m_value;
};


class CORE_EXPORT SharedStorageMetadata : public ::crdtp::ProtocolObject<SharedStorageMetadata> {
public:
    ~SharedStorageMetadata() override;  // Defined below

    double getCreationTime() { return m_creationTime; }
    void setCreationTime(double value);  // Defined below

    int getLength() { return m_length; }
    void setLength(int value);  // Defined below

    double getRemainingBudget() { return m_remainingBudget; }
    void setRemainingBudget(double value);  // Defined below

    int getBytesUsed() { return m_bytesUsed; }
    void setBytesUsed(int value);  // Defined below

    template<int STATE>
    class SharedStorageMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CreationTimeSet = 1 << 1,
            LengthSet = 1 << 2,
            RemainingBudgetSet = 1 << 3,
            BytesUsedSet = 1 << 4,
            AllFieldsSet = (CreationTimeSet | LengthSet | RemainingBudgetSet | BytesUsedSet | 0)};


        SharedStorageMetadataBuilder<STATE | CreationTimeSet>& setCreationTime(double value);  // Defined below

        SharedStorageMetadataBuilder<STATE | LengthSet>& setLength(int value);  // Defined below

        SharedStorageMetadataBuilder<STATE | RemainingBudgetSet>& setRemainingBudget(double value);  // Defined below

        SharedStorageMetadataBuilder<STATE | BytesUsedSet>& setBytesUsed(int value);  // Defined below

        std::unique_ptr<SharedStorageMetadata> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageMetadata;
        SharedStorageMetadataBuilder() : m_result(new SharedStorageMetadata()) { }

        template<int STEP> SharedStorageMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageMetadata> m_result;
    };

    static SharedStorageMetadataBuilder<0> create()
    {
        return SharedStorageMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageMetadata();  // Defined below

    double m_creationTime;
    int m_length;
    double m_remainingBudget;
    int m_bytesUsed;
};


class CORE_EXPORT SharedStoragePrivateAggregationConfig : public ::crdtp::ProtocolObject<SharedStoragePrivateAggregationConfig> {
public:
    ~SharedStoragePrivateAggregationConfig() override;  // Defined below

    bool hasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String getAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& getAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void setAggregationCoordinatorOrigin(const String& value);  // Defined below

    bool hasContextId() { return !!m_contextId; }
    String getContextId(const String& defaultValue) const {
       return m_contextId.value_or(defaultValue);
    }
    const std::optional<String>& getContextId() const {
       return m_contextId;
    }
    void setContextId(const String& value);  // Defined below

    int getFilteringIdMaxBytes() { return m_filteringIdMaxBytes; }
    void setFilteringIdMaxBytes(int value);  // Defined below

    bool hasMaxContributions() { return !!m_maxContributions; }
    int getMaxContributions(int defaultValue) const {
       return m_maxContributions.value_or(defaultValue);
    }
    const std::optional<int>& getMaxContributions() const {
       return m_maxContributions;
    }
    void setMaxContributions(int value);  // Defined below

    template<int STATE>
    class SharedStoragePrivateAggregationConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FilteringIdMaxBytesSet = 1 << 1,
            AllFieldsSet = (FilteringIdMaxBytesSet | 0)};


        SharedStoragePrivateAggregationConfigBuilder<STATE>& setAggregationCoordinatorOrigin(const String& value);  // Defined below

        SharedStoragePrivateAggregationConfigBuilder<STATE>& setContextId(const String& value);  // Defined below

        SharedStoragePrivateAggregationConfigBuilder<STATE | FilteringIdMaxBytesSet>& setFilteringIdMaxBytes(int value);  // Defined below

        SharedStoragePrivateAggregationConfigBuilder<STATE>& setMaxContributions(int value);  // Defined below

        std::unique_ptr<SharedStoragePrivateAggregationConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStoragePrivateAggregationConfig;
        SharedStoragePrivateAggregationConfigBuilder() : m_result(new SharedStoragePrivateAggregationConfig()) { }

        template<int STEP> SharedStoragePrivateAggregationConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStoragePrivateAggregationConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> m_result;
    };

    static SharedStoragePrivateAggregationConfigBuilder<0> create()
    {
        return SharedStoragePrivateAggregationConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStoragePrivateAggregationConfig();  // Defined below

    std::optional<String> m_aggregationCoordinatorOrigin;
    std::optional<String> m_contextId;
    int m_filteringIdMaxBytes;
    std::optional<int> m_maxContributions;
};


class CORE_EXPORT SharedStorageReportingMetadata : public ::crdtp::ProtocolObject<SharedStorageReportingMetadata> {
public:
    ~SharedStorageReportingMetadata() override;  // Defined below

    String getEventType() { return m_eventType; }
    void setEventType(const String& value);  // Defined below

    String getReportingUrl() { return m_reportingUrl; }
    void setReportingUrl(const String& value);  // Defined below

    template<int STATE>
    class SharedStorageReportingMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            EventTypeSet = 1 << 1,
            ReportingUrlSet = 1 << 2,
            AllFieldsSet = (EventTypeSet | ReportingUrlSet | 0)};


        SharedStorageReportingMetadataBuilder<STATE | EventTypeSet>& setEventType(const String& value);  // Defined below

        SharedStorageReportingMetadataBuilder<STATE | ReportingUrlSet>& setReportingUrl(const String& value);  // Defined below

        std::unique_ptr<SharedStorageReportingMetadata> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageReportingMetadata;
        SharedStorageReportingMetadataBuilder() : m_result(new SharedStorageReportingMetadata()) { }

        template<int STEP> SharedStorageReportingMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageReportingMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageReportingMetadata> m_result;
    };

    static SharedStorageReportingMetadataBuilder<0> create()
    {
        return SharedStorageReportingMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageReportingMetadata();  // Defined below

    String m_eventType;
    String m_reportingUrl;
};


class CORE_EXPORT SharedStorageUrlWithMetadata : public ::crdtp::ProtocolObject<SharedStorageUrlWithMetadata> {
public:
    ~SharedStorageUrlWithMetadata() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    protocol::Array<protocol::Storage::SharedStorageReportingMetadata>* getReportingMetadata() { return m_reportingMetadata.get(); }
    void setReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value);  // Defined below

    template<int STATE>
    class SharedStorageUrlWithMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            ReportingMetadataSet = 1 << 2,
            AllFieldsSet = (UrlSet | ReportingMetadataSet | 0)};


        SharedStorageUrlWithMetadataBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        SharedStorageUrlWithMetadataBuilder<STATE | ReportingMetadataSet>& setReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value);  // Defined below

        std::unique_ptr<SharedStorageUrlWithMetadata> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageUrlWithMetadata;
        SharedStorageUrlWithMetadataBuilder() : m_result(new SharedStorageUrlWithMetadata()) { }

        template<int STEP> SharedStorageUrlWithMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageUrlWithMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageUrlWithMetadata> m_result;
    };

    static SharedStorageUrlWithMetadataBuilder<0> create()
    {
        return SharedStorageUrlWithMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageUrlWithMetadata();  // Defined below

    String m_url;
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> m_reportingMetadata;
};


class CORE_EXPORT SharedStorageAccessParams : public ::crdtp::ProtocolObject<SharedStorageAccessParams> {
public:
    ~SharedStorageAccessParams() override;  // Defined below

    bool hasScriptSourceUrl() { return !!m_scriptSourceUrl; }
    String getScriptSourceUrl(const String& defaultValue) const {
       return m_scriptSourceUrl.value_or(defaultValue);
    }
    const std::optional<String>& getScriptSourceUrl() const {
       return m_scriptSourceUrl;
    }
    void setScriptSourceUrl(const String& value);  // Defined below

    bool hasDataOrigin() { return !!m_dataOrigin; }
    String getDataOrigin(const String& defaultValue) const {
       return m_dataOrigin.value_or(defaultValue);
    }
    const std::optional<String>& getDataOrigin() const {
       return m_dataOrigin;
    }
    void setDataOrigin(const String& value);  // Defined below

    bool hasOperationName() { return !!m_operationName; }
    String getOperationName(const String& defaultValue) const {
       return m_operationName.value_or(defaultValue);
    }
    const std::optional<String>& getOperationName() const {
       return m_operationName;
    }
    void setOperationName(const String& value);  // Defined below

    bool hasOperationId() { return !!m_operationId; }
    String getOperationId(const String& defaultValue) const {
       return m_operationId.value_or(defaultValue);
    }
    const std::optional<String>& getOperationId() const {
       return m_operationId;
    }
    void setOperationId(const String& value);  // Defined below

    bool hasKeepAlive() { return !!m_keepAlive; }
    bool getKeepAlive(bool defaultValue) const {
       return m_keepAlive.value_or(defaultValue);
    }
    const std::optional<bool>& getKeepAlive() const {
       return m_keepAlive;
    }
    void setKeepAlive(bool value);  // Defined below

    bool hasPrivateAggregationConfig() { return !!m_privateAggregationConfig; }
    protocol::Storage::SharedStoragePrivateAggregationConfig* getPrivateAggregationConfig(protocol::Storage::SharedStoragePrivateAggregationConfig* defaultValue) {
       return m_privateAggregationConfig ? m_privateAggregationConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig>& getPrivateAggregationConfig() const {
       return m_privateAggregationConfig;
    }
    void setPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value);  // Defined below

    bool hasSerializedData() { return !!m_serializedData; }
    String getSerializedData(const String& defaultValue) const {
       return m_serializedData.value_or(defaultValue);
    }
    const std::optional<String>& getSerializedData() const {
       return m_serializedData;
    }
    void setSerializedData(const String& value);  // Defined below

    bool hasUrlsWithMetadata() { return !!m_urlsWithMetadata; }
    protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>* getUrlsWithMetadata(protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>* defaultValue) {
       return m_urlsWithMetadata ? m_urlsWithMetadata.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>>& getUrlsWithMetadata() const {
       return m_urlsWithMetadata;
    }
    void setUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value);  // Defined below

    bool hasUrnUuid() { return !!m_urnUuid; }
    String getUrnUuid(const String& defaultValue) const {
       return m_urnUuid.value_or(defaultValue);
    }
    const std::optional<String>& getUrnUuid() const {
       return m_urnUuid;
    }
    void setUrnUuid(const String& value);  // Defined below

    bool hasKey() { return !!m_key; }
    String getKey(const String& defaultValue) const {
       return m_key.value_or(defaultValue);
    }
    const std::optional<String>& getKey() const {
       return m_key;
    }
    void setKey(const String& value);  // Defined below

    bool hasValue() { return !!m_value; }
    String getValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& getValue() const {
       return m_value;
    }
    void setValue(const String& value);  // Defined below

    bool hasIgnoreIfPresent() { return !!m_ignoreIfPresent; }
    bool getIgnoreIfPresent(bool defaultValue) const {
       return m_ignoreIfPresent.value_or(defaultValue);
    }
    const std::optional<bool>& getIgnoreIfPresent() const {
       return m_ignoreIfPresent;
    }
    void setIgnoreIfPresent(bool value);  // Defined below

    bool hasWorkletOrdinal() { return !!m_workletOrdinal; }
    int getWorkletOrdinal(int defaultValue) const {
       return m_workletOrdinal.value_or(defaultValue);
    }
    const std::optional<int>& getWorkletOrdinal() const {
       return m_workletOrdinal;
    }
    void setWorkletOrdinal(int value);  // Defined below

    bool hasWorkletTargetId() { return !!m_workletTargetId; }
    String getWorkletTargetId(const String& defaultValue) const {
       return m_workletTargetId.value_or(defaultValue);
    }
    const std::optional<String>& getWorkletTargetId() const {
       return m_workletTargetId;
    }
    void setWorkletTargetId(const String& value);  // Defined below

    bool hasWithLock() { return !!m_withLock; }
    String getWithLock(const String& defaultValue) const {
       return m_withLock.value_or(defaultValue);
    }
    const std::optional<String>& getWithLock() const {
       return m_withLock;
    }
    void setWithLock(const String& value);  // Defined below

    bool hasBatchUpdateId() { return !!m_batchUpdateId; }
    String getBatchUpdateId(const String& defaultValue) const {
       return m_batchUpdateId.value_or(defaultValue);
    }
    const std::optional<String>& getBatchUpdateId() const {
       return m_batchUpdateId;
    }
    void setBatchUpdateId(const String& value);  // Defined below

    bool hasBatchSize() { return !!m_batchSize; }
    int getBatchSize(int defaultValue) const {
       return m_batchSize.value_or(defaultValue);
    }
    const std::optional<int>& getBatchSize() const {
       return m_batchSize;
    }
    void setBatchSize(int value);  // Defined below

    template<int STATE>
    class SharedStorageAccessParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SharedStorageAccessParamsBuilder<STATE>& setScriptSourceUrl(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setDataOrigin(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setOperationName(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setOperationId(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setKeepAlive(bool value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setSerializedData(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setUrnUuid(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setKey(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setValue(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setIgnoreIfPresent(bool value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setWorkletOrdinal(int value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setWorkletTargetId(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setWithLock(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setBatchUpdateId(const String& value);  // Defined below

        SharedStorageAccessParamsBuilder<STATE>& setBatchSize(int value);  // Defined below

        std::unique_ptr<SharedStorageAccessParams> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedStorageAccessParams;
        SharedStorageAccessParamsBuilder() : m_result(new SharedStorageAccessParams()) { }

        template<int STEP> SharedStorageAccessParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedStorageAccessParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::SharedStorageAccessParams> m_result;
    };

    static SharedStorageAccessParamsBuilder<0> create()
    {
        return SharedStorageAccessParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedStorageAccessParams();  // Defined below

    std::optional<String> m_scriptSourceUrl;
    std::optional<String> m_dataOrigin;
    std::optional<String> m_operationName;
    std::optional<String> m_operationId;
    std::optional<bool> m_keepAlive;
    std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> m_privateAggregationConfig;
    std::optional<String> m_serializedData;
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> m_urlsWithMetadata;
    std::optional<String> m_urnUuid;
    std::optional<String> m_key;
    std::optional<String> m_value;
    std::optional<bool> m_ignoreIfPresent;
    std::optional<int> m_workletOrdinal;
    std::optional<String> m_workletTargetId;
    std::optional<String> m_withLock;
    std::optional<String> m_batchUpdateId;
    std::optional<int> m_batchSize;
};


class CORE_EXPORT StorageBucket : public ::crdtp::ProtocolObject<StorageBucket> {
public:
    ~StorageBucket() override;  // Defined below

    String getStorageKey() { return m_storageKey; }
    void setStorageKey(const String& value);  // Defined below

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value);  // Defined below

    template<int STATE>
    class StorageBucketBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageKeySet = 1 << 1,
            AllFieldsSet = (StorageKeySet | 0)};


        StorageBucketBuilder<STATE | StorageKeySet>& setStorageKey(const String& value);  // Defined below

        StorageBucketBuilder<STATE>& setName(const String& value);  // Defined below

        std::unique_ptr<StorageBucket> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StorageBucket;
        StorageBucketBuilder() : m_result(new StorageBucket()) { }

        template<int STEP> StorageBucketBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StorageBucketBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::StorageBucket> m_result;
    };

    static StorageBucketBuilder<0> create()
    {
        return StorageBucketBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StorageBucket();  // Defined below

    String m_storageKey;
    std::optional<String> m_name;
};


class CORE_EXPORT StorageBucketInfo : public ::crdtp::ProtocolObject<StorageBucketInfo> {
public:
    ~StorageBucketInfo() override;  // Defined below

    protocol::Storage::StorageBucket* getBucket() { return m_bucket.get(); }
    void setBucket(std::unique_ptr<protocol::Storage::StorageBucket> value);  // Defined below

    String getId() { return m_id; }
    void setId(const String& value);  // Defined below

    double getExpiration() { return m_expiration; }
    void setExpiration(double value);  // Defined below

    double getQuota() { return m_quota; }
    void setQuota(double value);  // Defined below

    bool getPersistent() { return m_persistent; }
    void setPersistent(bool value);  // Defined below

    String getDurability() { return m_durability; }
    void setDurability(const String& value);  // Defined below

    template<int STATE>
    class StorageBucketInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BucketSet = 1 << 1,
            IdSet = 1 << 2,
            ExpirationSet = 1 << 3,
            QuotaSet = 1 << 4,
            PersistentSet = 1 << 5,
            DurabilitySet = 1 << 6,
            AllFieldsSet = (BucketSet | IdSet | ExpirationSet | QuotaSet | PersistentSet | DurabilitySet | 0)};


        StorageBucketInfoBuilder<STATE | BucketSet>& setBucket(std::unique_ptr<protocol::Storage::StorageBucket> value);  // Defined below

        StorageBucketInfoBuilder<STATE | IdSet>& setId(const String& value);  // Defined below

        StorageBucketInfoBuilder<STATE | ExpirationSet>& setExpiration(double value);  // Defined below

        StorageBucketInfoBuilder<STATE | QuotaSet>& setQuota(double value);  // Defined below

        StorageBucketInfoBuilder<STATE | PersistentSet>& setPersistent(bool value);  // Defined below

        StorageBucketInfoBuilder<STATE | DurabilitySet>& setDurability(const String& value);  // Defined below

        std::unique_ptr<StorageBucketInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StorageBucketInfo;
        StorageBucketInfoBuilder() : m_result(new StorageBucketInfo()) { }

        template<int STEP> StorageBucketInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StorageBucketInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::StorageBucketInfo> m_result;
    };

    static StorageBucketInfoBuilder<0> create()
    {
        return StorageBucketInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StorageBucketInfo();  // Defined below

    std::unique_ptr<protocol::Storage::StorageBucket> m_bucket;
    String m_id;
    double m_expiration;
    double m_quota;
    bool m_persistent;
    String m_durability;
};


class CORE_EXPORT AttributionReportingFilterDataEntry : public ::crdtp::ProtocolObject<AttributionReportingFilterDataEntry> {
public:
    ~AttributionReportingFilterDataEntry() override;  // Defined below

    String getKey() { return m_key; }
    void setKey(const String& value);  // Defined below

    protocol::Array<String>* getValues() { return m_values.get(); }
    void setValues(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class AttributionReportingFilterDataEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValuesSet = 1 << 2,
            AllFieldsSet = (KeySet | ValuesSet | 0)};


        AttributionReportingFilterDataEntryBuilder<STATE | KeySet>& setKey(const String& value);  // Defined below

        AttributionReportingFilterDataEntryBuilder<STATE | ValuesSet>& setValues(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<AttributionReportingFilterDataEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterDataEntry;
        AttributionReportingFilterDataEntryBuilder() : m_result(new AttributionReportingFilterDataEntry()) { }

        template<int STEP> AttributionReportingFilterDataEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterDataEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterDataEntry> m_result;
    };

    static AttributionReportingFilterDataEntryBuilder<0> create()
    {
        return AttributionReportingFilterDataEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterDataEntry();  // Defined below

    String m_key;
    std::unique_ptr<protocol::Array<String>> m_values;
};


class CORE_EXPORT AttributionReportingFilterConfig : public ::crdtp::ProtocolObject<AttributionReportingFilterConfig> {
public:
    ~AttributionReportingFilterConfig() override;  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>* getFilterValues() { return m_filterValues.get(); }
    void setFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value);  // Defined below

    bool hasLookbackWindow() { return !!m_lookbackWindow; }
    int getLookbackWindow(int defaultValue) const {
       return m_lookbackWindow.value_or(defaultValue);
    }
    const std::optional<int>& getLookbackWindow() const {
       return m_lookbackWindow;
    }
    void setLookbackWindow(int value);  // Defined below

    template<int STATE>
    class AttributionReportingFilterConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FilterValuesSet = 1 << 1,
            AllFieldsSet = (FilterValuesSet | 0)};


        AttributionReportingFilterConfigBuilder<STATE | FilterValuesSet>& setFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value);  // Defined below

        AttributionReportingFilterConfigBuilder<STATE>& setLookbackWindow(int value);  // Defined below

        std::unique_ptr<AttributionReportingFilterConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterConfig;
        AttributionReportingFilterConfigBuilder() : m_result(new AttributionReportingFilterConfig()) { }

        template<int STEP> AttributionReportingFilterConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterConfig> m_result;
    };

    static AttributionReportingFilterConfigBuilder<0> create()
    {
        return AttributionReportingFilterConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterConfig();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> m_filterValues;
    std::optional<int> m_lookbackWindow;
};


class CORE_EXPORT AttributionReportingFilterPair : public ::crdtp::ProtocolObject<AttributionReportingFilterPair> {
public:
    ~AttributionReportingFilterPair() override;  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingFilterConfig>* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingFilterConfig>* getNotFilters() { return m_notFilters.get(); }
    void setNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value);  // Defined below

    template<int STATE>
    class AttributionReportingFilterPairBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            NotFiltersSet = 1 << 2,
            AllFieldsSet = (FiltersSet | NotFiltersSet | 0)};


        AttributionReportingFilterPairBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value);  // Defined below

        AttributionReportingFilterPairBuilder<STATE | NotFiltersSet>& setNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value);  // Defined below

        std::unique_ptr<AttributionReportingFilterPair> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingFilterPair;
        AttributionReportingFilterPairBuilder() : m_result(new AttributionReportingFilterPair()) { }

        template<int STEP> AttributionReportingFilterPairBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingFilterPairBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_result;
    };

    static AttributionReportingFilterPairBuilder<0> create()
    {
        return AttributionReportingFilterPairBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingFilterPair();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> m_filters;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> m_notFilters;
};


class CORE_EXPORT AttributionReportingAggregationKeysEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregationKeysEntry> {
public:
    ~AttributionReportingAggregationKeysEntry() override;  // Defined below

    String getKey() { return m_key; }
    void setKey(const String& value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregationKeysEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (KeySet | ValueSet | 0)};


        AttributionReportingAggregationKeysEntryBuilder<STATE | KeySet>& setKey(const String& value);  // Defined below

        AttributionReportingAggregationKeysEntryBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        std::unique_ptr<AttributionReportingAggregationKeysEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregationKeysEntry;
        AttributionReportingAggregationKeysEntryBuilder() : m_result(new AttributionReportingAggregationKeysEntry()) { }

        template<int STEP> AttributionReportingAggregationKeysEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregationKeysEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregationKeysEntry> m_result;
    };

    static AttributionReportingAggregationKeysEntryBuilder<0> create()
    {
        return AttributionReportingAggregationKeysEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregationKeysEntry();  // Defined below

    String m_key;
    String m_value;
};


class CORE_EXPORT AttributionReportingEventReportWindows : public ::crdtp::ProtocolObject<AttributionReportingEventReportWindows> {
public:
    ~AttributionReportingEventReportWindows() override;  // Defined below

    int getStart() { return m_start; }
    void setStart(int value);  // Defined below

    protocol::Array<int>* getEnds() { return m_ends.get(); }
    void setEnds(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class AttributionReportingEventReportWindowsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StartSet = 1 << 1,
            EndsSet = 1 << 2,
            AllFieldsSet = (StartSet | EndsSet | 0)};


        AttributionReportingEventReportWindowsBuilder<STATE | StartSet>& setStart(int value);  // Defined below

        AttributionReportingEventReportWindowsBuilder<STATE | EndsSet>& setEnds(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<AttributionReportingEventReportWindows> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingEventReportWindows;
        AttributionReportingEventReportWindowsBuilder() : m_result(new AttributionReportingEventReportWindows()) { }

        template<int STEP> AttributionReportingEventReportWindowsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingEventReportWindowsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> m_result;
    };

    static AttributionReportingEventReportWindowsBuilder<0> create()
    {
        return AttributionReportingEventReportWindowsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingEventReportWindows();  // Defined below

    int m_start;
    std::unique_ptr<protocol::Array<int>> m_ends;
};


class CORE_EXPORT AttributionReportingAggregatableDebugReportingData : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDebugReportingData> {
public:
    ~AttributionReportingAggregatableDebugReportingData() override;  // Defined below

    String getKeyPiece() { return m_keyPiece; }
    void setKeyPiece(const String& value);  // Defined below

    double getValue() { return m_value; }
    void setValue(double value);  // Defined below

    protocol::Array<String>* getTypes() { return m_types.get(); }
    void setTypes(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregatableDebugReportingDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            ValueSet = 1 << 2,
            TypesSet = 1 << 3,
            AllFieldsSet = (KeyPieceSet | ValueSet | TypesSet | 0)};


        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | KeyPieceSet>& setKeyPiece(const String& value);  // Defined below

        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | ValueSet>& setValue(double value);  // Defined below

        AttributionReportingAggregatableDebugReportingDataBuilder<STATE | TypesSet>& setTypes(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<AttributionReportingAggregatableDebugReportingData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDebugReportingData;
        AttributionReportingAggregatableDebugReportingDataBuilder() : m_result(new AttributionReportingAggregatableDebugReportingData()) { }

        template<int STEP> AttributionReportingAggregatableDebugReportingDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDebugReportingDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingData> m_result;
    };

    static AttributionReportingAggregatableDebugReportingDataBuilder<0> create()
    {
        return AttributionReportingAggregatableDebugReportingDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDebugReportingData();  // Defined below

    String m_keyPiece;
    double m_value;
    std::unique_ptr<protocol::Array<String>> m_types;
};


class CORE_EXPORT AttributionReportingAggregatableDebugReportingConfig : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDebugReportingConfig> {
public:
    ~AttributionReportingAggregatableDebugReportingConfig() override;  // Defined below

    bool hasBudget() { return !!m_budget; }
    double getBudget(double defaultValue) const {
       return m_budget.value_or(defaultValue);
    }
    const std::optional<double>& getBudget() const {
       return m_budget;
    }
    void setBudget(double value);  // Defined below

    String getKeyPiece() { return m_keyPiece; }
    void setKeyPiece(const String& value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>* getDebugData() { return m_debugData.get(); }
    void setDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value);  // Defined below

    bool hasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String getAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& getAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void setAggregationCoordinatorOrigin(const String& value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregatableDebugReportingConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            DebugDataSet = 1 << 2,
            AllFieldsSet = (KeyPieceSet | DebugDataSet | 0)};


        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& setBudget(double value);  // Defined below

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | KeyPieceSet>& setKeyPiece(const String& value);  // Defined below

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | DebugDataSet>& setDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value);  // Defined below

        AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& setAggregationCoordinatorOrigin(const String& value);  // Defined below

        std::unique_ptr<AttributionReportingAggregatableDebugReportingConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDebugReportingConfig;
        AttributionReportingAggregatableDebugReportingConfigBuilder() : m_result(new AttributionReportingAggregatableDebugReportingConfig()) { }

        template<int STEP> AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_result;
    };

    static AttributionReportingAggregatableDebugReportingConfigBuilder<0> create()
    {
        return AttributionReportingAggregatableDebugReportingConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDebugReportingConfig();  // Defined below

    std::optional<double> m_budget;
    String m_keyPiece;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> m_debugData;
    std::optional<String> m_aggregationCoordinatorOrigin;
};


class CORE_EXPORT AttributionScopesData : public ::crdtp::ProtocolObject<AttributionScopesData> {
public:
    ~AttributionScopesData() override;  // Defined below

    protocol::Array<String>* getValues() { return m_values.get(); }
    void setValues(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    double getLimit() { return m_limit; }
    void setLimit(double value);  // Defined below

    double getMaxEventStates() { return m_maxEventStates; }
    void setMaxEventStates(double value);  // Defined below

    template<int STATE>
    class AttributionScopesDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValuesSet = 1 << 1,
            LimitSet = 1 << 2,
            MaxEventStatesSet = 1 << 3,
            AllFieldsSet = (ValuesSet | LimitSet | MaxEventStatesSet | 0)};


        AttributionScopesDataBuilder<STATE | ValuesSet>& setValues(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        AttributionScopesDataBuilder<STATE | LimitSet>& setLimit(double value);  // Defined below

        AttributionScopesDataBuilder<STATE | MaxEventStatesSet>& setMaxEventStates(double value);  // Defined below

        std::unique_ptr<AttributionScopesData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionScopesData;
        AttributionScopesDataBuilder() : m_result(new AttributionScopesData()) { }

        template<int STEP> AttributionScopesDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionScopesDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionScopesData> m_result;
    };

    static AttributionScopesDataBuilder<0> create()
    {
        return AttributionScopesDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionScopesData();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_values;
    double m_limit;
    double m_maxEventStates;
};


class CORE_EXPORT AttributionReportingNamedBudgetDef : public ::crdtp::ProtocolObject<AttributionReportingNamedBudgetDef> {
public:
    ~AttributionReportingNamedBudgetDef() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    int getBudget() { return m_budget; }
    void setBudget(int value);  // Defined below

    template<int STATE>
    class AttributionReportingNamedBudgetDefBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            BudgetSet = 1 << 2,
            AllFieldsSet = (NameSet | BudgetSet | 0)};


        AttributionReportingNamedBudgetDefBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        AttributionReportingNamedBudgetDefBuilder<STATE | BudgetSet>& setBudget(int value);  // Defined below

        std::unique_ptr<AttributionReportingNamedBudgetDef> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingNamedBudgetDef;
        AttributionReportingNamedBudgetDefBuilder() : m_result(new AttributionReportingNamedBudgetDef()) { }

        template<int STEP> AttributionReportingNamedBudgetDefBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingNamedBudgetDefBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingNamedBudgetDef> m_result;
    };

    static AttributionReportingNamedBudgetDefBuilder<0> create()
    {
        return AttributionReportingNamedBudgetDefBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingNamedBudgetDef();  // Defined below

    String m_name;
    int m_budget;
};


class CORE_EXPORT AttributionReportingSourceRegistration : public ::crdtp::ProtocolObject<AttributionReportingSourceRegistration> {
public:
    ~AttributionReportingSourceRegistration() override;  // Defined below

    double getTime() { return m_time; }
    void setTime(double value);  // Defined below

    int getExpiry() { return m_expiry; }
    void setExpiry(int value);  // Defined below

    protocol::Array<double>* getTriggerData() { return m_triggerData.get(); }
    void setTriggerData(std::unique_ptr<protocol::Array<double>> value);  // Defined below

    protocol::Storage::AttributionReportingEventReportWindows* getEventReportWindows() { return m_eventReportWindows.get(); }
    void setEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value);  // Defined below

    int getAggregatableReportWindow() { return m_aggregatableReportWindow; }
    void setAggregatableReportWindow(int value);  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    String getSourceOrigin() { return m_sourceOrigin; }
    void setSourceOrigin(const String& value);  // Defined below

    String getReportingOrigin() { return m_reportingOrigin; }
    void setReportingOrigin(const String& value);  // Defined below

    protocol::Array<String>* getDestinationSites() { return m_destinationSites.get(); }
    void setDestinationSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    String getEventId() { return m_eventId; }
    void setEventId(const String& value);  // Defined below

    String getPriority() { return m_priority; }
    void setPriority(const String& value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>* getFilterData() { return m_filterData.get(); }
    void setFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>* getAggregationKeys() { return m_aggregationKeys.get(); }
    void setAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value);  // Defined below

    bool hasDebugKey() { return !!m_debugKey; }
    String getDebugKey(const String& defaultValue) const {
       return m_debugKey.value_or(defaultValue);
    }
    const std::optional<String>& getDebugKey() const {
       return m_debugKey;
    }
    void setDebugKey(const String& value);  // Defined below

    String getTriggerDataMatching() { return m_triggerDataMatching; }
    void setTriggerDataMatching(const String& value);  // Defined below

    String getDestinationLimitPriority() { return m_destinationLimitPriority; }
    void setDestinationLimitPriority(const String& value);  // Defined below

    protocol::Storage::AttributionReportingAggregatableDebugReportingConfig* getAggregatableDebugReportingConfig() { return m_aggregatableDebugReportingConfig.get(); }
    void setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value);  // Defined below

    bool hasScopesData() { return !!m_scopesData; }
    protocol::Storage::AttributionScopesData* getScopesData(protocol::Storage::AttributionScopesData* defaultValue) {
       return m_scopesData ? m_scopesData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Storage::AttributionScopesData>& getScopesData() const {
       return m_scopesData;
    }
    void setScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value);  // Defined below

    int getMaxEventLevelReports() { return m_maxEventLevelReports; }
    void setMaxEventLevelReports(int value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>* getNamedBudgets() { return m_namedBudgets.get(); }
    void setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value);  // Defined below

    bool getDebugReporting() { return m_debugReporting; }
    void setDebugReporting(bool value);  // Defined below

    double getEventLevelEpsilon() { return m_eventLevelEpsilon; }
    void setEventLevelEpsilon(double value);  // Defined below

    template<int STATE>
    class AttributionReportingSourceRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TimeSet = 1 << 1,
            ExpirySet = 1 << 2,
            TriggerDataSet = 1 << 3,
            EventReportWindowsSet = 1 << 4,
            AggregatableReportWindowSet = 1 << 5,
            TypeSet = 1 << 6,
            SourceOriginSet = 1 << 7,
            ReportingOriginSet = 1 << 8,
            DestinationSitesSet = 1 << 9,
            EventIdSet = 1 << 10,
            PrioritySet = 1 << 11,
            FilterDataSet = 1 << 12,
            AggregationKeysSet = 1 << 13,
            TriggerDataMatchingSet = 1 << 14,
            DestinationLimitPrioritySet = 1 << 15,
            AggregatableDebugReportingConfigSet = 1 << 16,
            MaxEventLevelReportsSet = 1 << 17,
            NamedBudgetsSet = 1 << 18,
            DebugReportingSet = 1 << 19,
            EventLevelEpsilonSet = 1 << 20,
            AllFieldsSet = (TimeSet | ExpirySet | TriggerDataSet | EventReportWindowsSet | AggregatableReportWindowSet | TypeSet | SourceOriginSet | ReportingOriginSet | DestinationSitesSet | EventIdSet | PrioritySet | FilterDataSet | AggregationKeysSet | TriggerDataMatchingSet | DestinationLimitPrioritySet | AggregatableDebugReportingConfigSet | MaxEventLevelReportsSet | NamedBudgetsSet | DebugReportingSet | EventLevelEpsilonSet | 0)};


        AttributionReportingSourceRegistrationBuilder<STATE | TimeSet>& setTime(double value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | ExpirySet>& setExpiry(int value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | TriggerDataSet>& setTriggerData(std::unique_ptr<protocol::Array<double>> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | EventReportWindowsSet>& setEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | AggregatableReportWindowSet>& setAggregatableReportWindow(int value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | SourceOriginSet>& setSourceOrigin(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | ReportingOriginSet>& setReportingOrigin(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | DestinationSitesSet>& setDestinationSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | EventIdSet>& setEventId(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | PrioritySet>& setPriority(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | FilterDataSet>& setFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | AggregationKeysSet>& setAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE>& setDebugKey(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | TriggerDataMatchingSet>& setTriggerDataMatching(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | DestinationLimitPrioritySet>& setDestinationLimitPriority(const String& value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | AggregatableDebugReportingConfigSet>& setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE>& setScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | MaxEventLevelReportsSet>& setMaxEventLevelReports(int value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | NamedBudgetsSet>& setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | DebugReportingSet>& setDebugReporting(bool value);  // Defined below

        AttributionReportingSourceRegistrationBuilder<STATE | EventLevelEpsilonSet>& setEventLevelEpsilon(double value);  // Defined below

        std::unique_ptr<AttributionReportingSourceRegistration> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingSourceRegistration;
        AttributionReportingSourceRegistrationBuilder() : m_result(new AttributionReportingSourceRegistration()) { }

        template<int STEP> AttributionReportingSourceRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingSourceRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> m_result;
    };

    static AttributionReportingSourceRegistrationBuilder<0> create()
    {
        return AttributionReportingSourceRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingSourceRegistration();  // Defined below

    double m_time;
    int m_expiry;
    std::unique_ptr<protocol::Array<double>> m_triggerData;
    std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> m_eventReportWindows;
    int m_aggregatableReportWindow;
    String m_type;
    String m_sourceOrigin;
    String m_reportingOrigin;
    std::unique_ptr<protocol::Array<String>> m_destinationSites;
    String m_eventId;
    String m_priority;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> m_filterData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> m_aggregationKeys;
    std::optional<String> m_debugKey;
    String m_triggerDataMatching;
    String m_destinationLimitPriority;
    std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_aggregatableDebugReportingConfig;
    std::unique_ptr<protocol::Storage::AttributionScopesData> m_scopesData;
    int m_maxEventLevelReports;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> m_namedBudgets;
    bool m_debugReporting;
    double m_eventLevelEpsilon;
};


class CORE_EXPORT AttributionReportingAggregatableValueDictEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregatableValueDictEntry> {
public:
    ~AttributionReportingAggregatableValueDictEntry() override;  // Defined below

    String getKey() { return m_key; }
    void setKey(const String& value);  // Defined below

    double getValue() { return m_value; }
    void setValue(double value);  // Defined below

    String getFilteringId() { return m_filteringId; }
    void setFilteringId(const String& value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregatableValueDictEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            ValueSet = 1 << 2,
            FilteringIdSet = 1 << 3,
            AllFieldsSet = (KeySet | ValueSet | FilteringIdSet | 0)};


        AttributionReportingAggregatableValueDictEntryBuilder<STATE | KeySet>& setKey(const String& value);  // Defined below

        AttributionReportingAggregatableValueDictEntryBuilder<STATE | ValueSet>& setValue(double value);  // Defined below

        AttributionReportingAggregatableValueDictEntryBuilder<STATE | FilteringIdSet>& setFilteringId(const String& value);  // Defined below

        std::unique_ptr<AttributionReportingAggregatableValueDictEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableValueDictEntry;
        AttributionReportingAggregatableValueDictEntryBuilder() : m_result(new AttributionReportingAggregatableValueDictEntry()) { }

        template<int STEP> AttributionReportingAggregatableValueDictEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableValueDictEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableValueDictEntry> m_result;
    };

    static AttributionReportingAggregatableValueDictEntryBuilder<0> create()
    {
        return AttributionReportingAggregatableValueDictEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableValueDictEntry();  // Defined below

    String m_key;
    double m_value;
    String m_filteringId;
};


class CORE_EXPORT AttributionReportingAggregatableValueEntry : public ::crdtp::ProtocolObject<AttributionReportingAggregatableValueEntry> {
public:
    ~AttributionReportingAggregatableValueEntry() override;  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>* getValues() { return m_values.get(); }
    void setValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value);  // Defined below

    protocol::Storage::AttributionReportingFilterPair* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregatableValueEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValuesSet = 1 << 1,
            FiltersSet = 1 << 2,
            AllFieldsSet = (ValuesSet | FiltersSet | 0)};


        AttributionReportingAggregatableValueEntryBuilder<STATE | ValuesSet>& setValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value);  // Defined below

        AttributionReportingAggregatableValueEntryBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

        std::unique_ptr<AttributionReportingAggregatableValueEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableValueEntry;
        AttributionReportingAggregatableValueEntryBuilder() : m_result(new AttributionReportingAggregatableValueEntry()) { }

        template<int STEP> AttributionReportingAggregatableValueEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableValueEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableValueEntry> m_result;
    };

    static AttributionReportingAggregatableValueEntryBuilder<0> create()
    {
        return AttributionReportingAggregatableValueEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableValueEntry();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> m_values;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CORE_EXPORT AttributionReportingEventTriggerData : public ::crdtp::ProtocolObject<AttributionReportingEventTriggerData> {
public:
    ~AttributionReportingEventTriggerData() override;  // Defined below

    String getData() { return m_data; }
    void setData(const String& value);  // Defined below

    String getPriority() { return m_priority; }
    void setPriority(const String& value);  // Defined below

    bool hasDedupKey() { return !!m_dedupKey; }
    String getDedupKey(const String& defaultValue) const {
       return m_dedupKey.value_or(defaultValue);
    }
    const std::optional<String>& getDedupKey() const {
       return m_dedupKey;
    }
    void setDedupKey(const String& value);  // Defined below

    protocol::Storage::AttributionReportingFilterPair* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

    template<int STATE>
    class AttributionReportingEventTriggerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DataSet = 1 << 1,
            PrioritySet = 1 << 2,
            FiltersSet = 1 << 3,
            AllFieldsSet = (DataSet | PrioritySet | FiltersSet | 0)};


        AttributionReportingEventTriggerDataBuilder<STATE | DataSet>& setData(const String& value);  // Defined below

        AttributionReportingEventTriggerDataBuilder<STATE | PrioritySet>& setPriority(const String& value);  // Defined below

        AttributionReportingEventTriggerDataBuilder<STATE>& setDedupKey(const String& value);  // Defined below

        AttributionReportingEventTriggerDataBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

        std::unique_ptr<AttributionReportingEventTriggerData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingEventTriggerData;
        AttributionReportingEventTriggerDataBuilder() : m_result(new AttributionReportingEventTriggerData()) { }

        template<int STEP> AttributionReportingEventTriggerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingEventTriggerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingEventTriggerData> m_result;
    };

    static AttributionReportingEventTriggerDataBuilder<0> create()
    {
        return AttributionReportingEventTriggerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingEventTriggerData();  // Defined below

    String m_data;
    String m_priority;
    std::optional<String> m_dedupKey;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CORE_EXPORT AttributionReportingAggregatableTriggerData : public ::crdtp::ProtocolObject<AttributionReportingAggregatableTriggerData> {
public:
    ~AttributionReportingAggregatableTriggerData() override;  // Defined below

    String getKeyPiece() { return m_keyPiece; }
    void setKeyPiece(const String& value);  // Defined below

    protocol::Array<String>* getSourceKeys() { return m_sourceKeys.get(); }
    void setSourceKeys(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Storage::AttributionReportingFilterPair* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregatableTriggerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyPieceSet = 1 << 1,
            SourceKeysSet = 1 << 2,
            FiltersSet = 1 << 3,
            AllFieldsSet = (KeyPieceSet | SourceKeysSet | FiltersSet | 0)};


        AttributionReportingAggregatableTriggerDataBuilder<STATE | KeyPieceSet>& setKeyPiece(const String& value);  // Defined below

        AttributionReportingAggregatableTriggerDataBuilder<STATE | SourceKeysSet>& setSourceKeys(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        AttributionReportingAggregatableTriggerDataBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

        std::unique_ptr<AttributionReportingAggregatableTriggerData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableTriggerData;
        AttributionReportingAggregatableTriggerDataBuilder() : m_result(new AttributionReportingAggregatableTriggerData()) { }

        template<int STEP> AttributionReportingAggregatableTriggerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableTriggerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableTriggerData> m_result;
    };

    static AttributionReportingAggregatableTriggerDataBuilder<0> create()
    {
        return AttributionReportingAggregatableTriggerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableTriggerData();  // Defined below

    String m_keyPiece;
    std::unique_ptr<protocol::Array<String>> m_sourceKeys;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CORE_EXPORT AttributionReportingAggregatableDedupKey : public ::crdtp::ProtocolObject<AttributionReportingAggregatableDedupKey> {
public:
    ~AttributionReportingAggregatableDedupKey() override;  // Defined below

    bool hasDedupKey() { return !!m_dedupKey; }
    String getDedupKey(const String& defaultValue) const {
       return m_dedupKey.value_or(defaultValue);
    }
    const std::optional<String>& getDedupKey() const {
       return m_dedupKey;
    }
    void setDedupKey(const String& value);  // Defined below

    protocol::Storage::AttributionReportingFilterPair* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

    template<int STATE>
    class AttributionReportingAggregatableDedupKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AllFieldsSet = (FiltersSet | 0)};


        AttributionReportingAggregatableDedupKeyBuilder<STATE>& setDedupKey(const String& value);  // Defined below

        AttributionReportingAggregatableDedupKeyBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

        std::unique_ptr<AttributionReportingAggregatableDedupKey> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingAggregatableDedupKey;
        AttributionReportingAggregatableDedupKeyBuilder() : m_result(new AttributionReportingAggregatableDedupKey()) { }

        template<int STEP> AttributionReportingAggregatableDedupKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingAggregatableDedupKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDedupKey> m_result;
    };

    static AttributionReportingAggregatableDedupKeyBuilder<0> create()
    {
        return AttributionReportingAggregatableDedupKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingAggregatableDedupKey();  // Defined below

    std::optional<String> m_dedupKey;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CORE_EXPORT AttributionReportingNamedBudgetCandidate : public ::crdtp::ProtocolObject<AttributionReportingNamedBudgetCandidate> {
public:
    ~AttributionReportingNamedBudgetCandidate() override;  // Defined below

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value);  // Defined below

    protocol::Storage::AttributionReportingFilterPair* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

    template<int STATE>
    class AttributionReportingNamedBudgetCandidateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AllFieldsSet = (FiltersSet | 0)};


        AttributionReportingNamedBudgetCandidateBuilder<STATE>& setName(const String& value);  // Defined below

        AttributionReportingNamedBudgetCandidateBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

        std::unique_ptr<AttributionReportingNamedBudgetCandidate> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingNamedBudgetCandidate;
        AttributionReportingNamedBudgetCandidateBuilder() : m_result(new AttributionReportingNamedBudgetCandidate()) { }

        template<int STEP> AttributionReportingNamedBudgetCandidateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingNamedBudgetCandidateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingNamedBudgetCandidate> m_result;
    };

    static AttributionReportingNamedBudgetCandidateBuilder<0> create()
    {
        return AttributionReportingNamedBudgetCandidateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingNamedBudgetCandidate();  // Defined below

    std::optional<String> m_name;
    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
};


class CORE_EXPORT AttributionReportingTriggerRegistration : public ::crdtp::ProtocolObject<AttributionReportingTriggerRegistration> {
public:
    ~AttributionReportingTriggerRegistration() override;  // Defined below

    protocol::Storage::AttributionReportingFilterPair* getFilters() { return m_filters.get(); }
    void setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

    bool hasDebugKey() { return !!m_debugKey; }
    String getDebugKey(const String& defaultValue) const {
       return m_debugKey.value_or(defaultValue);
    }
    const std::optional<String>& getDebugKey() const {
       return m_debugKey;
    }
    void setDebugKey(const String& value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>* getAggregatableDedupKeys() { return m_aggregatableDedupKeys.get(); }
    void setAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>* getEventTriggerData() { return m_eventTriggerData.get(); }
    void setEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>* getAggregatableTriggerData() { return m_aggregatableTriggerData.get(); }
    void setAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>* getAggregatableValues() { return m_aggregatableValues.get(); }
    void setAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value);  // Defined below

    int getAggregatableFilteringIdMaxBytes() { return m_aggregatableFilteringIdMaxBytes; }
    void setAggregatableFilteringIdMaxBytes(int value);  // Defined below

    bool getDebugReporting() { return m_debugReporting; }
    void setDebugReporting(bool value);  // Defined below

    bool hasAggregationCoordinatorOrigin() { return !!m_aggregationCoordinatorOrigin; }
    String getAggregationCoordinatorOrigin(const String& defaultValue) const {
       return m_aggregationCoordinatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& getAggregationCoordinatorOrigin() const {
       return m_aggregationCoordinatorOrigin;
    }
    void setAggregationCoordinatorOrigin(const String& value);  // Defined below

    String getSourceRegistrationTimeConfig() { return m_sourceRegistrationTimeConfig; }
    void setSourceRegistrationTimeConfig(const String& value);  // Defined below

    bool hasTriggerContextId() { return !!m_triggerContextId; }
    String getTriggerContextId(const String& defaultValue) const {
       return m_triggerContextId.value_or(defaultValue);
    }
    const std::optional<String>& getTriggerContextId() const {
       return m_triggerContextId;
    }
    void setTriggerContextId(const String& value);  // Defined below

    protocol::Storage::AttributionReportingAggregatableDebugReportingConfig* getAggregatableDebugReportingConfig() { return m_aggregatableDebugReportingConfig.get(); }
    void setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value);  // Defined below

    protocol::Array<String>* getScopes() { return m_scopes.get(); }
    void setScopes(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>* getNamedBudgets() { return m_namedBudgets.get(); }
    void setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value);  // Defined below

    template<int STATE>
    class AttributionReportingTriggerRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FiltersSet = 1 << 1,
            AggregatableDedupKeysSet = 1 << 2,
            EventTriggerDataSet = 1 << 3,
            AggregatableTriggerDataSet = 1 << 4,
            AggregatableValuesSet = 1 << 5,
            AggregatableFilteringIdMaxBytesSet = 1 << 6,
            DebugReportingSet = 1 << 7,
            SourceRegistrationTimeConfigSet = 1 << 8,
            AggregatableDebugReportingConfigSet = 1 << 9,
            ScopesSet = 1 << 10,
            NamedBudgetsSet = 1 << 11,
            AllFieldsSet = (FiltersSet | AggregatableDedupKeysSet | EventTriggerDataSet | AggregatableTriggerDataSet | AggregatableValuesSet | AggregatableFilteringIdMaxBytesSet | DebugReportingSet | SourceRegistrationTimeConfigSet | AggregatableDebugReportingConfigSet | ScopesSet | NamedBudgetsSet | 0)};


        AttributionReportingTriggerRegistrationBuilder<STATE | FiltersSet>& setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE>& setDebugKey(const String& value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableDedupKeysSet>& setAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | EventTriggerDataSet>& setEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableTriggerDataSet>& setAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableValuesSet>& setAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableFilteringIdMaxBytesSet>& setAggregatableFilteringIdMaxBytes(int value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | DebugReportingSet>& setDebugReporting(bool value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE>& setAggregationCoordinatorOrigin(const String& value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | SourceRegistrationTimeConfigSet>& setSourceRegistrationTimeConfig(const String& value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE>& setTriggerContextId(const String& value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | AggregatableDebugReportingConfigSet>& setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | ScopesSet>& setScopes(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        AttributionReportingTriggerRegistrationBuilder<STATE | NamedBudgetsSet>& setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value);  // Defined below

        std::unique_ptr<AttributionReportingTriggerRegistration> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingTriggerRegistration;
        AttributionReportingTriggerRegistrationBuilder() : m_result(new AttributionReportingTriggerRegistration()) { }

        template<int STEP> AttributionReportingTriggerRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingTriggerRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> m_result;
    };

    static AttributionReportingTriggerRegistrationBuilder<0> create()
    {
        return AttributionReportingTriggerRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingTriggerRegistration();  // Defined below

    std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> m_filters;
    std::optional<String> m_debugKey;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> m_aggregatableDedupKeys;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> m_eventTriggerData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> m_aggregatableTriggerData;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> m_aggregatableValues;
    int m_aggregatableFilteringIdMaxBytes;
    bool m_debugReporting;
    std::optional<String> m_aggregationCoordinatorOrigin;
    String m_sourceRegistrationTimeConfig;
    std::optional<String> m_triggerContextId;
    std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> m_aggregatableDebugReportingConfig;
    std::unique_ptr<protocol::Array<String>> m_scopes;
    std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> m_namedBudgets;
};


class CORE_EXPORT RelatedWebsiteSet : public ::crdtp::ProtocolObject<RelatedWebsiteSet> {
public:
    ~RelatedWebsiteSet() override;  // Defined below

    protocol::Array<String>* getPrimarySites() { return m_primarySites.get(); }
    void setPrimarySites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<String>* getAssociatedSites() { return m_associatedSites.get(); }
    void setAssociatedSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<String>* getServiceSites() { return m_serviceSites.get(); }
    void setServiceSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class RelatedWebsiteSetBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PrimarySitesSet = 1 << 1,
            AssociatedSitesSet = 1 << 2,
            ServiceSitesSet = 1 << 3,
            AllFieldsSet = (PrimarySitesSet | AssociatedSitesSet | ServiceSitesSet | 0)};


        RelatedWebsiteSetBuilder<STATE | PrimarySitesSet>& setPrimarySites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        RelatedWebsiteSetBuilder<STATE | AssociatedSitesSet>& setAssociatedSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        RelatedWebsiteSetBuilder<STATE | ServiceSitesSet>& setServiceSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<RelatedWebsiteSet> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RelatedWebsiteSet;
        RelatedWebsiteSetBuilder() : m_result(new RelatedWebsiteSet()) { }

        template<int STEP> RelatedWebsiteSetBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RelatedWebsiteSetBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Storage::RelatedWebsiteSet> m_result;
    };

    static RelatedWebsiteSetBuilder<0> create()
    {
        return RelatedWebsiteSetBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RelatedWebsiteSet();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_primarySites;
    std::unique_ptr<protocol::Array<String>> m_associatedSites;
    std::unique_ptr<protocol::Array<String>> m_serviceSites;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline UsageForType::~UsageForType() = default;
inline void UsageForType::setStorageType(const String& value) { m_storageType = value; }
inline void UsageForType::setUsage(double value) { m_usage = value; }

template<int STATE>
inline UsageForType::UsageForTypeBuilder<STATE | UsageForType::UsageForTypeBuilder<STATE>::StorageTypeSet>&
UsageForType::UsageForTypeBuilder<STATE>::setStorageType(const String& value) {
  static_assert(!(STATE & StorageTypeSet), "property storageType should not be set yet");
  m_result->setStorageType(value);
  return castState<StorageTypeSet>();
}
template<int STATE>
inline UsageForType::UsageForTypeBuilder<STATE | UsageForType::UsageForTypeBuilder<STATE>::UsageSet>&
UsageForType::UsageForTypeBuilder<STATE>::setUsage(double value) {
  static_assert(!(STATE & UsageSet), "property usage should not be set yet");
  m_result->setUsage(value);
  return castState<UsageSet>();
}

inline UsageForType::UsageForType() {
  m_usage = 0;
}
inline TrustTokens::~TrustTokens() = default;
inline void TrustTokens::setIssuerOrigin(const String& value) { m_issuerOrigin = value; }
inline void TrustTokens::setCount(double value) { m_count = value; }

template<int STATE>
inline TrustTokens::TrustTokensBuilder<STATE | TrustTokens::TrustTokensBuilder<STATE>::IssuerOriginSet>&
TrustTokens::TrustTokensBuilder<STATE>::setIssuerOrigin(const String& value) {
  static_assert(!(STATE & IssuerOriginSet), "property issuerOrigin should not be set yet");
  m_result->setIssuerOrigin(value);
  return castState<IssuerOriginSet>();
}
template<int STATE>
inline TrustTokens::TrustTokensBuilder<STATE | TrustTokens::TrustTokensBuilder<STATE>::CountSet>&
TrustTokens::TrustTokensBuilder<STATE>::setCount(double value) {
  static_assert(!(STATE & CountSet), "property count should not be set yet");
  m_result->setCount(value);
  return castState<CountSet>();
}

inline TrustTokens::TrustTokens() {
  m_count = 0;
}
inline SharedStorageEntry::~SharedStorageEntry() = default;
inline void SharedStorageEntry::setKey(const String& value) { m_key = value; }
inline void SharedStorageEntry::setValue(const String& value) { m_value = value; }

template<int STATE>
inline SharedStorageEntry::SharedStorageEntryBuilder<STATE | SharedStorageEntry::SharedStorageEntryBuilder<STATE>::KeySet>&
SharedStorageEntry::SharedStorageEntryBuilder<STATE>::setKey(const String& value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline SharedStorageEntry::SharedStorageEntryBuilder<STATE | SharedStorageEntry::SharedStorageEntryBuilder<STATE>::ValueSet>&
SharedStorageEntry::SharedStorageEntryBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}

inline SharedStorageEntry::SharedStorageEntry() {
}
inline SharedStorageMetadata::~SharedStorageMetadata() = default;
inline void SharedStorageMetadata::setCreationTime(double value) { m_creationTime = value; }
inline void SharedStorageMetadata::setLength(int value) { m_length = value; }
inline void SharedStorageMetadata::setRemainingBudget(double value) { m_remainingBudget = value; }
inline void SharedStorageMetadata::setBytesUsed(int value) { m_bytesUsed = value; }

template<int STATE>
inline SharedStorageMetadata::SharedStorageMetadataBuilder<STATE | SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::CreationTimeSet>&
SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::setCreationTime(double value) {
  static_assert(!(STATE & CreationTimeSet), "property creationTime should not be set yet");
  m_result->setCreationTime(value);
  return castState<CreationTimeSet>();
}
template<int STATE>
inline SharedStorageMetadata::SharedStorageMetadataBuilder<STATE | SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::LengthSet>&
SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::setLength(int value) {
  static_assert(!(STATE & LengthSet), "property length should not be set yet");
  m_result->setLength(value);
  return castState<LengthSet>();
}
template<int STATE>
inline SharedStorageMetadata::SharedStorageMetadataBuilder<STATE | SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::RemainingBudgetSet>&
SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::setRemainingBudget(double value) {
  static_assert(!(STATE & RemainingBudgetSet), "property remainingBudget should not be set yet");
  m_result->setRemainingBudget(value);
  return castState<RemainingBudgetSet>();
}
template<int STATE>
inline SharedStorageMetadata::SharedStorageMetadataBuilder<STATE | SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::BytesUsedSet>&
SharedStorageMetadata::SharedStorageMetadataBuilder<STATE>::setBytesUsed(int value) {
  static_assert(!(STATE & BytesUsedSet), "property bytesUsed should not be set yet");
  m_result->setBytesUsed(value);
  return castState<BytesUsedSet>();
}

inline SharedStorageMetadata::SharedStorageMetadata() {
  m_creationTime = 0;
  m_length = 0;
  m_remainingBudget = 0;
  m_bytesUsed = 0;
}
inline SharedStoragePrivateAggregationConfig::~SharedStoragePrivateAggregationConfig() = default;
inline void SharedStoragePrivateAggregationConfig::setAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }
inline void SharedStoragePrivateAggregationConfig::setContextId(const String& value) { m_contextId = value; }
inline void SharedStoragePrivateAggregationConfig::setFilteringIdMaxBytes(int value) { m_filteringIdMaxBytes = value; }
inline void SharedStoragePrivateAggregationConfig::setMaxContributions(int value) { m_maxContributions = value; }

template<int STATE>
inline SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>& SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>::setAggregationCoordinatorOrigin(const String& value) {
  m_result->setAggregationCoordinatorOrigin(value);
  return *this;
}
template<int STATE>
inline SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>& SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>::setContextId(const String& value) {
  m_result->setContextId(value);
  return *this;
}
template<int STATE>
inline SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE | SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>::FilteringIdMaxBytesSet>&
SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>::setFilteringIdMaxBytes(int value) {
  static_assert(!(STATE & FilteringIdMaxBytesSet), "property filteringIdMaxBytes should not be set yet");
  m_result->setFilteringIdMaxBytes(value);
  return castState<FilteringIdMaxBytesSet>();
}
template<int STATE>
inline SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>& SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfigBuilder<STATE>::setMaxContributions(int value) {
  m_result->setMaxContributions(value);
  return *this;
}

inline SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfig() {
  m_filteringIdMaxBytes = 0;
}
inline SharedStorageReportingMetadata::~SharedStorageReportingMetadata() = default;
inline void SharedStorageReportingMetadata::setEventType(const String& value) { m_eventType = value; }
inline void SharedStorageReportingMetadata::setReportingUrl(const String& value) { m_reportingUrl = value; }

template<int STATE>
inline SharedStorageReportingMetadata::SharedStorageReportingMetadataBuilder<STATE | SharedStorageReportingMetadata::SharedStorageReportingMetadataBuilder<STATE>::EventTypeSet>&
SharedStorageReportingMetadata::SharedStorageReportingMetadataBuilder<STATE>::setEventType(const String& value) {
  static_assert(!(STATE & EventTypeSet), "property eventType should not be set yet");
  m_result->setEventType(value);
  return castState<EventTypeSet>();
}
template<int STATE>
inline SharedStorageReportingMetadata::SharedStorageReportingMetadataBuilder<STATE | SharedStorageReportingMetadata::SharedStorageReportingMetadataBuilder<STATE>::ReportingUrlSet>&
SharedStorageReportingMetadata::SharedStorageReportingMetadataBuilder<STATE>::setReportingUrl(const String& value) {
  static_assert(!(STATE & ReportingUrlSet), "property reportingUrl should not be set yet");
  m_result->setReportingUrl(value);
  return castState<ReportingUrlSet>();
}

inline SharedStorageReportingMetadata::SharedStorageReportingMetadata() {
}
inline SharedStorageUrlWithMetadata::~SharedStorageUrlWithMetadata() = default;
inline void SharedStorageUrlWithMetadata::setUrl(const String& value) { m_url = value; }
inline void SharedStorageUrlWithMetadata::setReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value) { m_reportingMetadata = std::move(value); }

template<int STATE>
inline SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadataBuilder<STATE | SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadataBuilder<STATE>::UrlSet>&
SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadataBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadataBuilder<STATE | SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadataBuilder<STATE>::ReportingMetadataSet>&
SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadataBuilder<STATE>::setReportingMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageReportingMetadata>> value) {
  static_assert(!(STATE & ReportingMetadataSet), "property reportingMetadata should not be set yet");
  m_result->setReportingMetadata(std::move(value));
  return castState<ReportingMetadataSet>();
}

inline SharedStorageUrlWithMetadata::SharedStorageUrlWithMetadata() {
}
inline SharedStorageAccessParams::~SharedStorageAccessParams() = default;
inline void SharedStorageAccessParams::setScriptSourceUrl(const String& value) { m_scriptSourceUrl = value; }
inline void SharedStorageAccessParams::setDataOrigin(const String& value) { m_dataOrigin = value; }
inline void SharedStorageAccessParams::setOperationName(const String& value) { m_operationName = value; }
inline void SharedStorageAccessParams::setOperationId(const String& value) { m_operationId = value; }
inline void SharedStorageAccessParams::setKeepAlive(bool value) { m_keepAlive = value; }
inline void SharedStorageAccessParams::setPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value) { m_privateAggregationConfig = std::move(value); }
inline void SharedStorageAccessParams::setSerializedData(const String& value) { m_serializedData = value; }
inline void SharedStorageAccessParams::setUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value) { m_urlsWithMetadata = std::move(value); }
inline void SharedStorageAccessParams::setUrnUuid(const String& value) { m_urnUuid = value; }
inline void SharedStorageAccessParams::setKey(const String& value) { m_key = value; }
inline void SharedStorageAccessParams::setValue(const String& value) { m_value = value; }
inline void SharedStorageAccessParams::setIgnoreIfPresent(bool value) { m_ignoreIfPresent = value; }
inline void SharedStorageAccessParams::setWorkletOrdinal(int value) { m_workletOrdinal = value; }
inline void SharedStorageAccessParams::setWorkletTargetId(const String& value) { m_workletTargetId = value; }
inline void SharedStorageAccessParams::setWithLock(const String& value) { m_withLock = value; }
inline void SharedStorageAccessParams::setBatchUpdateId(const String& value) { m_batchUpdateId = value; }
inline void SharedStorageAccessParams::setBatchSize(int value) { m_batchSize = value; }

template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setScriptSourceUrl(const String& value) {
  m_result->setScriptSourceUrl(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setDataOrigin(const String& value) {
  m_result->setDataOrigin(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setOperationName(const String& value) {
  m_result->setOperationName(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setOperationId(const String& value) {
  m_result->setOperationId(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setKeepAlive(bool value) {
  m_result->setKeepAlive(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setPrivateAggregationConfig(std::unique_ptr<protocol::Storage::SharedStoragePrivateAggregationConfig> value) {
  m_result->setPrivateAggregationConfig(std::move(value));
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setSerializedData(const String& value) {
  m_result->setSerializedData(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setUrlsWithMetadata(std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageUrlWithMetadata>> value) {
  m_result->setUrlsWithMetadata(std::move(value));
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setUrnUuid(const String& value) {
  m_result->setUrnUuid(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setKey(const String& value) {
  m_result->setKey(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setValue(const String& value) {
  m_result->setValue(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setIgnoreIfPresent(bool value) {
  m_result->setIgnoreIfPresent(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setWorkletOrdinal(int value) {
  m_result->setWorkletOrdinal(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setWorkletTargetId(const String& value) {
  m_result->setWorkletTargetId(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setWithLock(const String& value) {
  m_result->setWithLock(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setBatchUpdateId(const String& value) {
  m_result->setBatchUpdateId(value);
  return *this;
}
template<int STATE>
inline SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>& SharedStorageAccessParams::SharedStorageAccessParamsBuilder<STATE>::setBatchSize(int value) {
  m_result->setBatchSize(value);
  return *this;
}

inline SharedStorageAccessParams::SharedStorageAccessParams() {
}
inline StorageBucket::~StorageBucket() = default;
inline void StorageBucket::setStorageKey(const String& value) { m_storageKey = value; }
inline void StorageBucket::setName(const String& value) { m_name = value; }

template<int STATE>
inline StorageBucket::StorageBucketBuilder<STATE | StorageBucket::StorageBucketBuilder<STATE>::StorageKeySet>&
StorageBucket::StorageBucketBuilder<STATE>::setStorageKey(const String& value) {
  static_assert(!(STATE & StorageKeySet), "property storageKey should not be set yet");
  m_result->setStorageKey(value);
  return castState<StorageKeySet>();
}
template<int STATE>
inline StorageBucket::StorageBucketBuilder<STATE>& StorageBucket::StorageBucketBuilder<STATE>::setName(const String& value) {
  m_result->setName(value);
  return *this;
}

inline StorageBucket::StorageBucket() {
}
inline StorageBucketInfo::~StorageBucketInfo() = default;
inline void StorageBucketInfo::setBucket(std::unique_ptr<protocol::Storage::StorageBucket> value) { m_bucket = std::move(value); }
inline void StorageBucketInfo::setId(const String& value) { m_id = value; }
inline void StorageBucketInfo::setExpiration(double value) { m_expiration = value; }
inline void StorageBucketInfo::setQuota(double value) { m_quota = value; }
inline void StorageBucketInfo::setPersistent(bool value) { m_persistent = value; }
inline void StorageBucketInfo::setDurability(const String& value) { m_durability = value; }

template<int STATE>
inline StorageBucketInfo::StorageBucketInfoBuilder<STATE | StorageBucketInfo::StorageBucketInfoBuilder<STATE>::BucketSet>&
StorageBucketInfo::StorageBucketInfoBuilder<STATE>::setBucket(std::unique_ptr<protocol::Storage::StorageBucket> value) {
  static_assert(!(STATE & BucketSet), "property bucket should not be set yet");
  m_result->setBucket(std::move(value));
  return castState<BucketSet>();
}
template<int STATE>
inline StorageBucketInfo::StorageBucketInfoBuilder<STATE | StorageBucketInfo::StorageBucketInfoBuilder<STATE>::IdSet>&
StorageBucketInfo::StorageBucketInfoBuilder<STATE>::setId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline StorageBucketInfo::StorageBucketInfoBuilder<STATE | StorageBucketInfo::StorageBucketInfoBuilder<STATE>::ExpirationSet>&
StorageBucketInfo::StorageBucketInfoBuilder<STATE>::setExpiration(double value) {
  static_assert(!(STATE & ExpirationSet), "property expiration should not be set yet");
  m_result->setExpiration(value);
  return castState<ExpirationSet>();
}
template<int STATE>
inline StorageBucketInfo::StorageBucketInfoBuilder<STATE | StorageBucketInfo::StorageBucketInfoBuilder<STATE>::QuotaSet>&
StorageBucketInfo::StorageBucketInfoBuilder<STATE>::setQuota(double value) {
  static_assert(!(STATE & QuotaSet), "property quota should not be set yet");
  m_result->setQuota(value);
  return castState<QuotaSet>();
}
template<int STATE>
inline StorageBucketInfo::StorageBucketInfoBuilder<STATE | StorageBucketInfo::StorageBucketInfoBuilder<STATE>::PersistentSet>&
StorageBucketInfo::StorageBucketInfoBuilder<STATE>::setPersistent(bool value) {
  static_assert(!(STATE & PersistentSet), "property persistent should not be set yet");
  m_result->setPersistent(value);
  return castState<PersistentSet>();
}
template<int STATE>
inline StorageBucketInfo::StorageBucketInfoBuilder<STATE | StorageBucketInfo::StorageBucketInfoBuilder<STATE>::DurabilitySet>&
StorageBucketInfo::StorageBucketInfoBuilder<STATE>::setDurability(const String& value) {
  static_assert(!(STATE & DurabilitySet), "property durability should not be set yet");
  m_result->setDurability(value);
  return castState<DurabilitySet>();
}

inline StorageBucketInfo::StorageBucketInfo() {
  m_expiration = 0;
  m_quota = 0;
  m_persistent = false;
}
inline AttributionReportingFilterDataEntry::~AttributionReportingFilterDataEntry() = default;
inline void AttributionReportingFilterDataEntry::setKey(const String& value) { m_key = value; }
inline void AttributionReportingFilterDataEntry::setValues(std::unique_ptr<protocol::Array<String>> value) { m_values = std::move(value); }

template<int STATE>
inline AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntryBuilder<STATE | AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntryBuilder<STATE>::KeySet>&
AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntryBuilder<STATE>::setKey(const String& value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntryBuilder<STATE | AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntryBuilder<STATE>::ValuesSet>&
AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntryBuilder<STATE>::setValues(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & ValuesSet), "property values should not be set yet");
  m_result->setValues(std::move(value));
  return castState<ValuesSet>();
}

inline AttributionReportingFilterDataEntry::AttributionReportingFilterDataEntry() {
}
inline AttributionReportingFilterConfig::~AttributionReportingFilterConfig() = default;
inline void AttributionReportingFilterConfig::setFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) { m_filterValues = std::move(value); }
inline void AttributionReportingFilterConfig::setLookbackWindow(int value) { m_lookbackWindow = value; }

template<int STATE>
inline AttributionReportingFilterConfig::AttributionReportingFilterConfigBuilder<STATE | AttributionReportingFilterConfig::AttributionReportingFilterConfigBuilder<STATE>::FilterValuesSet>&
AttributionReportingFilterConfig::AttributionReportingFilterConfigBuilder<STATE>::setFilterValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) {
  static_assert(!(STATE & FilterValuesSet), "property filterValues should not be set yet");
  m_result->setFilterValues(std::move(value));
  return castState<FilterValuesSet>();
}
template<int STATE>
inline AttributionReportingFilterConfig::AttributionReportingFilterConfigBuilder<STATE>& AttributionReportingFilterConfig::AttributionReportingFilterConfigBuilder<STATE>::setLookbackWindow(int value) {
  m_result->setLookbackWindow(value);
  return *this;
}

inline AttributionReportingFilterConfig::AttributionReportingFilterConfig() {
}
inline AttributionReportingFilterPair::~AttributionReportingFilterPair() = default;
inline void AttributionReportingFilterPair::setFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) { m_filters = std::move(value); }
inline void AttributionReportingFilterPair::setNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) { m_notFilters = std::move(value); }

template<int STATE>
inline AttributionReportingFilterPair::AttributionReportingFilterPairBuilder<STATE | AttributionReportingFilterPair::AttributionReportingFilterPairBuilder<STATE>::FiltersSet>&
AttributionReportingFilterPair::AttributionReportingFilterPairBuilder<STATE>::setFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}
template<int STATE>
inline AttributionReportingFilterPair::AttributionReportingFilterPairBuilder<STATE | AttributionReportingFilterPair::AttributionReportingFilterPairBuilder<STATE>::NotFiltersSet>&
AttributionReportingFilterPair::AttributionReportingFilterPairBuilder<STATE>::setNotFilters(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterConfig>> value) {
  static_assert(!(STATE & NotFiltersSet), "property notFilters should not be set yet");
  m_result->setNotFilters(std::move(value));
  return castState<NotFiltersSet>();
}

inline AttributionReportingFilterPair::AttributionReportingFilterPair() {
}
inline AttributionReportingAggregationKeysEntry::~AttributionReportingAggregationKeysEntry() = default;
inline void AttributionReportingAggregationKeysEntry::setKey(const String& value) { m_key = value; }
inline void AttributionReportingAggregationKeysEntry::setValue(const String& value) { m_value = value; }

template<int STATE>
inline AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntryBuilder<STATE | AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntryBuilder<STATE>::KeySet>&
AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntryBuilder<STATE>::setKey(const String& value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntryBuilder<STATE | AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntryBuilder<STATE>::ValueSet>&
AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntryBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}

inline AttributionReportingAggregationKeysEntry::AttributionReportingAggregationKeysEntry() {
}
inline AttributionReportingEventReportWindows::~AttributionReportingEventReportWindows() = default;
inline void AttributionReportingEventReportWindows::setStart(int value) { m_start = value; }
inline void AttributionReportingEventReportWindows::setEnds(std::unique_ptr<protocol::Array<int>> value) { m_ends = std::move(value); }

template<int STATE>
inline AttributionReportingEventReportWindows::AttributionReportingEventReportWindowsBuilder<STATE | AttributionReportingEventReportWindows::AttributionReportingEventReportWindowsBuilder<STATE>::StartSet>&
AttributionReportingEventReportWindows::AttributionReportingEventReportWindowsBuilder<STATE>::setStart(int value) {
  static_assert(!(STATE & StartSet), "property start should not be set yet");
  m_result->setStart(value);
  return castState<StartSet>();
}
template<int STATE>
inline AttributionReportingEventReportWindows::AttributionReportingEventReportWindowsBuilder<STATE | AttributionReportingEventReportWindows::AttributionReportingEventReportWindowsBuilder<STATE>::EndsSet>&
AttributionReportingEventReportWindows::AttributionReportingEventReportWindowsBuilder<STATE>::setEnds(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & EndsSet), "property ends should not be set yet");
  m_result->setEnds(std::move(value));
  return castState<EndsSet>();
}

inline AttributionReportingEventReportWindows::AttributionReportingEventReportWindows() {
  m_start = 0;
}
inline AttributionReportingAggregatableDebugReportingData::~AttributionReportingAggregatableDebugReportingData() = default;
inline void AttributionReportingAggregatableDebugReportingData::setKeyPiece(const String& value) { m_keyPiece = value; }
inline void AttributionReportingAggregatableDebugReportingData::setValue(double value) { m_value = value; }
inline void AttributionReportingAggregatableDebugReportingData::setTypes(std::unique_ptr<protocol::Array<String>> value) { m_types = std::move(value); }

template<int STATE>
inline AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE | AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE>::KeyPieceSet>&
AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE>::setKeyPiece(const String& value) {
  static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
  m_result->setKeyPiece(value);
  return castState<KeyPieceSet>();
}
template<int STATE>
inline AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE | AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE>::ValueSet>&
AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE>::setValue(double value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}
template<int STATE>
inline AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE | AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE>::TypesSet>&
AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingDataBuilder<STATE>::setTypes(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & TypesSet), "property types should not be set yet");
  m_result->setTypes(std::move(value));
  return castState<TypesSet>();
}

inline AttributionReportingAggregatableDebugReportingData::AttributionReportingAggregatableDebugReportingData() {
  m_value = 0;
}
inline AttributionReportingAggregatableDebugReportingConfig::~AttributionReportingAggregatableDebugReportingConfig() = default;
inline void AttributionReportingAggregatableDebugReportingConfig::setBudget(double value) { m_budget = value; }
inline void AttributionReportingAggregatableDebugReportingConfig::setKeyPiece(const String& value) { m_keyPiece = value; }
inline void AttributionReportingAggregatableDebugReportingConfig::setDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value) { m_debugData = std::move(value); }
inline void AttributionReportingAggregatableDebugReportingConfig::setAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }

template<int STATE>
inline AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>::setBudget(double value) {
  m_result->setBudget(value);
  return *this;
}
template<int STATE>
inline AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>::KeyPieceSet>&
AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>::setKeyPiece(const String& value) {
  static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
  m_result->setKeyPiece(value);
  return castState<KeyPieceSet>();
}
template<int STATE>
inline AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE | AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>::DebugDataSet>&
AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>::setDebugData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDebugReportingData>> value) {
  static_assert(!(STATE & DebugDataSet), "property debugData should not be set yet");
  m_result->setDebugData(std::move(value));
  return castState<DebugDataSet>();
}
template<int STATE>
inline AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>& AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfigBuilder<STATE>::setAggregationCoordinatorOrigin(const String& value) {
  m_result->setAggregationCoordinatorOrigin(value);
  return *this;
}

inline AttributionReportingAggregatableDebugReportingConfig::AttributionReportingAggregatableDebugReportingConfig() {
}
inline AttributionScopesData::~AttributionScopesData() = default;
inline void AttributionScopesData::setValues(std::unique_ptr<protocol::Array<String>> value) { m_values = std::move(value); }
inline void AttributionScopesData::setLimit(double value) { m_limit = value; }
inline void AttributionScopesData::setMaxEventStates(double value) { m_maxEventStates = value; }

template<int STATE>
inline AttributionScopesData::AttributionScopesDataBuilder<STATE | AttributionScopesData::AttributionScopesDataBuilder<STATE>::ValuesSet>&
AttributionScopesData::AttributionScopesDataBuilder<STATE>::setValues(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & ValuesSet), "property values should not be set yet");
  m_result->setValues(std::move(value));
  return castState<ValuesSet>();
}
template<int STATE>
inline AttributionScopesData::AttributionScopesDataBuilder<STATE | AttributionScopesData::AttributionScopesDataBuilder<STATE>::LimitSet>&
AttributionScopesData::AttributionScopesDataBuilder<STATE>::setLimit(double value) {
  static_assert(!(STATE & LimitSet), "property limit should not be set yet");
  m_result->setLimit(value);
  return castState<LimitSet>();
}
template<int STATE>
inline AttributionScopesData::AttributionScopesDataBuilder<STATE | AttributionScopesData::AttributionScopesDataBuilder<STATE>::MaxEventStatesSet>&
AttributionScopesData::AttributionScopesDataBuilder<STATE>::setMaxEventStates(double value) {
  static_assert(!(STATE & MaxEventStatesSet), "property maxEventStates should not be set yet");
  m_result->setMaxEventStates(value);
  return castState<MaxEventStatesSet>();
}

inline AttributionScopesData::AttributionScopesData() {
  m_limit = 0;
  m_maxEventStates = 0;
}
inline AttributionReportingNamedBudgetDef::~AttributionReportingNamedBudgetDef() = default;
inline void AttributionReportingNamedBudgetDef::setName(const String& value) { m_name = value; }
inline void AttributionReportingNamedBudgetDef::setBudget(int value) { m_budget = value; }

template<int STATE>
inline AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDefBuilder<STATE | AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDefBuilder<STATE>::NameSet>&
AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDefBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDefBuilder<STATE | AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDefBuilder<STATE>::BudgetSet>&
AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDefBuilder<STATE>::setBudget(int value) {
  static_assert(!(STATE & BudgetSet), "property budget should not be set yet");
  m_result->setBudget(value);
  return castState<BudgetSet>();
}

inline AttributionReportingNamedBudgetDef::AttributionReportingNamedBudgetDef() {
  m_budget = 0;
}
inline AttributionReportingSourceRegistration::~AttributionReportingSourceRegistration() = default;
inline void AttributionReportingSourceRegistration::setTime(double value) { m_time = value; }
inline void AttributionReportingSourceRegistration::setExpiry(int value) { m_expiry = value; }
inline void AttributionReportingSourceRegistration::setTriggerData(std::unique_ptr<protocol::Array<double>> value) { m_triggerData = std::move(value); }
inline void AttributionReportingSourceRegistration::setEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value) { m_eventReportWindows = std::move(value); }
inline void AttributionReportingSourceRegistration::setAggregatableReportWindow(int value) { m_aggregatableReportWindow = value; }
inline void AttributionReportingSourceRegistration::setType(const String& value) { m_type = value; }
inline void AttributionReportingSourceRegistration::setSourceOrigin(const String& value) { m_sourceOrigin = value; }
inline void AttributionReportingSourceRegistration::setReportingOrigin(const String& value) { m_reportingOrigin = value; }
inline void AttributionReportingSourceRegistration::setDestinationSites(std::unique_ptr<protocol::Array<String>> value) { m_destinationSites = std::move(value); }
inline void AttributionReportingSourceRegistration::setEventId(const String& value) { m_eventId = value; }
inline void AttributionReportingSourceRegistration::setPriority(const String& value) { m_priority = value; }
inline void AttributionReportingSourceRegistration::setFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) { m_filterData = std::move(value); }
inline void AttributionReportingSourceRegistration::setAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value) { m_aggregationKeys = std::move(value); }
inline void AttributionReportingSourceRegistration::setDebugKey(const String& value) { m_debugKey = value; }
inline void AttributionReportingSourceRegistration::setTriggerDataMatching(const String& value) { m_triggerDataMatching = value; }
inline void AttributionReportingSourceRegistration::setDestinationLimitPriority(const String& value) { m_destinationLimitPriority = value; }
inline void AttributionReportingSourceRegistration::setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) { m_aggregatableDebugReportingConfig = std::move(value); }
inline void AttributionReportingSourceRegistration::setScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value) { m_scopesData = std::move(value); }
inline void AttributionReportingSourceRegistration::setMaxEventLevelReports(int value) { m_maxEventLevelReports = value; }
inline void AttributionReportingSourceRegistration::setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value) { m_namedBudgets = std::move(value); }
inline void AttributionReportingSourceRegistration::setDebugReporting(bool value) { m_debugReporting = value; }
inline void AttributionReportingSourceRegistration::setEventLevelEpsilon(double value) { m_eventLevelEpsilon = value; }

template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::TimeSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setTime(double value) {
  static_assert(!(STATE & TimeSet), "property time should not be set yet");
  m_result->setTime(value);
  return castState<TimeSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::ExpirySet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setExpiry(int value) {
  static_assert(!(STATE & ExpirySet), "property expiry should not be set yet");
  m_result->setExpiry(value);
  return castState<ExpirySet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::TriggerDataSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setTriggerData(std::unique_ptr<protocol::Array<double>> value) {
  static_assert(!(STATE & TriggerDataSet), "property triggerData should not be set yet");
  m_result->setTriggerData(std::move(value));
  return castState<TriggerDataSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::EventReportWindowsSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setEventReportWindows(std::unique_ptr<protocol::Storage::AttributionReportingEventReportWindows> value) {
  static_assert(!(STATE & EventReportWindowsSet), "property eventReportWindows should not be set yet");
  m_result->setEventReportWindows(std::move(value));
  return castState<EventReportWindowsSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::AggregatableReportWindowSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setAggregatableReportWindow(int value) {
  static_assert(!(STATE & AggregatableReportWindowSet), "property aggregatableReportWindow should not be set yet");
  m_result->setAggregatableReportWindow(value);
  return castState<AggregatableReportWindowSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::TypeSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::SourceOriginSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setSourceOrigin(const String& value) {
  static_assert(!(STATE & SourceOriginSet), "property sourceOrigin should not be set yet");
  m_result->setSourceOrigin(value);
  return castState<SourceOriginSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::ReportingOriginSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setReportingOrigin(const String& value) {
  static_assert(!(STATE & ReportingOriginSet), "property reportingOrigin should not be set yet");
  m_result->setReportingOrigin(value);
  return castState<ReportingOriginSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::DestinationSitesSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setDestinationSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & DestinationSitesSet), "property destinationSites should not be set yet");
  m_result->setDestinationSites(std::move(value));
  return castState<DestinationSitesSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::EventIdSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setEventId(const String& value) {
  static_assert(!(STATE & EventIdSet), "property eventId should not be set yet");
  m_result->setEventId(value);
  return castState<EventIdSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::PrioritySet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setPriority(const String& value) {
  static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
  m_result->setPriority(value);
  return castState<PrioritySet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::FilterDataSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setFilterData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingFilterDataEntry>> value) {
  static_assert(!(STATE & FilterDataSet), "property filterData should not be set yet");
  m_result->setFilterData(std::move(value));
  return castState<FilterDataSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::AggregationKeysSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setAggregationKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregationKeysEntry>> value) {
  static_assert(!(STATE & AggregationKeysSet), "property aggregationKeys should not be set yet");
  m_result->setAggregationKeys(std::move(value));
  return castState<AggregationKeysSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>& AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setDebugKey(const String& value) {
  m_result->setDebugKey(value);
  return *this;
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::TriggerDataMatchingSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setTriggerDataMatching(const String& value) {
  static_assert(!(STATE & TriggerDataMatchingSet), "property triggerDataMatching should not be set yet");
  m_result->setTriggerDataMatching(value);
  return castState<TriggerDataMatchingSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::DestinationLimitPrioritySet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setDestinationLimitPriority(const String& value) {
  static_assert(!(STATE & DestinationLimitPrioritySet), "property destinationLimitPriority should not be set yet");
  m_result->setDestinationLimitPriority(value);
  return castState<DestinationLimitPrioritySet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::AggregatableDebugReportingConfigSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) {
  static_assert(!(STATE & AggregatableDebugReportingConfigSet), "property aggregatableDebugReportingConfig should not be set yet");
  m_result->setAggregatableDebugReportingConfig(std::move(value));
  return castState<AggregatableDebugReportingConfigSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>& AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setScopesData(std::unique_ptr<protocol::Storage::AttributionScopesData> value) {
  m_result->setScopesData(std::move(value));
  return *this;
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::MaxEventLevelReportsSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setMaxEventLevelReports(int value) {
  static_assert(!(STATE & MaxEventLevelReportsSet), "property maxEventLevelReports should not be set yet");
  m_result->setMaxEventLevelReports(value);
  return castState<MaxEventLevelReportsSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::NamedBudgetsSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetDef>> value) {
  static_assert(!(STATE & NamedBudgetsSet), "property namedBudgets should not be set yet");
  m_result->setNamedBudgets(std::move(value));
  return castState<NamedBudgetsSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::DebugReportingSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setDebugReporting(bool value) {
  static_assert(!(STATE & DebugReportingSet), "property debugReporting should not be set yet");
  m_result->setDebugReporting(value);
  return castState<DebugReportingSet>();
}
template<int STATE>
inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE | AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::EventLevelEpsilonSet>&
AttributionReportingSourceRegistration::AttributionReportingSourceRegistrationBuilder<STATE>::setEventLevelEpsilon(double value) {
  static_assert(!(STATE & EventLevelEpsilonSet), "property eventLevelEpsilon should not be set yet");
  m_result->setEventLevelEpsilon(value);
  return castState<EventLevelEpsilonSet>();
}

inline AttributionReportingSourceRegistration::AttributionReportingSourceRegistration() {
  m_time = 0;
  m_expiry = 0;
  m_aggregatableReportWindow = 0;
  m_maxEventLevelReports = 0;
  m_debugReporting = false;
  m_eventLevelEpsilon = 0;
}
inline AttributionReportingAggregatableValueDictEntry::~AttributionReportingAggregatableValueDictEntry() = default;
inline void AttributionReportingAggregatableValueDictEntry::setKey(const String& value) { m_key = value; }
inline void AttributionReportingAggregatableValueDictEntry::setValue(double value) { m_value = value; }
inline void AttributionReportingAggregatableValueDictEntry::setFilteringId(const String& value) { m_filteringId = value; }

template<int STATE>
inline AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE | AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE>::KeySet>&
AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE>::setKey(const String& value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(value);
  return castState<KeySet>();
}
template<int STATE>
inline AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE | AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE>::ValueSet>&
AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE>::setValue(double value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}
template<int STATE>
inline AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE | AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE>::FilteringIdSet>&
AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntryBuilder<STATE>::setFilteringId(const String& value) {
  static_assert(!(STATE & FilteringIdSet), "property filteringId should not be set yet");
  m_result->setFilteringId(value);
  return castState<FilteringIdSet>();
}

inline AttributionReportingAggregatableValueDictEntry::AttributionReportingAggregatableValueDictEntry() {
  m_value = 0;
}
inline AttributionReportingAggregatableValueEntry::~AttributionReportingAggregatableValueEntry() = default;
inline void AttributionReportingAggregatableValueEntry::setValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value) { m_values = std::move(value); }
inline void AttributionReportingAggregatableValueEntry::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

template<int STATE>
inline AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntryBuilder<STATE | AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntryBuilder<STATE>::ValuesSet>&
AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntryBuilder<STATE>::setValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueDictEntry>> value) {
  static_assert(!(STATE & ValuesSet), "property values should not be set yet");
  m_result->setValues(std::move(value));
  return castState<ValuesSet>();
}
template<int STATE>
inline AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntryBuilder<STATE | AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntryBuilder<STATE>::FiltersSet>&
AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntryBuilder<STATE>::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}

inline AttributionReportingAggregatableValueEntry::AttributionReportingAggregatableValueEntry() {
}
inline AttributionReportingEventTriggerData::~AttributionReportingEventTriggerData() = default;
inline void AttributionReportingEventTriggerData::setData(const String& value) { m_data = value; }
inline void AttributionReportingEventTriggerData::setPriority(const String& value) { m_priority = value; }
inline void AttributionReportingEventTriggerData::setDedupKey(const String& value) { m_dedupKey = value; }
inline void AttributionReportingEventTriggerData::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

template<int STATE>
inline AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE | AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::DataSet>&
AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::setData(const String& value) {
  static_assert(!(STATE & DataSet), "property data should not be set yet");
  m_result->setData(value);
  return castState<DataSet>();
}
template<int STATE>
inline AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE | AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::PrioritySet>&
AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::setPriority(const String& value) {
  static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
  m_result->setPriority(value);
  return castState<PrioritySet>();
}
template<int STATE>
inline AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>& AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::setDedupKey(const String& value) {
  m_result->setDedupKey(value);
  return *this;
}
template<int STATE>
inline AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE | AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::FiltersSet>&
AttributionReportingEventTriggerData::AttributionReportingEventTriggerDataBuilder<STATE>::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}

inline AttributionReportingEventTriggerData::AttributionReportingEventTriggerData() {
}
inline AttributionReportingAggregatableTriggerData::~AttributionReportingAggregatableTriggerData() = default;
inline void AttributionReportingAggregatableTriggerData::setKeyPiece(const String& value) { m_keyPiece = value; }
inline void AttributionReportingAggregatableTriggerData::setSourceKeys(std::unique_ptr<protocol::Array<String>> value) { m_sourceKeys = std::move(value); }
inline void AttributionReportingAggregatableTriggerData::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

template<int STATE>
inline AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE | AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE>::KeyPieceSet>&
AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE>::setKeyPiece(const String& value) {
  static_assert(!(STATE & KeyPieceSet), "property keyPiece should not be set yet");
  m_result->setKeyPiece(value);
  return castState<KeyPieceSet>();
}
template<int STATE>
inline AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE | AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE>::SourceKeysSet>&
AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE>::setSourceKeys(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & SourceKeysSet), "property sourceKeys should not be set yet");
  m_result->setSourceKeys(std::move(value));
  return castState<SourceKeysSet>();
}
template<int STATE>
inline AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE | AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE>::FiltersSet>&
AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerDataBuilder<STATE>::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}

inline AttributionReportingAggregatableTriggerData::AttributionReportingAggregatableTriggerData() {
}
inline AttributionReportingAggregatableDedupKey::~AttributionReportingAggregatableDedupKey() = default;
inline void AttributionReportingAggregatableDedupKey::setDedupKey(const String& value) { m_dedupKey = value; }
inline void AttributionReportingAggregatableDedupKey::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

template<int STATE>
inline AttributionReportingAggregatableDedupKey::AttributionReportingAggregatableDedupKeyBuilder<STATE>& AttributionReportingAggregatableDedupKey::AttributionReportingAggregatableDedupKeyBuilder<STATE>::setDedupKey(const String& value) {
  m_result->setDedupKey(value);
  return *this;
}
template<int STATE>
inline AttributionReportingAggregatableDedupKey::AttributionReportingAggregatableDedupKeyBuilder<STATE | AttributionReportingAggregatableDedupKey::AttributionReportingAggregatableDedupKeyBuilder<STATE>::FiltersSet>&
AttributionReportingAggregatableDedupKey::AttributionReportingAggregatableDedupKeyBuilder<STATE>::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}

inline AttributionReportingAggregatableDedupKey::AttributionReportingAggregatableDedupKey() {
}
inline AttributionReportingNamedBudgetCandidate::~AttributionReportingNamedBudgetCandidate() = default;
inline void AttributionReportingNamedBudgetCandidate::setName(const String& value) { m_name = value; }
inline void AttributionReportingNamedBudgetCandidate::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }

template<int STATE>
inline AttributionReportingNamedBudgetCandidate::AttributionReportingNamedBudgetCandidateBuilder<STATE>& AttributionReportingNamedBudgetCandidate::AttributionReportingNamedBudgetCandidateBuilder<STATE>::setName(const String& value) {
  m_result->setName(value);
  return *this;
}
template<int STATE>
inline AttributionReportingNamedBudgetCandidate::AttributionReportingNamedBudgetCandidateBuilder<STATE | AttributionReportingNamedBudgetCandidate::AttributionReportingNamedBudgetCandidateBuilder<STATE>::FiltersSet>&
AttributionReportingNamedBudgetCandidate::AttributionReportingNamedBudgetCandidateBuilder<STATE>::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}

inline AttributionReportingNamedBudgetCandidate::AttributionReportingNamedBudgetCandidate() {
}
inline AttributionReportingTriggerRegistration::~AttributionReportingTriggerRegistration() = default;
inline void AttributionReportingTriggerRegistration::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) { m_filters = std::move(value); }
inline void AttributionReportingTriggerRegistration::setDebugKey(const String& value) { m_debugKey = value; }
inline void AttributionReportingTriggerRegistration::setAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value) { m_aggregatableDedupKeys = std::move(value); }
inline void AttributionReportingTriggerRegistration::setEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value) { m_eventTriggerData = std::move(value); }
inline void AttributionReportingTriggerRegistration::setAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value) { m_aggregatableTriggerData = std::move(value); }
inline void AttributionReportingTriggerRegistration::setAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value) { m_aggregatableValues = std::move(value); }
inline void AttributionReportingTriggerRegistration::setAggregatableFilteringIdMaxBytes(int value) { m_aggregatableFilteringIdMaxBytes = value; }
inline void AttributionReportingTriggerRegistration::setDebugReporting(bool value) { m_debugReporting = value; }
inline void AttributionReportingTriggerRegistration::setAggregationCoordinatorOrigin(const String& value) { m_aggregationCoordinatorOrigin = value; }
inline void AttributionReportingTriggerRegistration::setSourceRegistrationTimeConfig(const String& value) { m_sourceRegistrationTimeConfig = value; }
inline void AttributionReportingTriggerRegistration::setTriggerContextId(const String& value) { m_triggerContextId = value; }
inline void AttributionReportingTriggerRegistration::setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) { m_aggregatableDebugReportingConfig = std::move(value); }
inline void AttributionReportingTriggerRegistration::setScopes(std::unique_ptr<protocol::Array<String>> value) { m_scopes = std::move(value); }
inline void AttributionReportingTriggerRegistration::setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value) { m_namedBudgets = std::move(value); }

template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::FiltersSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setFilters(std::unique_ptr<protocol::Storage::AttributionReportingFilterPair> value) {
  static_assert(!(STATE & FiltersSet), "property filters should not be set yet");
  m_result->setFilters(std::move(value));
  return castState<FiltersSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>& AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setDebugKey(const String& value) {
  m_result->setDebugKey(value);
  return *this;
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::AggregatableDedupKeysSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setAggregatableDedupKeys(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableDedupKey>> value) {
  static_assert(!(STATE & AggregatableDedupKeysSet), "property aggregatableDedupKeys should not be set yet");
  m_result->setAggregatableDedupKeys(std::move(value));
  return castState<AggregatableDedupKeysSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::EventTriggerDataSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setEventTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingEventTriggerData>> value) {
  static_assert(!(STATE & EventTriggerDataSet), "property eventTriggerData should not be set yet");
  m_result->setEventTriggerData(std::move(value));
  return castState<EventTriggerDataSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::AggregatableTriggerDataSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setAggregatableTriggerData(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableTriggerData>> value) {
  static_assert(!(STATE & AggregatableTriggerDataSet), "property aggregatableTriggerData should not be set yet");
  m_result->setAggregatableTriggerData(std::move(value));
  return castState<AggregatableTriggerDataSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::AggregatableValuesSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setAggregatableValues(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingAggregatableValueEntry>> value) {
  static_assert(!(STATE & AggregatableValuesSet), "property aggregatableValues should not be set yet");
  m_result->setAggregatableValues(std::move(value));
  return castState<AggregatableValuesSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::AggregatableFilteringIdMaxBytesSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setAggregatableFilteringIdMaxBytes(int value) {
  static_assert(!(STATE & AggregatableFilteringIdMaxBytesSet), "property aggregatableFilteringIdMaxBytes should not be set yet");
  m_result->setAggregatableFilteringIdMaxBytes(value);
  return castState<AggregatableFilteringIdMaxBytesSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::DebugReportingSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setDebugReporting(bool value) {
  static_assert(!(STATE & DebugReportingSet), "property debugReporting should not be set yet");
  m_result->setDebugReporting(value);
  return castState<DebugReportingSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>& AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setAggregationCoordinatorOrigin(const String& value) {
  m_result->setAggregationCoordinatorOrigin(value);
  return *this;
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::SourceRegistrationTimeConfigSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setSourceRegistrationTimeConfig(const String& value) {
  static_assert(!(STATE & SourceRegistrationTimeConfigSet), "property sourceRegistrationTimeConfig should not be set yet");
  m_result->setSourceRegistrationTimeConfig(value);
  return castState<SourceRegistrationTimeConfigSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>& AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setTriggerContextId(const String& value) {
  m_result->setTriggerContextId(value);
  return *this;
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::AggregatableDebugReportingConfigSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setAggregatableDebugReportingConfig(std::unique_ptr<protocol::Storage::AttributionReportingAggregatableDebugReportingConfig> value) {
  static_assert(!(STATE & AggregatableDebugReportingConfigSet), "property aggregatableDebugReportingConfig should not be set yet");
  m_result->setAggregatableDebugReportingConfig(std::move(value));
  return castState<AggregatableDebugReportingConfigSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::ScopesSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setScopes(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & ScopesSet), "property scopes should not be set yet");
  m_result->setScopes(std::move(value));
  return castState<ScopesSet>();
}
template<int STATE>
inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE | AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::NamedBudgetsSet>&
AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistrationBuilder<STATE>::setNamedBudgets(std::unique_ptr<protocol::Array<protocol::Storage::AttributionReportingNamedBudgetCandidate>> value) {
  static_assert(!(STATE & NamedBudgetsSet), "property namedBudgets should not be set yet");
  m_result->setNamedBudgets(std::move(value));
  return castState<NamedBudgetsSet>();
}

inline AttributionReportingTriggerRegistration::AttributionReportingTriggerRegistration() {
  m_aggregatableFilteringIdMaxBytes = 0;
  m_debugReporting = false;
}
inline RelatedWebsiteSet::~RelatedWebsiteSet() = default;
inline void RelatedWebsiteSet::setPrimarySites(std::unique_ptr<protocol::Array<String>> value) { m_primarySites = std::move(value); }
inline void RelatedWebsiteSet::setAssociatedSites(std::unique_ptr<protocol::Array<String>> value) { m_associatedSites = std::move(value); }
inline void RelatedWebsiteSet::setServiceSites(std::unique_ptr<protocol::Array<String>> value) { m_serviceSites = std::move(value); }

template<int STATE>
inline RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE | RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE>::PrimarySitesSet>&
RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE>::setPrimarySites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & PrimarySitesSet), "property primarySites should not be set yet");
  m_result->setPrimarySites(std::move(value));
  return castState<PrimarySitesSet>();
}
template<int STATE>
inline RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE | RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE>::AssociatedSitesSet>&
RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE>::setAssociatedSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & AssociatedSitesSet), "property associatedSites should not be set yet");
  m_result->setAssociatedSites(std::move(value));
  return castState<AssociatedSitesSet>();
}
template<int STATE>
inline RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE | RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE>::ServiceSitesSet>&
RelatedWebsiteSet::RelatedWebsiteSetBuilder<STATE>::setServiceSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & ServiceSitesSet), "property serviceSites should not be set yet");
  m_result->setServiceSites(std::move(value));
  return castState<ServiceSitesSet>();
}

inline RelatedWebsiteSet::RelatedWebsiteSet() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getStorageKeyForFrame(const String& in_frameId, String* out_storageKey) = 0;
    virtual DispatchResponse getStorageKey(std::optional<String> in_frameId, String* out_storageKey) = 0;
    virtual DispatchResponse clearDataForOrigin(const String& in_origin, const String& in_storageTypes) = 0;
    virtual DispatchResponse clearDataForStorageKey(const String& in_storageKey, const String& in_storageTypes) = 0;
    virtual DispatchResponse getCookies(std::optional<String> in_browserContextId, std::unique_ptr<protocol::Array<protocol::Network::Cookie>>* out_cookies) = 0;
    virtual DispatchResponse setCookies(std::unique_ptr<protocol::Array<protocol::Network::CookieParam>> in_cookies, std::optional<String> in_browserContextId) = 0;
    virtual DispatchResponse clearCookies(std::optional<String> in_browserContextId) = 0;
    virtual DispatchResponse getUsageAndQuota(const String& in_origin, double* out_usage, double* out_quota, bool* out_overrideActive, std::unique_ptr<protocol::Array<protocol::Storage::UsageForType>>* out_usageBreakdown) = 0;
    virtual DispatchResponse overrideQuotaForOrigin(const String& in_origin, std::optional<double> in_quotaSize) = 0;
    virtual DispatchResponse trackCacheStorageForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse trackCacheStorageForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse trackIndexedDBForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse trackIndexedDBForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse untrackCacheStorageForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse untrackCacheStorageForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse untrackIndexedDBForOrigin(const String& in_origin) = 0;
    virtual DispatchResponse untrackIndexedDBForStorageKey(const String& in_storageKey) = 0;
    virtual DispatchResponse getTrustTokens(std::unique_ptr<protocol::Array<protocol::Storage::TrustTokens>>* out_tokens) = 0;
    virtual DispatchResponse clearTrustTokens(const String& in_issuerOrigin, bool* out_didDeleteTokens) = 0;
    virtual DispatchResponse getInterestGroupDetails(const String& in_ownerOrigin, const String& in_name, std::unique_ptr<protocol::DictionaryValue>* out_details) = 0;
    virtual DispatchResponse setInterestGroupTracking(bool in_enable) = 0;
    virtual DispatchResponse setInterestGroupAuctionTracking(bool in_enable) = 0;
    virtual DispatchResponse getSharedStorageMetadata(const String& in_ownerOrigin, std::unique_ptr<protocol::Storage::SharedStorageMetadata>* out_metadata) = 0;
    virtual DispatchResponse getSharedStorageEntries(const String& in_ownerOrigin, std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageEntry>>* out_entries) = 0;
    virtual DispatchResponse setSharedStorageEntry(const String& in_ownerOrigin, const String& in_key, const String& in_value, std::optional<bool> in_ignoreIfPresent) = 0;
    virtual DispatchResponse deleteSharedStorageEntry(const String& in_ownerOrigin, const String& in_key) = 0;
    virtual DispatchResponse clearSharedStorageEntries(const String& in_ownerOrigin) = 0;
    virtual DispatchResponse resetSharedStorageBudget(const String& in_ownerOrigin) = 0;
    virtual DispatchResponse setSharedStorageTracking(bool in_enable) = 0;
    virtual DispatchResponse setStorageBucketTracking(const String& in_storageKey, bool in_enable) = 0;
    virtual DispatchResponse deleteStorageBucket(std::unique_ptr<protocol::Storage::StorageBucket> in_bucket) = 0;
    virtual DispatchResponse runBounceTrackingMitigations(std::unique_ptr<protocol::Array<String>>* out_deletedSites) = 0;
    virtual DispatchResponse setAttributionReportingLocalTestingMode(bool in_enabled) = 0;
    virtual DispatchResponse setAttributionReportingTracking(bool in_enable) = 0;
    virtual DispatchResponse sendPendingAttributionReports(int* out_numSent) = 0;
    virtual DispatchResponse getRelatedWebsiteSets(std::unique_ptr<protocol::Array<protocol::Storage::RelatedWebsiteSet>>* out_sets) = 0;
    virtual DispatchResponse getAffectedUrlsForThirdPartyCookieMetadata(const String& in_firstPartyUrl, std::unique_ptr<protocol::Array<String>> in_thirdPartyUrls, std::unique_ptr<protocol::Array<String>>* out_matchedUrls) = 0;
    virtual DispatchResponse setProtectedAudienceKAnonymity(const String& in_owner, const String& in_name, std::unique_ptr<protocol::Array<Binary>> in_hashes) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void cacheStorageContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& cacheName);
    void cacheStorageListUpdated(const String& origin, const String& storageKey, const String& bucketId);
    void indexedDBContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& databaseName, const String& objectStoreName);
    void indexedDBListUpdated(const String& origin, const String& storageKey, const String& bucketId);
    void interestGroupAccessed(double accessTime, const String& type, const String& ownerOrigin, const String& name, std::optional<String> componentSellerOrigin = {}, std::optional<double> bid = {}, std::optional<String> bidCurrency = {}, std::optional<String> uniqueAuctionId = {});
    void interestGroupAuctionEventOccurred(double eventTime, const String& type, const String& uniqueAuctionId, std::optional<String> parentAuctionId = {}, std::unique_ptr<protocol::DictionaryValue> auctionConfig = {});
    void interestGroupAuctionNetworkRequestCreated(const String& type, const String& requestId, std::unique_ptr<protocol::Array<String>> auctions);
    void sharedStorageAccessed(double accessTime, const String& scope, const String& method, const String& mainFrameId, const String& ownerOrigin, const String& ownerSite, std::unique_ptr<protocol::Storage::SharedStorageAccessParams> params);
    void sharedStorageWorkletOperationExecutionFinished(double finishedTime, int executionTime, const String& method, const String& operationId, const String& workletTargetId, const String& mainFrameId, const String& ownerOrigin);
    void storageBucketCreatedOrUpdated(std::unique_ptr<protocol::Storage::StorageBucketInfo> bucketInfo);
    void storageBucketDeleted(const String& bucketId);
    void attributionReportingSourceRegistered(std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> registration, const String& result);
    void attributionReportingTriggerRegistered(std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> registration, const String& eventLevel, const String& aggregatable);
    void attributionReportingReportSent(const String& url, std::unique_ptr<protocol::DictionaryValue> body, const String& result, std::optional<int> netError = {}, std::optional<String> netErrorName = {}, std::optional<int> httpStatusCode = {});
    void attributionReportingVerboseDebugReportSent(const String& url, std::unique_ptr<protocol::Array<protocol::DictionaryValue>> body = {}, std::optional<int> netError = {}, std::optional<String> netErrorName = {}, std::optional<int> httpStatusCode = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Storage
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Storage_h)
