// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Security_h
#define blink_protocol_Security_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace Security {
using CertificateId = int;
using MixedContentType = String;
using SecurityState = String;
class CertificateSecurityState;
using SafetyTipStatus = String;
class SafetyTipInfo;
class VisibleSecurityState;
class SecurityStateExplanation;
class InsecureContentStatus;

// ------------- Forward and enum declarations.

namespace MixedContentTypeEnum {
CORE_EXPORT extern const char Blockable[];
CORE_EXPORT extern const char OptionallyBlockable[];
CORE_EXPORT extern const char None[];
} // namespace MixedContentTypeEnum

namespace SecurityStateEnum {
CORE_EXPORT extern const char Unknown[];
CORE_EXPORT extern const char Neutral[];
CORE_EXPORT extern const char Insecure[];
CORE_EXPORT extern const char Secure[];
CORE_EXPORT extern const char Info[];
CORE_EXPORT extern const char InsecureBroken[];
} // namespace SecurityStateEnum

namespace SafetyTipStatusEnum {
CORE_EXPORT extern const char BadReputation[];
CORE_EXPORT extern const char Lookalike[];
} // namespace SafetyTipStatusEnum

// ------------- Type and builder declarations.

class CORE_EXPORT CertificateSecurityState : public ::crdtp::ProtocolObject<CertificateSecurityState> {
public:
    ~CertificateSecurityState() override;  // Defined below

    String getProtocol() { return m_protocol; }
    void setProtocol(const String& value);  // Defined below

    String getKeyExchange() { return m_keyExchange; }
    void setKeyExchange(const String& value);  // Defined below

    bool hasKeyExchangeGroup() { return !!m_keyExchangeGroup; }
    String getKeyExchangeGroup(const String& defaultValue) const {
       return m_keyExchangeGroup.value_or(defaultValue);
    }
    const std::optional<String>& getKeyExchangeGroup() const {
       return m_keyExchangeGroup;
    }
    void setKeyExchangeGroup(const String& value);  // Defined below

    String getCipher() { return m_cipher; }
    void setCipher(const String& value);  // Defined below

    bool hasMac() { return !!m_mac; }
    String getMac(const String& defaultValue) const {
       return m_mac.value_or(defaultValue);
    }
    const std::optional<String>& getMac() const {
       return m_mac;
    }
    void setMac(const String& value);  // Defined below

    protocol::Array<String>* getCertificate() { return m_certificate.get(); }
    void setCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    String getSubjectName() { return m_subjectName; }
    void setSubjectName(const String& value);  // Defined below

    String getIssuer() { return m_issuer; }
    void setIssuer(const String& value);  // Defined below

    double getValidFrom() { return m_validFrom; }
    void setValidFrom(double value);  // Defined below

    double getValidTo() { return m_validTo; }
    void setValidTo(double value);  // Defined below

    bool hasCertificateNetworkError() { return !!m_certificateNetworkError; }
    String getCertificateNetworkError(const String& defaultValue) const {
       return m_certificateNetworkError.value_or(defaultValue);
    }
    const std::optional<String>& getCertificateNetworkError() const {
       return m_certificateNetworkError;
    }
    void setCertificateNetworkError(const String& value);  // Defined below

    bool getCertificateHasWeakSignature() { return m_certificateHasWeakSignature; }
    void setCertificateHasWeakSignature(bool value);  // Defined below

    bool getCertificateHasSha1Signature() { return m_certificateHasSha1Signature; }
    void setCertificateHasSha1Signature(bool value);  // Defined below

    bool getModernSSL() { return m_modernSSL; }
    void setModernSSL(bool value);  // Defined below

    bool getObsoleteSslProtocol() { return m_obsoleteSslProtocol; }
    void setObsoleteSslProtocol(bool value);  // Defined below

    bool getObsoleteSslKeyExchange() { return m_obsoleteSslKeyExchange; }
    void setObsoleteSslKeyExchange(bool value);  // Defined below

    bool getObsoleteSslCipher() { return m_obsoleteSslCipher; }
    void setObsoleteSslCipher(bool value);  // Defined below

    bool getObsoleteSslSignature() { return m_obsoleteSslSignature; }
    void setObsoleteSslSignature(bool value);  // Defined below

    template<int STATE>
    class CertificateSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            KeyExchangeSet = 1 << 2,
            CipherSet = 1 << 3,
            CertificateSet = 1 << 4,
            SubjectNameSet = 1 << 5,
            IssuerSet = 1 << 6,
            ValidFromSet = 1 << 7,
            ValidToSet = 1 << 8,
            CertificateHasWeakSignatureSet = 1 << 9,
            CertificateHasSha1SignatureSet = 1 << 10,
            ModernSSLSet = 1 << 11,
            ObsoleteSslProtocolSet = 1 << 12,
            ObsoleteSslKeyExchangeSet = 1 << 13,
            ObsoleteSslCipherSet = 1 << 14,
            ObsoleteSslSignatureSet = 1 << 15,
            AllFieldsSet = (ProtocolSet | KeyExchangeSet | CipherSet | CertificateSet | SubjectNameSet | IssuerSet | ValidFromSet | ValidToSet | CertificateHasWeakSignatureSet | CertificateHasSha1SignatureSet | ModernSSLSet | ObsoleteSslProtocolSet | ObsoleteSslKeyExchangeSet | ObsoleteSslCipherSet | ObsoleteSslSignatureSet | 0)};


        CertificateSecurityStateBuilder<STATE | ProtocolSet>& setProtocol(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | KeyExchangeSet>& setKeyExchange(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& setKeyExchangeGroup(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CipherSet>& setCipher(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& setMac(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateSet>& setCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CertificateSecurityStateBuilder<STATE | SubjectNameSet>& setSubjectName(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | IssuerSet>& setIssuer(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ValidFromSet>& setValidFrom(double value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ValidToSet>& setValidTo(double value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& setCertificateNetworkError(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateHasWeakSignatureSet>& setCertificateHasWeakSignature(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateHasSha1SignatureSet>& setCertificateHasSha1Signature(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ModernSSLSet>& setModernSSL(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslProtocolSet>& setObsoleteSslProtocol(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslKeyExchangeSet>& setObsoleteSslKeyExchange(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslCipherSet>& setObsoleteSslCipher(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslSignatureSet>& setObsoleteSslSignature(bool value);  // Defined below

        std::unique_ptr<CertificateSecurityState> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CertificateSecurityState;
        CertificateSecurityStateBuilder() : m_result(new CertificateSecurityState()) { }

        template<int STEP> CertificateSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CertificateSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::CertificateSecurityState> m_result;
    };

    static CertificateSecurityStateBuilder<0> create()
    {
        return CertificateSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CertificateSecurityState();  // Defined below

    String m_protocol;
    String m_keyExchange;
    std::optional<String> m_keyExchangeGroup;
    String m_cipher;
    std::optional<String> m_mac;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    String m_subjectName;
    String m_issuer;
    double m_validFrom;
    double m_validTo;
    std::optional<String> m_certificateNetworkError;
    bool m_certificateHasWeakSignature;
    bool m_certificateHasSha1Signature;
    bool m_modernSSL;
    bool m_obsoleteSslProtocol;
    bool m_obsoleteSslKeyExchange;
    bool m_obsoleteSslCipher;
    bool m_obsoleteSslSignature;
};


class CORE_EXPORT SafetyTipInfo : public ::crdtp::ProtocolObject<SafetyTipInfo> {
public:
    ~SafetyTipInfo() override;  // Defined below

    String getSafetyTipStatus() { return m_safetyTipStatus; }
    void setSafetyTipStatus(const String& value);  // Defined below

    bool hasSafeUrl() { return !!m_safeUrl; }
    String getSafeUrl(const String& defaultValue) const {
       return m_safeUrl.value_or(defaultValue);
    }
    const std::optional<String>& getSafeUrl() const {
       return m_safeUrl;
    }
    void setSafeUrl(const String& value);  // Defined below

    template<int STATE>
    class SafetyTipInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SafetyTipStatusSet = 1 << 1,
            AllFieldsSet = (SafetyTipStatusSet | 0)};


        SafetyTipInfoBuilder<STATE | SafetyTipStatusSet>& setSafetyTipStatus(const String& value);  // Defined below

        SafetyTipInfoBuilder<STATE>& setSafeUrl(const String& value);  // Defined below

        std::unique_ptr<SafetyTipInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SafetyTipInfo;
        SafetyTipInfoBuilder() : m_result(new SafetyTipInfo()) { }

        template<int STEP> SafetyTipInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SafetyTipInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SafetyTipInfo> m_result;
    };

    static SafetyTipInfoBuilder<0> create()
    {
        return SafetyTipInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SafetyTipInfo();  // Defined below

    String m_safetyTipStatus;
    std::optional<String> m_safeUrl;
};


class CORE_EXPORT VisibleSecurityState : public ::crdtp::ProtocolObject<VisibleSecurityState> {
public:
    ~VisibleSecurityState() override;  // Defined below

    String getSecurityState() { return m_securityState; }
    void setSecurityState(const String& value);  // Defined below

    bool hasCertificateSecurityState() { return !!m_certificateSecurityState; }
    protocol::Security::CertificateSecurityState* getCertificateSecurityState(protocol::Security::CertificateSecurityState* defaultValue) {
       return m_certificateSecurityState ? m_certificateSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Security::CertificateSecurityState>& getCertificateSecurityState() const {
       return m_certificateSecurityState;
    }
    void setCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value);  // Defined below

    bool hasSafetyTipInfo() { return !!m_safetyTipInfo; }
    protocol::Security::SafetyTipInfo* getSafetyTipInfo(protocol::Security::SafetyTipInfo* defaultValue) {
       return m_safetyTipInfo ? m_safetyTipInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Security::SafetyTipInfo>& getSafetyTipInfo() const {
       return m_safetyTipInfo;
    }
    void setSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value);  // Defined below

    protocol::Array<String>* getSecurityStateIssueIds() { return m_securityStateIssueIds.get(); }
    void setSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class VisibleSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            SecurityStateIssueIdsSet = 1 << 2,
            AllFieldsSet = (SecurityStateSet | SecurityStateIssueIdsSet | 0)};


        VisibleSecurityStateBuilder<STATE | SecurityStateSet>& setSecurityState(const String& value);  // Defined below

        VisibleSecurityStateBuilder<STATE>& setCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value);  // Defined below

        VisibleSecurityStateBuilder<STATE>& setSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value);  // Defined below

        VisibleSecurityStateBuilder<STATE | SecurityStateIssueIdsSet>& setSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<VisibleSecurityState> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VisibleSecurityState;
        VisibleSecurityStateBuilder() : m_result(new VisibleSecurityState()) { }

        template<int STEP> VisibleSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VisibleSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::VisibleSecurityState> m_result;
    };

    static VisibleSecurityStateBuilder<0> create()
    {
        return VisibleSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VisibleSecurityState();  // Defined below

    String m_securityState;
    std::unique_ptr<protocol::Security::CertificateSecurityState> m_certificateSecurityState;
    std::unique_ptr<protocol::Security::SafetyTipInfo> m_safetyTipInfo;
    std::unique_ptr<protocol::Array<String>> m_securityStateIssueIds;
};


class CORE_EXPORT SecurityStateExplanation : public ::crdtp::ProtocolObject<SecurityStateExplanation> {
public:
    ~SecurityStateExplanation() override;  // Defined below

    String getSecurityState() { return m_securityState; }
    void setSecurityState(const String& value);  // Defined below

    String getTitle() { return m_title; }
    void setTitle(const String& value);  // Defined below

    String getSummary() { return m_summary; }
    void setSummary(const String& value);  // Defined below

    String getDescription() { return m_description; }
    void setDescription(const String& value);  // Defined below

    String getMixedContentType() { return m_mixedContentType; }
    void setMixedContentType(const String& value);  // Defined below

    protocol::Array<String>* getCertificate() { return m_certificate.get(); }
    void setCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    bool hasRecommendations() { return !!m_recommendations; }
    protocol::Array<String>* getRecommendations(protocol::Array<String>* defaultValue) {
       return m_recommendations ? m_recommendations.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getRecommendations() const {
       return m_recommendations;
    }
    void setRecommendations(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class SecurityStateExplanationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            TitleSet = 1 << 2,
            SummarySet = 1 << 3,
            DescriptionSet = 1 << 4,
            MixedContentTypeSet = 1 << 5,
            CertificateSet = 1 << 6,
            AllFieldsSet = (SecurityStateSet | TitleSet | SummarySet | DescriptionSet | MixedContentTypeSet | CertificateSet | 0)};


        SecurityStateExplanationBuilder<STATE | SecurityStateSet>& setSecurityState(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | TitleSet>& setTitle(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | SummarySet>& setSummary(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | DescriptionSet>& setDescription(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | MixedContentTypeSet>& setMixedContentType(const String& value);  // Defined below

        SecurityStateExplanationBuilder<STATE | CertificateSet>& setCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        SecurityStateExplanationBuilder<STATE>& setRecommendations(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<SecurityStateExplanation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityStateExplanation;
        SecurityStateExplanationBuilder() : m_result(new SecurityStateExplanation()) { }

        template<int STEP> SecurityStateExplanationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityStateExplanationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SecurityStateExplanation> m_result;
    };

    static SecurityStateExplanationBuilder<0> create()
    {
        return SecurityStateExplanationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityStateExplanation();  // Defined below

    String m_securityState;
    String m_title;
    String m_summary;
    String m_description;
    String m_mixedContentType;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    std::unique_ptr<protocol::Array<String>> m_recommendations;
};


class CORE_EXPORT InsecureContentStatus : public ::crdtp::ProtocolObject<InsecureContentStatus> {
public:
    ~InsecureContentStatus() override;  // Defined below

    bool getRanMixedContent() { return m_ranMixedContent; }
    void setRanMixedContent(bool value);  // Defined below

    bool getDisplayedMixedContent() { return m_displayedMixedContent; }
    void setDisplayedMixedContent(bool value);  // Defined below

    bool getContainedMixedForm() { return m_containedMixedForm; }
    void setContainedMixedForm(bool value);  // Defined below

    bool getRanContentWithCertErrors() { return m_ranContentWithCertErrors; }
    void setRanContentWithCertErrors(bool value);  // Defined below

    bool getDisplayedContentWithCertErrors() { return m_displayedContentWithCertErrors; }
    void setDisplayedContentWithCertErrors(bool value);  // Defined below

    String getRanInsecureContentStyle() { return m_ranInsecureContentStyle; }
    void setRanInsecureContentStyle(const String& value);  // Defined below

    String getDisplayedInsecureContentStyle() { return m_displayedInsecureContentStyle; }
    void setDisplayedInsecureContentStyle(const String& value);  // Defined below

    template<int STATE>
    class InsecureContentStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RanMixedContentSet = 1 << 1,
            DisplayedMixedContentSet = 1 << 2,
            ContainedMixedFormSet = 1 << 3,
            RanContentWithCertErrorsSet = 1 << 4,
            DisplayedContentWithCertErrorsSet = 1 << 5,
            RanInsecureContentStyleSet = 1 << 6,
            DisplayedInsecureContentStyleSet = 1 << 7,
            AllFieldsSet = (RanMixedContentSet | DisplayedMixedContentSet | ContainedMixedFormSet | RanContentWithCertErrorsSet | DisplayedContentWithCertErrorsSet | RanInsecureContentStyleSet | DisplayedInsecureContentStyleSet | 0)};


        InsecureContentStatusBuilder<STATE | RanMixedContentSet>& setRanMixedContent(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | DisplayedMixedContentSet>& setDisplayedMixedContent(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | ContainedMixedFormSet>& setContainedMixedForm(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | RanContentWithCertErrorsSet>& setRanContentWithCertErrors(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | DisplayedContentWithCertErrorsSet>& setDisplayedContentWithCertErrors(bool value);  // Defined below

        InsecureContentStatusBuilder<STATE | RanInsecureContentStyleSet>& setRanInsecureContentStyle(const String& value);  // Defined below

        InsecureContentStatusBuilder<STATE | DisplayedInsecureContentStyleSet>& setDisplayedInsecureContentStyle(const String& value);  // Defined below

        std::unique_ptr<InsecureContentStatus> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InsecureContentStatus;
        InsecureContentStatusBuilder() : m_result(new InsecureContentStatus()) { }

        template<int STEP> InsecureContentStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InsecureContentStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::InsecureContentStatus> m_result;
    };

    static InsecureContentStatusBuilder<0> create()
    {
        return InsecureContentStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InsecureContentStatus();  // Defined below

    bool m_ranMixedContent;
    bool m_displayedMixedContent;
    bool m_containedMixedForm;
    bool m_ranContentWithCertErrors;
    bool m_displayedContentWithCertErrors;
    String m_ranInsecureContentStyle;
    String m_displayedInsecureContentStyle;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline CertificateSecurityState::~CertificateSecurityState() = default;
inline void CertificateSecurityState::setProtocol(const String& value) { m_protocol = value; }
inline void CertificateSecurityState::setKeyExchange(const String& value) { m_keyExchange = value; }
inline void CertificateSecurityState::setKeyExchangeGroup(const String& value) { m_keyExchangeGroup = value; }
inline void CertificateSecurityState::setCipher(const String& value) { m_cipher = value; }
inline void CertificateSecurityState::setMac(const String& value) { m_mac = value; }
inline void CertificateSecurityState::setCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }
inline void CertificateSecurityState::setSubjectName(const String& value) { m_subjectName = value; }
inline void CertificateSecurityState::setIssuer(const String& value) { m_issuer = value; }
inline void CertificateSecurityState::setValidFrom(double value) { m_validFrom = value; }
inline void CertificateSecurityState::setValidTo(double value) { m_validTo = value; }
inline void CertificateSecurityState::setCertificateNetworkError(const String& value) { m_certificateNetworkError = value; }
inline void CertificateSecurityState::setCertificateHasWeakSignature(bool value) { m_certificateHasWeakSignature = value; }
inline void CertificateSecurityState::setCertificateHasSha1Signature(bool value) { m_certificateHasSha1Signature = value; }
inline void CertificateSecurityState::setModernSSL(bool value) { m_modernSSL = value; }
inline void CertificateSecurityState::setObsoleteSslProtocol(bool value) { m_obsoleteSslProtocol = value; }
inline void CertificateSecurityState::setObsoleteSslKeyExchange(bool value) { m_obsoleteSslKeyExchange = value; }
inline void CertificateSecurityState::setObsoleteSslCipher(bool value) { m_obsoleteSslCipher = value; }
inline void CertificateSecurityState::setObsoleteSslSignature(bool value) { m_obsoleteSslSignature = value; }

template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ProtocolSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setProtocol(const String& value) {
  static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
  m_result->setProtocol(value);
  return castState<ProtocolSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::KeyExchangeSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setKeyExchange(const String& value) {
  static_assert(!(STATE & KeyExchangeSet), "property keyExchange should not be set yet");
  m_result->setKeyExchange(value);
  return castState<KeyExchangeSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setKeyExchangeGroup(const String& value) {
  m_result->setKeyExchangeGroup(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CipherSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setCipher(const String& value) {
  static_assert(!(STATE & CipherSet), "property cipher should not be set yet");
  m_result->setCipher(value);
  return castState<CipherSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setMac(const String& value) {
  m_result->setMac(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setCertificate(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
  m_result->setCertificate(std::move(value));
  return castState<CertificateSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SubjectNameSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setSubjectName(const String& value) {
  static_assert(!(STATE & SubjectNameSet), "property subjectName should not be set yet");
  m_result->setSubjectName(value);
  return castState<SubjectNameSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::IssuerSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setIssuer(const String& value) {
  static_assert(!(STATE & IssuerSet), "property issuer should not be set yet");
  m_result->setIssuer(value);
  return castState<IssuerSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ValidFromSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setValidFrom(double value) {
  static_assert(!(STATE & ValidFromSet), "property validFrom should not be set yet");
  m_result->setValidFrom(value);
  return castState<ValidFromSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ValidToSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setValidTo(double value) {
  static_assert(!(STATE & ValidToSet), "property validTo should not be set yet");
  m_result->setValidTo(value);
  return castState<ValidToSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setCertificateNetworkError(const String& value) {
  m_result->setCertificateNetworkError(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateHasWeakSignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setCertificateHasWeakSignature(bool value) {
  static_assert(!(STATE & CertificateHasWeakSignatureSet), "property certificateHasWeakSignature should not be set yet");
  m_result->setCertificateHasWeakSignature(value);
  return castState<CertificateHasWeakSignatureSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateHasSha1SignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setCertificateHasSha1Signature(bool value) {
  static_assert(!(STATE & CertificateHasSha1SignatureSet), "property certificateHasSha1Signature should not be set yet");
  m_result->setCertificateHasSha1Signature(value);
  return castState<CertificateHasSha1SignatureSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ModernSSLSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setModernSSL(bool value) {
  static_assert(!(STATE & ModernSSLSet), "property modernSSL should not be set yet");
  m_result->setModernSSL(value);
  return castState<ModernSSLSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslProtocolSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setObsoleteSslProtocol(bool value) {
  static_assert(!(STATE & ObsoleteSslProtocolSet), "property obsoleteSslProtocol should not be set yet");
  m_result->setObsoleteSslProtocol(value);
  return castState<ObsoleteSslProtocolSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslKeyExchangeSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setObsoleteSslKeyExchange(bool value) {
  static_assert(!(STATE & ObsoleteSslKeyExchangeSet), "property obsoleteSslKeyExchange should not be set yet");
  m_result->setObsoleteSslKeyExchange(value);
  return castState<ObsoleteSslKeyExchangeSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslCipherSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setObsoleteSslCipher(bool value) {
  static_assert(!(STATE & ObsoleteSslCipherSet), "property obsoleteSslCipher should not be set yet");
  m_result->setObsoleteSslCipher(value);
  return castState<ObsoleteSslCipherSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslSignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::setObsoleteSslSignature(bool value) {
  static_assert(!(STATE & ObsoleteSslSignatureSet), "property obsoleteSslSignature should not be set yet");
  m_result->setObsoleteSslSignature(value);
  return castState<ObsoleteSslSignatureSet>();
}

inline CertificateSecurityState::CertificateSecurityState() {
  m_validFrom = 0;
  m_validTo = 0;
  m_certificateHasWeakSignature = false;
  m_certificateHasSha1Signature = false;
  m_modernSSL = false;
  m_obsoleteSslProtocol = false;
  m_obsoleteSslKeyExchange = false;
  m_obsoleteSslCipher = false;
  m_obsoleteSslSignature = false;
}
inline SafetyTipInfo::~SafetyTipInfo() = default;
inline void SafetyTipInfo::setSafetyTipStatus(const String& value) { m_safetyTipStatus = value; }
inline void SafetyTipInfo::setSafeUrl(const String& value) { m_safeUrl = value; }

template<int STATE>
inline SafetyTipInfo::SafetyTipInfoBuilder<STATE | SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SafetyTipStatusSet>&
SafetyTipInfo::SafetyTipInfoBuilder<STATE>::setSafetyTipStatus(const String& value) {
  static_assert(!(STATE & SafetyTipStatusSet), "property safetyTipStatus should not be set yet");
  m_result->setSafetyTipStatus(value);
  return castState<SafetyTipStatusSet>();
}
template<int STATE>
inline SafetyTipInfo::SafetyTipInfoBuilder<STATE>& SafetyTipInfo::SafetyTipInfoBuilder<STATE>::setSafeUrl(const String& value) {
  m_result->setSafeUrl(value);
  return *this;
}

inline SafetyTipInfo::SafetyTipInfo() {
}
inline VisibleSecurityState::~VisibleSecurityState() = default;
inline void VisibleSecurityState::setSecurityState(const String& value) { m_securityState = value; }
inline void VisibleSecurityState::setCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) { m_certificateSecurityState = std::move(value); }
inline void VisibleSecurityState::setSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) { m_safetyTipInfo = std::move(value); }
inline void VisibleSecurityState::setSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) { m_securityStateIssueIds = std::move(value); }

template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE | VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SecurityStateSet>&
VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::setSecurityState(const String& value) {
  static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
  m_result->setSecurityState(value);
  return castState<SecurityStateSet>();
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE>& VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::setCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) {
  m_result->setCertificateSecurityState(std::move(value));
  return *this;
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE>& VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::setSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) {
  m_result->setSafetyTipInfo(std::move(value));
  return *this;
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE | VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SecurityStateIssueIdsSet>&
VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::setSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & SecurityStateIssueIdsSet), "property securityStateIssueIds should not be set yet");
  m_result->setSecurityStateIssueIds(std::move(value));
  return castState<SecurityStateIssueIdsSet>();
}

inline VisibleSecurityState::VisibleSecurityState() {
}
inline SecurityStateExplanation::~SecurityStateExplanation() = default;
inline void SecurityStateExplanation::setSecurityState(const String& value) { m_securityState = value; }
inline void SecurityStateExplanation::setTitle(const String& value) { m_title = value; }
inline void SecurityStateExplanation::setSummary(const String& value) { m_summary = value; }
inline void SecurityStateExplanation::setDescription(const String& value) { m_description = value; }
inline void SecurityStateExplanation::setMixedContentType(const String& value) { m_mixedContentType = value; }
inline void SecurityStateExplanation::setCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }
inline void SecurityStateExplanation::setRecommendations(std::unique_ptr<protocol::Array<String>> value) { m_recommendations = std::move(value); }

template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SecurityStateSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setSecurityState(const String& value) {
  static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
  m_result->setSecurityState(value);
  return castState<SecurityStateSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::TitleSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setTitle(const String& value) {
  static_assert(!(STATE & TitleSet), "property title should not be set yet");
  m_result->setTitle(value);
  return castState<TitleSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::SummarySet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setSummary(const String& value) {
  static_assert(!(STATE & SummarySet), "property summary should not be set yet");
  m_result->setSummary(value);
  return castState<SummarySet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::DescriptionSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setDescription(const String& value) {
  static_assert(!(STATE & DescriptionSet), "property description should not be set yet");
  m_result->setDescription(value);
  return castState<DescriptionSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::MixedContentTypeSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setMixedContentType(const String& value) {
  static_assert(!(STATE & MixedContentTypeSet), "property mixedContentType should not be set yet");
  m_result->setMixedContentType(value);
  return castState<MixedContentTypeSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE | SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::CertificateSet>&
SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setCertificate(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
  m_result->setCertificate(std::move(value));
  return castState<CertificateSet>();
}
template<int STATE>
inline SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>& SecurityStateExplanation::SecurityStateExplanationBuilder<STATE>::setRecommendations(std::unique_ptr<protocol::Array<String>> value) {
  m_result->setRecommendations(std::move(value));
  return *this;
}

inline SecurityStateExplanation::SecurityStateExplanation() {
}
inline InsecureContentStatus::~InsecureContentStatus() = default;
inline void InsecureContentStatus::setRanMixedContent(bool value) { m_ranMixedContent = value; }
inline void InsecureContentStatus::setDisplayedMixedContent(bool value) { m_displayedMixedContent = value; }
inline void InsecureContentStatus::setContainedMixedForm(bool value) { m_containedMixedForm = value; }
inline void InsecureContentStatus::setRanContentWithCertErrors(bool value) { m_ranContentWithCertErrors = value; }
inline void InsecureContentStatus::setDisplayedContentWithCertErrors(bool value) { m_displayedContentWithCertErrors = value; }
inline void InsecureContentStatus::setRanInsecureContentStyle(const String& value) { m_ranInsecureContentStyle = value; }
inline void InsecureContentStatus::setDisplayedInsecureContentStyle(const String& value) { m_displayedInsecureContentStyle = value; }

template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::RanMixedContentSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setRanMixedContent(bool value) {
  static_assert(!(STATE & RanMixedContentSet), "property ranMixedContent should not be set yet");
  m_result->setRanMixedContent(value);
  return castState<RanMixedContentSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::DisplayedMixedContentSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setDisplayedMixedContent(bool value) {
  static_assert(!(STATE & DisplayedMixedContentSet), "property displayedMixedContent should not be set yet");
  m_result->setDisplayedMixedContent(value);
  return castState<DisplayedMixedContentSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::ContainedMixedFormSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setContainedMixedForm(bool value) {
  static_assert(!(STATE & ContainedMixedFormSet), "property containedMixedForm should not be set yet");
  m_result->setContainedMixedForm(value);
  return castState<ContainedMixedFormSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::RanContentWithCertErrorsSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setRanContentWithCertErrors(bool value) {
  static_assert(!(STATE & RanContentWithCertErrorsSet), "property ranContentWithCertErrors should not be set yet");
  m_result->setRanContentWithCertErrors(value);
  return castState<RanContentWithCertErrorsSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::DisplayedContentWithCertErrorsSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setDisplayedContentWithCertErrors(bool value) {
  static_assert(!(STATE & DisplayedContentWithCertErrorsSet), "property displayedContentWithCertErrors should not be set yet");
  m_result->setDisplayedContentWithCertErrors(value);
  return castState<DisplayedContentWithCertErrorsSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::RanInsecureContentStyleSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setRanInsecureContentStyle(const String& value) {
  static_assert(!(STATE & RanInsecureContentStyleSet), "property ranInsecureContentStyle should not be set yet");
  m_result->setRanInsecureContentStyle(value);
  return castState<RanInsecureContentStyleSet>();
}
template<int STATE>
inline InsecureContentStatus::InsecureContentStatusBuilder<STATE | InsecureContentStatus::InsecureContentStatusBuilder<STATE>::DisplayedInsecureContentStyleSet>&
InsecureContentStatus::InsecureContentStatusBuilder<STATE>::setDisplayedInsecureContentStyle(const String& value) {
  static_assert(!(STATE & DisplayedInsecureContentStyleSet), "property displayedInsecureContentStyle should not be set yet");
  m_result->setDisplayedInsecureContentStyle(value);
  return castState<DisplayedInsecureContentStyleSet>();
}

inline InsecureContentStatus::InsecureContentStatus() {
  m_ranMixedContent = false;
  m_displayedMixedContent = false;
  m_containedMixedForm = false;
  m_ranContentWithCertErrors = false;
  m_displayedContentWithCertErrors = false;
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }


    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void certificateError(int eventId, const String& errorType, const String& requestURL);
    void visibleSecurityStateChanged(std::unique_ptr<protocol::Security::VisibleSecurityState> visibleSecurityState);
    void securityStateChanged(const String& securityState, bool schemeIsCryptographic, std::unique_ptr<protocol::Array<protocol::Security::SecurityStateExplanation>> explanations, std::unique_ptr<protocol::Security::InsecureContentStatus> insecureContentStatus, std::optional<String> summary = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Security
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Security_h)
