// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_PerformanceTimeline_h
#define blink_protocol_PerformanceTimeline_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/network.h"

namespace blink {
namespace protocol {
namespace PerformanceTimeline {
class LargestContentfulPaint;
class LayoutShiftAttribution;
class LayoutShift;
class TimelineEvent;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT LargestContentfulPaint : public ::crdtp::ProtocolObject<LargestContentfulPaint> {
public:
    ~LargestContentfulPaint() override;  // Defined below

    double getRenderTime() { return m_renderTime; }
    void setRenderTime(double value);  // Defined below

    double getLoadTime() { return m_loadTime; }
    void setLoadTime(double value);  // Defined below

    double getSize() { return m_size; }
    void setSize(double value);  // Defined below

    bool hasElementId() { return !!m_elementId; }
    String getElementId(const String& defaultValue) const {
       return m_elementId.value_or(defaultValue);
    }
    const std::optional<String>& getElementId() const {
       return m_elementId;
    }
    void setElementId(const String& value);  // Defined below

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value);  // Defined below

    bool hasNodeId() { return !!m_nodeId; }
    int getNodeId(int defaultValue) const {
       return m_nodeId.value_or(defaultValue);
    }
    const std::optional<int>& getNodeId() const {
       return m_nodeId;
    }
    void setNodeId(int value);  // Defined below

    template<int STATE>
    class LargestContentfulPaintBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RenderTimeSet = 1 << 1,
            LoadTimeSet = 1 << 2,
            SizeSet = 1 << 3,
            AllFieldsSet = (RenderTimeSet | LoadTimeSet | SizeSet | 0)};


        LargestContentfulPaintBuilder<STATE | RenderTimeSet>& setRenderTime(double value);  // Defined below

        LargestContentfulPaintBuilder<STATE | LoadTimeSet>& setLoadTime(double value);  // Defined below

        LargestContentfulPaintBuilder<STATE | SizeSet>& setSize(double value);  // Defined below

        LargestContentfulPaintBuilder<STATE>& setElementId(const String& value);  // Defined below

        LargestContentfulPaintBuilder<STATE>& setUrl(const String& value);  // Defined below

        LargestContentfulPaintBuilder<STATE>& setNodeId(int value);  // Defined below

        std::unique_ptr<LargestContentfulPaint> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LargestContentfulPaint;
        LargestContentfulPaintBuilder() : m_result(new LargestContentfulPaint()) { }

        template<int STEP> LargestContentfulPaintBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LargestContentfulPaintBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint> m_result;
    };

    static LargestContentfulPaintBuilder<0> create()
    {
        return LargestContentfulPaintBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LargestContentfulPaint();  // Defined below

    double m_renderTime;
    double m_loadTime;
    double m_size;
    std::optional<String> m_elementId;
    std::optional<String> m_url;
    std::optional<int> m_nodeId;
};


class CORE_EXPORT LayoutShiftAttribution : public ::crdtp::ProtocolObject<LayoutShiftAttribution> {
public:
    ~LayoutShiftAttribution() override;  // Defined below

    protocol::DOM::Rect* getPreviousRect() { return m_previousRect.get(); }
    void setPreviousRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    protocol::DOM::Rect* getCurrentRect() { return m_currentRect.get(); }
    void setCurrentRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    bool hasNodeId() { return !!m_nodeId; }
    int getNodeId(int defaultValue) const {
       return m_nodeId.value_or(defaultValue);
    }
    const std::optional<int>& getNodeId() const {
       return m_nodeId;
    }
    void setNodeId(int value);  // Defined below

    template<int STATE>
    class LayoutShiftAttributionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PreviousRectSet = 1 << 1,
            CurrentRectSet = 1 << 2,
            AllFieldsSet = (PreviousRectSet | CurrentRectSet | 0)};


        LayoutShiftAttributionBuilder<STATE | PreviousRectSet>& setPreviousRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        LayoutShiftAttributionBuilder<STATE | CurrentRectSet>& setCurrentRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        LayoutShiftAttributionBuilder<STATE>& setNodeId(int value);  // Defined below

        std::unique_ptr<LayoutShiftAttribution> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LayoutShiftAttribution;
        LayoutShiftAttributionBuilder() : m_result(new LayoutShiftAttribution()) { }

        template<int STEP> LayoutShiftAttributionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LayoutShiftAttributionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::PerformanceTimeline::LayoutShiftAttribution> m_result;
    };

    static LayoutShiftAttributionBuilder<0> create()
    {
        return LayoutShiftAttributionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LayoutShiftAttribution();  // Defined below

    std::unique_ptr<protocol::DOM::Rect> m_previousRect;
    std::unique_ptr<protocol::DOM::Rect> m_currentRect;
    std::optional<int> m_nodeId;
};


class CORE_EXPORT LayoutShift : public ::crdtp::ProtocolObject<LayoutShift> {
public:
    ~LayoutShift() override;  // Defined below

    double getValue() { return m_value; }
    void setValue(double value);  // Defined below

    bool getHadRecentInput() { return m_hadRecentInput; }
    void setHadRecentInput(bool value);  // Defined below

    double getLastInputTime() { return m_lastInputTime; }
    void setLastInputTime(double value);  // Defined below

    protocol::Array<protocol::PerformanceTimeline::LayoutShiftAttribution>* getSources() { return m_sources.get(); }
    void setSources(std::unique_ptr<protocol::Array<protocol::PerformanceTimeline::LayoutShiftAttribution>> value);  // Defined below

    template<int STATE>
    class LayoutShiftBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            HadRecentInputSet = 1 << 2,
            LastInputTimeSet = 1 << 3,
            SourcesSet = 1 << 4,
            AllFieldsSet = (ValueSet | HadRecentInputSet | LastInputTimeSet | SourcesSet | 0)};


        LayoutShiftBuilder<STATE | ValueSet>& setValue(double value);  // Defined below

        LayoutShiftBuilder<STATE | HadRecentInputSet>& setHadRecentInput(bool value);  // Defined below

        LayoutShiftBuilder<STATE | LastInputTimeSet>& setLastInputTime(double value);  // Defined below

        LayoutShiftBuilder<STATE | SourcesSet>& setSources(std::unique_ptr<protocol::Array<protocol::PerformanceTimeline::LayoutShiftAttribution>> value);  // Defined below

        std::unique_ptr<LayoutShift> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LayoutShift;
        LayoutShiftBuilder() : m_result(new LayoutShift()) { }

        template<int STEP> LayoutShiftBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LayoutShiftBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::PerformanceTimeline::LayoutShift> m_result;
    };

    static LayoutShiftBuilder<0> create()
    {
        return LayoutShiftBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LayoutShift();  // Defined below

    double m_value;
    bool m_hadRecentInput;
    double m_lastInputTime;
    std::unique_ptr<protocol::Array<protocol::PerformanceTimeline::LayoutShiftAttribution>> m_sources;
};


class CORE_EXPORT TimelineEvent : public ::crdtp::ProtocolObject<TimelineEvent> {
public:
    ~TimelineEvent() override;  // Defined below

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value);  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    double getTime() { return m_time; }
    void setTime(double value);  // Defined below

    bool hasDuration() { return !!m_duration; }
    double getDuration(double defaultValue) const {
       return m_duration.value_or(defaultValue);
    }
    const std::optional<double>& getDuration() const {
       return m_duration;
    }
    void setDuration(double value);  // Defined below

    bool hasLcpDetails() { return !!m_lcpDetails; }
    protocol::PerformanceTimeline::LargestContentfulPaint* getLcpDetails(protocol::PerformanceTimeline::LargestContentfulPaint* defaultValue) {
       return m_lcpDetails ? m_lcpDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint>& getLcpDetails() const {
       return m_lcpDetails;
    }
    void setLcpDetails(std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint> value);  // Defined below

    bool hasLayoutShiftDetails() { return !!m_layoutShiftDetails; }
    protocol::PerformanceTimeline::LayoutShift* getLayoutShiftDetails(protocol::PerformanceTimeline::LayoutShift* defaultValue) {
       return m_layoutShiftDetails ? m_layoutShiftDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::PerformanceTimeline::LayoutShift>& getLayoutShiftDetails() const {
       return m_layoutShiftDetails;
    }
    void setLayoutShiftDetails(std::unique_ptr<protocol::PerformanceTimeline::LayoutShift> value);  // Defined below

    template<int STATE>
    class TimelineEventBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            TypeSet = 1 << 2,
            NameSet = 1 << 3,
            TimeSet = 1 << 4,
            AllFieldsSet = (FrameIdSet | TypeSet | NameSet | TimeSet | 0)};


        TimelineEventBuilder<STATE | FrameIdSet>& setFrameId(const String& value);  // Defined below

        TimelineEventBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        TimelineEventBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        TimelineEventBuilder<STATE | TimeSet>& setTime(double value);  // Defined below

        TimelineEventBuilder<STATE>& setDuration(double value);  // Defined below

        TimelineEventBuilder<STATE>& setLcpDetails(std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint> value);  // Defined below

        TimelineEventBuilder<STATE>& setLayoutShiftDetails(std::unique_ptr<protocol::PerformanceTimeline::LayoutShift> value);  // Defined below

        std::unique_ptr<TimelineEvent> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TimelineEvent;
        TimelineEventBuilder() : m_result(new TimelineEvent()) { }

        template<int STEP> TimelineEventBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TimelineEventBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::PerformanceTimeline::TimelineEvent> m_result;
    };

    static TimelineEventBuilder<0> create()
    {
        return TimelineEventBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TimelineEvent();  // Defined below

    String m_frameId;
    String m_type;
    String m_name;
    double m_time;
    std::optional<double> m_duration;
    std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint> m_lcpDetails;
    std::unique_ptr<protocol::PerformanceTimeline::LayoutShift> m_layoutShiftDetails;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline LargestContentfulPaint::~LargestContentfulPaint() = default;
inline void LargestContentfulPaint::setRenderTime(double value) { m_renderTime = value; }
inline void LargestContentfulPaint::setLoadTime(double value) { m_loadTime = value; }
inline void LargestContentfulPaint::setSize(double value) { m_size = value; }
inline void LargestContentfulPaint::setElementId(const String& value) { m_elementId = value; }
inline void LargestContentfulPaint::setUrl(const String& value) { m_url = value; }
inline void LargestContentfulPaint::setNodeId(int value) { m_nodeId = value; }

template<int STATE>
inline LargestContentfulPaint::LargestContentfulPaintBuilder<STATE | LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::RenderTimeSet>&
LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::setRenderTime(double value) {
  static_assert(!(STATE & RenderTimeSet), "property renderTime should not be set yet");
  m_result->setRenderTime(value);
  return castState<RenderTimeSet>();
}
template<int STATE>
inline LargestContentfulPaint::LargestContentfulPaintBuilder<STATE | LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::LoadTimeSet>&
LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::setLoadTime(double value) {
  static_assert(!(STATE & LoadTimeSet), "property loadTime should not be set yet");
  m_result->setLoadTime(value);
  return castState<LoadTimeSet>();
}
template<int STATE>
inline LargestContentfulPaint::LargestContentfulPaintBuilder<STATE | LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::SizeSet>&
LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::setSize(double value) {
  static_assert(!(STATE & SizeSet), "property size should not be set yet");
  m_result->setSize(value);
  return castState<SizeSet>();
}
template<int STATE>
inline LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>& LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::setElementId(const String& value) {
  m_result->setElementId(value);
  return *this;
}
template<int STATE>
inline LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>& LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::setUrl(const String& value) {
  m_result->setUrl(value);
  return *this;
}
template<int STATE>
inline LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>& LargestContentfulPaint::LargestContentfulPaintBuilder<STATE>::setNodeId(int value) {
  m_result->setNodeId(value);
  return *this;
}

inline LargestContentfulPaint::LargestContentfulPaint() {
  m_renderTime = 0;
  m_loadTime = 0;
  m_size = 0;
}
inline LayoutShiftAttribution::~LayoutShiftAttribution() = default;
inline void LayoutShiftAttribution::setPreviousRect(std::unique_ptr<protocol::DOM::Rect> value) { m_previousRect = std::move(value); }
inline void LayoutShiftAttribution::setCurrentRect(std::unique_ptr<protocol::DOM::Rect> value) { m_currentRect = std::move(value); }
inline void LayoutShiftAttribution::setNodeId(int value) { m_nodeId = value; }

template<int STATE>
inline LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE | LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE>::PreviousRectSet>&
LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE>::setPreviousRect(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & PreviousRectSet), "property previousRect should not be set yet");
  m_result->setPreviousRect(std::move(value));
  return castState<PreviousRectSet>();
}
template<int STATE>
inline LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE | LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE>::CurrentRectSet>&
LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE>::setCurrentRect(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & CurrentRectSet), "property currentRect should not be set yet");
  m_result->setCurrentRect(std::move(value));
  return castState<CurrentRectSet>();
}
template<int STATE>
inline LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE>& LayoutShiftAttribution::LayoutShiftAttributionBuilder<STATE>::setNodeId(int value) {
  m_result->setNodeId(value);
  return *this;
}

inline LayoutShiftAttribution::LayoutShiftAttribution() {
}
inline LayoutShift::~LayoutShift() = default;
inline void LayoutShift::setValue(double value) { m_value = value; }
inline void LayoutShift::setHadRecentInput(bool value) { m_hadRecentInput = value; }
inline void LayoutShift::setLastInputTime(double value) { m_lastInputTime = value; }
inline void LayoutShift::setSources(std::unique_ptr<protocol::Array<protocol::PerformanceTimeline::LayoutShiftAttribution>> value) { m_sources = std::move(value); }

template<int STATE>
inline LayoutShift::LayoutShiftBuilder<STATE | LayoutShift::LayoutShiftBuilder<STATE>::ValueSet>&
LayoutShift::LayoutShiftBuilder<STATE>::setValue(double value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}
template<int STATE>
inline LayoutShift::LayoutShiftBuilder<STATE | LayoutShift::LayoutShiftBuilder<STATE>::HadRecentInputSet>&
LayoutShift::LayoutShiftBuilder<STATE>::setHadRecentInput(bool value) {
  static_assert(!(STATE & HadRecentInputSet), "property hadRecentInput should not be set yet");
  m_result->setHadRecentInput(value);
  return castState<HadRecentInputSet>();
}
template<int STATE>
inline LayoutShift::LayoutShiftBuilder<STATE | LayoutShift::LayoutShiftBuilder<STATE>::LastInputTimeSet>&
LayoutShift::LayoutShiftBuilder<STATE>::setLastInputTime(double value) {
  static_assert(!(STATE & LastInputTimeSet), "property lastInputTime should not be set yet");
  m_result->setLastInputTime(value);
  return castState<LastInputTimeSet>();
}
template<int STATE>
inline LayoutShift::LayoutShiftBuilder<STATE | LayoutShift::LayoutShiftBuilder<STATE>::SourcesSet>&
LayoutShift::LayoutShiftBuilder<STATE>::setSources(std::unique_ptr<protocol::Array<protocol::PerformanceTimeline::LayoutShiftAttribution>> value) {
  static_assert(!(STATE & SourcesSet), "property sources should not be set yet");
  m_result->setSources(std::move(value));
  return castState<SourcesSet>();
}

inline LayoutShift::LayoutShift() {
  m_value = 0;
  m_hadRecentInput = false;
  m_lastInputTime = 0;
}
inline TimelineEvent::~TimelineEvent() = default;
inline void TimelineEvent::setFrameId(const String& value) { m_frameId = value; }
inline void TimelineEvent::setType(const String& value) { m_type = value; }
inline void TimelineEvent::setName(const String& value) { m_name = value; }
inline void TimelineEvent::setTime(double value) { m_time = value; }
inline void TimelineEvent::setDuration(double value) { m_duration = value; }
inline void TimelineEvent::setLcpDetails(std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint> value) { m_lcpDetails = std::move(value); }
inline void TimelineEvent::setLayoutShiftDetails(std::unique_ptr<protocol::PerformanceTimeline::LayoutShift> value) { m_layoutShiftDetails = std::move(value); }

template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE | TimelineEvent::TimelineEventBuilder<STATE>::FrameIdSet>&
TimelineEvent::TimelineEventBuilder<STATE>::setFrameId(const String& value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->setFrameId(value);
  return castState<FrameIdSet>();
}
template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE | TimelineEvent::TimelineEventBuilder<STATE>::TypeSet>&
TimelineEvent::TimelineEventBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE | TimelineEvent::TimelineEventBuilder<STATE>::NameSet>&
TimelineEvent::TimelineEventBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE | TimelineEvent::TimelineEventBuilder<STATE>::TimeSet>&
TimelineEvent::TimelineEventBuilder<STATE>::setTime(double value) {
  static_assert(!(STATE & TimeSet), "property time should not be set yet");
  m_result->setTime(value);
  return castState<TimeSet>();
}
template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE>& TimelineEvent::TimelineEventBuilder<STATE>::setDuration(double value) {
  m_result->setDuration(value);
  return *this;
}
template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE>& TimelineEvent::TimelineEventBuilder<STATE>::setLcpDetails(std::unique_ptr<protocol::PerformanceTimeline::LargestContentfulPaint> value) {
  m_result->setLcpDetails(std::move(value));
  return *this;
}
template<int STATE>
inline TimelineEvent::TimelineEventBuilder<STATE>& TimelineEvent::TimelineEventBuilder<STATE>::setLayoutShiftDetails(std::unique_ptr<protocol::PerformanceTimeline::LayoutShift> value) {
  m_result->setLayoutShiftDetails(std::move(value));
  return *this;
}

inline TimelineEvent::TimelineEvent() {
  m_time = 0;
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse enable(std::unique_ptr<protocol::Array<String>> in_eventTypes) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void timelineEventAdded(std::unique_ptr<protocol::PerformanceTimeline::TimelineEvent> event);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace PerformanceTimeline
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_PerformanceTimeline_h)
