// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Page_h
#define blink_protocol_Page_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/debugger.h"
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/io.h"
#include "third_party/blink/renderer/core/inspector/protocol/network.h"
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"

namespace blink {
namespace protocol {
namespace Page {
using FrameId = String;
using AdFrameType = String;
using AdFrameExplanation = String;
class AdFrameStatus;
class AdScriptId;
class AdScriptAncestry;
using SecureContextType = String;
using CrossOriginIsolatedContextType = String;
using GatedAPIFeatures = String;
using PermissionsPolicyFeature = String;
using PermissionsPolicyBlockReason = String;
class PermissionsPolicyBlockLocator;
class PermissionsPolicyFeatureState;
using OriginTrialTokenStatus = String;
using OriginTrialStatus = String;
using OriginTrialUsageRestriction = String;
class OriginTrialToken;
class OriginTrialTokenWithStatus;
class OriginTrial;
class SecurityOriginDetails;
class Frame;
class FrameResource;
class FrameResourceTree;
class FrameTree;
using ScriptIdentifier = String;
class LayoutViewport;
class VisualViewport;
class Viewport;
class FontFamilies;
class ScriptFontFamilies;
class FontSizes;
using ClientNavigationReason = String;
using ClientNavigationDisposition = String;
class CompilationCacheParams;
using NavigationType = String;
using BackForwardCacheNotRestoredReason = String;
using BackForwardCacheNotRestoredReasonType = String;
class BackForwardCacheBlockingDetails;
class BackForwardCacheNotRestoredExplanation;
class BackForwardCacheNotRestoredExplanationTree;

// ------------- Forward and enum declarations.

namespace AdFrameTypeEnum {
CORE_EXPORT extern const char None[];
CORE_EXPORT extern const char Child[];
CORE_EXPORT extern const char Root[];
} // namespace AdFrameTypeEnum

namespace AdFrameExplanationEnum {
CORE_EXPORT extern const char ParentIsAd[];
CORE_EXPORT extern const char CreatedByAdScript[];
CORE_EXPORT extern const char MatchedBlockingRule[];
} // namespace AdFrameExplanationEnum

namespace SecureContextTypeEnum {
CORE_EXPORT extern const char Secure[];
CORE_EXPORT extern const char SecureLocalhost[];
CORE_EXPORT extern const char InsecureScheme[];
CORE_EXPORT extern const char InsecureAncestor[];
} // namespace SecureContextTypeEnum

namespace CrossOriginIsolatedContextTypeEnum {
CORE_EXPORT extern const char Isolated[];
CORE_EXPORT extern const char NotIsolated[];
CORE_EXPORT extern const char NotIsolatedFeatureDisabled[];
} // namespace CrossOriginIsolatedContextTypeEnum

namespace GatedAPIFeaturesEnum {
CORE_EXPORT extern const char SharedArrayBuffers[];
CORE_EXPORT extern const char SharedArrayBuffersTransferAllowed[];
CORE_EXPORT extern const char PerformanceMeasureMemory[];
CORE_EXPORT extern const char PerformanceProfile[];
} // namespace GatedAPIFeaturesEnum

namespace PermissionsPolicyFeatureEnum {
CORE_EXPORT extern const char Accelerometer[];
CORE_EXPORT extern const char AllScreensCapture[];
CORE_EXPORT extern const char AmbientLightSensor[];
CORE_EXPORT extern const char AriaNotify[];
CORE_EXPORT extern const char AttributionReporting[];
CORE_EXPORT extern const char Autofill[];
CORE_EXPORT extern const char Autoplay[];
CORE_EXPORT extern const char Bluetooth[];
CORE_EXPORT extern const char BrowsingTopics[];
CORE_EXPORT extern const char Camera[];
CORE_EXPORT extern const char CapturedSurfaceControl[];
CORE_EXPORT extern const char ChDpr[];
CORE_EXPORT extern const char ChDeviceMemory[];
CORE_EXPORT extern const char ChDownlink[];
CORE_EXPORT extern const char ChEct[];
CORE_EXPORT extern const char ChPrefersColorScheme[];
CORE_EXPORT extern const char ChPrefersReducedMotion[];
CORE_EXPORT extern const char ChPrefersReducedTransparency[];
CORE_EXPORT extern const char ChRtt[];
CORE_EXPORT extern const char ChSaveData[];
CORE_EXPORT extern const char ChUa[];
CORE_EXPORT extern const char ChUaArch[];
CORE_EXPORT extern const char ChUaBitness[];
CORE_EXPORT extern const char ChUaHighEntropyValues[];
CORE_EXPORT extern const char ChUaPlatform[];
CORE_EXPORT extern const char ChUaModel[];
CORE_EXPORT extern const char ChUaMobile[];
CORE_EXPORT extern const char ChUaFormFactors[];
CORE_EXPORT extern const char ChUaFullVersion[];
CORE_EXPORT extern const char ChUaFullVersionList[];
CORE_EXPORT extern const char ChUaPlatformVersion[];
CORE_EXPORT extern const char ChUaWow64[];
CORE_EXPORT extern const char ChViewportHeight[];
CORE_EXPORT extern const char ChViewportWidth[];
CORE_EXPORT extern const char ChWidth[];
CORE_EXPORT extern const char ClipboardRead[];
CORE_EXPORT extern const char ClipboardWrite[];
CORE_EXPORT extern const char ComputePressure[];
CORE_EXPORT extern const char ControlledFrame[];
CORE_EXPORT extern const char CrossOriginIsolated[];
CORE_EXPORT extern const char DeferredFetch[];
CORE_EXPORT extern const char DeferredFetchMinimal[];
CORE_EXPORT extern const char DeviceAttributes[];
CORE_EXPORT extern const char DigitalCredentialsCreate[];
CORE_EXPORT extern const char DigitalCredentialsGet[];
CORE_EXPORT extern const char DirectSockets[];
CORE_EXPORT extern const char DirectSocketsMulticast[];
CORE_EXPORT extern const char DirectSocketsPrivate[];
CORE_EXPORT extern const char DisplayCapture[];
CORE_EXPORT extern const char DocumentDomain[];
CORE_EXPORT extern const char EncryptedMedia[];
CORE_EXPORT extern const char ExecutionWhileOutOfViewport[];
CORE_EXPORT extern const char ExecutionWhileNotRendered[];
CORE_EXPORT extern const char FencedUnpartitionedStorageRead[];
CORE_EXPORT extern const char FocusWithoutUserActivation[];
CORE_EXPORT extern const char Fullscreen[];
CORE_EXPORT extern const char Frobulate[];
CORE_EXPORT extern const char Gamepad[];
CORE_EXPORT extern const char Geolocation[];
CORE_EXPORT extern const char Gyroscope[];
CORE_EXPORT extern const char Hid[];
CORE_EXPORT extern const char IdentityCredentialsGet[];
CORE_EXPORT extern const char IdleDetection[];
CORE_EXPORT extern const char InterestCohort[];
CORE_EXPORT extern const char JoinAdInterestGroup[];
CORE_EXPORT extern const char KeyboardMap[];
CORE_EXPORT extern const char LanguageDetector[];
CORE_EXPORT extern const char LanguageModel[];
CORE_EXPORT extern const char LocalFonts[];
CORE_EXPORT extern const char LocalNetworkAccess[];
CORE_EXPORT extern const char Magnetometer[];
CORE_EXPORT extern const char ManualText[];
CORE_EXPORT extern const char MediaPlaybackWhileNotVisible[];
CORE_EXPORT extern const char Microphone[];
CORE_EXPORT extern const char Midi[];
CORE_EXPORT extern const char OnDeviceSpeechRecognition[];
CORE_EXPORT extern const char OtpCredentials[];
CORE_EXPORT extern const char Payment[];
CORE_EXPORT extern const char PictureInPicture[];
CORE_EXPORT extern const char PrivateAggregation[];
CORE_EXPORT extern const char PrivateStateTokenIssuance[];
CORE_EXPORT extern const char PrivateStateTokenRedemption[];
CORE_EXPORT extern const char PublickeyCredentialsCreate[];
CORE_EXPORT extern const char PublickeyCredentialsGet[];
CORE_EXPORT extern const char RecordAdAuctionEvents[];
CORE_EXPORT extern const char Rewriter[];
CORE_EXPORT extern const char RunAdAuction[];
CORE_EXPORT extern const char ScreenWakeLock[];
CORE_EXPORT extern const char Serial[];
CORE_EXPORT extern const char SharedStorage[];
CORE_EXPORT extern const char SharedStorageSelectUrl[];
CORE_EXPORT extern const char SmartCard[];
CORE_EXPORT extern const char SpeakerSelection[];
CORE_EXPORT extern const char StorageAccess[];
CORE_EXPORT extern const char SubApps[];
CORE_EXPORT extern const char Summarizer[];
CORE_EXPORT extern const char SyncXhr[];
CORE_EXPORT extern const char Translator[];
CORE_EXPORT extern const char Unload[];
CORE_EXPORT extern const char Usb[];
CORE_EXPORT extern const char UsbUnrestricted[];
CORE_EXPORT extern const char VerticalScroll[];
CORE_EXPORT extern const char WebAppInstallation[];
CORE_EXPORT extern const char WebPrinting[];
CORE_EXPORT extern const char WebShare[];
CORE_EXPORT extern const char WindowManagement[];
CORE_EXPORT extern const char Writer[];
CORE_EXPORT extern const char XrSpatialTracking[];
} // namespace PermissionsPolicyFeatureEnum

namespace PermissionsPolicyBlockReasonEnum {
CORE_EXPORT extern const char Header[];
CORE_EXPORT extern const char IframeAttribute[];
CORE_EXPORT extern const char InFencedFrameTree[];
CORE_EXPORT extern const char InIsolatedApp[];
} // namespace PermissionsPolicyBlockReasonEnum

namespace OriginTrialTokenStatusEnum {
CORE_EXPORT extern const char Success[];
CORE_EXPORT extern const char NotSupported[];
CORE_EXPORT extern const char Insecure[];
CORE_EXPORT extern const char Expired[];
CORE_EXPORT extern const char WrongOrigin[];
CORE_EXPORT extern const char InvalidSignature[];
CORE_EXPORT extern const char Malformed[];
CORE_EXPORT extern const char WrongVersion[];
CORE_EXPORT extern const char FeatureDisabled[];
CORE_EXPORT extern const char TokenDisabled[];
CORE_EXPORT extern const char FeatureDisabledForUser[];
CORE_EXPORT extern const char UnknownTrial[];
} // namespace OriginTrialTokenStatusEnum

namespace OriginTrialStatusEnum {
CORE_EXPORT extern const char Enabled[];
CORE_EXPORT extern const char ValidTokenNotProvided[];
CORE_EXPORT extern const char OSNotSupported[];
CORE_EXPORT extern const char TrialNotAllowed[];
} // namespace OriginTrialStatusEnum

namespace OriginTrialUsageRestrictionEnum {
CORE_EXPORT extern const char None[];
CORE_EXPORT extern const char Subset[];
} // namespace OriginTrialUsageRestrictionEnum

namespace ClientNavigationReasonEnum {
CORE_EXPORT extern const char AnchorClick[];
CORE_EXPORT extern const char FormSubmissionGet[];
CORE_EXPORT extern const char FormSubmissionPost[];
CORE_EXPORT extern const char HttpHeaderRefresh[];
CORE_EXPORT extern const char InitialFrameNavigation[];
CORE_EXPORT extern const char MetaTagRefresh[];
CORE_EXPORT extern const char Other[];
CORE_EXPORT extern const char PageBlockInterstitial[];
CORE_EXPORT extern const char Reload[];
CORE_EXPORT extern const char ScriptInitiated[];
} // namespace ClientNavigationReasonEnum

namespace ClientNavigationDispositionEnum {
CORE_EXPORT extern const char CurrentTab[];
CORE_EXPORT extern const char NewTab[];
CORE_EXPORT extern const char NewWindow[];
CORE_EXPORT extern const char Download[];
} // namespace ClientNavigationDispositionEnum

namespace NavigationTypeEnum {
CORE_EXPORT extern const char Navigation[];
CORE_EXPORT extern const char BackForwardCacheRestore[];
} // namespace NavigationTypeEnum

namespace BackForwardCacheNotRestoredReasonEnum {
CORE_EXPORT extern const char NotPrimaryMainFrame[];
CORE_EXPORT extern const char BackForwardCacheDisabled[];
CORE_EXPORT extern const char RelatedActiveContentsExist[];
CORE_EXPORT extern const char HTTPStatusNotOK[];
CORE_EXPORT extern const char SchemeNotHTTPOrHTTPS[];
CORE_EXPORT extern const char Loading[];
CORE_EXPORT extern const char WasGrantedMediaAccess[];
CORE_EXPORT extern const char DisableForRenderFrameHostCalled[];
CORE_EXPORT extern const char DomainNotAllowed[];
CORE_EXPORT extern const char HTTPMethodNotGET[];
CORE_EXPORT extern const char SubframeIsNavigating[];
CORE_EXPORT extern const char Timeout[];
CORE_EXPORT extern const char CacheLimit[];
CORE_EXPORT extern const char JavaScriptExecution[];
CORE_EXPORT extern const char RendererProcessKilled[];
CORE_EXPORT extern const char RendererProcessCrashed[];
CORE_EXPORT extern const char SchedulerTrackedFeatureUsed[];
CORE_EXPORT extern const char ConflictingBrowsingInstance[];
CORE_EXPORT extern const char CacheFlushed[];
CORE_EXPORT extern const char ServiceWorkerVersionActivation[];
CORE_EXPORT extern const char SessionRestored[];
CORE_EXPORT extern const char ServiceWorkerPostMessage[];
CORE_EXPORT extern const char EnteredBackForwardCacheBeforeServiceWorkerHostAdded[];
CORE_EXPORT extern const char RenderFrameHostReused_SameSite[];
CORE_EXPORT extern const char RenderFrameHostReused_CrossSite[];
CORE_EXPORT extern const char ServiceWorkerClaim[];
CORE_EXPORT extern const char IgnoreEventAndEvict[];
CORE_EXPORT extern const char HaveInnerContents[];
CORE_EXPORT extern const char TimeoutPuttingInCache[];
CORE_EXPORT extern const char BackForwardCacheDisabledByLowMemory[];
CORE_EXPORT extern const char BackForwardCacheDisabledByCommandLine[];
CORE_EXPORT extern const char NetworkRequestDatapipeDrainedAsBytesConsumer[];
CORE_EXPORT extern const char NetworkRequestRedirected[];
CORE_EXPORT extern const char NetworkRequestTimeout[];
CORE_EXPORT extern const char NetworkExceedsBufferLimit[];
CORE_EXPORT extern const char NavigationCancelledWhileRestoring[];
CORE_EXPORT extern const char NotMostRecentNavigationEntry[];
CORE_EXPORT extern const char BackForwardCacheDisabledForPrerender[];
CORE_EXPORT extern const char UserAgentOverrideDiffers[];
CORE_EXPORT extern const char ForegroundCacheLimit[];
CORE_EXPORT extern const char BrowsingInstanceNotSwapped[];
CORE_EXPORT extern const char BackForwardCacheDisabledForDelegate[];
CORE_EXPORT extern const char UnloadHandlerExistsInMainFrame[];
CORE_EXPORT extern const char UnloadHandlerExistsInSubFrame[];
CORE_EXPORT extern const char ServiceWorkerUnregistration[];
CORE_EXPORT extern const char CacheControlNoStore[];
CORE_EXPORT extern const char CacheControlNoStoreCookieModified[];
CORE_EXPORT extern const char CacheControlNoStoreHTTPOnlyCookieModified[];
CORE_EXPORT extern const char NoResponseHead[];
CORE_EXPORT extern const char Unknown[];
CORE_EXPORT extern const char ActivationNavigationsDisallowedForBug1234857[];
CORE_EXPORT extern const char ErrorDocument[];
CORE_EXPORT extern const char FencedFramesEmbedder[];
CORE_EXPORT extern const char CookieDisabled[];
CORE_EXPORT extern const char HTTPAuthRequired[];
CORE_EXPORT extern const char CookieFlushed[];
CORE_EXPORT extern const char BroadcastChannelOnMessage[];
CORE_EXPORT extern const char WebViewSettingsChanged[];
CORE_EXPORT extern const char WebViewJavaScriptObjectChanged[];
CORE_EXPORT extern const char WebViewMessageListenerInjected[];
CORE_EXPORT extern const char WebViewSafeBrowsingAllowlistChanged[];
CORE_EXPORT extern const char WebViewDocumentStartJavascriptChanged[];
CORE_EXPORT extern const char WebSocket[];
CORE_EXPORT extern const char WebTransport[];
CORE_EXPORT extern const char WebRTC[];
CORE_EXPORT extern const char MainResourceHasCacheControlNoStore[];
CORE_EXPORT extern const char MainResourceHasCacheControlNoCache[];
CORE_EXPORT extern const char SubresourceHasCacheControlNoStore[];
CORE_EXPORT extern const char SubresourceHasCacheControlNoCache[];
CORE_EXPORT extern const char ContainsPlugins[];
CORE_EXPORT extern const char DocumentLoaded[];
CORE_EXPORT extern const char OutstandingNetworkRequestOthers[];
CORE_EXPORT extern const char RequestedMIDIPermission[];
CORE_EXPORT extern const char RequestedAudioCapturePermission[];
CORE_EXPORT extern const char RequestedVideoCapturePermission[];
CORE_EXPORT extern const char RequestedBackForwardCacheBlockedSensors[];
CORE_EXPORT extern const char RequestedBackgroundWorkPermission[];
CORE_EXPORT extern const char BroadcastChannel[];
CORE_EXPORT extern const char WebXR[];
CORE_EXPORT extern const char SharedWorker[];
CORE_EXPORT extern const char SharedWorkerMessage[];
CORE_EXPORT extern const char SharedWorkerWithNoActiveClient[];
CORE_EXPORT extern const char WebLocks[];
CORE_EXPORT extern const char WebHID[];
CORE_EXPORT extern const char WebBluetooth[];
CORE_EXPORT extern const char WebShare[];
CORE_EXPORT extern const char RequestedStorageAccessGrant[];
CORE_EXPORT extern const char WebNfc[];
CORE_EXPORT extern const char OutstandingNetworkRequestFetch[];
CORE_EXPORT extern const char OutstandingNetworkRequestXHR[];
CORE_EXPORT extern const char AppBanner[];
CORE_EXPORT extern const char Printing[];
CORE_EXPORT extern const char WebDatabase[];
CORE_EXPORT extern const char PictureInPicture[];
CORE_EXPORT extern const char SpeechRecognizer[];
CORE_EXPORT extern const char IdleManager[];
CORE_EXPORT extern const char PaymentManager[];
CORE_EXPORT extern const char SpeechSynthesis[];
CORE_EXPORT extern const char KeyboardLock[];
CORE_EXPORT extern const char WebOTPService[];
CORE_EXPORT extern const char OutstandingNetworkRequestDirectSocket[];
CORE_EXPORT extern const char InjectedJavascript[];
CORE_EXPORT extern const char InjectedStyleSheet[];
CORE_EXPORT extern const char KeepaliveRequest[];
CORE_EXPORT extern const char IndexedDBEvent[];
CORE_EXPORT extern const char Dummy[];
CORE_EXPORT extern const char JsNetworkRequestReceivedCacheControlNoStoreResource[];
CORE_EXPORT extern const char WebRTCUsedWithCCNS[];
CORE_EXPORT extern const char WebTransportUsedWithCCNS[];
CORE_EXPORT extern const char WebSocketUsedWithCCNS[];
CORE_EXPORT extern const char SmartCard[];
CORE_EXPORT extern const char LiveMediaStreamTrack[];
CORE_EXPORT extern const char UnloadHandler[];
CORE_EXPORT extern const char ParserAborted[];
CORE_EXPORT extern const char ContentSecurityHandler[];
CORE_EXPORT extern const char ContentWebAuthenticationAPI[];
CORE_EXPORT extern const char ContentFileChooser[];
CORE_EXPORT extern const char ContentSerial[];
CORE_EXPORT extern const char ContentFileSystemAccess[];
CORE_EXPORT extern const char ContentMediaDevicesDispatcherHost[];
CORE_EXPORT extern const char ContentWebBluetooth[];
CORE_EXPORT extern const char ContentWebUSB[];
CORE_EXPORT extern const char ContentMediaSessionService[];
CORE_EXPORT extern const char ContentScreenReader[];
CORE_EXPORT extern const char ContentDiscarded[];
CORE_EXPORT extern const char EmbedderPopupBlockerTabHelper[];
CORE_EXPORT extern const char EmbedderSafeBrowsingTriggeredPopupBlocker[];
CORE_EXPORT extern const char EmbedderSafeBrowsingThreatDetails[];
CORE_EXPORT extern const char EmbedderAppBannerManager[];
CORE_EXPORT extern const char EmbedderDomDistillerViewerSource[];
CORE_EXPORT extern const char EmbedderDomDistillerSelfDeletingRequestDelegate[];
CORE_EXPORT extern const char EmbedderOomInterventionTabHelper[];
CORE_EXPORT extern const char EmbedderOfflinePage[];
CORE_EXPORT extern const char EmbedderChromePasswordManagerClientBindCredentialManager[];
CORE_EXPORT extern const char EmbedderPermissionRequestManager[];
CORE_EXPORT extern const char EmbedderModalDialog[];
CORE_EXPORT extern const char EmbedderExtensions[];
CORE_EXPORT extern const char EmbedderExtensionMessaging[];
CORE_EXPORT extern const char EmbedderExtensionMessagingForOpenPort[];
CORE_EXPORT extern const char EmbedderExtensionSentMessageToCachedFrame[];
CORE_EXPORT extern const char RequestedByWebViewClient[];
CORE_EXPORT extern const char PostMessageByWebViewClient[];
CORE_EXPORT extern const char CacheControlNoStoreDeviceBoundSessionTerminated[];
CORE_EXPORT extern const char CacheLimitPrunedOnModerateMemoryPressure[];
CORE_EXPORT extern const char CacheLimitPrunedOnCriticalMemoryPressure[];
} // namespace BackForwardCacheNotRestoredReasonEnum

namespace BackForwardCacheNotRestoredReasonTypeEnum {
CORE_EXPORT extern const char SupportPending[];
CORE_EXPORT extern const char PageSupportNeeded[];
CORE_EXPORT extern const char Circumstantial[];
} // namespace BackForwardCacheNotRestoredReasonTypeEnum

namespace CaptureScreenshot {
namespace FormatEnum {
CORE_EXPORT extern const char* Jpeg;
CORE_EXPORT extern const char* Png;
CORE_EXPORT extern const char* Webp;
} // FormatEnum
} // CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
CORE_EXPORT extern const char* Mhtml;
} // FormatEnum
} // CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
CORE_EXPORT extern const char* ReturnAsBase64;
CORE_EXPORT extern const char* ReturnAsStream;
} // TransferModeEnum
} // PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
CORE_EXPORT extern const char* Deny;
CORE_EXPORT extern const char* Allow;
CORE_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
CORE_EXPORT extern const char* Mobile;
CORE_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
CORE_EXPORT extern const char* Jpeg;
CORE_EXPORT extern const char* Png;
} // FormatEnum
} // StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
CORE_EXPORT extern const char* Frozen;
CORE_EXPORT extern const char* Active;
} // StateEnum
} // SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
CORE_EXPORT extern const char* None;
CORE_EXPORT extern const char* AutoAccept;
CORE_EXPORT extern const char* AutoChooseToAuthAnotherWay;
CORE_EXPORT extern const char* AutoReject;
CORE_EXPORT extern const char* AutoOptOut;
} // ModeEnum
} // SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
CORE_EXPORT extern const char* None;
CORE_EXPORT extern const char* AutoAccept;
CORE_EXPORT extern const char* AutoReject;
} // ModeEnum
} // SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
CORE_EXPORT extern const char* SelectSingle;
CORE_EXPORT extern const char* SelectMultiple;
} // ModeEnum
} // FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
CORE_EXPORT extern const char* Remove;
CORE_EXPORT extern const char* Swap;
} // ReasonEnum
} // FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
CORE_EXPORT extern const char* Reload;
CORE_EXPORT extern const char* ReloadBypassingCache;
CORE_EXPORT extern const char* Restore;
CORE_EXPORT extern const char* RestoreWithPost;
CORE_EXPORT extern const char* HistorySameDocument;
CORE_EXPORT extern const char* HistoryDifferentDocument;
CORE_EXPORT extern const char* SameDocument;
CORE_EXPORT extern const char* DifferentDocument;
} // NavigationTypeEnum
} // FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
CORE_EXPORT extern const char* InProgress;
CORE_EXPORT extern const char* Completed;
CORE_EXPORT extern const char* Canceled;
} // StateEnum
} // DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
CORE_EXPORT extern const char* Fragment;
CORE_EXPORT extern const char* HistoryApi;
CORE_EXPORT extern const char* Other;
} // NavigationTypeEnum
} // NavigatedWithinDocument

// ------------- Type and builder declarations.

class CORE_EXPORT AdFrameStatus : public ::crdtp::ProtocolObject<AdFrameStatus> {
public:
    ~AdFrameStatus() override;  // Defined below

    String getAdFrameType() { return m_adFrameType; }
    void setAdFrameType(const String& value);  // Defined below

    bool hasExplanations() { return !!m_explanations; }
    protocol::Array<String>* getExplanations(protocol::Array<String>* defaultValue) {
       return m_explanations ? m_explanations.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getExplanations() const {
       return m_explanations;
    }
    void setExplanations(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class AdFrameStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AdFrameTypeSet = 1 << 1,
            AllFieldsSet = (AdFrameTypeSet | 0)};


        AdFrameStatusBuilder<STATE | AdFrameTypeSet>& setAdFrameType(const String& value);  // Defined below

        AdFrameStatusBuilder<STATE>& setExplanations(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<AdFrameStatus> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AdFrameStatus;
        AdFrameStatusBuilder() : m_result(new AdFrameStatus()) { }

        template<int STEP> AdFrameStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AdFrameStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AdFrameStatus> m_result;
    };

    static AdFrameStatusBuilder<0> create()
    {
        return AdFrameStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AdFrameStatus();  // Defined below

    String m_adFrameType;
    std::unique_ptr<protocol::Array<String>> m_explanations;
};


class CORE_EXPORT AdScriptId : public ::crdtp::ProtocolObject<AdScriptId> {
public:
    ~AdScriptId() override;  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    String getDebuggerId() { return m_debuggerId; }
    void setDebuggerId(const String& value);  // Defined below

    template<int STATE>
    class AdScriptIdBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScriptIdSet = 1 << 1,
            DebuggerIdSet = 1 << 2,
            AllFieldsSet = (ScriptIdSet | DebuggerIdSet | 0)};


        AdScriptIdBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        AdScriptIdBuilder<STATE | DebuggerIdSet>& setDebuggerId(const String& value);  // Defined below

        std::unique_ptr<AdScriptId> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AdScriptId;
        AdScriptIdBuilder() : m_result(new AdScriptId()) { }

        template<int STEP> AdScriptIdBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AdScriptIdBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AdScriptId> m_result;
    };

    static AdScriptIdBuilder<0> create()
    {
        return AdScriptIdBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AdScriptId();  // Defined below

    String m_scriptId;
    String m_debuggerId;
};


class CORE_EXPORT AdScriptAncestry : public ::crdtp::ProtocolObject<AdScriptAncestry> {
public:
    ~AdScriptAncestry() override;  // Defined below

    protocol::Array<protocol::Page::AdScriptId>* getAncestryChain() { return m_ancestryChain.get(); }
    void setAncestryChain(std::unique_ptr<protocol::Array<protocol::Page::AdScriptId>> value);  // Defined below

    bool hasRootScriptFilterlistRule() { return !!m_rootScriptFilterlistRule; }
    String getRootScriptFilterlistRule(const String& defaultValue) const {
       return m_rootScriptFilterlistRule.value_or(defaultValue);
    }
    const std::optional<String>& getRootScriptFilterlistRule() const {
       return m_rootScriptFilterlistRule;
    }
    void setRootScriptFilterlistRule(const String& value);  // Defined below

    template<int STATE>
    class AdScriptAncestryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AncestryChainSet = 1 << 1,
            AllFieldsSet = (AncestryChainSet | 0)};


        AdScriptAncestryBuilder<STATE | AncestryChainSet>& setAncestryChain(std::unique_ptr<protocol::Array<protocol::Page::AdScriptId>> value);  // Defined below

        AdScriptAncestryBuilder<STATE>& setRootScriptFilterlistRule(const String& value);  // Defined below

        std::unique_ptr<AdScriptAncestry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AdScriptAncestry;
        AdScriptAncestryBuilder() : m_result(new AdScriptAncestry()) { }

        template<int STEP> AdScriptAncestryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AdScriptAncestryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::AdScriptAncestry> m_result;
    };

    static AdScriptAncestryBuilder<0> create()
    {
        return AdScriptAncestryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AdScriptAncestry();  // Defined below

    std::unique_ptr<protocol::Array<protocol::Page::AdScriptId>> m_ancestryChain;
    std::optional<String> m_rootScriptFilterlistRule;
};


class CORE_EXPORT PermissionsPolicyBlockLocator : public ::crdtp::ProtocolObject<PermissionsPolicyBlockLocator> {
public:
    ~PermissionsPolicyBlockLocator() override;  // Defined below

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value);  // Defined below

    String getBlockReason() { return m_blockReason; }
    void setBlockReason(const String& value);  // Defined below

    template<int STATE>
    class PermissionsPolicyBlockLocatorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            BlockReasonSet = 1 << 2,
            AllFieldsSet = (FrameIdSet | BlockReasonSet | 0)};


        PermissionsPolicyBlockLocatorBuilder<STATE | FrameIdSet>& setFrameId(const String& value);  // Defined below

        PermissionsPolicyBlockLocatorBuilder<STATE | BlockReasonSet>& setBlockReason(const String& value);  // Defined below

        std::unique_ptr<PermissionsPolicyBlockLocator> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PermissionsPolicyBlockLocator;
        PermissionsPolicyBlockLocatorBuilder() : m_result(new PermissionsPolicyBlockLocator()) { }

        template<int STEP> PermissionsPolicyBlockLocatorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PermissionsPolicyBlockLocatorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator> m_result;
    };

    static PermissionsPolicyBlockLocatorBuilder<0> create()
    {
        return PermissionsPolicyBlockLocatorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PermissionsPolicyBlockLocator();  // Defined below

    String m_frameId;
    String m_blockReason;
};


class CORE_EXPORT PermissionsPolicyFeatureState : public ::crdtp::ProtocolObject<PermissionsPolicyFeatureState> {
public:
    ~PermissionsPolicyFeatureState() override;  // Defined below

    String getFeature() { return m_feature; }
    void setFeature(const String& value);  // Defined below

    bool getAllowed() { return m_allowed; }
    void setAllowed(bool value);  // Defined below

    bool hasLocator() { return !!m_locator; }
    protocol::Page::PermissionsPolicyBlockLocator* getLocator(protocol::Page::PermissionsPolicyBlockLocator* defaultValue) {
       return m_locator ? m_locator.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator>& getLocator() const {
       return m_locator;
    }
    void setLocator(std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator> value);  // Defined below

    template<int STATE>
    class PermissionsPolicyFeatureStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FeatureSet = 1 << 1,
            AllowedSet = 1 << 2,
            AllFieldsSet = (FeatureSet | AllowedSet | 0)};


        PermissionsPolicyFeatureStateBuilder<STATE | FeatureSet>& setFeature(const String& value);  // Defined below

        PermissionsPolicyFeatureStateBuilder<STATE | AllowedSet>& setAllowed(bool value);  // Defined below

        PermissionsPolicyFeatureStateBuilder<STATE>& setLocator(std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator> value);  // Defined below

        std::unique_ptr<PermissionsPolicyFeatureState> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PermissionsPolicyFeatureState;
        PermissionsPolicyFeatureStateBuilder() : m_result(new PermissionsPolicyFeatureState()) { }

        template<int STEP> PermissionsPolicyFeatureStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PermissionsPolicyFeatureStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::PermissionsPolicyFeatureState> m_result;
    };

    static PermissionsPolicyFeatureStateBuilder<0> create()
    {
        return PermissionsPolicyFeatureStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PermissionsPolicyFeatureState();  // Defined below

    String m_feature;
    bool m_allowed;
    std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator> m_locator;
};


class CORE_EXPORT OriginTrialToken : public ::crdtp::ProtocolObject<OriginTrialToken> {
public:
    ~OriginTrialToken() override;  // Defined below

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value);  // Defined below

    bool getMatchSubDomains() { return m_matchSubDomains; }
    void setMatchSubDomains(bool value);  // Defined below

    String getTrialName() { return m_trialName; }
    void setTrialName(const String& value);  // Defined below

    double getExpiryTime() { return m_expiryTime; }
    void setExpiryTime(double value);  // Defined below

    bool getIsThirdParty() { return m_isThirdParty; }
    void setIsThirdParty(bool value);  // Defined below

    String getUsageRestriction() { return m_usageRestriction; }
    void setUsageRestriction(const String& value);  // Defined below

    template<int STATE>
    class OriginTrialTokenBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            MatchSubDomainsSet = 1 << 2,
            TrialNameSet = 1 << 3,
            ExpiryTimeSet = 1 << 4,
            IsThirdPartySet = 1 << 5,
            UsageRestrictionSet = 1 << 6,
            AllFieldsSet = (OriginSet | MatchSubDomainsSet | TrialNameSet | ExpiryTimeSet | IsThirdPartySet | UsageRestrictionSet | 0)};


        OriginTrialTokenBuilder<STATE | OriginSet>& setOrigin(const String& value);  // Defined below

        OriginTrialTokenBuilder<STATE | MatchSubDomainsSet>& setMatchSubDomains(bool value);  // Defined below

        OriginTrialTokenBuilder<STATE | TrialNameSet>& setTrialName(const String& value);  // Defined below

        OriginTrialTokenBuilder<STATE | ExpiryTimeSet>& setExpiryTime(double value);  // Defined below

        OriginTrialTokenBuilder<STATE | IsThirdPartySet>& setIsThirdParty(bool value);  // Defined below

        OriginTrialTokenBuilder<STATE | UsageRestrictionSet>& setUsageRestriction(const String& value);  // Defined below

        std::unique_ptr<OriginTrialToken> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class OriginTrialToken;
        OriginTrialTokenBuilder() : m_result(new OriginTrialToken()) { }

        template<int STEP> OriginTrialTokenBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<OriginTrialTokenBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::OriginTrialToken> m_result;
    };

    static OriginTrialTokenBuilder<0> create()
    {
        return OriginTrialTokenBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    OriginTrialToken();  // Defined below

    String m_origin;
    bool m_matchSubDomains;
    String m_trialName;
    double m_expiryTime;
    bool m_isThirdParty;
    String m_usageRestriction;
};


class CORE_EXPORT OriginTrialTokenWithStatus : public ::crdtp::ProtocolObject<OriginTrialTokenWithStatus> {
public:
    ~OriginTrialTokenWithStatus() override;  // Defined below

    String getRawTokenText() { return m_rawTokenText; }
    void setRawTokenText(const String& value);  // Defined below

    bool hasParsedToken() { return !!m_parsedToken; }
    protocol::Page::OriginTrialToken* getParsedToken(protocol::Page::OriginTrialToken* defaultValue) {
       return m_parsedToken ? m_parsedToken.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Page::OriginTrialToken>& getParsedToken() const {
       return m_parsedToken;
    }
    void setParsedToken(std::unique_ptr<protocol::Page::OriginTrialToken> value);  // Defined below

    String getStatus() { return m_status; }
    void setStatus(const String& value);  // Defined below

    template<int STATE>
    class OriginTrialTokenWithStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RawTokenTextSet = 1 << 1,
            StatusSet = 1 << 2,
            AllFieldsSet = (RawTokenTextSet | StatusSet | 0)};


        OriginTrialTokenWithStatusBuilder<STATE | RawTokenTextSet>& setRawTokenText(const String& value);  // Defined below

        OriginTrialTokenWithStatusBuilder<STATE>& setParsedToken(std::unique_ptr<protocol::Page::OriginTrialToken> value);  // Defined below

        OriginTrialTokenWithStatusBuilder<STATE | StatusSet>& setStatus(const String& value);  // Defined below

        std::unique_ptr<OriginTrialTokenWithStatus> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class OriginTrialTokenWithStatus;
        OriginTrialTokenWithStatusBuilder() : m_result(new OriginTrialTokenWithStatus()) { }

        template<int STEP> OriginTrialTokenWithStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<OriginTrialTokenWithStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::OriginTrialTokenWithStatus> m_result;
    };

    static OriginTrialTokenWithStatusBuilder<0> create()
    {
        return OriginTrialTokenWithStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    OriginTrialTokenWithStatus();  // Defined below

    String m_rawTokenText;
    std::unique_ptr<protocol::Page::OriginTrialToken> m_parsedToken;
    String m_status;
};


class CORE_EXPORT OriginTrial : public ::crdtp::ProtocolObject<OriginTrial> {
public:
    ~OriginTrial() override;  // Defined below

    String getTrialName() { return m_trialName; }
    void setTrialName(const String& value);  // Defined below

    String getStatus() { return m_status; }
    void setStatus(const String& value);  // Defined below

    protocol::Array<protocol::Page::OriginTrialTokenWithStatus>* getTokensWithStatus() { return m_tokensWithStatus.get(); }
    void setTokensWithStatus(std::unique_ptr<protocol::Array<protocol::Page::OriginTrialTokenWithStatus>> value);  // Defined below

    template<int STATE>
    class OriginTrialBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TrialNameSet = 1 << 1,
            StatusSet = 1 << 2,
            TokensWithStatusSet = 1 << 3,
            AllFieldsSet = (TrialNameSet | StatusSet | TokensWithStatusSet | 0)};


        OriginTrialBuilder<STATE | TrialNameSet>& setTrialName(const String& value);  // Defined below

        OriginTrialBuilder<STATE | StatusSet>& setStatus(const String& value);  // Defined below

        OriginTrialBuilder<STATE | TokensWithStatusSet>& setTokensWithStatus(std::unique_ptr<protocol::Array<protocol::Page::OriginTrialTokenWithStatus>> value);  // Defined below

        std::unique_ptr<OriginTrial> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class OriginTrial;
        OriginTrialBuilder() : m_result(new OriginTrial()) { }

        template<int STEP> OriginTrialBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<OriginTrialBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::OriginTrial> m_result;
    };

    static OriginTrialBuilder<0> create()
    {
        return OriginTrialBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    OriginTrial();  // Defined below

    String m_trialName;
    String m_status;
    std::unique_ptr<protocol::Array<protocol::Page::OriginTrialTokenWithStatus>> m_tokensWithStatus;
};


class CORE_EXPORT SecurityOriginDetails : public ::crdtp::ProtocolObject<SecurityOriginDetails> {
public:
    ~SecurityOriginDetails() override;  // Defined below

    bool getIsLocalhost() { return m_isLocalhost; }
    void setIsLocalhost(bool value);  // Defined below

    template<int STATE>
    class SecurityOriginDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsLocalhostSet = 1 << 1,
            AllFieldsSet = (IsLocalhostSet | 0)};


        SecurityOriginDetailsBuilder<STATE | IsLocalhostSet>& setIsLocalhost(bool value);  // Defined below

        std::unique_ptr<SecurityOriginDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityOriginDetails;
        SecurityOriginDetailsBuilder() : m_result(new SecurityOriginDetails()) { }

        template<int STEP> SecurityOriginDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityOriginDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::SecurityOriginDetails> m_result;
    };

    static SecurityOriginDetailsBuilder<0> create()
    {
        return SecurityOriginDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityOriginDetails();  // Defined below

    bool m_isLocalhost;
};


class CORE_EXPORT Frame : public ::crdtp::ProtocolObject<Frame> {
public:
    ~Frame() override;  // Defined below

    String getId() { return m_id; }
    void setId(const String& value);  // Defined below

    bool hasParentId() { return !!m_parentId; }
    String getParentId(const String& defaultValue) const {
       return m_parentId.value_or(defaultValue);
    }
    const std::optional<String>& getParentId() const {
       return m_parentId;
    }
    void setParentId(const String& value);  // Defined below

    String getLoaderId() { return m_loaderId; }
    void setLoaderId(const String& value);  // Defined below

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    bool hasUrlFragment() { return !!m_urlFragment; }
    String getUrlFragment(const String& defaultValue) const {
       return m_urlFragment.value_or(defaultValue);
    }
    const std::optional<String>& getUrlFragment() const {
       return m_urlFragment;
    }
    void setUrlFragment(const String& value);  // Defined below

    String getDomainAndRegistry() { return m_domainAndRegistry; }
    void setDomainAndRegistry(const String& value);  // Defined below

    String getSecurityOrigin() { return m_securityOrigin; }
    void setSecurityOrigin(const String& value);  // Defined below

    bool hasSecurityOriginDetails() { return !!m_securityOriginDetails; }
    protocol::Page::SecurityOriginDetails* getSecurityOriginDetails(protocol::Page::SecurityOriginDetails* defaultValue) {
       return m_securityOriginDetails ? m_securityOriginDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Page::SecurityOriginDetails>& getSecurityOriginDetails() const {
       return m_securityOriginDetails;
    }
    void setSecurityOriginDetails(std::unique_ptr<protocol::Page::SecurityOriginDetails> value);  // Defined below

    String getMimeType() { return m_mimeType; }
    void setMimeType(const String& value);  // Defined below

    bool hasUnreachableUrl() { return !!m_unreachableUrl; }
    String getUnreachableUrl(const String& defaultValue) const {
       return m_unreachableUrl.value_or(defaultValue);
    }
    const std::optional<String>& getUnreachableUrl() const {
       return m_unreachableUrl;
    }
    void setUnreachableUrl(const String& value);  // Defined below

    bool hasAdFrameStatus() { return !!m_adFrameStatus; }
    protocol::Page::AdFrameStatus* getAdFrameStatus(protocol::Page::AdFrameStatus* defaultValue) {
       return m_adFrameStatus ? m_adFrameStatus.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Page::AdFrameStatus>& getAdFrameStatus() const {
       return m_adFrameStatus;
    }
    void setAdFrameStatus(std::unique_ptr<protocol::Page::AdFrameStatus> value);  // Defined below

    String getSecureContextType() { return m_secureContextType; }
    void setSecureContextType(const String& value);  // Defined below

    String getCrossOriginIsolatedContextType() { return m_crossOriginIsolatedContextType; }
    void setCrossOriginIsolatedContextType(const String& value);  // Defined below

    protocol::Array<String>* getGatedAPIFeatures() { return m_gatedAPIFeatures.get(); }
    void setGatedAPIFeatures(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class FrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            LoaderIdSet = 1 << 2,
            UrlSet = 1 << 3,
            DomainAndRegistrySet = 1 << 4,
            SecurityOriginSet = 1 << 5,
            MimeTypeSet = 1 << 6,
            SecureContextTypeSet = 1 << 7,
            CrossOriginIsolatedContextTypeSet = 1 << 8,
            GatedAPIFeaturesSet = 1 << 9,
            AllFieldsSet = (IdSet | LoaderIdSet | UrlSet | DomainAndRegistrySet | SecurityOriginSet | MimeTypeSet | SecureContextTypeSet | CrossOriginIsolatedContextTypeSet | GatedAPIFeaturesSet | 0)};


        FrameBuilder<STATE | IdSet>& setId(const String& value);  // Defined below

        FrameBuilder<STATE>& setParentId(const String& value);  // Defined below

        FrameBuilder<STATE | LoaderIdSet>& setLoaderId(const String& value);  // Defined below

        FrameBuilder<STATE>& setName(const String& value);  // Defined below

        FrameBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        FrameBuilder<STATE>& setUrlFragment(const String& value);  // Defined below

        FrameBuilder<STATE | DomainAndRegistrySet>& setDomainAndRegistry(const String& value);  // Defined below

        FrameBuilder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value);  // Defined below

        FrameBuilder<STATE>& setSecurityOriginDetails(std::unique_ptr<protocol::Page::SecurityOriginDetails> value);  // Defined below

        FrameBuilder<STATE | MimeTypeSet>& setMimeType(const String& value);  // Defined below

        FrameBuilder<STATE>& setUnreachableUrl(const String& value);  // Defined below

        FrameBuilder<STATE>& setAdFrameStatus(std::unique_ptr<protocol::Page::AdFrameStatus> value);  // Defined below

        FrameBuilder<STATE | SecureContextTypeSet>& setSecureContextType(const String& value);  // Defined below

        FrameBuilder<STATE | CrossOriginIsolatedContextTypeSet>& setCrossOriginIsolatedContextType(const String& value);  // Defined below

        FrameBuilder<STATE | GatedAPIFeaturesSet>& setGatedAPIFeatures(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<Frame> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Frame;
        FrameBuilder() : m_result(new Frame()) { }

        template<int STEP> FrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::Frame> m_result;
    };

    static FrameBuilder<0> create()
    {
        return FrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Frame();  // Defined below

    String m_id;
    std::optional<String> m_parentId;
    String m_loaderId;
    std::optional<String> m_name;
    String m_url;
    std::optional<String> m_urlFragment;
    String m_domainAndRegistry;
    String m_securityOrigin;
    std::unique_ptr<protocol::Page::SecurityOriginDetails> m_securityOriginDetails;
    String m_mimeType;
    std::optional<String> m_unreachableUrl;
    std::unique_ptr<protocol::Page::AdFrameStatus> m_adFrameStatus;
    String m_secureContextType;
    String m_crossOriginIsolatedContextType;
    std::unique_ptr<protocol::Array<String>> m_gatedAPIFeatures;
};


class CORE_EXPORT FrameResource : public ::crdtp::ProtocolObject<FrameResource> {
public:
    ~FrameResource() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    String getMimeType() { return m_mimeType; }
    void setMimeType(const String& value);  // Defined below

    bool hasLastModified() { return !!m_lastModified; }
    double getLastModified(double defaultValue) const {
       return m_lastModified.value_or(defaultValue);
    }
    const std::optional<double>& getLastModified() const {
       return m_lastModified;
    }
    void setLastModified(double value);  // Defined below

    bool hasContentSize() { return !!m_contentSize; }
    double getContentSize(double defaultValue) const {
       return m_contentSize.value_or(defaultValue);
    }
    const std::optional<double>& getContentSize() const {
       return m_contentSize;
    }
    void setContentSize(double value);  // Defined below

    bool hasFailed() { return !!m_failed; }
    bool getFailed(bool defaultValue) const {
       return m_failed.value_or(defaultValue);
    }
    const std::optional<bool>& getFailed() const {
       return m_failed;
    }
    void setFailed(bool value);  // Defined below

    bool hasCanceled() { return !!m_canceled; }
    bool getCanceled(bool defaultValue) const {
       return m_canceled.value_or(defaultValue);
    }
    const std::optional<bool>& getCanceled() const {
       return m_canceled;
    }
    void setCanceled(bool value);  // Defined below

    template<int STATE>
    class FrameResourceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            TypeSet = 1 << 2,
            MimeTypeSet = 1 << 3,
            AllFieldsSet = (UrlSet | TypeSet | MimeTypeSet | 0)};


        FrameResourceBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        FrameResourceBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        FrameResourceBuilder<STATE | MimeTypeSet>& setMimeType(const String& value);  // Defined below

        FrameResourceBuilder<STATE>& setLastModified(double value);  // Defined below

        FrameResourceBuilder<STATE>& setContentSize(double value);  // Defined below

        FrameResourceBuilder<STATE>& setFailed(bool value);  // Defined below

        FrameResourceBuilder<STATE>& setCanceled(bool value);  // Defined below

        std::unique_ptr<FrameResource> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FrameResource;
        FrameResourceBuilder() : m_result(new FrameResource()) { }

        template<int STEP> FrameResourceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FrameResourceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FrameResource> m_result;
    };

    static FrameResourceBuilder<0> create()
    {
        return FrameResourceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FrameResource();  // Defined below

    String m_url;
    String m_type;
    String m_mimeType;
    std::optional<double> m_lastModified;
    std::optional<double> m_contentSize;
    std::optional<bool> m_failed;
    std::optional<bool> m_canceled;
};


class CORE_EXPORT FrameResourceTree : public ::crdtp::ProtocolObject<FrameResourceTree> {
public:
    ~FrameResourceTree() override;  // Defined below

    protocol::Page::Frame* getFrame() { return m_frame.get(); }
    void setFrame(std::unique_ptr<protocol::Page::Frame> value);  // Defined below

    bool hasChildFrames() { return !!m_childFrames; }
    protocol::Array<protocol::Page::FrameResourceTree>* getChildFrames(protocol::Array<protocol::Page::FrameResourceTree>* defaultValue) {
       return m_childFrames ? m_childFrames.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::FrameResourceTree>>& getChildFrames() const {
       return m_childFrames;
    }
    void setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameResourceTree>> value);  // Defined below

    protocol::Array<protocol::Page::FrameResource>* getResources() { return m_resources.get(); }
    void setResources(std::unique_ptr<protocol::Array<protocol::Page::FrameResource>> value);  // Defined below

    template<int STATE>
    class FrameResourceTreeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameSet = 1 << 1,
            ResourcesSet = 1 << 2,
            AllFieldsSet = (FrameSet | ResourcesSet | 0)};


        FrameResourceTreeBuilder<STATE | FrameSet>& setFrame(std::unique_ptr<protocol::Page::Frame> value);  // Defined below

        FrameResourceTreeBuilder<STATE>& setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameResourceTree>> value);  // Defined below

        FrameResourceTreeBuilder<STATE | ResourcesSet>& setResources(std::unique_ptr<protocol::Array<protocol::Page::FrameResource>> value);  // Defined below

        std::unique_ptr<FrameResourceTree> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FrameResourceTree;
        FrameResourceTreeBuilder() : m_result(new FrameResourceTree()) { }

        template<int STEP> FrameResourceTreeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FrameResourceTreeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FrameResourceTree> m_result;
    };

    static FrameResourceTreeBuilder<0> create()
    {
        return FrameResourceTreeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FrameResourceTree();  // Defined below

    std::unique_ptr<protocol::Page::Frame> m_frame;
    std::unique_ptr<protocol::Array<protocol::Page::FrameResourceTree>> m_childFrames;
    std::unique_ptr<protocol::Array<protocol::Page::FrameResource>> m_resources;
};


class CORE_EXPORT FrameTree : public ::crdtp::ProtocolObject<FrameTree> {
public:
    ~FrameTree() override;  // Defined below

    protocol::Page::Frame* getFrame() { return m_frame.get(); }
    void setFrame(std::unique_ptr<protocol::Page::Frame> value);  // Defined below

    bool hasChildFrames() { return !!m_childFrames; }
    protocol::Array<protocol::Page::FrameTree>* getChildFrames(protocol::Array<protocol::Page::FrameTree>* defaultValue) {
       return m_childFrames ? m_childFrames.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::FrameTree>>& getChildFrames() const {
       return m_childFrames;
    }
    void setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameTree>> value);  // Defined below

    template<int STATE>
    class FrameTreeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameSet = 1 << 1,
            AllFieldsSet = (FrameSet | 0)};


        FrameTreeBuilder<STATE | FrameSet>& setFrame(std::unique_ptr<protocol::Page::Frame> value);  // Defined below

        FrameTreeBuilder<STATE>& setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameTree>> value);  // Defined below

        std::unique_ptr<FrameTree> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FrameTree;
        FrameTreeBuilder() : m_result(new FrameTree()) { }

        template<int STEP> FrameTreeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FrameTreeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FrameTree> m_result;
    };

    static FrameTreeBuilder<0> create()
    {
        return FrameTreeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FrameTree();  // Defined below

    std::unique_ptr<protocol::Page::Frame> m_frame;
    std::unique_ptr<protocol::Array<protocol::Page::FrameTree>> m_childFrames;
};


class CORE_EXPORT LayoutViewport : public ::crdtp::ProtocolObject<LayoutViewport> {
public:
    ~LayoutViewport() override;  // Defined below

    int getPageX() { return m_pageX; }
    void setPageX(int value);  // Defined below

    int getPageY() { return m_pageY; }
    void setPageY(int value);  // Defined below

    int getClientWidth() { return m_clientWidth; }
    void setClientWidth(int value);  // Defined below

    int getClientHeight() { return m_clientHeight; }
    void setClientHeight(int value);  // Defined below

    template<int STATE>
    class LayoutViewportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PageXSet = 1 << 1,
            PageYSet = 1 << 2,
            ClientWidthSet = 1 << 3,
            ClientHeightSet = 1 << 4,
            AllFieldsSet = (PageXSet | PageYSet | ClientWidthSet | ClientHeightSet | 0)};


        LayoutViewportBuilder<STATE | PageXSet>& setPageX(int value);  // Defined below

        LayoutViewportBuilder<STATE | PageYSet>& setPageY(int value);  // Defined below

        LayoutViewportBuilder<STATE | ClientWidthSet>& setClientWidth(int value);  // Defined below

        LayoutViewportBuilder<STATE | ClientHeightSet>& setClientHeight(int value);  // Defined below

        std::unique_ptr<LayoutViewport> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LayoutViewport;
        LayoutViewportBuilder() : m_result(new LayoutViewport()) { }

        template<int STEP> LayoutViewportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LayoutViewportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::LayoutViewport> m_result;
    };

    static LayoutViewportBuilder<0> create()
    {
        return LayoutViewportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LayoutViewport();  // Defined below

    int m_pageX;
    int m_pageY;
    int m_clientWidth;
    int m_clientHeight;
};


class CORE_EXPORT VisualViewport : public ::crdtp::ProtocolObject<VisualViewport> {
public:
    ~VisualViewport() override;  // Defined below

    double getOffsetX() { return m_offsetX; }
    void setOffsetX(double value);  // Defined below

    double getOffsetY() { return m_offsetY; }
    void setOffsetY(double value);  // Defined below

    double getPageX() { return m_pageX; }
    void setPageX(double value);  // Defined below

    double getPageY() { return m_pageY; }
    void setPageY(double value);  // Defined below

    double getClientWidth() { return m_clientWidth; }
    void setClientWidth(double value);  // Defined below

    double getClientHeight() { return m_clientHeight; }
    void setClientHeight(double value);  // Defined below

    double getScale() { return m_scale; }
    void setScale(double value);  // Defined below

    bool hasZoom() { return !!m_zoom; }
    double getZoom(double defaultValue) const {
       return m_zoom.value_or(defaultValue);
    }
    const std::optional<double>& getZoom() const {
       return m_zoom;
    }
    void setZoom(double value);  // Defined below

    template<int STATE>
    class VisualViewportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OffsetXSet = 1 << 1,
            OffsetYSet = 1 << 2,
            PageXSet = 1 << 3,
            PageYSet = 1 << 4,
            ClientWidthSet = 1 << 5,
            ClientHeightSet = 1 << 6,
            ScaleSet = 1 << 7,
            AllFieldsSet = (OffsetXSet | OffsetYSet | PageXSet | PageYSet | ClientWidthSet | ClientHeightSet | ScaleSet | 0)};


        VisualViewportBuilder<STATE | OffsetXSet>& setOffsetX(double value);  // Defined below

        VisualViewportBuilder<STATE | OffsetYSet>& setOffsetY(double value);  // Defined below

        VisualViewportBuilder<STATE | PageXSet>& setPageX(double value);  // Defined below

        VisualViewportBuilder<STATE | PageYSet>& setPageY(double value);  // Defined below

        VisualViewportBuilder<STATE | ClientWidthSet>& setClientWidth(double value);  // Defined below

        VisualViewportBuilder<STATE | ClientHeightSet>& setClientHeight(double value);  // Defined below

        VisualViewportBuilder<STATE | ScaleSet>& setScale(double value);  // Defined below

        VisualViewportBuilder<STATE>& setZoom(double value);  // Defined below

        std::unique_ptr<VisualViewport> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VisualViewport;
        VisualViewportBuilder() : m_result(new VisualViewport()) { }

        template<int STEP> VisualViewportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VisualViewportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::VisualViewport> m_result;
    };

    static VisualViewportBuilder<0> create()
    {
        return VisualViewportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VisualViewport();  // Defined below

    double m_offsetX;
    double m_offsetY;
    double m_pageX;
    double m_pageY;
    double m_clientWidth;
    double m_clientHeight;
    double m_scale;
    std::optional<double> m_zoom;
};


class CORE_EXPORT Viewport : public ::crdtp::ProtocolObject<Viewport> {
public:
    ~Viewport() override;  // Defined below

    double getX() { return m_x; }
    void setX(double value);  // Defined below

    double getY() { return m_y; }
    void setY(double value);  // Defined below

    double getWidth() { return m_width; }
    void setWidth(double value);  // Defined below

    double getHeight() { return m_height; }
    void setHeight(double value);  // Defined below

    double getScale() { return m_scale; }
    void setScale(double value);  // Defined below

    template<int STATE>
    class ViewportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            ScaleSet = 1 << 5,
            AllFieldsSet = (XSet | YSet | WidthSet | HeightSet | ScaleSet | 0)};


        ViewportBuilder<STATE | XSet>& setX(double value);  // Defined below

        ViewportBuilder<STATE | YSet>& setY(double value);  // Defined below

        ViewportBuilder<STATE | WidthSet>& setWidth(double value);  // Defined below

        ViewportBuilder<STATE | HeightSet>& setHeight(double value);  // Defined below

        ViewportBuilder<STATE | ScaleSet>& setScale(double value);  // Defined below

        std::unique_ptr<Viewport> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Viewport;
        ViewportBuilder() : m_result(new Viewport()) { }

        template<int STEP> ViewportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ViewportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::Viewport> m_result;
    };

    static ViewportBuilder<0> create()
    {
        return ViewportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Viewport();  // Defined below

    double m_x;
    double m_y;
    double m_width;
    double m_height;
    double m_scale;
};


class CORE_EXPORT FontFamilies : public ::crdtp::ProtocolObject<FontFamilies> {
public:
    ~FontFamilies() override;  // Defined below

    bool hasStandard() { return !!m_standard; }
    String getStandard(const String& defaultValue) const {
       return m_standard.value_or(defaultValue);
    }
    const std::optional<String>& getStandard() const {
       return m_standard;
    }
    void setStandard(const String& value);  // Defined below

    bool hasFixed() { return !!m_fixed; }
    String getFixed(const String& defaultValue) const {
       return m_fixed.value_or(defaultValue);
    }
    const std::optional<String>& getFixed() const {
       return m_fixed;
    }
    void setFixed(const String& value);  // Defined below

    bool hasSerif() { return !!m_serif; }
    String getSerif(const String& defaultValue) const {
       return m_serif.value_or(defaultValue);
    }
    const std::optional<String>& getSerif() const {
       return m_serif;
    }
    void setSerif(const String& value);  // Defined below

    bool hasSansSerif() { return !!m_sansSerif; }
    String getSansSerif(const String& defaultValue) const {
       return m_sansSerif.value_or(defaultValue);
    }
    const std::optional<String>& getSansSerif() const {
       return m_sansSerif;
    }
    void setSansSerif(const String& value);  // Defined below

    bool hasCursive() { return !!m_cursive; }
    String getCursive(const String& defaultValue) const {
       return m_cursive.value_or(defaultValue);
    }
    const std::optional<String>& getCursive() const {
       return m_cursive;
    }
    void setCursive(const String& value);  // Defined below

    bool hasFantasy() { return !!m_fantasy; }
    String getFantasy(const String& defaultValue) const {
       return m_fantasy.value_or(defaultValue);
    }
    const std::optional<String>& getFantasy() const {
       return m_fantasy;
    }
    void setFantasy(const String& value);  // Defined below

    bool hasMath() { return !!m_math; }
    String getMath(const String& defaultValue) const {
       return m_math.value_or(defaultValue);
    }
    const std::optional<String>& getMath() const {
       return m_math;
    }
    void setMath(const String& value);  // Defined below

    template<int STATE>
    class FontFamiliesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FontFamiliesBuilder<STATE>& setStandard(const String& value);  // Defined below

        FontFamiliesBuilder<STATE>& setFixed(const String& value);  // Defined below

        FontFamiliesBuilder<STATE>& setSerif(const String& value);  // Defined below

        FontFamiliesBuilder<STATE>& setSansSerif(const String& value);  // Defined below

        FontFamiliesBuilder<STATE>& setCursive(const String& value);  // Defined below

        FontFamiliesBuilder<STATE>& setFantasy(const String& value);  // Defined below

        FontFamiliesBuilder<STATE>& setMath(const String& value);  // Defined below

        std::unique_ptr<FontFamilies> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FontFamilies;
        FontFamiliesBuilder() : m_result(new FontFamilies()) { }

        template<int STEP> FontFamiliesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FontFamiliesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FontFamilies> m_result;
    };

    static FontFamiliesBuilder<0> create()
    {
        return FontFamiliesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FontFamilies();  // Defined below

    std::optional<String> m_standard;
    std::optional<String> m_fixed;
    std::optional<String> m_serif;
    std::optional<String> m_sansSerif;
    std::optional<String> m_cursive;
    std::optional<String> m_fantasy;
    std::optional<String> m_math;
};


class CORE_EXPORT ScriptFontFamilies : public ::crdtp::ProtocolObject<ScriptFontFamilies> {
public:
    ~ScriptFontFamilies() override;  // Defined below

    String getScript() { return m_script; }
    void setScript(const String& value);  // Defined below

    protocol::Page::FontFamilies* getFontFamilies() { return m_fontFamilies.get(); }
    void setFontFamilies(std::unique_ptr<protocol::Page::FontFamilies> value);  // Defined below

    template<int STATE>
    class ScriptFontFamiliesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScriptSet = 1 << 1,
            FontFamiliesSet = 1 << 2,
            AllFieldsSet = (ScriptSet | FontFamiliesSet | 0)};


        ScriptFontFamiliesBuilder<STATE | ScriptSet>& setScript(const String& value);  // Defined below

        ScriptFontFamiliesBuilder<STATE | FontFamiliesSet>& setFontFamilies(std::unique_ptr<protocol::Page::FontFamilies> value);  // Defined below

        std::unique_ptr<ScriptFontFamilies> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScriptFontFamilies;
        ScriptFontFamiliesBuilder() : m_result(new ScriptFontFamilies()) { }

        template<int STEP> ScriptFontFamiliesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScriptFontFamiliesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::ScriptFontFamilies> m_result;
    };

    static ScriptFontFamiliesBuilder<0> create()
    {
        return ScriptFontFamiliesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScriptFontFamilies();  // Defined below

    String m_script;
    std::unique_ptr<protocol::Page::FontFamilies> m_fontFamilies;
};


class CORE_EXPORT FontSizes : public ::crdtp::ProtocolObject<FontSizes> {
public:
    ~FontSizes() override;  // Defined below

    bool hasStandard() { return !!m_standard; }
    int getStandard(int defaultValue) const {
       return m_standard.value_or(defaultValue);
    }
    const std::optional<int>& getStandard() const {
       return m_standard;
    }
    void setStandard(int value);  // Defined below

    bool hasFixed() { return !!m_fixed; }
    int getFixed(int defaultValue) const {
       return m_fixed.value_or(defaultValue);
    }
    const std::optional<int>& getFixed() const {
       return m_fixed;
    }
    void setFixed(int value);  // Defined below

    template<int STATE>
    class FontSizesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FontSizesBuilder<STATE>& setStandard(int value);  // Defined below

        FontSizesBuilder<STATE>& setFixed(int value);  // Defined below

        std::unique_ptr<FontSizes> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FontSizes;
        FontSizesBuilder() : m_result(new FontSizes()) { }

        template<int STEP> FontSizesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FontSizesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::FontSizes> m_result;
    };

    static FontSizesBuilder<0> create()
    {
        return FontSizesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FontSizes();  // Defined below

    std::optional<int> m_standard;
    std::optional<int> m_fixed;
};


class CORE_EXPORT CompilationCacheParams : public ::crdtp::ProtocolObject<CompilationCacheParams> {
public:
    ~CompilationCacheParams() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    bool hasEager() { return !!m_eager; }
    bool getEager(bool defaultValue) const {
       return m_eager.value_or(defaultValue);
    }
    const std::optional<bool>& getEager() const {
       return m_eager;
    }
    void setEager(bool value);  // Defined below

    template<int STATE>
    class CompilationCacheParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        CompilationCacheParamsBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        CompilationCacheParamsBuilder<STATE>& setEager(bool value);  // Defined below

        std::unique_ptr<CompilationCacheParams> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CompilationCacheParams;
        CompilationCacheParamsBuilder() : m_result(new CompilationCacheParams()) { }

        template<int STEP> CompilationCacheParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CompilationCacheParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::CompilationCacheParams> m_result;
    };

    static CompilationCacheParamsBuilder<0> create()
    {
        return CompilationCacheParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CompilationCacheParams();  // Defined below

    String m_url;
    std::optional<bool> m_eager;
};


class CORE_EXPORT BackForwardCacheBlockingDetails : public ::crdtp::ProtocolObject<BackForwardCacheBlockingDetails> {
public:
    ~BackForwardCacheBlockingDetails() override;  // Defined below

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value);  // Defined below

    bool hasFunction() { return !!m_function; }
    String getFunction(const String& defaultValue) const {
       return m_function.value_or(defaultValue);
    }
    const std::optional<String>& getFunction() const {
       return m_function;
    }
    void setFunction(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value);  // Defined below

    template<int STATE>
    class BackForwardCacheBlockingDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LineNumberSet = 1 << 1,
            ColumnNumberSet = 1 << 2,
            AllFieldsSet = (LineNumberSet | ColumnNumberSet | 0)};


        BackForwardCacheBlockingDetailsBuilder<STATE>& setUrl(const String& value);  // Defined below

        BackForwardCacheBlockingDetailsBuilder<STATE>& setFunction(const String& value);  // Defined below

        BackForwardCacheBlockingDetailsBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        BackForwardCacheBlockingDetailsBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value);  // Defined below

        std::unique_ptr<BackForwardCacheBlockingDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackForwardCacheBlockingDetails;
        BackForwardCacheBlockingDetailsBuilder() : m_result(new BackForwardCacheBlockingDetails()) { }

        template<int STEP> BackForwardCacheBlockingDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackForwardCacheBlockingDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::BackForwardCacheBlockingDetails> m_result;
    };

    static BackForwardCacheBlockingDetailsBuilder<0> create()
    {
        return BackForwardCacheBlockingDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackForwardCacheBlockingDetails();  // Defined below

    std::optional<String> m_url;
    std::optional<String> m_function;
    int m_lineNumber;
    int m_columnNumber;
};


class CORE_EXPORT BackForwardCacheNotRestoredExplanation : public ::crdtp::ProtocolObject<BackForwardCacheNotRestoredExplanation> {
public:
    ~BackForwardCacheNotRestoredExplanation() override;  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    String getReason() { return m_reason; }
    void setReason(const String& value);  // Defined below

    bool hasContext() { return !!m_context; }
    String getContext(const String& defaultValue) const {
       return m_context.value_or(defaultValue);
    }
    const std::optional<String>& getContext() const {
       return m_context;
    }
    void setContext(const String& value);  // Defined below

    bool hasDetails() { return !!m_details; }
    protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>* getDetails(protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>* defaultValue) {
       return m_details ? m_details.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>>& getDetails() const {
       return m_details;
    }
    void setDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value);  // Defined below

    template<int STATE>
    class BackForwardCacheNotRestoredExplanationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (TypeSet | ReasonSet | 0)};


        BackForwardCacheNotRestoredExplanationBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationBuilder<STATE | ReasonSet>& setReason(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationBuilder<STATE>& setContext(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationBuilder<STATE>& setDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value);  // Defined below

        std::unique_ptr<BackForwardCacheNotRestoredExplanation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackForwardCacheNotRestoredExplanation;
        BackForwardCacheNotRestoredExplanationBuilder() : m_result(new BackForwardCacheNotRestoredExplanation()) { }

        template<int STEP> BackForwardCacheNotRestoredExplanationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackForwardCacheNotRestoredExplanationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanation> m_result;
    };

    static BackForwardCacheNotRestoredExplanationBuilder<0> create()
    {
        return BackForwardCacheNotRestoredExplanationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackForwardCacheNotRestoredExplanation();  // Defined below

    String m_type;
    String m_reason;
    std::optional<String> m_context;
    std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> m_details;
};


class CORE_EXPORT BackForwardCacheNotRestoredExplanationTree : public ::crdtp::ProtocolObject<BackForwardCacheNotRestoredExplanationTree> {
public:
    ~BackForwardCacheNotRestoredExplanationTree() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>* getExplanations() { return m_explanations.get(); }
    void setExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value);  // Defined below

    protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>* getChildren() { return m_children.get(); }
    void setChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value);  // Defined below

    template<int STATE>
    class BackForwardCacheNotRestoredExplanationTreeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            ExplanationsSet = 1 << 2,
            ChildrenSet = 1 << 3,
            AllFieldsSet = (UrlSet | ExplanationsSet | ChildrenSet | 0)};


        BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | ExplanationsSet>& setExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value);  // Defined below

        BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | ChildrenSet>& setChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value);  // Defined below

        std::unique_ptr<BackForwardCacheNotRestoredExplanationTree> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackForwardCacheNotRestoredExplanationTree;
        BackForwardCacheNotRestoredExplanationTreeBuilder() : m_result(new BackForwardCacheNotRestoredExplanationTree()) { }

        template<int STEP> BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanationTree> m_result;
    };

    static BackForwardCacheNotRestoredExplanationTreeBuilder<0> create()
    {
        return BackForwardCacheNotRestoredExplanationTreeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackForwardCacheNotRestoredExplanationTree();  // Defined below

    String m_url;
    std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> m_explanations;
    std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> m_children;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline AdFrameStatus::~AdFrameStatus() = default;
inline void AdFrameStatus::setAdFrameType(const String& value) { m_adFrameType = value; }
inline void AdFrameStatus::setExplanations(std::unique_ptr<protocol::Array<String>> value) { m_explanations = std::move(value); }

template<int STATE>
inline AdFrameStatus::AdFrameStatusBuilder<STATE | AdFrameStatus::AdFrameStatusBuilder<STATE>::AdFrameTypeSet>&
AdFrameStatus::AdFrameStatusBuilder<STATE>::setAdFrameType(const String& value) {
  static_assert(!(STATE & AdFrameTypeSet), "property adFrameType should not be set yet");
  m_result->setAdFrameType(value);
  return castState<AdFrameTypeSet>();
}
template<int STATE>
inline AdFrameStatus::AdFrameStatusBuilder<STATE>& AdFrameStatus::AdFrameStatusBuilder<STATE>::setExplanations(std::unique_ptr<protocol::Array<String>> value) {
  m_result->setExplanations(std::move(value));
  return *this;
}

inline AdFrameStatus::AdFrameStatus() {
}
inline AdScriptId::~AdScriptId() = default;
inline void AdScriptId::setScriptId(const String& value) { m_scriptId = value; }
inline void AdScriptId::setDebuggerId(const String& value) { m_debuggerId = value; }

template<int STATE>
inline AdScriptId::AdScriptIdBuilder<STATE | AdScriptId::AdScriptIdBuilder<STATE>::ScriptIdSet>&
AdScriptId::AdScriptIdBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline AdScriptId::AdScriptIdBuilder<STATE | AdScriptId::AdScriptIdBuilder<STATE>::DebuggerIdSet>&
AdScriptId::AdScriptIdBuilder<STATE>::setDebuggerId(const String& value) {
  static_assert(!(STATE & DebuggerIdSet), "property debuggerId should not be set yet");
  m_result->setDebuggerId(value);
  return castState<DebuggerIdSet>();
}

inline AdScriptId::AdScriptId() {
}
inline AdScriptAncestry::~AdScriptAncestry() = default;
inline void AdScriptAncestry::setAncestryChain(std::unique_ptr<protocol::Array<protocol::Page::AdScriptId>> value) { m_ancestryChain = std::move(value); }
inline void AdScriptAncestry::setRootScriptFilterlistRule(const String& value) { m_rootScriptFilterlistRule = value; }

template<int STATE>
inline AdScriptAncestry::AdScriptAncestryBuilder<STATE | AdScriptAncestry::AdScriptAncestryBuilder<STATE>::AncestryChainSet>&
AdScriptAncestry::AdScriptAncestryBuilder<STATE>::setAncestryChain(std::unique_ptr<protocol::Array<protocol::Page::AdScriptId>> value) {
  static_assert(!(STATE & AncestryChainSet), "property ancestryChain should not be set yet");
  m_result->setAncestryChain(std::move(value));
  return castState<AncestryChainSet>();
}
template<int STATE>
inline AdScriptAncestry::AdScriptAncestryBuilder<STATE>& AdScriptAncestry::AdScriptAncestryBuilder<STATE>::setRootScriptFilterlistRule(const String& value) {
  m_result->setRootScriptFilterlistRule(value);
  return *this;
}

inline AdScriptAncestry::AdScriptAncestry() {
}
inline PermissionsPolicyBlockLocator::~PermissionsPolicyBlockLocator() = default;
inline void PermissionsPolicyBlockLocator::setFrameId(const String& value) { m_frameId = value; }
inline void PermissionsPolicyBlockLocator::setBlockReason(const String& value) { m_blockReason = value; }

template<int STATE>
inline PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocatorBuilder<STATE | PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocatorBuilder<STATE>::FrameIdSet>&
PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocatorBuilder<STATE>::setFrameId(const String& value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->setFrameId(value);
  return castState<FrameIdSet>();
}
template<int STATE>
inline PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocatorBuilder<STATE | PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocatorBuilder<STATE>::BlockReasonSet>&
PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocatorBuilder<STATE>::setBlockReason(const String& value) {
  static_assert(!(STATE & BlockReasonSet), "property blockReason should not be set yet");
  m_result->setBlockReason(value);
  return castState<BlockReasonSet>();
}

inline PermissionsPolicyBlockLocator::PermissionsPolicyBlockLocator() {
}
inline PermissionsPolicyFeatureState::~PermissionsPolicyFeatureState() = default;
inline void PermissionsPolicyFeatureState::setFeature(const String& value) { m_feature = value; }
inline void PermissionsPolicyFeatureState::setAllowed(bool value) { m_allowed = value; }
inline void PermissionsPolicyFeatureState::setLocator(std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator> value) { m_locator = std::move(value); }

template<int STATE>
inline PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE | PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE>::FeatureSet>&
PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE>::setFeature(const String& value) {
  static_assert(!(STATE & FeatureSet), "property feature should not be set yet");
  m_result->setFeature(value);
  return castState<FeatureSet>();
}
template<int STATE>
inline PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE | PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE>::AllowedSet>&
PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE>::setAllowed(bool value) {
  static_assert(!(STATE & AllowedSet), "property allowed should not be set yet");
  m_result->setAllowed(value);
  return castState<AllowedSet>();
}
template<int STATE>
inline PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE>& PermissionsPolicyFeatureState::PermissionsPolicyFeatureStateBuilder<STATE>::setLocator(std::unique_ptr<protocol::Page::PermissionsPolicyBlockLocator> value) {
  m_result->setLocator(std::move(value));
  return *this;
}

inline PermissionsPolicyFeatureState::PermissionsPolicyFeatureState() {
  m_allowed = false;
}
inline OriginTrialToken::~OriginTrialToken() = default;
inline void OriginTrialToken::setOrigin(const String& value) { m_origin = value; }
inline void OriginTrialToken::setMatchSubDomains(bool value) { m_matchSubDomains = value; }
inline void OriginTrialToken::setTrialName(const String& value) { m_trialName = value; }
inline void OriginTrialToken::setExpiryTime(double value) { m_expiryTime = value; }
inline void OriginTrialToken::setIsThirdParty(bool value) { m_isThirdParty = value; }
inline void OriginTrialToken::setUsageRestriction(const String& value) { m_usageRestriction = value; }

template<int STATE>
inline OriginTrialToken::OriginTrialTokenBuilder<STATE | OriginTrialToken::OriginTrialTokenBuilder<STATE>::OriginSet>&
OriginTrialToken::OriginTrialTokenBuilder<STATE>::setOrigin(const String& value) {
  static_assert(!(STATE & OriginSet), "property origin should not be set yet");
  m_result->setOrigin(value);
  return castState<OriginSet>();
}
template<int STATE>
inline OriginTrialToken::OriginTrialTokenBuilder<STATE | OriginTrialToken::OriginTrialTokenBuilder<STATE>::MatchSubDomainsSet>&
OriginTrialToken::OriginTrialTokenBuilder<STATE>::setMatchSubDomains(bool value) {
  static_assert(!(STATE & MatchSubDomainsSet), "property matchSubDomains should not be set yet");
  m_result->setMatchSubDomains(value);
  return castState<MatchSubDomainsSet>();
}
template<int STATE>
inline OriginTrialToken::OriginTrialTokenBuilder<STATE | OriginTrialToken::OriginTrialTokenBuilder<STATE>::TrialNameSet>&
OriginTrialToken::OriginTrialTokenBuilder<STATE>::setTrialName(const String& value) {
  static_assert(!(STATE & TrialNameSet), "property trialName should not be set yet");
  m_result->setTrialName(value);
  return castState<TrialNameSet>();
}
template<int STATE>
inline OriginTrialToken::OriginTrialTokenBuilder<STATE | OriginTrialToken::OriginTrialTokenBuilder<STATE>::ExpiryTimeSet>&
OriginTrialToken::OriginTrialTokenBuilder<STATE>::setExpiryTime(double value) {
  static_assert(!(STATE & ExpiryTimeSet), "property expiryTime should not be set yet");
  m_result->setExpiryTime(value);
  return castState<ExpiryTimeSet>();
}
template<int STATE>
inline OriginTrialToken::OriginTrialTokenBuilder<STATE | OriginTrialToken::OriginTrialTokenBuilder<STATE>::IsThirdPartySet>&
OriginTrialToken::OriginTrialTokenBuilder<STATE>::setIsThirdParty(bool value) {
  static_assert(!(STATE & IsThirdPartySet), "property isThirdParty should not be set yet");
  m_result->setIsThirdParty(value);
  return castState<IsThirdPartySet>();
}
template<int STATE>
inline OriginTrialToken::OriginTrialTokenBuilder<STATE | OriginTrialToken::OriginTrialTokenBuilder<STATE>::UsageRestrictionSet>&
OriginTrialToken::OriginTrialTokenBuilder<STATE>::setUsageRestriction(const String& value) {
  static_assert(!(STATE & UsageRestrictionSet), "property usageRestriction should not be set yet");
  m_result->setUsageRestriction(value);
  return castState<UsageRestrictionSet>();
}

inline OriginTrialToken::OriginTrialToken() {
  m_matchSubDomains = false;
  m_expiryTime = 0;
  m_isThirdParty = false;
}
inline OriginTrialTokenWithStatus::~OriginTrialTokenWithStatus() = default;
inline void OriginTrialTokenWithStatus::setRawTokenText(const String& value) { m_rawTokenText = value; }
inline void OriginTrialTokenWithStatus::setParsedToken(std::unique_ptr<protocol::Page::OriginTrialToken> value) { m_parsedToken = std::move(value); }
inline void OriginTrialTokenWithStatus::setStatus(const String& value) { m_status = value; }

template<int STATE>
inline OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE | OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE>::RawTokenTextSet>&
OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE>::setRawTokenText(const String& value) {
  static_assert(!(STATE & RawTokenTextSet), "property rawTokenText should not be set yet");
  m_result->setRawTokenText(value);
  return castState<RawTokenTextSet>();
}
template<int STATE>
inline OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE>& OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE>::setParsedToken(std::unique_ptr<protocol::Page::OriginTrialToken> value) {
  m_result->setParsedToken(std::move(value));
  return *this;
}
template<int STATE>
inline OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE | OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE>::StatusSet>&
OriginTrialTokenWithStatus::OriginTrialTokenWithStatusBuilder<STATE>::setStatus(const String& value) {
  static_assert(!(STATE & StatusSet), "property status should not be set yet");
  m_result->setStatus(value);
  return castState<StatusSet>();
}

inline OriginTrialTokenWithStatus::OriginTrialTokenWithStatus() {
}
inline OriginTrial::~OriginTrial() = default;
inline void OriginTrial::setTrialName(const String& value) { m_trialName = value; }
inline void OriginTrial::setStatus(const String& value) { m_status = value; }
inline void OriginTrial::setTokensWithStatus(std::unique_ptr<protocol::Array<protocol::Page::OriginTrialTokenWithStatus>> value) { m_tokensWithStatus = std::move(value); }

template<int STATE>
inline OriginTrial::OriginTrialBuilder<STATE | OriginTrial::OriginTrialBuilder<STATE>::TrialNameSet>&
OriginTrial::OriginTrialBuilder<STATE>::setTrialName(const String& value) {
  static_assert(!(STATE & TrialNameSet), "property trialName should not be set yet");
  m_result->setTrialName(value);
  return castState<TrialNameSet>();
}
template<int STATE>
inline OriginTrial::OriginTrialBuilder<STATE | OriginTrial::OriginTrialBuilder<STATE>::StatusSet>&
OriginTrial::OriginTrialBuilder<STATE>::setStatus(const String& value) {
  static_assert(!(STATE & StatusSet), "property status should not be set yet");
  m_result->setStatus(value);
  return castState<StatusSet>();
}
template<int STATE>
inline OriginTrial::OriginTrialBuilder<STATE | OriginTrial::OriginTrialBuilder<STATE>::TokensWithStatusSet>&
OriginTrial::OriginTrialBuilder<STATE>::setTokensWithStatus(std::unique_ptr<protocol::Array<protocol::Page::OriginTrialTokenWithStatus>> value) {
  static_assert(!(STATE & TokensWithStatusSet), "property tokensWithStatus should not be set yet");
  m_result->setTokensWithStatus(std::move(value));
  return castState<TokensWithStatusSet>();
}

inline OriginTrial::OriginTrial() {
}
inline SecurityOriginDetails::~SecurityOriginDetails() = default;
inline void SecurityOriginDetails::setIsLocalhost(bool value) { m_isLocalhost = value; }

template<int STATE>
inline SecurityOriginDetails::SecurityOriginDetailsBuilder<STATE | SecurityOriginDetails::SecurityOriginDetailsBuilder<STATE>::IsLocalhostSet>&
SecurityOriginDetails::SecurityOriginDetailsBuilder<STATE>::setIsLocalhost(bool value) {
  static_assert(!(STATE & IsLocalhostSet), "property isLocalhost should not be set yet");
  m_result->setIsLocalhost(value);
  return castState<IsLocalhostSet>();
}

inline SecurityOriginDetails::SecurityOriginDetails() {
  m_isLocalhost = false;
}
inline Frame::~Frame() = default;
inline void Frame::setId(const String& value) { m_id = value; }
inline void Frame::setParentId(const String& value) { m_parentId = value; }
inline void Frame::setLoaderId(const String& value) { m_loaderId = value; }
inline void Frame::setName(const String& value) { m_name = value; }
inline void Frame::setUrl(const String& value) { m_url = value; }
inline void Frame::setUrlFragment(const String& value) { m_urlFragment = value; }
inline void Frame::setDomainAndRegistry(const String& value) { m_domainAndRegistry = value; }
inline void Frame::setSecurityOrigin(const String& value) { m_securityOrigin = value; }
inline void Frame::setSecurityOriginDetails(std::unique_ptr<protocol::Page::SecurityOriginDetails> value) { m_securityOriginDetails = std::move(value); }
inline void Frame::setMimeType(const String& value) { m_mimeType = value; }
inline void Frame::setUnreachableUrl(const String& value) { m_unreachableUrl = value; }
inline void Frame::setAdFrameStatus(std::unique_ptr<protocol::Page::AdFrameStatus> value) { m_adFrameStatus = std::move(value); }
inline void Frame::setSecureContextType(const String& value) { m_secureContextType = value; }
inline void Frame::setCrossOriginIsolatedContextType(const String& value) { m_crossOriginIsolatedContextType = value; }
inline void Frame::setGatedAPIFeatures(std::unique_ptr<protocol::Array<String>> value) { m_gatedAPIFeatures = std::move(value); }

template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::IdSet>&
Frame::FrameBuilder<STATE>::setId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE>& Frame::FrameBuilder<STATE>::setParentId(const String& value) {
  m_result->setParentId(value);
  return *this;
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::LoaderIdSet>&
Frame::FrameBuilder<STATE>::setLoaderId(const String& value) {
  static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
  m_result->setLoaderId(value);
  return castState<LoaderIdSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE>& Frame::FrameBuilder<STATE>::setName(const String& value) {
  m_result->setName(value);
  return *this;
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::UrlSet>&
Frame::FrameBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE>& Frame::FrameBuilder<STATE>::setUrlFragment(const String& value) {
  m_result->setUrlFragment(value);
  return *this;
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::DomainAndRegistrySet>&
Frame::FrameBuilder<STATE>::setDomainAndRegistry(const String& value) {
  static_assert(!(STATE & DomainAndRegistrySet), "property domainAndRegistry should not be set yet");
  m_result->setDomainAndRegistry(value);
  return castState<DomainAndRegistrySet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::SecurityOriginSet>&
Frame::FrameBuilder<STATE>::setSecurityOrigin(const String& value) {
  static_assert(!(STATE & SecurityOriginSet), "property securityOrigin should not be set yet");
  m_result->setSecurityOrigin(value);
  return castState<SecurityOriginSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE>& Frame::FrameBuilder<STATE>::setSecurityOriginDetails(std::unique_ptr<protocol::Page::SecurityOriginDetails> value) {
  m_result->setSecurityOriginDetails(std::move(value));
  return *this;
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::MimeTypeSet>&
Frame::FrameBuilder<STATE>::setMimeType(const String& value) {
  static_assert(!(STATE & MimeTypeSet), "property mimeType should not be set yet");
  m_result->setMimeType(value);
  return castState<MimeTypeSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE>& Frame::FrameBuilder<STATE>::setUnreachableUrl(const String& value) {
  m_result->setUnreachableUrl(value);
  return *this;
}
template<int STATE>
inline Frame::FrameBuilder<STATE>& Frame::FrameBuilder<STATE>::setAdFrameStatus(std::unique_ptr<protocol::Page::AdFrameStatus> value) {
  m_result->setAdFrameStatus(std::move(value));
  return *this;
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::SecureContextTypeSet>&
Frame::FrameBuilder<STATE>::setSecureContextType(const String& value) {
  static_assert(!(STATE & SecureContextTypeSet), "property secureContextType should not be set yet");
  m_result->setSecureContextType(value);
  return castState<SecureContextTypeSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::CrossOriginIsolatedContextTypeSet>&
Frame::FrameBuilder<STATE>::setCrossOriginIsolatedContextType(const String& value) {
  static_assert(!(STATE & CrossOriginIsolatedContextTypeSet), "property crossOriginIsolatedContextType should not be set yet");
  m_result->setCrossOriginIsolatedContextType(value);
  return castState<CrossOriginIsolatedContextTypeSet>();
}
template<int STATE>
inline Frame::FrameBuilder<STATE | Frame::FrameBuilder<STATE>::GatedAPIFeaturesSet>&
Frame::FrameBuilder<STATE>::setGatedAPIFeatures(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & GatedAPIFeaturesSet), "property gatedAPIFeatures should not be set yet");
  m_result->setGatedAPIFeatures(std::move(value));
  return castState<GatedAPIFeaturesSet>();
}

inline Frame::Frame() {
}
inline FrameResource::~FrameResource() = default;
inline void FrameResource::setUrl(const String& value) { m_url = value; }
inline void FrameResource::setType(const String& value) { m_type = value; }
inline void FrameResource::setMimeType(const String& value) { m_mimeType = value; }
inline void FrameResource::setLastModified(double value) { m_lastModified = value; }
inline void FrameResource::setContentSize(double value) { m_contentSize = value; }
inline void FrameResource::setFailed(bool value) { m_failed = value; }
inline void FrameResource::setCanceled(bool value) { m_canceled = value; }

template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE | FrameResource::FrameResourceBuilder<STATE>::UrlSet>&
FrameResource::FrameResourceBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE | FrameResource::FrameResourceBuilder<STATE>::TypeSet>&
FrameResource::FrameResourceBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE | FrameResource::FrameResourceBuilder<STATE>::MimeTypeSet>&
FrameResource::FrameResourceBuilder<STATE>::setMimeType(const String& value) {
  static_assert(!(STATE & MimeTypeSet), "property mimeType should not be set yet");
  m_result->setMimeType(value);
  return castState<MimeTypeSet>();
}
template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE>& FrameResource::FrameResourceBuilder<STATE>::setLastModified(double value) {
  m_result->setLastModified(value);
  return *this;
}
template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE>& FrameResource::FrameResourceBuilder<STATE>::setContentSize(double value) {
  m_result->setContentSize(value);
  return *this;
}
template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE>& FrameResource::FrameResourceBuilder<STATE>::setFailed(bool value) {
  m_result->setFailed(value);
  return *this;
}
template<int STATE>
inline FrameResource::FrameResourceBuilder<STATE>& FrameResource::FrameResourceBuilder<STATE>::setCanceled(bool value) {
  m_result->setCanceled(value);
  return *this;
}

inline FrameResource::FrameResource() {
}
inline FrameResourceTree::~FrameResourceTree() = default;
inline void FrameResourceTree::setFrame(std::unique_ptr<protocol::Page::Frame> value) { m_frame = std::move(value); }
inline void FrameResourceTree::setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameResourceTree>> value) { m_childFrames = std::move(value); }
inline void FrameResourceTree::setResources(std::unique_ptr<protocol::Array<protocol::Page::FrameResource>> value) { m_resources = std::move(value); }

template<int STATE>
inline FrameResourceTree::FrameResourceTreeBuilder<STATE | FrameResourceTree::FrameResourceTreeBuilder<STATE>::FrameSet>&
FrameResourceTree::FrameResourceTreeBuilder<STATE>::setFrame(std::unique_ptr<protocol::Page::Frame> value) {
  static_assert(!(STATE & FrameSet), "property frame should not be set yet");
  m_result->setFrame(std::move(value));
  return castState<FrameSet>();
}
template<int STATE>
inline FrameResourceTree::FrameResourceTreeBuilder<STATE>& FrameResourceTree::FrameResourceTreeBuilder<STATE>::setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameResourceTree>> value) {
  m_result->setChildFrames(std::move(value));
  return *this;
}
template<int STATE>
inline FrameResourceTree::FrameResourceTreeBuilder<STATE | FrameResourceTree::FrameResourceTreeBuilder<STATE>::ResourcesSet>&
FrameResourceTree::FrameResourceTreeBuilder<STATE>::setResources(std::unique_ptr<protocol::Array<protocol::Page::FrameResource>> value) {
  static_assert(!(STATE & ResourcesSet), "property resources should not be set yet");
  m_result->setResources(std::move(value));
  return castState<ResourcesSet>();
}

inline FrameResourceTree::FrameResourceTree() {
}
inline FrameTree::~FrameTree() = default;
inline void FrameTree::setFrame(std::unique_ptr<protocol::Page::Frame> value) { m_frame = std::move(value); }
inline void FrameTree::setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameTree>> value) { m_childFrames = std::move(value); }

template<int STATE>
inline FrameTree::FrameTreeBuilder<STATE | FrameTree::FrameTreeBuilder<STATE>::FrameSet>&
FrameTree::FrameTreeBuilder<STATE>::setFrame(std::unique_ptr<protocol::Page::Frame> value) {
  static_assert(!(STATE & FrameSet), "property frame should not be set yet");
  m_result->setFrame(std::move(value));
  return castState<FrameSet>();
}
template<int STATE>
inline FrameTree::FrameTreeBuilder<STATE>& FrameTree::FrameTreeBuilder<STATE>::setChildFrames(std::unique_ptr<protocol::Array<protocol::Page::FrameTree>> value) {
  m_result->setChildFrames(std::move(value));
  return *this;
}

inline FrameTree::FrameTree() {
}
inline LayoutViewport::~LayoutViewport() = default;
inline void LayoutViewport::setPageX(int value) { m_pageX = value; }
inline void LayoutViewport::setPageY(int value) { m_pageY = value; }
inline void LayoutViewport::setClientWidth(int value) { m_clientWidth = value; }
inline void LayoutViewport::setClientHeight(int value) { m_clientHeight = value; }

template<int STATE>
inline LayoutViewport::LayoutViewportBuilder<STATE | LayoutViewport::LayoutViewportBuilder<STATE>::PageXSet>&
LayoutViewport::LayoutViewportBuilder<STATE>::setPageX(int value) {
  static_assert(!(STATE & PageXSet), "property pageX should not be set yet");
  m_result->setPageX(value);
  return castState<PageXSet>();
}
template<int STATE>
inline LayoutViewport::LayoutViewportBuilder<STATE | LayoutViewport::LayoutViewportBuilder<STATE>::PageYSet>&
LayoutViewport::LayoutViewportBuilder<STATE>::setPageY(int value) {
  static_assert(!(STATE & PageYSet), "property pageY should not be set yet");
  m_result->setPageY(value);
  return castState<PageYSet>();
}
template<int STATE>
inline LayoutViewport::LayoutViewportBuilder<STATE | LayoutViewport::LayoutViewportBuilder<STATE>::ClientWidthSet>&
LayoutViewport::LayoutViewportBuilder<STATE>::setClientWidth(int value) {
  static_assert(!(STATE & ClientWidthSet), "property clientWidth should not be set yet");
  m_result->setClientWidth(value);
  return castState<ClientWidthSet>();
}
template<int STATE>
inline LayoutViewport::LayoutViewportBuilder<STATE | LayoutViewport::LayoutViewportBuilder<STATE>::ClientHeightSet>&
LayoutViewport::LayoutViewportBuilder<STATE>::setClientHeight(int value) {
  static_assert(!(STATE & ClientHeightSet), "property clientHeight should not be set yet");
  m_result->setClientHeight(value);
  return castState<ClientHeightSet>();
}

inline LayoutViewport::LayoutViewport() {
  m_pageX = 0;
  m_pageY = 0;
  m_clientWidth = 0;
  m_clientHeight = 0;
}
inline VisualViewport::~VisualViewport() = default;
inline void VisualViewport::setOffsetX(double value) { m_offsetX = value; }
inline void VisualViewport::setOffsetY(double value) { m_offsetY = value; }
inline void VisualViewport::setPageX(double value) { m_pageX = value; }
inline void VisualViewport::setPageY(double value) { m_pageY = value; }
inline void VisualViewport::setClientWidth(double value) { m_clientWidth = value; }
inline void VisualViewport::setClientHeight(double value) { m_clientHeight = value; }
inline void VisualViewport::setScale(double value) { m_scale = value; }
inline void VisualViewport::setZoom(double value) { m_zoom = value; }

template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::OffsetXSet>&
VisualViewport::VisualViewportBuilder<STATE>::setOffsetX(double value) {
  static_assert(!(STATE & OffsetXSet), "property offsetX should not be set yet");
  m_result->setOffsetX(value);
  return castState<OffsetXSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::OffsetYSet>&
VisualViewport::VisualViewportBuilder<STATE>::setOffsetY(double value) {
  static_assert(!(STATE & OffsetYSet), "property offsetY should not be set yet");
  m_result->setOffsetY(value);
  return castState<OffsetYSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::PageXSet>&
VisualViewport::VisualViewportBuilder<STATE>::setPageX(double value) {
  static_assert(!(STATE & PageXSet), "property pageX should not be set yet");
  m_result->setPageX(value);
  return castState<PageXSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::PageYSet>&
VisualViewport::VisualViewportBuilder<STATE>::setPageY(double value) {
  static_assert(!(STATE & PageYSet), "property pageY should not be set yet");
  m_result->setPageY(value);
  return castState<PageYSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::ClientWidthSet>&
VisualViewport::VisualViewportBuilder<STATE>::setClientWidth(double value) {
  static_assert(!(STATE & ClientWidthSet), "property clientWidth should not be set yet");
  m_result->setClientWidth(value);
  return castState<ClientWidthSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::ClientHeightSet>&
VisualViewport::VisualViewportBuilder<STATE>::setClientHeight(double value) {
  static_assert(!(STATE & ClientHeightSet), "property clientHeight should not be set yet");
  m_result->setClientHeight(value);
  return castState<ClientHeightSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE | VisualViewport::VisualViewportBuilder<STATE>::ScaleSet>&
VisualViewport::VisualViewportBuilder<STATE>::setScale(double value) {
  static_assert(!(STATE & ScaleSet), "property scale should not be set yet");
  m_result->setScale(value);
  return castState<ScaleSet>();
}
template<int STATE>
inline VisualViewport::VisualViewportBuilder<STATE>& VisualViewport::VisualViewportBuilder<STATE>::setZoom(double value) {
  m_result->setZoom(value);
  return *this;
}

inline VisualViewport::VisualViewport() {
  m_offsetX = 0;
  m_offsetY = 0;
  m_pageX = 0;
  m_pageY = 0;
  m_clientWidth = 0;
  m_clientHeight = 0;
  m_scale = 0;
}
inline Viewport::~Viewport() = default;
inline void Viewport::setX(double value) { m_x = value; }
inline void Viewport::setY(double value) { m_y = value; }
inline void Viewport::setWidth(double value) { m_width = value; }
inline void Viewport::setHeight(double value) { m_height = value; }
inline void Viewport::setScale(double value) { m_scale = value; }

template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::XSet>&
Viewport::ViewportBuilder<STATE>::setX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->setX(value);
  return castState<XSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::YSet>&
Viewport::ViewportBuilder<STATE>::setY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->setY(value);
  return castState<YSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::WidthSet>&
Viewport::ViewportBuilder<STATE>::setWidth(double value) {
  static_assert(!(STATE & WidthSet), "property width should not be set yet");
  m_result->setWidth(value);
  return castState<WidthSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::HeightSet>&
Viewport::ViewportBuilder<STATE>::setHeight(double value) {
  static_assert(!(STATE & HeightSet), "property height should not be set yet");
  m_result->setHeight(value);
  return castState<HeightSet>();
}
template<int STATE>
inline Viewport::ViewportBuilder<STATE | Viewport::ViewportBuilder<STATE>::ScaleSet>&
Viewport::ViewportBuilder<STATE>::setScale(double value) {
  static_assert(!(STATE & ScaleSet), "property scale should not be set yet");
  m_result->setScale(value);
  return castState<ScaleSet>();
}

inline Viewport::Viewport() {
  m_x = 0;
  m_y = 0;
  m_width = 0;
  m_height = 0;
  m_scale = 0;
}
inline FontFamilies::~FontFamilies() = default;
inline void FontFamilies::setStandard(const String& value) { m_standard = value; }
inline void FontFamilies::setFixed(const String& value) { m_fixed = value; }
inline void FontFamilies::setSerif(const String& value) { m_serif = value; }
inline void FontFamilies::setSansSerif(const String& value) { m_sansSerif = value; }
inline void FontFamilies::setCursive(const String& value) { m_cursive = value; }
inline void FontFamilies::setFantasy(const String& value) { m_fantasy = value; }
inline void FontFamilies::setMath(const String& value) { m_math = value; }

template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setStandard(const String& value) {
  m_result->setStandard(value);
  return *this;
}
template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setFixed(const String& value) {
  m_result->setFixed(value);
  return *this;
}
template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setSerif(const String& value) {
  m_result->setSerif(value);
  return *this;
}
template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setSansSerif(const String& value) {
  m_result->setSansSerif(value);
  return *this;
}
template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setCursive(const String& value) {
  m_result->setCursive(value);
  return *this;
}
template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setFantasy(const String& value) {
  m_result->setFantasy(value);
  return *this;
}
template<int STATE>
inline FontFamilies::FontFamiliesBuilder<STATE>& FontFamilies::FontFamiliesBuilder<STATE>::setMath(const String& value) {
  m_result->setMath(value);
  return *this;
}

inline FontFamilies::FontFamilies() {
}
inline ScriptFontFamilies::~ScriptFontFamilies() = default;
inline void ScriptFontFamilies::setScript(const String& value) { m_script = value; }
inline void ScriptFontFamilies::setFontFamilies(std::unique_ptr<protocol::Page::FontFamilies> value) { m_fontFamilies = std::move(value); }

template<int STATE>
inline ScriptFontFamilies::ScriptFontFamiliesBuilder<STATE | ScriptFontFamilies::ScriptFontFamiliesBuilder<STATE>::ScriptSet>&
ScriptFontFamilies::ScriptFontFamiliesBuilder<STATE>::setScript(const String& value) {
  static_assert(!(STATE & ScriptSet), "property script should not be set yet");
  m_result->setScript(value);
  return castState<ScriptSet>();
}
template<int STATE>
inline ScriptFontFamilies::ScriptFontFamiliesBuilder<STATE | ScriptFontFamilies::ScriptFontFamiliesBuilder<STATE>::FontFamiliesSet>&
ScriptFontFamilies::ScriptFontFamiliesBuilder<STATE>::setFontFamilies(std::unique_ptr<protocol::Page::FontFamilies> value) {
  static_assert(!(STATE & FontFamiliesSet), "property fontFamilies should not be set yet");
  m_result->setFontFamilies(std::move(value));
  return castState<FontFamiliesSet>();
}

inline ScriptFontFamilies::ScriptFontFamilies() {
}
inline FontSizes::~FontSizes() = default;
inline void FontSizes::setStandard(int value) { m_standard = value; }
inline void FontSizes::setFixed(int value) { m_fixed = value; }

template<int STATE>
inline FontSizes::FontSizesBuilder<STATE>& FontSizes::FontSizesBuilder<STATE>::setStandard(int value) {
  m_result->setStandard(value);
  return *this;
}
template<int STATE>
inline FontSizes::FontSizesBuilder<STATE>& FontSizes::FontSizesBuilder<STATE>::setFixed(int value) {
  m_result->setFixed(value);
  return *this;
}

inline FontSizes::FontSizes() {
}
inline CompilationCacheParams::~CompilationCacheParams() = default;
inline void CompilationCacheParams::setUrl(const String& value) { m_url = value; }
inline void CompilationCacheParams::setEager(bool value) { m_eager = value; }

template<int STATE>
inline CompilationCacheParams::CompilationCacheParamsBuilder<STATE | CompilationCacheParams::CompilationCacheParamsBuilder<STATE>::UrlSet>&
CompilationCacheParams::CompilationCacheParamsBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline CompilationCacheParams::CompilationCacheParamsBuilder<STATE>& CompilationCacheParams::CompilationCacheParamsBuilder<STATE>::setEager(bool value) {
  m_result->setEager(value);
  return *this;
}

inline CompilationCacheParams::CompilationCacheParams() {
}
inline BackForwardCacheBlockingDetails::~BackForwardCacheBlockingDetails() = default;
inline void BackForwardCacheBlockingDetails::setUrl(const String& value) { m_url = value; }
inline void BackForwardCacheBlockingDetails::setFunction(const String& value) { m_function = value; }
inline void BackForwardCacheBlockingDetails::setLineNumber(int value) { m_lineNumber = value; }
inline void BackForwardCacheBlockingDetails::setColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>& BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::setUrl(const String& value) {
  m_result->setUrl(value);
  return *this;
}
template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>& BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::setFunction(const String& value) {
  m_result->setFunction(value);
  return *this;
}
template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE | BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::LineNumberSet>&
BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE | BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::ColumnNumberSet>&
BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetailsBuilder<STATE>::setColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->setColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline BackForwardCacheBlockingDetails::BackForwardCacheBlockingDetails() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline BackForwardCacheNotRestoredExplanation::~BackForwardCacheNotRestoredExplanation() = default;
inline void BackForwardCacheNotRestoredExplanation::setType(const String& value) { m_type = value; }
inline void BackForwardCacheNotRestoredExplanation::setReason(const String& value) { m_reason = value; }
inline void BackForwardCacheNotRestoredExplanation::setContext(const String& value) { m_context = value; }
inline void BackForwardCacheNotRestoredExplanation::setDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value) { m_details = std::move(value); }

template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE | BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::TypeSet>&
BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE | BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::ReasonSet>&
BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::setReason(const String& value) {
  static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
  m_result->setReason(value);
  return castState<ReasonSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>& BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::setContext(const String& value) {
  m_result->setContext(value);
  return *this;
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>& BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanationBuilder<STATE>::setDetails(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheBlockingDetails>> value) {
  m_result->setDetails(std::move(value));
  return *this;
}

inline BackForwardCacheNotRestoredExplanation::BackForwardCacheNotRestoredExplanation() {
}
inline BackForwardCacheNotRestoredExplanationTree::~BackForwardCacheNotRestoredExplanationTree() = default;
inline void BackForwardCacheNotRestoredExplanationTree::setUrl(const String& value) { m_url = value; }
inline void BackForwardCacheNotRestoredExplanationTree::setExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value) { m_explanations = std::move(value); }
inline void BackForwardCacheNotRestoredExplanationTree::setChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value) { m_children = std::move(value); }

template<int STATE>
inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::UrlSet>&
BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::ExplanationsSet>&
BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::setExplanations(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> value) {
  static_assert(!(STATE & ExplanationsSet), "property explanations should not be set yet");
  m_result->setExplanations(std::move(value));
  return castState<ExplanationsSet>();
}
template<int STATE>
inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE | BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::ChildrenSet>&
BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTreeBuilder<STATE>::setChildren(std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanationTree>> value) {
  static_assert(!(STATE & ChildrenSet), "property children should not be set yet");
  m_result->setChildren(std::move(value));
  return castState<ChildrenSet>();
}

inline BackForwardCacheNotRestoredExplanationTree::BackForwardCacheNotRestoredExplanationTree() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse addScriptToEvaluateOnLoad(const String& in_scriptSource, String* out_identifier) = 0;
    virtual DispatchResponse addScriptToEvaluateOnNewDocument(const String& in_source, std::optional<String> in_worldName, std::optional<bool> in_includeCommandLineAPI, std::optional<bool> in_runImmediately, String* out_identifier) = 0;
    class CORE_EXPORT CreateIsolatedWorldCallback {
    public:
        virtual void sendSuccess(int executionContextId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CreateIsolatedWorldCallback() { }
    };
    virtual void createIsolatedWorld(const String& in_frameId, std::optional<String> in_worldName, std::optional<bool> in_grantUniveralAccess, std::unique_ptr<CreateIsolatedWorldCallback> callback) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable(std::optional<bool> in_enableFileChooserOpenedEvent) = 0;
    virtual DispatchResponse getAdScriptAncestry(const String& in_frameId, std::unique_ptr<protocol::Page::AdScriptAncestry>* out_adScriptAncestry) = 0;
    virtual DispatchResponse getFrameTree(std::unique_ptr<protocol::Page::FrameTree>* out_frameTree) = 0;
    virtual DispatchResponse getLayoutMetrics(std::unique_ptr<protocol::Page::LayoutViewport>* out_layoutViewport, std::unique_ptr<protocol::Page::VisualViewport>* out_visualViewport, std::unique_ptr<protocol::DOM::Rect>* out_contentSize, std::unique_ptr<protocol::Page::LayoutViewport>* out_cssLayoutViewport, std::unique_ptr<protocol::Page::VisualViewport>* out_cssVisualViewport, std::unique_ptr<protocol::DOM::Rect>* out_cssContentSize) = 0;
    class CORE_EXPORT GetResourceContentCallback {
    public:
        virtual void sendSuccess(const String& content, bool base64Encoded) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetResourceContentCallback() { }
    };
    virtual void getResourceContent(const String& in_frameId, const String& in_url, std::unique_ptr<GetResourceContentCallback> callback) = 0;
    virtual DispatchResponse getResourceTree(std::unique_ptr<protocol::Page::FrameResourceTree>* out_frameTree) = 0;
    virtual DispatchResponse reload(std::optional<bool> in_ignoreCache, std::optional<String> in_scriptToEvaluateOnLoad, std::optional<String> in_loaderId) = 0;
    virtual DispatchResponse removeScriptToEvaluateOnLoad(const String& in_identifier) = 0;
    virtual DispatchResponse removeScriptToEvaluateOnNewDocument(const String& in_identifier) = 0;
    class CORE_EXPORT SearchInResourceCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<v8_inspector::protocol::Debugger::API::SearchMatch>> result) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SearchInResourceCallback() { }
    };
    virtual void searchInResource(const String& in_frameId, const String& in_url, const String& in_query, std::optional<bool> in_caseSensitive, std::optional<bool> in_isRegex, std::unique_ptr<SearchInResourceCallback> callback) = 0;
    virtual DispatchResponse setAdBlockingEnabled(bool in_enabled) = 0;
    virtual DispatchResponse setBypassCSP(bool in_enabled) = 0;
    virtual DispatchResponse getPermissionsPolicyState(const String& in_frameId, std::unique_ptr<protocol::Array<protocol::Page::PermissionsPolicyFeatureState>>* out_states) = 0;
    virtual DispatchResponse getOriginTrials(const String& in_frameId, std::unique_ptr<protocol::Array<protocol::Page::OriginTrial>>* out_originTrials) = 0;
    virtual DispatchResponse setFontFamilies(std::unique_ptr<protocol::Page::FontFamilies> in_fontFamilies, std::unique_ptr<protocol::Array<protocol::Page::ScriptFontFamilies>> in_forScripts) = 0;
    virtual DispatchResponse setFontSizes(std::unique_ptr<protocol::Page::FontSizes> in_fontSizes) = 0;
    virtual DispatchResponse setDocumentContent(const String& in_frameId, const String& in_html) = 0;
    virtual DispatchResponse setLifecycleEventsEnabled(bool in_enabled) = 0;
    virtual DispatchResponse startScreencast(std::optional<String> in_format, std::optional<int> in_quality, std::optional<int> in_maxWidth, std::optional<int> in_maxHeight, std::optional<int> in_everyNthFrame) = 0;
    virtual DispatchResponse stopLoading() = 0;
    virtual DispatchResponse stopScreencast() = 0;
    virtual DispatchResponse produceCompilationCache(std::unique_ptr<protocol::Array<protocol::Page::CompilationCacheParams>> in_scripts) = 0;
    virtual DispatchResponse addCompilationCache(const String& in_url, const Binary& in_data) = 0;
    virtual DispatchResponse clearCompilationCache() = 0;
    virtual DispatchResponse generateTestReport(const String& in_message, std::optional<String> in_group) = 0;
    virtual DispatchResponse waitForDebugger() = 0;
    virtual DispatchResponse setInterceptFileChooserDialog(bool in_enabled, std::optional<bool> in_cancel) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void domContentEventFired(double timestamp);
    void fileChooserOpened(const String& frameId, const String& mode, std::optional<int> backendNodeId = {});
    void frameAttached(const String& frameId, const String& parentFrameId, std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> stack = {});
    void frameClearedScheduledNavigation(const String& frameId);
    void frameDetached(const String& frameId, const String& reason);
    void frameSubtreeWillBeDetached(const String& frameId);
    void frameNavigated(std::unique_ptr<protocol::Page::Frame> frame, const String& type);
    void documentOpened(std::unique_ptr<protocol::Page::Frame> frame);
    void frameResized();
    void frameStartedNavigating(const String& frameId, const String& url, const String& loaderId, const String& navigationType);
    void frameRequestedNavigation(const String& frameId, const String& reason, const String& url, const String& disposition);
    void frameScheduledNavigation(const String& frameId, double delay, const String& reason, const String& url);
    void downloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename);
    void downloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state);
    void lifecycleEvent(const String& frameId, const String& loaderId, const String& name, double timestamp);
    void backForwardCacheNotUsed(const String& loaderId, const String& frameId, std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> notRestoredExplanations, std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree = {});
    void loadEventFired(double timestamp);
    void navigatedWithinDocument(const String& frameId, const String& url, const String& navigationType);
    void windowOpen(const String& url, const String& windowName, std::unique_ptr<protocol::Array<String>> windowFeatures, bool userGesture);
    void compilationCacheProduced(const String& url, const Binary& data);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Page
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Page_h)
