// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Media_h
#define blink_protocol_Media_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace Media {
using PlayerId = String;
using Timestamp = double;
class PlayerMessage;
class PlayerProperty;
class PlayerEvent;
class PlayerErrorSourceLocation;
class PlayerError;
class Player;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT PlayerMessage : public ::crdtp::ProtocolObject<PlayerMessage> {
public:
    ~PlayerMessage() override;  // Defined below

    struct CORE_EXPORT LevelEnum {
        static const char* Error;
        static const char* Warning;
        static const char* Info;
        static const char* Debug;
    }; // LevelEnum

    String getLevel() { return m_level; }
    void setLevel(const String& value);  // Defined below

    String getMessage() { return m_message; }
    void setMessage(const String& value);  // Defined below

    template<int STATE>
    class PlayerMessageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LevelSet = 1 << 1,
            MessageSet = 1 << 2,
            AllFieldsSet = (LevelSet | MessageSet | 0)};


        PlayerMessageBuilder<STATE | LevelSet>& setLevel(const String& value);  // Defined below

        PlayerMessageBuilder<STATE | MessageSet>& setMessage(const String& value);  // Defined below

        std::unique_ptr<PlayerMessage> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PlayerMessage;
        PlayerMessageBuilder() : m_result(new PlayerMessage()) { }

        template<int STEP> PlayerMessageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlayerMessageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Media::PlayerMessage> m_result;
    };

    static PlayerMessageBuilder<0> create()
    {
        return PlayerMessageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PlayerMessage();  // Defined below

    String m_level;
    String m_message;
};


class CORE_EXPORT PlayerProperty : public ::crdtp::ProtocolObject<PlayerProperty> {
public:
    ~PlayerProperty() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    template<int STATE>
    class PlayerPropertyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        PlayerPropertyBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        PlayerPropertyBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        std::unique_ptr<PlayerProperty> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PlayerProperty;
        PlayerPropertyBuilder() : m_result(new PlayerProperty()) { }

        template<int STEP> PlayerPropertyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlayerPropertyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Media::PlayerProperty> m_result;
    };

    static PlayerPropertyBuilder<0> create()
    {
        return PlayerPropertyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PlayerProperty();  // Defined below

    String m_name;
    String m_value;
};


class CORE_EXPORT PlayerEvent : public ::crdtp::ProtocolObject<PlayerEvent> {
public:
    ~PlayerEvent() override;  // Defined below

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    template<int STATE>
    class PlayerEventBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TimestampSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (TimestampSet | ValueSet | 0)};


        PlayerEventBuilder<STATE | TimestampSet>& setTimestamp(double value);  // Defined below

        PlayerEventBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        std::unique_ptr<PlayerEvent> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PlayerEvent;
        PlayerEventBuilder() : m_result(new PlayerEvent()) { }

        template<int STEP> PlayerEventBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlayerEventBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Media::PlayerEvent> m_result;
    };

    static PlayerEventBuilder<0> create()
    {
        return PlayerEventBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PlayerEvent();  // Defined below

    double m_timestamp;
    String m_value;
};


class CORE_EXPORT PlayerErrorSourceLocation : public ::crdtp::ProtocolObject<PlayerErrorSourceLocation> {
public:
    ~PlayerErrorSourceLocation() override;  // Defined below

    String getFile() { return m_file; }
    void setFile(const String& value);  // Defined below

    int getLine() { return m_line; }
    void setLine(int value);  // Defined below

    template<int STATE>
    class PlayerErrorSourceLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FileSet = 1 << 1,
            LineSet = 1 << 2,
            AllFieldsSet = (FileSet | LineSet | 0)};


        PlayerErrorSourceLocationBuilder<STATE | FileSet>& setFile(const String& value);  // Defined below

        PlayerErrorSourceLocationBuilder<STATE | LineSet>& setLine(int value);  // Defined below

        std::unique_ptr<PlayerErrorSourceLocation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PlayerErrorSourceLocation;
        PlayerErrorSourceLocationBuilder() : m_result(new PlayerErrorSourceLocation()) { }

        template<int STEP> PlayerErrorSourceLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlayerErrorSourceLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Media::PlayerErrorSourceLocation> m_result;
    };

    static PlayerErrorSourceLocationBuilder<0> create()
    {
        return PlayerErrorSourceLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PlayerErrorSourceLocation();  // Defined below

    String m_file;
    int m_line;
};


class CORE_EXPORT PlayerError : public ::crdtp::ProtocolObject<PlayerError> {
public:
    ~PlayerError() override;  // Defined below

    String getErrorType() { return m_errorType; }
    void setErrorType(const String& value);  // Defined below

    int getCode() { return m_code; }
    void setCode(int value);  // Defined below

    protocol::Array<protocol::Media::PlayerErrorSourceLocation>* getStack() { return m_stack.get(); }
    void setStack(std::unique_ptr<protocol::Array<protocol::Media::PlayerErrorSourceLocation>> value);  // Defined below

    protocol::Array<protocol::Media::PlayerError>* getCause() { return m_cause.get(); }
    void setCause(std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> value);  // Defined below

    protocol::DictionaryValue* getData() { return m_data.get(); }
    void setData(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

    template<int STATE>
    class PlayerErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorTypeSet = 1 << 1,
            CodeSet = 1 << 2,
            StackSet = 1 << 3,
            CauseSet = 1 << 4,
            DataSet = 1 << 5,
            AllFieldsSet = (ErrorTypeSet | CodeSet | StackSet | CauseSet | DataSet | 0)};


        PlayerErrorBuilder<STATE | ErrorTypeSet>& setErrorType(const String& value);  // Defined below

        PlayerErrorBuilder<STATE | CodeSet>& setCode(int value);  // Defined below

        PlayerErrorBuilder<STATE | StackSet>& setStack(std::unique_ptr<protocol::Array<protocol::Media::PlayerErrorSourceLocation>> value);  // Defined below

        PlayerErrorBuilder<STATE | CauseSet>& setCause(std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> value);  // Defined below

        PlayerErrorBuilder<STATE | DataSet>& setData(std::unique_ptr<protocol::DictionaryValue> value);  // Defined below

        std::unique_ptr<PlayerError> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PlayerError;
        PlayerErrorBuilder() : m_result(new PlayerError()) { }

        template<int STEP> PlayerErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlayerErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Media::PlayerError> m_result;
    };

    static PlayerErrorBuilder<0> create()
    {
        return PlayerErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PlayerError();  // Defined below

    String m_errorType;
    int m_code;
    std::unique_ptr<protocol::Array<protocol::Media::PlayerErrorSourceLocation>> m_stack;
    std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> m_cause;
    std::unique_ptr<protocol::DictionaryValue> m_data;
};


class CORE_EXPORT Player : public ::crdtp::ProtocolObject<Player> {
public:
    ~Player() override;  // Defined below

    String getPlayerId() { return m_playerId; }
    void setPlayerId(const String& value);  // Defined below

    bool hasDomNodeId() { return !!m_domNodeId; }
    int getDomNodeId(int defaultValue) const {
       return m_domNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getDomNodeId() const {
       return m_domNodeId;
    }
    void setDomNodeId(int value);  // Defined below

    template<int STATE>
    class PlayerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PlayerIdSet = 1 << 1,
            AllFieldsSet = (PlayerIdSet | 0)};


        PlayerBuilder<STATE | PlayerIdSet>& setPlayerId(const String& value);  // Defined below

        PlayerBuilder<STATE>& setDomNodeId(int value);  // Defined below

        std::unique_ptr<Player> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Player;
        PlayerBuilder() : m_result(new Player()) { }

        template<int STEP> PlayerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlayerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Media::Player> m_result;
    };

    static PlayerBuilder<0> create()
    {
        return PlayerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Player();  // Defined below

    String m_playerId;
    std::optional<int> m_domNodeId;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline PlayerMessage::~PlayerMessage() = default;
inline void PlayerMessage::setLevel(const String& value) { m_level = value; }
inline void PlayerMessage::setMessage(const String& value) { m_message = value; }

template<int STATE>
inline PlayerMessage::PlayerMessageBuilder<STATE | PlayerMessage::PlayerMessageBuilder<STATE>::LevelSet>&
PlayerMessage::PlayerMessageBuilder<STATE>::setLevel(const String& value) {
  static_assert(!(STATE & LevelSet), "property level should not be set yet");
  m_result->setLevel(value);
  return castState<LevelSet>();
}
template<int STATE>
inline PlayerMessage::PlayerMessageBuilder<STATE | PlayerMessage::PlayerMessageBuilder<STATE>::MessageSet>&
PlayerMessage::PlayerMessageBuilder<STATE>::setMessage(const String& value) {
  static_assert(!(STATE & MessageSet), "property message should not be set yet");
  m_result->setMessage(value);
  return castState<MessageSet>();
}

inline PlayerMessage::PlayerMessage() {
}
inline PlayerProperty::~PlayerProperty() = default;
inline void PlayerProperty::setName(const String& value) { m_name = value; }
inline void PlayerProperty::setValue(const String& value) { m_value = value; }

template<int STATE>
inline PlayerProperty::PlayerPropertyBuilder<STATE | PlayerProperty::PlayerPropertyBuilder<STATE>::NameSet>&
PlayerProperty::PlayerPropertyBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline PlayerProperty::PlayerPropertyBuilder<STATE | PlayerProperty::PlayerPropertyBuilder<STATE>::ValueSet>&
PlayerProperty::PlayerPropertyBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}

inline PlayerProperty::PlayerProperty() {
}
inline PlayerEvent::~PlayerEvent() = default;
inline void PlayerEvent::setTimestamp(double value) { m_timestamp = value; }
inline void PlayerEvent::setValue(const String& value) { m_value = value; }

template<int STATE>
inline PlayerEvent::PlayerEventBuilder<STATE | PlayerEvent::PlayerEventBuilder<STATE>::TimestampSet>&
PlayerEvent::PlayerEventBuilder<STATE>::setTimestamp(double value) {
  static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
  m_result->setTimestamp(value);
  return castState<TimestampSet>();
}
template<int STATE>
inline PlayerEvent::PlayerEventBuilder<STATE | PlayerEvent::PlayerEventBuilder<STATE>::ValueSet>&
PlayerEvent::PlayerEventBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}

inline PlayerEvent::PlayerEvent() {
  m_timestamp = 0;
}
inline PlayerErrorSourceLocation::~PlayerErrorSourceLocation() = default;
inline void PlayerErrorSourceLocation::setFile(const String& value) { m_file = value; }
inline void PlayerErrorSourceLocation::setLine(int value) { m_line = value; }

template<int STATE>
inline PlayerErrorSourceLocation::PlayerErrorSourceLocationBuilder<STATE | PlayerErrorSourceLocation::PlayerErrorSourceLocationBuilder<STATE>::FileSet>&
PlayerErrorSourceLocation::PlayerErrorSourceLocationBuilder<STATE>::setFile(const String& value) {
  static_assert(!(STATE & FileSet), "property file should not be set yet");
  m_result->setFile(value);
  return castState<FileSet>();
}
template<int STATE>
inline PlayerErrorSourceLocation::PlayerErrorSourceLocationBuilder<STATE | PlayerErrorSourceLocation::PlayerErrorSourceLocationBuilder<STATE>::LineSet>&
PlayerErrorSourceLocation::PlayerErrorSourceLocationBuilder<STATE>::setLine(int value) {
  static_assert(!(STATE & LineSet), "property line should not be set yet");
  m_result->setLine(value);
  return castState<LineSet>();
}

inline PlayerErrorSourceLocation::PlayerErrorSourceLocation() {
  m_line = 0;
}
inline PlayerError::~PlayerError() = default;
inline void PlayerError::setErrorType(const String& value) { m_errorType = value; }
inline void PlayerError::setCode(int value) { m_code = value; }
inline void PlayerError::setStack(std::unique_ptr<protocol::Array<protocol::Media::PlayerErrorSourceLocation>> value) { m_stack = std::move(value); }
inline void PlayerError::setCause(std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> value) { m_cause = std::move(value); }
inline void PlayerError::setData(std::unique_ptr<protocol::DictionaryValue> value) { m_data = std::move(value); }

template<int STATE>
inline PlayerError::PlayerErrorBuilder<STATE | PlayerError::PlayerErrorBuilder<STATE>::ErrorTypeSet>&
PlayerError::PlayerErrorBuilder<STATE>::setErrorType(const String& value) {
  static_assert(!(STATE & ErrorTypeSet), "property errorType should not be set yet");
  m_result->setErrorType(value);
  return castState<ErrorTypeSet>();
}
template<int STATE>
inline PlayerError::PlayerErrorBuilder<STATE | PlayerError::PlayerErrorBuilder<STATE>::CodeSet>&
PlayerError::PlayerErrorBuilder<STATE>::setCode(int value) {
  static_assert(!(STATE & CodeSet), "property code should not be set yet");
  m_result->setCode(value);
  return castState<CodeSet>();
}
template<int STATE>
inline PlayerError::PlayerErrorBuilder<STATE | PlayerError::PlayerErrorBuilder<STATE>::StackSet>&
PlayerError::PlayerErrorBuilder<STATE>::setStack(std::unique_ptr<protocol::Array<protocol::Media::PlayerErrorSourceLocation>> value) {
  static_assert(!(STATE & StackSet), "property stack should not be set yet");
  m_result->setStack(std::move(value));
  return castState<StackSet>();
}
template<int STATE>
inline PlayerError::PlayerErrorBuilder<STATE | PlayerError::PlayerErrorBuilder<STATE>::CauseSet>&
PlayerError::PlayerErrorBuilder<STATE>::setCause(std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> value) {
  static_assert(!(STATE & CauseSet), "property cause should not be set yet");
  m_result->setCause(std::move(value));
  return castState<CauseSet>();
}
template<int STATE>
inline PlayerError::PlayerErrorBuilder<STATE | PlayerError::PlayerErrorBuilder<STATE>::DataSet>&
PlayerError::PlayerErrorBuilder<STATE>::setData(std::unique_ptr<protocol::DictionaryValue> value) {
  static_assert(!(STATE & DataSet), "property data should not be set yet");
  m_result->setData(std::move(value));
  return castState<DataSet>();
}

inline PlayerError::PlayerError() {
  m_code = 0;
}
inline Player::~Player() = default;
inline void Player::setPlayerId(const String& value) { m_playerId = value; }
inline void Player::setDomNodeId(int value) { m_domNodeId = value; }

template<int STATE>
inline Player::PlayerBuilder<STATE | Player::PlayerBuilder<STATE>::PlayerIdSet>&
Player::PlayerBuilder<STATE>::setPlayerId(const String& value) {
  static_assert(!(STATE & PlayerIdSet), "property playerId should not be set yet");
  m_result->setPlayerId(value);
  return castState<PlayerIdSet>();
}
template<int STATE>
inline Player::PlayerBuilder<STATE>& Player::PlayerBuilder<STATE>::setDomNodeId(int value) {
  m_result->setDomNodeId(value);
  return *this;
}

inline Player::Player() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse disable() = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void playerPropertiesChanged(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerProperty>> properties);
    void playerEventsAdded(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerEvent>> events);
    void playerMessagesLogged(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerMessage>> messages);
    void playerErrorsRaised(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> errors);
    void playerCreated(std::unique_ptr<protocol::Media::Player> player);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Media
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Media_h)
