// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Log_h
#define blink_protocol_Log_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"
#include "third_party/blink/renderer/core/inspector/protocol/network.h"

namespace blink {
namespace protocol {
namespace Log {
class LogEntry;
class ViolationSetting;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT LogEntry : public ::crdtp::ProtocolObject<LogEntry> {
public:
    ~LogEntry() override;  // Defined below

    struct CORE_EXPORT SourceEnum {
        static const char* Xml;
        static const char* Javascript;
        static const char* Network;
        static const char* Storage;
        static const char* Appcache;
        static const char* Rendering;
        static const char* Security;
        static const char* Deprecation;
        static const char* Worker;
        static const char* Violation;
        static const char* Intervention;
        static const char* Recommendation;
        static const char* Other;
    }; // SourceEnum

    String getSource() { return m_source; }
    void setSource(const String& value);  // Defined below

    struct CORE_EXPORT LevelEnum {
        static const char* Verbose;
        static const char* Info;
        static const char* Warning;
        static const char* Error;
    }; // LevelEnum

    String getLevel() { return m_level; }
    void setLevel(const String& value);  // Defined below

    String getText() { return m_text; }
    void setText(const String& value);  // Defined below

    struct CORE_EXPORT CategoryEnum {
        static const char* Cors;
    }; // CategoryEnum

    bool hasCategory() { return !!m_category; }
    String getCategory(const String& defaultValue) const {
       return m_category.value_or(defaultValue);
    }
    const std::optional<String>& getCategory() const {
       return m_category;
    }
    void setCategory(const String& value);  // Defined below

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value);  // Defined below

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value);  // Defined below

    bool hasLineNumber() { return !!m_lineNumber; }
    int getLineNumber(int defaultValue) const {
       return m_lineNumber.value_or(defaultValue);
    }
    const std::optional<int>& getLineNumber() const {
       return m_lineNumber;
    }
    void setLineNumber(int value);  // Defined below

    bool hasStackTrace() { return !!m_stackTrace; }
    v8_inspector::protocol::Runtime::API::StackTrace* getStackTrace(v8_inspector::protocol::Runtime::API::StackTrace* defaultValue) {
       return m_stackTrace ? m_stackTrace.get() : defaultValue;
    }
    const std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace>& getStackTrace() const {
       return m_stackTrace;
    }
    void setStackTrace(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value);  // Defined below

    bool hasNetworkRequestId() { return !!m_networkRequestId; }
    String getNetworkRequestId(const String& defaultValue) const {
       return m_networkRequestId.value_or(defaultValue);
    }
    const std::optional<String>& getNetworkRequestId() const {
       return m_networkRequestId;
    }
    void setNetworkRequestId(const String& value);  // Defined below

    bool hasWorkerId() { return !!m_workerId; }
    String getWorkerId(const String& defaultValue) const {
       return m_workerId.value_or(defaultValue);
    }
    const std::optional<String>& getWorkerId() const {
       return m_workerId;
    }
    void setWorkerId(const String& value);  // Defined below

    bool hasArgs() { return !!m_args; }
    protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>* getArgs(protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>* defaultValue) {
       return m_args ? m_args.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>>& getArgs() const {
       return m_args;
    }
    void setArgs(std::unique_ptr<protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>> value);  // Defined below

    template<int STATE>
    class LogEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceSet = 1 << 1,
            LevelSet = 1 << 2,
            TextSet = 1 << 3,
            TimestampSet = 1 << 4,
            AllFieldsSet = (SourceSet | LevelSet | TextSet | TimestampSet | 0)};


        LogEntryBuilder<STATE | SourceSet>& setSource(const String& value);  // Defined below

        LogEntryBuilder<STATE | LevelSet>& setLevel(const String& value);  // Defined below

        LogEntryBuilder<STATE | TextSet>& setText(const String& value);  // Defined below

        LogEntryBuilder<STATE>& setCategory(const String& value);  // Defined below

        LogEntryBuilder<STATE | TimestampSet>& setTimestamp(double value);  // Defined below

        LogEntryBuilder<STATE>& setUrl(const String& value);  // Defined below

        LogEntryBuilder<STATE>& setLineNumber(int value);  // Defined below

        LogEntryBuilder<STATE>& setStackTrace(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value);  // Defined below

        LogEntryBuilder<STATE>& setNetworkRequestId(const String& value);  // Defined below

        LogEntryBuilder<STATE>& setWorkerId(const String& value);  // Defined below

        LogEntryBuilder<STATE>& setArgs(std::unique_ptr<protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>> value);  // Defined below

        std::unique_ptr<LogEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LogEntry;
        LogEntryBuilder() : m_result(new LogEntry()) { }

        template<int STEP> LogEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LogEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Log::LogEntry> m_result;
    };

    static LogEntryBuilder<0> create()
    {
        return LogEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LogEntry();  // Defined below

    String m_source;
    String m_level;
    String m_text;
    std::optional<String> m_category;
    double m_timestamp;
    std::optional<String> m_url;
    std::optional<int> m_lineNumber;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> m_stackTrace;
    std::optional<String> m_networkRequestId;
    std::optional<String> m_workerId;
    std::unique_ptr<protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>> m_args;
};


class CORE_EXPORT ViolationSetting : public ::crdtp::ProtocolObject<ViolationSetting> {
public:
    ~ViolationSetting() override;  // Defined below

    struct CORE_EXPORT NameEnum {
        static const char* LongTask;
        static const char* LongLayout;
        static const char* BlockedEvent;
        static const char* BlockedParser;
        static const char* DiscouragedAPIUse;
        static const char* Handler;
        static const char* RecurringHandler;
    }; // NameEnum

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    double getThreshold() { return m_threshold; }
    void setThreshold(double value);  // Defined below

    template<int STATE>
    class ViolationSettingBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ThresholdSet = 1 << 2,
            AllFieldsSet = (NameSet | ThresholdSet | 0)};


        ViolationSettingBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        ViolationSettingBuilder<STATE | ThresholdSet>& setThreshold(double value);  // Defined below

        std::unique_ptr<ViolationSetting> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ViolationSetting;
        ViolationSettingBuilder() : m_result(new ViolationSetting()) { }

        template<int STEP> ViolationSettingBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ViolationSettingBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Log::ViolationSetting> m_result;
    };

    static ViolationSettingBuilder<0> create()
    {
        return ViolationSettingBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ViolationSetting();  // Defined below

    String m_name;
    double m_threshold;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline LogEntry::~LogEntry() = default;
inline void LogEntry::setSource(const String& value) { m_source = value; }
inline void LogEntry::setLevel(const String& value) { m_level = value; }
inline void LogEntry::setText(const String& value) { m_text = value; }
inline void LogEntry::setCategory(const String& value) { m_category = value; }
inline void LogEntry::setTimestamp(double value) { m_timestamp = value; }
inline void LogEntry::setUrl(const String& value) { m_url = value; }
inline void LogEntry::setLineNumber(int value) { m_lineNumber = value; }
inline void LogEntry::setStackTrace(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value) { m_stackTrace = std::move(value); }
inline void LogEntry::setNetworkRequestId(const String& value) { m_networkRequestId = value; }
inline void LogEntry::setWorkerId(const String& value) { m_workerId = value; }
inline void LogEntry::setArgs(std::unique_ptr<protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>> value) { m_args = std::move(value); }

template<int STATE>
inline LogEntry::LogEntryBuilder<STATE | LogEntry::LogEntryBuilder<STATE>::SourceSet>&
LogEntry::LogEntryBuilder<STATE>::setSource(const String& value) {
  static_assert(!(STATE & SourceSet), "property source should not be set yet");
  m_result->setSource(value);
  return castState<SourceSet>();
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE | LogEntry::LogEntryBuilder<STATE>::LevelSet>&
LogEntry::LogEntryBuilder<STATE>::setLevel(const String& value) {
  static_assert(!(STATE & LevelSet), "property level should not be set yet");
  m_result->setLevel(value);
  return castState<LevelSet>();
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE | LogEntry::LogEntryBuilder<STATE>::TextSet>&
LogEntry::LogEntryBuilder<STATE>::setText(const String& value) {
  static_assert(!(STATE & TextSet), "property text should not be set yet");
  m_result->setText(value);
  return castState<TextSet>();
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setCategory(const String& value) {
  m_result->setCategory(value);
  return *this;
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE | LogEntry::LogEntryBuilder<STATE>::TimestampSet>&
LogEntry::LogEntryBuilder<STATE>::setTimestamp(double value) {
  static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
  m_result->setTimestamp(value);
  return castState<TimestampSet>();
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setUrl(const String& value) {
  m_result->setUrl(value);
  return *this;
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setLineNumber(int value) {
  m_result->setLineNumber(value);
  return *this;
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setStackTrace(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value) {
  m_result->setStackTrace(std::move(value));
  return *this;
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setNetworkRequestId(const String& value) {
  m_result->setNetworkRequestId(value);
  return *this;
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setWorkerId(const String& value) {
  m_result->setWorkerId(value);
  return *this;
}
template<int STATE>
inline LogEntry::LogEntryBuilder<STATE>& LogEntry::LogEntryBuilder<STATE>::setArgs(std::unique_ptr<protocol::Array<v8_inspector::protocol::Runtime::API::RemoteObject>> value) {
  m_result->setArgs(std::move(value));
  return *this;
}

inline LogEntry::LogEntry() {
  m_timestamp = 0;
}
inline ViolationSetting::~ViolationSetting() = default;
inline void ViolationSetting::setName(const String& value) { m_name = value; }
inline void ViolationSetting::setThreshold(double value) { m_threshold = value; }

template<int STATE>
inline ViolationSetting::ViolationSettingBuilder<STATE | ViolationSetting::ViolationSettingBuilder<STATE>::NameSet>&
ViolationSetting::ViolationSettingBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline ViolationSetting::ViolationSettingBuilder<STATE | ViolationSetting::ViolationSettingBuilder<STATE>::ThresholdSet>&
ViolationSetting::ViolationSettingBuilder<STATE>::setThreshold(double value) {
  static_assert(!(STATE & ThresholdSet), "property threshold should not be set yet");
  m_result->setThreshold(value);
  return castState<ThresholdSet>();
}

inline ViolationSetting::ViolationSetting() {
  m_threshold = 0;
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse clear() = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse startViolationsReport(std::unique_ptr<protocol::Array<protocol::Log::ViolationSetting>> in_config) = 0;
    virtual DispatchResponse stopViolationsReport() = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void entryAdded(std::unique_ptr<protocol::Log::LogEntry> entry);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Log
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Log_h)
