// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_IndexedDB_h
#define blink_protocol_IndexedDB_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"
#include "third_party/blink/renderer/core/inspector/protocol/storage.h"

namespace blink {
namespace protocol {
namespace IndexedDB {
class DatabaseWithObjectStores;
class ObjectStore;
class ObjectStoreIndex;
class Key;
class KeyRange;
class DataEntry;
class KeyPath;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT DatabaseWithObjectStores : public ::crdtp::ProtocolObject<DatabaseWithObjectStores> {
public:
    ~DatabaseWithObjectStores() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    double getVersion() { return m_version; }
    void setVersion(double value);  // Defined below

    protocol::Array<protocol::IndexedDB::ObjectStore>* getObjectStores() { return m_objectStores.get(); }
    void setObjectStores(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStore>> value);  // Defined below

    template<int STATE>
    class DatabaseWithObjectStoresBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            VersionSet = 1 << 2,
            ObjectStoresSet = 1 << 3,
            AllFieldsSet = (NameSet | VersionSet | ObjectStoresSet | 0)};


        DatabaseWithObjectStoresBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        DatabaseWithObjectStoresBuilder<STATE | VersionSet>& setVersion(double value);  // Defined below

        DatabaseWithObjectStoresBuilder<STATE | ObjectStoresSet>& setObjectStores(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStore>> value);  // Defined below

        std::unique_ptr<DatabaseWithObjectStores> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DatabaseWithObjectStores;
        DatabaseWithObjectStoresBuilder() : m_result(new DatabaseWithObjectStores()) { }

        template<int STEP> DatabaseWithObjectStoresBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DatabaseWithObjectStoresBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::DatabaseWithObjectStores> m_result;
    };

    static DatabaseWithObjectStoresBuilder<0> create()
    {
        return DatabaseWithObjectStoresBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DatabaseWithObjectStores();  // Defined below

    String m_name;
    double m_version;
    std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStore>> m_objectStores;
};


class CORE_EXPORT ObjectStore : public ::crdtp::ProtocolObject<ObjectStore> {
public:
    ~ObjectStore() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    protocol::IndexedDB::KeyPath* getKeyPath() { return m_keyPath.get(); }
    void setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value);  // Defined below

    bool getAutoIncrement() { return m_autoIncrement; }
    void setAutoIncrement(bool value);  // Defined below

    protocol::Array<protocol::IndexedDB::ObjectStoreIndex>* getIndexes() { return m_indexes.get(); }
    void setIndexes(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStoreIndex>> value);  // Defined below

    template<int STATE>
    class ObjectStoreBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            KeyPathSet = 1 << 2,
            AutoIncrementSet = 1 << 3,
            IndexesSet = 1 << 4,
            AllFieldsSet = (NameSet | KeyPathSet | AutoIncrementSet | IndexesSet | 0)};


        ObjectStoreBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        ObjectStoreBuilder<STATE | KeyPathSet>& setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value);  // Defined below

        ObjectStoreBuilder<STATE | AutoIncrementSet>& setAutoIncrement(bool value);  // Defined below

        ObjectStoreBuilder<STATE | IndexesSet>& setIndexes(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStoreIndex>> value);  // Defined below

        std::unique_ptr<ObjectStore> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ObjectStore;
        ObjectStoreBuilder() : m_result(new ObjectStore()) { }

        template<int STEP> ObjectStoreBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ObjectStoreBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::ObjectStore> m_result;
    };

    static ObjectStoreBuilder<0> create()
    {
        return ObjectStoreBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ObjectStore();  // Defined below

    String m_name;
    std::unique_ptr<protocol::IndexedDB::KeyPath> m_keyPath;
    bool m_autoIncrement;
    std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStoreIndex>> m_indexes;
};


class CORE_EXPORT ObjectStoreIndex : public ::crdtp::ProtocolObject<ObjectStoreIndex> {
public:
    ~ObjectStoreIndex() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    protocol::IndexedDB::KeyPath* getKeyPath() { return m_keyPath.get(); }
    void setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value);  // Defined below

    bool getUnique() { return m_unique; }
    void setUnique(bool value);  // Defined below

    bool getMultiEntry() { return m_multiEntry; }
    void setMultiEntry(bool value);  // Defined below

    template<int STATE>
    class ObjectStoreIndexBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            KeyPathSet = 1 << 2,
            UniqueSet = 1 << 3,
            MultiEntrySet = 1 << 4,
            AllFieldsSet = (NameSet | KeyPathSet | UniqueSet | MultiEntrySet | 0)};


        ObjectStoreIndexBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        ObjectStoreIndexBuilder<STATE | KeyPathSet>& setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value);  // Defined below

        ObjectStoreIndexBuilder<STATE | UniqueSet>& setUnique(bool value);  // Defined below

        ObjectStoreIndexBuilder<STATE | MultiEntrySet>& setMultiEntry(bool value);  // Defined below

        std::unique_ptr<ObjectStoreIndex> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ObjectStoreIndex;
        ObjectStoreIndexBuilder() : m_result(new ObjectStoreIndex()) { }

        template<int STEP> ObjectStoreIndexBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ObjectStoreIndexBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::ObjectStoreIndex> m_result;
    };

    static ObjectStoreIndexBuilder<0> create()
    {
        return ObjectStoreIndexBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ObjectStoreIndex();  // Defined below

    String m_name;
    std::unique_ptr<protocol::IndexedDB::KeyPath> m_keyPath;
    bool m_unique;
    bool m_multiEntry;
};


class CORE_EXPORT Key : public ::crdtp::ProtocolObject<Key> {
public:
    ~Key() override;  // Defined below

    struct CORE_EXPORT TypeEnum {
        static const char* Number;
        static const char* String;
        static const char* Date;
        static const char* Array;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasNumber() { return !!m_number; }
    double getNumber(double defaultValue) const {
       return m_number.value_or(defaultValue);
    }
    const std::optional<double>& getNumber() const {
       return m_number;
    }
    void setNumber(double value);  // Defined below

    bool hasString() { return !!m_string; }
    String getString(const String& defaultValue) const {
       return m_string.value_or(defaultValue);
    }
    const std::optional<String>& getString() const {
       return m_string;
    }
    void setString(const String& value);  // Defined below

    bool hasDate() { return !!m_date; }
    double getDate(double defaultValue) const {
       return m_date.value_or(defaultValue);
    }
    const std::optional<double>& getDate() const {
       return m_date;
    }
    void setDate(double value);  // Defined below

    bool hasArray() { return !!m_array; }
    protocol::Array<protocol::IndexedDB::Key>* getArray(protocol::Array<protocol::IndexedDB::Key>* defaultValue) {
       return m_array ? m_array.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::IndexedDB::Key>>& getArray() const {
       return m_array;
    }
    void setArray(std::unique_ptr<protocol::Array<protocol::IndexedDB::Key>> value);  // Defined below

    template<int STATE>
    class KeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        KeyBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        KeyBuilder<STATE>& setNumber(double value);  // Defined below

        KeyBuilder<STATE>& setString(const String& value);  // Defined below

        KeyBuilder<STATE>& setDate(double value);  // Defined below

        KeyBuilder<STATE>& setArray(std::unique_ptr<protocol::Array<protocol::IndexedDB::Key>> value);  // Defined below

        std::unique_ptr<Key> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Key;
        KeyBuilder() : m_result(new Key()) { }

        template<int STEP> KeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<KeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::Key> m_result;
    };

    static KeyBuilder<0> create()
    {
        return KeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Key();  // Defined below

    String m_type;
    std::optional<double> m_number;
    std::optional<String> m_string;
    std::optional<double> m_date;
    std::unique_ptr<protocol::Array<protocol::IndexedDB::Key>> m_array;
};


class CORE_EXPORT KeyRange : public ::crdtp::ProtocolObject<KeyRange> {
public:
    ~KeyRange() override;  // Defined below

    bool hasLower() { return !!m_lower; }
    protocol::IndexedDB::Key* getLower(protocol::IndexedDB::Key* defaultValue) {
       return m_lower ? m_lower.get() : defaultValue;
    }
    const std::unique_ptr<protocol::IndexedDB::Key>& getLower() const {
       return m_lower;
    }
    void setLower(std::unique_ptr<protocol::IndexedDB::Key> value);  // Defined below

    bool hasUpper() { return !!m_upper; }
    protocol::IndexedDB::Key* getUpper(protocol::IndexedDB::Key* defaultValue) {
       return m_upper ? m_upper.get() : defaultValue;
    }
    const std::unique_ptr<protocol::IndexedDB::Key>& getUpper() const {
       return m_upper;
    }
    void setUpper(std::unique_ptr<protocol::IndexedDB::Key> value);  // Defined below

    bool getLowerOpen() { return m_lowerOpen; }
    void setLowerOpen(bool value);  // Defined below

    bool getUpperOpen() { return m_upperOpen; }
    void setUpperOpen(bool value);  // Defined below

    template<int STATE>
    class KeyRangeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LowerOpenSet = 1 << 1,
            UpperOpenSet = 1 << 2,
            AllFieldsSet = (LowerOpenSet | UpperOpenSet | 0)};


        KeyRangeBuilder<STATE>& setLower(std::unique_ptr<protocol::IndexedDB::Key> value);  // Defined below

        KeyRangeBuilder<STATE>& setUpper(std::unique_ptr<protocol::IndexedDB::Key> value);  // Defined below

        KeyRangeBuilder<STATE | LowerOpenSet>& setLowerOpen(bool value);  // Defined below

        KeyRangeBuilder<STATE | UpperOpenSet>& setUpperOpen(bool value);  // Defined below

        std::unique_ptr<KeyRange> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class KeyRange;
        KeyRangeBuilder() : m_result(new KeyRange()) { }

        template<int STEP> KeyRangeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<KeyRangeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::KeyRange> m_result;
    };

    static KeyRangeBuilder<0> create()
    {
        return KeyRangeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    KeyRange();  // Defined below

    std::unique_ptr<protocol::IndexedDB::Key> m_lower;
    std::unique_ptr<protocol::IndexedDB::Key> m_upper;
    bool m_lowerOpen;
    bool m_upperOpen;
};


class CORE_EXPORT DataEntry : public ::crdtp::ProtocolObject<DataEntry> {
public:
    ~DataEntry() override;  // Defined below

    v8_inspector::protocol::Runtime::API::RemoteObject* getKey() { return m_key.get(); }
    void setKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

    v8_inspector::protocol::Runtime::API::RemoteObject* getPrimaryKey() { return m_primaryKey.get(); }
    void setPrimaryKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

    v8_inspector::protocol::Runtime::API::RemoteObject* getValue() { return m_value.get(); }
    void setValue(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

    template<int STATE>
    class DataEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            PrimaryKeySet = 1 << 2,
            ValueSet = 1 << 3,
            AllFieldsSet = (KeySet | PrimaryKeySet | ValueSet | 0)};


        DataEntryBuilder<STATE | KeySet>& setKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

        DataEntryBuilder<STATE | PrimaryKeySet>& setPrimaryKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

        DataEntryBuilder<STATE | ValueSet>& setValue(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

        std::unique_ptr<DataEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DataEntry;
        DataEntryBuilder() : m_result(new DataEntry()) { }

        template<int STEP> DataEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DataEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::DataEntry> m_result;
    };

    static DataEntryBuilder<0> create()
    {
        return DataEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DataEntry();  // Defined below

    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> m_key;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> m_primaryKey;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> m_value;
};


class CORE_EXPORT KeyPath : public ::crdtp::ProtocolObject<KeyPath> {
public:
    ~KeyPath() override;  // Defined below

    struct CORE_EXPORT TypeEnum {
        static const char* Null;
        static const char* String;
        static const char* Array;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasString() { return !!m_string; }
    String getString(const String& defaultValue) const {
       return m_string.value_or(defaultValue);
    }
    const std::optional<String>& getString() const {
       return m_string;
    }
    void setString(const String& value);  // Defined below

    bool hasArray() { return !!m_array; }
    protocol::Array<String>* getArray(protocol::Array<String>* defaultValue) {
       return m_array ? m_array.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getArray() const {
       return m_array;
    }
    void setArray(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class KeyPathBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        KeyPathBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        KeyPathBuilder<STATE>& setString(const String& value);  // Defined below

        KeyPathBuilder<STATE>& setArray(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<KeyPath> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class KeyPath;
        KeyPathBuilder() : m_result(new KeyPath()) { }

        template<int STEP> KeyPathBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<KeyPathBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::IndexedDB::KeyPath> m_result;
    };

    static KeyPathBuilder<0> create()
    {
        return KeyPathBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    KeyPath();  // Defined below

    String m_type;
    std::optional<String> m_string;
    std::unique_ptr<protocol::Array<String>> m_array;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline DatabaseWithObjectStores::~DatabaseWithObjectStores() = default;
inline void DatabaseWithObjectStores::setName(const String& value) { m_name = value; }
inline void DatabaseWithObjectStores::setVersion(double value) { m_version = value; }
inline void DatabaseWithObjectStores::setObjectStores(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStore>> value) { m_objectStores = std::move(value); }

template<int STATE>
inline DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE | DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE>::NameSet>&
DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE | DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE>::VersionSet>&
DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE>::setVersion(double value) {
  static_assert(!(STATE & VersionSet), "property version should not be set yet");
  m_result->setVersion(value);
  return castState<VersionSet>();
}
template<int STATE>
inline DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE | DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE>::ObjectStoresSet>&
DatabaseWithObjectStores::DatabaseWithObjectStoresBuilder<STATE>::setObjectStores(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStore>> value) {
  static_assert(!(STATE & ObjectStoresSet), "property objectStores should not be set yet");
  m_result->setObjectStores(std::move(value));
  return castState<ObjectStoresSet>();
}

inline DatabaseWithObjectStores::DatabaseWithObjectStores() {
  m_version = 0;
}
inline ObjectStore::~ObjectStore() = default;
inline void ObjectStore::setName(const String& value) { m_name = value; }
inline void ObjectStore::setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value) { m_keyPath = std::move(value); }
inline void ObjectStore::setAutoIncrement(bool value) { m_autoIncrement = value; }
inline void ObjectStore::setIndexes(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStoreIndex>> value) { m_indexes = std::move(value); }

template<int STATE>
inline ObjectStore::ObjectStoreBuilder<STATE | ObjectStore::ObjectStoreBuilder<STATE>::NameSet>&
ObjectStore::ObjectStoreBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline ObjectStore::ObjectStoreBuilder<STATE | ObjectStore::ObjectStoreBuilder<STATE>::KeyPathSet>&
ObjectStore::ObjectStoreBuilder<STATE>::setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value) {
  static_assert(!(STATE & KeyPathSet), "property keyPath should not be set yet");
  m_result->setKeyPath(std::move(value));
  return castState<KeyPathSet>();
}
template<int STATE>
inline ObjectStore::ObjectStoreBuilder<STATE | ObjectStore::ObjectStoreBuilder<STATE>::AutoIncrementSet>&
ObjectStore::ObjectStoreBuilder<STATE>::setAutoIncrement(bool value) {
  static_assert(!(STATE & AutoIncrementSet), "property autoIncrement should not be set yet");
  m_result->setAutoIncrement(value);
  return castState<AutoIncrementSet>();
}
template<int STATE>
inline ObjectStore::ObjectStoreBuilder<STATE | ObjectStore::ObjectStoreBuilder<STATE>::IndexesSet>&
ObjectStore::ObjectStoreBuilder<STATE>::setIndexes(std::unique_ptr<protocol::Array<protocol::IndexedDB::ObjectStoreIndex>> value) {
  static_assert(!(STATE & IndexesSet), "property indexes should not be set yet");
  m_result->setIndexes(std::move(value));
  return castState<IndexesSet>();
}

inline ObjectStore::ObjectStore() {
  m_autoIncrement = false;
}
inline ObjectStoreIndex::~ObjectStoreIndex() = default;
inline void ObjectStoreIndex::setName(const String& value) { m_name = value; }
inline void ObjectStoreIndex::setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value) { m_keyPath = std::move(value); }
inline void ObjectStoreIndex::setUnique(bool value) { m_unique = value; }
inline void ObjectStoreIndex::setMultiEntry(bool value) { m_multiEntry = value; }

template<int STATE>
inline ObjectStoreIndex::ObjectStoreIndexBuilder<STATE | ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::NameSet>&
ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline ObjectStoreIndex::ObjectStoreIndexBuilder<STATE | ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::KeyPathSet>&
ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::setKeyPath(std::unique_ptr<protocol::IndexedDB::KeyPath> value) {
  static_assert(!(STATE & KeyPathSet), "property keyPath should not be set yet");
  m_result->setKeyPath(std::move(value));
  return castState<KeyPathSet>();
}
template<int STATE>
inline ObjectStoreIndex::ObjectStoreIndexBuilder<STATE | ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::UniqueSet>&
ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::setUnique(bool value) {
  static_assert(!(STATE & UniqueSet), "property unique should not be set yet");
  m_result->setUnique(value);
  return castState<UniqueSet>();
}
template<int STATE>
inline ObjectStoreIndex::ObjectStoreIndexBuilder<STATE | ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::MultiEntrySet>&
ObjectStoreIndex::ObjectStoreIndexBuilder<STATE>::setMultiEntry(bool value) {
  static_assert(!(STATE & MultiEntrySet), "property multiEntry should not be set yet");
  m_result->setMultiEntry(value);
  return castState<MultiEntrySet>();
}

inline ObjectStoreIndex::ObjectStoreIndex() {
  m_unique = false;
  m_multiEntry = false;
}
inline Key::~Key() = default;
inline void Key::setType(const String& value) { m_type = value; }
inline void Key::setNumber(double value) { m_number = value; }
inline void Key::setString(const String& value) { m_string = value; }
inline void Key::setDate(double value) { m_date = value; }
inline void Key::setArray(std::unique_ptr<protocol::Array<protocol::IndexedDB::Key>> value) { m_array = std::move(value); }

template<int STATE>
inline Key::KeyBuilder<STATE | Key::KeyBuilder<STATE>::TypeSet>&
Key::KeyBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline Key::KeyBuilder<STATE>& Key::KeyBuilder<STATE>::setNumber(double value) {
  m_result->setNumber(value);
  return *this;
}
template<int STATE>
inline Key::KeyBuilder<STATE>& Key::KeyBuilder<STATE>::setString(const String& value) {
  m_result->setString(value);
  return *this;
}
template<int STATE>
inline Key::KeyBuilder<STATE>& Key::KeyBuilder<STATE>::setDate(double value) {
  m_result->setDate(value);
  return *this;
}
template<int STATE>
inline Key::KeyBuilder<STATE>& Key::KeyBuilder<STATE>::setArray(std::unique_ptr<protocol::Array<protocol::IndexedDB::Key>> value) {
  m_result->setArray(std::move(value));
  return *this;
}

inline Key::Key() {
}
inline KeyRange::~KeyRange() = default;
inline void KeyRange::setLower(std::unique_ptr<protocol::IndexedDB::Key> value) { m_lower = std::move(value); }
inline void KeyRange::setUpper(std::unique_ptr<protocol::IndexedDB::Key> value) { m_upper = std::move(value); }
inline void KeyRange::setLowerOpen(bool value) { m_lowerOpen = value; }
inline void KeyRange::setUpperOpen(bool value) { m_upperOpen = value; }

template<int STATE>
inline KeyRange::KeyRangeBuilder<STATE>& KeyRange::KeyRangeBuilder<STATE>::setLower(std::unique_ptr<protocol::IndexedDB::Key> value) {
  m_result->setLower(std::move(value));
  return *this;
}
template<int STATE>
inline KeyRange::KeyRangeBuilder<STATE>& KeyRange::KeyRangeBuilder<STATE>::setUpper(std::unique_ptr<protocol::IndexedDB::Key> value) {
  m_result->setUpper(std::move(value));
  return *this;
}
template<int STATE>
inline KeyRange::KeyRangeBuilder<STATE | KeyRange::KeyRangeBuilder<STATE>::LowerOpenSet>&
KeyRange::KeyRangeBuilder<STATE>::setLowerOpen(bool value) {
  static_assert(!(STATE & LowerOpenSet), "property lowerOpen should not be set yet");
  m_result->setLowerOpen(value);
  return castState<LowerOpenSet>();
}
template<int STATE>
inline KeyRange::KeyRangeBuilder<STATE | KeyRange::KeyRangeBuilder<STATE>::UpperOpenSet>&
KeyRange::KeyRangeBuilder<STATE>::setUpperOpen(bool value) {
  static_assert(!(STATE & UpperOpenSet), "property upperOpen should not be set yet");
  m_result->setUpperOpen(value);
  return castState<UpperOpenSet>();
}

inline KeyRange::KeyRange() {
  m_lowerOpen = false;
  m_upperOpen = false;
}
inline DataEntry::~DataEntry() = default;
inline void DataEntry::setKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) { m_key = std::move(value); }
inline void DataEntry::setPrimaryKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) { m_primaryKey = std::move(value); }
inline void DataEntry::setValue(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) { m_value = std::move(value); }

template<int STATE>
inline DataEntry::DataEntryBuilder<STATE | DataEntry::DataEntryBuilder<STATE>::KeySet>&
DataEntry::DataEntryBuilder<STATE>::setKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(std::move(value));
  return castState<KeySet>();
}
template<int STATE>
inline DataEntry::DataEntryBuilder<STATE | DataEntry::DataEntryBuilder<STATE>::PrimaryKeySet>&
DataEntry::DataEntryBuilder<STATE>::setPrimaryKey(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) {
  static_assert(!(STATE & PrimaryKeySet), "property primaryKey should not be set yet");
  m_result->setPrimaryKey(std::move(value));
  return castState<PrimaryKeySet>();
}
template<int STATE>
inline DataEntry::DataEntryBuilder<STATE | DataEntry::DataEntryBuilder<STATE>::ValueSet>&
DataEntry::DataEntryBuilder<STATE>::setValue(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(std::move(value));
  return castState<ValueSet>();
}

inline DataEntry::DataEntry() {
}
inline KeyPath::~KeyPath() = default;
inline void KeyPath::setType(const String& value) { m_type = value; }
inline void KeyPath::setString(const String& value) { m_string = value; }
inline void KeyPath::setArray(std::unique_ptr<protocol::Array<String>> value) { m_array = std::move(value); }

template<int STATE>
inline KeyPath::KeyPathBuilder<STATE | KeyPath::KeyPathBuilder<STATE>::TypeSet>&
KeyPath::KeyPathBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline KeyPath::KeyPathBuilder<STATE>& KeyPath::KeyPathBuilder<STATE>::setString(const String& value) {
  m_result->setString(value);
  return *this;
}
template<int STATE>
inline KeyPath::KeyPathBuilder<STATE>& KeyPath::KeyPathBuilder<STATE>::setArray(std::unique_ptr<protocol::Array<String>> value) {
  m_result->setArray(std::move(value));
  return *this;
}

inline KeyPath::KeyPath() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CORE_EXPORT ClearObjectStoreCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ClearObjectStoreCallback() { }
    };
    virtual void clearObjectStore(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, const String& in_databaseName, const String& in_objectStoreName, std::unique_ptr<ClearObjectStoreCallback> callback) = 0;
    class CORE_EXPORT DeleteDatabaseCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DeleteDatabaseCallback() { }
    };
    virtual void deleteDatabase(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, const String& in_databaseName, std::unique_ptr<DeleteDatabaseCallback> callback) = 0;
    class CORE_EXPORT DeleteObjectStoreEntriesCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DeleteObjectStoreEntriesCallback() { }
    };
    virtual void deleteObjectStoreEntries(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, const String& in_databaseName, const String& in_objectStoreName, std::unique_ptr<protocol::IndexedDB::KeyRange> in_keyRange, std::unique_ptr<DeleteObjectStoreEntriesCallback> callback) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    class CORE_EXPORT RequestDataCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::IndexedDB::DataEntry>> objectStoreDataEntries, bool hasMore) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RequestDataCallback() { }
    };
    virtual void requestData(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, const String& in_databaseName, const String& in_objectStoreName, std::optional<String> in_indexName, int in_skipCount, int in_pageSize, std::unique_ptr<protocol::IndexedDB::KeyRange> in_keyRange, std::unique_ptr<RequestDataCallback> callback) = 0;
    class CORE_EXPORT GetMetadataCallback {
    public:
        virtual void sendSuccess(double entriesCount, double keyGeneratorValue) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetMetadataCallback() { }
    };
    virtual void getMetadata(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, const String& in_databaseName, const String& in_objectStoreName, std::unique_ptr<GetMetadataCallback> callback) = 0;
    class CORE_EXPORT RequestDatabaseCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::IndexedDB::DatabaseWithObjectStores> databaseWithObjectStores) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RequestDatabaseCallback() { }
    };
    virtual void requestDatabase(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, const String& in_databaseName, std::unique_ptr<RequestDatabaseCallback> callback) = 0;
    class CORE_EXPORT RequestDatabaseNamesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<String>> databaseNames) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RequestDatabaseNamesCallback() { }
    };
    virtual void requestDatabaseNames(std::optional<String> in_securityOrigin, std::optional<String> in_storageKey, std::unique_ptr<protocol::Storage::StorageBucket> in_storageBucket, std::unique_ptr<RequestDatabaseNamesCallback> callback) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace IndexedDB
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_IndexedDB_h)
