// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/emulation.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Emulation {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Emulation";
const char Metainfo::commandPrefix[] = "Emulation.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(SafeAreaInsets)
    CRDTP_DESERIALIZE_FIELD_OPT("bottom", m_bottom),
    CRDTP_DESERIALIZE_FIELD_OPT("bottomMax", m_bottomMax),
    CRDTP_DESERIALIZE_FIELD_OPT("left", m_left),
    CRDTP_DESERIALIZE_FIELD_OPT("leftMax", m_leftMax),
    CRDTP_DESERIALIZE_FIELD_OPT("right", m_right),
    CRDTP_DESERIALIZE_FIELD_OPT("rightMax", m_rightMax),
    CRDTP_DESERIALIZE_FIELD_OPT("top", m_top),
    CRDTP_DESERIALIZE_FIELD_OPT("topMax", m_topMax),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SafeAreaInsets)
    CRDTP_SERIALIZE_FIELD("top", m_top);
    CRDTP_SERIALIZE_FIELD("topMax", m_topMax);
    CRDTP_SERIALIZE_FIELD("left", m_left);
    CRDTP_SERIALIZE_FIELD("leftMax", m_leftMax);
    CRDTP_SERIALIZE_FIELD("bottom", m_bottom);
    CRDTP_SERIALIZE_FIELD("bottomMax", m_bottomMax);
    CRDTP_SERIALIZE_FIELD("right", m_right);
    CRDTP_SERIALIZE_FIELD("rightMax", m_rightMax);
CRDTP_END_SERIALIZER();



const char* ScreenOrientation::TypeEnum::PortraitPrimary = "portraitPrimary";
const char* ScreenOrientation::TypeEnum::PortraitSecondary = "portraitSecondary";
const char* ScreenOrientation::TypeEnum::LandscapePrimary = "landscapePrimary";
const char* ScreenOrientation::TypeEnum::LandscapeSecondary = "landscapeSecondary";
CRDTP_BEGIN_DESERIALIZER(ScreenOrientation)
    CRDTP_DESERIALIZE_FIELD("angle", m_angle),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScreenOrientation)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("angle", m_angle);
CRDTP_END_SERIALIZER();



const char* DisplayFeature::OrientationEnum::Vertical = "vertical";
const char* DisplayFeature::OrientationEnum::Horizontal = "horizontal";
CRDTP_BEGIN_DESERIALIZER(DisplayFeature)
    CRDTP_DESERIALIZE_FIELD("maskLength", m_maskLength),
    CRDTP_DESERIALIZE_FIELD("offset", m_offset),
    CRDTP_DESERIALIZE_FIELD("orientation", m_orientation),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DisplayFeature)
    CRDTP_SERIALIZE_FIELD("orientation", m_orientation);
    CRDTP_SERIALIZE_FIELD("offset", m_offset);
    CRDTP_SERIALIZE_FIELD("maskLength", m_maskLength);
CRDTP_END_SERIALIZER();



const char* DevicePosture::TypeEnum::Continuous = "continuous";
const char* DevicePosture::TypeEnum::Folded = "folded";
CRDTP_BEGIN_DESERIALIZER(DevicePosture)
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DevicePosture)
    CRDTP_SERIALIZE_FIELD("type", m_type);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(MediaFeature)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(MediaFeature)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


namespace VirtualTimePolicyEnum {
const char Advance[] = "advance";
const char Pause[] = "pause";
const char PauseIfNetworkFetchesPending[] = "pauseIfNetworkFetchesPending";
} // namespace VirtualTimePolicyEnum


CRDTP_BEGIN_DESERIALIZER(UserAgentBrandVersion)
    CRDTP_DESERIALIZE_FIELD("brand", m_brand),
    CRDTP_DESERIALIZE_FIELD("version", m_version),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UserAgentBrandVersion)
    CRDTP_SERIALIZE_FIELD("brand", m_brand);
    CRDTP_SERIALIZE_FIELD("version", m_version);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(UserAgentMetadata)
    CRDTP_DESERIALIZE_FIELD("architecture", m_architecture),
    CRDTP_DESERIALIZE_FIELD_OPT("bitness", m_bitness),
    CRDTP_DESERIALIZE_FIELD_OPT("brands", m_brands),
    CRDTP_DESERIALIZE_FIELD_OPT("formFactors", m_formFactors),
    CRDTP_DESERIALIZE_FIELD_OPT("fullVersion", m_fullVersion),
    CRDTP_DESERIALIZE_FIELD_OPT("fullVersionList", m_fullVersionList),
    CRDTP_DESERIALIZE_FIELD("mobile", m_mobile),
    CRDTP_DESERIALIZE_FIELD("model", m_model),
    CRDTP_DESERIALIZE_FIELD("platform", m_platform),
    CRDTP_DESERIALIZE_FIELD("platformVersion", m_platformVersion),
    CRDTP_DESERIALIZE_FIELD_OPT("wow64", m_wow64),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UserAgentMetadata)
    CRDTP_SERIALIZE_FIELD("brands", m_brands);
    CRDTP_SERIALIZE_FIELD("fullVersionList", m_fullVersionList);
    CRDTP_SERIALIZE_FIELD("fullVersion", m_fullVersion);
    CRDTP_SERIALIZE_FIELD("platform", m_platform);
    CRDTP_SERIALIZE_FIELD("platformVersion", m_platformVersion);
    CRDTP_SERIALIZE_FIELD("architecture", m_architecture);
    CRDTP_SERIALIZE_FIELD("model", m_model);
    CRDTP_SERIALIZE_FIELD("mobile", m_mobile);
    CRDTP_SERIALIZE_FIELD("bitness", m_bitness);
    CRDTP_SERIALIZE_FIELD("wow64", m_wow64);
    CRDTP_SERIALIZE_FIELD("formFactors", m_formFactors);
CRDTP_END_SERIALIZER();


namespace DisabledImageTypeEnum {
const char Avif[] = "avif";
const char Webp[] = "webp";
} // namespace DisabledImageTypeEnum


// ------------- Enum values from params.


namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
const char* Mobile = "mobile";
const char* Desktop = "desktop";
} // namespace ConfigurationEnum
} // namespace SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
const char* None = "none";
const char* BlurredVision = "blurredVision";
const char* ReducedContrast = "reducedContrast";
const char* Achromatopsia = "achromatopsia";
const char* Deuteranopia = "deuteranopia";
const char* Protanopia = "protanopia";
const char* Tritanopia = "tritanopia";
} // namespace TypeEnum
} // namespace SetEmulatedVisionDeficiency

// ------------- Frontend notifications.

void Frontend::virtualTimeBudgetExpired()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Emulation.virtualTimeBudgetExpired"));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void clearDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable);
    void resetPageScaleFactor(const crdtp::Dispatchable& dispatchable);
    void setFocusEmulationEnabled(const crdtp::Dispatchable& dispatchable);
    void setAutoDarkModeOverride(const crdtp::Dispatchable& dispatchable);
    void setCPUThrottlingRate(const crdtp::Dispatchable& dispatchable);
    void setDefaultBackgroundColorOverride(const crdtp::Dispatchable& dispatchable);
    void setSafeAreaInsetsOverride(const crdtp::Dispatchable& dispatchable);
    void setDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable);
    void setScrollbarsHidden(const crdtp::Dispatchable& dispatchable);
    void setDocumentCookieDisabled(const crdtp::Dispatchable& dispatchable);
    void setEmulatedMedia(const crdtp::Dispatchable& dispatchable);
    void setEmulatedVisionDeficiency(const crdtp::Dispatchable& dispatchable);
    void setEmulatedOSTextScale(const crdtp::Dispatchable& dispatchable);
    void setNavigatorOverrides(const crdtp::Dispatchable& dispatchable);
    void setPageScaleFactor(const crdtp::Dispatchable& dispatchable);
    void setScriptExecutionDisabled(const crdtp::Dispatchable& dispatchable);
    void setTouchEmulationEnabled(const crdtp::Dispatchable& dispatchable);
    void setVirtualTimePolicy(const crdtp::Dispatchable& dispatchable);
    void setLocaleOverride(const crdtp::Dispatchable& dispatchable);
    void setTimezoneOverride(const crdtp::Dispatchable& dispatchable);
    void setDisabledImageTypes(const crdtp::Dispatchable& dispatchable);
    void setDataSaverOverride(const crdtp::Dispatchable& dispatchable);
    void setHardwareConcurrencyOverride(const crdtp::Dispatchable& dispatchable);
    void setUserAgentOverride(const crdtp::Dispatchable& dispatchable);
    void setAutomationOverride(const crdtp::Dispatchable& dispatchable);
    void setSmallViewportHeightDifferenceOverride(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("clearDeviceMetricsOverride"),
          &DomainDispatcherImpl::clearDeviceMetricsOverride
    },
    {
          crdtp::SpanFrom("resetPageScaleFactor"),
          &DomainDispatcherImpl::resetPageScaleFactor
    },
    {
          crdtp::SpanFrom("setAutoDarkModeOverride"),
          &DomainDispatcherImpl::setAutoDarkModeOverride
    },
    {
          crdtp::SpanFrom("setAutomationOverride"),
          &DomainDispatcherImpl::setAutomationOverride
    },
    {
          crdtp::SpanFrom("setCPUThrottlingRate"),
          &DomainDispatcherImpl::setCPUThrottlingRate
    },
    {
          crdtp::SpanFrom("setDataSaverOverride"),
          &DomainDispatcherImpl::setDataSaverOverride
    },
    {
          crdtp::SpanFrom("setDefaultBackgroundColorOverride"),
          &DomainDispatcherImpl::setDefaultBackgroundColorOverride
    },
    {
          crdtp::SpanFrom("setDeviceMetricsOverride"),
          &DomainDispatcherImpl::setDeviceMetricsOverride
    },
    {
          crdtp::SpanFrom("setDisabledImageTypes"),
          &DomainDispatcherImpl::setDisabledImageTypes
    },
    {
          crdtp::SpanFrom("setDocumentCookieDisabled"),
          &DomainDispatcherImpl::setDocumentCookieDisabled
    },
    {
          crdtp::SpanFrom("setEmulatedMedia"),
          &DomainDispatcherImpl::setEmulatedMedia
    },
    {
          crdtp::SpanFrom("setEmulatedOSTextScale"),
          &DomainDispatcherImpl::setEmulatedOSTextScale
    },
    {
          crdtp::SpanFrom("setEmulatedVisionDeficiency"),
          &DomainDispatcherImpl::setEmulatedVisionDeficiency
    },
    {
          crdtp::SpanFrom("setFocusEmulationEnabled"),
          &DomainDispatcherImpl::setFocusEmulationEnabled
    },
    {
          crdtp::SpanFrom("setHardwareConcurrencyOverride"),
          &DomainDispatcherImpl::setHardwareConcurrencyOverride
    },
    {
          crdtp::SpanFrom("setLocaleOverride"),
          &DomainDispatcherImpl::setLocaleOverride
    },
    {
          crdtp::SpanFrom("setNavigatorOverrides"),
          &DomainDispatcherImpl::setNavigatorOverrides
    },
    {
          crdtp::SpanFrom("setPageScaleFactor"),
          &DomainDispatcherImpl::setPageScaleFactor
    },
    {
          crdtp::SpanFrom("setSafeAreaInsetsOverride"),
          &DomainDispatcherImpl::setSafeAreaInsetsOverride
    },
    {
          crdtp::SpanFrom("setScriptExecutionDisabled"),
          &DomainDispatcherImpl::setScriptExecutionDisabled
    },
    {
          crdtp::SpanFrom("setScrollbarsHidden"),
          &DomainDispatcherImpl::setScrollbarsHidden
    },
    {
          crdtp::SpanFrom("setSmallViewportHeightDifferenceOverride"),
          &DomainDispatcherImpl::setSmallViewportHeightDifferenceOverride
    },
    {
          crdtp::SpanFrom("setTimezoneOverride"),
          &DomainDispatcherImpl::setTimezoneOverride
    },
    {
          crdtp::SpanFrom("setTouchEmulationEnabled"),
          &DomainDispatcherImpl::setTouchEmulationEnabled
    },
    {
          crdtp::SpanFrom("setUserAgentOverride"),
          &DomainDispatcherImpl::setUserAgentOverride
    },
    {
          crdtp::SpanFrom("setVirtualTimePolicy"),
          &DomainDispatcherImpl::setVirtualTimePolicy
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::clearDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearDeviceMetricsOverride();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.clearDeviceMetricsOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::resetPageScaleFactor(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->resetPageScaleFactor();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.resetPageScaleFactor"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setFocusEmulationEnabledParams : public crdtp::DeserializableProtocolObject<setFocusEmulationEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setFocusEmulationEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setFocusEmulationEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setFocusEmulationEnabledParams params;
    if (!setFocusEmulationEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setFocusEmulationEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setFocusEmulationEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setAutoDarkModeOverrideParams : public crdtp::DeserializableProtocolObject<setAutoDarkModeOverrideParams> {
    std::optional<bool> enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAutoDarkModeOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAutoDarkModeOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAutoDarkModeOverrideParams params;
    if (!setAutoDarkModeOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAutoDarkModeOverride(std::move(params.enabled));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setAutoDarkModeOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setCPUThrottlingRateParams : public crdtp::DeserializableProtocolObject<setCPUThrottlingRateParams> {
    double rate;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setCPUThrottlingRateParams)
    CRDTP_DESERIALIZE_FIELD("rate", rate),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setCPUThrottlingRate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setCPUThrottlingRateParams params;
    if (!setCPUThrottlingRateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setCPUThrottlingRate(params.rate);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setCPUThrottlingRate"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDefaultBackgroundColorOverrideParams : public crdtp::DeserializableProtocolObject<setDefaultBackgroundColorOverrideParams> {
    std::unique_ptr<protocol::DOM::RGBA> color;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDefaultBackgroundColorOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("color", color),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDefaultBackgroundColorOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDefaultBackgroundColorOverrideParams params;
    if (!setDefaultBackgroundColorOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDefaultBackgroundColorOverride(std::move(params.color));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setDefaultBackgroundColorOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setSafeAreaInsetsOverrideParams : public crdtp::DeserializableProtocolObject<setSafeAreaInsetsOverrideParams> {
    std::unique_ptr<protocol::Emulation::SafeAreaInsets> insets;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setSafeAreaInsetsOverrideParams)
    CRDTP_DESERIALIZE_FIELD("insets", insets),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSafeAreaInsetsOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSafeAreaInsetsOverrideParams params;
    if (!setSafeAreaInsetsOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSafeAreaInsetsOverride(std::move(params.insets));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setSafeAreaInsetsOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDeviceMetricsOverrideParams : public crdtp::DeserializableProtocolObject<setDeviceMetricsOverrideParams> {
    int width;
    int height;
    double deviceScaleFactor;
    bool mobile;
    std::optional<double> scale;
    std::optional<int> screenWidth;
    std::optional<int> screenHeight;
    std::optional<int> positionX;
    std::optional<int> positionY;
    std::optional<bool> dontSetVisibleSize;
    std::unique_ptr<protocol::Emulation::ScreenOrientation> screenOrientation;
    std::unique_ptr<protocol::Page::Viewport> viewport;
    std::unique_ptr<protocol::Emulation::DisplayFeature> displayFeature;
    std::unique_ptr<protocol::Emulation::DevicePosture> devicePosture;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDeviceMetricsOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("devicePosture", devicePosture),
    CRDTP_DESERIALIZE_FIELD("deviceScaleFactor", deviceScaleFactor),
    CRDTP_DESERIALIZE_FIELD_OPT("displayFeature", displayFeature),
    CRDTP_DESERIALIZE_FIELD_OPT("dontSetVisibleSize", dontSetVisibleSize),
    CRDTP_DESERIALIZE_FIELD("height", height),
    CRDTP_DESERIALIZE_FIELD("mobile", mobile),
    CRDTP_DESERIALIZE_FIELD_OPT("positionX", positionX),
    CRDTP_DESERIALIZE_FIELD_OPT("positionY", positionY),
    CRDTP_DESERIALIZE_FIELD_OPT("scale", scale),
    CRDTP_DESERIALIZE_FIELD_OPT("screenHeight", screenHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("screenOrientation", screenOrientation),
    CRDTP_DESERIALIZE_FIELD_OPT("screenWidth", screenWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("viewport", viewport),
    CRDTP_DESERIALIZE_FIELD("width", width),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDeviceMetricsOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDeviceMetricsOverrideParams params;
    if (!setDeviceMetricsOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDeviceMetricsOverride(params.width, params.height, params.deviceScaleFactor, params.mobile, std::move(params.scale), std::move(params.screenWidth), std::move(params.screenHeight), std::move(params.positionX), std::move(params.positionY), std::move(params.dontSetVisibleSize), std::move(params.screenOrientation), std::move(params.viewport), std::move(params.displayFeature), std::move(params.devicePosture));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setDeviceMetricsOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setScrollbarsHiddenParams : public crdtp::DeserializableProtocolObject<setScrollbarsHiddenParams> {
    bool hidden;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setScrollbarsHiddenParams)
    CRDTP_DESERIALIZE_FIELD("hidden", hidden),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setScrollbarsHidden(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setScrollbarsHiddenParams params;
    if (!setScrollbarsHiddenParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setScrollbarsHidden(params.hidden);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setScrollbarsHidden"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDocumentCookieDisabledParams : public crdtp::DeserializableProtocolObject<setDocumentCookieDisabledParams> {
    bool disabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDocumentCookieDisabledParams)
    CRDTP_DESERIALIZE_FIELD("disabled", disabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDocumentCookieDisabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDocumentCookieDisabledParams params;
    if (!setDocumentCookieDisabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDocumentCookieDisabled(params.disabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setDocumentCookieDisabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setEmulatedMediaParams : public crdtp::DeserializableProtocolObject<setEmulatedMediaParams> {
    std::optional<String> media;
    std::unique_ptr<protocol::Array<protocol::Emulation::MediaFeature>> features;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setEmulatedMediaParams)
    CRDTP_DESERIALIZE_FIELD_OPT("features", features),
    CRDTP_DESERIALIZE_FIELD_OPT("media", media),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setEmulatedMedia(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setEmulatedMediaParams params;
    if (!setEmulatedMediaParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setEmulatedMedia(std::move(params.media), std::move(params.features));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setEmulatedMedia"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setEmulatedVisionDeficiencyParams : public crdtp::DeserializableProtocolObject<setEmulatedVisionDeficiencyParams> {
    String type;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setEmulatedVisionDeficiencyParams)
    CRDTP_DESERIALIZE_FIELD("type", type),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setEmulatedVisionDeficiency(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setEmulatedVisionDeficiencyParams params;
    if (!setEmulatedVisionDeficiencyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setEmulatedVisionDeficiency(params.type);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setEmulatedVisionDeficiency"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setEmulatedOSTextScaleParams : public crdtp::DeserializableProtocolObject<setEmulatedOSTextScaleParams> {
    std::optional<double> scale;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setEmulatedOSTextScaleParams)
    CRDTP_DESERIALIZE_FIELD_OPT("scale", scale),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setEmulatedOSTextScale(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setEmulatedOSTextScaleParams params;
    if (!setEmulatedOSTextScaleParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setEmulatedOSTextScale(std::move(params.scale));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setEmulatedOSTextScale"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setNavigatorOverridesParams : public crdtp::DeserializableProtocolObject<setNavigatorOverridesParams> {
    String platform;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setNavigatorOverridesParams)
    CRDTP_DESERIALIZE_FIELD("platform", platform),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setNavigatorOverrides(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setNavigatorOverridesParams params;
    if (!setNavigatorOverridesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setNavigatorOverrides(params.platform);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setNavigatorOverrides"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPageScaleFactorParams : public crdtp::DeserializableProtocolObject<setPageScaleFactorParams> {
    double pageScaleFactor;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPageScaleFactorParams)
    CRDTP_DESERIALIZE_FIELD("pageScaleFactor", pageScaleFactor),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPageScaleFactor(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPageScaleFactorParams params;
    if (!setPageScaleFactorParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setPageScaleFactor(params.pageScaleFactor);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setPageScaleFactor"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setScriptExecutionDisabledParams : public crdtp::DeserializableProtocolObject<setScriptExecutionDisabledParams> {
    bool value;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setScriptExecutionDisabledParams)
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setScriptExecutionDisabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setScriptExecutionDisabledParams params;
    if (!setScriptExecutionDisabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setScriptExecutionDisabled(params.value);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setScriptExecutionDisabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setTouchEmulationEnabledParams : public crdtp::DeserializableProtocolObject<setTouchEmulationEnabledParams> {
    bool enabled;
    std::optional<int> maxTouchPoints;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setTouchEmulationEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
    CRDTP_DESERIALIZE_FIELD_OPT("maxTouchPoints", maxTouchPoints),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setTouchEmulationEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setTouchEmulationEnabledParams params;
    if (!setTouchEmulationEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setTouchEmulationEnabled(params.enabled, std::move(params.maxTouchPoints));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setTouchEmulationEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setVirtualTimePolicyParams : public crdtp::DeserializableProtocolObject<setVirtualTimePolicyParams> {
    String policy;
    std::optional<double> budget;
    std::optional<int> maxVirtualTimeTaskStarvationCount;
    std::optional<double> initialVirtualTime;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setVirtualTimePolicyParams)
    CRDTP_DESERIALIZE_FIELD_OPT("budget", budget),
    CRDTP_DESERIALIZE_FIELD_OPT("initialVirtualTime", initialVirtualTime),
    CRDTP_DESERIALIZE_FIELD_OPT("maxVirtualTimeTaskStarvationCount", maxVirtualTimeTaskStarvationCount),
    CRDTP_DESERIALIZE_FIELD("policy", policy),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setVirtualTimePolicy(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setVirtualTimePolicyParams params;
    if (!setVirtualTimePolicyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    double out_virtualTimeTicksBase;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setVirtualTimePolicy(params.policy, std::move(params.budget), std::move(params.maxVirtualTimeTaskStarvationCount), std::move(params.initialVirtualTime), &out_virtualTimeTicksBase);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setVirtualTimePolicy"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("virtualTimeTicksBase"), out_virtualTimeTicksBase);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setLocaleOverrideParams : public crdtp::DeserializableProtocolObject<setLocaleOverrideParams> {
    std::optional<String> locale;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setLocaleOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("locale", locale),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setLocaleOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setLocaleOverrideParams params;
    if (!setLocaleOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setLocaleOverride(std::move(params.locale));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setLocaleOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setTimezoneOverrideParams : public crdtp::DeserializableProtocolObject<setTimezoneOverrideParams> {
    String timezoneId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setTimezoneOverrideParams)
    CRDTP_DESERIALIZE_FIELD("timezoneId", timezoneId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setTimezoneOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setTimezoneOverrideParams params;
    if (!setTimezoneOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setTimezoneOverride(params.timezoneId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setTimezoneOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDisabledImageTypesParams : public crdtp::DeserializableProtocolObject<setDisabledImageTypesParams> {
    std::unique_ptr<protocol::Array<String>> imageTypes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDisabledImageTypesParams)
    CRDTP_DESERIALIZE_FIELD("imageTypes", imageTypes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDisabledImageTypes(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDisabledImageTypesParams params;
    if (!setDisabledImageTypesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDisabledImageTypes(std::move(params.imageTypes));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setDisabledImageTypes"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDataSaverOverrideParams : public crdtp::DeserializableProtocolObject<setDataSaverOverrideParams> {
    std::optional<bool> dataSaverEnabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDataSaverOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("dataSaverEnabled", dataSaverEnabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDataSaverOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDataSaverOverrideParams params;
    if (!setDataSaverOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDataSaverOverride(std::move(params.dataSaverEnabled));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setDataSaverOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setHardwareConcurrencyOverrideParams : public crdtp::DeserializableProtocolObject<setHardwareConcurrencyOverrideParams> {
    int hardwareConcurrency;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setHardwareConcurrencyOverrideParams)
    CRDTP_DESERIALIZE_FIELD("hardwareConcurrency", hardwareConcurrency),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setHardwareConcurrencyOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setHardwareConcurrencyOverrideParams params;
    if (!setHardwareConcurrencyOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setHardwareConcurrencyOverride(params.hardwareConcurrency);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setHardwareConcurrencyOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setUserAgentOverrideParams : public crdtp::DeserializableProtocolObject<setUserAgentOverrideParams> {
    String userAgent;
    std::optional<String> acceptLanguage;
    std::optional<String> platform;
    std::unique_ptr<protocol::Emulation::UserAgentMetadata> userAgentMetadata;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setUserAgentOverrideParams)
    CRDTP_DESERIALIZE_FIELD_OPT("acceptLanguage", acceptLanguage),
    CRDTP_DESERIALIZE_FIELD_OPT("platform", platform),
    CRDTP_DESERIALIZE_FIELD("userAgent", userAgent),
    CRDTP_DESERIALIZE_FIELD_OPT("userAgentMetadata", userAgentMetadata),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setUserAgentOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setUserAgentOverrideParams params;
    if (!setUserAgentOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setUserAgentOverride(params.userAgent, std::move(params.acceptLanguage), std::move(params.platform), std::move(params.userAgentMetadata));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setUserAgentOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setAutomationOverrideParams : public crdtp::DeserializableProtocolObject<setAutomationOverrideParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAutomationOverrideParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAutomationOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAutomationOverrideParams params;
    if (!setAutomationOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAutomationOverride(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setAutomationOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setSmallViewportHeightDifferenceOverrideParams : public crdtp::DeserializableProtocolObject<setSmallViewportHeightDifferenceOverrideParams> {
    int difference;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setSmallViewportHeightDifferenceOverrideParams)
    CRDTP_DESERIALIZE_FIELD("difference", difference),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSmallViewportHeightDifferenceOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSmallViewportHeightDifferenceOverrideParams params;
    if (!setSmallViewportHeightDifferenceOverrideParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSmallViewportHeightDifferenceOverride(params.difference);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Emulation.setSmallViewportHeightDifferenceOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Emulation"), SortedRedirects(), std::move(dispatcher));
}

} // Emulation
} // namespace blink
} // namespace protocol
