// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_DOMSnapshot_h
#define blink_protocol_DOMSnapshot_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/css.h"
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/dom_debugger.h"
#include "third_party/blink/renderer/core/inspector/protocol/page.h"

namespace blink {
namespace protocol {
namespace DOMSnapshot {
class DOMNode;
class InlineTextBox;
class LayoutTreeNode;
class ComputedStyle;
class NameValue;
using StringIndex = int;
class RareStringData;
class RareBooleanData;
class RareIntegerData;
class DocumentSnapshot;
class NodeTreeSnapshot;
class LayoutTreeSnapshot;
class TextBoxSnapshot;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT DOMNode : public ::crdtp::ProtocolObject<DOMNode> {
public:
    ~DOMNode() override;  // Defined below

    int getNodeType() { return m_nodeType; }
    void setNodeType(int value);  // Defined below

    String getNodeName() { return m_nodeName; }
    void setNodeName(const String& value);  // Defined below

    String getNodeValue() { return m_nodeValue; }
    void setNodeValue(const String& value);  // Defined below

    bool hasTextValue() { return !!m_textValue; }
    String getTextValue(const String& defaultValue) const {
       return m_textValue.value_or(defaultValue);
    }
    const std::optional<String>& getTextValue() const {
       return m_textValue;
    }
    void setTextValue(const String& value);  // Defined below

    bool hasInputValue() { return !!m_inputValue; }
    String getInputValue(const String& defaultValue) const {
       return m_inputValue.value_or(defaultValue);
    }
    const std::optional<String>& getInputValue() const {
       return m_inputValue;
    }
    void setInputValue(const String& value);  // Defined below

    bool hasInputChecked() { return !!m_inputChecked; }
    bool getInputChecked(bool defaultValue) const {
       return m_inputChecked.value_or(defaultValue);
    }
    const std::optional<bool>& getInputChecked() const {
       return m_inputChecked;
    }
    void setInputChecked(bool value);  // Defined below

    bool hasOptionSelected() { return !!m_optionSelected; }
    bool getOptionSelected(bool defaultValue) const {
       return m_optionSelected.value_or(defaultValue);
    }
    const std::optional<bool>& getOptionSelected() const {
       return m_optionSelected;
    }
    void setOptionSelected(bool value);  // Defined below

    int getBackendNodeId() { return m_backendNodeId; }
    void setBackendNodeId(int value);  // Defined below

    bool hasChildNodeIndexes() { return !!m_childNodeIndexes; }
    protocol::Array<int>* getChildNodeIndexes(protocol::Array<int>* defaultValue) {
       return m_childNodeIndexes ? m_childNodeIndexes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getChildNodeIndexes() const {
       return m_childNodeIndexes;
    }
    void setChildNodeIndexes(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasAttributes() { return !!m_attributes; }
    protocol::Array<protocol::DOMSnapshot::NameValue>* getAttributes(protocol::Array<protocol::DOMSnapshot::NameValue>* defaultValue) {
       return m_attributes ? m_attributes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>>& getAttributes() const {
       return m_attributes;
    }
    void setAttributes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value);  // Defined below

    bool hasPseudoElementIndexes() { return !!m_pseudoElementIndexes; }
    protocol::Array<int>* getPseudoElementIndexes(protocol::Array<int>* defaultValue) {
       return m_pseudoElementIndexes ? m_pseudoElementIndexes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getPseudoElementIndexes() const {
       return m_pseudoElementIndexes;
    }
    void setPseudoElementIndexes(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasLayoutNodeIndex() { return !!m_layoutNodeIndex; }
    int getLayoutNodeIndex(int defaultValue) const {
       return m_layoutNodeIndex.value_or(defaultValue);
    }
    const std::optional<int>& getLayoutNodeIndex() const {
       return m_layoutNodeIndex;
    }
    void setLayoutNodeIndex(int value);  // Defined below

    bool hasDocumentURL() { return !!m_documentURL; }
    String getDocumentURL(const String& defaultValue) const {
       return m_documentURL.value_or(defaultValue);
    }
    const std::optional<String>& getDocumentURL() const {
       return m_documentURL;
    }
    void setDocumentURL(const String& value);  // Defined below

    bool hasBaseURL() { return !!m_baseURL; }
    String getBaseURL(const String& defaultValue) const {
       return m_baseURL.value_or(defaultValue);
    }
    const std::optional<String>& getBaseURL() const {
       return m_baseURL;
    }
    void setBaseURL(const String& value);  // Defined below

    bool hasContentLanguage() { return !!m_contentLanguage; }
    String getContentLanguage(const String& defaultValue) const {
       return m_contentLanguage.value_or(defaultValue);
    }
    const std::optional<String>& getContentLanguage() const {
       return m_contentLanguage;
    }
    void setContentLanguage(const String& value);  // Defined below

    bool hasDocumentEncoding() { return !!m_documentEncoding; }
    String getDocumentEncoding(const String& defaultValue) const {
       return m_documentEncoding.value_or(defaultValue);
    }
    const std::optional<String>& getDocumentEncoding() const {
       return m_documentEncoding;
    }
    void setDocumentEncoding(const String& value);  // Defined below

    bool hasPublicId() { return !!m_publicId; }
    String getPublicId(const String& defaultValue) const {
       return m_publicId.value_or(defaultValue);
    }
    const std::optional<String>& getPublicId() const {
       return m_publicId;
    }
    void setPublicId(const String& value);  // Defined below

    bool hasSystemId() { return !!m_systemId; }
    String getSystemId(const String& defaultValue) const {
       return m_systemId.value_or(defaultValue);
    }
    const std::optional<String>& getSystemId() const {
       return m_systemId;
    }
    void setSystemId(const String& value);  // Defined below

    bool hasFrameId() { return !!m_frameId; }
    String getFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& getFrameId() const {
       return m_frameId;
    }
    void setFrameId(const String& value);  // Defined below

    bool hasContentDocumentIndex() { return !!m_contentDocumentIndex; }
    int getContentDocumentIndex(int defaultValue) const {
       return m_contentDocumentIndex.value_or(defaultValue);
    }
    const std::optional<int>& getContentDocumentIndex() const {
       return m_contentDocumentIndex;
    }
    void setContentDocumentIndex(int value);  // Defined below

    bool hasPseudoType() { return !!m_pseudoType; }
    String getPseudoType(const String& defaultValue) const {
       return m_pseudoType.value_or(defaultValue);
    }
    const std::optional<String>& getPseudoType() const {
       return m_pseudoType;
    }
    void setPseudoType(const String& value);  // Defined below

    bool hasShadowRootType() { return !!m_shadowRootType; }
    String getShadowRootType(const String& defaultValue) const {
       return m_shadowRootType.value_or(defaultValue);
    }
    const std::optional<String>& getShadowRootType() const {
       return m_shadowRootType;
    }
    void setShadowRootType(const String& value);  // Defined below

    bool hasIsClickable() { return !!m_isClickable; }
    bool getIsClickable(bool defaultValue) const {
       return m_isClickable.value_or(defaultValue);
    }
    const std::optional<bool>& getIsClickable() const {
       return m_isClickable;
    }
    void setIsClickable(bool value);  // Defined below

    bool hasEventListeners() { return !!m_eventListeners; }
    protocol::Array<protocol::DOMDebugger::EventListener>* getEventListeners(protocol::Array<protocol::DOMDebugger::EventListener>* defaultValue) {
       return m_eventListeners ? m_eventListeners.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>>& getEventListeners() const {
       return m_eventListeners;
    }
    void setEventListeners(std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>> value);  // Defined below

    bool hasCurrentSourceURL() { return !!m_currentSourceURL; }
    String getCurrentSourceURL(const String& defaultValue) const {
       return m_currentSourceURL.value_or(defaultValue);
    }
    const std::optional<String>& getCurrentSourceURL() const {
       return m_currentSourceURL;
    }
    void setCurrentSourceURL(const String& value);  // Defined below

    bool hasOriginURL() { return !!m_originURL; }
    String getOriginURL(const String& defaultValue) const {
       return m_originURL.value_or(defaultValue);
    }
    const std::optional<String>& getOriginURL() const {
       return m_originURL;
    }
    void setOriginURL(const String& value);  // Defined below

    bool hasScrollOffsetX() { return !!m_scrollOffsetX; }
    double getScrollOffsetX(double defaultValue) const {
       return m_scrollOffsetX.value_or(defaultValue);
    }
    const std::optional<double>& getScrollOffsetX() const {
       return m_scrollOffsetX;
    }
    void setScrollOffsetX(double value);  // Defined below

    bool hasScrollOffsetY() { return !!m_scrollOffsetY; }
    double getScrollOffsetY(double defaultValue) const {
       return m_scrollOffsetY.value_or(defaultValue);
    }
    const std::optional<double>& getScrollOffsetY() const {
       return m_scrollOffsetY;
    }
    void setScrollOffsetY(double value);  // Defined below

    template<int STATE>
    class DOMNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeTypeSet = 1 << 1,
            NodeNameSet = 1 << 2,
            NodeValueSet = 1 << 3,
            BackendNodeIdSet = 1 << 4,
            AllFieldsSet = (NodeTypeSet | NodeNameSet | NodeValueSet | BackendNodeIdSet | 0)};


        DOMNodeBuilder<STATE | NodeTypeSet>& setNodeType(int value);  // Defined below

        DOMNodeBuilder<STATE | NodeNameSet>& setNodeName(const String& value);  // Defined below

        DOMNodeBuilder<STATE | NodeValueSet>& setNodeValue(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setTextValue(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setInputValue(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setInputChecked(bool value);  // Defined below

        DOMNodeBuilder<STATE>& setOptionSelected(bool value);  // Defined below

        DOMNodeBuilder<STATE | BackendNodeIdSet>& setBackendNodeId(int value);  // Defined below

        DOMNodeBuilder<STATE>& setChildNodeIndexes(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        DOMNodeBuilder<STATE>& setAttributes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value);  // Defined below

        DOMNodeBuilder<STATE>& setPseudoElementIndexes(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        DOMNodeBuilder<STATE>& setLayoutNodeIndex(int value);  // Defined below

        DOMNodeBuilder<STATE>& setDocumentURL(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setBaseURL(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setContentLanguage(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setDocumentEncoding(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setPublicId(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setSystemId(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setFrameId(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setContentDocumentIndex(int value);  // Defined below

        DOMNodeBuilder<STATE>& setPseudoType(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setShadowRootType(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setIsClickable(bool value);  // Defined below

        DOMNodeBuilder<STATE>& setEventListeners(std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>> value);  // Defined below

        DOMNodeBuilder<STATE>& setCurrentSourceURL(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setOriginURL(const String& value);  // Defined below

        DOMNodeBuilder<STATE>& setScrollOffsetX(double value);  // Defined below

        DOMNodeBuilder<STATE>& setScrollOffsetY(double value);  // Defined below

        std::unique_ptr<DOMNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DOMNode;
        DOMNodeBuilder() : m_result(new DOMNode()) { }

        template<int STEP> DOMNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DOMNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::DOMNode> m_result;
    };

    static DOMNodeBuilder<0> create()
    {
        return DOMNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DOMNode();  // Defined below

    int m_nodeType;
    String m_nodeName;
    String m_nodeValue;
    std::optional<String> m_textValue;
    std::optional<String> m_inputValue;
    std::optional<bool> m_inputChecked;
    std::optional<bool> m_optionSelected;
    int m_backendNodeId;
    std::unique_ptr<protocol::Array<int>> m_childNodeIndexes;
    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> m_attributes;
    std::unique_ptr<protocol::Array<int>> m_pseudoElementIndexes;
    std::optional<int> m_layoutNodeIndex;
    std::optional<String> m_documentURL;
    std::optional<String> m_baseURL;
    std::optional<String> m_contentLanguage;
    std::optional<String> m_documentEncoding;
    std::optional<String> m_publicId;
    std::optional<String> m_systemId;
    std::optional<String> m_frameId;
    std::optional<int> m_contentDocumentIndex;
    std::optional<String> m_pseudoType;
    std::optional<String> m_shadowRootType;
    std::optional<bool> m_isClickable;
    std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>> m_eventListeners;
    std::optional<String> m_currentSourceURL;
    std::optional<String> m_originURL;
    std::optional<double> m_scrollOffsetX;
    std::optional<double> m_scrollOffsetY;
};


class CORE_EXPORT InlineTextBox : public ::crdtp::ProtocolObject<InlineTextBox> {
public:
    ~InlineTextBox() override;  // Defined below

    protocol::DOM::Rect* getBoundingBox() { return m_boundingBox.get(); }
    void setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    int getStartCharacterIndex() { return m_startCharacterIndex; }
    void setStartCharacterIndex(int value);  // Defined below

    int getNumCharacters() { return m_numCharacters; }
    void setNumCharacters(int value);  // Defined below

    template<int STATE>
    class InlineTextBoxBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BoundingBoxSet = 1 << 1,
            StartCharacterIndexSet = 1 << 2,
            NumCharactersSet = 1 << 3,
            AllFieldsSet = (BoundingBoxSet | StartCharacterIndexSet | NumCharactersSet | 0)};


        InlineTextBoxBuilder<STATE | BoundingBoxSet>& setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        InlineTextBoxBuilder<STATE | StartCharacterIndexSet>& setStartCharacterIndex(int value);  // Defined below

        InlineTextBoxBuilder<STATE | NumCharactersSet>& setNumCharacters(int value);  // Defined below

        std::unique_ptr<InlineTextBox> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InlineTextBox;
        InlineTextBoxBuilder() : m_result(new InlineTextBox()) { }

        template<int STEP> InlineTextBoxBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InlineTextBoxBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::InlineTextBox> m_result;
    };

    static InlineTextBoxBuilder<0> create()
    {
        return InlineTextBoxBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InlineTextBox();  // Defined below

    std::unique_ptr<protocol::DOM::Rect> m_boundingBox;
    int m_startCharacterIndex;
    int m_numCharacters;
};


class CORE_EXPORT LayoutTreeNode : public ::crdtp::ProtocolObject<LayoutTreeNode> {
public:
    ~LayoutTreeNode() override;  // Defined below

    int getDomNodeIndex() { return m_domNodeIndex; }
    void setDomNodeIndex(int value);  // Defined below

    protocol::DOM::Rect* getBoundingBox() { return m_boundingBox.get(); }
    void setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    bool hasLayoutText() { return !!m_layoutText; }
    String getLayoutText(const String& defaultValue) const {
       return m_layoutText.value_or(defaultValue);
    }
    const std::optional<String>& getLayoutText() const {
       return m_layoutText;
    }
    void setLayoutText(const String& value);  // Defined below

    bool hasInlineTextNodes() { return !!m_inlineTextNodes; }
    protocol::Array<protocol::DOMSnapshot::InlineTextBox>* getInlineTextNodes(protocol::Array<protocol::DOMSnapshot::InlineTextBox>* defaultValue) {
       return m_inlineTextNodes ? m_inlineTextNodes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOMSnapshot::InlineTextBox>>& getInlineTextNodes() const {
       return m_inlineTextNodes;
    }
    void setInlineTextNodes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::InlineTextBox>> value);  // Defined below

    bool hasStyleIndex() { return !!m_styleIndex; }
    int getStyleIndex(int defaultValue) const {
       return m_styleIndex.value_or(defaultValue);
    }
    const std::optional<int>& getStyleIndex() const {
       return m_styleIndex;
    }
    void setStyleIndex(int value);  // Defined below

    bool hasPaintOrder() { return !!m_paintOrder; }
    int getPaintOrder(int defaultValue) const {
       return m_paintOrder.value_or(defaultValue);
    }
    const std::optional<int>& getPaintOrder() const {
       return m_paintOrder;
    }
    void setPaintOrder(int value);  // Defined below

    bool hasIsStackingContext() { return !!m_isStackingContext; }
    bool getIsStackingContext(bool defaultValue) const {
       return m_isStackingContext.value_or(defaultValue);
    }
    const std::optional<bool>& getIsStackingContext() const {
       return m_isStackingContext;
    }
    void setIsStackingContext(bool value);  // Defined below

    template<int STATE>
    class LayoutTreeNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DomNodeIndexSet = 1 << 1,
            BoundingBoxSet = 1 << 2,
            AllFieldsSet = (DomNodeIndexSet | BoundingBoxSet | 0)};


        LayoutTreeNodeBuilder<STATE | DomNodeIndexSet>& setDomNodeIndex(int value);  // Defined below

        LayoutTreeNodeBuilder<STATE | BoundingBoxSet>& setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        LayoutTreeNodeBuilder<STATE>& setLayoutText(const String& value);  // Defined below

        LayoutTreeNodeBuilder<STATE>& setInlineTextNodes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::InlineTextBox>> value);  // Defined below

        LayoutTreeNodeBuilder<STATE>& setStyleIndex(int value);  // Defined below

        LayoutTreeNodeBuilder<STATE>& setPaintOrder(int value);  // Defined below

        LayoutTreeNodeBuilder<STATE>& setIsStackingContext(bool value);  // Defined below

        std::unique_ptr<LayoutTreeNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LayoutTreeNode;
        LayoutTreeNodeBuilder() : m_result(new LayoutTreeNode()) { }

        template<int STEP> LayoutTreeNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LayoutTreeNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::LayoutTreeNode> m_result;
    };

    static LayoutTreeNodeBuilder<0> create()
    {
        return LayoutTreeNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LayoutTreeNode();  // Defined below

    int m_domNodeIndex;
    std::unique_ptr<protocol::DOM::Rect> m_boundingBox;
    std::optional<String> m_layoutText;
    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::InlineTextBox>> m_inlineTextNodes;
    std::optional<int> m_styleIndex;
    std::optional<int> m_paintOrder;
    std::optional<bool> m_isStackingContext;
};


class CORE_EXPORT ComputedStyle : public ::crdtp::ProtocolObject<ComputedStyle> {
public:
    ~ComputedStyle() override;  // Defined below

    protocol::Array<protocol::DOMSnapshot::NameValue>* getProperties() { return m_properties.get(); }
    void setProperties(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value);  // Defined below

    template<int STATE>
    class ComputedStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PropertiesSet = 1 << 1,
            AllFieldsSet = (PropertiesSet | 0)};


        ComputedStyleBuilder<STATE | PropertiesSet>& setProperties(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value);  // Defined below

        std::unique_ptr<ComputedStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ComputedStyle;
        ComputedStyleBuilder() : m_result(new ComputedStyle()) { }

        template<int STEP> ComputedStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ComputedStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::ComputedStyle> m_result;
    };

    static ComputedStyleBuilder<0> create()
    {
        return ComputedStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ComputedStyle();  // Defined below

    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> m_properties;
};


class CORE_EXPORT NameValue : public ::crdtp::ProtocolObject<NameValue> {
public:
    ~NameValue() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getValue() { return m_value; }
    void setValue(const String& value);  // Defined below

    template<int STATE>
    class NameValueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        NameValueBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        NameValueBuilder<STATE | ValueSet>& setValue(const String& value);  // Defined below

        std::unique_ptr<NameValue> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NameValue;
        NameValueBuilder() : m_result(new NameValue()) { }

        template<int STEP> NameValueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NameValueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::NameValue> m_result;
    };

    static NameValueBuilder<0> create()
    {
        return NameValueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NameValue();  // Defined below

    String m_name;
    String m_value;
};


class CORE_EXPORT RareStringData : public ::crdtp::ProtocolObject<RareStringData> {
public:
    ~RareStringData() override;  // Defined below

    protocol::Array<int>* getIndex() { return m_index.get(); }
    void setIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    protocol::Array<int>* getValue() { return m_value.get(); }
    void setValue(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class RareStringDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IndexSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (IndexSet | ValueSet | 0)};


        RareStringDataBuilder<STATE | IndexSet>& setIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        RareStringDataBuilder<STATE | ValueSet>& setValue(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<RareStringData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RareStringData;
        RareStringDataBuilder() : m_result(new RareStringData()) { }

        template<int STEP> RareStringDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RareStringDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_result;
    };

    static RareStringDataBuilder<0> create()
    {
        return RareStringDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RareStringData();  // Defined below

    std::unique_ptr<protocol::Array<int>> m_index;
    std::unique_ptr<protocol::Array<int>> m_value;
};


class CORE_EXPORT RareBooleanData : public ::crdtp::ProtocolObject<RareBooleanData> {
public:
    ~RareBooleanData() override;  // Defined below

    protocol::Array<int>* getIndex() { return m_index.get(); }
    void setIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class RareBooleanDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IndexSet = 1 << 1,
            AllFieldsSet = (IndexSet | 0)};


        RareBooleanDataBuilder<STATE | IndexSet>& setIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<RareBooleanData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RareBooleanData;
        RareBooleanDataBuilder() : m_result(new RareBooleanData()) { }

        template<int STEP> RareBooleanDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RareBooleanDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> m_result;
    };

    static RareBooleanDataBuilder<0> create()
    {
        return RareBooleanDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RareBooleanData();  // Defined below

    std::unique_ptr<protocol::Array<int>> m_index;
};


class CORE_EXPORT RareIntegerData : public ::crdtp::ProtocolObject<RareIntegerData> {
public:
    ~RareIntegerData() override;  // Defined below

    protocol::Array<int>* getIndex() { return m_index.get(); }
    void setIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    protocol::Array<int>* getValue() { return m_value.get(); }
    void setValue(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class RareIntegerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IndexSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (IndexSet | ValueSet | 0)};


        RareIntegerDataBuilder<STATE | IndexSet>& setIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        RareIntegerDataBuilder<STATE | ValueSet>& setValue(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<RareIntegerData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RareIntegerData;
        RareIntegerDataBuilder() : m_result(new RareIntegerData()) { }

        template<int STEP> RareIntegerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RareIntegerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::RareIntegerData> m_result;
    };

    static RareIntegerDataBuilder<0> create()
    {
        return RareIntegerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RareIntegerData();  // Defined below

    std::unique_ptr<protocol::Array<int>> m_index;
    std::unique_ptr<protocol::Array<int>> m_value;
};


class CORE_EXPORT DocumentSnapshot : public ::crdtp::ProtocolObject<DocumentSnapshot> {
public:
    ~DocumentSnapshot() override;  // Defined below

    int getDocumentURL() { return m_documentURL; }
    void setDocumentURL(int value);  // Defined below

    int getTitle() { return m_title; }
    void setTitle(int value);  // Defined below

    int getBaseURL() { return m_baseURL; }
    void setBaseURL(int value);  // Defined below

    int getContentLanguage() { return m_contentLanguage; }
    void setContentLanguage(int value);  // Defined below

    int getEncodingName() { return m_encodingName; }
    void setEncodingName(int value);  // Defined below

    int getPublicId() { return m_publicId; }
    void setPublicId(int value);  // Defined below

    int getSystemId() { return m_systemId; }
    void setSystemId(int value);  // Defined below

    int getFrameId() { return m_frameId; }
    void setFrameId(int value);  // Defined below

    protocol::DOMSnapshot::NodeTreeSnapshot* getNodes() { return m_nodes.get(); }
    void setNodes(std::unique_ptr<protocol::DOMSnapshot::NodeTreeSnapshot> value);  // Defined below

    protocol::DOMSnapshot::LayoutTreeSnapshot* getLayout() { return m_layout.get(); }
    void setLayout(std::unique_ptr<protocol::DOMSnapshot::LayoutTreeSnapshot> value);  // Defined below

    protocol::DOMSnapshot::TextBoxSnapshot* getTextBoxes() { return m_textBoxes.get(); }
    void setTextBoxes(std::unique_ptr<protocol::DOMSnapshot::TextBoxSnapshot> value);  // Defined below

    bool hasScrollOffsetX() { return !!m_scrollOffsetX; }
    double getScrollOffsetX(double defaultValue) const {
       return m_scrollOffsetX.value_or(defaultValue);
    }
    const std::optional<double>& getScrollOffsetX() const {
       return m_scrollOffsetX;
    }
    void setScrollOffsetX(double value);  // Defined below

    bool hasScrollOffsetY() { return !!m_scrollOffsetY; }
    double getScrollOffsetY(double defaultValue) const {
       return m_scrollOffsetY.value_or(defaultValue);
    }
    const std::optional<double>& getScrollOffsetY() const {
       return m_scrollOffsetY;
    }
    void setScrollOffsetY(double value);  // Defined below

    bool hasContentWidth() { return !!m_contentWidth; }
    double getContentWidth(double defaultValue) const {
       return m_contentWidth.value_or(defaultValue);
    }
    const std::optional<double>& getContentWidth() const {
       return m_contentWidth;
    }
    void setContentWidth(double value);  // Defined below

    bool hasContentHeight() { return !!m_contentHeight; }
    double getContentHeight(double defaultValue) const {
       return m_contentHeight.value_or(defaultValue);
    }
    const std::optional<double>& getContentHeight() const {
       return m_contentHeight;
    }
    void setContentHeight(double value);  // Defined below

    template<int STATE>
    class DocumentSnapshotBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DocumentURLSet = 1 << 1,
            TitleSet = 1 << 2,
            BaseURLSet = 1 << 3,
            ContentLanguageSet = 1 << 4,
            EncodingNameSet = 1 << 5,
            PublicIdSet = 1 << 6,
            SystemIdSet = 1 << 7,
            FrameIdSet = 1 << 8,
            NodesSet = 1 << 9,
            LayoutSet = 1 << 10,
            TextBoxesSet = 1 << 11,
            AllFieldsSet = (DocumentURLSet | TitleSet | BaseURLSet | ContentLanguageSet | EncodingNameSet | PublicIdSet | SystemIdSet | FrameIdSet | NodesSet | LayoutSet | TextBoxesSet | 0)};


        DocumentSnapshotBuilder<STATE | DocumentURLSet>& setDocumentURL(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | TitleSet>& setTitle(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | BaseURLSet>& setBaseURL(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | ContentLanguageSet>& setContentLanguage(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | EncodingNameSet>& setEncodingName(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | PublicIdSet>& setPublicId(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | SystemIdSet>& setSystemId(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | FrameIdSet>& setFrameId(int value);  // Defined below

        DocumentSnapshotBuilder<STATE | NodesSet>& setNodes(std::unique_ptr<protocol::DOMSnapshot::NodeTreeSnapshot> value);  // Defined below

        DocumentSnapshotBuilder<STATE | LayoutSet>& setLayout(std::unique_ptr<protocol::DOMSnapshot::LayoutTreeSnapshot> value);  // Defined below

        DocumentSnapshotBuilder<STATE | TextBoxesSet>& setTextBoxes(std::unique_ptr<protocol::DOMSnapshot::TextBoxSnapshot> value);  // Defined below

        DocumentSnapshotBuilder<STATE>& setScrollOffsetX(double value);  // Defined below

        DocumentSnapshotBuilder<STATE>& setScrollOffsetY(double value);  // Defined below

        DocumentSnapshotBuilder<STATE>& setContentWidth(double value);  // Defined below

        DocumentSnapshotBuilder<STATE>& setContentHeight(double value);  // Defined below

        std::unique_ptr<DocumentSnapshot> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DocumentSnapshot;
        DocumentSnapshotBuilder() : m_result(new DocumentSnapshot()) { }

        template<int STEP> DocumentSnapshotBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DocumentSnapshotBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::DocumentSnapshot> m_result;
    };

    static DocumentSnapshotBuilder<0> create()
    {
        return DocumentSnapshotBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DocumentSnapshot();  // Defined below

    int m_documentURL;
    int m_title;
    int m_baseURL;
    int m_contentLanguage;
    int m_encodingName;
    int m_publicId;
    int m_systemId;
    int m_frameId;
    std::unique_ptr<protocol::DOMSnapshot::NodeTreeSnapshot> m_nodes;
    std::unique_ptr<protocol::DOMSnapshot::LayoutTreeSnapshot> m_layout;
    std::unique_ptr<protocol::DOMSnapshot::TextBoxSnapshot> m_textBoxes;
    std::optional<double> m_scrollOffsetX;
    std::optional<double> m_scrollOffsetY;
    std::optional<double> m_contentWidth;
    std::optional<double> m_contentHeight;
};


class CORE_EXPORT NodeTreeSnapshot : public ::crdtp::ProtocolObject<NodeTreeSnapshot> {
public:
    ~NodeTreeSnapshot() override;  // Defined below

    bool hasParentIndex() { return !!m_parentIndex; }
    protocol::Array<int>* getParentIndex(protocol::Array<int>* defaultValue) {
       return m_parentIndex ? m_parentIndex.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getParentIndex() const {
       return m_parentIndex;
    }
    void setParentIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasNodeType() { return !!m_nodeType; }
    protocol::Array<int>* getNodeType(protocol::Array<int>* defaultValue) {
       return m_nodeType ? m_nodeType.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getNodeType() const {
       return m_nodeType;
    }
    void setNodeType(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasShadowRootType() { return !!m_shadowRootType; }
    protocol::DOMSnapshot::RareStringData* getShadowRootType(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_shadowRootType ? m_shadowRootType.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getShadowRootType() const {
       return m_shadowRootType;
    }
    void setShadowRootType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    bool hasNodeName() { return !!m_nodeName; }
    protocol::Array<int>* getNodeName(protocol::Array<int>* defaultValue) {
       return m_nodeName ? m_nodeName.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getNodeName() const {
       return m_nodeName;
    }
    void setNodeName(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasNodeValue() { return !!m_nodeValue; }
    protocol::Array<int>* getNodeValue(protocol::Array<int>* defaultValue) {
       return m_nodeValue ? m_nodeValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getNodeValue() const {
       return m_nodeValue;
    }
    void setNodeValue(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasBackendNodeId() { return !!m_backendNodeId; }
    protocol::Array<int>* getBackendNodeId(protocol::Array<int>* defaultValue) {
       return m_backendNodeId ? m_backendNodeId.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getBackendNodeId() const {
       return m_backendNodeId;
    }
    void setBackendNodeId(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasAttributes() { return !!m_attributes; }
    protocol::Array<protocol::Array<int>>* getAttributes(protocol::Array<protocol::Array<int>>* defaultValue) {
       return m_attributes ? m_attributes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Array<int>>>& getAttributes() const {
       return m_attributes;
    }
    void setAttributes(std::unique_ptr<protocol::Array<protocol::Array<int>>> value);  // Defined below

    bool hasTextValue() { return !!m_textValue; }
    protocol::DOMSnapshot::RareStringData* getTextValue(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_textValue ? m_textValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getTextValue() const {
       return m_textValue;
    }
    void setTextValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    bool hasInputValue() { return !!m_inputValue; }
    protocol::DOMSnapshot::RareStringData* getInputValue(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_inputValue ? m_inputValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getInputValue() const {
       return m_inputValue;
    }
    void setInputValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    bool hasInputChecked() { return !!m_inputChecked; }
    protocol::DOMSnapshot::RareBooleanData* getInputChecked(protocol::DOMSnapshot::RareBooleanData* defaultValue) {
       return m_inputChecked ? m_inputChecked.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareBooleanData>& getInputChecked() const {
       return m_inputChecked;
    }
    void setInputChecked(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

    bool hasOptionSelected() { return !!m_optionSelected; }
    protocol::DOMSnapshot::RareBooleanData* getOptionSelected(protocol::DOMSnapshot::RareBooleanData* defaultValue) {
       return m_optionSelected ? m_optionSelected.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareBooleanData>& getOptionSelected() const {
       return m_optionSelected;
    }
    void setOptionSelected(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

    bool hasContentDocumentIndex() { return !!m_contentDocumentIndex; }
    protocol::DOMSnapshot::RareIntegerData* getContentDocumentIndex(protocol::DOMSnapshot::RareIntegerData* defaultValue) {
       return m_contentDocumentIndex ? m_contentDocumentIndex.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareIntegerData>& getContentDocumentIndex() const {
       return m_contentDocumentIndex;
    }
    void setContentDocumentIndex(std::unique_ptr<protocol::DOMSnapshot::RareIntegerData> value);  // Defined below

    bool hasPseudoType() { return !!m_pseudoType; }
    protocol::DOMSnapshot::RareStringData* getPseudoType(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_pseudoType ? m_pseudoType.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getPseudoType() const {
       return m_pseudoType;
    }
    void setPseudoType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    bool hasPseudoIdentifier() { return !!m_pseudoIdentifier; }
    protocol::DOMSnapshot::RareStringData* getPseudoIdentifier(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_pseudoIdentifier ? m_pseudoIdentifier.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getPseudoIdentifier() const {
       return m_pseudoIdentifier;
    }
    void setPseudoIdentifier(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    bool hasIsClickable() { return !!m_isClickable; }
    protocol::DOMSnapshot::RareBooleanData* getIsClickable(protocol::DOMSnapshot::RareBooleanData* defaultValue) {
       return m_isClickable ? m_isClickable.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareBooleanData>& getIsClickable() const {
       return m_isClickable;
    }
    void setIsClickable(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

    bool hasCurrentSourceURL() { return !!m_currentSourceURL; }
    protocol::DOMSnapshot::RareStringData* getCurrentSourceURL(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_currentSourceURL ? m_currentSourceURL.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getCurrentSourceURL() const {
       return m_currentSourceURL;
    }
    void setCurrentSourceURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    bool hasOriginURL() { return !!m_originURL; }
    protocol::DOMSnapshot::RareStringData* getOriginURL(protocol::DOMSnapshot::RareStringData* defaultValue) {
       return m_originURL ? m_originURL.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOMSnapshot::RareStringData>& getOriginURL() const {
       return m_originURL;
    }
    void setOriginURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

    template<int STATE>
    class NodeTreeSnapshotBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        NodeTreeSnapshotBuilder<STATE>& setParentIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setNodeType(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setShadowRootType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setNodeName(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setNodeValue(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setBackendNodeId(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setAttributes(std::unique_ptr<protocol::Array<protocol::Array<int>>> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setTextValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setInputValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setInputChecked(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setOptionSelected(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setContentDocumentIndex(std::unique_ptr<protocol::DOMSnapshot::RareIntegerData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setPseudoType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setPseudoIdentifier(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setIsClickable(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setCurrentSourceURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        NodeTreeSnapshotBuilder<STATE>& setOriginURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value);  // Defined below

        std::unique_ptr<NodeTreeSnapshot> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NodeTreeSnapshot;
        NodeTreeSnapshotBuilder() : m_result(new NodeTreeSnapshot()) { }

        template<int STEP> NodeTreeSnapshotBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NodeTreeSnapshotBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::NodeTreeSnapshot> m_result;
    };

    static NodeTreeSnapshotBuilder<0> create()
    {
        return NodeTreeSnapshotBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NodeTreeSnapshot();  // Defined below

    std::unique_ptr<protocol::Array<int>> m_parentIndex;
    std::unique_ptr<protocol::Array<int>> m_nodeType;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_shadowRootType;
    std::unique_ptr<protocol::Array<int>> m_nodeName;
    std::unique_ptr<protocol::Array<int>> m_nodeValue;
    std::unique_ptr<protocol::Array<int>> m_backendNodeId;
    std::unique_ptr<protocol::Array<protocol::Array<int>>> m_attributes;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_textValue;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_inputValue;
    std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> m_inputChecked;
    std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> m_optionSelected;
    std::unique_ptr<protocol::DOMSnapshot::RareIntegerData> m_contentDocumentIndex;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_pseudoType;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_pseudoIdentifier;
    std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> m_isClickable;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_currentSourceURL;
    std::unique_ptr<protocol::DOMSnapshot::RareStringData> m_originURL;
};


class CORE_EXPORT LayoutTreeSnapshot : public ::crdtp::ProtocolObject<LayoutTreeSnapshot> {
public:
    ~LayoutTreeSnapshot() override;  // Defined below

    protocol::Array<int>* getNodeIndex() { return m_nodeIndex.get(); }
    void setNodeIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    protocol::Array<protocol::Array<int>>* getStyles() { return m_styles.get(); }
    void setStyles(std::unique_ptr<protocol::Array<protocol::Array<int>>> value);  // Defined below

    protocol::Array<protocol::Array<double>>* getBounds() { return m_bounds.get(); }
    void setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

    protocol::Array<int>* getText() { return m_text.get(); }
    void setText(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    protocol::DOMSnapshot::RareBooleanData* getStackingContexts() { return m_stackingContexts.get(); }
    void setStackingContexts(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

    bool hasPaintOrders() { return !!m_paintOrders; }
    protocol::Array<int>* getPaintOrders(protocol::Array<int>* defaultValue) {
       return m_paintOrders ? m_paintOrders.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getPaintOrders() const {
       return m_paintOrders;
    }
    void setPaintOrders(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasOffsetRects() { return !!m_offsetRects; }
    protocol::Array<protocol::Array<double>>* getOffsetRects(protocol::Array<protocol::Array<double>>* defaultValue) {
       return m_offsetRects ? m_offsetRects.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Array<double>>>& getOffsetRects() const {
       return m_offsetRects;
    }
    void setOffsetRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

    bool hasScrollRects() { return !!m_scrollRects; }
    protocol::Array<protocol::Array<double>>* getScrollRects(protocol::Array<protocol::Array<double>>* defaultValue) {
       return m_scrollRects ? m_scrollRects.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Array<double>>>& getScrollRects() const {
       return m_scrollRects;
    }
    void setScrollRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

    bool hasClientRects() { return !!m_clientRects; }
    protocol::Array<protocol::Array<double>>* getClientRects(protocol::Array<protocol::Array<double>>* defaultValue) {
       return m_clientRects ? m_clientRects.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Array<double>>>& getClientRects() const {
       return m_clientRects;
    }
    void setClientRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

    bool hasBlendedBackgroundColors() { return !!m_blendedBackgroundColors; }
    protocol::Array<int>* getBlendedBackgroundColors(protocol::Array<int>* defaultValue) {
       return m_blendedBackgroundColors ? m_blendedBackgroundColors.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<int>>& getBlendedBackgroundColors() const {
       return m_blendedBackgroundColors;
    }
    void setBlendedBackgroundColors(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    bool hasTextColorOpacities() { return !!m_textColorOpacities; }
    protocol::Array<double>* getTextColorOpacities(protocol::Array<double>* defaultValue) {
       return m_textColorOpacities ? m_textColorOpacities.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<double>>& getTextColorOpacities() const {
       return m_textColorOpacities;
    }
    void setTextColorOpacities(std::unique_ptr<protocol::Array<double>> value);  // Defined below

    template<int STATE>
    class LayoutTreeSnapshotBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIndexSet = 1 << 1,
            StylesSet = 1 << 2,
            BoundsSet = 1 << 3,
            TextSet = 1 << 4,
            StackingContextsSet = 1 << 5,
            AllFieldsSet = (NodeIndexSet | StylesSet | BoundsSet | TextSet | StackingContextsSet | 0)};


        LayoutTreeSnapshotBuilder<STATE | NodeIndexSet>& setNodeIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE | StylesSet>& setStyles(std::unique_ptr<protocol::Array<protocol::Array<int>>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE | BoundsSet>& setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE | TextSet>& setText(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE | StackingContextsSet>& setStackingContexts(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE>& setPaintOrders(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE>& setOffsetRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE>& setScrollRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE>& setClientRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE>& setBlendedBackgroundColors(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        LayoutTreeSnapshotBuilder<STATE>& setTextColorOpacities(std::unique_ptr<protocol::Array<double>> value);  // Defined below

        std::unique_ptr<LayoutTreeSnapshot> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LayoutTreeSnapshot;
        LayoutTreeSnapshotBuilder() : m_result(new LayoutTreeSnapshot()) { }

        template<int STEP> LayoutTreeSnapshotBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LayoutTreeSnapshotBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::LayoutTreeSnapshot> m_result;
    };

    static LayoutTreeSnapshotBuilder<0> create()
    {
        return LayoutTreeSnapshotBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LayoutTreeSnapshot();  // Defined below

    std::unique_ptr<protocol::Array<int>> m_nodeIndex;
    std::unique_ptr<protocol::Array<protocol::Array<int>>> m_styles;
    std::unique_ptr<protocol::Array<protocol::Array<double>>> m_bounds;
    std::unique_ptr<protocol::Array<int>> m_text;
    std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> m_stackingContexts;
    std::unique_ptr<protocol::Array<int>> m_paintOrders;
    std::unique_ptr<protocol::Array<protocol::Array<double>>> m_offsetRects;
    std::unique_ptr<protocol::Array<protocol::Array<double>>> m_scrollRects;
    std::unique_ptr<protocol::Array<protocol::Array<double>>> m_clientRects;
    std::unique_ptr<protocol::Array<int>> m_blendedBackgroundColors;
    std::unique_ptr<protocol::Array<double>> m_textColorOpacities;
};


class CORE_EXPORT TextBoxSnapshot : public ::crdtp::ProtocolObject<TextBoxSnapshot> {
public:
    ~TextBoxSnapshot() override;  // Defined below

    protocol::Array<int>* getLayoutIndex() { return m_layoutIndex.get(); }
    void setLayoutIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    protocol::Array<protocol::Array<double>>* getBounds() { return m_bounds.get(); }
    void setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

    protocol::Array<int>* getStart() { return m_start.get(); }
    void setStart(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    protocol::Array<int>* getLength() { return m_length.get(); }
    void setLength(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class TextBoxSnapshotBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LayoutIndexSet = 1 << 1,
            BoundsSet = 1 << 2,
            StartSet = 1 << 3,
            LengthSet = 1 << 4,
            AllFieldsSet = (LayoutIndexSet | BoundsSet | StartSet | LengthSet | 0)};


        TextBoxSnapshotBuilder<STATE | LayoutIndexSet>& setLayoutIndex(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        TextBoxSnapshotBuilder<STATE | BoundsSet>& setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value);  // Defined below

        TextBoxSnapshotBuilder<STATE | StartSet>& setStart(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        TextBoxSnapshotBuilder<STATE | LengthSet>& setLength(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<TextBoxSnapshot> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TextBoxSnapshot;
        TextBoxSnapshotBuilder() : m_result(new TextBoxSnapshot()) { }

        template<int STEP> TextBoxSnapshotBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TextBoxSnapshotBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMSnapshot::TextBoxSnapshot> m_result;
    };

    static TextBoxSnapshotBuilder<0> create()
    {
        return TextBoxSnapshotBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TextBoxSnapshot();  // Defined below

    std::unique_ptr<protocol::Array<int>> m_layoutIndex;
    std::unique_ptr<protocol::Array<protocol::Array<double>>> m_bounds;
    std::unique_ptr<protocol::Array<int>> m_start;
    std::unique_ptr<protocol::Array<int>> m_length;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline DOMNode::~DOMNode() = default;
inline void DOMNode::setNodeType(int value) { m_nodeType = value; }
inline void DOMNode::setNodeName(const String& value) { m_nodeName = value; }
inline void DOMNode::setNodeValue(const String& value) { m_nodeValue = value; }
inline void DOMNode::setTextValue(const String& value) { m_textValue = value; }
inline void DOMNode::setInputValue(const String& value) { m_inputValue = value; }
inline void DOMNode::setInputChecked(bool value) { m_inputChecked = value; }
inline void DOMNode::setOptionSelected(bool value) { m_optionSelected = value; }
inline void DOMNode::setBackendNodeId(int value) { m_backendNodeId = value; }
inline void DOMNode::setChildNodeIndexes(std::unique_ptr<protocol::Array<int>> value) { m_childNodeIndexes = std::move(value); }
inline void DOMNode::setAttributes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value) { m_attributes = std::move(value); }
inline void DOMNode::setPseudoElementIndexes(std::unique_ptr<protocol::Array<int>> value) { m_pseudoElementIndexes = std::move(value); }
inline void DOMNode::setLayoutNodeIndex(int value) { m_layoutNodeIndex = value; }
inline void DOMNode::setDocumentURL(const String& value) { m_documentURL = value; }
inline void DOMNode::setBaseURL(const String& value) { m_baseURL = value; }
inline void DOMNode::setContentLanguage(const String& value) { m_contentLanguage = value; }
inline void DOMNode::setDocumentEncoding(const String& value) { m_documentEncoding = value; }
inline void DOMNode::setPublicId(const String& value) { m_publicId = value; }
inline void DOMNode::setSystemId(const String& value) { m_systemId = value; }
inline void DOMNode::setFrameId(const String& value) { m_frameId = value; }
inline void DOMNode::setContentDocumentIndex(int value) { m_contentDocumentIndex = value; }
inline void DOMNode::setPseudoType(const String& value) { m_pseudoType = value; }
inline void DOMNode::setShadowRootType(const String& value) { m_shadowRootType = value; }
inline void DOMNode::setIsClickable(bool value) { m_isClickable = value; }
inline void DOMNode::setEventListeners(std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>> value) { m_eventListeners = std::move(value); }
inline void DOMNode::setCurrentSourceURL(const String& value) { m_currentSourceURL = value; }
inline void DOMNode::setOriginURL(const String& value) { m_originURL = value; }
inline void DOMNode::setScrollOffsetX(double value) { m_scrollOffsetX = value; }
inline void DOMNode::setScrollOffsetY(double value) { m_scrollOffsetY = value; }

template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE | DOMNode::DOMNodeBuilder<STATE>::NodeTypeSet>&
DOMNode::DOMNodeBuilder<STATE>::setNodeType(int value) {
  static_assert(!(STATE & NodeTypeSet), "property nodeType should not be set yet");
  m_result->setNodeType(value);
  return castState<NodeTypeSet>();
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE | DOMNode::DOMNodeBuilder<STATE>::NodeNameSet>&
DOMNode::DOMNodeBuilder<STATE>::setNodeName(const String& value) {
  static_assert(!(STATE & NodeNameSet), "property nodeName should not be set yet");
  m_result->setNodeName(value);
  return castState<NodeNameSet>();
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE | DOMNode::DOMNodeBuilder<STATE>::NodeValueSet>&
DOMNode::DOMNodeBuilder<STATE>::setNodeValue(const String& value) {
  static_assert(!(STATE & NodeValueSet), "property nodeValue should not be set yet");
  m_result->setNodeValue(value);
  return castState<NodeValueSet>();
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setTextValue(const String& value) {
  m_result->setTextValue(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setInputValue(const String& value) {
  m_result->setInputValue(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setInputChecked(bool value) {
  m_result->setInputChecked(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setOptionSelected(bool value) {
  m_result->setOptionSelected(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE | DOMNode::DOMNodeBuilder<STATE>::BackendNodeIdSet>&
DOMNode::DOMNodeBuilder<STATE>::setBackendNodeId(int value) {
  static_assert(!(STATE & BackendNodeIdSet), "property backendNodeId should not be set yet");
  m_result->setBackendNodeId(value);
  return castState<BackendNodeIdSet>();
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setChildNodeIndexes(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setChildNodeIndexes(std::move(value));
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setAttributes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value) {
  m_result->setAttributes(std::move(value));
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setPseudoElementIndexes(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setPseudoElementIndexes(std::move(value));
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setLayoutNodeIndex(int value) {
  m_result->setLayoutNodeIndex(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setDocumentURL(const String& value) {
  m_result->setDocumentURL(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setBaseURL(const String& value) {
  m_result->setBaseURL(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setContentLanguage(const String& value) {
  m_result->setContentLanguage(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setDocumentEncoding(const String& value) {
  m_result->setDocumentEncoding(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setPublicId(const String& value) {
  m_result->setPublicId(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setSystemId(const String& value) {
  m_result->setSystemId(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setFrameId(const String& value) {
  m_result->setFrameId(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setContentDocumentIndex(int value) {
  m_result->setContentDocumentIndex(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setPseudoType(const String& value) {
  m_result->setPseudoType(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setShadowRootType(const String& value) {
  m_result->setShadowRootType(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setIsClickable(bool value) {
  m_result->setIsClickable(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setEventListeners(std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>> value) {
  m_result->setEventListeners(std::move(value));
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setCurrentSourceURL(const String& value) {
  m_result->setCurrentSourceURL(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setOriginURL(const String& value) {
  m_result->setOriginURL(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setScrollOffsetX(double value) {
  m_result->setScrollOffsetX(value);
  return *this;
}
template<int STATE>
inline DOMNode::DOMNodeBuilder<STATE>& DOMNode::DOMNodeBuilder<STATE>::setScrollOffsetY(double value) {
  m_result->setScrollOffsetY(value);
  return *this;
}

inline DOMNode::DOMNode() {
  m_nodeType = 0;
  m_backendNodeId = 0;
}
inline InlineTextBox::~InlineTextBox() = default;
inline void InlineTextBox::setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value) { m_boundingBox = std::move(value); }
inline void InlineTextBox::setStartCharacterIndex(int value) { m_startCharacterIndex = value; }
inline void InlineTextBox::setNumCharacters(int value) { m_numCharacters = value; }

template<int STATE>
inline InlineTextBox::InlineTextBoxBuilder<STATE | InlineTextBox::InlineTextBoxBuilder<STATE>::BoundingBoxSet>&
InlineTextBox::InlineTextBoxBuilder<STATE>::setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & BoundingBoxSet), "property boundingBox should not be set yet");
  m_result->setBoundingBox(std::move(value));
  return castState<BoundingBoxSet>();
}
template<int STATE>
inline InlineTextBox::InlineTextBoxBuilder<STATE | InlineTextBox::InlineTextBoxBuilder<STATE>::StartCharacterIndexSet>&
InlineTextBox::InlineTextBoxBuilder<STATE>::setStartCharacterIndex(int value) {
  static_assert(!(STATE & StartCharacterIndexSet), "property startCharacterIndex should not be set yet");
  m_result->setStartCharacterIndex(value);
  return castState<StartCharacterIndexSet>();
}
template<int STATE>
inline InlineTextBox::InlineTextBoxBuilder<STATE | InlineTextBox::InlineTextBoxBuilder<STATE>::NumCharactersSet>&
InlineTextBox::InlineTextBoxBuilder<STATE>::setNumCharacters(int value) {
  static_assert(!(STATE & NumCharactersSet), "property numCharacters should not be set yet");
  m_result->setNumCharacters(value);
  return castState<NumCharactersSet>();
}

inline InlineTextBox::InlineTextBox() {
  m_startCharacterIndex = 0;
  m_numCharacters = 0;
}
inline LayoutTreeNode::~LayoutTreeNode() = default;
inline void LayoutTreeNode::setDomNodeIndex(int value) { m_domNodeIndex = value; }
inline void LayoutTreeNode::setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value) { m_boundingBox = std::move(value); }
inline void LayoutTreeNode::setLayoutText(const String& value) { m_layoutText = value; }
inline void LayoutTreeNode::setInlineTextNodes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::InlineTextBox>> value) { m_inlineTextNodes = std::move(value); }
inline void LayoutTreeNode::setStyleIndex(int value) { m_styleIndex = value; }
inline void LayoutTreeNode::setPaintOrder(int value) { m_paintOrder = value; }
inline void LayoutTreeNode::setIsStackingContext(bool value) { m_isStackingContext = value; }

template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE | LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::DomNodeIndexSet>&
LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setDomNodeIndex(int value) {
  static_assert(!(STATE & DomNodeIndexSet), "property domNodeIndex should not be set yet");
  m_result->setDomNodeIndex(value);
  return castState<DomNodeIndexSet>();
}
template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE | LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::BoundingBoxSet>&
LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setBoundingBox(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & BoundingBoxSet), "property boundingBox should not be set yet");
  m_result->setBoundingBox(std::move(value));
  return castState<BoundingBoxSet>();
}
template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE>& LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setLayoutText(const String& value) {
  m_result->setLayoutText(value);
  return *this;
}
template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE>& LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setInlineTextNodes(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::InlineTextBox>> value) {
  m_result->setInlineTextNodes(std::move(value));
  return *this;
}
template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE>& LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setStyleIndex(int value) {
  m_result->setStyleIndex(value);
  return *this;
}
template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE>& LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setPaintOrder(int value) {
  m_result->setPaintOrder(value);
  return *this;
}
template<int STATE>
inline LayoutTreeNode::LayoutTreeNodeBuilder<STATE>& LayoutTreeNode::LayoutTreeNodeBuilder<STATE>::setIsStackingContext(bool value) {
  m_result->setIsStackingContext(value);
  return *this;
}

inline LayoutTreeNode::LayoutTreeNode() {
  m_domNodeIndex = 0;
}
inline ComputedStyle::~ComputedStyle() = default;
inline void ComputedStyle::setProperties(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value) { m_properties = std::move(value); }

template<int STATE>
inline ComputedStyle::ComputedStyleBuilder<STATE | ComputedStyle::ComputedStyleBuilder<STATE>::PropertiesSet>&
ComputedStyle::ComputedStyleBuilder<STATE>::setProperties(std::unique_ptr<protocol::Array<protocol::DOMSnapshot::NameValue>> value) {
  static_assert(!(STATE & PropertiesSet), "property properties should not be set yet");
  m_result->setProperties(std::move(value));
  return castState<PropertiesSet>();
}

inline ComputedStyle::ComputedStyle() {
}
inline NameValue::~NameValue() = default;
inline void NameValue::setName(const String& value) { m_name = value; }
inline void NameValue::setValue(const String& value) { m_value = value; }

template<int STATE>
inline NameValue::NameValueBuilder<STATE | NameValue::NameValueBuilder<STATE>::NameSet>&
NameValue::NameValueBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline NameValue::NameValueBuilder<STATE | NameValue::NameValueBuilder<STATE>::ValueSet>&
NameValue::NameValueBuilder<STATE>::setValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(value);
  return castState<ValueSet>();
}

inline NameValue::NameValue() {
}
inline RareStringData::~RareStringData() = default;
inline void RareStringData::setIndex(std::unique_ptr<protocol::Array<int>> value) { m_index = std::move(value); }
inline void RareStringData::setValue(std::unique_ptr<protocol::Array<int>> value) { m_value = std::move(value); }

template<int STATE>
inline RareStringData::RareStringDataBuilder<STATE | RareStringData::RareStringDataBuilder<STATE>::IndexSet>&
RareStringData::RareStringDataBuilder<STATE>::setIndex(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & IndexSet), "property index should not be set yet");
  m_result->setIndex(std::move(value));
  return castState<IndexSet>();
}
template<int STATE>
inline RareStringData::RareStringDataBuilder<STATE | RareStringData::RareStringDataBuilder<STATE>::ValueSet>&
RareStringData::RareStringDataBuilder<STATE>::setValue(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(std::move(value));
  return castState<ValueSet>();
}

inline RareStringData::RareStringData() {
}
inline RareBooleanData::~RareBooleanData() = default;
inline void RareBooleanData::setIndex(std::unique_ptr<protocol::Array<int>> value) { m_index = std::move(value); }

template<int STATE>
inline RareBooleanData::RareBooleanDataBuilder<STATE | RareBooleanData::RareBooleanDataBuilder<STATE>::IndexSet>&
RareBooleanData::RareBooleanDataBuilder<STATE>::setIndex(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & IndexSet), "property index should not be set yet");
  m_result->setIndex(std::move(value));
  return castState<IndexSet>();
}

inline RareBooleanData::RareBooleanData() {
}
inline RareIntegerData::~RareIntegerData() = default;
inline void RareIntegerData::setIndex(std::unique_ptr<protocol::Array<int>> value) { m_index = std::move(value); }
inline void RareIntegerData::setValue(std::unique_ptr<protocol::Array<int>> value) { m_value = std::move(value); }

template<int STATE>
inline RareIntegerData::RareIntegerDataBuilder<STATE | RareIntegerData::RareIntegerDataBuilder<STATE>::IndexSet>&
RareIntegerData::RareIntegerDataBuilder<STATE>::setIndex(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & IndexSet), "property index should not be set yet");
  m_result->setIndex(std::move(value));
  return castState<IndexSet>();
}
template<int STATE>
inline RareIntegerData::RareIntegerDataBuilder<STATE | RareIntegerData::RareIntegerDataBuilder<STATE>::ValueSet>&
RareIntegerData::RareIntegerDataBuilder<STATE>::setValue(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->setValue(std::move(value));
  return castState<ValueSet>();
}

inline RareIntegerData::RareIntegerData() {
}
inline DocumentSnapshot::~DocumentSnapshot() = default;
inline void DocumentSnapshot::setDocumentURL(int value) { m_documentURL = value; }
inline void DocumentSnapshot::setTitle(int value) { m_title = value; }
inline void DocumentSnapshot::setBaseURL(int value) { m_baseURL = value; }
inline void DocumentSnapshot::setContentLanguage(int value) { m_contentLanguage = value; }
inline void DocumentSnapshot::setEncodingName(int value) { m_encodingName = value; }
inline void DocumentSnapshot::setPublicId(int value) { m_publicId = value; }
inline void DocumentSnapshot::setSystemId(int value) { m_systemId = value; }
inline void DocumentSnapshot::setFrameId(int value) { m_frameId = value; }
inline void DocumentSnapshot::setNodes(std::unique_ptr<protocol::DOMSnapshot::NodeTreeSnapshot> value) { m_nodes = std::move(value); }
inline void DocumentSnapshot::setLayout(std::unique_ptr<protocol::DOMSnapshot::LayoutTreeSnapshot> value) { m_layout = std::move(value); }
inline void DocumentSnapshot::setTextBoxes(std::unique_ptr<protocol::DOMSnapshot::TextBoxSnapshot> value) { m_textBoxes = std::move(value); }
inline void DocumentSnapshot::setScrollOffsetX(double value) { m_scrollOffsetX = value; }
inline void DocumentSnapshot::setScrollOffsetY(double value) { m_scrollOffsetY = value; }
inline void DocumentSnapshot::setContentWidth(double value) { m_contentWidth = value; }
inline void DocumentSnapshot::setContentHeight(double value) { m_contentHeight = value; }

template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::DocumentURLSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setDocumentURL(int value) {
  static_assert(!(STATE & DocumentURLSet), "property documentURL should not be set yet");
  m_result->setDocumentURL(value);
  return castState<DocumentURLSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::TitleSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setTitle(int value) {
  static_assert(!(STATE & TitleSet), "property title should not be set yet");
  m_result->setTitle(value);
  return castState<TitleSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::BaseURLSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setBaseURL(int value) {
  static_assert(!(STATE & BaseURLSet), "property baseURL should not be set yet");
  m_result->setBaseURL(value);
  return castState<BaseURLSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::ContentLanguageSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setContentLanguage(int value) {
  static_assert(!(STATE & ContentLanguageSet), "property contentLanguage should not be set yet");
  m_result->setContentLanguage(value);
  return castState<ContentLanguageSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::EncodingNameSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setEncodingName(int value) {
  static_assert(!(STATE & EncodingNameSet), "property encodingName should not be set yet");
  m_result->setEncodingName(value);
  return castState<EncodingNameSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::PublicIdSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setPublicId(int value) {
  static_assert(!(STATE & PublicIdSet), "property publicId should not be set yet");
  m_result->setPublicId(value);
  return castState<PublicIdSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::SystemIdSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setSystemId(int value) {
  static_assert(!(STATE & SystemIdSet), "property systemId should not be set yet");
  m_result->setSystemId(value);
  return castState<SystemIdSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::FrameIdSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setFrameId(int value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->setFrameId(value);
  return castState<FrameIdSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::NodesSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setNodes(std::unique_ptr<protocol::DOMSnapshot::NodeTreeSnapshot> value) {
  static_assert(!(STATE & NodesSet), "property nodes should not be set yet");
  m_result->setNodes(std::move(value));
  return castState<NodesSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::LayoutSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setLayout(std::unique_ptr<protocol::DOMSnapshot::LayoutTreeSnapshot> value) {
  static_assert(!(STATE & LayoutSet), "property layout should not be set yet");
  m_result->setLayout(std::move(value));
  return castState<LayoutSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE | DocumentSnapshot::DocumentSnapshotBuilder<STATE>::TextBoxesSet>&
DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setTextBoxes(std::unique_ptr<protocol::DOMSnapshot::TextBoxSnapshot> value) {
  static_assert(!(STATE & TextBoxesSet), "property textBoxes should not be set yet");
  m_result->setTextBoxes(std::move(value));
  return castState<TextBoxesSet>();
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE>& DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setScrollOffsetX(double value) {
  m_result->setScrollOffsetX(value);
  return *this;
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE>& DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setScrollOffsetY(double value) {
  m_result->setScrollOffsetY(value);
  return *this;
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE>& DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setContentWidth(double value) {
  m_result->setContentWidth(value);
  return *this;
}
template<int STATE>
inline DocumentSnapshot::DocumentSnapshotBuilder<STATE>& DocumentSnapshot::DocumentSnapshotBuilder<STATE>::setContentHeight(double value) {
  m_result->setContentHeight(value);
  return *this;
}

inline DocumentSnapshot::DocumentSnapshot() {
  m_documentURL = 0;
  m_title = 0;
  m_baseURL = 0;
  m_contentLanguage = 0;
  m_encodingName = 0;
  m_publicId = 0;
  m_systemId = 0;
  m_frameId = 0;
}
inline NodeTreeSnapshot::~NodeTreeSnapshot() = default;
inline void NodeTreeSnapshot::setParentIndex(std::unique_ptr<protocol::Array<int>> value) { m_parentIndex = std::move(value); }
inline void NodeTreeSnapshot::setNodeType(std::unique_ptr<protocol::Array<int>> value) { m_nodeType = std::move(value); }
inline void NodeTreeSnapshot::setShadowRootType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_shadowRootType = std::move(value); }
inline void NodeTreeSnapshot::setNodeName(std::unique_ptr<protocol::Array<int>> value) { m_nodeName = std::move(value); }
inline void NodeTreeSnapshot::setNodeValue(std::unique_ptr<protocol::Array<int>> value) { m_nodeValue = std::move(value); }
inline void NodeTreeSnapshot::setBackendNodeId(std::unique_ptr<protocol::Array<int>> value) { m_backendNodeId = std::move(value); }
inline void NodeTreeSnapshot::setAttributes(std::unique_ptr<protocol::Array<protocol::Array<int>>> value) { m_attributes = std::move(value); }
inline void NodeTreeSnapshot::setTextValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_textValue = std::move(value); }
inline void NodeTreeSnapshot::setInputValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_inputValue = std::move(value); }
inline void NodeTreeSnapshot::setInputChecked(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) { m_inputChecked = std::move(value); }
inline void NodeTreeSnapshot::setOptionSelected(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) { m_optionSelected = std::move(value); }
inline void NodeTreeSnapshot::setContentDocumentIndex(std::unique_ptr<protocol::DOMSnapshot::RareIntegerData> value) { m_contentDocumentIndex = std::move(value); }
inline void NodeTreeSnapshot::setPseudoType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_pseudoType = std::move(value); }
inline void NodeTreeSnapshot::setPseudoIdentifier(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_pseudoIdentifier = std::move(value); }
inline void NodeTreeSnapshot::setIsClickable(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) { m_isClickable = std::move(value); }
inline void NodeTreeSnapshot::setCurrentSourceURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_currentSourceURL = std::move(value); }
inline void NodeTreeSnapshot::setOriginURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) { m_originURL = std::move(value); }

template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setParentIndex(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setParentIndex(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setNodeType(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setNodeType(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setShadowRootType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setShadowRootType(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setNodeName(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setNodeName(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setNodeValue(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setNodeValue(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setBackendNodeId(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setBackendNodeId(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setAttributes(std::unique_ptr<protocol::Array<protocol::Array<int>>> value) {
  m_result->setAttributes(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setTextValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setTextValue(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setInputValue(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setInputValue(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setInputChecked(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) {
  m_result->setInputChecked(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setOptionSelected(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) {
  m_result->setOptionSelected(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setContentDocumentIndex(std::unique_ptr<protocol::DOMSnapshot::RareIntegerData> value) {
  m_result->setContentDocumentIndex(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setPseudoType(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setPseudoType(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setPseudoIdentifier(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setPseudoIdentifier(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setIsClickable(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) {
  m_result->setIsClickable(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setCurrentSourceURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setCurrentSourceURL(std::move(value));
  return *this;
}
template<int STATE>
inline NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>& NodeTreeSnapshot::NodeTreeSnapshotBuilder<STATE>::setOriginURL(std::unique_ptr<protocol::DOMSnapshot::RareStringData> value) {
  m_result->setOriginURL(std::move(value));
  return *this;
}

inline NodeTreeSnapshot::NodeTreeSnapshot() {
}
inline LayoutTreeSnapshot::~LayoutTreeSnapshot() = default;
inline void LayoutTreeSnapshot::setNodeIndex(std::unique_ptr<protocol::Array<int>> value) { m_nodeIndex = std::move(value); }
inline void LayoutTreeSnapshot::setStyles(std::unique_ptr<protocol::Array<protocol::Array<int>>> value) { m_styles = std::move(value); }
inline void LayoutTreeSnapshot::setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) { m_bounds = std::move(value); }
inline void LayoutTreeSnapshot::setText(std::unique_ptr<protocol::Array<int>> value) { m_text = std::move(value); }
inline void LayoutTreeSnapshot::setStackingContexts(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) { m_stackingContexts = std::move(value); }
inline void LayoutTreeSnapshot::setPaintOrders(std::unique_ptr<protocol::Array<int>> value) { m_paintOrders = std::move(value); }
inline void LayoutTreeSnapshot::setOffsetRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) { m_offsetRects = std::move(value); }
inline void LayoutTreeSnapshot::setScrollRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) { m_scrollRects = std::move(value); }
inline void LayoutTreeSnapshot::setClientRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) { m_clientRects = std::move(value); }
inline void LayoutTreeSnapshot::setBlendedBackgroundColors(std::unique_ptr<protocol::Array<int>> value) { m_blendedBackgroundColors = std::move(value); }
inline void LayoutTreeSnapshot::setTextColorOpacities(std::unique_ptr<protocol::Array<double>> value) { m_textColorOpacities = std::move(value); }

template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE | LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::NodeIndexSet>&
LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setNodeIndex(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & NodeIndexSet), "property nodeIndex should not be set yet");
  m_result->setNodeIndex(std::move(value));
  return castState<NodeIndexSet>();
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE | LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::StylesSet>&
LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setStyles(std::unique_ptr<protocol::Array<protocol::Array<int>>> value) {
  static_assert(!(STATE & StylesSet), "property styles should not be set yet");
  m_result->setStyles(std::move(value));
  return castState<StylesSet>();
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE | LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::BoundsSet>&
LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) {
  static_assert(!(STATE & BoundsSet), "property bounds should not be set yet");
  m_result->setBounds(std::move(value));
  return castState<BoundsSet>();
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE | LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::TextSet>&
LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setText(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & TextSet), "property text should not be set yet");
  m_result->setText(std::move(value));
  return castState<TextSet>();
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE | LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::StackingContextsSet>&
LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setStackingContexts(std::unique_ptr<protocol::DOMSnapshot::RareBooleanData> value) {
  static_assert(!(STATE & StackingContextsSet), "property stackingContexts should not be set yet");
  m_result->setStackingContexts(std::move(value));
  return castState<StackingContextsSet>();
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>& LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setPaintOrders(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setPaintOrders(std::move(value));
  return *this;
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>& LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setOffsetRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) {
  m_result->setOffsetRects(std::move(value));
  return *this;
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>& LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setScrollRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) {
  m_result->setScrollRects(std::move(value));
  return *this;
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>& LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setClientRects(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) {
  m_result->setClientRects(std::move(value));
  return *this;
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>& LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setBlendedBackgroundColors(std::unique_ptr<protocol::Array<int>> value) {
  m_result->setBlendedBackgroundColors(std::move(value));
  return *this;
}
template<int STATE>
inline LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>& LayoutTreeSnapshot::LayoutTreeSnapshotBuilder<STATE>::setTextColorOpacities(std::unique_ptr<protocol::Array<double>> value) {
  m_result->setTextColorOpacities(std::move(value));
  return *this;
}

inline LayoutTreeSnapshot::LayoutTreeSnapshot() {
}
inline TextBoxSnapshot::~TextBoxSnapshot() = default;
inline void TextBoxSnapshot::setLayoutIndex(std::unique_ptr<protocol::Array<int>> value) { m_layoutIndex = std::move(value); }
inline void TextBoxSnapshot::setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) { m_bounds = std::move(value); }
inline void TextBoxSnapshot::setStart(std::unique_ptr<protocol::Array<int>> value) { m_start = std::move(value); }
inline void TextBoxSnapshot::setLength(std::unique_ptr<protocol::Array<int>> value) { m_length = std::move(value); }

template<int STATE>
inline TextBoxSnapshot::TextBoxSnapshotBuilder<STATE | TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::LayoutIndexSet>&
TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::setLayoutIndex(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & LayoutIndexSet), "property layoutIndex should not be set yet");
  m_result->setLayoutIndex(std::move(value));
  return castState<LayoutIndexSet>();
}
template<int STATE>
inline TextBoxSnapshot::TextBoxSnapshotBuilder<STATE | TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::BoundsSet>&
TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::setBounds(std::unique_ptr<protocol::Array<protocol::Array<double>>> value) {
  static_assert(!(STATE & BoundsSet), "property bounds should not be set yet");
  m_result->setBounds(std::move(value));
  return castState<BoundsSet>();
}
template<int STATE>
inline TextBoxSnapshot::TextBoxSnapshotBuilder<STATE | TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::StartSet>&
TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::setStart(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & StartSet), "property start should not be set yet");
  m_result->setStart(std::move(value));
  return castState<StartSet>();
}
template<int STATE>
inline TextBoxSnapshot::TextBoxSnapshotBuilder<STATE | TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::LengthSet>&
TextBoxSnapshot::TextBoxSnapshotBuilder<STATE>::setLength(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & LengthSet), "property length should not be set yet");
  m_result->setLength(std::move(value));
  return castState<LengthSet>();
}

inline TextBoxSnapshot::TextBoxSnapshot() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getSnapshot(std::unique_ptr<protocol::Array<String>> in_computedStyleWhitelist, std::optional<bool> in_includeEventListeners, std::optional<bool> in_includePaintOrder, std::optional<bool> in_includeUserAgentShadowTree, std::unique_ptr<protocol::Array<protocol::DOMSnapshot::DOMNode>>* out_domNodes, std::unique_ptr<protocol::Array<protocol::DOMSnapshot::LayoutTreeNode>>* out_layoutTreeNodes, std::unique_ptr<protocol::Array<protocol::DOMSnapshot::ComputedStyle>>* out_computedStyles) = 0;
    virtual DispatchResponse captureSnapshot(std::unique_ptr<protocol::Array<String>> in_computedStyles, std::optional<bool> in_includePaintOrder, std::optional<bool> in_includeDOMRects, std::optional<bool> in_includeBlendedBackgroundColors, std::optional<bool> in_includeTextColorOpacities, std::unique_ptr<protocol::Array<protocol::DOMSnapshot::DocumentSnapshot>>* out_documents, std::unique_ptr<protocol::Array<String>>* out_strings) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DOMSnapshot
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_DOMSnapshot_h)
