// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/dom.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace DOM {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "DOM";
const char Metainfo::commandPrefix[] = "DOM.";
const char Metainfo::version[] = "1.3";




CRDTP_BEGIN_DESERIALIZER(BackendNode)
    CRDTP_DESERIALIZE_FIELD("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD("nodeName", m_nodeName),
    CRDTP_DESERIALIZE_FIELD("nodeType", m_nodeType),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackendNode)
    CRDTP_SERIALIZE_FIELD("nodeType", m_nodeType);
    CRDTP_SERIALIZE_FIELD("nodeName", m_nodeName);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
CRDTP_END_SERIALIZER();


namespace PseudoTypeEnum {
const char FirstLine[] = "first-line";
const char FirstLetter[] = "first-letter";
const char Checkmark[] = "checkmark";
const char Before[] = "before";
const char After[] = "after";
const char PickerIcon[] = "picker-icon";
const char InterestHint[] = "interest-hint";
const char Marker[] = "marker";
const char Backdrop[] = "backdrop";
const char Column[] = "column";
const char Selection[] = "selection";
const char SearchText[] = "search-text";
const char TargetText[] = "target-text";
const char SpellingError[] = "spelling-error";
const char GrammarError[] = "grammar-error";
const char Highlight[] = "highlight";
const char FirstLineInherited[] = "first-line-inherited";
const char ScrollMarker[] = "scroll-marker";
const char ScrollMarkerGroup[] = "scroll-marker-group";
const char ScrollButton[] = "scroll-button";
const char Scrollbar[] = "scrollbar";
const char ScrollbarThumb[] = "scrollbar-thumb";
const char ScrollbarButton[] = "scrollbar-button";
const char ScrollbarTrack[] = "scrollbar-track";
const char ScrollbarTrackPiece[] = "scrollbar-track-piece";
const char ScrollbarCorner[] = "scrollbar-corner";
const char Resizer[] = "resizer";
const char InputListButton[] = "input-list-button";
const char ViewTransition[] = "view-transition";
const char ViewTransitionGroup[] = "view-transition-group";
const char ViewTransitionImagePair[] = "view-transition-image-pair";
const char ViewTransitionGroupChildren[] = "view-transition-group-children";
const char ViewTransitionOld[] = "view-transition-old";
const char ViewTransitionNew[] = "view-transition-new";
const char Placeholder[] = "placeholder";
const char FileSelectorButton[] = "file-selector-button";
const char DetailsContent[] = "details-content";
const char Picker[] = "picker";
const char PermissionIcon[] = "permission-icon";
const char OverscrollAreaParent[] = "overscroll-area-parent";
const char OverscrollClientArea[] = "overscroll-client-area";
} // namespace PseudoTypeEnum


namespace ShadowRootTypeEnum {
const char UserAgent[] = "user-agent";
const char Open[] = "open";
const char Closed[] = "closed";
} // namespace ShadowRootTypeEnum


namespace CompatibilityModeEnum {
const char QuirksMode[] = "QuirksMode";
const char LimitedQuirksMode[] = "LimitedQuirksMode";
const char NoQuirksMode[] = "NoQuirksMode";
} // namespace CompatibilityModeEnum


namespace PhysicalAxesEnum {
const char Horizontal[] = "Horizontal";
const char Vertical[] = "Vertical";
const char Both[] = "Both";
} // namespace PhysicalAxesEnum


namespace LogicalAxesEnum {
const char Inline[] = "Inline";
const char Block[] = "Block";
const char Both[] = "Both";
} // namespace LogicalAxesEnum


namespace ScrollOrientationEnum {
const char Horizontal[] = "horizontal";
const char Vertical[] = "vertical";
} // namespace ScrollOrientationEnum


CRDTP_BEGIN_DESERIALIZER(Node)
    CRDTP_DESERIALIZE_FIELD_OPT("adoptedStyleSheets", m_adoptedStyleSheets),
    CRDTP_DESERIALIZE_FIELD_OPT("affectedByStartingStyles", m_affectedByStartingStyles),
    CRDTP_DESERIALIZE_FIELD_OPT("assignedSlot", m_assignedSlot),
    CRDTP_DESERIALIZE_FIELD_OPT("attributes", m_attributes),
    CRDTP_DESERIALIZE_FIELD("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("baseURL", m_baseURL),
    CRDTP_DESERIALIZE_FIELD_OPT("childNodeCount", m_childNodeCount),
    CRDTP_DESERIALIZE_FIELD_OPT("children", m_children),
    CRDTP_DESERIALIZE_FIELD_OPT("compatibilityMode", m_compatibilityMode),
    CRDTP_DESERIALIZE_FIELD_OPT("contentDocument", m_contentDocument),
    CRDTP_DESERIALIZE_FIELD_OPT("distributedNodes", m_distributedNodes),
    CRDTP_DESERIALIZE_FIELD_OPT("documentURL", m_documentURL),
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("importedDocument", m_importedDocument),
    CRDTP_DESERIALIZE_FIELD_OPT("internalSubset", m_internalSubset),
    CRDTP_DESERIALIZE_FIELD_OPT("isSVG", m_isSVG),
    CRDTP_DESERIALIZE_FIELD_OPT("isScrollable", m_isScrollable),
    CRDTP_DESERIALIZE_FIELD("localName", m_localName),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD("nodeName", m_nodeName),
    CRDTP_DESERIALIZE_FIELD("nodeType", m_nodeType),
    CRDTP_DESERIALIZE_FIELD("nodeValue", m_nodeValue),
    CRDTP_DESERIALIZE_FIELD_OPT("parentId", m_parentId),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoElements", m_pseudoElements),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoIdentifier", m_pseudoIdentifier),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoType", m_pseudoType),
    CRDTP_DESERIALIZE_FIELD_OPT("publicId", m_publicId),
    CRDTP_DESERIALIZE_FIELD_OPT("shadowRootType", m_shadowRootType),
    CRDTP_DESERIALIZE_FIELD_OPT("shadowRoots", m_shadowRoots),
    CRDTP_DESERIALIZE_FIELD_OPT("systemId", m_systemId),
    CRDTP_DESERIALIZE_FIELD_OPT("templateContent", m_templateContent),
    CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    CRDTP_DESERIALIZE_FIELD_OPT("xmlVersion", m_xmlVersion),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Node)
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
    CRDTP_SERIALIZE_FIELD("parentId", m_parentId);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
    CRDTP_SERIALIZE_FIELD("nodeType", m_nodeType);
    CRDTP_SERIALIZE_FIELD("nodeName", m_nodeName);
    CRDTP_SERIALIZE_FIELD("localName", m_localName);
    CRDTP_SERIALIZE_FIELD("nodeValue", m_nodeValue);
    CRDTP_SERIALIZE_FIELD("childNodeCount", m_childNodeCount);
    CRDTP_SERIALIZE_FIELD("children", m_children);
    CRDTP_SERIALIZE_FIELD("attributes", m_attributes);
    CRDTP_SERIALIZE_FIELD("documentURL", m_documentURL);
    CRDTP_SERIALIZE_FIELD("baseURL", m_baseURL);
    CRDTP_SERIALIZE_FIELD("publicId", m_publicId);
    CRDTP_SERIALIZE_FIELD("systemId", m_systemId);
    CRDTP_SERIALIZE_FIELD("internalSubset", m_internalSubset);
    CRDTP_SERIALIZE_FIELD("xmlVersion", m_xmlVersion);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("pseudoType", m_pseudoType);
    CRDTP_SERIALIZE_FIELD("pseudoIdentifier", m_pseudoIdentifier);
    CRDTP_SERIALIZE_FIELD("shadowRootType", m_shadowRootType);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("contentDocument", m_contentDocument);
    CRDTP_SERIALIZE_FIELD("shadowRoots", m_shadowRoots);
    CRDTP_SERIALIZE_FIELD("templateContent", m_templateContent);
    CRDTP_SERIALIZE_FIELD("pseudoElements", m_pseudoElements);
    CRDTP_SERIALIZE_FIELD("importedDocument", m_importedDocument);
    CRDTP_SERIALIZE_FIELD("distributedNodes", m_distributedNodes);
    CRDTP_SERIALIZE_FIELD("isSVG", m_isSVG);
    CRDTP_SERIALIZE_FIELD("compatibilityMode", m_compatibilityMode);
    CRDTP_SERIALIZE_FIELD("assignedSlot", m_assignedSlot);
    CRDTP_SERIALIZE_FIELD("isScrollable", m_isScrollable);
    CRDTP_SERIALIZE_FIELD("affectedByStartingStyles", m_affectedByStartingStyles);
    CRDTP_SERIALIZE_FIELD("adoptedStyleSheets", m_adoptedStyleSheets);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(DetachedElementInfo)
    CRDTP_DESERIALIZE_FIELD("retainedNodeIds", m_retainedNodeIds),
    CRDTP_DESERIALIZE_FIELD("treeNode", m_treeNode),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DetachedElementInfo)
    CRDTP_SERIALIZE_FIELD("treeNode", m_treeNode);
    CRDTP_SERIALIZE_FIELD("retainedNodeIds", m_retainedNodeIds);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(RGBA)
    CRDTP_DESERIALIZE_FIELD_OPT("a", m_a),
    CRDTP_DESERIALIZE_FIELD("b", m_b),
    CRDTP_DESERIALIZE_FIELD("g", m_g),
    CRDTP_DESERIALIZE_FIELD("r", m_r),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RGBA)
    CRDTP_SERIALIZE_FIELD("r", m_r);
    CRDTP_SERIALIZE_FIELD("g", m_g);
    CRDTP_SERIALIZE_FIELD("b", m_b);
    CRDTP_SERIALIZE_FIELD("a", m_a);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(BoxModel)
    CRDTP_DESERIALIZE_FIELD("border", m_border),
    CRDTP_DESERIALIZE_FIELD("content", m_content),
    CRDTP_DESERIALIZE_FIELD("height", m_height),
    CRDTP_DESERIALIZE_FIELD("margin", m_margin),
    CRDTP_DESERIALIZE_FIELD("padding", m_padding),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeOutside", m_shapeOutside),
    CRDTP_DESERIALIZE_FIELD("width", m_width),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BoxModel)
    CRDTP_SERIALIZE_FIELD("content", m_content);
    CRDTP_SERIALIZE_FIELD("padding", m_padding);
    CRDTP_SERIALIZE_FIELD("border", m_border);
    CRDTP_SERIALIZE_FIELD("margin", m_margin);
    CRDTP_SERIALIZE_FIELD("width", m_width);
    CRDTP_SERIALIZE_FIELD("height", m_height);
    CRDTP_SERIALIZE_FIELD("shapeOutside", m_shapeOutside);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ShapeOutsideInfo)
    CRDTP_DESERIALIZE_FIELD("bounds", m_bounds),
    CRDTP_DESERIALIZE_FIELD("marginShape", m_marginShape),
    CRDTP_DESERIALIZE_FIELD("shape", m_shape),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ShapeOutsideInfo)
    CRDTP_SERIALIZE_FIELD("bounds", m_bounds);
    CRDTP_SERIALIZE_FIELD("shape", m_shape);
    CRDTP_SERIALIZE_FIELD("marginShape", m_marginShape);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Rect)
    CRDTP_DESERIALIZE_FIELD("height", m_height),
    CRDTP_DESERIALIZE_FIELD("width", m_width),
    CRDTP_DESERIALIZE_FIELD("x", m_x),
    CRDTP_DESERIALIZE_FIELD("y", m_y),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Rect)
    CRDTP_SERIALIZE_FIELD("x", m_x);
    CRDTP_SERIALIZE_FIELD("y", m_y);
    CRDTP_SERIALIZE_FIELD("width", m_width);
    CRDTP_SERIALIZE_FIELD("height", m_height);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSComputedStyleProperty)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSComputedStyleProperty)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace Enable {
namespace IncludeWhitespaceEnum {
const char* None = "none";
const char* All = "all";
} // namespace IncludeWhitespaceEnum
} // namespace Enable

namespace GetElementByRelation {
namespace RelationEnum {
const char* PopoverTarget = "PopoverTarget";
const char* InterestTarget = "InterestTarget";
const char* CommandFor = "CommandFor";
} // namespace RelationEnum
} // namespace GetElementByRelation

// ------------- Frontend notifications.

void Frontend::attributeModified(int nodeId, const String& name, const String& value)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("name"), name);
    serializer.AddField(crdtp::MakeSpan("value"), value);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.attributeModified", serializer.Finish()));
}

void Frontend::adoptedStyleSheetsModified(int nodeId, std::unique_ptr<protocol::Array<String>> adoptedStyleSheets)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("adoptedStyleSheets"), adoptedStyleSheets);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.adoptedStyleSheetsModified", serializer.Finish()));
}

void Frontend::attributeRemoved(int nodeId, const String& name)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("name"), name);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.attributeRemoved", serializer.Finish()));
}

void Frontend::characterDataModified(int nodeId, const String& characterData)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("characterData"), characterData);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.characterDataModified", serializer.Finish()));
}

void Frontend::childNodeCountUpdated(int nodeId, int childNodeCount)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("childNodeCount"), childNodeCount);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.childNodeCountUpdated", serializer.Finish()));
}

void Frontend::childNodeInserted(int parentNodeId, int previousNodeId, std::unique_ptr<protocol::DOM::Node> node)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("parentNodeId"), parentNodeId);
    serializer.AddField(crdtp::MakeSpan("previousNodeId"), previousNodeId);
    serializer.AddField(crdtp::MakeSpan("node"), node);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.childNodeInserted", serializer.Finish()));
}

void Frontend::childNodeRemoved(int parentNodeId, int nodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("parentNodeId"), parentNodeId);
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.childNodeRemoved", serializer.Finish()));
}

void Frontend::distributedNodesUpdated(int insertionPointId, std::unique_ptr<protocol::Array<protocol::DOM::BackendNode>> distributedNodes)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("insertionPointId"), insertionPointId);
    serializer.AddField(crdtp::MakeSpan("distributedNodes"), distributedNodes);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.distributedNodesUpdated", serializer.Finish()));
}

void Frontend::documentUpdated()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.documentUpdated"));
}

void Frontend::inlineStyleInvalidated(std::unique_ptr<protocol::Array<int>> nodeIds)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeIds"), nodeIds);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.inlineStyleInvalidated", serializer.Finish()));
}

void Frontend::pseudoElementAdded(int parentId, std::unique_ptr<protocol::DOM::Node> pseudoElement)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("parentId"), parentId);
    serializer.AddField(crdtp::MakeSpan("pseudoElement"), pseudoElement);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.pseudoElementAdded", serializer.Finish()));
}

void Frontend::topLayerElementsUpdated()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.topLayerElementsUpdated"));
}

void Frontend::scrollableFlagUpdated(int nodeId, bool isScrollable)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("isScrollable"), isScrollable);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.scrollableFlagUpdated", serializer.Finish()));
}

void Frontend::affectedByStartingStylesFlagUpdated(int nodeId, bool affectedByStartingStyles)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("affectedByStartingStyles"), affectedByStartingStyles);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.affectedByStartingStylesFlagUpdated", serializer.Finish()));
}

void Frontend::pseudoElementRemoved(int parentId, int pseudoElementId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("parentId"), parentId);
    serializer.AddField(crdtp::MakeSpan("pseudoElementId"), pseudoElementId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.pseudoElementRemoved", serializer.Finish()));
}

void Frontend::setChildNodes(int parentId, std::unique_ptr<protocol::Array<protocol::DOM::Node>> nodes)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("parentId"), parentId);
    serializer.AddField(crdtp::MakeSpan("nodes"), nodes);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.setChildNodes", serializer.Finish()));
}

void Frontend::shadowRootPopped(int hostId, int rootId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("hostId"), hostId);
    serializer.AddField(crdtp::MakeSpan("rootId"), rootId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.shadowRootPopped", serializer.Finish()));
}

void Frontend::shadowRootPushed(int hostId, std::unique_ptr<protocol::DOM::Node> root)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("hostId"), hostId);
    serializer.AddField(crdtp::MakeSpan("root"), root);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOM.shadowRootPushed", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void collectClassNamesFromSubtree(const crdtp::Dispatchable& dispatchable);
    void copyTo(const crdtp::Dispatchable& dispatchable);
    void describeNode(const crdtp::Dispatchable& dispatchable);
    void scrollIntoViewIfNeeded(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void discardSearchResults(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void focus(const crdtp::Dispatchable& dispatchable);
    void getAttributes(const crdtp::Dispatchable& dispatchable);
    void getBoxModel(const crdtp::Dispatchable& dispatchable);
    void getContentQuads(const crdtp::Dispatchable& dispatchable);
    void getDocument(const crdtp::Dispatchable& dispatchable);
    void getFlattenedDocument(const crdtp::Dispatchable& dispatchable);
    void getNodesForSubtreeByStyle(const crdtp::Dispatchable& dispatchable);
    void getNodeForLocation(const crdtp::Dispatchable& dispatchable);
    void getOuterHTML(const crdtp::Dispatchable& dispatchable);
    void getRelayoutBoundary(const crdtp::Dispatchable& dispatchable);
    void getSearchResults(const crdtp::Dispatchable& dispatchable);
    void markUndoableState(const crdtp::Dispatchable& dispatchable);
    void moveTo(const crdtp::Dispatchable& dispatchable);
    void performSearch(const crdtp::Dispatchable& dispatchable);
    void pushNodeByPathToFrontend(const crdtp::Dispatchable& dispatchable);
    void pushNodesByBackendIdsToFrontend(const crdtp::Dispatchable& dispatchable);
    void querySelector(const crdtp::Dispatchable& dispatchable);
    void querySelectorAll(const crdtp::Dispatchable& dispatchable);
    void getTopLayerElements(const crdtp::Dispatchable& dispatchable);
    void getElementByRelation(const crdtp::Dispatchable& dispatchable);
    void redo(const crdtp::Dispatchable& dispatchable);
    void removeAttribute(const crdtp::Dispatchable& dispatchable);
    void removeNode(const crdtp::Dispatchable& dispatchable);
    void requestChildNodes(const crdtp::Dispatchable& dispatchable);
    void requestNode(const crdtp::Dispatchable& dispatchable);
    void resolveNode(const crdtp::Dispatchable& dispatchable);
    void setAttributeValue(const crdtp::Dispatchable& dispatchable);
    void setAttributesAsText(const crdtp::Dispatchable& dispatchable);
    void setFileInputFiles(const crdtp::Dispatchable& dispatchable);
    void setNodeStackTracesEnabled(const crdtp::Dispatchable& dispatchable);
    void getNodeStackTraces(const crdtp::Dispatchable& dispatchable);
    void getFileInfo(const crdtp::Dispatchable& dispatchable);
    void getDetachedDomNodes(const crdtp::Dispatchable& dispatchable);
    void setInspectedNode(const crdtp::Dispatchable& dispatchable);
    void setNodeName(const crdtp::Dispatchable& dispatchable);
    void setNodeValue(const crdtp::Dispatchable& dispatchable);
    void setOuterHTML(const crdtp::Dispatchable& dispatchable);
    void undo(const crdtp::Dispatchable& dispatchable);
    void getFrameOwner(const crdtp::Dispatchable& dispatchable);
    void getContainerForNode(const crdtp::Dispatchable& dispatchable);
    void getQueryingDescendantsForContainer(const crdtp::Dispatchable& dispatchable);
    void getAnchorElement(const crdtp::Dispatchable& dispatchable);
    void forceShowPopover(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("collectClassNamesFromSubtree"),
          &DomainDispatcherImpl::collectClassNamesFromSubtree
    },
    {
          crdtp::SpanFrom("copyTo"),
          &DomainDispatcherImpl::copyTo
    },
    {
          crdtp::SpanFrom("describeNode"),
          &DomainDispatcherImpl::describeNode
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("discardSearchResults"),
          &DomainDispatcherImpl::discardSearchResults
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("focus"),
          &DomainDispatcherImpl::focus
    },
    {
          crdtp::SpanFrom("forceShowPopover"),
          &DomainDispatcherImpl::forceShowPopover
    },
    {
          crdtp::SpanFrom("getAnchorElement"),
          &DomainDispatcherImpl::getAnchorElement
    },
    {
          crdtp::SpanFrom("getAttributes"),
          &DomainDispatcherImpl::getAttributes
    },
    {
          crdtp::SpanFrom("getBoxModel"),
          &DomainDispatcherImpl::getBoxModel
    },
    {
          crdtp::SpanFrom("getContainerForNode"),
          &DomainDispatcherImpl::getContainerForNode
    },
    {
          crdtp::SpanFrom("getContentQuads"),
          &DomainDispatcherImpl::getContentQuads
    },
    {
          crdtp::SpanFrom("getDetachedDomNodes"),
          &DomainDispatcherImpl::getDetachedDomNodes
    },
    {
          crdtp::SpanFrom("getDocument"),
          &DomainDispatcherImpl::getDocument
    },
    {
          crdtp::SpanFrom("getElementByRelation"),
          &DomainDispatcherImpl::getElementByRelation
    },
    {
          crdtp::SpanFrom("getFileInfo"),
          &DomainDispatcherImpl::getFileInfo
    },
    {
          crdtp::SpanFrom("getFlattenedDocument"),
          &DomainDispatcherImpl::getFlattenedDocument
    },
    {
          crdtp::SpanFrom("getFrameOwner"),
          &DomainDispatcherImpl::getFrameOwner
    },
    {
          crdtp::SpanFrom("getNodeForLocation"),
          &DomainDispatcherImpl::getNodeForLocation
    },
    {
          crdtp::SpanFrom("getNodeStackTraces"),
          &DomainDispatcherImpl::getNodeStackTraces
    },
    {
          crdtp::SpanFrom("getNodesForSubtreeByStyle"),
          &DomainDispatcherImpl::getNodesForSubtreeByStyle
    },
    {
          crdtp::SpanFrom("getOuterHTML"),
          &DomainDispatcherImpl::getOuterHTML
    },
    {
          crdtp::SpanFrom("getQueryingDescendantsForContainer"),
          &DomainDispatcherImpl::getQueryingDescendantsForContainer
    },
    {
          crdtp::SpanFrom("getRelayoutBoundary"),
          &DomainDispatcherImpl::getRelayoutBoundary
    },
    {
          crdtp::SpanFrom("getSearchResults"),
          &DomainDispatcherImpl::getSearchResults
    },
    {
          crdtp::SpanFrom("getTopLayerElements"),
          &DomainDispatcherImpl::getTopLayerElements
    },
    {
          crdtp::SpanFrom("markUndoableState"),
          &DomainDispatcherImpl::markUndoableState
    },
    {
          crdtp::SpanFrom("moveTo"),
          &DomainDispatcherImpl::moveTo
    },
    {
          crdtp::SpanFrom("performSearch"),
          &DomainDispatcherImpl::performSearch
    },
    {
          crdtp::SpanFrom("pushNodeByPathToFrontend"),
          &DomainDispatcherImpl::pushNodeByPathToFrontend
    },
    {
          crdtp::SpanFrom("pushNodesByBackendIdsToFrontend"),
          &DomainDispatcherImpl::pushNodesByBackendIdsToFrontend
    },
    {
          crdtp::SpanFrom("querySelector"),
          &DomainDispatcherImpl::querySelector
    },
    {
          crdtp::SpanFrom("querySelectorAll"),
          &DomainDispatcherImpl::querySelectorAll
    },
    {
          crdtp::SpanFrom("redo"),
          &DomainDispatcherImpl::redo
    },
    {
          crdtp::SpanFrom("removeAttribute"),
          &DomainDispatcherImpl::removeAttribute
    },
    {
          crdtp::SpanFrom("removeNode"),
          &DomainDispatcherImpl::removeNode
    },
    {
          crdtp::SpanFrom("requestChildNodes"),
          &DomainDispatcherImpl::requestChildNodes
    },
    {
          crdtp::SpanFrom("requestNode"),
          &DomainDispatcherImpl::requestNode
    },
    {
          crdtp::SpanFrom("resolveNode"),
          &DomainDispatcherImpl::resolveNode
    },
    {
          crdtp::SpanFrom("scrollIntoViewIfNeeded"),
          &DomainDispatcherImpl::scrollIntoViewIfNeeded
    },
    {
          crdtp::SpanFrom("setAttributeValue"),
          &DomainDispatcherImpl::setAttributeValue
    },
    {
          crdtp::SpanFrom("setAttributesAsText"),
          &DomainDispatcherImpl::setAttributesAsText
    },
    {
          crdtp::SpanFrom("setFileInputFiles"),
          &DomainDispatcherImpl::setFileInputFiles
    },
    {
          crdtp::SpanFrom("setInspectedNode"),
          &DomainDispatcherImpl::setInspectedNode
    },
    {
          crdtp::SpanFrom("setNodeName"),
          &DomainDispatcherImpl::setNodeName
    },
    {
          crdtp::SpanFrom("setNodeStackTracesEnabled"),
          &DomainDispatcherImpl::setNodeStackTracesEnabled
    },
    {
          crdtp::SpanFrom("setNodeValue"),
          &DomainDispatcherImpl::setNodeValue
    },
    {
          crdtp::SpanFrom("setOuterHTML"),
          &DomainDispatcherImpl::setOuterHTML
    },
    {
          crdtp::SpanFrom("undo"),
          &DomainDispatcherImpl::undo
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct collectClassNamesFromSubtreeParams : public crdtp::DeserializableProtocolObject<collectClassNamesFromSubtreeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(collectClassNamesFromSubtreeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::collectClassNamesFromSubtree(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    collectClassNamesFromSubtreeParams params;
    if (!collectClassNamesFromSubtreeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_classNames;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->collectClassNamesFromSubtree(params.nodeId, &out_classNames);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.collectClassNamesFromSubtree"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("classNames"), out_classNames);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct copyToParams : public crdtp::DeserializableProtocolObject<copyToParams> {
    int nodeId;
    int targetNodeId;
    std::optional<int> insertBeforeNodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(copyToParams)
    CRDTP_DESERIALIZE_FIELD_OPT("insertBeforeNodeId", insertBeforeNodeId),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("targetNodeId", targetNodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::copyTo(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    copyToParams params;
    if (!copyToParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->copyTo(params.nodeId, params.targetNodeId, std::move(params.insertBeforeNodeId), &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.copyTo"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct describeNodeParams : public crdtp::DeserializableProtocolObject<describeNodeParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    std::optional<int> depth;
    std::optional<bool> pierce;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(describeNodeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("depth", depth),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
    CRDTP_DESERIALIZE_FIELD_OPT("pierce", pierce),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::describeNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    describeNodeParams params;
    if (!describeNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DOM::Node> out_node;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->describeNode(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId), std::move(params.depth), std::move(params.pierce), &out_node);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.describeNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("node"), out_node);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct scrollIntoViewIfNeededParams : public crdtp::DeserializableProtocolObject<scrollIntoViewIfNeededParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    std::unique_ptr<protocol::DOM::Rect> rect;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(scrollIntoViewIfNeededParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
    CRDTP_DESERIALIZE_FIELD_OPT("rect", rect),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::scrollIntoViewIfNeeded(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    scrollIntoViewIfNeededParams params;
    if (!scrollIntoViewIfNeededParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->scrollIntoViewIfNeeded(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId), std::move(params.rect));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.scrollIntoViewIfNeeded"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct discardSearchResultsParams : public crdtp::DeserializableProtocolObject<discardSearchResultsParams> {
    String searchId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(discardSearchResultsParams)
    CRDTP_DESERIALIZE_FIELD("searchId", searchId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::discardSearchResults(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    discardSearchResultsParams params;
    if (!discardSearchResultsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->discardSearchResults(params.searchId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.discardSearchResults"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<String> includeWhitespace;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD_OPT("includeWhitespace", includeWhitespace),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.includeWhitespace));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct focusParams : public crdtp::DeserializableProtocolObject<focusParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(focusParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::focus(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    focusParams params;
    if (!focusParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->focus(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.focus"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getAttributesParams : public crdtp::DeserializableProtocolObject<getAttributesParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAttributesParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAttributes(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAttributesParams params;
    if (!getAttributesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_attributes;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getAttributes(params.nodeId, &out_attributes);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getAttributes"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("attributes"), out_attributes);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getBoxModelParams : public crdtp::DeserializableProtocolObject<getBoxModelParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getBoxModelParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getBoxModel(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getBoxModelParams params;
    if (!getBoxModelParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DOM::BoxModel> out_model;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getBoxModel(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId), &out_model);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getBoxModel"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("model"), out_model);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getContentQuadsParams : public crdtp::DeserializableProtocolObject<getContentQuadsParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getContentQuadsParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getContentQuads(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getContentQuadsParams params;
    if (!getContentQuadsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Array<double>>> out_quads;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getContentQuads(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId), &out_quads);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getContentQuads"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("quads"), out_quads);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getDocumentParams : public crdtp::DeserializableProtocolObject<getDocumentParams> {
    std::optional<int> depth;
    std::optional<bool> pierce;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getDocumentParams)
    CRDTP_DESERIALIZE_FIELD_OPT("depth", depth),
    CRDTP_DESERIALIZE_FIELD_OPT("pierce", pierce),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getDocument(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getDocumentParams params;
    if (!getDocumentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DOM::Node> out_root;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getDocument(std::move(params.depth), std::move(params.pierce), &out_root);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getDocument"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("root"), out_root);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getFlattenedDocumentParams : public crdtp::DeserializableProtocolObject<getFlattenedDocumentParams> {
    std::optional<int> depth;
    std::optional<bool> pierce;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getFlattenedDocumentParams)
    CRDTP_DESERIALIZE_FIELD_OPT("depth", depth),
    CRDTP_DESERIALIZE_FIELD_OPT("pierce", pierce),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getFlattenedDocument(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getFlattenedDocumentParams params;
    if (!getFlattenedDocumentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::DOM::Node>> out_nodes;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getFlattenedDocument(std::move(params.depth), std::move(params.pierce), &out_nodes);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getFlattenedDocument"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodes"), out_nodes);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getNodesForSubtreeByStyleParams : public crdtp::DeserializableProtocolObject<getNodesForSubtreeByStyleParams> {
    int nodeId;
    std::unique_ptr<protocol::Array<protocol::DOM::CSSComputedStyleProperty>> computedStyles;
    std::optional<bool> pierce;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getNodesForSubtreeByStyleParams)
    CRDTP_DESERIALIZE_FIELD("computedStyles", computedStyles),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("pierce", pierce),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getNodesForSubtreeByStyle(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getNodesForSubtreeByStyleParams params;
    if (!getNodesForSubtreeByStyleParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getNodesForSubtreeByStyle(params.nodeId, std::move(params.computedStyles), std::move(params.pierce), &out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getNodesForSubtreeByStyle"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getNodeForLocationParams : public crdtp::DeserializableProtocolObject<getNodeForLocationParams> {
    int x;
    int y;
    std::optional<bool> includeUserAgentShadowDOM;
    std::optional<bool> ignorePointerEventsNone;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getNodeForLocationParams)
    CRDTP_DESERIALIZE_FIELD_OPT("ignorePointerEventsNone", ignorePointerEventsNone),
    CRDTP_DESERIALIZE_FIELD_OPT("includeUserAgentShadowDOM", includeUserAgentShadowDOM),
    CRDTP_DESERIALIZE_FIELD("x", x),
    CRDTP_DESERIALIZE_FIELD("y", y),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getNodeForLocation(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getNodeForLocationParams params;
    if (!getNodeForLocationParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_backendNodeId;
    String out_frameId;
    std::optional<int> out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getNodeForLocation(params.x, params.y, std::move(params.includeUserAgentShadowDOM), std::move(params.ignorePointerEventsNone), &out_backendNodeId, &out_frameId, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getNodeForLocation"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("backendNodeId"), out_backendNodeId);
          serializer.AddField(crdtp::MakeSpan("frameId"), out_frameId);
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getOuterHTMLParams : public crdtp::DeserializableProtocolObject<getOuterHTMLParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    std::optional<bool> includeShadowDOM;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getOuterHTMLParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("includeShadowDOM", includeShadowDOM),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getOuterHTML(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getOuterHTMLParams params;
    if (!getOuterHTMLParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_outerHTML;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getOuterHTML(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId), std::move(params.includeShadowDOM), &out_outerHTML);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getOuterHTML"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("outerHTML"), out_outerHTML);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getRelayoutBoundaryParams : public crdtp::DeserializableProtocolObject<getRelayoutBoundaryParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getRelayoutBoundaryParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getRelayoutBoundary(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getRelayoutBoundaryParams params;
    if (!getRelayoutBoundaryParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getRelayoutBoundary(params.nodeId, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getRelayoutBoundary"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getSearchResultsParams : public crdtp::DeserializableProtocolObject<getSearchResultsParams> {
    String searchId;
    int fromIndex;
    int toIndex;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getSearchResultsParams)
    CRDTP_DESERIALIZE_FIELD("fromIndex", fromIndex),
    CRDTP_DESERIALIZE_FIELD("searchId", searchId),
    CRDTP_DESERIALIZE_FIELD("toIndex", toIndex),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getSearchResults(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getSearchResultsParams params;
    if (!getSearchResultsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getSearchResults(params.searchId, params.fromIndex, params.toIndex, &out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getSearchResults"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::markUndoableState(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->markUndoableState();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.markUndoableState"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct moveToParams : public crdtp::DeserializableProtocolObject<moveToParams> {
    int nodeId;
    int targetNodeId;
    std::optional<int> insertBeforeNodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(moveToParams)
    CRDTP_DESERIALIZE_FIELD_OPT("insertBeforeNodeId", insertBeforeNodeId),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("targetNodeId", targetNodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::moveTo(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    moveToParams params;
    if (!moveToParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->moveTo(params.nodeId, params.targetNodeId, std::move(params.insertBeforeNodeId), &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.moveTo"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct performSearchParams : public crdtp::DeserializableProtocolObject<performSearchParams> {
    String query;
    std::optional<bool> includeUserAgentShadowDOM;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(performSearchParams)
    CRDTP_DESERIALIZE_FIELD_OPT("includeUserAgentShadowDOM", includeUserAgentShadowDOM),
    CRDTP_DESERIALIZE_FIELD("query", query),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::performSearch(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    performSearchParams params;
    if (!performSearchParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_searchId;
    int out_resultCount;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->performSearch(params.query, std::move(params.includeUserAgentShadowDOM), &out_searchId, &out_resultCount);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.performSearch"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("searchId"), out_searchId);
          serializer.AddField(crdtp::MakeSpan("resultCount"), out_resultCount);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct pushNodeByPathToFrontendParams : public crdtp::DeserializableProtocolObject<pushNodeByPathToFrontendParams> {
    String path;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(pushNodeByPathToFrontendParams)
    CRDTP_DESERIALIZE_FIELD("path", path),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::pushNodeByPathToFrontend(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    pushNodeByPathToFrontendParams params;
    if (!pushNodeByPathToFrontendParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->pushNodeByPathToFrontend(params.path, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.pushNodeByPathToFrontend"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct pushNodesByBackendIdsToFrontendParams : public crdtp::DeserializableProtocolObject<pushNodesByBackendIdsToFrontendParams> {
    std::unique_ptr<protocol::Array<int>> backendNodeIds;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(pushNodesByBackendIdsToFrontendParams)
    CRDTP_DESERIALIZE_FIELD("backendNodeIds", backendNodeIds),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::pushNodesByBackendIdsToFrontend(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    pushNodesByBackendIdsToFrontendParams params;
    if (!pushNodesByBackendIdsToFrontendParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->pushNodesByBackendIdsToFrontend(std::move(params.backendNodeIds), &out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.pushNodesByBackendIdsToFrontend"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct querySelectorParams : public crdtp::DeserializableProtocolObject<querySelectorParams> {
    int nodeId;
    String selector;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(querySelectorParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("selector", selector),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::querySelector(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    querySelectorParams params;
    if (!querySelectorParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->querySelector(params.nodeId, params.selector, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.querySelector"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct querySelectorAllParams : public crdtp::DeserializableProtocolObject<querySelectorAllParams> {
    int nodeId;
    String selector;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(querySelectorAllParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("selector", selector),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::querySelectorAll(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    querySelectorAllParams params;
    if (!querySelectorAllParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->querySelectorAll(params.nodeId, params.selector, &out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.querySelectorAll"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getTopLayerElements(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getTopLayerElements(&out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getTopLayerElements"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getElementByRelationParams : public crdtp::DeserializableProtocolObject<getElementByRelationParams> {
    int nodeId;
    String relation;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getElementByRelationParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("relation", relation),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getElementByRelation(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getElementByRelationParams params;
    if (!getElementByRelationParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getElementByRelation(params.nodeId, params.relation, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getElementByRelation"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::redo(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->redo();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.redo"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeAttributeParams : public crdtp::DeserializableProtocolObject<removeAttributeParams> {
    int nodeId;
    String name;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeAttributeParams)
    CRDTP_DESERIALIZE_FIELD("name", name),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeAttribute(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeAttributeParams params;
    if (!removeAttributeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeAttribute(params.nodeId, params.name);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.removeAttribute"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeNodeParams : public crdtp::DeserializableProtocolObject<removeNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeNodeParams params;
    if (!removeNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeNode(params.nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.removeNode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct requestChildNodesParams : public crdtp::DeserializableProtocolObject<requestChildNodesParams> {
    int nodeId;
    std::optional<int> depth;
    std::optional<bool> pierce;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestChildNodesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("depth", depth),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("pierce", pierce),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestChildNodes(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestChildNodesParams params;
    if (!requestChildNodesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->requestChildNodes(params.nodeId, std::move(params.depth), std::move(params.pierce));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.requestChildNodes"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct requestNodeParams : public crdtp::DeserializableProtocolObject<requestNodeParams> {
    String objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestNodeParams)
    CRDTP_DESERIALIZE_FIELD("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestNodeParams params;
    if (!requestNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->requestNode(params.objectId, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.requestNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct resolveNodeParams : public crdtp::DeserializableProtocolObject<resolveNodeParams> {
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectGroup;
    std::optional<int> executionContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(resolveNodeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::resolveNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    resolveNodeParams params;
    if (!resolveNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> out_object;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->resolveNode(std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectGroup), std::move(params.executionContextId), &out_object);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.resolveNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("object"), out_object);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setAttributeValueParams : public crdtp::DeserializableProtocolObject<setAttributeValueParams> {
    int nodeId;
    String name;
    String value;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAttributeValueParams)
    CRDTP_DESERIALIZE_FIELD("name", name),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAttributeValue(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAttributeValueParams params;
    if (!setAttributeValueParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAttributeValue(params.nodeId, params.name, params.value);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setAttributeValue"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setAttributesAsTextParams : public crdtp::DeserializableProtocolObject<setAttributesAsTextParams> {
    int nodeId;
    String text;
    std::optional<String> name;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAttributesAsTextParams)
    CRDTP_DESERIALIZE_FIELD_OPT("name", name),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("text", text),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAttributesAsText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAttributesAsTextParams params;
    if (!setAttributesAsTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAttributesAsText(params.nodeId, params.text, std::move(params.name));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setAttributesAsText"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setFileInputFilesParams : public crdtp::DeserializableProtocolObject<setFileInputFilesParams> {
    std::unique_ptr<protocol::Array<String>> files;
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setFileInputFilesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD("files", files),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setFileInputFiles(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setFileInputFilesParams params;
    if (!setFileInputFilesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setFileInputFiles(std::move(params.files), std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setFileInputFiles"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setNodeStackTracesEnabledParams : public crdtp::DeserializableProtocolObject<setNodeStackTracesEnabledParams> {
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setNodeStackTracesEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setNodeStackTracesEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setNodeStackTracesEnabledParams params;
    if (!setNodeStackTracesEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setNodeStackTracesEnabled(params.enable);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setNodeStackTracesEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getNodeStackTracesParams : public crdtp::DeserializableProtocolObject<getNodeStackTracesParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getNodeStackTracesParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getNodeStackTraces(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getNodeStackTracesParams params;
    if (!getNodeStackTracesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> out_creation;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getNodeStackTraces(params.nodeId, &out_creation);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getNodeStackTraces"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("creation"), out_creation);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getFileInfoParams : public crdtp::DeserializableProtocolObject<getFileInfoParams> {
    String objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getFileInfoParams)
    CRDTP_DESERIALIZE_FIELD("objectId", objectId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getFileInfo(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getFileInfoParams params;
    if (!getFileInfoParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_path;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getFileInfo(params.objectId, &out_path);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getFileInfo"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("path"), out_path);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getDetachedDomNodes(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::DOM::DetachedElementInfo>> out_detachedNodes;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getDetachedDomNodes(&out_detachedNodes);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getDetachedDomNodes"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("detachedNodes"), out_detachedNodes);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setInspectedNodeParams : public crdtp::DeserializableProtocolObject<setInspectedNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInspectedNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInspectedNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInspectedNodeParams params;
    if (!setInspectedNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInspectedNode(params.nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setInspectedNode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setNodeNameParams : public crdtp::DeserializableProtocolObject<setNodeNameParams> {
    int nodeId;
    String name;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setNodeNameParams)
    CRDTP_DESERIALIZE_FIELD("name", name),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setNodeName(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setNodeNameParams params;
    if (!setNodeNameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setNodeName(params.nodeId, params.name, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setNodeName"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setNodeValueParams : public crdtp::DeserializableProtocolObject<setNodeValueParams> {
    int nodeId;
    String value;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setNodeValueParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setNodeValue(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setNodeValueParams params;
    if (!setNodeValueParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setNodeValue(params.nodeId, params.value);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setNodeValue"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setOuterHTMLParams : public crdtp::DeserializableProtocolObject<setOuterHTMLParams> {
    int nodeId;
    String outerHTML;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setOuterHTMLParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("outerHTML", outerHTML),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setOuterHTML(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setOuterHTMLParams params;
    if (!setOuterHTMLParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setOuterHTML(params.nodeId, params.outerHTML);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.setOuterHTML"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::undo(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->undo();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.undo"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getFrameOwnerParams : public crdtp::DeserializableProtocolObject<getFrameOwnerParams> {
    String frameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getFrameOwnerParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getFrameOwner(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getFrameOwnerParams params;
    if (!getFrameOwnerParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_backendNodeId;
    std::optional<int> out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getFrameOwner(params.frameId, &out_backendNodeId, &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getFrameOwner"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("backendNodeId"), out_backendNodeId);
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getContainerForNodeParams : public crdtp::DeserializableProtocolObject<getContainerForNodeParams> {
    int nodeId;
    std::optional<String> containerName;
    std::optional<String> physicalAxes;
    std::optional<String> logicalAxes;
    std::optional<bool> queriesScrollState;
    std::optional<bool> queriesAnchored;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getContainerForNodeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("containerName", containerName),
    CRDTP_DESERIALIZE_FIELD_OPT("logicalAxes", logicalAxes),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("physicalAxes", physicalAxes),
    CRDTP_DESERIALIZE_FIELD_OPT("queriesAnchored", queriesAnchored),
    CRDTP_DESERIALIZE_FIELD_OPT("queriesScrollState", queriesScrollState),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getContainerForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getContainerForNodeParams params;
    if (!getContainerForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::optional<int> out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getContainerForNode(params.nodeId, std::move(params.containerName), std::move(params.physicalAxes), std::move(params.logicalAxes), std::move(params.queriesScrollState), std::move(params.queriesAnchored), &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getContainerForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getQueryingDescendantsForContainerParams : public crdtp::DeserializableProtocolObject<getQueryingDescendantsForContainerParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getQueryingDescendantsForContainerParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getQueryingDescendantsForContainer(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getQueryingDescendantsForContainerParams params;
    if (!getQueryingDescendantsForContainerParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getQueryingDescendantsForContainer(params.nodeId, &out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getQueryingDescendantsForContainer"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getAnchorElementParams : public crdtp::DeserializableProtocolObject<getAnchorElementParams> {
    int nodeId;
    std::optional<String> anchorSpecifier;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAnchorElementParams)
    CRDTP_DESERIALIZE_FIELD_OPT("anchorSpecifier", anchorSpecifier),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAnchorElement(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAnchorElementParams params;
    if (!getAnchorElementParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    int out_nodeId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getAnchorElement(params.nodeId, std::move(params.anchorSpecifier), &out_nodeId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.getAnchorElement"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeId"), out_nodeId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct forceShowPopoverParams : public crdtp::DeserializableProtocolObject<forceShowPopoverParams> {
    int nodeId;
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(forceShowPopoverParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::forceShowPopover(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    forceShowPopoverParams params;
    if (!forceShowPopoverParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<int>> out_nodeIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->forceShowPopover(params.nodeId, params.enable, &out_nodeIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOM.forceShowPopover"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("nodeIds"), out_nodeIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("DOM.hideHighlight"), crdtp::SpanFrom("Overlay.hideHighlight") },
          { crdtp::SpanFrom("DOM.highlightNode"), crdtp::SpanFrom("Overlay.highlightNode") },
          { crdtp::SpanFrom("DOM.highlightRect"), crdtp::SpanFrom("Overlay.highlightRect") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("DOM"), SortedRedirects(), std::move(dispatcher));
}

} // DOM
} // namespace blink
} // namespace protocol
