// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/css.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace CSS {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "CSS";
const char Metainfo::commandPrefix[] = "CSS.";
const char Metainfo::version[] = "1.3";

namespace StyleSheetOriginEnum {
const char Injected[] = "injected";
const char UserAgent[] = "user-agent";
const char Inspector[] = "inspector";
const char Regular[] = "regular";
} // namespace StyleSheetOriginEnum


CRDTP_BEGIN_DESERIALIZER(PseudoElementMatches)
    CRDTP_DESERIALIZE_FIELD("matches", m_matches),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoIdentifier", m_pseudoIdentifier),
    CRDTP_DESERIALIZE_FIELD("pseudoType", m_pseudoType),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PseudoElementMatches)
    CRDTP_SERIALIZE_FIELD("pseudoType", m_pseudoType);
    CRDTP_SERIALIZE_FIELD("pseudoIdentifier", m_pseudoIdentifier);
    CRDTP_SERIALIZE_FIELD("matches", m_matches);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSAnimationStyle)
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD("style", m_style),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSAnimationStyle)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("style", m_style);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InheritedStyleEntry)
    CRDTP_DESERIALIZE_FIELD_OPT("inlineStyle", m_inlineStyle),
    CRDTP_DESERIALIZE_FIELD("matchedCSSRules", m_matchedCSSRules),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InheritedStyleEntry)
    CRDTP_SERIALIZE_FIELD("inlineStyle", m_inlineStyle);
    CRDTP_SERIALIZE_FIELD("matchedCSSRules", m_matchedCSSRules);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InheritedAnimatedStyleEntry)
    CRDTP_DESERIALIZE_FIELD_OPT("animationStyles", m_animationStyles),
    CRDTP_DESERIALIZE_FIELD_OPT("transitionsStyle", m_transitionsStyle),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InheritedAnimatedStyleEntry)
    CRDTP_SERIALIZE_FIELD("animationStyles", m_animationStyles);
    CRDTP_SERIALIZE_FIELD("transitionsStyle", m_transitionsStyle);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InheritedPseudoElementMatches)
    CRDTP_DESERIALIZE_FIELD("pseudoElements", m_pseudoElements),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InheritedPseudoElementMatches)
    CRDTP_SERIALIZE_FIELD("pseudoElements", m_pseudoElements);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(RuleMatch)
    CRDTP_DESERIALIZE_FIELD("matchingSelectors", m_matchingSelectors),
    CRDTP_DESERIALIZE_FIELD("rule", m_rule),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RuleMatch)
    CRDTP_SERIALIZE_FIELD("rule", m_rule);
    CRDTP_SERIALIZE_FIELD("matchingSelectors", m_matchingSelectors);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Value)
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("specificity", m_specificity),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Value)
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("specificity", m_specificity);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Specificity)
    CRDTP_DESERIALIZE_FIELD("a", m_a),
    CRDTP_DESERIALIZE_FIELD("b", m_b),
    CRDTP_DESERIALIZE_FIELD("c", m_c),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Specificity)
    CRDTP_SERIALIZE_FIELD("a", m_a);
    CRDTP_SERIALIZE_FIELD("b", m_b);
    CRDTP_SERIALIZE_FIELD("c", m_c);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SelectorList)
    CRDTP_DESERIALIZE_FIELD("selectors", m_selectors),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SelectorList)
    CRDTP_SERIALIZE_FIELD("selectors", m_selectors);
    CRDTP_SERIALIZE_FIELD("text", m_text);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSStyleSheetHeader)
    CRDTP_DESERIALIZE_FIELD("disabled", m_disabled),
    CRDTP_DESERIALIZE_FIELD("endColumn", m_endColumn),
    CRDTP_DESERIALIZE_FIELD("endLine", m_endLine),
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("hasSourceURL", m_hasSourceURL),
    CRDTP_DESERIALIZE_FIELD("isConstructed", m_isConstructed),
    CRDTP_DESERIALIZE_FIELD("isInline", m_isInline),
    CRDTP_DESERIALIZE_FIELD("isMutable", m_isMutable),
    CRDTP_DESERIALIZE_FIELD("length", m_length),
    CRDTP_DESERIALIZE_FIELD_OPT("loadingFailed", m_loadingFailed),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD_OPT("ownerNode", m_ownerNode),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceMapURL", m_sourceMapURL),
    CRDTP_DESERIALIZE_FIELD("sourceURL", m_sourceURL),
    CRDTP_DESERIALIZE_FIELD("startColumn", m_startColumn),
    CRDTP_DESERIALIZE_FIELD("startLine", m_startLine),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("title", m_title),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSStyleSheetHeader)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("sourceURL", m_sourceURL);
    CRDTP_SERIALIZE_FIELD("sourceMapURL", m_sourceMapURL);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("title", m_title);
    CRDTP_SERIALIZE_FIELD("ownerNode", m_ownerNode);
    CRDTP_SERIALIZE_FIELD("disabled", m_disabled);
    CRDTP_SERIALIZE_FIELD("hasSourceURL", m_hasSourceURL);
    CRDTP_SERIALIZE_FIELD("isInline", m_isInline);
    CRDTP_SERIALIZE_FIELD("isMutable", m_isMutable);
    CRDTP_SERIALIZE_FIELD("isConstructed", m_isConstructed);
    CRDTP_SERIALIZE_FIELD("startLine", m_startLine);
    CRDTP_SERIALIZE_FIELD("startColumn", m_startColumn);
    CRDTP_SERIALIZE_FIELD("length", m_length);
    CRDTP_SERIALIZE_FIELD("endLine", m_endLine);
    CRDTP_SERIALIZE_FIELD("endColumn", m_endColumn);
    CRDTP_SERIALIZE_FIELD("loadingFailed", m_loadingFailed);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSRule)
    CRDTP_DESERIALIZE_FIELD_OPT("containerQueries", m_containerQueries),
    CRDTP_DESERIALIZE_FIELD_OPT("layers", m_layers),
    CRDTP_DESERIALIZE_FIELD_OPT("media", m_media),
    CRDTP_DESERIALIZE_FIELD_OPT("nestingSelectors", m_nestingSelectors),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD_OPT("originTreeScopeNodeId", m_originTreeScopeNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("ruleTypes", m_ruleTypes),
    CRDTP_DESERIALIZE_FIELD_OPT("scopes", m_scopes),
    CRDTP_DESERIALIZE_FIELD("selectorList", m_selectorList),
    CRDTP_DESERIALIZE_FIELD_OPT("startingStyles", m_startingStyles),
    CRDTP_DESERIALIZE_FIELD("style", m_style),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD_OPT("supports", m_supports),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSRule)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("selectorList", m_selectorList);
    CRDTP_SERIALIZE_FIELD("nestingSelectors", m_nestingSelectors);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("style", m_style);
    CRDTP_SERIALIZE_FIELD("originTreeScopeNodeId", m_originTreeScopeNodeId);
    CRDTP_SERIALIZE_FIELD("media", m_media);
    CRDTP_SERIALIZE_FIELD("containerQueries", m_containerQueries);
    CRDTP_SERIALIZE_FIELD("supports", m_supports);
    CRDTP_SERIALIZE_FIELD("layers", m_layers);
    CRDTP_SERIALIZE_FIELD("scopes", m_scopes);
    CRDTP_SERIALIZE_FIELD("ruleTypes", m_ruleTypes);
    CRDTP_SERIALIZE_FIELD("startingStyles", m_startingStyles);
CRDTP_END_SERIALIZER();


namespace CSSRuleTypeEnum {
const char MediaRule[] = "MediaRule";
const char SupportsRule[] = "SupportsRule";
const char ContainerRule[] = "ContainerRule";
const char LayerRule[] = "LayerRule";
const char ScopeRule[] = "ScopeRule";
const char StyleRule[] = "StyleRule";
const char StartingStyleRule[] = "StartingStyleRule";
} // namespace CSSRuleTypeEnum


CRDTP_BEGIN_DESERIALIZER(RuleUsage)
    CRDTP_DESERIALIZE_FIELD("endOffset", m_endOffset),
    CRDTP_DESERIALIZE_FIELD("startOffset", m_startOffset),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("used", m_used),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RuleUsage)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("startOffset", m_startOffset);
    CRDTP_SERIALIZE_FIELD("endOffset", m_endOffset);
    CRDTP_SERIALIZE_FIELD("used", m_used);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SourceRange)
    CRDTP_DESERIALIZE_FIELD("endColumn", m_endColumn),
    CRDTP_DESERIALIZE_FIELD("endLine", m_endLine),
    CRDTP_DESERIALIZE_FIELD("startColumn", m_startColumn),
    CRDTP_DESERIALIZE_FIELD("startLine", m_startLine),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SourceRange)
    CRDTP_SERIALIZE_FIELD("startLine", m_startLine);
    CRDTP_SERIALIZE_FIELD("startColumn", m_startColumn);
    CRDTP_SERIALIZE_FIELD("endLine", m_endLine);
    CRDTP_SERIALIZE_FIELD("endColumn", m_endColumn);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ShorthandEntry)
    CRDTP_DESERIALIZE_FIELD_OPT("important", m_important),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ShorthandEntry)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("important", m_important);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSComputedStyleProperty)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSComputedStyleProperty)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ComputedStyleExtraFields)
    CRDTP_DESERIALIZE_FIELD("isAppearanceBase", m_isAppearanceBase),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ComputedStyleExtraFields)
    CRDTP_SERIALIZE_FIELD("isAppearanceBase", m_isAppearanceBase);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSStyle)
    CRDTP_DESERIALIZE_FIELD("cssProperties", m_cssProperties),
    CRDTP_DESERIALIZE_FIELD_OPT("cssText", m_cssText),
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD("shorthandEntries", m_shorthandEntries),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSStyle)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("cssProperties", m_cssProperties);
    CRDTP_SERIALIZE_FIELD("shorthandEntries", m_shorthandEntries);
    CRDTP_SERIALIZE_FIELD("cssText", m_cssText);
    CRDTP_SERIALIZE_FIELD("range", m_range);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSProperty)
    CRDTP_DESERIALIZE_FIELD_OPT("disabled", m_disabled),
    CRDTP_DESERIALIZE_FIELD_OPT("implicit", m_implicit),
    CRDTP_DESERIALIZE_FIELD_OPT("important", m_important),
    CRDTP_DESERIALIZE_FIELD_OPT("longhandProperties", m_longhandProperties),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("parsedOk", m_parsedOk),
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("text", m_text),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSProperty)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("important", m_important);
    CRDTP_SERIALIZE_FIELD("implicit", m_implicit);
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("parsedOk", m_parsedOk);
    CRDTP_SERIALIZE_FIELD("disabled", m_disabled);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("longhandProperties", m_longhandProperties);
CRDTP_END_SERIALIZER();



const char* CSSMedia::SourceEnum::MediaRule = "mediaRule";
const char* CSSMedia::SourceEnum::ImportRule = "importRule";
const char* CSSMedia::SourceEnum::LinkedSheet = "linkedSheet";
const char* CSSMedia::SourceEnum::InlineSheet = "inlineSheet";
CRDTP_BEGIN_DESERIALIZER(CSSMedia)
    CRDTP_DESERIALIZE_FIELD_OPT("mediaList", m_mediaList),
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD("source", m_source),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceURL", m_sourceURL),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSMedia)
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("source", m_source);
    CRDTP_SERIALIZE_FIELD("sourceURL", m_sourceURL);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("mediaList", m_mediaList);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(MediaQuery)
    CRDTP_DESERIALIZE_FIELD("active", m_active),
    CRDTP_DESERIALIZE_FIELD("expressions", m_expressions),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(MediaQuery)
    CRDTP_SERIALIZE_FIELD("expressions", m_expressions);
    CRDTP_SERIALIZE_FIELD("active", m_active);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(MediaQueryExpression)
    CRDTP_DESERIALIZE_FIELD_OPT("computedLength", m_computedLength),
    CRDTP_DESERIALIZE_FIELD("feature", m_feature),
    CRDTP_DESERIALIZE_FIELD("unit", m_unit),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
    CRDTP_DESERIALIZE_FIELD_OPT("valueRange", m_valueRange),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(MediaQueryExpression)
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("unit", m_unit);
    CRDTP_SERIALIZE_FIELD("feature", m_feature);
    CRDTP_SERIALIZE_FIELD("valueRange", m_valueRange);
    CRDTP_SERIALIZE_FIELD("computedLength", m_computedLength);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSContainerQuery)
    CRDTP_DESERIALIZE_FIELD_OPT("logicalAxes", m_logicalAxes),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("physicalAxes", m_physicalAxes),
    CRDTP_DESERIALIZE_FIELD_OPT("queriesAnchored", m_queriesAnchored),
    CRDTP_DESERIALIZE_FIELD_OPT("queriesScrollState", m_queriesScrollState),
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSContainerQuery)
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("physicalAxes", m_physicalAxes);
    CRDTP_SERIALIZE_FIELD("logicalAxes", m_logicalAxes);
    CRDTP_SERIALIZE_FIELD("queriesScrollState", m_queriesScrollState);
    CRDTP_SERIALIZE_FIELD("queriesAnchored", m_queriesAnchored);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSSupports)
    CRDTP_DESERIALIZE_FIELD("active", m_active),
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSSupports)
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("active", m_active);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSScope)
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSScope)
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSLayer)
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSLayer)
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSStartingStyle)
    CRDTP_DESERIALIZE_FIELD_OPT("range", m_range),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSStartingStyle)
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSLayerData)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("order", m_order),
    CRDTP_DESERIALIZE_FIELD_OPT("subLayers", m_subLayers),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSLayerData)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("subLayers", m_subLayers);
    CRDTP_SERIALIZE_FIELD("order", m_order);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PlatformFontUsage)
    CRDTP_DESERIALIZE_FIELD("familyName", m_familyName),
    CRDTP_DESERIALIZE_FIELD("glyphCount", m_glyphCount),
    CRDTP_DESERIALIZE_FIELD("isCustomFont", m_isCustomFont),
    CRDTP_DESERIALIZE_FIELD("postScriptName", m_postScriptName),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PlatformFontUsage)
    CRDTP_SERIALIZE_FIELD("familyName", m_familyName);
    CRDTP_SERIALIZE_FIELD("postScriptName", m_postScriptName);
    CRDTP_SERIALIZE_FIELD("isCustomFont", m_isCustomFont);
    CRDTP_SERIALIZE_FIELD("glyphCount", m_glyphCount);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FontVariationAxis)
    CRDTP_DESERIALIZE_FIELD("defaultValue", m_defaultValue),
    CRDTP_DESERIALIZE_FIELD("maxValue", m_maxValue),
    CRDTP_DESERIALIZE_FIELD("minValue", m_minValue),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("tag", m_tag),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FontVariationAxis)
    CRDTP_SERIALIZE_FIELD("tag", m_tag);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("minValue", m_minValue);
    CRDTP_SERIALIZE_FIELD("maxValue", m_maxValue);
    CRDTP_SERIALIZE_FIELD("defaultValue", m_defaultValue);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FontFace)
    CRDTP_DESERIALIZE_FIELD("fontDisplay", m_fontDisplay),
    CRDTP_DESERIALIZE_FIELD("fontFamily", m_fontFamily),
    CRDTP_DESERIALIZE_FIELD("fontStretch", m_fontStretch),
    CRDTP_DESERIALIZE_FIELD("fontStyle", m_fontStyle),
    CRDTP_DESERIALIZE_FIELD("fontVariant", m_fontVariant),
    CRDTP_DESERIALIZE_FIELD_OPT("fontVariationAxes", m_fontVariationAxes),
    CRDTP_DESERIALIZE_FIELD("fontWeight", m_fontWeight),
    CRDTP_DESERIALIZE_FIELD("platformFontFamily", m_platformFontFamily),
    CRDTP_DESERIALIZE_FIELD("src", m_src),
    CRDTP_DESERIALIZE_FIELD("unicodeRange", m_unicodeRange),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FontFace)
    CRDTP_SERIALIZE_FIELD("fontFamily", m_fontFamily);
    CRDTP_SERIALIZE_FIELD("fontStyle", m_fontStyle);
    CRDTP_SERIALIZE_FIELD("fontVariant", m_fontVariant);
    CRDTP_SERIALIZE_FIELD("fontWeight", m_fontWeight);
    CRDTP_SERIALIZE_FIELD("fontStretch", m_fontStretch);
    CRDTP_SERIALIZE_FIELD("fontDisplay", m_fontDisplay);
    CRDTP_SERIALIZE_FIELD("unicodeRange", m_unicodeRange);
    CRDTP_SERIALIZE_FIELD("src", m_src);
    CRDTP_SERIALIZE_FIELD("platformFontFamily", m_platformFontFamily);
    CRDTP_SERIALIZE_FIELD("fontVariationAxes", m_fontVariationAxes);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSPositionTryRule)
    CRDTP_DESERIALIZE_FIELD("active", m_active),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("style", m_style),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSPositionTryRule)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("style", m_style);
    CRDTP_SERIALIZE_FIELD("active", m_active);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSKeyframesRule)
    CRDTP_DESERIALIZE_FIELD("animationName", m_animationName),
    CRDTP_DESERIALIZE_FIELD("keyframes", m_keyframes),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSKeyframesRule)
    CRDTP_SERIALIZE_FIELD("animationName", m_animationName);
    CRDTP_SERIALIZE_FIELD("keyframes", m_keyframes);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSPropertyRegistration)
    CRDTP_DESERIALIZE_FIELD("inherits", m_inherits),
    CRDTP_DESERIALIZE_FIELD_OPT("initialValue", m_initialValue),
    CRDTP_DESERIALIZE_FIELD("propertyName", m_propertyName),
    CRDTP_DESERIALIZE_FIELD("syntax", m_syntax),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSPropertyRegistration)
    CRDTP_SERIALIZE_FIELD("propertyName", m_propertyName);
    CRDTP_SERIALIZE_FIELD("initialValue", m_initialValue);
    CRDTP_SERIALIZE_FIELD("inherits", m_inherits);
    CRDTP_SERIALIZE_FIELD("syntax", m_syntax);
CRDTP_END_SERIALIZER();



const char* CSSAtRule::TypeEnum::FontFace = "font-face";
const char* CSSAtRule::TypeEnum::FontFeatureValues = "font-feature-values";
const char* CSSAtRule::TypeEnum::FontPaletteValues = "font-palette-values";

const char* CSSAtRule::SubsectionEnum::Swash = "swash";
const char* CSSAtRule::SubsectionEnum::Annotation = "annotation";
const char* CSSAtRule::SubsectionEnum::Ornaments = "ornaments";
const char* CSSAtRule::SubsectionEnum::Stylistic = "stylistic";
const char* CSSAtRule::SubsectionEnum::Styleset = "styleset";
const char* CSSAtRule::SubsectionEnum::CharacterVariant = "character-variant";
CRDTP_BEGIN_DESERIALIZER(CSSAtRule)
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("style", m_style),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD_OPT("subsection", m_subsection),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSAtRule)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("subsection", m_subsection);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("style", m_style);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSPropertyRule)
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("propertyName", m_propertyName),
    CRDTP_DESERIALIZE_FIELD("style", m_style),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSPropertyRule)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("propertyName", m_propertyName);
    CRDTP_SERIALIZE_FIELD("style", m_style);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSFunctionParameter)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSFunctionParameter)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("type", m_type);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSFunctionConditionNode)
    CRDTP_DESERIALIZE_FIELD("children", m_children),
    CRDTP_DESERIALIZE_FIELD("conditionText", m_conditionText),
    CRDTP_DESERIALIZE_FIELD_OPT("containerQueries", m_containerQueries),
    CRDTP_DESERIALIZE_FIELD_OPT("media", m_media),
    CRDTP_DESERIALIZE_FIELD_OPT("supports", m_supports),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSFunctionConditionNode)
    CRDTP_SERIALIZE_FIELD("media", m_media);
    CRDTP_SERIALIZE_FIELD("containerQueries", m_containerQueries);
    CRDTP_SERIALIZE_FIELD("supports", m_supports);
    CRDTP_SERIALIZE_FIELD("children", m_children);
    CRDTP_SERIALIZE_FIELD("conditionText", m_conditionText);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSFunctionNode)
    CRDTP_DESERIALIZE_FIELD_OPT("condition", m_condition),
    CRDTP_DESERIALIZE_FIELD_OPT("style", m_style),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSFunctionNode)
    CRDTP_SERIALIZE_FIELD("condition", m_condition);
    CRDTP_SERIALIZE_FIELD("style", m_style);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSFunctionRule)
    CRDTP_DESERIALIZE_FIELD("children", m_children),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("parameters", m_parameters),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSFunctionRule)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("parameters", m_parameters);
    CRDTP_SERIALIZE_FIELD("children", m_children);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CSSKeyframeRule)
    CRDTP_DESERIALIZE_FIELD("keyText", m_keyText),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("style", m_style),
    CRDTP_DESERIALIZE_FIELD_OPT("styleSheetId", m_styleSheetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CSSKeyframeRule)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("keyText", m_keyText);
    CRDTP_SERIALIZE_FIELD("style", m_style);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(StyleDeclarationEdit)
    CRDTP_DESERIALIZE_FIELD("range", m_range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", m_styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StyleDeclarationEdit)
    CRDTP_SERIALIZE_FIELD("styleSheetId", m_styleSheetId);
    CRDTP_SERIALIZE_FIELD("range", m_range);
    CRDTP_SERIALIZE_FIELD("text", m_text);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::fontsUpdated(std::unique_ptr<protocol::CSS::FontFace> font)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("font"), font);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("CSS.fontsUpdated", serializer.Finish()));
}

void Frontend::mediaQueryResultChanged()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("CSS.mediaQueryResultChanged"));
}

void Frontend::styleSheetAdded(std::unique_ptr<protocol::CSS::CSSStyleSheetHeader> header)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("header"), header);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("CSS.styleSheetAdded", serializer.Finish()));
}

void Frontend::styleSheetChanged(const String& styleSheetId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("styleSheetId"), styleSheetId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("CSS.styleSheetChanged", serializer.Finish()));
}

void Frontend::styleSheetRemoved(const String& styleSheetId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("styleSheetId"), styleSheetId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("CSS.styleSheetRemoved", serializer.Finish()));
}

void Frontend::computedStyleUpdated(int nodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("CSS.computedStyleUpdated", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void addRule(const crdtp::Dispatchable& dispatchable);
    void collectClassNames(const crdtp::Dispatchable& dispatchable);
    void createStyleSheet(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void forcePseudoState(const crdtp::Dispatchable& dispatchable);
    void forceStartingStyle(const crdtp::Dispatchable& dispatchable);
    void getBackgroundColors(const crdtp::Dispatchable& dispatchable);
    void getComputedStyleForNode(const crdtp::Dispatchable& dispatchable);
    void resolveValues(const crdtp::Dispatchable& dispatchable);
    void getLonghandProperties(const crdtp::Dispatchable& dispatchable);
    void getInlineStylesForNode(const crdtp::Dispatchable& dispatchable);
    void getAnimatedStylesForNode(const crdtp::Dispatchable& dispatchable);
    void getMatchedStylesForNode(const crdtp::Dispatchable& dispatchable);
    void getEnvironmentVariables(const crdtp::Dispatchable& dispatchable);
    void getMediaQueries(const crdtp::Dispatchable& dispatchable);
    void getPlatformFontsForNode(const crdtp::Dispatchable& dispatchable);
    void getStyleSheetText(const crdtp::Dispatchable& dispatchable);
    void getLayersForNode(const crdtp::Dispatchable& dispatchable);
    void getLocationForSelector(const crdtp::Dispatchable& dispatchable);
    void trackComputedStyleUpdatesForNode(const crdtp::Dispatchable& dispatchable);
    void trackComputedStyleUpdates(const crdtp::Dispatchable& dispatchable);
    void takeComputedStyleUpdates(const crdtp::Dispatchable& dispatchable);
    void setEffectivePropertyValueForNode(const crdtp::Dispatchable& dispatchable);
    void setPropertyRulePropertyName(const crdtp::Dispatchable& dispatchable);
    void setKeyframeKey(const crdtp::Dispatchable& dispatchable);
    void setMediaText(const crdtp::Dispatchable& dispatchable);
    void setContainerQueryText(const crdtp::Dispatchable& dispatchable);
    void setSupportsText(const crdtp::Dispatchable& dispatchable);
    void setScopeText(const crdtp::Dispatchable& dispatchable);
    void setRuleSelector(const crdtp::Dispatchable& dispatchable);
    void setStyleSheetText(const crdtp::Dispatchable& dispatchable);
    void setStyleTexts(const crdtp::Dispatchable& dispatchable);
    void startRuleUsageTracking(const crdtp::Dispatchable& dispatchable);
    void stopRuleUsageTracking(const crdtp::Dispatchable& dispatchable);
    void takeCoverageDelta(const crdtp::Dispatchable& dispatchable);
    void setLocalFontsEnabled(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("addRule"),
          &DomainDispatcherImpl::addRule
    },
    {
          crdtp::SpanFrom("collectClassNames"),
          &DomainDispatcherImpl::collectClassNames
    },
    {
          crdtp::SpanFrom("createStyleSheet"),
          &DomainDispatcherImpl::createStyleSheet
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("forcePseudoState"),
          &DomainDispatcherImpl::forcePseudoState
    },
    {
          crdtp::SpanFrom("forceStartingStyle"),
          &DomainDispatcherImpl::forceStartingStyle
    },
    {
          crdtp::SpanFrom("getAnimatedStylesForNode"),
          &DomainDispatcherImpl::getAnimatedStylesForNode
    },
    {
          crdtp::SpanFrom("getBackgroundColors"),
          &DomainDispatcherImpl::getBackgroundColors
    },
    {
          crdtp::SpanFrom("getComputedStyleForNode"),
          &DomainDispatcherImpl::getComputedStyleForNode
    },
    {
          crdtp::SpanFrom("getEnvironmentVariables"),
          &DomainDispatcherImpl::getEnvironmentVariables
    },
    {
          crdtp::SpanFrom("getInlineStylesForNode"),
          &DomainDispatcherImpl::getInlineStylesForNode
    },
    {
          crdtp::SpanFrom("getLayersForNode"),
          &DomainDispatcherImpl::getLayersForNode
    },
    {
          crdtp::SpanFrom("getLocationForSelector"),
          &DomainDispatcherImpl::getLocationForSelector
    },
    {
          crdtp::SpanFrom("getLonghandProperties"),
          &DomainDispatcherImpl::getLonghandProperties
    },
    {
          crdtp::SpanFrom("getMatchedStylesForNode"),
          &DomainDispatcherImpl::getMatchedStylesForNode
    },
    {
          crdtp::SpanFrom("getMediaQueries"),
          &DomainDispatcherImpl::getMediaQueries
    },
    {
          crdtp::SpanFrom("getPlatformFontsForNode"),
          &DomainDispatcherImpl::getPlatformFontsForNode
    },
    {
          crdtp::SpanFrom("getStyleSheetText"),
          &DomainDispatcherImpl::getStyleSheetText
    },
    {
          crdtp::SpanFrom("resolveValues"),
          &DomainDispatcherImpl::resolveValues
    },
    {
          crdtp::SpanFrom("setContainerQueryText"),
          &DomainDispatcherImpl::setContainerQueryText
    },
    {
          crdtp::SpanFrom("setEffectivePropertyValueForNode"),
          &DomainDispatcherImpl::setEffectivePropertyValueForNode
    },
    {
          crdtp::SpanFrom("setKeyframeKey"),
          &DomainDispatcherImpl::setKeyframeKey
    },
    {
          crdtp::SpanFrom("setLocalFontsEnabled"),
          &DomainDispatcherImpl::setLocalFontsEnabled
    },
    {
          crdtp::SpanFrom("setMediaText"),
          &DomainDispatcherImpl::setMediaText
    },
    {
          crdtp::SpanFrom("setPropertyRulePropertyName"),
          &DomainDispatcherImpl::setPropertyRulePropertyName
    },
    {
          crdtp::SpanFrom("setRuleSelector"),
          &DomainDispatcherImpl::setRuleSelector
    },
    {
          crdtp::SpanFrom("setScopeText"),
          &DomainDispatcherImpl::setScopeText
    },
    {
          crdtp::SpanFrom("setStyleSheetText"),
          &DomainDispatcherImpl::setStyleSheetText
    },
    {
          crdtp::SpanFrom("setStyleTexts"),
          &DomainDispatcherImpl::setStyleTexts
    },
    {
          crdtp::SpanFrom("setSupportsText"),
          &DomainDispatcherImpl::setSupportsText
    },
    {
          crdtp::SpanFrom("startRuleUsageTracking"),
          &DomainDispatcherImpl::startRuleUsageTracking
    },
    {
          crdtp::SpanFrom("stopRuleUsageTracking"),
          &DomainDispatcherImpl::stopRuleUsageTracking
    },
    {
          crdtp::SpanFrom("takeComputedStyleUpdates"),
          &DomainDispatcherImpl::takeComputedStyleUpdates
    },
    {
          crdtp::SpanFrom("takeCoverageDelta"),
          &DomainDispatcherImpl::takeCoverageDelta
    },
    {
          crdtp::SpanFrom("trackComputedStyleUpdates"),
          &DomainDispatcherImpl::trackComputedStyleUpdates
    },
    {
          crdtp::SpanFrom("trackComputedStyleUpdatesForNode"),
          &DomainDispatcherImpl::trackComputedStyleUpdatesForNode
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct addRuleParams : public crdtp::DeserializableProtocolObject<addRuleParams> {
    String styleSheetId;
    String ruleText;
    std::unique_ptr<protocol::CSS::SourceRange> location;
    std::optional<int> nodeForPropertySyntaxValidation;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addRuleParams)
    CRDTP_DESERIALIZE_FIELD("location", location),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeForPropertySyntaxValidation", nodeForPropertySyntaxValidation),
    CRDTP_DESERIALIZE_FIELD("ruleText", ruleText),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addRule(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addRuleParams params;
    if (!addRuleParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSRule> out_rule;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->addRule(params.styleSheetId, params.ruleText, std::move(params.location), std::move(params.nodeForPropertySyntaxValidation), &out_rule);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.addRule"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("rule"), out_rule);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct collectClassNamesParams : public crdtp::DeserializableProtocolObject<collectClassNamesParams> {
    String styleSheetId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(collectClassNamesParams)
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::collectClassNames(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    collectClassNamesParams params;
    if (!collectClassNamesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_classNames;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->collectClassNames(params.styleSheetId, &out_classNames);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.collectClassNames"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("classNames"), out_classNames);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct createStyleSheetParams : public crdtp::DeserializableProtocolObject<createStyleSheetParams> {
    String frameId;
    std::optional<bool> force;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(createStyleSheetParams)
    CRDTP_DESERIALIZE_FIELD_OPT("force", force),
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::createStyleSheet(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    createStyleSheetParams params;
    if (!createStyleSheetParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_styleSheetId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->createStyleSheet(params.frameId, std::move(params.force), &out_styleSheetId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.createStyleSheet"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("styleSheetId"), out_styleSheetId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class EnableCallbackImpl : public Backend::EnableCallback, public DomainDispatcher::Callback {
public:
    EnableCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CSS.enable"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->enable(std::make_unique<EnableCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct forcePseudoStateParams : public crdtp::DeserializableProtocolObject<forcePseudoStateParams> {
    int nodeId;
    std::unique_ptr<protocol::Array<String>> forcedPseudoClasses;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(forcePseudoStateParams)
    CRDTP_DESERIALIZE_FIELD("forcedPseudoClasses", forcedPseudoClasses),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::forcePseudoState(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    forcePseudoStateParams params;
    if (!forcePseudoStateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->forcePseudoState(params.nodeId, std::move(params.forcedPseudoClasses));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.forcePseudoState"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct forceStartingStyleParams : public crdtp::DeserializableProtocolObject<forceStartingStyleParams> {
    int nodeId;
    bool forced;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(forceStartingStyleParams)
    CRDTP_DESERIALIZE_FIELD("forced", forced),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::forceStartingStyle(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    forceStartingStyleParams params;
    if (!forceStartingStyleParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->forceStartingStyle(params.nodeId, params.forced);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.forceStartingStyle"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getBackgroundColorsParams : public crdtp::DeserializableProtocolObject<getBackgroundColorsParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getBackgroundColorsParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getBackgroundColors(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getBackgroundColorsParams params;
    if (!getBackgroundColorsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_backgroundColors;
    std::optional<String> out_computedFontSize;
    std::optional<String> out_computedFontWeight;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getBackgroundColors(params.nodeId, &out_backgroundColors, &out_computedFontSize, &out_computedFontWeight);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getBackgroundColors"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("backgroundColors"), out_backgroundColors);
          serializer.AddField(crdtp::MakeSpan("computedFontSize"), out_computedFontSize);
          serializer.AddField(crdtp::MakeSpan("computedFontWeight"), out_computedFontWeight);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getComputedStyleForNodeParams : public crdtp::DeserializableProtocolObject<getComputedStyleForNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getComputedStyleForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getComputedStyleForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getComputedStyleForNodeParams params;
    if (!getComputedStyleForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::CSSComputedStyleProperty>> out_computedStyle;
    std::unique_ptr<protocol::CSS::ComputedStyleExtraFields> out_extraFields;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getComputedStyleForNode(params.nodeId, &out_computedStyle, &out_extraFields);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getComputedStyleForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("computedStyle"), out_computedStyle);
          serializer.AddField(crdtp::MakeSpan("extraFields"), out_extraFields);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct resolveValuesParams : public crdtp::DeserializableProtocolObject<resolveValuesParams> {
    std::unique_ptr<protocol::Array<String>> values;
    int nodeId;
    std::optional<String> propertyName;
    std::optional<String> pseudoType;
    std::optional<String> pseudoIdentifier;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(resolveValuesParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("propertyName", propertyName),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoIdentifier", pseudoIdentifier),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoType", pseudoType),
    CRDTP_DESERIALIZE_FIELD("values", values),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::resolveValues(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    resolveValuesParams params;
    if (!resolveValuesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_results;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->resolveValues(std::move(params.values), params.nodeId, std::move(params.propertyName), std::move(params.pseudoType), std::move(params.pseudoIdentifier), &out_results);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.resolveValues"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("results"), out_results);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getLonghandPropertiesParams : public crdtp::DeserializableProtocolObject<getLonghandPropertiesParams> {
    String shorthandName;
    String value;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getLonghandPropertiesParams)
    CRDTP_DESERIALIZE_FIELD("shorthandName", shorthandName),
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getLonghandProperties(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getLonghandPropertiesParams params;
    if (!getLonghandPropertiesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> out_longhandProperties;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getLonghandProperties(params.shorthandName, params.value, &out_longhandProperties);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getLonghandProperties"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("longhandProperties"), out_longhandProperties);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getInlineStylesForNodeParams : public crdtp::DeserializableProtocolObject<getInlineStylesForNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getInlineStylesForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getInlineStylesForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getInlineStylesForNodeParams params;
    if (!getInlineStylesForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSStyle> out_inlineStyle;
    std::unique_ptr<protocol::CSS::CSSStyle> out_attributesStyle;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getInlineStylesForNode(params.nodeId, &out_inlineStyle, &out_attributesStyle);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getInlineStylesForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("inlineStyle"), out_inlineStyle);
          serializer.AddField(crdtp::MakeSpan("attributesStyle"), out_attributesStyle);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getAnimatedStylesForNodeParams : public crdtp::DeserializableProtocolObject<getAnimatedStylesForNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAnimatedStylesForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAnimatedStylesForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAnimatedStylesForNodeParams params;
    if (!getAnimatedStylesForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::CSSAnimationStyle>> out_animationStyles;
    std::unique_ptr<protocol::CSS::CSSStyle> out_transitionsStyle;
    std::unique_ptr<protocol::Array<protocol::CSS::InheritedAnimatedStyleEntry>> out_inherited;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getAnimatedStylesForNode(params.nodeId, &out_animationStyles, &out_transitionsStyle, &out_inherited);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getAnimatedStylesForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("animationStyles"), out_animationStyles);
          serializer.AddField(crdtp::MakeSpan("transitionsStyle"), out_transitionsStyle);
          serializer.AddField(crdtp::MakeSpan("inherited"), out_inherited);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getMatchedStylesForNodeParams : public crdtp::DeserializableProtocolObject<getMatchedStylesForNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getMatchedStylesForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getMatchedStylesForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getMatchedStylesForNodeParams params;
    if (!getMatchedStylesForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSStyle> out_inlineStyle;
    std::unique_ptr<protocol::CSS::CSSStyle> out_attributesStyle;
    std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> out_matchedCSSRules;
    std::unique_ptr<protocol::Array<protocol::CSS::PseudoElementMatches>> out_pseudoElements;
    std::unique_ptr<protocol::Array<protocol::CSS::InheritedStyleEntry>> out_inherited;
    std::unique_ptr<protocol::Array<protocol::CSS::InheritedPseudoElementMatches>> out_inheritedPseudoElements;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSKeyframesRule>> out_cssKeyframesRules;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSPositionTryRule>> out_cssPositionTryRules;
    std::optional<int> out_activePositionFallbackIndex;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSPropertyRule>> out_cssPropertyRules;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSPropertyRegistration>> out_cssPropertyRegistrations;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSAtRule>> out_cssAtRules;
    std::optional<int> out_parentLayoutNodeId;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionRule>> out_cssFunctionRules;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getMatchedStylesForNode(params.nodeId, &out_inlineStyle, &out_attributesStyle, &out_matchedCSSRules, &out_pseudoElements, &out_inherited, &out_inheritedPseudoElements, &out_cssKeyframesRules, &out_cssPositionTryRules, &out_activePositionFallbackIndex, &out_cssPropertyRules, &out_cssPropertyRegistrations, &out_cssAtRules, &out_parentLayoutNodeId, &out_cssFunctionRules);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getMatchedStylesForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("inlineStyle"), out_inlineStyle);
          serializer.AddField(crdtp::MakeSpan("attributesStyle"), out_attributesStyle);
          serializer.AddField(crdtp::MakeSpan("matchedCSSRules"), out_matchedCSSRules);
          serializer.AddField(crdtp::MakeSpan("pseudoElements"), out_pseudoElements);
          serializer.AddField(crdtp::MakeSpan("inherited"), out_inherited);
          serializer.AddField(crdtp::MakeSpan("inheritedPseudoElements"), out_inheritedPseudoElements);
          serializer.AddField(crdtp::MakeSpan("cssKeyframesRules"), out_cssKeyframesRules);
          serializer.AddField(crdtp::MakeSpan("cssPositionTryRules"), out_cssPositionTryRules);
          serializer.AddField(crdtp::MakeSpan("activePositionFallbackIndex"), out_activePositionFallbackIndex);
          serializer.AddField(crdtp::MakeSpan("cssPropertyRules"), out_cssPropertyRules);
          serializer.AddField(crdtp::MakeSpan("cssPropertyRegistrations"), out_cssPropertyRegistrations);
          serializer.AddField(crdtp::MakeSpan("cssAtRules"), out_cssAtRules);
          serializer.AddField(crdtp::MakeSpan("parentLayoutNodeId"), out_parentLayoutNodeId);
          serializer.AddField(crdtp::MakeSpan("cssFunctionRules"), out_cssFunctionRules);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getEnvironmentVariables(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::DictionaryValue> out_environmentVariables;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getEnvironmentVariables(&out_environmentVariables);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getEnvironmentVariables"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("environmentVariables"), out_environmentVariables);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getMediaQueries(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::CSSMedia>> out_medias;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getMediaQueries(&out_medias);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getMediaQueries"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("medias"), out_medias);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getPlatformFontsForNodeParams : public crdtp::DeserializableProtocolObject<getPlatformFontsForNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getPlatformFontsForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getPlatformFontsForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getPlatformFontsForNodeParams params;
    if (!getPlatformFontsForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::PlatformFontUsage>> out_fonts;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getPlatformFontsForNode(params.nodeId, &out_fonts);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getPlatformFontsForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("fonts"), out_fonts);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getStyleSheetTextParams : public crdtp::DeserializableProtocolObject<getStyleSheetTextParams> {
    String styleSheetId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getStyleSheetTextParams)
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getStyleSheetText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getStyleSheetTextParams params;
    if (!getStyleSheetTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_text;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getStyleSheetText(params.styleSheetId, &out_text);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getStyleSheetText"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("text"), out_text);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getLayersForNodeParams : public crdtp::DeserializableProtocolObject<getLayersForNodeParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getLayersForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getLayersForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getLayersForNodeParams params;
    if (!getLayersForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSLayerData> out_rootLayer;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getLayersForNode(params.nodeId, &out_rootLayer);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getLayersForNode"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("rootLayer"), out_rootLayer);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getLocationForSelectorParams : public crdtp::DeserializableProtocolObject<getLocationForSelectorParams> {
    String styleSheetId;
    String selectorText;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getLocationForSelectorParams)
    CRDTP_DESERIALIZE_FIELD("selectorText", selectorText),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getLocationForSelector(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getLocationForSelectorParams params;
    if (!getLocationForSelectorParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::SourceRange>> out_ranges;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getLocationForSelector(params.styleSheetId, params.selectorText, &out_ranges);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.getLocationForSelector"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("ranges"), out_ranges);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct trackComputedStyleUpdatesForNodeParams : public crdtp::DeserializableProtocolObject<trackComputedStyleUpdatesForNodeParams> {
    std::optional<int> nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackComputedStyleUpdatesForNodeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackComputedStyleUpdatesForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackComputedStyleUpdatesForNodeParams params;
    if (!trackComputedStyleUpdatesForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->trackComputedStyleUpdatesForNode(std::move(params.nodeId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.trackComputedStyleUpdatesForNode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct trackComputedStyleUpdatesParams : public crdtp::DeserializableProtocolObject<trackComputedStyleUpdatesParams> {
    std::unique_ptr<protocol::Array<protocol::CSS::CSSComputedStyleProperty>> propertiesToTrack;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackComputedStyleUpdatesParams)
    CRDTP_DESERIALIZE_FIELD("propertiesToTrack", propertiesToTrack),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackComputedStyleUpdates(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackComputedStyleUpdatesParams params;
    if (!trackComputedStyleUpdatesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->trackComputedStyleUpdates(std::move(params.propertiesToTrack));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.trackComputedStyleUpdates"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class TakeComputedStyleUpdatesCallbackImpl : public Backend::TakeComputedStyleUpdatesCallback, public DomainDispatcher::Callback {
public:
    TakeComputedStyleUpdatesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CSS.takeComputedStyleUpdates"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<int>> nodeIds) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("nodeIds"), nodeIds);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::takeComputedStyleUpdates(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->takeComputedStyleUpdates(std::make_unique<TakeComputedStyleUpdatesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct setEffectivePropertyValueForNodeParams : public crdtp::DeserializableProtocolObject<setEffectivePropertyValueForNodeParams> {
    int nodeId;
    String propertyName;
    String value;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setEffectivePropertyValueForNodeParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("propertyName", propertyName),
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setEffectivePropertyValueForNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setEffectivePropertyValueForNodeParams params;
    if (!setEffectivePropertyValueForNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setEffectivePropertyValueForNode(params.nodeId, params.propertyName, params.value);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setEffectivePropertyValueForNode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPropertyRulePropertyNameParams : public crdtp::DeserializableProtocolObject<setPropertyRulePropertyNameParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String propertyName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPropertyRulePropertyNameParams)
    CRDTP_DESERIALIZE_FIELD("propertyName", propertyName),
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPropertyRulePropertyName(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPropertyRulePropertyNameParams params;
    if (!setPropertyRulePropertyNameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::Value> out_propertyName;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setPropertyRulePropertyName(params.styleSheetId, std::move(params.range), params.propertyName, &out_propertyName);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setPropertyRulePropertyName"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("propertyName"), out_propertyName);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setKeyframeKeyParams : public crdtp::DeserializableProtocolObject<setKeyframeKeyParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String keyText;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setKeyframeKeyParams)
    CRDTP_DESERIALIZE_FIELD("keyText", keyText),
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setKeyframeKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setKeyframeKeyParams params;
    if (!setKeyframeKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::Value> out_keyText;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setKeyframeKey(params.styleSheetId, std::move(params.range), params.keyText, &out_keyText);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setKeyframeKey"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("keyText"), out_keyText);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setMediaTextParams : public crdtp::DeserializableProtocolObject<setMediaTextParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String text;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setMediaTextParams)
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", text),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setMediaText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setMediaTextParams params;
    if (!setMediaTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSMedia> out_media;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setMediaText(params.styleSheetId, std::move(params.range), params.text, &out_media);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setMediaText"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("media"), out_media);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setContainerQueryTextParams : public crdtp::DeserializableProtocolObject<setContainerQueryTextParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String text;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setContainerQueryTextParams)
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", text),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setContainerQueryText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setContainerQueryTextParams params;
    if (!setContainerQueryTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSContainerQuery> out_containerQuery;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setContainerQueryText(params.styleSheetId, std::move(params.range), params.text, &out_containerQuery);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setContainerQueryText"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("containerQuery"), out_containerQuery);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setSupportsTextParams : public crdtp::DeserializableProtocolObject<setSupportsTextParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String text;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setSupportsTextParams)
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", text),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSupportsText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSupportsTextParams params;
    if (!setSupportsTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSSupports> out_supports;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSupportsText(params.styleSheetId, std::move(params.range), params.text, &out_supports);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setSupportsText"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("supports"), out_supports);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setScopeTextParams : public crdtp::DeserializableProtocolObject<setScopeTextParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String text;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setScopeTextParams)
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", text),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setScopeText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setScopeTextParams params;
    if (!setScopeTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::CSSScope> out_scope;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setScopeText(params.styleSheetId, std::move(params.range), params.text, &out_scope);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setScopeText"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("scope"), out_scope);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setRuleSelectorParams : public crdtp::DeserializableProtocolObject<setRuleSelectorParams> {
    String styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> range;
    String selector;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setRuleSelectorParams)
    CRDTP_DESERIALIZE_FIELD("range", range),
    CRDTP_DESERIALIZE_FIELD("selector", selector),
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setRuleSelector(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setRuleSelectorParams params;
    if (!setRuleSelectorParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::CSS::SelectorList> out_selectorList;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setRuleSelector(params.styleSheetId, std::move(params.range), params.selector, &out_selectorList);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setRuleSelector"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("selectorList"), out_selectorList);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setStyleSheetTextParams : public crdtp::DeserializableProtocolObject<setStyleSheetTextParams> {
    String styleSheetId;
    String text;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setStyleSheetTextParams)
    CRDTP_DESERIALIZE_FIELD("styleSheetId", styleSheetId),
    CRDTP_DESERIALIZE_FIELD("text", text),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setStyleSheetText(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setStyleSheetTextParams params;
    if (!setStyleSheetTextParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::optional<String> out_sourceMapURL;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setStyleSheetText(params.styleSheetId, params.text, &out_sourceMapURL);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setStyleSheetText"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("sourceMapURL"), out_sourceMapURL);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setStyleTextsParams : public crdtp::DeserializableProtocolObject<setStyleTextsParams> {
    std::unique_ptr<protocol::Array<protocol::CSS::StyleDeclarationEdit>> edits;
    std::optional<int> nodeForPropertySyntaxValidation;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setStyleTextsParams)
    CRDTP_DESERIALIZE_FIELD("edits", edits),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeForPropertySyntaxValidation", nodeForPropertySyntaxValidation),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setStyleTexts(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setStyleTextsParams params;
    if (!setStyleTextsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::CSSStyle>> out_styles;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setStyleTexts(std::move(params.edits), std::move(params.nodeForPropertySyntaxValidation), &out_styles);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setStyleTexts"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("styles"), out_styles);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::startRuleUsageTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->startRuleUsageTracking();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.startRuleUsageTracking"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopRuleUsageTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::RuleUsage>> out_ruleUsage;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stopRuleUsageTracking(&out_ruleUsage);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.stopRuleUsageTracking"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("ruleUsage"), out_ruleUsage);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::takeCoverageDelta(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::CSS::RuleUsage>> out_coverage;
    double out_timestamp;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->takeCoverageDelta(&out_coverage, &out_timestamp);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.takeCoverageDelta"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("coverage"), out_coverage);
          serializer.AddField(crdtp::MakeSpan("timestamp"), out_timestamp);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setLocalFontsEnabledParams : public crdtp::DeserializableProtocolObject<setLocalFontsEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setLocalFontsEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setLocalFontsEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setLocalFontsEnabledParams params;
    if (!setLocalFontsEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setLocalFontsEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("CSS.setLocalFontsEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("CSS"), SortedRedirects(), std::move(dispatcher));
}

} // CSS
} // namespace blink
} // namespace protocol
