// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/audits.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Audits {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Audits";
const char Metainfo::commandPrefix[] = "Audits.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(AffectedCookie)
    CRDTP_DESERIALIZE_FIELD("domain", m_domain),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("path", m_path),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AffectedCookie)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("path", m_path);
    CRDTP_SERIALIZE_FIELD("domain", m_domain);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AffectedRequest)
    CRDTP_DESERIALIZE_FIELD_OPT("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AffectedRequest)
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AffectedFrame)
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AffectedFrame)
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
CRDTP_END_SERIALIZER();


namespace CookieExclusionReasonEnum {
const char ExcludeSameSiteUnspecifiedTreatedAsLax[] = "ExcludeSameSiteUnspecifiedTreatedAsLax";
const char ExcludeSameSiteNoneInsecure[] = "ExcludeSameSiteNoneInsecure";
const char ExcludeSameSiteLax[] = "ExcludeSameSiteLax";
const char ExcludeSameSiteStrict[] = "ExcludeSameSiteStrict";
const char ExcludeInvalidSameParty[] = "ExcludeInvalidSameParty";
const char ExcludeSamePartyCrossPartyContext[] = "ExcludeSamePartyCrossPartyContext";
const char ExcludeDomainNonASCII[] = "ExcludeDomainNonASCII";
const char ExcludeThirdPartyCookieBlockedInFirstPartySet[] = "ExcludeThirdPartyCookieBlockedInFirstPartySet";
const char ExcludeThirdPartyPhaseout[] = "ExcludeThirdPartyPhaseout";
const char ExcludePortMismatch[] = "ExcludePortMismatch";
const char ExcludeSchemeMismatch[] = "ExcludeSchemeMismatch";
} // namespace CookieExclusionReasonEnum


namespace CookieWarningReasonEnum {
const char WarnSameSiteUnspecifiedCrossSiteContext[] = "WarnSameSiteUnspecifiedCrossSiteContext";
const char WarnSameSiteNoneInsecure[] = "WarnSameSiteNoneInsecure";
const char WarnSameSiteUnspecifiedLaxAllowUnsafe[] = "WarnSameSiteUnspecifiedLaxAllowUnsafe";
const char WarnSameSiteStrictLaxDowngradeStrict[] = "WarnSameSiteStrictLaxDowngradeStrict";
const char WarnSameSiteStrictCrossDowngradeStrict[] = "WarnSameSiteStrictCrossDowngradeStrict";
const char WarnSameSiteStrictCrossDowngradeLax[] = "WarnSameSiteStrictCrossDowngradeLax";
const char WarnSameSiteLaxCrossDowngradeStrict[] = "WarnSameSiteLaxCrossDowngradeStrict";
const char WarnSameSiteLaxCrossDowngradeLax[] = "WarnSameSiteLaxCrossDowngradeLax";
const char WarnAttributeValueExceedsMaxSize[] = "WarnAttributeValueExceedsMaxSize";
const char WarnDomainNonASCII[] = "WarnDomainNonASCII";
const char WarnThirdPartyPhaseout[] = "WarnThirdPartyPhaseout";
const char WarnCrossSiteRedirectDowngradeChangesInclusion[] = "WarnCrossSiteRedirectDowngradeChangesInclusion";
const char WarnDeprecationTrialMetadata[] = "WarnDeprecationTrialMetadata";
const char WarnThirdPartyCookieHeuristic[] = "WarnThirdPartyCookieHeuristic";
} // namespace CookieWarningReasonEnum


namespace CookieOperationEnum {
const char SetCookie[] = "SetCookie";
const char ReadCookie[] = "ReadCookie";
} // namespace CookieOperationEnum


namespace InsightTypeEnum {
const char GitHubResource[] = "GitHubResource";
const char GracePeriod[] = "GracePeriod";
const char Heuristics[] = "Heuristics";
} // namespace InsightTypeEnum


CRDTP_BEGIN_DESERIALIZER(CookieIssueInsight)
    CRDTP_DESERIALIZE_FIELD_OPT("tableEntryUrl", m_tableEntryUrl),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CookieIssueInsight)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("tableEntryUrl", m_tableEntryUrl);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CookieIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("cookie", m_cookie),
    CRDTP_DESERIALIZE_FIELD("cookieExclusionReasons", m_cookieExclusionReasons),
    CRDTP_DESERIALIZE_FIELD_OPT("cookieUrl", m_cookieUrl),
    CRDTP_DESERIALIZE_FIELD("cookieWarningReasons", m_cookieWarningReasons),
    CRDTP_DESERIALIZE_FIELD_OPT("insight", m_insight),
    CRDTP_DESERIALIZE_FIELD("operation", m_operation),
    CRDTP_DESERIALIZE_FIELD_OPT("rawCookieLine", m_rawCookieLine),
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD_OPT("siteForCookies", m_siteForCookies),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CookieIssueDetails)
    CRDTP_SERIALIZE_FIELD("cookie", m_cookie);
    CRDTP_SERIALIZE_FIELD("rawCookieLine", m_rawCookieLine);
    CRDTP_SERIALIZE_FIELD("cookieWarningReasons", m_cookieWarningReasons);
    CRDTP_SERIALIZE_FIELD("cookieExclusionReasons", m_cookieExclusionReasons);
    CRDTP_SERIALIZE_FIELD("operation", m_operation);
    CRDTP_SERIALIZE_FIELD("siteForCookies", m_siteForCookies);
    CRDTP_SERIALIZE_FIELD("cookieUrl", m_cookieUrl);
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("insight", m_insight);
CRDTP_END_SERIALIZER();


namespace MixedContentResolutionStatusEnum {
const char MixedContentBlocked[] = "MixedContentBlocked";
const char MixedContentAutomaticallyUpgraded[] = "MixedContentAutomaticallyUpgraded";
const char MixedContentWarning[] = "MixedContentWarning";
} // namespace MixedContentResolutionStatusEnum


namespace MixedContentResourceTypeEnum {
const char AttributionSrc[] = "AttributionSrc";
const char Audio[] = "Audio";
const char Beacon[] = "Beacon";
const char CSPReport[] = "CSPReport";
const char Download[] = "Download";
const char EventSource[] = "EventSource";
const char Favicon[] = "Favicon";
const char Font[] = "Font";
const char Form[] = "Form";
const char Frame[] = "Frame";
const char Image[] = "Image";
const char Import[] = "Import";
const char JSON[] = "JSON";
const char Manifest[] = "Manifest";
const char Ping[] = "Ping";
const char PluginData[] = "PluginData";
const char PluginResource[] = "PluginResource";
const char Prefetch[] = "Prefetch";
const char Resource[] = "Resource";
const char Script[] = "Script";
const char ServiceWorker[] = "ServiceWorker";
const char SharedWorker[] = "SharedWorker";
const char SpeculationRules[] = "SpeculationRules";
const char Stylesheet[] = "Stylesheet";
const char Track[] = "Track";
const char Video[] = "Video";
const char Worker[] = "Worker";
const char XMLHttpRequest[] = "XMLHttpRequest";
const char XSLT[] = "XSLT";
} // namespace MixedContentResourceTypeEnum


CRDTP_BEGIN_DESERIALIZER(MixedContentIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("frame", m_frame),
    CRDTP_DESERIALIZE_FIELD("insecureURL", m_insecureURL),
    CRDTP_DESERIALIZE_FIELD("mainResourceURL", m_mainResourceURL),
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD("resolutionStatus", m_resolutionStatus),
    CRDTP_DESERIALIZE_FIELD_OPT("resourceType", m_resourceType),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(MixedContentIssueDetails)
    CRDTP_SERIALIZE_FIELD("resourceType", m_resourceType);
    CRDTP_SERIALIZE_FIELD("resolutionStatus", m_resolutionStatus);
    CRDTP_SERIALIZE_FIELD("insecureURL", m_insecureURL);
    CRDTP_SERIALIZE_FIELD("mainResourceURL", m_mainResourceURL);
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("frame", m_frame);
CRDTP_END_SERIALIZER();


namespace BlockedByResponseReasonEnum {
const char CoepFrameResourceNeedsCoepHeader[] = "CoepFrameResourceNeedsCoepHeader";
const char CoopSandboxedIFrameCannotNavigateToCoopPage[] = "CoopSandboxedIFrameCannotNavigateToCoopPage";
const char CorpNotSameOrigin[] = "CorpNotSameOrigin";
const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[] = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep";
const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[] = "CorpNotSameOriginAfterDefaultedToSameOriginByDip";
const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[] = "CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip";
const char CorpNotSameSite[] = "CorpNotSameSite";
const char SRIMessageSignatureMismatch[] = "SRIMessageSignatureMismatch";
} // namespace BlockedByResponseReasonEnum


CRDTP_BEGIN_DESERIALIZER(BlockedByResponseIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("blockedFrame", m_blockedFrame),
    CRDTP_DESERIALIZE_FIELD_OPT("parentFrame", m_parentFrame),
    CRDTP_DESERIALIZE_FIELD("reason", m_reason),
    CRDTP_DESERIALIZE_FIELD("request", m_request),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BlockedByResponseIssueDetails)
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("parentFrame", m_parentFrame);
    CRDTP_SERIALIZE_FIELD("blockedFrame", m_blockedFrame);
    CRDTP_SERIALIZE_FIELD("reason", m_reason);
CRDTP_END_SERIALIZER();


namespace HeavyAdResolutionStatusEnum {
const char HeavyAdBlocked[] = "HeavyAdBlocked";
const char HeavyAdWarning[] = "HeavyAdWarning";
} // namespace HeavyAdResolutionStatusEnum


namespace HeavyAdReasonEnum {
const char NetworkTotalLimit[] = "NetworkTotalLimit";
const char CpuTotalLimit[] = "CpuTotalLimit";
const char CpuPeakLimit[] = "CpuPeakLimit";
} // namespace HeavyAdReasonEnum


CRDTP_BEGIN_DESERIALIZER(HeavyAdIssueDetails)
    CRDTP_DESERIALIZE_FIELD("frame", m_frame),
    CRDTP_DESERIALIZE_FIELD("reason", m_reason),
    CRDTP_DESERIALIZE_FIELD("resolution", m_resolution),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(HeavyAdIssueDetails)
    CRDTP_SERIALIZE_FIELD("resolution", m_resolution);
    CRDTP_SERIALIZE_FIELD("reason", m_reason);
    CRDTP_SERIALIZE_FIELD("frame", m_frame);
CRDTP_END_SERIALIZER();


namespace ContentSecurityPolicyViolationTypeEnum {
const char KInlineViolation[] = "kInlineViolation";
const char KEvalViolation[] = "kEvalViolation";
const char KURLViolation[] = "kURLViolation";
const char KSRIViolation[] = "kSRIViolation";
const char KTrustedTypesSinkViolation[] = "kTrustedTypesSinkViolation";
const char KTrustedTypesPolicyViolation[] = "kTrustedTypesPolicyViolation";
const char KWasmEvalViolation[] = "kWasmEvalViolation";
} // namespace ContentSecurityPolicyViolationTypeEnum


CRDTP_BEGIN_DESERIALIZER(SourceCodeLocation)
    CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("scriptId", m_scriptId),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SourceCodeLocation)
    CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ContentSecurityPolicyIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("blockedURL", m_blockedURL),
    CRDTP_DESERIALIZE_FIELD("contentSecurityPolicyViolationType", m_contentSecurityPolicyViolationType),
    CRDTP_DESERIALIZE_FIELD_OPT("frameAncestor", m_frameAncestor),
    CRDTP_DESERIALIZE_FIELD("isReportOnly", m_isReportOnly),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceCodeLocation", m_sourceCodeLocation),
    CRDTP_DESERIALIZE_FIELD("violatedDirective", m_violatedDirective),
    CRDTP_DESERIALIZE_FIELD_OPT("violatingNodeId", m_violatingNodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ContentSecurityPolicyIssueDetails)
    CRDTP_SERIALIZE_FIELD("blockedURL", m_blockedURL);
    CRDTP_SERIALIZE_FIELD("violatedDirective", m_violatedDirective);
    CRDTP_SERIALIZE_FIELD("isReportOnly", m_isReportOnly);
    CRDTP_SERIALIZE_FIELD("contentSecurityPolicyViolationType", m_contentSecurityPolicyViolationType);
    CRDTP_SERIALIZE_FIELD("frameAncestor", m_frameAncestor);
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("violatingNodeId", m_violatingNodeId);
CRDTP_END_SERIALIZER();


namespace SharedArrayBufferIssueTypeEnum {
const char TransferIssue[] = "TransferIssue";
const char CreationIssue[] = "CreationIssue";
} // namespace SharedArrayBufferIssueTypeEnum


CRDTP_BEGIN_DESERIALIZER(SharedArrayBufferIssueDetails)
    CRDTP_DESERIALIZE_FIELD("isWarning", m_isWarning),
    CRDTP_DESERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedArrayBufferIssueDetails)
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("isWarning", m_isWarning);
    CRDTP_SERIALIZE_FIELD("type", m_type);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(LowTextContrastIssueDetails)
    CRDTP_DESERIALIZE_FIELD("contrastRatio", m_contrastRatio),
    CRDTP_DESERIALIZE_FIELD("fontSize", m_fontSize),
    CRDTP_DESERIALIZE_FIELD("fontWeight", m_fontWeight),
    CRDTP_DESERIALIZE_FIELD("thresholdAA", m_thresholdAA),
    CRDTP_DESERIALIZE_FIELD("thresholdAAA", m_thresholdAAA),
    CRDTP_DESERIALIZE_FIELD("violatingNodeId", m_violatingNodeId),
    CRDTP_DESERIALIZE_FIELD("violatingNodeSelector", m_violatingNodeSelector),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LowTextContrastIssueDetails)
    CRDTP_SERIALIZE_FIELD("violatingNodeId", m_violatingNodeId);
    CRDTP_SERIALIZE_FIELD("violatingNodeSelector", m_violatingNodeSelector);
    CRDTP_SERIALIZE_FIELD("contrastRatio", m_contrastRatio);
    CRDTP_SERIALIZE_FIELD("thresholdAA", m_thresholdAA);
    CRDTP_SERIALIZE_FIELD("thresholdAAA", m_thresholdAAA);
    CRDTP_SERIALIZE_FIELD("fontSize", m_fontSize);
    CRDTP_SERIALIZE_FIELD("fontWeight", m_fontWeight);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CorsIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("clientSecurityState", m_clientSecurityState),
    CRDTP_DESERIALIZE_FIELD("corsErrorStatus", m_corsErrorStatus),
    CRDTP_DESERIALIZE_FIELD_OPT("initiatorOrigin", m_initiatorOrigin),
    CRDTP_DESERIALIZE_FIELD("isWarning", m_isWarning),
    CRDTP_DESERIALIZE_FIELD_OPT("location", m_location),
    CRDTP_DESERIALIZE_FIELD("request", m_request),
    CRDTP_DESERIALIZE_FIELD_OPT("resourceIPAddressSpace", m_resourceIPAddressSpace),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CorsIssueDetails)
    CRDTP_SERIALIZE_FIELD("corsErrorStatus", m_corsErrorStatus);
    CRDTP_SERIALIZE_FIELD("isWarning", m_isWarning);
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("location", m_location);
    CRDTP_SERIALIZE_FIELD("initiatorOrigin", m_initiatorOrigin);
    CRDTP_SERIALIZE_FIELD("resourceIPAddressSpace", m_resourceIPAddressSpace);
    CRDTP_SERIALIZE_FIELD("clientSecurityState", m_clientSecurityState);
CRDTP_END_SERIALIZER();


namespace AttributionReportingIssueTypeEnum {
const char PermissionPolicyDisabled[] = "PermissionPolicyDisabled";
const char UntrustworthyReportingOrigin[] = "UntrustworthyReportingOrigin";
const char InsecureContext[] = "InsecureContext";
const char InvalidHeader[] = "InvalidHeader";
const char InvalidRegisterTriggerHeader[] = "InvalidRegisterTriggerHeader";
const char SourceAndTriggerHeaders[] = "SourceAndTriggerHeaders";
const char SourceIgnored[] = "SourceIgnored";
const char TriggerIgnored[] = "TriggerIgnored";
const char OsSourceIgnored[] = "OsSourceIgnored";
const char OsTriggerIgnored[] = "OsTriggerIgnored";
const char InvalidRegisterOsSourceHeader[] = "InvalidRegisterOsSourceHeader";
const char InvalidRegisterOsTriggerHeader[] = "InvalidRegisterOsTriggerHeader";
const char WebAndOsHeaders[] = "WebAndOsHeaders";
const char NoWebOrOsSupport[] = "NoWebOrOsSupport";
const char NavigationRegistrationWithoutTransientUserActivation[] = "NavigationRegistrationWithoutTransientUserActivation";
const char InvalidInfoHeader[] = "InvalidInfoHeader";
const char NoRegisterSourceHeader[] = "NoRegisterSourceHeader";
const char NoRegisterTriggerHeader[] = "NoRegisterTriggerHeader";
const char NoRegisterOsSourceHeader[] = "NoRegisterOsSourceHeader";
const char NoRegisterOsTriggerHeader[] = "NoRegisterOsTriggerHeader";
const char NavigationRegistrationUniqueScopeAlreadySet[] = "NavigationRegistrationUniqueScopeAlreadySet";
} // namespace AttributionReportingIssueTypeEnum


namespace SharedDictionaryErrorEnum {
const char UseErrorCrossOriginNoCorsRequest[] = "UseErrorCrossOriginNoCorsRequest";
const char UseErrorDictionaryLoadFailure[] = "UseErrorDictionaryLoadFailure";
const char UseErrorMatchingDictionaryNotUsed[] = "UseErrorMatchingDictionaryNotUsed";
const char UseErrorUnexpectedContentDictionaryHeader[] = "UseErrorUnexpectedContentDictionaryHeader";
const char WriteErrorCossOriginNoCorsRequest[] = "WriteErrorCossOriginNoCorsRequest";
const char WriteErrorDisallowedBySettings[] = "WriteErrorDisallowedBySettings";
const char WriteErrorExpiredResponse[] = "WriteErrorExpiredResponse";
const char WriteErrorFeatureDisabled[] = "WriteErrorFeatureDisabled";
const char WriteErrorInsufficientResources[] = "WriteErrorInsufficientResources";
const char WriteErrorInvalidMatchField[] = "WriteErrorInvalidMatchField";
const char WriteErrorInvalidStructuredHeader[] = "WriteErrorInvalidStructuredHeader";
const char WriteErrorInvalidTTLField[] = "WriteErrorInvalidTTLField";
const char WriteErrorNavigationRequest[] = "WriteErrorNavigationRequest";
const char WriteErrorNoMatchField[] = "WriteErrorNoMatchField";
const char WriteErrorNonIntegerTTLField[] = "WriteErrorNonIntegerTTLField";
const char WriteErrorNonListMatchDestField[] = "WriteErrorNonListMatchDestField";
const char WriteErrorNonSecureContext[] = "WriteErrorNonSecureContext";
const char WriteErrorNonStringIdField[] = "WriteErrorNonStringIdField";
const char WriteErrorNonStringInMatchDestList[] = "WriteErrorNonStringInMatchDestList";
const char WriteErrorNonStringMatchField[] = "WriteErrorNonStringMatchField";
const char WriteErrorNonTokenTypeField[] = "WriteErrorNonTokenTypeField";
const char WriteErrorRequestAborted[] = "WriteErrorRequestAborted";
const char WriteErrorShuttingDown[] = "WriteErrorShuttingDown";
const char WriteErrorTooLongIdField[] = "WriteErrorTooLongIdField";
const char WriteErrorUnsupportedType[] = "WriteErrorUnsupportedType";
} // namespace SharedDictionaryErrorEnum


namespace SRIMessageSignatureErrorEnum {
const char MissingSignatureHeader[] = "MissingSignatureHeader";
const char MissingSignatureInputHeader[] = "MissingSignatureInputHeader";
const char InvalidSignatureHeader[] = "InvalidSignatureHeader";
const char InvalidSignatureInputHeader[] = "InvalidSignatureInputHeader";
const char SignatureHeaderValueIsNotByteSequence[] = "SignatureHeaderValueIsNotByteSequence";
const char SignatureHeaderValueIsParameterized[] = "SignatureHeaderValueIsParameterized";
const char SignatureHeaderValueIsIncorrectLength[] = "SignatureHeaderValueIsIncorrectLength";
const char SignatureInputHeaderMissingLabel[] = "SignatureInputHeaderMissingLabel";
const char SignatureInputHeaderValueNotInnerList[] = "SignatureInputHeaderValueNotInnerList";
const char SignatureInputHeaderValueMissingComponents[] = "SignatureInputHeaderValueMissingComponents";
const char SignatureInputHeaderInvalidComponentType[] = "SignatureInputHeaderInvalidComponentType";
const char SignatureInputHeaderInvalidComponentName[] = "SignatureInputHeaderInvalidComponentName";
const char SignatureInputHeaderInvalidHeaderComponentParameter[] = "SignatureInputHeaderInvalidHeaderComponentParameter";
const char SignatureInputHeaderInvalidDerivedComponentParameter[] = "SignatureInputHeaderInvalidDerivedComponentParameter";
const char SignatureInputHeaderKeyIdLength[] = "SignatureInputHeaderKeyIdLength";
const char SignatureInputHeaderInvalidParameter[] = "SignatureInputHeaderInvalidParameter";
const char SignatureInputHeaderMissingRequiredParameters[] = "SignatureInputHeaderMissingRequiredParameters";
const char ValidationFailedSignatureExpired[] = "ValidationFailedSignatureExpired";
const char ValidationFailedInvalidLength[] = "ValidationFailedInvalidLength";
const char ValidationFailedSignatureMismatch[] = "ValidationFailedSignatureMismatch";
const char ValidationFailedIntegrityMismatch[] = "ValidationFailedIntegrityMismatch";
} // namespace SRIMessageSignatureErrorEnum


namespace UnencodedDigestErrorEnum {
const char MalformedDictionary[] = "MalformedDictionary";
const char UnknownAlgorithm[] = "UnknownAlgorithm";
const char IncorrectDigestType[] = "IncorrectDigestType";
const char IncorrectDigestLength[] = "IncorrectDigestLength";
} // namespace UnencodedDigestErrorEnum


CRDTP_BEGIN_DESERIALIZER(AttributionReportingIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("invalidParameter", m_invalidParameter),
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD_OPT("violatingNodeId", m_violatingNodeId),
    CRDTP_DESERIALIZE_FIELD("violationType", m_violationType),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingIssueDetails)
    CRDTP_SERIALIZE_FIELD("violationType", m_violationType);
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("violatingNodeId", m_violatingNodeId);
    CRDTP_SERIALIZE_FIELD("invalidParameter", m_invalidParameter);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(QuirksModeIssueDetails)
    CRDTP_DESERIALIZE_FIELD("documentNodeId", m_documentNodeId),
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD("isLimitedQuirksMode", m_isLimitedQuirksMode),
    CRDTP_DESERIALIZE_FIELD("loaderId", m_loaderId),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(QuirksModeIssueDetails)
    CRDTP_SERIALIZE_FIELD("isLimitedQuirksMode", m_isLimitedQuirksMode);
    CRDTP_SERIALIZE_FIELD("documentNodeId", m_documentNodeId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("loaderId", m_loaderId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(NavigatorUserAgentIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("location", m_location),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(NavigatorUserAgentIssueDetails)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("location", m_location);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedDictionaryIssueDetails)
    CRDTP_DESERIALIZE_FIELD("request", m_request),
    CRDTP_DESERIALIZE_FIELD("sharedDictionaryError", m_sharedDictionaryError),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedDictionaryIssueDetails)
    CRDTP_SERIALIZE_FIELD("sharedDictionaryError", m_sharedDictionaryError);
    CRDTP_SERIALIZE_FIELD("request", m_request);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SRIMessageSignatureIssueDetails)
    CRDTP_DESERIALIZE_FIELD("error", m_error),
    CRDTP_DESERIALIZE_FIELD("integrityAssertions", m_integrityAssertions),
    CRDTP_DESERIALIZE_FIELD("request", m_request),
    CRDTP_DESERIALIZE_FIELD("signatureBase", m_signatureBase),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SRIMessageSignatureIssueDetails)
    CRDTP_SERIALIZE_FIELD("error", m_error);
    CRDTP_SERIALIZE_FIELD("signatureBase", m_signatureBase);
    CRDTP_SERIALIZE_FIELD("integrityAssertions", m_integrityAssertions);
    CRDTP_SERIALIZE_FIELD("request", m_request);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(UnencodedDigestIssueDetails)
    CRDTP_DESERIALIZE_FIELD("error", m_error),
    CRDTP_DESERIALIZE_FIELD("request", m_request),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UnencodedDigestIssueDetails)
    CRDTP_SERIALIZE_FIELD("error", m_error);
    CRDTP_SERIALIZE_FIELD("request", m_request);
CRDTP_END_SERIALIZER();


namespace GenericIssueErrorTypeEnum {
const char FormLabelForNameError[] = "FormLabelForNameError";
const char FormDuplicateIdForInputError[] = "FormDuplicateIdForInputError";
const char FormInputWithNoLabelError[] = "FormInputWithNoLabelError";
const char FormAutocompleteAttributeEmptyError[] = "FormAutocompleteAttributeEmptyError";
const char FormEmptyIdAndNameAttributesForInputError[] = "FormEmptyIdAndNameAttributesForInputError";
const char FormAriaLabelledByToNonExistingIdError[] = "FormAriaLabelledByToNonExistingIdError";
const char FormInputAssignedAutocompleteValueToIdOrNameAttributeError[] = "FormInputAssignedAutocompleteValueToIdOrNameAttributeError";
const char FormLabelHasNeitherForNorNestedInputError[] = "FormLabelHasNeitherForNorNestedInputError";
const char FormLabelForMatchesNonExistingIdError[] = "FormLabelForMatchesNonExistingIdError";
const char FormInputHasWrongButWellIntendedAutocompleteValueError[] = "FormInputHasWrongButWellIntendedAutocompleteValueError";
const char ResponseWasBlockedByORB[] = "ResponseWasBlockedByORB";
const char NavigationEntryMarkedSkippable[] = "NavigationEntryMarkedSkippable";
} // namespace GenericIssueErrorTypeEnum


CRDTP_BEGIN_DESERIALIZER(GenericIssueDetails)
    CRDTP_DESERIALIZE_FIELD("errorType", m_errorType),
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD_OPT("violatingNodeAttribute", m_violatingNodeAttribute),
    CRDTP_DESERIALIZE_FIELD_OPT("violatingNodeId", m_violatingNodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(GenericIssueDetails)
    CRDTP_SERIALIZE_FIELD("errorType", m_errorType);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("violatingNodeId", m_violatingNodeId);
    CRDTP_SERIALIZE_FIELD("violatingNodeAttribute", m_violatingNodeAttribute);
    CRDTP_SERIALIZE_FIELD("request", m_request);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(DeprecationIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("affectedFrame", m_affectedFrame),
    CRDTP_DESERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DeprecationIssueDetails)
    CRDTP_SERIALIZE_FIELD("affectedFrame", m_affectedFrame);
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("type", m_type);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BounceTrackingIssueDetails)
    CRDTP_DESERIALIZE_FIELD("trackingSites", m_trackingSites),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BounceTrackingIssueDetails)
    CRDTP_SERIALIZE_FIELD("trackingSites", m_trackingSites);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CookieDeprecationMetadataIssueDetails)
    CRDTP_DESERIALIZE_FIELD("allowedSites", m_allowedSites),
    CRDTP_DESERIALIZE_FIELD("isOptOutTopLevel", m_isOptOutTopLevel),
    CRDTP_DESERIALIZE_FIELD("operation", m_operation),
    CRDTP_DESERIALIZE_FIELD("optOutPercentage", m_optOutPercentage),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CookieDeprecationMetadataIssueDetails)
    CRDTP_SERIALIZE_FIELD("allowedSites", m_allowedSites);
    CRDTP_SERIALIZE_FIELD("optOutPercentage", m_optOutPercentage);
    CRDTP_SERIALIZE_FIELD("isOptOutTopLevel", m_isOptOutTopLevel);
    CRDTP_SERIALIZE_FIELD("operation", m_operation);
CRDTP_END_SERIALIZER();


namespace ClientHintIssueReasonEnum {
const char MetaTagAllowListInvalidOrigin[] = "MetaTagAllowListInvalidOrigin";
const char MetaTagModifiedHTML[] = "MetaTagModifiedHTML";
} // namespace ClientHintIssueReasonEnum


CRDTP_BEGIN_DESERIALIZER(FederatedAuthRequestIssueDetails)
    CRDTP_DESERIALIZE_FIELD("federatedAuthRequestIssueReason", m_federatedAuthRequestIssueReason),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FederatedAuthRequestIssueDetails)
    CRDTP_SERIALIZE_FIELD("federatedAuthRequestIssueReason", m_federatedAuthRequestIssueReason);
CRDTP_END_SERIALIZER();


namespace FederatedAuthRequestIssueReasonEnum {
const char ShouldEmbargo[] = "ShouldEmbargo";
const char TooManyRequests[] = "TooManyRequests";
const char WellKnownHttpNotFound[] = "WellKnownHttpNotFound";
const char WellKnownNoResponse[] = "WellKnownNoResponse";
const char WellKnownInvalidResponse[] = "WellKnownInvalidResponse";
const char WellKnownListEmpty[] = "WellKnownListEmpty";
const char WellKnownInvalidContentType[] = "WellKnownInvalidContentType";
const char ConfigNotInWellKnown[] = "ConfigNotInWellKnown";
const char WellKnownTooBig[] = "WellKnownTooBig";
const char ConfigHttpNotFound[] = "ConfigHttpNotFound";
const char ConfigNoResponse[] = "ConfigNoResponse";
const char ConfigInvalidResponse[] = "ConfigInvalidResponse";
const char ConfigInvalidContentType[] = "ConfigInvalidContentType";
const char ClientMetadataHttpNotFound[] = "ClientMetadataHttpNotFound";
const char ClientMetadataNoResponse[] = "ClientMetadataNoResponse";
const char ClientMetadataInvalidResponse[] = "ClientMetadataInvalidResponse";
const char ClientMetadataInvalidContentType[] = "ClientMetadataInvalidContentType";
const char IdpNotPotentiallyTrustworthy[] = "IdpNotPotentiallyTrustworthy";
const char DisabledInSettings[] = "DisabledInSettings";
const char DisabledInFlags[] = "DisabledInFlags";
const char ErrorFetchingSignin[] = "ErrorFetchingSignin";
const char InvalidSigninResponse[] = "InvalidSigninResponse";
const char AccountsHttpNotFound[] = "AccountsHttpNotFound";
const char AccountsNoResponse[] = "AccountsNoResponse";
const char AccountsInvalidResponse[] = "AccountsInvalidResponse";
const char AccountsListEmpty[] = "AccountsListEmpty";
const char AccountsInvalidContentType[] = "AccountsInvalidContentType";
const char IdTokenHttpNotFound[] = "IdTokenHttpNotFound";
const char IdTokenNoResponse[] = "IdTokenNoResponse";
const char IdTokenInvalidResponse[] = "IdTokenInvalidResponse";
const char IdTokenIdpErrorResponse[] = "IdTokenIdpErrorResponse";
const char IdTokenCrossSiteIdpErrorResponse[] = "IdTokenCrossSiteIdpErrorResponse";
const char IdTokenInvalidRequest[] = "IdTokenInvalidRequest";
const char IdTokenInvalidContentType[] = "IdTokenInvalidContentType";
const char ErrorIdToken[] = "ErrorIdToken";
const char Canceled[] = "Canceled";
const char RpPageNotVisible[] = "RpPageNotVisible";
const char SilentMediationFailure[] = "SilentMediationFailure";
const char ThirdPartyCookiesBlocked[] = "ThirdPartyCookiesBlocked";
const char NotSignedInWithIdp[] = "NotSignedInWithIdp";
const char MissingTransientUserActivation[] = "MissingTransientUserActivation";
const char ReplacedByActiveMode[] = "ReplacedByActiveMode";
const char InvalidFieldsSpecified[] = "InvalidFieldsSpecified";
const char RelyingPartyOriginIsOpaque[] = "RelyingPartyOriginIsOpaque";
const char TypeNotMatching[] = "TypeNotMatching";
const char UiDismissedNoEmbargo[] = "UiDismissedNoEmbargo";
const char CorsError[] = "CorsError";
const char SuppressedBySegmentationPlatform[] = "SuppressedBySegmentationPlatform";
} // namespace FederatedAuthRequestIssueReasonEnum


CRDTP_BEGIN_DESERIALIZER(FederatedAuthUserInfoRequestIssueDetails)
    CRDTP_DESERIALIZE_FIELD("federatedAuthUserInfoRequestIssueReason", m_federatedAuthUserInfoRequestIssueReason),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FederatedAuthUserInfoRequestIssueDetails)
    CRDTP_SERIALIZE_FIELD("federatedAuthUserInfoRequestIssueReason", m_federatedAuthUserInfoRequestIssueReason);
CRDTP_END_SERIALIZER();


namespace FederatedAuthUserInfoRequestIssueReasonEnum {
const char NotSameOrigin[] = "NotSameOrigin";
const char NotIframe[] = "NotIframe";
const char NotPotentiallyTrustworthy[] = "NotPotentiallyTrustworthy";
const char NoApiPermission[] = "NoApiPermission";
const char NotSignedInWithIdp[] = "NotSignedInWithIdp";
const char NoAccountSharingPermission[] = "NoAccountSharingPermission";
const char InvalidConfigOrWellKnown[] = "InvalidConfigOrWellKnown";
const char InvalidAccountsResponse[] = "InvalidAccountsResponse";
const char NoReturningUserFromFetchedAccounts[] = "NoReturningUserFromFetchedAccounts";
} // namespace FederatedAuthUserInfoRequestIssueReasonEnum


CRDTP_BEGIN_DESERIALIZER(ClientHintIssueDetails)
    CRDTP_DESERIALIZE_FIELD("clientHintIssueReason", m_clientHintIssueReason),
    CRDTP_DESERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ClientHintIssueDetails)
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("clientHintIssueReason", m_clientHintIssueReason);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FailedRequestInfo)
    CRDTP_DESERIALIZE_FIELD("failureMessage", m_failureMessage),
    CRDTP_DESERIALIZE_FIELD_OPT("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FailedRequestInfo)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("failureMessage", m_failureMessage);
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
CRDTP_END_SERIALIZER();


namespace PartitioningBlobURLInfoEnum {
const char BlockedCrossPartitionFetching[] = "BlockedCrossPartitionFetching";
const char EnforceNoopenerForNavigation[] = "EnforceNoopenerForNavigation";
} // namespace PartitioningBlobURLInfoEnum


CRDTP_BEGIN_DESERIALIZER(PartitioningBlobURLIssueDetails)
    CRDTP_DESERIALIZE_FIELD("partitioningBlobURLInfo", m_partitioningBlobURLInfo),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PartitioningBlobURLIssueDetails)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("partitioningBlobURLInfo", m_partitioningBlobURLInfo);
CRDTP_END_SERIALIZER();


namespace ElementAccessibilityIssueReasonEnum {
const char DisallowedSelectChild[] = "DisallowedSelectChild";
const char DisallowedOptGroupChild[] = "DisallowedOptGroupChild";
const char NonPhrasingContentOptionChild[] = "NonPhrasingContentOptionChild";
const char InteractiveContentOptionChild[] = "InteractiveContentOptionChild";
const char InteractiveContentLegendChild[] = "InteractiveContentLegendChild";
const char InteractiveContentSummaryDescendant[] = "InteractiveContentSummaryDescendant";
} // namespace ElementAccessibilityIssueReasonEnum


CRDTP_BEGIN_DESERIALIZER(ElementAccessibilityIssueDetails)
    CRDTP_DESERIALIZE_FIELD("elementAccessibilityIssueReason", m_elementAccessibilityIssueReason),
    CRDTP_DESERIALIZE_FIELD("hasDisallowedAttributes", m_hasDisallowedAttributes),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ElementAccessibilityIssueDetails)
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
    CRDTP_SERIALIZE_FIELD("elementAccessibilityIssueReason", m_elementAccessibilityIssueReason);
    CRDTP_SERIALIZE_FIELD("hasDisallowedAttributes", m_hasDisallowedAttributes);
CRDTP_END_SERIALIZER();


namespace StyleSheetLoadingIssueReasonEnum {
const char LateImportRule[] = "LateImportRule";
const char RequestFailed[] = "RequestFailed";
} // namespace StyleSheetLoadingIssueReasonEnum


CRDTP_BEGIN_DESERIALIZER(StylesheetLoadingIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("failedRequestInfo", m_failedRequestInfo),
    CRDTP_DESERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation),
    CRDTP_DESERIALIZE_FIELD("styleSheetLoadingIssueReason", m_styleSheetLoadingIssueReason),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StylesheetLoadingIssueDetails)
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("styleSheetLoadingIssueReason", m_styleSheetLoadingIssueReason);
    CRDTP_SERIALIZE_FIELD("failedRequestInfo", m_failedRequestInfo);
CRDTP_END_SERIALIZER();


namespace PropertyRuleIssueReasonEnum {
const char InvalidSyntax[] = "InvalidSyntax";
const char InvalidInitialValue[] = "InvalidInitialValue";
const char InvalidInherits[] = "InvalidInherits";
const char InvalidName[] = "InvalidName";
} // namespace PropertyRuleIssueReasonEnum


CRDTP_BEGIN_DESERIALIZER(PropertyRuleIssueDetails)
    CRDTP_DESERIALIZE_FIELD("propertyRuleIssueReason", m_propertyRuleIssueReason),
    CRDTP_DESERIALIZE_FIELD_OPT("propertyValue", m_propertyValue),
    CRDTP_DESERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PropertyRuleIssueDetails)
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("propertyRuleIssueReason", m_propertyRuleIssueReason);
    CRDTP_SERIALIZE_FIELD("propertyValue", m_propertyValue);
CRDTP_END_SERIALIZER();


namespace UserReidentificationIssueTypeEnum {
const char BlockedFrameNavigation[] = "BlockedFrameNavigation";
const char BlockedSubresource[] = "BlockedSubresource";
const char NoisedCanvasReadback[] = "NoisedCanvasReadback";
} // namespace UserReidentificationIssueTypeEnum


CRDTP_BEGIN_DESERIALIZER(UserReidentificationIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceCodeLocation", m_sourceCodeLocation),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UserReidentificationIssueDetails)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
CRDTP_END_SERIALIZER();


namespace PermissionElementIssueTypeEnum {
const char InvalidType[] = "InvalidType";
const char FencedFrameDisallowed[] = "FencedFrameDisallowed";
const char CspFrameAncestorsMissing[] = "CspFrameAncestorsMissing";
const char PermissionsPolicyBlocked[] = "PermissionsPolicyBlocked";
const char PaddingRightUnsupported[] = "PaddingRightUnsupported";
const char PaddingBottomUnsupported[] = "PaddingBottomUnsupported";
const char InsetBoxShadowUnsupported[] = "InsetBoxShadowUnsupported";
const char RequestInProgress[] = "RequestInProgress";
const char UntrustedEvent[] = "UntrustedEvent";
const char RegistrationFailed[] = "RegistrationFailed";
const char TypeNotSupported[] = "TypeNotSupported";
const char InvalidTypeActivation[] = "InvalidTypeActivation";
const char SecurityChecksFailed[] = "SecurityChecksFailed";
const char ActivationDisabled[] = "ActivationDisabled";
const char GeolocationDeprecated[] = "GeolocationDeprecated";
const char InvalidDisplayStyle[] = "InvalidDisplayStyle";
const char NonOpaqueColor[] = "NonOpaqueColor";
const char LowContrast[] = "LowContrast";
const char FontSizeTooSmall[] = "FontSizeTooSmall";
const char FontSizeTooLarge[] = "FontSizeTooLarge";
const char InvalidSizeValue[] = "InvalidSizeValue";
} // namespace PermissionElementIssueTypeEnum


CRDTP_BEGIN_DESERIALIZER(PermissionElementIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("disableReason", m_disableReason),
    CRDTP_DESERIALIZE_FIELD_OPT("isWarning", m_isWarning),
    CRDTP_DESERIALIZE_FIELD("issueType", m_issueType),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("occluderNodeInfo", m_occluderNodeInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("occluderParentNodeInfo", m_occluderParentNodeInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("permissionName", m_permissionName),
    CRDTP_DESERIALIZE_FIELD_OPT("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PermissionElementIssueDetails)
    CRDTP_SERIALIZE_FIELD("issueType", m_issueType);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
    CRDTP_SERIALIZE_FIELD("isWarning", m_isWarning);
    CRDTP_SERIALIZE_FIELD("permissionName", m_permissionName);
    CRDTP_SERIALIZE_FIELD("occluderNodeInfo", m_occluderNodeInfo);
    CRDTP_SERIALIZE_FIELD("occluderParentNodeInfo", m_occluderParentNodeInfo);
    CRDTP_SERIALIZE_FIELD("disableReason", m_disableReason);
CRDTP_END_SERIALIZER();


namespace InspectorIssueCodeEnum {
const char CookieIssue[] = "CookieIssue";
const char MixedContentIssue[] = "MixedContentIssue";
const char BlockedByResponseIssue[] = "BlockedByResponseIssue";
const char HeavyAdIssue[] = "HeavyAdIssue";
const char ContentSecurityPolicyIssue[] = "ContentSecurityPolicyIssue";
const char SharedArrayBufferIssue[] = "SharedArrayBufferIssue";
const char LowTextContrastIssue[] = "LowTextContrastIssue";
const char CorsIssue[] = "CorsIssue";
const char AttributionReportingIssue[] = "AttributionReportingIssue";
const char QuirksModeIssue[] = "QuirksModeIssue";
const char PartitioningBlobURLIssue[] = "PartitioningBlobURLIssue";
const char NavigatorUserAgentIssue[] = "NavigatorUserAgentIssue";
const char GenericIssue[] = "GenericIssue";
const char DeprecationIssue[] = "DeprecationIssue";
const char ClientHintIssue[] = "ClientHintIssue";
const char FederatedAuthRequestIssue[] = "FederatedAuthRequestIssue";
const char BounceTrackingIssue[] = "BounceTrackingIssue";
const char CookieDeprecationMetadataIssue[] = "CookieDeprecationMetadataIssue";
const char StylesheetLoadingIssue[] = "StylesheetLoadingIssue";
const char FederatedAuthUserInfoRequestIssue[] = "FederatedAuthUserInfoRequestIssue";
const char PropertyRuleIssue[] = "PropertyRuleIssue";
const char SharedDictionaryIssue[] = "SharedDictionaryIssue";
const char ElementAccessibilityIssue[] = "ElementAccessibilityIssue";
const char SRIMessageSignatureIssue[] = "SRIMessageSignatureIssue";
const char UnencodedDigestIssue[] = "UnencodedDigestIssue";
const char UserReidentificationIssue[] = "UserReidentificationIssue";
const char PermissionElementIssue[] = "PermissionElementIssue";
} // namespace InspectorIssueCodeEnum


CRDTP_BEGIN_DESERIALIZER(InspectorIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("attributionReportingIssueDetails", m_attributionReportingIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("blockedByResponseIssueDetails", m_blockedByResponseIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("bounceTrackingIssueDetails", m_bounceTrackingIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("clientHintIssueDetails", m_clientHintIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("contentSecurityPolicyIssueDetails", m_contentSecurityPolicyIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("cookieDeprecationMetadataIssueDetails", m_cookieDeprecationMetadataIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("cookieIssueDetails", m_cookieIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("corsIssueDetails", m_corsIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("deprecationIssueDetails", m_deprecationIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("elementAccessibilityIssueDetails", m_elementAccessibilityIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("federatedAuthRequestIssueDetails", m_federatedAuthRequestIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("federatedAuthUserInfoRequestIssueDetails", m_federatedAuthUserInfoRequestIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("genericIssueDetails", m_genericIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("heavyAdIssueDetails", m_heavyAdIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("lowTextContrastIssueDetails", m_lowTextContrastIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("mixedContentIssueDetails", m_mixedContentIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("navigatorUserAgentIssueDetails", m_navigatorUserAgentIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("partitioningBlobURLIssueDetails", m_partitioningBlobURLIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("permissionElementIssueDetails", m_permissionElementIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("propertyRuleIssueDetails", m_propertyRuleIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("quirksModeIssueDetails", m_quirksModeIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("sharedArrayBufferIssueDetails", m_sharedArrayBufferIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("sharedDictionaryIssueDetails", m_sharedDictionaryIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("sriMessageSignatureIssueDetails", m_sriMessageSignatureIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("stylesheetLoadingIssueDetails", m_stylesheetLoadingIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("unencodedDigestIssueDetails", m_unencodedDigestIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("userReidentificationIssueDetails", m_userReidentificationIssueDetails),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InspectorIssueDetails)
    CRDTP_SERIALIZE_FIELD("cookieIssueDetails", m_cookieIssueDetails);
    CRDTP_SERIALIZE_FIELD("mixedContentIssueDetails", m_mixedContentIssueDetails);
    CRDTP_SERIALIZE_FIELD("blockedByResponseIssueDetails", m_blockedByResponseIssueDetails);
    CRDTP_SERIALIZE_FIELD("heavyAdIssueDetails", m_heavyAdIssueDetails);
    CRDTP_SERIALIZE_FIELD("contentSecurityPolicyIssueDetails", m_contentSecurityPolicyIssueDetails);
    CRDTP_SERIALIZE_FIELD("sharedArrayBufferIssueDetails", m_sharedArrayBufferIssueDetails);
    CRDTP_SERIALIZE_FIELD("lowTextContrastIssueDetails", m_lowTextContrastIssueDetails);
    CRDTP_SERIALIZE_FIELD("corsIssueDetails", m_corsIssueDetails);
    CRDTP_SERIALIZE_FIELD("attributionReportingIssueDetails", m_attributionReportingIssueDetails);
    CRDTP_SERIALIZE_FIELD("quirksModeIssueDetails", m_quirksModeIssueDetails);
    CRDTP_SERIALIZE_FIELD("partitioningBlobURLIssueDetails", m_partitioningBlobURLIssueDetails);
    CRDTP_SERIALIZE_FIELD("navigatorUserAgentIssueDetails", m_navigatorUserAgentIssueDetails);
    CRDTP_SERIALIZE_FIELD("genericIssueDetails", m_genericIssueDetails);
    CRDTP_SERIALIZE_FIELD("deprecationIssueDetails", m_deprecationIssueDetails);
    CRDTP_SERIALIZE_FIELD("clientHintIssueDetails", m_clientHintIssueDetails);
    CRDTP_SERIALIZE_FIELD("federatedAuthRequestIssueDetails", m_federatedAuthRequestIssueDetails);
    CRDTP_SERIALIZE_FIELD("bounceTrackingIssueDetails", m_bounceTrackingIssueDetails);
    CRDTP_SERIALIZE_FIELD("cookieDeprecationMetadataIssueDetails", m_cookieDeprecationMetadataIssueDetails);
    CRDTP_SERIALIZE_FIELD("stylesheetLoadingIssueDetails", m_stylesheetLoadingIssueDetails);
    CRDTP_SERIALIZE_FIELD("propertyRuleIssueDetails", m_propertyRuleIssueDetails);
    CRDTP_SERIALIZE_FIELD("federatedAuthUserInfoRequestIssueDetails", m_federatedAuthUserInfoRequestIssueDetails);
    CRDTP_SERIALIZE_FIELD("sharedDictionaryIssueDetails", m_sharedDictionaryIssueDetails);
    CRDTP_SERIALIZE_FIELD("elementAccessibilityIssueDetails", m_elementAccessibilityIssueDetails);
    CRDTP_SERIALIZE_FIELD("sriMessageSignatureIssueDetails", m_sriMessageSignatureIssueDetails);
    CRDTP_SERIALIZE_FIELD("unencodedDigestIssueDetails", m_unencodedDigestIssueDetails);
    CRDTP_SERIALIZE_FIELD("userReidentificationIssueDetails", m_userReidentificationIssueDetails);
    CRDTP_SERIALIZE_FIELD("permissionElementIssueDetails", m_permissionElementIssueDetails);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(InspectorIssue)
    CRDTP_DESERIALIZE_FIELD("code", m_code),
    CRDTP_DESERIALIZE_FIELD("details", m_details),
    CRDTP_DESERIALIZE_FIELD_OPT("issueId", m_issueId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InspectorIssue)
    CRDTP_SERIALIZE_FIELD("code", m_code);
    CRDTP_SERIALIZE_FIELD("details", m_details);
    CRDTP_SERIALIZE_FIELD("issueId", m_issueId);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace GetEncodedResponse {
namespace EncodingEnum {
const char* Webp = "webp";
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace EncodingEnum
} // namespace GetEncodedResponse

// ------------- Frontend notifications.

void Frontend::issueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("issue"), issue);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Audits.issueAdded", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void getEncodedResponse(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void checkContrast(const crdtp::Dispatchable& dispatchable);
    void checkFormsIssues(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("checkContrast"),
          &DomainDispatcherImpl::checkContrast
    },
    {
          crdtp::SpanFrom("checkFormsIssues"),
          &DomainDispatcherImpl::checkFormsIssues
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getEncodedResponse"),
          &DomainDispatcherImpl::getEncodedResponse
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct getEncodedResponseParams : public crdtp::DeserializableProtocolObject<getEncodedResponseParams> {
    String requestId;
    String encoding;
    std::optional<double> quality;
    std::optional<bool> sizeOnly;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getEncodedResponseParams)
    CRDTP_DESERIALIZE_FIELD("encoding", encoding),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", quality),
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
    CRDTP_DESERIALIZE_FIELD_OPT("sizeOnly", sizeOnly),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getEncodedResponse(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getEncodedResponseParams params;
    if (!getEncodedResponseParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::optional<Binary> out_body;
    int out_originalSize;
    int out_encodedSize;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getEncodedResponse(params.requestId, params.encoding, std::move(params.quality), std::move(params.sizeOnly), &out_body, &out_originalSize, &out_encodedSize);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.getEncodedResponse"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("body"), out_body);
          serializer.AddField(crdtp::MakeSpan("originalSize"), out_originalSize);
          serializer.AddField(crdtp::MakeSpan("encodedSize"), out_encodedSize);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct checkContrastParams : public crdtp::DeserializableProtocolObject<checkContrastParams> {
    std::optional<bool> reportAAA;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(checkContrastParams)
    CRDTP_DESERIALIZE_FIELD_OPT("reportAAA", reportAAA),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::checkContrast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    checkContrastParams params;
    if (!checkContrastParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->checkContrast(std::move(params.reportAAA));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.checkContrast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::checkFormsIssues(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Audits::GenericIssueDetails>> out_formIssues;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->checkFormsIssues(&out_formIssues);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.checkFormsIssues"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("formIssues"), out_formIssues);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Audits"), SortedRedirects(), std::move(dispatcher));
}

} // Audits
} // namespace blink
} // namespace protocol
