// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Animation_h
#define blink_protocol_Animation_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"

namespace blink {
namespace protocol {
namespace Animation {
class Animation;
class ViewOrScrollTimeline;
class AnimationEffect;
class KeyframesRule;
class KeyframeStyle;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT Animation : public ::crdtp::ProtocolObject<Animation> {
public:
    ~Animation() override;  // Defined below

    String getId() { return m_id; }
    void setId(const String& value);  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    bool getPausedState() { return m_pausedState; }
    void setPausedState(bool value);  // Defined below

    String getPlayState() { return m_playState; }
    void setPlayState(const String& value);  // Defined below

    double getPlaybackRate() { return m_playbackRate; }
    void setPlaybackRate(double value);  // Defined below

    double getStartTime() { return m_startTime; }
    void setStartTime(double value);  // Defined below

    double getCurrentTime() { return m_currentTime; }
    void setCurrentTime(double value);  // Defined below

    struct CORE_EXPORT TypeEnum {
        static const char* CSSTransition;
        static const char* CSSAnimation;
        static const char* WebAnimation;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasSource() { return !!m_source; }
    protocol::Animation::AnimationEffect* getSource(protocol::Animation::AnimationEffect* defaultValue) {
       return m_source ? m_source.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Animation::AnimationEffect>& getSource() const {
       return m_source;
    }
    void setSource(std::unique_ptr<protocol::Animation::AnimationEffect> value);  // Defined below

    bool hasCssId() { return !!m_cssId; }
    String getCssId(const String& defaultValue) const {
       return m_cssId.value_or(defaultValue);
    }
    const std::optional<String>& getCssId() const {
       return m_cssId;
    }
    void setCssId(const String& value);  // Defined below

    bool hasViewOrScrollTimeline() { return !!m_viewOrScrollTimeline; }
    protocol::Animation::ViewOrScrollTimeline* getViewOrScrollTimeline(protocol::Animation::ViewOrScrollTimeline* defaultValue) {
       return m_viewOrScrollTimeline ? m_viewOrScrollTimeline.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Animation::ViewOrScrollTimeline>& getViewOrScrollTimeline() const {
       return m_viewOrScrollTimeline;
    }
    void setViewOrScrollTimeline(std::unique_ptr<protocol::Animation::ViewOrScrollTimeline> value);  // Defined below

    template<int STATE>
    class AnimationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            NameSet = 1 << 2,
            PausedStateSet = 1 << 3,
            PlayStateSet = 1 << 4,
            PlaybackRateSet = 1 << 5,
            StartTimeSet = 1 << 6,
            CurrentTimeSet = 1 << 7,
            TypeSet = 1 << 8,
            AllFieldsSet = (IdSet | NameSet | PausedStateSet | PlayStateSet | PlaybackRateSet | StartTimeSet | CurrentTimeSet | TypeSet | 0)};


        AnimationBuilder<STATE | IdSet>& setId(const String& value);  // Defined below

        AnimationBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        AnimationBuilder<STATE | PausedStateSet>& setPausedState(bool value);  // Defined below

        AnimationBuilder<STATE | PlayStateSet>& setPlayState(const String& value);  // Defined below

        AnimationBuilder<STATE | PlaybackRateSet>& setPlaybackRate(double value);  // Defined below

        AnimationBuilder<STATE | StartTimeSet>& setStartTime(double value);  // Defined below

        AnimationBuilder<STATE | CurrentTimeSet>& setCurrentTime(double value);  // Defined below

        AnimationBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        AnimationBuilder<STATE>& setSource(std::unique_ptr<protocol::Animation::AnimationEffect> value);  // Defined below

        AnimationBuilder<STATE>& setCssId(const String& value);  // Defined below

        AnimationBuilder<STATE>& setViewOrScrollTimeline(std::unique_ptr<protocol::Animation::ViewOrScrollTimeline> value);  // Defined below

        std::unique_ptr<Animation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Animation;
        AnimationBuilder() : m_result(new Animation()) { }

        template<int STEP> AnimationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AnimationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Animation::Animation> m_result;
    };

    static AnimationBuilder<0> create()
    {
        return AnimationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Animation();  // Defined below

    String m_id;
    String m_name;
    bool m_pausedState;
    String m_playState;
    double m_playbackRate;
    double m_startTime;
    double m_currentTime;
    String m_type;
    std::unique_ptr<protocol::Animation::AnimationEffect> m_source;
    std::optional<String> m_cssId;
    std::unique_ptr<protocol::Animation::ViewOrScrollTimeline> m_viewOrScrollTimeline;
};


class CORE_EXPORT ViewOrScrollTimeline : public ::crdtp::ProtocolObject<ViewOrScrollTimeline> {
public:
    ~ViewOrScrollTimeline() override;  // Defined below

    bool hasSourceNodeId() { return !!m_sourceNodeId; }
    int getSourceNodeId(int defaultValue) const {
       return m_sourceNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getSourceNodeId() const {
       return m_sourceNodeId;
    }
    void setSourceNodeId(int value);  // Defined below

    bool hasStartOffset() { return !!m_startOffset; }
    double getStartOffset(double defaultValue) const {
       return m_startOffset.value_or(defaultValue);
    }
    const std::optional<double>& getStartOffset() const {
       return m_startOffset;
    }
    void setStartOffset(double value);  // Defined below

    bool hasEndOffset() { return !!m_endOffset; }
    double getEndOffset(double defaultValue) const {
       return m_endOffset.value_or(defaultValue);
    }
    const std::optional<double>& getEndOffset() const {
       return m_endOffset;
    }
    void setEndOffset(double value);  // Defined below

    bool hasSubjectNodeId() { return !!m_subjectNodeId; }
    int getSubjectNodeId(int defaultValue) const {
       return m_subjectNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getSubjectNodeId() const {
       return m_subjectNodeId;
    }
    void setSubjectNodeId(int value);  // Defined below

    String getAxis() { return m_axis; }
    void setAxis(const String& value);  // Defined below

    template<int STATE>
    class ViewOrScrollTimelineBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AxisSet = 1 << 1,
            AllFieldsSet = (AxisSet | 0)};


        ViewOrScrollTimelineBuilder<STATE>& setSourceNodeId(int value);  // Defined below

        ViewOrScrollTimelineBuilder<STATE>& setStartOffset(double value);  // Defined below

        ViewOrScrollTimelineBuilder<STATE>& setEndOffset(double value);  // Defined below

        ViewOrScrollTimelineBuilder<STATE>& setSubjectNodeId(int value);  // Defined below

        ViewOrScrollTimelineBuilder<STATE | AxisSet>& setAxis(const String& value);  // Defined below

        std::unique_ptr<ViewOrScrollTimeline> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ViewOrScrollTimeline;
        ViewOrScrollTimelineBuilder() : m_result(new ViewOrScrollTimeline()) { }

        template<int STEP> ViewOrScrollTimelineBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ViewOrScrollTimelineBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Animation::ViewOrScrollTimeline> m_result;
    };

    static ViewOrScrollTimelineBuilder<0> create()
    {
        return ViewOrScrollTimelineBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ViewOrScrollTimeline();  // Defined below

    std::optional<int> m_sourceNodeId;
    std::optional<double> m_startOffset;
    std::optional<double> m_endOffset;
    std::optional<int> m_subjectNodeId;
    String m_axis;
};


class CORE_EXPORT AnimationEffect : public ::crdtp::ProtocolObject<AnimationEffect> {
public:
    ~AnimationEffect() override;  // Defined below

    double getDelay() { return m_delay; }
    void setDelay(double value);  // Defined below

    double getEndDelay() { return m_endDelay; }
    void setEndDelay(double value);  // Defined below

    double getIterationStart() { return m_iterationStart; }
    void setIterationStart(double value);  // Defined below

    bool hasIterations() { return !!m_iterations; }
    double getIterations(double defaultValue) const {
       return m_iterations.value_or(defaultValue);
    }
    const std::optional<double>& getIterations() const {
       return m_iterations;
    }
    void setIterations(double value);  // Defined below

    double getDuration() { return m_duration; }
    void setDuration(double value);  // Defined below

    String getDirection() { return m_direction; }
    void setDirection(const String& value);  // Defined below

    String getFill() { return m_fill; }
    void setFill(const String& value);  // Defined below

    bool hasBackendNodeId() { return !!m_backendNodeId; }
    int getBackendNodeId(int defaultValue) const {
       return m_backendNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getBackendNodeId() const {
       return m_backendNodeId;
    }
    void setBackendNodeId(int value);  // Defined below

    bool hasKeyframesRule() { return !!m_keyframesRule; }
    protocol::Animation::KeyframesRule* getKeyframesRule(protocol::Animation::KeyframesRule* defaultValue) {
       return m_keyframesRule ? m_keyframesRule.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Animation::KeyframesRule>& getKeyframesRule() const {
       return m_keyframesRule;
    }
    void setKeyframesRule(std::unique_ptr<protocol::Animation::KeyframesRule> value);  // Defined below

    String getEasing() { return m_easing; }
    void setEasing(const String& value);  // Defined below

    template<int STATE>
    class AnimationEffectBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DelaySet = 1 << 1,
            EndDelaySet = 1 << 2,
            IterationStartSet = 1 << 3,
            DurationSet = 1 << 4,
            DirectionSet = 1 << 5,
            FillSet = 1 << 6,
            EasingSet = 1 << 7,
            AllFieldsSet = (DelaySet | EndDelaySet | IterationStartSet | DurationSet | DirectionSet | FillSet | EasingSet | 0)};


        AnimationEffectBuilder<STATE | DelaySet>& setDelay(double value);  // Defined below

        AnimationEffectBuilder<STATE | EndDelaySet>& setEndDelay(double value);  // Defined below

        AnimationEffectBuilder<STATE | IterationStartSet>& setIterationStart(double value);  // Defined below

        AnimationEffectBuilder<STATE>& setIterations(double value);  // Defined below

        AnimationEffectBuilder<STATE | DurationSet>& setDuration(double value);  // Defined below

        AnimationEffectBuilder<STATE | DirectionSet>& setDirection(const String& value);  // Defined below

        AnimationEffectBuilder<STATE | FillSet>& setFill(const String& value);  // Defined below

        AnimationEffectBuilder<STATE>& setBackendNodeId(int value);  // Defined below

        AnimationEffectBuilder<STATE>& setKeyframesRule(std::unique_ptr<protocol::Animation::KeyframesRule> value);  // Defined below

        AnimationEffectBuilder<STATE | EasingSet>& setEasing(const String& value);  // Defined below

        std::unique_ptr<AnimationEffect> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AnimationEffect;
        AnimationEffectBuilder() : m_result(new AnimationEffect()) { }

        template<int STEP> AnimationEffectBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AnimationEffectBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Animation::AnimationEffect> m_result;
    };

    static AnimationEffectBuilder<0> create()
    {
        return AnimationEffectBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AnimationEffect();  // Defined below

    double m_delay;
    double m_endDelay;
    double m_iterationStart;
    std::optional<double> m_iterations;
    double m_duration;
    String m_direction;
    String m_fill;
    std::optional<int> m_backendNodeId;
    std::unique_ptr<protocol::Animation::KeyframesRule> m_keyframesRule;
    String m_easing;
};


class CORE_EXPORT KeyframesRule : public ::crdtp::ProtocolObject<KeyframesRule> {
public:
    ~KeyframesRule() override;  // Defined below

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value);  // Defined below

    protocol::Array<protocol::Animation::KeyframeStyle>* getKeyframes() { return m_keyframes.get(); }
    void setKeyframes(std::unique_ptr<protocol::Array<protocol::Animation::KeyframeStyle>> value);  // Defined below

    template<int STATE>
    class KeyframesRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeyframesSet = 1 << 1,
            AllFieldsSet = (KeyframesSet | 0)};


        KeyframesRuleBuilder<STATE>& setName(const String& value);  // Defined below

        KeyframesRuleBuilder<STATE | KeyframesSet>& setKeyframes(std::unique_ptr<protocol::Array<protocol::Animation::KeyframeStyle>> value);  // Defined below

        std::unique_ptr<KeyframesRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class KeyframesRule;
        KeyframesRuleBuilder() : m_result(new KeyframesRule()) { }

        template<int STEP> KeyframesRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<KeyframesRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Animation::KeyframesRule> m_result;
    };

    static KeyframesRuleBuilder<0> create()
    {
        return KeyframesRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    KeyframesRule();  // Defined below

    std::optional<String> m_name;
    std::unique_ptr<protocol::Array<protocol::Animation::KeyframeStyle>> m_keyframes;
};


class CORE_EXPORT KeyframeStyle : public ::crdtp::ProtocolObject<KeyframeStyle> {
public:
    ~KeyframeStyle() override;  // Defined below

    String getOffset() { return m_offset; }
    void setOffset(const String& value);  // Defined below

    String getEasing() { return m_easing; }
    void setEasing(const String& value);  // Defined below

    template<int STATE>
    class KeyframeStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OffsetSet = 1 << 1,
            EasingSet = 1 << 2,
            AllFieldsSet = (OffsetSet | EasingSet | 0)};


        KeyframeStyleBuilder<STATE | OffsetSet>& setOffset(const String& value);  // Defined below

        KeyframeStyleBuilder<STATE | EasingSet>& setEasing(const String& value);  // Defined below

        std::unique_ptr<KeyframeStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class KeyframeStyle;
        KeyframeStyleBuilder() : m_result(new KeyframeStyle()) { }

        template<int STEP> KeyframeStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<KeyframeStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Animation::KeyframeStyle> m_result;
    };

    static KeyframeStyleBuilder<0> create()
    {
        return KeyframeStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    KeyframeStyle();  // Defined below

    String m_offset;
    String m_easing;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Animation::~Animation() = default;
inline void Animation::setId(const String& value) { m_id = value; }
inline void Animation::setName(const String& value) { m_name = value; }
inline void Animation::setPausedState(bool value) { m_pausedState = value; }
inline void Animation::setPlayState(const String& value) { m_playState = value; }
inline void Animation::setPlaybackRate(double value) { m_playbackRate = value; }
inline void Animation::setStartTime(double value) { m_startTime = value; }
inline void Animation::setCurrentTime(double value) { m_currentTime = value; }
inline void Animation::setType(const String& value) { m_type = value; }
inline void Animation::setSource(std::unique_ptr<protocol::Animation::AnimationEffect> value) { m_source = std::move(value); }
inline void Animation::setCssId(const String& value) { m_cssId = value; }
inline void Animation::setViewOrScrollTimeline(std::unique_ptr<protocol::Animation::ViewOrScrollTimeline> value) { m_viewOrScrollTimeline = std::move(value); }

template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::IdSet>&
Animation::AnimationBuilder<STATE>::setId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::NameSet>&
Animation::AnimationBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::PausedStateSet>&
Animation::AnimationBuilder<STATE>::setPausedState(bool value) {
  static_assert(!(STATE & PausedStateSet), "property pausedState should not be set yet");
  m_result->setPausedState(value);
  return castState<PausedStateSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::PlayStateSet>&
Animation::AnimationBuilder<STATE>::setPlayState(const String& value) {
  static_assert(!(STATE & PlayStateSet), "property playState should not be set yet");
  m_result->setPlayState(value);
  return castState<PlayStateSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::PlaybackRateSet>&
Animation::AnimationBuilder<STATE>::setPlaybackRate(double value) {
  static_assert(!(STATE & PlaybackRateSet), "property playbackRate should not be set yet");
  m_result->setPlaybackRate(value);
  return castState<PlaybackRateSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::StartTimeSet>&
Animation::AnimationBuilder<STATE>::setStartTime(double value) {
  static_assert(!(STATE & StartTimeSet), "property startTime should not be set yet");
  m_result->setStartTime(value);
  return castState<StartTimeSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::CurrentTimeSet>&
Animation::AnimationBuilder<STATE>::setCurrentTime(double value) {
  static_assert(!(STATE & CurrentTimeSet), "property currentTime should not be set yet");
  m_result->setCurrentTime(value);
  return castState<CurrentTimeSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE | Animation::AnimationBuilder<STATE>::TypeSet>&
Animation::AnimationBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline Animation::AnimationBuilder<STATE>& Animation::AnimationBuilder<STATE>::setSource(std::unique_ptr<protocol::Animation::AnimationEffect> value) {
  m_result->setSource(std::move(value));
  return *this;
}
template<int STATE>
inline Animation::AnimationBuilder<STATE>& Animation::AnimationBuilder<STATE>::setCssId(const String& value) {
  m_result->setCssId(value);
  return *this;
}
template<int STATE>
inline Animation::AnimationBuilder<STATE>& Animation::AnimationBuilder<STATE>::setViewOrScrollTimeline(std::unique_ptr<protocol::Animation::ViewOrScrollTimeline> value) {
  m_result->setViewOrScrollTimeline(std::move(value));
  return *this;
}

inline Animation::Animation() {
  m_pausedState = false;
  m_playbackRate = 0;
  m_startTime = 0;
  m_currentTime = 0;
}
inline ViewOrScrollTimeline::~ViewOrScrollTimeline() = default;
inline void ViewOrScrollTimeline::setSourceNodeId(int value) { m_sourceNodeId = value; }
inline void ViewOrScrollTimeline::setStartOffset(double value) { m_startOffset = value; }
inline void ViewOrScrollTimeline::setEndOffset(double value) { m_endOffset = value; }
inline void ViewOrScrollTimeline::setSubjectNodeId(int value) { m_subjectNodeId = value; }
inline void ViewOrScrollTimeline::setAxis(const String& value) { m_axis = value; }

template<int STATE>
inline ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>& ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>::setSourceNodeId(int value) {
  m_result->setSourceNodeId(value);
  return *this;
}
template<int STATE>
inline ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>& ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>::setStartOffset(double value) {
  m_result->setStartOffset(value);
  return *this;
}
template<int STATE>
inline ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>& ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>::setEndOffset(double value) {
  m_result->setEndOffset(value);
  return *this;
}
template<int STATE>
inline ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>& ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>::setSubjectNodeId(int value) {
  m_result->setSubjectNodeId(value);
  return *this;
}
template<int STATE>
inline ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE | ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>::AxisSet>&
ViewOrScrollTimeline::ViewOrScrollTimelineBuilder<STATE>::setAxis(const String& value) {
  static_assert(!(STATE & AxisSet), "property axis should not be set yet");
  m_result->setAxis(value);
  return castState<AxisSet>();
}

inline ViewOrScrollTimeline::ViewOrScrollTimeline() {
}
inline AnimationEffect::~AnimationEffect() = default;
inline void AnimationEffect::setDelay(double value) { m_delay = value; }
inline void AnimationEffect::setEndDelay(double value) { m_endDelay = value; }
inline void AnimationEffect::setIterationStart(double value) { m_iterationStart = value; }
inline void AnimationEffect::setIterations(double value) { m_iterations = value; }
inline void AnimationEffect::setDuration(double value) { m_duration = value; }
inline void AnimationEffect::setDirection(const String& value) { m_direction = value; }
inline void AnimationEffect::setFill(const String& value) { m_fill = value; }
inline void AnimationEffect::setBackendNodeId(int value) { m_backendNodeId = value; }
inline void AnimationEffect::setKeyframesRule(std::unique_ptr<protocol::Animation::KeyframesRule> value) { m_keyframesRule = std::move(value); }
inline void AnimationEffect::setEasing(const String& value) { m_easing = value; }

template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::DelaySet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setDelay(double value) {
  static_assert(!(STATE & DelaySet), "property delay should not be set yet");
  m_result->setDelay(value);
  return castState<DelaySet>();
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::EndDelaySet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setEndDelay(double value) {
  static_assert(!(STATE & EndDelaySet), "property endDelay should not be set yet");
  m_result->setEndDelay(value);
  return castState<EndDelaySet>();
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::IterationStartSet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setIterationStart(double value) {
  static_assert(!(STATE & IterationStartSet), "property iterationStart should not be set yet");
  m_result->setIterationStart(value);
  return castState<IterationStartSet>();
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE>& AnimationEffect::AnimationEffectBuilder<STATE>::setIterations(double value) {
  m_result->setIterations(value);
  return *this;
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::DurationSet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setDuration(double value) {
  static_assert(!(STATE & DurationSet), "property duration should not be set yet");
  m_result->setDuration(value);
  return castState<DurationSet>();
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::DirectionSet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setDirection(const String& value) {
  static_assert(!(STATE & DirectionSet), "property direction should not be set yet");
  m_result->setDirection(value);
  return castState<DirectionSet>();
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::FillSet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setFill(const String& value) {
  static_assert(!(STATE & FillSet), "property fill should not be set yet");
  m_result->setFill(value);
  return castState<FillSet>();
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE>& AnimationEffect::AnimationEffectBuilder<STATE>::setBackendNodeId(int value) {
  m_result->setBackendNodeId(value);
  return *this;
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE>& AnimationEffect::AnimationEffectBuilder<STATE>::setKeyframesRule(std::unique_ptr<protocol::Animation::KeyframesRule> value) {
  m_result->setKeyframesRule(std::move(value));
  return *this;
}
template<int STATE>
inline AnimationEffect::AnimationEffectBuilder<STATE | AnimationEffect::AnimationEffectBuilder<STATE>::EasingSet>&
AnimationEffect::AnimationEffectBuilder<STATE>::setEasing(const String& value) {
  static_assert(!(STATE & EasingSet), "property easing should not be set yet");
  m_result->setEasing(value);
  return castState<EasingSet>();
}

inline AnimationEffect::AnimationEffect() {
  m_delay = 0;
  m_endDelay = 0;
  m_iterationStart = 0;
  m_duration = 0;
}
inline KeyframesRule::~KeyframesRule() = default;
inline void KeyframesRule::setName(const String& value) { m_name = value; }
inline void KeyframesRule::setKeyframes(std::unique_ptr<protocol::Array<protocol::Animation::KeyframeStyle>> value) { m_keyframes = std::move(value); }

template<int STATE>
inline KeyframesRule::KeyframesRuleBuilder<STATE>& KeyframesRule::KeyframesRuleBuilder<STATE>::setName(const String& value) {
  m_result->setName(value);
  return *this;
}
template<int STATE>
inline KeyframesRule::KeyframesRuleBuilder<STATE | KeyframesRule::KeyframesRuleBuilder<STATE>::KeyframesSet>&
KeyframesRule::KeyframesRuleBuilder<STATE>::setKeyframes(std::unique_ptr<protocol::Array<protocol::Animation::KeyframeStyle>> value) {
  static_assert(!(STATE & KeyframesSet), "property keyframes should not be set yet");
  m_result->setKeyframes(std::move(value));
  return castState<KeyframesSet>();
}

inline KeyframesRule::KeyframesRule() {
}
inline KeyframeStyle::~KeyframeStyle() = default;
inline void KeyframeStyle::setOffset(const String& value) { m_offset = value; }
inline void KeyframeStyle::setEasing(const String& value) { m_easing = value; }

template<int STATE>
inline KeyframeStyle::KeyframeStyleBuilder<STATE | KeyframeStyle::KeyframeStyleBuilder<STATE>::OffsetSet>&
KeyframeStyle::KeyframeStyleBuilder<STATE>::setOffset(const String& value) {
  static_assert(!(STATE & OffsetSet), "property offset should not be set yet");
  m_result->setOffset(value);
  return castState<OffsetSet>();
}
template<int STATE>
inline KeyframeStyle::KeyframeStyleBuilder<STATE | KeyframeStyle::KeyframeStyleBuilder<STATE>::EasingSet>&
KeyframeStyle::KeyframeStyleBuilder<STATE>::setEasing(const String& value) {
  static_assert(!(STATE & EasingSet), "property easing should not be set yet");
  m_result->setEasing(value);
  return castState<EasingSet>();
}

inline KeyframeStyle::KeyframeStyle() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getCurrentTime(const String& in_id, double* out_currentTime) = 0;
    virtual DispatchResponse getPlaybackRate(double* out_playbackRate) = 0;
    virtual DispatchResponse releaseAnimations(std::unique_ptr<protocol::Array<String>> in_animations) = 0;
    virtual DispatchResponse resolveAnimation(const String& in_animationId, std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject>* out_remoteObject) = 0;
    virtual DispatchResponse seekAnimations(std::unique_ptr<protocol::Array<String>> in_animations, double in_currentTime) = 0;
    virtual DispatchResponse setPaused(std::unique_ptr<protocol::Array<String>> in_animations, bool in_paused) = 0;
    virtual DispatchResponse setPlaybackRate(double in_playbackRate) = 0;
    virtual DispatchResponse setTiming(const String& in_animationId, double in_duration, double in_delay) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void animationCanceled(const String& id);
    void animationCreated(const String& id);
    void animationStarted(std::unique_ptr<protocol::Animation::Animation> animation);
    void animationUpdated(std::unique_ptr<protocol::Animation::Animation> animation);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Animation
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Animation_h)
