// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/animation.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Animation {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Animation";
const char Metainfo::commandPrefix[] = "Animation.";
const char Metainfo::version[] = "1.3";


const char* Animation::TypeEnum::CSSTransition = "CSSTransition";
const char* Animation::TypeEnum::CSSAnimation = "CSSAnimation";
const char* Animation::TypeEnum::WebAnimation = "WebAnimation";
CRDTP_BEGIN_DESERIALIZER(Animation)
    CRDTP_DESERIALIZE_FIELD_OPT("cssId", m_cssId),
    CRDTP_DESERIALIZE_FIELD("currentTime", m_currentTime),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("pausedState", m_pausedState),
    CRDTP_DESERIALIZE_FIELD("playState", m_playState),
    CRDTP_DESERIALIZE_FIELD("playbackRate", m_playbackRate),
    CRDTP_DESERIALIZE_FIELD_OPT("source", m_source),
    CRDTP_DESERIALIZE_FIELD("startTime", m_startTime),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("viewOrScrollTimeline", m_viewOrScrollTimeline),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Animation)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("pausedState", m_pausedState);
    CRDTP_SERIALIZE_FIELD("playState", m_playState);
    CRDTP_SERIALIZE_FIELD("playbackRate", m_playbackRate);
    CRDTP_SERIALIZE_FIELD("startTime", m_startTime);
    CRDTP_SERIALIZE_FIELD("currentTime", m_currentTime);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("source", m_source);
    CRDTP_SERIALIZE_FIELD("cssId", m_cssId);
    CRDTP_SERIALIZE_FIELD("viewOrScrollTimeline", m_viewOrScrollTimeline);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ViewOrScrollTimeline)
    CRDTP_DESERIALIZE_FIELD("axis", m_axis),
    CRDTP_DESERIALIZE_FIELD_OPT("endOffset", m_endOffset),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceNodeId", m_sourceNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("startOffset", m_startOffset),
    CRDTP_DESERIALIZE_FIELD_OPT("subjectNodeId", m_subjectNodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ViewOrScrollTimeline)
    CRDTP_SERIALIZE_FIELD("sourceNodeId", m_sourceNodeId);
    CRDTP_SERIALIZE_FIELD("startOffset", m_startOffset);
    CRDTP_SERIALIZE_FIELD("endOffset", m_endOffset);
    CRDTP_SERIALIZE_FIELD("subjectNodeId", m_subjectNodeId);
    CRDTP_SERIALIZE_FIELD("axis", m_axis);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AnimationEffect)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD("delay", m_delay),
    CRDTP_DESERIALIZE_FIELD("direction", m_direction),
    CRDTP_DESERIALIZE_FIELD("duration", m_duration),
    CRDTP_DESERIALIZE_FIELD("easing", m_easing),
    CRDTP_DESERIALIZE_FIELD("endDelay", m_endDelay),
    CRDTP_DESERIALIZE_FIELD("fill", m_fill),
    CRDTP_DESERIALIZE_FIELD("iterationStart", m_iterationStart),
    CRDTP_DESERIALIZE_FIELD_OPT("iterations", m_iterations),
    CRDTP_DESERIALIZE_FIELD_OPT("keyframesRule", m_keyframesRule),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AnimationEffect)
    CRDTP_SERIALIZE_FIELD("delay", m_delay);
    CRDTP_SERIALIZE_FIELD("endDelay", m_endDelay);
    CRDTP_SERIALIZE_FIELD("iterationStart", m_iterationStart);
    CRDTP_SERIALIZE_FIELD("iterations", m_iterations);
    CRDTP_SERIALIZE_FIELD("duration", m_duration);
    CRDTP_SERIALIZE_FIELD("direction", m_direction);
    CRDTP_SERIALIZE_FIELD("fill", m_fill);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
    CRDTP_SERIALIZE_FIELD("keyframesRule", m_keyframesRule);
    CRDTP_SERIALIZE_FIELD("easing", m_easing);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(KeyframesRule)
    CRDTP_DESERIALIZE_FIELD("keyframes", m_keyframes),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(KeyframesRule)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("keyframes", m_keyframes);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(KeyframeStyle)
    CRDTP_DESERIALIZE_FIELD("easing", m_easing),
    CRDTP_DESERIALIZE_FIELD("offset", m_offset),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(KeyframeStyle)
    CRDTP_SERIALIZE_FIELD("offset", m_offset);
    CRDTP_SERIALIZE_FIELD("easing", m_easing);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::animationCanceled(const String& id)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("id"), id);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Animation.animationCanceled", serializer.Finish()));
}

void Frontend::animationCreated(const String& id)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("id"), id);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Animation.animationCreated", serializer.Finish()));
}

void Frontend::animationStarted(std::unique_ptr<protocol::Animation::Animation> animation)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("animation"), animation);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Animation.animationStarted", serializer.Finish()));
}

void Frontend::animationUpdated(std::unique_ptr<protocol::Animation::Animation> animation)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("animation"), animation);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Animation.animationUpdated", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getCurrentTime(const crdtp::Dispatchable& dispatchable);
    void getPlaybackRate(const crdtp::Dispatchable& dispatchable);
    void releaseAnimations(const crdtp::Dispatchable& dispatchable);
    void resolveAnimation(const crdtp::Dispatchable& dispatchable);
    void seekAnimations(const crdtp::Dispatchable& dispatchable);
    void setPaused(const crdtp::Dispatchable& dispatchable);
    void setPlaybackRate(const crdtp::Dispatchable& dispatchable);
    void setTiming(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getCurrentTime"),
          &DomainDispatcherImpl::getCurrentTime
    },
    {
          crdtp::SpanFrom("getPlaybackRate"),
          &DomainDispatcherImpl::getPlaybackRate
    },
    {
          crdtp::SpanFrom("releaseAnimations"),
          &DomainDispatcherImpl::releaseAnimations
    },
    {
          crdtp::SpanFrom("resolveAnimation"),
          &DomainDispatcherImpl::resolveAnimation
    },
    {
          crdtp::SpanFrom("seekAnimations"),
          &DomainDispatcherImpl::seekAnimations
    },
    {
          crdtp::SpanFrom("setPaused"),
          &DomainDispatcherImpl::setPaused
    },
    {
          crdtp::SpanFrom("setPlaybackRate"),
          &DomainDispatcherImpl::setPlaybackRate
    },
    {
          crdtp::SpanFrom("setTiming"),
          &DomainDispatcherImpl::setTiming
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getCurrentTimeParams : public crdtp::DeserializableProtocolObject<getCurrentTimeParams> {
    String id;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getCurrentTimeParams)
    CRDTP_DESERIALIZE_FIELD("id", id),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getCurrentTime(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getCurrentTimeParams params;
    if (!getCurrentTimeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    double out_currentTime;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getCurrentTime(params.id, &out_currentTime);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.getCurrentTime"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("currentTime"), out_currentTime);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getPlaybackRate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    double out_playbackRate;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getPlaybackRate(&out_playbackRate);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.getPlaybackRate"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("playbackRate"), out_playbackRate);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct releaseAnimationsParams : public crdtp::DeserializableProtocolObject<releaseAnimationsParams> {
    std::unique_ptr<protocol::Array<String>> animations;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(releaseAnimationsParams)
    CRDTP_DESERIALIZE_FIELD("animations", animations),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::releaseAnimations(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    releaseAnimationsParams params;
    if (!releaseAnimationsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->releaseAnimations(std::move(params.animations));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.releaseAnimations"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct resolveAnimationParams : public crdtp::DeserializableProtocolObject<resolveAnimationParams> {
    String animationId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(resolveAnimationParams)
    CRDTP_DESERIALIZE_FIELD("animationId", animationId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::resolveAnimation(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    resolveAnimationParams params;
    if (!resolveAnimationParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> out_remoteObject;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->resolveAnimation(params.animationId, &out_remoteObject);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.resolveAnimation"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("remoteObject"), out_remoteObject);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct seekAnimationsParams : public crdtp::DeserializableProtocolObject<seekAnimationsParams> {
    std::unique_ptr<protocol::Array<String>> animations;
    double currentTime;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(seekAnimationsParams)
    CRDTP_DESERIALIZE_FIELD("animations", animations),
    CRDTP_DESERIALIZE_FIELD("currentTime", currentTime),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::seekAnimations(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    seekAnimationsParams params;
    if (!seekAnimationsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->seekAnimations(std::move(params.animations), params.currentTime);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.seekAnimations"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPausedParams : public crdtp::DeserializableProtocolObject<setPausedParams> {
    std::unique_ptr<protocol::Array<String>> animations;
    bool paused;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPausedParams)
    CRDTP_DESERIALIZE_FIELD("animations", animations),
    CRDTP_DESERIALIZE_FIELD("paused", paused),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPaused(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPausedParams params;
    if (!setPausedParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setPaused(std::move(params.animations), params.paused);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.setPaused"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPlaybackRateParams : public crdtp::DeserializableProtocolObject<setPlaybackRateParams> {
    double playbackRate;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPlaybackRateParams)
    CRDTP_DESERIALIZE_FIELD("playbackRate", playbackRate),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPlaybackRate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPlaybackRateParams params;
    if (!setPlaybackRateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setPlaybackRate(params.playbackRate);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.setPlaybackRate"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setTimingParams : public crdtp::DeserializableProtocolObject<setTimingParams> {
    String animationId;
    double duration;
    double delay;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setTimingParams)
    CRDTP_DESERIALIZE_FIELD("animationId", animationId),
    CRDTP_DESERIALIZE_FIELD("delay", delay),
    CRDTP_DESERIALIZE_FIELD("duration", duration),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setTiming(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setTimingParams params;
    if (!setTimingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setTiming(params.animationId, params.duration, params.delay);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Animation.setTiming"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Animation"), SortedRedirects(), std::move(dispatcher));
}

} // Animation
} // namespace blink
} // namespace protocol
