// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by third_party/blink/renderer/build/scripts/generate_permission_element_grd.py

#include <stdint.h>

#include <optional>
#include <string_view>
#include <utility>

#include "base/containers/fixed_flat_map.h"
#include "base/containers/fixed_flat_set.h"
#include "base/strings/string_slice.h"
#include "third_party/blink/renderer/core/html/html_permission_element_strings_map.h"
#include "third_party/blink/public/strings/grit/permission_element_generated_strings.h"
#include "third_party/blink/public/strings/grit/permission_element_strings.h"

namespace blink {

namespace {

static constexpr char kLanguages[] =
    "vidasr-latnes-419fr-capt-brzh-hkzh-twfilafamarazbebgbnbscscydeleneteuglguhihrhuhyisitiwjakakkmknkokyloltlvmlmnmrmsmynlnorpaplroruskslsqsvswtathtrukuruzu";


using LangStringSlice = base::subtle::StringSlice<sizeof(kLanguages), kLanguages>;

// In C++20, pairs required exactly-matching types to be comparable, i.e.
// std::pair<T1, T2> cannot be compared against std::pair<U1, U2>, even if T1
// and T2 are comparable against U1 and U2. This was addressed in C++23 in
// https://cplusplus.github.io/LWG/issue3865. However, older versions of
// libstdc++ do not support this, so the lookup needs to be wrapped with a
// type that is heterogeneously comparable with the key pair type...
struct LookupHelper {
  std::string_view lang;
  uint16_t id;

  // The style guide requires operator== to be defined if operator<=> is
  // defined. However, operator== is never actually used, which causes a
  // compiler warning. Explicitly delete it instead... if it's ever needed,
  // the build will start failing.
  friend constexpr bool operator==(LookupHelper lhs,
                                   std::pair<LangStringSlice, uint16_t> rhs) = delete;
  friend constexpr auto operator<=>(LookupHelper lhs,
                                    std::pair<LangStringSlice, uint16_t> rhs) {
    return lhs.lang != rhs.first ?  lhs.lang <=> rhs.first : lhs.id <=> rhs.second;
  }
};

}  // namespace

std::optional<uint16_t> GetPermissionElementMessageId(
    std::string_view language_code,
    uint16_t base_message) {
  static constexpr auto kMessageIds =
      base::MakeFixedFlatMap<std::pair<LangStringSlice, uint16_t>, uint16_t>({
        {{{40, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_af},
        {{{40, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_af},
        {{{42, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_am},
        {{{42, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_am},
        {{{44, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ar},
        {{{44, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ar},
        {{{3, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_as},
        {{{3, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_as},
        {{{46, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_az},
        {{{46, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_az},
        {{{48, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_be},
        {{{48, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_be},
        {{{50, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_bg},
        {{{50, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_bg},
        {{{52, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_bn},
        {{{52, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_bn},
        {{{54, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_bs},
        {{{54, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_bs},
        {{{20, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ca},
        {{{20, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ca},
        {{{56, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_cs},
        {{{56, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_cs},
        {{{58, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_cy},
        {{{58, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_cy},
        {{{2, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_da},
        {{{2, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_da},
        {{{60, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_de},
        {{{60, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_de},
        {{{61, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_el},
        {{{61, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_el},
        {{{63, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_en_GB},
        {{{63, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_en_GB},
        {{{11, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_es},
        {{{11, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_es},
        {{{11, 6}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_es_419},
        {{{11, 6}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_es_419},
        {{{65, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_et},
        {{{65, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_et},
        {{{67, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_eu},
        {{{67, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_eu},
        {{{41, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_fa},
        {{{41, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_fa},
        {{{37, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_fi},
        {{{37, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_fi},
        {{{37, 3}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_fil},
        {{{37, 3}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_fil},
        {{{17, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_fr},
        {{{17, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_fr},
        {{{17, 5}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_fr_CA},
        {{{17, 5}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_fr_CA},
        {{{69, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_gl},
        {{{69, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_gl},
        {{{71, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_gu},
        {{{71, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_gu},
        {{{73, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_hi},
        {{{73, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_hi},
        {{{75, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_hr},
        {{{75, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_hr},
        {{{77, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_hu},
        {{{77, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_hu},
        {{{79, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_hy},
        {{{79, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_hy},
        {{{1, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_id},
        {{{1, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_id},
        {{{81, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_is},
        {{{81, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_is},
        {{{83, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_it},
        {{{83, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_it},
        {{{85, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_iw},
        {{{85, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_iw},
        {{{87, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ja},
        {{{87, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ja},
        {{{89, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ka},
        {{{89, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ka},
        {{{91, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_kk},
        {{{91, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_kk},
        {{{92, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_km},
        {{{92, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_km},
        {{{94, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_kn},
        {{{94, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_kn},
        {{{96, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ko},
        {{{96, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ko},
        {{{98, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ky},
        {{{98, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ky},
        {{{100, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_lo},
        {{{100, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_lo},
        {{{102, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_lt},
        {{{102, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_lt},
        {{{104, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_lv},
        {{{104, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_lv},
        {{{93, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_mk},
        {{{93, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_mk},
        {{{106, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ml},
        {{{106, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ml},
        {{{108, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_mn},
        {{{108, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_mn},
        {{{110, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_mr},
        {{{110, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_mr},
        {{{112, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ms},
        {{{112, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ms},
        {{{114, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_my},
        {{{114, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_my},
        {{{10, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ne},
        {{{10, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ne},
        {{{116, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_nl},
        {{{116, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_nl},
        {{{118, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_no},
        {{{118, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_no},
        {{{119, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_or},
        {{{119, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_or},
        {{{121, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_pa},
        {{{121, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_pa},
        {{{123, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_pl},
        {{{123, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_pl},
        {{{22, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_pt_PT},
        {{{22, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_pt_PT},
        {{{22, 5}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_pt_BR},
        {{{22, 5}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_pt_BR},
        {{{125, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ro},
        {{{125, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ro},
        {{{127, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ru},
        {{{127, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ru},
        {{{82, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_si},
        {{{82, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_si},
        {{{129, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sk},
        {{{129, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sk},
        {{{131, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sl},
        {{{131, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sl},
        {{{133, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sq},
        {{{133, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sq},
        {{{4, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sr},
        {{{4, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sr},
        {{{4, 7}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sr_Latn},
        {{{4, 7}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sr_Latn},
        {{{135, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sv},
        {{{135, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sv},
        {{{137, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_sw},
        {{{137, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_sw},
        {{{139, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ta},
        {{{139, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ta},
        {{{66, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_te},
        {{{66, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_te},
        {{{141, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_th},
        {{{141, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_th},
        {{{143, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_tr},
        {{{143, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_tr},
        {{{145, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_uk},
        {{{145, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_uk},
        {{{147, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_ur},
        {{{147, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_ur},
        {{{149, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_uz},
        {{{149, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_uz},
        {{{0, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_vi},
        {{{0, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_vi},
        {{{27, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_zh_CN},
        {{{27, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_zh_CN},
        {{{27, 5}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_zh_HK},
        {{{27, 5}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_zh_HK},
        {{{32, 5}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_zh_TW},
        {{{32, 5}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_zh_TW},
        {{{150, 2}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_CAMERA}, IDS_PERMISSION_REQUEST_CAMERA_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_MICROPHONE}, IDS_PERMISSION_REQUEST_MICROPHONE_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_GEOLOCATION}, IDS_PERMISSION_REQUEST_GEOLOCATION_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE}, IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION}, IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_USING_LOCATION}, IDS_PERMISSION_REQUEST_USING_LOCATION_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_INSTALL}, IDS_PERMISSION_REQUEST_INSTALL_zu},
        {{{150, 2}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST}, IDS_PERMISSION_REQUEST_INSTALL_WITH_HOST_zu},

      });

  auto message = kMessageIds.find(
      LookupHelper{language_code, static_cast<uint16_t>(base_message)});
  return message == kMessageIds.end()
      ? std::nullopt
      : std::optional(message->second);
}

}  // namespace blink
