// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_

#include <stddef.h>

#include "base/check_op.h"
#include "third_party/blink/public/mojom/use_counter/metrics/css_property_id.mojom-blink-forward.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/allocator/allocator.h"
#include "third_party/blink/renderer/platform/wtf/forward.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/hash_traits.h"

namespace blink {

class ExecutionContext;

enum class CSSPropertyID {
    kInvalid = 0,
    kVariable = 1,
    kColorScheme = 2,
    kForcedColorAdjust = 3,
    kMaskImage = 4,
    kMathDepth = 5,
    kPosition = 6,
    kPositionAnchor = 7,
    kTextSizeAdjust = 8,
    kInternalVisitedColor = 9,
    kAppearance = 10,
    kColor = 11,
    kDirection = 12,
    kFontFamily = 13,
    kFontFeatureSettings = 14,
    kFontKerning = 15,
    kFontLanguageOverride = 16,
    kFontOpticalSizing = 17,
    kFontPalette = 18,
    kFontSize = 19,
    kFontSizeAdjust = 20,
    kFontStretch = 21,
    kFontStyle = 22,
    kFontSynthesisSmallCaps = 23,
    kFontSynthesisStyle = 24,
    kFontSynthesisWeight = 25,
    kFontVariantAlternates = 26,
    kFontVariantCaps = 27,
    kFontVariantEastAsian = 28,
    kFontVariantEmoji = 29,
    kFontVariantLigatures = 30,
    kFontVariantNumeric = 31,
    kFontVariantPosition = 32,
    kFontVariationSettings = 33,
    kFontWeight = 34,
    kPositionArea = 35,
    kTextOrientation = 36,
    kTextRendering = 37,
    kTextSpacingTrim = 38,
    kWebkitFontSmoothing = 39,
    kWebkitLocale = 40,
    kWebkitTextOrientation = 41,
    kWebkitWritingMode = 42,
    kWritingMode = 43,
    kZoom = 44,
    kInternalForcedVisitedColor = 45,
    kInternalVisitedBackgroundColor = 46,
    kInternalVisitedBorderBlockEndColor = 47,
    kInternalVisitedBorderBlockStartColor = 48,
    kInternalVisitedBorderBottomColor = 49,
    kInternalVisitedBorderInlineEndColor = 50,
    kInternalVisitedBorderInlineStartColor = 51,
    kInternalVisitedBorderLeftColor = 52,
    kInternalVisitedBorderRightColor = 53,
    kInternalVisitedBorderTopColor = 54,
    kInternalVisitedCaretColor = 55,
    kInternalVisitedColumnRuleColor = 56,
    kInternalVisitedFill = 57,
    kInternalVisitedOutlineColor = 58,
    kInternalVisitedStroke = 59,
    kInternalVisitedTextDecorationColor = 60,
    kInternalVisitedTextEmphasisColor = 61,
    kInternalVisitedTextFillColor = 62,
    kInternalVisitedTextStrokeColor = 63,
    kAccentColor = 64,
    kAdditiveSymbols = 65,
    kAlignContent = 66,
    kAlignItems = 67,
    kAlignSelf = 68,
    kAlignmentBaseline = 69,
    kAll = 70,
    kAnchorName = 71,
    kAnchorScope = 72,
    kAnimationComposition = 73,
    kAnimationDelay = 74,
    kAnimationDirection = 75,
    kAnimationDuration = 76,
    kAnimationFillMode = 77,
    kAnimationIterationCount = 78,
    kAnimationName = 79,
    kAnimationPlayState = 80,
    kAnimationRangeEnd = 81,
    kAnimationRangeStart = 82,
    kAnimationTimeline = 83,
    kAnimationTimingFunction = 84,
    kAnimationTrigger = 85,
    kAppRegion = 86,
    kAscentOverride = 87,
    kAspectRatio = 88,
    kBackdropFilter = 89,
    kBackfaceVisibility = 90,
    kBackgroundAttachment = 91,
    kBackgroundBlendMode = 92,
    kBackgroundClip = 93,
    kBackgroundColor = 94,
    kBackgroundImage = 95,
    kBackgroundOrigin = 96,
    kBackgroundPositionX = 97,
    kBackgroundPositionY = 98,
    kBackgroundRepeat = 99,
    kBackgroundSize = 100,
    kBasePalette = 101,
    kBaselineShift = 102,
    kBaselineSource = 103,
    kBlockEllipsis = 104,
    kBlockSize = 105,
    kBorderBlockEndColor = 106,
    kBorderBlockEndStyle = 107,
    kBorderBlockEndWidth = 108,
    kBorderBlockStartColor = 109,
    kBorderBlockStartStyle = 110,
    kBorderBlockStartWidth = 111,
    kBorderBottomColor = 112,
    kBorderBottomLeftRadius = 113,
    kBorderBottomRightRadius = 114,
    kBorderBottomStyle = 115,
    kBorderBottomWidth = 116,
    kBorderCollapse = 117,
    kBorderEndEndRadius = 118,
    kBorderEndStartRadius = 119,
    kBorderImageOutset = 120,
    kBorderImageRepeat = 121,
    kBorderImageSlice = 122,
    kBorderImageSource = 123,
    kBorderImageWidth = 124,
    kBorderInlineEndColor = 125,
    kBorderInlineEndStyle = 126,
    kBorderInlineEndWidth = 127,
    kBorderInlineStartColor = 128,
    kBorderInlineStartStyle = 129,
    kBorderInlineStartWidth = 130,
    kBorderLeftColor = 131,
    kBorderLeftStyle = 132,
    kBorderLeftWidth = 133,
    kBorderRightColor = 134,
    kBorderRightStyle = 135,
    kBorderRightWidth = 136,
    kBorderShape = 137,
    kBorderStartEndRadius = 138,
    kBorderStartStartRadius = 139,
    kBorderTopColor = 140,
    kBorderTopLeftRadius = 141,
    kBorderTopRightRadius = 142,
    kBorderTopStyle = 143,
    kBorderTopWidth = 144,
    kBottom = 145,
    kBoxDecorationBreak = 146,
    kBoxShadow = 147,
    kBoxSizing = 148,
    kBreakAfter = 149,
    kBreakBefore = 150,
    kBreakInside = 151,
    kBufferedRendering = 152,
    kCaptionSide = 153,
    kCaretAnimation = 154,
    kCaretColor = 155,
    kCaretShape = 156,
    kClear = 157,
    kClip = 158,
    kClipPath = 159,
    kClipRule = 160,
    kColorInterpolation = 161,
    kColorInterpolationFilters = 162,
    kColorRendering = 163,
    kColumnCount = 164,
    kColumnFill = 165,
    kColumnGap = 166,
    kColumnHeight = 167,
    kColumnRuleBreak = 168,
    kColumnRuleColor = 169,
    kColumnRuleEdgeEndInset = 170,
    kColumnRuleEdgeStartInset = 171,
    kColumnRuleInteriorEndInset = 172,
    kColumnRuleInteriorStartInset = 173,
    kColumnRuleStyle = 174,
    kColumnRuleVisibilityItems = 175,
    kColumnRuleWidth = 176,
    kColumnSpan = 177,
    kColumnWidth = 178,
    kColumnWrap = 179,
    kContain = 180,
    kContainIntrinsicBlockSize = 181,
    kContainIntrinsicHeight = 182,
    kContainIntrinsicInlineSize = 183,
    kContainIntrinsicWidth = 184,
    kContainerName = 185,
    kContainerType = 186,
    kContent = 187,
    kContentVisibility = 188,
    kContinue = 189,
    kCornerBottomLeftShape = 190,
    kCornerBottomRightShape = 191,
    kCornerEndEndShape = 192,
    kCornerEndStartShape = 193,
    kCornerStartEndShape = 194,
    kCornerStartStartShape = 195,
    kCornerTopLeftShape = 196,
    kCornerTopRightShape = 197,
    kCounterIncrement = 198,
    kCounterReset = 199,
    kCounterSet = 200,
    kCursor = 201,
    kCx = 202,
    kCy = 203,
    kD = 204,
    kDescentOverride = 205,
    kDisplay = 206,
    kDominantBaseline = 207,
    kDynamicRangeLimit = 208,
    kEmptyCells = 209,
    kFallback = 210,
    kFieldSizing = 211,
    kFill = 212,
    kFillOpacity = 213,
    kFillRule = 214,
    kFilter = 215,
    kFlexBasis = 216,
    kFlexDirection = 217,
    kFlexGrow = 218,
    kFlexShrink = 219,
    kFlexWrap = 220,
    kFloat = 221,
    kFloodColor = 222,
    kFloodOpacity = 223,
    kFontDisplay = 224,
    kGapRuleOverlap = 225,
    kGridAutoColumns = 226,
    kGridAutoFlow = 227,
    kGridAutoRows = 228,
    kGridColumnEnd = 229,
    kGridColumnStart = 230,
    kGridLanesDirection = 231,
    kGridLanesFill = 232,
    kGridRowEnd = 233,
    kGridRowStart = 234,
    kGridTemplateAreas = 235,
    kGridTemplateColumns = 236,
    kGridTemplateRows = 237,
    kHeight = 238,
    kHyphenateCharacter = 239,
    kHyphenateLimitChars = 240,
    kHyphens = 241,
    kImageOrientation = 242,
    kImageRendering = 243,
    kInherits = 244,
    kInitialLetter = 245,
    kInitialValue = 246,
    kInlineSize = 247,
    kInsetBlockEnd = 248,
    kInsetBlockStart = 249,
    kInsetInlineEnd = 250,
    kInsetInlineStart = 251,
    kInteractivity = 252,
    kInterestDelayEnd = 253,
    kInterestDelayStart = 254,
    kInternalAlignContentBlock = 255,
    kInternalEmptyLineHeight = 256,
    kInternalFontSizeDelta = 257,
    kInternalForcedBackgroundColor = 258,
    kInternalForcedBorderColor = 259,
    kInternalForcedColor = 260,
    kInternalForcedOutlineColor = 261,
    kInterpolateSize = 262,
    kIsolation = 263,
    kItemTolerance = 264,
    kJustifyContent = 265,
    kJustifyItems = 266,
    kJustifySelf = 267,
    kLeft = 268,
    kLetterSpacing = 269,
    kLightingColor = 270,
    kLineBreak = 271,
    kLineGapOverride = 272,
    kLineHeight = 273,
    kListStyleImage = 274,
    kListStylePosition = 275,
    kListStyleType = 276,
    kMarginBlockEnd = 277,
    kMarginBlockStart = 278,
    kMarginBottom = 279,
    kMarginInlineEnd = 280,
    kMarginInlineStart = 281,
    kMarginLeft = 282,
    kMarginRight = 283,
    kMarginTop = 284,
    kMarkerEnd = 285,
    kMarkerMid = 286,
    kMarkerStart = 287,
    kMaskClip = 288,
    kMaskComposite = 289,
    kMaskMode = 290,
    kMaskOrigin = 291,
    kMaskRepeat = 292,
    kMaskSize = 293,
    kMaskType = 294,
    kMathShift = 295,
    kMathStyle = 296,
    kMaxBlockSize = 297,
    kMaxHeight = 298,
    kMaxInlineSize = 299,
    kMaxLines = 300,
    kMaxWidth = 301,
    kMinBlockSize = 302,
    kMinHeight = 303,
    kMinInlineSize = 304,
    kMinWidth = 305,
    kMixBlendMode = 306,
    kNavigation = 307,
    kNegative = 308,
    kObjectFit = 309,
    kObjectPosition = 310,
    kObjectViewBox = 311,
    kOffsetAnchor = 312,
    kOffsetDistance = 313,
    kOffsetPath = 314,
    kOffsetPosition = 315,
    kOffsetRotate = 316,
    kOpacity = 317,
    kOrder = 318,
    kOriginTrialTestProperty = 319,
    kOrphans = 320,
    kOutlineColor = 321,
    kOutlineOffset = 322,
    kOutlineStyle = 323,
    kOutlineWidth = 324,
    kOverflowAnchor = 325,
    kOverflowBlock = 326,
    kOverflowClipMargin = 327,
    kOverflowInline = 328,
    kOverflowWrap = 329,
    kOverflowX = 330,
    kOverflowY = 331,
    kOverlay = 332,
    kOverrideColors = 333,
    kOverscrollArea = 334,
    kOverscrollBehaviorBlock = 335,
    kOverscrollBehaviorInline = 336,
    kOverscrollBehaviorX = 337,
    kOverscrollBehaviorY = 338,
    kOverscrollPosition = 339,
    kPad = 340,
    kPaddingBlockEnd = 341,
    kPaddingBlockStart = 342,
    kPaddingBottom = 343,
    kPaddingInlineEnd = 344,
    kPaddingInlineStart = 345,
    kPaddingLeft = 346,
    kPaddingRight = 347,
    kPaddingTop = 348,
    kPage = 349,
    kPageOrientation = 350,
    kPaintOrder = 351,
    kPerspective = 352,
    kPerspectiveOrigin = 353,
    kPointerEvents = 354,
    kPositionTryFallbacks = 355,
    kPositionTryOrder = 356,
    kPositionVisibility = 357,
    kPrefix = 358,
    kPrintColorAdjust = 359,
    kQuotes = 360,
    kR = 361,
    kRange = 362,
    kReadingFlow = 363,
    kReadingOrder = 364,
    kResize = 365,
    kResult = 366,
    kRight = 367,
    kRotate = 368,
    kRowGap = 369,
    kRowRuleBreak = 370,
    kRowRuleColor = 371,
    kRowRuleEdgeEndInset = 372,
    kRowRuleEdgeStartInset = 373,
    kRowRuleInteriorEndInset = 374,
    kRowRuleInteriorStartInset = 375,
    kRowRuleStyle = 376,
    kRowRuleVisibilityItems = 377,
    kRowRuleWidth = 378,
    kRubyAlign = 379,
    kRubyOverhang = 380,
    kRubyPosition = 381,
    kRx = 382,
    kRy = 383,
    kScale = 384,
    kScrollBehavior = 385,
    kScrollInitialTarget = 386,
    kScrollMarginBlockEnd = 387,
    kScrollMarginBlockStart = 388,
    kScrollMarginBottom = 389,
    kScrollMarginInlineEnd = 390,
    kScrollMarginInlineStart = 391,
    kScrollMarginLeft = 392,
    kScrollMarginRight = 393,
    kScrollMarginTop = 394,
    kScrollMarkerGroup = 395,
    kScrollPaddingBlockEnd = 396,
    kScrollPaddingBlockStart = 397,
    kScrollPaddingBottom = 398,
    kScrollPaddingInlineEnd = 399,
    kScrollPaddingInlineStart = 400,
    kScrollPaddingLeft = 401,
    kScrollPaddingRight = 402,
    kScrollPaddingTop = 403,
    kScrollSnapAlign = 404,
    kScrollSnapStop = 405,
    kScrollSnapType = 406,
    kScrollTargetGroup = 407,
    kScrollTimelineAxis = 408,
    kScrollTimelineName = 409,
    kScrollbarColor = 410,
    kScrollbarGutter = 411,
    kScrollbarWidth = 412,
    kShapeImageThreshold = 413,
    kShapeMargin = 414,
    kShapeOutside = 415,
    kShapeRendering = 416,
    kSize = 417,
    kSizeAdjust = 418,
    kSpeak = 419,
    kSpeakAs = 420,
    kSrc = 421,
    kStopColor = 422,
    kStopOpacity = 423,
    kStroke = 424,
    kStrokeDasharray = 425,
    kStrokeDashoffset = 426,
    kStrokeLinecap = 427,
    kStrokeLinejoin = 428,
    kStrokeMiterlimit = 429,
    kStrokeOpacity = 430,
    kStrokeWidth = 431,
    kSuffix = 432,
    kSymbols = 433,
    kSyntax = 434,
    kSystem = 435,
    kTabSize = 436,
    kTableLayout = 437,
    kTextAlign = 438,
    kTextAlignLast = 439,
    kTextAnchor = 440,
    kTextAutospace = 441,
    kTextBoxEdge = 442,
    kTextBoxTrim = 443,
    kTextCombineUpright = 444,
    kTextDecorationColor = 445,
    kTextDecorationLine = 446,
    kTextDecorationSkipInk = 447,
    kTextDecorationStyle = 448,
    kTextDecorationThickness = 449,
    kTextEmphasisColor = 450,
    kTextEmphasisPosition = 451,
    kTextEmphasisStyle = 452,
    kTextGrow = 453,
    kTextIndent = 454,
    kTextJustify = 455,
    kTextOverflow = 456,
    kTextShadow = 457,
    kTextShrink = 458,
    kTextTransform = 459,
    kTextUnderlineOffset = 460,
    kTextUnderlinePosition = 461,
    kTextWrapMode = 462,
    kTextWrapStyle = 463,
    kTimelineScope = 464,
    kTimelineTriggerExitRangeEnd = 465,
    kTimelineTriggerExitRangeStart = 466,
    kTimelineTriggerName = 467,
    kTimelineTriggerRangeEnd = 468,
    kTimelineTriggerRangeStart = 469,
    kTimelineTriggerSource = 470,
    kTop = 471,
    kTouchAction = 472,
    kTransform = 473,
    kTransformBox = 474,
    kTransformOrigin = 475,
    kTransformStyle = 476,
    kTransitionBehavior = 477,
    kTransitionDelay = 478,
    kTransitionDuration = 479,
    kTransitionProperty = 480,
    kTransitionTimingFunction = 481,
    kTranslate = 482,
    kTypes = 483,
    kUnicodeBidi = 484,
    kUnicodeRange = 485,
    kUserSelect = 486,
    kVectorEffect = 487,
    kVerticalAlign = 488,
    kViewTimelineAxis = 489,
    kViewTimelineInset = 490,
    kViewTimelineName = 491,
    kViewTransitionClass = 492,
    kViewTransitionGroup = 493,
    kViewTransitionName = 494,
    kVisibility = 495,
    kWebkitBorderHorizontalSpacing = 496,
    kWebkitBorderImage = 497,
    kWebkitBorderVerticalSpacing = 498,
    kWebkitBoxAlign = 499,
    kWebkitBoxDecorationBreak = 500,
    kWebkitBoxDirection = 501,
    kWebkitBoxFlex = 502,
    kWebkitBoxOrdinalGroup = 503,
    kWebkitBoxOrient = 504,
    kWebkitBoxPack = 505,
    kWebkitBoxReflect = 506,
    kWebkitLineBreak = 507,
    kWebkitLineClamp = 508,
    kWebkitMaskBoxImageOutset = 509,
    kWebkitMaskBoxImageRepeat = 510,
    kWebkitMaskBoxImageSlice = 511,
    kWebkitMaskBoxImageSource = 512,
    kWebkitMaskBoxImageWidth = 513,
    kWebkitMaskPositionX = 514,
    kWebkitMaskPositionY = 515,
    kWebkitPerspectiveOriginX = 516,
    kWebkitPerspectiveOriginY = 517,
    kWebkitRtlOrdering = 518,
    kWebkitRubyPosition = 519,
    kWebkitTapHighlightColor = 520,
    kWebkitTextCombine = 521,
    kWebkitTextDecorationsInEffect = 522,
    kWebkitTextFillColor = 523,
    kWebkitTextSecurity = 524,
    kWebkitTextStrokeColor = 525,
    kWebkitTextStrokeWidth = 526,
    kWebkitTransformOriginX = 527,
    kWebkitTransformOriginY = 528,
    kWebkitTransformOriginZ = 529,
    kWebkitUserDrag = 530,
    kWebkitUserModify = 531,
    kWhiteSpaceCollapse = 532,
    kWidows = 533,
    kWidth = 534,
    kWillChange = 535,
    kWordBreak = 536,
    kWordSpacing = 537,
    kX = 538,
    kY = 539,
    kZIndex = 540,
    kAlternativeWebkitLineClamp = 541,
    kAnimation = 542,
    kAnimationRange = 543,
    kBackground = 544,
    kBackgroundPosition = 545,
    kBorder = 546,
    kBorderBlock = 547,
    kBorderBlockColor = 548,
    kBorderBlockEnd = 549,
    kBorderBlockStart = 550,
    kBorderBlockStyle = 551,
    kBorderBlockWidth = 552,
    kBorderBottom = 553,
    kBorderColor = 554,
    kBorderImage = 555,
    kBorderInline = 556,
    kBorderInlineColor = 557,
    kBorderInlineEnd = 558,
    kBorderInlineStart = 559,
    kBorderInlineStyle = 560,
    kBorderInlineWidth = 561,
    kBorderLeft = 562,
    kBorderRadius = 563,
    kBorderRight = 564,
    kBorderSpacing = 565,
    kBorderStyle = 566,
    kBorderTop = 567,
    kBorderWidth = 568,
    kColumnRule = 569,
    kColumnRuleInset = 570,
    kColumns = 571,
    kContainIntrinsicSize = 572,
    kContainer = 573,
    kCornerBlockEndShape = 574,
    kCornerBlockStartShape = 575,
    kCornerBottomShape = 576,
    kCornerInlineEndShape = 577,
    kCornerInlineStartShape = 578,
    kCornerLeftShape = 579,
    kCornerRightShape = 580,
    kCornerShape = 581,
    kCornerTopShape = 582,
    kCorners = 583,
    kFlex = 584,
    kFlexFlow = 585,
    kFont = 586,
    kFontSynthesis = 587,
    kFontVariant = 588,
    kGap = 589,
    kGrid = 590,
    kGridArea = 591,
    kGridColumn = 592,
    kGridLanes = 593,
    kGridLanesFlow = 594,
    kGridRow = 595,
    kGridTemplate = 596,
    kInset = 597,
    kInsetBlock = 598,
    kInsetInline = 599,
    kInterestDelay = 600,
    kLineClamp = 601,
    kListStyle = 602,
    kMargin = 603,
    kMarginBlock = 604,
    kMarginInline = 605,
    kMarker = 606,
    kMask = 607,
    kMaskPosition = 608,
    kOffset = 609,
    kOutline = 610,
    kOverflow = 611,
    kOverscrollBehavior = 612,
    kPadding = 613,
    kPaddingBlock = 614,
    kPaddingInline = 615,
    kPageBreakAfter = 616,
    kPageBreakBefore = 617,
    kPageBreakInside = 618,
    kPlaceContent = 619,
    kPlaceItems = 620,
    kPlaceSelf = 621,
    kPositionTry = 622,
    kRowRule = 623,
    kRowRuleInset = 624,
    kRule = 625,
    kRuleBreak = 626,
    kRuleColor = 627,
    kRuleInset = 628,
    kRuleStyle = 629,
    kRuleWidth = 630,
    kScrollMargin = 631,
    kScrollMarginBlock = 632,
    kScrollMarginInline = 633,
    kScrollPadding = 634,
    kScrollPaddingBlock = 635,
    kScrollPaddingInline = 636,
    kScrollTimeline = 637,
    kTextBox = 638,
    kTextDecoration = 639,
    kTextEmphasis = 640,
    kTextSpacing = 641,
    kTextWrap = 642,
    kTimelineTrigger = 643,
    kTimelineTriggerExitRange = 644,
    kTimelineTriggerRange = 645,
    kTransition = 646,
    kViewTimeline = 647,
    kWebkitColumnBreakAfter = 648,
    kWebkitColumnBreakBefore = 649,
    kWebkitColumnBreakInside = 650,
    kWebkitMaskBoxImage = 651,
    kWebkitTextStroke = 652,
    kWhiteSpace = 653,
    kAliasWebkitAppearance = 654,
    kAliasWebkitAppRegion = 655,
    kAliasWebkitMaskClip = 656,
    kAliasWebkitMaskComposite = 657,
    kAliasWebkitMaskImage = 658,
    kAliasWebkitMaskOrigin = 659,
    kAliasWebkitMaskRepeat = 660,
    kAliasWebkitMaskSize = 661,
    kAliasWebkitBorderEndColor = 662,
    kAliasWebkitBorderEndStyle = 663,
    kAliasWebkitBorderEndWidth = 664,
    kAliasWebkitBorderStartColor = 665,
    kAliasWebkitBorderStartStyle = 666,
    kAliasWebkitBorderStartWidth = 667,
    kAliasWebkitBorderBeforeColor = 668,
    kAliasWebkitBorderBeforeStyle = 669,
    kAliasWebkitBorderBeforeWidth = 670,
    kAliasWebkitBorderAfterColor = 671,
    kAliasWebkitBorderAfterStyle = 672,
    kAliasWebkitBorderAfterWidth = 673,
    kAliasWebkitMarginEnd = 674,
    kAliasWebkitMarginStart = 675,
    kAliasWebkitMarginBefore = 676,
    kAliasWebkitMarginAfter = 677,
    kAliasWebkitPaddingEnd = 678,
    kAliasWebkitPaddingStart = 679,
    kAliasWebkitPaddingBefore = 680,
    kAliasWebkitPaddingAfter = 681,
    kAliasWebkitLogicalWidth = 682,
    kAliasWebkitLogicalHeight = 683,
    kAliasWebkitMinLogicalWidth = 684,
    kAliasWebkitMinLogicalHeight = 685,
    kAliasWebkitMaxLogicalWidth = 686,
    kAliasWebkitMaxLogicalHeight = 687,
    kAliasWebkitPrintColorAdjust = 688,
    kAliasWebkitBorderAfter = 689,
    kAliasWebkitBorderBefore = 690,
    kAliasWebkitBorderEnd = 691,
    kAliasWebkitBorderStart = 692,
    kAliasWebkitMask = 693,
    kAliasWebkitMaskPosition = 694,
    kAliasEpubCaptionSide = 695,
    kAliasEpubTextCombine = 696,
    kAliasEpubTextEmphasis = 697,
    kAliasEpubTextEmphasisColor = 698,
    kAliasEpubTextEmphasisStyle = 699,
    kAliasEpubTextOrientation = 700,
    kAliasEpubTextTransform = 701,
    kAliasEpubWordBreak = 702,
    kAliasEpubWritingMode = 703,
    kAliasWebkitAlignContent = 704,
    kAliasWebkitAlignItems = 705,
    kAliasWebkitAlignSelf = 706,
    kAliasWebkitAnimation = 707,
    kAliasWebkitAnimationDelay = 708,
    kAliasWebkitAnimationDirection = 709,
    kAliasWebkitAnimationDuration = 710,
    kAliasWebkitAnimationFillMode = 711,
    kAliasWebkitAnimationIterationCount = 712,
    kAliasWebkitAnimationName = 713,
    kAliasWebkitAnimationPlayState = 714,
    kAliasWebkitAnimationTimingFunction = 715,
    kAliasWebkitBackfaceVisibility = 716,
    kAliasWebkitBackgroundClip = 717,
    kAliasWebkitBackgroundOrigin = 718,
    kAliasWebkitBackgroundSize = 719,
    kAliasWebkitBorderBottomLeftRadius = 720,
    kAliasWebkitBorderBottomRightRadius = 721,
    kAliasWebkitBorderRadius = 722,
    kAliasWebkitBorderTopLeftRadius = 723,
    kAliasWebkitBorderTopRightRadius = 724,
    kAliasWebkitBoxShadow = 725,
    kAliasWebkitBoxSizing = 726,
    kAliasWebkitClipPath = 727,
    kAliasWebkitColumnCount = 728,
    kAliasWebkitColumnGap = 729,
    kAliasWebkitColumnRule = 730,
    kAliasWebkitColumnRuleColor = 731,
    kAliasWebkitColumnRuleStyle = 732,
    kAliasWebkitColumnRuleWidth = 733,
    kAliasWebkitColumnSpan = 734,
    kAliasWebkitColumnWidth = 735,
    kAliasWebkitColumns = 736,
    kAliasWebkitFilter = 737,
    kAliasWebkitFlex = 738,
    kAliasWebkitFlexBasis = 739,
    kAliasWebkitFlexDirection = 740,
    kAliasWebkitFlexFlow = 741,
    kAliasWebkitFlexGrow = 742,
    kAliasWebkitFlexShrink = 743,
    kAliasWebkitFlexWrap = 744,
    kAliasWebkitFontFeatureSettings = 745,
    kAliasWebkitHyphenateCharacter = 746,
    kAliasWebkitJustifyContent = 747,
    kAliasWebkitOpacity = 748,
    kAliasWebkitOrder = 749,
    kAliasWebkitPerspective = 750,
    kAliasWebkitPerspectiveOrigin = 751,
    kAliasWebkitShapeImageThreshold = 752,
    kAliasWebkitShapeMargin = 753,
    kAliasWebkitShapeOutside = 754,
    kAliasWebkitTextEmphasis = 755,
    kAliasWebkitTextEmphasisColor = 756,
    kAliasWebkitTextEmphasisPosition = 757,
    kAliasWebkitTextEmphasisStyle = 758,
    kAliasWebkitTextSizeAdjust = 759,
    kAliasWebkitTransform = 760,
    kAliasWebkitTransformOrigin = 761,
    kAliasWebkitTransformStyle = 762,
    kAliasWebkitTransition = 763,
    kAliasWebkitTransitionDelay = 764,
    kAliasWebkitTransitionDuration = 765,
    kAliasWebkitTransitionProperty = 766,
    kAliasWebkitTransitionTimingFunction = 767,
    kAliasWebkitUserSelect = 768,
    kAliasWordWrap = 769,
    kAliasGridColumnGap = 770,
    kAliasGridRowGap = 771,
    kAliasGridGap = 772,
};

const CSSPropertyID kCSSPropertyAliasList[] = {
    CSSPropertyID::kAliasWebkitAppearance,
    CSSPropertyID::kAliasWebkitAppRegion,
    CSSPropertyID::kAliasWebkitMaskClip,
    CSSPropertyID::kAliasWebkitMaskComposite,
    CSSPropertyID::kAliasWebkitMaskImage,
    CSSPropertyID::kAliasWebkitMaskOrigin,
    CSSPropertyID::kAliasWebkitMaskRepeat,
    CSSPropertyID::kAliasWebkitMaskSize,
    CSSPropertyID::kAliasWebkitBorderEndColor,
    CSSPropertyID::kAliasWebkitBorderEndStyle,
    CSSPropertyID::kAliasWebkitBorderEndWidth,
    CSSPropertyID::kAliasWebkitBorderStartColor,
    CSSPropertyID::kAliasWebkitBorderStartStyle,
    CSSPropertyID::kAliasWebkitBorderStartWidth,
    CSSPropertyID::kAliasWebkitBorderBeforeColor,
    CSSPropertyID::kAliasWebkitBorderBeforeStyle,
    CSSPropertyID::kAliasWebkitBorderBeforeWidth,
    CSSPropertyID::kAliasWebkitBorderAfterColor,
    CSSPropertyID::kAliasWebkitBorderAfterStyle,
    CSSPropertyID::kAliasWebkitBorderAfterWidth,
    CSSPropertyID::kAliasWebkitMarginEnd,
    CSSPropertyID::kAliasWebkitMarginStart,
    CSSPropertyID::kAliasWebkitMarginBefore,
    CSSPropertyID::kAliasWebkitMarginAfter,
    CSSPropertyID::kAliasWebkitPaddingEnd,
    CSSPropertyID::kAliasWebkitPaddingStart,
    CSSPropertyID::kAliasWebkitPaddingBefore,
    CSSPropertyID::kAliasWebkitPaddingAfter,
    CSSPropertyID::kAliasWebkitLogicalWidth,
    CSSPropertyID::kAliasWebkitLogicalHeight,
    CSSPropertyID::kAliasWebkitMinLogicalWidth,
    CSSPropertyID::kAliasWebkitMinLogicalHeight,
    CSSPropertyID::kAliasWebkitMaxLogicalWidth,
    CSSPropertyID::kAliasWebkitMaxLogicalHeight,
    CSSPropertyID::kAliasWebkitPrintColorAdjust,
    CSSPropertyID::kAliasWebkitBorderAfter,
    CSSPropertyID::kAliasWebkitBorderBefore,
    CSSPropertyID::kAliasWebkitBorderEnd,
    CSSPropertyID::kAliasWebkitBorderStart,
    CSSPropertyID::kAliasWebkitMask,
    CSSPropertyID::kAliasWebkitMaskPosition,
    CSSPropertyID::kAliasEpubCaptionSide,
    CSSPropertyID::kAliasEpubTextCombine,
    CSSPropertyID::kAliasEpubTextEmphasis,
    CSSPropertyID::kAliasEpubTextEmphasisColor,
    CSSPropertyID::kAliasEpubTextEmphasisStyle,
    CSSPropertyID::kAliasEpubTextOrientation,
    CSSPropertyID::kAliasEpubTextTransform,
    CSSPropertyID::kAliasEpubWordBreak,
    CSSPropertyID::kAliasEpubWritingMode,
    CSSPropertyID::kAliasWebkitAlignContent,
    CSSPropertyID::kAliasWebkitAlignItems,
    CSSPropertyID::kAliasWebkitAlignSelf,
    CSSPropertyID::kAliasWebkitAnimation,
    CSSPropertyID::kAliasWebkitAnimationDelay,
    CSSPropertyID::kAliasWebkitAnimationDirection,
    CSSPropertyID::kAliasWebkitAnimationDuration,
    CSSPropertyID::kAliasWebkitAnimationFillMode,
    CSSPropertyID::kAliasWebkitAnimationIterationCount,
    CSSPropertyID::kAliasWebkitAnimationName,
    CSSPropertyID::kAliasWebkitAnimationPlayState,
    CSSPropertyID::kAliasWebkitAnimationTimingFunction,
    CSSPropertyID::kAliasWebkitBackfaceVisibility,
    CSSPropertyID::kAliasWebkitBackgroundClip,
    CSSPropertyID::kAliasWebkitBackgroundOrigin,
    CSSPropertyID::kAliasWebkitBackgroundSize,
    CSSPropertyID::kAliasWebkitBorderBottomLeftRadius,
    CSSPropertyID::kAliasWebkitBorderBottomRightRadius,
    CSSPropertyID::kAliasWebkitBorderRadius,
    CSSPropertyID::kAliasWebkitBorderTopLeftRadius,
    CSSPropertyID::kAliasWebkitBorderTopRightRadius,
    CSSPropertyID::kAliasWebkitBoxShadow,
    CSSPropertyID::kAliasWebkitBoxSizing,
    CSSPropertyID::kAliasWebkitClipPath,
    CSSPropertyID::kAliasWebkitColumnCount,
    CSSPropertyID::kAliasWebkitColumnGap,
    CSSPropertyID::kAliasWebkitColumnRule,
    CSSPropertyID::kAliasWebkitColumnRuleColor,
    CSSPropertyID::kAliasWebkitColumnRuleStyle,
    CSSPropertyID::kAliasWebkitColumnRuleWidth,
    CSSPropertyID::kAliasWebkitColumnSpan,
    CSSPropertyID::kAliasWebkitColumnWidth,
    CSSPropertyID::kAliasWebkitColumns,
    CSSPropertyID::kAliasWebkitFilter,
    CSSPropertyID::kAliasWebkitFlex,
    CSSPropertyID::kAliasWebkitFlexBasis,
    CSSPropertyID::kAliasWebkitFlexDirection,
    CSSPropertyID::kAliasWebkitFlexFlow,
    CSSPropertyID::kAliasWebkitFlexGrow,
    CSSPropertyID::kAliasWebkitFlexShrink,
    CSSPropertyID::kAliasWebkitFlexWrap,
    CSSPropertyID::kAliasWebkitFontFeatureSettings,
    CSSPropertyID::kAliasWebkitHyphenateCharacter,
    CSSPropertyID::kAliasWebkitJustifyContent,
    CSSPropertyID::kAliasWebkitOpacity,
    CSSPropertyID::kAliasWebkitOrder,
    CSSPropertyID::kAliasWebkitPerspective,
    CSSPropertyID::kAliasWebkitPerspectiveOrigin,
    CSSPropertyID::kAliasWebkitShapeImageThreshold,
    CSSPropertyID::kAliasWebkitShapeMargin,
    CSSPropertyID::kAliasWebkitShapeOutside,
    CSSPropertyID::kAliasWebkitTextEmphasis,
    CSSPropertyID::kAliasWebkitTextEmphasisColor,
    CSSPropertyID::kAliasWebkitTextEmphasisPosition,
    CSSPropertyID::kAliasWebkitTextEmphasisStyle,
    CSSPropertyID::kAliasWebkitTextSizeAdjust,
    CSSPropertyID::kAliasWebkitTransform,
    CSSPropertyID::kAliasWebkitTransformOrigin,
    CSSPropertyID::kAliasWebkitTransformStyle,
    CSSPropertyID::kAliasWebkitTransition,
    CSSPropertyID::kAliasWebkitTransitionDelay,
    CSSPropertyID::kAliasWebkitTransitionDuration,
    CSSPropertyID::kAliasWebkitTransitionProperty,
    CSSPropertyID::kAliasWebkitTransitionTimingFunction,
    CSSPropertyID::kAliasWebkitUserSelect,
    CSSPropertyID::kAliasWordWrap,
    CSSPropertyID::kAliasGridColumnGap,
    CSSPropertyID::kAliasGridRowGap,
    CSSPropertyID::kAliasGridGap,
};

const CSSPropertyID kCSSComputableProperties[] = {
    CSSPropertyID::kAccentColor,
    CSSPropertyID::kAlignContent,
    CSSPropertyID::kAlignItems,
    CSSPropertyID::kAlignSelf,
    CSSPropertyID::kAlignmentBaseline,
    CSSPropertyID::kAnchorName,
    CSSPropertyID::kAnchorScope,
    CSSPropertyID::kAnimationComposition,
    CSSPropertyID::kAnimationDelay,
    CSSPropertyID::kAnimationDirection,
    CSSPropertyID::kAnimationDuration,
    CSSPropertyID::kAnimationFillMode,
    CSSPropertyID::kAnimationIterationCount,
    CSSPropertyID::kAnimationName,
    CSSPropertyID::kAnimationPlayState,
    CSSPropertyID::kAnimationRangeEnd,
    CSSPropertyID::kAnimationRangeStart,
    CSSPropertyID::kAnimationTimeline,
    CSSPropertyID::kAnimationTimingFunction,
    CSSPropertyID::kAnimationTrigger,
    CSSPropertyID::kAppRegion,
    CSSPropertyID::kAppearance,
    CSSPropertyID::kBackdropFilter,
    CSSPropertyID::kBackfaceVisibility,
    CSSPropertyID::kBackgroundAttachment,
    CSSPropertyID::kBackgroundBlendMode,
    CSSPropertyID::kBackgroundClip,
    CSSPropertyID::kBackgroundColor,
    CSSPropertyID::kBackgroundImage,
    CSSPropertyID::kBackgroundOrigin,
    CSSPropertyID::kBackgroundPosition,
    CSSPropertyID::kBackgroundRepeat,
    CSSPropertyID::kBackgroundSize,
    CSSPropertyID::kBaselineShift,
    CSSPropertyID::kBaselineSource,
    CSSPropertyID::kBlockEllipsis,
    CSSPropertyID::kBlockSize,
    CSSPropertyID::kBorderBlockEndColor,
    CSSPropertyID::kBorderBlockEndStyle,
    CSSPropertyID::kBorderBlockEndWidth,
    CSSPropertyID::kBorderBlockStartColor,
    CSSPropertyID::kBorderBlockStartStyle,
    CSSPropertyID::kBorderBlockStartWidth,
    CSSPropertyID::kBorderBottomColor,
    CSSPropertyID::kBorderBottomLeftRadius,
    CSSPropertyID::kBorderBottomRightRadius,
    CSSPropertyID::kBorderBottomStyle,
    CSSPropertyID::kBorderBottomWidth,
    CSSPropertyID::kBorderCollapse,
    CSSPropertyID::kBorderEndEndRadius,
    CSSPropertyID::kBorderEndStartRadius,
    CSSPropertyID::kBorderImageOutset,
    CSSPropertyID::kBorderImageRepeat,
    CSSPropertyID::kBorderImageSlice,
    CSSPropertyID::kBorderImageSource,
    CSSPropertyID::kBorderImageWidth,
    CSSPropertyID::kBorderInlineEndColor,
    CSSPropertyID::kBorderInlineEndStyle,
    CSSPropertyID::kBorderInlineEndWidth,
    CSSPropertyID::kBorderInlineStartColor,
    CSSPropertyID::kBorderInlineStartStyle,
    CSSPropertyID::kBorderInlineStartWidth,
    CSSPropertyID::kBorderLeftColor,
    CSSPropertyID::kBorderLeftStyle,
    CSSPropertyID::kBorderLeftWidth,
    CSSPropertyID::kBorderRightColor,
    CSSPropertyID::kBorderRightStyle,
    CSSPropertyID::kBorderRightWidth,
    CSSPropertyID::kBorderShape,
    CSSPropertyID::kBorderStartEndRadius,
    CSSPropertyID::kBorderStartStartRadius,
    CSSPropertyID::kBorderTopColor,
    CSSPropertyID::kBorderTopLeftRadius,
    CSSPropertyID::kBorderTopRightRadius,
    CSSPropertyID::kBorderTopStyle,
    CSSPropertyID::kBorderTopWidth,
    CSSPropertyID::kBottom,
    CSSPropertyID::kBoxDecorationBreak,
    CSSPropertyID::kBoxShadow,
    CSSPropertyID::kBoxSizing,
    CSSPropertyID::kBreakAfter,
    CSSPropertyID::kBreakBefore,
    CSSPropertyID::kBreakInside,
    CSSPropertyID::kBufferedRendering,
    CSSPropertyID::kCaptionSide,
    CSSPropertyID::kCaretAnimation,
    CSSPropertyID::kCaretColor,
    CSSPropertyID::kCaretShape,
    CSSPropertyID::kClear,
    CSSPropertyID::kClip,
    CSSPropertyID::kClipPath,
    CSSPropertyID::kClipRule,
    CSSPropertyID::kColor,
    CSSPropertyID::kColorInterpolation,
    CSSPropertyID::kColorInterpolationFilters,
    CSSPropertyID::kColorRendering,
    CSSPropertyID::kColumnCount,
    CSSPropertyID::kColumnGap,
    CSSPropertyID::kColumnHeight,
    CSSPropertyID::kColumnRuleBreak,
    CSSPropertyID::kColumnRuleColor,
    CSSPropertyID::kColumnRuleEdgeEndInset,
    CSSPropertyID::kColumnRuleEdgeStartInset,
    CSSPropertyID::kColumnRuleInteriorEndInset,
    CSSPropertyID::kColumnRuleInteriorStartInset,
    CSSPropertyID::kColumnRuleStyle,
    CSSPropertyID::kColumnRuleVisibilityItems,
    CSSPropertyID::kColumnRuleWidth,
    CSSPropertyID::kColumnSpan,
    CSSPropertyID::kColumnWidth,
    CSSPropertyID::kColumnWrap,
    CSSPropertyID::kContainIntrinsicBlockSize,
    CSSPropertyID::kContainIntrinsicHeight,
    CSSPropertyID::kContainIntrinsicInlineSize,
    CSSPropertyID::kContainIntrinsicSize,
    CSSPropertyID::kContainIntrinsicWidth,
    CSSPropertyID::kContainerName,
    CSSPropertyID::kContainerType,
    CSSPropertyID::kContent,
    CSSPropertyID::kContinue,
    CSSPropertyID::kCornerBottomLeftShape,
    CSSPropertyID::kCornerBottomRightShape,
    CSSPropertyID::kCornerEndEndShape,
    CSSPropertyID::kCornerEndStartShape,
    CSSPropertyID::kCornerStartEndShape,
    CSSPropertyID::kCornerStartStartShape,
    CSSPropertyID::kCornerTopLeftShape,
    CSSPropertyID::kCornerTopRightShape,
    CSSPropertyID::kCursor,
    CSSPropertyID::kCx,
    CSSPropertyID::kCy,
    CSSPropertyID::kD,
    CSSPropertyID::kDirection,
    CSSPropertyID::kDisplay,
    CSSPropertyID::kDominantBaseline,
    CSSPropertyID::kDynamicRangeLimit,
    CSSPropertyID::kEmptyCells,
    CSSPropertyID::kFieldSizing,
    CSSPropertyID::kFill,
    CSSPropertyID::kFillOpacity,
    CSSPropertyID::kFillRule,
    CSSPropertyID::kFilter,
    CSSPropertyID::kFlexBasis,
    CSSPropertyID::kFlexDirection,
    CSSPropertyID::kFlexGrow,
    CSSPropertyID::kFlexShrink,
    CSSPropertyID::kFlexWrap,
    CSSPropertyID::kFloat,
    CSSPropertyID::kFloodColor,
    CSSPropertyID::kFloodOpacity,
    CSSPropertyID::kFontFamily,
    CSSPropertyID::kFontKerning,
    CSSPropertyID::kFontLanguageOverride,
    CSSPropertyID::kFontOpticalSizing,
    CSSPropertyID::kFontPalette,
    CSSPropertyID::kFontSize,
    CSSPropertyID::kFontSizeAdjust,
    CSSPropertyID::kFontStretch,
    CSSPropertyID::kFontStyle,
    CSSPropertyID::kFontSynthesisSmallCaps,
    CSSPropertyID::kFontSynthesisStyle,
    CSSPropertyID::kFontSynthesisWeight,
    CSSPropertyID::kFontVariant,
    CSSPropertyID::kFontVariantAlternates,
    CSSPropertyID::kFontVariantCaps,
    CSSPropertyID::kFontVariantEastAsian,
    CSSPropertyID::kFontVariantEmoji,
    CSSPropertyID::kFontVariantLigatures,
    CSSPropertyID::kFontVariantNumeric,
    CSSPropertyID::kFontVariantPosition,
    CSSPropertyID::kFontWeight,
    CSSPropertyID::kGapRuleOverlap,
    CSSPropertyID::kGridAutoColumns,
    CSSPropertyID::kGridAutoFlow,
    CSSPropertyID::kGridAutoRows,
    CSSPropertyID::kGridColumnEnd,
    CSSPropertyID::kGridColumnStart,
    CSSPropertyID::kGridLanesDirection,
    CSSPropertyID::kGridLanesFill,
    CSSPropertyID::kGridRowEnd,
    CSSPropertyID::kGridRowStart,
    CSSPropertyID::kGridTemplateAreas,
    CSSPropertyID::kGridTemplateColumns,
    CSSPropertyID::kGridTemplateRows,
    CSSPropertyID::kHeight,
    CSSPropertyID::kHyphenateCharacter,
    CSSPropertyID::kHyphenateLimitChars,
    CSSPropertyID::kHyphens,
    CSSPropertyID::kImageOrientation,
    CSSPropertyID::kImageRendering,
    CSSPropertyID::kInitialLetter,
    CSSPropertyID::kInlineSize,
    CSSPropertyID::kInsetBlockEnd,
    CSSPropertyID::kInsetBlockStart,
    CSSPropertyID::kInsetInlineEnd,
    CSSPropertyID::kInsetInlineStart,
    CSSPropertyID::kInteractivity,
    CSSPropertyID::kInterestDelayEnd,
    CSSPropertyID::kInterestDelayStart,
    CSSPropertyID::kInterpolateSize,
    CSSPropertyID::kIsolation,
    CSSPropertyID::kItemTolerance,
    CSSPropertyID::kJustifyContent,
    CSSPropertyID::kJustifyItems,
    CSSPropertyID::kJustifySelf,
    CSSPropertyID::kLeft,
    CSSPropertyID::kLetterSpacing,
    CSSPropertyID::kLightingColor,
    CSSPropertyID::kLineBreak,
    CSSPropertyID::kLineHeight,
    CSSPropertyID::kListStyleImage,
    CSSPropertyID::kListStylePosition,
    CSSPropertyID::kListStyleType,
    CSSPropertyID::kMarginBlockEnd,
    CSSPropertyID::kMarginBlockStart,
    CSSPropertyID::kMarginBottom,
    CSSPropertyID::kMarginInlineEnd,
    CSSPropertyID::kMarginInlineStart,
    CSSPropertyID::kMarginLeft,
    CSSPropertyID::kMarginRight,
    CSSPropertyID::kMarginTop,
    CSSPropertyID::kMarkerEnd,
    CSSPropertyID::kMarkerMid,
    CSSPropertyID::kMarkerStart,
    CSSPropertyID::kMaskClip,
    CSSPropertyID::kMaskComposite,
    CSSPropertyID::kMaskImage,
    CSSPropertyID::kMaskMode,
    CSSPropertyID::kMaskOrigin,
    CSSPropertyID::kMaskPosition,
    CSSPropertyID::kMaskRepeat,
    CSSPropertyID::kMaskSize,
    CSSPropertyID::kMaskType,
    CSSPropertyID::kMathDepth,
    CSSPropertyID::kMathShift,
    CSSPropertyID::kMathStyle,
    CSSPropertyID::kMaxBlockSize,
    CSSPropertyID::kMaxHeight,
    CSSPropertyID::kMaxInlineSize,
    CSSPropertyID::kMaxLines,
    CSSPropertyID::kMaxWidth,
    CSSPropertyID::kMinBlockSize,
    CSSPropertyID::kMinHeight,
    CSSPropertyID::kMinInlineSize,
    CSSPropertyID::kMinWidth,
    CSSPropertyID::kMixBlendMode,
    CSSPropertyID::kObjectFit,
    CSSPropertyID::kObjectPosition,
    CSSPropertyID::kObjectViewBox,
    CSSPropertyID::kOffsetAnchor,
    CSSPropertyID::kOffsetDistance,
    CSSPropertyID::kOffsetPath,
    CSSPropertyID::kOffsetPosition,
    CSSPropertyID::kOffsetRotate,
    CSSPropertyID::kOpacity,
    CSSPropertyID::kOrder,
    CSSPropertyID::kOrphans,
    CSSPropertyID::kOutlineColor,
    CSSPropertyID::kOutlineOffset,
    CSSPropertyID::kOutlineStyle,
    CSSPropertyID::kOutlineWidth,
    CSSPropertyID::kOverflowAnchor,
    CSSPropertyID::kOverflowBlock,
    CSSPropertyID::kOverflowClipMargin,
    CSSPropertyID::kOverflowInline,
    CSSPropertyID::kOverflowWrap,
    CSSPropertyID::kOverflowX,
    CSSPropertyID::kOverflowY,
    CSSPropertyID::kOverlay,
    CSSPropertyID::kOverscrollArea,
    CSSPropertyID::kOverscrollBehaviorBlock,
    CSSPropertyID::kOverscrollBehaviorInline,
    CSSPropertyID::kOverscrollPosition,
    CSSPropertyID::kPaddingBlockEnd,
    CSSPropertyID::kPaddingBlockStart,
    CSSPropertyID::kPaddingBottom,
    CSSPropertyID::kPaddingInlineEnd,
    CSSPropertyID::kPaddingInlineStart,
    CSSPropertyID::kPaddingLeft,
    CSSPropertyID::kPaddingRight,
    CSSPropertyID::kPaddingTop,
    CSSPropertyID::kPaintOrder,
    CSSPropertyID::kPerspective,
    CSSPropertyID::kPerspectiveOrigin,
    CSSPropertyID::kPointerEvents,
    CSSPropertyID::kPosition,
    CSSPropertyID::kPositionAnchor,
    CSSPropertyID::kPositionArea,
    CSSPropertyID::kPositionTryFallbacks,
    CSSPropertyID::kPositionTryOrder,
    CSSPropertyID::kPositionVisibility,
    CSSPropertyID::kPrintColorAdjust,
    CSSPropertyID::kR,
    CSSPropertyID::kReadingFlow,
    CSSPropertyID::kReadingOrder,
    CSSPropertyID::kResize,
    CSSPropertyID::kRight,
    CSSPropertyID::kRotate,
    CSSPropertyID::kRowGap,
    CSSPropertyID::kRowRuleBreak,
    CSSPropertyID::kRowRuleColor,
    CSSPropertyID::kRowRuleEdgeEndInset,
    CSSPropertyID::kRowRuleEdgeStartInset,
    CSSPropertyID::kRowRuleInteriorEndInset,
    CSSPropertyID::kRowRuleInteriorStartInset,
    CSSPropertyID::kRowRuleStyle,
    CSSPropertyID::kRowRuleVisibilityItems,
    CSSPropertyID::kRowRuleWidth,
    CSSPropertyID::kRubyAlign,
    CSSPropertyID::kRubyOverhang,
    CSSPropertyID::kRubyPosition,
    CSSPropertyID::kRx,
    CSSPropertyID::kRy,
    CSSPropertyID::kScale,
    CSSPropertyID::kScrollBehavior,
    CSSPropertyID::kScrollInitialTarget,
    CSSPropertyID::kScrollMarginBlockEnd,
    CSSPropertyID::kScrollMarginBlockStart,
    CSSPropertyID::kScrollMarginInlineEnd,
    CSSPropertyID::kScrollMarginInlineStart,
    CSSPropertyID::kScrollMarkerGroup,
    CSSPropertyID::kScrollPaddingBlockEnd,
    CSSPropertyID::kScrollPaddingBlockStart,
    CSSPropertyID::kScrollPaddingInlineEnd,
    CSSPropertyID::kScrollPaddingInlineStart,
    CSSPropertyID::kScrollTargetGroup,
    CSSPropertyID::kScrollTimelineAxis,
    CSSPropertyID::kScrollTimelineName,
    CSSPropertyID::kScrollbarColor,
    CSSPropertyID::kScrollbarGutter,
    CSSPropertyID::kScrollbarWidth,
    CSSPropertyID::kShapeImageThreshold,
    CSSPropertyID::kShapeMargin,
    CSSPropertyID::kShapeOutside,
    CSSPropertyID::kShapeRendering,
    CSSPropertyID::kSpeak,
    CSSPropertyID::kStopColor,
    CSSPropertyID::kStopOpacity,
    CSSPropertyID::kStroke,
    CSSPropertyID::kStrokeDasharray,
    CSSPropertyID::kStrokeDashoffset,
    CSSPropertyID::kStrokeLinecap,
    CSSPropertyID::kStrokeLinejoin,
    CSSPropertyID::kStrokeMiterlimit,
    CSSPropertyID::kStrokeOpacity,
    CSSPropertyID::kStrokeWidth,
    CSSPropertyID::kTabSize,
    CSSPropertyID::kTableLayout,
    CSSPropertyID::kTextAlign,
    CSSPropertyID::kTextAlignLast,
    CSSPropertyID::kTextAnchor,
    CSSPropertyID::kTextAutospace,
    CSSPropertyID::kTextBoxEdge,
    CSSPropertyID::kTextBoxTrim,
    CSSPropertyID::kTextDecoration,
    CSSPropertyID::kTextDecorationColor,
    CSSPropertyID::kTextDecorationLine,
    CSSPropertyID::kTextDecorationSkipInk,
    CSSPropertyID::kTextDecorationStyle,
    CSSPropertyID::kTextEmphasisColor,
    CSSPropertyID::kTextEmphasisPosition,
    CSSPropertyID::kTextEmphasisStyle,
    CSSPropertyID::kTextGrow,
    CSSPropertyID::kTextIndent,
    CSSPropertyID::kTextJustify,
    CSSPropertyID::kTextOverflow,
    CSSPropertyID::kTextRendering,
    CSSPropertyID::kTextShadow,
    CSSPropertyID::kTextShrink,
    CSSPropertyID::kTextSizeAdjust,
    CSSPropertyID::kTextSpacingTrim,
    CSSPropertyID::kTextTransform,
    CSSPropertyID::kTextUnderlinePosition,
    CSSPropertyID::kTextWrapMode,
    CSSPropertyID::kTextWrapStyle,
    CSSPropertyID::kTimelineScope,
    CSSPropertyID::kTimelineTriggerExitRangeEnd,
    CSSPropertyID::kTimelineTriggerExitRangeStart,
    CSSPropertyID::kTimelineTriggerName,
    CSSPropertyID::kTimelineTriggerRangeEnd,
    CSSPropertyID::kTimelineTriggerRangeStart,
    CSSPropertyID::kTimelineTriggerSource,
    CSSPropertyID::kTop,
    CSSPropertyID::kTouchAction,
    CSSPropertyID::kTransform,
    CSSPropertyID::kTransformOrigin,
    CSSPropertyID::kTransformStyle,
    CSSPropertyID::kTransitionBehavior,
    CSSPropertyID::kTransitionDelay,
    CSSPropertyID::kTransitionDuration,
    CSSPropertyID::kTransitionProperty,
    CSSPropertyID::kTransitionTimingFunction,
    CSSPropertyID::kTranslate,
    CSSPropertyID::kUnicodeBidi,
    CSSPropertyID::kUserSelect,
    CSSPropertyID::kVectorEffect,
    CSSPropertyID::kVerticalAlign,
    CSSPropertyID::kViewTimelineAxis,
    CSSPropertyID::kViewTimelineInset,
    CSSPropertyID::kViewTimelineName,
    CSSPropertyID::kViewTransitionClass,
    CSSPropertyID::kViewTransitionGroup,
    CSSPropertyID::kViewTransitionName,
    CSSPropertyID::kVisibility,
    CSSPropertyID::kWhiteSpaceCollapse,
    CSSPropertyID::kWidows,
    CSSPropertyID::kWidth,
    CSSPropertyID::kWillChange,
    CSSPropertyID::kWordBreak,
    CSSPropertyID::kWordSpacing,
    CSSPropertyID::kWritingMode,
    CSSPropertyID::kX,
    CSSPropertyID::kY,
    CSSPropertyID::kZIndex,
    CSSPropertyID::kZoom,
    CSSPropertyID::kWebkitBorderHorizontalSpacing,
    CSSPropertyID::kWebkitBorderImage,
    CSSPropertyID::kWebkitBorderVerticalSpacing,
    CSSPropertyID::kWebkitBoxAlign,
    CSSPropertyID::kWebkitBoxDecorationBreak,
    CSSPropertyID::kWebkitBoxDirection,
    CSSPropertyID::kWebkitBoxFlex,
    CSSPropertyID::kWebkitBoxOrdinalGroup,
    CSSPropertyID::kWebkitBoxOrient,
    CSSPropertyID::kWebkitBoxPack,
    CSSPropertyID::kWebkitBoxReflect,
    CSSPropertyID::kWebkitFontSmoothing,
    CSSPropertyID::kWebkitLineBreak,
    CSSPropertyID::kWebkitLineClamp,
    CSSPropertyID::kWebkitLocale,
    CSSPropertyID::kWebkitMaskBoxImage,
    CSSPropertyID::kWebkitMaskBoxImageOutset,
    CSSPropertyID::kWebkitMaskBoxImageRepeat,
    CSSPropertyID::kWebkitMaskBoxImageSlice,
    CSSPropertyID::kWebkitMaskBoxImageSource,
    CSSPropertyID::kWebkitMaskBoxImageWidth,
    CSSPropertyID::kWebkitRtlOrdering,
    CSSPropertyID::kWebkitTapHighlightColor,
    CSSPropertyID::kWebkitTextCombine,
    CSSPropertyID::kWebkitTextDecorationsInEffect,
    CSSPropertyID::kWebkitTextFillColor,
    CSSPropertyID::kWebkitTextOrientation,
    CSSPropertyID::kWebkitTextSecurity,
    CSSPropertyID::kWebkitTextStrokeColor,
    CSSPropertyID::kWebkitTextStrokeWidth,
    CSSPropertyID::kWebkitUserDrag,
    CSSPropertyID::kWebkitUserModify,
    CSSPropertyID::kWebkitWritingMode,
};

inline constexpr CSSPropertyID kCSSIncludesCurrentColorProperties[] = {
      CSSPropertyID::kMaskImage,
    CSSPropertyID::kAccentColor,
    CSSPropertyID::kBackdropFilter,
    CSSPropertyID::kBackgroundColor,
    CSSPropertyID::kBackgroundImage,
    CSSPropertyID::kBorderBottomColor,
    CSSPropertyID::kBorderImageSource,
    CSSPropertyID::kBorderLeftColor,
    CSSPropertyID::kBorderRightColor,
    CSSPropertyID::kBorderTopColor,
    CSSPropertyID::kBoxShadow,
    CSSPropertyID::kCaretColor,
    CSSPropertyID::kColumnRuleColor,
    CSSPropertyID::kFill,
    CSSPropertyID::kFilter,
    CSSPropertyID::kFloodColor,
    CSSPropertyID::kLightingColor,
    CSSPropertyID::kListStyleImage,
    CSSPropertyID::kOutlineColor,
    CSSPropertyID::kRowRuleColor,
    CSSPropertyID::kStopColor,
    CSSPropertyID::kStroke,
    CSSPropertyID::kTextDecorationColor,
    CSSPropertyID::kTextEmphasisColor,
    CSSPropertyID::kTextShadow,
    CSSPropertyID::kWebkitBoxReflect,
    CSSPropertyID::kWebkitMaskBoxImageSource,
    CSSPropertyID::kWebkitTapHighlightColor,
    CSSPropertyID::kWebkitTextStrokeColor,
};

// The lowest CSSPropertyID excluding kInvalid and kVariable.
const int kIntFirstCSSProperty = 2;
const CSSPropertyID kFirstCSSProperty =
    static_cast<CSSPropertyID>(kIntFirstCSSProperty);

// The number of unresolved CSS properties excluding kInvalid and kVariable.
const int kNumCSSProperties = 771;

// The highest resolved CSSPropertyID.
const int kIntLastCSSProperty = 653;
const CSSPropertyID kLastCSSProperty =
    static_cast<CSSPropertyID>(kIntLastCSSProperty);

// The highest unresolved CSSPropertyID.
const CSSPropertyID kLastUnresolvedCSSProperty =
    static_cast<CSSPropertyID>(772);

const CSSPropertyID kFirstHighPriorityCSSProperty = kFirstCSSProperty;
const CSSPropertyID kLastHighPriorityCSSProperty = CSSPropertyID::kZoom;

// 1 + <The highest unresolved CSSPropertyID>.
const int kNumCSSPropertyIDs = static_cast<int>(kLastUnresolvedCSSProperty) + 1;

const size_t kMaxCSSPropertyNameLength = 48;
constexpr size_t kCSSPropertyIDBitLength = 10;
constexpr size_t kMaxShorthandExpansion = 19;

static_assert((static_cast<size_t>(1) << kCSSPropertyIDBitLength) >
                  static_cast<size_t>(kLastUnresolvedCSSProperty),
              "kCSSPropertyIDBitLength has enough bits");

// These are basically just change-detector tests, so that we do not
// accidentally add new high-priority properties or break the code generator.
static_assert(CSSPropertyID::kColorScheme == kFirstHighPriorityCSSProperty);
static_assert(CSSPropertyID::kZoom == kLastHighPriorityCSSProperty);
static_assert((static_cast<int>(kLastHighPriorityCSSProperty) -
               static_cast<int>(kFirstHighPriorityCSSProperty)) == 42,
              "There should a low number of high-priority properties");

inline int GetCSSPropertyIDIndex(CSSPropertyID id) {
    DCHECK_GE(id, kFirstCSSProperty);
    DCHECK_LE(id, kLastCSSProperty);
    return static_cast<int>(id) - kIntFirstCSSProperty;
}

constexpr bool IsHighPriority(CSSPropertyID id) {
  return id >= kFirstHighPriorityCSSProperty &&
      id <= kLastHighPriorityCSSProperty;
}

inline bool IsCSSPropertyIDWithName(CSSPropertyID id)
{
    return id >= kFirstCSSProperty && id <= kLastUnresolvedCSSProperty;
}

inline bool IsValidCSSPropertyID(CSSPropertyID id)
{
    return id != CSSPropertyID::kInvalid;
}

inline CSSPropertyID ConvertToCSSPropertyID(int value)
{
    DCHECK_GE(value, static_cast<int>(CSSPropertyID::kInvalid));
    DCHECK_LE(value, kIntLastCSSProperty);
    return static_cast<CSSPropertyID>(value);
}

int CORE_EXPORT ResolveCSSPropertyAlias(int value);

inline bool IsPropertyAlias(CSSPropertyID id) {
  return static_cast<int>(id) >= 654;
}

inline CSSPropertyID ResolveCSSPropertyID(CSSPropertyID id)
{
  int int_id = static_cast<int>(id);
  if (IsPropertyAlias(id))
    int_id = ResolveCSSPropertyAlias(int_id);
  return ConvertToCSSPropertyID(int_id);
}

CSSPropertyID CORE_EXPORT CssPropertyID(const ExecutionContext*,
                                        const String&);

class CSSPropertyIDList {
  STACK_ALLOCATED();

 public:
  class Iterator {
    STACK_ALLOCATED();
   public:
    Iterator(int id) : id_(id) {}
    CSSPropertyID operator*() const { return ConvertToCSSPropertyID(id_); }
    Iterator& operator++() {
      id_++;
      return *this;
    }
    bool operator!=(const Iterator& i) const { return id_ != i.id_; }

   private:
    int id_;
  };
  Iterator begin() const { return Iterator(kIntFirstCSSProperty); }
  Iterator end() const { return Iterator(kIntLastCSSProperty + 1); }
};

mojom::blink::CSSSampleId CORE_EXPORT GetCSSSampleId(CSSPropertyID id);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_
