// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_REFERENCE_SPACE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_REFERENCE_SPACE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRReferenceSpace;
class XRRigidTransform;

class MODULES_EXPORT XRReferenceSpaceEventInit : public EventInit {
  
  public:
static XRReferenceSpaceEventInit* Create() {
  return MakeGarbageCollected<XRReferenceSpaceEventInit>();
}
static XRReferenceSpaceEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRReferenceSpaceEventInit>(isolate);
}
static XRReferenceSpaceEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRReferenceSpaceEventInit();
explicit  XRReferenceSpaceEventInit(v8::Isolate* isolate);

bool hasReferenceSpace() const {
  return true;
}
XRReferenceSpace* referenceSpace() const {
  return member_reference_space_.Get();
}
void setReferenceSpace(XRReferenceSpace* value) {
  member_reference_space_ = value;
DCHECK(member_reference_space_);
}

bool hasTransform() const {
  return has_transform_;
}
XRRigidTransform* transform() const {
  DCHECK(hasTransform());
return member_transform_.Get();
}
XRRigidTransform* getTransformOr(XRRigidTransform* fallback_value) const {
  if (!hasTransform()) {
  return fallback_value;
}
return member_transform_.Get();
}
void setTransform(XRRigidTransform* value) {
  member_transform_ = value;
has_transform_ = true;
DCHECK(member_transform_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_transform_ = false;

Member<XRReferenceSpace> member_reference_space_;
Member<XRRigidTransform> member_transform_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_REFERENCE_SPACE_EVENT_INIT_H_
