// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_INPUT_SOURCE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_INPUT_SOURCE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRFrame;
class XRInputSource;

class MODULES_EXPORT XRInputSourceEventInit : public EventInit {
  
  public:
static XRInputSourceEventInit* Create() {
  return MakeGarbageCollected<XRInputSourceEventInit>();
}
static XRInputSourceEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRInputSourceEventInit>(isolate);
}
static XRInputSourceEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRInputSourceEventInit();
explicit  XRInputSourceEventInit(v8::Isolate* isolate);

bool hasFrame() const {
  return true;
}
XRFrame* frame() const {
  return member_frame_.Get();
}
void setFrame(XRFrame* value) {
  member_frame_ = value;
DCHECK(member_frame_);
}

bool hasInputSource() const {
  return true;
}
XRInputSource* inputSource() const {
  return member_input_source_.Get();
}
void setInputSource(XRInputSource* value) {
  member_input_source_ = value;
DCHECK(member_input_source_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<XRFrame> member_frame_;
Member<XRInputSource> member_input_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_INPUT_SOURCE_EVENT_INIT_H_
