// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_DEPTH_STATE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_DEPTH_STATE_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_depth_data_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_depth_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_depth_usage.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT XRDepthStateInit : public bindings::InputDictionaryBase {
  
  public:
static XRDepthStateInit* Create() {
  return MakeGarbageCollected<XRDepthStateInit>();
}
static XRDepthStateInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRDepthStateInit>(isolate);
}
static XRDepthStateInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRDepthStateInit();
explicit  XRDepthStateInit(v8::Isolate* isolate);

bool hasDataFormatPreference() const {
  return true;
}
const Vector<V8XRDepthDataFormat>& dataFormatPreference() const {
  return member_data_format_preference_;
}
void setDataFormatPreference(const Vector<V8XRDepthDataFormat>& value);
void setDataFormatPreference(Vector<V8XRDepthDataFormat>&& value);

bool hasDepthTypeRequest() const {
  return has_depth_type_request_;
}
const Vector<V8XRDepthType>& depthTypeRequest() const {
  DCHECK(hasDepthTypeRequest());
return member_depth_type_request_;
}
Vector<V8XRDepthType> getDepthTypeRequestOr(const Vector<V8XRDepthType>& fallback_value) const;
Vector<V8XRDepthType> getDepthTypeRequestOr(Vector<V8XRDepthType>&& fallback_value) const;
void setDepthTypeRequest(const Vector<V8XRDepthType>& value);
void setDepthTypeRequest(Vector<V8XRDepthType>&& value);

bool hasMatchDepthView() const {
  return has_match_depth_view_;
}
bool matchDepthView() const {
  DCHECK(hasMatchDepthView());
return member_match_depth_view_;
}
bool getMatchDepthViewOr(bool fallback_value) const {
  if (!hasMatchDepthView()) {
  return fallback_value;
}
return member_match_depth_view_;
}
void setMatchDepthView(bool value) {
  member_match_depth_view_ = value;
has_match_depth_view_ = true;
}

bool hasUsagePreference() const {
  return true;
}
const Vector<V8XRDepthUsage>& usagePreference() const {
  return member_usage_preference_;
}
void setUsagePreference(const Vector<V8XRDepthUsage>& value);
void setUsagePreference(Vector<V8XRDepthUsage>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_type_request_ = false;
bool has_match_depth_view_ = false;

Vector<V8XRDepthDataFormat> member_data_format_preference_;
Vector<V8XRDepthType> member_depth_type_request_;
bool member_match_depth_view_;
Vector<V8XRDepthUsage> member_usage_preference_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_DEPTH_STATE_INIT_H_
