// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_write_params.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_blob_usvstring.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"data",
"position",
"size",
"type",
};


}  // namespace 

WriteParams* WriteParams::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WriteParams* dictionary = MakeGarbageCollected<WriteParams>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WriteParams";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WriteParams::WriteParams() {
  
}

 WriteParams::WriteParams(v8::Isolate* isolate) {
  
}




























void WriteParams::Trace(Visitor* visitor) const {
  visitor->Trace(member_data_);
bindings::DictionaryBase::Trace(visitor);
}

void WriteParams::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void WriteParams::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasData()) {
  values[0] = ToV8Traits<IDLNullable<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>>::ToV8(script_state, member_data_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasPosition()) {
  values[1] = ToV8Traits<IDLNullable<IDLUnsignedLongLong>>::ToV8(script_state, member_position_);
DCHECK(!values[1].IsEmpty());
}
if (hasSize()) {
  values[2] = ToV8Traits<IDLNullable<IDLUnsignedLongLong>>::ToV8(script_state, member_size_);
DCHECK(!values[2].IsEmpty());
}
if (hasType()) {
  values[3] = ToV8Traits<V8WriteCommandType>::ToV8(script_state, member_type_);
DCHECK(!values[3].IsEmpty());
}
}

const void* WriteParams::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> WriteParams::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void WriteParams::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WriteParams";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("data");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_data_, member_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("position");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLUnsignedLongLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_position_, member_position_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("size");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLUnsignedLongLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_size_, member_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8WriteCommandType, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> WriteParams::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
