// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_worker_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_font_face_set.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_function.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_canvas_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_video_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_init.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_response.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scheduler.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_structured_serialize_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_svg_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_type_policy_factory.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_request_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_trustedscript.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_trustedscripturl_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_void_function.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_location.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_navigator.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cache_storage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_factory.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_blob_htmlcanvaselement_htmlimageelement_htmlvideoelement_imagebitmap_imagedata_offscreencanvas_svgimageelement_videoframe.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_manager.h"
#include "third_party/blink/renderer/core/css/font_face_set.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/fetch/global_fetch.h"
#include "third_party/blink/renderer/core/fetch/request.h"
#include "third_party/blink/renderer/core/fetch/response.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/canvas/html_canvas_element.h"
#include "third_party/blink/renderer/core/html/canvas/image_data.h"
#include "third_party/blink/renderer/core/html/html_image_element.h"
#include "third_party/blink/renderer/core/html/media/html_video_element.h"
#include "third_party/blink/renderer/core/imagebitmap/image_bitmap.h"
#include "third_party/blink/renderer/core/offscreencanvas/offscreen_canvas.h"
#include "third_party/blink/renderer/core/scheduler/dom_scheduler.h"
#include "third_party/blink/renderer/core/scheduler/dom_timer.h"
#include "third_party/blink/renderer/core/svg/svg_image_element.h"
#include "third_party/blink/renderer/core/timing/global_performance.h"
#include "third_party/blink/renderer/core/timing/performance.h"
#include "third_party/blink/renderer/core/trustedtypes/global_trusted_types.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_script.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_script_url.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_type_policy_factory.h"
#include "third_party/blink/renderer/core/workers/worker_global_scope.h"
#include "third_party/blink/renderer/core/workers/worker_location.h"
#include "third_party/blink/renderer/core/workers/worker_navigator.h"
#include "third_party/blink/renderer/modules/cache_storage/cache_storage.h"
#include "third_party/blink/renderer/modules/cache_storage/global_cache_storage.h"
#include "third_party/blink/renderer/modules/canvas/imagebitmap/image_bitmap_factories.h"
#include "third_party/blink/renderer/modules/crypto/crypto.h"
#include "third_party/blink/renderer/modules/crypto/global_crypto.h"
#include "third_party/blink/renderer/modules/indexeddb/global_indexed_db.h"
#include "third_party/blink/renderer/modules/indexeddb/idb_factory.h"
#include "third_party/blink/renderer/modules/printing/web_printing_manager.h"
#include "third_party/blink/renderer/modules/webcodecs/video_frame.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



void V8WorkerGlobalScope::Impl::Init() {
  V8WorkerGlobalScope::install_interface_template_func_ = InstallInterfaceTemplate;
V8WorkerGlobalScope::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8WorkerGlobalScope::install_context_independent_props_func_ = InstallContextIndependentProperties;
V8WorkerGlobalScope::install_context_dependent_props_func_ = InstallContextDependentProperties;
}

namespace  {

namespace v8_worker_global_scope {


void SelfAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_self_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.self.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->self();
static_assert(bindings::IsReturnTypeCompatible<WorkerGlobalScope, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LocationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_location_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.location.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->location();
static_assert(bindings::IsReturnTypeCompatible<WorkerLocation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void OnerrorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onerror_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onerror.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onerror();
static_assert(bindings::IsReturnTypeCompatible<IDLOnErrorEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnerrorAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onerror_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onerror.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kOnErrorEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnerror(event_handler);
}


void OnlanguagechangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onlanguagechange_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onlanguagechange.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onlanguagechange();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnlanguagechangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onlanguagechange_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onlanguagechange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnlanguagechange(event_handler);
}


void OntimezonechangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_ontimezonechange_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.ontimezonechange.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ontimezonechange();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OntimezonechangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_ontimezonechange_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.ontimezonechange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOntimezonechange(event_handler);
}


void NavigatorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_navigator_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.navigator.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->navigator();
static_assert(bindings::IsReturnTypeCompatible<WorkerNavigator, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void OnrejectionhandledAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onrejectionhandled_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onrejectionhandled.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onrejectionhandled();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnrejectionhandledAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onrejectionhandled_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onrejectionhandled.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnrejectionhandled(event_handler);
}


void OnunhandledrejectionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onunhandledrejection_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onunhandledrejection.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onunhandledrejection();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnunhandledrejectionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_onunhandledrejection_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.onunhandledrejection.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnunhandledrejection(event_handler);
}


void OriginAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_origin_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.origin.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->origin();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void OriginAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_origin_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.origin.set");

// [Replaceable]
bool did_create;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "origin";
v8::Local<v8::Value> v8_property_value = info[0];
if (!v8_receiver->CreateDataProperty(current_context, V8AtomicString(isolate, property_name), v8_property_value).To(&did_create)) {
  return;
}
}


void IsSecureContextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_isSecureContext_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.isSecureContext.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->isSecureContextForBindings(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void CrossOriginIsolatedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_crossOriginIsolated_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.crossOriginIsolated.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->crossOriginIsolated();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void CrossOriginEmbedderPolicyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_crossOriginEmbedderPolicy_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.crossOriginEmbedderPolicy.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->crossOriginEmbedderPolicy();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void SchedulerAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_scheduler_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.scheduler.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = DOMScheduler::scheduler(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<DOMScheduler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void SchedulerAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_scheduler_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.scheduler.set");

// [Replaceable]
bool did_create;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "scheduler";
v8::Local<v8::Value> v8_property_value = info[0];
if (!v8_receiver->CreateDataProperty(current_context, V8AtomicString(isolate, property_name), v8_property_value).To(&did_create)) {
  return;
}
}


void PerformanceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_performance_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.performance.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GlobalPerformance::performance(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Performance, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void PerformanceAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_performance_Setter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.performance.set");

// [Replaceable]
bool did_create;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "performance";
v8::Local<v8::Value> v8_property_value = info[0];
if (!v8_receiver->CreateDataProperty(current_context, V8AtomicString(isolate, property_name), v8_property_value).To(&did_create)) {
  return;
}
}


void TrustedTypesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_trustedTypes_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.trustedTypes.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GlobalTrustedTypes::trustedTypes(script_state, *blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<TrustedTypePolicyFactory, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void CachesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_caches_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.caches.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kGlobalCacheStorage);


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = GlobalCacheStorage::caches(*blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<CacheStorage, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void CryptoAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_crypto_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.crypto.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GlobalCrypto::crypto(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Crypto, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void IndexedDBAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_indexedDB_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.indexedDB.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GlobalIndexedDB::indexedDB(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDBFactory, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PrintingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_printing_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.printing.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = WebPrintingManager::GetWebPrintingManager(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<WebPrintingManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void FontsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_fonts_Getter");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.fonts.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDocumentFonts);


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->fonts();
static_assert(bindings::IsReturnTypeCompatible<FontFaceSet, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}


void AtobOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_atob");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.atob");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_atob = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->atob(arg1_atob, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void BtoaOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_btoa");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.btoa");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_btoa = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->btoa(arg1_btoa, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void ClearIntervalOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_clearInterval");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.clearInterval");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_handle{0};
if (!info[0]->IsUndefined()) {
  ExceptionState exception_state(isolate);
arg1_handle = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
DOMTimer::clearInterval(*blink_receiver, arg1_handle);

}

void ClearTimeoutOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_clearTimeout");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.clearTimeout");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_handle{0};
if (!info[0]->IsUndefined()) {
  ExceptionState exception_state(isolate);
arg1_handle = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
DOMTimer::clearTimeout(*blink_receiver, arg1_handle);

}

void CreateImageBitmapOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8WorkerGlobalScope::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "WorkerGlobalScope";
const char* const property_name = "createImageBitmap";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_image_bitmap = NativeValueTraits<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<ImageBitmapOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_options;
if (info[1]->IsUndefined()) {
  arg2_options = ImageBitmapOptions::Create();
} else {
  arg2_options = NativeValueTraits<ImageBitmapOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = ImageBitmapFactories::createImageBitmap(script_state, *blink_receiver, arg1_image_bitmap, arg2_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<ImageBitmap>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CreateImageBitmapOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8WorkerGlobalScope::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}


if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "WorkerGlobalScope";
const char* const property_name = "createImageBitmap";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_image_bitmap = NativeValueTraits<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sx = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_sy = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_sw = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_sh = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<ImageBitmapOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg6_options;
if (info[5]->IsUndefined()) {
  arg6_options = ImageBitmapOptions::Create();
} else {
  arg6_options = NativeValueTraits<ImageBitmapOptions>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = ImageBitmapFactories::createImageBitmap(script_state, *blink_receiver, arg1_image_bitmap, arg2_sx, arg3_sy, arg4_sw, arg5_sh, arg6_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<ImageBitmap>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CreateImageBitmapOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  // Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_createImageBitmap");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.createImageBitmap");


const int arg_count = std::min(info.Length(), 6);
if (arg_count == 6) {
  return CreateImageBitmapOperationOverload2(info);
}
if (arg_count == 5) {
  return CreateImageBitmapOperationOverload2(info);
}
if (arg_count == 2) {
  return CreateImageBitmapOperationOverload1(info);
}
if (arg_count == 1) {
  return CreateImageBitmapOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void FetchOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_fetch");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.fetch");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8WorkerGlobalScope::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "WorkerGlobalScope";
const char* const property_name = "fetch";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_input = NativeValueTraits<V8UnionRequestOrUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<RequestInit>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_init;
if (info[1]->IsUndefined()) {
  arg2_init = RequestInit::Create();
} else {
  arg2_init = NativeValueTraits<RequestInit>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = GlobalFetch::fetch(script_state, *blink_receiver, arg1_input, arg2_init, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<Response>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void ImportScriptsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_importScripts");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.importScripts");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_urls = bindings::VariadicArgumentsToNativeValues<V8UnionTrustedScriptURLOrUSVString>(isolate, info, 0, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->importScripts(arg1_urls, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void QueueMicrotaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_queueMicrotask");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.queueMicrotask");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<V8VoidFunction>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_callback;
if (info[0]->IsFunction()) [[likely]] {
  arg1_callback = V8VoidFunction::Create(info[0].As<v8::Function>());
} else {
  ExceptionState exception_state(isolate);
arg1_callback = NativeValueTraits<V8VoidFunction>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->queueMicrotask(arg1_callback);

}

void ReportErrorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_reportError");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.reportError");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_e = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->reportError(script_state, arg1_e);

}

void SetIntervalOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_handler = NativeValueTraits<V8Function>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_timeout{0};
if (!info[1]->IsUndefined()) {
  arg2_timeout = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& arg3_arguments = bindings::VariadicArgumentsToNativeValues<IDLAny>(isolate, info, 2, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = DOMTimer::setInterval(script_state, *blink_receiver, arg1_handler, arg2_timeout, arg3_arguments);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void SetIntervalOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_handler = NativeValueTraits<V8UnionStringOrTrustedScript>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_timeout{0};
if (!info[1]->IsUndefined()) {
  arg2_timeout = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& arg3_arguments = bindings::VariadicArgumentsToNativeValues<IDLAny>(isolate, info, 2, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = DOMTimer::setInterval(script_state, *blink_receiver, arg1_handler, arg2_timeout, arg3_arguments, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void SetIntervalOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_setInterval");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.setInterval");


const int arg_count = std::min(info.Length(), 3);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (arg_count == 3) {
  if (info[0]->IsObject()) {
  if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (V8TrustedScript::HasInstance(isolate, info[0])) {
  return SetIntervalOperationOverload2(info);
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (info[0]->IsFunction()) {
  return SetIntervalOperationOverload1(info);
}
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  return SetIntervalOperationOverload2(info);
}
break;
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (arg_count == 2) {
  if (info[0]->IsObject()) {
  if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (V8TrustedScript::HasInstance(isolate, info[0])) {
  return SetIntervalOperationOverload2(info);
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (info[0]->IsFunction()) {
  return SetIntervalOperationOverload1(info);
}
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  return SetIntervalOperationOverload2(info);
}
break;
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (arg_count == 1) {
  if (info[0]->IsObject()) {
  if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (V8TrustedScript::HasInstance(isolate, info[0])) {
  return SetIntervalOperationOverload2(info);
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (info[0]->IsFunction()) {
  return SetIntervalOperationOverload1(info);
}
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  return SetIntervalOperationOverload2(info);
}
break;
}
}
} while (false);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetTimeoutOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_handler = NativeValueTraits<V8Function>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_timeout{0};
if (!info[1]->IsUndefined()) {
  arg2_timeout = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& arg3_arguments = bindings::VariadicArgumentsToNativeValues<IDLAny>(isolate, info, 2, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = DOMTimer::setTimeout(script_state, *blink_receiver, arg1_handler, arg2_timeout, arg3_arguments);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void SetTimeoutOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_handler = NativeValueTraits<V8UnionStringOrTrustedScript>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_timeout{0};
if (!info[1]->IsUndefined()) {
  arg2_timeout = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& arg3_arguments = bindings::VariadicArgumentsToNativeValues<IDLAny>(isolate, info, 2, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = DOMTimer::setTimeout(script_state, *blink_receiver, arg1_handler, arg2_timeout, arg3_arguments, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void SetTimeoutOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_setTimeout");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.setTimeout");


const int arg_count = std::min(info.Length(), 3);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (arg_count == 3) {
  if (info[0]->IsObject()) {
  if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (V8TrustedScript::HasInstance(isolate, info[0])) {
  return SetTimeoutOperationOverload2(info);
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (info[0]->IsFunction()) {
  return SetTimeoutOperationOverload1(info);
}
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  return SetTimeoutOperationOverload2(info);
}
break;
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (arg_count == 2) {
  if (info[0]->IsObject()) {
  if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (V8TrustedScript::HasInstance(isolate, info[0])) {
  return SetTimeoutOperationOverload2(info);
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (info[0]->IsFunction()) {
  return SetTimeoutOperationOverload1(info);
}
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  return SetTimeoutOperationOverload2(info);
}
break;
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (arg_count == 1) {
  if (info[0]->IsObject()) {
  if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (V8TrustedScript::HasInstance(isolate, info[0])) {
  return SetTimeoutOperationOverload2(info);
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  if (info[0]->IsFunction()) {
  return SetTimeoutOperationOverload1(info);
}
}
}
if (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) {
  return SetTimeoutOperationOverload2(info);
}
break;
}
}
} while (false);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void StructuredCloneOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WorkerGlobalScope_structuredClone");
BLINK_BINDINGS_TRACE_EVENT("WorkerGlobalScope.structuredClone");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kStructuredCloneMethod);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WorkerGlobalScope* blink_receiver = V8WorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<StructuredSerializeOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_options;
if (info[1]->IsUndefined()) {
  arg2_options = StructuredSerializeOptions::Create();
} else {
  arg2_options = NativeValueTraits<StructuredSerializeOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->structuredClone(script_state, arg1_value, arg2_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_worker_global_scope

using namespace v8_worker_global_scope;

}  // namespace 

void V8WorkerGlobalScope::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WorkerGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global] - prototype object in the prototype chain of global objects
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WorkerGlobalScope::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"self", SelfAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"location", LocationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onerror", OnerrorAttributeGetCallback, OnerrorAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onlanguagechange", OnlanguagechangeAttributeGetCallback, OnlanguagechangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"navigator", NavigatorAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onrejectionhandled", OnrejectionhandledAttributeGetCallback, OnrejectionhandledAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onunhandledrejection", OnunhandledrejectionAttributeGetCallback, OnunhandledrejectionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"origin", OriginAttributeGetCallback, OriginAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"performance", PerformanceAttributeGetCallback, PerformanceAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"trustedTypes", TrustedTypesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"crypto", CryptoAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"indexedDB", IndexedDBAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"fonts", FontsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "WorkerGlobalScope", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"createImageBitmap", CreateImageBitmapOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"fetch", FetchOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"importScripts", ImportScriptsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WorkerGlobalScope", kOperationTable);
}



}

void V8WorkerGlobalScope::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

if (RuntimeEnabledFeatures::TimeZoneChangeEventEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ontimezonechange", OntimezonechangeAttributeGetCallback, OntimezonechangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "WorkerGlobalScope", kAttributeTable);
}






}

void V8WorkerGlobalScope::Impl::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

v8::Isolate* isolate = v8::Isolate::GetCurrent();
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"isSecureContext", IsSecureContextAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kAttributeTable);
}
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
if ((execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"crossOriginIsolated", CrossOriginIsolatedAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"scheduler", SchedulerAttributeGetCallback, SchedulerAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kAttributeTable);
}
if ((execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && (feature_selector.IsAll() && RuntimeEnabledFeatures::CoepReflectionEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"crossOriginEmbedderPolicy", CrossOriginEmbedderPolicyAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kAttributeTable);
}
const bool is_in_secure_context = execution_context->IsSecureContext();
if (is_in_secure_context && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"caches", CachesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kAttributeTable);
}
const bool is_in_isolated_context = execution_context->IsIsolatedContext();
if (is_in_isolated_context && is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebPrintingEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"printing", PrintingAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kAttributeTable);
}




if (feature_selector.IsAll()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"atob", AtobOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"btoa", BtoaOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"queueMicrotask", QueueMicrotaskOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"reportError", ReportErrorOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"structuredClone", StructuredCloneOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kOperationTable);
}
if ((execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && feature_selector.IsAll()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clearInterval", ClearIntervalOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"clearTimeout", ClearTimeoutOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setInterval", SetIntervalOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setTimeout", SetTimeoutOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "WorkerGlobalScope", kOperationTable);
}


}


}  // namespace blink
