// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBSOCKET_CLOSE_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBSOCKET_CLOSE_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebSocketCloseInfo : public bindings::DictionaryBase {
  
  public:
static WebSocketCloseInfo* Create() {
  return MakeGarbageCollected<WebSocketCloseInfo>();
}
static WebSocketCloseInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebSocketCloseInfo>(isolate);
}
static WebSocketCloseInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebSocketCloseInfo();
explicit  WebSocketCloseInfo(v8::Isolate* isolate);

bool hasCloseCode() const {
  return has_close_code_;
}
uint16_t closeCode() const {
  DCHECK(hasCloseCode());
return member_close_code_;
}
uint16_t getCloseCodeOr(uint16_t fallback_value) const {
  if (!hasCloseCode()) {
  return fallback_value;
}
return member_close_code_;
}
void setCloseCode(uint16_t value) {
  member_close_code_ = value;
has_close_code_ = true;
}

bool hasReason() const {
  return true;
}
const String& reason() const {
  return member_reason_;
}
void setReason(const String& value);
void setReason(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_close_code_ = false;

uint16_t member_close_code_;
String member_reason_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBSOCKET_CLOSE_INFO_H_
