// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader_pixel_local_storage.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_texture.h"
#include "third_party/blink/renderer/modules/webgl/webgl_shader_pixel_local_storage.h"
#include "third_party/blink/renderer/modules/webgl/webgl_texture.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8WebGLShaderPixelLocalStorage::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLShaderPixelLocalStorage::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLShaderPixelLocalStorage::InstallInterfaceTemplate,
    V8WebGLShaderPixelLocalStorage::InstallContextDependentProperties,
    "WebGLShaderPixelLocalStorage",
    nullptr,
    V8WebGLShaderPixelLocalStorage::kThisTag,
    V8WebGLShaderPixelLocalStorage::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLShaderPixelLocalStorage::wrapper_type_info_ =
    V8WebGLShaderPixelLocalStorage::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WebGLShaderPixelLocalStorage>::value,
    "WebGLShaderPixelLocalStorage inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_shader_pixel_local_storage {

void BeginPixelLocalStorageWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_beginPixelLocalStorageWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.beginPixelLocalStorageWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_loadops = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->beginPixelLocalStorageWEBGL(std::move(arg1_loadops));

}

void EndPixelLocalStorageWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_endPixelLocalStorageWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.endPixelLocalStorageWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_storeops = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->endPixelLocalStorageWEBGL(std::move(arg1_storeops));

}

void FramebufferPixelLocalClearValuefvWEBGLOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->framebufferPixelLocalClearValuefvWEBGL(arg1_plane, arg2_value, arg3_src_offset);

}

void FramebufferPixelLocalClearValuefvWEBGLOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<IDLSequence<IDLUnrestrictedFloat>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->framebufferPixelLocalClearValuefvWEBGL(arg1_plane, std::move(arg2_value), arg3_src_offset);

}

void FramebufferPixelLocalClearValuefvWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_framebufferPixelLocalClearValuefvWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.framebufferPixelLocalClearValuefvWEBGL");


const int arg_count = std::min(info.Length(), 3);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 3) {
  if (info[1]->IsObject()) {
  if (info[1]->IsFloat32Array()) {
  return FramebufferPixelLocalClearValuefvWEBGLOperationOverload1(info);
}
ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return FramebufferPixelLocalClearValuefvWEBGLOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
break;
}
if (arg_count == 2) {
  if (info[1]->IsObject()) {
  if (info[1]->IsFloat32Array()) {
  return FramebufferPixelLocalClearValuefvWEBGLOperationOverload1(info);
}
ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return FramebufferPixelLocalClearValuefvWEBGLOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
break;
}
} while (false);

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void FramebufferPixelLocalClearValueivWEBGLOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->framebufferPixelLocalClearValueivWEBGL(arg1_plane, arg2_value, arg3_src_offset);

}

void FramebufferPixelLocalClearValueivWEBGLOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<IDLSequence<IDLLong>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->framebufferPixelLocalClearValueivWEBGL(arg1_plane, std::move(arg2_value), arg3_src_offset);

}

void FramebufferPixelLocalClearValueivWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_framebufferPixelLocalClearValueivWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.framebufferPixelLocalClearValueivWEBGL");


const int arg_count = std::min(info.Length(), 3);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 3) {
  if (info[1]->IsObject()) {
  if (info[1]->IsInt32Array()) {
  return FramebufferPixelLocalClearValueivWEBGLOperationOverload1(info);
}
ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return FramebufferPixelLocalClearValueivWEBGLOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
break;
}
if (arg_count == 2) {
  if (info[1]->IsObject()) {
  if (info[1]->IsInt32Array()) {
  return FramebufferPixelLocalClearValueivWEBGLOperationOverload1(info);
}
ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return FramebufferPixelLocalClearValueivWEBGLOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
break;
}
} while (false);

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void FramebufferPixelLocalClearValueuivWEBGLOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->framebufferPixelLocalClearValueuivWEBGL(arg1_plane, arg2_value, arg3_src_offset);

}

void FramebufferPixelLocalClearValueuivWEBGLOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->framebufferPixelLocalClearValueuivWEBGL(arg1_plane, std::move(arg2_value), arg3_src_offset);

}

void FramebufferPixelLocalClearValueuivWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_framebufferPixelLocalClearValueuivWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.framebufferPixelLocalClearValueuivWEBGL");


const int arg_count = std::min(info.Length(), 3);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 3) {
  if (info[1]->IsObject()) {
  if (info[1]->IsUint32Array()) {
  return FramebufferPixelLocalClearValueuivWEBGLOperationOverload1(info);
}
ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return FramebufferPixelLocalClearValueuivWEBGLOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
break;
}
if (arg_count == 2) {
  if (info[1]->IsObject()) {
  if (info[1]->IsUint32Array()) {
  return FramebufferPixelLocalClearValueuivWEBGLOperationOverload1(info);
}
ExceptionState exception_state(isolate);
if (info[1]->IsArray() || bindings::IsEsIterableObject(isolate, info[1], exception_state)) {
  return FramebufferPixelLocalClearValueuivWEBGLOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
break;
}
} while (false);

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void FramebufferTexturePixelLocalStorageWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_framebufferTexturePixelLocalStorageWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.framebufferTexturePixelLocalStorageWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_layer = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->framebufferTexturePixelLocalStorageWEBGL(arg1_plane, arg2_texture, arg3_level, arg4_layer);

}

void GetFramebufferPixelLocalStorageParameterWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_getFramebufferPixelLocalStorageParameterWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.getFramebufferPixelLocalStorageParameterWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_plane = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getFramebufferPixelLocalStorageParameterWEBGL(script_state, arg1_plane, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void IsCoherentOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_isCoherent");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.isCoherent");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->isCoherent();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void PixelLocalStorageBarrierWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLShaderPixelLocalStorage_pixelLocalStorageBarrierWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLShaderPixelLocalStorage.pixelLocalStorageBarrierWEBGL");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLShaderPixelLocalStorage* blink_receiver = V8WebGLShaderPixelLocalStorage::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->pixelLocalStorageBarrierWEBGL();

}


}  // namespace v8_webgl_shader_pixel_local_storage

using namespace v8_webgl_shader_pixel_local_storage;

}  // namespace 

void V8WebGLShaderPixelLocalStorage::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLShaderPixelLocalStorage::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLShaderPixelLocalStorage::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;



v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"MAX_PIXEL_LOCAL_STORAGE_PLANES_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kMaxPixelLocalStoragePlanesWebgl},
{"MAX_COMBINED_DRAW_BUFFERS_AND_PIXEL_LOCAL_STORAGE_PLANES_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kMaxCombinedDrawBuffersAndPixelLocalStoragePlanesWebgl},
{"PIXEL_LOCAL_STORAGE_ACTIVE_PLANES_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalStorageActivePlanesWebgl},
{"LOAD_OP_ZERO_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kLoadOpZeroWebgl},
{"LOAD_OP_CLEAR_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kLoadOpClearWebgl},
{"LOAD_OP_LOAD_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kLoadOpLoadWebgl},
{"STORE_OP_STORE_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kStoreOpStoreWebgl},
{"PIXEL_LOCAL_FORMAT_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalFormatWebgl},
{"PIXEL_LOCAL_TEXTURE_NAME_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalTextureNameWebgl},
{"PIXEL_LOCAL_TEXTURE_LEVEL_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalTextureLevelWebgl},
{"PIXEL_LOCAL_TEXTURE_LAYER_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalTextureLayerWebgl},
{"PIXEL_LOCAL_CLEAR_VALUE_FLOAT_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalClearValueFloatWebgl},
{"PIXEL_LOCAL_CLEAR_VALUE_INT_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalClearValueIntWebgl},
{"PIXEL_LOCAL_CLEAR_VALUE_UNSIGNED_INT_WEBGL", V8WebGLShaderPixelLocalStorage::Constant::kPixelLocalClearValueUnsignedIntWebgl},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}



{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"beginPixelLocalStorageWEBGL", BeginPixelLocalStorageWEBGLOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"endPixelLocalStorageWEBGL", EndPixelLocalStorageWEBGLOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferPixelLocalClearValuefvWEBGL", FramebufferPixelLocalClearValuefvWEBGLOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferPixelLocalClearValueivWEBGL", FramebufferPixelLocalClearValueivWEBGLOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferPixelLocalClearValueuivWEBGL", FramebufferPixelLocalClearValueuivWEBGLOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferTexturePixelLocalStorageWEBGL", FramebufferTexturePixelLocalStorageWEBGLOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getFramebufferPixelLocalStorageParameterWEBGL", GetFramebufferPixelLocalStorageParameterWEBGLOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isCoherent", IsCoherentOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pixelLocalStorageBarrierWEBGL", PixelLocalStorageBarrierWEBGLOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLShaderPixelLocalStorage", kOperationTable);
}



}


void V8WebGLShaderPixelLocalStorage::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}


}  // namespace blink
