// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBGL_RENDERING_CONTEXT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBGL_RENDERING_CONTEXT_H_

#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/v8_interface_bridge.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {

class ExecutionContext;
class WebGLRenderingContext;
struct WrapperTypeInfo;

class MODULES_EXPORT V8WebGLRenderingContext final : public bindings::V8InterfaceBridge<V8WebGLRenderingContext, WebGLRenderingContext> {
  
  public:
// Constants
class Constant final {
  STATIC_ONLY(Constant);

  public:
static constexpr uint32_t kRgb8 = 0x8051;
static constexpr uint32_t kRgba8 = 0x8058;
static constexpr uint32_t kDepthBufferBit = 0x00000100;
static constexpr uint32_t kStencilBufferBit = 0x00000400;
static constexpr uint32_t kColorBufferBit = 0x00004000;
static constexpr uint32_t kPoints = 0x0000;
static constexpr uint32_t kLines = 0x0001;
static constexpr uint32_t kLineLoop = 0x0002;
static constexpr uint32_t kLineStrip = 0x0003;
static constexpr uint32_t kTriangles = 0x0004;
static constexpr uint32_t kTriangleStrip = 0x0005;
static constexpr uint32_t kTriangleFan = 0x0006;
static constexpr uint32_t kZero = 0;
static constexpr uint32_t kOne = 1;
static constexpr uint32_t kSrcColor = 0x0300;
static constexpr uint32_t kOneMinusSrcColor = 0x0301;
static constexpr uint32_t kSrcAlpha = 0x0302;
static constexpr uint32_t kOneMinusSrcAlpha = 0x0303;
static constexpr uint32_t kDstAlpha = 0x0304;
static constexpr uint32_t kOneMinusDstAlpha = 0x0305;
static constexpr uint32_t kDstColor = 0x0306;
static constexpr uint32_t kOneMinusDstColor = 0x0307;
static constexpr uint32_t kSrcAlphaSaturate = 0x0308;
static constexpr uint32_t kFuncAdd = 0x8006;
static constexpr uint32_t kBlendEquation = 0x8009;
static constexpr uint32_t kBlendEquationRgb = 0x8009;
static constexpr uint32_t kBlendEquationAlpha = 0x883D;
static constexpr uint32_t kFuncSubtract = 0x800A;
static constexpr uint32_t kFuncReverseSubtract = 0x800B;
static constexpr uint32_t kBlendDstRgb = 0x80C8;
static constexpr uint32_t kBlendSrcRgb = 0x80C9;
static constexpr uint32_t kBlendDstAlpha = 0x80CA;
static constexpr uint32_t kBlendSrcAlpha = 0x80CB;
static constexpr uint32_t kConstantColor = 0x8001;
static constexpr uint32_t kOneMinusConstantColor = 0x8002;
static constexpr uint32_t kConstantAlpha = 0x8003;
static constexpr uint32_t kOneMinusConstantAlpha = 0x8004;
static constexpr uint32_t kBlendColor = 0x8005;
static constexpr uint32_t kArrayBuffer = 0x8892;
static constexpr uint32_t kElementArrayBuffer = 0x8893;
static constexpr uint32_t kArrayBufferBinding = 0x8894;
static constexpr uint32_t kElementArrayBufferBinding = 0x8895;
static constexpr uint32_t kStreamDraw = 0x88E0;
static constexpr uint32_t kStaticDraw = 0x88E4;
static constexpr uint32_t kDynamicDraw = 0x88E8;
static constexpr uint32_t kBufferSize = 0x8764;
static constexpr uint32_t kBufferUsage = 0x8765;
static constexpr uint32_t kCurrentVertexAttrib = 0x8626;
static constexpr uint32_t kFront = 0x0404;
static constexpr uint32_t kBack = 0x0405;
static constexpr uint32_t kFrontAndBack = 0x0408;
static constexpr uint32_t kTexture2d = 0x0DE1;
static constexpr uint32_t kCullFace = 0x0B44;
static constexpr uint32_t kBlend = 0x0BE2;
static constexpr uint32_t kDither = 0x0BD0;
static constexpr uint32_t kStencilTest = 0x0B90;
static constexpr uint32_t kDepthTest = 0x0B71;
static constexpr uint32_t kScissorTest = 0x0C11;
static constexpr uint32_t kPolygonOffsetFill = 0x8037;
static constexpr uint32_t kSampleAlphaToCoverage = 0x809E;
static constexpr uint32_t kSampleCoverage = 0x80A0;
static constexpr uint32_t kNoError = 0;
static constexpr uint32_t kInvalidEnum = 0x0500;
static constexpr uint32_t kInvalidValue = 0x0501;
static constexpr uint32_t kInvalidOperation = 0x0502;
static constexpr uint32_t kOutOfMemory = 0x0505;
static constexpr uint32_t kCw = 0x0900;
static constexpr uint32_t kCcw = 0x0901;
static constexpr uint32_t kLineWidth = 0x0B21;
static constexpr uint32_t kAliasedPointSizeRange = 0x846D;
static constexpr uint32_t kAliasedLineWidthRange = 0x846E;
static constexpr uint32_t kCullFaceMode = 0x0B45;
static constexpr uint32_t kFrontFace = 0x0B46;
static constexpr uint32_t kDepthRange = 0x0B70;
static constexpr uint32_t kDepthWritemask = 0x0B72;
static constexpr uint32_t kDepthClearValue = 0x0B73;
static constexpr uint32_t kDepthFunc = 0x0B74;
static constexpr uint32_t kStencilClearValue = 0x0B91;
static constexpr uint32_t kStencilFunc = 0x0B92;
static constexpr uint32_t kStencilFail = 0x0B94;
static constexpr uint32_t kStencilPassDepthFail = 0x0B95;
static constexpr uint32_t kStencilPassDepthPass = 0x0B96;
static constexpr uint32_t kStencilRef = 0x0B97;
static constexpr uint32_t kStencilValueMask = 0x0B93;
static constexpr uint32_t kStencilWritemask = 0x0B98;
static constexpr uint32_t kStencilBackFunc = 0x8800;
static constexpr uint32_t kStencilBackFail = 0x8801;
static constexpr uint32_t kStencilBackPassDepthFail = 0x8802;
static constexpr uint32_t kStencilBackPassDepthPass = 0x8803;
static constexpr uint32_t kStencilBackRef = 0x8CA3;
static constexpr uint32_t kStencilBackValueMask = 0x8CA4;
static constexpr uint32_t kStencilBackWritemask = 0x8CA5;
static constexpr uint32_t kViewport = 0x0BA2;
static constexpr uint32_t kScissorBox = 0x0C10;
static constexpr uint32_t kColorClearValue = 0x0C22;
static constexpr uint32_t kColorWritemask = 0x0C23;
static constexpr uint32_t kUnpackAlignment = 0x0CF5;
static constexpr uint32_t kPackAlignment = 0x0D05;
static constexpr uint32_t kMaxTextureSize = 0x0D33;
static constexpr uint32_t kMaxViewportDims = 0x0D3A;
static constexpr uint32_t kSubpixelBits = 0x0D50;
static constexpr uint32_t kRedBits = 0x0D52;
static constexpr uint32_t kGreenBits = 0x0D53;
static constexpr uint32_t kBlueBits = 0x0D54;
static constexpr uint32_t kAlphaBits = 0x0D55;
static constexpr uint32_t kDepthBits = 0x0D56;
static constexpr uint32_t kStencilBits = 0x0D57;
static constexpr uint32_t kPolygonOffsetUnits = 0x2A00;
static constexpr uint32_t kPolygonOffsetFactor = 0x8038;
static constexpr uint32_t kTextureBinding2d = 0x8069;
static constexpr uint32_t kSampleBuffers = 0x80A8;
static constexpr uint32_t kSamples = 0x80A9;
static constexpr uint32_t kSampleCoverageValue = 0x80AA;
static constexpr uint32_t kSampleCoverageInvert = 0x80AB;
static constexpr uint32_t kCompressedTextureFormats = 0x86A3;
static constexpr uint32_t kDontCare = 0x1100;
static constexpr uint32_t kFastest = 0x1101;
static constexpr uint32_t kNicest = 0x1102;
static constexpr uint32_t kGenerateMipmapHint = 0x8192;
static constexpr uint32_t kByte = 0x1400;
static constexpr uint32_t kUnsignedByte = 0x1401;
static constexpr uint32_t kShort = 0x1402;
static constexpr uint32_t kUnsignedShort = 0x1403;
static constexpr uint32_t kInt = 0x1404;
static constexpr uint32_t kUnsignedInt = 0x1405;
static constexpr uint32_t kFloat = 0x1406;
static constexpr uint32_t kDepthComponent = 0x1902;
static constexpr uint32_t kAlpha = 0x1906;
static constexpr uint32_t kRgb = 0x1907;
static constexpr uint32_t kRgba = 0x1908;
static constexpr uint32_t kLuminance = 0x1909;
static constexpr uint32_t kLuminanceAlpha = 0x190A;
static constexpr uint32_t kUnsignedShort4444 = 0x8033;
static constexpr uint32_t kUnsignedShort5551 = 0x8034;
static constexpr uint32_t kUnsignedShort565 = 0x8363;
static constexpr uint32_t kFragmentShader = 0x8B30;
static constexpr uint32_t kVertexShader = 0x8B31;
static constexpr uint32_t kMaxVertexAttribs = 0x8869;
static constexpr uint32_t kMaxVertexUniformVectors = 0x8DFB;
static constexpr uint32_t kMaxVaryingVectors = 0x8DFC;
static constexpr uint32_t kMaxCombinedTextureImageUnits = 0x8B4D;
static constexpr uint32_t kMaxVertexTextureImageUnits = 0x8B4C;
static constexpr uint32_t kMaxTextureImageUnits = 0x8872;
static constexpr uint32_t kMaxFragmentUniformVectors = 0x8DFD;
static constexpr uint32_t kShaderType = 0x8B4F;
static constexpr uint32_t kDeleteStatus = 0x8B80;
static constexpr uint32_t kLinkStatus = 0x8B82;
static constexpr uint32_t kValidateStatus = 0x8B83;
static constexpr uint32_t kAttachedShaders = 0x8B85;
static constexpr uint32_t kActiveUniforms = 0x8B86;
static constexpr uint32_t kActiveAttributes = 0x8B89;
static constexpr uint32_t kShadingLanguageVersion = 0x8B8C;
static constexpr uint32_t kCurrentProgram = 0x8B8D;
static constexpr uint32_t kNever = 0x0200;
static constexpr uint32_t kLess = 0x0201;
static constexpr uint32_t kEqual = 0x0202;
static constexpr uint32_t kLequal = 0x0203;
static constexpr uint32_t kGreater = 0x0204;
static constexpr uint32_t kNotequal = 0x0205;
static constexpr uint32_t kGequal = 0x0206;
static constexpr uint32_t kAlways = 0x0207;
static constexpr uint32_t kKeep = 0x1E00;
static constexpr uint32_t kReplace = 0x1E01;
static constexpr uint32_t kIncr = 0x1E02;
static constexpr uint32_t kDecr = 0x1E03;
static constexpr uint32_t kInvert = 0x150A;
static constexpr uint32_t kIncrWrap = 0x8507;
static constexpr uint32_t kDecrWrap = 0x8508;
static constexpr uint32_t kVendor = 0x1F00;
static constexpr uint32_t kRenderer = 0x1F01;
static constexpr uint32_t kVersion = 0x1F02;
static constexpr uint32_t kNearest = 0x2600;
static constexpr uint32_t kLinear = 0x2601;
static constexpr uint32_t kNearestMipmapNearest = 0x2700;
static constexpr uint32_t kLinearMipmapNearest = 0x2701;
static constexpr uint32_t kNearestMipmapLinear = 0x2702;
static constexpr uint32_t kLinearMipmapLinear = 0x2703;
static constexpr uint32_t kTextureMagFilter = 0x2800;
static constexpr uint32_t kTextureMinFilter = 0x2801;
static constexpr uint32_t kTextureWrapS = 0x2802;
static constexpr uint32_t kTextureWrapT = 0x2803;
static constexpr uint32_t kTexture = 0x1702;
static constexpr uint32_t kTextureCubeMap = 0x8513;
static constexpr uint32_t kTextureBindingCubeMap = 0x8514;
static constexpr uint32_t kTextureCubeMapPositiveX = 0x8515;
static constexpr uint32_t kTextureCubeMapNegativeX = 0x8516;
static constexpr uint32_t kTextureCubeMapPositiveY = 0x8517;
static constexpr uint32_t kTextureCubeMapNegativeY = 0x8518;
static constexpr uint32_t kTextureCubeMapPositiveZ = 0x8519;
static constexpr uint32_t kTextureCubeMapNegativeZ = 0x851A;
static constexpr uint32_t kMaxCubeMapTextureSize = 0x851C;
static constexpr uint32_t kTexture0 = 0x84C0;
static constexpr uint32_t kTexture1 = 0x84C1;
static constexpr uint32_t kTexture2 = 0x84C2;
static constexpr uint32_t kTexture3 = 0x84C3;
static constexpr uint32_t kTexture4 = 0x84C4;
static constexpr uint32_t kTexture5 = 0x84C5;
static constexpr uint32_t kTexture6 = 0x84C6;
static constexpr uint32_t kTexture7 = 0x84C7;
static constexpr uint32_t kTexture8 = 0x84C8;
static constexpr uint32_t kTexture9 = 0x84C9;
static constexpr uint32_t kTexture10 = 0x84CA;
static constexpr uint32_t kTexture11 = 0x84CB;
static constexpr uint32_t kTexture12 = 0x84CC;
static constexpr uint32_t kTexture13 = 0x84CD;
static constexpr uint32_t kTexture14 = 0x84CE;
static constexpr uint32_t kTexture15 = 0x84CF;
static constexpr uint32_t kTexture16 = 0x84D0;
static constexpr uint32_t kTexture17 = 0x84D1;
static constexpr uint32_t kTexture18 = 0x84D2;
static constexpr uint32_t kTexture19 = 0x84D3;
static constexpr uint32_t kTexture20 = 0x84D4;
static constexpr uint32_t kTexture21 = 0x84D5;
static constexpr uint32_t kTexture22 = 0x84D6;
static constexpr uint32_t kTexture23 = 0x84D7;
static constexpr uint32_t kTexture24 = 0x84D8;
static constexpr uint32_t kTexture25 = 0x84D9;
static constexpr uint32_t kTexture26 = 0x84DA;
static constexpr uint32_t kTexture27 = 0x84DB;
static constexpr uint32_t kTexture28 = 0x84DC;
static constexpr uint32_t kTexture29 = 0x84DD;
static constexpr uint32_t kTexture30 = 0x84DE;
static constexpr uint32_t kTexture31 = 0x84DF;
static constexpr uint32_t kActiveTexture = 0x84E0;
static constexpr uint32_t kRepeat = 0x2901;
static constexpr uint32_t kClampToEdge = 0x812F;
static constexpr uint32_t kMirroredRepeat = 0x8370;
static constexpr uint32_t kFloatVec2 = 0x8B50;
static constexpr uint32_t kFloatVec3 = 0x8B51;
static constexpr uint32_t kFloatVec4 = 0x8B52;
static constexpr uint32_t kIntVec2 = 0x8B53;
static constexpr uint32_t kIntVec3 = 0x8B54;
static constexpr uint32_t kIntVec4 = 0x8B55;
static constexpr uint32_t kBool = 0x8B56;
static constexpr uint32_t kBoolVec2 = 0x8B57;
static constexpr uint32_t kBoolVec3 = 0x8B58;
static constexpr uint32_t kBoolVec4 = 0x8B59;
static constexpr uint32_t kFloatMat2 = 0x8B5A;
static constexpr uint32_t kFloatMat3 = 0x8B5B;
static constexpr uint32_t kFloatMat4 = 0x8B5C;
static constexpr uint32_t kSampler2d = 0x8B5E;
static constexpr uint32_t kSamplerCube = 0x8B60;
static constexpr uint32_t kVertexAttribArrayEnabled = 0x8622;
static constexpr uint32_t kVertexAttribArraySize = 0x8623;
static constexpr uint32_t kVertexAttribArrayStride = 0x8624;
static constexpr uint32_t kVertexAttribArrayType = 0x8625;
static constexpr uint32_t kVertexAttribArrayNormalized = 0x886A;
static constexpr uint32_t kVertexAttribArrayPointer = 0x8645;
static constexpr uint32_t kVertexAttribArrayBufferBinding = 0x889F;
static constexpr uint32_t kImplementationColorReadType = 0x8B9A;
static constexpr uint32_t kImplementationColorReadFormat = 0x8B9B;
static constexpr uint32_t kCompileStatus = 0x8B81;
static constexpr uint32_t kLowFloat = 0x8DF0;
static constexpr uint32_t kMediumFloat = 0x8DF1;
static constexpr uint32_t kHighFloat = 0x8DF2;
static constexpr uint32_t kLowInt = 0x8DF3;
static constexpr uint32_t kMediumInt = 0x8DF4;
static constexpr uint32_t kHighInt = 0x8DF5;
static constexpr uint32_t kFramebuffer = 0x8D40;
static constexpr uint32_t kRenderbuffer = 0x8D41;
static constexpr uint32_t kRgba4 = 0x8056;
static constexpr uint32_t kRgb5A1 = 0x8057;
static constexpr uint32_t kRgb565 = 0x8D62;
static constexpr uint32_t kDepthComponent16 = 0x81A5;
static constexpr uint32_t kStencilIndex8 = 0x8D48;
static constexpr uint32_t kDepthStencil = 0x84F9;
static constexpr uint32_t kRenderbufferWidth = 0x8D42;
static constexpr uint32_t kRenderbufferHeight = 0x8D43;
static constexpr uint32_t kRenderbufferInternalFormat = 0x8D44;
static constexpr uint32_t kRenderbufferRedSize = 0x8D50;
static constexpr uint32_t kRenderbufferGreenSize = 0x8D51;
static constexpr uint32_t kRenderbufferBlueSize = 0x8D52;
static constexpr uint32_t kRenderbufferAlphaSize = 0x8D53;
static constexpr uint32_t kRenderbufferDepthSize = 0x8D54;
static constexpr uint32_t kRenderbufferStencilSize = 0x8D55;
static constexpr uint32_t kFramebufferAttachmentObjectType = 0x8CD0;
static constexpr uint32_t kFramebufferAttachmentObjectName = 0x8CD1;
static constexpr uint32_t kFramebufferAttachmentTextureLevel = 0x8CD2;
static constexpr uint32_t kFramebufferAttachmentTextureCubeMapFace = 0x8CD3;
static constexpr uint32_t kColorAttachment0 = 0x8CE0;
static constexpr uint32_t kDepthAttachment = 0x8D00;
static constexpr uint32_t kStencilAttachment = 0x8D20;
static constexpr uint32_t kDepthStencilAttachment = 0x821A;
static constexpr uint32_t kNone = 0;
static constexpr uint32_t kFramebufferComplete = 0x8CD5;
static constexpr uint32_t kFramebufferIncompleteAttachment = 0x8CD6;
static constexpr uint32_t kFramebufferIncompleteMissingAttachment = 0x8CD7;
static constexpr uint32_t kFramebufferIncompleteDimensions = 0x8CD9;
static constexpr uint32_t kFramebufferUnsupported = 0x8CDD;
static constexpr uint32_t kFramebufferBinding = 0x8CA6;
static constexpr uint32_t kRenderbufferBinding = 0x8CA7;
static constexpr uint32_t kMaxRenderbufferSize = 0x84E8;
static constexpr uint32_t kInvalidFramebufferOperation = 0x0506;
static constexpr uint32_t kUnpackFlipYWebgl = 0x9240;
static constexpr uint32_t kUnpackPremultiplyAlphaWebgl = 0x9241;
static constexpr uint32_t kContextLostWebgl = 0x9242;
static constexpr uint32_t kUnpackColorspaceConversionWebgl = 0x9243;
static constexpr uint32_t kBrowserDefaultWebgl = 0x9244;

  
  
  
};

static bool IsExposed(ExecutionContext* execution_context);

static constexpr const WrapperTypeInfo* GetWrapperTypeInfo() {
  return &wrapper_type_info_;
}
  static_assert(1345 <
                 blink::kLastGeneratedScriptWrappableTag,
                 "There are more ScriptWrappable types than available type tags."
                 "You have to increase the kLastScirptWrappableTag in wrapper_type_info.h");
  static constexpr v8::CppHeapPointerTag kThisTag =
      static_cast<v8::CppHeapPointerTag>(1345);
  static constexpr v8::CppHeapPointerTag kMaxSubclassTag =
      static_cast<v8::CppHeapPointerTag>(1345);
  static constexpr v8::CppHeapPointerTagRange kTagRange =
      v8::CppHeapPointerTagRange(kThisTag, kMaxSubclassTag);


static void InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template);
static void InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template);
static void InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template);
static void InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector);


  
  private:
static const WrapperTypeInfo wrapper_type_info_;


  friend class WebGLRenderingContext;
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBGL_RENDERING_CONTEXT_H_
