// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_multi_draw.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/modules/webgl/webgl_multi_draw.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8WebGLMultiDraw::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLMultiDraw::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLMultiDraw::InstallInterfaceTemplate,
    V8WebGLMultiDraw::InstallContextDependentProperties,
    "WebGLMultiDraw",
    nullptr,
    V8WebGLMultiDraw::kThisTag,
    V8WebGLMultiDraw::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLMultiDraw::wrapper_type_info_ =
    V8WebGLMultiDraw::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WebGLMultiDraw>::value,
    "WebGLMultiDraw inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_multi_draw {

void MultiDrawArraysInstancedWEBGLOperationNoAllocDirectCallArg8(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, v8::Local<v8::Value> v8_arg2_firsts_list, uint32_t v8_arg3_firsts_offset, v8::Local<v8::Value> v8_arg4_counts_list, uint32_t v8_arg5_counts_offset, v8::Local<v8::Value> v8_arg6_instance_counts_list, uint32_t v8_arg7_instance_counts_offset, int32_t v8_arg8_drawcount, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
ExceptionState exception_state(isolate);
auto&& arg2_firsts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_firsts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_firsts_offset = v8_arg3_firsts_offset;
auto&& arg4_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 3, v8_arg4_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_counts_offset = v8_arg5_counts_offset;
auto&& arg6_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 5, v8_arg6_instance_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_instance_counts_offset = v8_arg7_instance_counts_offset;
auto&& arg8_drawcount = v8_arg8_drawcount;
blink_receiver->multiDrawArraysInstancedWEBGL(arg1_mode, arg2_firsts_list, arg3_firsts_offset, arg4_counts_list, arg5_counts_offset, arg6_instance_counts_list, arg7_instance_counts_offset, arg8_drawcount);
}

void MultiDrawArraysInstancedWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLMultiDraw_multiDrawArraysInstancedWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLMultiDraw.multiDrawArraysInstancedWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_firsts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_firsts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_instance_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_drawcount = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->multiDrawArraysInstancedWEBGL(arg1_mode, arg2_firsts_list, arg3_firsts_offset, arg4_counts_list, arg5_counts_offset, arg6_instance_counts_list, arg7_instance_counts_offset, arg8_drawcount);

}

void MultiDrawArraysWEBGLOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, v8::Local<v8::Value> v8_arg2_firsts_list, uint32_t v8_arg3_firsts_offset, v8::Local<v8::Value> v8_arg4_counts_list, uint32_t v8_arg5_counts_offset, int32_t v8_arg6_drawcount, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
ExceptionState exception_state(isolate);
auto&& arg2_firsts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_firsts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_firsts_offset = v8_arg3_firsts_offset;
auto&& arg4_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 3, v8_arg4_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_counts_offset = v8_arg5_counts_offset;
auto&& arg6_drawcount = v8_arg6_drawcount;
blink_receiver->multiDrawArraysWEBGL(arg1_mode, arg2_firsts_list, arg3_firsts_offset, arg4_counts_list, arg5_counts_offset, arg6_drawcount);
}

void MultiDrawArraysWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLMultiDraw_multiDrawArraysWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLMultiDraw.multiDrawArraysWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_firsts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_firsts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_drawcount = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->multiDrawArraysWEBGL(arg1_mode, arg2_firsts_list, arg3_firsts_offset, arg4_counts_list, arg5_counts_offset, arg6_drawcount);

}

void MultiDrawElementsInstancedWEBGLOperationNoAllocDirectCallArg9(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, v8::Local<v8::Value> v8_arg2_counts_list, uint32_t v8_arg3_counts_offset, uint32_t v8_arg4_type, v8::Local<v8::Value> v8_arg5_offsets_list, uint32_t v8_arg6_offsets_offset, v8::Local<v8::Value> v8_arg7_instance_counts_list, uint32_t v8_arg8_instance_counts_offset, int32_t v8_arg9_drawcount, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
ExceptionState exception_state(isolate);
auto&& arg2_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_counts_offset = v8_arg3_counts_offset;
auto&& arg4_type = v8_arg4_type;
auto&& arg5_offsets_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 4, v8_arg5_offsets_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offsets_offset = v8_arg6_offsets_offset;
auto&& arg7_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 6, v8_arg7_instance_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_instance_counts_offset = v8_arg8_instance_counts_offset;
auto&& arg9_drawcount = v8_arg9_drawcount;
blink_receiver->multiDrawElementsInstancedWEBGL(arg1_mode, arg2_counts_list, arg3_counts_offset, arg4_type, arg5_offsets_list, arg6_offsets_offset, arg7_instance_counts_list, arg8_instance_counts_offset, arg9_drawcount);
}

void MultiDrawElementsInstancedWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLMultiDraw_multiDrawElementsInstancedWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLMultiDraw.multiDrawElementsInstancedWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_offsets_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offsets_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_instance_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_instance_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_drawcount = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->multiDrawElementsInstancedWEBGL(arg1_mode, arg2_counts_list, arg3_counts_offset, arg4_type, arg5_offsets_list, arg6_offsets_offset, arg7_instance_counts_list, arg8_instance_counts_offset, arg9_drawcount);

}

void MultiDrawElementsWEBGLOperationNoAllocDirectCallArg7(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, v8::Local<v8::Value> v8_arg2_counts_list, uint32_t v8_arg3_counts_offset, uint32_t v8_arg4_type, v8::Local<v8::Value> v8_arg5_offsets_list, uint32_t v8_arg6_offsets_offset, int32_t v8_arg7_drawcount, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
ExceptionState exception_state(isolate);
auto&& arg2_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_counts_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_counts_offset = v8_arg3_counts_offset;
auto&& arg4_type = v8_arg4_type;
auto&& arg5_offsets_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 4, v8_arg5_offsets_list, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offsets_offset = v8_arg6_offsets_offset;
auto&& arg7_drawcount = v8_arg7_drawcount;
blink_receiver->multiDrawElementsWEBGL(arg1_mode, arg2_counts_list, arg3_counts_offset, arg4_type, arg5_offsets_list, arg6_offsets_offset, arg7_drawcount);
}

void MultiDrawElementsWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLMultiDraw_multiDrawElementsWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLMultiDraw.multiDrawElementsWEBGL");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLMultiDraw* blink_receiver = V8WebGLMultiDraw::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_counts_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_counts_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_offsets_list = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offsets_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_drawcount = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->multiDrawElementsWEBGL(arg1_mode, arg2_counts_list, arg3_counts_offset, arg4_type, arg5_offsets_list, arg6_offsets_offset, arg7_drawcount);

}


}  // namespace v8_webgl_multi_draw

using namespace v8_webgl_multi_draw;

}  // namespace 

void V8WebGLMultiDraw::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLMultiDraw::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLMultiDraw::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;






{
  static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawArraysInstancedWEBGL[] = {
v8::CFunctionBuilder().Fn(MultiDrawArraysInstancedWEBGLOperationNoAllocDirectCallArg8).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawArraysWEBGL[] = {
v8::CFunctionBuilder().Fn(MultiDrawArraysWEBGLOperationNoAllocDirectCallArg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawElementsInstancedWEBGL[] = {
v8::CFunctionBuilder().Fn(MultiDrawElementsInstancedWEBGLOperationNoAllocDirectCallArg9).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMultiDrawElementsWEBGL[] = {
v8::CFunctionBuilder().Fn(MultiDrawElementsWEBGLOperationNoAllocDirectCallArg7).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"multiDrawArraysInstancedWEBGL", MultiDrawArraysInstancedWEBGLOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawArraysInstancedWEBGL, std::size(kNoAllocDirectCallOverloadsOfMultiDrawArraysInstancedWEBGL)}, 
{{"multiDrawArraysWEBGL", MultiDrawArraysWEBGLOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawArraysWEBGL, std::size(kNoAllocDirectCallOverloadsOfMultiDrawArraysWEBGL)}, 
{{"multiDrawElementsInstancedWEBGL", MultiDrawElementsInstancedWEBGLOperationCallback, 9, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawElementsInstancedWEBGL, std::size(kNoAllocDirectCallOverloadsOfMultiDrawElementsInstancedWEBGL)}, 
{{"multiDrawElementsWEBGL", MultiDrawElementsWEBGLOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMultiDrawElementsWEBGL, std::size(kNoAllocDirectCallOverloadsOfMultiDrawElementsWEBGL)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLMultiDraw", kOperationTable);
}


}


void V8WebGLMultiDraw::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}


}  // namespace blink
