// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_compressed_texture_astc.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/webgl/webgl_compressed_texture_astc.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8WebGLCompressedTextureASTC::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLCompressedTextureASTC::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLCompressedTextureASTC::InstallInterfaceTemplate,
    V8WebGLCompressedTextureASTC::InstallContextDependentProperties,
    "WebGLCompressedTextureASTC",
    nullptr,
    V8WebGLCompressedTextureASTC::kThisTag,
    V8WebGLCompressedTextureASTC::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLCompressedTextureASTC::wrapper_type_info_ =
    V8WebGLCompressedTextureASTC::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WebGLCompressedTextureASTC>::value,
    "WebGLCompressedTextureASTC inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_compressed_texture_astc {

void GetSupportedProfilesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLCompressedTextureASTC_getSupportedProfiles");
BLINK_BINDINGS_TRACE_EVENT("WebGLCompressedTextureASTC.getSupportedProfiles");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8WebGLCompressedTextureASTC_GetSupportedProfiles_Method);



v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGLCompressedTextureASTC* blink_receiver = V8WebGLCompressedTextureASTC::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getSupportedProfiles();
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}


}  // namespace v8_webgl_compressed_texture_astc

using namespace v8_webgl_compressed_texture_astc;

}  // namespace 

void V8WebGLCompressedTextureASTC::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLCompressedTextureASTC::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLCompressedTextureASTC::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;



v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"COMPRESSED_RGBA_ASTC_4x4_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc4X4Khr},
{"COMPRESSED_RGBA_ASTC_5x4_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc5X4Khr},
{"COMPRESSED_RGBA_ASTC_5x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc5X5Khr},
{"COMPRESSED_RGBA_ASTC_6x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc6X5Khr},
{"COMPRESSED_RGBA_ASTC_6x6_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc6X6Khr},
{"COMPRESSED_RGBA_ASTC_8x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc8X5Khr},
{"COMPRESSED_RGBA_ASTC_8x6_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc8X6Khr},
{"COMPRESSED_RGBA_ASTC_8x8_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc8X8Khr},
{"COMPRESSED_RGBA_ASTC_10x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc10X5Khr},
{"COMPRESSED_RGBA_ASTC_10x6_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc10X6Khr},
{"COMPRESSED_RGBA_ASTC_10x8_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc10X8Khr},
{"COMPRESSED_RGBA_ASTC_10x10_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc10X10Khr},
{"COMPRESSED_RGBA_ASTC_12x10_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc12X10Khr},
{"COMPRESSED_RGBA_ASTC_12x12_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedRgbaAstc12X12Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc4X4Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc5X4Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc5X5Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc6X5Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc6X6Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc8X5Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc8X6Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc8X8Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc10X5Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc10X6Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc10X8Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc10X10Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc12X10Khr},
{"COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR", V8WebGLCompressedTextureASTC::Constant::kCompressedSrgb8Alpha8Astc12X12Khr},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}



{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getSupportedProfiles", GetSupportedProfilesOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLCompressedTextureASTC", kOperationTable);
}



}


void V8WebGLCompressedTextureASTC::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}


}  // namespace blink
