// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_RESOLUTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_RESOLUTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_resolution_units.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebPrintingResolution : public bindings::DictionaryBase {
  
  public:
static WebPrintingResolution* Create() {
  return MakeGarbageCollected<WebPrintingResolution>();
}
static WebPrintingResolution* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrintingResolution>(isolate);
}
static WebPrintingResolution* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrintingResolution();
explicit  WebPrintingResolution(v8::Isolate* isolate);

bool hasCrossFeedDirectionResolution() const {
  return has_cross_feed_direction_resolution_;
}
uint32_t crossFeedDirectionResolution() const {
  DCHECK(hasCrossFeedDirectionResolution());
return member_cross_feed_direction_resolution_;
}
uint32_t getCrossFeedDirectionResolutionOr(uint32_t fallback_value) const {
  if (!hasCrossFeedDirectionResolution()) {
  return fallback_value;
}
return member_cross_feed_direction_resolution_;
}
void setCrossFeedDirectionResolution(uint32_t value) {
  member_cross_feed_direction_resolution_ = value;
has_cross_feed_direction_resolution_ = true;
}

bool hasFeedDirectionResolution() const {
  return has_feed_direction_resolution_;
}
uint32_t feedDirectionResolution() const {
  DCHECK(hasFeedDirectionResolution());
return member_feed_direction_resolution_;
}
uint32_t getFeedDirectionResolutionOr(uint32_t fallback_value) const {
  if (!hasFeedDirectionResolution()) {
  return fallback_value;
}
return member_feed_direction_resolution_;
}
void setFeedDirectionResolution(uint32_t value) {
  member_feed_direction_resolution_ = value;
has_feed_direction_resolution_ = true;
}

bool hasUnits() const {
  return has_units_;
}
V8WebPrintingResolutionUnits units() const {
  DCHECK(hasUnits());
return member_units_;
}
V8WebPrintingResolutionUnits getUnitsOr(V8WebPrintingResolutionUnits fallback_value) const {
  if (!hasUnits()) {
  return fallback_value;
}
return member_units_;
}
void setUnits(V8WebPrintingResolutionUnits value) {
  member_units_ = value;
has_units_ = true;
}
void setUnits(V8WebPrintingResolutionUnits::Enum value) {
  member_units_ = V8WebPrintingResolutionUnits(value);
has_units_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_cross_feed_direction_resolution_ = false;
bool has_feed_direction_resolution_ = false;
bool has_units_ = false;

uint32_t member_cross_feed_direction_resolution_;
uint32_t member_feed_direction_resolution_;
V8WebPrintingResolutionUnits member_units_{static_cast<V8WebPrintingResolutionUnits::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_RESOLUTION_H_
