// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTER_ATTRIBUTES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTER_ATTRIBUTES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_color_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_quality.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printer_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printer_state_reason.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_mime_media_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_multiple_document_handling.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_orientation_requested.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_sides.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class WebPrintingMediaCollection;
class WebPrintingRange;
class WebPrintingResolution;

class MODULES_EXPORT WebPrinterAttributes : public bindings::DictionaryBase {
  
  public:
static WebPrinterAttributes* Create() {
  return MakeGarbageCollected<WebPrinterAttributes>();
}
static WebPrinterAttributes* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrinterAttributes>(isolate);
}
static WebPrinterAttributes* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrinterAttributes();
explicit  WebPrinterAttributes(v8::Isolate* isolate);

bool hasCopiesDefault() const {
  return has_copies_default_;
}
uint32_t copiesDefault() const {
  DCHECK(hasCopiesDefault());
return member_copies_default_;
}
uint32_t getCopiesDefaultOr(uint32_t fallback_value) const {
  if (!hasCopiesDefault()) {
  return fallback_value;
}
return member_copies_default_;
}
void setCopiesDefault(uint32_t value) {
  member_copies_default_ = value;
has_copies_default_ = true;
}

bool hasCopiesSupported() const {
  return has_copies_supported_;
}
WebPrintingRange* copiesSupported() const {
  DCHECK(hasCopiesSupported());
return member_copies_supported_.Get();
}
WebPrintingRange* getCopiesSupportedOr(WebPrintingRange* fallback_value) const {
  if (!hasCopiesSupported()) {
  return fallback_value;
}
return member_copies_supported_.Get();
}
void setCopiesSupported(WebPrintingRange* value) {
  member_copies_supported_ = value;
has_copies_supported_ = true;
DCHECK(member_copies_supported_);
}

bool hasDocumentFormatDefault() const {
  return has_document_format_default_;
}
V8WebPrintingMimeMediaType documentFormatDefault() const {
  DCHECK(hasDocumentFormatDefault());
return member_document_format_default_;
}
V8WebPrintingMimeMediaType getDocumentFormatDefaultOr(V8WebPrintingMimeMediaType fallback_value) const {
  if (!hasDocumentFormatDefault()) {
  return fallback_value;
}
return member_document_format_default_;
}
void setDocumentFormatDefault(V8WebPrintingMimeMediaType value) {
  member_document_format_default_ = value;
has_document_format_default_ = true;
}
void setDocumentFormatDefault(V8WebPrintingMimeMediaType::Enum value) {
  member_document_format_default_ = V8WebPrintingMimeMediaType(value);
has_document_format_default_ = true;
}

bool hasDocumentFormatSupported() const {
  return has_document_format_supported_;
}
const Vector<V8WebPrintingMimeMediaType>& documentFormatSupported() const {
  DCHECK(hasDocumentFormatSupported());
return member_document_format_supported_;
}
Vector<V8WebPrintingMimeMediaType> getDocumentFormatSupportedOr(const Vector<V8WebPrintingMimeMediaType>& fallback_value) const;
Vector<V8WebPrintingMimeMediaType> getDocumentFormatSupportedOr(Vector<V8WebPrintingMimeMediaType>&& fallback_value) const;
void setDocumentFormatSupported(const Vector<V8WebPrintingMimeMediaType>& value);
void setDocumentFormatSupported(Vector<V8WebPrintingMimeMediaType>&& value);

bool hasMediaColDatabase() const {
  return has_media_col_database_;
}
const HeapVector<Member<WebPrintingMediaCollection>>& mediaColDatabase() const {
  DCHECK(hasMediaColDatabase());
return member_media_col_database_;
}
HeapVector<Member<WebPrintingMediaCollection>> getMediaColDatabaseOr(const HeapVector<Member<WebPrintingMediaCollection>>& fallback_value) const;
HeapVector<Member<WebPrintingMediaCollection>> getMediaColDatabaseOr(HeapVector<Member<WebPrintingMediaCollection>>&& fallback_value) const;
void setMediaColDatabase(const HeapVector<Member<WebPrintingMediaCollection>>& value);
void setMediaColDatabase(HeapVector<Member<WebPrintingMediaCollection>>&& value);

bool hasMediaColDefault() const {
  return has_media_col_default_;
}
WebPrintingMediaCollection* mediaColDefault() const {
  DCHECK(hasMediaColDefault());
return member_media_col_default_.Get();
}
WebPrintingMediaCollection* getMediaColDefaultOr(WebPrintingMediaCollection* fallback_value) const {
  if (!hasMediaColDefault()) {
  return fallback_value;
}
return member_media_col_default_.Get();
}
void setMediaColDefault(WebPrintingMediaCollection* value) {
  member_media_col_default_ = value;
has_media_col_default_ = true;
DCHECK(member_media_col_default_);
}

bool hasMediaSourceDefault() const {
  return has_media_source_default_;
}
const String& mediaSourceDefault() const {
  DCHECK(hasMediaSourceDefault());
return member_media_source_default_;
}
String getMediaSourceDefaultOr(const String& fallback_value) const;
String getMediaSourceDefaultOr(String&& fallback_value) const;
void setMediaSourceDefault(const String& value);
void setMediaSourceDefault(String&& value);

bool hasMediaSourceSupported() const {
  return has_media_source_supported_;
}
const Vector<String>& mediaSourceSupported() const {
  DCHECK(hasMediaSourceSupported());
return member_media_source_supported_;
}
Vector<String> getMediaSourceSupportedOr(const Vector<String>& fallback_value) const;
Vector<String> getMediaSourceSupportedOr(Vector<String>&& fallback_value) const;
void setMediaSourceSupported(const Vector<String>& value);
void setMediaSourceSupported(Vector<String>&& value);

bool hasMultipleDocumentHandlingDefault() const {
  return has_multiple_document_handling_default_;
}
V8WebPrintingMultipleDocumentHandling multipleDocumentHandlingDefault() const {
  DCHECK(hasMultipleDocumentHandlingDefault());
return member_multiple_document_handling_default_;
}
V8WebPrintingMultipleDocumentHandling getMultipleDocumentHandlingDefaultOr(V8WebPrintingMultipleDocumentHandling fallback_value) const {
  if (!hasMultipleDocumentHandlingDefault()) {
  return fallback_value;
}
return member_multiple_document_handling_default_;
}
void setMultipleDocumentHandlingDefault(V8WebPrintingMultipleDocumentHandling value) {
  member_multiple_document_handling_default_ = value;
has_multiple_document_handling_default_ = true;
}
void setMultipleDocumentHandlingDefault(V8WebPrintingMultipleDocumentHandling::Enum value) {
  member_multiple_document_handling_default_ = V8WebPrintingMultipleDocumentHandling(value);
has_multiple_document_handling_default_ = true;
}

bool hasMultipleDocumentHandlingSupported() const {
  return has_multiple_document_handling_supported_;
}
const Vector<V8WebPrintingMultipleDocumentHandling>& multipleDocumentHandlingSupported() const {
  DCHECK(hasMultipleDocumentHandlingSupported());
return member_multiple_document_handling_supported_;
}
Vector<V8WebPrintingMultipleDocumentHandling> getMultipleDocumentHandlingSupportedOr(const Vector<V8WebPrintingMultipleDocumentHandling>& fallback_value) const;
Vector<V8WebPrintingMultipleDocumentHandling> getMultipleDocumentHandlingSupportedOr(Vector<V8WebPrintingMultipleDocumentHandling>&& fallback_value) const;
void setMultipleDocumentHandlingSupported(const Vector<V8WebPrintingMultipleDocumentHandling>& value);
void setMultipleDocumentHandlingSupported(Vector<V8WebPrintingMultipleDocumentHandling>&& value);

bool hasOrientationRequestedDefault() const {
  return has_orientation_requested_default_;
}
V8WebPrintingOrientationRequested orientationRequestedDefault() const {
  DCHECK(hasOrientationRequestedDefault());
return member_orientation_requested_default_;
}
V8WebPrintingOrientationRequested getOrientationRequestedDefaultOr(V8WebPrintingOrientationRequested fallback_value) const {
  if (!hasOrientationRequestedDefault()) {
  return fallback_value;
}
return member_orientation_requested_default_;
}
void setOrientationRequestedDefault(V8WebPrintingOrientationRequested value) {
  member_orientation_requested_default_ = value;
has_orientation_requested_default_ = true;
}
void setOrientationRequestedDefault(V8WebPrintingOrientationRequested::Enum value) {
  member_orientation_requested_default_ = V8WebPrintingOrientationRequested(value);
has_orientation_requested_default_ = true;
}

bool hasOrientationRequestedSupported() const {
  return has_orientation_requested_supported_;
}
const Vector<V8WebPrintingOrientationRequested>& orientationRequestedSupported() const {
  DCHECK(hasOrientationRequestedSupported());
return member_orientation_requested_supported_;
}
Vector<V8WebPrintingOrientationRequested> getOrientationRequestedSupportedOr(const Vector<V8WebPrintingOrientationRequested>& fallback_value) const;
Vector<V8WebPrintingOrientationRequested> getOrientationRequestedSupportedOr(Vector<V8WebPrintingOrientationRequested>&& fallback_value) const;
void setOrientationRequestedSupported(const Vector<V8WebPrintingOrientationRequested>& value);
void setOrientationRequestedSupported(Vector<V8WebPrintingOrientationRequested>&& value);

bool hasPrintColorModeDefault() const {
  return has_print_color_mode_default_;
}
V8WebPrintColorMode printColorModeDefault() const {
  DCHECK(hasPrintColorModeDefault());
return member_print_color_mode_default_;
}
V8WebPrintColorMode getPrintColorModeDefaultOr(V8WebPrintColorMode fallback_value) const {
  if (!hasPrintColorModeDefault()) {
  return fallback_value;
}
return member_print_color_mode_default_;
}
void setPrintColorModeDefault(V8WebPrintColorMode value) {
  member_print_color_mode_default_ = value;
has_print_color_mode_default_ = true;
}
void setPrintColorModeDefault(V8WebPrintColorMode::Enum value) {
  member_print_color_mode_default_ = V8WebPrintColorMode(value);
has_print_color_mode_default_ = true;
}

bool hasPrintColorModeSupported() const {
  return has_print_color_mode_supported_;
}
const Vector<V8WebPrintColorMode>& printColorModeSupported() const {
  DCHECK(hasPrintColorModeSupported());
return member_print_color_mode_supported_;
}
Vector<V8WebPrintColorMode> getPrintColorModeSupportedOr(const Vector<V8WebPrintColorMode>& fallback_value) const;
Vector<V8WebPrintColorMode> getPrintColorModeSupportedOr(Vector<V8WebPrintColorMode>&& fallback_value) const;
void setPrintColorModeSupported(const Vector<V8WebPrintColorMode>& value);
void setPrintColorModeSupported(Vector<V8WebPrintColorMode>&& value);

bool hasPrintQualityDefault() const {
  return has_print_quality_default_;
}
V8WebPrintQuality printQualityDefault() const {
  DCHECK(hasPrintQualityDefault());
return member_print_quality_default_;
}
V8WebPrintQuality getPrintQualityDefaultOr(V8WebPrintQuality fallback_value) const {
  if (!hasPrintQualityDefault()) {
  return fallback_value;
}
return member_print_quality_default_;
}
void setPrintQualityDefault(V8WebPrintQuality value) {
  member_print_quality_default_ = value;
has_print_quality_default_ = true;
}
void setPrintQualityDefault(V8WebPrintQuality::Enum value) {
  member_print_quality_default_ = V8WebPrintQuality(value);
has_print_quality_default_ = true;
}

bool hasPrintQualitySupported() const {
  return has_print_quality_supported_;
}
const Vector<V8WebPrintQuality>& printQualitySupported() const {
  DCHECK(hasPrintQualitySupported());
return member_print_quality_supported_;
}
Vector<V8WebPrintQuality> getPrintQualitySupportedOr(const Vector<V8WebPrintQuality>& fallback_value) const;
Vector<V8WebPrintQuality> getPrintQualitySupportedOr(Vector<V8WebPrintQuality>&& fallback_value) const;
void setPrintQualitySupported(const Vector<V8WebPrintQuality>& value);
void setPrintQualitySupported(Vector<V8WebPrintQuality>&& value);

bool hasPrinterId() const {
  return has_printer_id_;
}
const String& printerId() const {
  DCHECK(hasPrinterId());
return member_printer_id_;
}
String getPrinterIdOr(const String& fallback_value) const;
String getPrinterIdOr(String&& fallback_value) const;
void setPrinterId(const String& value);
void setPrinterId(String&& value);

bool hasPrinterName() const {
  return has_printer_name_;
}
const String& printerName() const {
  DCHECK(hasPrinterName());
return member_printer_name_;
}
String getPrinterNameOr(const String& fallback_value) const;
String getPrinterNameOr(String&& fallback_value) const;
void setPrinterName(const String& value);
void setPrinterName(String&& value);

bool hasPrinterResolutionDefault() const {
  return has_printer_resolution_default_;
}
WebPrintingResolution* printerResolutionDefault() const {
  DCHECK(hasPrinterResolutionDefault());
return member_printer_resolution_default_.Get();
}
WebPrintingResolution* getPrinterResolutionDefaultOr(WebPrintingResolution* fallback_value) const {
  if (!hasPrinterResolutionDefault()) {
  return fallback_value;
}
return member_printer_resolution_default_.Get();
}
void setPrinterResolutionDefault(WebPrintingResolution* value) {
  member_printer_resolution_default_ = value;
has_printer_resolution_default_ = true;
DCHECK(member_printer_resolution_default_);
}

bool hasPrinterResolutionSupported() const {
  return has_printer_resolution_supported_;
}
const HeapVector<Member<WebPrintingResolution>>& printerResolutionSupported() const {
  DCHECK(hasPrinterResolutionSupported());
return member_printer_resolution_supported_;
}
HeapVector<Member<WebPrintingResolution>> getPrinterResolutionSupportedOr(const HeapVector<Member<WebPrintingResolution>>& fallback_value) const;
HeapVector<Member<WebPrintingResolution>> getPrinterResolutionSupportedOr(HeapVector<Member<WebPrintingResolution>>&& fallback_value) const;
void setPrinterResolutionSupported(const HeapVector<Member<WebPrintingResolution>>& value);
void setPrinterResolutionSupported(HeapVector<Member<WebPrintingResolution>>&& value);

bool hasPrinterState() const {
  return has_printer_state_;
}
V8WebPrinterState printerState() const {
  DCHECK(hasPrinterState());
return member_printer_state_;
}
V8WebPrinterState getPrinterStateOr(V8WebPrinterState fallback_value) const {
  if (!hasPrinterState()) {
  return fallback_value;
}
return member_printer_state_;
}
void setPrinterState(V8WebPrinterState value) {
  member_printer_state_ = value;
has_printer_state_ = true;
}
void setPrinterState(V8WebPrinterState::Enum value) {
  member_printer_state_ = V8WebPrinterState(value);
has_printer_state_ = true;
}

bool hasPrinterStateMessage() const {
  return has_printer_state_message_;
}
const String& printerStateMessage() const {
  DCHECK(hasPrinterStateMessage());
return member_printer_state_message_;
}
String getPrinterStateMessageOr(const String& fallback_value) const;
String getPrinterStateMessageOr(String&& fallback_value) const;
void setPrinterStateMessage(const String& value);
void setPrinterStateMessage(String&& value);

bool hasPrinterStateReasons() const {
  return has_printer_state_reasons_;
}
const Vector<V8WebPrinterStateReason>& printerStateReasons() const {
  DCHECK(hasPrinterStateReasons());
return member_printer_state_reasons_;
}
Vector<V8WebPrinterStateReason> getPrinterStateReasonsOr(const Vector<V8WebPrinterStateReason>& fallback_value) const;
Vector<V8WebPrinterStateReason> getPrinterStateReasonsOr(Vector<V8WebPrinterStateReason>&& fallback_value) const;
void setPrinterStateReasons(const Vector<V8WebPrinterStateReason>& value);
void setPrinterStateReasons(Vector<V8WebPrinterStateReason>&& value);

bool hasSidesDefault() const {
  return has_sides_default_;
}
V8WebPrintingSides sidesDefault() const {
  DCHECK(hasSidesDefault());
return member_sides_default_;
}
V8WebPrintingSides getSidesDefaultOr(V8WebPrintingSides fallback_value) const {
  if (!hasSidesDefault()) {
  return fallback_value;
}
return member_sides_default_;
}
void setSidesDefault(V8WebPrintingSides value) {
  member_sides_default_ = value;
has_sides_default_ = true;
}
void setSidesDefault(V8WebPrintingSides::Enum value) {
  member_sides_default_ = V8WebPrintingSides(value);
has_sides_default_ = true;
}

bool hasSidesSupported() const {
  return has_sides_supported_;
}
const Vector<V8WebPrintingSides>& sidesSupported() const {
  DCHECK(hasSidesSupported());
return member_sides_supported_;
}
Vector<V8WebPrintingSides> getSidesSupportedOr(const Vector<V8WebPrintingSides>& fallback_value) const;
Vector<V8WebPrintingSides> getSidesSupportedOr(Vector<V8WebPrintingSides>&& fallback_value) const;
void setSidesSupported(const Vector<V8WebPrintingSides>& value);
void setSidesSupported(Vector<V8WebPrintingSides>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 25;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_copies_default_ = false;
bool has_copies_supported_ = false;
bool has_document_format_default_ = false;
bool has_document_format_supported_ = false;
bool has_media_col_database_ = false;
bool has_media_col_default_ = false;
bool has_media_source_default_ = false;
bool has_media_source_supported_ = false;
bool has_multiple_document_handling_default_ = false;
bool has_multiple_document_handling_supported_ = false;
bool has_orientation_requested_default_ = false;
bool has_orientation_requested_supported_ = false;
bool has_print_color_mode_default_ = false;
bool has_print_color_mode_supported_ = false;
bool has_print_quality_default_ = false;
bool has_print_quality_supported_ = false;
bool has_printer_id_ = false;
bool has_printer_name_ = false;
bool has_printer_resolution_default_ = false;
bool has_printer_resolution_supported_ = false;
bool has_printer_state_ = false;
bool has_printer_state_message_ = false;
bool has_printer_state_reasons_ = false;
bool has_sides_default_ = false;
bool has_sides_supported_ = false;

uint32_t member_copies_default_;
Member<WebPrintingRange> member_copies_supported_;
V8WebPrintingMimeMediaType member_document_format_default_{static_cast<V8WebPrintingMimeMediaType::Enum>(0)};
Vector<V8WebPrintingMimeMediaType> member_document_format_supported_;
HeapVector<Member<WebPrintingMediaCollection>> member_media_col_database_;
Member<WebPrintingMediaCollection> member_media_col_default_;
String member_media_source_default_;
Vector<String> member_media_source_supported_;
V8WebPrintingMultipleDocumentHandling member_multiple_document_handling_default_{static_cast<V8WebPrintingMultipleDocumentHandling::Enum>(0)};
Vector<V8WebPrintingMultipleDocumentHandling> member_multiple_document_handling_supported_;
V8WebPrintingOrientationRequested member_orientation_requested_default_{static_cast<V8WebPrintingOrientationRequested::Enum>(0)};
Vector<V8WebPrintingOrientationRequested> member_orientation_requested_supported_;
V8WebPrintColorMode member_print_color_mode_default_{static_cast<V8WebPrintColorMode::Enum>(0)};
Vector<V8WebPrintColorMode> member_print_color_mode_supported_;
V8WebPrintQuality member_print_quality_default_{static_cast<V8WebPrintQuality::Enum>(0)};
Vector<V8WebPrintQuality> member_print_quality_supported_;
String member_printer_id_;
String member_printer_name_;
Member<WebPrintingResolution> member_printer_resolution_default_;
HeapVector<Member<WebPrintingResolution>> member_printer_resolution_supported_;
V8WebPrinterState member_printer_state_{static_cast<V8WebPrinterState::Enum>(0)};
String member_printer_state_message_;
Vector<V8WebPrinterStateReason> member_printer_state_reasons_;
V8WebPrintingSides member_sides_default_{static_cast<V8WebPrintingSides::Enum>(0)};
Vector<V8WebPrintingSides> member_sides_supported_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTER_ATTRIBUTES_H_
